#!/bin/sh

# TODO check if upgrade

# upgrade procedure(draft):
# .check if sda3 is mountable and upgrade file exists
# .backup user's configs
# .delete all files on root partition
# .extract new root fs
# .copy user's configs back to its position
#
# Any needed configuration format updating or new configs
# will be geenerated automatically by config generator.
UpgradeFile="SynoUpgrade.tar.gz"
UpgradeFileDot=".SynoUpgrade.tar.gz"
TarUpgradeFile="SynoUpgrade.tar"
TarUpgradeFileDot=".SynoUpgrade.tar"
SupportDualhead=`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`
SupportRAID=`/bin/get_key_value /etc/synoinfo.conf supportraid`
PLATFORM=`get_key_value /etc/synoinfo.conf unique | cut -d"_" -f2`
# executables
Umount="/bin/umount -f"
Mount="/bin/mount"
Cp="/bin/cp"
Rm="/bin/rm"
Mv="/bin/mv"
Tar="/bin/tar"
Mkdir="/bin/mkdir"
Fsck="/sbin/e2fsck -nq"
Cksum="/usr/syno/bin/synochecksum"

. /usr/syno/share/dsmupdate/dsmupdate.subr

RootMnt="/tmpRoot"
DataMnt="/tmpRoot"
if [ "$SupportRAID" = "yes" -o "$SupportDualhead" = "yes" ]; then
	DISKNODE="/dev/md"
	RootPartition="${DISKNODE}0"
	SwapPartition="${DISKNODE}1"
	DataPartition="${DISKNODE}0"
else
	DISKNODE="/dev/sda"
	RootPartition="${DISKNODE}1"
	SwapPartition="${DISKNODE}2"
	if [ -f $RootMnt/$TarUpgradeFile -o -f $RootMnt/$UpgradeFile ]; then
		DataPartition="${DISKNODE}1"
	else
		DataPartition="${DISKNODE}3"
		DataMnt="/tmpData"
	fi
fi

NOTIFY_ASSISTANT_INSTALL_VOL_CREATE="${RootMnt}/.assistant_install_create_vol"
IS_INSTALL_CREATE_VOL=0
PLATFORM=`get_key_value /etc.defaults/synoinfo.conf unique | cut -d"_" -f2`

if [ -f ${NOTIFY_ASSISTANT_INSTALL_VOL_CREATE} ]; then
	IS_INSTALL_CREATE_VOL=1
fi

#83941 remove unused workaround for 1-bay downgrade issue
if [ -f "${RootMnt}/.upgrade_vol" ]; then
	$Rm -f "${RootMnt}/.upgrade_vol"
fi

IsCleanlyUmounted() {
	if [ -z "$1" ]; then
		return 0
	fi
	if [ "${RootPartition}" != "$1" ]; then
		CleanlyUmounted=`${Fsck} $1 | grep "is cleanly umounted"`
		if [ -z "$CleanlyUmounted" ]; then
			return 0
		fi
	elif [ -f "${RootMnt}/.needquotacheck" ]; then
		rm -f ${RootMnt}/.needquotacheck
		echo "Found ${RootPartition}:/.needquotacheck, removed."
	fi
	return 1
}

# PrepareVersionFile RootMnt
PrepareVersionFile() {
	if [ -z "$1" -o ! -f $1/etc/VERSION ]; then
		return 0
	fi
	# Backup oldest VERSION
	if [ ! -f $1/.syno/dsminfo/VERSION.init ]; then
		$Mkdir -p $1/.syno/dsminfo
		$Cp -f $1/etc/VERSION $1/.syno/dsminfo/VERSION.init
	fi
	# Sync VERSION in /etc & /etc.defaults for DSM before 6.0
	$Cp -f $1/etc.defaults/VERSION $1/etc/VERSION
}

#
#
# ##########################################################
echo "Begin upgrade procedure"

IsCleanlyUmounted ${DataPartition}
IsClean=$?

if [ ${RootMnt} != ${DataMnt} ]; then
	${Mkdir} -p $DataMnt
	# mount data
	echo "Mount data partition"
	echo "$Mount $DataPartition $DataMnt"
	$Mount $DataPartition $DataMnt
	RetMount=$?
	if [ $RetMount -ne 0 ]; then
		# mount data failed
		echo "Mount data partition failed"
		exit 0
	fi
fi

# check flag and upgrade file
if [ -f $DataMnt/$TarUpgradeFile ]; then
	UpgradeFile=$TarUpgradeFile
	UpgradeFileDot=$TarUpgradeFileDot
fi

# For ds216p bios upgrade hang, we need
# to disable usb port and upgrade bios
# after reboot
BraswellBIOSUpgrade

if [ -f $DataMnt/$UpgradeFile ]; then
	# file exists. start upgrade
	echo "Found an upgrade file on data volume. Begin upgrade"

	if ! $Cksum "$DataMnt"; then
		echo "Checksum not matches. Skip untar system files."
		touch /.tarball_checksum_not_match
		exit 1
	fi
	echo "Checksum of system tarball verified."

	# rename upgrade patch first
	$Mv $DataMnt/$UpgradeFile $DataMnt/$UpgradeFileDot
	UPGRADE_FILE="$DataMnt/$UpgradeFileDot"

	## clean immutable bit to avoid upgrade failed
	chattr -R -i ${RootMnt}/ > /dev/null 2>&1

	# Modify update flow for #77126
	PrepareVersionFile ${RootMnt}
	BackupExtraConfig ${RootMnt}
	BackupConfig ${RootMnt} ${DataMnt}

	BKPDIR="${DataMnt}/.upd@te"
	BKPSUBDIR="${DataMnt}/.upd@te_sub"
	# B#69262 make sure /root is 700
	chmod 700 ${BKPDIR}/root

	# copy upgrade builtin packages
	if [ -d ${DataMnt}/SynoUpgradePackages ]; then
		$Mv ${DataMnt}/SynoUpgradePackages ${RootMnt}/.SynoUpgradePackages
	fi

	# copy upgrade manutil packages
	if [ -d ${DataMnt}/SynoManutilPackages ]; then
		$Mv ${DataMnt}/SynoManutilPackages ${RootMnt}/.SynoManutilPackages
	fi

	# copy upgrade indexdb
	if [ -f ${DataMnt}/SynoUpgradeIndexdb.txz ]; then
		$Mv ${DataMnt}/SynoUpgradeIndexdb.txz ${RootMnt}/.SynoUpgradeIndexdb.txz
	fi

	# copy upgrade synohdpack_img
	if [ -f ${DataMnt}/SynoUpgradeSynohdpackImg.txz ]; then
		$Mv ${DataMnt}/SynoUpgradeSynohdpackImg.txz ${RootMnt}/.SynoUpgradeSynohdpackImg.txz
	fi

	OLD_PATCH_DIR=$RootMnt/.old_patch_info
	$Rm -rf ${OLD_PATCH_DIR}
	${Mkdir} ${OLD_PATCH_DIR}
	$Cp $RootMnt/etc.defaults/VERSION ${OLD_PATCH_DIR}/VERSION
	$Cp $RootMnt/etc.defaults/synoinfo.conf ${OLD_PATCH_DIR}/synoinfo.conf
	$Cp -rf $RootMnt/.system_info ${OLD_PATCH_DIR}/

	# rm all files on root fs
	$Rm -rf $RootMnt/*
	# extract
	mkswap ${SwapPartition}
	swapon ${SwapPartition}
	echo "Untaring ${UPGRADE_FILE}..."
	$Tar xf $UPGRADE_FILE -C $RootMnt
	isFailToUntarSynoUpgrade=$?

	 if [ $isFailToUntarSynoUpgrade -ne 0 -a "synology_monaco_ds216play" == `/bin/get_key_value /etc.defaults/synoinfo.conf unique` ]; then
		# Workaround for DS216play to avoid for failing to untar SynoUpgrade.tar
		# see bug HW_DS216play_STM # 48
		maxUntarRetryCount=10
		untarRetryCount=0
		while [ $untarRetryCount -ne 5 ]; do
			echo "fail to untar. sleep 10 seconds and try again"
			sleep 10
			untarRetryCount=$(( $untarRetryCount +1 ))
			echo "Untaring ${UPGRADE_FILE}... retry=${untarRetryCount}/${maxUntarRetryCount}"
			$Tar xf $UPGRADE_FILE -C $RootMnt
			isFailToUntarSynoUpgrade=$?
			if [ $isFailToUntarSynoUpgrade -eq 0 ]; then
				break;
			fi
		done
	fi

	if [ $isFailToUntarSynoUpgrade -ne 0 ]; then
		# remove bad files
		$Rm -rf $RootMnt/*

		# remove upgrade tarball file
		$Rm -rf $UPGRADE_FILE

		# restore backed-up config files
		if [ ${RootPartition} = ${DataPartition} ]; then
			$Cp -alf ${BKPDIR}/* ${RootMnt}/
			$Cp -alf ${BKPSUBDIR}/* ${RootMnt}/
		else
			$Cp -a ${BKPDIR}/* ${RootMnt}/
			$Cp -a ${BKPSUBDIR}/* ${RootMnt}/
		fi
		# remove backup config files
		$Rm -rf ${BKPDIR}
		$Rm -rf ${BKPSUBDIR}

		# restore VERSION & synoinfo.conf
		${Mkdir} -p ${RootMnt}/etc.defaults
		$Cp -a ${OLD_PATCH_DIR}/VERSION ${RootMnt}/etc.defaults/VERSION
		$Cp -a ${OLD_PATCH_DIR}/synoinfo.conf ${RootMnt}/etc.defaults/synoinfo.conf

		swapoff ${SwapPartition}
		exit 2;
	fi

	swapoff ${SwapPartition}

	# remove upgrade tarball file
	$Rm -rf $UPGRADE_FILE

	# copy backed-up config files
	local SameDev="no"
	if [ ${RootPartition} = ${DataPartition} ]; then
		SameDev="yes"
	fi
	RestoreConfig ${RootMnt} ${DataMnt} ${SameDev}

	# modify unique in disk synoinfo.conf for rp and non-rp models
	if [ -x /usr/syno/bin/synohdcfgen ]; then
		insmod /lib/modules/synobios.*
		/bin/mknod /dev/synobios c 201 0
		echo "Starting /usr/syno/bin/synohdcfgen..."
		/usr/syno/bin/synohdcfgen $RootMnt
		RetCfg=$?
		echo "/usr/syno/bin/synohdcfgen returns $RetCfg"
		rmmod `/sbin/lsmod | /usr/bin/cut -f 1 -d ' ' | /bin/grep synobios`
	fi

	if [ $IS_INSTALL_CREATE_VOL -eq 1 ]; then
	    touch ${NOTIFY_ASSISTANT_INSTALL_VOL_CREATE}
	    echo "Touching ${NOTIFY_ASSISTANT_INSTALL_VOL_CREATE}"
	fi


	# Workaround for BLDK issue in all models that support EUP
	# this file (/var/.updater_enable_rcpower) is read by S79RCPower.sh in the
	# last rebooting to keep RCPower enable during upgrading.
	# And it should be removed now

	if [ -e "$RootMnt/var/.updater_enable_rcpower" ]; then
		rm -f $RootMnt/var/.updater_enable_rcpower
	fi

	sync ; sync ; sync
else
	echo "No upgrade file exists"
fi

if [ $IsClean -ne 1 ]; then
	touch ${DataMnt}/.needquotacheck_upgrade
	echo "Touching ${DataPartition}:/.needquotacheck_upgrade"
fi

# cleanup
sync ; sync ; sync
if [ ${RootMnt} != ${DataMnt} ]; then
	$Umount $DataMnt
fi

echo "End upgrade procedure"
##################################

