/* Copyright (c) 2017 Synology Inc. All rights reserved. */

Ext.ns("SYNO.SDS.ResourceMonitor.Performance.Chart");Ext.define("SYNO.SDS.ResourceMonitor.Performance.Detail.Header",{extend:"Ext.Container",constructor:function(a){var c=this;var b=Ext.apply({layout:{type:"hbox",pack:"end"},height:32,style:"margin: 5px 0px 0px 0px;",topLayer:a.topLayer,items:[],listeners:{activate:this.onActivate,scope:this}},a.config);if(!Ext.isEmpty(a.lun_button)){if(a.lun_button.title){c.button_label=c.createCustomLabel(a.lun_button.title,false);b.items.push(c.button_label)}c.lun_button=c.createLunButton(a.lun_button.text,a.lun_button.handler,a.lun_button.scope);b.items.push(c.lun_button)}if(!Ext.isEmpty(a.type_combo)){c.type_label=c.createCustomLabel(_T("rsrcmonitor","chart"),false);c.type_combo=c.createTypeCombo(a.type_combo.data);b.items.push(c.type_label);b.items.push(c.type_combo)}if(!Ext.isEmpty(a.lun_combo)){c.lun_label=c.createCustomLabel(_T("rsrcmonitor","lun_name"),false);c.lun_combo=c.createLunCombo();b.items.push(c.lun_label);b.items.push(c.lun_combo)}c.history_label=c.createCustomLabel(_T("rsrcmonitor","time_range"),true);c.history_combo=c.createHistoryCombo();b.items.push(c.history_label);b.items.push(c.history_combo);this.callParent([b])},createHistoryCombo:function(){return new SYNO.ux.ComboBox({xtype:"syno_combobox",itemId:"history_combo",width:150,margins:{top:0,right:0,bottom:0,left:10},triggerAction:"all",editable:false,valueField:"history",displayField:"displayText",value:"current",mode:"local",autoScroll:false,hidden:true,store:new Ext.data.ArrayStore({fields:["history","displayText"],data:[["current",_T("rsrcmonitor","realtime")],["day",_T("rsrcmonitor","last_24_hours")],["week",_T("rsrcmonitor","last_7_days")],["month",_T("rsrcmonitor","last_30_days")],["year",_T("rsrcmonitor","last_12_months")]]}),listeners:{select:{scope:this,fn:this.headerChange}}})},createTypeCombo:function(a){return new SYNO.ux.ComboBox({itemId:"type_combo",width:185,margins:{top:0,right:0,bottom:0,left:10},triggerAction:"all",editable:false,mode:"local",autoScroll:false,valueField:"type",displayField:"displayText",value:a[0][0],store:new Ext.data.ArrayStore({fields:["type","displayText"],data:a}),listeners:{select:{scope:this,fn:this.headerChange}}})},createLunCombo:function(){return new SYNO.ux.ComboBox({itemId:"lun_combo",width:185,margins:{top:0,right:0,bottom:0,left:10},triggerAction:"all",editable:false,mode:"local",autoScroll:false,valueField:"uuid",displayField:"displayText",store:new Ext.data.ArrayStore({fields:["uuid",{name:"displayText",sortType:"asNaturalUCString"}],sortInfo:{field:"displayText",direction:"ASC"}}),listeners:{select:{scope:this,fn:this.headerChange}}})},createCustomLabel:function(b,a){return new SYNO.ux.DisplayField({margins:{top:0,right:0,bottom:0,left:20},style:"text-align: right;",value:b+":",hidden:a})},createLunButton:function(c,b,a){return new SYNO.ux.Button({cls:"absolute-left",itemId:"type-button",xtype:"syno_button",margins:{top:0,right:0,bottom:0,left:10},text:c,scope:a,handler:b})},headerChange:function(){var a=this.getContentConfig();this.topLayer.setTimeRange(a.history);this.fireEvent("contentSelect",a)},reloadContent:function(a){if(this.history_combo){this.history_combo.setValue(a.history)}if(this.type_combo){this.type_combo.setValue(a.type)}this.fireEvent("contentSelect",a)},getContentConfig:function(){var a={};if(this.history_combo){a.history=this.history_combo.value}else{a.history="current"}if(this.type_combo){a.type=this.type_combo.value}if(this.lun_combo){a.lun=this.lun_combo.value}return a},setToRealTime:function(){var a=this;if(!a.history_combo){return}a.history_combo.setValue("current");a.headerChange()},onActivate:function(){var a=this.getContentConfig();if(this.history_combo.hidden){return}if(a.history!==this.topLayer.time_range){a.history=this.topLayer.time_range;this.reloadContent(a)}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Chart.Current",{extend:"Ext.Panel",totalTime:180,constructor:function(d){var e=this,b={},a,c=0;b={store:[],border:false,topLayer:d.topLayer,dataType:"normal"};Ext.apply(b,d);this.callParent([b]);if(d.lines){for(c=0;c<d.lines.length;++c){a=d.lines[c];e.store.push(new SYNO.SDS.ResourceMonitor.Performance.DataSet({totalTime:e.totalTime,lineType:a.lineType,itemId:a.itemId||"store"+c,color:a.color,trackColor:a.trackColor||a.color,trackOrder:a.trackOrder||0,lineName:a.lineName}))}}},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Chart.Current.superclass.initEvents.call(this,arguments);a.mon(a,"resize",a.drawChart,a);a.mon(a.topLayer.appWin,"server_change",a.clearStoreData,a)},drawChart:function(){var c=this,b=[],a=0;if(c.isDestroyed||!c.body||c.body.getSize(true).width<=1||c.body.getSize(true).height<=1){return}for(a=0;a<c.store.length;++a){b.push(c.store[a].genSeries())}Flotr.draw(c.body.dom,b,c.getChartType())},updateStores:function(d){var c=this,a=0,b=false;Ext.each(c.store,function(e){b=d.every(function(g,f,h){return e.itemId!==g.itemId});if(b){return false}});if(!b&&d.length===c.store.length){return}c.store=[];for(a=0;a<d.length;++a){c.store.push(new SYNO.SDS.ResourceMonitor.Performance.DataSet({totalTime:c.totalTime,lineType:d[a].lineType,color:d[a].color,itemId:d[a].itemId,lineName:d[a].lineName}))}},pushValueById:function(c,d){var b=this,a=0;Ext.each(c,function(f,e,g){for(a=0;a<b.store.length;++a){if(b.store[a].itemId===f.itemId){b.store[a].pushData(f.value,d);return}}})},pushValue:function(d,e){var c=this,b=0,a=0;for(b=c.store.length-1;b>=0;--b){c.store[b].pushData(d[b]+a,e);if(c.aggregate){a+=d[b]}}},clearStoreData:function(){var b=this,a=0;for(a=b.store.length-1;a>=0;--a){b.store[a].clear()}},getChartType:function(){var d=this,c={},a=0,b=0,e=0;c.mouse={track:true,trackAll:true,position:"nw",sensibility:2,radius:0,lineColor:null,trackFormatter:d.trackFormatter.createDelegate(d),trackStyle:""};c.crosshair={mode:"x",color:"#FA4444",hideCursor:false,lineWidth:2};c.shadowSize=0;a=(d.store[0])?d.store[0].getLastTime():0;b=a-d.totalTime;c.xaxis={min:b,max:a,noTicks:0,minLabelHeight:14};c.grid={verticalLines:false,horizontalLines:true,color:"#b4bec8",outlineWidth:1,backgroundColor:"#f5faff"};switch(d.dataType){case"percent":c.yaxis={min:0,max:100,noTicks:5,minLabelWidth:21,color:"#505a64"};break;case"byte":case"bytes":e=d.getMaxDataValue();if(!Ext.isNumber(e)||e<100*1024){e=100*1024}else{e=e*1.1}c.yaxis={max:e,min:0,tickDecimals:0,noTicks:5,minLabelWidth:32,mode:d.dataType,color:"#505a64"};break;case"timeus":e=d.getMaxDataValue();if(!Ext.isNumber(e)||e<10){e=10}else{e=e*1.1}c.yaxis={max:e,min:0,tickDecimals:0,noTicks:5,minLabelWidth:32,mode:"timeus",color:"#505a64"};break;case"normal":e=d.getMaxDataValue();if(!Ext.isNumber(e)||e<10){e=10}else{e=e*1.1}c.yaxis={max:e,min:0,tickDecimals:0,noTicks:5,minLabelWidth:32,color:"#505a64"};break;default:return}c.y2axis={showLabels:false};if(d.chartTitle){c.title=d.chartTitle;c.titleCls="performance-chart-title"}return c},getMaxDataValue:function(){var c=this,a=0,b=0;for(b=0;b<c.store.length;++b){if(a<c.store[b].getMaxDataValue()){a=c.store[b].getMaxDataValue()}}return a},trackFormatter:function(e){var j=this,g=e.nearest.allSeries,h=e.index,f=[],c,d=0,i=0,k,b=[];if(0===e.index&&e.mx+1<e.x){return""}c=new Date(g[0].data[h][0]*1000);c=c.format("Y/m/d H:i:s");for(i=g.size()-1;i>=0;--i){f[i]=g[i].data[h][1]-d;if(j.aggregate){d+=f[i]}}for(i=0;i<g.size();++i){if("percent"===j.dataType){k=f[i]+"%"}else{if("byte"===j.dataType){k=Ext.util.Format.fileSize(f[i])}else{if("bytes"===j.dataType){k=Ext.util.Format.fileSize(f[i])+"/s"}else{if("normal"===j.dataType){k=f[i]}else{if("timeus"===j.dataType){var a=j.topLayer.numberUnit(f[i],j.dataType);k=a.num+" "+a.unit}}}}}b.push({name:g[i].lineName,value:k,color:g[i].trackColor||g[i].color,order:g[i].trackOrder||0})}b=b.sort(function(m,l){return(m.order>l.order)?1:-1});return SYNO.SDS.ResourceMonitor.Performance.Chart.Util.getStyledInfoList(c,b)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Chart.History",{extend:"Ext.Panel",aggregate:false,lines:[],timeAxis:"day",dataType:"percent",dataBase:1,data:{},dataSize:0,constructor:function(b){var a={topLayer:b.topLayer,border:false};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Chart.History.superclass.initEvents.call(this,arguments);a.mon(a,"resize",function(){if(a.data){a.drawChart()}},a)},setChartConfig:function(a){var b=this;if(!a){return false}if(Ext.isDefined(a.aggregate)){b.aggregate=a.aggregate}if(Ext.isDefined(a.lines)){b.lines=a.lines}if(Ext.isDefined(a.timeAxis)){b.timeAxis=a.timeAxis}if(Ext.isDefined(a.dataType)){b.dataType=a.dataType}if(Ext.isDefined(a.dataBase)){b.dataBase=a.dataBase}if(Ext.isDefined(a.data)){b.data=a.data}if(Ext.isDefined(a.dataSize)){b.dataSize=a.dataSize}if(Ext.isDefined(a.endTime)){b.endTime=a.endTime}if(Ext.isDefined(a.timeInterval)){b.timeInterval=a.timeInterval}if(Ext.isDefined(a.chartTitle)){b.chartTitle=a.chartTitle}else{b.chartTitle=null}},drawChart:function(){var b=this,c=0,a;if(b.isDestroyed||!b.body||b.body.getSize(true).width<=1||b.body.getSize(true).height<=1){return}a=b.genSeries();c=b.getMaxDataValue(a);Flotr.draw(b.body.dom,a,b.getChartType(c))},genSeries:function(){var m=this,g=[],f=m.data,h=0,e=0,n=m.lines.length,d=[],k,c=new Date(),a=m.endTime,l=c.getTimezoneOffset()*60,b=1;if("bytes"===m.dataType){b=m.dataBase}if(m.aggregate){f=m.aggregateData()}for(h=0;h<n;++h){d=[];k=m.lines[h].itemId;a=m.endTime;if(!Ext.isDefined(f[k])){continue}for(e=f[k].size()-1;e>=0;--e){d.push([(a-l)*1000,f[k][e]*b]);a-=m.timeInterval}g.push({data:d.reverse(),lines:m.lines[h].lineType,color:m.lines[h].color,lineName:m.lines[h].lineName,trackColor:m.lines[h].trackColor||m.lines[h].color,trackOrder:m.lines[h].trackOrder||0})}return g},aggregateData:function(){var d=this,c=0,b=0,a=d.lines.length,f=0,e=SYNO.Util.copy(d.data);for(c=0;c<d.dataSize;++c){f=0;for(b=a-1;b>=0;--b){f+=e[d.lines[b].itemId][c];e[d.lines[b].itemId][c]=f}}return e},getChartType:function(c){var b=this,a={};a.mouse={track:true,trackAll:true,position:"nw",sensibility:2,radius:0,lineColor:null,trackFormatter:b.trackFormatter.createDelegate(b),trackStyle:""};a.crosshair={mode:"x",color:"#FA4444",hideCursor:false,lineWidth:2};a.shadowSize=0;a.grid={verticalLines:false,horizontalLines:true,color:"#b4bec8",outlineWidth:1,backgroundColor:"#f5faff"};switch(b.timeAxis){case"day":a.xaxis={mode:"time",timeFormat:"%H",noTicks:12,minLabelHeight:14};break;case"week":a.xaxis={mode:"time",timeFormat:"%d",noTicks:7,minLabelHeight:14};break;case"month":a.xaxis={mode:"time",timeFormat:"%d",noTicks:15,minLabelHeight:14};break;case"year":a.xaxis={mode:"time",timeFormat:"%b",noTicks:12,minLabelHeight:14};break;default:return}switch(b.dataType){case"percent":a.yaxis={min:0,max:100,minLabelWidth:21,noTicks:5,color:"#505a64"};break;case"byte":case"bytes":if(!Ext.isNumber(c)||c<100*1024){c=100*1024}else{c=c*1.1}a.yaxis={max:c,min:0,tickDecimals:0,noTicks:5,minLabelWidth:32,mode:b.dataType,color:"#505a64"};break;case"timeus":if(!Ext.isNumber(c)||c<10){c=10}else{c=c*1.1}a.yaxis={max:c,min:0,tickDecimals:0,noTicks:5,minLabelWidth:32,mode:"timeus",color:"#505a64"};break;case"normal":if(!Ext.isNumber(c)||c<10){c=10}else{c=c*1.1}a.yaxis={max:c,min:0,tickDecimals:0,noTicks:5,minLabelWidth:32,color:"#505a64"};break;default:return}a.y2axis={showLabels:false};if(b.chartTitle){a.title=b.chartTitle;a.titleCls="performance-chart-title"}return a},getMaxDataValue:function(d){var c=0,b=0,a=0;for(c=0;c<d.length;++c){for(b=0;b<d[c].data.length;++b){if(a<d[c].data[b][1]){a=d[c].data[b][1]}}}return a},trackFormatter:function(e){var k=this,g=e.nearest.allSeries,h=e.index,f=[],d=0,i=0,c=new Date(),j=c.getTimezoneOffset()*60*1000,b=[],l;for(i=g.size()-1;i>=0;--i){f[i]=g[i].data[h][1]-d;if(k.aggregate){d+=f[i]}}for(i=0;i<g.size();++i){if("percent"===k.dataType){l=f[i]+"%"}else{if("byte"===k.dataType){l=Ext.util.Format.fileSize(f[i])}else{if("bytes"===k.dataType){l=Ext.util.Format.fileSize(f[i])+"/s"}else{if("normal"===k.dataType){l=f[i]}else{if("timeus"===k.dataType){var a=k.topLayer.numberUnit(f[i],k.dataType);l=a.num+" "+a.unit}}}}}b.push({name:g[i].lineName,color:g[i].trackColor||g[i].color,order:g[i].trackOrder||0,value:l})}b=b.sort(function(n,m){return(n.order>m.order)?1:-1});c=new Date(g[0].data[h][0]+j);c=c.format("Y/m/d H:i");return SYNO.SDS.ResourceMonitor.Performance.Chart.Util.getStyledInfoList(c,b)}});SYNO.SDS.ResourceMonitor.Performance.Chart.Util={getStyledInfoList:function(b,d){var c,a;c='<table class="info-list-table">';c+='<tr><td class="info-list-top-l"></td><td colspan="2" class="info-list-top-m"></td><td class="info-list-top-r"></td></tr>';c+='<tr><td class="info-list-time-l"></td><td colspan="2" class="info-list-time-text">'+b+'</td><td class="info-list-time-r"></td></tr>';for(a=0;a<d.size();++a){c+='<tr style="color:'+d[a].color+'"><td class="info-list-content-l"></td><td class="info-list-content-name">'+d[a].name+'</td><td align="right" class="info-list-content-value">'+d[a].value+'</td><td class="info-list-content-r"></td></tr>'}c+='<tr><td class="info-list-bottom-l"></td><td colspan="2" class="info-list-bottom-m"></td><td class="info-list-bottom-r"></td></tr>';c+="</table>";return c}};Ext.define("SYNO.SDS.ResourceMonitor.Performance.DataSet",{extend:"Ext.util.Observable",constructor:function(b){this.data=[];var a=Ext.apply({totalTime:180,lineType:{}},b);Ext.apply(this,a);this.callParent([a])},pushData:function(d,e){var c=this,a=e-c.totalTime,b=0;if(c.getLastTime()>=e){c.data=[]}c.data.push([e,d]);for(b=0;c.data[b][0]<a;++b){}if(2<=b){c.data=c.data.slice(b-2)}},genSeries:function(){var a=this;return{data:a.data,lines:a.lineType,lineName:a.lineName,color:a.color,trackColor:a.trackColor||a.color,trackOrder:a.trackOrder||1}},getLastTime:function(){var a=this;if(a.data.length>0){return a.data[a.data.length-1][0]}else{return 0}},getMaxDataValue:function(){var b=this,c=0,a=0;for(a=0;a<b.data.length;++a){if(b.data[a][1]>c){c=b.data[a][1]}}return c},clear:function(){this.data.clear()},getLastDataValue:function(){if(this.data.last()){return this.data.last()[1]}return 0}});SYNO.SDS.ResourceMonitor.Performance.TotalTime=3*60;Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Main",{extend:"Ext.Container",constructor:function(g){var f={xtype:"box",height:33,border:false};var d=new SYNO.SDS.ResourceMonitor.Performance.Overview.RowOne({topLayer:g.topLayer,appWin:g.appWin,flex:1});var a={xtype:"box",height:9,border:false};var e=new SYNO.SDS.ResourceMonitor.Performance.Overview.RowTwo({topLayer:g.topLayer,appWin:g.appWin,owner:this,flex:1});var b={xtype:"displayfield",itemId:"overview_note",value:"yes"===g.appWin._D("dockerdsm")?'<span class="green-status">'+_T("common","note")+": </span>"+_T("rsrcmonitor","note_dockerdsm"):"",height:33,border:false};var c=Ext.apply({layout:"vbox",layoutConfig:{align:"stretch"},items:[f,d,a,e,b],listeners:{activate:this.onActivate,scope:this}},g);this.callParent([c])},onUpdateBottomBuffer:function(){var a="";if("yes"===this.findAppWindow()._D("dockerdsm")){a='<span class="green-status">'+_T("common","note")+": </span>"+_T("rsrcmonitor","note_dockerdsm")}this.getComponent("overview_note").setValue(a)},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.RowOne",{extend:"Ext.Container",constructor:function(d){var b=new SYNO.SDS.ResourceMonitor.Performance.Overview.CPU({itemId:"cpu",topLayer:d.topLayer,flex:1});var f=new SYNO.SDS.ResourceMonitor.Performance.Overview.Memory({itemId:"memory",topLayer:d.topLayer,flex:1});var e=new SYNO.SDS.ResourceMonitor.Performance.Overview.Network({itemId:"network",topLayer:d.topLayer,flex:1});var a={xtype:"box",width:18,border:false};var c=Ext.apply({layout:"hbox",layoutConfig:{align:"stretch"},items:[b,a,f,a,e]},d);this.callParent([c])},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.RowTwo",{extend:"Ext.Container",constructor:function(b){var l=b.appWin._S("version"),i=("yes"!==b.appWin._D("dockerdsm")),a=i&&("yes"!==b.appWin._D("usbstation")),h=l>=7280&&("yes"===b.appWin._D("support_iscsi_target","no")),j=b.appWin.hasOpenConfig("is_cms_open"),g={itemId:"buff1",xtype:"box",width:18,border:false},d={itemId:"block_middle",xtype:"box",flex:1},f={itemId:"buff2",xtype:"box",width:18,border:false},k={itemId:"block_right",xtype:"box",flex:1},e=[];if(j||i){e.push(new SYNO.SDS.ResourceMonitor.Performance.Overview.Disk({itemId:"disk",topLayer:b.topLayer,fillColor:"#f23a6d",flex:1}));e.push(g)}if(j||a){e.push(new SYNO.SDS.ResourceMonitor.Performance.Overview.Disk({itemId:"space",topLayer:b.topLayer,summary_title:((l<5621&&"yes"===b.appWin._D("supoort_iscsi_target_block","no"))||(l<7280&&"yes"===b.appWin._D("support_iscsi_target","no")))?_T("rsrcmonitor","space"):_T("tree","leaf_volume"),colors:["#5a4878"],fillColor:"#6940b2",dataRoot:"space",flex:1}))}if(j||(i&&!a)){e.push(d)}if(e.length){e.push(f)}if(j||h){e.push(new SYNO.SDS.ResourceMonitor.Performance.Overview.Lun({itemId:"lun",topLayer:b.topLayer,flex:1}))}if(j||(i&&!h)){e.push(k)}var c=Ext.apply({layout:"hbox",layoutConfig:{align:"stretch"},items:e},b);this.callParent([c]);this.mon(b.appWin,"server_ready",this.onUpdateItem,this)},onUpdateItem:function(){var l=this.findAppWindow()._S("version"),i=("yes"!==this.findAppWindow()._D("dockerdsm")),c=i&&("yes"!==this.findAppWindow()._D("usbstation")),g=l>=7280&&("yes"===this.findAppWindow()._D("support_iscsi_target","no")),k=this.getComponent("disk"),f=this.getComponent("buff1"),j=c?this.getComponent("space"):this.getComponent("block_middle"),d=c?this.getComponent("block_middle"):this.getComponent("space"),e=this.getComponent("buff2"),b=g?this.getComponent("lun"):this.getComponent("block_right"),h=g?this.getComponent("block_right"):this.getComponent("lun"),a=false;if(i){if(k.hidden){k.show();a=true}}else{if(!k.hidden){k.hide();a=true}}if(j.hidden||!d.hidden){j.show();d.hide();a=true}if(c){if((l<5621&&"yes"===this.findAppWindow()._D("supoort_iscsi_target_block","no"))||(l<7280&&"yes"===this.findAppWindow()._D("support_iscsi_target","no"))){this.getComponent("space").summary_title=_T("rsrcmonitor","space")}else{this.getComponent("space").summary_title=_T("tree","leaf_volume")}}if(b.hidden||!h.hidden){b.show();h.hide();a=true}if((i||c||g)&&(f.hidden||e.hidden)){f.show();e.show();a=true}else{if(!i&&!c&&!g&&(!f.hidden||!e.hidden)){f.hide();e.hide();a=true}}if(a){this.doLayout(false,true);this.owner.onUpdateBottomBuffer()}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Base",{extend:"Ext.Panel",summary_title:"Base",colors:["#00A8F0"],totalTime:SYNO.SDS.ResourceMonitor.Performance.TotalTime,lastChartData:null,defaultSelect:false,constructor:function(b){var a=Ext.apply({border:false,layout:"vbox",items:[{itemId:"header",xtype:"box",height:18},{itemId:"chart",xtype:"box",flex:1},{itemId:"footer",xtype:"box",height:24}],listeners:{scope:this,afterRender:{fn:function(){this.body.removeClass("x-panel-body")}}}},b);this.callParent([a])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.Overview.Base.superclass.initEvents.apply(this,arguments);var a=this;a.mon(a.topLayer,"data_comming",function(b){a.updateData(b)});a.mon(a.topLayer,"resize",a.drawResize,a);a.mon(a.topLayer.appWin,"server_change",a.clearLastData,a)},drawResize:function(){var b=this,a=b.get("chart");if(null===b.lastChartData){return}if(b.isDestroyed||!b.topLayer.isVisible()||!b.isVisible()){return}if("overview_main"!==b.topLayer.activeTab.itemId){return}b.updateChartWidth();b.doLayout();b.flotr=Flotr.draw(a.getEl().dom,b.lastChartData.series,b.lastChartData.chartType)},drawChart:function(b,e,d,a){var f=this,c=f.get("chart"),h=f.get("header"),g=f.get("footer");f.lastChartData={series:b,chartType:e,header:d,footer:a};if(f.isDestroyed||!f.topLayer.isVisible()||!f.isVisible()){return}if("overview_main"!==f.topLayer.activeTab.itemId){return}h.update(d);g.update(a);f.updateChartWidth();f.doLayout();f.flotr=Flotr.draw(c.getEl().dom,b,e)},updateChartWidth:function(){var a=this.get("chart"),c=this.get("header"),b=this.get("footer");a.setWidth(this.getWidth());c.setWidth(this.getWidth());b.setWidth(this.getWidth())},getChartType:function(){return{colors:this.colors,grid:{color:"#b4bec8",outlineWidth:1,backgroundColor:"#f5faff"},maxOutset:1,xaxis:{showLabels:false,noTicks:0,max:this.totalTime,min:0},yaxis:{showLabels:false,noTicks:5,max:100,min:0},x2axis:{showLabels:false},y2axis:{showLabels:false},shadowSize:0}},clearLastData:function(){var a=this;if(a.lastChartData){a.lastChartData.series.each(function(b){b.data.clear()},a)}},onActivate:function(){var a=this;if(null===a.lastChartData||this.hidden){return}a.drawChart(a.lastChartData.series,a.lastChartData.chartType,a.lastChartData.header,a.lastChartData.footer)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.CPU",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","cpu"),colors:["#479ea1"],constructor:function(a){this.callParent([a]);this.usageSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fill:true,fillColor:"#23dfd4",fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h.cpu){return}var d=this,g=h.time,f=h.cpu,c=d.getChartType(),e=f.user_load+f.system_load,b,a;d.usageSet.pushData(e,g);c.xaxis.max=d.usageSet.getLastTime();c.xaxis.min=c.xaxis.max-d.totalTime;b='<div class="cpu-title">'+d.summary_title+"</div>";a="<div><span class=cpu-content>"+_T("rsrcmonitor","utilization")+"&nbsp(%)</span><span class=cpu-content-value>"+e+"%</span></div>";d.drawChart([d.usageSet.genSeries()],c,b,a)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Memory",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","memory"),colors:["#b29446"],constructor:function(a){this.callParent([a]);this.usageSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fill:true,fillColor:"#fdc125",fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h.memory){return}var d=this,f=h.memory,g=h.time,c=d.getChartType(),e=f.real_usage,b,a;d.usageSet.pushData(e,g);c.xaxis.max=d.usageSet.getLastTime();c.xaxis.min=c.xaxis.max-d.totalTime;b='<div class="mem-title">'+d.summary_title+"</div>";a="<div><span class=mem-content>"+_T("rsrcmonitor","utilization")+"&nbsp(%)</span><span class=mem-content-value>"+e+"%</span></div>";d.drawChart([d.usageSet.genSeries()],c,b,a)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Disk",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","disk"),colors:["#93465c"],dataRoot:"disk",constructor:function(a){this.callParent([a]);this.utilsSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fillColor:a.fillColor,fill:true,fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h||this.hidden){return}var e=this,f=h[e.dataRoot],g=h.time,d=e.getChartType(),a,b,c;if(!f.total||!h[e.dataRoot]){return}a=f.total.utilization;e.utilsSet.pushData(a,g);d.xaxis.max=e.utilsSet.getLastTime();d.xaxis.min=d.xaxis.max-e.totalTime;c='<div class="disk-title">'+this.summary_title+"</div>";b="<div><span class=disk-content>"+_T("rsrcmonitor","utilization")+"&nbsp(%)</span><span class=disk-content-value>"+a+"%</span></div>";e.drawChart([e.utilsSet.genSeries()],d,c,b)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Network",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","network"),colors:["#64803d"],constructor:function(a){this.callParent([a]);this.speedSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fillColor:"#85c728",fill:true,fillOpacity:0.7}})},updateData:function(d){if(!d.time||!d.network){return}var k=this,h=d.network,c=d.time,j=k.getChartType(),a=0,e=0,f=0,g=0,b;for(g=0;g<h.length;++g){if("total"===h[g].device){e=h[g].rx;f=h[g].tx;break}}if("total"!==h[g].device){return}k.speedSet.pushData(e+f,c);j.xaxis.max=k.speedSet.getLastTime();j.xaxis.min=j.xaxis.max-k.totalTime;a=k.speedSet.getMaxDataValue()*1.1;if(a<100*1024){a=100*1024}j.yaxis.max=a;b='<div class="network-title">'+this.summary_title+"</div>";k.drawChart([k.speedSet.genSeries()],j,b,k.getOverviewHtml(h[g]))},getOverviewHtml:function(a){return"<div><span class=network-content-out>"+Ext.util.Format.fileSize(a.tx)+"/s</span><span class=network-content-in>"+Ext.util.Format.fileSize(a.rx)+"/s</span></div>"}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Lun",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("tree","leaf_iscsi"),colors:["#476899"],constructor:function(a){this.callParent([a]);this.speedSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fillColor:"#297bf5",fill:true,fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h.lun||this.hidden){return}var n=this,k=h.lun,f=h.time,m=n.getChartType(),b=0,p=0,a=0,j=0,e;var d=0;var o=0;var g=0;var l=0;var c=0;for(j=0;j<k.length;++j){d=k[j].read_bytes;o=k[j].write_bytes;g=parseInt(d,10)+parseInt(o,10);l=(0===g)?0:k[j].total_throughput*d/g;c=(0===g)?0:k[j].total_throughput*o/g;p+=c;a+=l}p=Math.round(p);a=Math.round(a);n.speedSet.pushData(p+a,f);m.xaxis.max=n.speedSet.getLastTime();m.xaxis.min=m.xaxis.max-n.totalTime;b=n.speedSet.getMaxDataValue()*1.1;if(b<100*1024){b=100*1024}m.yaxis.max=b;e='<div class="lun-title">'+this.summary_title+"</div>";n.drawChart([n.speedSet.genSeries()],m,e,n.getOverviewHtml(p+a))},getOverviewHtml:function(a){return"<div><span class=disk-content>"+_T("rsrcmonitor","throughput")+"</span><span class=disk-content-value>"+Ext.util.Format.fileSize(a)+"/s</span></div>"}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Main",{extend:"Ext.Container",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this,a=c.showHistory,b=false;if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:_T("rsrcmonitor","cpu"),topLayer:c.topLayer});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.CPU.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Content",{extend:"Ext.Container",constructor:function(b){var a={layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.CPU.Current({itemId:"current",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.CPU.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if("current"===a.history){this.layout.setActiveItem("current")}else{this.layout.setActiveItem("history");this.get("history").setType(a.history)}},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Current",{extend:"Ext.Panel",constructor:function(b){this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({itemId:"total_chart",chartTitle:_T("rsrcmonitor","utilization")+" (%)",flex:1,topLayer:b.topLayer,aggregate:true,totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"cpu_others",lineName:_T("rsrcmonitor","iowait"),color:"#3d85cc",trackColor:"#3d85cc",trackOrder:3,lineType:{lineWidth:0,fill:true,fillOpacity:1}},{itemId:"cpu_system",lineName:_T("rsrcmonitor","cpu_system"),color:"#55b1f2",trackColor:"#55b1f2",trackOrder:2,lineType:{fill:true,fillOpacity:1,lineWidth:1}},{itemId:"cpu_user",lineName:_T("rsrcmonitor","cpu_user"),color:"#aee239",trackColor:"#aee239",trackOrder:1,lineType:{fill:true,fillOpacity:1,lineWidth:1}}],dataType:"percent"});var a={layout:"vbox",layoutConfig:{align:"stretch"},border:false,items:[this.chart,new SYNO.SDS.ResourceMonitor.Performance.CPU.Current.Footer({itemId:"footer",topLayer:b.topLayer,height:115})]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.CPU.Current.superclass.initEvents.apply(a,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b)});a.mon(a,"activate",a.onActivate,a)},updateData:function(c){if(!c.time||!c.cpu){return}var a=this,b=c.cpu,d=c.time;a.chart.pushValue([b.other_load,b.system_load,b.user_load],d);a.chart.drawChart()},onActivate:function(){this.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Current.Footer",{extend:"Ext.Panel",constructor:function(a){var c=this;this.legendId={};var b={layout:"hbox",border:false,margins:{top:0,right:0,bottom:0,left:25},items:[{xtype:"box",itemId:"util_table",height:96,minWidth:246,border:false,html:c.createUtilTbl()},{xtype:"box",border:false,height:50,flex:1},{xtype:"box",itemId:"load_table",height:96,minWidth:246,border:false,html:c.createLoadAvarageTbl()}]};Ext.apply(b,a);this.callParent([b])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.CPU.Current.Footer.superclass.initEvents.apply(this,arguments);var a=this;a.mon(a.topLayer,"data_comming",function(b){a.updateData(b)})},updateData:function(e){if(!e.cpu){return}var b=this,d=e.cpu,a={},c={};a={utilization:d.user_load+d.system_load,user:d.user_load,system:d.system_load,others:d.other_load};c={"1min":Math.round(d["1min_load"])/100,"5min":Math.round(d["5min_load"])/100,"15min":Math.round(d["15min_load"])/100};b.updateUtilTbl(a);b.updateLoadAvarageTbl(c);b.doLayout()},createUtilTbl:function(){var c=this,b=c.legendId,a;b.util=Ext.id();b.user=Ext.id();b.system=Ext.id();b.others=Ext.id();a='<table class="legend-header"> <tbody><tr><td>'+_T("rsrcmonitor","utilization")+'</td><td style="float: right;"><span id='+b.util+' class="legend-header-value">0</span><span class="legend-value-unit-large" style="padding-left: 8px;">%</td></tr></tbody> </table><div class="legend-header-bar"></div><table class="legend-util-content"> <tbody><tr><td rowspan="2" class="legend-color-user legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">'+_T("rsrcmonitor","cpu_user")+'</td><td rowspan="2" class="legend-color-system legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">'+_T("rsrcmonitor","cpu_system")+'</td><td rowspan="2" class="legend-color-others legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">'+_T("rsrcmonitor","iowait")+"</td></tr><tr><td><span id="+b.user+' class="legend-value">0</span><span class="legend-value-unit">%</span></td><td><span id='+b.system+' class="legend-value">0</span><span class="legend-value-unit">%</span></td><td><span id='+b.others+' class="legend-value">0</span><span class="legend-value-unit">%</span></td></tr></tbody> </table>';return a},updateUtilTbl:function(a){var b=this;Ext.fly(b.legendId.util).update(""+a.utilization);Ext.fly(b.legendId.user).update(""+a.user);Ext.fly(b.legendId.system).update(""+a.system);Ext.fly(b.legendId.others).update(""+a.others)},createLoadAvarageTbl:function(){var c=this,b=c.legendId,a;b._1min=Ext.id();b._5min=Ext.id();b._15min=Ext.id();a='<table class="legend-header"> <tbody><tr><td>'+_T("rsrcmonitor","load_average")+'</td></tr></tbody> </table><div class="legend-header-bar"></div><table class="legend-avg-content"> <tbody><tr><td rowspan="2" class="legend-color-average legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">1 '+_T("rsrcmonitor","minute")+'</td><td rowspan="2" class="legend-color-average legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">5 '+_T("rsrcmonitor","minutes")+'</td><td rowspan="2" class="legend-color-average legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">15 '+_T("rsrcmonitor","minutes")+'</td></tr><tr><td class="legend-value" id='+b._1min+'>0</td><td class="legend-value" id='+b._5min+'>0</td><td class="legend-value" id='+b._15min+">0</td></tr></tbody> </table>";return a},updateLoadAvarageTbl:function(b){var a=this;Ext.fly(a.legendId._1min).update(b["1min"]+"");Ext.fly(a.legendId._5min).update(b["5min"]+"");Ext.fly(a.legendId._15min).update(b["15min"]+"")}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.History",{extend:"Ext.Container",constructor:function(c){var d=this,b={},a;a='<table><tbody><tr><td style="min-width: 80px"><div class = "legend-color-dot legend-color-user"></div>'+_T("rsrcmonitor","cpu_user")+'</td><td style="min-width: 80px"><div class = "legend-color-dot legend-color-system"></div>'+_T("rsrcmonitor","cpu_system")+'</td><td style="min-width: 80px"><div class = "legend-color-dot legend-color-others"></div>'+_T("rsrcmonitor","iowait")+"</td></tr></tbody></table>";d.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({chartTitle:_T("rsrcmonitor","utilization")+" (%)",flex:1});b={layout:"vbox",layoutConfig:{align:"stretch"},items:[d.chart,{xtype:"box",margins:{top:2,right:0,bottom:0,left:23},height:113,border:false,html:a}]};Ext.apply(b,c);this.callParent([b])},setType:function(b){var a=this;a.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:a.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["cpu"],time_range:b},scope:a,callback:a.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e)},drawCharts:function(b,d){var a=this,e={},c;if(!b){return}c={fill:true,fillOpacity:1,lineWidth:1};e={chartTitle:_T("rsrcmonitor","utilization")+" (%)",aggregate:true,lines:[{itemId:"other_load",lineName:_T("rsrcmonitor","iowait"),color:"#3d85cc",trackColor:"#3d85cc",trackOrder:3,lineType:{lineWidth:0,fill:true,fillOpacity:1}},{itemId:"system_load",lineName:_T("rsrcmonitor","cpu_system"),color:"#55b1f2",trackColor:"#55b1f2",trackOrder:2,lineType:c},{itemId:"user_load",lineName:_T("rsrcmonitor","cpu_user"),color:"#aee239",trackColor:"#aee239",trackOrder:1,lineType:c}],timeAxis:d.time_range,dataType:"percent",data:b.cpu,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};a.chart.setChartConfig(e);a.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.Main",{extend:"Ext.Container",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:{fn:this.onActivate,scope:this}}},b);this.callParent([a])},createComponent:function(c){var d=this,b=false,a=c.showHistory;if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:_T("rsrcmonitor","memory"),topLayer:c.topLayer,type_combo:{data:[["usage",_T("rsrcmonitor","physical_memory")],["swap",_T("rsrcmonitor","swap")]]}});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Memory.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.Content",{extend:"Ext.Container",constructor:function(b){var a={itemId:"content",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentPhysical({itemId:"current_usage",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentSwap({itemId:"current_swap",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Memory.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if(!Ext.isDefined(a.type)){a.type="usage"}if("current"===a.history){this.layout.setActiveItem("current_"+a.type)}else{this.layout.setActiveItem("history");this.get("history").setType(a.history,a.type)}},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentPhysical",{extend:"Ext.Panel",lastPollingData:null,constructor:function(c){var d=this;d.pieId={used:Ext.id(),buff:Ext.id(),cached:Ext.id(),free:Ext.id(),reserved:Ext.id()};d.sumarryId={total:Ext.id(),totalUnit:Ext.id(),util:Ext.id()};var b='<div style="width: 100%;"><span class="pie-title">'+_T("rsrcmonitor","memory_composition")+'</span><span style="float:right"><span class="legend-value-header-large"  style="display:inline-block; padding-right: 12px;">'+_T("rsrcmonitor","total")+"</span><span id="+d.sumarryId.total+' class="legend-value" style="display:inline-block; padding-right: 8px; padding-left: 0px;">0</span><span id='+d.sumarryId.totalUnit+' class="legend-value-unit-large" style="padding-right: 28px;">MB</span><span class="legend-value-unit-large" style="display:inline-block; padding-right:12px;">'+_T("rsrcmonitor","utilization")+"</span><span id="+d.sumarryId.util+' class="legend-value" style="display:inline-block; padding-right: 8px; padding-left: 0px;">0</span><span class="legend-value-unit-large">%</span></span></div><div class="pie-chart"><div id='+d.pieId.reserved+' class="legend-color-reserved pie-item"></div> <div id='+d.pieId.used+' class="legend-color-used pie-item"></div><div id='+d.pieId.buff+' class="legend-color-buff pie-item"></div> <div id='+d.pieId.cached+' class="legend-color-cached pie-item"></div><div id='+d.pieId.free+' class="legend-color-free pie-last-item"></div> </div>';d.legendId={legend:Ext.id(),used:Ext.id(),usedUnit:Ext.id(),buff:Ext.id(),buffUnit:Ext.id(),cached:Ext.id(),cachedUnit:Ext.id(),free:Ext.id(),freeUnit:Ext.id(),reserved:Ext.id(),reservedUnit:Ext.id()};var e="<div id="+d.legendId.legend+' style="position: absolute; top: 73px;"><table class="info-list-table"><tbody><tr><td rowspan="2" class="legend-color-reserved legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","reserved")+'</td><td rowspan="2" class="legend-color-used legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","memroy_used")+'</td><td rowspan="2" class="legend-color-buff legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","memroy_buff")+'</td><td rowspan="2" class="legend-color-cached legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","memory_cached")+'</td><td rowspan="2" class="legend-color-free legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","memory_free")+"</td></tr><tr><td><span id="+d.legendId.reserved+' class="legend-value">0</span><span id='+d.legendId.reservedUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.used+' class="legend-value">0</span><span id='+d.legendId.usedUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.buff+' class="legend-value">0</span><span id='+d.legendId.buffUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.cached+' class="legend-value">0</span><span id='+d.legendId.cachedUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.free+' class="legend-value">0</span><span id='+d.legendId.freeUnit+' class="legend-value-unit">MB</span></td></tr></tbody></table></div>';this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","utilization")+" (%)",flex:1,topLayer:c.topLayer,totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"memory_util",lineName:_T("rsrcmonitor","utilization"),color:"#105398",trackColor:"#30a9ff",lineType:{lineWidth:1,fill:true,fillColor:"#30a9ff",fillOpacity:0.7}}],dataType:"percent"});var a=Ext.apply({layout:"vbox",layoutConfig:{align:"stretch"},border:false,items:[this.chart,{xtype:"container",margins:{top:2,right:0,bottom:0,left:23},height:133,style:{position:"relative"},itemId:"legend",border:false,items:[{xtype:"box",itemId:"pie",html:b},{xtype:"box",html:e}]}]},c);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentPhysical.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b.memory,b.time)});a.mon(a,"resize",a.onResizeThis,a);a.mon(a,"activate",a.onActivate,a)},onResizeThis:function(){var a=this,b=a.lastPollingData;if(!b){return}a.updateRetanglePieChart(b);a.updateLegend(b)},onActivate:function(){var a=this,b=a.lastPollingData;if(!b){return}a.doLayout();a.updateRetanglePieChart(b);a.updateLegend(b);a.updateSumarry(b);a.chart.drawChart()},updateData:function(a,e){var b=this,d=a,c={};c={total:d.total_real*1024,used:(d.total_real-d.avail_real-d.cached-d.buffer)*1024,buffer:d.buffer*1024,cached:d.cached*1024,free:d.avail_real*1024,util:d.real_usage,reserved:(d.memory_size-d.total_real)*1024,ramsize:d.memory_size*1024};b.lastPollingData=c;b.updateRetanglePieChart(c);b.updateLegend(c);b.updateSumarry(c);b.updateChart(c,e)},updateRetanglePieChart:function(f){var e=this,c=e.get("legend").get("pie").getWidth()-8,g=Math.ceil((f.reserved*c)/f.ramsize),a=Math.ceil((f.used*c)/f.ramsize),d=Math.ceil((f.buffer*c)/f.ramsize),h=Math.ceil((f.cached*c)/f.ramsize),b=c+4-g-a-d-h;Ext.fly(e.pieId.reserved).setWidth(g);Ext.fly(e.pieId.used).setWidth(a);Ext.fly(e.pieId.buff).setWidth(d);Ext.fly(e.pieId.cached).setWidth(h);Ext.fly(e.pieId.free).setWidth(b)},updateLegend:function(e){var d=this,c=d.topLayer.fileSizeUnit(e.used),g=d.topLayer.fileSizeUnit(e.buffer),b=d.topLayer.fileSizeUnit(e.cached),f=d.topLayer.fileSizeUnit(e.free),a=d.topLayer.fileSizeUnit(e.reserved);Ext.fly(d.legendId.used).update(c.size);Ext.fly(d.legendId.usedUnit).update(c.unit);Ext.fly(d.legendId.buff).update(g.size);Ext.fly(d.legendId.buffUnit).update(g.unit);Ext.fly(d.legendId.cached).update(b.size);Ext.fly(d.legendId.cachedUnit).update(b.unit);Ext.fly(d.legendId.free).update(f.size);Ext.fly(d.legendId.freeUnit).update(f.unit);Ext.fly(d.legendId.reserved).update(a.size);Ext.fly(d.legendId.reservedUnit).update(a.unit)},updateSumarry:function(c){var b=this,a=b.topLayer.fileSizeUnit(c.ramsize);Ext.fly(b.sumarryId.total).update(a.size);Ext.fly(b.sumarryId.totalUnit).update(a.unit);Ext.fly(b.sumarryId.util).update(c.util)},updateChart:function(b,c){var a=this;a.chart.pushValue([b.util],c);a.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentSwap",{extend:"Ext.Panel",lastPollingData:null,constructor:function(c){var d=this,b={},a,e;d.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({flex:1,topLayer:c.topLayer,chartTitle:_T("rsrcmonitor","si_descr")+" / "+_T("rsrcmonitor","so_descr"),totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"swap_si",lineName:_T("rsrcmonitor","si_descr"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"swap_so",lineName:_T("rsrcmonitor","so_descr"),color:"#1eb300",trackColor:"#1eb300"}],dataType:"bytes"});d.flow={swapin:Ext.id(),swapinUnit:Ext.id(),swapout:Ext.id(),swapoutUnit:Ext.id()};a='<div><table><tbody><tr><td rowspan="2" class="legend-color-swapin legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","si_descr")+'</td><td rowspan="2" class="legend-color-swapout legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","so_descr")+"</td></tr><tr><td><span id="+d.flow.swapin+' class="legend-value">0</span><span id='+d.flow.swapinUnit+' class="legend-value-unit">Kb/s</span></td><td><span id='+d.flow.swapout+' class="legend-value">0</span><span id='+d.flow.swapoutUnit+' class="legend-value-unit" >Kb/s</td></tr></tbody></table></div>';d.swap={total:Ext.id(),totalUnit:Ext.id(),used:Ext.id(),usedUnit:Ext.id(),utilization:Ext.id()};e='<div style="position: absolute; top: 0px; right: 0px;"><table><tbody><tr><td rowspan="2" class="legend-color-summary legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","total")+'</td><td rowspan="2" class="legend-color-summary legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","memroy_used")+'</td><td rowspan="2" class="legend-color-summary legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","utilization")+"</td></tr><tr><td><span id="+d.swap.total+' class="legend-value">0</span><span id='+d.swap.totalUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.swap.used+' class="legend-value">0</span><span id='+d.swap.usedUnit+' class="legend-value-unit" >0MB</span></td><td><span id='+d.swap.utilization+' class="legend-value">0</span><span class="legend-value-unit">%</span></td></tr></tbody></table></div>';b=Ext.apply({layout:"vbox",layoutConfig:{align:"stretch"},border:false,cls:"resource-monitor-swap",style:{position:"relative"},items:[d.chart,{xtype:"box",margins:{top:3,right:0,bottom:0,left:23},height:112,html:a+e}]},c);this.callParent([b])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentSwap.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b.memory,b.time)});a.mon(a,"activate",a.onActivate,a)},onActivate:function(){this.chart.drawChart()},updateData:function(b,c){var a=this;a.chart.pushValue([b.si_disk*1024,b.so_disk*1024],c);a.chart.drawChart();a.updateFlow(b);a.updateSwap(b)},updateFlow:function(d){var b=this,a=b.getkbSizeUnit(d.si_disk),c=b.getkbSizeUnit(d.so_disk);Ext.fly(b.flow.swapin).update(a.size);Ext.fly(b.flow.swapinUnit).update(a.unit);Ext.fly(b.flow.swapout).update(c.size);Ext.fly(b.flow.swapoutUnit).update(c.unit)},getkbSizeUnit:function(a){var b=0,c="KB/s";if(a<1024){b=a;c="KB/s"}else{b=(Math.round((a)/1024));c="MB/s"}return{size:""+b,unit:c}},updateSwap:function(d){var c=this,b=c.topLayer.fileSizeUnit(d.total_swap*1024),a=c.topLayer.fileSizeUnit((d.total_swap-d.avail_swap)*1024);Ext.fly(c.swap.total).update(b.size);Ext.fly(c.swap.totalUnit).update(b.unit);Ext.fly(c.swap.used).update(a.size);Ext.fly(c.swap.usedUnit).update(a.unit);if(0>=d.total_swap){Ext.fly(c.swap.utilization).update("0")}else{Ext.fly(c.swap.utilization).update(""+Math.round((d.total_swap-d.avail_swap)*100/d.total_swap))}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.History",{extend:"Ext.Container",constructor:function(b){var c=this,a={};c.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({chartTitle:_T("rsrcmonitor","utilization")+" (%)",anchor:"100% -115"});a={layout:"anchor",items:[c.chart,{xtype:"box",height:113,style:"position: relative; margin: 2px 0px 0px 23px;",itemId:"footer"}]};Ext.apply(a,b);this.callParent([a])},setType:function(c,a){var b=this;b.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:b.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["memory"],time_range:c,graph:a},scope:b,callback:b.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e);b.setFooter(d,e)},drawCharts:function(b,c){var a=this,d={};if(!b){return}if("usage"===c.graph){d={chartTitle:_T("rsrcmonitor","utilization")+" (%)",lines:[{itemId:"real_usage",lineName:_T("rsrcmonitor","utilization"),color:"#105398",trackColor:"#30a9ff",lineType:{lineWidth:1,fill:true,fillColor:"#30a9ff",fillOpacity:0.7}}],timeAxis:c.time_range,dataType:"percent",data:b.memory,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval}}else{d={chartTitle:_T("rsrcmonitor","si_descr")+" / "+_T("rsrcmonitor","so_descr"),lines:[{itemId:"si_disk",lineName:_T("rsrcmonitor","si_descr"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"so_disk",lineName:_T("rsrcmonitor","so_descr"),color:"#1eb300",trackColor:"#1eb300"}],timeAxis:c.time_range,dataType:"bytes",dataBase:1024,data:b.memory,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval}}a.chart.setChartConfig(d);a.chart.drawChart()},setFooter:function(a,b){var c;if("usage"===b.graph){c='<div><table><tbody><tr> <td><div class = "legend-color-usage  legend-color-dot"></div>'+_T("rsrcmonitor","utilization")+"</td></tr></tbody></table></div>"}else{c='<div class="resource-monitor-swap"><table><tbody><tr class="legend-value-header"><td style="min-width: 80px;"><div class = "legend-color-swapin  legend-color-dot"></div>'+_T("rsrcmonitor","si_descr")+'</td><td><div class = "legend-color-swapout  legend-color-dot"></div>'+_T("rsrcmonitor","so_descr")+"</td></tr></tbody></table></div>"}this.get("footer").update(c)}});SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize=8;Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.Main",{extend:"Ext.Panel",header_title:_T("rsrcmonitor","disk"),dataRoot:"disk",historyType:"disk",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this,e=SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog,a=c.showHistory,b=false;if("space"===this.dataRoot){e=SYNO.SDS.ResourceMonitor.Performance.Space.SelectorDialog}if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:d.header_title,topLayer:c.topLayer,type_combo:{data:[["utilization",_T("rsrcmonitor","utilization")],["transfer_rate",_T("rsrcmonitor","transfer_rate")],["iops",_T("rsrcmonitor","iops")]]}});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Disk.Content({topLayer:c.topLayer,mainLayer:this,dataRoot:this.dataRoot,historyType:this.historyType,anchor:"100% -37",selectorDialogClass:e,detailHeader:d.chartHeader});d.add(d.content)}b=true}else{d.chartHeader.setToRealTime();d.content.updateStorages([]);d.content.selectorDialog.clearSelections()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.Content",{extend:"Ext.Panel",selectorDialog:null,defaultColors:["#e44c41","#fb6d96","#6b6dca","#80d24c","#ff8400","#fcbd00","#2fc9c2"],defaultStorages:[{itemId:"total",storageType:"total",display_name:_T("rsrcmonitor","total"),qtipName:_T("rsrcmonitor","total"),color:"#3799fa"}],storages:null,lastPollingData:null,constructor:function(b){var c=this,a={};c.storages=c.defaultStorages.clone();a=Ext.apply({layout:"anchor",border:false,autoFlexcroll:true,items:[{itemId:"content",xtype:"container",border:false,anchor:"100% -100",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentUtilization({itemId:"utilization",topLayer:b.topLayer,controlLayer:c}),new SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentTransferRate({itemId:"transfer_rate",topLayer:b.topLayer,controlLayer:c}),new SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentIOPS({itemId:"iops",topLayer:b.topLayer,controlLayer:c}),new SYNO.SDS.ResourceMonitor.Performance.Disk.History({itemId:"history",topLayer:b.topLayer,controlLayer:c})]},{xtype:"box",itemId:"chart_ctl",height:40,style:"margin: 0px 0px 0px 23px;",html:c.getChartCtlHtml()},{itemId:"footer",border:false,height:42,style:{margin:"5px 0px 0px 23px",position:"relative"},items:[{xtype:"box",border:false,itemId:"footer_text"},{xtype:"syno_button",btnStyle:"gray",style:"position: absolute; bottom: 8px; right:0px",text:_T("rsrcmonitor","view_all"),handler:c.showSelectorDialog,scope:c}]}]},b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.Main.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){if(!b||!b[a.dataRoot]){return}a.lastPollingData=b[a.dataRoot];a.removeInvalidStorages(b[a.dataRoot]);a.updateFooter(b[a.dataRoot])});a.mon(a.detailHeader,"contentSelect",a.changeContent,a);a.selectorDialog=new a.selectorDialogClass({owner:a.topLayer.appWin,topLayer:a.topLayer,dataRoot:a.dataRoot});a.mon(a.selectorDialog,"select_finish",a.updateStorages,a);a.mon(a,"activate",a.onActivate,a);a.mon(a,"beforedestroy",a.destroyed,a)},onActivate:function(){var b=this,a=b.get("content"),c=a.layout.activeItem;if(c&&Ext.isFunction(c.onActivate)){c.onActivate()}},setToRealTime:function(){this.detailHeader.setToRealTime()},changeContent:function(c){var b=this,a=b.get("content");if("utilization"===c.type){a.boxMinHeight=null}else{a.boxMinHeight=380}a.anchorSpec=null;b.doLayout();if("current"===c.history){a.layout.setActiveItem(c.type);b.updateFooter(b.lastPollingData)}else{a.layout.setActiveItem("history");a.get("history").setType(c.history,c.type);b.updateFooter()}},showSelectorDialog:function(){this.selectorDialog.show()},getChartCtlHtml:function(){var c=this,b='<div><table class="ctl-table"><tbody><tr>',a=0;for(a=0;a<c.storages.length;++a){if(0===a%4&&0!==a){b+="</tr><tr>"}b+='<td ext:qtip="'+c.storages[a].qtipName+'"><div class = "legend-color-dot" style="background-color:'+c.storages[a].color+'"></div>'+c.storages[a].display_name+"</td>"}b+="</tr></tbody><table></div>";return b},removeInvalidStorages:function(a){var d=this,b=false,c=false,e=[];Ext.each(d.storages,function(f){if("total"===f.itemId){return}c=a[f.storageType].every(function(g){if(g.device===f.itemId){return false}return true});if(c){b=true}else{e.push(f)}});if(b){d.updateStorages(e)}},updateStorages:function(e){var d=this,c=false,a=[],b;Ext.each(d.storages,function(f){c=e.every(function(h,g,i){return f.itemId!==h.id});if(true!==c){a.push(f)}});Ext.each(e,function(g,f){c=a.every(function(i,h,j){return g.id!==i.itemId});if(true===c){b=g;b.color=d.getAColor(a);a.splice(f,0,b)}});d.storages=d.defaultStorages.concat(a);d.get("chart_ctl").update(d.getChartCtlHtml());d.fireEvent("storagesUpdate")},getAColor:function(a){var d=this,c=false,b=d.defaultColors[0];Ext.each(d.defaultColors,function(e){c=a.every(function(g,f,h){return e!==g.color});if(c){b=e;return false}});return b},updateFooter:function(f){var e=this,h=e.get("footer").get("footer_text"),b,d,c=e.get("content").layout.activeItem.itemId;if("history"===c){h.update("<div></div>");return}d=f.total;if(!Ext.isDefined(d)){return false}if("utilization"===c){b='<div><table><tbody><tr><td rowspan="2" class="legend-color-total legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","utilization")+'</td></tr><tr><td><span class="legend-value">'+d.utilization+'</span><span class="legend-value-unit">%</span></td></tr></tbody></table></div>'}else{if("transfer_rate"===c){var g=e.topLayer.fileSizeUnit(d.read_byte),a=e.topLayer.fileSizeUnit(d.write_byte);b='<div><table><tbody><tr><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","read_speed")+'</td><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","write_speed")+'</td></tr><tr><td><span class="legend-value">'+g.size+'</span><span class="legend-value-unit">'+g.unit+'/s</span></td><td><span class="legend-value">'+a.size+'</span><span class="legend-value-unit">'+a.unit+"/s</span></td></tr></tbody></table></div>"}else{if("iops"===c){b='<div><table><tbody><tr><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","read")+'</td><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","write")+'</td></tr><tr><td><span class="legend-value">'+d.read_access+'</span><span class="legend-value-unit">/s</span></td><td><span class="legend-value">'+d.write_access+'</span><span class="legend-value-unit">/s</span></td></tr></tbody></table></div>'}else{b="<div></div>"}}}h.update(b)},getStoragesToDraw:function(){var b=this,c=SYNO.SDS.ResourceMonitor.Performance,d=[],a=0;for(a=0;a<c.MaxDisplaySize&&a<b.storages.length;++a){d.push(Ext.apply(b.storages[a],{lineType:{fill:false},lineName:b.storages[a].display_name||b.storages[a].itemId}))}return d},destroyed:function(){this.selectorDialog.destroy();delete this.selectorDialog}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog",{extend:"SYNO.SDS.ModalWindow",lastCommingData:null,grids:null,dataRoot:"disk",constructor:function(b){var c=this;c.selectionCheck={};c.grids=b.grids||[c.createHddGrid(b)];var a={title:_T("rsrcmonitor","view_all"),topLayer:b.topLayer,height:300,width:650,layout:"fit",items:[{xtype:"syno_tabpanel",itemId:"storage_tabs",activeTab:0,deferredRender:false,items:c.grids}],buttons:[{text:_T("common","ok"),btnStyle:"blue",itemId:"ok_btn",handler:c.okHandler,scope:c},{text:_T("common","close"),itemId:"close_btn",handler:c.closeHandler,scope:c}],listeners:{show:{fn:function(){if(c.lastCommingData){c.updateGrids(c.lastCommingData)}}}}};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.lastCommingData=b[a.dataRoot];if(a.isVisible()){a.updateGrids(b[a.dataRoot])}});Ext.each(a.grids,function(b){a.mon(b.getSelectionModel(),"afterselect",a.checkExceedMaxSelection,a)})},updateGrids:function(a){Ext.each(this.grids,function(b){b.getStore().loadData(a[b.itemId])})},createHddGrid:function(c){var b=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,a="device",d=b.defaultSorter;if("yes"===c.owner._D("supportsas")){a="display_name";d=b.sasSorter}return this.createStorageGrid({itemId:"disk",title:_T("rsrcmonitor","disk"),nameIndex:a,displayNameSorter:d,deviceNameRenderer:b.shortExpansionDiskName,topLayer:c.topLayer})},createStorageGrid:function(d){var a=new Ext.data.JsonReader({idProperty:"device",fields:[{name:"device"},{name:"display_name",sortType:d.displayNameSorter},{name:"utilization"},{name:"read_byte",type:"integer"},{name:"write_byte",type:"integer"},{name:"read_access",type:"integer"},{name:"write_access",type:"integer"}]});var e=new SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel({width:30});var b=function(j,g,f){var i=f.get("display_name"),h=Ext.util.Format.htmlEncode(i);g.attr='ext:qtip="'+h+'"';if(d.deviceNameRenderer){return Ext.util.Format.htmlEncode(d.deviceNameRenderer(i,d.topLayer))}else{return h}};var c={store:new Ext.data.Store({autoDestroy:true,reader:a,sortInfo:{field:d.nameIndex,direction:"ASC"}}),colModel:new Ext.grid.ColumnModel({defaults:{sortable:true,menuDisabled:true,width:100,height:20},columns:[e,{header:_T("common","name"),width:160,dataIndex:d.nameIndex,renderer:b},{header:_T("rsrcmonitor","utilization")+"(%)",dataIndex:"utilization"},{header:_T("rsrcmonitor","read_speed")+"(/s)",renderer:Ext.util.Format.fileSize,dataIndex:"read_byte"},{header:_T("rsrcmonitor","write_speed")+"(/s)",renderer:Ext.util.Format.fileSize,dataIndex:"write_byte"},{header:_T("rsrcmonitor","read")+"(/s)",dataIndex:"read_access"},{header:_T("rsrcmonitor","write")+"(/s)",dataIndex:"write_access"}]}),sm:e,viewConfig:{forceFit:true,onLoad:Ext.emptyFn,listeners:{beforerefresh:function(f){f.scrollTop=f.scroller.dom.scrollTop},refresh:function(f){f.scroller.dom.scrollTop=f.scrollTop}}},enableHdMenu:false,columnLines:true,frame:false,cls:"resource-monitor-performance"};Ext.apply(c,d);return new SYNO.ux.GridPanel(c)},getSelections:function(){var b=this,a=[];Ext.each(b.grids,function(c){a=a.concat(b.getGridSelections(c))});return a},getGridSelections:function(b){var c=this,a=[],e=b.getSelectionModel();a=e.getSelections().map(function(g){var f={itemId:g.get("device"),device:g.get("device"),storageType:b.itemId};if(b.deviceNameRenderer){f.display_name=b.deviceNameRenderer(g.get("display_name"),c.topLayer)}else{f.display_name=g.get("display_name")}f.qtipName=g.get("display_name");return f});var d=function(h,f){var g=b.nameIndex;if("display_name"===g&&b.deviceNameRenderer){g="qtipName"}return b.displayNameSorter(h[g])>b.displayNameSorter(f[g])};a.sort(d);return a},saveSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().saveSelections()})},resetSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().resetSelections()})},clearSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().clearSelections(true);a.getSelectionModel().clearCheckSelections()})},okHandler:function(){var b=this,a=[];a=b.getSelections();if(a.size()>=SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize){return}b.clearStatus();b.saveSelections();b.fireEvent("select_finish",a);b.hide()},closeHandler:function(){var a=this;a.hide();a.clearStatus();a.resetSelections()},checkExceedMaxSelection:function(){var b=this,c=String.format(_T("rsrcmonitor","exceeded_max_disk_selection"),SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize-1),a=[];a=b.getSelections();if(a.size()>=SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize){b.setStatusError({text:c})}else{b.clearStatus()}return}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel",{extend:"Ext.grid.CheckboxSelectionModel",checkSelections:[],constructor:function(a){var b=this;b.headerCheckId=Ext.id();b.header="<div id="+b.headerCheckId+' class="x-grid3-row-checker">&#160;</div>';this.callParent([a])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel.superclass.initEvents.apply(this,arguments);this.grid.mon(this.grid.getStore(),"load",this.checkSelectAll,this);this.grid.mon(this.grid.getStore(),"load",this.fireAfterSelectEvent,this)},handleMouseDown:function(){},checkSelectAll:function(){var a=this;if(a.getCount()===a.grid.getStore().getCount()&&a.getCount()!==0){Ext.get(a.headerCheckId).addClass("x-grid3-hd-checker-on")}else{Ext.get(a.headerCheckId).removeClass("x-grid3-hd-checker-on")}},fireAfterSelectEvent:function(){this.fireEvent("afterselect")},onMouseDown:function(b,a){SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel.superclass.onMouseDown.apply(this,arguments);this.checkSelectAll();this.fireAfterSelectEvent()},onHdMouseDown:function(c,a){var b=this;if(!a.hasClassName("x-grid3-row-checker")){return}if(a.hasClassName("x-grid3-hd-checker-on")){Ext.get(b.headerCheckId).removeClass("x-grid3-hd-checker-on");b.clearSelections()}else{Ext.get(b.headerCheckId).addClass("x-grid3-hd-checker-on");b.selectAll()}b.fireAfterSelectEvent()},saveSelections:function(){var a=this;a.checkSelections=a.getSelections()},resetSelections:function(){var b=this,a=b.grid.getStore();b.clearSelections(true);a.each(function(c){Ext.each(b.checkSelections,function(d){if(c.id===d.id){b.selectRow(a.indexOf(c),true,true);return false}})});b.checkSelectAll()},clearCheckSelections:function(){this.checkSelections.clear()}});SYNO.SDS.ResourceMonitor.Performance.Disk.Utility={getValueFromComingDataById:function(c,a,e,d){var b=0;if("total"===e){return c.total[d]}Ext.each(c[a],function(g,f,h){if(g.device===e){b=g[d];return false}return true});return b},shortExpansionDiskName:function(a,e){if("yes"!==e.appWin._D("supportsas")){return a}var b=_T("volume","volume_expansion"),f=_T("volume","volume_disk"),d,c;if("("+b!==a.substr(0,b.length+1)){return a}d=a.match(/\d+/g);if(null===d||2!==d.length){return a}c="{0} - "+f+" {1}";return String.format(c,d[0],d[1])},volumeSorter:function(a){if("volume"===a.substr(0,6)){return parseInt(a.substr(6),10)}return a},defaultSorter:function(a){return a},sasSorter:function(c){var b,d=0,a=0;b=c.match(/\d+/g);if(null===b){return c}if(1===b.length){d=0;a=parseInt(b[0],10)}else{d=parseInt(b[0],10);a=parseInt(b[1],10)}return d*1000+a}};Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentTransferRate",{extend:"Ext.Panel",constructor:function(b){var c=this,a={};c.readChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","read_speed"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"bytes",topLayer:b.topLayer});c.writeChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","write_speed"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"bytes",topLayer:b.topLayer});a={layout:"anchor",border:false,items:[c.readChart,c.writeChart]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentTransferRate.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b[a.controlLayer.dataRoot],b.time)});a.mon(a,"activate",a.onActivate,a)},updateData:function(e,f){var c=this,b=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,g=[],d=[],a=c.controlLayer.getStoragesToDraw();c.readChart.updateStores(a);c.writeChart.updateStores(a);Ext.each(a,function(i,h,j){g.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"read_byte")});d.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"write_byte")})});c.readChart.pushValueById(g,f);c.writeChart.pushValueById(d,f);c.readChart.drawChart();c.writeChart.drawChart()},onActivate:function(){var a=this;a.readChart.drawChart();a.writeChart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentUtilization",{extend:"Ext.Panel",constructor:function(b){var c=this,a={};c.utilChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","utilization")+" (%)",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"percent",topLayer:b.topLayer});a={layout:"fit",border:false,items:[c.utilChart]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentUtilization.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b[a.controlLayer.dataRoot],b.time)});a.mon(a,"activate",a.onActivate,a)},updateData:function(e,f){var d=this,c=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,b=[],a=d.controlLayer.getStoragesToDraw();d.utilChart.updateStores(a);Ext.each(a,function(h,g,i){b.push({itemId:h.itemId,value:c.getValueFromComingDataById(e,h.storageType,h.itemId,"utilization")})});d.utilChart.pushValueById(b,f);d.utilChart.drawChart()},onActivate:function(){var a=this;a.utilChart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentIOPS",{extend:"Ext.Panel",constructor:function(b){var c=this,a={};c.readChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","read"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"normal",topLayer:b.topLayer});c.writeChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","write"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"normal",topLayer:b.topLayer});a={layout:"anchor",border:false,items:[c.readChart,c.writeChart]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentIOPS.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b[a.controlLayer.dataRoot],b.time)});a.mon(a,"activate",a.onActivate,a)},updateData:function(e,f){var c=this,b=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,g=[],d=[],a=c.controlLayer.getStoragesToDraw();c.readChart.updateStores(a);c.writeChart.updateStores(a);Ext.each(a,function(i,h,j){g.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"read_access")});d.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"write_access")})});c.readChart.pushValueById(g,f);c.writeChart.pushValueById(d,f);c.readChart.drawChart();c.writeChart.drawChart()},onActivate:function(){var a=this;a.readChart.drawChart();a.writeChart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.History",{extend:"Ext.Panel",constructor:function(b){this.chart1=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({flex:1});this.chart2=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({flex:1});var a={layout:"vbox",border:false,layoutConfig:{align:"stretch",pack:"start"},items:[this.chart1,this.chart2]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.History.superclass.initEvents.apply(this,arguments);a.mon(a.controlLayer,"storagesUpdate",a.onStoragesUpdate,a)},onStoragesUpdate:function(){var a=this;if(!a.isVisible()||!a.history||!a.type){return false}a.setType(a.history,a.type)},setType:function(f,c){var e=this,b=[],d=e.controlLayer.historyType,a={};e.history=f;e.type=c;e.topLayer.setStatusLoading();Ext.each(e.controlLayer.getStoragesToDraw(),function(g){b.push(g.itemId)});if("disk"===d){a={disk:b}}else{if("space"===d){a={space:b}}}SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:e.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:[d],time_range:f,interfaces:a,graph:c},scope:e,callback:e.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.task.stop();b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e)},drawCharts:function(b,c){var a=this;if("utilization"===c.graph){a.drawUtilizationChart(b,c)}if("transfer_rate"===c.graph){a.drawTransferRateChart(b,c)}if("iops"===c.graph){a.drawIopsChart(b,c)}a.doLayout()},drawUtilizationChart:function(b,e){var c=this,a=[],d={},f={};a=c.controlLayer.getStoragesToDraw();Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.utilization});f={flex:1,chartTitle:_T("rsrcmonitor","utilization")+" (%)",lines:a,timeAxis:e.time_range,dataType:"percent",data:d,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};c.chart1.show();c.chart2.hide();c.chart1.setChartConfig(f);c.chart1.drawChart()},drawTransferRateChart:function(b,e){var c=this,a=[],d={},f={};a=c.controlLayer.getStoragesToDraw();Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.read_byte});c.chart1.show();c.chart2.show();f={flex:1,chartTitle:_T("rsrcmonitor","read_speed"),lines:a,timeAxis:e.time_range,dataType:"bytes",dataBase:1,data:d,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};c.chart1.setChartConfig(f);d={};Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.write_byte});f.chartTitle=_T("rsrcmonitor","write_speed");f.data=d;c.chart2.setChartConfig(f);c.chart1.drawChart();c.chart2.drawChart()},drawIopsChart:function(b,e){var c=this,a=[],d={},f={};a=c.controlLayer.getStoragesToDraw();Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.read_access});c.chart1.show();c.chart2.show();f={flex:1,chartTitle:_T("rsrcmonitor","read"),lines:a,timeAxis:e.time_range,dataType:"normal",data:d,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};c.chart1.setChartConfig(f);d={};Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.write_access});f.chartTitle=_T("rsrcmonitor","write");f.data=d;c.chart2.setChartConfig(f);c.chart1.drawChart();c.chart2.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Space.SelectorDialog",{extend:"SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog",constructor:function(b){var d=this,c=[d.createVolumeGrid()];if(b.owner.hasOpenConfig("is_cms_open")){c.push(d.createLunGrid())}var a=Ext.apply({grids:c},b);this.callParent([a])},createVolumeGrid:function(){var a=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility;return this.createStorageGrid({itemId:"volume",title:_T("volume","volume"),nameIndex:"display_name",displayNameSorter:a.volumeSorter})},createLunGrid:function(){var a=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility;return this.createStorageGrid({itemId:"lun",title:_T("volume","volume_iscsitrg_lun"),nameIndex:"display_name",displayNameSorter:a.defaultSorter})}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Space.Main",{extend:"SYNO.SDS.ResourceMonitor.Performance.Disk.Main",header_title:_T("tree","leaf_volume"),dataRoot:"space",historyType:"space",constructor:function(b){var a=Ext.apply({selectorDialogClass:SYNO.SDS.ResourceMonitor.Performance.Space.SelectorDialog},b);this.callParent([a])}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Main",{extend:"Ext.Container",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this,a=c.showHistory,b=false;if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:_T("rsrcmonitor","network"),topLayer:c.topLayer});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Network.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.content.get("current").clearInterfaces();d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Content",{extend:"Ext.Container",constructor:function(b){var a={itemId:"content",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Network.Current({itemId:"current",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Network.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if("current"===a.history){this.layout.setActiveItem("current")}else{this.layout.setActiveItem("history");this.get("history").setType(a.history,a.type)}},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Current",{extend:"SYNO.ux.FormPanel",lastPollingData:null,constructor:function(b){var a={border:false,autoFlexcroll:true,topLayer:b.topLayer,items:[]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Network.Current.superclass.initEvents.apply(a,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b.network,b.time)});a.mon(a,"activate",a.onActivate,a)},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.drawChart)){a.drawChart()}},this)},initComponent:function(){SYNO.SDS.ResourceMonitor.Performance.Network.Current.superclass.initComponent.apply(this,arguments);this.add(new SYNO.SDS.ResourceMonitor.Performance.Network.Current.Interface({topLayer:this.topLayer,itemId:"total"}))},updateData:function(c,e){var d=this,a=0,b;if(!c||!e){return}d.updateInterfaces(c);for(a=0;a<c.length;++a){b=d.get(c[a].device);if(b){b.updateData(c[a],e)}}},updateInterfaces:function(c){var d=this,f=false,a=0,b,g,e=[];if(c.length>2){d.get("total").show()}else{d.get("total").hide()}d.items.each(function(h){var i=Ext.each(c,function(j){if(j.device===h.itemId){return false}return true});if(!Ext.isDefined(i)){e.push(h)}},d);Ext.each(e,function(h){d.remove(h)});for(a=0;a<c.length;++a){b=d.get(c[a].device);if(!b){g=new SYNO.SDS.ResourceMonitor.Performance.Network.Current.Interface({topLayer:this.topLayer,itemId:c[a].device});d.insert(a,g);f=true}}if(f||e.size()>0){d.doLayout()}},clearInterfaces:function(){var a=this;a.items.each(function(b){if("total"!==b.itemId){a.remove(b)}else{b.hide()}})}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Current.Interface",{extend:"Ext.Container",deviceName:"",constructor:function(c){var d,a;if("total"===c.itemId){this.deviceName=_T("rsrcmonitor","total")}else{a=c.itemId.replace(/\.\d+$/,"").replace(/\d+$/,"");if("bridge"===c.topLayer.appWin._S("net_topology")&&"wlan"===a){d="wifiap"}this.deviceName=SYNO.SDS.Utils.Network.idToString.apply(c.topLayer.appWin,[c.itemId,d])}this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({topLayer:c.topLayer,chartTitle:this.deviceName,totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"network_trans",lineName:_T("rsrcmonitor","rsrcmonitor_trans"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"network_recv",lineName:_T("rsrcmonitor","rsrcmonitor_recv"),color:"#1eb300",trackColor:"#1eb300"}],height:155,margins:{top:0,right:0,bottom:0,left:0},dataType:"bytes"});var e='<div style="position: absolute; right: 0px;"><table><tbody><tr><td style="width: 105px;"> <div class="legend-color-dot legend-trans"></div>'+_T("rsrcmonitor","rsrcmonitor_trans")+'</td><td><div class="legend-color-dot legend-recv"></div>'+_T("rsrcmonitor","rsrcmonitor_recv")+"</td></tr></tbody></table></div>";var b={border:false,layout:"vbox",layoutConfig:{align:"stretch"},height:192,items:[this.chart,{xtype:"box",itemId:"legend",height:37,margins:{top:0,right:0,bottom:0,left:43},html:e}]};Ext.apply(b,c);this.callParent([b])},updateData:function(a,c){var b=this;b.chart.pushValue([a.tx,a.rx],c);b.chart.drawChart()},drawChart:function(){this.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.History",{extend:"SYNO.ux.FormPanel",constructor:function(b){var a={itemId:"charts",border:false,autoFlexcroll:true,topLayer:b.topLayer,items:[]};Ext.apply(a,b);this.callParent([a])},setType:function(c){var b=this,a=[];b.controlLayer.get("current").items.items.each(function(d){if(Ext.isDefined(d.deviceName)&&"total"!==d.itemId){a.push(d.itemId)}});b.history=c;b.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:b.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["network"],time_range:c,interfaces:{network:a}},scope:b,callback:b.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e)},drawCharts:function(b,c){var a=this;a.updateInterfaces(b,c);a.items.eachKey(function(d,e){e.drawChart()},a)},updateInterfaces:function(e,g){var c=this,b="",f,a=0,d=[];c.items.each(function(h){var i=Ext.each(e.network,function(j){if(j.device===h.itemId){return false}return true});if(!Ext.isDefined(i)){d.push(h.itemId)}},c);Ext.each(d,function(h){c.remove(h)});for(a=0;a<e.network.length;++a){b=c.get(e.network[a].device);if(!b){b=new SYNO.SDS.ResourceMonitor.Performance.Network.History.Interface({itemId:e.network[a].device});c.add(b);f=true}b.setChartConfig({topLayer:c.topLayer,timeAxis:g.time_range,data:e.network[a],dataSize:e.data_size,endTime:e.time,timeInterval:e.interval})}if(f){c.doLayout()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.History.Interface",{extend:"Ext.Container",deviceName:"",constructor:function(b){this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({lines:[{itemId:"tx",lineName:_T("rsrcmonitor","rsrcmonitor_trans"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"rx",lineName:_T("rsrcmonitor","rsrcmonitor_recv"),color:"#1eb300",trackColor:"#1eb300"}],height:155,margins:{top:0,right:0,bottom:0,left:0},dataType:"bytes",dataBase:1});var c='<div style="position: absolute; right: 0px;"><table><tbody><tr><td style="width: 105px;"> <div class="legend-color-dot legend-trans"></div>'+_T("rsrcmonitor","rsrcmonitor_trans")+'</td><td><div class="legend-color-dot legend-recv"></div>'+_T("rsrcmonitor","rsrcmonitor_recv")+"</td></tr></tbody></table></div>";var a={border:false,layout:"vbox",layoutConfig:{align:"stretch"},height:192,items:[this.chart,{xtype:"box",itemId:"legend",height:37,margins:{top:0,right:0,bottom:0,left:43},html:c}]};Ext.apply(a,b);this.callParent([a])},setChartConfig:function(b){var d=this,c,a=d.itemId.replace(/\.\d+$/,"").replace(/\d+$/,"");if("bridge"===b.topLayer.appWin._S("net_topology")&&"wlan"===a){c="wifiap"}b.chartTitle=SYNO.SDS.Utils.Network.idToString.apply(b.topLayer.appWin,[d.itemId,c]);d.chart.setChartConfig(b)},drawChart:function(){this.chart.drawChart()}});SYNO.SDS.ResourceMonitor.Performance.LunDatafield=["throughput","iops","total_latency","io_size","io_latency","network_latency","queue"];SYNO.SDS.ResourceMonitor.Performance.ShowDatafield=[true,true,true,false,false,false,false];SYNO.SDS.ResourceMonitor.Performance.datafieldName={throughput:_T("rsrcmonitor","throughput"),iops:_T("rsrcmonitor","iops"),io_size:_T("rsrcmonitor","io_size"),total_latency:_T("rsrcmonitor","total_latency"),io_latency:_T("rsrcmonitor","io_latency"),network_latency:_T("rsrcmonitor","network_latency"),queue:_T("rsrcmonitor","queue_depth")};SYNO.SDS.ResourceMonitor.Performance.Charts={throughput:{line:[_T("rsrcmonitor","read"),_T("rsrcmonitor","write"),_T("rsrcmonitor","total")],dataType:"bytes"},iops:{line:[_T("rsrcmonitor","read"),_T("rsrcmonitor","write"),_T("rsrcmonitor","total")],dataType:"normal"},io_size:{line:[_T("rsrcmonitor","read"),_T("rsrcmonitor","write"),""],dataType:"byte"},total_latency:{line:[_T("rsrcmonitor","read"),_T("rsrcmonitor","write"),_T("snapmgr","info_average")],dataType:"timeus"},io_latency:{line:[_T("rsrcmonitor","read"),_T("rsrcmonitor","write"),_T("snapmgr","info_average")],dataType:"timeus"},network_latency:{line:[_T("rsrcmonitor","rsrcmonitor_trans"),_T("rsrcmonitor","rsrcmonitor_recv"),_T("snapmgr","info_average")],dataType:"timeus"},queue:{line:[_T("rsrcmonitor","depth"),"",""],dataType:"normal"}};Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.Main",{extend:"Ext.Container",constructor:function(b){this.alreadySelectedLun=false;var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this;var a=c.showHistory;var b=false;d.selectorDialog=new SYNO.SDS.ResourceMonitor.Performance.Lun.SelectorDialog({owner:c.topLayer.appWin,topLayer:c.topLayer});d.mon(d.selectorDialog,"select_finish",d.udpateGraphType,d);if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:d.header_title,topLayer:c.topLayer,lun_combo:{title:"LUN"},lun_button:{text:_T("rsrcmonitor","choose_charts"),handler:d.showSelectorDialog,scope:d}});d.add(d.chartHeader);d.mon(c.topLayer,"data_comming",function(e){d.updateLuns(d.chartHeader,e.lun)});if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Lun.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.content.get("current").clearDatafields();d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){if(this.chartHeader){var a=this.chartHeader.get("lun_combo");if(a){this.setMask(a.store.data.length)}}this.items.each(function(b){if(Ext.isFunction(b.onActivate)){b.onActivate()}},this)},udpateGraphType:function(b){var c=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;var a={};Ext.each(c,function(e,d){a[e]=false});Ext.each(b,function(e,d){a[e.data_field]=true});this.content.updateInfo(a)},updateLuns:function(d,b){var c=d.get("lun_combo");if(!c){return}var a=c.isExpanded();c.store.loadData(b.map(function(e){return[e.uuid,e.device]}));if(!a){c.collapse()}this.setMask(b.length);if(0!==b.length&&!this.alreadySelectedLun){c.setValue(b[0].uuid);d.headerChange();this.alreadySelectedLun=true}},setMask:function(a){if(0===a){this.getEl().mask(_T("rsrcmonitor","no_running_luns"));this.alreadySelectedLun=false}else{this.getEl().unmask()}},showSelectorDialog:function(){var a=this.selectorDialog;a.show();if(!a.initialized){a.initializeSelections()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.Content",{extend:"Ext.Container",constructor:function(b){var a={itemId:"content",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Lun.Current({itemId:"current",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Lun.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.header=b.header;this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if("current"===a.history){this.layout.setActiveItem("current");this.get("current").setSelectedLun(a.lun)}else{this.layout.setActiveItem("history");if(a.lun){this.get("history").setSelectedLun(a.history,a.lun)}}},updateInfo:function(a){this.choosedGraphs=a;this.get("current").updateDatafields(a);this.get("history").updateDatafields(a)},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.Current",{extend:"SYNO.ux.FormPanel",constructor:function(b){this.defaultDataFields={};this.selectedLun="";var a={border:false,autoFlexcroll:true,topLayer:b.topLayer,items:[]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var c=this;var b=SYNO.SDS.ResourceMonitor.Performance.ShowDatafield;var d=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;for(var a=0;a<d.length;++a){if(a<b.length){this.defaultDataFields[d[a]]=b[a]}else{this.defaultDataFields[d[a]]=false}}SYNO.SDS.ResourceMonitor.Performance.Lun.Current.superclass.initEvents.apply(c,arguments);c.initializeDatafields();c.updateDatafields(c.defaultDataFields);c.mon(c.topLayer,"data_comming",function(e){c.updateData(e.lun,e.time)});c.mon(c,"activate",c.onActivate,c)},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.drawChart)){a.drawChart()}},this)},initComponent:function(){SYNO.SDS.ResourceMonitor.Performance.Lun.Current.superclass.initComponent.apply(this,arguments)},setSelectedLun:function(a){if(this.selectedLun!==a){this.selectedLun=a;this.clearDatafields();this.refreshDatafields()}},updateData:function(c,d){if(0===c.length){return}var f=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;var b,a;if(!c||!d){return}for(b=0;b<c.length;++b){for(a=0;a<f.length;++a){var e=this.get(f[a]);if(e){e.storeData(c[b],d,c[b].uuid);if(this.selectedLun===c[b].uuid){e.updateData(c[b],d)}}}}},initializeDatafields:function(){var b=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;for(var a=0;a<b.length;++a){this.add(new SYNO.SDS.ResourceMonitor.Performance.Lun.Current.Datafield({topLayer:this.topLayer,itemId:b[a]}))}this.doLayout()},updateDatafields:function(b){var c=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;for(var a=0;a<c.length;++a){if(b[c[a]]){this.get(c[a]).show()}else{this.get(c[a]).hide()}}this.doLayout()},refreshDatafields:function(){var a=this.selectedLun;this.items.each(function(b){b.popData(a);b.chart.drawChart()})},clearDatafields:function(){this.items.each(function(a){a.chart.clearStoreData();a.chart.drawChart()})}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.Current.Datafield",{extend:"Ext.Container",maxStoreNum:350,constructor:function(c){this.dataField=c.itemId;this.lineName1="";this.lineName2="";this.lineName3="";this.dataType="";this.savedData={};var d=this;var a=[];d.initializeLines();d.toplayer=c.topLayer;if(""!==d.lineName1){a.push({itemId:"line1",lineName:d.lineName1,color:"#0086e6",trackColor:"#0086e6"})}if(""!==d.lineName2){a.push({itemId:"line2",lineName:d.lineName2,color:"#1eb300",trackColor:"#1eb300"})}if(""!==d.lineName3){a.push({itemId:"line3",lineName:d.lineName3,color:"#a048e4",trackColor:"#a048e4"})}this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({topLayer:c.topLayer,chartTitle:SYNO.SDS.ResourceMonitor.Performance.datafieldName[this.dataField],totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:a,height:155,margins:{top:0,right:0,bottom:0,left:0},dataType:d.dataType});var b={border:false,layout:"vbox",layoutConfig:{align:"stretch"},height:192,items:[this.chart,{xtype:"box",itemId:"legend",height:37,margins:{top:0,right:0,bottom:0,left:43},html:""}]};Ext.apply(b,c);this.callParent([b])},computeData:function(l,i){var t=l.read_cmd_count;var h=l.write_cmd_count;var o=parseInt(l.total_cmd_count,10);var p=parseInt(l.total_iops,10);var w=(0===o)?0:p*t/o;var m=(0===o)?0:p*h/o;var s=parseInt(l.read_avg_latency,10);var v=parseInt(l.write_avg_latency,10);var g=parseInt(l.tx_avg_latency,10);var q=parseInt(l.rx_avg_latency,10);switch(this.dataField){case"throughput":var n=l.read_bytes;var c=l.write_bytes;var b=parseInt(n,10)+parseInt(c,10);var r=(0===b)?0:l.total_throughput*n/b;var k=(0===b)?0:l.total_throughput*c/b;var y=r+k;r=Math.round(r);k=Math.round(k);y=Math.round(y);return[r,k,y];case"iops":w=Math.round(w*10)/10;m=Math.round(m*10)/10;p=Math.round(p*10)/10;return[w,m,p];case"io_size":var e=l.read_avg_cmd_size;var x=l.write_avg_cmd_size;return[e,x];case"total_latency":var u=s+g;var f=v+q;var a=(0===p)?0:Math.round((u*w+f*m)/p);return[u,f,a];case"io_latency":var j=(0===p)?0:Math.round((s*w+v*m)/p);return[s,v,j];case"network_latency":var d=(0===p)?0:Math.round((g*w+q*m)/p);return[g,q,d];case"queue":return[l.queue_que];default:alert("Not supported dataField "+this.dataField)}},updateData:function(b,c){var a=this.computeData(b);this.chart.pushValue(a,c);this.updateLegend(a[0],a[1],a[2]);this.chart.drawChart()},storeData:function(c,d,b){var a=this.computeData(c);if(!this.savedData[b]){this.savedData[b]=[]}this.savedData[b].push({data:a,time:d});if(this.maxStoreNum*2<this.savedData[b].length){this.savedData[b]=this.savedData[b].slice(-this.maxStoreNum)}},popData:function(a){var b=this;if(b.savedData[a]){b.savedData[a].each(function(c){b.chart.pushValue(c.data,c.time)})}},initializeLines:function(){var a=SYNO.SDS.ResourceMonitor.Performance.Charts[this.dataField];this.lineName1=a.line[0];this.lineName2=a.line[1];this.lineName3=a.line[2];this.dataType=a.dataType},updateLegend:function(b,g,e){b=b||"0";g=g||"0";e=e||"0";var c=this.topLayer.numberUnit(b,this.dataType);var a=this.topLayer.numberUnit(g,this.dataType);var f=this.topLayer.numberUnit(e,this.dataType);if("throughput"===this.dataField){c.unit+="/s";a.unit+="/s";f.unit+="/s"}var d='<div style="position: absolute; right: 0px;"><table><tbody><tr><td style="width: 105px; vertical-align: text-bottom;"> <div class="legend-color-dot legend-line1"></div>'+this.lineName1+'</td><td style="width: 105px; vertical-align: text-bottom;"><span class="legend-value">'+c.num+'</span><span class="legend-value-unit">'+c.unit+"</span></td>";if(""!==this.lineName2){d+='<td style="width: 105px; vertical-align: text-bottom;"> <div class="legend-color-dot legend-line2"></div>'+this.lineName2+'</td><td style="width: 105px; vertical-align: text-bottom;"><span class="legend-value">'+a.num+'</span><span class="legend-value-unit">'+a.unit+"</span></td>"}if(""!==this.lineName3){d+='<td style="width: 105px; vertical-align: text-bottom;"> <div class="legend-color-dot legend-line3"></div>'+this.lineName3+'</td><td style="width: 105px; vertical-align: text-bottom;"><span class="legend-value">'+f.num+'</span><span class="legend-value-unit">'+f.unit+"</span></td>"}d+="</tr></tbody></table></div>";this.get("legend").update(d)},drawChart:function(){this.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.History",{extend:"SYNO.ux.FormPanel",constructor:function(b){this.selectedLun="";this.defaultDataFields={};var a={itemId:"charts",border:false,autoFlexcroll:true,topLayer:b.topLayer,items:[]};Ext.apply(a,b);this.callParent([a]);if(!this.initialized){this.initializeDatafields()}},setSelectedLun:function(a,b){this.history=a;this.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:this.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["lun"],time_range:a,interfaces:{lun:[b]}},scope:this,callback:this.LoadHistoryData})},LoadHistoryData:function(a,c,d,b){if(this.isDestronyed){return}this.topLayer.clearStatusLoading();if(!a||!c){this.topLayer.appWin.showAlert(_T(c.err_session,c.err_key),this.controlLayer.setToRealTime,this.controlLayer);return}if(!Ext.isDefined(c.data_size)||0===c.data_size){this.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),this.controlLayer.setToRealTime,this.controlLayer);return}this.updateGraphData(c,d);this.drawCharts(c,d)},drawCharts:function(b,c){var a=this;a.items.eachKey(function(d,e){e.drawChart()},a)},initializeDatafields:function(){var d=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;var c=SYNO.SDS.ResourceMonitor.Performance.ShowDatafield;var b;var a;for(a=0;a<d.length;++a){b=this.get(d[a]);if(!b){this.add(new SYNO.SDS.ResourceMonitor.Performance.Lun.History.Datafield({topLayer:this.topLayer,itemId:d[a]}))}}for(a=0;a<d.length;++a){if(a<c.length){this.defaultDataFields[d[a]]=c[a]}else{this.defaultDataFields[d[a]]=false}}this.updateDatafields(this.defaultDataFields);this.initialized=true;this.doLayout()},updateDatafields:function(b){var c=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;for(var a=0;a<c.length;++a){if(b[c[a]]){this.get(c[a]).show()}else{this.get(c[a]).hide()}}this.doLayout()},updateGraphData:function(c,f){var e=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;var b;for(var a=0;a<e.length;++a){b=this.get(e[a]);var d=this.parseData(c.iscsi[0],c.data_size,e[a]);b.setChartConfig({chartTitle:SYNO.SDS.ResourceMonitor.Performance.datafieldName[e[a]],topLayer:this.topLayer,timeAxis:f.time_range,data:d,dataSize:c.data_size,endTime:c.time,timeInterval:c.interval})}this.doLayout()},parseData:function(x,c,r){var s=new Array(c);var v=new Array(c);var C=new Array(c);var t;var u;var z;var g;var p;var w;var h;var n;var A;var l;var o;switch(r){case"throughput":for(t=0;t<c;++t){var m=x.read_bytes[t];var d=x.write_bytes[t];var b=parseInt(m,10)+parseInt(d,10);var q=(0===b)?0:x.total_throughput[t]*m/b;var k=(0===b)?0:x.total_throughput[t]*d/b;var B=q+k;s[t]=Math.round(q);v[t]=Math.round(k);C[t]=Math.round(B)}return{line1:s,line2:v,line3:C};case"iops":for(t=0;t<c;++t){w=x.read_cmd_count[t];h=x.write_cmd_count[t];n=parseInt(x.total_cmd_count[t],10);A=(0===n)?0:x.total_iops[t]*w/n;l=(0===n)?0:x.total_iops[t]*h/n;o=parseInt(x.total_iops[t],10);s[t]=Math.round(A*10)/10;v[t]=Math.round(l*10)/10;C[t]=Math.round(o*10)/10}return{line1:s,line2:v,line3:C};case"io_size":return{line1:x.read_avg_cmd_size,line2:x.write_avg_cmd_size};case"total_latency":var y=new Array(c);var f=new Array(c);var a=new Array(c);for(t=0;t<c;++t){u=parseInt(x.read_avg_latency[t],10);z=parseInt(x.write_avg_latency[t],10);g=parseInt(x.tx_avg_latency[t],10);p=parseInt(x.rx_avg_latency[t],10);w=x.read_cmd_count[t];h=x.write_cmd_count[t];n=parseInt(x.total_cmd_count[t],10);A=(0===n)?0:x.total_iops[t]*w/n;l=(0===n)?0:x.total_iops[t]*h/n;o=parseInt(x.total_iops[t],10);y[t]=u+g;f[t]=z+p;a[t]=(0===o)?0:Math.round((y[t]*A+f[t]*l)/o)}return{line1:y,line2:f,line3:a};case"io_latency":var j=new Array(c);for(t=0;t<c;++t){u=parseInt(x.read_avg_latency[t],10);z=parseInt(x.write_avg_latency[t],10);w=x.read_cmd_count[t];h=x.write_cmd_count[t];n=parseInt(x.total_cmd_count[t],10);A=(0===n)?0:x.total_iops[t]*w/n;l=(0===n)?0:x.total_iops[t]*h/n;o=parseInt(x.total_iops[t],10);j[t]=(0===o)?0:Math.round((u*A+z*l)/o)}return{line1:x.read_avg_latency,line2:x.write_avg_latency,line3:j};case"network_latency":var e=new Array(c);for(t=0;t<c;++t){g=parseInt(x.tx_avg_latency[t],10);p=parseInt(x.rx_avg_latency[t],10);w=x.read_cmd_count[t];h=x.write_cmd_count[t];n=parseInt(x.total_cmd_count[t],10);A=(0===n)?0:x.total_iops[t]*w/n;l=(0===n)?0:x.total_iops[t]*h/n;o=parseInt(x.total_iops[t],10);e[t]=(0===o)?0:Math.round((g*A+p*l)/o)}return{line1:x.tx_avg_latency,line2:x.rx_avg_latency,line3:e};case"queue":return{line1:x.queue_que};default:alert("Not supported dataField "+this.dataField);return{line1:x.queue_que}}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.History.Datafield",{extend:"Ext.Container",constructor:function(c){this.dataField=c.itemId;this.lineName1="";this.lineName2="";this.lineName3="";this.dataType="";var d=this;var a=[];d.initializeLines();d.toplayer=c.topLayer;if(""!==d.lineName1){a.push({itemId:"line1",lineName:d.lineName1,color:"#0086e6",trackColor:"#0086e6"})}if(""!==d.lineName2){a.push({itemId:"line2",lineName:d.lineName2,color:"#1eb300",trackColor:"#1eb300"})}if(""!==d.lineName3){a.push({itemId:"line3",lineName:d.lineName3,color:"#a048e4",trackColor:"#a048e4"})}this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({topLayer:c.topLayer,lines:a,height:155,margins:{top:0,right:0,bottom:0,left:0},dataType:d.dataType,dataBase:1});var e='<div style="position: absolute; right: 0px;"><table><tbody><tr><td style="width: 105px;"> <div class="legend-color-dot legend-line1"></div>'+d.lineName1+"</td>";if(""!==d.lineName2){e+='<td style="width: 105px;"> <div class="legend-color-dot legend-line2"></div>'+d.lineName2+"</td>"}if(""!==d.lineName3){e+='<td style="width: 105px;"> <div class="legend-color-dot legend-line3"></div>'+d.lineName3+"</td>"}e+="</tr></tbody></table></div>";var b={border:false,layout:"vbox",layoutConfig:{align:"stretch"},height:192,items:[this.chart,{xtype:"box",itemId:"legend",height:37,margins:{top:0,right:0,bottom:0,left:43},html:e}]};Ext.apply(b,c);this.callParent([b])},initializeLines:function(){var a=SYNO.SDS.ResourceMonitor.Performance.Charts[this.dataField];this.lineName1=a.line[0];this.lineName2=a.line[1];this.lineName3=a.line[2];this.dataType=a.dataType},setChartConfig:function(a){var b=this;b.chart.setChartConfig(a)},drawChart:function(){this.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.SelectorDialog",{extend:"SYNO.SDS.ModalWindow",lastCommingData:null,grids:null,dataRoot:"lun",constructor:function(b){var c=this;c.initialized=false;c.selectionCheck={};c.grids=b.grids||[c.createLunGrid(b)];var a={title:_T("rsrcmonitor","choose_charts"),topLayer:b.topLayer,height:370,width:650,layout:"fit",items:[{xtype:"syno_tabpanel",itemId:"storage_tabs",activeTab:0,deferredRender:false,items:c.grids}],buttons:[{text:_T("common","ok"),btnStyle:"blue",itemId:"ok_btn",handler:c.okHandler,scope:c},{text:_T("common","close"),itemId:"close_btn",handler:c.closeHandler,scope:c}]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.Lun.SelectorDialog.superclass.initEvents.apply(this,arguments)},createLunGrid:function(a){return this.createFieldGrid({itemId:"dataField",title:_T("rsrcmonitor","data_fields"),topLayer:a.topLayer})},createFieldGrid:function(b){var d=new SYNO.SDS.ResourceMonitor.Performance.Lun.SelectorDialog.SelectModel({width:30});var c=SYNO.SDS.ResourceMonitor.Performance.LunDatafield;var a={store:new Ext.data.ArrayStore({data:c.map(function(e){return[e,SYNO.SDS.ResourceMonitor.Performance.datafieldName[e]]}),fields:[{name:"data_field"},{name:"field_name"}]}),colModel:new Ext.grid.ColumnModel({defaults:{sortable:false,menuDisabled:true,width:100,height:20},columns:[d,{header:_T("common","name"),width:160,dataIndex:"field_name"}]}),sm:d,viewConfig:{forceFit:true,onLoad:Ext.emptyFn},columnLines:true,frame:false,cls:"resource-monitor-performance"};Ext.apply(a,b);return new SYNO.ux.GridPanel(a)},initializeSelections:function(){var b=SYNO.SDS.ResourceMonitor.Performance.ShowDatafield;for(var a=0;a<b.length;++a){if(b[a]){this.grids[0].getSelectionModel().selectRow(a,true)}}this.clearStatus();this.saveSelections();this.resetSelections();this.initialized=true},getSelections:function(){var b=this;var a=[];Ext.each(b.grids,function(c){a=a.concat(b.getGridSelections(c))});return a},getGridSelections:function(b){var a=[];var c=b.getSelectionModel();a=c.getSelections().map(function(e){var d={data_field:e.get("data_field")};return d});return a},saveSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().saveSelections()})},resetSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().resetSelections()})},clearSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().clearSelections(true);a.getSelectionModel().clearCheckSelections()})},okHandler:function(){var b=this;var a=[];a=b.getSelections();b.clearStatus();b.saveSelections();b.fireEvent("select_finish",a);b.hide()},closeHandler:function(){var a=this;a.hide();a.clearStatus();a.resetSelections()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Lun.SelectorDialog.SelectModel",{extend:"SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel",resetSelections:function(){var b=this;var a=b.grid.getStore();b.clearSelections(false);a.each(function(c){Ext.each(b.checkSelections,function(d){if(c.id===d.id){b.selectRow(a.indexOf(c),true,false);return false}})});b.checkSelectAll()}});SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime=15*60;SYNO.SDS.ResourceMonitor.Performance.CurrentChartTotalDot=300;Ext.define("SYNO.SDS.ResourceMonitor.Performance.Main",{extend:"SYNO.SDS.Utils.TabPanel",time_range:"current",constructor:function(b){var c=b.appWin._S("version");this.show_disk=("yes"!==b.appWin._D("dockerdsm"));this.show_space=this.show_disk&&("yes"!==b.appWin._D("usbstation"));this.show_lun=c>=7280&&("yes"===b.appWin._D("support_iscsi_target","no"));var a=Ext.apply({activeTab:0,syncTabsActiveEvent:false,cls:"resource-monitor-performance",useDefaultBtn:false,items:[new SYNO.SDS.ResourceMonitor.Performance.Overview.Main({cls:"performance-overview",itemId:"overview_main",topLayer:this,appWin:b.appWin,title:_T("rsrcmonitor","overview")}),new SYNO.SDS.ResourceMonitor.Performance.CPU.Main({cls:"performance-cpu",itemId:"cpu_main",title:_T("rsrcmonitor","cpu")}),new SYNO.SDS.ResourceMonitor.Performance.Memory.Main({cls:"performance-memory",itemId:"mem_main",title:_T("rsrcmonitor","memory")}),new SYNO.SDS.ResourceMonitor.Performance.Network.Main({cls:"performance-network",itemId:"net_main",title:_T("rsrcmonitor","network")})],listeners:{scope:this,activate:this.onActivate}},b);if(this.show_disk){a.items.push(new SYNO.SDS.ResourceMonitor.Performance.Disk.Main({cls:"performance-disk",itemId:"disk_main",title:_T("rsrcmonitor","disk")}))}if(this.show_space){a.items.push(new SYNO.SDS.ResourceMonitor.Performance.Space.Main({cls:"performance-disk",itemId:"space_main",title:((c<5621&&"yes"===b.appWin._D("supoort_iscsi_target_block","no"))||(c<7280&&"yes"===b.appWin._D("support_iscsi_target","no")))?_T("rsrcmonitor","space"):_T("tree","leaf_volume")}))}if(this.show_lun){a.items.push(new SYNO.SDS.ResourceMonitor.Performance.Lun.Main({cls:"performance-lun",itemId:"lun_main",title:_T("tree","leaf_iscsi")}))}return this.callParent([Ext.apply(a)])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Main.superclass.initEvents.apply(a,arguments);a.setStatusLoading();if(false===a.appWin.hasOpenConfig("is_cms_open")){a.LoadConfig()}a.mon(a.appWin,"server_change",a.onServerChange,a);a.mon(a.appWin,"server_ready",a.LoadConfig,a)},updateNeededTab:function(){var a=this.getActiveTab().itemId,b=this.findAppWindow()._S("version"),c=false;this.show_disk=("yes"!==this.findAppWindow()._D("dockerdsm"));this.show_space=this.show_disk&&("yes"!==this.findAppWindow()._D("usbstation"));this.show_lun=b>=7280&&("yes"===this.findAppWindow()._D("support_iscsi_target","no"));if(!this.show_disk&&this.getItem("disk_main")){this.remove("disk_main");c=true}else{if(this.show_disk&&!this.getItem("disk_main")){this.add(new SYNO.SDS.ResourceMonitor.Performance.Disk.Main({cls:"performance-disk",itemId:"disk_main",title:_T("rsrcmonitor","disk")}));c=true}}if(!this.show_space&&this.getItem("space_main")){this.remove("space_main");c=true}else{if(this.show_space){if(!this.getItem("space_main")){this.add(new SYNO.SDS.ResourceMonitor.Performance.Space.Main({cls:"performance-disk",itemId:"space_main",title:_T("tree","leaf_volume")}));c=true}if((b<5621&&"yes"===this.findAppWindow()._D("supoort_iscsi_target_block","no"))||(b<7280&&"yes"===this.findAppWindow()._D("support_iscsi_target","no"))){this.getComponent("space_main").setTitle(_T("rsrcmonitor","space"))}else{this.getComponent("space_main").setTitle(_T("tree","leaf_volume"))}}}if(!this.show_lun&&this.getItem("lun_main")){this.remove("lun_main");c=true}else{if(this.show_lun&&!this.getItem("lun_main")){this.add(new SYNO.SDS.ResourceMonitor.Performance.Lun.Main({cls:"performance-lun",itemId:"lun_main",title:_T("tree","leaf_iscsi")}));c=true}}if("lun_main"===a&&!this.show_lun){this.setActiveTab(this.show_space?"space_main":(this.show_disk?"disk_main":"net_main"))}else{if("space_main"===a&&!this.show_space){this.setActiveTab(this.show_disk?"disk_main":"net_main")}else{if("disk_main"===a&&!this.show_disk){this.setActiveTab("net_main")}}}if(c){this.doLayout(false,true)}},LoadConfig:function(){var a=this;SYNO.API.Request({api:"SYNO.ResourceMonitor.Setting",appWindow:a.appWin,method:"get",version:1,scope:a,callback:a.onLoadConfigDone});a.no_data=true},onLoadConfigDone:function(a,f,h,d){var c=this,e=SYNO.SDS.ResourceMonitor.Performance,g=false;if(!a){c.appWin.showAlert(_T("common","commfail"),c.appWin.close,c.appWin);return}if(Ext.isNumber(f.duration)){e.CurrentTotalTime=f.duration*60}if(Ext.isDefined(f.enable_history)&&f.enable_history){g=true}var b={showHistory:g,topLayer:c};this.updateNeededTab();this.items.each(function(i){if(Ext.isFunction(i.createComponent)){i.createComponent(b)}if(Ext.isFunction(i.onActivate)){i.onActivate()}},this);c.StartPollTask()},StartPollTask:function(){var a=this,c=SYNO.SDS.ResourceMonitor.Performance,b=["cpu","memory","network"];if(a.performancePollTask){return}if(this.show_lun){b.push("lun")}if(this.show_disk){b.push("disk")}if(this.show_space){b.push("space")}a.performancePollTask=a.pollReg({webapi:{api:"SYNO.Core.System.Utilization",appWindow:a.appWin,method:"get",version:1,params:{type:"current",resource:b}},immediate:true,interval:(c.CurrentTotalTime/c.CurrentChartTotalDot),scope:a,status_callback:a.LoadPollData})},StopPollTask:function(){if(this.performancePollTask){this.pollUnreg(this.performancePollTask);this.performancePollTask=undefined}},LoadPollData:function(a,d,e,c){var b=this;if(b.isDestroyed){return}if(!a){if(b.no_data){b.appWin.showAlert(_T("common","commfail"),b.appWin.close,b.appWin)}return}b.fireEvent("data_comming",d);if(b.no_data){b.no_data=false;if(b.isVisible()){b.clearStatusLoading()}}},clearStatusLoading:function(){this.appWin.clearStatusLoading()},setStatusLoading:function(){this.appWin.setStatusLoading()},setTimeRange:function(a){if("current"!==a&&"day"!==a&&"week"!==a&&"month"!==a&&"year"!==a){return}this.time_range=a},onActivate:function(a){if(!Ext.isDefined(a.targetReady)||false===a.targetReady){this.items.each(function(b){if(Ext.isFunction(b.onActivate)){b.onActivate()}},this)}},onServerChange:function(){this.StopPollTask()},numberUnit:function(a,c){var d=parseInt(a,10);var e=d;var b="";switch(c){case"percent":return{num:""+e,unit:"%"};case"byte":case"bytes":if(d<1048576){e=Math.round(((d*10)/1024))/10;b="KB"}else{if(d<1073741824){e=Math.round(((d*10)/1048576))/10;b="MB"}else{e=Math.round(((d*10)/1073741824))/10;b="GB"}}return{num:""+e,unit:b};case"timeus":if(d<1000){e=d;b="us"}else{if(d<1000000){e=Math.round(((d*10)/1000))/10;b="ms"}else{e=Math.round(((d*10)/1000000))/10;b="s"}}return{num:""+e,unit:b};case"normal":if(d<1000){e=d;b=""}else{if(d<1000000){e=Math.round(((d*10)/1000))/10;b="K"}else{e=Math.round(((d*10)/1000000))/10;b="M"}}return{num:""+e,unit:b};default:return{num:""+e,unit:b}}},fileSizeUnit:function(b){var a=this.numberUnit(b,"bytes");return{size:a.num,unit:a.unit}}});SYNO.SDS.ResourceMonitor.PollingIntervalMs=5000;Ext.define("SYNO.SDS.ResourceMonitor.Top.Main",{extend:"SYNO.ux.GridPanel",border:false,frame:false,constructor:function(b){var a={title:_T("rsrcmonitor","process"),itemId:"top",store:this.createStore(b),colModel:this.configColumnModel(),viewConfig:{forceFit:true,onLoad:Ext.emptyFn,listeners:{beforerefresh:function(c){c.scrollTop=c.scroller.dom.scrollTop},refresh:function(c){c.scroller.dom.scrollTop=c.scrollTop}}}};Ext.apply(a,b);return this.callParent([Ext.apply(a)])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Top.Main.superclass.initEvents.apply(this,arguments);a.task=a.appWin.addTask({interval:SYNO.SDS.ResourceMonitor.PollingIntervalMs,scope:a.store,run:a.store.load});a.mon(a,"activate",a.onActivate,a);a.mon(a,"deactivate",function(){a.task.stop()});a.mon(a.appWin,"server_change",a.onServerChange,a)},onServerChange:function(){this.task.stop();this.store.removeAll()},onActivate:function(a){if(a&&a.targetReady){this.mon(this.store,"load",this.clearStatusLoading,this,{single:true})}this.task.start(true);if(0===this.store.getCount()){this.setHeight(this.appWin.getInnerHeight());this.setStatusLoading(false)}},kbfileSize:function(a){return Ext.util.Format.fileSize(a*1024)},processStatus:function(a){switch(a){case"R":return _T("rsrcmonitor","running");case"S":return _T("rsrcmonitor","sleeping");case"T":return _T("rsrcmonitor","stopped");default:return _T("rsrcmonitor","sleeping")+" ("+a+")"}},createStore:function(a){var b=this;var c=new SYNO.API.Store({api:"SYNO.Core.System.Process",version:"1",method:"list",appWindow:a.appWin,listeners:{scope:b,load:function(f,e,d){this.clearStatusLoading()},exception:function(g,h,i,f,e,d){var j=(e&&e.error)?SYNO.API.Errors.core[e.error.code]:_T("common","error_system");this.clearStatusLoading();this.appWin.getMsgBox().alert("",j)}},reader:new Ext.data.JsonReader({idProperty:"pid",root:"process"},["command","status","cpu","mem"]),remoteSort:false,sortInfo:{field:"cpu",direction:"DESC"},autoDestroy:true});return c},configColumnModel:function(){var a=new Ext.grid.ColumnModel({columns:[{header:_T("rsrcmonitor","process_name"),dataIndex:"command",width:200,align:"left"},{header:_T("common","status"),dataIndex:"status",renderer:this.processStatus,width:100,align:"left"},{header:_T("rsrcmonitor","cpu")+"(%)",dataIndex:"cpu",renderer:function(b){return b/10},width:100,align:"left"},{header:_T("rsrcmonitor","memory"),dataIndex:"mem",renderer:this.kbfileSize,width:100,align:"left"}],defaults:{sortable:true,menuDisabled:false}});return a},setStatusLoading:function(a){if(a){this.appWin.setStatusLoading()}else{if(this.appWin.isStatusLoading){return}else{if(this.tabParent){this.tabParent.getEl().mask(_T("common","loading"),"x-mask-loading")}else{this.getEl().mask(_T("common","loading"),"x-mask-loading")}}}},clearStatusLoading:function(){if(this.appWin.isStatusLoading){this.appWin.clearStatusLoading()}if(this.tabParent){this.tabParent.getEl().unmask()}else{this.getEl().unmask()}}});Ext.ns("SYNO.SDS.ResourceMonitor.ServiceTree");SYNO.SDS.ResourceMonitor.ServiceTree.PollingIntervalMs=1000;Ext.define("SYNO.SDS.ResourceMonitor.ServiceTree.TreeLoader",{extend:"Ext.ux.tree.TreeGridLoader",nproc:1,sec_per_nsec:1000000000,nodeExpanded:{},lastClick:null,loadFlag:false,constructor:function(b){var a={api:"SYNO.Core.System.ProcessGroup",method:"status",version:1,clearOnLoad:false,listeners:{scope:this,load:this.onLoad}};Ext.apply(a,b);return this.callParent([Ext.apply(a)])},onLoad:function(f,e,h){var d=Ext.decode(h.responseText);var g=(d.data)?d.data:{};var a=e.getOwnerTree();f.loadFlag=false;if(!a.store_ready||!a.task.running){return false}if(!g||!g.procs||!g.nproc||!g.cgroups){return false}a.unmask();f.nproc=g.nproc;f.data=g;e.beginUpdate();e.removeAll();var c=g.cgroups.root.cpuFraction;for(var b in g.cgroups){if(!b.match(/root/)){c-=g.cgroups[b].cpuFraction}}g.cgroups.root.cpuFraction=c;a.ds.each(function(i){var s={};var u,o,k,m,l,p;s.cpuFraction=0;s.cpu_time=0;s.memory=0;s.read=0;s.write=0;s.name=i.data.name;s.display_name=i.data.display_name;s.cgroup=[];if("dsm-bultin"===s.name){var t=e.getOwnerTree();var r=t.cgroupMap;for(var q in g.cgroups){if(g.cgroups.hasOwnProperty(q)&&!q.match(/pkgctl-/)&&!r[q]){s.cgroup.push(g.cgroups[q]);s.cpuFraction+=g.cgroups[q].cpuFraction;s.cpu_time+=g.cgroups[q].cpu_time;s.memory+=g.cgroups[q].memory}}}Object.keys(i.data.cgroup).forEach(function(n){if(g.cgroups[n]){s.cgroup.push(g.cgroups[n]);s.cpuFraction+=g.cgroups[n].cpuFraction;s.cpu_time+=g.cgroups[n].cpu_time;s.memory+=g.cgroups[n].memory}});if(0===s.cgroup.length){return}k=(i.data.dsmappname)?SYNO.SDS.Config.FnMap[i.data.dsmappname.split(" ")[0]]:null;if(i.data.iconCls){s.iconCls=i.data.iconCls}else{if(k){u=k.config.jsBaseURL;o=k.config.icon;if("SYNO.SDS.AdminCenter.Application"===i.data.dsmappname){l=SYNO.SDS.UIFeatures.test("isRetina")?"2x":"1x";p=i.data.icon.replace("icon-","").replace(/-/g,"_");s.icon=String.format("{0}/images/default/{1}/home_icons/{2}.png",u,l,p)}else{m=encodeURI(k.config.jsBaseURL)+"/"+(k.config.icon);s.icon=SYNO.SDS.UIFeatures.IconSizeManager.getIconPath(m,"AppView")}}else{s.iconCls="icon-other-app"}}s.cpuFraction=Math.round(s.cpuFraction/f.nproc);s.cpu_time=Math.round(s.cpu_time/f.sec_per_nsec);s.children=f.arrangeTasks(s);s.expanded=(f.nodeExpanded[s.name])?true:false;s.listeners={scope:f,expand:function(n){f.nodeExpanded[n.attributes.name]=true},collapse:function(n){delete f.nodeExpanded[n.attributes.name]},click:function(n){f.lastClick=n.attributes.name}};if(0===s.children.length&&30>s.cpu_time){return}var j=f.createNode(s);if(j){e.appendChild(j)}},this);e.endUpdate();f.restoreClickStatus(e);a.updateScrollbar()},arrangeTasks:function(c){var a=[];var d=[];var b=this;Object.keys(c.cgroup).forEach(function(e){d=d.concat(c.cgroup[e].pids)});Ext.each(d,function(e){var f={};if(!b.data.procs[e]){return}f.leaf=true;f.name=b.data.procs[e].name;f.display_name=String.format("pid-{0}",b.data.procs[e].name);f.iconCls="leaf-no-icon";f.cpuFraction=Math.round(b.data.procs[e].cpuFraction/b.nproc);f.cpu_time=Math.round(b.data.procs[e].cpu_time/b.sec_per_nsec);f.memory=b.data.procs[e].memory;f.read=b.data.procs[e].read;f.write=b.data.procs[e].write;f.pid=e;f.listeners={scope:b,click:function(g){b.lastClick=g.attributes.pid}};c.read+=f.read;c.write+=f.write;a.push(f)});return a},restoreClickStatus:function(b){var c=this;var a=b.getOwnerTree();var d=false;Ext.each(b.childNodes,function(e){if(c.lastClick===e.attributes.name){a.selModel.select(e);return false}Ext.each(e.childNodes,function(f){if(c.lastClick===f.attributes.pid){a.selModel.select(f);d=true;return false}});if(d){return false}})},resetStatus:function(){delete this.nodeExpanded;delete this.lastClick;this.nodeExpanded={};this.lastClick=null}});Ext.define("SYNO.SDS.ResourceMonitor.ServiceTree.Main",{extend:"Ext.ux.tree.FleXcrollTreeGrid",store_ready:false,cgroupMap:{},constructor:function(b){var a={cls:"syno-process-group",loadMask:true,enableSort:false,stripeRows:true,animate:false,enableHdMenu:false,ds:this.createStore(b),loader:new SYNO.SDS.ResourceMonitor.ServiceTree.TreeLoader({appWindow:b.appWin}),columns:this.configColumnModel()};Ext.apply(a,b);return this.callParent([Ext.apply(a)])},initEvents:function(){var a=this;a.task=a.appWin.addTask({interval:SYNO.SDS.ResourceMonitor.ServiceTree.PollingIntervalMs,scope:a,run:function(){if(a.loader.loadFlag===true){return}a.loader.loadFlag=true;a.loader.load(a.root)}});a.mon(a,"activate",a.onActivate,a);a.mon(a,"deactivate",a.onDeactivate,a);a.mon(a.appWin,"server_change",a.onServerChange,a);this.callParent(arguments)},onServerChange:function(){this.store_ready=false;this.task.stop();this.ds.removeAll();this.root.beginUpdate();this.root.removeAll();this.root.endUpdate();this.updateScrollbar()},initComponent:function(){SYNO.SDS.ResourceMonitor.ServiceTree.Main.superclass.initComponent.apply(this,arguments);this.treeGridSorter=new Ext.ux.tree.TreeGridSorter(this,{property:"cpuFraction",folderSort:true,caseSensitive:true,dir:"desc"});this.treeGridSorter.sortFn=this.sortProcessGroup.createDelegate(this.treeGridSorter);this.treeGridSorter.defaultSortFn=this.sortProcessGroup.createDelegate(this.treeGridSorter)},sortProcessGroup:function(j,i){var l=j.attributes;var k=i.attributes;var a=this.property;var h=l[a];var e=k[a];var g=this.dir&&this.dir.toLowerCase()=="desc";var b=this.leafAttr||"leaf";var f=l.display_name;var d=k.display_name;var c;if(this.folderSort){if(l[b]&&!k[b]){return 1}if(!l[b]&&k[b]){return -1}}if(f.match("pid-")){f=f.replace("pid-","")}else{c=f.split(":");f=(c.length>1)?_T(c[0],c[1]):f}if(d.match("pid-")){d=d.replace("pid-","")}else{c=d.split(":");d=(c.length>1)?_T(c[0],c[1]):d}if("display_name"===this.property){if(f<d){return g?1:-1}else{if(f>d){return g?-1:1}}return 0}else{if(h<e){return g?1:-1}else{if(h>e){return g?-1:1}else{if(f<d){return -1}else{if(f>d){return 1}}return 0}}}},createStore:function(a){var b=this;var c=new SYNO.API.Store({api:"SYNO.Core.System.ProcessGroup",version:"1",method:"service_info",appWindow:a.appWin,listeners:{scope:b,load:function(f,e,d){this.store_ready=true;Ext.each(e,function(g){Object.keys(g.data.cgroup).forEach(function(h){b.cgroupMap[h]=true})})},exception:function(g,h,i,f,e,d){var j=(e&&e.error)?SYNO.API.Errors.core[e.error.code]:_T("common","error_system");this.unmask();this.appWin.getMsgBox().alert("",j)}},reader:new Ext.data.JsonReader({root:"services"},["name","display_name","cgroup","dsmappname","icon","iconCls"]),remoteSort:false,autoDestroy:true});return c},onActivate:function(a){if(a&&a.targetReady){this.mon(this.ds,"load",this.clearStatusLoading,this,{single:true})}if(0===this.ds.getCount()){this.setHeight(this.appWin.getInnerHeight());this.mask(_T("common","loading"),"x-mask-loading")}this.ds.load();this.task.start(false);this.collapseAll();this.loader.resetStatus()},onDeactivate:function(a){this.task.stop()},kbfileSize:function(a){return Ext.util.Format.fileSize(a)},renderCpuTime:function(e){var f="";var d=[86400,3600,60,1];var a=[_T("common","time_days")+" ",":",":",""];var c;for(var b=0;b<d.length;++b){c=e;c=(0<b)?c%d[b-1]:c;c=Math.floor(c/d[b]);f=(0===c&&0===b)?f:String.format("{0}{1}{2}{3}",f,(0!==b&&10>c)?"0":"",c,a[b])}return f},configColumnModel:function(){var a=[{header:_T("rsrcmonitor","service_name"),dataIndex:"display_name",width:200,align:"left",renderer:function(c){var b=c.split(":");if(c.match("pid-")){return c.replace("pid-","")}return(b.length>1)?_T(b[0],b[1]):c}},{header:_T("rsrcmonitor","cpu")+"(%)",dataIndex:"cpuFraction",renderer:function(b){return b/10},width:80,align:"left"},{header:_T("rsrcmonitor","cpu")+" Time",dataIndex:"cpu_time",renderer:this.renderCpuTime,width:120,align:"left"},{header:_T("rsrcmonitor","memory"),dataIndex:"memory",renderer:this.kbfileSize,width:80,align:"left"},{header:_T("rsrcmonitor","input_per_sec"),dataIndex:"read",renderer:this.kbfileSize,width:80,align:"left"},{header:_T("rsrcmonitor","output_per_sec"),dataIndex:"write",renderer:this.kbfileSize,width:80,align:"left"}];return a},setStatusLoading:function(){this.appWin.setStatusLoading()},clearStatusLoading:function(){this.appWin.clearStatusLoading()},updateColumnWidths:function(){var d=this,e=d.columns,c=e.length,a=this.innerCt.parent().getWidth(),g=this.getTotalColumnWidth(),b;var f=this.isVisible();if(f){for(b=0;b<c;b++){e[b].width=(e[b].width*a)/g}d.callParent(arguments)}},mask:function(){if(this.tabParent){this.tabParent.getEl().mask(_T("common","loading"),"x-mask-loading")}else{this.getEl().mask(_T("common","loading"),"x-mask-loading")}},unmask:function(){if(this.tabParent){this.tabParent.getEl().unmask()}else{this.getEl().unmask()}},updateScrollbar:function(){this.setHeight(this.appWin.getInnerHeight());this.callParent(arguments)}});Ext.define("SYNO.SDS.ResourceMonitor.TaskTab",{extend:"SYNO.SDS.Utils.TabPanel",constructor:function(b){var a=Ext.apply({activeTab:0,useDefaultBtn:false,items:[new SYNO.SDS.ResourceMonitor.ServiceTree.Main({itemId:"service_tree",appWin:b.appWin,title:_T("schedule","title_service"),tabParent:this}),new SYNO.SDS.ResourceMonitor.Top.Main({itemId:"top",appWin:b.appWin,title:_T("rsrcmonitor","process"),tabParent:this})]},b);this.callParent([Ext.apply(a)]);this.mon(this,"activate",this.onActivate,this)},onActivate:function(a){if(a&&a.targetReady){this.clearStatusLoading();this.setActiveTab(0);this.items.map.service_tree.fireEvent("activate",{targetReady:true})}},setStatusLoading:function(){this.appWin.setStatusLoading()},clearStatusLoading:function(){this.appWin.clearStatusLoading()}});Ext.define("SYNO.SDS.ResourceMonitor.Setting.Main",{extend:"SYNO.SDS.Utils.FormPanel",tabParent:null,constructor:function(a){this.tabParent=a.tabParent;this.callParent([Ext.apply({useDefaultBtn:false,buttons:[{xtype:"syno_button",btnStyle:"blue",disabled:a.appWin._S("demo_mode"),tooltip:a.appWin._S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","commit"),scope:this,handler:this.applyHandler},{xtype:"syno_button",btnStyle:"grey",text:_T("common","reset"),scope:this,handler:this.resetHandler}],items:[this.createPerformanceField(a)],listeners:{scope:this,deactivate:this.resetHandler}},a)]);this.on("afterlayout",this.defineBehaviors,this,{single:true})},defineBehaviors:function(){var a;if("yes"===this.appWin.findAppWindow()._D("support_performance_event")){a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_history",["enable_event"])}},createPerformanceField:function(c){var f;var b="recovery_site"===_S("systemdr_role");var e=b?_TT("SYNO.SDS.SystemDR.Instance","feasibility","sdr_in_recovery"):"";var a=[{xtype:"syno_combobox",name:"duration",fieldLabel:_T("rsrcmonitor","realtime_minutes"),store:[[15,"15 "+_T("rsrcmonitor","minutes")],[30,"30 "+_T("rsrcmonitor","minutes")],[60,"60 "+_T("rsrcmonitor","minutes")],[120,"120 "+_T("rsrcmonitor","minutes")]]},{xtype:"syno_checkbox",name:"enable_history",htmlEncode:false,boxLabel:String.format('<div ext:qtip="{1}">{0}</div>',_T("rsrcmonitor","enable_history"),e),disabled:b,listeners:{scope:this,check:function(h,g){if("yes"===c.appWin.findAppWindow()._D("support_performance_event")&&false===g){this.getComponent("enable_event").setValue(false)}}}}];if("yes"===c.appWin.findAppWindow()._D("support_performance_event")){var d={xtype:"syno_checkbox",name:"enable_event",itemId:"enable_event",boxLabel:_T("rsrcmonitor","enable_event"),indent:1};if(this.tabParent){d.listeners={scope:this,check:function(h,g){if(!this.tabParent){return}if(g){this.tabParent.setEventRulePageUnamsk()}else{this.tabParent.setEventRulePageMask()}}}}a.push(d);f=a}else{f={xtype:"syno_fieldset",collapsible:false,title:_T("rsrcmonitor","performance"),synodefaults:{width:150},items:a}}return f},onLoadConfigDone:function(a,c,d,b){if(!a){return}this.getForm().setValues(c);if(this.isVisible()){this.clearStatusLoading()}},LoadConfig:function(){var a=this;SYNO.API.Request({api:"SYNO.ResourceMonitor.Setting",appWindow:a.appWin,method:"get",version:1,scope:a,callback:a.onLoadConfigDone})},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Setting.Main.superclass.initEvents.apply(a,arguments);a.LoadConfig();a.mon(a.appWin,"server_ready",a.LoadConfig,a)},applyHandler:function(){var a=this;if(!a.onBeforeActionApply()){return}a.appWin.getMsgBox().confirm(_T("tree","leaf_rsrcmonitor"),_T("rsrcmonitor","warring_restart"),a.confirmApply,a)},getWebapiParams:function(){var b=this,a=b.getForm();var c={enable_history:a.findField("enable_history").getValue(),duration:a.findField("duration").getValue()};if("yes"===this.appWin.findAppWindow()._D("support_performance_event")){c.enable_event=a.findField("enable_event").getValue()}return c},confirmApply:function(a){var b=this;if("no"===a){return}var c=this.getWebapiParams();if(this.tabParent){this.tabParent.applySetting()}else{b.appWin.sendWebAPI({compound:{params:[{api:"SYNO.ResourceMonitor.Setting",method:"set",version:1,params:c},{api:"SYNO.ResourceMonitor.Setting",method:"get",version:1}]},scope:b,callback:b.onActionComplete})}b.setStatusLoading({text:_T("common","saving")})},resetHandler:function(){this.getForm().reset()},onBeforeActionApply:function(){var b=this,a=b.getForm();if(!a.isDirty()){b.setStatusError({text:_T("error","nochange_subject"),clear:true});return false}if(!a.isValid()){b.setStatusError({text:_T("common","forminvalid"),clear:true});return false}return true},onActionComplete:function(a,d,e,c){var b=this;b.clearStatusLoading();if(true===a&&false===d.has_fail){b.getForm().setValues(d.result[1].data);b.appWin.close();Ext.defer(SYNO.SDS.AppLaunch,500,null,["SYNO.SDS.ResourceMonitor.Instance",b.appWin.openConfig])}else{if(false===d.result[0].success){b.appWin.showAlert(_T(d.result[0].error.errors.err_session,d.result[0].error.errors.err_key));if(d.result[1].data){b.getForm().setValues(d.result[1].data)}}}},setStatusOK:function(a){a=a||{};Ext.applyIf(a,{text:_T("common","setting_applied"),iconCls:"x-status-valid"});this.getFooterToolbar().setStatus(a)},setStatusError:function(a){a=a||{};Ext.applyIf(a,{text:_T("common","error_system"),iconCls:"x-status-error",clear:true});this.getFooterToolbar().setStatus(a)},setStatusLoading:function(a){this.appWin.setStatusLoading(a)},clearStatusLoading:function(){this.appWin.clearStatusLoading()}});Ext.ns("SYNO.SDS.ResourceMonitor.Util");Ext.define("SYNO.SDS.ResourceMonitor.Util.AdvancedSearchField",{extend:"SYNO.ux.SearchField",initEvents:function(){this.callParent(arguments);this.mon(Ext.getDoc(),"mousedown",this.onMouseDown,this);this.mon(this,"keypress",function(b,a){if(a.getKey()===Ext.EventObject.ENTER){this.searchPanel.setKeyWord(this.getValue());this.searchPanel.onSearch()}},this)},isInnerComponent:function(c,b){var a=false;b.items.each(function(d){if(d instanceof Ext.form.ComboBox){if(d.view&&c.within(d.view.getEl())){a=true;return false}}else{if(d instanceof Ext.form.DateField){if(d.menu&&c.within(d.menu.getEl())){a=true;return false}}else{if(d instanceof Ext.form.CompositeField){if(this.isInnerComponent(c,d)){a=true;return false}}}}},this);return a},onMouseDown:function(b){var a=this.searchPanel;if(a&&a.isVisible()&&!a.isDestroyed&&!a.inEl&&!b.within(a.getEl())&&!b.within(this.searchtrigger)&&!this.isInnerComponent(b,this.searchPanel.getForm())){a.hide()}},onSearchTriggerClick:function(){if(this.searchPanel.isVisible()){this.searchPanel.hide();return}this.searchPanel.getEl().alignTo(this.wrap,"tr-br?",[6,0]);this.searchPanel.show();this.searchPanel.setKeyWord(this.getValue())},onTriggerClick:function(){this.callParent();this.searchPanel.onReset()}});Ext.define("SYNO.SDS.ResourceMonitor.Util.SearchFormPanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.dateType={custom:1,today:2,yesterday:4,lastweek:8,lastmonth:16};this.dataRange=[[this.dateType.custom,_T("log","date_custom")],[this.dateType.today,_T("log","date_today")],[this.dateType.yesterday,_T("log","date_yesterday")],[this.dateType.lastweek,_T("log","date_lastweek")],[this.dateType.lastmonth,_T("log","date_lastmonth")]];this.logLevelType={warn:"Warning",crit:"Critical"};this.logLevel=[[this.logLevelType.warn,_T("log","warn_level")],[this.logLevelType.crit,_T("log","crit_level")]];this.defaultAnimation=["#000",1,{duration:0.35}];Ext.apply(this,a||{});var b=this.fillConfig(a);this.callParent([b]);this.mon(this,"afterlayout",function(){this.defineBehaviors()},this)},initComponent:function(){this.callParent(arguments);this.addEvents("search")},fillConfig:function(b){var a,f,g,e;var c=[];a=this.createKeyword();f=this.createFriendlyDate();g=this.createCustDate();e=this.createLevel();c.push(a);c.push(f);c.push(g);c.push(e);c.push({xtype:"toolbar",border:false,itemId:"btns",id:"btns",toolbarCls:"search-panel-fbar-btnPanel",items:[{xtype:"lctbtext",itemId:"search-loading",text:""},{xtype:"lctbtext",itemId:"msg",height:26,style:"-webkit-text-size-adjust:none;font-size:11px;height:26px;overflow:hidden;",cls:"red-status",text:""},{xtype:"tbfill"},{xtype:"syno_button",btnStyle:"blue",style:"margin-right: 10px",text:_T("log","search"),itemId:"btn_search",handler:this.onSearch,scope:this},{xtype:"syno_button",btnStyle:"blue",style:"margin-right: 10px",text:_T("smart","smart_test_button_stop"),itemId:"btn_stop",hidden:true,handler:this.onStop,scope:this},{xtype:"syno_button",minWidth:80,text:_T("common","reset"),handler:this.onReset,scope:this}]});var d={width:368,heigh:480,floating:true,labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:true,bodyStyle:"padding: 20px; padding-top: 0px; font-size: 24px;",autoFlexcroll:false,defaults:{hideLabel:true,anchor:"100%"},items:c,listeners:{actionfailed:{fn:function(){this.setMsg("");this.form.reset()},scope:this},beforeshow:{fn:function(){this.doLayout()},single:true},show:{fn:this.doLayout,single:true}},keys:[{key:[10,13],fn:function(){if(!this.isVisible()){return}if(!this.btnSearch.hidden&&!this.btnSearch.disabled){this.onSearch()}else{if(!this.btnStop.hidden&&!this.btnStop.disabled){this.onStop()}}},scope:this}]};return d},setComboBoxValue:function(b,a){this.frameAnimation(b.el,this.defaultAnimation);if(b.setMultiValue){b.setMultiValue(a.split(","))}},getComboBoxValue:function(b){var a=this.getForm().findField(b);return a.getMultiValue?a.getMultiValue().toString():a.getValue()},createTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" ext:qtip="{displayText:htmlEncode}">',"{displayText:htmlEncode}","</div>","</tpl>")},logSelect:function(c,a,b){this.setComboBoxValue(c,c.getValue())},createKeyword:function(){return[{xtype:"syno_displayfield",value:_T("log","attr_keyword")+_T("common","colon"),flex:1},{xtype:"syno_textfield",msgTarget:"qtip",validateOnBlur:true,validationEvent:"blur",name:"keyword",flex:2,vaule:""}]},setDate:function(c,b,a){if(a===true){this.frameAnimation(this.form.findField("searchdatefrom").el,this.defaultAnimation);this.frameAnimation(this.form.findField("searchdateto").el,this.defaultAnimation)}this.form.findField("searchdatefrom").setMaxValue(b);this.form.findField("searchdateto").setMinValue(c);this.form.findField("searchdatefrom").setValue(c);this.form.findField("searchdateto").setValue(b)},getFromToDate:function(c){var e,d,b=new Date();if(c===this.dateType.today){e=b;d=b}else{if(c===this.dateType.yesterday){e=b.add(Date.DAY,-1);d=e}else{if(c===this.dateType.lastweek){var a=b.getDay();e=b.add(Date.DAY,-7-a);d=e.add(Date.DAY,6)}else{if(c===this.dateType.lastmonth){b=b.add(Date.MONTH,-1);e=b.getFirstDateOfMonth();d=b.getLastDateOfMonth()}}}}return{from:e,to:d}},friendlyDateSelect:function(c,e,a){var b=e.get("id"),d=this.getFromToDate(b);this.setDate(d.from,d.to,true)},getFriendlyDateStore:function(){var a=this.dataRange;return new Ext.data.ArrayStore({autoDestroy:true,fields:["id","displayText"],data:a})},createFriendlyDate:function(){this.FriendlyDate=new SYNO.ux.ComboBox({mode:"local",editable:false,name:"dateRange",tpl:this.createTpl(),resizable:true,store:this.getFriendlyDateStore(),displayField:"displayText",valueField:"id",triggerAction:"all",lazyRender:true,flex:6,value:this.dateType.custom,listeners:{scope:this,beforequery:function(a){delete a.combo.lastQuery},beforeselect:this.friendlyDateSelect}});return[{xtype:"syno_displayfield",value:_T("log","date_range")+_T("common","colon"),flex:1},this.FriendlyDate]},createCustDate:function(){this.DateFrom=new SYNO.ux.DateField({name:"searchdatefrom",editable:false,format:"m/d/Y",emptyText:_T("log","date_from"),value:"",listeners:{scope:this,select:function(b,a){this.form.findField("searchdateto").setMinValue(a)}}});this.DateTo=new SYNO.ux.DateField({name:"searchdateto",editable:false,format:"m/d/Y",emptyText:_T("log","date_to"),value:"",listeners:{scope:this,select:function(b,a){this.form.findField("searchdatefrom").setMaxValue(a)}}});return[{xtype:"syno_displayfield",value:_T("time","time_date")+_T("common","colon")},{xtype:"syno_compositefield",hideLabel:true,defaults:{flex:1},defaultMargins:"0 8 0 0",items:[this.DateFrom,this.DateTo]}]},getLogLevelStore:function(){var a=this.logLevel.slice(0,this.logLevel.length);if(a.length>1){a.splice(0,0,["",_T("log","log_all")])}return new Ext.data.ArrayStore({autoDestroy:true,fields:["value","displayText"],data:a})},createLevel:function(){this.LogLevel=new SYNO.ux.ComboBox({xtype:"syno_combobox",mode:"local",editable:false,name:"logLevel",tpl:this.createTpl(),resizable:true,store:this.getLogLevelStore(),displayField:"displayText",valueField:"value",triggerAction:"all",lazyRender:true,flex:3,value:"",listeners:{scope:this,beforequery:function(a){delete a.combo.lastQuery},select:this.logSelect}});return[{xtype:"syno_displayfield",name:"logLevelLabel",value:_T("log","logattr")+_T("common","colon"),flex:1},this.LogLevel]},hideItems:function(b){var c;if(!Ext.isArray(b)){b=[b]}for(var a=b.length-1;a>=0;a--){c=this.form.findField(b[a]);if(c){c.setVisible(false)}}},frameAnimation:function(a,b){if(a&&a.isVisible()){Ext.Element.prototype.frame.apply(a,b)}},defineBehaviors:function(){var a=this.get("btns");this.btnSearch=a.get("btn_search");this.btnStop=a.get("btn_stop")},setMsg:function(c){var a=this.get("btns");var b=a.get("msg");b.setText(c);if(c.trim()!==""){this.frameAnimation(b.el,this.defaultAnimation)}},setKeyWord:function(a){var b=this.form.findField("keyword");if(b&&Ext.isString(a)){b.setValue(a)}b.focus("",1)},onShowHideBtn:function(a){if(a){this.btnSearch.hide();this.btnStop.show()}else{this.btnSearch.show();this.btnStop.hide()}},onEnableDisableBtn:function(a){if(a){this.btnSearch.enable();this.btnStop.enable()}else{this.btnSearch.disable();this.btnStop.disable()}},isOwnerDestroyed:function(){return(this.owner&&this.owner.isDestroyed)},showMsg:function(b,a){if(!this.isOwnerDestroyed()){this.owner.getMsgBox().alert(b,a)}},hideMsg:function(){if(!this.isOwnerDestroyed()){this.owner.getMsgBox().hide()}},isFieldDirty:function(a){return this.form.findField(a).isDirty()},validateForm:function(){if(!this.form.isValid()){return false}return this.isFieldDirty("searchdatefrom")||this.isFieldDirty("searchdateto")||this.isFieldDirty("keyword")},onSearch:function(c,f){var d,b,i,h,a;var g;d=this.getForm();b=d.findField("keyword").getValue();i=d.findField("searchdatefrom").getRawValue();h=d.findField("searchdateto").getRawValue();a=this.getComboBoxValue("logLevel");g={filter:{keyword:b,loglevel:a,datefrom:i?new Date(i+" 00:00:00").getTime()/1000:0,dateto:h?new Date(h+" 23:59:59").getTime()/1000:0}};this.fireEvent("search",this,g)},onReset:function(){this.form.items.each(function(a){if(a.isDirty()){this.frameAnimation(a.el,this.defaultAnimation)}},this);this.setMsg("");this.form.reset();this.form.findField("searchdatefrom").setMaxValue(null);this.form.findField("searchdateto").setMinValue(null);this.form.findField("logLevel").multiValue="";this.onSearch()}});Ext.define("SYNO.SDS.ResourceMonitor.Util.TextItem",{extend:"Ext.Toolbar.TextItem",onRender:function(b,a){this.autoEl={cls:"xtb-text",html:this.text||"","ext:qtip":this.text||""};SYNO.SDS.ResourceMonitor.Util.TextItem.superclass.onRender.call(this,b,a)},setText:function(a){SYNO.SDS.ResourceMonitor.Util.TextItem.superclass.setText.call(this,a);if(this.rendered){this.el.set({"ext:qtip":a})}}});Ext.reg("lctbtext",SYNO.SDS.ResourceMonitor.Util.TextItem);Ext.ns("SYNO.SDS.ResourceMonitor.EventRule");SYNO.SDS.ResourceMonitor.EventRule.Events={getByType:function(a){var b;switch(a){case 1:b=this.Service;break;case 2:b=this.iSCSI;break;case 3:b=this.Volume;break;case 0:b=this.System;break;default:b=this.System;break}return b},System:{Strings:{0:_T("rsrcmonitor","perf_desc_cpu"),1:String.format(_T("rsrcmonitor","perf_desc_load_avg"),"1 "+_T("rsrcmonitor","minute"),"{1}","{2}"),2:String.format(_T("rsrcmonitor","perf_desc_load_avg"),"5 "+_T("rsrcmonitor","minutes"),"{1}","{2}"),3:String.format(_T("rsrcmonitor","perf_desc_load_avg"),"15 "+_T("rsrcmonitor","minutes"),"{1}","{2}"),4:_T("rsrcmonitor","perf_desc_memory")},Units:{0:"%",1:"",2:"",3:"",4:"%"},DefVal:{0:80,1:10,2:10,3:10,4:80},MinMax:{0:[60,99],1:[1,1000],2:[1,1000],3:[1,1000],4:[1,99]},Resource:[[0,_T("router_overview","cpu_utilization")],[1,String.format(_T("rsrcmonitor","cpu_load_avg"),"1 "+_T("rsrcmonitor","minute"))],[2,String.format(_T("rsrcmonitor","cpu_load_avg"),"5 "+_T("rsrcmonitor","minutes"))],[3,String.format(_T("rsrcmonitor","cpu_load_avg"),"15 "+_T("rsrcmonitor","minutes"))],[4,_T("router_overview","memory_utilization")]]},Service:{Strings:{0:_T("rsrcmonitor","perf_desc_serv_cpu"),4:_T("rsrcmonitor","perf_desc_serv_memory"),5:_T("rsrcmonitor","perf_desc_serv_disk")},Units:{0:"%",4:"MB",5:"MB/s"},DefVal:{0:80,4:10,5:10},MinMax:{0:[60,99],4:[1,524288],5:[1,65536]},Resource:[[0,_T("router_overview","cpu_utilization")],[4,_T("router_overview","memory_utilization")],[5,_T("rsrcmonitor","disk_io_utilization")]]},iSCSI:{Strings:{6:_T("rsrcmonitor","perf_desc_iscsi_network"),7:_T("rsrcmonitor","perf_desc_iscsi_disk")},Units:{6:"ms",7:"ms"},DefVal:{6:100,7:100},MinMax:{6:[10,60000],7:[10,60000]},Resource:[[6,_T("rsrcmonitor","network_latency")],[7,_T("rsrcmonitor","io_latency")]]},Volume:{Strings:{5:_T("rsrcmonitor","perf_desc_volume")},Units:{5:"%"},DefVal:{5:80},MinMax:{5:[1,99]},Resource:[[5,_T("rsrcmonitor","disk_io_utilization")]]}};Ext.define("SYNO.SDS.ResourceMonitor.EventRule.EventDialog",{extend:"SYNO.SDS.ModalWindow",SUPPORT_SERVICE_WEBAPI:"SYNO.Core.System.ProcessGroup",event_data:null,load_record:false,constructor:function(b){this.panel=this.createPanel();this.applyBtn=new SYNO.ux.Button({btnStyle:"blue",text:_T("common","alt_apply"),scope:this,handler:this.onApply});var a={dsmStyle:"v5",width:500,height:460,resizable:false,title:b.title,items:[this.panel],buttons:[this.applyBtn,{btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.close}]};Ext.apply(a,b);this.callParent([a]);this.defineBehaviors()},defineBehaviors:function(){var a;a=new SYNO.ux.Utils.EnableRadioGroup(this.panel.getForm(),"type",{0:["system"],1:["service_name"],2:["iSCSI_lun"],3:["volume"]})},createPanel:function(){var c=new Ext.data.JsonStore({autoDestroy:true,idProperty:"value",fields:["value",{name:"display",sortType:"asNaturalUCString"},"desc"],data:[[0,0]],sortInfo:{field:"display",direction:"ASC"}});var b=new Ext.data.JsonStore({autoDestroy:true,idProperty:"value",fields:["value",{name:"display",sortType:"asNaturalUCString"}],data:[[0,0]],sortInfo:{field:"display",direction:"ASC"}});var e=new Ext.data.JsonStore({autoDestroy:true,idProperty:"value",fields:["value",{name:"display",sortType:"asNaturalUCString"}],data:[[0,0]],sortInfo:{field:"display",direction:"ASC"}});var d=new Ext.data.JsonStore({autoDestroy:true,idProperty:"value",fields:["value","display"],data:[[0,0]]});var a={border:false,width:480,height:420,webapi:{api:"SYNO.ResourceMonitor.EventRule",methods:{set:"set"},version:1},items:[{xtype:"syno_textfield",name:"id",value:"",allowBlank:true,hidden:true},{xtype:"syno_fieldset",title:_T("rsrcmonitor","performance_event_type"),items:[{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_radio",boxLabel:_T("rsrcmonitor","cpu_system"),name:"type",inputValue:"0",width:172,checked:true,listeners:{scope:this,check:this.onEventTypeChange}},{xtype:"syno_textfield",name:"system",value:"general",hidden:true}]},{xtype:"syno_compositefield",hideLabel:true,hidden:(!SYNO.API.GetKnownAPI(this.SUPPORT_SERVICE_WEBAPI))?true:false,items:[{xtype:"syno_radio",boxLabel:_T("connections","service"),width:172,name:"type",inputValue:"1",listeners:{scope:this,check:this.onEventTypeChange}},{xtype:"syno_combobox",width:200,name:"service_name",store:e,displayField:"display",valueField:"value",tpl:'<tpl for="."><div ext:qtip="{display}" class="x-combo-list-item">{display}</div></tpl>',allowBlank:false}]},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_radio",boxLabel:_T("tree","leaf_iscsilun"),width:172,name:"type",inputValue:"2",listeners:{scope:this,check:this.onEventTypeChange}},{xtype:"syno_combobox",width:200,name:"iSCSI_lun",store:b,displayField:"display",valueField:"value",tpl:'<tpl for="."><div ext:qtip="{display}" class="x-combo-list-item">{display}</div></tpl>',allowBlank:false}]},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_radio",boxLabel:_T("tree","leaf_volume"),width:172,name:"type",inputValue:"3",listeners:{scope:this,check:this.onEventTypeChange}},{xtype:"syno_storage_combobox",width:200,name:"volume",store:c,displayField:"display",valueField:"value",descriptionField:"desc",triggerAction:"all",editable:false,grow:true,allowBlank:false}]}]},{xtype:"syno_combobox",fieldLabel:_T("rsrcmonitor","performance_event_resource"),name:"resource",store:d,displayField:"display",valueField:"value",tpl:'<tpl for="."><div ext:qtip="{display}" class="x-combo-list-item">{display}</div></tpl>',value:0,listeners:{scope:this,select:this.onResourceSelect}},{xtype:"syno_compositefield",hideLabel:false,items:[{xtype:"syno_numberfield",width:200,fieldLabel:_T("rsrcmonitor","performance_event_threshold"),name:"threshold",minValue:60,maxValue:99,value:80,allowBlank:false},{xtype:"syno_displayfield",name:"unit",value:"%"}]},{xtype:"syno_combobox",fieldLabel:_T("log","logattr"),store:[[0,_T("log","warn_level")],[1,_T("log","crit_level")]],name:"severity",value:0},{xtype:"syno_checkbox",name:"enable",boxLabel:_T("common","enabled")}],processParams:this.processParams,setStatusError:this.setStatusError.createDelegate(this),setStatusBusy:this.setStatusBusy.createDelegate(this),setStatusOK:this.setStatusOK.createDelegate(this),clearStatusBusy:this.clearStatusBusy.createDelegate(this),processReturnData:this.processReturnData};return new SYNO.SDS.Utils.FormPanel(a)},loadData:function(){var a=[{api:"SYNO.Core.Storage.Volume",version:1,method:"list",params:{offset:0,limit:-1,location:"internal"}},{api:"SYNO.Core.ISCSI.LUN",version:1,method:"list",params:{additional:["storage_manager"]}}];if(this.IsKnownAPI(this.SUPPORT_SERVICE_WEBAPI)){a.push({api:this.SUPPORT_SERVICE_WEBAPI,version:1,method:"service_info",params:{"grouping-bultin":false}})}this.sendWebAPI({params:{},compound:{stopwhenerror:false,params:a},callback:function(g,f,e){this.clearStatusBusy();if(g&&!f.has_fail){this.processData(f)}else{this.getMsgBox().alert("",_T("common","commfail"),null,this)}},scope:this});var d=this.panel.getForm().findField("resource");var b=d.getStore();var c=SYNO.SDS.ResourceMonitor.EventRule.Events.getByType(0);b.loadData(c.Resource.map(function(e){return{value:e[0],display:e[1]}}));if(b.getCount()>0){d.setValue(b.getAt(0).get("value"))}},onApply:function(){var a=this.panel.getForm();if(!a.isValid()){this.setStatusError({text:_T("common","forminvalid"),clear:true});return false}if(!this.event_data){this.panel.checkFormDirty=false}this.panel.applyHandler()},onOpen:function(){this.setStatusBusy();this.loadData();this.callParent(arguments)},close:function(){var a=this.panel.getForm();if(!this.panel.checkFormDirty||!a.isDirty()){this.superclass().close.call(this);return}this.getMsgBox().confirm("",_T("common","confirm_lostchange"),function(b){if("yes"!==b){return}this.superclass().close.call(this)},this)},onClose:function(){this.grid.loadData()},onEventTypeChange:function(b,a){if(!a){return}var c=b.getInputValue();this.changeResourceAndUnits(parseInt(c,10))},onResourceSelect:function(c,g,a){var f=c.getValue();var d=this.panel.getForm().findField("unit");var b=this.panel.getForm().getValues().type;var e=SYNO.SDS.ResourceMonitor.EventRule.Events.getByType(parseInt(b,10));d.setValue(e.Units[f]);this.changeThresholdDefMinMax(b,f)},processData:function(f){var e=SYNO.API.Util.GetValByAPI(f,"SYNO.Core.Storage.Volume","list");var k=SYNO.API.Util.GetValByAPI(f,"SYNO.Core.ISCSI.LUN","list");var g=this.panel.getForm().findField("volume");var j=g.getStore();if(e.volumes&&e.total){j.removeAll();j.loadData(e.volumes.map(function(l){return{value:l.volume_path,display:SYNO.SDS.Utils.StorageUtils.VolumeNameRenderer(l),desc:Ext.util.Format.htmlEncode(l.description)}}));if(j.getCount()>0){g.setValue(j.getAt(0).get("value"))}}var i=this.panel.getForm().findField("iSCSI_lun");var h=i.getStore();if(k.luns){h.removeAll();h.loadData(k.luns.map(function(l){return{value:l.uuid,display:l.name}}));if(h.getCount()>0){i.setValue(h.getAt(0).get("value"))}}if(this.IsKnownAPI(this.SUPPORT_SERVICE_WEBAPI)){var a=SYNO.API.Util.GetValByAPI(f,this.SUPPORT_SERVICE_WEBAPI,"service_info");var d=this.panel.getForm().findField("service_name");var c=d.getStore();if(a.services){c.removeAll();c.loadData(a.services.map(function(n){var m=n.display_name;var l=m.split(":");if(l.length>1){m=_T(l[0],l[1])}return{value:n.name,display:m}}));if(c.getCount()>0){d.setValue(c.getAt(0).get("value"))}}}var b=this.panel.getForm();if(null!==this.event_data){this.load_record=true;this.changeResourceAndUnits(this.event_data.type);switch(this.event_data.type){case 0:this.event_data.system=this.event_data.service;break;case 1:this.event_data.service_name=this.event_data.service;break;case 2:this.event_data.iSCSI_lun=this.event_data.service;break;case 3:this.event_data.volume=this.event_data.service;break}this.event_data.type=this.event_data.type.toString();b.setValues(this.event_data);this.changeThresholdDefMinMax(this.event_data.type,this.event_data.resource);this.load_record=false}},changeResourceAndUnits:function(f){var d=this.panel.getForm().findField("resource");var b=d.getStore();var c=this.panel.getForm().findField("unit");var a;var e=SYNO.SDS.ResourceMonitor.EventRule.Events.getByType(parseInt(f,10));b.loadData(e.Resource.map(function(g){return{value:g[0],display:g[1]}}));if(b.getCount()>0){d.setValue(b.getAt(0).get("value"))}if(!this.load_record){a=e.Resource[0][0];d.setValue(a);d.originalValue=a}else{a=this.event_data.resource}c.setValue(e.Units[a]);c.originalValue=e.Units[a];this.changeThresholdDefMinMax(f,a)},changeThresholdDefMinMax:function(b,d){var a=this.panel.getForm().findField("threshold");var c=SYNO.SDS.ResourceMonitor.EventRule.Events.getByType(parseInt(b,10));a.setMinValue(c.MinMax[d][0]);a.setMaxValue(c.MinMax[d][1]);if(!this.load_record){a.setValue(c.DefVal[d])}},processParams:function(b,a){if("set"===b){if(0===a[0].params.id.length){delete a[0].params.id}a[0].params.type=parseInt(a[0].params.type,10);a[0].params.threshold=parseInt(a[0].params.threshold,10);a[0].params.service=a[0].params.volume||a[0].params.iSCSI_lun||a[0].params.service_name||a[0].params.system;delete a[0].params.volume;delete a[0].params.iSCSI_lun;delete a[0].params.service_name;delete a[0].params.system;a.pop()}return a},processReturnData:function(e,d,c){var a=this.getApiArray(e);if("set"===e){if(this.isDestroyed){return}if(d.has_fail){var b=SYNO.API.Util.GetValByAPI(d,a[0].api,a[0].method);if(6106===b.code){this.ownerCt.getMsgBox().alert("",_T("rsrcmonitor","performance_event_rule_exist"),null,this)}else{this.ownerCt.getMsgBox().alert("",_T("common","commfail"),function(){this.checkFormDirty=false;this.ownerCt.close()},this)}}else{this.checkFormDirty=false;this.ownerCt.applyBtn.setDisabled(true);this.ownerCt.close.defer(1000,this.ownerCt)}}}});Ext.define("SYNO.SDS.ResourceMonitor.EventRule.Main",{extend:"SYNO.ux.EditorGridPanel",needMask:false,pageSize:50,actions:null,constructor:function(b){this.store=this.createStore(b);this.toolBar=this.createTBar();var a={itemId:"log",store:this.store,colModel:this.configColumnModel(),tbar:this.toolBar,bbar:new SYNO.ux.PagingToolbar({store:this.store,displayInfo:true,pageSize:this.pageSize}),selModel:new Ext.grid.RowSelectionModel(),plugins:[this.enableColumn]};Ext.apply(a,b);this.callParent([Ext.apply(a)]);this.mon(this.enableColumn,"selectall",this.saveBtnStatus,this);this.mon(this.getSelectionModel(),"selectionchange",this.selectionChange,this);this.mon(this,"rowdblclick",this.btnEdit,this)},createStore:function(a){var b=this;var c=new SYNO.API.Store({api:"SYNO.ResourceMonitor.EventRule",version:"1",method:"list",appWindow:a.appWin,listeners:{scope:b,beforeload:function(){this.appWin.setStatusBusy({text:_T("common","loading")})},load:function(){this.saveBtnStatus();this.appWin.clearStatusBusy()},update:function(){this.saveBtnStatus()}},reader:new Ext.data.JsonReader({idProperty:"id",root:"rules"},["enable","id","severity","name","resource","service","threshold","type"]),remoteSort:false,sortInfo:{field:"id",direction:"DESC"},autoDestroy:true,pruneModifiedRecords:true});return c},createTBar:function(){this.actions={add:new Ext.Action({itemId:"add",text:_T("common","create"),handler:this.btnAdd,scope:this}),edit:new Ext.Action({itemId:"edit",text:_T("common","alt_edit"),handler:this.btnEdit,disabled:true,scope:this}),del:new Ext.Action({itemId:"delete",text:_T("common","delete"),handler:this.btnDel,disabled:true,scope:this}),save:new Ext.Action({itemId:"save",text:_T("common","save"),handler:this.btnSave,scope:this})};return new SYNO.ux.Toolbar({items:[this.actions.add,this.actions.edit,this.actions.del,this.actions.save]})},configColumnModel:function(){this.enableColumn=new SYNO.ux.EnableColumn({header:_T("common","enabled"),dataIndex:"enable",width:90,align:"center",sortable:false,enableFastSelectAll:true});var a=new Ext.grid.ColumnModel({columns:[this.enableColumn,{header:_T("connections","service"),dataIndex:"name",width:100,align:"left",renderer:this.renderService.createDelegate(this)},{header:_T("log","logattr"),dataIndex:"severity",width:60,align:"left",renderer:this.renderSeverity},{header:_T("log","log_action"),dataIndex:"event",width:200,align:"left",sortable:false,renderer:this.renderEvent.createDelegate(this)}],defaults:{sortable:true,menuDisabled:false}});return a},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Top.Main.superclass.initEvents.apply(this,arguments);a.mon(a,"activate",a.onActivate,a);a.mon(a.appWin,"server_change",a.onServerChange,a)},onServerChange:function(){this.store.removeAll()},onActivate:function(a){if(a&&a.targetReady){this.mon(this.store,"load",this.clearStatusLoading,this,{single:true})}if(this.needMask){this.getEl().mask(_T("rsrcmonitor","performance_event_enable_warning"),"syno-ux-mask-info")}else{this.getEl().unmask()}},loadData:function(){this.store.removeAll();this.store.load();this.getAction("save").disable()},setStatusLoading:function(){this.appWin.setStatusLoading()},clearStatusLoading:function(){this.appWin.clearStatusLoading()},getAction:function(a){if(a in this.actions){return this.actions[a]}else{SYNO.Debug("no this action: "+a);return undefined}},parseServiceName:function(b,d){var a=d.split(":");var c;switch(b){case 1:if(a.length>1){c=_T(a[0],a[1])}else{c=d}break;case 2:c="iSCSI LUN - "+d;break;case 3:c=SYNO.SDS.Utils.StorageUtils.VolumeNameRenderer(d);break;case 0:c=_T("rsrcmonitor","cpu_system");break;default:c=d;break}return c},renderService:function(d,a,c){var b=this.parseServiceName(c.get("type"),d);return'<div ext:qtip="'+b+'">'+Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(b))+"</div>"},renderSeverity:function(b){var a=(0===b)?_T("log","warn_level"):_T("log","crit_level");switch(b){case 0:return'<div style="color:#FFA500;" ext:qtip="'+a+'">'+a+"</div>";case 1:return'<div style="color:red;" ext:qtip="'+a+'">'+a+"</div>";default:return a}},renderEvent:function(b,g,d){var h=d.get("type");var c=d.get("resource");var e=SYNO.SDS.ResourceMonitor.EventRule.Events.getByType(h);var j=e.Strings[c];var i=e.Units[c];var a="";var f;switch(h){case 0:break;case 1:a=this.parseServiceName(h,d.get("name"));break;case 2:a=d.get("name");break;case 3:a=this.parseServiceName(h,d.get("name"));break}f=String.format(j,a,d.get("threshold"),i);return'<div ext:qtip="'+f+'">'+f+"</div>"},btnAdd:function(){var a=new SYNO.SDS.ResourceMonitor.EventRule.EventDialog({owner:this.appWin,module:this.appWin,title:_T("rsrcmonitor","add_performance_event_rule"),grid:this});a.open()},btnEdit:function(){var c=this.getSelectionModel();var b=c.getSelections();if(1!=b.length){return false}var a=new SYNO.SDS.ResourceMonitor.EventRule.EventDialog({owner:this.appWin,module:this.appWin,grid:this,title:_T("rsrcmonitor","edit_performance_event_rule"),event_data:b[0].data});a.open()},btnDel:function(){var c=this.getSelectionModel();var b=c.getSelections();var a=[];Ext.each(b,function(d){a.push(d.id)});this.appWin.getMsgBox().confirmDelete("",_T("app_port_alias","confirm_delete_proxy"),function(d){if("yes"!==d){return}this.appWin.setStatusBusy();this.sendWebAPI({api:"SYNO.ResourceMonitor.EventRule",method:"delete",version:1,params:{id_list:a},callback:function(g,f,e){this.appWin.clearStatusBusy();if(!g){this.appWin.getMsgBox().alert("",_T("common","commfail"),null,this);return}this.loadData()},scope:this})},this)},getOnOffWebapiParams:function(){var b=this.getStore().getModifiedRecords();var a=[];if(0===b.length){return a}Ext.each(b,function(c){a.push({id:c.id,enable:c.get("enable")})});return a},btnSave:function(){var a=this.getOnOffWebapiParams();if(0===a.length){return}this.appWin.setStatusBusy();this.sendWebAPI({api:"SYNO.ResourceMonitor.EventRule",method:"onoff",version:1,params:{id_list:a},callback:function(d,c,b){this.appWin.clearStatusBusy();if(!d){this.appWin.getMsgBox().alert("",_T("common","commfail"),null,this);return}this.loadData()},scope:this})},saveBtnStatus:function(){if(0===this.getStore().getModifiedRecords().length){this.getAction("save").disable()}else{this.getAction("save").enable()}},selectionChange:function(){var b=this.getSelectionModel();var a=b.getSelections();if(0!==a.length){this.getAction("del").enable()}else{this.getAction("del").disable()}if(1===a.length){this.getAction("edit").enable()}else{this.getAction("edit").disable()}}});Ext.define("SYNO.SDS.ResourceMonitor.Setting.Tab",{extend:"SYNO.SDS.Utils.TabPanel",constructor:function(b){var a=Ext.apply({activeTab:0,useDefaultBtn:false,items:[new SYNO.SDS.ResourceMonitor.Setting.Main({itemId:"basic_setting",appWin:b.appWin,title:_T("common","common_settings"),tabParent:this}),new SYNO.SDS.ResourceMonitor.EventRule.Main({itemId:"event_rule",appWin:b.appWin,title:_T("rsrcmonitor","performance_event_rule")})]},b);return this.callParent([Ext.apply(a)])},onPageDeactivate:function(){if(!this.checkFormDirty){return true}else{if(0!==this.items.map.event_rule.store.getModifiedRecords().length){return false}if(this.isAnyFormDirty()){return false}}},onPageActivate:function(){var a=this.items.map.basic_setting;var b=a.getComponent("enable_event");this.items.map.event_rule.loadData();if(b.getValue()){this.setEventRulePageUnamsk()}else{this.setEventRulePageMask()}},setEventRulePageMask:function(){var a=this.items.map.basic_setting.getComponent("enable_event");if(!a.isDirty()){this.items.map.event_rule.needMask=true}},setEventRulePageUnamsk:function(){var a=this.items.map.basic_setting.getComponent("enable_event");if(!a.isDirty()){this.items.map.event_rule.needMask=false}},setStatusLoading:function(a){if(true===this.isStatusLoading){return}a=a||{};Ext.applyIf(a,{text:_T("common","loading"),iconCls:"x-mask-loading"});this.isStatusLoading=true;this.getEl().mask(a.text,a.iconCls)},clearStatusLoading:function(){if(true!==this.isStatusLoading){return}this.getEl().unmask();this.isStatusLoading=false},applySetting:function(){var b=this.items.map.basic_setting;var d=this.items.map.event_rule;var a=d.getOnOffWebapiParams();var e=[];if(0!==a.length){e.push({api:"SYNO.ResourceMonitor.EventRule",version:1,method:"onoff",params:{id_list:a}})}var c=b.getWebapiParams();e.push({api:"SYNO.ResourceMonitor.Setting",method:"set",version:1,params:c});e.push({api:"SYNO.ResourceMonitor.Setting",method:"get",version:1});this.sendWebAPI({compound:{params:e},scope:this,callback:function(f,h,i,g){this.checkFormDirty=false;b.onActionComplete(f,h,i,g)}})}});Ext.define("SYNO.SDS.ResourceMonitor.Factory",{statics:{CurConnPanel:function(a){return new SYNO.SDS.ResourceMonitor.CurConn(a).getPanel()}}});Ext.define("SYNO.SDS.ResourceMonitor.CurConn",{extend:"Ext.util.Observable",itemsPerPage:50,lstLog:null,firstActivated:true,appInst:null,grid:null,constructor:function(b){this.topwin=b.appWin;this.appInst=b.appWin.appInstance;this.callParent(arguments);this.searchField=new SYNO.ux.TextFilter({itemId:"search",queryParam:"filter",emptyText:_T("connections","search_connections"),store:this.getCurConnStore(),pageSize:this.itemsPerPage,disabled:true});var a=new Ext.Toolbar({defaultType:"syno_button"});a.add({text:_T("log","log_save"),itemId:"bt_save",handler:this.onLogSave,scope:this,disabled:true},{text:_T("log","log_reload"),itemId:"bt_refresh",handler:function(){this.paging.doRefresh()},scope:this,disabled:true},{text:_T("connections","kick_connection_br"),itemId:"bt_kick",disabled:true,handler:this.kickConnection,scope:this},{text:_T("connections","disable_this_account"),itemId:"bt_disable_account",disabled:true,handler:this.disableUser,scope:this},"->",this.searchField);this.paging=new SYNO.ux.PagingToolbar({store:this.getCurConnStore(),displayInfo:true,pageSize:this.itemsPerPage,refreshText:_T("log","log_reload")});var c=new SYNO.ux.GridPanel({itemId:"curconn",title:_T("connections","connections_title"),store:this.getCurConnStore(),colModel:this.getCurrConCM(),tbar:a,bbar:this.paging,sm:new Ext.grid.RowSelectionModel({listeners:{selectionchange:{fn:this.updateToolBarBts,scope:this,buffer:80}}}),autoExpandColumn:"descr",loadMask:true,stripeRows:true,listeners:{scope:this,activate:function(f){if(this.topwin.hasOpenConfig("is_cms_open")||(f&&f.targetReady)){var e=this.topwin.getTargetData();if(0>e.id){return}else{if(0===e.id){this.topwin.openConfig.cms_id=undefined}else{this.topwin.openConfig.cms_id=e.id}}}var d=this.grid.getTopToolbar();d.getComponent("bt_save").enable();d.getComponent("bt_refresh").enable();this.searchField.enable();this.onLoad()}}});this.grid=c;c.mon(c,"rowcontextmenu",this.showGridCtxMenu,this)},onLoad:function(){var a=this.grid.getStore();a.removeAll();a.load({params:{start:0,limit:this.itemsPerPage}})},onLogSave:function(){if(_S("demo_mode")){this.topwin.getMsgBox().alert(this.topwin.title,_JSLIBSTR("uicommon","error_demo"));return}var a=this.grid.getStore();this.topwin.downloadWebAPI({webapi:{api:"SYNO.Core.CurrentConnection",method:"download",version:1,params:{sort_by:a.sortInfo.field,sort_direction:a.sortInfo.direction,filter:a.lastOptions.params.filter}}})},getPanel:function(){return this.grid},getCurConnStore:function(){if(this.dsCurCon){return this.dsCurCon}var a=new SYNO.API.Store({autoLoad:false,api:"SYNO.Core.CurrentConnection",method:"get",version:"1",appWindow:this.topwin,reader:new Ext.data.JsonReader({root:"items",totalProperty:"total"},["pid","time","who","type","descr","from","user_can_be_disabled","can_be_kicked"]),sortInfo:{field:"time",direction:"DESC"},remoteSort:true,listeners:{scope:this,beforeload:function(b,c){if(!Ext.isDefined(c.params.offset)){c.params.offset=c.params.start}if(!Ext.isDefined(c.params.start)){c.params.start=c.params.offset}},load:{fn:function(c,b,d){this.grid.getView().updateScroller()}}}});this.dsCurCon=a;this.topwin.addManagedComponent(a);return a},getCurrConCM:function(){if(this.cmCurrCon){return this.cmCurrCon}var a=new Ext.grid.ColumnModel({columns:[{header:_T("log","log_time"),dataIndex:"time",width:150,align:"center"},{header:_T("log","log_account"),dataIndex:"who",width:100,align:"center",renderer:this.whoRender},{header:_T("log","log_client"),dataIndex:"from",width:200,align:"center"},{header:_T("common","connection_method"),dataIndex:"type",width:150,align:"center"},{id:"descr",header:_T("log","log_resource"),dataIndex:"descr",width:300,align:"left",renderer:this.htmlEncodeRender}],defaults:{sortable:true,menuDisabled:true}});this.cmCurrCon=a;return a},htmlEncodeRender:function(c,b){var a=Ext.util.Format.htmlEncode(c);b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(a)+'"';return a},whoRender:function(b,a){if(b.empty()){return"-"}return b},showGridCtxMenu:function(a,d,b){b.preventDefault();var c=a.getSelectionModel();if(!c.isSelected(d)){c.selectRow(d)}this.getGridCtxMenu().showAt(b.getXY())},getGridCtxMenu:function(){if(!this.CurrConRowCtxMenu){this.CurrConRowCtxMenu=new SYNO.ux.Menu({itemId:"adminCtxMenu",ignoreParentClicks:"true",items:[{itemId:"kick_conn",text:_T("connections","kick_connection"),handler:this.kickConnection,scope:this},{itemId:"disable_account",text:_T("connections","disable_this_account"),handler:this.disableUser,scope:this}]});this.topwin.addManagedComponent(this.CurrConRowCtxMenu)}return this.CurrConRowCtxMenu},kickConnection:function(){var f=this.grid.getSelectionModel();var d=f.getSelections();if(0===d.length){return}var c=[];var a=[];var e=false;for(var b=0;b<d.length;++b){if("HTTP/HTTPS"===d[b].get("type")){a.push({who:d[b].get("who"),from:d[b].get("from")})}else{c.push({pid:d[b].get("pid"),type:d[b].get("type"),who:d[b].get("who"),from:d[b].get("from")})}if(_S("user")===d[b].get("who")){e=true}}if(e){this.topwin.getMsgBox().confirm(_T("connections","connections_title"),_T("connections","confirm_kick_self"),function(g,h){if(g==="yes"){this.doKickConnection(c,a)}},this)}else{this.doKickConnection(c,a)}},doKickConnection:function(b,a){this.grid.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.topwin.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"kick_connection",timeout:450000,params:{service_conn:b,http_conn:a},version:1,scope:this,callback:function(c,d){this.grid.getEl().unmask();if(!c){this.topwin.getMsgBox().alert("",SYNO.API.Erros.core[d.code]||_T("common","commfail"))}else{this.paging.doRefresh()}}})},disableUser:function(){var d=this.grid.getSelectionModel();var b=d.getSelections();if(0===b.length){return}var c=[];for(var a=0;a<b.length;++a){if(_S("user")===b[a].get("who")||false===b[a].get("user_can_be_disabled")){continue}c.push(b[a].get("who"))}if(0===c.length){return}this.grid.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.topwin.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"disable_user",timeout:450000,params:{users:c},version:1,scope:this,callback:function(e,f){this.grid.getEl().unmask();if(!e){this.topwin.getMsgBox().alert("",SYNO.API.Erros.core[f.code]||_T("common","commfail"))}else{this.paging.doRefresh()}}})},updateToolBarBts:function(b){var d=0;var k=b.getSelections();var g=this.grid.getTopToolbar();var c=g.getComponent("bt_kick");var e=this.getGridCtxMenu().get("kick_conn");var h=g.getComponent("bt_disable_account");var j=this.getGridCtxMenu().get("disable_account");var a=true;var f=true;c.disable();e.disable();h.disable();j.disable();if(0===k.length||_S("demo_mode")){return}for(d=0;d<k.length;++d){if(_S("user")===k[d].get("who")||false===k[d].get("user_can_be_disabled")){f=false;break}}for(d=0;d<k.length;++d){if(false===k[d].get("can_be_kicked")){a=false;break}}if(f){h.enable();j.enable()}if(a){c.enable();e.enable()}}});Ext.define("SYNO.SDS.ResourceMonitor.Log.Main",{extend:"SYNO.ux.GridPanel",pageSize:100,constructor:function(b){this.store=this.createStore(b);this.searchPanel=this.initSearchForm();this.toolBar=this.createTBar();this.bottomBar=this.createBBar();var a={text:_T("rsrcmonitor","performance_event"),itemId:"log",store:this.store,colModel:this.configColumnModel(),tbar:this.toolBar,bbar:this.bottomBar,viewConfig:{forceFit:true,onLoad:Ext.emptyFn,listeners:{}}};Ext.apply(a,b);return this.callParent([Ext.apply(a)])},initSearchForm:function(){var a=new SYNO.SDS.ResourceMonitor.Util.SearchFormPanel({cls:"syno-sds-fs-search-panel",renderTo:Ext.getBody(),shadow:false,hidden:true,owner:this});this.addManagedComponent(a);return a},createStore:function(a){var b=this;var c=new SYNO.API.JsonStore({api:"SYNO.ResourceMonitor.Log",version:"1",method:"list",root:"logs",autoDestroy:true,remoteSort:true,appWindow:a.appWin,baseParams:{limit:this.pageSize,offset:0},listeners:{exception:b.onException,scope:b},sortInfo:{field:"time",direction:"DESC"},fields:["time","level","event"]});return c},createTBar:function(){var c=this;var b=new SYNO.ux.Menu({items:[{text:_T("log","html_type"),itemId:"export_html",scope:this,handler:this.btnExportHTML},{text:_T("log","csv_type"),itemId:"export_csv",scope:this,handler:this.btnExportCSV}]});var a=new SYNO.ux.Toolbar({items:[new Ext.Action({itemId:"clear",text:_T("common","clean"),scope:this,handler:this.btnClear}),new SYNO.ux.SplitButton({itemId:"export",text:_T("autoblock","autoblock_export_ip_list"),scope:this,handler:this.btnExportHTML,menu:b}),"->"]});a.add(new SYNO.SDS.ResourceMonitor.Util.AdvancedSearchField({iconStyle:"filter",searchPanel:c.searchPanel,owner:c}));return a},createBBar:function(){return new SYNO.ux.PagingToolbar({store:this.store,pageSize:this.pageSize,displayInfo:true})},renderLevel:function(a){switch(a){case"Information":return"<span style='color:green;' ext:qtip='"+a+"'>"+a+"</span>";case"Warning":return"<span style='color:#FFA500;' ext:qtip='"+a+"'>"+a+"</span>";case"Critical":return"<span style='color:red;' ext:qtip='"+a+"'>"+a+"</span>";default:return a}},configColumnModel:function(){var a=new Ext.grid.ColumnModel({columns:[{header:_T("log","log_time"),dataIndex:"time",width:150,align:"left",renderer:function(b){return'<span ext:qtip="'+b+'">'+b+"</span>"}},{header:_T("log","logattr"),dataIndex:"level",width:80,align:"left",renderer:this.renderLevel},{header:_T("log","log_action"),dataIndex:"event",width:500,align:"left",renderer:function(b){return'<span ext:qtip="'+b+'">'+b+"</span>"}}],defaults:{sortable:false,menuDisabled:false}});return a},initEvents:function(){SYNO.SDS.ResourceMonitor.Top.Main.superclass.initEvents.apply(this,arguments);this.mon(this,"activate",this.onActivate,this);this.mon(this.searchPanel,"search",this.onSearch,this);this.mon(this.store,"load",this.onAfterStoreLoad,this);this.mon(this.store,"beforeload",this.onBeforeStoreLoad,this);this.mon(this.appWin,"server_change",this.onServerChange,this)},onServerChange:function(){},onActivate:function(a){if(a&&a.targetReady){this.mon(this.store,"load",this.clearStatusLoading,this,{single:true})}this.store.load()},isTheSame:function(b,a){var c;for(c in a){if(a[c]!==b[c]){return false}}return true},onSearch:function(b,c){var a=this.store;if(!this.isTheSame(a.baseParams,c)){Ext.apply(a.baseParams,c);a.load()}},setStatusLoading:function(){this.appWin.setStatusLoading()},clearStatusLoading:function(){this.appWin.clearStatusLoading()},refreshStore:function(){this.bottomBar.doRefresh()},btnExportHTML:function(){this.btnExport("html")},btnExportCSV:function(){this.btnExport("csv")},btnExport:function(b){var a=this.store;this.downloadWebAPI({webapi:{version:1,api:"SYNO.ResourceMonitor.Log",method:"export",params:{type:b,filter:a.baseParams.filter}},scope:this})},btnClear:function(){var a=this;this.appWin.getMsgBox().confirm("confirm",_T("log","log_cfrm_clear"),function(b){if(b==="yes"){a.sendWebAPI({api:"SYNO.ResourceMonitor.Log",version:1,scope:a,method:"clear",callback:function(d,c){if(d){this.refreshStore()}else{this.appWin.getMsgBox().alert("",this.helper.getError(c.code))}}})}})},enableButtonCheck:function(){var c=this.store;var d=this.getTopToolbar();var b=d.get("clear");var a=d.get("export");if(!c.getTotalCount()){a.disable();b.disable()}else{a.enable();b.enable()}},onBeforeStoreLoad:function(a,b){this.appWin.setStatusBusy();this.getEl().unmask()},onAfterStoreLoad:function(a,d,b){var c;if(d.length<1){this.body.mask(_T("rsrcmonitor","performance_event_no_event"))}else{this.body.unmask()}c=a.reader.jsonData;this.enableButtonCheck();this.appWin.clearStatusBusy()},onException:function(b,f,c,e,a){var d=(a&&a.error)?SYNO.API.Errors.core[a.error.code]:_T("common","error_system");this.appWin.getMsgBox().alert("alert",d);this.appWin.clearStatusBusy();this.getEl().mask(_T("rsrcmonitor","performance_event_no_event"))}});Ext.define("SYNO.SDS.ResourceMonitor.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.ResourceMonitor.App"});Ext.define("SYNO.SDS.ResourceMonitor.App",{extend:"SYNO.SDS.PageListAppWindow",activePage:"SYNO.SDS.ResourceMonitor.Performance.Main",pageTopFn:"SYNO.SDS.ResourceMonitor.Top.Main",pageServiceTreeFn:"SYNO.SDS.ResourceMonitor.TaskTab",constructor:function(a){this.appInstance=a.appInstance;this.addEvents("afterlaunchpage");this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={itemId:"mainWin",minWidth:860,minHeight:500,width:1024,height:580};Ext.apply(b,a);return b},getPageList:function(a){var b;if(!this.pageList){b={region:"west",width:240,tbar:{items:this.getCMSComboBox()},listeners:{scope:this,single:true,load:{fn:this.onLoad,buffer:50}},onBeforeSelect:function(d,f,h){if(this.getSelectionModel().getSelectedNode()){var i=this.getSelectionModel().getSelectedNode().id;var g=(i)?this.ownerCt.pageCt.items.map[i]:null;var e=(g)?g.el.isMasked():false;if(e){return false}}if(!f.leaf){return false}return true}};var c={listItems:[{text:_T("rsrcmonitor","performance"),iconCls:"icon-performance",help:"ResourceMonitor/rsrcmonitor_performance.html",fn:"SYNO.SDS.ResourceMonitor.Performance.Main"},{text:_T("rsrcmonitor","process"),iconCls:"icon-process",help:"ResourceMonitor/rsrcmonitor_processes.html",fn:"SYNO.SDS.ResourceMonitor.Top.Main",hidden:(SYNO.API.GetKnownAPI("SYNO.Core.System.ProcessGroup"))?true:false},{text:_T("rsrcmonitor","taskmanager"),iconCls:"icon-process",help:"ResourceMonitor/rsrcmonitor_task_manager.html",fn:"SYNO.SDS.ResourceMonitor.TaskTab",hidden:(!SYNO.API.GetKnownAPI("SYNO.Core.System.ProcessGroup"))?true:false,appWindow:this.findAppWindow()},{text:_T("connections","connections_title"),iconCls:"icon-connect",help:"ResourceMonitor/rsrcmonitor_connected_users.html",owner:this,fn:"SYNO.SDS.ResourceMonitor.Factory.CurConnPanel"},{text:_T("rsrcmonitor","speed_limit"),iconCls:"icon-speed",help:"ResourceMonitor/rsrcmonitor_speed_limit.html",fn:"SYNO.SDS.BandwidthControl.Status"}]};if("yes"===this.findAppWindow()._D("support_performance_event")){c.listItems.push({text:_T("common","common_settings"),help:"ResourceMonitor/rsrcmonitor_settings.html",fn:"SYNO.SDS.ResourceMonitor.Setting.Tab"},{text:_T("rsrcmonitor","performance_event"),iconCls:"icon-syslog",help:"ResourceMonitor/rsrcmonitor_performance_alarm.html",fn:"SYNO.SDS.ResourceMonitor.Log.Main"})}else{c.listItems.push({text:_T("common","common_settings"),help:"ResourceMonitor/rsrcmonitor_settings.html",fn:"SYNO.SDS.ResourceMonitor.Setting.Main"})}Ext.apply(b,c);this.pageList=new SYNO.ux.ModuleList(b)}return this.pageList},onOpen:function(a){if(a.hasOwnProperty("cms_id")){this.on("afterlaunchpage",function(){SYNO.API.Request({api:"SYNO.CMS.DS",params:{additional:["host","http_port","https_port","extra_info"],offset:0,limit:1000,sort_by:"hostname",sort_direction:"ASC"},method:"list",version:1,param:a,scope:this,callback:this.onListServerDone})},this,{single:true})}this.callParent(arguments);this.checkModuleVisible()},onRequest:function(a){this.callParent(arguments);if(this.hasOpenConfig("is_cms_open")){this.getCMSComboBox().setValue(a.cms_id).fireEvent("select")}},onListServerDone:function(b,d,c,j){if(!b){alert("WebAPI Fail: SYNO.CMS.Server - list");return}var h=[],k=j.param.cms_id;for(var f=0;f<d.count;f++){var a={};try{a=Ext.util.JSON.decode(d.ds_info_list[f].additional.extra_info)}catch(g){a={self:false}}h.push([d.ds_info_list[f].hostname,d.ds_info_list[f].id,d.ds_info_list[f].additional.host,d.ds_info_list[f].additional.http_port,d.ds_info_list[f].additional.https_port,a])}if(_S("is_admin")){h.push([_T("rsrcmonitor","localhost"),0,"","","",""])}if(0<h.length){this.getCMSComboBox().store=new Ext.data.ArrayStore({data:h,fields:["hostname","id","host","http_port","https_port","extra_info"]});this.getCMSComboBox().setValue(k).show();this.getActivePage().fireEvent("activate",{targetReady:true});this.fireEvent("server_ready");this.lastCMSComboBoxValue=k}else{this.showAlert(_T("common","commfail"),this.close,this)}},onLoad:function(a){this.callParent(arguments)},getCMSComboBox:function(){if(this.cmdComboBox){return this.cmdComboBox}this.cmdComboBox=new SYNO.ux.ComboBox({width:212,itemId:"client_combobox",value:-1,valueField:"id",displayField:"hostname",store:new Ext.data.ArrayStore({data:[["",-1,null,null,null,null]],fields:["hostname","id","host","http_port","https_port","extra_info"]}),hidden:true,listeners:{scope:this,select:this.onSelectCMSComboBox,beforeselect:this.onBeforeSelectCMSComboBox}});return this.cmdComboBox},onSelectCMSComboBox:function(a,b){if(this.lastCMSComboBoxValue!==this.getCMSComboBox().getValue()){this.updateOpenConfig();this.fireEvent("server_change");if(Ext.isFunction(this.findAppWindow().getActivePage().setStatusLoading)){this.findAppWindow().getActivePage().setStatusLoading(true)}if(!Ext.isDefined(this.openConfig.cms_id)){this.onSelectCMSComboBoxDone()}else{SYNO.API.Info.UpdateById({cms_id:this.openConfig.cms_id,callback:this.onSelectCMSComboBoxDone,args:arguments,scope:this})}}},onSelectCMSComboBoxDone:function(){this.fireEvent("server_ready");this.checkModuleVisible();this.findAppWindow().getActivePage().fireEvent("activate",{targetReady:true});this.lastCMSComboBoxValue=this.getCMSComboBox().getValue()},onBeforeSelectCMSComboBox:function(d,b,c){var e=this,a=this.getActivePage();if(a&&Ext.isFunction(a.onPageDeactivate)){if(false===a.onPageDeactivate()){e.getCMSComboBox().setValue(b.get("id"));e.getCMSComboBox().collapse();e.confirmLostChange(function(f){if(a&&Ext.isFunction(a.onPageConfirm)){a.onPageConfirm(f)}if(f==="yes"){e.onSelectCMSComboBox(d,b)}else{e.getCMSComboBox().setValue(d.startValue)}},e);return false}}},updateOpenConfig:function(){var a=this.getTargetData();if(this.hasOpenConfig("is_cms_open")){if(0>a.id){return}else{if(0===a.id){this.openConfig.cms_id=undefined}else{this.openConfig.cms_id=a.id}}}},setStatusLoading:function(a){if(true===this.isStatusLoading){return}a=a||{};Ext.applyIf(a,{text:_T("common","loading"),iconCls:"x-mask-loading"});this.isStatusLoading=true;this.getEl().mask(a.text,a.iconCls)},clearStatusLoading:function(){if(true!==this.isStatusLoading){return}this.getEl().unmask();this.isStatusLoading=false},showAlert:function(e,c,b){e=e||_T("common","commfail");if(e===_T("error","volume_no_volumes")||(e===_T("error","db_connect_fail")&&"yes"===this.findAppWindow()._D("usbstation"))){var d=new SYNO.SDS.MessageBoxV5({owner:this}),a=d.fbButtons.ok;if("yes"===this.findAppWindow()._D("usbstation")){e=_T("system","require_pgsql");e+=(e?"<br>":"")+String.format(_T("pkgmgr","prompt_enable_serviece"),_T("controlpanel","metadata_title"));if(false===this.hasOpenConfig("is_cms_open")){this.mon(a,"click",function(){SYNO.SDS.AppLaunch("SYNO.SDS.AdminCenter.Application",{fn:"SYNO.SDS.AdminCenter.SystemDatabase.Main"})},this)}else{this.mon(a,"click",function(){var f=new SYNO.SDS.CMS.DSMgr({owner:this});f.onLaunchDS(this.getTargetData(),{url:"/webman/index.cgi?launchApp=SYNO.SDS.AdminCenter.Application"})},this)}}else{if(false===this.hasOpenConfig("is_cms_open")){this.mon(a,"click",function(){SYNO.SDS.AppLaunch("SYNO.SDS.StorageManager.Instance")},this)}else{this.mon(a,"click",function(){var f=new SYNO.SDS.CMS.DSMgr({owner:this});f.onLaunchDS(this.getTargetData(),{url:"/webman/index.cgi?launchApp=SYNO.SDS.StorageManager.Instance"})},this)}}d.confirm(_T("tree","leaf_rsrcmonitor"),e,null,this,Ext.MessageBox.OKCANCEL)}else{this.getMsgBox().alert(_T("tree","leaf_rsrcmonitor"),e,c,b)}},getTargetData:function(){var d={};if(true===this.hasOpenConfig("is_cms_open")){var c=this.getCMSComboBox().getValue(),a=this.getCMSComboBox().store,b=a.getAt(a.findExact("id",c)).data;d=b}return d},checkModuleVisible:function(){var b=this.pageList;var a=this.getActivePage().itemId;b.setModuleVisible(this.pageTopFn,!this.IsKnownAPI("SYNO.Core.System.ProcessGroup"));b.setModuleVisible(this.pageServiceTreeFn,this.IsKnownAPI("SYNO.Core.System.ProcessGroup"));if(this.pageTopFn===a||this.pageServiceTreeFn===a){this.selectPage((this.IsKnownAPI("SYNO.Core.System.ProcessGroup"))?this.pageServiceTreeFn:this.pageTopFn)}},launchPage:function(c){var b=this.pageCt,a=b.getComponent(c);if(!a){a=this.createPage(c);b.add(a)}if(!a){return false}b.layout.setActiveItem(c);this.activePage=a;if(a instanceof Ext.TabPanel&&Ext.isFunction(a.setActiveTab)){a.setActiveTab(0)}if(a.onPageActivate){a.onPageActivate(this.openParams)}this.fireEvent("afterlaunchpage");return true}});