#!/bin/sh

# VirtualBox package made by seba/dodo-dk/DI4bI0
# package maintained at http://www.diablos-netzwerk.de

[ -f /etc/vbox/vbox.cfg ] && source /etc/vbox/vbox.cfg

vboxmanage="$INSTALL_DIR/VBoxManage"

# Enable/disable service
if [ "${VBOXWEB_USER}" == "" ]; then
	exit 0
fi

# Implementation of user control, execute several commands as another (predefined) user,
su_command="su - ${VBOXWEB_USER} -s /bin/sh -c"

# Get all autostart machines
MACHINES=$($su_command "$vboxmanage list vms | awk '{ print \$NF }' | sed -e 's/[{}]//g'")
for UUID in $MACHINES; do
	STARTUP=$($su_command "$vboxmanage getextradata $UUID 'pvbx/startupMode'" | awk '{ print $NF }')
	if [ "${STARTUP}" == "auto" ]; then
		VMNAME=$($su_command "$vboxmanage showvminfo $UUID | sed -n '0,/^Name:/s/^Name:[ \t]*//p'")
		echo "$0: starting machine ${VMNAME} ..."
		$su_command "$vboxmanage startvm $UUID --type headless"
	fi
done

exit 0
