#!/bin/sh

# VirtualBox package made by seba/dodo-dk/DI4bI0
# package maintained at http://www.diablos-netzwerk.de

# PACKAGE VARIABLES
PACKAGE="virtualbox"
NAME="VirtualBox"
TMP_DIR="${SYNOPKG_PKGDEST}/../../@tmp"

# COMMON PACKAGE VARIABLES
INSTALL_DIR="/usr/local/${PACKAGE}"
PACKAGE_DIR="/var/packages/${PACKAGE}"
WEB_DIR="/var/services/web"
DEFAULT_CFG_FILE_PHPVB="/usr/local/${PACKAGE}/www/config.php.synology"
CFG_FILE_PHPVB="${WEB_DIR}/phpvirtualbox/config.php"
DEFAULT_CFG_FILE_VB="/usr/local/${PACKAGE}/etc/vbox/vbox.cfg"
CFG_FILE_VB="/etc/vbox/vbox.cfg"
INSTALL_FILES="virtualbox_install_files"
BACKUP_FILES="virtualbox_backup_files"
KERNEL=$(uname -r)
DIST=$(get_key_value /etc.defaults/synoinfo.conf unique)
LOADED_KERNEL_MODULE=$(lsmod | grep vboxdrv)
DSMMAJOR=$(get_key_value /etc.defaults/VERSION majorversion)
DSMMINOR=$(get_key_value /etc.defaults/VERSION minorversion)
DSMBUILD=$(get_key_value /etc.defaults/VERSION buildnumber)

# ARCH SELECTION
[ $(echo $DIST | grep evansport) ] && ARCH="x86" || ARCH="amd64"
[ $(echo $DIST | grep evansport) ] && ARCH="x86" || ARCH="amd64"

# REQUIRED KERNEL VERSION AND BUILD
[ $(echo $DIST | grep evansport) ] && REQUIRED_KERNEL_VERSION="3.2.40" || REQUIRED_KERNEL_VERSION="3.10.102"
[ $(echo $DIST | grep apollolake) ] && REQUIRED_KERNEL_VERSION="4.4.15" || REQUIRED_KERNEL_VERSION="3.10.102"
REQUIRED_KERNEL_BUILD="15152"

# INCLUDE FUNCTIONS
source "$(dirname $0)"/lib.sh

# COMMON VIRTUALBOX VARIABLES
VIRTUALBOX_ARCH="$ARCH"
VIRTUALBOX_VER="5.1.30"
VIRTUALBOX_BUILD="118389"
PHPVIRTUALBOX_VER="develop"
VIRTUALBOX_DOWNLOAD_URL="http://download.virtualbox.org/virtualbox/${VIRTUALBOX_VER}/VirtualBox-${VIRTUALBOX_VER}-${VIRTUALBOX_BUILD}-Linux_${VIRTUALBOX_ARCH}.run"
VIRTUALBOX_DOWNLOAD_FILE="$(basename ${VIRTUALBOX_DOWNLOAD_URL})"
VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_URL="http://download.virtualbox.org/virtualbox/${VIRTUALBOX_VER}/Oracle_VM_VirtualBox_Extension_Pack-${VIRTUALBOX_VER}-${VIRTUALBOX_BUILD}.vbox-extpack"
VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_FILE="$(basename ${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_URL})"
# VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_URL="https://sourceforge.net/projects/phpvirtualbox/files/phpvirtualbox-${PHPVIRTUALBOX_VER}.zip/download"
# VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE="$(getSourceForgeUriFilename $VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_URL)"

# Check if PHPVIRTUALBOX_VER is available, if not use the latest release
# if [ -z "$VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE" ]; then
# 	VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_URL="https://sourceforge.net/projects/phpvirtualbox/files/latest/download"
# 	VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE="$(getSourceForgeUriFilename $VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_URL)"
# 	PHPVIRTUALBOX_VER=${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE#*-}
# 	PHPVIRTUALBOX_VER=${PHPVIRTUALBOX_VER%.*}
# fi

# DSM language based messages
source "$(dirname $0)"/lang.sh

preinst ()
{
	# Nothing to be done here if we upgrade
	if [ "$SYNOPKG_PKG_STATUS" == "UPGRADE" ]; then
		exit 0
	fi
	
	# check for supported kernel
	if [ $KERNEL != $REQUIRED_KERNEL_VERSION ]; then
		echo "$KERNEL_ERROR"
		exit 1
	fi
	
	# Check the DSM Version
	if [ $DSMBUILD != $REQUIRED_KERNEL_BUILD ]; then
		echo "$DSM_VERSION_ERROR"
		exit 1
	fi
	
	# check for loaded kernel module
	if [ "$LOADED_KERNEL_MODULE" ]; then
		echo "$KERNEL_LOADED_ERROR"
		exit 1
	fi
	
	# Check if the selected Path for VirtualBox VMs exists
	if [ ! -d "${wizard_virtualbox_path:=/volume1/VirtualBoxVMs}" ]; then
		echo "$VIRTUAL_BOX_VMS_PATH_ERROR"
		exit 1
	fi
	
	# Create a temp dir for the install files!
	[ ! -d "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}" ] && mkdir -p "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Download VirtualBox
	wget "${VIRTUALBOX_DOWNLOAD_URL}" -P "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Check if the download was successfully
	if [ ! -e "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE}" ]; then
		echo "$DOWNLOAD_ERROR"
		exit 1
	fi
	
	# Download VirtualBox ExtensionPacks
	wget "${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_URL}" -P "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Check if the download was successfully
	if [ ! -e "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_FILE}" ]; then
		echo "$DOWNLOAD_ERROR_2"
		exit 1
	fi
	
	# Download PHPVirtualBox
	# wget --content-disposition "${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_URL}" -P "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Check if the download was successfully
	# if [ ! -e "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE}" ]; then
	# 	echo "$DOWNLOAD_ERROR_3"
	# 	exit 1
	# fi
	
	# Set the right permissions so that we can execute the VirtualBox file
	chmod 755 ${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE}
	
	# Execute the downloaded VirtualBox Version
	${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE} --noexec --keep --target ${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE%.*} > /dev/null 2>&1
	
	# Decompress VirtualBox
	tar -xjf "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE%.*}/VirtualBox.tar.bz2" -C "${SYNOPKG_PKGINST_TEMP_DIR}/opt/VirtualBox"
	
	if [ $? != 0 ]; then
		echo "$EXTRACT_ERROR"
		exit 1
	fi
	
	# Decompress VirtualBox ExtensionPacks
	tar -xzf "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_FILE}" -C "${SYNOPKG_PKGINST_TEMP_DIR}/opt/VirtualBox/ExtensionPacks/Oracle_VM_VirtualBox_Extension_Pack"
	
	if [ $? != 0 ]; then
		echo "$EXTRACT_ERROR_2"
		exit 1
	fi
	
	# Decompress phpvirtualbox
	# 7zip replaced zip/unzip in DSM 6.0
	# 7z x "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE}" -o"${SYNOPKG_PKGINST_TEMP_DIR}/www" > /dev/null 2>&1
	
	# if [ $? != 0 ]; then
	# 	echo "$EXTRACT_ERROR_3"
	# 	exit 1
	# fi
	
	# Delete the downloaded and decompressed files
	rm -fr ${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}
	
	exit 0
}
	
postinst ()
{
	# Nothing to be done here if we upgrade
	if [ "$SYNOPKG_PKG_STATUS" == "UPGRADE" ]; then
		exit 0
	fi
	
	# Remove old VirtualBox CFG file
	[ -d /etc/vbox ] && rm -fr /etc/vbox
		
	# Remove versions number from phpvirtualbox folder
	mv ${SYNOPKG_PKGDEST}/www/phpvirtualbox-${PHPVIRTUALBOX_VER} ${SYNOPKG_PKGDEST}/www/phpvirtualbox
	
	# Link
	ln -s ${SYNOPKG_PKGDEST} ${INSTALL_DIR}
	
	# Install the phpVirtualBox web interface
	cp -pR ${INSTALL_DIR}/www/phpvirtualbox ${WEB_DIR}
	
	# Create a default configuration file for phpVirtualBox
	if [ ! -f ${CFG_FILE_PHPVB} ]; then
		cp ${DEFAULT_CFG_FILE_PHPVB} ${CFG_FILE_PHPVB}
		noAuth=$([ "${wizard_no_auth}" == "true" ] && echo "true" || echo "false")
		noPreview=$([ "${wizard_no_preview}" == "true" ] && echo "true" || echo "false")
		enableAdvancedConfig=$([ "${wizard_enable_advanced_config}" == "true" ] && echo "true" || echo "false")
		startStopConfig=$([ "${wizard_start_stop_config}" == "true" ] && echo "true" || echo "false")
		Language=$([ "${wizard_language_ger}" == "true" ] && echo "de" || echo "en")
		KeyboardLayout=$([ "${wizard_keyboard_layout_ger}" == "true" ] && echo "DE" || echo "EN")
		enableCustomIcons=$([ "${wizard_enable_Custom_Icons}" == "true" ] && echo "true" || echo "false")
		sed -i -e "s|@noAuth@|${noAuth:=false}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@noPreview@|${noPreview:=false}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@enableCustomIcons@|${enableCustomIcons:=false}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@enableAdvancedConfig@|${enableAdvancedConfig:=true}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@startStopConfig@|${startStopConfig:=true}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@language@|${Language:=en}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@keyboardlayout@|${KeyboardLayout:=EN}|g" ${CFG_FILE_PHPVB}
		sed -i -e "s|@pass@|${wizard_vbox_pass:=}|g" ${CFG_FILE_PHPVB}
		chmod ga+w ${CFG_FILE_PHPVB}
	fi
	
	# Create a default configuration file for VirtualBox
	if [ ! -f ${CFG_FILE_VB} ]; then
		mkdir /etc/vbox
		cp ${DEFAULT_CFG_FILE_VB} ${CFG_FILE_VB}
		action="acpibutton"
		action=$([ "${wizard_on_stop_acpibutton}" == "true" ] && echo "acpibutton" || echo $action)
		action=$([ "${wizard_on_stop_savestate}" == "true" ] && echo "savestate" || echo $action)
		action=$([ "${wizard_on_stop_poweroff}" == "true" ] && echo "poweroff" || echo $action)
		sed -i -e "s|@shutdown@|${action}|g" ${CFG_FILE_VB}
	fi 
	
	[ -d "/root/.config/VirtualBox" ] && rm -fr /root/.config/VirtualBox
	
	if [ ! -d "/root/.config/VirtualBox" ]; then
		mkdir /root/.config/VirtualBox
		cp "${INSTALL_DIR}"/etc/VirtualBox-Config.xml /root/.config/VirtualBox/VirtualBox.xml
		sed -i -e "s|@virtualbox_path@|${wizard_virtualbox_path:=/volume1/VirtualBoxVMs}|g" /root/.config/VirtualBox/VirtualBox.xml
	fi
	
	# Check if /opt is a symbolic link
	# /opt as a symbolic link is not supported by VirtualBox
	[ -h /opt ] && rm /opt
	
	# Install vbox to /opt/VirtualBox
	[ ! -d /opt ] && mkdir /opt
	
	cp -pR "${INSTALL_DIR}/opt/VirtualBox" /opt/VirtualBox
	ln -s /opt/VirtualBox/additions /usr/share/virtualbox
	
	# Fix permissions
	chmod -R 755 /opt/VirtualBox
	chmod 644 ${WEB_DIR}/phpvirtualbox/config.php
	
	chown -R root:root /opt/VirtualBox/ExtensionPacks
	
	exit 0
}
	
preuninst ()
{
	exit 0
}
	
postuninst ()
{
	# Remove link
	rm -f ${INSTALL_DIR}
	
	# Remove the web interface
	rm -fr ${WEB_DIR}/phpvirtualbox
	
	# Remove VirtualBox CFG file
	[ -d /etc/vbox ] && rm -fr /etc/vbox
	
	# Remove vbox
	if [ -d /opt/VirtualBox ]; then
		rm -fr /opt/VirtualBox
		rm -fr /usr/share/virtualbox
		if [ ! "$(ls -A /opt)" ]; then
			rmdir /opt
		fi
	fi
	
	# Remove the VirtualBox settings & logs
	[ -d /root/.config/VirtualBox ] && rm -fr /root/.config/VirtualBox
	
	exit 0
}

preupgrade ()
{
	# check for supported kernel
	if [ $KERNEL != $REQUIRED_KERNEL_VERSION ]; then
		echo "$KERNEL_ERROR"
		exit 1
	fi
	
	# Check the DSM Version
	if [ $DSMBUILD != $REQUIRED_KERNEL_BUILD ]; then
		echo "$DSM_VERSION_ERROR"
		exit 1
	fi
	
	# check for loaded kernel module
	if [ "$LOADED_KERNEL_MODULE" ]; then
		echo "$KERNEL_LOADED_ERROR"
		exit 1
	fi
	
	# Check if the selected Path for VirtualBox VMs exists
	if [ ! -d "${wizard_virtualbox_path:=/volume1/VirtualBoxVMs}" ]; then
		echo "$VIRTUAL_BOX_VMS_PATH_ERROR"
		exit 1
	fi
	
	#  Create a temp dir for the install files!
	[ ! -d "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}" ] && mkdir -p "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Download VirtualBox
	wget "${VIRTUALBOX_DOWNLOAD_URL}" -P "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Check if the download was successfully
	if [ ! -e "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE}" ]; then
		echo "$DOWNLOAD_ERROR"
		exit 1
	fi
	
	# Download VirtualBox ExtensionPacks
	wget "${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_URL}" -P "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Check if the download was successfully
	if [ ! -e "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_FILE}" ]; then
		echo "$DOWNLOAD_ERROR_2"
		exit 1
	fi
	
	# Download PHPVirtualBox
	# wget --content-disposition "${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_URL}" -P "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}"
	
	# Check if the download was successfully
	# if [ ! -e "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE}" ]; then
	# 	echo "$DOWNLOAD_ERROR_3"
	# 	exit 1
	# fi
	
	# Set the right permissions so that we can execute the VirtualBox file
	chmod 755 ${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE}
	
	# Execute the downloaded VirtualBox Version
	${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE} --noexec --keep --target ${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE%.*} > /dev/null 2>&1
	
	# Decompress VirtualBox
	tar -xjf "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_DOWNLOAD_FILE%.*}/VirtualBox.tar.bz2" -C "${SYNOPKG_PKGINST_TEMP_DIR}/opt/VirtualBox"
	
	if [ $? != 0 ]; then
		echo "$EXTRACT_ERROR"
		exit 1
	fi
	
	# Decompress VirtualBox ExtensionPacks
	tar -xzf "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_EXTENSIONPACK_DOWNLOAD_FILE}" -C "${SYNOPKG_PKGINST_TEMP_DIR}/opt/VirtualBox/ExtensionPacks/Oracle_VM_VirtualBox_Extension_Pack"
	
	if [ $? != 0 ]; then
		echo "$EXTRACT_ERROR_2"
		exit 1
	fi
	
	# Decompress phpvirtualbox
	# 7zip replaced zip/unzip in DSM 6.0
	# 7z x "${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}/${VIRTUALBOX_PHPVIRTUALBOX_DOWNLOAD_FILE}" -o"${SYNOPKG_PKGINST_TEMP_DIR}/www" > /dev/null 2>&1
	
	# if [ $? != 0 ]; then
	# 	echo "$EXTRACT_ERROR_3"
	# 	exit 1
	# fi
	
	# Delete the downloaded and decompressed files
	rm -fr ${SYNOPKG_PKGINST_TEMP_DIR}/${INSTALL_FILES}
	
	# When upgrading, we need to backup the config files into a temporary dir!
	[ ! -d "${SYNOPKG_PKGINST_TEMP_DIR}/${BACKUP_FILES}" ] && mkdir -p "${SYNOPKG_PKGINST_TEMP_DIR}/${BACKUP_FILES}"
	
	# Save some stuff
	rm -fr ${SYNOPKG_PKGINST_TEMP_DIR}/${BACKUP_FILES}
	mkdir -p ${SYNOPKG_PKGINST_TEMP_DIR}/${BACKUP_FILES}
	mv ${CFG_FILE_PHPVB} ${SYNOPKG_PKGINST_TEMP_DIR}/${BACKUP_FILES}/
	mv /root/.config/VirtualBox ${SYNOPKG_PKGINST_TEMP_DIR}/${BACKUP_FILES}/
	
	exit 0
}

postupgrade ()
{
	# Remove old VirtualBox CFG file
	[ -d /etc/vbox ] && rm -fr /etc/vbox
	
	# Remove versions number from phpvirtualbox folder
	mv ${SYNOPKG_PKGDEST}/www/phpvirtualbox-${PHPVIRTUALBOX_VER} ${SYNOPKG_PKGDEST}/www/phpvirtualbox
	
	# Link
	ln -s ${SYNOPKG_PKGDEST} ${INSTALL_DIR}
	
	# Install the phpVirtualBox web interface
	cp -pR ${INSTALL_DIR}/www/phpvirtualbox ${WEB_DIR}
	
	# Create a default configuration file for VirtualBox
	if [ ! -f ${CFG_FILE_VB} ]; then
		mkdir /etc/vbox
		cp ${DEFAULT_CFG_FILE_VB} ${CFG_FILE_VB}
		action="acpibutton"
		action=$([ "${wizard_on_stop_acpibutton}" == "true" ] && echo "acpibutton" || echo $action)
		action=$([ "${wizard_on_stop_savestate}" == "true" ] && echo "savestate" || echo $action)
		action=$([ "${wizard_on_stop_poweroff}" == "true" ] && echo "poweroff" || echo $action)
		sed -i -e "s|@shutdown@|${action}|g" ${CFG_FILE_VB}
	fi 
	
	# Check if /opt is a symbolic link
	# /opt as a symbolic link is not supported by VirtualBox
	[ -h /opt ] && rm /opt
	
	# Install vbox to /opt/VirtualBox
	[ ! -d /opt ] && mkdir /opt
	
	cp -pR "${INSTALL_DIR}/opt/VirtualBox" /opt/VirtualBox
	ln -s /opt/VirtualBox/additions /usr/share/virtualbox
		
	# Restore some stuff
	rm -f ${CFG_FILE_PHPVB}
	rm -fr /root/.config/VirtualBox
	mv ${SYNOPKG_PKGDEST}/${BACKUP_FILES}/VirtualBox /root/.config/
	mv ${SYNOPKG_PKGDEST}/${BACKUP_FILES}/config.php ${CFG_FILE_PHPVB}
	rm -fr ${SYNOPKG_PKGDEST}/${BACKUP_FILES}
	
	# Set VirtualBox VMs path
	if [ -f /root/.config/VirtualBox/VirtualBox.xml ]; then
		VIRTUAL_BOX_PATH=$(cat "/root/.config/VirtualBox/VirtualBox.xml" | grep "defaultMachineFolder")
		PATTERN=$(echo $VIRTUAL_BOX_PATH | awk -F '"' '{ print $2}')
		PATTERN="defaultMachineFolder=\"$PATTERN\""
		VIRTUAL_BOX_PATH_NEW="defaultMachineFolder=\"${wizard_virtualbox_path:=/volume1/VirtualBoxVMs}\""
		echo $VIRTUAL_BOX_PATH | sed -i -e "s|$PATTERN|$VIRTUAL_BOX_PATH_NEW|g" /root/.config/VirtualBox/VirtualBox.xml
	fi
	
	# Fix permissions
	chmod -R 755 /opt/VirtualBox
	chmod 644 ${WEB_DIR}/phpvirtualbox/config.php
	
	chown -R root:root /opt/VirtualBox/ExtensionPacks
	
	exit 0
}
