#!/bin/sh

# VirtualBox package made by seba/dodo-dk/DI4bI0
# package maintained at http://www.diablos-netzwerk.de

###BEGIN INIT INFO########################
#
# start-stop-status
# Starts, stops the VirtualBox and
# reports status to the package manager
#
###END INIT INFO##########################

# PACKAGE
PACKAGE="virtualbox"
NAME="VirtualBox"
PKGDEST=$(readlink "/var/packages/${PACKAGE}/target")
UIDEST="/usr/syno/synoman/webman/3rdparty/$PACKAGE"
TMP_DIR="${PKGDEST}/../../@tmp"

# COMMON PACKAGE VARIABLES
PACKAGE_DIR="/var/packages/${PACKAGE}"
SCRIPTSPATH="/var/packages/${PACKAGE}/scripts"
INSTALL_DIR="${PACKAGE_DIR}/target/opt/VirtualBox"

start()
{
	# start services
	$SCRIPTSPATH/vboxdrv.sh start
	$SCRIPTSPATH/vboxweb-service.sh start
	$SCRIPTSPATH/vboxinit.sh start
}

stop()
{
	# stop services
	$SCRIPTSPATH/vboxweb-service.sh stop
	$SCRIPTSPATH/vboxdrv.sh stop
}

log() {
	echo /var/log/vbox.log
	exit 0
}

case $1 in
	start)
		start
		exit 0
	;;
	stop)
		stop
		exit 0
	;;
	status)
		if [ -e ${UIDEST} ]; then
			exit 0
		else
			exit 1
		fi
	;;
	log)
		log
	;;
	*)
		exit 1
	;;
esac
