#!/bin/sh

if [ -z "$SYNOPKG_PKGNAME" ]; then
	# prior DSM 3.2, start script will be run without environment variable
	#  at boot time, thus we need a workaround to gather name and version info
	PACKAGE_NAME="virtualbox"
else
	PACKAGE_NAME=$SYNOPKG_PKGNAME
fi 

PACKAGE_DIR="/var/packages/${PACKAGE_NAME}" 
SCRIPTSPATH="/var/packages/${PACKAGE_NAME}/scripts"
APP_PATH="/usr/syno/synoman/webman/3rdparty/$PACKAGE_NAME" 
INSTALL_DIR="${PACKAGE_DIR}/target/opt/VirtualBox"
PACKAGE_ENABLED="${PACKAGE_DIR}/enabled" 

start()
{ 
	# start services
	$SCRIPTSPATH/vboxdrv.sh start
	$SCRIPTSPATH/vboxweb-service.sh start 
	$SCRIPTSPATH/vboxinit.sh start 
}

stop()
{
	# stop services, we will let vboxdrv shutdown VM's based on vbox.cfg
	#$SCRIPTSPATH/vboxinit stop 
	$SCRIPTSPATH/vboxweb-service.sh stop
	$SCRIPTSPATH/vboxdrv.sh stop
}

log() {
	echo /var/log/vbox.log
	exit 0
}

case $1 in
	start)
		# check enabled
		if [ ! -f $PACKAGE_ENABLED ]; then
			exit 0
		fi
		# start routine
		start
		exit 0 
	;;
	stop)
		stop
		exit 0
	;;
	status)
	if [ -e ${APP_PATH} ]; then
		exit 0
	else
		exit 1
	fi 
	;;
	log)
		log
	;;
	*)
		exit 1
	;;
esac
