#!/bin/sh

# Package
PACKAGE="virtualbox"
DNAME="VirtualBox"

# Others
INSTALL_DIR="/usr/local/${PACKAGE}"
PACKAGE_DIR="/var/packages/${PACKAGE}"
DEFAULT_CFG_FILE="/usr/local/${PACKAGE}/www/config.php.synology"
WEB_DIR="/var/services/web"
CFG_FILE="${WEB_DIR}/phpvirtualbox/config.php"

#common
KERNEL=$(uname -a | awk '{print $3}')
DIST=$(uname -a | awk '{print $14}')

preinst ()
{
	# check for supported kernel
	if [[ $KERNEL != "3.10.35" && $KERNEL != "3.2.40" ]]; then
		echo "Your Kernel ${KERNEL} is not supported"
		exit 1
	fi
}

postinst ()
{
	# check for libs
	if [ ! -f "/lib/libz.so.1.2.8" ]; then
		cp "${PACKAGE_DIR}"/target/lib/libz.so.1.2.8 /lib/
	fi
	
	if [ ! -f "/lib64/libz.so.1.2.8" ]; then
		cp "${PACKAGE_DIR}"/target/lib64/libz.so.1.2.8 /lib64/
	fi
	
	# create symlinks for libs
	[ ! -L "/lib/libz.so" ] && ln -s /lib/libz.so.1.2.8 /lib/libz.so
	[ ! -L "/lib/libz.so.1" ] && ln -s /lib/libz.so.1.2.8 /lib/libz.so.1
	[ ! -L "/lib64/libz.so" ] && ln -s /lib64/libz.so.1.2.8 /lib64/libz.so
	[ ! -L "/lib64/libz.so.1" ] && ln -s /lib64/libz.so.1.2.8 /lib64/libz.so.1
  	
	# copy kernel module
	# just for xpenology
	echo $DIST | grep -q bromolow
	if [ $? != 0 ]; then
		if [ ! -f "/lib/modules/modules/${KERNEL}/vboxdrv.ko" ]; then
			cp -r "${PACKAGE_DIR}"/target/kernel_module/x86_64/${KERNEL} /lib/modules/
			touch ${PACKAGE_DIR}/${DIST}_${KERNEL}_x86_64
		fi
	else
		if [ ! -f "/lib/modules/modules/${KERNEL}/vboxdrv.ko" ]; then
			cp -r "${PACKAGE_DIR}"/target/kernel_module/bromolow/${KERNEL} /lib/modules/
			touch ${PACKAGE_DIR}/${DIST}_${KERNEL}_bromolow
		fi
	fi

	# check for config
	if [ ! -d "/etc/vbox" ]; then
		ln -s "${PACKAGE_DIR}"/target/etc/vbox /etc/vbox
	fi
	
	# Link
	ln -s ${SYNOPKG_PKGDEST} ${INSTALL_DIR}

	# Install the phpVirtualBox web interface
	cp -pR ${INSTALL_DIR}/www/phpvirtualbox ${WEB_DIR}

	# Create a default configuration file for phpVirtualBox
	if [ ! -f ${CFG_FILE} ]; then
		cp ${DEFAULT_CFG_FILE} ${CFG_FILE}
		noAuth=$([ "${wizard_no_auth}" == "true" ] && echo "true" || echo "false")
		enableAdvancedConfig=$([ "${wizard_enable_advanced_config}" == "true" ] && echo "true" || echo "false")
		startStopConfig=$([ "${wizard_start_stop_config}" == "true" ] && echo "true" || echo "false")
		Language=$([ "${wizard_language_ger}" == "true" ] && echo "de" || echo "en")
		KeyboardLayout=$([ "${wizard_keyboard_layout_ger}" == "true" ] && echo "DE" || echo "EN")
		sed -i -e "s|@pass@|${wizard_vbox_pass:=}|g" ${CFG_FILE}
		sed -i -e "s|@noAuth@|${noAuth:=true}|g" ${CFG_FILE}
		sed -i -e "s|@enableAdvancedConfig@|${enableAdvancedConfig:=true}|g" ${CFG_FILE}
		sed -i -e "s|@startStopConfig@|${startStopConfig:=true}|g" ${CFG_FILE}
		sed -i -e "s|@language@|${Language}|g" ${CFG_FILE}
		sed -i -e "s|@keyboardlayout@|${KeyboardLayout}|g" ${CFG_FILE}
		chmod ga+w ${CFG_FILE}
	fi

	# Create a default configuration file for VirtualBox
	if [ ! -d "/etc/vbox" ]; then
		cp -rf "${INSTALL_DIR}"/etc/vbox /etc/
		action="acpibutton"
		action=$([ "${wizard_on_stop_poweroff}" == "true" ] && echo "poweroff" || echo $action)
		action=$([ "${wizard_on_stop_acpibutton}" == "true" ] && echo "acpibutton" || echo $action)
		action=$([ "${wizard_on_stop_savestate}" == "true" ] && echo "savestate" || echo $action)
		sed -i -e "s|acpibutton|${action}|g" /etc/vbox/vbox.cfg
	fi 

	# Install vbox to /opt/VirtualBox
	if [ ! -d /opt ]; then
		mkdir /opt
	fi 

	cp -pR "${INSTALL_DIR}/opt/VirtualBox" /opt/VirtualBox
	ln -s /opt/VirtualBox/additions /usr/share/virtualbox

	# Fix permissions
	chmod -R 755 /opt/VirtualBox
	
	exit 0
}

preuninst ()
{
	exit 0
}

postuninst ()
{
	# Remove link
	rm -f ${INSTALL_DIR}

	# Remove the web interface
	rm -fr ${WEB_DIR}/phpvirtualbox

	if [ -d /etc/vbox ]; then
		rm -fr /etc/vbox
	fi

	# Remove drivers
	if [ -f /lib/modules/${KERNEL}/vboxdrv.ko ]; then
		rm -f /lib/modules/${KERNEL}/modules.dep
		rm -f /lib/modules/${KERNEL}/vboxdrv.ko
		rm -f /lib/modules/${KERNEL}/vboxnetflt.ko
		rm -f /lib/modules/${KERNEL}/vboxnetadp.ko
		rm -f /lib/modules/${KERNEL}/vboxpci.ko
		if [ ! "$(ls -A /lib/modules/${KERNEL})" ]; then
			rmdir /lib/modules/${KERNEL}
		fi		
	fi

	# Remove vbox
	if [ -d /opt/VirtualBox ]; then
		rm -fr /opt/VirtualBox
			 rm -fr /usr/share/virtualbox
		if [ ! "$(ls -A /opt)" ]; then
			rmdir /opt
		fi		
	fi

	exit 0
}

preupgrade ()
{
	# Save some stuff
	rm -fr ${TMP_DIR}/${PACKAGE}
	mkdir -p ${TMP_DIR}/${PACKAGE}
	mv ${CFG_FILE} ${TMP_DIR}/${PACKAGE}/

	exit 0
}

postupgrade ()
{
	# Restore some stuff
	rm -f ${CFG_FILE}
	mv ${TMP_DIR}/${PACKAGE}/config.php ${CFG_FILE}
	rm -fr ${TMP_DIR}/${PACKAGE}
	
	exit 0
}
