#!/bin/sh

[ -f /etc/vbox/vbox.cfg ] && . /etc/vbox/vbox.cfg

vboxmanage="$INSTALL_DIR/VBoxManage"
LOG="/var/log/vboxscripts.log"

# Enable/disable service
if [ "${VBOXWEB_USER}" == "" ]; then
	exit 0
fi

start()
{
	# Get all autostart machines
	MACHINES=$($su_command "$vboxmanage list vms | awk '{ print \$NF }' | sed -e 's/[{}]//g'")
	for UUID in $MACHINES; do
		STARTUP=$($su_command "$vboxmanage getextradata $UUID 'pvbx/startupMode'" | awk '{ print $NF }')
		if [ "${STARTUP}" == "auto" ]; then
			VMNAME=$($su_command "$vboxmanage showvminfo $UUID | sed -n '0,/^Name:/s/^Name:[ \t]*//p'")
			echo "$0: starting machine ${VMNAME} ..."
			$su_command "$vboxmanage startvm $UUID --type headless" >>$LOG
		fi
	done
}

stop()
{
	# vms are saved, instead of stopped.
	MACHINES=$($su_command "$vboxmanage list runningvms | awk '{ print \$NF }' | sed -e 's/[{}]//g'")
	for UUID in $MACHINES; do
		VMNAME=$($su_command "$vboxmanage showvminfo $UUID | sed -n '0,/^Name:/s/^Name:[ \t]*//p'")
		echo "$0: saving machine ${VMNAME} state ..."
		$su_command "$vboxmanage controlvm $UUID savestate" >>$LOG
	done

}

status()
{
	$su_command "$vboxmanage list runningvms"
}

restart()
{
	stop
	start
}


# Implementation of user control, execute several commands as another (predefined) user,
su_command="su - ${VBOXWEB_USER} -s /bin/sh -c"

#
# Check for a command line option
#
case "$1" in

	start)
		start
		;;
	stop)
		stop
  		;;
	status)
		status
		;;
	restart)
		restart
		;;
	*)
	    echo "Usage: $0 {start|stop|restart|status}"
	    exit 1
		;;
esac

exit 0
