#!/usr/bin/python
# -*- coding: utf-8 -*-
import os, re, hashlib, subprocess, syslog, uuid

def getEnglishTitle(title):
    # https://regex101.com/r/DzL2w2/6/
    pattern = re.compile("\s+([\x20-\xff’“”]+)\s?$")
    result = pattern.search(title)
    title_en = result.group().strip() if result else ''
    return title_en if len(title_en) > 0 else title.strip()

class KodiAddon(object):
    def __init__(self, extend_lib = ""):
        self.entry = os.path.join(os.path.dirname(self.file), self.addon_id, "service.py")
        self.lib_path = os.path.join(os.path.dirname(os.path.dirname(self.file)), "lib")
        self.libs = ["xbmc"]
        self.temp =  '/tmp/VideoStation/addon/%s/%s'%(self.addon_id, uuid.uuid4())
        if extend_lib and os.path.isdir(extend_lib):
            self.libs.append(extend_lib)

    def execute(self, command, extra_env):
        # LANG and LC_ALL will affect os.listdir, isdir encoding conversion
        env = {
            "PYTHONPATH": self.getPythonPath(),
            "LANG": "en_US.utf8",
            "LC_ALL": "en_US.utf8"
        }
        env.update(extra_env)
        p = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=env)
        out, err = p.communicate()
        if err:
            syslog.syslog(syslog.LOG_ERR, 'Failed to run [%s], stderr: %s' % (command, err))
        return out

    def getMD5(self, string):
        m = hashlib.md5()
        m.update(string)
        return m.hexdigest()

    def getPythonPath(self):
        libs = [self.lib_path]
        for lib in self.libs:
            libs.append(os.path.join(self.lib_path, lib))
        return ":".join(libs)

    def getSuffixAndLink(self, download_id):
        suffix = ""
        link = download_id
        index = download_id.find(",")
        if index > -1:
            suffix = download_id[:index]
            link = download_id[index+1:]
        return [suffix, link]

    def removeLabelFormating(self, text):
        # Kodi label formating: http://kodi.wiki/view/Label_Formatting
        # Regex: https://regex101.com/r/Mr1jdb/2
        return re.sub(r"\[\/?\b(B|I|LIGHT|COLOR|UPPERCASE|LOWERCASE|CAPITALIZE|CR)(\s\w*)?\]|\$\w+\[[^\]]*\]", "", text)

    def encodeToUTF8(self, string):
        return string.decode("unicode_escape").encode("UTF-8")
