import argparse
import urllib.parse
import urllib.request
import os
import html
import json
import ssl


def _verify_run():
    parser = argparse.ArgumentParser()
    parser.add_argument("--apikey", type=str, required=False, help='TMDB api key')
    args, unknowPrm = parser.parse_known_args()

    if(args.apikey):
        os.environ["METADATA_PLUGIN_APIKEY"] = args.apikey

    result_obj = _verifyApiKey()

    json_string = json.dumps(result_obj, ensure_ascii=False, separators=(',', ':'))
    json_string = html.unescape(json_string)
    print(json_string)


def _verifyApiKey():
    if os.environ.get('METADATA_PLUGIN_APIKEY'):
        api_key = os.environ['METADATA_PLUGIN_APIKEY']
    else:
        return {}

    apikeyEncode = urllib.parse.quote_plus(api_key)
    url = 'https://api.themoviedb.org/3/authentication/token/new?api_key=' + apikeyEncode

    try:
        if hasattr(ssl, 'PROTOCOL_SSLv23'):
            # python3 < 3.6
            context = ssl.SSLContext(ssl.PROTOCOL_SSLv23)
        else:
            # python3 >= 3.6
            context = ssl.SSLContext(ssl.PROTOCOL_TLS)
        response = json.loads(urllib.request.urlopen(url, context=context).read().decode('utf-8'))
    except Exception as e:
        return {}

    if not response.get('request_token'):
        return {}

    return {'token': response['request_token']}


if __name__ == "__main__":
    _verify_run()
