#!/bin/bash

BASEDIR=$(dirname $0)
ARGV=""

escape()
{
	local ARG=$(echo -E $@ | sed "s/'/'\\\\''/g")
	echo \'$ARG\'
}


i=1
while [ $i -le $# ]; do
	eval ARG=\$\(escape \${$i}\)
	ARGV="$ARGV $ARG"
	i=`expr $i + 1`
done

export LC_CTYPE="en_US.utf8"

if [ -f "/usr/bin/python3" ]; then
	eval "/usr/bin/python3 $BASEDIR/search.py $ARGV"
else
	eval "/usr/local/bin/python3 $BASEDIR/search.py $ARGV"
fi

