#!/usr/bin/python
# -*- coding: utf-8 -*-
import os, sys, json, shutil
import argparse
import ast

sys.path.append(os.path.join(os.path.dirname(os.path.dirname(os.path.abspath(__file__))), "lib"))
from kodiaddon import KodiAddon, getEnglishTitle

class Subscene(KodiAddon):
    def __init__(self, extend_lib = ""):
        self.addon_id = "service.subtitles.subscene"
        self.file = os.path.abspath(__file__)
        super(Subscene, self).__init__(extend_lib)

    def getSubtitleIDPrefix(self, path, hashcode, lang):
        dirname = os.path.dirname(path)
        basename = os.path.basename(path)
        filename = os.path.splitext(basename)[0]
        return "%s/%s.subscene.%s.%s"%(dirname, filename, hashcode, lang)

    def getSubtitleID(self, prefix):
        dirname = os.path.dirname(prefix)
        files = [f for f in os.listdir(dirname) if os.path.isfile(os.path.join(dirname, f))]
        for f in files:
            filename = os.path.join(dirname, f)
            if 0 == filename.find(prefix):
                return filename
        return False

    def runSearch(self, arguments):
        video_info = json.dumps(arguments)
        video_path = arguments["path"]

        out = self.execute([
            "python", self.entry, "1", "?action=search&languages=%s"%arguments["lang"]
        ], {
            "VIDEO_INFO": video_info
        })
        results = json.loads(out)

        items = []
        for result in results:
            listitem = ast.literal_eval(result["listitem"])
            hashcode = self.getMD5(result["url"])
            prefix = self.getSubtitleIDPrefix(video_path, hashcode, listitem["label"])
            subtitle_id = self.getSubtitleID(prefix)
            downloaded = (subtitle_id != False)
            item = {
                "plugin_id": "com.synology.Subscene",
                "plugin_title": "Subscene",
                "language": listitem["label"],
                "language_id": listitem["label"],
                "filename": self.removeLabelFormating(self.encodeToUTF8(listitem["label2"])),
                "id": "%s,%s"%(os.path.basename(prefix), self.encodeToUTF8(result["url"])),
                "downloaded": downloaded
            }
            if downloaded:
                item["subtitle_id"] = subtitle_id
            items.append(item)
        print json.dumps({"items": items, "total": len(items)})

    def runDownload(self, arguments):
        video_info = json.dumps(arguments)
        video_path = arguments["path"]
        suffix, link = self.getSuffixAndLink(arguments["id"])

        out = self.execute([
            "python", self.entry, "2", "?action=download&link=%s"%link
        ], {
            "VIDEO_INFO": video_info,
            "TEMP_PATH": self.temp
        })
        results = json.loads(out)

        src_subtitle_id = results[0]["url"].encode("utf-8")
        dst_subtitle_id = "%s/%s%s"%(os.path.dirname(video_path), suffix, os.path.splitext(src_subtitle_id)[1])
        shutil.move(src_subtitle_id, dst_subtitle_id)
        shutil.rmtree(self.temp, ignore_errors=True)
        print json.dumps({"id": dst_subtitle_id})

def main():
    parser = argparse.ArgumentParser(prog='', description='')
    parser.add_argument('--action')
    parser.add_argument('--path')
    parser.add_argument('--id')
    parser.add_argument('--lang')
    parser.add_argument('--limit')
    parser.add_argument('--title')
    parser.add_argument('--year')
    parser.add_argument('--season')
    parser.add_argument('--episode')
    parser.add_argument('--extend_lib')
    args = parser.parse_args()

    arguments = {
        "path": "%s"%args.path
    }

    if args.action == "search":
        if args.limit:
            arguments["limit"] = "%s"%args.limit
        if args.lang:
            arguments["lang"] = "%s"%args.lang
        if args.title:
            arguments["title"] = "%s"%getEnglishTitle(args.title)
        else:
            arguments["title"] = os.path.splitext(os.path.basename(args.path))[0]
        if args.year:
            arguments["year"] = "%s"%args.year
        if args.season:
            arguments["season"] = "%s"%args.season
        if args.episode:
            arguments["episode"] = "%s"%args.episode

        Subscene(args.extend_lib).runSearch(arguments)

    elif args.action == "download":
        arguments["id"] = "%s"%args.id.replace('plugin://service.subtitles.subscene/', '')

        Subscene(args.extend_lib).runDownload(arguments)
    else:
        parser.print_help()

if __name__ == "__main__":
    main()
    exit(0)
