<?php
define('PKG_INSTALL_DIR', dirname(__FILE__));
require_once(dirname(__FILE__) . '/utils.php');

function _GetAPIKey($options)
{
	if (!isSet($options['apikey'])) {
		throw new Exception();
	}

	return $options['apikey'];
}

function PluginVerify($callback)
{
	$result = array();
	$options = CheckOptions(
		array(
			"help",
			"apikey:"
		), ' [--apikey key string]'
	);

	$apikey = getenv("METADATA_PLUGIN_APIKEY");
	if (empty($apikey)) {
		$apikey = _GetAPIKey($options);
	}

	try {
		$result = $callback($apikey);
	} catch (Exception $e) {
		// echo $e . "\n";
	}

	ProcessOutput($result);
}

?>

