<?php
function RemoveControlCharacter($value)
{
	$control_chars =  array("\x00", "\x01", "\x02", "\x03", "\x04", "\x05", "\x06", "\x07", "\x08", "\x09", "\x0A", "\x0B", "\x0C", "\x0D", "\x0E", "\x0F", "\x10", "\x11", "\x12", "\x13", "\x14", "\x15", "\x16", "\x17", "\x18", "\x19", "\x1A", "\x1B", "\x1C", "\x1D", "\x1E", "\x1F", "\x7F");
	return str_replace($control_chars, '', $value);
}

function GetStripedXML($xml_path)
{
	$xml = NULL;

	try {
		@$xml = new SimpleXMLElement(RemoveControlCharacter(file_get_contents($xml_path)));
	} catch (Exception $e) {
	}

	return $xml;
}

function CheckOptions($accept_options, $help_msg)
{
	$options = getopt("h", $accept_options);

	if (isSet($options['h']) || isSet($options['help'])) {
		echo $_SERVER['argv'][0] . $help_msg . "\n";
		exit(0);
	}

	return $options;
}

function IsDataObject($data)
{
	return is_array($data) && (isSet($data['path']) || isSet($data['title']));
}

function ProcessOutput($result)
{
	/* normalize to array */
	if (IsDataObject($result)) {
		$result = array($result);
	}

	/* workaround for unsupported JSON_UNESCAPED_UNICODE */
	array_walk_recursive($result, function(&$item, $key) {
		if(is_string($item)) {
			$item = urlencode(addcslashes(htmlspecialchars_decode($item), '"\\'));
		}
	});
	echo urldecode(json_encode($result)) . "\n";
}

function _CurlExecRetry($ch, $count)
{
	$result = FALSE;

	do {
		$result = curl_exec($ch);
		$info = curl_getinfo($ch);
		if ($info['http_code'] == 429) {
			$result = FALSE;
			sleep(10);
		}
	} while (FALSE === $result && 0 < $count--);

	return $result;
}

function _SetCurlOptions($ch)
{
	global $_cookie_file;

	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_1; de-de) AppleWebKit/527+ (KHTML, like Gecko) Version/3.1.1 Safari/525.20');
	curl_setopt($ch, CURLOPT_TIMEOUT, 45);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
	curl_setopt($ch, CURLOPT_FAILONERROR, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_COOKIEFILE, $_cookie_file);
	curl_setopt($ch, CURLOPT_COOKIEJAR, $_cookie_file);
}

function HTTPGETDownload($url, $fh)
{
	$ch = curl_init();
	if (FALSE === $ch) {
		return FALSE;
	}

	_SetCurlOptions($ch);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_FILE, $fh);

	$result = _CurlExecRetry($ch, 2);
	curl_close($ch);
	return $result;
}

function HTTPGETRequest($url)
{
	$ch = curl_init();
	if (FALSE === $ch) {
		return FALSE;
	}

	_SetCurlOptions($ch);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$result = _CurlExecRetry($ch, 2);
	curl_close($ch);
	return $result;
}

/**
 * @brief send POST request
 * @param $url [in]
 * @param $body [in] an array
 * @return [out] response
 */
function HTTPPOSTRequest($url, $body)
{
	$ch = curl_init();
	if (FALSE === $ch) {
		return FALSE;
	}

	_SetCurlOptions($ch);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));

	$result = _CurlExecRetry($ch, 2);
	curl_close($ch);
	return json_decode($result, true);
}

?>
