#!/usr/bin/php
<?php

require_once(dirname(__FILE__) . '/../verify.inc.php');

define('API_URL', 'https://api.themoviedb.org/3/');
define('AUTHENTICATION', 'authentication/token/new');

function VerifyAPIKey($apikey)
{
	$url = API_URL . AUTHENTICATION . '?api_key=' . urlencode($apikey);
	$response = json_decode(HTTPGETRequest($url), true);
	if (!isSet($response['request_token'])) {
		return array();
	}
	return array('token' => $response['request_token']);
}

function Process($apikey)
{
	if (empty($apikey)) {
		return array();
	}

	return VerifyAPIKey($apikey);
}

PluginVerify('Process');
?>
