#!/bin/sh
. /var/packages/VideoStation/scripts/common

SYNO_VIDEO_INDEXD=synovideoindexd
FULL_SYNO_VIDEO_INDEXD="${PACKAGE_DIR}/target/sbin/${SYNO_VIDEO_INDEXD}"

case $1 in
	start)
		killall -s KILL ${SYNO_VIDEO_INDEXD} > /dev/null 2>&1
		echo "Starting video indexing daemon ..."
		${FULL_SYNO_VIDEO_INDEXD}
		;;
	stop)
		echo "Stopping video indexing daemon ..."
		killall -s TERM ${SYNO_VIDEO_INDEXD} > /dev/null 2>&1
		;;
	restart)
		$0 stop
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
		;;
esac
