BEGIN;

CREATE TABLE offline_conversion_setting (
	id serial NOT NULL,
	video_file_id int NOT NULL,
	mapper_id int NOT NULL,
	video_profile varchar(32) NOT NULL,
	audio_track int NOT NULL,
	destination_path varchar(4096),

	CONSTRAINT offline_conversion_setting_pkey PRIMARY KEY (id),
	CONSTRAINT offline_conversion_setting_file_id_fkey FOREIGN KEY (video_file_id)
		REFERENCES video_file (id) MATCH FULL
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT offline_conversion_setting_mapper_id_fkey FOREIGN KEY (mapper_id)
		REFERENCES mapper (id) MATCH SIMPLE
		ON UPDATE CASCADE
)
WITHOUT OIDS;

CREATE TABLE offline_conversion_queue (
	id serial NOT NULL,
	setting_id int NOT NULL,
	uid bigint NOT NULL,
	status varchar(16) NOT NULL,
	status_additional text NOT NULL,
	create_date timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,

	CONSTRAINT offline_conversion_queue_pkey PRIMARY KEY (id),
	CONSTRAINT offline_conversion_queue_setting_id_fkey FOREIGN KEY (setting_id)
		REFERENCES offline_conversion_setting (id) MATCH FULL
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE TABLE backdrop (
	id serial NOT NULL,
	mapper_id serial NOT NULL,
	lo_oid oid NOT NULL,
	md5 text NOT NULL,
	pick_time timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,
	CONSTRAINT backdrop_pk PRIMARY KEY (id),
	CONSTRAINT backdrop_uk UNIQUE (id, lo_oid),
	CONSTRAINT backdrop_mapper_fk FOREIGN KEY (mapper_id)
		REFERENCES mapper (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE RULE backdrop_propagate_on_deletes_to_lob AS
	ON DELETE TO backdrop
	DO ALSO SELECT lo_unlink(OLD.lo_oid) AS lo_unlink;

CREATE RULE backdrop_propagate_on_update_to_lob AS
	ON UPDATE TO backdrop
	DO ALSO SELECT lo_unlink(OLD.lo_oid) AS lo_unlink;

CREATE VIEW has_poster_view AS
	SELECT mapper.id AS mapper_id, mapper.type, poster.id AS poster_id
	FROM mapper LEFT JOIN (SELECT id, mapper_id FROM poster) AS poster
	ON mapper.id = poster.mapper_id;

CREATE TABLE config (
	key varchar(256) NOT NULL,
	value text NOT NULL,
	updated integer NOT NULL DEFAULT 0,
	CONSTRAINT config_key_pk PRIMARY KEY (key)
)
WITHOUT OIDS;

INSERT INTO config (key, value) VALUES('version', '1');

COMMIT;
