/* Copyright (c) 2016 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.VideoStation2.Capability",{extend:"Ext.util.Observable",statics:{EVENT_CAPABILITY_READY:"capabilityready",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Capability.instance)){SYNO.SDS.VideoStation2.Capability.instance=new SYNO.SDS.VideoStation2.Capability()}return SYNO.SDS.VideoStation2.Capability.instance}},constructor:function(){this.callParent(arguments)},loadCapability:function(d){var a=d||{};var c=a.privilege||{};var b=a.transcoding_capability||{};this.remux=b.remux===true;this.transcode=b.transcode===true;this.software_transcode=b.software_transcode===true;this.hardware_transcode=b.hardware_transcode===true;this.dtv_transcode=b.dtv_transcode===true;this.dtv=c.dtv===true;this.renderer=c.renderer===true;this.sharing=c.sharing===true;this.offline_conversion=c.offline_conversion===true;this.fireEvent(SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY)},ableToRemux:function(){return this.remux},ableToTranscode:function(){return this.transcode},ableToSoftwareTranscode:function(){return this.software_transcode},ableToHardwareTranscode:function(){return this.hardware_transcode},ableToControlDTV:function(){return this.dtv},ableToPlayDTV:function(){return this.dtv_transcode||SYNO.VideoController2.Util.isVLCSupported()},ableToControlRenderer:function(){return this.renderer},ableToControlSharing:function(){return this.sharing},ableToControlOfflineConversion:function(){return this.offline_conversion},remux:false,transcode:false,software_transcode:false,hardware_transcode:false,dtv:false,renderer:false,sharing:false});Ext.define("SYNO.SDS.VideoStation2.Button",{extend:"SYNO.ux.Button",xtype:"syno_vs_button",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-button")}});Ext.define("SYNO.SDS.VideoStation2.MessageBox",{extend:"SYNO.SDS.MessageBoxV5",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-msgbox")},onRender:function(){this.callParent(arguments);this.progressBar.addClass("syno-vs2-progress")},getButtons:function(){var a=this.callParent(arguments);a.each(function(b){b.addClass("syno-vs2-button")});return a}});Ext.define("SYNO.SDS.VideoStation2.Dialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){b=b||{};b.owner=b.owner||SYNO.SDS.VideoStation2.Window;var a=Ext.isString(b.cls)?(b.cls+" syno-vs2-dialog"):"syno-vs2-dialog";b.cls=a;this.callParent([b])},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Error",{singleton:true,VIDEO_STATION_ERROR:{400:_VST("error","download_failed"),417:_VST("error","image_format"),418:String.format(_VST("error","image_too_big"),4),431:_VST("playlist","error_name_duplicated"),800:_VST("error","download_failed"),801:_VST("error","image_format"),803:String.format(_VST("error","image_too_big"),4),804:String.format(_VST("error","image_too_big"),10),903:_VST("playlist","error_name_duplicated")},DTV_ERROR:{401:_VST("error","error_someone_streaming"),402:_VST("error","error_someone_scaning"),403:_VST("error","dtv_channeltable_not_found"),404:_VST("error","record_program_not_exist"),405:_VST("error","recorde_duplicate"),406:_VST("error","dtv_folder_not_found"),407:_VST("error","dtv_request_dongle"),408:_VST("action","scan_fail"),409:_VST("error","no_data"),412:_VST("error","update_recording"),413:_VST("error","update_streaming"),414:_T("error","error_file_exist"),415:_VST("action","dvbs_scan_fail")},getAPIErrorString:function(e,c){var d=100;if(Ext.isNumber(e)){d=e}else{if(Ext.isObject(e)){var b=SYNO.API.Util.GetFirstError(e)||e;d=Ext.isNumber(b.code)?b.code:100}}if(d<400){return SYNO.API.Errors.common[d]||_T("error","error_error_system")}var a=(Ext.isString(c)&&c.indexOf("SYNO.DTV")!==-1)?SYNO.SDS.VideoStation2.Error.DTV_ERROR:SYNO.SDS.VideoStation2.Error.VIDEO_STATION_ERROR;return a[d]||_T("error","error_error_system")},getErrorInfoString:function(a,b){if(!Ext.isObject(a)){return b}if(a.success===true){return""}var d;var c=a.errinfo||{};if(c.sec&&c.key){d=_VST(c.sec,c.key)||_T(c.sec,c.key)||String.format("{0}:{1}",c.sec,c.key)}else{d=_T("error","error_error_system")}if(Ext.isNumber(c.line)){d=String.format("{0} ({1})",d,c.line)}return d},getDTVErrorString:function(a){return SYNO.SDS.VideoStation2.Error.getAPIErrorString(a,"SYNO.DTV.*")}});Ext.define("SYNO.SDS.VideoStation2.Filter",{statics:{EVENT_FILTER_CHANGE:"filterchange",FILTER_ACTOR:"actor",FILTER_DIRECTOR:"director",FILTER_GENRE:"genre",FILTER_WRITER:"writer",FILTER_CERTIFICATE:"certificate",FILTER_RATING:"rating",FILTER_YEAR:"year",FILTER_RESOLUTION:"resolution",FILTER_WATCHED_STATUS:"watchedstatus",FILTER_FILE_COUNT:"filecount",FILTER_CONTAINER:"container",FILTER_DURATION:"duration",FILTER_DATE:"date",FILTER_CHANNEL_NAME:"channel_name",FILTER_TITLE:"title",FILTER_KEYWORD:"keyword",DATA_RATING:[{key:_VST("filter","star_0"),value:{from:-1,to:14}},{key:_VST("filter","star_1"),value:{from:15,to:34}},{key:_VST("filter","star_2"),value:{from:35,to:54}},{key:_VST("filter","star_3"),value:{from:55,to:74}},{key:_VST("filter","star_4"),value:{from:75,to:94}},{key:_VST("filter","star_5"),value:{from:95,to:100}}],DATA_RESOLUTION:[{key:_VST("filter","resolution_sd"),value:{x_from:-1,x_to:1024,y_from:-1,y_to:576}},{key:"720p",value:{x_from:1024,x_to:1280,y_from:576,y_to:720}},{key:String.format(_VST("filter","andabove"),"1080p"),value:{x_from:1280,x_to:-1,y_from:720,y_to:-1}}],DATA_WATCHED_STATUS:[{key:_VST("advanced","unwatched"),value:"unwatched"},{key:_VST("advanced","watching"),value:"watching"},{key:_VST("advanced","watched"),value:"watched"}],DATA_FILE_COUNT:[{key:_VST("filter","singlefile"),value:"single"},{key:_VST("filter","multiplefile"),value:"multiple"}],DATA_DURATION:[{key:String.format(_VST("filter","andbelow"),"10 "+_VST("common","minutes")),value:{from:0,to:10}},{key:String.format("{0} ~ {1} {2}","10","30",_VST("common","minutes")),value:{from:10,to:30}},{key:String.format("{0} ~ {1} {2}","30","60",_VST("common","minutes")),value:{from:30,to:60}},{key:String.format("{0} ~ {1} {2}","60","120",_VST("common","minutes")),value:{from:60,to:120}},{key:String.format(_VST("filter","andabove"),"120 "+_VST("common","minutes")),value:{from:120,to:-1}}],instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Filter.instance)){SYNO.SDS.VideoStation2.Filter.instance=new SYNO.SDS.VideoStation2.Filter()}return SYNO.SDS.VideoStation2.Filter.instance},getLocalFilterData:function(a){switch(a){case SYNO.SDS.VideoStation2.Filter.FILTER_RATING:return SYNO.SDS.VideoStation2.Filter.DATA_RATING;case SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION:return SYNO.SDS.VideoStation2.Filter.DATA_RESOLUTION;case SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS:return SYNO.SDS.VideoStation2.Filter.DATA_WATCHED_STATUS;case SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT:return SYNO.SDS.VideoStation2.Filter.DATA_FILE_COUNT;case SYNO.SDS.VideoStation2.Filter.FILTER_DURATION:return SYNO.SDS.VideoStation2.Filter.DATA_DURATION;default:throw String.format("no such local filter {0}",a)}}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE);this.current_filter={};this.current_keyword=""},addFilter:function(a,b){if(this.hasFilter(a,b)){return}this.current_filter[a]=this.current_filter[a]||[];this.current_filter[a].push(b);this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,a)},deleteFilter:function(a,b){if(!this.hasFilter(a,b)){return}this.current_filter[a]=this.current_filter[a].filter(function(c){return c.key!==b.key});if(this.current_filter[a].length===0){delete this.current_filter[a]}this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,a)},toggleFilter:function(a,b){if(this.hasFilter(a,b)){this.deleteFilter(a,b)}else{this.addFilter(a,b)}},hasFilter:function(a,b){if(!this.current_filter[a]){return false}var c=false;Ext.each(this.current_filter[a],function(d){if(d.key===b.key){c=true;return false}});return c},setKeyword:function(a){if(this.current_keyword===a){return}this.current_keyword=a;this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)},hasKeyword:function(){return !Ext.isEmpty(this.current_keyword)},clearFilter:function(a){if(a===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){if(this.hasKeyword()){this.current_keyword="";this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)}return}if(!this.current_filter[a]){return}delete this.current_filter[a];this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,a)},clearAllFilter:function(){Object.keys(this.current_filter).each(function(a){this.clearFilter(a)},this);this.clearFilter(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)},isFilterEmpty:function(){return Object.keys(this.current_filter).length===0},getFilter:function(a){return this.current_filter[a]},getFilterOption:function(){var a={};Ext.iterate(this.current_filter,function(c,b){a[c]=b.map(function(d){return d.value})});return a},getKeywordOption:function(){var a={};if(this.hasKeyword()){a[SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD]=this.getKeyword()}return a},getKeyword:function(){return this.current_keyword},current_filter:null,current_keyword:null});function _VST(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}}Ext.define("SYNO.SDS.VideoStation2.Constant",{singleton:true,CLASS:{UNWATCHED:"unwatched",LASTWATCHED:"lastwatched"},EVENT:{PLAYLIST_CHANGE:"playlistchange",SHARING_STATUS_LOAD:"sharingstatusload",VIDEO_LOAD:"videoload",VIEW_LOADING:"viewloading",VIEW_LOADED:"viewloaded",VIEW_NOVIDEO:"viewnovideo",VIEW_NOTUNER:"viewnotuner",VIEW_CHANNEL_SCAN:"viewchannelscan",LOAD_PLAYER_OPTION:"loadplayeroption"},EXTRA:{KEY_RATING:"rating",KEY_REFERENCE:"reference",KEY_TMDB:"themoviedb",KEY_IMDB:"imdb",KEY_ATMOVIE:"atmovie"},PLAYLIST_TYPE:{ORIGINAL:"original",SMART:"smart"},REFRESH_INFO:{VIDEO:"video",SUBTITLE:"subtitle",NEXT_PREV_BTN:"next_prev_btn"},PLAYER_STREAMING:"streaming",TITLE_FAVORITE:"syno_favorite",TITLE_WATCHLIST:"syno_watchlist",COLLECTION:"collection",PLAYLIST:"playlist",PLAYLIST_VIDEOLIST:"playlistvideolist",MOVIE:"movie",TVSHOW:"tvshow",TVSHOW_EPISODE:"tvshow_episode",HOME_VIDEO:"home_video",TV_RECORDING:"tv_record",GETINFO_ADDITIONAL:["summary","file","actor","writer","director","extra","genre","collection","poster_mtime","watched_ratio","backdrop_mtime"],ADDITIONAL_DICT:{movie:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced","actor","director","genre","writer","extra"],home_video:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced","actor","director","genre","writer","extra"],tvshow:["summary","poster_mtime","backdrop_mtime"],tvshow_episode:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced","actor","director","genre","writer","extra","tvshow_summary"],tv_record:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced"]},CHANNEL:"channel",PROGRAM:"program",FOLDER:"folder",SQUARE:"square",FILE:"file",LIBRARY:"library",CATEGORY:"category",DTV:"dtv",FILTER:"filter",SEASON:"season",VIDEO:"video",PAGE:"page",RECORDING_SPECIFIC:"recording_specific",VIDEO_PROFILE_ORIGINAL:"original",VIDEO_PROFILE_HIGH:"high",VIDEO_PROFILE_MEDIUM:"medium",VIDEO_PROFILE_LOW:"low",RESOLUTION_DEFINITION:{SD:{x_from:-1,x_to:640,y_from:-1,y_to:480},"480p":{x_from:640,x_to:1024,y_from:480,y_to:576},"720p":{x_from:1024,x_to:1280,y_from:576,y_to:720},"1080p":{x_from:1280,x_to:1920,y_from:720,y_to:1080},"4K":{x_from:1920,x_to:-1,y_from:1080,y_to:-1}},PROGRAM_STATUS:{STATUS_NONE:"none",STATUS_PASS:"pass",STATUS_STREAMING:"streaming",STATUS_RECORDING:"recording",STATUS_SCHEDULED:"scheduled",STATUS_REPEAT_SCHEDULED:"repeatscheduled"},SCHEDULE_STATUS:{STATUS_ERROR:"error",STATUS_WAIT:"wait",STATUS_STREAMING:"streaming",STATUS_RECORDING:"recording",STATUS_DONGLE_NOT_FOUND:"nodonglenotfound",STATUS_RECORDING_INTERRUPT:"recordinginterrupt",STATUS_DONE:"done",STATUS_NO_PERMISSION:"nopermission",STATUS_USER_INVALID:"userinvalid",STATUS_NO_QUOTA:"noquota",STATUS_VOLUME_FULL:"volumefull",STATUS_CREATE_FILE_ERROR:"createfileerror",STATUS_WEEKLY_SCHEDULE:"weeklyschedule",STATUS_DAILY_SCHEDULE:"dailyschedule",STATUS_VLC_INTERRUPT:"vlcinterrupt",STATUS_SKIP:"skip"},TUNER_TYPE:{TYPE_QPSK:0,TYPE_QAM:1,TYPE_OFDM:2,TYPE_ATSC:3,TYPE_HDHOMERUN:99},STORE_UNLIMIT:500000});Ext.define("SYNO.SDS.VideoStation2.Util",{singleton:true,applyCallback:function(a){if(!Ext.isObject(a)||!Ext.isFunction(a.fn)){return}a.fn.apply(a.scope||window,a.args||[])},convertCollectionID:function(a){if(!Ext.isArray(a)){return a}return a.map(function(c){var d=parseInt(c.id,10);var b=c.title;if(SYNO.SDS.VideoStation2.Constant.TITLE_FAVORITE===b){d=-1}else{if(SYNO.SDS.VideoStation2.Constant.TITLE_WATCHLIST===b){d=-2}}return{id:d,title:c.title}})},getVideoActionString:function(a){return _VST("action",a)||_VST("controller",a)||_VST("advanced",a)||_VST(a,"action")},getFilterCategoryString:function(a){switch(a){case SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR:return _VST("actor","title");case SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR:return _VST("director","title");case SYNO.SDS.VideoStation2.Filter.FILTER_GENRE:return _VST("genre","title");case SYNO.SDS.VideoStation2.Filter.FILTER_WRITER:return _VST("writer","title");case SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE:return _VST("metadata","rating_classification");case SYNO.SDS.VideoStation2.Filter.FILTER_RATING:return _VST("metadata","rating");case SYNO.SDS.VideoStation2.Filter.FILTER_YEAR:return _VST("year","title");case SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION:return _VST("video_info","resolution");case SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS:return _VST("common","watch_status");case SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT:return _VST("filter","file_count");case SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER:return _VST("video_info","container");case SYNO.SDS.VideoStation2.Filter.FILTER_DURATION:return _VST("duration","title");case SYNO.SDS.VideoStation2.Filter.FILTER_DATE:return _VST("classification","bydate");case SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME:return _VST("classification","bychannel");case SYNO.SDS.VideoStation2.Filter.FILTER_TITLE:return _VST("classification","byprogram");case SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD:return _VST("search","keyword");default:return""}},getRecordingActionString:function(a){return _VST("action",a)||_VST("schedule",a)},getAPIName:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.MOVIE:return"SYNO.VideoStation2.Movie";case SYNO.SDS.VideoStation2.Constant.TVSHOW:return"SYNO.VideoStation2.TVShow";case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return"SYNO.VideoStation2.TVShowEpisode";case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return"SYNO.VideoStation2.HomeVideo";case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return"SYNO.VideoStation2.TVRecording";default:throw String.format("unexpected type {0}",a)}},getVideoRoot:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.MOVIE:return"movie";case SYNO.SDS.VideoStation2.Constant.TVSHOW:return"tvshow";case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return"episode";case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return"video";case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return"recording";default:throw String.format("unexpected type {0}",a)}},getWebAPIURL:function(a){return String.format("{0}/{1}","webapi/VideoStation",a)},getCGIURL:function(a){return String.format("webman/3rdparty/VideoStation/cgi/{0}",a)},getImageURL:function(b){b=Ext.apply(b||{},{api:"SYNO.VideoStation2.Poster",method:"get",version:"1"});if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(b,{resolution:Ext.encode("2x")})}var a=Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode(b));return a},getImageURLByRecord:function(b,a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:Ext.isString(a)?a:b.type,id:b.id,mtime:b.additional?b.additional.poster_mtime||"":""})},getBackdropURL:function(b){b=Ext.apply(b||{},{api:"SYNO.VideoStation2.Backdrop",method:"get",version:"1"});var a=Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode(b));return a},getVideoDate:function(a){if(Ext.isString(a.original_available)&&!Ext.isEmpty(a.original_available)){return a.original_available==="0"?"":a.original_available.split("-")[0]}else{if(Ext.isString(a.record_date)&&!Ext.isEmpty(a.record_date)){return a.record_date==="0"?"":a.record_date.split(" ")[0]}else{return""}}},hideDTVUI:function(){return SYNO.SDS.isNSM||_D("support_dual_head")==="yes"||SYNO.SDS.Utils.isInVirtualDSM()||_D("dockerdsm")==="yes"},isWatched:function(a){return Ext.isNumber(a)&&a===1},isUnwatched:function(a){return Ext.isNumber(a)&&Math.floor(a*100)===0},classifyVideos:function(a){var b={};a.each(function(c){b[c.type]=b[c.type]||[];b[c.type].push(c)});return b},formatBitrate:function(c){var b=parseInt(c,10);var a=(b/1024).toFixed(1);return String.format("{0} Kbps",a)},extractFileName:function(a){return a.substring(a.lastIndexOf("/")+1)},getShareData:function(d){var c=d;var a=c.indexOf("/",1);var b="";c=c.substr(1);if(a>0){b=c.substr(a);c=c.substr(0,a-1)}return{share:Ext.util.Format.lowercase(c),orishare:c,subpath:b}},getLangStore:function(){var b=SYNO.SDS.Utils.getSupportedLanguage(),a;a=new Ext.data.SimpleStore({fields:["value","display"],data:b,autoDestroy:true});return a},onProxyBeforeLoad:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}},getCombinationPosterDiv:function(b,a){if(!Ext.isArray(b)||!Ext.isFunction(a)){return""}if(1===b.length){return String.format('<div class="center loading" url="{0}"></div>',a(b[0]))}else{if(2===b.length){return[String.format('<div class="top loading" url="{0}"></div>',a(b[0])),String.format('<div class="bottom loading" url="{0}"></div>',a(b[1]))].join("")}else{if(3===b.length){return[String.format('<div class="top loading" url="{0}"></div>',a(b[0])),String.format('<div class="bottom-left loading" url="{0}"></div>',a(b[1])),String.format('<div class="bottom-right loading" url="{0}"></div>',a(b[2]))].join("")}else{if(4<=b.length){return[String.format('<div class="top-left loading" url="{0}"></div>',a(b[0])),String.format('<div class="top-right loading" url="{0}"></div>',a(b[1])),String.format('<div class="bottom-left loading" url="{0}"></div>',a(b[2])),String.format('<div class="bottom-right loading" url="{0}"></div>',a(b[3]))].join("")}}}}return""},getWatchStatusDiv:function(c){var a=c.additional||{};if(Ext.isDefined(a.total_seasons)){return""}var b=a.watched_ratio||0;b=(0===b?0:Math.floor(b*100));if(100===b){return""}return['<div class="watch-status-wrap">','<div class="grey-bar"></div>',String.format('<div class="blue-bar" style="width:{0}%"></div>',b),"</div>"].join("")},mask:function(c,h,b,g,e){var f;if(!c||!(f=c.getEl())){return}if(f.delayedUnmask){f.delayedUnmask.cancel();f.delayedUnmask=null}f.mask.apply(f,Array.prototype.slice.call(arguments,1,3));var a=f.down(".ext-el-mask");a.addClass("syno-vs2-el-mask");if(Ext.isFunction(g)){var d=f.down(".ext-el-mask-msg div");d.addClass("clickable");d.on("click",g)}if(f.delayedMask){f.delayedMask.cancel();f.delayedMask=null}f.delayedMask=new Ext.util.DelayedTask(function(){if(a&&a.dom){a.addClass("mask")}f.delayedMask=null});f.delayedMask.delay(e||1)},delayMask:function(b,d,a,c){SYNO.SDS.VideoStation2.Util.mask(b,d,a,c,500)},unmask:function(b){var c;if(!b||!(c=b.getEl())){return}if(c.delayedMask){c.delayedMask.cancel();c.delayedMask=null}var a=c.down(".ext-el-mask");if(!a){return}if(!c.delayedUnmask){a.addClass("unmask");c.delayedUnmask=new Ext.util.DelayedTask(function(){c.unmask();c.delayedUnmask=null})}c.delayedUnmask.delay(300)},maskLoading:function(a,b){var c=_T("common","loading");SYNO.SDS.VideoStation2.Util.maskLoadingMsg(a,c,b)},maskLoadingMsg:function(b,d,c){var a="x-mask-loading syno-vs2-mask-loading";SYNO.SDS.VideoStation2.Util[c?"delayMask":"mask"](b,d,a)},maskInfo:function(b,e,d,c){var a="syno-ux-mask-info syno-vs2-mask-info";SYNO.SDS.VideoStation2.Util[c?"delayMask":"mask"](b,e,a,d)},findValueInObject:function(c,a){var b;Ext.iterate(c,function(e,d){if(e===a){b=d;return false}if(Ext.isObject(d)){var f=SYNO.SDS.VideoStation2.Util.findValueInObject(d,a);if(Ext.isDefined(f)){b=f;return false}}});return b},launchHelp:function(){SYNO.SDS.WindowLaunch("SYNO.SDS.HelpBrowser.Application",{topic:"SYNO.SDS.VideoStation.AppInstance"})},getPathTitleForEpisode:function(b,a){var c=[b>0?String.format(_VST("episode","title"),b):_VST("metadata","unknown")];if(!Ext.isEmpty(a)){c.push(a)}return c.join(" - ")},getPathTitleForOfflineEpisode:function(b){var c=[b.title];var a="";if(0<b.season){a=String.format("S{0}",b.season)}if(0<b.episode){a+=String.format("E{0}",b.episode)}if(!Ext.isEmpty(a)){c.push(a)}if(!Ext.isEmpty(b.tagline)){c.push(b.tagline)}return c.join(" - ")},getLibraryTypeByVideoType:function(a){return a===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?SYNO.SDS.VideoStation2.Constant.TVSHOW:a}});Ext.define("SYNO.SDS.VideoStation2.FilteringBaseProxy",{extend:"SYNO.API.Proxy",constructor:function(a){this.callParent([a])},onRequestAPI:function(i,d,b,a,f,j,k,l,c){try{var g=f.getRoot(d);Ext.each(g,function(e){if(!Ext.isObject(e.additional)){return}if(e.additional.collection){e.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(e.additional.collection)}if(e.additional.extra){e.additional.extra=Ext.decode(e.additional.extra)}if(e.additional.tvshow_extra){e.additional.tvshow_extra=Ext.decode(e.additional.tvshow_extra)}},this);this.callParent(arguments)}catch(h){this.fireEvent("loadexception",this,l,d,h);this.fireEvent("exception",this,"response",c,l,d,h);return}}});Ext.define("SYNO.SDS.VideoStation2.ByFolderProxy",{extend:"SYNO.API.Proxy",constructor:function(a){this.callParent([a])},onRequestAPI:function(j,f,b,a,g,k,l,m,d){try{var c=0;var h=g.getRoot(f);Ext.each(h,function(e){if(e.additional&&e.additional.collection){e.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(e.additional.collection)}if(SYNO.SDS.VideoStation2.Constant.FOLDER===e.type){c=c+1}},this);if(0<c){h[c-1].last_folder=true}this.callParent(arguments)}catch(i){this.fireEvent("loadexception",this,m,f,i);this.fireEvent("exception",this,"response",d,m,f,i);return}}});Ext.define("SYNO.SDS.VideoStation2.FilterMetadataProxy",{extend:"SYNO.API.Proxy",constructor:function(a){this.callParent([a])},onRequestAPI:function(f,d,b,a,e,g,h,i,c){d.metadata=d.metadata.map(function(j){return{key:j,value:j}});this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Util.Styles",{singleton:true,updateMarginBySelector:function(a,g,b,f,d){var c,h,e=SYNO.SDS.VideoStation2.Util.Styles;if(!e.styleRules){e.styleRules={}}h=e.getVideoStyleRule(a);if(!h){return}c=Math.floor(b/(f+d));if(c<1){c=1}h.style[g]=String.format("calc(99% / {0} - {1}px)",c,f)},getVideoStyleRule:function(b){var a,c=SYNO.SDS.VideoStation2.Util.Styles;if(c.styleRules[b]){return c.styleRules[b]}if(!document.styleSheets){return null}for(a=document.styleSheets.length-1;a>=0;a--){if(!Ext.isString(document.styleSheets[a].href)){continue}if(document.styleSheets[a].href.indexOf("/VideoStation/style.css")>=0){c.styleRules[b]=c.getRuleBySelector(document.styleSheets[a],b);return c.styleRules[b]}}return null},getRuleBySelector:function(e,c){var b,a,d;if(!e.rules){return null}for(b=0,a=e.rules.length;b<a;b++){d=e.rules[b];if(!Ext.isString(d.selectorText)){continue}if(d.selectorText===c){return d}}return null}});Ext.define("SYNO.SDS.VideoStation2.Library",{statics:{EVENT_LIBRARY_LOAD:"libraryload",EVENT_LIBRARY_CHANGED:"librarychanged",DEFAULT_LIBRARY:[{id:0,title:_VST("playlist","title"),type:SYNO.SDS.VideoStation2.Constant.PLAYLIST,visible:true}],instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Library.instance)){SYNO.SDS.VideoStation2.Library.instance=new SYNO.SDS.VideoStation2.Library()}return SYNO.SDS.VideoStation2.Library.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED);this.prepareDefaultLibrary();this.cursor=this.default_library[0].get("opid");this.current_id=this.default_library[0].get("id");this.current_type=this.default_library[0].get("type")},getLibraryStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.LibraryStore({appWindow:SYNO.SDS.VideoStation2.Window,listeners:{scope:this,load:this.onLibraryLoad}});return this.store},loadLibrary:function(){this.getLibraryStore().load()},onLibraryLoad:function(){this.store.insert(0,this.default_library);this.store.commitChanges();this.updateCurrentDataByCursor();this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD)},prepareDefaultLibrary:function(){if(Ext.isEmpty(this.default_library)){var a=SYNO.SDS.VideoStation2.Library.DEFAULT_LIBRARY.filter(function(b){return !(b.type===SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&SYNO.SDS.VideoStation2.Util.hideDTVUI())});this.default_library=a.map(function(b){return new SYNO.SDS.VideoStation2.LibraryStore.Record(Ext.apply(b,{opid:SYNO.SDS.VideoStation2.LibraryStore.convertOPID(b)}))})}},updateCurrentDataByCursor:function(){this.current_id=null;this.current_type=null;var a=this.cursor||this.tmp_cursor;this.store.each(function(d,b,c){if(d.get("opid")===a){this.current_id=d.get("id");this.current_type=d.get("type");return false}return true},this)},activate:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted library opid {0}",a));this.cursor=a;this.tmp_cursor=null;this.updateCurrentDataByCursor();this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED)},activateTemporary:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted library opid {0}",a));this.tmp_cursor=a;this.updateCurrentDataByCursor();this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED)},activateFromTemporary:function(){this.activate(this.tmp_cursor)},isDeactivated:function(){return Ext.isEmpty(this.cursor)},getCurrentID:function(){return this.current_id},getCurrentType:function(){return this.current_type},getLibraryByFn:function(b){var a=null;this.store.each(function(c){if(b(c)){a=SYNO.Util.copy(c.data);return false}});return a},getLibraryByOPID:function(a){return this.getLibraryByFn(function(b){return b.get("opid")===a})},getLibraryByIDAndType:function(b,a){return this.getLibraryByFn(function(c){return c.get("id")===b&&c.get("type")===a})},getAllLibraries:function(){var a=[];this.store.each(function(c){var b=c.get("type");if(b===SYNO.SDS.VideoStation2.Constant.PLAYLIST||b===SYNO.SDS.VideoStation2.Constant.TV_RECORDING){return}a.push(SYNO.Util.copy(c.data))});return a},getCurrentVideoType:function(){var a=this.getCurrentType();return(a===SYNO.SDS.VideoStation2.Constant.TVSHOW)?SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:a},cursor:null,tmp_cursor:null,current_id:null,current_type:null});Ext.define("SYNO.SDS.VideoStation2.LibraryStore",{statics:{defaultLibraryTitle:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.MOVIE:return _VST("type","movie");case SYNO.SDS.VideoStation2.Constant.TVSHOW:return _VST("type","tv_show");case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return _VST("type","home_video");case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return _VST("type","tv_recorder");default:return""}},convertOPID:function(a){return String.format("{0}-{1}",a.type,a.id)},Record:Ext.data.Record.create([{name:"id",type:"int"},{name:"title",type:"string",convert:function(b,a){return a.id===0?SYNO.SDS.VideoStation2.LibraryStore.defaultLibraryTitle(a.type):b}},{name:"type",type:"string"},{name:"is_public",type:"boolean"},{name:"visible",type:"boolean"},{name:"opid",type:"string",convert:function(b,a){return SYNO.SDS.VideoStation2.LibraryStore.convertOPID(a)}}])},extend:"SYNO.API.Store",constructor:function(b){var a={api:"SYNO.VideoStation2.Library",method:"list",version:1,reader:new Ext.data.JsonReader({root:"library",idProperty:"opid"},SYNO.SDS.VideoStation2.LibraryStore.Record)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Stores",{extend:"SYNO.API.Store",proxyClass:"SYNO.API.Proxy",readerClass:"Ext.data.JsonReader",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},synoAPI:null,synoMethod:null,synoVersion:1,constructor:function(c){c=c||{};var b=Ext.apply(this.baseConfigs.reader,c.readerCfg);var a={method:"POST",proxy:this._getProxy(c),baseParams:Ext.apply({},this.baseConfigs.baseParams),reader:new (Ext.getClassByName(this.readerClass))(b)};if(c.baseParams){Ext.applyIf(c.baseParams,this.baseConfigs.baseParams)}Ext.apply(a,c);this.callParent([a])},_getProxy:function(a){this._proxy=this._proxy||new (Ext.getClassByName(a.proxyClass||this.proxyClass))({appWindow:SYNO.SDS.VideoStation2.Window,api:a.synoAPI||this.synoAPI,method:a.synoMethod||this.synoMethod,version:a.synoVersion||this.synoVersion,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}});return this._proxy}});Ext.define("SYNO.SDS.VideoStation2.Stores.movie",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Movie",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["poster_mtime","summary","watched_ratio","collection"]},reader:{id:"id",root:"movie",totalProperty:"total",fields:["id","mapper_id","title","certificate","rating","original_available","metadata_locked","additional","type","path","sharepath","file_count","last_watched","create_time","library_id"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.tvshow",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVShow",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["poster_mtime","summary","backdrop_mtime"]},reader:{id:"id",root:"tvshow",totalProperty:"total",fields:["id","mapper_id","title","original_available","metadata_locked","additional","mapper_id","sort_title","last_watched","create_time","library_id"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.tvshow_episode",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVShowEpisode",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,additional:["summary","collection","poster_mtime","watched_ratio"]},reader:{id:"id",root:"episode",totalProperty:"total",fields:["id","mapper_id","season","last_watched","episode","tagline","certificate","rating","original_available","metadata_locked","additional","mapper_id","sort_title","create_time","max_last_watched","library_id"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.home_video",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.HomeVideo",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["summary","collection","poster_mtime","watched_ratio"]},reader:{id:"id",root:"video",totalProperty:"total",fields:["id","mapper_id","title","certificate","rating","record_date","additional","type","path","sharepath","file_count","last_watched","create_time","library_id"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.tv_record",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVRecording",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["summary","collection","poster_mtime","watched_ratio"]},reader:{id:"id",root:"recording",totalProperty:"total",fields:["id","mapper_id","title","channel_name","certificate","rating","record_date","additional","last_watched","create_time"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.playlist",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Collection",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,sort_direction:"asc",preview_video:4,additional:["sharing_info","filter_info"]},reader:{id:"id",root:"collection",totalProperty:"total",fields:["id","title","additional","type","preview_video"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.folder",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Folder",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.ByFolderProxy",baseConfigs:{baseParams:{preview_video:4,additional:["poster_mtime","summary","watched_ratio","collection"]},reader:{id:"id",root:"object",totalProperty:"total",fields:["id","title","additional","type","path","sharepath","file_count","preview_video","last_folder"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.playlistvideolist",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Collection",synoMethod:"list_video",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{sort_by:"title",sort_direction:"asc",additional:["summary","poster_mtime","watched_ratio","collection"]},reader:{id:"mapper_id",root:"video",totalProperty:"total",fields:["id","mapper_id","title","type","metadata_locked","additional","season","episode","tagline","library_id","original_available","record_date","date"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.filter",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Metadata",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilterMetadataProxy",baseConfigs:{baseParams:{limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,sort_direction:"asc"},reader:{id:"key",root:"metadata",totalProperty:"total",fields:["key","value"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.localfilter",{extend:"Ext.data.JsonStore",constructor:function(b){var a={id:"key",fields:["key","value"]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Stores.internet_search",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.PluginSearch",synoMethod:"list",baseConfigs:{baseParams:{sort_direction:"asc"},reader:{id:"id",root:"data.result",totalProperty:"data.total",fields:["title","certificate","tag_line","original_available","actor","director","genre","writer","summary","extra","tvshow_original_available",{name:"episode",sortType:"asInt"},{name:"season",sortType:"asInt"},"tvshow_extra","tvshow_summary","tvshow_index"]}},sortInfo:{field:"title",direction:"asc"},remoteSort:true,constructor:function(){this.callParent(arguments)},createSortFunction:function(c,b){b=b||"asc";var a=b.toLowerCase()=="desc"?-1:1;var d=this.fields.get(c).sortType;return function(f,e){if(Ext.isEmpty(f.data[c])&&Ext.isEmpty(e.data[c])){return 0}else{if(Ext.isEmpty(f.data[c])){return a*1}else{if(Ext.isEmpty(e.data[c])){return a*-1}else{var h=d(f.data[c]),g=d(e.data[c]);return a*(h>g?1:(h<g?-1:0))}}}}}});Ext.define("SYNO.SDS.VideoStation2.Stores.schedule",{extend:"SYNO.SDS.VideoStation2.Stores",paramNames:{start:"start",limit:"limit",sort:"sort",dir:"dir"},synoAPI:"SYNO.DTV.Schedule",synoMethod:"list",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("schedule_recording.cgi"),reader:{id:"primeid",root:"schedules",totalProperty:"total",fields:["channel_name","description","duration","id","is_userdefine","primeid","start","start_time","status","title","weekday"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.channel",{extend:"Ext.data.JsonStore",constructor:function(b){var a={id:"id",fields:["channel","id","program","scrambled","title","streaming"]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Stores.program",{extend:"Ext.data.JsonStore",constructor:function(b){var a={id:"id",fields:["id","start_time","title","status","description","duration","finalprogram","schedule","channel_id","channel_name"],sortInfo:{field:"start_time",direction:"asc"}};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Stores.bychannel",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVRecording",synoMethod:"list_channel",baseConfigs:{baseParams:{offset:0,limit:120,preview_video:4},reader:{root:"channel",totalProperty:"total",fields:["title","preview_video"]}}});Ext.define("SYNO.SDS.VideoStation2.Stores.byprogram",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVRecording",synoMethod:"list_program",baseConfigs:{baseParams:{offset:0,limit:120,preview_video:4},reader:{root:"program",totalProperty:"total",fields:["title","preview_video"]}}});Ext.define("SYNO.SDS.VideoStation2.Playlist",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded",EVENT_PLAYLIST_CHANGED:"playlistchanged",EVENT_PLAYLIST_CLEARED:"playlistcleared",TYPE_ORIGIONAL:"original",TYPE_SMART:"smart",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Playlist.instance)){SYNO.SDS.VideoStation2.Playlist.instance=new SYNO.SDS.VideoStation2.Playlist()}return SYNO.SDS.VideoStation2.Playlist.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)},getStore:function(){this.playlist_store=this.playlist_store||new SYNO.SDS.VideoStation2.Stores.playlist({listeners:{scope:this,load:function(b,a){var c=a.map(function(d){var e=d.data;switch(e.id){case -1:e.playlist_title=_VST("playlist","favorite");break;case -2:e.playlist_title=_VST("playlist","watchlist");break;case -3:e.playlist_title=_VST("playlist","default_shared");break;default:e.playlist_title=e.title;break}return e});this.current_playlists=c;this.dirty=false;this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)}}});return this.playlist_store},loadPlaylists:function(){if(this.isDirty()){this.getStore().load()}else{this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)}},selectPlaylist:function(b,a){SYNO.Assert(Ext.isNumber(b)&&b>=-3,String.format("unexpceted playlist info {0}",b));this.current_id=b;this.current_path_title=a;this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED)},clearSelection:function(){this.current_id=null;this.current_path_title=null;this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CLEARED)},markDirty:function(){this.dirty=true},isSet:function(){return Ext.isNumber(this.current_id)},getCurrentPlaylists:function(){return this.current_playlists},getCurrentID:function(){return this.current_id},getCurrentPathTitle:function(){return this.current_path_title},getPlaylistByID:function(a){if(!this.current_playlists){return undefined}return this.current_playlists.filter(function(b){return b.id===a})[0]},isDirty:function(){return this.dirty},current_id:null,current_path_title:null,current_playlists:null,dirty:true,playlist_store:null});Ext.define("SYNO.SDS.VideoStation2.OP",{statics:{defaultFailureCallback:function(e,d,a){var b=a&&a.params&&a.params.api;var c=SYNO.SDS.VideoStation2.Error.getAPIErrorString(e,b);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",c)},sendRequest:function(d,h,b,f,g,a,c){var e=SYNO.API.Request({api:d,method:h,version:b,params:f,callback:function(l,k,j,i){if(!l){if(Ext.isFunction(e.failure_callback)){e.failure_callback.call(this,k,j,i)}else{SYNO.SDS.VideoStation2.OP.defaultFailureCallback(k,j,i)}return}if(Ext.isFunction(e.success_callback)){e.success_callback.call(this,k,j,i)}},scope:c});e.success_callback=g;e.failure_callback=a;return e},compound:function(g,f,b,e){f=Ext.isFunction(f)?f:Ext.emptyFn;b=Ext.isFunction(b)?b:Ext.emptyFn;e=e||window;var c=0;var a=0;var d=function(){if(c!==g.length){return}if(a===0){f.apply(e)}else{b.apply(e)}};g.each(function(j){var h=Ext.isFunction(j.success_callback)?j.success_callback:Ext.emptyFn;var i=Ext.isFunction(j.failure_callback)?j.failure_callback:Ext.emptyFn;j.success_callback=function(){h.apply(this,arguments);c+=1;d()};j.failure_callback=function(){i.apply(this,arguments);c+=1;a+=1;d()}})},abort:function(a){Ext.Ajax.abort(a)},classifyRequest:function(c,e,h,a,d){e=Ext.isFunction(e)?e:Ext.emptyFn;h=Ext.isFunction(h)?h:Ext.emptyFn;a=Ext.isFunction(a)?a:Ext.emptyFn;d=d||window;var g=SYNO.SDS.VideoStation2.Util.classifyVideos(c);var b=Object.keys(g);var f=b.map(function(i){return e.call(d,g,i)}).filter(function(i){return i});SYNO.SDS.VideoStation2.OP.compound(f,h,a,d)},pollingRequest:function(h,e,i,b,d){var f=null;var a=function(){if(f){SYNO.SDS.VideoStation2.OP.abort(f);f=null}f=SYNO.SDS.VideoStation2.OP.get()[h](c.params,i,d)};var c=SYNO.SDS.VideoStation2.Window.addTask({interval:b,run:a});var g=c.stop;c.stop=function(){if(f){Ext.Ajax.abort(f);f=null}g.apply(c,arguments)};c.params=e;c.start(true);return c},instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.OP.instance)){SYNO.SDS.VideoStation2.OP.instance=new SYNO.SDS.VideoStation2.OP()}return SYNO.SDS.VideoStation2.OP.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);var a={getVideoStationInfo:["SYNO.VideoStation2.Info","get",1],getInfo:[SYNO.SDS.VideoStation2.Util.getAPIName,"getinfo",1],addVideoToPlaylist:["SYNO.VideoStation2.Collection","add_video",1],removeVideoFromPlaylist:["SYNO.VideoStation2.Collection","delete_video",1],setVideoWatched:[SYNO.SDS.VideoStation2.Util.getAPIName,"set_watched",1],setVideoRating:[SYNO.SDS.VideoStation2.Util.getAPIName,"set_rating",1],deleteVideo:[SYNO.SDS.VideoStation2.Util.getAPIName,"delete",1],deleteFile:["SYNO.VideoStation2.File","delete",1],getFileTrackInfo:["SYNO.VideoStation2.File","get_track_info",1],getPublicSharing:["SYNO.VideoStation2.Sharing","get",1],setPublicSharing:["SYNO.VideoStation2.Sharing","set",1],createPlaylist:["SYNO.VideoStation2.Collection","create",1],createSmartPlaylist:["SYNO.VideoStation2.Collection","create_smart",1],deletePlaylist:["SYNO.VideoStation2.Collection","delete",1],editPlaylist:["SYNO.VideoStation2.Collection","edit",1],editSmartPlaylist:["SYNO.VideoStation2.Collection","edit_smart",1],listPlayer:["SYNO.VideoStation2.Controller.Device","list",1],listMetadata:["SYNO.VideoStation.Metadata","list",2],searchSubtitle:["SYNO.VideoStation2.Subtitle","search",1],downloadSubtitle:["SYNO.VideoStation2.Subtitle","download",1],listAudioTrack:["SYNO.VideoStation.AudioTrack","list",1],setPoster:["SYNO.VideoStation2.Poster","set",1],deletePoster:["SYNO.VideoStation2.Poster","delete",1],setBackdrop:["SYNO.VideoStation2.Backdrop","add",1],deleteAllBackdrop:["SYNO.VideoStation2.Backdrop","delete_all",1],editMetadata:[SYNO.SDS.VideoStation2.Util.getAPIName,"edit",1],editMetadataAdv:["SYNO.VideoStation2.TVShowEpisode","edit_adv",1],startSearchMetadata:["SYNO.VideoStation2.PluginSearch","start",1],listSearchMetadata:["SYNO.VideoStation2.PluginSearch","list",1],querySearchMetadata:["SYNO.VideoStation2.PluginSearch","query",1],stopSearchMetadata:["SYNO.VideoStation2.PluginSearch","stop",1],listChannel:["SYNO.DTV.Channel","list",1],editChannel:["SYNO.DTV.Channel","edit",1],listProgram:["SYNO.DTV.Program","list",1],searchProgram:["SYNO.DTV.Program","search",1],liveStreaming:["SYNO.DTV.Controller","setchannel",1],createRecording:["SYNO.DTV.Schedule","create",1],createRepeatRecording:["SYNO.DTV.Schedule","create_repeat",1],createSchedule:["SYNO.DTV.Schedule","create_userdefine",1],deleteSchedule:["SYNO.DTV.Schedule","delete",1],deleteRepeatSchedule:["SYNO.DTV.Schedule","delete_repeat",1],deletePassSchedule:["SYNO.DTV.Schedule","delete_passed",1],getScheduleInfo:["SYNO.DTV.Schedule","getinfo_userdefine",1],getRepeatScheduleInfo:["SYNO.DTV.Schedule","getinfo_repeat",1],editSchedule:["SYNO.DTV.Schedule","edit_userdefine",1],editRepeatSchedule:["SYNO.DTV.Schedule","edit_repeat",1],getChannelScanConfig:["SYNO.DTV.ChannelScan","getconfig",1],getSatelliteScanConfig:["SYNO.DTV.DVBSScan","getconfig",1],getChannelScanCountry:["SYNO.DTV.ChannelScan","getcountry",1],getChannelScanRegion:["SYNO.DTV.ChannelScan","getregion",1],getSatelliteScanSatellite:["SYNO.DTV.DVBSScan","get_satellite",1],getSatelliteScanLNB:["SYNO.DTV.DVBSScan","get_lnb",1],startChannelScan:["SYNO.DTV.ChannelScan","start",1],startSatelliteScan:["SYNO.DTV.DVBSScan","start",1],stopChannelScan:["SYNO.DTV.ChannelScan","stop",1],stopSatelliteScan:["SYNO.DTV.DVBSScan","stop",1],getChannelScanStatus:["SYNO.DTV.ChannelScan","status",1],getSatelliteScanStatus:["SYNO.DTV.DVBSScan","status",1],createSatellite:["SYNO.DTV.DVBSScan","create_satellite",1],editSatellite:["SYNO.DTV.DVBSScan","edit_satellite",1],deleteSatellite:["SYNO.DTV.DVBSScan","delete_satellite",1],createLNB:["SYNO.DTV.DVBSScan","create_lnb",1],editLNB:["SYNO.DTV.DVBSScan","edit_lnb",1],deleteLNB:["SYNO.DTV.DVBSScan","delete_lnb",1],getTransponder:["SYNO.DTV.DVBSScan","get_tp",1],getDefaultTransponder:["SYNO.DTV.DVBSScan","get_tp_default",1],saveTransponder:["SYNO.DTV.DVBSScan","save_tp",1],updateProgramGuide:["SYNO.DTV.Program","update",1],getTunerInfo:["SYNO.DTV.Tuner","getinfo",1],getDTVChannel:["SYNO.DTV.Controller","getchannel",1],getDTVChannelInfo:["SYNO.DTV.Channel","getinfo",1],getDTVStatistic:["SYNO.DTV.Statistic","getinfo",1],listTuner:["SYNO.DTV.Tuner","list",1],stopOfflineConversionTask:["SYNO.VideoStation.OfflineConversion","stop",1],restartOfflineConversionTask:["SYNO.VideoStation.OfflineConversion","restart",1],deleteOfflineConversionTask:["SYNO.VideoStation.OfflineConversion","delete",1],setLibraryVisibility:["SYNO.VideoStation2.Library","set_visibility",1]};Ext.iterate(a,function(c,d,b){this[c]=function(h,j,e){var g=Ext.isFunction(d[0])?d[0](e):d[0];var i=d[1];var f=d[2];return SYNO.SDS.VideoStation2.OP.sendRequest(g,i,f,h,j.success,j.failure,j.scope)}},this)}});Ext.define("SYNO.SDS.VideoStation2.PlaylistController",{statics:{loadPlaylists:function(){SYNO.SDS.VideoStation2.Playlist.get().loadPlaylists()},doPlaylistRequest:function(d,c,a,f,e){a=Ext.isFunction(a)?a:Ext.emptyFn;f=Ext.isFunction(f)?f:Ext.emptyFn;e=e||window;var b=function(g){a.call(e,g);SYNO.SDS.VideoStation2.Playlist.get().markDirty();SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists()};SYNO.SDS.VideoStation2.OP.get()[d](c,{success:b,failure:f,scope:e})},addVideoToPlaylist:function(a,b,c){SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(a,b,true,c)},removeVideoFromPlaylist:function(a,b,c){SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(a,b,false,c)},setVideoWithPlaylist:function(b,c,a,e){var d=b.map(function(f){return{video_id:f.id,video_type:f.type}});SYNO.SDS.VideoStation2.OP.get()[(a)?"addVideoToPlaylist":"removeVideoFromPlaylist"]({id:c,video:d},{success:function(){SYNO.SDS.VideoStation2.Playlist.get().markDirty();e()}})},applyPlaylistChangeToVideo:function(b,c,a){b.each(function(e){if(!e.record){return}var d=e.record.get("additional");d.collection=d.collection||[];if(a){d.collection.push({id:c.id,title:c.title})}else{d.collection=d.collection.filter(function(f){return f.id!==c.id})}e.record.set("additional",d)});SYNO.SDS.VideoStation2.Playlist.get().markDirty()},createPlaylistActions:function(e,j){var a=Ext.isFunction(e.clsFn)?e.clsFn:Ext.emptyFn;var h=Ext.isFunction(e.hideOnClickFn)?e.hideOnClickFn:Ext.emptyFn;var b=Ext.isFunction(e.createPlaylistFn)?e.createPlaylistFn:Ext.emptyFn;var c=Ext.isFunction(e.clickPlaylistFn)?e.clickPlaylistFn:Ext.emptyFn;var f=function(k){return -3!==k.id&&SYNO.SDS.VideoStation2.Constant.PLAYLIST_TYPE.ORIGINAL===k.type};var g=Ext.isFunction(e.filterPlaylistFn)?e.filterPlaylistFn:f;var d=[new Ext.Action({text:_VST("playlist","action_create"),scope:j,handler:b})];var i=SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists().filter(g);if(!i){return d}return d.concat(i.map(function(k){return new Ext.menu.Item({text:k.playlist_title,scope:j,itemId:k.id.toString(),cls:a.call(j,k)||"",hideOnClick:h.call(j,k)||false,disabled:false,handler:c})}))}}});Ext.define("SYNO.SDS.VideoStation2.Checkbox",{extend:"SYNO.ux.Checkbox",xtype:"syno_vs_checkbox",checkIconCls:"syno-vs2-checkbox syno-ux-checkbox-icon",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.DateField",{extend:"SYNO.ux.DateField",xtype:"syno_vs_datefield",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-datefield")},onTriggerClick:function(){this.callParent(arguments);if(!this.menu.el.hasClass("syno-vs2-datefield-menu")){this.menu.addClass("syno-vs2-datefield-menu")}}});Ext.define("SYNO.SDS.VideoStation2.FormPanel",{extend:"SYNO.ux.FormPanel",xtype:"syno_vs_form",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-form")}});Ext.define("SYNO.SDS.VideoStation2.TextField",{extend:"SYNO.ux.TextField",xtype:"syno_vs_textfield",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-textfield");this.addClass("syno-vs2-base-textfield")}});Ext.define("SYNO.SDS.VideoStation2.PlaylistSharingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",playlist:null,editable:null,constructor:function(b){var a={layout:"fit",width:450,height:(b.editable)?230:120,buttons:[this.doneBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.onDoneBtn}),this.openLinkBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","open_link"),scope:this,handler:this.onOpenLinkBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel(b)],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED,this.onPlaylistSharingChanged,this)},onAfterRender:function(){this.setTitle(String.format(_VST("playlist","link_to"),this.playlist.playlist_title));this.firePlaylistLoaded()},onDoneBtn:function(){if(!this.panel.isValid()){return}if(!this.panel.isDirty()){this.close();return}this.isFinalRequest=true;this.onPlaylistSharingChanged()},onOpenLinkBtn:function(){window.open(this.panel.getPublicSharingURL())},onPlaylistSharingChanged:function(){if(!this.panel.isValid()){return}this.setStatusBusy();var a=this.panel.getValues();a.id=this.playlist.id;SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editPlaylist",a,this.onPlaylistSharing,this.onPlaylistSharingFail,this)},onPlaylistSharing:function(){if(!this.waitingPlaylist){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)}this.waitingPlaylist=this.playlist.id},onPlaylistSharingFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onPlaylistLoaded:function(){this.clearStatusBusy();this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);if(this.isFinalRequest){this.close();return}this.playlist=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(this.waitingPlaylist);this.waitingPlaylist=null;this.firePlaylistLoaded()},firePlaylistLoaded:function(){var a=SYNO.Util.copy(this.playlist.additional.sharing_info);this.openLinkBtn.setDisabled(!a.enable_sharing);this.panel.fireEvent(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED,a)}});Ext.define("SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel",{statics:{EVENT_PLAYLIST_SHARING_CHANGED:"playlistsharingchanged",EVENT_PLAYLIST_SHARING_LOADED:"playlistsharingloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","action_share"),name:"enable_sharing",itemId:"enable_sharing",hidden:!b.editable,listeners:{scope:this,check:this.onEnableSharingChecked}},this.urlTextfield=new SYNO.SDS.VideoStation2.TextField({name:"url",cls:"selectabletext",itemId:"url",disabled:true,readOnly:true,selectOnFocus:true,hideLabel:true}),this.enableCustomizeDurationCheckbox=new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("playlist","customize_duration"),name:"enable_customize_duration",itemId:"enable_customize_duration",disabled:true,hidden:!b.editable}),this.customizeDurationFields=new SYNO.ux.CompositeField({hideLabel:true,disabled:true,indent:1,hidden:!b.editable,itemId:"customize_duration",items:[this.dateAvailableField=new SYNO.SDS.VideoStation2.DateField({name:"date_available",itemId:"date_available",editable:false,format:"Y-m-d",value:new Date()}),{xtype:"syno_vs_displayfield",value:"-",hideLabel:true},this.dateExpiredField=new SYNO.SDS.VideoStation2.DateField({name:"date_expired",itemId:"date_expired",editable:false,minValue:new Date(),format:"Y-m-d",value:new Date().add(Date.DAY,7),validator:this.customizeDurationValidator.createDelegate(this)})]})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED);this.mon(this,SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED,this.onPlaylistSharingLoaded,this);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_sharing",["url","enable_customize_duration"]),new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_customize_duration",["customize_duration"])]},customizeDurationValidator:function(a){if(this.dateAvailableField.getValue()>this.dateExpiredField.getValue()){return _VST("playlist","error_exp_before_avail")}return true},isValid:function(){return this.getForm().isValid()},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getPublicSharingURL:function(){return this.getForm().getValues().url},getValues:function(){var a=this.getForm().getValues();if(a.enable_customize_duration!=="true"){delete a.date_available;delete a.date_expired}a.enable_sharing=(a.enable_sharing==="true");delete a.enable_customize_duration;return a},onPlaylistSharingLoaded:function(a){if(!a.date_available||a.date_available==="0"||!a.date_expired||a.date_expired==="0"){a.enable_customize_duration=false;delete a.date_available;delete a.date_expired}else{a.enable_customize_duration=true}this.getForm().setValues(a);this.oriValue=this.getValues()},onEnableSharingChecked:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED)}});Ext.define("SYNO.SDS.VideoStation2.CreatePlaylistDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",forcePublicSharing:null,smartPlaylist:null,videos:null,constructor:function(b){var a={layout:"fit",width:560,height:280,title:(b.smartPlaylist)?_VST("playlist","action_create_smart"):(b.forcePublicSharing)?_VST("advanced","public_sharing"):_VST("playlist","action_create"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.CreatePlaylistDialog.Panel(b)]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){if(!this.panel.isValid()){return}this.setStatusBusy();var a=this.panel.getValues();if(this.smartPlaylist){var b=Ext.apply({type:SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType(),library_id:[SYNO.SDS.VideoStation2.Library.get().getCurrentID()]},SYNO.SDS.VideoStation2.Filter.get().getFilterOption());Ext.apply(b,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());a.filter_info=b;SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("createSmartPlaylist",a,this.onCreatePlaylist,this.onCreatePlaylistFail,this)}else{SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("createPlaylist",a,this.onCreatePlaylist,this.onCreatePlaylistFail,this)}},onCreatePlaylist:function(a){if(!this.waitingPlaylist){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)}this.waitingPlaylist=a.id},onCreatePlaylistFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onPlaylistLoaded:function(){this.clearStatusBusy();this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);var b=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(this.waitingPlaylist);this.waitingPlaylist=null;if(!this.smartPlaylist){SYNO.SDS.VideoStation2.PlaylistController.addVideoToPlaylist(this.videos,b.id,this.onVideoAdded.createDelegate(this,[b]))}if(this.forcePublicSharing){var a=new SYNO.SDS.VideoStation2.PlaylistSharingDialog({owner:this.owner,playlist:b});a.open()}this.close()},onVideoAdded:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.CreatePlaylistDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var c=SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing();var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_displayfield",value:_VST("playlist","share_desc"),hideLabel:true,hidden:!b.forcePublicSharing||!c},this.titleTextField=new SYNO.SDS.VideoStation2.TextField({fieldLabel:_VST("playlist","playlist_name"),name:"title",itemId:"title"}),{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","action_share"),name:"enable_sharing",hidden:b.forcePublicSharing||!c,checked:b.forcePublicSharing&&c},{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","customize_duration"),hidden:!c,name:"enable_customize_duration",itemId:"enable_customize_duration"},this.customizeDurationFields=new SYNO.ux.CompositeField({hidden:!c,hideLabel:true,disabled:true,indent:1,itemId:"customize_duration",items:[this.dateAvailableField=new SYNO.SDS.VideoStation2.DateField({name:"date_available",itemId:"date_available",editable:false,format:"Y-m-d",value:new Date()}),{xtype:"syno_vs_displayfield",value:"-",hideLabel:true},this.dateExpiredField=new SYNO.SDS.VideoStation2.DateField({name:"date_expired",itemId:"date_expired",editable:false,minValue:new Date(),format:"Y-m-d",value:new Date().add(Date.DAY,7),validator:this.customizeDurationValidator.createDelegate(this)})]})],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_customize_duration",["customize_duration"])]},customizeDurationValidator:function(a){if(this.dateAvailableField.getValue()>this.dateExpiredField.getValue()){return _VST("playlist","error_exp_before_avail")}return true},getValues:function(){var a=this.getForm().getValues();if(a.enable_customize_duration!=="true"){delete a.date_available;delete a.date_expired}a.enable_sharing=(a.enable_sharing==="true");delete a.enable_customize_duration;return a},isValid:function(){return this.getForm().isValid()},onAfterRender:function(){var a=_VST("playlist","untitled_name");var b=SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists();var c=b.filter(function(d){return d.title.substr(0,a.length)===a}).length;if(c>0){a=a+String.format(" ({0})",c)}this.titleTextField.setValue(a)}});Ext.define("SYNO.SDS.VideoStation2.SuperBox",{statics:{CLASS_MENU_EXPANDED:"menu-expanded"},extend:"SYNO.ux.SuperBoxSelect",xtype:"syno_vs_superbox",listClass:"syno-vs2-combobox-list",extraItemCls:"syno-vs2-superbox-item",ctCls:"syno-vs2-superbox",constructor:function(){this.callParent(arguments);this.mon(this,"expand",this.addExpandedClass,this);this.mon(this,"collapse",this.removeExpandedClass,this)},addExpandedClass:function(){this.addClass(SYNO.SDS.VideoStation2.SuperBox.CLASS_MENU_EXPANDED)},removeExpandedClass:function(){this.removeClass(SYNO.SDS.VideoStation2.SuperBox.CLASS_MENU_EXPANDED)},onDestroy:function(){this.mun(this,"expand",this.addExpandedClass,this);this.mun(this,"collapse",this.removeExpandedClass,this);this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",playlist:null,constructor:function(c){this.playlist=c.playlist;var a=[this.panel=new SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel(Ext.apply({anchor:"100%"},c))];if(this.isSmart()){a.push(this.smartPanel=new SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel(Ext.apply({anchor:"100% -35",hidden:true},c)))}var b={layout:"anchor",width:560,height:280,padding:"0 20",buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:a,listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(b,c)])},onClose:function(){SYNO.SDS.BaseWindow.superclass.destroy.call(this);return false},isSmart:function(){return this.playlist.type===SYNO.SDS.VideoStation2.Playlist.TYPE_SMART},isValid:function(){var a=this.panel.isValid();if(this.isSmart()){a=this.smartPanel.isValid()&&a}return a},isDirty:function(){var a=this.panel.isDirty();if(this.isSmart()){a=this.smartPanel.isDirty()||a}return a},getValues:function(){var a=this.panel.getValues();a.id=parseInt(a.id,10);if(this.isSmart()){var b=this.playlist.additional.filter_info;var c=this.smartPanel.getValues();c.type=b.type;c.library_id=b.library_id;a.filter_info=c}return a},onOKBtn:function(){if(!this.isValid()){return}if(!this.isDirty()){this.close();return}this.setStatusBusy();if(this.isSmart()){SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editSmartPlaylist",this.getValues(),this.onEditPlaylist,this.onEditPlaylistFail,this)}else{SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editPlaylist",this.getValues(),this.onEditPlaylist,this.onEditPlaylistFail,this)}},onAfterRender:function(){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED,this.playlist);if(this.isSmart()){this.smartPanel.fireEvent(SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED,this.playlist);this.smartPanel.show();this.setTitle(_VST("playlist","action_edit_smart"))}else{this.setTitle(_VST("playlist","action_edit"))}},onEditPlaylist:function(){this.clearStatusBusy();this.close()},onEditPlaylistFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={height:35,defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_numberfield",name:"id",itemId:"id",hidden:true},this.titleTextField=new SYNO.SDS.VideoStation2.TextField({fieldLabel:_VST("playlist","playlist_name"),name:"title",itemId:"title"})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED);this.mon(this,SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)},getValues:function(){return this.getForm().getValues()},isValid:function(){return this.getForm().isValid()},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},onPlaylistLoaded:function(a){this.getForm().setValues(a);this.oriValue=this.getValues()}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(c){var d=c.playlist.additional.filter_info.type;var a=d===SYNO.SDS.VideoStation2.Constant.TV_RECORDING?this.getTVRecordItems():this.getNormalLibraryItems();a.push({xtype:"syno_vs_textfield",itemId:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,name:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)});var b={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:a};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED);this.mon(this,SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)},getValues:function(){var a={};this.items.each(function(b){var c=b.getValue();if(!c||(Ext.isArray(c)&&c.length===0)){return}a[b.name]=c});return a},isValid:function(){return this.getForm().isValid()},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getFilterOption:function(){var a={};Ext.iterate(this.getValues(),function(b,c){if(b==="keyword"){return}a[b]=c});Ext.apply(a,{type:this.type,library_id:this.library_id});return a},createOptionItem:function(c){var b=[SYNO.SDS.VideoStation2.Filter.FILTER_RATING,SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,SYNO.SDS.VideoStation2.Filter.FILTER_DURATION];var a={category:c,itemId:c,name:c,getFilterOption:this.getFilterOption.createDelegate(this),listeners:{scope:this,valuechanged:this.doLayout}};if(b.indexOf(c)!==-1){return new SYNO.SDS.VideoStation2.EditPlaylistDialog.LocalOption(a)}else{return new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(a)}},getNormalLibraryItems:function(){var a=[SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,SYNO.SDS.VideoStation2.Filter.FILTER_RATING,SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,SYNO.SDS.VideoStation2.Filter.FILTER_DURATION];return a.map(function(b){return this.createOptionItem(b)},this)},getTVRecordItems:function(){var a=[SYNO.SDS.VideoStation2.Filter.FILTER_DATE,SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME,SYNO.SDS.VideoStation2.Filter.FILTER_TITLE,SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,SYNO.SDS.VideoStation2.Filter.FILTER_DURATION];return a.map(function(b){return this.createOptionItem(b)},this)},onPlaylistLoaded:function(b){var a=b.additional.filter_info;this.type=a.type;this.library_id=a.library_id;Ext.iterate(a,function(c,d){if(c==="type"||c==="library_id"||c==="keyword"){return}var e=this.getComponent(c);if(!e||e.local){return}d.each(function(f){e.addNewItem({key:f,value:f})})},this);this.getForm().setValues(a);this.oriValue=this.getValues()}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",{extend:"SYNO.SDS.VideoStation2.SuperBox",category:null,type:null,library_id:null,local:false,getFilterOption:Ext.emptyFn,constructor:function(c){var b=c.local||this.local;var d=c.category||this.category;var a={valueField:"value",displayField:"key",triggerAction:"all",mode:b?"local":"remote",minChars:2,allowQueryAll:true,pageSize:300,editable:true,grow:true,typeAhead:true,allowAddNewData:true,addNewDataOnBlur:true,fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(d),store:this.getStore(c)};this.callParent([Ext.apply(a,c)])},getStore:function(a){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this._store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{category:this.category});Ext.apply(c,this.getFilterOption());delete c[this.category]},getValue:function(){var a=[];this.items.each(function(b){a.push(b.value)});return a},findRecord:function(c,b){var a;if(this.store.getCount()>0){this.store.each(function(d){if(SYNO.ux.Utils.checkObjectConsistency(d.data[c],b)){a=d;return false}})}return a}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.LocalOption",{extend:"SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",local:true,constructor:function(a){this.callParent(arguments)},getStore:function(a){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.getLocalFilterData(a.category)});return this._store}});Ext.define("SYNO.SDS.VideoStation2.PlaylistActionController",{statics:{ACTION_DELETE:"action_delete",ACTION_SHARE:"action_share",ACTION_EDIT:"action_edit",getAllActions:function(){return[SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE,SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE,SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT]},doPlaylistAction:function(b,a){switch(b){case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE:return SYNO.SDS.VideoStation2.PlaylistActionController.deletePlaylist(a);case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE:return SYNO.SDS.VideoStation2.PlaylistActionController.sharePlaylist(a);case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT:return SYNO.SDS.VideoStation2.PlaylistActionController.editPlaylist(a);default:SYNO.Debug.error(String.format("unknown playlist action {0}",b))}},deletePlaylist:function(a){var b=_VST("playlist","delete_confirm");SYNO.SDS.VideoStation2.Window.getMsgBox().confirmDelete("",b,function(c){if("yes"===c){SYNO.SDS.VideoStation2.PlaylistActionController.doDeletePlaylist(a)}})},doDeletePlaylist:function(a){SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("deletePlaylist",{id:a})},sharePlaylist:function(b){var c=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(b);var a=new SYNO.SDS.VideoStation2.PlaylistSharingDialog({owner:SYNO.SDS.VideoStation2.Window,playlist:c,editable:true});a.open()},editPlaylist:function(b){var c=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(b);var a=new SYNO.SDS.VideoStation2.EditPlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,playlist:c});a.open()},createSmartPlaylist:function(){var a=new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,smartPlaylist:true});a.open()}}});Ext.define("SYNO.SDS.VideoStation2.SourceDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){var a={title:_VST("video_info","source"),layout:"fit",cls:"source-dialog",width:460,height:480,minWidth:300,minHeight:280,padding:24,buttons:[{xtype:"syno_vs_button",text:_T("common","close"),scope:this,handler:this.close}],items:[this.panel=new SYNO.SDS.VideoStation2.SourceDialog.Panel()]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.SourceDialog.Panel",{extend:"Ext.DataView",constructor:function(b){var a={tpl:this.getTpl(),store:this.getStore(),cls:"source-list",itemSelector:"div.source-wrap"};this.callParent([Ext.apply(a,b)])},getTpl:function(){this.tpl=this.tpl||new Ext.XTemplate('<tpl for=".">','<div class="source-wrap {id}">',"{[this.getLink(values)]}","</div>","</tpl>",'<div class="desc">{[_VST("video_info", "source_description")]}</div>',{getLink:function(a){var b=String.format('<a target="_blank" class="link" href="{0}">{1}</a>',a.link,a.title);return String.format(_VST("video_info","license_under"),b)}});return this.tpl},getStore:function(){this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","link","title"],data:[{id:"atmovies",link:"http://www.atmovies.com.tw/home/",title:_VST("video_info","source_atmovies")},{id:"tmdb",link:"https://www.themoviedb.org/",title:_VST("video_info","tmdb")},{id:"freebase",link:"http://creativecommons.org/licenses/by/2.5/",title:_VST("video_info","cc_by")},{id:"TVDB",link:"http://creativecommons.org/licenses/by/3.0/us/",title:_VST("video_info","cc_by")},{id:"allocine",link:"http://www.allocine.fr/",title:_VST("video_info","allocine")}]});return this.store}});Ext.define("SYNO.SDS.VideoStation2.ImageSelector",{extend:"SYNO.SDS.Utils.ImageSelector",constructor:function(b){var a={state:"fromDS"};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vs2-dialog");this.addClass("syno-vs2-imageselector");this.tree_myimage.hide();this.tree_myimage.getSelectionModel().clearSelections();this.centerPanel.layout.setActiveItem(this.view);Ext.each(this.buttons,function(c){c.addClass("syno-vs2-button")})},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailUtil",{singleton:true,processVideoData:function(b){if(b.additional&&b.additional.collection){b.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(b.additional.collection)}var d={};try{d=Ext.decode((b.additional&&b.additional.extra))}catch(c){}var a=new SYNO.SDS.VideoStation2.ViewDetailUtil.PlusInfoHandler({plus_info:d});b.rating=b.rating/10;b.reference=a.collectReference();SYNO.SDS.VideoStation2.ViewDetailUtil.chooseDefaultFile(b)},chooseDefaultFile:function(a){a.default_file=Ext.max(a.additional.file,function(c,b){return c.filesize>b.filesize?1:-1})},getRatingTpl:function(a){if(Ext.isString(a.channel_name)){return""}var d="base";if(!Ext.isNumber(a.rating)||a.rating<0){d="none"}var b='<td ext:qtip="{0}"><div class="rating {1} {2}">{3}</div></td>';var e=(a.rating>=0)?a.rating.toString():_VST("metadata","unknown");var c=Ext.util.Format.round(a.rating,0);return[0,1,2,3,4].map(function(h){var g=String.format("star_{0}",(h+1));var i=c-h*2;var f;if(i<1){f=""}else{if(i===1){f='<div class="rating {0} half"></div>'}else{if(i>=2){f='<div class="rating {0}"></div>'}}}f=String.format(f,g);return String.format(b,e,g,d,f)}).join("")}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailUtil.PlusInfoHandler",{extend:"Ext.util.Observable",constructor:function(a){this.plus_info=a.plus_info||{};this.callParent(arguments)},collect:function(a,b){Ext.iterate(this.plus_info,function(c,d){Ext.iterate(d,function(e,f){if(!a(e)){return}Ext.iterate(f,function(h,g){b(h,g)})})})},collectReference:function(){var c={};var a=[];var b=function(e){return e===SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_REFERENCE};var d=function(f,h){if(Ext.isEmpty(h)){return}var g=f.toLowerCase();var e=String.format("{0}:{1}",g,h);if(e in c){return}Ext.each(SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler.REFERENCE_SOURCE,function(i){if(g===i.key){c[e]=true;a.push({title:i.title,url:SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler[i.url_fn](h)})}})};this.collect(b,d);return Ext.isEmpty(a)?null:a},calculateMaxRating:function(){var c=-1;var a=function(d){return d===SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_RATING};var b=function(e,d){c=Ext.max([c,d])};this.collect(a,b);return c<0?null:c}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler",{singleton:true,IMDB_LANGUAGE_MAP:{enu:"com",ger:"de",spn:"es",fre:"fr",ita:"it"},REFERENCE_SOURCE:[{key:SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_IMDB,title:_VST("imdb","title"),url_fn:"getIMDBURL"},{key:SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_ATMOVIE,title:_VST("video_info","source_atmovies"),url_fn:"getATMovieURL"},{key:SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_TMDB,title:_VST("video_info","tmdb"),url_fn:"getTMDBURL"}],getIMDBURL:function(b){var a=SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler.IMDB_LANGUAGE_MAP[_S("lang")]||"com";return String.format("http://www.imdb.{0}/title/{1}",a,b)},getATMovieURL:function(a){return String.format("http://synology.atmovies.com.tw:8088/film/?sid={0}",a)},getTMDBURL:function(a){return String.format("https://www.themoviedb.org/movie/{0}",a)}});Ext.define("SYNO.SDS.VideoStation2.GridPanel",{extend:"SYNO.ux.GridPanel",xtype:"syno_vs_gridpanel",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-gridpanel")}});Ext.define("SYNO.SDS.VideoStation2.PagingToolbar",{extend:"SYNO.ux.PagingToolbar",xtype:"syno_vs_paging",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-paging")}});Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",type:null,defaultQuery:null,onVideoMetadataSelected:Ext.emptyFn,constructor:function(b){var c=b.type||this.type;var a={title:_VST("action","search_correct"),layout:"border",cls:"internet-search-dialog",width:800,height:400,minWidth:200,minHeight:200,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",disabled:true,scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.form=new SYNO.SDS.VideoStation2.InternetSearchDialog.Form({enableEpisodeField:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE===c,region:"north"}),this.grid=new SYNO.SDS.VideoStation2.InternetSearchDialog.Grid({enableEpisodeField:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE===c,store:this.getStore(),region:"center"})],listeners:{scope:this,afterrender:this.onAfterRender,beforedestroy:this.onBeforeDestory,show:{fn:this.onShow,single:true}}};this.callParent([Ext.apply(a,b)]);this.mon(this.form,SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH,this.onSearch,this);this.mon(this.grid,SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE,this.onOKBtn,this);this.mon(this.grid,SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.internet_search({remoteSort:false,listeners:{scope:this,load:this.onLoadStore}});return this.store},clearPollingTask:function(){if(this.currentPollingTask){SYNO.SDS.VideoStation2.OP.abort(this.currentPollingTask);SYNO.SDS.VideoStation2.OP.get().stopSearchMetadata({task_id:this.currentPollingTask.params.task_id},{});this.start_time=0;this.currentPollingTask=null}},clearMetaRequest:function(){if(this.metaRequest){SYNO.SDS.VideoStation2.OP.abort(this.metaRequest);this.metaRequest=null}},getStoreState:function(){return this.grid.getStoreState()},updateStore:function(d,c){var b=this.getStore();b.storeOptions({params:c});var a=b.reader.readRecords({data:d});b.loadRecords(a,{add:false,params:c},true)},showStatusBusy:function(){this.setStatus({text:_T("common","loading"),iconCls:"syno-ux-statusbar-loading"})},hideStatusBusy:function(){this.clearStatus()},formMetadata:function(b){var a=new SYNO.SDS.VideoStation2.ViewDetailUtil.PlusInfoHandler({plus_info:b.extra});return{additional:{actor:b.actor,director:b.director,genre:b.genre,writer:b.writer,summary:b.summary,extra:b.extra,tvshow_extra:b.tvshow_extra,tvshow_summary:b.tvshow_summary},title:b.title,certificate:b.certificate,rating:a.calculateMaxRating()*10,tagline:b.tag_line,original_available:b.original_available,tvshow_original_available:b.tvshow_original_available,episode:parseInt(b.episode,10),season:parseInt(b.season,10),update_tvshow:this.form.getValues().preferlanguage,from_internet:true}},correctTVShowMetadata:function(a){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().querySearchMetadata({id:this.getStore().baseParams.id,type:this.type,data:a},{scope:this,success:this.onCorrectTVShowMetadata,failure:this.onRequestFail})},onBeforeDestory:function(){this.getStore().destroy()},onAfterRender:function(){this.form.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY,this.defaultQuery)},onShow:function(){SYNO.SDS.VideoStation2.Util.maskInfo(this.grid,_VST("search","desc"))},onCancelBtn:function(){this.clearMetaRequest();this.clearPollingTask();this.close()},onOKBtn:function(){var a=this.grid.getSelected();if(!a){return}if(this.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE){this.correctTVShowMetadata(a.data);return}this.onVideoMetadataSelected(this.formMetadata(a.data));this.clearMetaRequest();this.clearPollingTask();this.close()},onSearch:function(){SYNO.SDS.VideoStation2.Util.unmask(this.grid);this.setStatusBusy();this.clearMetaRequest();this.clearPollingTask();this.metaRequest=SYNO.SDS.VideoStation2.OP.get().startSearchMetadata(Ext.apply({type:this.type},{query:this.form.getValues().title,prefer_lang:this.form.getValues().preferlanguage,season:parseInt(this.form.getValues().season,10),episode:parseInt(this.form.getValues().episode,10)}),{scope:this,success:this.onStartSearchMetadata,failure:this.onRequestFail})},onStartSearchMetadata:function(c,b,a){this.getStore().baseParams.id=c.id;this.startPolling();this.clearStatusBusy();this.showStatusBusy()},startPolling:function(){this.start_time=new Date().getTime();this.currentPollingTask=SYNO.SDS.VideoStation2.OP.get().listSearchMetadata(this.getStoreState(),{scope:this,success:this.onPollingSuccess,failure:this.onRequestFail});this.currentPollingTask.params=this.getStoreState()},onPollingSuccess:function(d,c,a){var b=new Date().getTime();this.updateStore(d,c);if("updated"===d.status){this.hideStatusBusy();return}setTimeout(this.startPolling.createDelegate(this),this.getPollingDelayTime(this.start_time,b,3000))},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)});this.clearMetaRequest();this.clearPollingTask()},onLoadStore:function(){var b=this.getStore();var a=this.grid.enableEpisodeField?["title","season","episode","summary"]:["title","summary"];b.sort(a.map(function(c){return{field:c,direction:"asc"}}),"asc")},onCorrectTVShowMetadata:function(c,b,a){this.clearStatusBusy();this.onVideoMetadataSelected(this.formMetadata(c.result));this.clearMetaRequest();this.clearPollingTask();this.close()},onSelectionChange:function(a){this.okBtn.setDisabled(!a)},getPollingDelayTime:function(c,b,a){var d=(b-c);if(d>a){return 0}return(a-d)}});Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog.Form",{statics:{EVENT_SEARCH:"search",EVENT_SET_QUERY:"setquery"},extend:"SYNO.SDS.VideoStation2.FormPanel",enableEpisodeField:false,constructor:function(c){var a=c.enableEpisodeField||this.enableEpisodeField;var b={defaults:{anchor:"100%"},updateFormForScrollbar:true,height:40,items:[{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"container",height:32,layout:"fit",flex:2,items:[{xtype:"syno_vs_textfilter",name:"title",itemId:"title",hideLabel:true,listeners:{scope:this,keypress:this.onFieldKeypress}}]},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:true,value:_VST("language","title")+": "},{xtype:"syno_vs_combobox",name:"preferlanguage",itemId:"preferlanguage",hideLabel:true,displayField:"display",valueField:"value",store:SYNO.SDS.VideoStation2.Util.getLangStore(),value:SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","search_lang")||"enu",flex:1,listeners:{scope:this,change:function(f,e,d){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","search_lang",e)}}},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:true,value:_VST("season","season_title")+": ",hidden:!a},{xtype:"syno_vs_numberfield",name:"season",itemId:"season",hideLabel:true,allowBlank:true,allowNegative:false,allowDecimals:false,disabled:!a,hidden:!a,flex:1,enableKeyEvents:true,listeners:{scope:this,keypress:this.onFieldKeypress}},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:true,value:_VST("episode","episode_title")+": ",hidden:!a},{xtype:"syno_vs_numberfield",name:"episode",itemId:"episode",hideLabel:true,allowBlank:true,allowNegative:false,allowDecimals:false,disabled:!a,hidden:!a,flex:1,enableKeyEvents:true,listeners:{scope:this,keypress:this.onFieldKeypress}},{xtype:"syno_vs_button",text:_VST("search","title"),scope:this,handler:this.fireSearch}]}]};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY);this.mon(this,SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY,this.onSetQuery,this)},onFieldKeypress:function(b,a){if(a.getKey()!==Ext.EventObject.ENTER){return}a.stopEvent();this.fireSearch()},onSetQuery:function(a){this.getForm().setValues(a)},getValues:function(){return this.getForm().getValues()},fireSearch:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH)}});Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog.Grid",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:500,enableEpisodeField:false,constructor:function(c){var a=c.enableEpisodeField||this.enableEpisodeField;var b={enableHdMenu:false,viewConfig:{trackResetOnLoad:false},bbar:new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:c.store,displayInfo:true,showRefreshBtn:true}),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("common","title"),dataIndex:"title",sortable:true},{header:a?String.format("{0} ({1})",_VST("original_available","title"),_VST("type","tv_show")):_VST("original_available","title"),dataIndex:a?"tvshow_original_available":"original_available",sortable:true},{header:_VST("episode","name_title"),dataIndex:"tag_line",sortable:true,hidden:!a},{header:_VST("season","season_title"),dataIndex:"season",sortable:true,hidden:!a},{header:_VST("episode","episode_title"),dataIndex:"episode",sortable:true,hiddne:!a},{header:a?String.format("{0} ({1})",_VST("summary","title"),_VST("episode","episode_title")):_VST("summary","title"),sortable:true,dataIndex:"summary"}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE)},getSelected:function(){return this.getSelectionModel().getSelected()},getStoreState:function(){var b=this.getStore();var a=b.getSortState();var c={};c[b.paramNames.start]=this.getBottomToolbar().cursor;c[b.paramNames.limit]=this.getBottomToolbar().pageSize;if(a){c[b.paramNames.sort]="tvshow_original_available"==a.field.toLowerCase()?"original_available":a.field.toLowerCase();c[b.paramNames.dir]=a.direction.toLowerCase()}c.task_id=b.baseParams.id;return c},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",type:null,library_id:null,defaultQuery:null,pageSize:500,onVideoMetadataSelected:Ext.emptyFn,constructor:function(b){b.type=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(b.type);var a={title:_VST("action","select_db"),layout:"border",cls:"video-metadata-choose-dialog",width:800,height:400,minWidth:200,minHeight:200,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",disabled:true,scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.form=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form({region:"north"}),this.grid=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid({pageSize:this.pageSize,store:this.getStore(b),region:"center"})],listeners:{scope:this,beforedestroy:this.onBeforeDestory}};this.callParent([Ext.apply(a,b)]);this.mon(this.form,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH,this.onSearch,this);this.mon(this.grid,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE,this.onOKBtn,this);this.mon(this.grid,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},getStore:function(a){if(!this.store){var b=a.type||this.type;this.store=new SYNO.SDS.VideoStation2.Stores[b]({autoLoad:true,listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}});this.store.on("beforeload",this.onFirstBeforeLoadStore,this,{single:true})}return this.store},onBeforeDestory:function(){this.getStore().destroy()},onFirstBeforeLoadStore:function(){this.form.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY,this.defaultQuery)},onOKBtn:function(){var a=this.grid.getSelected();if(!a){return}this.onVideoMetadataSelected(a.data);this.close()},onSearch:function(){this.getStore().load()},onBeforeLoadStore:function(b,c){this.setStatusBusy();var d=c.params;d.additional=SYNO.SDS.VideoStation2.Constant.ADDITIONAL_DICT[this.type];d.library_id=this.library_id;Ext.apply(d,this.form.getValues());var a={};a[b.paramNames.start]=0;a[b.paramNames.limit]=this.pageSize;Ext.applyIf(d,a)},onLoadStore:function(){this.clearStatusBusy()},onSelectionChange:function(a){this.okBtn.setDisabled(!a)}});Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form",{statics:{EVENT_SEARCH:"search",EVENT_SET_QUERY:"setquery"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,height:40,items:[{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"container",height:32,layout:"fit",flex:1,items:[{xtype:"syno_vs_textfilter",name:"keyword",itemId:"keyword",hideLabel:true,listeners:{scope:this,keypress:this.onFieldKeypress}}]},{xtype:"syno_vs_button",text:_VST("search","title"),scope:this,handler:this.fireSearch}]}]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY);this.mon(this,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY,this.onSetQuery,this)},onFieldKeypress:function(b,a){if(a.getKey()!==Ext.EventObject.ENTER){return}this.fireSearch()},onSetQuery:function(a){this.getForm().setValues({keyword:a.title})},getValues:function(){var a=this.getForm().getValues();if(Ext.isEmpty(a.keyword)){delete a.keyword}return a},fireSearch:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH)}});Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},extend:"SYNO.SDS.VideoStation2.GridPanel",constructor:function(b){var a={enableHdMenu:false,viewConfig:{trackResetOnLoad:false},bbar:new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:b.pageSize,store:b.store,displayInfo:true,showRefreshBtn:true}),colModel:new Ext.grid.ColumnModel({defaultSortable:true,columns:[{header:_VST("common","title"),dataIndex:"title"},{header:_VST("original_available","title"),dataIndex:"original_available"},{header:_VST("summary","title"),dataIndex:"summary"}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE)},getSelected:function(){return this.getSelectionModel().getSelected()},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.Toolbar",{statics:{EVENT_RESET:"reset",EVENT_IMPORT_METADATA:"importmetadata",EVENT_INTERNET_SEARCH:"internetsearch"},extend:"SYNO.ux.Toolbar",video:null,disableInternetSearch:false,disableSelectFromExisting:false,onBeforeOpenDialog:Ext.emptyFn,constructor:function(b){var c=b.disableInternetSearch||this.disableInternetSearch;var d=b.disableSelectFromExisting||this.disableSelectFromExisting;var a={items:[this.internetSearchBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","search_correct"),handler:this.onInternetSearchBtnClick,scope:this,hidden:c}),this.videoMetadataChooseBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","select_db"),handler:this.onVideoMetadataChooseBtnClick,scope:this,hidden:d}),this.resetBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","reset"),handler:this.onResetBtnClick,scope:this})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH);if(!c){this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH,this.onInternetSearchBtnClick,this)}},onResetBtnClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET)},onInternetSearchBtnClick:function(){var a=new SYNO.SDS.VideoStation2.InternetSearchDialog({type:this.video.type,owner:this.owner,defaultQuery:this.onBeforeOpenDialog(),onVideoMetadataSelected:this.onVideoMetadataSelected.createDelegate(this)});a.open()},onVideoMetadataChooseBtnClick:function(){var a=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog({type:this.video.type,library_id:this.video.library_id,owner:this.owner,defaultQuery:this.onBeforeOpenDialog(),onVideoMetadataSelected:this.onVideoMetadataSelected.createDelegate(this)});a.open()},onVideoMetadataSelected:function(a){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA,a)}});Ext.define("SYNO.SDS.VideoStation2.Radio",{extend:"SYNO.ux.Radio",xtype:"syno_vs_radio",checkIconCls:"syno-vs2-radio syno-ux-radio-icon",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.RadioGroup",{extend:"SYNO.ux.RadioGroup",xtype:"syno_vs_radiogroup",defaultType:"syno_vs_radio",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.Source",{extend:"SYNO.SDS.VideoStation2.Button",constructor:function(b){var a={text:_VST("video_info","source"),scope:this,handler:this.onClick};this.callParent([Ext.apply(a,b)])},onClick:function(){var a=new SYNO.SDS.VideoStation2.SourceDialog({owner:this.owner});a.open()}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.FileSelect",{statics:{EVENT_FILE_CHOOSE:"filechoose"},extend:"SYNO.SDS.VideoStation2.Button",gotoPath:null,constructor:function(b){var a={text:_VST("common","select"),scope:this,handler:this.onFileButtonClick};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE)},setGotoPath:function(a){this.gotopath=a},onFileButtonClick:function(){var a={owner:SYNO.SDS.VideoStation2.Window};if(this.gotopath){a.gotoPath=this.gotopath}var b=new SYNO.SDS.VideoStation2.ImageSelector(a);b.mon(b,"choose",function(c){this.onImageChoose(c);b.close()},this);b.open()},onImageChoose:function(a){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE,a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.MetaSelector",{extend:"SYNO.SDS.VideoStation2.SuperBox",type:null,library_id:null,category:null,owner:null,constructor:function(b){var c=b.category||this.category;var a={valueField:"key",displayField:"key",triggerAction:"all",mode:"remote",minChars:1,allowQueryAll:true,pageSize:300,editable:true,grow:true,queryParam:"match",typeAhead:true,allowAddNewData:true,addNewDataOnBlur:true,valueDelimiter:"|",fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(c),store:this.getStore()};this.callParent([Ext.apply(a,b)]);this.mon(this,"newitem",this.onNewItem,this)},getStore:function(a){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this.store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{type:this.type,library_id:[this.library_id],category:this.category,sort_by:this.category,sort_direction:"asc"})},onNewItem:function(b,a){b.addNewItem({key:a},true)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",{statics:{EVENT_META_LOADED:"metaloaded",EVENT_IMAGE_CHANGE:"imagechange",EVENT_POSTER_SET:"posterset",EVENT_BACKDROP_SET:"backdropset"},extend:"SYNO.SDS.VideoStation2.FormPanel",disableToolbar:false,disableInternetSearch:false,disableSelectFromExisting:false,allowSeasonEpisodeBlank:false,video:null,constructor:function(b){var c=b.video||this.video;var d=this.disableToolbar?null:new SYNO.SDS.VideoStation2.EditMetadata.Toolbar({video:c,owner:b.owner,disableInternetSearch:this.disableInternetSearch,disableSelectFromExisting:this.disableSelectFromExisting,onBeforeOpenDialog:this.onBeforeOpenToolbarDialog.createDelegate(this)});var a={bodyCssClass:"edit-metadata-meta-panel-body",title:Ext.isNumber(c.file)?_VST("action","correct_metadata"):_VST("metadata","title"),tbar:d,defaults:{anchor:"100%"},updateFormForScrollbar:true};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_IMAGE_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_BACKDROP_SET);this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.onMetaLoaded,this);if(d){this.mon(d,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET,this.onReset,this);this.mon(d,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA,this.onImportMetadata,this)}},getFileFieldConfig:function(a){var b=a.video||this.video;return[{xtype:"syno_vs_displayfield",fieldLabel:_VST("file","file_name"),name:"filename",itemId:"filename",hidden:!Ext.isNumber(b.file)},{xtype:"syno_vs_displayfield",fieldLabel:_VST("file","file_path"),name:"sharepath",itemId:"sharepath",hidden:!Ext.isNumber(b.file)}]},getChannelFieldConfig:function(a){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("schedule","channel"),name:"channel_name",itemId:"channel_name",readOnly:true}]},getTitleFieldConfig:function(a){var b=a.video||this.video;var c=_VST("common","title");switch(b.type){case SYNO.SDS.VideoStation2.Constant.TVSHOW:case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:c=_VST("tvshow","title");break;case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:c=_VST("programguide","title");break}return[{xtype:"syno_vs_textfield",fieldLabel:c,name:"title",itemId:"title",allowBlank:false,validator:this.lengthValidator.createDelegate(this,[255],true)}]},getTaglineFieldConfig:function(a){var b=a.video||this.video;return[{xtype:"syno_vs_textfield",fieldLabel:b.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?_VST("episode","name_title"):_VST("tagline","title"),name:"tagline",itemId:"tagline",validator:this.lengthValidator.createDelegate(this,[255],true)}]},getOriginalAvailableFieldConfig:function(a){var b=a.video||this.video;return[{xtype:"syno_vs_datefield",fieldLabel:b.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?String.format("{0} ({1})",_VST("original_available","title"),_VST("episode","episode_title")):_VST("original_available","title"),name:"original_available",itemId:"original_available",format:"Y-m-d",editable:false}]},getTVShowOriginalAvailableFieldConfig:function(a){return[{xtype:"syno_vs_datefield",fieldLabel:String.format("{0} ({1})",_VST("original_available","title"),_VST("type","tv_show")),name:"tvshow_original_available",itemId:"tvshow_original_available",format:"Y-m-d",editable:false}]},getSeasonFieldConfig:function(a){return[{xtype:"syno_vs_numberfield",fieldLabel:_VST("season","season_title"),name:"season",itemId:"season",allowDecimals:false,allowNegative:false,allowBlank:this.allowSeasonEpisodeBlank}]},getEpisodeFieldConfig:function(a){return[{xtype:"syno_vs_numberfield",fieldLabel:_VST("episode","episode_title"),name:"episode",itemId:"episode",allowDecimals:false,allowNegative:false,allowBlank:this.allowSeasonEpisodeBlank}]},getRecordDateFieldConfig:function(a){return[{xtype:"syno_compositefield",fieldLabel:_VST("video_info","record_time"),itemId:"record_date",items:[{xtype:"syno_vs_datefield",name:"record_date_date",itemId:"record_date_date",format:"Y-m-d",editable:false,allowBlank:false,flex:1},{xtype:"syno_vs_timefield",name:"record_date_time",itemId:"record_date_time",format:"H:i:s",editable:false,allowBlank:false,increment:1,flex:1}]}]},getCertificateFieldConfig:function(a){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("metadata","rating_classification"),name:"certificate",itemId:"certificate",validator:this.lengthValidator.createDelegate(this,[255],true)}]},getRatingFieldConfig:function(a){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("metadata","rating"),name:"rating",itemId:"rating",validator:this.ratingValidator.createDelegate(this)}]},getMetaSelectors:function(b){if(!this.metaSelectors){var c=b.video||this.video;var a={type:c.type,library_id:c.library_id,validator:this.lengthValidator.createDelegate(this,[255],true),listeners:{scope:this,valuechanged:this.doLayout}};this.metaSelectors=[new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,name:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE},a)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR},a)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,name:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER},a)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR},a))]}return this.metaSelectors},getMetadataLockFieldConfig:function(a){return[{xtype:"radiogroup",vertical:false,labelHtmlEncode:false,fieldLabel:String.format('{0}<img src="webman/resources/images/components/icon_information_mini.png" style="vertical-align:bottom;" border="0" ext:qtip="{1}">',_VST("lock","status"),Ext.util.Format.htmlEncode(_VST("lock","desc"))),itemId:"metadata_locked",items:[{xtype:"syno_vs_radio",boxLabel:_VST("lock","status_lock"),name:"metadata_locked",itemId:"metadata_locked_true",inputValue:"true"},{xtype:"syno_vs_radio",boxLabel:_VST("lock","status_unlock"),name:"metadata_locked",itemId:"metadata_locked_false",inputValue:"false"}]}]},getSummaryFieldConfig:function(a){return[{xtype:"syno_vs_textarea",fieldLabel:_VST("summary","title"),grow:true,growMax:200,name:"summary",itemId:"summary",validator:this.lengthValidator.createDelegate(this,[4096],true),listeners:{scope:this,autosize:this.doLayout}}]},getUpdateTVShowFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"update_tvshow",itemId:"update_tvshow",hidden:true}]},getExtraFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"extra",itemId:"extra",hidden:true}]},getTVShowExtraFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"tvshow_extra",itemId:"tvshow_extra",hidden:true}]},getSourceField:function(a){if(!this.sourceField){this.sourceField=new SYNO.ux.CompositeField({hideLabel:true,itemId:"source",items:[this.getSourceBtn(a)]});this.sourceField.innerCt.layoutConfig={pack:"end"}}return this.sourceField},getSourceBtn:function(a){this.sourceBtn=this.sourceBtn||new SYNO.SDS.VideoStation2.EditMetadata.Source(a);return this.sourceBtn},getBackdropFieldConfig:function(a){return[{xtype:"syno_vs_radiogroup",hideLabel:true,vertical:true,itemId:"backdrop",listeners:{scope:this,change:this.fireImageChange},items:[this.getImageOriginalRadio(a),this.getImageOriginalURLHiddenField(a),this.getImageClearRadio(a),this.getImageURLRadio(a),this.getImageURLField(a),this.getImageFileRadio(a),this.getImageFileSelectField(a),this.getImageFileField(a)]}]},getPosterFieldConfig:function(a){return[{xtype:"syno_vs_radiogroup",hideLabel:true,vertical:true,itemId:"poster",listeners:{scope:this,change:this.fireImageChange},items:[this.getImageOriginalRadio(a),this.getImageOriginalURLHiddenField(a),this.getImageClearRadio(a),this.getImageURLRadio(a),this.getImageURLField(a),this.getImageFileRadio(a),this.getImageFileSelectField(a),this.getImageFileField(a),{xtype:"syno_vs_displayfield",value:_VST("poster","set_image_desc"),hideLabel:true}]}]},getImageOriginalRadio:function(a){this.imageOriginalRadio=this.imageOriginalRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","original"),name:"image",itemId:"image_original",inputValue:"original",checked:true});return this.imageOriginalRadio},getImageURLRadio:function(a){this.imageURLRadio=this.imageURLRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","url"),name:"image",itemId:"image_url",inputValue:"url",listeners:{scope:this,check:function(b,c){this.getImageURLField().setDisabled(!c)}}});return this.imageURLRadio},getImageFileRadio:function(a){this.imageFileRadio=this.imageFileRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","select_existed_image"),name:"image",itemId:"image_file",inputValue:"file",listeners:{scope:this,check:function(b,c){this.getImageFileField().setDisabled(!c);this.getFileSelectTextField().setDisabled(!c);this.getFileSelectBtn().setDisabled(!c)}}});return this.imageFileRadio},getImageClearRadio:function(a){this.imageClearRadio=this.imageClearRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","no_image"),name:"image",itemId:"image_clear",inputValue:"clear"});return this.imageClearRadio},getImageOriginalURLHiddenField:function(a){this.imageOriginalURLHiddenField=this.imageOriginalURLHiddenField||new SYNO.SDS.VideoStation2.TextField({name:"original_url",itemId:"original_url",vtype:"url",hidden:true,listeners:{scope:this,change:this.fireImageChange}});return this.imageOriginalURLHiddenField},getImageURLField:function(a){this.imageURLField=this.imageURLField||new SYNO.SDS.VideoStation2.TextField({name:"url",itemId:"url",indent:1,vtype:"url",allowBlank:false,disabled:true,listeners:{scope:this,change:this.fireImageChange}});return this.imageURLField},getImageFileSelectField:function(a){this.imageFileSelectField=this.imageFileSelectField||new SYNO.ux.CompositeField({hideLabel:true,name:"file_select",itemId:"file_select",indent:1,items:[this.getFileSelectTextField(a),this.getFileSelectBtn(a)]});return this.imageFileSelectField},getFileSelectTextField:function(a){this.fileSelectTextField=this.fileSelectTextField||new SYNO.SDS.VideoStation2.TextField({name:"sharepath",itemId:"sharepath",allowBlank:false,disabled:true,readOnly:true,flex:1,listeners:{scope:this,change:this.fireImageChange}});return this.fileSelectTextField},getImageFileField:function(a){this.imageFileField=this.imageFileField||new SYNO.SDS.VideoStation2.TextField({name:"file",itemId:"file",allowBlank:false,disabled:true,readOnly:true,hidden:true});return this.imageFileField},getFileSelectBtn:function(a){if(!this.fileSelectBtn){this.fileSelectBtn=new SYNO.SDS.VideoStation2.EditMetadata.FileSelect({disabled:true});this.fileSelectBtn.mon(this.fileSelectBtn,SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE,this.onDSMFileChoose,this)}return this.fileSelectBtn},setMetaSelectorsValue:function(a){this.getMetaSelectors().each(function(c){var b=a.additional[c.itemId]||[];c.clearValue();b.each(function(d){c.addNewItem({key:d})})},this)},maybeSetFileValue:function(b){if(!Ext.isNumber(this.video.file)){return}var a=this.findFileFromData(b);if(!a){return}this.getForm().setValues({filename:a.sharepath.substr(a.sharepath.lastIndexOf("/")+1),sharepath:a.sharepath})},setImageFieldValue:function(a){this.getImageOriginalRadio().setValue(false);this.getImageURLRadio().setValue(false);this.getImageFileRadio().setValue(false);this.getImageClearRadio().setValue(false);switch(a.image){case"original":this.getImageOriginalRadio().setValue(true);if(Ext.isDefined(a.url)){this.getImageOriginalURLHiddenField().setValue(a.url)}break;case"url":this.getImageURLRadio().setValue(true);this.getImageURLField().setValue(a.url);break;case"file":this.getImageFileRadio().setValue(true);this.getFileSelectTextField().setValue(a.sharepath);this.getImageFileField().setValue(a.file);break;case"clear":this.getImageClearRadio().setValue(true);break}},getImageFieldValue:function(){var a={};if(this.getImageOriginalRadio().getValue()){a.image=this.getImageOriginalRadio().inputValue;a.url=this.getImageOriginalURLHiddenField().getValue()}else{if(this.getImageURLRadio().getValue()){a.image=this.getImageURLRadio().inputValue;a[this.getImageURLField().name]=this.getImageURLField().getValue()}else{if(this.getImageFileRadio().getValue()){a.image=this.getImageFileRadio().inputValue;a[this.getFileSelectTextField().name]=this.getFileSelectTextField().getValue();a[this.getImageFileField().name]=this.getImageFileField().getValue()}else{a.image=this.getImageClearRadio().inputValue}}}return a},findFileFromData:function(b){var a;Ext.each(b.additional.file,function(c){if(c.id===this.video.file){a=c;return false}},this);return a},correctOriginalAvailable:function(a){if(!Ext.isString(a)){return""}return(a.indexOf("-")===-1)?a+"-01-01":a},lengthValidator:function(b,a){return window.unescape(encodeURIComponent(b)).length<=a},getRatingSaveValue:function(a){return Ext.isEmpty(a)||(a<0||a>100)?-1:a*10},getRatingValue:function(a){a=a/10;if(a<0||a>10){return""}return a},ratingValidator:function(a){if(Ext.isEmpty(a)){return true}return a>=-1&&a<=10&&/^(10(\.0)?|[0-9](\.[0-9])?)$/.test(a)},fireImageChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_IMAGE_CHANGE)},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},isValid:function(){return this.getForm().isValid()},getImportMetadata:function(){return{raw:this.importRaw,value:this.importValue}},getOriValues:function(){return this.oriValue},getValues:Ext.emptyFn,setValues:Ext.emptyFn,isVideoChanged:function(){return false},hideMetadataLocked:function(){this.getComponent("metadata_locked").hide()},onMetaLoaded:function(a){this.setValues(a);this.oriRaw=a;this.oriValue=this.getValues();if(!a.hasOwnProperty("metadata_locked")){this.hideMetadataLocked()}},onReset:function(){this.setValues(this.oriRaw)},parseImageURL:function(c,b){var a=c.additional.extra;var d=SYNO.SDS.VideoStation2.Util.findValueInObject(a,b);if(!Ext.isDefined(d)){return}d=d.filter(function(e){return !Ext.isEmpty(e)});if(Ext.isEmpty(d)){return}return d[0]},onImportMetadata:function(d){this.setValues(d);this.importRaw=d;this.importValue=this.getValues();var b=(Ext.isDefined(d.from_internet)&&d.from_internet);var e=this.parseImageURL(d,"poster");var f={image:b?(Ext.isString(e)?"url":"clear"):"original",url:b?(Ext.isString(e)?e:""):SYNO.SDS.VideoStation2.Util.getImageURL({type:this.video.type,id:d.id})};this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET,f);var c=this.parseImageURL(d,"backdrop");var a={image:b?(Ext.isString(c)?"url":"clear"):"original",url:b?(Ext.isString(c)?c:""):SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:d.mapper_id})};this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_BACKDROP_SET,a)},onImageError:function(){switch(this.getValues().image){case"url":this.getImageURLField().markInvalid(_VST("error","image_format"));break;case"file":this.getFileSelectTextField().markInvalid(_VST("error","image_format"));this.getImageFileField().markInvalid(_VST("error","image_format"));break}},onDSMFileChoose:function(a){this.getFileSelectTextField().setValue(a.get("path"));this.getImageFileField().setValue(a.get("real_path"));this.fireImageChange()},onBeforeOpenToolbarDialog:function(){return this.getValues()}});Ext.define("SYNO.SDS.VideoStation2.OverwritePolicyDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",statics:{POLICY_SKIP:"skip",POLICY_OVERWRITE:"overwrite"},video:null,onPolicyChoosed:Ext.emptyFn,constructor:function(b){var c=b.video||this.video;var a={title:_VST("action","edit_metadata"),layout:"fit",cls:"overwrite-policy-dialog",width:475,height:280,minWidth:475,minHeight:280,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.OverwritePolicyDialog.Panel({video:c})]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){if(Ext.isFunction(this.onPolicyChoosed)){this.onPolicyChoosed.call(this,this.panel.getValues().policy)}this.close()}});Ext.define("SYNO.SDS.VideoStation2.OverwritePolicyDialog.Panel",{video:null,extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(d){var f=d.video||this.video;var c=f.library_id;var e=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(f.type);var a=SYNO.SDS.VideoStation2.Library.get().getLibraryByIDAndType(c,e)||{};var b={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_displayfield",hideLabel:true,itemId:"desc",value:String.format(_VST("metadata","duplicate_desc"),a.title)},{xtype:"syno_vs_radiogroup",hideLabel:true,itemId:"policy",items:[{boxLabel:_VST("metadata","duplicate_keep"),name:"policy",itemId:"policy_skip",inputValue:"skip",checked:true},{boxLabel:_VST("metadata","duplicate_replace"),name:"policy",itemId:"policy_overwrite",inputValue:"overwrite"}]}]};this.callParent([Ext.apply(b,d)])},getValues:function(){return this.getForm().getValues()}});Ext.define("SYNO.SDS.VideoStation2.TVShow",{statics:{EVENT_TVSHOW_CHANGED:"tvshowchanged",EVENT_SEASON_CHANGED:"seasonchanged",EVENT_AVAIL_SEASONS_LOADED:"availseasonsloaded",EVENT_TVSHOW_CLEARED:"tvshowcleared",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.TVShow.instance)){SYNO.SDS.VideoStation2.TVShow.instance=new SYNO.SDS.VideoStation2.TVShow()}return SYNO.SDS.VideoStation2.TVShow.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED)},selectTVShow:function(a){SYNO.Assert(Ext.isObject(a),["unexpceted tvshow",a]);var b=this.current_tvshow;this.current_tvshow=a;this.avail_seasons=null;this.current_season=null;this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,b,a)},updateTVShow:function(a){SYNO.Assert(Ext.isObject(a),["unexpceted tvshow",a]);this.current_tvshow=a},selectSeason:function(b){SYNO.Assert(Ext.isNumber(b),String.format("unexpceted season {0}",b));if(b!==this.current_season){var a=this.current_season;this.current_season=b;this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,a,b)}},setAvailableSeasons:function(a){SYNO.Assert(Ext.isArray(a),["unexpceted seasons",a]);if(!SYNO.ux.Utils.checkObjectConsistency(this.avail_seasons,a)){this.avail_seasons=a;if(this.avail_seasons.indexOf(this.current_season)===-1){this.current_season=null}if(null!==this.default_season&&this.avail_seasons.indexOf(this.default_season)!==-1){this.selectSeason(this.default_season);this.default_season=null}else{this.selectSeason(a[0])}this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED)}},setDefaultSeason:function(a){this.default_season=a},getCurrentTVShow:function(){return this.current_tvshow},getCurrentID:function(){SYNO.Assert(Ext.isObject(this.current_tvshow),["unexpceted tvshow",this.current_tvshow]);var a=this.current_tvshow.id;SYNO.Assert(Ext.isNumber(a),String.format("unexpceted tvshow id {0}",a));return a},getCurrentSeason:function(){return this.current_season},getTotalSeasons:function(){SYNO.Assert(Ext.isObject(this.current_tvshow),["unexpceted tvshow",this.current_tvshow]);var a=this.current_tvshow.additional;SYNO.Assert(Ext.isObject(a),["unexpceted tvshow additional",a]);var b=this.current_tvshow.additional.total_seasons;SYNO.Assert(Ext.isNumber(b),String.format("unexpceted total seasons {0}",b));return b},getAvailableSeasons:function(){return this.avail_seasons},clearTVShow:function(){this.current_tvshow=null;this.current_season=null;this.default_season=null;this.avail_seasons=null;this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CLEARED)},current_tvshow:null,current_season:null,default_season:null,avail_seasons:null});Ext.define("SYNO.SDS.VideoStation2.File",{statics:{EVENT_FILE_CHANGE:"filechange",EVENT_FILE_LOAD:"fileload",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.File.instance)){SYNO.SDS.VideoStation2.File.instance=new SYNO.SDS.VideoStation2.File()}return SYNO.SDS.VideoStation2.File.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},loadFile:function(a){SYNO.Assert(Ext.isArray(a)&&!Ext.isEmpty(a),String.format("bad file object array {0}",a));this.files=a;this.current_idx=null;this.fireEvent(SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD)},selectFile:function(b){SYNO.Assert(Ext.isNumber(b)&&b>0,"bad file id");try{if(this.getCurrentID()===b){return}}catch(a){}this.audiotrack=null;this.subtitle=null;this.current_idx=this.getFileIndexByID(b);this.fireEvent(SYNO.SDS.VideoStation2.File.EVENT_FILE_CHANGE)},selectAudiotrack:function(a){SYNO.Assert(Ext.isNumber(a),String.format("bad audiotrack id ({0})",a));this.audiotrack=a},selectSubtitle:function(a){SYNO.Assert(Ext.isString(a),String.format("bad subtitle id ({0})",a));this.subtitle=a},setPreSelectFile:function(a){this.pre_select_file=a},getFileIndexByID:function(b){var a=null;Ext.each(this.files||[],function(d,c){if(d.id===b){a=c;return false}});return a},hasMultipleFile:function(){return this.files.length>1},getCurrentID:function(){SYNO.Assert(Ext.isNumber(this.current_idx)&&Ext.isArray(this.files)&&!Ext.isEmpty(this.files),"file not set");return this.files[this.current_idx].id},getFileByID:function(b){var a=this.getFileIndexByID(b);return Ext.isNumber(a)?SYNO.Util.copy(this.files[a]):null},getAllFiles:function(){return SYNO.Util.copy(this.files)},getPreSelectFile:function(){return this.pre_select_file},getAudiotrack:function(){return this.audiotrack},getSubtitle:function(){return this.subtitle},files:null,current_idx:null,audiotrack:null,pre_select_file:null,subtitle:null});Ext.define("SYNO.SDS.VideoStation2.Video",{statics:{EVENT_VIDEO_SELECTION_CHANGED:"videoselectionchanged",EVENT_VIDEO_SELECT_MODE_CHANGED:"videoselectmodechanged",EVENT_SELECT_VIDEO:"selectvideo",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Video.instance)){SYNO.SDS.VideoStation2.Video.instance=new SYNO.SDS.VideoStation2.Video()}return SYNO.SDS.VideoStation2.Video.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.current_video_selection=[];this.current_videolist=[];this.select_mode=false},selectVideo:function(a){SYNO.Assert(Ext.isObject(a)&&Ext.isNumber(a.id)&&a.id>0&&Ext.isString(a.type),String.format("bad video object {0}",a));this.video=a;this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO)},clearVideo:function(){this.video={};this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO)},addVideoSelection:function(g,a,d,c,f,e,b){SYNO.Assert(Ext.isNumber(g)&&g>0&&Ext.isString(d),String.format("unexpceted video info {0}:{1}",g,d));if(!this.hasVideoSelection(g,a,d,c)){this.current_video_selection.push({id:g,type:d,mapper_id:a,file:c,playlists:f,season_episode:e,library_id:b});this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED)}},removeVideoSelection:function(d,a,c,b){SYNO.Assert(Ext.isNumber(d)&&d>0&&Ext.isString(c),String.format("unexpceted video info {0}:{1}",d,c));if(this.hasVideoSelection(d,a,c,b)){this.current_video_selection=this.current_video_selection.filter(function(e){return e.id!==d||e.type!==c||e.mapper_id!==a||e.file!==b});this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED)}},hasVideoSelection:function(e,a,c,b){SYNO.Assert(Ext.isNumber(e)&&e>0&&Ext.isString(c),String.format("unexpceted video info {0}:{1}",e,c));var d=false;Ext.each(this.current_video_selection,function(f){if(f.id===e&&f.type===c&&f.mapper_id===a&&f.file===b){d=true;return false}});return d},toggleVideoSelection:function(g,a,d,c,f,e,b){SYNO.Assert(Ext.isNumber(g)&&g>0&&Ext.isString(d),String.format("unexpceted video info {0}:{1}",g,d));if(this.hasVideoSelection(g,a,d,c)){this.removeVideoSelection(g,a,d,c)}else{this.addVideoSelection(g,a,d,c,f,e,b)}},clearVideoSelection:function(){if(this.current_video_selection.length!==0){this.current_video_selection=[];this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED)}},enterSelectMode:function(){if(!this.select_mode){this.select_mode=true;this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED)}},leaveSelectMode:function(){if(this.select_mode){this.select_mode=false;this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED)}},setVideoListProxy:function(a){SYNO.Assert(Ext.isObject(a),["unexpceted videoListProxy",a]);this.videoListProxy=a;this.setVideolist(this.videoListProxy.videolist)},setVideolist:function(a){SYNO.Assert(Ext.isArray(a),["unexpceted video list",a]);this.current_videolist=a},clearVideolist:function(){this.videoListProxy=null;this.current_videolist=[]},getCurrentID:function(){return this.video.id},getCurrentType:function(){return this.video.type},getCurrentVideo:function(){return SYNO.Util.copy(this.video)},getIdxInVideolist:function(d,c,b){var a=-1;Ext.each(this.current_videolist,function(f,e){if(f.id===d&&f.type===c&&(!Ext.isDefined(f.file)||f.file===b)){a=e;return false}});return a},getNextFromVideolist:function(){var b=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();var a=this.getIdxInVideolist(this.video.id,this.video.type,b);if(a===-1){return}if(a===this.current_videolist.length-1){this.videoListProxy.expandRight();return}return this.current_videolist[a+1]},getPrevFromVideolist:function(){var b=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();var a=this.getIdxInVideolist(this.video.id,this.video.type,b);if(a===-1){return}if(a===0){this.videoListProxy.expandLeft();return}return this.current_videolist[a-1]},getCurrentPathTitle:function(){return this.video.pathTitle},getCurrentVideoSelection:function(){return this.current_video_selection},isVideoSelectionEmpty:function(){return Ext.isEmpty(this.current_video_selection)},isInSelectMode:function(){return this.select_mode},video:{},current_video_selection:null,select_mode:null,current_videolist:null});Ext.define("SYNO.SDS.VideoStation2.TabPanel",{extend:"SYNO.ux.TabPanel",xtype:"syno_vs_tabpanel",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-tabpanel")}});Ext.define("SYNO.SDS.VideoStation2.ActivablePanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a=Ext.apply({},b);a.listeners=Ext.apply({scope:this,activate:this.onActivate.createDelegate(this),deactivate:this.onDeactivate.createDelegate(this)},b.listeners);this.callParent([a]);if(this.items){this.items.each(function(c){c.relayEvents(this,["activate","deactivate"])},this)}},onActivate:Ext.emptyFn,onDeactivate:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,multipleTVShowEpisodes:false,onVideoMetadataEdited:Ext.emptyFn,constructor:function(b){var c=this.video=b.videos[0]||this.video;this.multipleTVShowEpisodes=c.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE&&b.videos.length>1;this.correct_info=Ext.isNumber((c||{}).file);var a={title:this.correct_info?_VST("action","correct_metadata"):_VST("action","edit_metadata"),layout:"fit",cls:"edit-meta-dialog",width:690,height:580,minWidth:400,minHeight:280,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],listeners:{scope:this,afterrender:this.onAfterRender},items:[this.panel=new SYNO.SDS.VideoStation2.EditMetadataDialog.Panel({video:c,multipleTVShowEpisodes:this.multipleTVShowEpisodes,owner:this})]};this.callParent([Ext.apply(a,b)])},maybeShowApplyConfirm:function(){if(this.multipleTVShowEpisodes){if(this.panel.isVideoChanged()){this.applyMultipleEpisodes()}return}if(!this.correct_info){this.maybeApplyMetadata();return}if(this.panel.isVideoChanged()){this.maybeApplyMetadata();return}var a=this.panel.getOriValues();var b=String.format(_VST("metadata","correct_metadata_confirm"),a.meta.title);this.getMsgBox().confirm(this.title,b,function(c){if("yes"===c){this.maybeApplyMetadata()}},this)},applyMultipleEpisodes:function(){this.setStatusBusy();var a=this.panel.getValues().meta;var b=this.videos;var c=[];Ext.each(b,function(f,d){var e=Ext.copyTo({id:f.id},a,"title,tvshow_original_available,original_available,metadata_locked");e.season=a.season.trim()===""?b[d].season_episode.season:parseInt(a.season,10);e.episode=a.episode.trim()===""?b[d].season_episode.episode:parseInt(a.episode,10);c.push(e)},this);SYNO.SDS.VideoStation2.OP.get().editMetadataAdv({library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),episode:c},{scope:this,success:this.onEditMetadata,failure:this.onRequestFail})},maybeApplyMetadata:function(){this.setStatusBusy();var c=this.panel.getValues();if(!c.meta){this.maybeApplyPoster();return}var d=this.panel.getImportMetadata().meta;var a=d.raw;var b=d.value;if(a&&!a.from_internet&&SYNO.ux.Utils.checkObjectConsistency(b,c.meta)){this.applyMetadataWithOverwrite(SYNO.SDS.VideoStation2.OverwritePolicyDialog.POLICY_SKIP);return}var e=Ext.apply(this.getIDParameter(),c.meta);SYNO.SDS.VideoStation2.OP.get().editMetadata(e,{scope:this,success:this.maybeApplyPoster,failure:this.onApplyMetadataFail},this.video.type)},applyMetadataWithOverwrite:function(b){this.setStatusBusy();var a=this.panel.getValues();var c=Ext.apply(this.getIDParameter(),a.meta,{overwrite:b});SYNO.SDS.VideoStation2.OP.get().editMetadata(c,{scope:this,success:this.maybeApplyPoster,failure:this.onRequestFail},this.video.type)},maybeApplyPoster:function(b){if(b){if(this.correct_info){this.video.file=b.id}else{this.video.id=b.id}}var a=this.panel.getValues();if(!a.poster||a.poster.image==="original"){this.maybeApplyBackdrop();return}var c=this.getPosterParameter(a.poster);var d=(a.poster.image==="clear")?"deletePoster":"setPoster";SYNO.SDS.VideoStation2.OP.get()[d](c,{scope:this,success:this.maybeApplyBackdrop,failure:this.onRequestFail})},maybeApplyBackdrop:function(){var a=this.panel.getValues();if(!a.backdrop||a.backdrop.image==="original"){this.onEditMetadata();return}var b=Ext.apply(this.getBackdropParameter(),a.backdrop);Ext.apply(b,{keep_one:true});var c;if(a.backdrop.image!=="clear"){c="setBackdrop"}else{c="deleteAllBackdrop";Ext.apply(b,{mapper_id:this.video.mapper_id})}SYNO.SDS.VideoStation2.OP.get()[c](b,{scope:this,success:this.onEditMetadata,failure:this.onRequestFail})},getIDParameter:function(){var a={library_id:this.video.library_id};if(this.correct_info){a.target="file";a.file_id=this.video.file}else{a.target="video";a.id=this.video.id}return a},getBackdropParameter:function(){var b=this.correct_info?this.video.file:this.video.id;var a=this.correct_info?"video":this.video.type;return{id:b,type:a}},getPosterParameter:function(a){var b={id:this.correct_info?this.video.file:this.video.id,type:this.correct_info?"video":this.video.type};if(a.image=="url"){b.target="url";b.url=a.url}if(a.image=="file"){b.target="file";b.sharepath=a.file}return b},onOKBtn:function(){if(!this.panel.isValid()){return}if(!this.panel.isDirty()){this.close()}this.maybeShowApplyConfirm()},onCancelBtn:function(){if(!this.panel.isDirty()){this.close();return}this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this)},onApplyMetadataFail:function(d,c,a){if(d.code!==600){this.onRequestFail(d,c,a);return}this.clearStatusBusy();var b=new SYNO.SDS.VideoStation2.OverwritePolicyDialog({owner:this,video:this.video,onPolicyChoosed:this.applyMetadataWithOverwrite.createDelegate(this)});b.open()},onEditMetadata:function(){this.clearStatusBusy();if(Ext.isFunction(this.onVideoMetadataEdited)){this.onVideoMetadataEdited()}if(SYNO.SDS.VideoStation2.Video.get().isInSelectMode()){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection();SYNO.SDS.VideoStation2.Video.get().leaveSelectMode()}this.close()},onAfterRender:function(){if(this.multipleTVShowEpisodes){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.getMultipleVideoInfo())}else{this.loadSingleVideoInfo()}},getMultipleVideoInfo:function(){var c=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();var b={season:"",episode:"",type:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE,tvshow_original_available:c.original_available,title:c.title};var a=Ext.pluck(this.videos,"season_episode");if(Ext.unique(Ext.pluck(a,"season")).length===1){b.season=this.video.season_episode.season}if(Ext.unique(Ext.pluck(a,"episode")).length===1){b.episode=this.video.season_episode.episode}return b},loadSingleVideoInfo:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().getInfo({id:[this.video.id],additional:SYNO.SDS.VideoStation2.Constant.ADDITIONAL_DICT[this.video.type]},{scope:this,success:this.onInfoLoaded,failure:this.onRequestFail},this.video.type)},onInfoLoaded:function(d,c,a){var b=d[SYNO.SDS.VideoStation2.Util.getVideoRoot(this.video.type)][0];if(Ext.isObject(b.additional)){if(b.additional.extra){b.additional.extra=Ext.decode(b.additional.extra)}if(b.additional.tvshow_extra){b.additional.tvshow_extra=Ext.decode(b.additional.tvshow_extra)}}this.clearStatusBusy();this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,b)},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.Panel",{extend:"SYNO.SDS.VideoStation2.TabPanel",video:null,multipleTVShowEpisodes:false,constructor:function(d){var f=d.video||this.video;var g=d.multipleTVShowEpisodes||this.multipleTVShowEpisodes;var e=[];var c=[];var a=[];switch(f.type){case SYNO.SDS.VideoStation2.Constant.MOVIE:e=new SYNO.SDS.VideoStation2.EditMetadataDialog.MovieMetaPanel({video:f,owner:d.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TVSHOW:e=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMetaPanel({video:f,owner:d.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:if(g){e=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMultipleEpisodeMetaPanel({video:f,owner:d.owner,itemId:"meta"})}else{e=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowEpisodeMetaPanel({video:f,owner:d.owner,itemId:"meta"})}break;case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:e=new SYNO.SDS.VideoStation2.EditMetadataDialog.HomeVideoMetaPanel({video:f,owner:d.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:e=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVRecordingMetaPanel({video:f,owner:d.owner,itemId:"meta"});break}if(f.type!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&!g){c=new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel({video:f,owner:d.owner,itemId:"poster"});c.mon(e,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET,c.onImageSet,c)}if(f.type===SYNO.SDS.VideoStation2.Constant.MOVIE||f.type===SYNO.SDS.VideoStation2.Constant.TVSHOW){a=new SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel({video:f,owner:d.owner,itemId:"backdrop"});a.mon(e,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_BACKDROP_SET,a.onImageSet,a)}var b={activeTab:0,items:[e,c,a]};this.callParent([Ext.apply(b,d)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED);this.items.each(function(h){h.relayEvents(this,[SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED])},this)},isValid:function(){var a=true;var b;this.items.each(function(c){if(!(b=c.isValid())){this.setActiveTab(c)}a=b&&a},this);return a},isDirty:function(){var a=false;this.items.each(function(b){return !(a=(a||b.isDirty()))},this);return a},isVideoChanged:function(){var a=false;this.items.each(function(b){return !(a=(a||b.isVideoChanged()))},this);return a},getImportMetadata:function(){var a={};this.items.each(function(b){a[b.itemId]=b.getImportMetadata()},this);return a},getValues:function(){var a={};this.items.each(function(b){if(b.isDirty()){a[b.itemId]=this.serializedValues(b.getValues())}},this);return a},getOriValues:function(){var a={};this.items.each(function(b){a[b.itemId]=b.getOriValues()},this);return a},serializedValues:function(a){if(!Ext.isObject(a)){return a}var b={};Ext.iterate(a,function(c,d){if(!Ext.isArray(d)&&(c==="actor"||c==="genre"||c==="writer"||c==="director")){b[c]=[d]}else{b[c]=d}});return b}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.MovieMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={items:[this.getFileFieldConfig(b),this.getTitleFieldConfig(b),this.getTaglineFieldConfig(b),this.getOriginalAvailableFieldConfig(b),this.getCertificateFieldConfig(b),this.getRatingFieldConfig(b),this.getMetaSelectors(b),this.getMetadataLockFieldConfig(b),this.getSummaryFieldConfig(b),this.getExtraFieldConfig(b),this.getSourceField(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.rating=this.getRatingSaveValue(a.rating);a.metadata_locked=a.metadata_locked==="true";return a},setValues:function(a){this.getForm().setValues({title:a.title,tagline:a.tagline,original_available:this.correctOriginalAvailable(a.original_available),certificate:a.certificate,rating:this.getRatingValue(a.rating),metadata_locked:a.hasOwnProperty("metadata_locked")?a.metadata_locked:true,summary:a.additional.summary,extra:Ext.encode(a.additional.extra)});this.setMetaSelectorsValue(a);this.maybeSetFileValue(a)},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.original_available!==a.original_available)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={items:[this.getTitleFieldConfig(b),this.getOriginalAvailableFieldConfig(b),this.getMetadataLockFieldConfig(b),this.getSummaryFieldConfig(b),this.getExtraFieldConfig(b),this.getUpdateTVShowFieldConfig(b),this.getSourceField(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.metadata_locked=a.metadata_locked==="true";return a},setValues:function(a){this.getForm().setValues({title:a.title,original_available:this.correctOriginalAvailable(a.original_available),metadata_locked:a.hasOwnProperty("metadata_locked")?a.metadata_locked:true,summary:a.additional.summary,extra:Ext.encode(a.additional.extra),update_tvshow:a.update_tvshow})},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.original_available!==a.original_available)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowEpisodeMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={items:[this.getFileFieldConfig(b),this.getTitleFieldConfig(b),this.getTVShowOriginalAvailableFieldConfig(b),this.getTaglineFieldConfig(b),this.getSeasonFieldConfig(b),this.getEpisodeFieldConfig(b),this.getOriginalAvailableFieldConfig(b),this.getCertificateFieldConfig(b),this.getRatingFieldConfig(b),this.getMetaSelectors(b),this.getMetadataLockFieldConfig(b),this.getSummaryFieldConfig(b),this.getExtraFieldConfig(b),this.getTVShowExtraFieldConfig(b),this.getSourceField(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.rating=this.getRatingSaveValue(a.rating);a.metadata_locked=a.metadata_locked==="true";a.season=parseInt(a.season,10);a.episode=parseInt(a.episode,10);return a},setValues:function(a){this.getForm().setValues({title:a.title,tagline:a.tagline,original_available:this.correctOriginalAvailable(a.original_available),tvshow_original_available:this.correctOriginalAvailable(a.tvshow_original_available),episode:a.episode,season:a.season,certificate:a.certificate,rating:this.getRatingValue(a.rating),metadata_locked:a.hasOwnProperty("metadata_locked")?a.metadata_locked:true,extra:Ext.encode(a.additional.extra),tvshow_extra:Ext.encode(a.additional.tvshow_extra),summary:a.additional.summary});this.setMetaSelectorsValue(a);this.maybeSetFileValue(a)},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.tvshow_original_available!==a.tvshow_original_available||this.oriValue.season!==a.season||this.oriValue.episode!==a.episode)},onImportMetadata:function(b){if(!b.from_internet){b.tvshow_original_available=b.original_available;delete b.original_available}this.callParent(arguments);var a=this.getValues();if(a.title===this.oriValue.title||a.tvshow_original_available===this.oriValue.tvshow_original_available||b.from_internet){return}var d=_VST("metadata","title");var c=_VST("metadata","research_msg");this.owner.getMsgBox().confirm(d,c,function(e){if("yes"===e){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH)}},this)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMultipleEpisodeMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableInternetSearch:true,disableSelectFromExisting:true,allowSeasonEpisodeBlank:true,constructor:function(b){var a={items:[this.getTitleFieldConfig(b),this.getTVShowOriginalAvailableFieldConfig(b),this.getSeasonFieldConfig(b),this.getEpisodeFieldConfig(b),this.getMetadataLockFieldConfig(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.metadata_locked=a.metadata_locked==="true";return a},setValues:function(a){this.getForm().setValues({title:a.title,tvshow_original_available:this.correctOriginalAvailable(a.tvshow_original_available),season:a.season,episode:a.episode,metadata_locked:a.hasOwnProperty("metadata_locked")?a.metadata_locked:true})},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.tvshow_original_available!==a.tvshow_original_available||this.oriValue.season!==a.season||this.oriValue.episode!==a.episode)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.HomeVideoMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableInternetSearch:true,constructor:function(b){var a={items:[this.getFileFieldConfig(b),this.getTitleFieldConfig(b),this.getRecordDateFieldConfig(b),this.getCertificateFieldConfig(b),this.getRatingFieldConfig(b),this.getMetaSelectors(b),this.getSummaryFieldConfig(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.rating=this.getRatingSaveValue(a.rating);a.record_date=String.format("{0} {1}",a.record_date_date,a.record_date_time);return a},setValues:function(b){var a=(b.record_date||" ").split(" ");this.getForm().setValues({title:b.title,record_date_date:a[0],record_date_time:a[1],certificate:b.certificate,rating:this.getRatingValue(b.rating),summary:b.additional.summary});this.setMetaSelectorsValue(b);this.maybeSetFileValue(b)},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.record_date!==a.record_date)},hideMetadataLocked:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVRecordingMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableToolbar:true,constructor:function(b){var a={items:[this.getChannelFieldConfig(b),this.getTitleFieldConfig(b),this.getSummaryFieldConfig(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){return this.getForm().getValues()},setValues:function(a){this.getForm().setValues({title:a.title,channel_name:a.channel_name,summary:a.additional.summary})},isVideoChanged:function(){return true},hideMetadataLocked:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={bodyCssClass:"image-panel-body",items:[{xtype:"container",cls:"image-form-wrapper",layout:"border",items:[this.image=this.getImageBox({region:"west",owner:b.owner,video:b.video}),this.panel=this.getFormPanel({region:"center",owner:b.owner,video:b.video})]}]};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_IMAGE_CHANGE,this.loadImage,this);this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.onMetaLoaded,this);this.mon(this.image,SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image.EVENT_IMAGE_ERROR,this.onImageError,this);this.mon(this,"activate",this.loadImage,this,{single:true})},getImageBox:Ext.emptyFn,getFormPanel:Ext.emptyFn,loadImage:function(){this.image.setImage(this.getValues())},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},isValid:function(){return this.panel.isValid()},getValues:function(){return this.panel.getValues()},getOriValues:function(){return this.panel.getOriValues()},getImportMetadata:function(){return this.panel.getImportMetadata()},isVideoChanged:function(){return this.panel.isVideoChanged()},onMetaLoaded:function(a){this.setValues(a);this.oriRaw=a;this.oriValue=this.getValues()},onImageError:function(){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form.EVENT_IMAGE_ERROR)},onImageSet:function(a){this.panel.setValues(a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image",{statics:{EVENT_IMAGE_ERROR:"imageerror"},extend:"Ext.Container",video:null,mtime:null,constructor:function(b){var a={cls:"image",margins:"0 14 0 20"};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image.EVENT_IMAGE_ERROR)},setImageMtime:function(a){this.mtime=a},setImage:function(b){var c=this.getImageURL(b);if(Ext.isEmpty(c)){return}var a=new Image();a.onerror=this.setDefaultImage.createDelegate(this);a.onload=this.setImageImage.createDelegate(this,[c]);a.src=c},getImageURL:function(a){switch(a.image){case"original":if(a.url){return a.url}return this.getOriginalImageURL();case"url":return a.url;case"file":return Ext.isEmpty(a.file)?a.file:this.getBaseURL({api:"SYNO.Core.File.Thumbnail",method:"get",version:1,params:{path:SYNO.API.EscapeStr(a.sharepath),size:"medium"}});default:return this.getNoneImageURL({type:this.video.type,id:0})}},getNoneImageURL:Ext.emptyFn,getOriginalImageURL:Ext.emptyFn,setDefaultImage:function(){var a=this.getImageURL({});this.setImageImage(a);this.fireEvent(SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image.EVENT_IMAGE_ERROR)},setImageImage:function(a){var b=this.getEl();if(!b){return}b.setStyle("background-image",String.format("url('{0}')",a))}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form",{statics:{EVENT_IMAGE_ERROR:"imageerror"},disableToolbar:true,extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(a){this.callParent([a]);this.mon(this,SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form.EVENT_IMAGE_ERROR,this.onImageError,this)},getValues:function(){return this.getImageFieldValue()},setValues:function(b){if(b.image){this.setImageFieldValue(b);return}if(!b.additional.file){return}var a=this.correct_info?this.findFileFromData(b):b.additional.file[0];var c=a.sharepath;this.getFileSelectBtn().setGotoPath(c.substring(0,c.lastIndexOf("/")))},isValid:function(){var a=this.getForm().isValid();a=this.getImageURLField().isValid()&&a;a=this.getImageFileField().isValid()&&a;return a}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel",constructor:function(b){var a={cls:"poster",title:_VST("poster","title")};this.callParent([Ext.apply(a,b)])},getImageBox:function(a){return new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image(a)},getFormPanel:function(a){return new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Form(a)},setValues:function(a){this.image.setImageMtime((a.additional||{}).poster_mtime);this.panel.setValues(a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image",constructor:function(a){this.callParent([a])},getOriginalImageURL:function(){return SYNO.SDS.VideoStation2.Util.getImageURL({type:this.video.type,id:this.video.id,mtime:this.mtime||""})},getNoneImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL(a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Form",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form",constructor:function(b){var a={items:[this.getPosterFieldConfig(b)]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel",constructor:function(b){var a={cls:"backdrop",title:_VST("backdrop","title")};this.callParent([Ext.apply(a,b)])},getImageBox:function(a){return new SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Image(a)},getFormPanel:function(a){return new SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Form(a)},setValues:function(a){this.image.setImageMtime((a.additional||{}).backdrop_mtime);this.panel.setValues(a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Image",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image",constructor:function(a){this.callParent([a])},getOriginalImageURL:function(){return SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:this.video.mapper_id,mtime:this.mtime||""})},getNoneImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL(Ext.apply(a,{type:"tvshow_episode"}))}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Form",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form",constructor:function(b){var a={items:[this.getBackdropFieldConfig(b)]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.DropdownMenu",{extend:"SYNO.ux.Menu",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-dropdown-menu");this.addClass(a.noicon===true?"no-icon":"with-icon")}});Ext.define("SYNO.SDS.VideoStation2.OneTimeDropdownMenu",{extend:"SYNO.SDS.VideoStation2.DropdownMenu",hide:function(){this.destroy()}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionUtil",{singleton:true,getVideoProfiles:function(){return[SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_MEDIUM,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_LOW]},isFileSupportRemux:function(a){return("mp4"===a.container_type||"matroska,webm"===a.container_type)&&("h264"===a.video_codec)&&((1920>=a.resolutionx&&1080>=a.resolutiony)||(1080>=a.resolutionx&&1920>=a.resolutiony))},videoProfileToString:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL:return _VST("offline_conversion","orignal_quality");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH:return _VST("controller","quality_high");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_MEDIUM:return _VST("controller","quality_medium");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_LOW:return _VST("controller","quality_low");default:}return""},audioCodecToString:function(a){return String.format("#{0} - {1}({2})",a.id,a.language,a.codec)}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{TITLE_WRAP_HEIGHT:28,OPTION_WRAP_HEIGHT:26},constructor:function(b){var a={tpl:this.getTpl(),cls:"offline-conversion-action-dataview",itemSelector:"div.offline-conversion-wrap",overClass:"x-view-over",singleSelect:true};this.callParent([Ext.apply(a,b)])},prepareData:function(c,b,a){c.index=b;return c},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="offline-conversion-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr class="align-top">','<td class="fit-minimum"><div class="rearrange"></div></td>','<td class="fit-minimum"><div class="thumb" style="background-image: url({[this.getImageURL(values)]})"></div></td>','<td><div class="info-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr class="align-top">','<td class="fit-minimum">','<div class="counter">{values.index + 1} - </div>',"</td>","<td>",'<div class="info">','<div class="title-wrap">',"{[this.getTitleBtnTpl(values)]}","</div>",'<div class="video-profile-wrap">','<div class="field">{[_VST("offline_conversion", "video_pofile")]}</div>',"{[this.getVideoProfileBtnTpl(values)]}","</div>",'<div class="audio-track-wrap">','<div class="field">{[_VST("offline_conversion", "original_audio_track")]}</div>',"{[this.getAudioTrackBtnTpl(values)]}","</div>","</div>","</td>","</tr></tbody></table></div></td>",'<td class="fit-minimum"><div class="delete"></div></td>',"</tr></tbody></table></div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getTitleBtnTpl:this.getTitleBtnTpl.createDelegate(this),getVideoProfileBtnTpl:this.getVideoProfileBtnTpl.createDelegate(this),getAudioTrackBtnTpl:this.getAudioTrackBtnTpl.createDelegate(this)});return a},getImageURL:function(b){var a=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:a,id:b.id,mtime:b.poster_mtime})},getBtnTpl:function(a,b){return[String.format('<div class="dropdown-btn {0}">',a),String.format("<span>{0}</span>",b),"</div>"].join("")},getTitleBtnTpl:function(b){var a=b.file[b.selectedFileIndex];var c=Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.extractFileName(a.sharepath));return this.getBtnTpl("title",c)},getVideoProfileBtnTpl:function(a){var b=SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(a.selectedVideoProfile);return this.getBtnTpl("video-profile",b)},getAudioTrackBtnTpl:function(c){var a=c.file[c.selectedFileIndex];var b="";if(0>c.selectedAudioIndex||!Ext.isArray(a.audio_codecs)){b=_VST("offline_conversion","default_audio_track")}else{var d=a.audio_codecs[c.selectedAudioIndex];b=SYNO.SDS.VideoStation2.OfflineConversionUtil.audioCodecToString(d)}return this.getBtnTpl("audio-track",b)},getMenu:function(){this._menu=this._menu||new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true});return this._menu},showMenu:function(b,a){var c=this.getMenu();c.removeAll();Ext.each(b,function(d){c.add(d)},this);c.showAt(a)},onTitleClick:function(b,a){var d=function(g){b.data.selectedFileIndex=g.fileIndex;b.data.selectedAudioIndex=-1;var f=b.get("file")[b.get("selectedFileIndex")];if(SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(f)){b.data.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL}else{b.data.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH}b.commit()};var e=b.get("file");var c=[];Ext.each(e,function(g,f){c.push(new Ext.menu.Item({text:SYNO.SDS.VideoStation2.Util.extractFileName(g.sharepath),fileIndex:f,scope:this,handler:d}))},this);this.showMenu(c,a)},onVideoProfileClick:function(b,a){var f=function(g){b.data.selectedVideoProfile=g.itemId;b.commit()};var e=b.get("file")[b.get("selectedFileIndex")];var d=SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(e);var c=[];Ext.each(SYNO.SDS.VideoStation2.OfflineConversionUtil.getVideoProfiles(),function(g){if(!d&&SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL===g){return}c.push({xtype:"menuitem",text:SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(g),itemId:g,scope:this,handler:f})},this);this.showMenu(c,a)},onAudioTrackClick:function(b,a){var d=function(h){b.data.selectedAudioIndex=h.audioIndex;b.commit()};var e=this;var g=function(i){var h=[];Ext.each(i,function(k,j){h.push(new Ext.menu.Item({text:SYNO.SDS.VideoStation2.OfflineConversionUtil.audioCodecToString(k),audioIndex:j,scope:this,handler:d}))},this);e.showMenu(h,a)};var c=b.get("file")[b.get("selectedFileIndex")];if(Ext.isArray(c.audio_codecs)){g(c.audio_codecs)}else{var f={success:function(j,i,h){b.data.file[b.get("selectedFileIndex")].audio_codecs=j.trackinfo;g(c.audio_codecs)},scope:this};SYNO.SDS.VideoStation2.OP.get().listAudioTrack({id:c.id},f)}},onDeleteClick:function(a){this.store.remove(a)},onClick:function(f,d,c){var g=Ext.get(d);var b=f.getTarget(this.itemSelector,this.getTemplateTarget());if(!g||!b){this.callParent(arguments);return}var a=this.getRecord(b);if(g.hasClass("title")||g.parent(".title")){this.onTitleClick(a,[g.getLeft(),g.getTop()+SYNO.SDS.VideoStation2.OfflineConversionActionDataView.TITLE_WRAP_HEIGHT])}else{if(g.hasClass("video-profile")||g.parent(".video-profile")){this.onVideoProfileClick(a,[g.getLeft(),g.getTop()+SYNO.SDS.VideoStation2.OfflineConversionActionDataView.OPTION_WRAP_HEIGHT])}else{if(g.hasClass("audio-track")||g.parent(".audio-track")){this.onAudioTrackClick(a,[g.getLeft(),g.getTop()+SYNO.SDS.VideoStation2.OfflineConversionActionDataView.OPTION_WRAP_HEIGHT])}else{if(g.hasClass("delete")||g.parent(".delete")){this.onDeleteClick(a)}}}}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){var a={layout:"fit",width:586,height:540,title:_VST("offline_conversion","action"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.OfflineConversionActionPanel(b)]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){var b=[];this.panel.getStore().each(function(c){var e=c.get("file")[c.get("selectedFileIndex")];var d=c.get("selectedAudioIndex");var f={file_id:e.id,video_profile:c.get("selectedVideoProfile")};if(0<=d){Ext.apply(f,{audio_id:parseInt(e.audio_codecs[d].id,10)})}b.push({api:"SYNO.VideoStation.OfflineConversion",method:"create",version:1,params:f})},this);var a={params:b,stopwhenerror:true};this.setStatusBusy();SYNO.API.Request({compound:a,callback:function(c,e,f,d){this.clearStatusBusy();if(!c||e.has_fail){this.setStatusError()}else{this.close()}},scope:this})}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.videos=b.videos;this.video_type=this.videos[0].type;this.callback=this.callback||{};var a={autoFlexcroll:true,layout:"fit",items:[this.getDataView()]};this.callParent([Ext.apply(a,b)]);this.loadView()},loadView:function(){var a=[];Ext.each(this.videos,function(b){a.push(b.id)},this);this.getStore().load({params:{id:a}})},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores[this.video_type]({synoMethod:"getinfo",baseParams:{additional:["poster_mtime","file","conversion_produced"]},proxyClass:"SYNO.SDS.VideoStation2.OfflineConversionActionProxy",readerCfg:{fields:["id","title","poster_mtime","type","selectedFileIndex","selectedAudioIndex","selectedVideoProfile","file"]}});return this._store},getDataView:function(){this._dataView=this._dataView||new SYNO.SDS.VideoStation2.OfflineConversionActionDataView({store:this.getStore()});return this._dataView}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionProxy",{extend:"SYNO.API.Proxy",constructor:function(a){this.callParent([a])},onRequestAPI:function(i,d,b,a,f,j,k,l,c){try{var g=f.getRoot(d);Ext.each(g,function(e){SYNO.Assert(Ext.isDefined(e.additional)&&Ext.isArray(e.additional.file)&&0<e.additional.file.length,"OfflineConversionActionHttpProxy parser file failed");e.poster_mtime=e.additional.poster_mtime||"";e.selectedFileIndex=0;e.selectedAudioIndex=-1;e.file=e.additional.file.filter(function(m){return !m.conversion_produced});if(SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(e.file[e.selectedFileIndex])){e.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL}else{e.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH}},this);this.callParent(arguments)}catch(h){this.fireEvent("loadexception",this,l,d,h);this.fireEvent("exception",this,"response",c,l,d,h);return}}});Ext.define("SYNO.SDS.VideoStation2.PublicSharingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,constructor:function(b){var a={layout:"fit",title:_VST("advanced","public_sharing"),width:450,height:160,buttons:[this.doneBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.close}),this.openLinkBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","open_link"),disabled:true,scope:this,handler:this.onOpenLinkBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.PublicSharingDialog.Panel()],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED,this.onPublicSharingChanged,this)},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().getPublicSharing({video_id:this.video.id,video_type:this.video.type,need_url:true},{scope:this,success:this.onPublicSharingLoaded,failure:this.onRequestFail})},onPublicSharingLoaded:function(c,b,a){this.clearStatusBusy();this.openLinkBtn.setDisabled(!c.enable);this.panel.fireEvent(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED,c)},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onPublicSharingChanged:function(a){this.setStatusBusy();this.openLinkBtn.setDisabled(!a);SYNO.SDS.VideoStation2.OP.get().setPublicSharing({enable:a,video_id:this.video.id,video_type:this.video.type},{scope:this,success:this.onUpdatePublicSharing,failure:this.onRequestFail})},onUpdatePublicSharing:function(c,b,a){SYNO.SDS.VideoStation2.Playlist.get().markDirty();this.clearStatusBusy();this.onEnableChanged(b.enable)},onOpenLinkBtn:function(){window.open(this.panel.getPublicSharingURL())},onEnableChanged:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.PublicSharingDialog.Panel",{statics:{EVENT_PUBLIC_SHARING_CHANGED:"publicsharingchanged",EVENT_PUBLIC_SHARING_LOADED:"publicsharingloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.enableCheckbox=new SYNO.SDS.VideoStation2.Checkbox({name:"enable",itemId:"enable",boxLabel:_VST("advanced","public_sharing"),listeners:{scope:this,check:this.onPublicSharingChecked}}),this.urlTextfield=new SYNO.SDS.VideoStation2.TextField({name:"url",itemId:"url",cls:"selectabletext",disabled:true,readOnly:true,selectOnFocus:true,hideLabel:true})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED);this.mon(this,SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED,this.onPublicSharingLoaded,this);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable",["url"])]},getPublicSharingURL:function(){return this.getForm().getValues().url},onPublicSharingLoaded:function(a){this.getForm().setValues(a)},onPublicSharingChecked:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED,a)}});Ext.define("SYNO.SDS.VideoStation2.SearchSubtitleDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",file:null,onSubtitleDownloaded:Ext.emptyFn,constructor:function(b){var a={layout:"fit",title:_VST("controller","search_subtitle"),width:600,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),disabled:true,btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel(b)],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.addClass("search-subtitle-dialog");this.mon(this.panel,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE,this.onSelectionChange,this);this.mon(this.panel,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_CHOOSE,this.onOKBtn,this)},onSelectionChange:function(a){this.okBtn.setDisabled(a.length===0)},onOKBtn:function(){var a=this.panel.getSelections();if(a.length===0){return}this.setStatusBusy();var b=a.map(function(c){if(c.get("downloaded")){return}return SYNO.SDS.VideoStation2.OP.get().downloadSubtitle({id:this.file.id,plugin_id:c.get("plugin_id"),download_id:c.get("id")},{})},this).filter(function(c){return Ext.isObject(c)});if(b.length===0){this.close();return}SYNO.SDS.VideoStation2.OP.compound(b,this.onDownloadRequestDone,this.onDownloadRequestFail,this)},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().searchSubtitle({id:this.file.id},{scope:this,success:this.onSubtitleLoaded,failure:this.onRequestFail})},onSubtitleLoaded:function(c,b,a){this.clearStatusBusy();this.panel.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED,c.subtitle)},onDownloadRequestDone:function(c,b,a){this.clearStatusBusy();this.onSubtitleDownloaded();this.close()},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onDownloadRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:_VST("controller","download_subtitle_fail")})}});Ext.define("SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel",{extend:"SYNO.SDS.VideoStation2.GridPanel",statics:{EVENT_SUBTITLE_LOADED:"subtitleloaded",EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},constructor:function(b){var a={enableHdMenu:false,store:this.getStore(),viewConfig:{trackResetOnLoad:false,emptyText:_T("search","no_search_result")},colModel:new Ext.grid.ColumnModel({columns:[this.getSelectionModel(),{header:_VST("language","title"),dataIndex:"language"},{header:_VST("file","file_name"),dataIndex:"filename"},{header:_VST("video_info","source"),dataIndex:"plugin_title"}]}),selModel:this.getSelectionModel(),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED);this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_CHOOSE);this.mon(this,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED,this.onSubtitleLoaded,this)},getStore:function(){this.store=this.store||new Ext.data.JsonStore({autoDestroy:true,id:"id",fields:["id","downloaded","filename","language","language_id","plugin_id","plugin_title","subtitle_id"]});return this.store},getSelectionModel:function(){this.selection_model=this.selection_model||new Ext.grid.CheckboxSelectionModel({width:34,checkOnly:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}});return this.selection_model},getSelections:function(){return this.getSelectionModel().getSelections()},onSubtitleLoaded:function(a){this.getStore().loadData(a)},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE,this.getSelections())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.VideoFileChooseDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,onVideoChoosed:Ext.emptyFn,files:null,constructor:function(b){var a={layout:"fit",title:_VST("error","select_one_video"),width:600,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),disabled:true,btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel(b)],listeners:{scope:this,beforeshow:{single:true,fn:this.onBeforeShow}}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE,this.onSelectionChange,this);this.mon(this.panel,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE,this.onOKBtn,this)},getFileByID:function(b){var a;Ext.each(this.files,function(c){if(c.id===b){a=c;return false}});return a},callVideoChoosed:function(a){this.onVideoChoosed.call(this,a);this.close()},onSelectionChange:function(a){this.okBtn.setDisabled(!a)},onOKBtn:function(){var a=this.panel.getSelected();if(!a){return}Ext.each(this.files,function(b){if(b.id===a.get("id")){this.callVideoChoosed(b);return false}},this)},onBeforeShow:function(){SYNO.SDS.VideoStation2.OP.get().getInfo({id:[this.video.id],additional:["file"]},{scope:this,success:this.onInfoLoaded,failure:this.onRequestFail},this.video.type);return false},onInfoLoaded:function(d,c,a){this.files=d[SYNO.SDS.VideoStation2.Util.getVideoRoot(this.video.type)][0].additional.file;var b;if(Ext.isNumber(this.video.file)){b=this.getFileByID(this.video.file)}else{if(this.files.length===1){b=this.files[0]}}if(b){this.callVideoChoosed(b);return}this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED,this.files);this.show()},onRequestFail:function(c,b,a){SYNO.SDS.VideoStation2.OP.defaultFailureCallback(c,b,a);this.close()}});Ext.define("SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel",{extend:"SYNO.SDS.VideoStation2.GridPanel",statics:{EVENT_INFO_LOADED:"infoloaded",EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},constructor:function(b){var a={enableHdMenu:false,viewConfig:{trackResetOnLoad:false,forceFit:false},store:this.getStore(),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("file","file_name"),dataIndex:"sharepath",id:"sharepath",resizable:false,renderer:function(e,d){var c=e.substr(e.lastIndexOf("/")+1);c=Ext.util.Format.htmlEncode(c);d.attr=String.format('ext:qtip="{0}"',Ext.util.Format.htmlEncode(e));return c}},{header:_VST("duration","title"),dataIndex:"duration",width:120,fixed:true,renderer:function(d,c){c.attr=String.format('ext:qtip="{0}"',d);return d}},{header:_T("common","size"),dataIndex:"filesize",width:120,fixed:true,renderer:function(e,d){var c=Ext.util.Format.fileSize(e);d.attr=String.format('ext:qtip="{0}"',c);return c}}]}),autoExpandColumn:"sharepath",selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED);this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE);this.mon(this,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED,this.onInfoLoaded,this)},getStore:function(){this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","sharepath","duration","filesize"],autoDestroy:true});return this.store},getSelected:function(){return this.getSelectionModel().getSelected()},onInfoLoaded:function(a){this.store.loadData(a)},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",statics:{EVENT_FILE_CHANGE:"filechange"},files:[],index:0,constructor:function(b){var a={cls:"video-info-dialog",layout:"fit",title:_VST("action","view_video_info"),width:680,height:500,useStatusBar:false,buttonAlign:"left",fbar:new SYNO.ux.Toolbar({cls:"x-statusbar",items:[{xtype:"tbspacer",width:10},this.getPrevButton(),this.getNextButton(),"->",this.getCloseButton()]}),items:[this.panel=new SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel({})],listeners:{scope:this,afterrender:{fn:this.onAfterRender,single:true}}};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.onFileChange,this);this.getPrevButton().setVisible(this.files.length>1);this.getNextButton().setVisible(this.files.length>1)},onAfterRender:function(){this.onFileChange(this.index)},onFileChange:function(a){this.getPrevButton().setDisabled(a<=0);this.getNextButton().setDisabled(a+1>=this.files.length);this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel.EVENT_LOAD_FILE,this.files[a])},getPrevButton:function(){this._prev_btn=this._prev_btn||new SYNO.SDS.VideoStation2.Button({cls:"action prev",scope:this,handler:this.goPrevious});return this._prev_btn},getNextButton:function(){this._next_btn=this._next_btn||new SYNO.SDS.VideoStation2.Button({cls:"action next",scope:this,handler:this.goNext});return this._next_btn},getCloseButton:function(){this._close_btn=this._close_btn||new SYNO.SDS.VideoStation2.Button({text:_T("common","close"),scope:this,handler:this.close});return this._close_btn},goPrevious:function(){SYNO.Assert(this.index>0,"unable to go previous");this.index--;this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.index)},goNext:function(){SYNO.Assert(this.index+1<this.files.length,"unable to go next");this.index++;this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.index)}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel",{extend:"SYNO.SDS.VideoStation2.TabPanel",statics:{EVENT_LOAD_FILE:"loadfile"},constructor:function(b){var a={border:false,items:[]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel.EVENT_LOAD_FILE);this.mon(this,SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel.EVENT_LOAD_FILE,this.loadFile,this)},loadFile:function(a){if(Ext.isObject(this._load_track_request)){Ext.Ajax.abort(this._load_track_request)}this.removeAll();this._file=SYNO.Util.copy(a);this.add(new SYNO.SDS.VideoStation2.VideoInfoDialog.GeneralPanel({data:this._file,itemId:"general"}));this.setActiveTab("general");this.loadTrackInfo()},loadTrackInfo:function(){this._load_track_request=SYNO.SDS.VideoStation2.OP.get().getFileTrackInfo({id:this._file.id},{scope:this,success:this.updateTrackInfo,failure:Ext.emptyFn})},updateTrackInfo:function(d,c,a){var b=SYNO.Util.copy((d.video||[])[0]||{});b.resolution=String.format("{0} x {1}",b.resolutionx,b.resolutiony);this._video=b;this._audio=SYNO.Util.copy(d.audio)||[];this.add(new SYNO.SDS.VideoStation2.VideoInfoDialog.VideoPanel({data:this._video}));this.add(new SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanel({data:this._audio}))}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={title:(b||{}).title||"Title",autoFlexcroll:true,items:new SYNO.SDS.VideoStation2.VideoInfoDialog.InnerPanel(Ext.apply(b,{computeData:this.computeData,getFields:this.getFields}))};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.InnerPanel",{extend:"Ext.Panel",constructor:function(b){Ext.apply(this,b);var a={border:false,header:false,cls:"info-panel",layout:"table",layoutConfig:{columns:2},items:this.getItems(b)};this.callParent([Ext.apply(a,b)])},getItems:function(a){var b=this.computeData((a||{}).data);return this.getFields().map(function(d){var c=Ext.isDefined(b[d.name])?Ext.util.Format.htmlEncode(b[d.name]):"";return[{xtype:"box",cls:"label",html:Ext.util.Format.htmlEncode(d.label)},{xtype:"box",cls:"value allowDefCtxMenu selectabletext",html:c}]}).reduce(function(c,d){return c.concat(d)},[])},computeData:function(){return{}},getFields:function(){return[]}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.GeneralPanel",{extend:"SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",statics:{FIELDS:[{name:"filename",label:_VST("file","file_name")},{name:"sharepath",label:_VST("file","file_path")},{name:"duration",label:_VST("duration","title")},{name:"formated_filesize",label:_T("common","size")},{name:"resolution",label:_VST("video_info","resolution")},{name:"container_type",label:_VST("video_info","container")},{name:"video_codec",label:_VST("video_info","video_codec")},{name:"audio_codec",label:_VST("video_info","audio_codec")},{name:"video_bitrate",label:_VST("video_info","video_bitrate")}]},constructor:function(b){var a={title:_VST("video_info","general")};this.callParent([Ext.apply(a,b)])},computeData:function(b){var a=SYNO.Util.copy(b);return Ext.apply(a,{filename:b.sharepath.split("/").pop(),formated_filesize:Ext.util.Format.fileSize(b.filesize),resolution:String.format("{0} x {1}",b.resolutionx,b.resolutiony),video_bitrate:SYNO.SDS.VideoStation2.Util.formatBitrate(b.frame_bitrate)})},getFields:function(){return SYNO.SDS.VideoStation2.VideoInfoDialog.GeneralPanel.FIELDS}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.VideoPanel",{extend:"SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",statics:{FIELDS:[{name:"codec_raw",label:_VST("video_info","video_codec")},{name:"resolution",label:_VST("video_info","resolution")},{name:"rotate",label:_VST("video_info","rotation")},{name:"framerate",label:_VST("video_info","fps")},{name:"profile",label:_VST("video_info","profile")},{name:"level",label:_VST("video_info","level")}]},constructor:function(b){var a={title:_VST("video_info","video")};this.callParent([Ext.apply(a,b)])},computeData:function(b){var a=SYNO.Util.copy(b);return Ext.apply(a,{resolution:String.format("{0} x {1}",b.resolutionx,b.resolutiony),framerate:(b.framerate||0).toFixed(3),rotate:String.format("{0}{1}",b.rotate,String.fromCharCode(176))})},getFields:function(){return SYNO.SDS.VideoStation2.VideoInfoDialog.VideoPanel.FIELDS}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={title:_VST("video_info","audio"),autoFlexcroll:true,items:new SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanelInner(b)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanelInner",{extend:"Ext.Panel",statics:{FIELDS:[{name:"codec_raw",label:_VST("video_info","audio_codec")},{name:"channel_layout",label:_VST("video_info","audio_channel")},{name:"sample_rate",label:_VST("video_info","sample_rate")},{name:"language",label:_VST("language","title")}]},constructor:function(b){var c=((b||{}).data||[]);var a={border:false,header:false,cls:"info-panel",tpl:this.getTpl(),listeners:{afterrender:{fn:function(){this.update(c)},scope:this,single:true}}};this.callParent([Ext.apply(a,b)])},getTpl:function(){var a=SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanelInner.FIELDS.map(function(b){return["<tr>",String.format('<td class="x-table-layout-cell"><div class="label">{0}</div></td>',Ext.util.Format.htmlEncode(b.label)),String.format('<td class="x-table-layout-cell"><div class="value allowDefCtxMenu selectabletext">{values.{0}:htmlEncode}</div></td>',b.name),"</tr>"].join("")}).join("");return new Ext.XTemplate('<tpl for=".">','<div class="track-title {[this.getIndexClass(xindex)]}">{[this.getTrackTitle(values)]}</div>','<table class="x-table-layout" cellspacing="0"><tbody>',a,"</tbody></table>","</tpl>",{getIndexClass:function(b){return b>1?"non-first":""},getTrackTitle:function(c){var b=(c||{}).track||-1;return String.format("{0}{1}",_VST("video_info","audio"),b<0?"":(" - #"+b))}})}});Ext.define("SYNO.SDS.VideoStation2.VideoActionController",{statics:{ACTION_VIEW_VIDEO_INFO:"view_video_info",ACTION_EDIT_METADATA:"edit_metadata",ACTION_EDIT_MULTIPLE_EPISODE_METADATA:"edit_multiple_episode_metadata",ACTION_CORRECT_METADATA:"correct_metadata",ACTION_SEARCH_SUBTITLE:"search_subtitle",ACTION_PUBLIC_SHARING:"public_sharing",ACTION_SET_WATCHED:"set_watched",ACTION_SET_UNWATCHED:"set_unwatched",ACTION_DEL_VIDEO:"del_video",ACTION_DEL_FILE:"del_file",ACTION_OFFLINE_CONVERSION:"offline_conversion",getAllActions:function(){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_VIEW_VIDEO_INFO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE,SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE,SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION]},doVideoAction:function(b,a,c){switch(b){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_VIEW_VIDEO_INFO:return SYNO.SDS.VideoStation2.VideoActionController.viewVideoInfo(a);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.correctMetadata(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.editMetadata(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_MULTIPLE_EPISODE_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.editMetadata(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE:return SYNO.SDS.VideoStation2.VideoActionController.searchSubtitle(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING:return SYNO.SDS.VideoStation2.VideoActionController.publicSharing(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:return SYNO.SDS.VideoStation2.VideoActionController.setWatched(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:return SYNO.SDS.VideoStation2.VideoActionController.setUnwatched(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO:return SYNO.SDS.VideoStation2.VideoActionController.delVideo(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE:return SYNO.SDS.VideoStation2.VideoActionController.delFile(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION:return SYNO.SDS.VideoStation2.VideoActionController.offlineConversion(a,c);default:SYNO.Debug.error(String.format("unknown video action {0}",b))}},createPlaylist:function(c,a){var b=new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,videos:c,onVideoAdded:a});b.open()},getOneVideoFileInfo:function(b,c){var a=new SYNO.SDS.VideoStation2.VideoFileChooseDialog({owner:SYNO.SDS.VideoStation2.Window,video:b,onVideoChoosed:c});a.open()},viewVideoInfo:function(a){SYNO.Assert(a.length===1,"viewVideoInfo only allow one video");var b=a[0];var c=function(g,f,d){var e=new SYNO.SDS.VideoStation2.VideoInfoDialog({owner:SYNO.SDS.VideoStation2.Window,files:g[SYNO.SDS.VideoStation2.Util.getVideoRoot(b.type)][0].additional.file||[]});e.open()};SYNO.SDS.VideoStation2.OP.get().getInfo({id:[b.id],additional:["file"]},{scope:this,success:c},b.type)},correctMetadata:function(a,c){SYNO.Assert(a.length===1,"correctMetadata only allow one video");var b=a[0];if(Ext.isNumber(b.file)){SYNO.SDS.VideoStation2.VideoActionController.doCorrectMetadata(b,c)}else{SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(b,function(d){b.file=d.id;SYNO.SDS.VideoStation2.VideoActionController.doCorrectMetadata(b,c)})}},editMetadata:function(b,c){SYNO.Assert(b.length>0,"editMetadata only allow at least one video");var a=new SYNO.SDS.VideoStation2.EditMetadataDialog({owner:SYNO.SDS.VideoStation2.Window,videos:b,onVideoMetadataEdited:c});a.open()},searchSubtitle:function(a,b){SYNO.Assert(a.length===1,"searchSubtitle only allow one video");SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a[0],function(d){var c=new SYNO.SDS.VideoStation2.SearchSubtitleDialog({owner:SYNO.SDS.VideoStation2.Window,file:d,onSubtitleDownloaded:b});c.open()})},publicSharing:function(b,d){var a;d=Ext.isFunction(d)?d:Ext.emptyFn;var c={};b.each(function(e){c[e.id.toString()+","+e.type]=true});c=Object.keys(c).map(function(f){var e=f.split(",");return{id:parseInt(e[0],10),type:e[1]}});if(c.length===1){a=new SYNO.SDS.VideoStation2.PublicSharingDialog({owner:SYNO.SDS.VideoStation2.Window,video:c[0],onEnableChanged:d})}else{a=new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,forcePublicSharing:true,videos:c,onVideoAdded:d})}a.open()},setWatched:function(a,b){SYNO.SDS.VideoStation2.VideoActionController.setWatchStatus(a,true,b)},setUnwatched:function(a,b){SYNO.SDS.VideoStation2.VideoActionController.setWatchStatus(a,false,b)},setWatchStatus:function(b,c,d){var a=function(g,f){var e=g[f].map(function(h){return h.id}).uniq();return SYNO.SDS.VideoStation2.OP.get().setVideoWatched({id:e,watched:(c)?true:false},{},f)};SYNO.SDS.VideoStation2.OP.classifyRequest(b,a,d)},offlineConversion:function(b,c){var a=new SYNO.SDS.VideoStation2.OfflineConversionActionDialog({videos:b,callback:c});a.open()},confirmDelete:function(a,b){var c=String.format(_VST("action","delete_video_confirm"),b);SYNO.SDS.VideoStation2.Window.getMsgBox().confirmDelete("",c,function(d){if("yes"===d){a()}})},delFile:function(a,b){SYNO.Assert(a.length===1,"delete file only allow one video");SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a[0],function(d){var c=function(){SYNO.SDS.VideoStation2.VideoActionController.doDelFile([d.id],b)};SYNO.SDS.VideoStation2.VideoActionController.confirmDelete(c,1)})},delVideo:function(b,c){var a=function(){SYNO.SDS.VideoStation2.VideoActionController.doDelVideo(b,c)};SYNO.SDS.VideoStation2.VideoActionController.confirmDelete(a,b.length)},doCorrectMetadata:function(b,c){var a=new SYNO.SDS.VideoStation2.EditMetadataDialog({owner:SYNO.SDS.VideoStation2.Window,videos:[b],onVideoMetadataEdited:c});a.open()},doDelVideo:function(b,d){if(Ext.isNumber(b[0].file)){var c=b.map(function(e){return e.file});SYNO.SDS.VideoStation2.VideoActionController.doDelFile(c,d)}else{var a=function(g,f){var e=g[f].map(function(h){return h.id}).uniq();return SYNO.SDS.VideoStation2.OP.get().deleteVideo({id:e},{},f)};SYNO.SDS.VideoStation2.OP.classifyRequest(b,a,d)}},doDelFile:function(a,b){SYNO.SDS.VideoStation2.OP.get().deleteFile({id:a},{success:b})},applyWatchStatusChangeToVideo:function(a,b){a.each(function(d){var c=d.record.get("additional")||{};c.watched_ratio=(b)?1:0;d.record.set("additional",c);d.record.commit()})}}});Ext.define("SYNO.SDS.VideoStation2.ActionUtil",{singleton:true,isAdminAction:function(a){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE].indexOf(a)!==-1},getAvailablePlaylistActions:function(){var a=SYNO.SDS.VideoStation2.PlaylistActionController.getAllActions();return a.filter(function(b){if(b===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()){return false}return true})},getAvailableVideoActions:function(){var a=SYNO.SDS.VideoStation2.VideoActionController.getAllActions();return a.filter(function(b){if(!_S("is_admin")&&SYNO.SDS.VideoStation2.ActionUtil.isAdminAction(b)){return false}if(b===SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()){return false}if(b===SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion()){return false}return true})}});Ext.define("SYNO.SDS.VideoStation2.AboutWindow",{extend:"SYNO.SDS.AboutWindow",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-about-window")}});Ext.define("SYNO.SDS.VideoStation2.AccordionPanel",{extend:"SYNO.ux.Panel",header:true,constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-accordion-panel");this.mon(this,"activate",this.addExpandedClass,this);this.mon(this,"deactivate",this.removeExpandedClass,this);this.mon(this,"afterrender",this.initExpandedClass,this,{single:true})},initExpandedClass:function(){if(this.header&&!this.collapsed){this.addExpandedClass()}},addExpandedClass:function(){if(this.header){this.header.addClass("expanded")}},removeExpandedClass:function(){if(this.header){this.header.removeClass("expanded")}}});Ext.define("SYNO.SDS.VideoStation2.ActionButton",{extend:"SYNO.ux.Button",constructor:function(a){this.callParent([a]);this.addClass("syno-vs2-action-button")}});Ext.define("SYNO.SDS.VideoStation2.MenuActionButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(d){d=d||{};var b=d.noicon===true?true:false;var a=d.menuBeforeShow||{};var c={handler:Ext.emptyFn,menu:d.menu||new SYNO.SDS.VideoStation2.DropdownMenu({noicon:b,items:[],listeners:{beforeshow:{scope:a.scope||this,fn:a.fn||Ext.emptyFn}}})};delete d.beforeshow;delete d.noicon;this.callParent([Ext.apply(c,d)]);this.addClass("menu-action-button")}});Ext.define("SYNO.SDS.VideoStation2.BrowsingAction",{statics:{EVENT_BROWSING_ACTION_CHANGED:"browsingactionchanged",ACTION_NONE:"none",ACTION_SELECT:"select",ACTION_DETAIL:"detail",ACTION_LIST:"list",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.BrowsingAction.instance)){SYNO.SDS.VideoStation2.BrowsingAction.instance=new SYNO.SDS.VideoStation2.BrowsingAction()}return SYNO.SDS.VideoStation2.BrowsingAction.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED);this.toNone()},selectAction:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted action {0}",a));if(this.current_action!==a){this.current_action=a;this.fireEvent(SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED)}},toNone:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_NONE)},toSelect:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_SELECT)},toDetail:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_DETAIL)},toList:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_LIST)},getCurrentAction:function(){SYNO.Assert(Ext.isString(this.current_action),String.format("unexpceted action {0}",this.current_action));return this.current_action},current_action:null});Ext.define("SYNO.SDS.VideoStation2.Category",{statics:{instance:null,EVENT_CATEGORY_CHANGED:"categorychanged",EVENT_CATEGORY_CLEARED:"categorycleared",CATEGORY_RECENTLY_ADDED:"recently_added",CATEGORY_RECENTLY_WATCHED:"recently_watched",CATEGORY_RECENTLY_RELEASED:"recently_released",CATEGORY_ALL:"all",CATEGORY_FOLDER:"folder",CATEGORY_BY_CHANNEL:"bychannel",CATEGORY_BY_PROGRAM:"byprogram",CATEGORY_NONE:"none",get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Category.instance)){SYNO.SDS.VideoStation2.Category.instance=new SYNO.SDS.VideoStation2.Category()}return SYNO.SDS.VideoStation2.Category.instance},getAllCategories:function(){return[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM]},isCommonLibraryAvailableCategory:function(a){return[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER].indexOf(a)!==-1},isTVRecordingAvailableCategory:function(a){return[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM].indexOf(a)!==-1},isRecordingSpecificCategory:function(a){return[SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM].indexOf(a)!==-1},isSpecialCategory:function(a){return[SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM].indexOf(a)!==-1},isSortAdjustableCategory:function(a){return[SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM].indexOf(a)!==-1}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED);this.current_category=SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED},selectCategory:function(b){SYNO.Assert(Ext.isString(b),String.format("unexpceted category {0}",b));if(this.current_category!==b){var a=this.current_category;this.current_category=b;this.fireEvent(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,a,b)}},toNone:function(){this.current_category=SYNO.SDS.VideoStation2.Category.CATEGORY_NONE;this.fireEvent(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED)},getCurrentCategory:function(){SYNO.Assert(Ext.isString(this.current_category),String.format("unexpceted category {0}",this.current_category));return this.current_category},getSortOption:function(){var a={};switch(this.current_category){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:a.sort_by="added";break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:a.sort_by="watched";break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:a.sort_by="date";break;default:break}if(a.sort_by){a.sort_direction="desc"}return a},getDefaultCategory:function(){return SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED},isCurrentRecordingSpecific:function(){return SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(this.current_category)},current_category:null});Ext.define("SYNO.SDS.VideoStation2.Channel",{statics:{EVENT_CHANNEL_CHANGE:"channelchange",EVENT_DATE_CHANGE:"datechange",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Channel.instance)){SYNO.SDS.VideoStation2.Channel.instance=new SYNO.SDS.VideoStation2.Channel()}return SYNO.SDS.VideoStation2.Channel.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE)},selectChannel:function(b,a){if(b===this.current_id){return}this.current_id=b;this.current_title=a;this.remain_days=null;if(!Ext.isEmpty(b)){this.current_date=Date.parseDate(new Date().format("Ymd"),"Ymd")}else{this.current_date=null}this.fireEvent(SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE)},selectDate:function(a){if(a.valueOf()===this.current_date.valueOf()){return}this.current_date=a;this.fireEvent(SYNO.SDS.VideoStation2.Channel.EVENT_DATE_CHANGE)},setRemainDays:function(a){this.remain_days=a},clearChannel:function(){this.selectChannel(null,"")},getCurrentID:function(){return this.current_id},getCurrentTitle:function(){return this.current_title},getCurrentDate:function(){return this.current_date},getRemainDays:function(){return this.remain_days},current_id:null,current_title:null,current_date:null,remain_days:null});Ext.define("SYNO.SDS.VideoStation2.DTV",{statics:{EVENT_DTV_LOAD:"dtvload",EVENT_DISABLE_DTV:"disable_dtv",EVENT_DTV_CHANGED:"dtvchanged",DEFAULT_DTV:[{id:-1,title:_VST("schedule","schedule_recording"),type:0,signal:0,additional:0}],instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.DTV.instance)){SYNO.SDS.VideoStation2.DTV.instance=new SYNO.SDS.VideoStation2.DTV()}return SYNO.SDS.VideoStation2.DTV.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,SYNO.SDS.VideoStation2.DTV.EVENT_DISABLE_DTV,SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED);this.prepareDefaultDTV()},getDTVStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.DTVStore({appWindow:SYNO.SDS.VideoStation2.Window,listeners:{scope:this,load:this.onDTVLoad,exception:this.onDTVLoadException}});return this.store},loadDTV:function(){this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DISABLE_DTV,this.disable_dtv);if(this.disable_dtv){this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,false,[]);return}this.getDTVStore().load()},onDTVLoad:function(c,b,d){this.tuners=b||[];if(Ext.isEmpty(this.tuners)){this.store.removeAll()}var a=true;Ext.each(this.tuners,function(e){if(e.get("id")===this.current_id){a=false;return false}},this);if(this.current_id===SYNO.SDS.VideoStation2.DTV.DEFAULT_DTV[0].id){a=false}if(!SYNO.SDS.VideoStation2.Capability.get().ableToControlDTV()){this.store.removeAll();this.default_dtv[0].set("display","none");a=false}this.store.insert(0,this.default_dtv);this.store.commitChanges();this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,a,this.tuners);this.loadDTV.defer(8000,this)},onDTVLoadException:function(){this.loadDTV.defer(8000,this)},prepareDefaultDTV:function(){if(Ext.isEmpty(this.default_dtv)){this.default_dtv=SYNO.SDS.VideoStation2.DTV.DEFAULT_DTV.map(function(a){return new SYNO.SDS.VideoStation2.DTVStore.Record(a,a.id)})}},selectDTV:function(a){if(a===this.current_id){return}this.current_id=a;this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED)},getCurrentID:function(){return this.current_id},getCurrentDTV:function(){return(this.store.getById(this.current_id)||{}).data},getTuner:function(){return this.tuners},setDTVDisabled:function(a){this.disable_dtv=a===true},isDTVDisabled:function(){return this.disable_dtv},tuners:[],disable_dtv:false,current_id:null});Ext.define("SYNO.SDS.VideoStation2.DTVStore",{statics:{Record:Ext.data.Record.create([{name:"id",type:"int"},{name:"title",type:"string"},{name:"type",type:"int"},{name:"signal",type:"int"},{name:"additional"}])},extend:"SYNO.API.Store",constructor:function(b){var a={api:"SYNO.DTV.Tuner",method:"list",version:1,baseParams:{additional:"channel_status"},reader:new Ext.data.JsonReader({root:"tuners",idProperty:"id"},SYNO.SDS.VideoStation2.DTVStore.Record)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Folder",{statics:{EVENT_FOLDER_CHANGED:"folderchanged",FOLDER_NULL:null,instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Folder.instance)){SYNO.SDS.VideoStation2.Folder.instance=new SYNO.SDS.VideoStation2.Folder()}return SYNO.SDS.VideoStation2.Folder.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.resetData()},resetData:function(){this.current_folder=[];this.fireEvent(SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED)},selectFolder:function(b,a){SYNO.Assert(Ext.isString(b),String.format("unexpceted FolderPath {0}",b));this.current_folder.push({id:b,pathTitle:a});this.fireEvent(SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED)},thrinkFolderStackTo:function(b){if(b===SYNO.SDS.VideoStation2.Folder.FOLDER_NULL){this.resetData();return}var a=-1;Ext.each(this.current_folder,function(d,c){if(d.id===b.id){a=c;return false}});if(a!==-1){this.current_folder=this.current_folder.slice(0,a+1)}this.fireEvent(SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED)},isSet:function(){return !Ext.isEmpty(this.current_folder)},getCurrentID:function(){if(this.current_folder.length===0){return null}return this.current_folder.last().id},getCurrentPathTitle:function(){if(this.current_folder.length===0){return null}return this.current_folder.last().pathTitle},getCurrentFolderStack:function(){return SYNO.Util.copy(this.current_folder)},current_folder:[]});Ext.define("SYNO.SDS.VideoStation2.RecordingSpecific",{extend:"Ext.util.Observable",statics:{EVENT_RECORDING_SPECIFIC_SET:"recordingspecificset",EVENT_RECORDING_SPECIFIC_CLEAR:"recordingspecificclear",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.RecordingSpecific.instance)){SYNO.SDS.VideoStation2.RecordingSpecific.instance=new SYNO.SDS.VideoStation2.RecordingSpecific()}return SYNO.SDS.VideoStation2.RecordingSpecific.instance}},constructor:function(){this.callParent(arguments);this.resetData()},resetData:function(){this.clearChannel();this.clearProgram()},getCurrentChannel:function(){SYNO.Assert(Ext.isString(this.current_channel),"channel unset");return this.current_channel},getCurrentProgram:function(){SYNO.Assert(Ext.isString(this.current_program),"program unset");return this.current_program},clearChannel:function(){if(Ext.isString(this.current_channel)){this.current_channel=null;this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR)}},clearProgram:function(){if(Ext.isString(this.current_program)){this.current_program=null;this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR)}},selectChannel:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted channel {0}",a));if(this.current_channel!==a){this.current_channel=a;this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET)}},selectProgram:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted program {0}",a));if(this.current_program!==a){this.current_program=a;this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET)}},getFilterOption:function(){var a={};if(Ext.isString(this.current_channel)){a[SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME]=[this.current_channel]}else{if(Ext.isString(this.current_program)){a[SYNO.SDS.VideoStation2.Filter.FILTER_TITLE]=[this.current_program]}}return a},getValue:function(){return this.current_channel||this.current_program},isSet:function(){return Ext.isString(this.current_channel)||Ext.isString(this.current_program)},current_channel:null,current_program:null});Ext.define("SYNO.SDS.VideoStation2.View",{statics:{VIEW_HOMEPAGE:"view_homepage",VIEW_PLAYLIST:"view_playlist",VIEW_POSTER:"view_poster",VIEW_DETAIL:"view_detail",VIEW_TVSHOW:"view_tvshow",VIEW_SCHEDULE:"view_schedule",VIEW_DTV:"view_dtv",TYPE_THUMBNAIL:"thumbnail",TYPE_TILE:"tile",TYPE_LIST:"list",EVENT_VIEW_CHANGED:"viewchanged",EVENT_VIEWTYPE_CHANGED:"viewtypechanged",EVENT_VIEW_REFRESH:"viewrefresh",EVENT_VIEW_REFRESH_INFO:"viewrefreshinfo",EVENT_VIEWPAGE_CHANGED:"viewpagechanged",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.View.instance)){SYNO.SDS.VideoStation2.View.instance=new SYNO.SDS.VideoStation2.View()}return SYNO.SDS.VideoStation2.View.instance},getAllTypes:function(){return[SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL,SYNO.SDS.VideoStation2.View.TYPE_TILE,SYNO.SDS.VideoStation2.View.TYPE_LIST]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO);this.viewType=SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL},setPageView:function(a){if(this.view!==a){this.view=a;this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED)}else{this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)}},toHomePageView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE);this.setPage(null,false)},toPlaylistView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST);this.setPage(null,false)},toPosterView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_POSTER)},toDetailView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_DETAIL);this.setPage(null,false)},toTVShowView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_TVSHOW);this.setPage(null,false)},toScheduleView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE);this.setPage(null,false)},toDTVView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_DTV);this.setPage(null,false)},toEmptyView:function(){this.setPageView(null)},setViewType:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted viewtype {0}",a));if(this.viewType!==a){this.viewType=a;this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED)}},toThumbnailType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL)},toTileType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_TILE)},toListType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_LIST)},setPage:function(b,a){if(!a&&this.view!==SYNO.SDS.VideoStation2.View.VIEW_POSTER){b=null}this.pageFromURL=a;this.page=b;this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEWPAGE_CHANGED,b)},getPage:function(){if(!this.pageFromURL){return null}return this.page},getView:function(){return this.view},getViewType:function(){SYNO.Assert(Ext.isString(this.viewType),String.format("unexpceted viewtype {0}",this.viewType));return this.viewType},view:null,viewType:null,page:null,pageFromURL:false});Ext.define("SYNO.SDS.VideoStation2.Hash",{statics:{EVENT_HASH_CHANGED:"hashchanged",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Hash.instance)){SYNO.SDS.VideoStation2.Hash.instance=new SYNO.SDS.VideoStation2.Hash()}return SYNO.SDS.VideoStation2.Hash.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments);this.lockStack={};this.options={};this.replaceState=false;this.arm()},arm:function(){this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChanged,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryCleared,this);this.mon(SYNO.SDS.VideoStation2.Folder.get(),SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED,this.onFolderChanged,this);this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED,this.onPlaylistChanged,this);this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CLEARED,this.onPlaylistCleared,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,this.onTVShowChanged,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CLEARED,this.onTVShowCleared,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this);this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO,this.onSelectVideo,this);this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED,this.onDTVChanged,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChanged,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWPAGE_CHANGED,this.onViewPageChanged,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChanged,this);this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificChanged,this);this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificChanged,this)},disarm:function(){this.mun(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this);this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChanged,this);this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryCleared,this);this.mun(SYNO.SDS.VideoStation2.Folder.get(),SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED,this.onFolderChanged,this);this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED,this.onPlaylistChanged,this);this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CLEARED,this.onPlaylistCleared,this);this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,this.onTVShowChanged,this);this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CLEARED,this.onTVShowCleared,this);this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this);this.mun(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO,this.onSelectVideo,this);this.mun(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED,this.onDTVChanged,this);this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChanged,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWPAGE_CHANGED,this.onViewPageChanged,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChanged,this);this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificChanged,this);this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificChanged,this)},onLibraryChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.LIBRARY,SYNO.SDS.VideoStation2.Library.get().cursor);this.updatePath()},onCategoryChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.CATEGORY,SYNO.SDS.VideoStation2.Category.get().getCurrentCategory());this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},onCategoryCleared:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.CATEGORY,null);this.updatePath()},onPlaylistChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.PLAYLIST,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID(),title:SYNO.SDS.VideoStation2.Playlist.get().getCurrentPathTitle()});this.updatePath()},onPlaylistCleared:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.PLAYLIST,null);this.updatePath()},onFolderChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.FOLDER,SYNO.SDS.VideoStation2.Folder.get().getCurrentFolderStack());this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},onTVShowChanged:function(){var a=SYNO.SDS.VideoStation2.TVShow.get();var b={id:a.getCurrentID()};if(a.getCurrentTVShow().hasOwnProperty("library_id")){Ext.apply(b,{library_id:a.getCurrentTVShow().library_id})}this.setOptions(SYNO.SDS.VideoStation2.Constant.TVSHOW,b);this.lockStack[SYNO.SDS.VideoStation2.Constant.SEASON]=SYNO.SDS.VideoStation2.Constant.SEASON},onTVShowCleared:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.TVSHOW,null);this.setOptions(SYNO.SDS.VideoStation2.Constant.SEASON,null);this.updatePath()},onSeasonChanged:function(){if(this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.SEASON)){this.replaceState=true}this.setOptions(SYNO.SDS.VideoStation2.Constant.SEASON,SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason());this.updatePath(SYNO.SDS.VideoStation2.Constant.SEASON)},onSelectVideo:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.VIDEO,SYNO.SDS.VideoStation2.Video.get().getCurrentVideo());this.updatePath()},onDTVChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.DTV,SYNO.SDS.VideoStation2.DTV.get().getCurrentID());this.updatePath()},onFilterChanged:function(){var a=SYNO.SDS.VideoStation2.Filter.get();var b=Ext.apply(SYNO.Util.copy(a.getKeywordOption()),a.getFilterOption());if(this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.FILTER)&&!SYNO.ux.Utils.checkObjectConsistency(b,{})){this.replaceState=true}this.setOptions(SYNO.SDS.VideoStation2.Constant.FILTER,b);this.updatePath()},onViewPageChanged:function(a){this.setOptions(SYNO.SDS.VideoStation2.Constant.PAGE,a);this.updatePath(SYNO.SDS.VideoStation2.Constant.PAGE)},onViewChanged:function(){this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},onRecordingSpecificChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.RECORDING_SPECIFIC,SYNO.SDS.VideoStation2.RecordingSpecific.get().getValue());this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},setOptions:function(a,b){if(SYNO.ux.Utils.checkObjectConsistency(b,{})||Ext.isEmpty(b)){if(this.options.hasOwnProperty(a)){delete this.options[a]}return}this.options[a]=b},getPath:function(){var c="";var b={};if(this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.DTV)){c="DTV";b=Ext.copyTo({},this.options,SYNO.SDS.VideoStation2.Constant.DTV)}else{if(!this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.LIBRARY)){c="Home"}else{var a=SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(this.options[SYNO.SDS.VideoStation2.Constant.LIBRARY]);c=a.id===0?encodeURIComponent(a.title):"lib"+encodeURIComponent(a.title)}b=this.options}return SYNO.ux.Utils.checkObjectConsistency(b,{})?c:c+"/"+LZString.compressToEncodedURIComponent(Ext.encode(b))},getOptions:function(){return this.options},setOptionsByURL:function(a){this.resetData();if(-1===a.search("/")){return false}var d=a.substring(a.search("/")+1,a.length);var b=LZString.decompressFromEncodedURIComponent(d);if(Ext.isEmpty(b)){return false}try{this.options=Ext.decode(b,[true])}catch(c){return false}return true},resetData:function(){this.options={}},updatePath:function(a){if(a){delete this.lockStack[a]}if(SYNO.ux.Utils.checkObjectConsistency(this.lockStack,{})){this.fireEvent(SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.replaceState);this.replaceState=false}},unUpdatePath:function(a){if(a===undefined){return}this.lockStack[a]=a}});Ext.define("SYNO.SDS.VideoStation2.Navigation",{statics:{EVENT_NAVIGATION_PATH_CHANGED:"navpathchanged",EVENT_NAVIGATION_TYPE_CHANGED:"navtypechanged",EVENT_NAVIGATION_GOBACK:"navgoback",TYPE_PATH:"path",TYPE_CATEGORY:"category",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Navigation.instance)){SYNO.SDS.VideoStation2.Navigation.instance=new SYNO.SDS.VideoStation2.Navigation()}return SYNO.SDS.VideoStation2.Navigation.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK);this.toCategory()},setNavigation:function(a,b){if(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted type {0}",a));if(this.current_type!==a){this.current_type=a;this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED)}}if(!Ext.isArray(b)||!Ext.isArray(this.current_path)||!SYNO.ux.Utils.checkObjectConsistency(this.current_path,b)){this.current_path=b;this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED)}},toPath:function(a){this.setNavigation(SYNO.SDS.VideoStation2.Navigation.TYPE_PATH,a)},toCategory:function(){this.setNavigation(SYNO.SDS.VideoStation2.Navigation.TYPE_CATEGORY,null)},goback:function(){this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK)},getCurrentPath:function(){return this.current_path},getCurrentType:function(){SYNO.Assert(Ext.isString(this.current_type),String.format("unexpceted nav type {0}",this.current_type));return this.current_type},current_path:null,current_type:null});Ext.define("SYNO.SDS.VideoStation2.RecordingSpecificController",{extend:"Ext.Component",statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.RecordingSpecificController.instance)){SYNO.SDS.VideoStation2.RecordingSpecificController.instance=new SYNO.SDS.VideoStation2.RecordingSpecificController()}return SYNO.SDS.VideoStation2.RecordingSpecificController.instance}},constructor:function(){this.callParent(arguments);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChanged,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryChanged,this)},onCategoryChanged:function(){if(!SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific()){SYNO.SDS.VideoStation2.RecordingSpecific.get().resetData()}},handleRecordingSpecific:function(b,c){var a=SYNO.SDS.VideoStation2.RecordingSpecific.get();if(SYNO.SDS.VideoStation2.Constant.CHANNEL===b){a.selectChannel(c)}else{if(SYNO.SDS.VideoStation2.Constant.PROGRAM===b){a.selectProgram(c)}else{a.resetData()}}}});Ext.define("SYNO.SDS.VideoStation2.Sort",{statics:{instance:null,EVENT_SORT_CHANGED:"sortchanged",SORT_RECENTLY_ADDED:"recently_added",SORT_RECENTLY_RELEASED:"recently_released",SORT_TITLE:"title",DIR_DESC:"desc",DIR_ASC:"asc",get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Sort.instance)){SYNO.SDS.VideoStation2.Sort.instance=new SYNO.SDS.VideoStation2.Sort()}return SYNO.SDS.VideoStation2.Sort.instance},getAllSorts:function(){return[SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Sort.SORT_TITLE]},getAllDirections:function(){return[SYNO.SDS.VideoStation2.Sort.DIR_ASC,SYNO.SDS.VideoStation2.Sort.DIR_DESC]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.resetSort()},setSort:function(b,a){var c=false;if(null!==b){SYNO.Assert(Ext.isString(b),String.format("unexpceted sort {0}",b));if(this.current_sort!==b){this.current_sort=b;c=true}}if(null!==a){SYNO.Assert(Ext.isString(a),String.format("unexpceted dir {0}",a));if(this.current_dir!==a){this.current_dir=a;c=true}}if(c){if(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){this.saveSortPreference()}this.fireEvent(SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED)}},resetSort:function(){this.setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},setSortType:function(a){this.setSort(a,null)},setSortDir:function(a){this.setSort(null,a)},saveSortPreference:function(){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance",this.getPreferenceKey(),{sort_by:this.current_sort,sort_direction:this.current_dir})},loadSortPreference:function(){var a=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance",this.getPreferenceKey());if(Ext.isObject(a)){this.current_sort=a.sort_by;this.current_dir=a.sort_direction}else{this.current_sort=SYNO.SDS.VideoStation2.Sort.SORT_TITLE;this.current_dir=SYNO.SDS.VideoStation2.Sort.DIR_ASC}this.fireEvent(SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED)},getCurrentSort:function(){SYNO.Assert(Ext.isString(this.current_sort),String.format("unexpceted sort {0}"),this.current_sort);return this.current_sort},getCurrentSortDir:function(){SYNO.Assert(Ext.isString(this.current_dir),String.format("unexpceted sort dir {0}"),this.current_dir);return this.current_dir},getSortOption:function(){var a={};switch(this.current_sort){case SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED:a.sort_by="added";break;case SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED:a.sort_by="date";break;case SYNO.SDS.VideoStation2.Sort.SORT_TITLE:a.sort_by="title";break;default:break}if(this.current_dir){a.sort_direction=this.current_dir}return a},getPreferenceKey:function(){return SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()+"sortstate"},current_sort:null,current_dir:null});Ext.define("SYNO.SDS.VideoStation2.VideoListController",{statics:{toNone:function(){SYNO.SDS.VideoStation2.Category.get().toNone();SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false)},toAvailableCategory:function(a){var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var d=(b===SYNO.SDS.VideoStation2.Category.CATEGORY_NONE);var c=(a===SYNO.SDS.VideoStation2.Constant.TV_RECORDING)?SYNO.SDS.VideoStation2.Category.isTVRecordingAvailableCategory(b):SYNO.SDS.VideoStation2.Category.isCommonLibraryAvailableCategory(b);if(d||!c){SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory()}},toRecentlyAddedCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toRecentlyWatchCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false)},toRecentlyReleasedCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toAllCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_ALL);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().loadSortPreference()},toFolderCategory:function(){SYNO.SDS.VideoStation2.Folder.get().resetData();SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER)},toChannelCategory:function(){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL);SYNO.SDS.VideoStation2.VideoListController.toAvailableSort(SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},toProgramCategory:function(){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM);SYNO.SDS.VideoStation2.VideoListController.toAvailableSort(SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},toAvailableSort:function(d){var c=d===SYNO.SDS.VideoStation2.Constant.PLAYLIST;var a=SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific();var b=c&&SYNO.SDS.VideoStation2.Sort.get().getCurrentSort()===SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED;if(a||b){SYNO.SDS.VideoStation2.VideoListController.toSortType(SYNO.SDS.VideoStation2.Sort.SORT_TITLE)}},toSortType:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSortType(a)},toSortDirection:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSortDir(a)},toSelectMode:function(c,a){var b=SYNO.SDS.VideoStation2.Video.get();b.clearVideoSelection();if(c){b.enterSelectMode()}else{b.leaveSelectMode()}if(a){if(c){SYNO.SDS.VideoStation2.BrowsingAction.get().toSelect()}else{SYNO.SDS.VideoStation2.BrowsingAction.get().toList()}}}}});Ext.define("SYNO.SDS.VideoStation2.Controller",{statics:{setBackdrop:function(a){var b=String.format('url("{0}")',a);SYNO.SDS.VideoStation2.Window.getEl().select(".background-poster").each(function(c){c.setStyle("background-image",b)})},switchLibrary:function(c){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.LIBRARY);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);var b=SYNO.SDS.VideoStation2.Library.get();var a=SYNO.SDS.VideoStation2.View.get();a.toEmptyView();SYNO.SDS.VideoStation2.Folder.get().resetData();SYNO.SDS.VideoStation2.Filter.get().clearAllFilter();SYNO.SDS.VideoStation2.Video.get().clearVideo();SYNO.SDS.VideoStation2.TVShow.get().clearTVShow();SYNO.SDS.VideoStation2.Playlist.get().clearSelection();SYNO.SDS.VideoStation2.RecordingSpecific.get().resetData();SYNO.SDS.VideoStation2.DTV.get().selectDTV(null);if(Ext.isString(c)){b.activate(c)}SYNO.SDS.VideoStation2.VideoListController.toAvailableSort(b.getCurrentType());if(SYNO.SDS.VideoStation2.Constant.PLAYLIST===b.getCurrentType()){SYNO.SDS.VideoStation2.VideoListController.toNone();SYNO.SDS.VideoStation2.Controller.intoPlaylistView();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.LIBRARY);return}SYNO.SDS.VideoStation2.Sort.get().loadSortPreference();SYNO.SDS.VideoStation2.VideoListController.toAvailableCategory(b.getCurrentType());SYNO.SDS.VideoStation2.BrowsingAction.get().toList();a.toPosterView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.LIBRARY)},switchLibraryTemporary:function(a){SYNO.SDS.VideoStation2.Library.get().activateTemporary(a)},switchDTV:function(a){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.DTV);SYNO.SDS.VideoStation2.Navigation.get().toPath(null);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.View.get().toEmptyView();SYNO.SDS.VideoStation2.Filter.get().clearAllFilter();SYNO.SDS.VideoStation2.Channel.get().clearChannel();SYNO.SDS.VideoStation2.Library.get().activate("");SYNO.SDS.VideoStation2.DTV.get().selectDTV(a);if(a<0){SYNO.SDS.VideoStation2.View.get().toScheduleView()}else{SYNO.SDS.VideoStation2.View.get().toDTVView()}SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.DTV)},refreshView:function(){SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)},refreshViewInfo:function(a){SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,a)},intoHomePage:function(a){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.VideoListController.toNone();SYNO.SDS.VideoStation2.BrowsingAction.get().toNone();if(a!==true){SYNO.SDS.VideoStation2.View.get().toEmptyView();SYNO.SDS.VideoStation2.Filter.get().clearAllFilter()}SYNO.SDS.VideoStation2.Sort.get().resetSort();SYNO.SDS.VideoStation2.DTV.get().selectDTV(null);SYNO.SDS.VideoStation2.Library.get().activate("");SYNO.SDS.VideoStation2.Playlist.get().clearSelection();SYNO.SDS.VideoStation2.Folder.get().resetData();SYNO.SDS.VideoStation2.Video.get().clearVideo();SYNO.SDS.VideoStation2.TVShow.get().clearTVShow();SYNO.SDS.VideoStation2.View.get().toHomePageView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE)},intoPlaylistView:function(){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.PLAYLIST);if(SYNO.SDS.VideoStation2.View.get().getViewType()===SYNO.SDS.VideoStation2.View.TYPE_TILE){SYNO.SDS.VideoStation2.View.get().toThumbnailType()}SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toList();SYNO.SDS.VideoStation2.View.get().toPlaylistView();SYNO.SDS.VideoStation2.Video.get().clearVideo();SYNO.SDS.VideoStation2.Playlist.get().clearSelection();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.PLAYLIST)},intoPosterView:function(c,b,a){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.View.VIEW_POSTER);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);if(Ext.isDefined(c)){SYNO.SDS.VideoStation2.View.get().toEmptyView();if(SYNO.SDS.VideoStation2.Constant.PLAYLIST===c){SYNO.SDS.VideoStation2.Playlist.get().selectPlaylist(b,a)}else{if(SYNO.SDS.VideoStation2.Constant.FOLDER===c){SYNO.SDS.VideoStation2.Folder.get().selectFolder(b,a)}}}if(SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific()){SYNO.SDS.VideoStation2.RecordingSpecificController.get().handleRecordingSpecific(c,a)}SYNO.SDS.VideoStation2.BrowsingAction.get().toList();SYNO.SDS.VideoStation2.View.get().toPosterView();SYNO.SDS.VideoStation2.Video.get().clearVideo();SYNO.SDS.VideoStation2.TVShow.get().clearTVShow();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.View.VIEW_POSTER)},setupVideoDetail:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toDetail();if(Ext.isObject(a)){SYNO.SDS.VideoStation2.Video.get().selectVideo(a);SYNO.SDS.VideoStation2.Controller.preSelectFile(Ext.isNumber(a.file)?a.file:null)}},intoVideoDetailFromOfflineVideo:function(b){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.View.VIEW_DETAIL);SYNO.SDS.VideoStation2.Controller.setupVideoDetail(b);SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.get().getDefaultCategory());SYNO.SDS.VideoStation2.View.get().toDetailView();SYNO.SDS.VideoStation2.DTV.get().selectDTV(null);SYNO.SDS.VideoStation2.Library.get().activate("");SYNO.SDS.VideoStation2.Playlist.get().clearSelection();SYNO.SDS.VideoStation2.TVShow.get().clearTVShow();SYNO.SDS.VideoStation2.Controller.updatePath();var a=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(b.type);var c=String.format("{0}-{1}",a,Ext.isDefined(b.library_id)?b.library_id:0);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(c);SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.View.VIEW_DETAIL)},intoVideoDetail:function(b,a){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.VIDEO);if(Ext.isObject(b)){SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(String.format("{0}-{1}",SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(b.type),b.library_id))}SYNO.SDS.VideoStation2.Controller.setupVideoDetail(b);if(Ext.isObject(a)){SYNO.SDS.VideoStation2.Video.get().setVideoListProxy(a)}SYNO.SDS.VideoStation2.View.get().toDetailView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.VIDEO)},updateVideoInfo:function(a){SYNO.SDS.VideoStation2.Video.get().selectVideo({id:a.id,type:a.type,pathTitle:a.pathTitle,mapper_id:a.mapper_id,library_id:a.library_id});SYNO.SDS.VideoStation2.Controller.updatePath()},intoTVShow:function(a){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.TVSHOW);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toList();SYNO.SDS.VideoStation2.Video.get().clearVideo();if(Ext.isDefined(a)){SYNO.SDS.VideoStation2.TVShow.get().selectTVShow(a)}SYNO.SDS.VideoStation2.View.get().toTVShowView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.TVSHOW)},loadFile:function(a){SYNO.SDS.VideoStation2.File.get().loadFile(a)},switchFile:function(a){SYNO.SDS.VideoStation2.File.get().selectFile(a)},preSelectFile:function(a){SYNO.SDS.VideoStation2.File.get().setPreSelectFile(a)},setFilter:function(e,f){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.FILTER);if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){var d=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();var c=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(d.type);var b=Ext.isNumber(d.library_id)?d.library_id:0;var h=String.format("{0}-{1}",c,b);SYNO.SDS.VideoStation2.Controller.switchLibrary(h)}SYNO.SDS.VideoStation2.Video.get().clearVideo();SYNO.SDS.VideoStation2.TVShow.get().clearTVShow();SYNO.SDS.VideoStation2.Playlist.get().clearSelection();var a=SYNO.SDS.VideoStation2.Library.get();SYNO.SDS.VideoStation2.View.get().toEmptyView();if(e===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){SYNO.SDS.VideoStation2.Filter.get().setKeyword(f)}else{SYNO.SDS.VideoStation2.Filter.get().clearAllFilter();SYNO.SDS.VideoStation2.Filter.get().addFilter(e,f);if(a.isDeactivated()){a.activateFromTemporary()}}var g=SYNO.SDS.VideoStation2.DTV.get().getCurrentID();if(Ext.isNumber(g)){SYNO.SDS.VideoStation2.Channel.get().clearChannel();SYNO.SDS.VideoStation2.View.get().toDTVView()}else{if(a.isDeactivated()){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toNone();SYNO.SDS.VideoStation2.View.get().toHomePageView()}else{SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toList();SYNO.SDS.VideoStation2.VideoListController.toAllCategory();SYNO.SDS.VideoStation2.View.get().toPosterView()}SYNO.SDS.VideoStation2.Controller.updatePath()}SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.FILTER)},goback:function(){SYNO.SDS.VideoStation2.Navigation.get().goback()},getClassificationString:function(b,c){var a="";if(c===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO&&b===SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED){a="recently_recoded"}else{a=b}return _VST("classification",a)},getFolderPath:function(b,a){if(b!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER){return null}return SYNO.SDS.VideoStation2.Folder.get().getCurrentFolderStack().map(function(c){return{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:c.pathTitle,folder:c}})},getRecordingSpecificPath:function(d,c){var b=SYNO.SDS.VideoStation2.RecordingSpecific.get();if(!SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(d)||!b.isSet()){return null}var a=d===SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL;return[{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:c},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:a?b.getCurrentChannel():b.getCurrentProgram(),recording_specific:a?SYNO.SDS.VideoStation2.Constant.CHANNEL:SYNO.SDS.VideoStation2.Constant.PROGRAM}]},updatePath:function(){var a=SYNO.SDS.VideoStation2.Category.get();var h=SYNO.SDS.VideoStation2.Library.get();var g=SYNO.SDS.VideoStation2.View.get();var c=SYNO.SDS.VideoStation2.TVShow.get();var b=SYNO.SDS.VideoStation2.Video.get();var e=SYNO.SDS.VideoStation2.Navigation.get();var f=SYNO.SDS.VideoStation2.Playlist.get();var j=SYNO.SDS.VideoStation2.Controller.getClassificationString(a.getCurrentCategory(),h.getCurrentType());var k=null;var d=SYNO.SDS.VideoStation2.Controller.getFolderPath(a.getCurrentCategory(),j);var i=SYNO.SDS.VideoStation2.Controller.getRecordingSpecificPath(a.getCurrentCategory(),j);switch(g.getView()){case SYNO.SDS.VideoStation2.View.VIEW_TVSHOW:k=[{view:h.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:h.isDeactivated()?_VST("common","homepage"):j},{view:SYNO.SDS.VideoStation2.View.VIEW_TVSHOW,value:c.getCurrentTVShow().title}];break;case SYNO.SDS.VideoStation2.View.VIEW_DETAIL:if(h.getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){k=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:f.getCurrentPathTitle()},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()}]}else{if(Ext.isArray(d)){k=[].concat({view:h.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:h.isDeactivated()?_VST("common","homepage"):j,folder:SYNO.SDS.VideoStation2.Folder.FOLDER_NULL}).concat(d).concat({view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()})}else{if(Ext.isArray(i)){k=i.concat({view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()})}else{if(h.getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW&&!Ext.isEmpty(c.getCurrentTVShow())){k=[{view:h.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:h.isDeactivated()?_VST("common","homepage"):j},{view:SYNO.SDS.VideoStation2.View.VIEW_TVSHOW,value:c.getCurrentTVShow().title},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()}]}else{k=[{view:h.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:h.isDeactivated()?_VST("common","homepage"):j},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()}]}}}}break;case SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST:k=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")}];break;case SYNO.SDS.VideoStation2.View.VIEW_POSTER:if(h.getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){k=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:f.getCurrentPathTitle()}]}else{if(Ext.isArray(d)&&d.length>0){k=[].concat({view:h.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:h.isDeactivated()?_VST("common","homepage"):j,folder:SYNO.SDS.VideoStation2.Folder.FOLDER_NULL}).concat(d)}else{if(Ext.isArray(i)){k=i}}}break;default:break}SYNO.Debug("updatePath",k,g.getView());if(k){e.toPath(k)}else{e.toCategory()}}}});Ext.define("SYNO.SDS.VideoStation2.DTVUtil",{singleton:true,bandwidthValidator:function(a){if(!Ext.isNumber(a)){a=parseInt(a,10)}return 0===a||(20000>=a&&3000<=a)},getWeekdayString:function(a){if(Ext.isString(a)){a=parseInt(a,10)}switch(a){case 0:return _VST("repeat","schedule_sun");case 1:return _VST("repeat","schedule_mon");case 2:return _VST("repeat","schedule_tue");case 3:return _VST("repeat","schedule_wed");case 4:return _VST("repeat","schedule_thu");case 5:return _VST("repeat","schedule_fri");case 6:return _VST("repeat","schedule_sat")}},getProgramStatus:function(a){switch(a){case 0:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_NONE;case 1:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_PASS;case 2:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_STREAMING;case 3:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_RECORDING;case 4:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_SCHEDULED;case 22:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_REPEAT_SCHEDULED}},getScheduleStatus:function(a){switch(a){case 0:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_ERROR;case 1:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WAIT;case 2:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_STREAMING;case 3:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_RECORDING;case 4:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DONGLE_NOT_FOUND;case 5:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_RECORDING_INTERRUPT;case 6:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DONE;case 7:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_NO_PERMISSION;case 8:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_USER_INVALID;case 9:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_NO_QUOTA;case 10:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_VOLUME_FULL;case 11:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_CREATE_FILE_ERROR;case 12:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE;case 13:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE;case 14:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_VLC_INTERRUPT;case 15:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_SKIP}},getScheduleStatusString:function(a){switch(a){case 0:return _T("error","error_error");case 1:return _VST("record","task_waiting");case 2:return _VST("streaming","streaming_for_someone");case 3:return _VST("action","recording");case 4:return _VST("error","no_dtv_dongle");case 5:return _VST("record","record_interrupt");case 6:return _VST("record","task_finished");case 7:return _VST("error","record_dest_deny");case 8:return _VST("error","invalid_user");case 9:return _VST("error","record_quota_reached");case 10:return _VST("error","record_no_volume");case 11:return _VST("error","record_dest_not_exist");case 12:return _VST("repeat","repeat_weekly");case 13:return _VST("repeat","repeat_daily");case 14:return _VST("record","record_interrupt");case 15:return _VST("record","skip")}},getTunerPort:function(a){return 9025+a%16},getStreamingURL:function(b){var a=window.location;return String.format("{0}//{1}{2}VideoStation/livestreaming/{3}",a.protocol,a.host,a.pathname.substr(0,a.pathname.lastIndexOf("/")+1),b)},isScheduleStatusRepeatSchedule:function(a){var b=SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus(a);return(SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE===b||SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE===b)},isProgramStatusRepeatSchedule:function(a){var b=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(a);return(SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_REPEAT_SCHEDULED===b||SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_DAILY_SCHEDULED===b)},isDailySchedule:function(a){var b=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(a);return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_DAILY_SCHEDULED===b},durationFormatter:function(a){var b=a%86400;return[("00"+Math.floor(b/3600)).substr(-2),("00"+Math.floor((b%3600)/60)).substr(-2),("00"+Math.floor(b%60)).substr(-2)].join(":")},scheduleStatusIconRenderer:function(b){var a=SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus(b);return SYNO.SDS.VideoStation2.DTVUtil.getDTVStatusIcon(a)},programStatusIconRenderer:function(b){var a=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(b);return SYNO.SDS.VideoStation2.DTVUtil.getDTVStatusIcon(a)},getDTVStatusIcon:function(b){var a="";switch(b){case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_RECORDING:a="recording";break;case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_SCHEDULED:case SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WAIT:a="time";break;case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_REPEAT_SCHEDULED:case SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE:case SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE:a="loop";break;default:break}return !Ext.isEmpty(a)?String.format('<div class="status {0}"></div>',a):""}});Ext.define("SYNO.SDS.VideoStation2.Player",{statics:{EVENT_PLAYER_LOAD:"playerload",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Player.instance)){SYNO.SDS.VideoStation2.Player.instance=new SYNO.SDS.VideoStation2.Player()}return SYNO.SDS.VideoStation2.Player.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},loadPlayer:function(a){SYNO.Assert(Ext.isArray(a),String.format("bad player object array {0}",a));this.players=[];if(Ext.isDefined(window.chrome)&&Ext.isDefined(window.chrome.cast)&&window.chrome.cast.isAvailable){var b={title:_VST("controller","chromecast_mode"),id:SYNO.VideoController2.Util.CHROMECAST_ID};this.players=this.players.concat(b)}this.players=this.players.concat(a);this.current_idx=null;this.streaming=true;this.fireEvent(SYNO.SDS.VideoStation2.Player.EVENT_PLAYER_LOAD)},selectPlayer:function(a){SYNO.Assert(Ext.isString(a),"bad player id");this.current_idx=null;this.streaming=true;Ext.each(this.players,function(c,b){if(c.id===a){this.current_idx=b;this.streaming=false;return false}},this)},getCurrentID:function(){if(this.streaming){return SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING}SYNO.Assert(Ext.isNumber(this.current_idx)&&Ext.isArray(this.players)&&!Ext.isEmpty(this.players),"player not set");return this.players[this.current_idx].id},getAllPlayers:function(){return SYNO.Util.copy(this.players)},players:null,current_idx:null,streaming:true});Ext.define("SYNO.SDS.VideoStation2.PlaybackController",{statics:{loadPlayer:function(){var a={success:function(d,c,b){SYNO.SDS.VideoStation2.Player.get().loadPlayer(d.device)},failure:function(){SYNO.SDS.VideoStation2.Player.get().loadPlayer([])}};SYNO.SDS.VideoStation2.OP.get().listPlayer({limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},a)},selectPlayer:function(a){SYNO.SDS.VideoStation2.Player.get().selectPlayer(a)},selectSubtitle:function(a){SYNO.SDS.VideoStation2.File.get().selectSubtitle(a)},selectAudiotrack:function(a){SYNO.SDS.VideoStation2.File.get().selectAudiotrack(a)},launchVideoPlayer:function(c,g){var f=null;var e=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(e===SYNO.SDS.VideoStation2.Constant.PLAYLIST){e=SYNO.SDS.VideoStation2.Constant.COLLECTION;f=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()}else{if(e===SYNO.SDS.VideoStation2.Constant.TVSHOW){var b=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();f=Ext.isObject(b)?b.id:null}}var d={file_id:c.file_id,player_id:SYNO.SDS.VideoStation2.Player.get().getCurrentID(),title:"",browse_type:e,type_id:f,sort_info:SYNO.SDS.VideoStation2.Sort.get().getSortOption(),video_id:c.video_id,video_type:c.video_type,subtitle_id:c.subtitle_id||null,audiotrack_id:c.audiotrack_id||null};var a=function(h){SYNO.SDS.VideoStation2.Window.mon(h||SYNO.SDS.WindowMgr.front,"close",function(){SYNO.SDS.VideoStation2.Util.applyCallback(g)},{single:true})};SYNO.SDS.AppLaunch("SYNO.VideoController2.Application",d,false,a)},launchVideoPlayerWithDTV:function(a){var b={dtv_url:SYNO.SDS.VideoStation2.DTVUtil.getStreamingURL(a.tuner)};SYNO.SDS.AppLaunch("SYNO.VideoController2.Application",b,false)}}});Ext.define("SYNO.SDS.VideoStation2.ActionDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{ACTION_ADD:"add",ACTION_PLAY:"play",ACTION_MORE:"more",ACTION_PLAYLIST_EDIT:"playlist-edit",ACTION_PLAYLIST_MORE:"playlist-more"},disableAction:false,enableSelectMode:false,videoType:null,trackResetOnLoad:false,constructor:function(){this.callParent(arguments);this.addClass("action-dataview");if(this.disableAction){this.addClass("hide-action")}if(this.enableSelectMode){this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED,this.onVideoSelectModeChange,this);this.onVideoSelectModeChange();this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED,this.onVideoSelectionChange,this)}this.mon(this,"beforedestroy",this.onBeforeDestroy,this);this.mon(this,"activate",this.onActivate,this);this.mon(this,"deactivate",this.onDeactivate,this)},hideAction:function(){if(this.disableAction){return}this.addClass("hide-action")},showAction:function(){if(this.disableAction){return}this.removeClass("hide-action")},getVideoData:function(a){return{id:this.getVideoID(a),type:this.getVideoType(a),pathTitle:this.getVideoTitle(a),mapper_id:this.getVideoMapperID(a),library_id:this.getLibraryID(a)}},getLibraryID:function(a){return a.get("library_id")||0},getVideoType:function(a){return a.get("type")||this.videoType||SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()},getVideoID:function(a){return a.get("id")},getVideoMapperID:function(a){return a.get("mapper_id")},getVideoTitle:function(a){return a.get("title")},getVideoPlaylists:function(a){if(a.get("additional")&&a.get("additional").collection){return a.get("additional").collection}return null},getSeasonEpisode:function(a){if(Ext.isNumber(a.get("season"))&&Ext.isNumber(a.get("episode"))){return{season:a.get("season"),episode:a.get("episode")}}return null},getVideoFile:function(a){return null},getRecordBySelection:function(d){var e;var b=this.getStore();if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){e=b.findExact("mapper_id",d.mapper_id)}else{e=b.findExact("id",d.id)}if(e===-1){return}var a=b.getAt(e);var c=this.getVideoType(a);if(c!==d.type){return}return a},formRelatedSelections:function(b){var a=this.getRecordBySelection(b);b.record=a;return[b]},startVideoAction:function(a){this.clearVideoSelection();this.addVideoSelection(a)},clearVideoSelection:function(){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection()},addVideoSelection:function(a){SYNO.SDS.VideoStation2.Video.get().addVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a),this.getVideoPlaylists(a),this.getSeasonEpisode(a),this.getLibraryID(a))},removeVideoSelection:function(a){SYNO.SDS.VideoStation2.Video.get().removeVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a),this.getVideoPlaylists(a))},toggleVideoSelection:function(a){SYNO.SDS.VideoStation2.Video.get().toggleVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a),this.getVideoPlaylists(a),this.getSeasonEpisode(a))},hasVideoSelection:function(a){return SYNO.SDS.VideoStation2.Video.get().hasVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a))},isVideoSelectionEmpty:function(){return SYNO.SDS.VideoStation2.Video.get().isVideoSelectionEmpty()},onActivate:function(){var a=this.getStore();this.bindStore(a);this.mon(a,"load",this.onVideoSelectionChange,this);this.onVideoSelectionChange()},onDeactivate:function(){var a=this.getStore();this.mun(a,"load",this.onVideoSelectionChange,this);this.bindStore(null)},onVideoSelectModeChange:function(){if(!this.enableSelectMode){return}if(SYNO.SDS.VideoStation2.Video.get().isInSelectMode()){this.hideAction()}else{this.lastSelect=null;this.showAction()}},onVideoSelectionChange:function(){if(!this.enableSelectMode){return}if(this.hidden){return}if(!SYNO.SDS.VideoStation2.Video.get().isInSelectMode()){return}var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();this.getNodes().each(function(c){var b=Ext.fly(c);b.removeClass("x-view-selected")});a.each(function(d){var b=this.getRecordBySelection(d);if(!b){return}var e=this.getNode(b);var c=Ext.fly(e);c.addClass("x-view-selected")},this)},onStoreLoad:function(){this.updateScrollbar(this.trackResetOnLoad);this.fireEvent("afterUpdateScrollbar",this)},onClick:function(h,g,f){var b=Ext.fly(g);var c=h.getTarget(this.itemSelector,this.getTemplateTarget());var a=null;if(c){a=this.getRecord(c)}var d=SYNO.SDS.VideoStation2.Video.get().isInSelectMode();if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_ADD)){this.onActionAddClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAY)){this.onActionPlayClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_MORE)){this.onActionMoreClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAYLIST_EDIT)){this.onActionPlaylistEditClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAYLIST_MORE)){this.onActionPlaylistMoreClick(this,h,a)}else{if(this.enableSelectMode&&a){if((h.ctrlKey||h.shiftKey)&&!d){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(true,true);d=true}if(d){this.onSelect(this,h,a)}else{this.callParent(arguments)}}else{this.callParent(arguments)}}}}}}},onActionAddClick:function(i,a,h){this.startVideoAction(h);var d=this.getVideoPlaylists(h);if(d){d=d.map(function(j){return j.id})}var e=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();var b=function(j){return(d&&d.indexOf(j.id)!==-1)?"checked":""};var g=function(j){return e===j.id};var f=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:b,hideOnClickFn:g,createPlaylistFn:this.onCreatePlaylist,clickPlaylistFn:this.onPlaylistClick},this);var c=new SYNO.SDS.VideoStation2.OneTimeDropdownMenu({items:f});c.showAt(a.getXY())},onActionPlayClick:function(b,d,a){this.startVideoAction(a);var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(c,function(e){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING);SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:e.id,video_id:c.id,video_type:c.type},{fn:SYNO.SDS.VideoStation2.Controller.refreshView})})},onActionMoreClick:function(b,c,a){this.startVideoAction(a);var f=this.filterNotAllowedAction(SYNO.SDS.VideoStation2.ActionUtil.getAvailableVideoActions(),a);var d=f.map(function(g){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getVideoActionString(g),itemId:g,scope:this,handler:this.onVideoAction})},this);var e=new SYNO.SDS.VideoStation2.OneTimeDropdownMenu({noicon:true,items:d});e.showAt(c.getXY())},onActionPlaylistEditClick:function(b,c,a){if(Ext.fly(c.target).hasClass("x-item-disabled")){return}SYNO.SDS.VideoStation2.PlaylistActionController.doPlaylistAction(SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT,a.id)},onActionPlaylistMoreClick:function(b,c,a){if(Ext.fly(c.target).hasClass("x-item-disabled")){return}var f=a.id;var d=[];SYNO.SDS.VideoStation2.ActionUtil.getAvailablePlaylistActions().each(function(g){if(g===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT){return}d.push(new Ext.Action({text:_VST("playlist",g),itemId:g,disabled:g===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE&&f<0,handler:SYNO.SDS.VideoStation2.PlaylistActionController.doPlaylistAction.createDelegate(this,[g,f])}))},this);var e=new SYNO.SDS.VideoStation2.OneTimeDropdownMenu({noicon:true,items:d});e.showAt(c.getXY())},onCreatePlaylist:function(e){var d=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];var b=this.getRecordBySelection(d);if(!b){return}var a=this.formRelatedSelections(d);var c=function(f){SYNO.SDS.VideoStation2.PlaylistController.applyPlaylistChangeToVideo(a,f,true)};SYNO.SDS.VideoStation2.VideoActionController.createPlaylist([d],c)},onPlaylistClick:function(e){var d=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];var b=this.getRecordBySelection(d);if(!b){return}var a=this.formRelatedSelections(d);var c=!e.getEl().hasClass("checked");var f=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(parseInt(e.itemId,10));var g=Ext.emptyFn;if(f.id===SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()){g=SYNO.SDS.VideoStation2.Controller.refreshView}else{g=this.onPlaylistAddRemove.createDelegate(this,[a,f,c,e])}SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist([d],f.id,c,g)},onPlaylistAddRemove:function(b,d,a,c){if(c&&!c.isDestroyed){c.getEl()[a?"addClass":"removeClass"]("checked")}SYNO.SDS.VideoStation2.PlaylistController.applyPlaylistChangeToVideo(b,d,a)},onVideoAction:function(d){var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];var b=this.getRecordBySelection(c);if(!b){return}var a=this.formRelatedSelections(c);var e;switch(d.itemId){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:e=SYNO.SDS.VideoStation2.VideoActionController.applyWatchStatusChangeToVideo(a,true);break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:e=SYNO.SDS.VideoStation2.VideoActionController.applyWatchStatusChangeToVideo(a,false);break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:e=SYNO.SDS.VideoStation2.Controller.refreshView;break}SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(d.itemId,[c],e)},onBeforeDestroy:function(){this.getStore().destroy()},onSelect:function(b,f,a){if(!Ext.isNumber(this.getVideoID(a))){return}var c=this.getStore();if(f.shiftKey&&this.lastSelect){this.clearVideoSelection();var g=[c.indexOf(this.lastSelect),c.indexOf(a)].sortBy(function(h){return h});for(var d=g[0];d<=g[1];++d){var e=c.getAt(d);if(!Ext.isNumber(this.getVideoID(e))){continue}this.addVideoSelection(e)}return}if(!this.hasVideoSelection(a)){this.lastSelect=a}this.toggleVideoSelection(a);if(this.lastSelect&&!this.hasVideoSelection(this.lastSelect)){this.lastSelect=null}if(f.ctrlKey&&this.isVideoSelectionEmpty()){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false,true)}},filterNotAllowedAction:function(d,a){var c=(a.get("additional"))?a.get("additional").watched_ratio:0;var b=a.get("type")===SYNO.SDS.VideoStation2.Constant.FILE;return d.filter(function(e){if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA&&b){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA&&!b){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED&&SYNO.SDS.VideoStation2.Util.isWatched(c)){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED&&SYNO.SDS.VideoStation2.Util.isUnwatched(c)){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE){return false}return true})},getTitle:function(a){return Ext.isString(a.title)?a.title:""},getWatchedInfo:function(a){return""},getStore:function(){SYNO.Debug.error("need to implement interface getStore")},getImageURL:function(){SYNO.Debug.error("need to implement interface getImageURL")}});Ext.define("SYNO.SDS.VideoStation2.CompositeMenu",{extend:"SYNO.ux.Menu",alignTarget:null,constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-composite-menu")},show:function(b,c,a){this.callParent(arguments);if(this.alignTarget){b=this.alignTarget.getEl()||b}this.items.each(function(d){d.fireEvent("activate")})}});Ext.define("SYNO.SDS.VideoStation2.EditorGridPanel",{extend:"SYNO.ux.EditorGridPanel",xtype:"syno_vs_editorgrid",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-editorgridpanel")}});Ext.define("SYNO.SDS.VideoStation2.EnableColumn",{extend:"SYNO.ux.EnableColumn",constructor:function(){this.callParent(arguments)},isIgnore:function(b,a){if(Ext.isEmpty(this.ignoreKey)){return this.callParent(arguments)}return(true===a.get(this.ignoreKey))},renderer:function(g,e,a,f,c,b){var d=this.scope;if(Ext.isString(d.ignoreKey)&&a.get(d.ignoreKey)===true){return SYNO.SDS.VideoStation2.EnableColumn.superclass.renderer.call(this,"gray",e,a,f,c,b)}else{return SYNO.SDS.VideoStation2.EnableColumn.superclass.renderer.apply(this,arguments)}}});Ext.define("SYNO.SDS.VideoStation2.FileChooser",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",constructor:function(b){var a={usage:{type:"chooseDir"},folderToolbar:true,treeFilter:function(d,c){if(c&&(c.spath==="/home"||c.spath==="/homes"||c.mountType==="remote")){return false}return true},listeners:{afterrender:this.addButtonClass}};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vs2-filechooser");this.addClass("syno-vs2-dialog")},addButtonClass:function(){var c=this.topToolbar.items.item(0);var b=this.topToolbar.items.item(1);c.addClass("syno-vs2-button");c.addClass("syno-vs2-button-grey");b.addClass("syno-vs2-button");b.addClass("syno-vs2-button-grey");var d=this.items.item(1).items.item(1).items.item(1);var a=this.items.item(1).items.item(2).items.item(1);d.addClass("syno-vs2-button");d.addClass("syno-vs2-button-blue");a.addClass("syno-vs2-button");a.addClass("syno-vs2-button-grey")},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)},createFolder:function(){if(!this.crtDialog||this.crtDialog.isDestroyed){this.crtDialog=new SYNO.SDS.VideoStation2.FileChooser.CrtFdrDialog({RELURL:this.RELURL,owner:this,cls:this.initialConfig.cls})}return this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.FileChooser.CrtFdrDialog",{extend:"SYNO.SDS.Utils.FileChooser.CrtFdrDialog",constructor:function(){this.callParent(arguments);this.addClass(["syno-vs2-dialog","syno-vs2-filechooser-crtfdrdialog"]);this.buttons.each(function(c){c.addClass("syno-vs2-button")});var a=this.items.get(0);a.addClass(["syno-ux-formpanel","syno-vs2-form"]);var b=a.getComponent("name");b.addClass(["syno-vs2-textfield","syno-vs2-base-textfield"])}});Ext.define("SYNO.SDS.VideoStation2.ComboBox",{statics:{CLASS_MENU_EXPANDED:"menu-expanded"},extend:"SYNO.ux.ComboBox",xtype:"syno_vs_combobox",listClass:"syno-vs2-combobox-list",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-combobox");this.mon(this,"expand",this.addExpandedClass,this);this.mon(this,"collapse",this.removeExpandedClass,this)},addExpandedClass:function(){this.addClass(SYNO.SDS.VideoStation2.ComboBox.CLASS_MENU_EXPANDED)},removeExpandedClass:function(){this.removeClass(SYNO.SDS.VideoStation2.ComboBox.CLASS_MENU_EXPANDED)},onDestroy:function(){this.mun(this,"expand",this.addExpandedClass,this);this.mun(this,"collapse",this.removeExpandedClass,this);this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.DisplayField",{extend:"SYNO.ux.DisplayField",xtype:"syno_vs_displayfield",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-displayfield")}});Ext.define("SYNO.SDS.VideoStation2.FieldSet",{extend:"SYNO.ux.FieldSet",xtype:"syno_vs_fieldset",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-fieldset")}});Ext.define("SYNO.SDS.VideoStation2.NumberField",{extend:"SYNO.ux.NumberField",xtype:"syno_vs_numberfield",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-numberfield");this.addClass("syno-vs2-base-textfield")}});Ext.define("SYNO.SDS.VideoStation2.TextArea",{extend:"SYNO.ux.TextArea",xtype:"syno_vs_textarea",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-textarea");this.addClass("syno-vs2-base-textfield")}});Ext.define("SYNO.SDS.VideoStation2.TimeField",{extend:"SYNO.ux.TimeField",xtype:"syno_vs_timefield",listClass:"syno-vs2-combobox-list",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-timefield")}});Ext.define("SYNO.SDS.VideoStation2.ListView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){Ext.apply(this,a.decorator);var b={tpl:this.getTpl(),cls:"list-view",store:this.getStore(),itemSelector:"div.list-wrap",overClass:"x-view-over",singleSelect:true};Ext.apply(b,a);delete b.decorator;return b},getTemplateTarget:function(){if(!this.el.dom){return}this.scrollBar=this.scrollBar||this.el.createChild({tag:"div",style:"display:inline-block;width:100%;"});return this.scrollBar},getTpl:function(){var b=this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster";var a=new Ext.XTemplate('<tpl for=".">','<div class="list-wrap '+b+'">','<div class="select-mark"></div>',"{[this.getListThumbDiv(values)]}",'<div class="title sds-ellipsis">','<tpl if="this.hasEpisode(values)">{[this.getEpisodeDiv(values)]}</tpl>',"{[this.singleEncode(this.getTitle(values))]}","{[this.getTitleDecorateDiv(values)]}","</div>",'<div class="action">',"{[this.getActionDiv(values)]}","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{getTitle:this.getTitle.createDelegate(this),getEpisodeDiv:function(c){if(c.episode){return String.format('<span class="episode sds-ellipsis">{0}</span>',String.format(_VST("episode","title"),c.episode))}return""},hasEpisode:function(c){return c.episode!==undefined},singleEncode:function(c){return Ext.util.Format.htmlEncode(c)},doubleEncode:function(c){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(c))},getListThumbDiv:this.getListThumbDiv.createDelegate(this),getActionDiv:this.getActionDiv.createDelegate(this),getTitleDecorateDiv:this.getTitleDecorateDiv.createDelegate(this)});return a},getListThumbDiv:function(a){return""},getTitleDecorateDiv:function(a){return""},getImageStyle:function(a){return""},getDate:function(b){var a=SYNO.SDS.VideoStation2.Util.getVideoDate(b);return Ext.isEmpty(a)?"- -":a},getActionDiv:function(a){if(this.getImageStyle(a).indexOf(SYNO.SDS.VideoStation2.Constant.FOLDER)!==-1){return""}return['<div class="date">'+this.getDate(a)+"</div>",'<div class="watched-info-dot '+this.getWatchedInfo(a)+'"></div>','<div class="add action-btn"></div>','<div class="play action-btn"></div>','<div class="more action-btn"></div>'].join("")}});Ext.define("SYNO.SDS.VideoStation2.NavigationToolbar",{extend:"SYNO.ux.Toolbar",constructor:function(a){this.callParent(arguments);this.addClass("nav-toolbar")}});Ext.define("SYNO.SDS.VideoStation2.SearchField",{extend:"SYNO.ux.TextFilter",constructor:function(b){var a={emptyText:_VST("search","keyword"),enableKeyEvents:true};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("syno-vs2-searchfield");c.wrap.addClassOnOver("over")})}});Ext.define("SYNO.SDS.VideoStation2.SlidableDataView",{extend:"SYNO.ux.Panel",statics:{POSITION:{left:-1,center:0,right:1}},dataViewMargin:20,constructor:function(c){SYNO.Assert(Ext.isFunction(c.getView),"need to implement getView");var d=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;var b={floating:true,hidden:true,shadow:false};this.views={};this.views[d.center]=c.getView(b);this.views[d.left]=c.getView(b);this.views[d.right]=c.getView(b);var a={cls:"slidable-viewport",layout:"fit",items:Object.values(this.views)};Ext.apply(a,c);this.callParent([a]);this.mon(this,"activate",this.onActivate,this);this.mon(this,"deactivate",this.onDeactivate,this);this.mon(this,"resize",this._onResize,this);this.mon(this,"afterlayout",this._onAfterLayout,this);this.items.each(function(e){this.mon(e,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,function(){if(e===this.views[d.center]){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)}},this);this.mon(e,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,function(){if(e===this.views[d.center]){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)}},this)},this)},prepareView:function(a,d){var c=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;SYNO.Assert(Object.values(c).indexOf(a)!==-1,String.format("unexpected position {0}",a));var b=this.views[a];this._setViewPosition(b,a);b.show();if(!d){b.fireEvent("activate",a)}},intoLeft:function(b){var c=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,a=this._getOriginView();if(!b){this.prepareView(c.left)}this._clearSlideClass();this.views[c.center].addClass("slidable-out");this.views[c.left].addClass("slidable-in");this._setViewPosition(this.views[c.center],c.right);this._setViewPosition(this.views[c.left],c.center);this.views[c.right].hide();this._setViewPosition(this.views[c.right],c.left);this.views[c.right].fireEvent("deactivate");this.views[c.left]=a[c.right];this.views[c.center]=a[c.left];this.views[c.right]=a[c.center];this._delayClearSlideClass()},intoRight:function(b){var c=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,a=this._getOriginView();if(!b){this.prepareView(c.right)}this._clearSlideClass();this.views[c.center].addClass("slidable-out");this.views[c.right].addClass("slidable-in");this._setViewPosition(this.views[c.center],c.left);this._setViewPosition(this.views[c.right],c.center);this.views[c.left].hide();this._setViewPosition(this.views[c.left],c.right);this.views[c.left].fireEvent("deactivate");this.views[c.right]=a[c.left];this.views[c.center]=a[c.right];this.views[c.left]=a[c.center];this._delayClearSlideClass()},getLeftView:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[a.left]},getRightView:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[a.right]},getCenterView:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[a.center]},_delayClearSlideClass:function(){this._delayClearSlideClassTask=this._delayClearSlideClassTask||new Ext.util.DelayedTask(this._clearSlideClass,this);this._delayClearSlideClassTask.cancel();this._delayClearSlideClassTask.delay(800)},_clearSlideClass:function(){Ext.iterate(this.views,function(b,a){a.removeClass(["slidable-in","slidable-out"])})},_setViewPosition:function(b,a){b.setPosition(this._getLeft(a),0)},_getOriginView:function(){var b=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;var a={};a[b.center]=this.views[b.center];a[b.left]=this.views[b.left];a[b.right]=this.views[b.right];return a},_onResize:function(){var b=this.getWidth(),a=this.getHeight();Object.values(this.views).each(function(c){c.setSize(b,a)})},_onAfterLayout:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this._setViewPosition(this.views[a.center],a.center);this._setViewPosition(this.views[a.left],a.left);this._setViewPosition(this.views[a.right],a.right)},onActivate:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.prepareView(a.center)},onDeactivate:function(){this.getCenterView().fireEvent("deactivate")},_getLeft:function(a){return(this.getWidth()+this.dataViewMargin)*a},getView:function(a){SYNO.Debug.error("need to implement getView")}});Ext.define("SYNO.SDS.VideoStation2.ImageLoadManager",{extend:"Ext.Component",MAX_CONCURRENT:3,running:0,jobs:null,preemptJobs:null,delegate:null,statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.ImageLoadManager.instance)){SYNO.SDS.VideoStation2.ImageLoadManager.instance=new SYNO.SDS.VideoStation2.ImageLoadManager()}return SYNO.SDS.VideoStation2.ImageLoadManager.instance}},constructor:function(){this.callParent(arguments);this.jobs=[];this.preemptJobs=[];this.delayedPreemptJob=new Ext.util.DelayedTask(this.preemptJob,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.clear,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.clear,this);this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.clear,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.clear,this)},clear:function(){this.jobs=[];this.preemptJobs=[]},appendJob:function(a){if(-1!==this.jobs.indexOf(a)){return}this.jobs.push(a);this.dispatch()},insertJob:function(a){this.preemptJobs.push(a);this.delayedPreemptJob.delay(100)},preemptJob:function(){Ext.each(this.preemptJobs,function(a){this.jobs.remove(a)},this);this.jobs.unshift.apply(this.jobs,this.preemptJobs);this.preemptJobs=[];this.dispatch()},dispatch:function(){while(this.MAX_CONCURRENT>this.running){var a=this.jobs.shift();if(!a){break}this.running++;this.setImgURL(a)}},setImgURL:function(c){var b=Ext.fly(c).getAttribute("url");if(!b){this.running--;this.dispatch.defer(0,this);return}var a=document.createElement("img");Ext.fly(a).on({load:this.onImageLoad.createDelegate(this,[c,a,b]),error:this.onImageError.createDelegate(this,[c,a,b])});c.removeAttribute("url");a.src=b},finalizedImageLoad:function(){this.running--;this.dispatch.defer(0,this)},onImageLoad:function(d,a,b){this.finalizedImageLoad();if(this.delegate){this.delegate.onImageLoad(a)}var c=Ext.fly(d);c.setStyle("background-image",String.format("url({0})",b));c.removeClass("loading");a=null},onImageError:function(c,a,b){this.finalizedImageLoad();if(this.delegate){this.delegate.onImageError(c,a)}}});Ext.define("SYNO.SDS.VideoStation2.ThumbDataView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(a){this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get();this.callParent([this.fillConfig(a)])},fillConfig:function(a){Ext.apply(this,a.decorator);var b={tpl:this.getTpl(),cls:"thumb-dataview",store:this.getStore(),itemSelector:"div.thumb-wrap",overClass:"x-view-over",singleSelect:true};Ext.apply(b,a);delete b.decorator;return b},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="thumb-wrap {[this.getImageStyle(values)]}">',"{[this.getThumbDiv(values)]}",'<div class="title sds-ellipsis" ext:qtip="{[this.doubleEncode(this.getTitle(values))]}">{[this.singleEncode(this.getTitle(values))]}',"{[this.getTitleDecorateDiv(values)]}","</div>",'<div class="description sds-ellipsis" ext:qtip="{[this.doubleEncode(this.getDescription(values))]}">{[this.singleEncode(this.getDescription(values))]}</div>',"{[this.getWatchedInfoDot(values)]}","</div>","{[this.getAfterThumbDiv(values)]}","</tpl>",'<div class="x-clear"></div>',{getImageStyle:this.getImageStyle.createDelegate(this),getThumbDiv:this.getThumbDiv.createDelegate(this),getTitle:this.getTitle.createDelegate(this),getTitleDecorateDiv:this.getTitleDecorateDiv.createDelegate(this),getDescription:this.getDescription.createDelegate(this),getWatchedInfoDot:this.getWatchedInfoDot.createDelegate(this),getAfterThumbDiv:this.getAfterThumbDiv.createDelegate(this),singleEncode:function(b){return Ext.util.Format.htmlEncode(b)},doubleEncode:function(b){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(b))}});return a},getImageStyle:function(a){return this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster"},getTitleDecorateDiv:function(){return""},getDescription:function(a){return SYNO.SDS.VideoStation2.Util.getVideoDate(a)},getIconDiv:function(c){var d;if(this.getImageStyle(c).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)!==-1){d='<div class="thumb">'}else{var b=this.getImageURL(c);d=String.format('<div class="thumb loading" url="{0}">',Ext.util.Format.htmlEncode(b))}var a=[d,Ext.isFunction(this.getAdditionalThumbDiv)?this.getAdditionalThumbDiv(c):"",this.getOnScreenBtnDiv(c),"</div>"].join("");return a},getThumbDiv:function(b){var a=[this.getIconDiv(b),this.getWatchStatusDiv(b),'<div class="select-mark"></div>','<div class="border"></div>'].join("");if(this.getImageStyle(b).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)!==-1){a=String.format('<div class="background-shadow">{0}</div>',a)}return a},getWatchStatusDiv:function(a){if(this.getImageStyle(a).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)!==-1){return""}return SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(a)},getOnScreenBtnDiv:function(b){var a=['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("");return a},getAfterThumbDiv:function(a){return""},refresh:function(){this.callParent(arguments);this.preloadItems()},preloadItems:function(){var a=this.getNodes();this.getImageItems(a,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(a){this.getImageItems([a],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(a,b){Ext.each(a,function(f,c,e){var d=Ext.fly(f).select(".loading");Ext.each(d.elements,b)})},getWatchedInfoDot:function(a){return String.format('<div class="watched-info-dot {0}"></div>',this.getWatchedInfo(a))}});Ext.define("SYNO.SDS.VideoStation2.TileDataView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(a){this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get();this.callParent([this.fillConfig(a)])},fillConfig:function(a){Ext.apply(this,a.decorator);var b={tpl:this.getTpl(),cls:"tile-dataview",store:this.getStore(),itemSelector:"div.tile-wrap",overClass:"x-view-over",singleSelect:true};Ext.apply(b,a);delete b.decorator;return b},getTemplateTarget:function(){if(!this.el.dom){return}this.scrollBar=this.scrollBar||this.el.createChild({tag:"div",style:"display:inline-block;width:100%;"});return this.scrollBar},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="tile-wrap {[this.getImageStyle(values)]}">','<div class="tile-img">',"{[this.getIconDiv(values)]}","{[this.getWatchStatusDiv(values)]}",'<div class="select-mark"></div>','<div class="border"></div>',"</div>",'<div class="tile-desc">','<div class="title sds-ellipsis">',"{[this.singleEncode(this.getTitle(values))]}","{[this.getEpisodeDiv(values)]}","{[this.getDateDiv(values)]}","{[this.getWatchedInfoDot(values)]}","</div>","{[this.getSummaryDiv(values)]}","</div>",'<div class="x-clear"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getTitle:this.getTitle.createDelegate(this),getImageStyle:this.getImageStyle.createDelegate(this),getIconDiv:this.getIconDiv.createDelegate(this),getWatchStatusDiv:this.getWatchStatusDiv.createDelegate(this),getDateDiv:this.getDateDiv.createDelegate(this),getWatchedInfoDot:this.getWatchedInfoDot.createDelegate(this),getSummaryDiv:this.getSummaryDiv.createDelegate(this),getEpisodeDiv:function(b){if(b.episode){return String.format('<span class="episode">{0}</span>',String.format(_VST("episode","title"),b.episode))}return""},singleEncode:function(b){return Ext.util.Format.htmlEncode(b)},doubleEncode:function(b){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(b))}});return a},getImageStyle:function(a){return this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster"},getIconDiv:function(c){var d;if(this.getImageStyle(c).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)!==-1){d='<div class="thumb">'}else{var b=this.getImageURL(c);d=String.format('<div class="thumb loading" url="{0}">',Ext.util.Format.htmlEncode(b))}var a=[d,this.getOnScreenBtnDiv(c),"</div>"].join("");return a},getOnScreenBtnDiv:function(b){var a=['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("");return a},getWatchStatusDiv:function(a){if(this.getImageStyle(a).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)!==-1){return""}return SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(a)},getSummaryDiv:function(a){if(this.getImageStyle(a).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)!==-1){return""}return String.format('<div class="summary">{0}</div>',Ext.util.Format.htmlEncode(a.additional.summary||""))},getDateDiv:function(b){var a=SYNO.SDS.VideoStation2.Util.getVideoDate(b);return Ext.isEmpty(a)?"":'<span class="date">'+a+"</span>"},refresh:function(){this.callParent(arguments);this.preloadItems()},preloadItems:function(){var a=this.getNodes();this.getImageItems(a,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(a){this.getImageItems([a],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(a,b){Ext.each(a,function(f,c,e){var d=Ext.fly(f).select(".loading");Ext.each(d.elements,b)})},getWatchedInfoDot:function(a){return String.format('<div class="watched-info-dot {0}"></div>',this.getWatchedInfo(a))}});Ext.define("SYNO.SDS.VideoStation2.SwitchableDataView",{enablePagingToolbar:false,pageSize:0,extend:"SYNO.ux.Panel",statics:{AVAILABLE_DECORATORS:["Season","Common","Byfolder","Playlist","PlaylistPoster","RecordingSpecific"]},constructor:function(b,c){this.decorator=this.getDecorator(b);this.applyDecorator();this.applyDecoratorToChild(b);if(Ext.isObject(c)&&Ext.isObject(c.decoration)){Ext.apply(this,c.decoration);Ext.apply(b.decorator,c.decoration)}this.views={};this.views[SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL]=new SYNO.SDS.VideoStation2.ThumbDataView(b);this.views[SYNO.SDS.VideoStation2.View.TYPE_TILE]=new SYNO.SDS.VideoStation2.TileDataView(b);this.views[SYNO.SDS.VideoStation2.View.TYPE_LIST]=new SYNO.SDS.VideoStation2.ListView(b);var a={layout:"card",items:Object.values(this.views),listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,beforedestroy:this.onBeforeDestroy}};if(this.enablePagingToolbar){this._paging=new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:this.getDataviewStore(),displayInfo:true,showRefreshBtn:true});a.bbar=this._paging}Ext.apply(a,c||{});this.callParent([a]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO)},getDecorator:function(a){var b=SYNO.SDS.VideoStation2.SwitchableDataView.AVAILABLE_DECORATORS;SYNO.Assert(b.indexOf(a.decorator)!==-1,String.format("unexpceted decorator {0}",a.decorator));return SYNO.SDS.VideoStation2.DataViewDecorator[a.decorator]},applyDecoratorToChild:function(a){a.decorator={getStore:function(){return this.owner.getDataviewStore()}};this.decorator.decorations.each(function(b){a.decorator[b]=this.decorator[b]},this);a.decorator.owner=this},applyDecorator:function(a){this.decorator.switchableDecorations.each(function(b){this[b]=this.decorator[b]},this)},onViewTypeChange:function(){if(this.hidden){SYNO.Debug("view is hidden, by pass");return}this.loadView()},loadView:function(){var a=SYNO.SDS.VideoStation2.View.get().getViewType();var c=this.layout.activeItem;var b=this.views[a];SYNO.Assert(b,String.format("unexpceted viewType {0}",a));if(c!==b){this.layout.setActiveItem(b)}else{if(c){c.fireEvent("activate")}}},getActiveView:function(){return this.layout.activeItem},clearActiveItem:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},resetPaging:function(){if(!this.enablePagingToolbar){return}this._paging.moveFirst()},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);var a=this.getDataviewStore();this.mon(a,"beforeload",this.onDataviewBeforeLoad,this);this.mon(a,"load",this.onDataviewStoreLoad,this);this.loadView();var b;if(this.enablePagingToolbar){b=this._paging.cursor;this._paging.bindStore(a)}if(this.isNeedLoadStore()){if(this.enablePagingToolbar){if(this.isNeedMovePagingToFirst()){this._paging.moveFirst()}else{this.keepScrollOnce=true;this._paging.cursor=b;this._paging.doRefresh()}}else{if(!this.isNeedMovePagingToFirst()){this.keepScrollOnce=true}a.load()}this.getActiveView().getTemplateTarget().update("")}else{this.getActiveView().updateScrollbar(true);this.getActiveView().onStoreLoad()}},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);var a=this.getDataviewStore();this.mun(a,"beforeload",this.onDataviewBeforeLoad,this);this.mun(a,"load",this.onDataviewStoreLoad,this);if(this.enablePagingToolbar){this._paging.bindStore(null)}this.clearActiveItem();this.keepScrollOnce=false;if(SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_TVSHOW){a.removeAll()}},onViewRefresh:function(){if(this.enablePagingToolbar){this._paging.doRefresh()}else{this.getDataviewStore().load()}},onBeforeDestroy:function(){this.getDataviewStore().destroy()},onDataviewBeforeLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this)},onDataviewStoreLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);if(0===this.getDataviewStore().getTotalCount()){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)}else{if(0===this.getDataviewStore().getCount()&&this.enablePagingToolbar){this._paging.movePrevious()}}if(this.keepScrollOnce){this.keepScrollOnce=false;return}this.getActiveView().updateScrollbar(true)},getDataviewStore:function(){SYNO.Debug.error("need to implement interface getDataviewStore")},isNeedLoadStore:function(){return true},isNeedMovePagingToFirst:function(){return true},getPagingParam:function(){var b={};var a=SYNO.SDS.VideoStation2.View.get().getPage();if(Ext.isNumber(a)){Ext.apply(b,{offset:(a-1)*this.pageSize,limit:this.pageSize})}return b}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Common",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","enablePagingToolbar","pageSize","isNeedMovePagingToFirst"],decorations:["decoratorConfig","getImageStyle","getImageURL","enableSelectMode"],enablePagingToolbar:true,pageSize:120,getDataviewStore:function(){this.stores=this.stores||{};var a=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(!this.stores[a]){SYNO.Assert(SYNO.SDS.VideoStation2.Stores[a],String.format("unexpceted library type {0}",a));this.stores[a]=new SYNO.SDS.VideoStation2.Stores[a]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}})}return this.stores[a]},onBeforeLoadStore:function(a,b){var f=b.params;var c=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var e=SYNO.SDS.VideoStation2.Category.isSortAdjustableCategory(c)?SYNO.SDS.VideoStation2.Sort.get().getSortOption():SYNO.SDS.VideoStation2.Category.get().getSortOption();var d=null;if(c===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){d=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(d,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption())}else{if(SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(c)){d=SYNO.SDS.VideoStation2.RecordingSpecific.get().getFilterOption()}}Ext.apply(f,this.getPagingParam());Ext.apply(f,e);Ext.apply(f,d);Ext.apply(f,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})},onLoadStore:function(b,a,c){SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(c.params.offset/c.params.limit)+1,false)},isNeedMovePagingToFirst:function(){return !Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())&&Ext.isEmpty(SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow())},enableSelectMode:true,decoratorConfig:{thumbCls:"poster"},getImageStyle:function(b){var a=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(a===SYNO.SDS.VideoStation2.Constant.MOVIE||a===SYNO.SDS.VideoStation2.Constant.TVSHOW){return"poster"}return"landscape"},getImageURL:function(a){var b=SYNO.SDS.VideoStation2.Library.get().getCurrentType();return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(a,b)}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Season",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","filterStore","isNeedLoadStore","clearLoadedInfo","isNeedMovePagingToFirst"],decorations:["decoratorConfig","getDescription","getImageURL","enableSelectMode","getVideoTitle","getTitle","getWatchedInfo"],getDataviewStore:function(){if(!this._store){var a=SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE;this._store=new SYNO.SDS.VideoStation2.Stores[a]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}})}return this._store},onBeforeLoadStore:function(a,b){var d=b.params;var c={};if(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){c=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(c,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption())}Ext.apply(d,c);Ext.apply(d,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),tvshow_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID()})},onLoadStore:function(c,b,d){this.loadedLibrary=d.params.library_id;this.loadedTVShow=d.params.tvshow_id;var a=b.reduce(function(f,g){f[g.get("season")]=true;return f},{});a=Object.keys(a).map(function(f){return parseInt(f,10)}).sortBy(function(f){return f});if(Ext.isEmpty(a)){SYNO.SDS.VideoStation2.Controller.goback();return}if(a[0]===0){a=a.slice(1).concat(0)}var e=b.reduce(function(f,g){return Math.max(f,g.get("last_watched"))},0);if(0<e){Ext.each(b,function(f){if(f.get("last_watched")===e){f.set("max_last_watched",true);f.commit(true)}},this)}SYNO.SDS.VideoStation2.TVShow.get().setAvailableSeasons(a);this.filterStore()},filterStore:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this._store.filter({property:"season",value:a,exactMatch:true})},isNeedLoadStore:function(){var b=SYNO.SDS.VideoStation2.Library.get().getCurrentID();var a=SYNO.SDS.VideoStation2.TVShow.get();return(this.loadedLibrary!==b||this.loadedTVShow!==a.getCurrentID()||a.getAvailableSeasons()===null)},clearLoadedInfo:function(){this.loadedLibrary=null;this.loadedTVShow=null},isNeedMovePagingToFirst:function(){return !Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:true,decoratorConfig:{thumbCls:"landscape"},getDescription:function(a){return a.episode>0?String.format(_VST("episode","title"),a.episode):""},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(a,SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)},getVideoTitle:function(a){return SYNO.SDS.VideoStation2.Util.getPathTitleForEpisode(a.get("episode"),a.get("tagline"))},getTitle:function(b){var a=b.episode>0?String.format(_VST("episode","title"),b.episode):_VST("metadata","unknown");return Ext.isString(b.tagline)&&!Ext.isEmpty(b.tagline)?b.tagline:a},getWatchedInfo:function(a){return true===a.max_last_watched?SYNO.SDS.VideoStation2.Constant.CLASS.LASTWATCHED:""}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Byfolder",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","equalToLastId","isNeedMovePagingToFirst","enablePagingToolbar","pageSize"],decorations:["getImageStyle","getListThumbDiv","getOnScreenBtnDiv","getAdditionalThumbDiv","getImageURL","enableSelectMode","getVideoData","getVideoID","getVideoMapperID","getVideoType","getVideoFile","getLibraryID","getRecordBySelection","getRelatedVideoRecordsBySelection","getAfterThumbDiv","formRelatedSelections","isFolder"],enablePagingToolbar:true,pageSize:120,getDataviewStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.folder({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}});return this._store},onBeforeLoadStore:function(a,b){var c=b.params;if(!this.equalToLastId()){Ext.apply(c,{offset:0})}Ext.apply(c,this.getPagingParam());Ext.apply(c,{path:SYNO.SDS.VideoStation2.Folder.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Library.get().getCurrentType(),library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})},onLoadStore:function(b,a,c){this.lastParams=c.params;SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(c.params.offset/c.params.limit)+1,false)},equalToLastId:function(){if(Ext.isEmpty(this.lastParams)){return false}var c=SYNO.SDS.VideoStation2.Folder.get().getCurrentID();var a=SYNO.SDS.VideoStation2.Library.get().getCurrentType();var b=SYNO.SDS.VideoStation2.Library.get().getCurrentID();return this.lastParams.path===c&&this.lastParams.type===a&&this.lastParams.library_id===b},isNeedMovePagingToFirst:function(){return !this.equalToLastId()},enableSelectMode:true,getVideoData:function(a){return{id:this.getVideoID(a),type:this.getVideoType(a),pathTitle:this.getVideoTitle(a),mapper_id:this.getVideoMapperID(a),library_id:this.getLibraryID(a),file:this.getVideoFile(a)}},getVideoID:function(a){var b=(a.get("additional")||{}).metadata;if(!b){return}return b.id},getVideoMapperID:function(a){var b=(a.get("additional")||{}).metadata;if(!b){return}return b.mapper_id},getVideoType:function(a){return SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()},getVideoFile:function(a){return parseInt(a.get("id"),10)},getLibraryID:function(a){var b=(a.get("additional")||{}).metadata;if(!b){return}return b.library_id},getRecordBySelection:function(a){return this.getStore().getById(a.file.toString())},getRelatedVideoRecordsBySelection:function(b){var a=[];this.getStore().each(function(c){if(b.mapper_id===this.getVideoMapperID(c)){a.push(c)}},this);return a},formRelatedSelections:function(a){return this.getRelatedVideoRecordsBySelection(a).map(function(b){return{id:this.getVideoID(b),type:this.getVideoType(b),mapper_id:this.getVideoMapperID(b),file:this.getVideoFile(b),record:b}},this)},getAdditionalThumbDiv:function(c){if(!this.isFolder(c)){return""}var b=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();var a=function(d){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(d,b)};return SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(c.preview_video,a)},isFolder:function(a){return SYNO.SDS.VideoStation2.Constant.FOLDER===a.type},getImageStyle:function(a){if(this.isFolder(a)){return String.format("{0} {1}",SYNO.SDS.VideoStation2.Constant.SQUARE,SYNO.SDS.VideoStation2.Constant.FOLDER)}if(SYNO.SDS.VideoStation2.Constant.MOVIE===SYNO.SDS.VideoStation2.Library.get().getCurrentType()){return"poster"}return"landscape"},getListThumbDiv:function(b){var a="";if(b.type===SYNO.SDS.VideoStation2.Constant.FOLDER){a=b.type}else{a=this.getVideoType()}return String.format('<div class="thumb-icon {0}"></div>',a)},getOnScreenBtnDiv:function(b){if(this.isFolder(b)){return""}var a=['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("");return a},getAfterThumbDiv:function(a){if(a.last_folder){return'<div class="x-clear"></div>'}return""},getImageURL:function(b){var a=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:a,id:b.additional.metadata.id,mtime:b.additional?b.additional.poster_mtime||"":""})}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Playlist",{singleton:true,switchableDecorations:["getDataviewStore","isNeedLoadStore"],decorations:["getImageURL","onActivate","decoratorConfig","getActionDiv","getListThumbDiv","getTitle","getTitleDecorateDiv","getAdditionalThumbDiv","getAfterThumbDiv","getOnScreenBtnDiv"],getDataviewStore:function(){this._store=this._store||new Ext.data.JsonStore({id:"id",fields:["id","title","additional","type","playlist_title","preview_video"]});return this._store},isNeedLoadStore:function(){return false},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(a)},onActivate:function(){this.bindStore(this.getStore())},onDeactivate:function(){this.bindStore(null)},decoratorConfig:{thumbCls:SYNO.SDS.VideoStation2.Constant.SQUARE},getActionDiv:function(a){return[String.format('<div class="playlist-edit action-btn {0}"></div>',(a.id<0)?"x-item-disabled":""),String.format('<div class="playlist-more action-btn {0}"></div>',(a.id===-3)?"x-item-disabled":"")].join("")},getListThumbDiv:function(b){var a=b.type;if(-1===b.id){a="favorite"}else{if(-2===b.id){a="watchlist"}else{if(-3===b.id){a="shared"}}}return String.format('<div class="thumb-icon {0}"></div>',a)},getTitle:function(a){return Ext.isString(a.playlist_title)?a.playlist_title:""},getTitleDecorateDiv:function(a){var b=(a.additional||{}).sharing_info;if(!b||!b.status||b.status==="none"){return""}if(-3===a.id){return""}return String.format('<div class="share-icon {0}"></div>',b.status)},getAdditionalThumbDiv:function(c){var b=SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(c.preview_video,this.getImageURL.createDelegate(this));var a="",d="";if(-1===c.id){a="favorite"}else{if(-2===c.id){a="watchlist"}else{if(-3===c.id){a="shared"}}}if(!Ext.isEmpty(a)){d=String.format('{0}<div class="playlist-icon {1} {2}"></div>',Ext.isEmpty(b)?"":'<div class="playlist-mask"></div>',a,Ext.isEmpty(b)?"":"has_contain")}return b+d},getAfterThumbDiv:function(a){if(-3===a.id){return'<div class="x-clear"></div>'}return""},getOnScreenBtnDiv:function(b){var a=['<div class="gradient"></div>','<div class="left-btn playlist-edit larger ',(b.id<0)?"x-item-disabled":"",'"></div>','<div class="right-btn playlist-more larger ',(b.id===-3)?"x-item-disabled":"",'"></div>'].join("");return a}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.PlaylistPoster",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","onExceptionStore","enablePagingToolbar","pageSize","isNeedMovePagingToFirst"],decorations:["getImageStyle","getImageURL","enableSelectMode"],enablePagingToolbar:true,pageSize:200,getDataviewStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.playlistvideolist({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore,exception:this.onExceptionStore}});return this._store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,this.getPagingParam());Ext.apply(c,SYNO.SDS.VideoStation2.Sort.get().getSortOption());Ext.apply(c,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()})},onLoadStore:function(b,a,c){SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(c.params.offset/c.params.limit)+1,false)},onExceptionStore:function(b,a,c){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)},isNeedMovePagingToFirst:function(){return !Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:true,getImageStyle:function(a){return"poster"},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(a)}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.RecordingSpecific",{singleton:true,switchableDecorations:["enablePagingToolbar","pageSize","getDataviewStore","onBeforeLoadStore","onLoadStore","onViewRefresh","tvrecordType"],decorations:["enableSelectMode","getImageStyle","getAdditionalThumbDiv","getOnScreenBtnDiv","getActionDiv"],enablePagingToolbar:true,pageSize:120,getDataviewStore:function(){var a=this.specialTVRecordType||"";SYNO.Assert(SYNO.SDS.VideoStation2.Stores[a],String.format("unexpceted category type {0}",a));this._store=this._store||new SYNO.SDS.VideoStation2.Stores[a]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}});return this._store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,this.getPagingParam());Ext.apply(c,SYNO.SDS.VideoStation2.Sort.get().getSortOption())},onLoadStore:function(b,a,c){SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(c.params.offset/c.params.limit)+1,false)},onViewRefresh:function(){this.getDataviewStore().load()},enableSelectMode:false,getImageStyle:function(a){return String.format("{0} {1}",SYNO.SDS.VideoStation2.Constant.SQUARE,this.specialTVRecordType)},getAdditionalThumbDiv:function(b){var a=function(c){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(c,SYNO.SDS.VideoStation2.Constant.TV_RECORDING)};return SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(b.preview_video||[],a)},getOnScreenBtnDiv:function(){return""},getActionDiv:function(){return""}});Ext.define("SYNO.SDS.VideoStation2.TextFilter",{extend:"SYNO.ux.TextFilter",xtype:"syno_vs_textfilter",constructor:function(b){var a={emptyText:_VST("search","keyword"),enableKeyEvents:true};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("syno-vs2-textfilter");c.wrap.addClass("syno-vs2-base-textfield");c.wrap.addClassOnOver("over")})}});Ext.define("SYNO.SDS.VideoStation2.TransparentButton",{extend:"SYNO.ux.Button",constructor:function(a){this.callParent([a]);this.addClass("syno-vs2-transparent-button")}});Ext.define("SYNO.SDS.VideoStation2.AddEditDialog",{statics:{MODE_ADD:"add",MODE_EDIT:"edit"},extend:"SYNO.SDS.VideoStation2.Dialog",addAction:"create",editAction:"modify",constructor:function(b){b=b||{};this.mode=b.mode;var a={title:this.isAddMode()?_T("common","add"):_T("common","alt_edit"),width:500,height:350,layout:"fit",items:[this.getFormPanel()],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","alt_apply"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)])},isAddMode:function(){return this.mode===SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD},isDirty:Ext.emptyFn,isValid:Ext.emptyFn,getFormPanel:function(){this.form_panel=this.form_panel||new SYNO.SDS.VideoStation2.FormPanel(this.getFormConfig());return this.form_panel},getInvalidError:Ext.emptyFn,getParameter:Ext.emptyFn,onApply:function(a){if(!this.isValid()){this.getMsgBox().alert(this.title,this.getInvalidError());return}var b=this.isAddMode()?this.addAction:this.editAction;this.setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:SYNO.SDS.VideoStation2.Util.getCGIURL(this.cgi),method:"POST",single:true,autoJsonDecode:true,params:Ext.apply(this.getParameter(),{action:b}),scope:this,callback:this.onRequestDone.createDelegate(this)},this).start(true)},onCancel:function(){if(this.isAddMode()||!this.isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),a,this)},onRequestDone:function(b,d,a){this.clearStatusBusy();if(a&&a.success){this.onRequestSuccess(b,a);this.close()}else{var c=SYNO.SDS.VideoStation2.Error.getErrorInfoString(a,_T("common","commfail"));this.getMsgBox().alert(_VST("library","title"),c)}},onRequestSuccess:function(b,a){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(this.callback,{args:[b,a]}))}});Ext.define("SYNO.SDS.VideoStation2.FolderDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",cgi:"folder_manage.cgi",constructor:function(b){this.library=SYNO.Util.copy(b.library);this.folder=SYNO.Util.copy(b.folder);this.callback=b.callback||{};var a={height:400,resizable:false,listeners:{scope:this,afterrender:this.initEnableCheckGroup}};this.callParent([Ext.apply(a,b)])},onOpen:function(){var a=this.isAddMode()?"enu":this.folder.preferlang;var c=this.isAddMode()?"":this.folder.path;var b=this.getFormPanel().getForm();b.findField("library").setValue(this.library.opid);b.findField("preferlanguage").setValue(a);b.findField("path").setValue(c);if(SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type){b.findField("enable_search_online_metadata").setValue(false)}else{b.findField("enable_search_online_metadata").setValue(this.isAddMode()?true:this.folder.search_metadata)}this.original_values=b.getValues();this.callParent(arguments)},getFormConfig:function(){var b={xtype:"syno_vs_fieldset",title:_VST("videofolder","title"),labelWidth:100,items:[{xtype:"syno_compositefield",fieldLabel:_T("common","folder"),defaults:{hideLabel:true},items:[{xtype:"syno_vs_textfield",width:200,name:"path",readOnly:true,allowBlank:false,blankText:_VST("videofolder","specify_path"),validationEvent:"afterrender"},{xtype:"syno_vs_button",text:_VST("common","select"),btnStyle:"blue",scope:this,handler:this.editPathHandler}]}]};var a={xtype:"syno_vs_fieldset",title:_VST("library","title"),items:[{disabled:!this.isAddMode(),xtype:"syno_vs_combobox",name:"library",fieldLabel:_VST("library","title"),displayField:"title",valueField:"opid",store:this.getLibraryStore(),listeners:{scope:this,select:this.onLibrarySelect}}]};var c={xtype:"syno_vs_fieldset",title:_VST("videofolder","video_info_search"),items:[{xtype:"syno_vs_checkbox",disabled:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type,name:"enable_search_online_metadata",boxLabel:_VST("videofolder","search_online_metadta")},{xtype:"syno_vs_combobox",disabled:(SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type),name:"preferlanguage",fieldLabel:_VST("language","title"),displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation2.Util.getLangStore())}]};return{trackResetOnLoad:true,border:false,items:[b,a,c]}},initEnableCheckGroup:function(){var a;a=new SYNO.ux.Utils.EnableCheckGroup(this.getFormPanel().getForm(),"enable_search_online_metadata",["preferlanguage"])},getLibraryStore:function(){this.library_store=this.library_store||new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,root:"data",idProperty:"opid",fields:["id","opid","title","type"],data:{data:SYNO.SDS.VideoStation2.Library.get().getAllLibraries()}});return this.library_store},editPathHandler:function(){var a=new SYNO.SDS.VideoStation2.FileChooser({owner:this,title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},isDirty:function(){if(!Ext.isObject(this.folder)||!Ext.isObject(this.library)){return false}return !SYNO.ux.Utils.checkObjectConsistency(this.getFormPanel().getForm().getValues(),this.original_values)},isValid:function(){return this.getFormPanel().getForm().isValid()},getInvalidError:function(){return _VST("videofolder","specify_path")},getParameter:function(){var b=this.getFormPanel().getForm();var c=b.findField("path").getValue();var a=SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(b.findField("library").getValue());var e=SYNO.SDS.VideoStation2.Util.getShareData(c);var d={share:e.orishare,subpath:e.subpath,section:a.type,search_metadata:b.findField("enable_search_online_metadata").getValue(),preferlang:b.findField("preferlanguage").getValue()};if(a.id>0){d.library_id=a.id}if(!this.isAddMode()){Ext.apply(d,{old_share:this.folder.share,old_subpath:this.folder.subpath})}return d},onChooserSelect:function(b,c){if(c&&Ext.isString(c.path)){var a=this.getFormPanel().getForm();a.findField("path").setValue(c.path)}b.close()},onLibrarySelect:function(d,a,b){var c=["enable_search_online_metadata","preferlanguage"];Ext.each(c,function(f){var e=this.getFormPanel().getForm().findField(f);e.setDisabled(a.get("type")===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO)},this)}});Ext.define("SYNO.SDS.VideoStation2.SettingController",{statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.SettingController.instance)){SYNO.SDS.VideoStation2.SettingController.instance=new SYNO.SDS.VideoStation2.SettingController()}return SYNO.SDS.VideoStation2.SettingController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments)},launchFolderDialog:function(b,a,d){var c=new SYNO.SDS.VideoStation2.FolderDialog({owner:this.getActiveWindow(),library:a,mode:SYNO.SDS.VideoStation2.AddEditDialog[b?"MODE_ADD":"MODE_EDIT"],callback:d});this.openDialog(c)},openDialog:function(a){this.activeDialog.push(a);this.mon(a,"close",this.onDialogClosed,this,{single:true});a.open()},getActiveWindow:function(){return Ext.isEmpty(this.activeDialog)?SYNO.SDS.VideoStation2.Window:this.activeDialog.last()},onDialogClosed:function(a){if(this.activeDialog.last()===a){this.activeDialog.splice(-1)}if(Ext.isEmpty(this.activeDialog)){SYNO.SDS.VideoStation2.Window.unmask()}},confirm:function(c,b,d,a){this.getActiveWindow().getMsgBox().confirm(c,b,d,a)},alert:function(b,a){this.getActiveWindow().getMsgBox().alert(b,a)},confirmAction:function(e,d,c,b){var a=function(f){if("yes"===f){SYNO.SDS.VideoStation2.Util.applyCallback({fn:c,scope:b})}};this.confirm(e,d,a)},sendRequest:function(b){var a=function(d,f,c){this.getActiveWindow().clearStatusBusy();if(c&&c.success){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(b.callback,{args:[d,c]}))}else{var e=SYNO.SDS.VideoStation2.Error.getErrorInfoString(c,_T("common","commfail"));this.alert("",e)}};this.getActiveWindow().setStatusBusy({text:b.loading_text||_T("common","saving")});this.addAjaxTask({url:b.url,method:"POST",single:true,autoJsonDecode:true,params:b.params,scope:this,callback:a},this).start(true)},checkCapability:function(a){SYNO.SDS.VideoStation2.OP.get().getVideoStationInfo({},{success:function(d,c,b){SYNO.SDS.VideoStation2.Capability.get().loadCapability(d);SYNO.SDS.VideoStation2.Util.applyCallback(a)}})},loadSession:function(a){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("session.cgi"),params:{action:"load"},callback:{fn:function(b,c){SYNO.SDS.VideoStation2.DTV.get().setDTVDisabled(c.data.disable_dtv);SYNO.SDS.VideoStation2.Util.applyCallback(a)}}})},deleteFolder:function(a,b){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),params:{action:"delete",share:a.share,subpath:a.subpath},callback:b})},deleteLibrary:function(a,b){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),params:{action:"delete",id:a.id,type:a.type},callback:b})},exportMetadata:function(a,b){if(!Ext.isObject(a)||!Ext.isString(a.type)||!Ext.isNumber(a.id)){return}this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),params:{action:"export_metadata",id:a.id>0?a.id:0,type:a.type},callback:b})},activeDialog:[]});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={title:_VST("advanced","panel_title"),labelWidth:200,trackResetOnLoad:true,items:[new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.TranscodingSet(),new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet(),new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet()],listeners:{scope:this,afterrender:{fn:this.initEnableCheckGroup,single:true},activate:{fn:this.loadData}}};this.callParent([Ext.apply(a,b)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event.EVENT_HEIGHT_CHANGE);this.items.each(function(c){this.relayEvents(c,[SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event.EVENT_HEIGHT_CHANGE])},this)},isDirty:function(){return this.getForm().isDirty()},initEnableCheckGroup:function(){var a;a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"cmzvideo_cover",["cmzvideo_cover_rule"]);a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"opensubtitles_enable",["opensubtitles_username","opensubtitles_password","opensubtitles_language"])},loadData:function(){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:{action:"load"},callback:{scope:this,fn:function(b,a){this.getForm().setValues(a.data)}}})},saveChanges:function(d){var b=this.getForm();if(!b.isValid()){return}var c=b.findField("cmzvideo_cover_rule");if(Ext.isEmpty(c.getValue().trim())){c.setValue(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet.DEFAULT_COVER_RULE)}var a=b.getValues();if(a.opensubtitles_password&&a.opensubtitles_password.indexOf("\t")!==-1){a.opensubtitles_password="\t\t\t\t\t\t\t\t"}if(Ext.isArray(a.opensubtitles_language)){a.opensubtitles_language=a.opensubtitles_language.join(",")}SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:Ext.apply({action:"save"},a),callback:{fn:function(f,e){b.setValues(a);SYNO.SDS.VideoStation2.Util.applyCallback(d)}}})},rejectChanges:function(){this.getForm().reset()}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event",{statics:{EVENT_HEIGHT_CHANGE:"heightchange"}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.TranscodingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={title:_VST("advanced","transcoding_settings"),collapsible:true,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){var b=["getEnableAC3Passthrough","getEnableHardwareTranscode","getSharingTranscodeOption"];var a=[];Ext.each(b,function(d){var c=this[d]();if(Ext.isObject(c)){a.push(c)}},this);return a},getEnableAC3Passthrough:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("advanced","pass_through_ac3"),name:"not_trans_audio_ac3_to_mp3"})},getEnableHardwareTranscode:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToHardwareTranscode()||!SYNO.SDS.VideoStation2.Capability.get().ableToSoftwareTranscode()){return null}return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("advanced","enable_hardware_accelerate"),name:"hardware_transcode"})},getSharingTranscodeOption:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToRemux()){return null}var a=[["disable",_VST("advanced","disallow_transcode")],["remux",_VST("advanced","allow_remux")],["transcode",_VST("advanced","allow_transcode")]];if(!SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()){a.splice(-1)}return new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("advanced","public_sharing"),displayField:"display",valueField:"value",name:"public_sharing_transcode_option",store:new Ext.data.ArrayStore({fields:["value","display"],data:a})})}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",statics:{DEFAULT_COVER_RULE:"cover.jpg;Cover.jpg;COVER.jpg;folder.jpg;Folder.jpg;FOLDER.jpg"},constructor:function(b){var a={title:_VST("advanced","video_cover_settings"),collapsible:true,labelWidth:250,items:[this.getEnableCoverRule(),this.getCoverRuleDescription(),this.getCustomizedCoverRule()]};this.callParent([Ext.apply(a,b)])},getEnableCoverRule:function(){return new SYNO.SDS.VideoStation2.Checkbox({name:"cmzvideo_cover",boxLabel:_VST("advanced","customized_video_cover")})},getCoverRuleDescription:function(){return{xtype:"syno_vs_displayfield",indent:1,name:"video_cover_note",htmlEncode:false,value:String.format('<span class="syno-ux-note">{0}: </span>{1} {2}',_T("common","note"),_VST("advanced","only_apply_to"),_VST("advanced","same_filename_high_priority"))}},getCustomizedCoverRule:function(){return new SYNO.SDS.VideoStation2.TextField({indent:1,width:300,name:"cmzvideo_cover_rule",fieldLabel:_VST("advanced","filename"),validator:this.coverRuleValidator})},coverRuleValidator:function(b){if(Ext.isEmpty(b.trim())){return true}var a=null;var c=b.split(";");Ext.each(c,function(d){if(-1===d.search(/.+\.([jJ][pP][gG]|[jJ][pP][eE][gG])$/)){a=String.format(_VST("advanced","cover_format_error"),SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet.DEFAULT_COVER_RULE);return false}});return a||true}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",statics:{LANGUAGE_MAPPING:{csy:"cze",dan:"dan",enu:"eng",fre:"fre",ger:"ger",hun:"hun",ita:"ita",jpn:"jpn",krn:"kor",nld:"dut",nor:"nor",plk:"pol",ptb:"pob",ptg:"por",rus:"rus",spn:"spa",sve:"swe",trk:"tur"},EXTRA_LANGUAGE:[["chi",_VST("language","chinese")],["fin",_VST("language","finnish")],["ara",_VST("language","arabic")],["heb",_VST("language","hebrew")],["ell",_VST("language","greek")]]},constructor:function(b){var a={title:_VST("advanced","subtitle_settings"),collapsible:true,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){return[{xtype:"syno_vs_checkbox",name:"opensubtitles_enable",boxLabel:_VST("advanced","opensubtitles_enable")},{xtype:"syno_vs_textfield",name:"opensubtitles_username",emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_username"),indent:1},{xtype:"syno_vs_textfield",textType:"password",maxLength:"32",name:"opensubtitles_password",autoCreate:{tag:"input",type:"text",size:"20",autocomplete:"new-password"},emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_password"),indent:1},new SYNO.SDS.VideoStation2.SuperBox({name:"opensubtitles_language",fieldLabel:_VST("advanced","opensubtitles_language"),store:this.getOpenSubtitlesLanguageStore(),allowBlank:false,allowAddNewData:false,editable:false,mode:"local",indent:1,listeners:{scope:this,additem:this.notifyHeightChange,removeitem:this.notifyHeightChange}}),{xtype:"syno_vs_checkbox",name:"shooter_enable",boxLabel:_VST("advanced","shooter_enable")}]},getOpenSubtitlesLanguageStore:function(){var a=SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.LANGUAGE_MAPPING;return SYNO.SDS.Utils.getSupportedLanguage().map(function(b){return !Ext.isEmpty(a[b[0]])?[a[b[0]],b[1]]:null}).filter(function(b){return !Ext.isEmpty(b)}).concat(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.EXTRA_LANGUAGE)},notifyHeightChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event.EVENT_HEIGHT_CHANGE)}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={cls:"dtv-panel",title:_VST("dtv","title"),itemId:"dtv_settings",labelWidth:200,trackResetOnLoad:true,items:this.getItems(),listeners:{scope:this,afterrender:{fn:this.initEnableCheckGroup,single:true},activate:this.loadData}};this.callParent([Ext.apply(a,b)]);this.mon(this._folder,SYNO.SDS.VideoStation2.Setting.DTVPanel.Event.EVENT_RELOAD_DATA,this.loadData,this)},getItems:function(){return[this._folder=new SYNO.SDS.VideoStation2.Setting.DTVPanel.FolderSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.StreamingSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.RecordingSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.TVGuideSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.ScanSet(),new SYNO.SDS.VideoStation2.FieldSet({collapsible:true,title:_T("common","advanced"),items:[new SYNO.SDS.VideoStation2.Setting.DTVDisableCheckbox({})]})]},initEnableCheckGroup:function(){var a=this.getForm();var b;b=new SYNO.ux.Utils.EnableCheckGroup(a,"enableauth",["account","passwd","password_confirm"]);b=new SYNO.ux.Utils.EnableCheckGroup(a,"enable_viewer_limit",["streaming_limit"]);b=new SYNO.ux.Utils.EnableCheckGroup(a,"disable_dtv",[],["dtv_destination","enableauth","enable_viewer_limit","closestreaming","pre_recording","post_recording","epg_update_frequency","non_dvbs_scan_clear","dvbs_scan_clear"])},loadData:function(){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("dtv_manage.cgi"),params:{action:"load"},callback:{scope:this,fn:function(b,a){var c=a.data;this.getForm().setValues(c);this._folder.checkComponentStatus(c)}}})},isDirty:function(){return this.getForm().isDirty()},saveChanges:function(e){var c=this.getForm();if(!c.isValid()){return}var a=c.getValues();var b=a.dtv_destination;if(!Ext.isEmpty(b)){var d=SYNO.SDS.VideoStation2.Util.getShareData(b);Ext.apply(a,{share:d.orishare,subpath:d.subpath})}SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("dtv_manage.cgi"),params:Ext.apply({action:"save"},a),callback:{fn:function(h,g){c.setValues(a);SYNO.SDS.VideoStation2.DTV.get().setDTVDisabled(a.disable_dtv==="true");if(SYNO.SDS.VideoStation2.DTV.get().isDTVDisabled()){var f=SYNO.SDS.VideoStation2.View.get().getView();if(f===SYNO.SDS.VideoStation2.View.VIEW_DTV||f===SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE){SYNO.SDS.VideoStation2.Controller.intoHomePage()}}SYNO.SDS.VideoStation2.DTV.get().loadDTV();SYNO.SDS.VideoStation2.Util.applyCallback(e)}}})},rejectChanges:function(){this.getForm().reset()}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.Event",{statics:{EVENT_RELOAD_DATA:"reloaddata"}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.FolderSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("dtvfolder","title"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){return[{xtype:"hidden",name:"share"},{xtype:"hidden",name:"subpath"},{xtype:"syno_compositefield",fieldLabel:_VST("dtvfolder","dtv_destination"),defaults:{hideLabel:true},items:[this.getDestination(),this.getFolderButton(),this.getExportButton()]}]},getExportButton:function(){this._export=this._export||new SYNO.SDS.VideoStation2.ActionButton({cls:"export-button",disabled:true,scope:this,handler:this.onClickExportMetadata});return this._export},getDestination:function(){this._destination=this._destination||new SYNO.SDS.VideoStation2.TextField({name:"dtv_destination",postBlur:this.checkDestValid.createDelegate(this),readOnly:true,width:157,listeners:{scope:this,enable:this.updateFolderButtonStatus,disable:this.updateFolderButtonStatus}});return this._destination},getFolderButton:function(){this._folder=this._folder||new SYNO.SDS.VideoStation2.Button({btnStyle:"blue",text:_VST("common","select"),scope:this,handler:this.onDTVFolderChoose});return this._folder},forEachButtonDo:function(a){a(this.getFolderButton());a(this.getExportButton())},updateFolderButtonStatus:function(){var a=this.getDestination();if(a.disabled===true){this.forEachButtonDo(function(c){c.disable()});return}this.getExportButton().setDisabled(this.destinationExporting||a.isDirty()||this.destInvalid||Ext.isEmpty(a.getValue()));this.getFolderButton().setDisabled(this.destinationExporting);if(this.destinationExporting){var b=Ext.util.Format.htmlEncode(_VST("library","metadata_exporting"));this.forEachButtonDo(function(c){c.setTooltip(b)})}else{this.forEachButtonDo(function(c){c.setTooltip("")});this.getExportButton().setTooltip(_VST("action","export_metadata"))}},onDTVFolderChoose:function(){var a=SYNO.SDS.VideoStation2.SettingController.get();var b=new SYNO.SDS.VideoStation2.FileChooser({owner:a.getActiveWindow(),title:this.title});b.mon(b,"choose",this.onChooserSelect,this);a.openDialog(b)},onChooserSelect:function(a,b){if(b&&Ext.isString(b.path)){this.destInvalid=false;this.getDestination().setValue(b.path);this.updateFolderButtonStatus()}a.close()},checkComponentStatus:function(a){this.destinationExporting=a.dtv_destination_exporting;if(!a.dtv_destination_exists&&""!==a.dtv_destination){this.destInvalid=true}this.checkDestValid();this.checkPollingExportStatus();this.updateFolderButtonStatus()},checkDestValid:function(){if(true===this.destInvalid){this.getDestination().markInvalid(_VST("error","record_dest_not_exist"))}},checkPollingExportStatus:function(){if(this.destinationExporting){this.getPollingExportingTask().delay(5000)}else{this.stopPollingExportingTask()}},onClickExportMetadata:function(){var a=function(){var b={type:"tv_record",id:0};SYNO.SDS.VideoStation2.SettingController.get().exportMetadata(b,{fn:function(){this.destinationExporting=true;this.updateFolderButtonStatus();this.getPollingExportingTask().delay(5000)},scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","export_metadata_desc"),a,this)},getPollingExportingTask:function(){if(!Ext.isEmpty(this.pollingExportingTask)){return this.pollingExportingTask}this.pollingExportingTask=new Ext.util.DelayedTask(function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.DTVPanel.Event.EVENT_RELOAD_DATA)},this);return this.pollingExportingTask},stopPollingExportingTask:function(){if(!Ext.isEmpty(this.pollingExportingTask)){this.pollingExportingTask.cancel()}}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.StreamingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("programguide","broadcast_streaming"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){var a=[{xtype:"syno_vs_checkbox",boxLabel:_VST("streaming","enable_streaming_auth"),name:"enableauth"}];a.push(this.getAccountField());a.push(this.getPasswordField());a.push(this.getPasswordConfirmField());a.push({xtype:"syno_vs_checkbox",boxLabel:_VST("streaming","enable_stream_limit"),name:"enable_viewer_limit"});a.push(this.getStreamingLimitField());return a},getAccountField:function(){this._account=this._account||new SYNO.SDS.VideoStation2.TextField({name:"account",fieldLabel:_VST("streaming","stream_auth_user"),validator:this.accountValidator.createDelegate(this),width:160,indent:1});return this._account},getPasswordField:function(){this._passwd=this._passwd||new SYNO.SDS.VideoStation2.TextField({name:"passwd",textType:"password",fieldLabel:_T("common","password"),validator:this.passwordValidator.createDelegate(this),width:160,indent:1});return this._passwd},getPasswordConfirmField:function(){this._confirm=this._confirm||new SYNO.SDS.VideoStation2.TextField({name:"password_confirm",textType:"password_confirm",fieldLabel:_VST("streaming","pass_confirm"),validator:this.confirmValidator.createDelegate(this),width:160,indent:1});return this._confirm},getStreamingLimitField:function(){this._limit=this._limit||new SYNO.SDS.VideoStation2.NumberField({name:"streaming_limit",fieldLabel:_VST("streaming","streaming_limit_viewer"),width:160,indent:1,decimalPrecision:0,minValue:1,maxlength:6});return this._limit},accountValidator:function(a){return Ext.isEmpty(a)?_VST("streaming","msg_invalid_user"):true},passwordValidator:function(a){return Ext.isEmpty(a)?_VST("streaming","error_empty_password"):true},confirmValidator:function(b){var a=this.getPasswordField().getValue();if(b!==a&&(b!=="87654321"||a!=="12345678")){return _VST("streaming","nzb_confirmpass")}else{return true}}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.RecordingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("record","record_setting"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){var a=[{xtype:"syno_vs_checkbox",boxLabel:_VST("record","record_first_stream"),name:"closestreaming"}];a.push(this.getPreRecordingField());a.push(this.getPostRecordingField());return a},getPreRecordingField:function(){this._pre=this._pre||new SYNO.SDS.VideoStation2.NumberField({name:"pre_recording",fieldLabel:_VST("record","pre_recording_interval"),indent:1,width:160,minValue:0,maxValue:3600,maxlength:4,emptyText:_T("common","time_seconds")});return this._pre},getPostRecordingField:function(){this._post=this._post||new SYNO.SDS.VideoStation2.NumberField({name:"post_recording",fieldLabel:_VST("record","post_recording_interval"),indent:1,width:160,minValue:0,maxValue:3600,maxlength:4,emptyText:_T("common","time_seconds")});return this._post}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.TVGuideSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("programguide","setting"),labelWidth:250,items:[this.getFrequencyCombo()]};this.callParent([Ext.apply(a,b)])},getFrequencyCombo:function(){this._frequency=this._frequency||new SYNO.SDS.VideoStation2.ComboBox({name:"epg_update_frequency",fieldLabel:_VST("programguide","update_frequency"),displayField:"display",valueField:"value",value:"daily",store:this.getFrequencyStore()});return this._frequency},getFrequencyStore:function(){this._store=this._store||new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:[["twiceaday",_VST("programguide","frequency_twice_a_day")],["daily",_VST("programguide","frequency_daily")],["3days",_VST("programguide","frequency_3_day")],["weekly",_VST("programguide","frequency_weekly")],["never",_VST("programguide","frequency_never")]]});return this._store}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.ScanSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("dtv","scan_setting"),labelWidth:250,items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("dtv","non_dvbs_scan_clear"),name:"non_dvbs_scan_clear"},{xtype:"syno_vs_checkbox",boxLabel:_VST("dtv","dvbs_scan_clear"),name:"dvbs_scan_clear"}]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVDisableCheckbox",{extend:"SYNO.SDS.VideoStation2.Checkbox",constructor:function(b){var a={boxLabel:_VST("dtv","disable_dtv"),name:"disable_dtv"};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={title:_VST("options","title"),items:[new SYNO.SDS.VideoStation2.Setting.GeneralPanel.HomepageSet(),new SYNO.SDS.VideoStation2.Setting.GeneralPanel.DiscoverSubtitleSet(),new SYNO.SDS.VideoStation2.Setting.GeneralPanel.ChromecastSet()],listeners:{scope:this,activate:{fn:this.loadData},afterrender:{fn:this.initEnableCheckGroup,single:true}}};this.callParent([Ext.apply(a,b)])},isDirty:function(){var a=this.getForm().getValues();return(a.hide_slide_show==="true")!==this.oriHideSlideShow||(a.disable_slide_show==="true")!==this.oriDisableSlideShow||(a.enable_discover==="true")!==this.oriEnableDiscover||(a.enable_ac3_passthrough==="true")!==this.oriEnableAc3Passthrough},initEnableCheckGroup:function(){new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"hide_slide_show",[],["disable_slide_show"])},loadData:function(){this.oriHideSlideShow=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show")===true;this.oriDisableSlideShow=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","disable_slide_show")===true;this.oriEnableDiscover=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","enable_discover")===true;this.oriEnableAc3Passthrough=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","enable_ac3_passthrough")===true;this.getForm().setValues({hide_slide_show:this.oriHideSlideShow,disable_slide_show:this.oriDisableSlideShow,enable_discover:this.oriEnableDiscover,enable_ac3_passthrough:this.oriEnableAc3Passthrough})},saveChanges:function(d){var b=this.getForm();if(!b.isValid()){return}var a=b.getValues();SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show",a.hide_slide_show==="true");SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","disable_slide_show",a.disable_slide_show==="true");SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","enable_discover",a.enable_discover==="true");SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","enable_ac3_passthrough",a.enable_ac3_passthrough==="true");var c=SYNO.SDS.VideoStation2.View.get();if(c.view===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE){SYNO.SDS.VideoStation2.Controller.refreshView()}SYNO.SDS.VideoStation2.Util.applyCallback(d)},rejectChanges:function(){this.getForm().setValues({hide_slide_show:this.oriHideSlideShow,disable_slide_show:this.oriDisableSlideShow,enable_discover:this.oriEnableDiscover,enable_ac3_passthrough:this.oriEnableAc3Passthrough})}});Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.HomepageSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={title:_VST("options","homepage_setting"),collapsible:true,labelWidth:250,items:[this.getHideSlideShow(),this.getDisableSlideShow()]};this.callParent([Ext.apply(a,b)])},getHideSlideShow:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","hide_slide_show"),name:"hide_slide_show"})},getDisableSlideShow:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","disable_slide_show"),name:"disable_slide_show"})}});Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.DiscoverSubtitleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={title:_VST("controller","discover_subtitle"),collapsible:true,labelWidth:250,items:[this.getDiscoverSubtitle()]};this.callParent([Ext.apply(a,b)])},getDiscoverSubtitle:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","enable_discover"),name:"enable_discover"})}});Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.ChromecastSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={title:_VST("controller","chromecast_mode"),collapsible:true,labelWidth:250,items:[this.getAc3Passthrough()]};this.callParent([Ext.apply(a,b)])},getAc3Passthrough:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","pass_through_ac3_chromecast"),name:"enable_ac3_passthrough"})}});Ext.define("SYNO.SDS.VideoStation2.LibraryController",{statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.LibraryController.instance)){SYNO.SDS.VideoStation2.LibraryController.instance=new SYNO.SDS.VideoStation2.LibraryController()}return SYNO.SDS.VideoStation2.LibraryController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments)},loadLibrary:function(){SYNO.SDS.VideoStation2.Library.get().loadLibrary()}});Ext.define("SYNO.SDS.VideoStation2.EnableGrid",{extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:50,constructor:function(a){this.pageSize=a.pageSize||this.pageSize;this.callParent([Ext.apply(this.getConfig(),a)]);this.addClass("enable-grid");this.mon(this.getStore(),"beforeload",this.onBeforeLoad,this)},confirm:Ext.emptyFn,getStore:Ext.emptyFn,getColumns:Ext.emptyFn,saveChanges:Ext.emptyFn,getPagingToolbar:function(){this._paging=this._paging||new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:this.getStore(),displayInfo:true});return this._paging},getConfig:function(){return{store:this.getStore(),border:false,flex:1,viewConfig:{scrollDelay:false,borderHeight:0,cacheSize:50,forceFit:true},stripeRows:true,enableColLock:false,enableColumnMove:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),cm:this.getColumns(),bbar:this.getPagingToolbar()}},saveChangesAndLoadStore:function(a){this.saveChanges({scope:this,fn:function(){this.getStore().commitChanges();this.getStore().load(a)}})},onBeforeLoad:function(a,b){if(!this.isDirty()){return true}var c=function(d){if("yes"===d){this.saveChangesAndLoadStore(b)}else{a.rejectChanges();a.load(b)}};this.confirm("",_T("share","share_save_chg_before_reload"),c,this);return false},isDirty:function(){return !Ext.isEmpty(this.getStore().getModifiedRecords())}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPermissionDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){this.callback=b.callback||{};var a={title:_VST("library","permission"),width:500,height:580,minWidth:300,minHeight:280,resizable:true,layout:"fit",items:[this.getGridPanel(b)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)])},getGridPanel:function(a){this._grid=this._grid||new SYNO.SDS.VideoStation2.Setting.LibraryPermissionGrid({library_id:a.library_id,permission:a.permission});return this._grid},onApply:function(){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(this.callback,{args:[this.getGridPanel().getChanges()]}));this.close()},onCancel:function(){if(!this.getGridPanel().isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this.getMsgBox().confirm("",_T("common","confirm_lostchange"),a,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPermissionGrid",{extend:"SYNO.SDS.VideoStation2.EnableGrid",constructor:function(b){this.library_id=b.library_id;this.changes=b.permission;var a={plugins:[this.getBrowseColumn()]};this.callParent([Ext.apply(a,b)]);this.mon(this.getStore(),"load",this.applyLocalChanges,this)},confirm:function(c,b,d,a){SYNO.SDS.VideoStation2.SettingController.get().confirm(c,b,d,a)},getStore:function(){this._store=this._store||new Ext.data.JsonStore({proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),autoLoad:true,root:"data.users",totalProperty:"data.total",baseParams:{action:"list_permission",id:this.library_id},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"browse",type:"boolean",defaulValue:false}]});return this._store},getColumns:function(){this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getBrowseColumn()]});return this._cm},saveChanges:function(a){this.changes=this.getChanges();SYNO.SDS.VideoStation2.Util.applyCallback(a)},getBrowseColumn:function(){this._browse_column=this._browse_column||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("common","browse"),dataIndex:"browse",id:"browse",width:150,ignoreKey:"is_admin"});return this._browse_column},getStoreChanges:function(){var a={};Ext.each(this.getStore().getModifiedRecords(),function(b){var c=b.get("uid");a[c]=a[c]||{};a[c].browse=b.get("browse")});return a},getChanges:function(){return Ext.apply(this.changes||{},this.getStoreChanges())},applyLocalChanges:function(b,a,c){if(!Ext.isObject(this.changes)){return}b.each(function(d){var e=d.get("uid");if(Ext.isDefined(this.changes[e])){d.set("browse",this.changes[e].browse)}},this);b.commitChanges()}});Ext.define("SYNO.SDS.VideoStation2.LibraryDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",cgi:"library_manage.cgi",constructor:function(b){this.library=SYNO.Util.copy(b.library);this.callback=b.callback||{};var a={resizable:false};this.callParent([Ext.apply(a,b)])},onOpen:function(){this.callParent(arguments);if(this.isAddMode()){return}var a=this.getFormPanel().getForm();a.findField("title").setValue(this.library.title);a.findField("type").setValue(this.library.type);a.findField("is_public").setValue(this.library.is_public?1:0);this.original_values=a.getValues()},getFormConfig:function(){var d={xtype:"syno_vs_textfield",itemId:"title",fieldLabel:_T("common","name"),allowBlank:false,maxLength:50};var b={xtype:"syno_vs_radiogroup",itemId:"type",fieldLabel:_VST("type","tile"),hideLabel:false,columns:1,items:[{boxLabel:_VST("type","movie"),inputValue:SYNO.SDS.VideoStation2.Constant.MOVIE,name:"type",checked:true},{boxLabel:_VST("type","tv_show"),inputValue:SYNO.SDS.VideoStation2.Constant.TVSHOW,name:"type",checked:false},{boxLabel:_VST("type","others"),inputValue:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO,name:"type",checked:false}]};var a={xtype:"syno_vs_radiogroup",itemId:"is_public",fieldLabel:_VST("library","permission_title"),hideLabel:false,columns:1,items:[{boxLabel:_VST("library","public"),inputValue:1,name:"is_public",checked:true},{boxLabel:_VST("library","private"),inputValue:0,name:"is_public",checked:false}],listeners:{scope:this,change:function(f,e){this.getPermissionButton().setDisabled(e.inputValue===1)}}};var c={xtype:"syno_compositefield",items:[this.getPermissionButton()]};return{trackResetOnLoad:true,border:false,labelWidth:180,hideLabels:false,items:[d,b,a,c]}},getPermissionButton:function(){this._permission_btn=this._permission_btn||new SYNO.SDS.VideoStation2.Button({btnStyle:"red",itemId:"permissionButton",disabled:true,text:_VST("library","permission"),handler:this.openPermissionDialog.createDelegate(this)});return this._permission_btn},openPermissionDialog:function(){var a=Ext.isObject(this.library)?this.library.id:0;var c=SYNO.SDS.VideoStation2.SettingController.get();var b=new SYNO.SDS.VideoStation2.Setting.LibraryPermissionDialog({owner:c.getActiveWindow(),library_id:a,permission:this.permission,callback:{scope:this,fn:function(d){this.permission=this.permission||{};Ext.apply(this.permission,d)}}});c.openDialog(b)},isDirty:function(){if(!Ext.isObject(this.library)){return false}return Ext.isObject(this.permission)||!SYNO.ux.Utils.checkObjectConsistency(this.getFormPanel().getForm().getValues(),this.original_values)},isValid:function(){return this.getFormPanel().getForm().isValid()},getInvalidError:function(){return _T("error","error_bad_field")},getParameter:function(){var a=this.getFormPanel().getForm();var b={title:a.findField("title").getValue(),is_public:a.findField("is_public").getValue().inputValue,type:a.findField("type").getValue().inputValue,permission:Ext.encode(this.permission||{})};if(Ext.isObject(this.library)&&!this.isAddMode()){Ext.apply(b,{id:this.library.id,old_type:this.library.type,old_is_public:this.library.is_public?1:0,old_title:this.library.title})}return b}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={title:_VST("library","title"),cls:"library-panel",autoFlexcroll:true,layout:"accordion",layoutConfig:{animate:false,activeOnTop:false,fill:false,hideCollapseTool:true,titleCollapse:true},tbar:this.getToolbar(),items:[this.getItems()]};this.callParent([Ext.apply(a,b)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_HEIGHT_CHANGE);this.bindAllEvents();this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.refreshLibrary,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,this.onFolderSelectionChange,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_LIBRARY_SELECTION_CHANGE,this.onLibrarySelectionChange,this)},getToolbar:function(){this._tbar=this._tbar||new SYNO.ux.Toolbar({items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"add-library",tooltip:_VST("library","create"),scope:this,handler:this.addLibrary}),this.getReindexButton(),this.getSearchInfoButton(),this.getExportButton()]});return this._tbar},getItems:function(){var a=SYNO.SDS.VideoStation2.Library.get().getAllLibraries();return a.map(function(b){return new SYNO.SDS.VideoStation2.Setting.FolderPanel({library:b})})},getReindexButton:function(){this._reindex=this._reindex||new SYNO.SDS.VideoStation2.ActionButton({cls:"reindex",tooltip:_VST("action","reindex_no_update"),scope:this,disabled:true,handler:this.doReindex});return this._reindex},getSearchInfoButton:function(){this._search=this._search||new SYNO.SDS.VideoStation2.ActionButton({cls:"search-info",tooltip:_VST("action","reindex_with_update"),scope:this,disabled:true,handler:this.doSearchInfo});return this._search},getExportButton:function(){this._export=this._export||new SYNO.SDS.VideoStation2.ActionButton({cls:"export",tooltip:_VST("action","export_metadata"),scope:this,handler:this.exportMetadata});return this._export},bindAllEvents:function(){this.items.each(function(a){this.relayEvents(a,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_HEIGHT_CHANGE,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_LIBRARY_SELECTION_CHANGE]);a.relayEvents(this,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER])},this)},refreshLibrary:function(){this.removeAll();this.add(this.getItems());this.bindAllEvents();this.doLayout()},onLibrarySelectionChange:function(a){this.active_library=SYNO.Util.copy(a);this.getExportButton().setDisabled(!Ext.isObject(this.active_library))},onFolderSelectionChange:function(a){this.getReindexButton().setDisabled(!Ext.isObject(a));this.getSearchInfoButton().setDisabled(!Ext.isObject(a));this.getExportButton().setDisabled(Ext.isObject(a))},addLibrary:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.LibraryDialog({owner:b.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD,callback:{fn:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}}});b.openDialog(a)},doReindex:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,this.active_library)},doSearchInfo:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,this.active_library)},doReloadCurrentLibrary:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER,this.active_library)},exportMetadata:function(){var a=function(){SYNO.SDS.VideoStation2.SettingController.get().exportMetadata(this.active_library||{},{fn:this.doReloadCurrentLibrary,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","export_metadata_desc"),a,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event",{statics:{EVENT_HEIGHT_CHANGE:"heightchange",EVENT_DO_REINDEX:"doreindex",EVENT_DO_SEARCH_INFO:"dosearchinfo",EVENT_DO_RELOAD_FOLDER:"doreloadfolder",EVENT_FOLDER_CHANGE:"folderchange",EVENT_FOLDER_SELECTION_CHANGE:"folderselectionchange",EVENT_LIBRARY_SELECTION_CHANGE:"libraryselectionchange",EVENT_EDIT_FOLDER:"editfolder",EVENT_DELETE_FOLDER:"deletefolder"}});Ext.define("SYNO.SDS.VideoStation2.Setting.FolderPanel",{extend:"SYNO.SDS.VideoStation2.AccordionPanel",statics:{ACTION_ADD_FOLDER:{cls:"add-folder",qtip:_VST("videofolder","add"),fn:"addFolder"},ACTION_EDIT_LIBRARY:{cls:"edit",qtip:_VST("library","edit"),fn:"editLibrary"},ACTION_DELETE_LIBRARY:{cls:"delete",qtip:_VST("library","delete"),fn:"deleteLibrary"}},header:false,headerAsText:false,title:null,constructor:function(b){this.library=SYNO.Util.copy(b.library);this.dataview=new SYNO.SDS.VideoStation2.Setting.FolderDataView({store:this.getStore()});var a={cls:"folder-panel",headerCfg:this.getHeaderConfig(),items:[this.dataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,expand:this.notifyHeightChange,collapse:this.onPanelCollapse}};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.dataview,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE]);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_CHANGE,this.loadData,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,this.onFolderSelectionChange,this);this.mon(this.dataview,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_EDIT_FOLDER,this.editFolder,this);this.mon(this.dataview,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DELETE_FOLDER,this.deleteFolder,this)},getHeaderConfig:function(){var b={tag:"td",align:"left",cn:[{tag:"div",cls:(this.library.id===0?this.library.type:"library")+" icon"},{tag:"div",cls:"title",html:Ext.util.Format.htmlEncode(this.library.title)}]};var c=[SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_ADD_FOLDER)];if(this.library.id>0){Array.prototype.push.apply(c,[SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_EDIT_LIBRARY),SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_DELETE_LIBRARY)])}c=c.map(function(d){return{tag:"div","ext:qtip":Ext.util.Format.htmlEncode(d.qtip),cls:String.format("action {0}",d.cls),fnname:d.fn}});var a={tag:"td",align:"right",cn:c};return{tag:"div",cls:"x-panel-header",cn:[{tag:"table",cls:"x-toolbar-ct",cn:[{tag:"tbody",cn:[{tag:"tr",cn:[b,a]}]}]}]}},getStoreParameter:function(){var a={action:"list",section:this.library.type};if(this.library.id>0){Ext.apply(a,{library_id:this.library.id})}return a},getStore:function(){this._store=this._store||new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,idProperty:"path",root:"data.folders",baseParams:this.getStoreParameter(),fields:["exist","path","preferlang","status","share","subpath","search_metadata"],proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),listeners:{scope:this,load:this.onFolderLoad}});return this._store},toggleCollapse:function(b){var a=Ext.fly(b.getTarget());if(a.hasClass("action")){this[a.getAttribute("fnname")]()}else{this.callParent(arguments)}},addFolder:function(){SYNO.SDS.VideoStation2.SettingController.get().launchFolderDialog(true,this.library,{fn:this.loadData,scope:this})},editFolder:function(b){var c=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.FolderDialog({owner:c.getActiveWindow(),library:this.library,folder:b,mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,callback:{scope:this,fn:this.notifyFolderChange}});c.openDialog(a)},editLibrary:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.LibraryDialog({owner:b.getActiveWindow(),library:this.library,mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,callback:{scope:this,fn:this.reloadLibrary}});b.openDialog(a)},deleteFolder:function(b){var a=function(){SYNO.SDS.VideoStation2.SettingController.get().deleteFolder(SYNO.Util.copy(b),{fn:this.notifyFolderChange,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("videofolder","delete_confirm"),a,this)},deleteLibrary:function(){var a=function(){SYNO.SDS.VideoStation2.SettingController.get().deleteLibrary(this.library,{fn:this.reloadLibrary,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","delete_confirm"),a,this)},reloadLibrary:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()},reindexRequest:function(a){if(!Ext.isObject(this.active_folder)){SYNO.Debug.error("no folder selection");return}SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),params:{action:a,share:this.active_folder.share,subpath:this.active_folder.subpath},loading_text:_T("common","loading"),callback:{fn:this.loadData,scope:this}})},doReindex:function(a){if(SYNO.ux.Utils.checkObjectConsistency(this.library,a)){this.reindexRequest("reindex-noupdate")}},doSearchInfo:function(a){if(SYNO.ux.Utils.checkObjectConsistency(this.library,a)){this.reindexRequest("reindex-update")}},doReloadFolder:function(a){if(SYNO.ux.Utils.checkObjectConsistency(this.library,a)){this.loadData()}},onPanelCollapse:function(){this.dataview.clearSelections();this.notifyHeightChange()},notifyHeightChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_HEIGHT_CHANGE)},notifyFolderChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_CHANGE)},onFolderLoad:function(b,a,c){if(!this.collapsed){this.notifyHeightChange()}},onActivate:function(){this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,this.doReindex,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,this.doSearchInfo,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER,this.doReloadFolder,this);this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_LIBRARY_SELECTION_CHANGE,this.library);this.loadData()},onDeactivate:function(){this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,this.doReindex,this);this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,this.doSearchInfo,this);this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER,this.doReloadFolder,this);this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,null)},onFolderSelectionChange:function(a){this.active_folder=SYNO.Util.copy(a)},loadData:function(){this.getStore().load()}});Ext.define("SYNO.SDS.VideoStation2.Setting.FolderDataView",{extend:"Ext.DataView",constructor:function(b){var a={cls:"folder-dataview",tpl:this.getTpl(),itemSelector:"div.item-wrap",overClass:"x-view-over",singleSelect:true,listeners:{scope:this,selectionchange:this.onSelectionChange}};this.callParent([Ext.apply(a,b)])},getTpl:function(){var a=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("videofolder","edit")));var b=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("videofolder","delete")));return new Ext.XTemplate('<tpl for=".">','<div class="item-wrap">','<div class="select-mark"></div>','<table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">','<div class="text-wrapper sds-ellipsis">','<span class="path">{path}</span>{[this.getStatusSpan(values)]}',"</div>","</td>",'<td align="right">','<div class="action-wrapper">',String.format('<div ext:qtip="{0}" class="action edit"></div><div ext:qtip="{1}", class="action delete"></div>',a,b),"</div>","</td>","</tr></tbody></table>","</div>","</tpl>",{compiled:true,getStatusSpan:this.getStatusSpan.createDelegate(this)})},getStatusSpan:function(a){return !Ext.isEmpty(a.status)?String.format('<span class="status">({0}...)</span>',a.status):""},onClick:function(g,f,d){var b=Ext.fly(f);var c=g.getTarget(this.itemSelector,this.getTemplateTarget());var a=this.getRecord(c);if(b.hasClass("delete")){this.deleteFolder(a)}else{if(b.hasClass("edit")){this.editFolder(a)}else{this.callParent(arguments)}}},onSelectionChange:function(a,b){if(Ext.isEmpty(b)){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,null)}else{this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,a.getRecord(b[0]).data)}},editFolder:function(a){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_EDIT_FOLDER,a.data)},deleteFolder:function(a){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DELETE_FOLDER,a.data)}});Ext.define("SYNO.SDS.VideoStation2.Setting.PrivilegePanel",{extend:"SYNO.SDS.VideoStation2.EnableGrid",constructor:function(b){var a={title:_VST("privilege","title"),plugins:this.getEnableColumns(),listeners:{scope:this,activate:this.onActivate}};this.callParent([Ext.apply(a,b)])},onActivate:function(){this.getStore().load()},confirm:function(c,b,d,a){SYNO.SDS.VideoStation2.SettingController.get().confirm(c,b,d,a)},getStore:function(){this._store=this._store||new Ext.data.JsonStore({proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("privilege_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),autoLoad:false,root:"data.users",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"dtv",type:"boolean",defaulValue:false},{name:"renderer",type:"boolean",defaulValue:false},{name:"sharing",type:"boolean",defaulValue:false},{name:"offline_conversion",type:"boolean",defaulValue:false}]});return this._store},getColumns:function(){this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"}].concat(this.getEnableColumns())});return this._cm},getEnableColumns:function(){var a=SYNO.SDS.VideoStation2.Util.hideDTVUI()?[]:[this.getDTVColumn()];a=a.concat([this.getRendererColumn(),this.getSharingColumn()]);if(SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()||SYNO.SDS.VideoStation2.Capability.get().ableToHardwareTranscode()){a.push(this.getOfflineConversionColumn())}return a},saveChanges:function(a){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("privilege_manage.cgi"),params:{action:"save",privilege:Ext.encode(this.getChanges()||{})},callback:a})},rejectChanges:function(){this.getStore().rejectChanges()},getDTVColumn:function(){this._dtv=this._dtv||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","dtv_control"),dataIndex:"dtv",id:"dtv",width:150,ignoreKey:"is_admin"});return this._dtv},getRendererColumn:function(){this._renderer=this._renderer||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","renderer_control"),dataIndex:"renderer",id:"renderer",width:200,ignoreKey:"is_admin"});return this._renderer},getSharingColumn:function(){this._sharing=this._sharing||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","public_sharing"),dataIndex:"sharing",id:"sharing",width:150,ignoreKey:"is_admin"});return this._sharing},getOfflineConversionColumn:function(){this._offline_conversion=this._offline_conversion||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("offline_conversion","title"),dataIndex:"offline_conversion",id:"offline_conversion",width:150,ignoreKey:"is_admin"});return this._offline_conversion},getChanges:function(){if(!this.isDirty()){return}var a={};Ext.each(this.getStore().getModifiedRecords(),function(b){var c=b.get("uid");a[c]=a[c]||{};Ext.each(["dtv","renderer","sharing","offline_conversion"],function(d){a[c][d]=b.get(d)})});return a}});Ext.define("SYNO.SDS.VideoStation2.Setting.Dialog",{extend:"SYNO.SDS.VideoStation2.Dialog",initActiveTab:0,constructor:function(b){var a={title:_VST("action","settings"),layout:"fit",width:690,height:580,minWidth:400,minHeight:280,items:[this.getTabPanel(b)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)])},getTabPanel:function(a){this._tab_panel=this._tab_panel||new SYNO.SDS.VideoStation2.Setting.TabPanel({activeTab:(a||{}).initActiveTab||this.initActiveTab});return this._tab_panel},onApply:function(){var b=this.getTabPanel();var a=b.getActiveTab();if(b.isActiveTabDirty()&&Ext.isFunction(a.saveChanges)){a.saveChanges({scope:this,fn:this.close})}else{this.close()}},onCancel:function(){this.confirmLostChange({scope:this,fn:this.close})},confirmLostChange:function(b){if(!this.getTabPanel().isActiveTabDirty()){SYNO.SDS.VideoStation2.Util.applyCallback(b);return}var a=function(c){if("yes"===c){SYNO.SDS.VideoStation2.Util.applyCallback(b)}};SYNO.SDS.VideoStation2.SettingController.get().confirm(this.title,_T("common","confirm_lostchange"),a,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.TabPanel",{extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(a){this.callParent([Ext.apply(this.getConfig(),a)])},getConfig:function(){var a=[];var c=["getLibrarySettingPanel","getDTVSettingPanel","getPrivilegePanel","getAdvancedSettingPanel","getGeneralPanel"];Ext.each(c,function(e){var d=this[e]();if(Ext.isObject(d)){a.push(d)}},this);var b={activeTab:0,items:a,listeners:{scope:this,beforetabchange:this.onBeforeTabChange}};return b},getLibrarySettingPanel:function(){if(!_S("is_admin")){return null}this._library=this._library||new SYNO.SDS.VideoStation2.Setting.LibraryPanel({});return this._library},getDTVSettingPanel:function(){if(!_S("is_admin")||SYNO.SDS.VideoStation2.Util.hideDTVUI()){return null}this._dtv=this._dtv||new SYNO.SDS.VideoStation2.Setting.DTVPanel({});return this._dtv},getPrivilegePanel:function(){if(!_S("is_admin")){return null}this._privilege=this._privilege||new SYNO.SDS.VideoStation2.Setting.PrivilegePanel({});return this._privilege},getAdvancedSettingPanel:function(){if(!_S("is_admin")){return null}this._advanced=this._advanced||new SYNO.SDS.VideoStation2.Setting.AdvancedPanel({});return this._advanced},getGeneralPanel:function(){this._general=this._general||new SYNO.SDS.VideoStation2.Setting.GeneralPanel({});return this._general},onBeforeTabChange:function(b,c,a){if(!this.isActiveTabDirty()){return true}this.ownerCt.confirmLostChange({fn:function(){if(Ext.isFunction(a.rejectChanges)){a.rejectChanges()}b.setActiveTab(c)}});return false},isActiveTabDirty:function(){var a=this.getActiveTab();return Ext.isObject(a)&&Ext.isFunction(a.isDirty)&&a.isDirty()}});Ext.define("SYNO.SDS.VideoStation2.CreateScheduleDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",onScheduleCreate:Ext.emptyFn,tuner:null,channel:null,program:null,constructor:function(c){var a=c.program||this.program;var b={layout:"fit",title:(a)?_VST("action","repeat_record"):_VST("schedule","user_define_schedule"),width:550,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.CreateScheduleDialog.Panel(c)]};this.callParent([Ext.apply(b,c)])},onOKBtn:function(){if(!this.panel.isValid()){return}this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get()[this.program?"createRepeatRecording":"createSchedule"](this.panel.getValues(),{success:this.onCreateRequest,failure:this.onRequestFail,scope:this})},onCreateRequest:function(){this.clearStatusBusy();if(Ext.isFunction(this.onScheduleCreate)){this.onScheduleCreate()}this.close()},onRequestFail:function(d,c,a){this.clearStatusBusy();var b=SYNO.SDS.VideoStation2.Error.getDTVErrorString(d);this.getMsgBox().alert(this.title,b,function(){if(406===d.code){var e=new SYNO.SDS.VideoStation2.Setting.Dialog({owner:this,initActiveTab:1});SYNO.SDS.VideoStation2.SettingController.get().openDialog(e)}},this)}});Ext.define("SYNO.SDS.VideoStation2.CreateScheduleDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",tuner:null,channel:null,program:null,constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getChannelTitleConfig(b),this.getProgramFields(b),this.getRepeatCheckboxConfig(b),this.getRepeatFields(b)]};this.callParent([Ext.apply(a,b)])},isValid:function(){return this.getForm().isValid()},setValues:function(a){if(Ext.isDefined(a.end_date)){if(a.end_date==="1"){a.end_date="never"}else{a.end_date_day=a.end_date;a.end_date="day"}}this.getForm().setValues(a);if(Ext.isDefined(a.duration)){this.syncDuration(this.durationField)}if(Ext.isDefined(a.isweekly)){this.weekdayStatusField.setReadOnly(!a.isweekly)}},getValues:function(){var a=this.getForm().getValues();a.is_repeat=a.is_repeat==="true";a.tuner=parseInt(a.tuner,10);a.id=this.channel.id;a.channel_name=this.channel.title;a.tuner=this.tuner;if(a.is_repeat){a.isweekly=a.isweekly==="true";a.end_date=(a.end_date==="never")?"1":a.end_date_day;if(Ext.isArray(a.weekdaystatus)){a.weekdaystatus=a.weekdaystatus.join()}delete a.end_date_day}if(this.program){delete a.is_repeat}delete a.end_time;return a},getChannelTitleConfig:function(a){var b=a.channel||this.channel;return[{xtype:"syno_vs_displayfield",value:b.title,itemId:"display_channel_name",fieldLabel:_VST("schedule","channel")}]},getProgramFields:function(e){if(!this.programFields){var c=e.program||this.program;var f=!!c;var d=new Date();var a=f?new Date(c.start_time*1000):null;var b=function(h){var g=h.match(/^(\d{2}):(\d{2})$/);if(!g){return String.format(_VST("schedule","format_error"),"hh:mm")}if(parseInt(g[1],10)>23){return _VST("schedule","hour_exceed")}if(parseInt(g[2],10)>59){return _VST("schedule","minute_exceed")}return true};this.programFields=[new SYNO.SDS.VideoStation2[f?"DisplayField":"TextField"]({name:"title",itemId:"title",fieldLabel:_VST("programguide","title"),allowBlank:false,value:f?c.title:""}),new SYNO.SDS.VideoStation2.TextField({name:"description",itemId:"description",fieldLabel:_VST("programguide","description"),value:(f)?c.description:"",hidden:f}),new SYNO.ux.CompositeField({fieldLabel:_T("common","start"),itemId:"start_date_time",hidden:f,items:[this.startDayField=new SYNO.SDS.VideoStation2.DateField({name:"start_date",itemId:"start_date",hideLabel:true,editable:false,flex:1,format:"Y-m-d",minValue:(f)?a:d,value:(f)?a:d,validator:function(g){g=Date.parseDate(g,this.format);return(g.valueOf()>=Date.parseDate(d.format("Ymd"),"Ymd").valueOf())?true:_VST("repeat","repeat_endday_error")},listeners:{scope:this,change:this.confineRepeatDay}}),this.startTimeField=new SYNO.SDS.VideoStation2.TextField({xtype:"syno_vs_textfield",name:"start_time",itemId:"start_time",hideLabel:true,allowBlank:false,flex:1,value:(f)?c.start_time:d.format("H:i"),validator:(f)?null:b,listeners:{scope:this,change:this.syncDuration}})]}),this.endTimeField=new SYNO.SDS.VideoStation2.TextField({xtype:"syno_vs_textfield",itemId:"end_time",name:"end_time",fieldLabel:String.format("{0} (hh:mm)",_VST("schedule","end")),value:d.add(Date.MINUTE,30).format("H:i"),validator:(f)?null:function(h){var g=b(h);if(true!==g){return g}if(this.startTimeField.getValue()===h){return _VST("schedule","time_conflict")}return true}.createDelegate(this),hidden:f,listeners:{scope:this,change:this.syncDuration}}),this.durationField=new SYNO.SDS.VideoStation2.TextField({name:"duration",itemId:"duration",fieldLabel:String.format("{0} (hh:mm)",_VST("schedule","duration")),value:(f)?c.duration:"00:30",validator:(f)?null:function(h){var g=b(h);if(true!==g){return g}if("00:00"===h){return false}return true},hidden:f,listeners:{scope:this,change:this.syncDuration}})]}return this.programFields},getRepeatCheckboxConfig:function(b){var a=b.program||this.program;var c=!!a;return[{xtype:"syno_vs_checkbox",name:"is_repeat",itemId:"is_repeat",boxLabel:_VST("action","repeat_record"),listeners:{scope:this,check:function(e,d){this.getRepeatFields().each(function(f){f.setDisabled(!d)});this.endDateDayField.setDisabled(!this.endDateRadio.getValue()||!d)}},checked:c,hidden:c}]},getRepeatFields:function(d){if(!this.repeatFields){var b=d.program||this.program;var e=!!b;var c=new Date();var a=e?new Date(b.start_time*1000):null;this.repeatFields=[new SYNO.SDS.VideoStation2.ComboBox({name:"isweekly",itemId:"isweekly",fieldLabel:_VST("repeat","repeat"),displayField:"display",valueField:"value",indent:(e)?0:1,value:true,disabled:!e,store:this.getRepeatWeeklyStore(),listeners:{scope:this,select:function(f){if(f.getValue()){this.weekdayStatusField.setReadOnly(false);this.weekdayStatusField.removeAllItems()}else{this.weekdayStatusField.setValue("1,1,1,1,1,1,1");this.weekdayStatusField.setReadOnly(true)}}}}),this.weekdayStatusField=new SYNO.SDS.VideoStation2.CreateScheduleDialog.WeekdayStatus({name:"weekdaystatus",itemId:"weekdaystatus",fieldLabel:_VST("repeat","repeat_data"),indent:(e)?0:1,mustHaveDay:(e)?a.getDay():c.getDay(),disabled:!e,listeners:{scope:this,valuechanged:this.doLayout}}),new SYNO.ux.CompositeField({fieldLabel:_VST("repeat","end_day"),itemId:"end_date_never",indent:(e)?0:1,disabled:!e,items:[this.neverEndDateRadio=new SYNO.SDS.VideoStation2.Radio({name:"end_date",itemId:"end_date",inputValue:"never",boxLabel:_VST("repeat","repeat_never"),checked:true})]}),new SYNO.ux.CompositeField({indent:(e)?0:1,disabled:!e,items:[this.endDateRadio=new SYNO.SDS.VideoStation2.Radio({name:"end_date",itemId:"end_date",inputValue:"day",boxLabel:_VST("repeat","repeat_on"),listeners:{scope:this,check:function(g,f){this.endDateDayField.setDisabled(!f)}}}),this.endDateDayField=new SYNO.SDS.VideoStation2.DateField({name:"end_date_day",itemId:"end_date_day",hideLabel:true,editable:false,format:"Y-m-d",disabled:true,minValue:(e)?a:c,value:(e)?a:c,validator:function(f){f=Date.parseDate(f,this.endDateDayField.format);return(f.valueOf()>=this.startDayField.getValue().valueOf())?true:_VST("repeat","repeat_endday_error")}.createDelegate(this)})]})]}return this.repeatFields},getRepeatWeeklyStore:function(){this.repeatWeeklyStore=this.weeklyStore||new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:[[true,_VST("repeat","repeat_weekly")],[false,_VST("repeat","repeat_daily")]]});return this.repeatWeeklyStore},syncDuration:function(d){if(!Ext.isEmpty(this.startTimeField.getActiveError())||!Ext.isEmpty(this.endTimeField.getActiveError())||!Ext.isEmpty(this.durationField.getActiveError())){return}var b,a,c;b=Date.parseDate(this.startTimeField.getValue(),"H:i");if(d.itemId==="duration"){c=Date.parseDate(this.durationField.getValue(),"H:i");a=b.add(Date.HOUR,c.getHours()).add(Date.MINUTE,c.getMinutes());this.endTimeField.setValue(a.format("H:i"))}else{a=Date.parseDate(this.endTimeField.getValue(),"H:i");if(a.valueOf()<b.valueOf()){a=a.add(Date.DAY,1)}c=Date.parseDuration(a.getElapsed(b)/1000);c=new Date(0,0,0,c.hours||0,c.minutes||0);this.durationField.setValue(c.format("H:i"))}},confineRepeatDay:function(a){if(!Ext.isEmpty(a.getActiveError())){return}this.weekdayStatusField.setMustHaveDay(a.getValue().getDay())}});Ext.define("SYNO.SDS.VideoStation2.CreateScheduleDialog.WeekdayStatus",{extend:"SYNO.SDS.VideoStation2.SuperBox",mustHaveDay:null,constructor:function(b){var a={valueField:"value",displayField:"display",triggerAction:"all",mode:"local",minChars:1,allowQueryAll:true,editable:false,grow:true,typeAhead:true,allowAddNewData:true,addNewDataOnBlur:true,value:b.mustHaveDay,store:this.getStore()};this.callParent([Ext.apply(a,b)]);this.mon(this,"beforeremoveitem",this.onBeforeRemoveItem,this)},getStore:function(){if(!this.store){var a=Array.apply(null,{length:7}).map(function(b,c){return[c,SYNO.SDS.VideoStation2.DTVUtil.getWeekdayString(c)]});this.store=new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:a})}return this.store},getValue:function(){var a=Array.apply(null,{length:7}).map(function(){return 0});this.items.each(function(b){a[b.value]=1});return a.join(this.valueDelimiter)},setValue:function(b){if(this.readOnly){return}this.isSettingValue=true;if(!Ext.isNumber(b)){b=b.split(this.valueDelimiter).map(function(d,c){return(d==="1")?c:null}).filter(function(c){return c!==null}).join(this.valueDelimiter)}var a=this.callParent([b]);this.isSettingValue=false;return a},setMustHaveDay:function(a){this.mustHaveDay=a;this.setValue(a)},onBeforeRemoveItem:function(b,a){return this.isSettingValue||this.mustHaveDay!==a}});Ext.define("SYNO.SDS.VideoStation2.SignalMenu",{extend:"SYNO.ux.Menu",tuners:[],ITEM_HEIGHT:34,constructor:function(b){var a={cls:"syno-vs2-signal-panel",items:[this.getPanel()],defaultOffsets:[34,0],listeners:{scope:this,beforeshow:function(){var d=this.getItems();var c=d.length*this.ITEM_HEIGHT;this.getPanel().loadData(d);this.getPanel().getDataView().setHeight(c);this.setHeight(c)}}};this.callParent([Ext.apply(a,b)])},getItems:function(){var a=[];Ext.each(this.tuners,function(b){var c=b.get("signal");if(!Ext.isNumber(c)||c<=0){return true}c=Ext.min([100,Math.ceil(c/20)*20]);a.push([b.get("id"),b.get("title"),c])},this);return a},setupTuner:function(a){if(!Ext.isArray(a)){return}this.tuners=a},getPanel:function(){if(this.panel){return this.panel}this.panel=new SYNO.SDS.VideoStation2.SignalPanel();return this.panel}});Ext.define("SYNO.SDS.VideoStation2.SignalPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={width:190,layout:"fit",autoHeight:true,items:this.getDataView()};this.callParent([Ext.apply(a,b)])},getDataView:function(){if(this.dataview){return this.dataview}this.dataview=new Ext.DataView({itemSelector:"div.item",emptyText:"No tuner",itemId:"dataview",cls:"syno-vs2-dtv-signalpanel-dataview",store:this.getStore(),tpl:new Ext.XTemplate('<tpl for=".">','<div class="item">','<div class="title">{values.title}</div>','<div class="image-{values.signal}"></div>',"</div>","</tpl>",{compiled:true,disableFormats:true})});return this.dataview},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.ArrayStore({data:[],idIndex:0,autoDestroy:true,fields:["id","title","signal"]});this.addManagedComponent(this.store);return this.store},loadData:function(a){this.getStore().loadData(a,false)}});Ext.define("SYNO.SDS.VideoStation2.StreamingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(a){a=a||{};this.currentTunerID=a.currentTunerID;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={width:600,height:_S("is_admin")?300:250,minWidth:300,minHeight:250,title:_VST("programguide","broadcast_streaming"),layout:"fit",items:[this.getFormPanel()],buttons:[{xtype:"syno_vs_button",text:_VST("action","play"),btnStyle:"blue",hidden:!SYNO.SDS.VideoStation2.Capability.get().ableToPlayDTV(),scope:this,handler:this.onPlayStreaming},{xtype:"syno_vs_button",text:_VST("streaming","streaming_stop"),btnStyle:"red",hidden:!SYNO.SDS.VideoStation2.Capability.get().ableToControlDTV(),scope:this,handler:this.onStopStreaming},{xtype:"syno_vs_button",text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:27,scope:this,handler:this.close}]};return Ext.apply(b,a)},show:function(){this.setStatusBusy({text:_T("common","loading")});this.basePort=9025;SYNO.SDS.VideoStation2.OP.get().listTuner({additional:"channel_status"},{scope:this,success:this.getTunerListDone});this.callParent(arguments)},getTunerListDone:function(g,f,d){if(!g.tuners||0===g.tuners.length){this.clearStatusBusy();return}var b=this.formPanel.tunerCombo.getStore();var c=[];Ext.each(g.tuners,function(j,h,i){if(j&&j.additional&&j.additional.channel_status&&j.additional.channel_status.streaming_id&&-1!==j.additional.channel_status.streaming_id){if(!Ext.isDefined(this.currentTunerID)){this.currentTunerID=j.id}c.push([j.id,j.title])}},this);var a=this.basePort;if(Ext.isDefined(this.currentTunerID)){a=this.currentTunerID%16+a}var e=String.format(_VST("streaming","streaming_description"),a);this.formPanel.getForm().findField("description").setValue(e);b.loadData(c,false);b.sort("display","ASC");if(Ext.isDefined(this.currentTunerID)){this.formPanel.tunerCombo.setValue(this.currentTunerID)}else{this.formPanel.tunerCombo.setValue(0)}SYNO.SDS.VideoStation2.OP.get().getDTVChannel({tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},{scope:this,success:this.getChannelDone})},getChannelDone:function(c,b,a){if(c&&c.streaming_id){SYNO.SDS.VideoStation2.OP.get().getDTVChannelInfo({id:c.streaming_id,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},{scope:this,success:this.getChannelInfoDone})}else{this.clearStatusBusy()}},getChannelInfoDone:function(d,c,a){var b=this.formPanel.form.findField("channel_name");this.ChannelName=d.channels[0].title;b.setValue(Ext.util.Format.htmlEncode(d.channels[0].title));SYNO.SDS.VideoStation2.OP.get().getDTVStatistic({},{scope:this,success:this.getStatistic})},getStatistic:function(f,e,b){var c=this.formPanel.getForm();var d=c.findField("watchnumber");var a=(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0);Ext.each(f.statistics,function(i,g,h){if(a===i.id){d.setValue(i.brocasting_count);return}},this);this.setupStreamURL()},setupStreamURL:function(){var d=this.formPanel.getForm();var c=d.findField("url");var b=window.location.port;var e=window.location.protocol;var a=e+"//"+window.location.hostname;this.clearStatusBusy();a+=!Ext.isEmpty(b)?(":"+b):"";a+="/VideoStation/livestreaming/"+(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0);c.setValue(a);c.selectText(0,c.length)},onStopStreaming:function(){this.setStatusBusy({text:_T("common","loading")});SYNO.SDS.VideoStation2.OP.get().liveStreaming({id:-1,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},{scope:this,success:this.onStopStreamingDone})},onStopStreamingDone:function(c,b,a){this.clearStatusBusy();this.close()},onPlayStreaming:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayerWithDTV({tuner:this.currentTunerID})},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation2.StreamingFormpanel({module:this})}return this.formPanel}});Ext.define("SYNO.SDS.VideoStation2.StreamingFormpanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.module=a.module;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=Ext.apply({frame:false,border:false,labelWidth:160,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[this.tunerCombo=new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dongle","tuner2"),name:"tuner",triggerAction:"all",resizable:false,store:this.createTunerStore(),editable:false,displayField:"display",valueField:"value",value:"no_dongle",mode:"local",listeners:{scope:this,select:this.onChangeTuner}}),{xtype:"syno_vs_displayfield",itemId:"channel_name",name:"channel_name",htmlEncode:false,fieldLabel:_VST("schedule","channel")},{xtype:"syno_vs_displayfield",itemId:"watchnumber",name:"watchnumber",fieldLabel:_VST("streaming","streaming_watch")},{xtype:"syno_vs_textfield",itemId:"url",name:"url",fieldLabel:_VST("streaming","streaming_url"),width:350,readOnly:true,cls:"selectabletext allowDefCtxMenu"},{xtype:"syno_vs_displayfield",name:"description",value:String.format(_VST("streaming","streaming_description"),"9025~9040"),hidden:!_S("is_admin")}]},a);return b},createTunerStore:function(){this.defTunerValue=["no_dongle",_VST("error","no_dtv_dongle")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defTunerValue]});this.addManagedComponent(a);return a},onChangeTuner:function(e,a,c){this.module.setStatusBusy({text:_T("common","loading")});this.module.currentTunerID=a.data.value;var b=this.module.basePort;if(Ext.isDefined(this.module.currentTunerID)){b=this.module.currentTunerID%16+b}var d=String.format(_VST("streaming","streaming_description"),b);this.getForm().findField("description").setValue(d);SYNO.SDS.VideoStation2.OP.get().getDTVChannel({tuner:Ext.isDefined(this.module.currentTunerID)?this.module.currentTunerID:0},{scope:this.module,success:this.module.getChannelDone})}});Ext.define("SYNO.SDS.VideoStation2.DTVController",{statics:{RECORDING_CREATE:"record",RECORDING_CANCEL:"cancel_recording",RECORDING_CREATE_REPEAT:"repeat_record",RECORDING_CREATE_SCHEDULE:"user_define_schedule",signalMenu:null,getRecordingActions:function(){return[SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE,SYNO.SDS.VideoStation2.DTVController.RECORDING_CANCEL,SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE_REPEAT,SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE_SCHEDULE]},loadDTV:function(){SYNO.SDS.VideoStation2.DTV.get().loadDTV()},doRecordingAction:function(d,b,c,a,e){switch(d){case SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE:return SYNO.SDS.VideoStation2.DTVController.createRecording(b,c,a,e);case SYNO.SDS.VideoStation2.DTVController.RECORDING_CANCEL:return SYNO.SDS.VideoStation2.DTVController.cancelRecording(b,c,a,e);case SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE_REPEAT:return SYNO.SDS.VideoStation2.DTVController.createRepeatRecording(b,c,a,e);case SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE_SCHEDULE:return SYNO.SDS.VideoStation2.DTVController.createSchedule(b,c,e);default:SYNO.Debug.error(String.format("unknown record action {0}",d))}},createRecording:function(b,c,a,d){SYNO.SDS.VideoStation2.OP.get().createRecording({tuner:b,id:c.id,start_time:a.start_time},{success:d,failure:function(h,g,f){var e=SYNO.SDS.VideoStation2.Error.getDTVErrorString(h);SYNO.SDS.VideoStation2.Window.getMsgBox().alert(this.title,e,function(){if(406===h.code){var i=new SYNO.SDS.VideoStation2.Setting.Dialog({initActiveTab:1});SYNO.SDS.VideoStation2.SettingController.get().openDialog(i)}},this)}})},cancelRecording:function(b,c,a,d){SYNO.SDS.VideoStation2.OP.get().deleteSchedule({tuner:b,channel_id:c.id,id:a.start_time},{success:d})},createRepeatRecording:function(b,d,a,e){var c=new SYNO.SDS.VideoStation2.CreateScheduleDialog({tuner:b,channel:d,program:a,onScheduleCreate:e});c.open()},createSchedule:function(a,c,d){var b=new SYNO.SDS.VideoStation2.CreateScheduleDialog({tuner:a,channel:c,onScheduleCreate:d});b.open()},showSignalMenu:function(a){var b=SYNO.SDS.VideoStation2.DTVController.getSignalMenu();b.setupTuner(SYNO.SDS.VideoStation2.DTV.get().getTuner());b.showAt([a.getX()-89,a.getY()+30])},getSignalMenu:function(){if(!SYNO.SDS.VideoStation2.DTVController.signalMenu){SYNO.SDS.VideoStation2.DTVController.signalMenu=new SYNO.SDS.VideoStation2.SignalMenu()}return SYNO.SDS.VideoStation2.DTVController.signalMenu},showStreamDialog:function(){var a=new SYNO.SDS.VideoStation2.StreamingDialog();a.show()}}});Ext.define("SYNO.SDS.VideoStation2.FilterController",{singleton:true,togggleFilter:function(a,b){if(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){SYNO.SDS.VideoStation2.VideoListController.toAllCategory()}SYNO.SDS.VideoStation2.Filter.get().toggleFilter(a,b)}});Ext.define("SYNO.SDS.VideoStation2.HistoryController",{statics:{instance:null,EVENT_HISTORYCONTROLLER_INITED:"history_controller_inited",get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.HistoryController.instance)){SYNO.SDS.VideoStation2.HistoryController.instance=new SYNO.SDS.VideoStation2.HistoryController()}return SYNO.SDS.VideoStation2.HistoryController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments);this.restore_order=[SYNO.SDS.VideoStation2.Constant.CATEGORY,SYNO.SDS.VideoStation2.Constant.LIBRARY,SYNO.SDS.VideoStation2.Constant.PLAYLIST,SYNO.SDS.VideoStation2.Constant.RECORDING_SPECIFIC,SYNO.SDS.VideoStation2.Constant.FOLDER,SYNO.SDS.VideoStation2.Constant.DTV,SYNO.SDS.VideoStation2.Constant.FILTER,SYNO.SDS.VideoStation2.Constant.TVSHOW,SYNO.SDS.VideoStation2.Constant.VIDEO];this.mon(SYNO.SDS.VideoStation2.Hash.get(),SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.onHashChanged,this);this.currentHash=location.hash.substr(location.hash.indexOf("!")+1);Ext.EventManager.addListener(window,"hashchange",this.onWindowHashChange,this)},init:function(){if(""===location.hash.substr(2)){this.toDefaultPage()}else{this.onWindowHashChange()}this.fireEvent(SYNO.SDS.VideoStation2.HistoryController.EVENT_HISTORYCONTROLLER_INITED)},loadByURL:function(){if(!this.currentHash){return}var c=SYNO.SDS.VideoStation2.Hash.get();if(!c.setOptionsByURL(this.currentHash)){this.toDefaultPage();return}for(var a=0;a<this.restore_order.length;a++){if(SYNO.SDS.VideoStation2.Constant.LIBRARY===this.restore_order[a]&&!c.getOptions().hasOwnProperty(SYNO.SDS.VideoStation2.Constant.LIBRARY)){SYNO.SDS.VideoStation2.Controller.intoHomePage();continue}try{this.restoreSubject(this.restore_order[a])}catch(b){c.resetData();this.toDefaultPage();break}}},toDefaultPage:function(){this.onHashChanged(true);SYNO.SDS.VideoStation2.Controller.intoHomePage()},restoreSubject:function(h){var j=SYNO.SDS.VideoStation2.Hash.get().getOptions();if(!j.hasOwnProperty(h)){return}switch(h){case SYNO.SDS.VideoStation2.Constant.CATEGORY:SYNO.SDS.VideoStation2.Category.get().selectCategory(j[h]);break;case SYNO.SDS.VideoStation2.Constant.LIBRARY:if(SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(j[h]).type!==SYNO.SDS.VideoStation2.Constant.PLAYLIST&&j.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.PAGE)){SYNO.SDS.VideoStation2.View.get().setPage(parseInt(j[SYNO.SDS.VideoStation2.Constant.PAGE],10),true)}SYNO.SDS.VideoStation2.Controller.switchLibrary(j[h]);break;case SYNO.SDS.VideoStation2.Constant.PLAYLIST:if(SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(j[SYNO.SDS.VideoStation2.Constant.LIBRARY]).type===SYNO.SDS.VideoStation2.Constant.PLAYLIST&&j.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.PAGE)){SYNO.SDS.VideoStation2.View.get().setPage(j[SYNO.SDS.VideoStation2.Constant.PAGE],true)}var e=j[h];SYNO.SDS.VideoStation2.Controller.intoPosterView(h,e.id,e.title);break;case SYNO.SDS.VideoStation2.Constant.RECORDING_SPECIFIC:if(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL===j[SYNO.SDS.VideoStation2.Constant.CATEGORY]){SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.CHANNEL,null,j[h])}else{if(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM===j[SYNO.SDS.VideoStation2.Constant.CATEGORY]){SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PROGRAM,null,j[h])}}break;case SYNO.SDS.VideoStation2.Constant.FOLDER:if(h===j[SYNO.SDS.VideoStation2.Constant.CATEGORY]){var a=SYNO.SDS.VideoStation2.Folder.get();a.resetData();Ext.each(j[h],function(k,i,l){if(i===l.length-1){SYNO.SDS.VideoStation2.Controller.intoPosterView(h,k.id,k.pathTitle);return false}a.selectFolder(k.id,k.pathTitle)})}break;case SYNO.SDS.VideoStation2.Constant.DTV:SYNO.SDS.VideoStation2.Controller.switchDTV(j[h]);break;case SYNO.SDS.VideoStation2.Constant.TVSHOW:if(j.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.SEASON)){var d=j[h];if(d.hasOwnProperty("library_id")){SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary("tvshow-"+d.library_id)}SYNO.SDS.VideoStation2.TVShow.get().setDefaultSeason(j[SYNO.SDS.VideoStation2.Constant.SEASON]);SYNO.SDS.VideoStation2.Controller.intoTVShow({id:d.id})}break;case SYNO.SDS.VideoStation2.Constant.VIDEO:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(j[h]);break;case SYNO.SDS.VideoStation2.Constant.FILTER:var b=null;var g=function(k,i,l){SYNO.SDS.VideoStation2.FilterController.togggleFilter(b,{key:k,value:k})};var c=j[h];for(var f in c){if(c.hasOwnProperty(f)){if(f===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){SYNO.SDS.VideoStation2.Controller.setFilter(f,c[f]);continue}b=f;Ext.each(c[f],g)}}break;default:break}},onHashChanged:function(b){var a=SYNO.SDS.VideoStation2.Hash.get().getPath();this.currentHash=a;var d=location.hash.substr(2);var c=false;if(location.hash===""){c=true}else{if(d!==a){c=b}else{return}}window.history[c?"replaceState":"pushState"]({},"","#!"+a)},onWindowHashChange:function(){if(!location.hash){return}if(!Ext.isEmpty(SYNO.SDS.WindowMgr.getActiveAppWindow().modalWin)||!Ext.isEmpty(SYNO.SDS.AppMgr.getByAppName("SYNO.VideoController2.Application"))){this.onHashChanged();return}this.currentHash=location.hash.substr(2);SYNO.SDS.VideoStation2.Hash.get().disarm();this.mun(SYNO.SDS.VideoStation2.Hash.get(),SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.onHashChanged,this);this.loadByURL();this.mon(SYNO.SDS.VideoStation2.Hash.get(),SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.onHashChanged,this);SYNO.SDS.VideoStation2.Hash.get().arm()}});Ext.define("SYNO.SDS.VideoStation2.VideoListProxy",{statics:{copyStoreParams:function(d){SYNO.Assert(Ext.isObject(d),["unexpceted params",d]);var a={};var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){Ext.apply(a,SYNO.SDS.VideoStation2.Sort.get().getSortOption());Ext.apply(a,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()})}else{if(b===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){var c=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(c,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());Ext.apply(a,c);Ext.apply(a,SYNO.SDS.VideoStation2.Sort.get().getSortOption())}else{Ext.apply(a,SYNO.SDS.VideoStation2.Category.get().getSortOption())}}if(b===SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER){Ext.apply(a,{id:SYNO.SDS.VideoStation2.Folder.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Library.get().getCurrentType()})}else{Ext.apply(a,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})}a.offset=d.offset||0;a.limit=d.limit||100;return a}},constructor:function(c){this.callParent(arguments);var b=SYNO.SDS.VideoStation2.Library.get().getCurrentType();var a=b===SYNO.SDS.VideoStation2.Constant.TVSHOW;var f=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER;var e=c.baseParams;this.videolist=c.videolist;if(Ext.isFunction(c.toVideos)&&(!a||f)){var d=f?SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER:b;d=d===SYNO.SDS.VideoStation2.Constant.PLAYLIST?SYNO.SDS.VideoStation2.Constant.PLAYLIST_VIDEOLIST:d;this.pageSize=e.limit;this.lowBound=e.offset;this.upBound=e.offset+e.limit;this.toVideos=c.toVideos;this.totalCount=c.totalCount;this.store=new SYNO.SDS.VideoStation2.Stores[d]({baseParams:e,listeners:{scope:this,load:function(h,g,i){var k=i.params;var j=this.toVideos(g);this.totalCount=h.getTotalCount();if(this.lowBound>k.offset){Array.prototype.unshift.apply(this.videolist,j);this.lowBound=k.offset}else{Array.prototype.push.apply(this.videolist,j);this.upBound=k.offset+this.pageSize}SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.NEXT_PREV_BTN)}}})}},expandLeft:function(){if(Ext.isObject(this.store)&&this.lowBound>0){this.store.load({params:{offset:this.lowBound-this.pageSize}})}},expandRight:function(){if(Ext.isObject(this.store)&&this.upBound<this.totalCount-1){this.store.load({params:{offset:this.upBound}})}}});Ext.define("SYNO.SDS.VideoStation2.LNBDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",tuner:null,satellite:null,lnb:null,onLNBEdit:Ext.emptyFn,constructor:function(b){var d=b.lnb||this.lnb;var c=b.satellite||this.satellite;var a={layout:"fit",title:c,width:690,height:580,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:(d)?_T("common","alt_edit"):_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancel})],listeners:{scope:this,afterrender:this.onAfterRender},items:[this.panel=new SYNO.SDS.VideoStation2.LNBDialog.Panel({owner:this,lnb:d})]};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER,this.onRequestDefaultTransponder,this)},maybeApplyLNB:function(){var a=this.panel.getValues();if(!a.lnb){this.maybeApplyTransponder();return}if(this.lnb){SYNO.SDS.VideoStation2.OP.get().editLNB(Ext.apply({tuner:this.tuner,satellite:this.satellite,lnb:this.lnb.name},a.lnb),{scope:this,success:this.onApplyLNB,failure:this.onRequestFail})}else{SYNO.SDS.VideoStation2.OP.get().createLNB(Ext.apply({tuner:this.tuner,satellite:this.satellite},a.lnb),{scope:this,success:this.onApplyLNB,failure:this.onRequestFail})}},maybeApplyTransponder:function(){var a=this.panel.getValues();if(!a.transponder){this.onLNBEditSuccess();return}SYNO.SDS.VideoStation2.OP.get().saveTransponder({tuner:this.tuner,satellite:this.satellite,lnb:this.lnb.name,tps:Ext.encode(a.transponder)},{scope:this,success:this.onLNBEditSuccess,failure:this.onRequestFail})},onOKBtn:function(){if(!this.panel.isValid()){return}if(!this.panel.isDirty()){return}this.setStatusBusy();this.maybeApplyLNB()},onCancel:function(){if(!this.lnb||!this.panel.isDirty()){this.close();return}this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if(a==="yes"){this.close()}},this)},onAfterRender:function(){this.setStatusBusy();if(this.lnb){SYNO.SDS.VideoStation2.OP.get().getTransponder({tuner:this.tuner,satellite:this.satellite,lnb:this.lnb.name},{scope:this,success:this.onTransponderLoad,failure:this.onRequestFail})}else{SYNO.SDS.VideoStation2.OP.get().getDefaultTransponder({tuner:this.tuner,satellite:this.satellite,lnb:"add_lnb"},{scope:this,success:this.onDefaultTransponderLoad,failure:this.onRequestFail})}},onRequestDefaultTransponder:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().getDefaultTransponder({tuner:this.tuner,satellite:this.satellite,lnb:this.lnb?this.lnb.name:"add_lnb"},{scope:this,success:this.onDefaultTransponderLoad,failure:this.onRequestFail})},onTransponderLoad:function(c,b,a){this.clearStatusBusy();this.panel.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD,c.tps)},onDefaultTransponderLoad:function(c,b,a){this.clearStatusBusy();this.panel.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD,c.tps)},onApplyLNB:function(c,b,a){this.lnb=this.lnb||{};this.lnb.name=b.name;this.maybeApplyTransponder()},onLNBEditSuccess:function(){this.clearStatusBusy();if(Ext.isFunction(this.onLNBEdit)){this.onLNBEdit(this.lnb.name)}this.close()},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getDTVErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.LNBDialog.Panel",{extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(b){var a={activeTab:0,items:[this.lnbPanel=new SYNO.SDS.VideoStation2.LNBDialog.LNBPanel({lnb:b.lnb,owner:b.owner,itemId:"lnb"}),this.transponderPanel=new SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel({owner:b.owner,itemId:"transponder"})]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.transponderPanel,[SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER]);this.transponderPanel.relayEvents(this,[SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD])},isValid:function(){var a=true;var b;this.items.each(function(c){if(!(b=c.isValid())){this.setActiveTab(c)}a=b&&a},this);return a},isDirty:function(){var a=false;this.items.each(function(b){return !(a=(a||b.isDirty()))},this);return a},getValues:function(){var a={};this.items.each(function(b){if(b.isDirty()){a[b.itemId]=b.getValues()}},this);return a}});Ext.define("SYNO.SDS.VideoStation2.LNBDialog.LNBPanel",{statics:{PROFILE:[["C-BAND","C-BAND",5150,0,0],["C-MULTI","C-MULTI",5150,5750,0],["DBS","DBS","11250",0,0],["ENHANCED","ENHANCED",9750,0,0],["STANDARD","STANDARD",10000,0,0],["UNIVERSAL","UNIVERSAL",9750,10600,11700],["customize",_T("common","customize"),0,0,0]],DISEQC:[[0],[1],[2],[3]]},extend:"SYNO.SDS.VideoStation2.FormPanel",lnb:null,constructor:function(c){var e=c.lnb||this.lnb;var a=this.getProfileStore(e);var d=e?a.getById(e.profile):a.getAt(0);var b={title:"LNB",defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_fieldset",itemId:"lnb",title:"LNB",items:[{xtype:"syno_vs_textfield",fieldLabel:_VST("dtvsscan","lnb_name"),name:"name",itemId:"name",allowBlank:false,readOnly:e?e.preset:false,value:e?e.name:""}]},{xtype:"syno_vs_fieldset",itemId:"general_settings",title:_VST("dtvsscan","general_setting"),items:[{xtype:"syno_vs_combobox",fieldLabel:_VST("dtvsscan","lnb_type"),name:"profile",itemId:"profile",displayField:"display",valueField:"profile",allowBlank:false,readOnly:e?e.preset:false,value:d.id,store:a,listeners:{scope:this,select:this.onProfileSelect}},{xtype:"syno_vs_numberfield",fieldLabel:"Low Band (MHZ)",name:"low",itemId:"low",allowBlank:false,allowDecimals:false,allowNegative:false,readOnly:e?e.preset:false,disabled:d.id!=="customize",value:d.get("low"),validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator},{xtype:"syno_vs_numberfield",fieldLabel:"High Band (MHZ)",name:"high",itemId:"high",allowBlank:false,allowDecimals:false,allowNegative:false,readOnly:e?e.preset:false,disabled:d.id!=="customize",value:d.get("high"),validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator},{xtype:"syno_vs_numberfield",fieldLabel:String.format("{0} (MHZ)",_VST("dtvsscan","switch")),name:"switch",itemId:"switch",allowBlank:false,allowDecimals:false,allowNegative:false,readOnly:e?e.preset:false,disabled:d.id!=="customize",value:d.get("switch"),validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator}]},{xtype:"syno_vs_fieldset",itemId:"advance_setttings",title:_VST("dtvsscan","adv_setting"),items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("dtvsscan","use_diseqc"),name:"enablediseqc",itemId:"enablediseqc",checked:e?e.enablediseqc:false},{xtype:"syno_vs_combobox",fieldLabel:"DiSEqC",name:"diseqc",itemId:"diseqc",displayField:"value",valueField:"value",allowBlank:false,indent:1,disabled:e?!e.enablediseqc:true,value:e?e.diseqc:0,store:this.getDiSEqCStore()}]}]};this.callParent([Ext.apply(b,c)]);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enablediseqc",["diseqc"])]},getProfileStore:function(b){if(!this.profileStore){this.profileStore=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["profile","display","low","high","switch"],data:SYNO.SDS.VideoStation2.LNBDialog.LNBPanel.PROFILE});if(b&&b.profile==="customize"){var a=this.profileStore.getById("customize");a.data.low=b.low;a.data.high=b.high;a.data["switch"]=b["switch"]}}return this.profileStore},getDiSEqCStore:function(){this.diseqcStore=this.diseqcStore||new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value"],data:SYNO.SDS.VideoStation2.LNBDialog.LNBPanel.DISEQC});return this.diseqcStore},isValid:function(){return this.getForm().isValid()},isDirty:function(){return this.getForm().isDirty()},getValues:function(){return this.getForm().getValues()},onProfileSelect:function(c){var b=this.getProfileStore();var a=b.getById(c.getValue());this.getForm().setValues(a.data);this.getForm().findField("low").setDisabled(a.id!=="customize");this.getForm().findField("high").setDisabled(a.id!=="customize");this.getForm().findField("switch").setDisabled(a.id!=="customize")}});Ext.define("SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel",{statics:{POLARISATION:[["H"],["V"]],EVENT_TRANSPONDER_LOAD:"transponderload",EVENT_DEFAULT_TRANSPONDER_LOAD:"defaulttransponderload",EVENT_REQUEST_DEFAULT_TRANSPONDER:"requestdefaulttransponder",convertTransponderID:function(a){return String.format("{0}-{1}-{2}",a.freq,a.sr,a.pol)}},extend:"SYNO.SDS.VideoStation2.EditorGridPanel",constructor:function(b){var a={title:_VST("dtvsscan","transponder"),enableHdMenu:false,enableColumnMove:false,tbar:new SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar(),viewConfig:{trackResetOnLoad:false},plugins:[this.getCheckedColumn()],store:this.getStore(),colModel:new Ext.grid.ColumnModel({columns:[this.getCheckedColumn(),{header:String.format("{0} (MHz)",_VST("video_info","frequency")),dataIndex:"freq",sortable:true,editable:true,editor:new SYNO.SDS.VideoStation2.NumberField({allowBlank:false,allowDecimals:false,allowNegative:false,validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator})},{header:String.format("{0} (Ksym/s)",_VST("dtvsscan","symbol_rate")),dataIndex:"sr",editable:true,editor:new SYNO.SDS.VideoStation2.NumberField({allowBlank:false,allowDecimals:false,allowNegative:false})},{header:_VST("dtvsscan","polarisation"),dataIndex:"pol",editable:true,editor:new SYNO.SDS.VideoStation2.ComboBox({displayField:"value",valueField:"value",allowBlank:false,store:this.getPolarisationStore()})}]}),selModel:new Ext.grid.RowSelectionModel({listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,validateedit:this.onValidateEdit,activate:this.onActivate}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD);this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD);this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER);this.mon(this,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD,this.onTransponderLoad,this);this.mon(this,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD,this.onDefaultTransponderLoad,this);this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_ACTION,this.onTransponderAction,this)},getCheckedColumn:function(){this.checkedColumn=this.checkedColumn||new SYNO.SDS.VideoStation2.EnableColumn({dataIndex:"checked",width:50,align:"center",menuDisabled:true,enableFastSelectAll:true});return this.checkedColumn},getStore:function(){this.store=this.store||new Ext.data.JsonStore({autoDestroy:true,fields:["freq","sr","pol","checked",{name:"tpid",type:"string",convert:function(b,a){return SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.convertTransponderID(a)}}],sortInfo:{field:"freq",direction:"asc"}});return this.store},getPolarisationStore:function(){this.polarisationStore=this.polarisationStore||new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value"],data:SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.POLARISATION});return this.polarisationStore},askConfirmDelete:function(a){this.owner.getMsgBox().confirmDelete("",_VST("dtvsscan","delete_cfrmrm"),function(b){if(b==="yes"){a.call(this)}},this)},buildRecordFromData:function(a){return new (this.getStore().recordType)(Ext.apply(a,{tpid:SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.convertTransponderID(a)}))},addTransponder:function(){var c=this.getStore();var d={freq:0,sr:0,pol:"H",checked:true};var a=this.buildRecordFromData(d);var b=c.findExact("tpid",a.get("tpid"));if(-1!==b){this.startEditing(b,1)}else{c.addSorted(a);a.markDirty();this.getView().refresh();this.startEditing(c.indexOf(a),1)}},deleteTransponder:function(){var a=this.getSelectionModel().getSelected();if(!a){return}this.askConfirmDelete(this.doDeleteTransponder)},doDeleteTransponder:function(){var a=this.getSelectionModel().getSelected();if(!a){return}this.getStore().remove(a)},loadDefaultTransponder:function(){this.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER)},isValid:function(){return true},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getValues:function(){var a=this.getStore();a.sort("freq","ASC");return a.data.items.map(function(b){return{freq:b.data.freq,sr:b.data.sr,pol:b.data.pol,checked:b.data.checked}})},onActivate:function(){this.getView().refresh()},onTransponderLoad:function(a){this.getStore().loadData(a);this.oriValue=this.getValues()},onDefaultTransponderLoad:function(a){this.getStore().loadData(a)},onRowSelectionChange:function(a){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_CHANGE,(a.getSelected()||{}).data)},onValidateEdit:function(c){var d=SYNO.Util.copy(c.record.data);var b=this.getStore();d[c.field]=c.value;var a=this.buildRecordFromData(d);if(-1!==b.findExact("tpid",a.get("tpid"))){return false}c.record.set("tpid",a.get("tpid"));c.record.commit()},onTransponderAction:function(a){switch(a){case SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_ADD:return this.addTransponder();case SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_DELETE:return this.deleteTransponder();case SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_LOAD_DEFAULT:return this.loadDefaultTransponder()}}});Ext.define("SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar",{statics:{EVENT_TRANSPONDER_ACTION:"transponderaction",EVENT_TRANSPONDER_CHANGE:"transponderchange",ACTION_ADD:"add",ACTION_DELETE:"delete",ACTION_LOAD_DEFAULT:"loaddefault"},extend:"SYNO.ux.Toolbar",constructor:function(b){var a={items:[this.addBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","add"),itemId:SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_ADD,scope:this,handler:this.onTransponderAction}),this.deleteBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),itemId:SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_DELETE,scope:this,handler:this.onTransponderAction,disabled:true}),this.loadDefaultBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("dtvsscan","apply_default"),itemId:SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_LOAD_DEFAULT,scope:this,handler:this.onTransponderAction})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_ACTION);this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_CHANGE);this.mon(this,SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_CHANGE,this.onTransponderChange,this)},onTransponderAction:function(a){this.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_ACTION,a.itemId)},onTransponderChange:function(a){this.deleteBtn.setDisabled(!a)}});Ext.define("SYNO.SDS.VideoStation2.SatelliteDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",onSatelliteEdit:Ext.emptyFn,tuner:null,satellite:null,constructor:function(b){var c=b.satellite||this.satellite;var a={layout:"fit",title:(c)?_VST("dtvsscan","edit_satellite"):_VST("dtvsscan","add_satellite"),width:400,height:130,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:(c)?_T("common","alt_edit"):_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancel})],items:[this.panel=new SYNO.SDS.VideoStation2.SatelliteDialog.Panel(b)]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){if(!this.panel.isValid()){return}if(!this.panel.isDirty()){this.close();return}this.setStatusBusy();if(this.satellite){SYNO.SDS.VideoStation2.OP.get().editSatellite(Ext.apply({tuner:this.tuner,satellite:this.satellite},this.panel.getValues()),{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})}else{SYNO.SDS.VideoStation2.OP.get().createSatellite(Ext.apply({tuner:this.tuner},this.panel.getValues()),{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})}},onCancel:function(){if(!this.satellite||!this.panel.isDirty()){this.close();return}this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if(a==="yes"){this.close()}},this)},onRequestSuccess:function(c,b,a){this.clearStatusBusy();if(Ext.isFunction(this.onSatelliteEdit)){this.onSatelliteEdit(b.name)}this.close()},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getDTVErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.SatelliteDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_textfield",fieldLabel:_VST("dtvsscan","satellite_name"),name:"name",itemId:"name",allowBlank:false,value:b.satellite||""}]};this.callParent([Ext.apply(a,b)])},isValid:function(){return this.getForm().isValid()},isDirty:function(){return this.getForm().isDirty()},getValues:function(){return this.getForm().getValues()}});Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",progress:null,tuner:null,onChannelScaned:Ext.emptyFn,constructor:function(c){var b=c.tuner||this.tuner;switch(b.type){case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_QPSK:this.panel=new SYNO.SDS.VideoStation2.ChannelScanDialog.SatellitePanel({owner:this,tuner:b});break;case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_QAM:case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_OFDM:case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_ATSC:this.panel=new SYNO.SDS.VideoStation2.ChannelScanDialog.DTVPanel({owner:this,tuner:b});break;case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_HDHOMERUN:this.panel=new SYNO.SDS.VideoStation2.ChannelScanDialog.HDHomeRunPanel({owner:this,tuner:b});break;default:SYNO.Assert(false,String.format("unknown tuner type {0}",b.type));break}var a={layout:"fit",width:650,height:240,cls:"channel-scan-dialog",title:_VST("action","channelscan"),buttons:[this.scanBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","scan"),btnStyle:"blue",scope:this,handler:this.onScanBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.panel],listeners:{scope:this,show:{fn:this.onDialogShow,single:true}}};this.callParent([Ext.apply(a,c)]);this.mon(this.panel,SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING,this.onPanelLoading,this);this.mon(this.panel,SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED,this.onPanelLoaded,this);this.mon(this.panel,SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOAD_ERROR,this.onPanelLoadError,this)},startScan:function(){this.progress=0;SYNO.SDS.VideoStation2.Util.maskLoadingMsg(this,_VST("action","scanning"),true);this.clearPollingTask(true);SYNO.SDS.VideoStation2.OP.get()[this.panel.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_START)](Ext.apply({tuner:this.tuner.id},this.panel.getValues()),{scope:this,success:this.onStartScan,failure:this.onRequestFail})},clearPollingTask:function(b,a){if(this.pollingTask){if(b){if(a){SYNO.SDS.VideoStation2.Util.maskLoadingMsg(this,_T("common","saving"),true)}SYNO.SDS.VideoStation2.OP.get()[this.panel.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STOP)]({tuner:this.tuner.id},{scope:this,success:a?this.onRequestSuccess:Ext.emptyFn,failure:a?this.onRequestFail:Ext.emptyFn})}this.pollingTask.stop();this.pollingTask.remove();this.pollingTask=null}},onStartScan:function(){this.pollingTask=SYNO.SDS.VideoStation2.OP.pollingRequest(this.panel.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STATUS),{tuner:this.tuner.id},{scope:this,success:this.onPollingScanStatus,failure:this.onPollingFail},5000);this.getMsgBox().show({title:_VST("action","scanning"),progress:true,closable:true,hideDlg:false,width:310,minWidth:250,buttons:Ext.MessageBox.CANCEL,fn:this.onCloseScanProgress,scope:this})},onPollingScanStatus:function(e,d,b){var c=this.panel.getProgressMsg(e);var a=this.getMsgBox().updateProgress(e.progress/100,"",c);this.progress=e.progress;if(100===e.progress){a.fbButtons.cancel.setText(_T("common","close"));a.setTitle(_VST("dtv","title_scan_done"));this.clearPollingTask()}},onCloseScanProgress:function(a){if(this.progress===100&&Ext.isFunction(this.onChannelScaned)){this.onChannelScaned()}this.progress=null;if(this.pollingTask){this.clearPollingTask(true,true);return}this.close()},onDialogShow:function(){this.panel.loadConfig()},onScanBtn:function(){if(!this.panel.isValid()){return}if(!Ext.isEmpty(this.panel.getOriConfig())){this.getMsgBox().confirm(this.title,_VST("action","rescan_message"),function(a){if("yes"===a){this.startScan()}},this)}else{this.startScan()}},onCancelBtn:function(){this.clearPollingTask(true);this.close()},onPanelLoading:function(){this.setStatusBusy()},onPanelLoaded:function(){this.clearStatusBusy()},onPanelLoadError:function(a){this.setStatusError({text:a||_T("common","error_system")})},onRequestSuccess:function(){SYNO.SDS.VideoStation2.Util.unmask(this)},onRequestFail:function(c,b,a){SYNO.SDS.VideoStation2.Util.unmask(this);this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation2.Error.getDTVErrorString(c))},onPollingFail:function(c,b,a){this.clearPollingTask(true);this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation2.Error.getDTVErrorString(c))}});Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.Panel",{statics:{EVENT_LOADING:"loading",EVENT_LOADED:"loaded",EVENT_LOAD_ERROR:"loaderror",EVENT_SAT_CHANGE:"satchange",EVENT_LNB_CHANGE:"lnbchange",OP_GETCONFIG:"getconfig",OP_START:"start",OP_STATUS:"status",OP_STOP:"stop"},extend:"SYNO.SDS.VideoStation2.FormPanel",tuner:null,constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING);this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOAD_ERROR);this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE);this.on(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,this.onUpdateSatelliteBtn,this);this.on(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,this.onUpdateLnbBtn,this)},isValid:function(){return this.getForm().isValid()},getValues:function(){return this.getForm().getValues()},getOriConfig:function(){return this.oriConfig},getOperation:function(a){switch(a){case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_GETCONFIG:return"getChannelScanConfig";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_START:return"startChannelScan";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STATUS:return"getChannelScanStatus";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STOP:return"stopChannelScan";default:SYNO.Assert(false,"unknown op")}},getProgressMsg:function(a){if(100===a.progress){return String.format("{0}<br />{1}",_VST("action","scanning_finish"),String.format(_VST("action","scan_finish_show"),a.scaned_count))}else{if((0!==a.scaned_count&&!a.service_name)||"(null)"===a.service_name||"null"===a.service_name){return String.format("{0}<br />{1}",_VST("action","unknown_channel"),String.format(_VST("action","scan_total_show"),a.scaned_count))}else{return String.format("{0}<br />{1}",a.service_name,String.format(_VST("action","scan_total_show"),a.scaned_count))}}},getTunerTitleFieldConfig:function(b){var a=b.tuner||this.tuner;return[{xtype:"syno_vs_displayfield",fieldLabel:_VST("dongle","tuner2"),name:"tuner",itemId:"tuner",value:a.title}]},getCountryCombo:function(){this.countryCombo=this.countryCombo||new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dtvtscan","country"),name:"country",itemId:"country",displayField:"value",valueField:"value",emptyText:_VST("action","select_country"),allowBlank:false,store:this.getCountryStore(),listeners:{scope:this,select:this.onCountryComboSelect}});return this.countryCombo},getRegionCombo:function(){this.regionCombo=this.regionCombo||new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dtvtscan","region"),name:"region",itemId:"region",displayField:"value",valueField:"value",emptyText:_VST("action","select_region"),allowBlank:false,store:this.getRegionStore()});return this.regionCombo},getSatelliteField:function(){this.satelliteField=this.satelliteField||new SYNO.ux.CompositeField({fieldLabel:_VST("dtvsscan","satellite"),itemId:"satellite",items:[this.getSatelliteCombo(),new SYNO.SDS.VideoStation2.Button({text:_T("common","add"),itemId:"add_sat_btn",scope:this,handler:this.onAddSatelliteBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","alt_edit"),itemId:"edit_sat_btn",disabled:true,scope:this,handler:this.onEditSatelliteBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),itemId:"del_sat_btn",disabled:true,scope:this,handler:this.onDeleteSatelliteBtn})]});return this.satelliteField},getSatelliteCombo:function(){this.satelliteCombo=this.satelliteCombo||new SYNO.SDS.VideoStation2.ComboBox({name:"satellite",itemId:"satellite",displayField:"name",valueField:"name",emptyText:_VST("dtvsscan","pls_select_satellite"),allowBlank:false,flex:1,store:this.getSatelliteStore(),listeners:{scope:this,select:this.onSatelliteComboSelect}});return this.satelliteCombo},getLNBField:function(){this.lnbField=this.lnbField||new SYNO.ux.CompositeField({fieldLabel:"LNB",itemId:"lnb",items:[this.getLNBCombo(),new SYNO.SDS.VideoStation2.Button({text:_T("common","add"),itemId:"add_lnb_btn",disabled:true,scope:this,handler:this.onAddLNBBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","alt_edit"),itemId:"edit_lnb_btn",disabled:true,scope:this,handler:this.onEditLNBBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),itemId:"del_lnb_btn",disabled:true,scope:this,handler:this.onDeleteLNBBtn})]});return this.lnbField},getLNBCombo:function(){this.lnbCombo=this.lnbCombo||new SYNO.SDS.VideoStation2.ComboBox({name:"lnb",itemId:"lnb",displayField:"name",valueField:"name",emptyText:_VST("dtvsscan","pls_select_lnb"),allowBlank:false,flex:1,store:this.getLNBStore(),listeners:{scope:this,select:this.onLNBComboSelect}});return this.lnbCombo},createOptionStore:function(){return new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value"]})},getCountryStore:function(){this.countryStore=this.countryStore||this.createOptionStore();return this.countryStore},getRegionStore:function(){this.regionStore=this.regionStore||this.createOptionStore();return this.regionStore},getSatelliteStore:function(){this.satelliteStore=this.satelliteStore||new Ext.data.JsonStore({autoDestroy:true,id:"name",fields:["name","preset"]});return this.satelliteStore},getLNBStore:function(){this.lnbStore=this.lnbStore||new Ext.data.JsonStore({autoDestroy:true,id:"name",fields:["name","preset","diseqc","enablediseqc","high","low","profile","switch","tp_count"]});return this.lnbStore},requestConfig:function(){SYNO.SDS.VideoStation2.OP.get()[this.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_GETCONFIG)]({tuner:this.tuner.id},{scope:this,success:this.onConfigLoad,failure:this.onRequestFail})},requestCountry:function(){SYNO.SDS.VideoStation2.OP.get().getChannelScanCountry({tuner:this.tuner.id},{scope:this,success:this.onCountryLoad,failure:this.onRequestFail})},requestRegion:function(a){SYNO.SDS.VideoStation2.OP.get().getChannelScanRegion({tuner:this.tuner.id,country:a},{scope:this,success:this.onRegionLoad,failure:this.onRequestFail})},requestSatellite:function(){SYNO.SDS.VideoStation2.OP.get().getSatelliteScanSatellite({tuner:this.tuner.id},{scope:this,success:this.onSatelliteLoad,failure:this.onRequestFail})},requestLNB:function(a){SYNO.SDS.VideoStation2.OP.get().getSatelliteScanLNB({tuner:this.tuner.id,satellite:a},{scope:this,success:this.onLNBLoad,failure:this.onRequestFail})},loadConfig:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING);this.requestConfig()},onRequestFail:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOAD_ERROR)},onCountryComboSelect:function(a){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING);this.requestRegion(a.getValue())},onSatelliteComboSelect:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING);this.requestLNB(b.getValue());this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,a)},onLNBComboSelect:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,a)},onConfigLoad:function(c,b,a){this.oriConfig=c},onUpdateSatelliteBtn:function(b){var a=this.getComponent("satellite").innerCt;if(Ext.isEmpty(b)||b.get("preset")){a.getComponent("edit_sat_btn").disable();a.getComponent("del_sat_btn").disable();this.getComponent("lnb").innerCt.getComponent("add_lnb_btn")[Ext.isEmpty(b)?"disable":"enable"]()}else{a.getComponent("edit_sat_btn").enable();a.getComponent("del_sat_btn").enable();this.getComponent("lnb").innerCt.getComponent("add_lnb_btn").enable()}},onUpdateLnbBtn:function(b){var a=this.getComponent("lnb").innerCt;if(Ext.isEmpty(b)||b.get("preset")){a.getComponent("edit_lnb_btn").disable();a.getComponent("del_lnb_btn").disable()}else{a.getComponent("edit_lnb_btn").enable();a.getComponent("del_lnb_btn").enable()}},onCountryLoad:Ext.emptyFn,onRegionLoad:Ext.emptyFn,onSatelliteLoad:Ext.emptyFn,onLNBLoad:Ext.emptyFn,onAddSatelliteBtn:Ext.emptyFn,onEditSatelliteBtn:Ext.emptyFn,onDeleteSatelliteBtn:Ext.emptyFn,onAddLNBBtn:Ext.emptyFn,onEditLNBBtn:Ext.emptyFn,onDeleteLNBBtn:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.DTVPanel",{extend:"SYNO.SDS.VideoStation2.ChannelScanDialog.Panel",constructor:function(b){var a={items:[this.getTunerTitleFieldConfig(b),this.getCountryCombo(),this.getRegionCombo()]};this.callParent([Ext.apply(a,b)])},onConfigLoad:function(c,b,a){this.callParent(arguments);if(c&&c.select_country&&c.select_region){this.getCountryStore().loadData([[c.select_country]]);this.getCountryCombo().setValue(c.select_country);this.getRegionStore().loadData([[c.select_region]]);this.getRegionCombo().setValue(c.select_region)}this.requestCountry()},onCountryLoad:function(f,e,b){var a=this.getCountryStore();var c=this.getCountryCombo();var d=c.getValue();if(!f||!f.country){a.clearData();c.clearValue();this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);return}f.country.sort();a.loadData(f.country.map(function(g){return[g]}));if(!a.getById(d)){c.clearValue();d=null}if(Ext.isEmpty(d)){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);return}this.requestRegion(d)},onRegionLoad:function(f,e,b){var a=this.getRegionStore();var d=this.getRegionCombo();var c=d.getValue();this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);if(!f||!f.region){a.clearData();d.clearValue();return}a.loadData(f.region.map(function(g){return[g]}));if(!a.getById(c)){d.clearValue();c=null}if(!c&&a.getCount()){d.setValue(a.getAt(0).get(d.valueField))}}});Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.HDHomeRunPanel",{extend:"SYNO.SDS.VideoStation2.ChannelScanDialog.DTVPanel",constructor:function(a){this.callParent(arguments)},getRegionCombo:function(){this.regionCombo=this.regionCombo||new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dtvtscan","model"),name:"region",itemId:"region",displayField:"value",valueField:"value",emptyText:_VST("dtvtscan","pls_select_model"),allowBlank:false,store:this.getRegionStore()});return this.regionCombo},getProgressMsg:function(b){var a=this.callParent(arguments);if(50<=b.progress&&100>b.progress){a=_VST("dtvtscan","scan_epging")}return a}});Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.SatellitePanel",{extend:"SYNO.SDS.VideoStation2.ChannelScanDialog.Panel",constructor:function(b){var a={items:[this.getTunerTitleFieldConfig(b),this.getSatelliteField(),this.getLNBField()]};this.callParent([Ext.apply(a,b)])},askConfirmDelete:function(a){this.owner.getMsgBox().confirmDelete("",_VST("dtvsscan","delete_cfrmrm"),function(b){if("yes"===b){a.call(this)}},this)},doDeleteSatellite:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING);SYNO.SDS.VideoStation2.OP.get().deleteSatellite({tuner:this.tuner.id,satellite:this.getSatelliteCombo().getValue()},{scope:this,success:this.onSatelliteDelete,failure:this.onRequestFail})},doDeleteLNB:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING);SYNO.SDS.VideoStation2.OP.get().deleteLNB({tuner:this.tuner.id,satellite:this.getSatelliteCombo().getValue(),lnb:this.getLNBCombo().getValue()},{scope:this,success:this.onLNBDelete,failure:this.onRequestFail})},getOperation:function(a){switch(a){case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_GETCONFIG:return"getSatelliteScanConfig";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_START:return"startSatelliteScan";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STATUS:return"getSatelliteScanStatus";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STOP:return"stopSatelliteScan";default:SYNO.Assert(false,"unknown op")}},onConfigLoad:function(c,b,a){this.callParent(arguments);if(c&&c.select_satellite&&c.select_lnb){this.getSatelliteStore().loadData([{name:c.select_satellite}]);this.getSatelliteCombo().setValue(c.select_satellite);this.getLNBStore().loadData([{name:c.select_lnb}]);this.getLNBCombo().setValue(c.select_lnb)}this.requestSatellite()},onSatelliteLoad:function(f,e,b){var a=this.getSatelliteStore();var d=this.getSatelliteCombo();var c=d.getValue();if(!f||!f.satellite){a.clearData();d.clearValue();this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);return}a.loadData(f.satellite);if(!a.getById(c)){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,null);this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,null);d.clearValue();c=null}else{this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,a.getById(c))}if(Ext.isEmpty(c)){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);return}this.requestLNB(c)},onLNBLoad:function(g,f,c){var b=this.getLNBStore();var e=this.getLNBCombo();var d=e.getValue();var a;this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);if(!g||!g.lnb){b.clearData();e.clearValue();return}b.loadData(g.lnb);if(!b.getById(d)){e.clearValue();d=null}if(!d&&b.getCount()){a=b.getAt(0);e.setValue(a.get(e.valueField))}else{a=b.getAt(b.findExact("name",d))}this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,a)},onAddSatelliteBtn:function(){var a=new SYNO.SDS.VideoStation2.SatelliteDialog({tuner:this.tuner.id,onSatelliteEdit:this.onSatelliteEdit.createDelegate(this)});a.open()},onEditSatelliteBtn:function(){var a=new SYNO.SDS.VideoStation2.SatelliteDialog({tuner:this.tuner.id,satellite:this.getSatelliteCombo().getValue(),onSatelliteEdit:this.onSatelliteEdit.createDelegate(this)});a.open()},onDeleteSatelliteBtn:function(){this.askConfirmDelete(this.doDeleteSatellite)},onAddLNBBtn:function(){var a=new SYNO.SDS.VideoStation2.LNBDialog({tuner:this.tuner.id,satellite:this.getSatelliteCombo().getValue(),onLNBEdit:this.onLNBEdit.createDelegate(this)});a.open()},onEditLNBBtn:function(){var c=this.getLNBCombo().getValue();var a=this.getLNBStore().getById(c);var b=new SYNO.SDS.VideoStation2.LNBDialog({tuner:this.tuner.id,satellite:this.getSatelliteCombo().getValue(),lnb:a.data,onLNBEdit:this.onLNBEdit.createDelegate(this)});b.open()},onDeleteLNBBtn:function(){this.askConfirmDelete(this.doDeleteLNB)},onSatelliteEdit:function(a){this.getSatelliteCombo().setValue(a);this.requestSatellite()},onSatelliteDelete:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);this.getLNBStore().clearData();this.getLNBCombo().clearValue();this.requestSatellite()},onLNBEdit:function(a){this.getLNBCombo().setValue(a);this.requestLNB(this.getSatelliteCombo().getValue())},onLNBDelete:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED);this.requestLNB(this.getSatelliteCombo().getValue())}});Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",tuner:null,onChannelEdited:Ext.emptyFn,constructor:function(b){var a={layout:"fit",width:500,height:600,cls:"edit-channel-dialog",title:_VST("action","channeledit"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.EditChannelDialog.Panel({owner:this,store:this.getStore()})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)])},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.channel();return this.store},getValues:function(){return this.getStore().data.items.map(function(a){return{id:a.get("id"),title:a.get("title"),scrambled:a.get("scrambled")}})},onBeforeDestroy:function(){this.getStore().destroy()},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().listChannel({offset:0,limit:-1,tuner:this.tuner},{scope:this,success:this.onListLoaded,failure:this.onRequestFail})},onListEdited:function(){if(Ext.isFunction(this.onChannelEdited)){this.onChannelEdited()}this.close()},onListLoaded:function(c,b,a){this.clearStatusBusy();this.getStore().loadData(c.channels);this.oriValues=this.getValues()},onRequestFail:function(){this.clearStatusBusy();this.setStatusError()},onOKBtn:function(){var a=this.getValues();if(SYNO.ux.Utils.checkObjectConsistency(a,this.oriValues)){this.onChannelEdited();return}this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().editChannel({tuner:this.tuner,channels:Ext.encode(a)},{scope:this,success:this.onListEdited,failure:this.onRequestFail})},onCancelBtn:function(){var a=this.getValues();if(SYNO.ux.Utils.checkObjectConsistency(a,this.oriValues)){this.close();return}this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(b){if("yes"===b){this.close()}},this)}});Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog.Panel",{extend:"SYNO.SDS.VideoStation2.EditorGridPanel",constructor:function(b){var a={enableHdMenu:false,enableColumnMove:false,enableDragDrop:true,ddGroup:Ext.id(),tbar:new SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar(),bbar:new SYNO.SDS.VideoStation2.EditChannelDialog.Bottombar(),viewConfig:{trackResetOnLoad:false},colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("schedule","channel"),dataIndex:"title",editable:true,renderer:function(f,c,e){var d=e.get("scrambled");f=Ext.util.Format.htmlEncode(f);if(!d){return f}else{return'<div class="syno-vs-channel-encrypted"></div>'+f}},editor:new SYNO.SDS.VideoStation2.TextField({allowBlank:false})}]}),selModel:new Ext.grid.RowSelectionModel({listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,afterrender:{fn:this.onAfterRender,single:true},beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditChannelDialog.Panel.EVENT_ACTION_DELETE);this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_ACTION_DELETE,this.onActionDelete,this)},doActionDelete:function(){var a=this.getSelectionModel().getSelections();a.each(function(b){this.store.remove(b)},this)},onAfterRender:function(){this.dropTarget=new Ext.dd.DropTarget(this.getEl(),{ddGroup:this.ddGroup,notifyDrop:this.onDrop.createDelegate(this)})},onBeforeDestroy:function(){if(this.dropTarget){this.dropTarget.destroy()}},onRowSelectionChange:function(a){var b=a.getSelections();this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_SELECTION_CHANGE,b)},onActionDelete:function(){this.owner.getMsgBox().confirmDelete("",_VST("action","remove_confirm"),function(a){if("yes"===a){this.doActionDelete()}},this)},onDrop:function(b,e,f){var c=this.getView();var a=c.findRowIndex(e.getTarget());if(!Ext.isNumber(a)){return}var d=f.selections;d.each(function(g){if(this.store.indexOf(g)<=a){--a}this.store.remove(g)},this);this.store.insert(a+1,d);this.getSelectionModel().selectRecords(d)}});Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_ACTION_DELETE:"actiondelete"},extend:"SYNO.ux.Toolbar",constructor:function(b){var a={items:[this.deleteBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),scope:this,handler:this.onDeleteBtn,disabled:true})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_ACTION_DELETE);this.mon(this,SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},onDeleteBtn:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_ACTION_DELETE)},onSelectionChange:function(a){this.deleteBtn.setDisabled(a.length===0)}});Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog.Bottombar",{extend:"SYNO.ux.Toolbar",constructor:function(b){var a={items:[{xtype:"tbtext",text:String.format('<span class="note">{0}:</span>{1}',_VST("common","hint"),_VST("action","drag_drop_channels"))}]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.EditScheduleDialog",{extend:"SYNO.SDS.VideoStation2.CreateScheduleDialog",onScheduleEdit:Ext.emptyFn,schedule:null,constructor:function(b){var c=b.schedule||this.schedule;var a={channel:{id:c.id,title:c.channel_name},listeners:{scope:this,show:this.onDialogShow}};if(!c.is_userdefine){a.program={title:c.title,description:c.description,start_time:c.start_time,duration:c.duration}}this.callParent([Ext.apply(a,b)])},onDialogShow:function(){this.setStatusBusy();var a={tuner:this.tuner,start_time:this.schedule.start_time};if(!this.schedule.is_userdefine){a.id=this.channel.id}SYNO.SDS.VideoStation2.OP.get()[this.schedule.is_userdefine?"getScheduleInfo":"getRepeatScheduleInfo"](a,{scope:this,success:this.onLoadSchedule,failure:this.onRequestFail})},onOKBtn:function(){if(!this.panel.isValid()){return}this.setStatusBusy();var a=this.panel.getValues();if(this.schedule.is_userdefine){Ext.apply(a,this.oriParams)}else{a={id:a.id,tuner:a.tuner,start_time:a.start_time,isweekly:a.isweekly,weekdaystatus:a.weekdaystatus,end_date:a.end_date}}SYNO.SDS.VideoStation2.OP.get()[this.schedule.is_userdefine?"editSchedule":"editRepeatSchedule"](a,{success:this.onEditRequest,failure:this.onRequestFail,scope:this})},onEditRequest:function(){this.clearStatusBusy();if(Ext.isFunction(this.onScheduleEdit)){this.onScheduleEdit()}this.close()},onLoadSchedule:function(d,c,b){this.clearStatusBusy();var a={title:d.title,description:d.description};if(this.schedule.is_userdefine){a.start_date=d.start_date;a.start_time=d.start_time;a.duration=d.duration;a.is_repeat=d.is_repeat;this.oriParams={orig_start_time:a.start_time,orig_start_date:a.start_date}}if(!this.schedule.is_userdefine||a.is_repeat){a.isweekly=SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE===SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus(this.schedule.status);a.end_date=d.end_date;a.weekdaystatus=d.weekdaystatus}this.panel.setValues(a)}});Ext.define("SYNO.SDS.VideoStation2.LiveStreamingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",tuner:null,channel:null,onLiveStreaming:Ext.emptyFn,constructor:function(c){var b=Ext.isNumber(c.tuner)?c.tuner:this.tuner;var a={layout:"fit",width:650,height:280,cls:"live-streaming-dialog",title:_VST("action","live_stream"),buttons:[this.playBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","play"),btnStyle:"blue",hidden:!SYNO.SDS.VideoStation2.Capability.get().ableToPlayDTV(),scope:this,handler:this.onPlayBtn}),this.closeBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","close"),scope:this,handler:this.onCloseBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.LiveStreamingDialog.Panel({tuner:b})],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,c)])},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().liveStreaming({id:this.channel,tuner:this.tuner},{scope:this,success:function(){this.clearStatusBusy();SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)},failure:this.onRequestFail})},onRequestFail:function(){this.clearStatusBusy();this.setStatusError()},onPlayBtn:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayerWithDTV({tuner:this.tuner})},onCloseBtn:function(){if(Ext.isFunction(this.onLiveStreaming)){this.onLiveStreaming()}this.close()}});Ext.define("SYNO.SDS.VideoStation2.LiveStreamingDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_displayfield",hideLabel:true,itemId:"desc_status",value:_VST("streaming","streaming_open_ok")},{xtype:"syno_vs_textfield",fieldLabel:_VST("streaming","streaming_url"),itemId:"url",value:SYNO.SDS.VideoStation2.DTVUtil.getStreamingURL(b.tuner),cls:"selectabletext",readOnly:true,selectOnFocus:true},{xtype:"syno_vs_displayfield",hideLabel:true,itemId:"desc_tip",value:String.format(_VST("streaming","streaming_description"),SYNO.SDS.VideoStation2.DTVUtil.getTunerPort(b.tuner)),hidden:!_S("is_admin")}]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.ChannelPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={tbar:new SYNO.SDS.VideoStation2.ChannelPanel.Toolbar(),cls:"channel-panel",layout:"border",width:200,items:[this.filter=new SYNO.SDS.VideoStation2.ChannelPanel.Filter({store:this.getStore(),margins:"0 12 12 12",itemId:"filter",region:"north"}),this.dataview=new SYNO.SDS.VideoStation2.ChannelPanel.DataView({store:this.getStore(),itemId:"list",region:"center"})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.channel();return this.store},resetListRequest:function(){if(this.listRequest){SYNO.SDS.VideoStation2.OP.abort(this.listRequest);this.listRequest=null}},loadList:function(){this.resetListRequest();this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.listRequest=SYNO.SDS.VideoStation2.OP.get().listChannel({offset:0,limit:-1,ishomepage:true,tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID()},{scope:this,success:this.onListLoaded,failure:this.onRequestFail})},onBeforeDestroy:function(){this.getStore().destroy();this.resetListRequest()},onActivate:function(){this.callParent(arguments);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);if(!SYNO.SDS.VideoStation2.Filter.get().hasKeyword()){this.onViewRefresh()}},onDeactivate:function(){this.callParent(arguments);this.resetListRequest();this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this)},onListLoaded:function(f,e,c){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);var b=this.getStore();b.loadData(f.channels);this.expand();if(SYNO.SDS.VideoStation2.Filter.get().hasKeyword()){SYNO.SDS.VideoStation2.Channel.get().clearChannel();return}var d=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();if(d&&!b.getById(d)){SYNO.SDS.VideoStation2.Channel.get().clearChannel();d=null}if(!d&&b.getCount()){var a=b.getAt(0);SYNO.SDS.VideoStation2.Channel.get().selectChannel(a.id,a.get("title"))}},onRequestFail:function(c,b,a){this.collapse();if(403===c.code){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN)}else{this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.OP.defaultFailureCallback(c,b,a)}},onViewRefresh:function(){switch(SYNO.SDS.VideoStation2.View.get().getView()){case SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE:this.collapse();break;case SYNO.SDS.VideoStation2.View.VIEW_DTV:this.loadList();break}}});Ext.define("SYNO.SDS.VideoStation2.ChannelPanel.Toolbar",{extend:"SYNO.ux.Toolbar",constructor:function(b){var a={cls:"channel-toolbar",items:[{xtype:"tbtext",text:_VST("schedule","channel")},"->",this.scanBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"scan",tooltip:_VST("action","channelscan"),scope:this,handler:this.onScanBtn}),{xtype:"tbspacer",width:12},this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",tooltip:_VST("action","channeledit"),scope:this,handler:this.onEditBtn})]};this.callParent([Ext.apply(a,b)])},onEditBtn:function(){var a=new SYNO.SDS.VideoStation2.EditChannelDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),onChannelEdited:SYNO.SDS.VideoStation2.Controller.refreshView});a.open()},onScanBtn:function(){var a=new SYNO.SDS.VideoStation2.ChannelScanDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentDTV(),onChannelScaned:SYNO.SDS.VideoStation2.Controller.refreshView});a.open()}});Ext.define("SYNO.SDS.VideoStation2.ChannelPanel.Filter",{extend:"SYNO.SDS.VideoStation2.TextFilter",constructor:function(b){var a={localFilter:true,localFilterField:"title"};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("channel-filter")})}});Ext.define("SYNO.SDS.VideoStation2.ChannelPanel.DataView",{extend:"SYNO.ux.FleXcroll.DataView",constructor:function(b){var a={cls:"channel-list",tpl:this.getTpl(),itemSelector:"div.item-wrap",listeners:{scope:this,click:this.onChannelClick}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.onChannelChange,this);this.mon(this.store,"datachanged",this.onChannelChange,this);this.mon(this.store,"load",this.onChannelChange,this)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div ext:qtip="{[this.doubleEncode(values.title)]}" class="item-wrap','<tpl if="this.isSelected(id)"> x-view-selected</tpl>','">','<tpl if="values.scrambled"><div class="x-view-scrambled"></div></tpl>','<tpl if="!values.scrambled && values.streaming"><div class="x-view-streaming"></div></tpl>',"{title:htmlEncode}","</div>","</tpl>",{isSelected:function(a){return a===SYNO.SDS.VideoStation2.Channel.get().getCurrentID()},doubleEncode:function(a){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a))}})},onChannelClick:function(e,a,d,c){var b=this.store.getAt(a);SYNO.SDS.VideoStation2.Filter.get().clearAllFilter();SYNO.SDS.VideoStation2.Channel.get().selectChannel(b.id,b.get("title"))},onChannelChange:function(){this.getNodes().each(function(d){Ext.fly(d).removeClass("x-view-selected")});var c=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();if(!c){return}var a=this.store.getById(c);if(!a){return}var b=this.getNode(a);if(!b){return}Ext.fly(b).addClass("x-view-selected")}});Ext.define("SYNO.SDS.VideoStation2.ViewCardPanel",{extend:"SYNO.ux.Panel",views:null,constructor:function(c){var a=c.views||this.views;var b={activeItem:null,layout:"card",items:Object.values(a)};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN);this.mon(this,"activate",this.onActivate,this);this.mon(this,"deactivate",this.onDeactivate,this);this.items.each(function(d){this.mon(d,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,function(e,f){if(d===this.layout.activeItem){this.onViewLoading(e,f)}},this);this.mon(d,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,function(){if(d===this.layout.activeItem){this.onViewLoaded()}},this);this.mon(d,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,function(e){if(d===this.layout.activeItem){this.onViewNoVideo(e)}},this);this.mon(d,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,function(e){if(d===this.layout.activeItem){this.onViewNoTuner(e)}},this);this.mon(d,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN,function(){if(d===this.layout.activeItem){this.onViewChannelScan()}},this)},this)},loadView:function(){var a=this.getItemByView();if(!a){this.clearActiveItem();return}var b=this.layout.activeItem;if(b!==a){this.layout.setActiveItem(a)}else{if(b){b.fireEvent("activate")}}},getItemByView:function(){var a=SYNO.SDS.VideoStation2.View.get().getView();return this.views[a]},clearActiveItem:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},onActivate:function(){this.loadView()},onDeactivate:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},onViewLoading:function(a,b){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,a,b)},onViewLoaded:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onViewNoVideo:function(a){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,a)},onViewNoTuner:function(a){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,a)},onViewChannelScan:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN)}});Ext.define("SYNO.SDS.VideoStation2.ViewDTV",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={cls:"view-dtv",tbar:new SYNO.SDS.VideoStation2.ViewDTV.Toolbar(),layout:"border",items:[this.dateSelector=new SYNO.SDS.VideoStation2.ViewDTV.DateSelector({store:this.getStore(),itemId:"date",region:"north"}),this.panel=new SYNO.SDS.VideoStation2.ViewDTV.Panel({store:this.getStore(),itemId:"program",region:"center"})],listeners:{beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.mon(this.panel,SYNO.SDS.VideoStation2.ViewDTV.Panel.EVENT_PROGRAM_CHANGE,this.onProgramChange,this);this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_RECORDING_ACTION,this.onRecordingAction,this);this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_UPDATE_PROGRAM_GUIDE,this.onUpdateProgramGuide,this)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.program();return this.store},loadChannel:function(){var a=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();if(!a&&!SYNO.SDS.VideoStation2.Filter.get().hasKeyword()){this.getStore().loadData([]);return}this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.clearRequests();if(a){this.programRequest=SYNO.SDS.VideoStation2.OP.get().listProgram({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),id:a,day:SYNO.SDS.VideoStation2.Channel.get().getCurrentDate().format("Ymd"),start:0,limit:-1},{scope:this,success:this.onListProgram,failure:this.onRequestFail});return}this.programRequest=SYNO.SDS.VideoStation2.OP.get().searchProgram(Ext.apply({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),offset:0,limit:-1},SYNO.SDS.VideoStation2.Filter.get().getKeywordOption()),{scope:this,success:this.onSearchProgram,failure:this.onRequestFail})},onListProgram:function(e,d,b){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.programRequest=null;SYNO.SDS.VideoStation2.Channel.get().setRemainDays(e.remain_days);var a=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();var c=SYNO.SDS.VideoStation2.Channel.get().getCurrentTitle();e.programs=e.programs.map(function(f){return Ext.apply(f,{id:String.format("{0}-{1}",a,f.start_time),channel_id:a,channel_name:c})});this.getStore().loadData(e.programs)},onSearchProgram:function(c,b,a){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.programRequest=null;c.results=c.results.map(function(d){return Ext.apply(d,{id:String.format("{0}-{1}",d.channel_id,d.start_time)})});this.getStore().loadData(c.results)},onStartPollingTunerInfo:function(){this.updateProgramGuideRequest=null;this.pollingTask=SYNO.SDS.VideoStation2.OP.pollingRequest("getTunerInfo",{id:SYNO.SDS.VideoStation2.DTV.get().getCurrentID()},{scope:this,success:this.onPollingTunerInfo,failure:this.onRequestFail},5000)},clearRequests:function(){if(this.programRequest){SYNO.SDS.VideoStation2.OP.abort(this.programRequest);this.programRequest=null}if(this.updateProgramGuideRequest){SYNO.SDS.VideoStation2.OP.abort(this.updateProgramGuideRequest);this.updateProgramGuideRequest=null}if(this.pollingTask){this.pollingTask.stop();this.pollingTask.remove();this.pollingTask=null}},onBeforeDestroy:function(){this.getStore().destroy()},onActivate:function(){this.callParent(arguments);this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.loadChannel,this);this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_DATE_CHANGE,this.loadChannel,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.loadChannel,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadChannel,this);this.loadChannel()},onDeactivate:function(){this.callParent(arguments);this.mun(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.loadChannel,this);this.mun(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_DATE_CHANGE,this.loadChannel,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.loadChannel,this);this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadChannel,this);this.clearRequests()},onProgramChange:function(a){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_PROGRAM_CHANGE,a)},onRecordingAction:function(c,a){var b={id:SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),title:SYNO.SDS.VideoStation2.Channel.get().getCurrentTitle()};SYNO.SDS.VideoStation2.DTVController.doRecordingAction(c,SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),b,a,SYNO.SDS.VideoStation2.Controller.refreshViewInfo)},onUpdateProgramGuide:function(){this.clearRequests();this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this,_VST("programguide","updating_epg"));this.updateProgramGuideRequest=SYNO.SDS.VideoStation2.OP.get().updateProgramGuide({id:SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID()},{scope:this,success:this.onStartPollingTunerInfo,failure:this.onRequestFail})},onPollingTunerInfo:function(c,b,a){if(!c||!c.tuners||c.tuners.status!=="ready"){return}this.clearRequests();this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.refreshViewInfo()},onRequestFail:function(d,c,a){this.clearRequests();this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);var b=SYNO.SDS.VideoStation2.Error.getDTVErrorString(d);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",b);this.getStore().removeAll()}});Ext.define("SYNO.SDS.VideoStation2.ViewDTV.Toolbar",{statics:{EVENT_PROGRAM_CHANGE:"programchange",EVENT_RECORDING_ACTION:"recordingaction",EVENT_UPDATE_PROGRAM_GUIDE:"updateprogramguide"},extend:"SYNO.ux.Toolbar",constructor:function(c){var a=SYNO.SDS.VideoStation2.DTVController.getRecordingActions().map(function(d){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getRecordingActionString(d),itemId:d,scope:this,handler:this.onRecordingAction})},this);var b={cls:"dtv-navbar",items:[this.recordingBtn=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"recording",tooltip:_VST("action","record"),disabled:true,menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:a,noicon:true})}),{xtype:"tbspacer",width:12},this.streamingBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"watched",tooltip:_VST("programguide","broadcast_streaming"),scope:this,handler:this.onStreamingBtn,disabled:true}),{xtype:"tbspacer",width:12},this.updateProgramGuideBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"refresh",tooltip:_VST("programguide","update_epg"),scope:this,handler:this.onUpdateProgramGuideBtn,disabled:true})]};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_PROGRAM_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_RECORDING_ACTION);this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_UPDATE_PROGRAM_GUIDE);this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.changeChannelState,this);this.mon(this,SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_PROGRAM_CHANGE,this.changeProgramState,this)},changeChannelState:function(){var a=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();this.recordingBtn.setDisabled(!a);this.streamingBtn.setDisabled(!a);this.updateProgramGuideBtn.setDisabled(!a)},changeProgramState:function(c){this.program=c;if(!Ext.isObject(c)){c={}}var b=this.recordingBtn.menu;var a=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(c.status);b.items.each(function(d){switch(d.itemId){case SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE:case SYNO.SDS.VideoStation2.DTVController.RECORDING_CREATE_REPEAT:d.setDisabled(Ext.isEmpty(a)||(a!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_NONE&&a!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_STREAMING));break;case SYNO.SDS.VideoStation2.DTVController.RECORDING_CANCEL:d.setDisabled(Ext.isEmpty(a)||(a!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_SCHEDULED&&a!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_RECORDING));break}})},onStreamingBtn:function(){var a=new SYNO.SDS.VideoStation2.LiveStreamingDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),channel:SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),onLiveStreaming:SYNO.SDS.VideoStation2.Controller.refreshViewInfo});a.open()},onUpdateProgramGuideBtn:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_UPDATE_PROGRAM_GUIDE)},onRecordingAction:function(a){this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_RECORDING_ACTION,a.itemId,this.program)}});Ext.define("SYNO.SDS.VideoStation2.ViewDTV.DateButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",statics:{EVENT_TEXT_CHANGE:"textchange"},constructor:function(b){var a={cls:"dtv-date",menu:new SYNO.ux.DateMenu({hideOnClick:false,focusOnSelect:false}),menuAlign:"t-b?"};this.callParent([Ext.apply(a,b)]);this.menu.addClass("syno-vs2-datefield-menu syno-ux-datefield-menu");this.mon(this.menu,"select",this.onMenuSelect,this);this.mon(this.menu,"show",this.onMenuShow,this);this.mon(this.menu,"hide",this.onMenuHide,this)},setText:function(b){var a=this.callParent(arguments);this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.DateButton.EVENT_TEXT_CHANGE);return a},setValue:function(a){if(!a){this.setText("");return}SYNO.SDS.VideoStation2.Channel.get().selectDate(a);this.menu.picker.setValue(a);this.setText(String.format("{0} ({1})",a.format("m/d"),SYNO.SDS.VideoStation2.DTVUtil.getWeekdayString(a.getDay())))},setMinMaxDate:function(a,b){this.menu.picker.minDate=a;this.menu.picker.maxDate=b},onMenuSelect:function(b,a){this.setValue(a);this.menu.hide()},onMenuShow:function(){this.focus()},onMenuHide:function(){this.focus(false,60)}});Ext.define("SYNO.SDS.VideoStation2.ViewDTV.DateSelector",{extend:"SYNO.ux.Panel",constructor:function(c){var a=c.store;var b={cls:"date-selector",layout:"hbox",height:36,layoutConfig:{align:"middle",pack:"center"},items:[this.prevBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"calendar_back",scope:this,handler:this.onPrevBtn}),new Ext.BoxComponent({width:80,height:36}),this.dateBtn=new SYNO.SDS.VideoStation2.ViewDTV.DateButton({}),new Ext.BoxComponent({width:80,height:36}),this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"calendar_next",scope:this,handler:this.onNextBtn})]};this.callParent([Ext.apply(b,c)]);this.mon(a,"load",this.onLoadStore,this);this.mon(this.dateBtn,SYNO.SDS.VideoStation2.ViewDTV.DateButton.EVENT_TEXT_CHANGE,this.doLayout,this)},onLoadStore:function(b){if(SYNO.SDS.VideoStation2.Filter.get().hasKeyword()){this.items.each(function(f){f.hide()});return}this.items.each(function(f){f.show()});var e=SYNO.SDS.VideoStation2.Channel.get().getRemainDays();if(!Ext.isNumber(e)){this.dateBtn.setValue(null);this.items.each(function(f){f.disable()});return}this.items.each(function(f){f.enable()});var d=SYNO.SDS.VideoStation2.Channel.get().getCurrentDate();var a=Date.parseDate(new Date().format("Ymd"),"Ymd");var c=a.add(Date.DAY,e-1);this.dateBtn.setValue(d);this.dateBtn.setMinMaxDate(a,c);this.prevBtn.setDisabled(d.valueOf()===a.valueOf());this.nextBtn.setDisabled(d.valueOf()===c.valueOf())},onPrevBtn:function(){var a=SYNO.SDS.VideoStation2.Channel.get().getCurrentDate().add(Date.DAY,-1);SYNO.SDS.VideoStation2.Channel.get().selectDate(a)},onNextBtn:function(){var a=SYNO.SDS.VideoStation2.Channel.get().getCurrentDate().add(Date.DAY,1);SYNO.SDS.VideoStation2.Channel.get().selectDate(a)}});Ext.define("SYNO.SDS.VideoStation2.ViewDTV.Panel",{statics:{EVENT_PROGRAM_CHANGE:"programchange"},extend:"SYNO.SDS.VideoStation2.GridPanel",constructor:function(b){var c=function(f,e,d){e.attr=String.format('ext:qtip="{0}"',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(f)));switch(SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(d.get("status"))){case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_PASS:e.css+="pass ";break}return Ext.util.Format.htmlEncode(f)};var a={cls:"dtv-grid",enableHdMenu:false,enableColumnMove:false,viewConfig:{trackResetOnLoad:false},colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"status",id:"status",width:50,fixed:true,resizable:false,renderer:SYNO.SDS.VideoStation2.DTVUtil.programStatusIconRenderer},{header:_VST("schedule","channel"),dataIndex:"channel_name",id:"channel_name",renderer:c,hidden:true},{header:_VST("schedule","schedule"),dataIndex:"schedule",id:"schedule",renderer:c},{header:_VST("programguide","title"),dataIndex:"title",id:"title",renderer:c},{header:_VST("programguide","description"),dataIndex:"description",id:"description",renderer:c},{header:_T("common","start"),dataIndex:"start_time",id:"start_time",renderer:function(e){var d=new Date(e*1000);e=String.format("{0} ({1})",d.format("Y/m/d H:i:s"),SYNO.SDS.VideoStation2.DTVUtil.getWeekdayString(d.getDay()));return c.apply(this,arguments)},hidden:true},{header:_VST("schedule","duration"),dataIndex:"duration",id:"duration",renderer:function(d){d=SYNO.SDS.VideoStation2.DTVUtil.durationFormatter(d);return c.apply(this,arguments)},hidden:true}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}})};this.callParent([Ext.apply(a,b)]);this.mon(this.store,"load",this.onLoadStore,this);this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Panel.EVENT_PROGRAM_CHANGE)},onLoadStore:function(){var b=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();var a=this.getColumnModel();a.setHidden(a.getIndexById("schedule"),b);a.setHidden(a.getIndexById("channel_name"),!b);a.setHidden(a.getIndexById("start_time"),!b);a.setHidden(a.getIndexById("duration"),!b);this.onRowSelectionChange(this.getSelectionModel())},onRowSelectionChange:function(a){this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Panel.EVENT_PROGRAM_CHANGE,(a.getSelected()||{}).data)}});Ext.define("SYNO.SDS.VideoStation2.ViewSchedule",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this._toolbar=new SYNO.SDS.VideoStation2.ViewSchedule.Toolbar();var a={cls:"view-schedule",layout:"fit",tbar:this._toolbar,items:[this.panel=new SYNO.SDS.VideoStation2.ViewSchedule.Panel({store:this.getStore()})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.ViewSchedule.Panel.EVENT_SCHEDULE_CHANGE,this.onScheduleChange,this);this.mon(this._toolbar,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_ACTION,this.onScheduleAction,this);this.mon(this._toolbar,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,this.onTunerComboLoad,this);this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,this.onDTVReload,this);this.panel.relayEvents(this._toolbar,[SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE])},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.schedule({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}});return this.store},editSchedule:function(b){if(!b){return}var a=new SYNO.SDS.VideoStation2.EditScheduleDialog({tuner:this.getCurrentTuner(),schedule:b,onScheduleEdit:SYNO.SDS.VideoStation2.Controller.refreshView});a.open()},deleteSchedule:function(b){if(!b||!Ext.isNumber(b.status)){return}this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);var a=SYNO.SDS.VideoStation2.DTVUtil.isScheduleStatusRepeatSchedule(b.status);SYNO.SDS.VideoStation2.OP.get()[a?"deleteRepeatSchedule":"deleteSchedule"]({tuner:this.getCurrentTuner(),channel_id:b.id,id:b.start_time},{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})},deletePassSchedule:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);SYNO.SDS.VideoStation2.OP.get().deletePassSchedule({tuner:this.getCurrentTuner()},{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})},getCurrentTuner:function(){return this._toolbar.getCurrentTuner()},onActivate:function(){this._toolbar.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_LOAD_TUNER);this._toolbar.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_ADJUST_COMBO)},onBeforeDestroy:function(){this.getStore().destroy()},onBeforeLoadStore:function(a,b){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);b.params.tuner=this.getCurrentTuner()},onLoadStore:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onScheduleChange:function(a){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_CHANGE,a)},onScheduleAction:function(a){var b=this.panel.getSelectedSchedule();switch(a){case SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_EDIT:return this.editSchedule(b);case SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE:return this.deleteSchedule(b);case SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE_PASS:return this.deletePassSchedule()}},onRequestSuccess:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.refreshView()},onRequestFail:function(d,c,a){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);var b=SYNO.SDS.VideoStation2.Error.getDTVErrorString(d);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",b)},onTunerComboLoad:function(a){if(a.length<=0){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,this)}},onDTVReload:function(d,b){var a=SYNO.SDS.VideoStation2.View.get().getView();var g=this._toolbar;var e=g.tunerCombo;var f=e.getValue();var c=false;if(a!==SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE){return}e.store.removeAll();Ext.iterate(b,function(h){if(h.get("id")===f){c=true}e.store.add(h)});if(!c){if(b.length<=0){e.clearValue();g._current_tuner=null;if(!Ext.isEmpty(f)){this.panel.store.removeAll();g.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,b)}}else{e.setValue(b[0].get("id"));this._toolbar.onTunerSelect(this._toolbar.tunerCombo,b[0]);g.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,b)}}}});Ext.define("SYNO.SDS.VideoStation2.ViewSchedule.Toolbar",{extend:"SYNO.ux.Toolbar",statics:{ACTION_LOAD_TUNER:"loadtuner",ACTION_ADJUST_COMBO:"adjustcombo",SCHEDULE_EDIT:"scheduleedit",SCHEDULE_DELETE:"scheduledelete",SCHEDULE_DELETE_PASS:"scheduledeletepass",EVENT_SCHEDULE_ACTION:"scheduleaction",EVENT_TUNER_LOADED:"tunerload",EVENT_SCHEDULE_CHANGE:"schedulechange",EVENT_TUNER_CHANGE:"tunerchange",COMBOBOX_WRAP_WIDTH:300},constructor:function(b){var a={cls:"schedule-navbar",items:[this.cancelBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"stop_recording",itemId:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE,tooltip:_VST("action","cancel_recording"),scope:this,handler:this.onScheduleAction,disabled:true}),{xtype:"tbspacer",width:12},this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",itemId:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_EDIT,tooltip:_VST("action","edit_repeat_schedule"),scope:this,handler:this.onScheduleAction,disabled:true}),{xtype:"tbspacer",width:12},this.deletePassBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"refresh",itemId:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE_PASS,tooltip:_VST("action","clear_pass_task"),scope:this,handler:this.onScheduleAction}),"->",new Ext.BoxComponent({cls:"dongle"}),{xtype:"tbspacer",width:8},this.tunerCombo=new SYNO.SDS.VideoStation2.ComboBox({width:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.COMBOBOX_WRAP_WIDTH,store:new SYNO.SDS.VideoStation2.DTVStore({appWindow:SYNO.SDS.VideoStation2.Window,autoDestroy:true,listeners:{scope:this,load:function(d,c,e){this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,c)}}}),valueField:"id",displayField:"title",listeners:{select:this.onTunerSelect,scope:this}})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_ACTION);this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED);this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_CHANGE,this.changeActionState,this);this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_LOAD_TUNER,this.loadTuner,this);this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_ADJUST_COMBO,this.adjustCombo,this)},changeActionState:function(b){var a=SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus((b||{}).status);this.cancelBtn.setDisabled(!b);this.editBtn.setDisabled(a!==SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE&&a!==SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE&&(a!==SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WAIT||!(b||{}).is_userdefine))},onScheduleAction:function(a){this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_ACTION,a.itemId)},onTunerSelect:function(c,b){var a=b.get("id");if(a===this._current_tuner){return}this._current_tuner=a;this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE)},loadTuner:function(){this.tunerCombo.getStore().load({callback:function(a){if(Ext.isEmpty(a)){return}this._current_tuner=a[0].get("id");this.tunerCombo.setValue(this._current_tuner);this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE)},scope:this})},adjustCombo:function(){this.tunerCombo.wrap.setWidth(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.COMBOBOX_WRAP_WIDTH)},getCurrentTuner:function(){return this._current_tuner}});Ext.define("SYNO.SDS.VideoStation2.ViewSchedule.Panel",{statics:{EVENT_SCHEDULE_CHANGE:"schedulechange"},extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:30,constructor:function(b){var a={enableHdMenu:false,enableColumnMove:false,cls:"schedule-grid",viewConfig:{trackResetOnLoad:false},bbar:this._paging=new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:b.store,displayInfo:true,showRefreshBtn:true}),colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"status",width:50,fixed:true,resizable:false,renderer:SYNO.SDS.VideoStation2.DTVUtil.scheduleStatusIconRenderer},{header:_VST("schedule","channel"),dataIndex:"channel_name"},{header:_VST("programguide","title"),dataIndex:"title"},{header:_VST("programguide","description"),dataIndex:"description"},{header:_VST("video_info","record_time"),dataIndex:"start",renderer:function(d){return d}},{header:_VST("schedule","duration"),dataIndex:"duration",renderer:SYNO.SDS.VideoStation2.DTVUtil.durationFormatter},{header:_VST("common","status"),dataIndex:"status",renderer:SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatusString}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Panel.EVENT_SCHEDULE_CHANGE);this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE,this.onTunerChanged,this)},getSelectedSchedule:function(){return(this.getSelectionModel().getSelected()||{}).data},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);this._paging.bindStore(this.store)},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);this._paging.bindStore(null)},onViewRefresh:function(){this._paging.doRefresh()},onRowSelectionChange:function(a){this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Panel.EVENT_SCHEDULE_CHANGE,(a.getSelected()||{}).data)},onTunerChanged:function(){this._paging.moveFirst()}});Ext.define("SYNO.SDS.VideoStation2.DTVNavigationPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={layout:"border",cls:"dtv-navigation",items:[this.channelPanel=new SYNO.SDS.VideoStation2.ChannelPanel({region:"west",collapsed:true}),this.cardPanel=new SYNO.SDS.VideoStation2.DTVNavigationCardPanel({region:"center"})]};this.callParent([Ext.apply(a,b)]);this.items.each(function(c){this.relayEvents(c,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN])},this)},getItemByView:function(){return this.cardPanel.getItemByView()}});Ext.define("SYNO.SDS.VideoStation2.DTVNavigationCardPanel",{extend:"SYNO.SDS.VideoStation2.ViewCardPanel",constructor:function(c){var a={};a[SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE]=new SYNO.SDS.VideoStation2.ViewSchedule({itemId:"schedule"});a[SYNO.SDS.VideoStation2.View.VIEW_DTV]=new SYNO.SDS.VideoStation2.ViewDTV({itemId:"dtv"});var b={views:a};this.callParent([Ext.apply(b,c)])}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryVisibilityDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){this.callback=b.callback||{};var a={title:_VST("library","edit"),width:400,height:580,minWidth:300,minHeight:280,resizable:true,layout:"fit",items:[this.getGridPanel(b)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}],listeners:{afterrender:{fn:function(){this.getGridPanel().fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid.EVENT_LOAD_LIBRARY)},scope:this}}};this.callParent([Ext.apply(a,b)])},getGridPanel:function(a){this._grid=this._grid||new SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid({});return this._grid},getVisibilityChange:function(){var a=[];Ext.iterate(this.getGridPanel().getChanges()||{},function(d,c,b){a.push({id:parseInt(d.split("-")[1],10),type:d.split("-")[0],visible:c})});return a},onApply:function(){var a=this.getVisibilityChange();if(Ext.isEmpty(a)){this.close();return}SYNO.SDS.VideoStation2.OP.get().setLibraryVisibility({visibility:a},{scope:this,success:function(){this.close();SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}})},onCancel:function(){if(Ext.isEmpty(this.getVisibilityChange())){this.close();return}SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("library","edit"),_T("common","confirm_lostchange"),this.close,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid",{extend:"SYNO.SDS.VideoStation2.EnableGrid",statics:{EVENT_LOAD_LIBRARY:"loadlibrary"},constructor:function(b){this._changes={};var a={autoExpandColumn:"title",plugins:[this.getVisibilityColumn()]};this.callParent([Ext.apply(a,b)]);this.mon(this.getStore(),"load",this.applyLocalChanges,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid.EVENT_LOAD_LIBRARY,this.loadLibrary,this)},confirm:function(c,b,d,a){SYNO.SDS.VideoStation2.SettingController.get().confirm(c,b,d,a)},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.LibraryStore({appWindow:SYNO.SDS.VideoStation2.Window});return this._store},getColumns:function(){this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:false},columns:[{align:"left",header:_VST("library","title"),dataIndex:"title",id:"title"},this.getVisibilityColumn()]});return this._cm},saveChanges:function(a){this._changes=this.getChanges();SYNO.SDS.VideoStation2.Util.applyCallback(a)},getVisibilityColumn:function(){this._visibility_column=this._visibility_column||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("library","visible"),dataIndex:"visible",width:150,id:"visible"});return this._visibility_column},getStoreChanges:function(){var a={};Ext.each(this.getStore().getModifiedRecords(),function(b){a[b.get("opid")]=b.get("visible")});return a},getChanges:function(){return Ext.apply(this._changes||{},this.getStoreChanges())},applyLocalChanges:function(b,a,c){if(!Ext.isObject(this._changes)){return}b.each(function(d){var e=d.get("opid");if(Ext.isDefined(this._changes[e])){d.set("visible",this._changes[e])}},this);b.commitChanges()},loadLibrary:function(){this.getPagingToolbar().moveFirst()}});Ext.define("SYNO.SDS.VideoStation2.MainList",{extend:"SYNO.ux.Panel",statics:{LIBRARY_PANEL_MIN_HEIGHT:150},constructor:function(b){var a={cls:"main-list",width:200,layout:"vbox",layoutConfig:{align:"stretch",pack:"start"},items:[this._library=new SYNO.SDS.VideoStation2.LibraryPanel({}),this._dtv=new SYNO.SDS.VideoStation2.DTVPanel({})],listeners:{resize:this.adjustLayout,scope:this}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DISABLE_DTV,this.showHideDTVPanel,this);this.mon(this._library,SYNO.SDS.VideoStation2.MainList.Event.LIBRARY_PANEL_RESIZE,this.adjustLayout,this);this.mon(this._dtv,SYNO.SDS.VideoStation2.MainList.Event.DTV_PANEL_RESIZE,this.adjustLayout,this)},adjustLayout:function(){var g=this.getEl().select(".library-panel .contentwrapper").elements[0];var c=this.getEl().select(".dtv-panel .contentwrapper").elements[0];if(!Ext.isDefined(g)){return}var b=this.getHeight();var f=g.getHeight();var e=c?c.getHeight():0;if(!Ext.isDefined(c)||!this._dtv.isVisible()){this._library.setHeight(b)}else{if(b>=f+e){this._library.setHeight(f);this._dtv.setHeight(e)}else{var a=Ext.max([b-e,SYNO.SDS.VideoStation2.MainList.LIBRARY_PANEL_MIN_HEIGHT]);var d=b-a;this._library.setHeight(a);this._dtv.setHeight(d)}}this.doLayout()},showHideDTVPanel:function(a){this._dtv[a?"hide":"show"]();this.adjustLayout()}});Ext.define("SYNO.SDS.VideoStation2.LibraryPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={cls:"library-panel",layout:"fit",items:[this.getDataview()]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.onLibraryLoad,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this)},getDataview:function(){if(!Ext.isObject(this.dataview)){this.dataview=new SYNO.SDS.VideoStation2.ListDataView({type:"library",store:SYNO.SDS.VideoStation2.Library.get().getLibraryStore(),listeners:{selectionchange:{buffer:100,scope:this,fn:this.onLibrarySelected}}})}return this.dataview},selectToCurrentLibrary:function(){var a=this.dataview.getStore();var b=a.findExact("opid",SYNO.SDS.VideoStation2.Library.get().cursor);if(b===-1){return}this.dataview.select(a.getAt(b),false,true)},onLibraryLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.MainList.Event.LIBRARY_PANEL_RESIZE);this.selectToCurrentLibrary()},onLibraryChanged:function(){if(SYNO.SDS.VideoStation2.Library.get().isDeactivated()){this.dataview.clearSelections()}else{this.selectToCurrentLibrary()}},onLibrarySelected:function(c,a){if(0===a.length){return}var b=this.getDataview().getRecord(a[0]);SYNO.SDS.VideoStation2.Controller.switchLibrary(b.get("opid"))}});Ext.define("SYNO.SDS.VideoStation2.DTVPanel",{extend:"SYNO.ux.Panel",blNeedRefresh:true,constructor:function(b){var a={cls:"dtv-panel",layout:"fit",items:[this.getDataview()]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,this.onDTVLoad,this);this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED,this.onDTVChanged,this)},getDataview:function(){if(!Ext.isObject(this.dataview)){this.dataview=new SYNO.SDS.VideoStation2.ListDataView({prepend_separator:true,type:"dtv",store:SYNO.SDS.VideoStation2.DTV.get().getDTVStore(),listeners:{selectionchange:{buffer:100,scope:this,fn:this.onDTVSelected}}})}return this.dataview},selectToCurrentDTV:function(c){var b=this.dataview.getStore();var a=b.getById(SYNO.SDS.VideoStation2.DTV.get().getCurrentID());if(!a){a=b.getAt(0)}this.blNeedRefresh=c;this.dataview.select(a,true,true)},onDTVLoad:function(f,d){this.fireEvent(SYNO.SDS.VideoStation2.MainList.Event.DTV_PANEL_RESIZE);var c=SYNO.SDS.VideoStation2.View.get().getView();var e=this.body.select(".signal-icon");var g=this.body.select(".streaming-icon");var b=0;var a=0;Ext.each(d,function(j){var i=j.get("signal");var h=j.get("additional").channel_status;if(Ext.isNumber(i)&&i>0){b++}if(-1!==h.streaming_id){a++}},this);if(b>0){e.removeClass("hide")}if(a>0){g.removeClass("hide")}if(c!==SYNO.SDS.VideoStation2.View.VIEW_DTV&&c!==SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE){return}this.selectToCurrentDTV(f)},onDTVChanged:function(){if(!Ext.isNumber(SYNO.SDS.VideoStation2.DTV.get().getCurrentID())){this.dataview.clearSelections()}else{this.selectToCurrentDTV(true)}},onDTVSelected:function(c,a){if(0===a.length||!this.blNeedRefresh){this.blNeedRefresh=true;return}var b=this.getDataview().getRecord(a[0]);SYNO.SDS.VideoStation2.Controller.switchDTV(b.get("id"))}});Ext.define("SYNO.SDS.VideoStation2.ListDataView",{extend:"SYNO.ux.FleXcroll.DataView",type:"",prepend_separator:false,onContainerClick:Ext.emptyFn,constructor:function(b){this.prepend_separator=(b||{}).prepend_separator||false;this.type=(b||{}).type||"library";var a={itemSelector:"dl.list-template",trackOver:false,selectedClass:"selected",overClass:"over",hideHeaders:true,singleSelect:true,cls:"dataview",tpl:this.getListTpl()};this.callParent([Ext.apply(a,b)])},onClick:function(g,f,d){var b=Ext.fly(f);if(b.hasClass("add")){var c=g.getTarget(this.itemSelector,this.getTemplateTarget());var a=this.getRecord(c);this.addFolderToLibrary(a)}else{if(b.hasClass("add-library")){this.addLibrary()}else{if(b.hasClass("edit-visibility")){this.editLibraryVisibility()}else{if(b.hasClass("signal-icon")){SYNO.SDS.VideoStation2.DTVController.showSignalMenu(b)}else{if(b.hasClass("streaming-icon")){SYNO.SDS.VideoStation2.DTVController.showStreamDialog()}else{this.callParent(arguments)}}}}}},onKeyUp:function(a){a.shiftKey=false;this.callParent(arguments)},onKeyDown:function(a){a.shiftKey=false;this.callParent(arguments)},onKeyRight:function(a){a.shiftKey=false;this.callParent(arguments)},onKeyLeft:function(a){a.shiftKey=false;this.callParent(arguments)},addFolderToLibrary:function(a){SYNO.SDS.VideoStation2.SettingController.get().launchFolderDialog(true,a.data)},addLibrary:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.LibraryDialog({owner:b.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD,callback:{fn:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}}});b.openDialog(a)},editLibraryVisibility:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.Setting.LibraryVisibilityDialog({owner:b.getActiveWindow()});b.openDialog(a)},getListTpl:function(){var b=this.type==="library";var d=['<dl class="title">',b?'{[this.getAddLibraryIcon(values)]}<div class="edit-visibility"></div>':"{[this.getDTVIcon()]}",'<dt><div>{[_VST("',this.type,'", "title")]}</div></dt>',"</dl>"].join("");var c=['<tpl for=".">','<dl class="list-template {[this.getHideDLClass(values.visible)]}" style="{[this.getItemDisplayStyle(values.display)]}">',b?"{[this.getAddFolderIcon(values)]}":"",'<dt><table cellspacing="0"><tbody><tr>','<td><div class="icon {[this.getIconClass(values)]}"></div></td>','<td><div class="text sds-ellipsis" ext:qtip="{[this.doubleEncode(values.title)]}">',"{title:htmlEncode}","</div></td>","</tr><tbody></table></dt>","</dl>","</tpl>"].join("");var a=new Ext.XTemplate(this.prepend_separator?'<div class="main-list-separator-margin"></div><div class="main-list-separator"></div>':"",d,c,'<div class="x-clear"></div>',{compiled:true,getItemDisplayStyle:function(e){return Ext.isEmpty(e)?"":"display: "+e+";"},doubleEncode:function(e){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(e))},getIconClass:function(e){return b?e.type:(e.id>=0?"dtv":"schedule")},getAddLibraryIcon:function(e){return _S("is_admin")?'<div class="add-library"></div>':""},getHideDLClass:function(e){return(b&&!e)?"x-hide-display":""},getDTVIcon:function(){return'<div class="signal-icon hide"></div><div class="streaming-icon hide"></div>'},getAddFolderIcon:function(f){var e=[SYNO.SDS.VideoStation2.Constant.MOVIE,SYNO.SDS.VideoStation2.Constant.TVSHOW,SYNO.SDS.VideoStation2.Constant.HOME_VIDEO].indexOf(f.type)!==-1;return(_S("is_admin")&&e)?'<div class="icon add"></div>':""}});return a}});Ext.define("SYNO.SDS.VideoStation2.MainList.Event",{singleton:true,LIBRARY_PANEL_RESIZE:"librarypanelresize",DTV_PANEL_RESIZE:"dtvpanelresize"});Ext.define("SYNO.SDS.VideoStation2.DetailActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"detail-action-bar",items:[new SYNO.SDS.VideoStation2.DetailActionBar.SelectPlayer(),new SYNO.SDS.VideoStation2.DetailActionBar.MoreAction()]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.DetailActionBar.SelectPlayer",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"device",tooltip:_VST("controller","tooltip_player"),noicon:true,disabled:true,menuBeforeShow:{scope:this,fn:this.refreshPlayerItem}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Player.get(),SYNO.SDS.VideoStation2.Player.EVENT_PLAYER_LOAD,this.onPlayerLoad,this)},refreshPlayerItem:function(c){c.removeAll();var a=SYNO.SDS.VideoStation2.Player.get().getAllPlayers();var b=a.map(function(d){return new Ext.menu.Item({text:d.title,scope:this,itemId:d.id,handler:this.onPlayerItemClick})},this);c.add(b)},onPlayerLoad:function(){this.setDisabled(Ext.isEmpty(SYNO.SDS.VideoStation2.Player.get().getAllPlayers()))},onPlayerItemClick:function(a){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(a.itemId);this[SYNO.SDS.VideoStation2.File.get().hasMultipleFile()?"chooseFileToPlay":"playVideo"]()},chooseFileToPlay:function(){var b=(function(c){SYNO.SDS.VideoStation2.Controller.switchFile(c.id);this.playVideo()}).createDelegate(this);var a={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType()};SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a,b)},playVideo:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:SYNO.SDS.VideoStation2.File.get().getCurrentID(),video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),subtitle_id:SYNO.SDS.VideoStation2.File.get().getSubtitle(),audiotrack_id:SYNO.SDS.VideoStation2.File.get().getAudiotrack()},{fn:SYNO.SDS.VideoStation2.Controller.refreshViewInfo,args:[SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO]})}});Ext.define("SYNO.SDS.VideoStation2.DetailActionBar.MoreAction",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"more",tooltip:_VST("action","start"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.File.get(),SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD,this.onFileLoad,this);this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:true})},onFileLoad:function(){var a=this.menu.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA);if(a){a.setVisible(SYNO.SDS.VideoStation2.File.get().hasMultipleFile())}},onCapabilityReady:function(){this.menu.removeAll();this.menu.addItem(this.getActions())},getActions:function(){var a=SYNO.SDS.VideoStation2.ActionUtil.getAvailableVideoActions().filter(function(b){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO].indexOf(b)===-1});return a.map(function(b){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getVideoActionString(b),itemId:b,scope:this,handler:this.doVideoAction})},this)},doVideoAction:function(b){var c;switch(b.itemId){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE:c=SYNO.SDS.VideoStation2.Controller.refreshView;break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE:c=function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.SUBTITLE)};break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:c=function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO)};break;default:c=Ext.emptyFn;break}var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();delete a.file;SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(b.itemId,[a],c)}});Ext.define("SYNO.SDS.VideoStation2.SortMenuActionButton",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var c=SYNO.SDS.VideoStation2.Sort.getAllSorts().map(function(d){return new Ext.Action({text:String.format(_VST("sort","sort_by"),_VST("common",d)||_VST("classification",d)),scope:this,itemId:d,handler:this.onSortTypeClick})},this);c=c.concat(SYNO.SDS.VideoStation2.Sort.getAllDirections().map(function(d){return new Ext.Action({text:_VST("sort","order_"+d),scope:this,itemId:d,handler:this.onSortDirClick})},this));var a={cls:"sort",tooltip:_VST("action","sort"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:c})};this.callParent([Ext.apply(a,b)]);this.onLoadSort();this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.adjustSortMenu,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.adjustSortMenu,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.adjustSortMenu,this);this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onLoadSort,this)},adjustSortMenu:function(){var b=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST;var a=SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific();var d=this.menu.getComponent(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED);var c=this.menu.getComponent(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED);d.setDisabled(b||a);c.setDisabled(a)},onLoadSort:function(){var a=[SYNO.SDS.VideoStation2.Sort.get().getCurrentSort(),SYNO.SDS.VideoStation2.Sort.get().getCurrentSortDir()];this.menu.items.each(function(b){b.removeClass("checked");if(-1!==a.indexOf(b.itemId)){b.addClass("checked")}},this)},onSortTypeClick:function(a){SYNO.SDS.VideoStation2.VideoListController.toSortType(a.itemId)},onSortDirClick:function(a){SYNO.SDS.VideoStation2.VideoListController.toSortDirection(a.itemId)}});Ext.define("SYNO.SDS.VideoStation2.NavigationToolbarPath",{extend:"SYNO.SDS.VideoStation2.TransparentButton",path:null,constructor:function(a){this.callParent(arguments);this.setPath(this.path);this.addClass("nav-toolbar-path");this.mon(this,"click",this.onPathClick)},setPath:function(a){this.path=a;this.setText(Ext.util.Format.htmlEncode(this.path.value))},onPathClick:function(){if(Ext.isDefined(this.path.folder)){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.FOLDER);SYNO.SDS.VideoStation2.Folder.get().thrinkFolderStackTo(this.path.folder)}switch(this.path.view){case SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.Controller.intoHomePage(true);break;case SYNO.SDS.VideoStation2.View.VIEW_POSTER:if(Ext.isDefined(this.path.recording_specific)){SYNO.SDS.VideoStation2.Controller.intoPosterView(this.path.recording_specific,null,this.path.value)}else{SYNO.SDS.VideoStation2.Controller.intoPosterView()}break;case SYNO.SDS.VideoStation2.View.VIEW_DETAIL:SYNO.SDS.VideoStation2.Controller.intoVideoDetail();break;case SYNO.SDS.VideoStation2.View.VIEW_TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow();break;case SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST:SYNO.SDS.VideoStation2.Controller.intoPlaylistView();break}SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.FOLDER)}});Ext.define("SYNO.SDS.VideoStation2.NavigationToolbarFilter",{extend:"SYNO.SDS.VideoStation2.TransparentButton",category:null,constructor:function(a){this.callParent(arguments);this.setCategory(this.category);this.addClass("nav-toolbar-filter");this.mon(this,"afterrender",this.onAfterRender,this)},setCategory:function(a){this.category=a;var b=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(a);this.setText(b)},onAfterRender:function(){var a=this.getEl();var b=a.createChild({tag:"div",cls:"filter-cancel"},a.down("em"));this.mon(b,"click",this.onFilterClick,this)},onFilterClick:function(){SYNO.SDS.VideoStation2.Filter.get().clearFilter(this.category)}});Ext.define("SYNO.SDS.VideoStation2.NavigationLeftContainer",{extend:"Ext.Container",constructor:function(b){var a={cls:"left-container",items:[this.categoryBar=new SYNO.SDS.VideoStation2.NavigationBar.CategoryBar(),this.pathBar=new SYNO.SDS.VideoStation2.NavigationBar.PathBar()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.categoryBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]);this.relayEvents(this.pathBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]);this._active=this.categoryBar;this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED,this.switchType,this);this.switchType()},getActiveWidth:function(){return this._active.getResizeEl()?this._active.getWidth():0},switchType:function(){var a=SYNO.SDS.VideoStation2.Navigation.get().getCurrentType();switch(a){case SYNO.SDS.VideoStation2.Navigation.TYPE_CATEGORY:this._active=this.categoryBar;this._deactive=this.pathBar;break;default:this._deactive=this.categoryBar;this._active=this.pathBar;break}this._active.show();this._deactive.hide();this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"main-navbar",items:[this.leftContainer=new SYNO.SDS.VideoStation2.NavigationLeftContainer(),"->",this.actionBar=new SYNO.SDS.VideoStation2.NavigationBar.ActionBar()],listeners:{afterlayout:this.adjustToolbarSize,scope:this}};this.callParent([Ext.apply(a,b)]);this.mon(this.leftContainer,SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR,this.adjustToolbarSize,this);this.mon(this.actionBar,SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR,this.adjustToolbarSize,this)},adjustToolbarSize:function(){var b=this.getEl();if(!b){return}var c=b.getWidth()-b.getPadding("lr");var a=this.actionBar.container.getWidth();var d=c-a;this.leftContainer.setWidth(d);this.leftContainer.setWidth(Ext.min([this.leftContainer.getActiveWidth(),d]))}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.Event",{statics:{EVENT_ADJUST_TOOLBAR:"adjusttoolbar"}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.CategoryBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-categorybar",items:[this.categoryBtn=new SYNO.SDS.VideoStation2.NavigationBar.CategoryButton(),this.filterBar=new SYNO.SDS.VideoStation2.NavigationBar.FilterBar()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.filterBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.changeFilterState,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeFilterState,this);this.changeFilterState()},changeFilterState:function(){var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL;var a=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE;this.categoryBtn.setVisible(!a);this.filterBar.setVisible(b||a);this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)},hide:function(){this.callParent(arguments);this.categoryBtn.menu.hide()}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.FilterBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-filterbar",items:[]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadFilter,this);this.loadFilter()},loadFilter:function(){this.removeAll();var a=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(a,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());this.add(Object.keys(a).map(function(b){return new SYNO.SDS.VideoStation2.NavigationToolbarFilter({category:b})}));this.doLayout();this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.PathBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-pathbar",items:[]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED,this.loadPath,this);this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK,this.goback,this);this.loadPath()},loadPath:function(){this.removeAll();var a=SYNO.SDS.VideoStation2.Navigation.get().getCurrentPath();if(!a){return}this.add(a.map(function(b){return new SYNO.SDS.VideoStation2.NavigationToolbarPath({path:b})}));this.doLayout();this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)},goback:function(){if(this.hidden){return}if(this.items.length<=1){return}this.items.get(this.items.length-2).fireEvent("click")}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.ActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-actionbar",items:[this.detailActionBar=new SYNO.SDS.VideoStation2.DetailActionBar(),this.listActionBar=new SYNO.SDS.VideoStation2.NavigationBar.ListActionBar()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.detailActionBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]);this.relayEvents(this.listActionBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]);this.mon(SYNO.SDS.VideoStation2.BrowsingAction.get(),SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED,this.switchAction,this);this.switchAction()},switchAction:function(){var a=SYNO.SDS.VideoStation2.BrowsingAction.get().getCurrentAction();switch(a){case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_NONE:this.detailActionBar.hide();this.listActionBar.hide();break;case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_DETAIL:this.detailActionBar.show();this.listActionBar.hide();break;default:this.detailActionBar.hide();this.listActionBar.show();break}this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.ListActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var c=SYNO.SDS.VideoStation2.View.getAllTypes().map(function(d){return new Ext.Action({text:_VST("common","mode_"+d),scope:this,itemId:d,handler:this.onViewTypeClick})},this);var a={cls:"navbar-list-actionbar",items:[this.selectModeBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"select_mode",tooltip:_VST("common","selection_mode"),enableToggle:true,scope:this,toggleHandler:this.onSelectModeToggle}),this.selectActionBar=new SYNO.SDS.VideoStation2.NavigationBar.SelectActionBar(),this.viewTypeBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"view_list",menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:c})}),this.sortBtn=new SYNO.SDS.VideoStation2.SortMenuActionButton(),this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",tooltip:_VST("action","edit_metadata"),scope:this,handler:this.onEditClick})]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.selectActionBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]);this.mon(SYNO.SDS.VideoStation2.BrowsingAction.get(),SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED,this.switchAction,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChange,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChange,this);this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED,this.onVideoSelectModeChange,this)},switchAction:function(){var a=SYNO.SDS.VideoStation2.BrowsingAction.get().getCurrentAction();switch(a){case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_SELECT:this.selectActionBar.show();break;default:this.selectActionBar.hide();break}},loadViewType:function(){var a=SYNO.SDS.VideoStation2.View.get().getViewType();var b=SYNO.SDS.VideoStation2.View.getAllTypes().map(function(c){return"view_"+c});this.viewTypeBtn.removeClass(b);this.viewTypeBtn.addClass("view_"+a);this.viewTypeBtn.setTooltip(_VST("common","mode_"+a));this.viewTypeBtn.menu.getComponent(SYNO.SDS.VideoStation2.View.TYPE_TILE).setVisible(SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST);this.viewTypeBtn.menu.items.each(function(c){c.removeClass("checked");if(c.itemId===a){c.addClass("checked")}})},changeSortBtnState:function(){if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){this.sortBtn.setDisabled(SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_POSTER)}else{this.sortBtn.setDisabled(SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW||!SYNO.SDS.VideoStation2.Category.isSortAdjustableCategory(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()))}},changeSelectModeBtnState:function(){var a=SYNO.SDS.VideoStation2.View.get().getView();var d=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var e=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW&&a===SYNO.SDS.VideoStation2.View.VIEW_POSTER&&d!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER;var b=a===SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST;var c=SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(d)&&!SYNO.SDS.VideoStation2.RecordingSpecific.get().isSet();this.selectModeBtn.setVisible(!e&&!b&&!c);this.selectModeBtn.toggle(SYNO.SDS.VideoStation2.Video.get().isInSelectMode())},changeEditBtnState:function(){this.editBtn.setVisible(SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW&&!SYNO.SDS.VideoStation2.Video.get().isInSelectMode()&&_S("is_admin"));this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)},onViewChange:function(){this.loadViewType();this.changeSortBtnState();this.changeSelectModeBtnState();this.changeEditBtnState()},onViewTypeChange:function(){this.loadViewType()},onVideoSelectModeChange:function(){this.changeSelectModeBtnState();this.changeEditBtnState()},onLibraryChange:function(){this.changeSortBtnState();this.changeSelectModeBtnState()},onCategoryChange:function(){this.changeSortBtnState();this.changeSelectModeBtnState()},onViewTypeClick:function(a){SYNO.SDS.VideoStation2.View.get().setViewType(a.itemId)},onSelectModeToggle:function(b,a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(a,true)},onEditClick:function(){SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,[{id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Constant.TVSHOW,mapper_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow().mapper_id,library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()}],SYNO.SDS.VideoStation2.Controller.refreshViewInfo)},hide:function(){this.callParent(arguments);this.viewTypeBtn.menu.hide();this.sortBtn.menu.hide()}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.SelectActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(c){var b={scope:this,handler:this.onVideoAction};var a={cls:"navbar-select-actionbar",hideMode:"custom",items:[new SYNO.SDS.VideoStation2.MenuActionButton({cls:"select_collection",tooltip:_VST("playlist","title"),menuBeforeShow:{scope:this,fn:this.onBeforeSelectPlaylistShow}}),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_share",tooltip:_VST("advanced","public_sharing"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_view",tooltip:_VST("action","set_watched"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_view_off",tooltip:_VST("action","set_unwatched"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_edit",tooltip:_VST("action","edit_metadata"),hidden:!_S("is_admin"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_MULTIPLE_EPISODE_METADATA},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_delete",tooltip:_VST("action","del_video"),hidden:!_S("is_admin"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_transcoding",tooltip:_VST("offline_conversion","action"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION},b))],listeners:{scope:this}};this.callParent([Ext.apply(a,c)]);this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED,this.onVideoSelectionChange,this);this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:true});this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.toggleMultipleTVShowEditBtn,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.toggleMultipleTVShowEditBtn,this);this.onVideoSelectionChange()},toggleMultipleTVShowEditBtn:function(){var a=this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_MULTIPLE_EPISODE_METADATA);if(_S("is_admin")&&SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE&&SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER){a.show()}else{a.hide()}},recalculateWidth:function(){var a;if(!(a=this.getEl())){return}this.setWidth(this.items.items.reduce(function(b,c){return b+c.container.getWidth()},0))},onCapabilityReady:function(){this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING).setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing());this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION).setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion())},onVideoSelectionChange:function(){var a=SYNO.SDS.VideoStation2.Video.get().isVideoSelectionEmpty();this.items.each(function(b){b.setDisabled(a)})},onBeforeSelectPlaylistShow:function(g){g.removeAll();var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();var e={};var d=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();c.each(function(h){if(!h.playlists){return}h.playlists.each(function(i){e[i.id]=(e[i.id]||0)+1})});var b=function(h){return(e[h.id]===c.length)?"checked":""};var a=function(h){return d===h.id};var f=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:b,hideOnClickFn:a,createPlaylistFn:this.onCreatePlaylist,clickPlaylistFn:this.onPlaylistClick},this);g.add(f)},onVideoAction:function(a){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();if(b.length===0){return}SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(a.itemId,b,SYNO.SDS.VideoStation2.Controller.refreshView)},onCreatePlaylist:function(){var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();SYNO.SDS.VideoStation2.VideoActionController.createPlaylist(a,SYNO.SDS.VideoStation2.Controller.refreshView)},onPlaylistClick:function(c){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();var d=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(parseInt(c.itemId,10));var a=!c.getEl().hasClass("checked");var e=Ext.emptyFn;if(!a&&d.id===SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()){e=function(){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection();SYNO.SDS.VideoStation2.Controller.refreshView()}}else{e=this.onPlaylistAddRemove.createDelegate(this,[a,c])}SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(b,d.id,a,e)},onPlaylistAddRemove:function(a,b){if(b&&!b.isDestroyed){b.getEl()[a?"addClass":"removeClass"]("checked")}SYNO.SDS.VideoStation2.Controller.refreshView()},onShow:function(){this.callParent(arguments);this.removeClass("hide");this.addClass("show");this.recalculateWidth();this.fireEvent.defer(500,this,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR])},onHide:function(){this.callParent(arguments);this.addClass("hide");this.removeClass("show");this.setWidth(0);this.fireEvent.defer(500,this,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR])}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.CategoryButton",{extend:"SYNO.SDS.VideoStation2.TransparentButton",constructor:function(b){var c=SYNO.SDS.VideoStation2.Category.getAllCategories().map(function(d){return new Ext.Action({text:_VST("classification",d),scope:this,itemId:d,handler:this.onCategoryClick})},this);var a={cls:"category-button",menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:c})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadCategory,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChange,this);this.loadCategory()},loadCategory:function(){var a=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var b=this.menu.getComponent(a);this.setText(b.text)},onLibraryChange:function(){var b=SYNO.SDS.VideoStation2.Library.get().getCurrentType();var a=[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER];var c=[SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM];Ext.each(a,function(d){this.menu.getComponent(d).setVisible(b!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},this);Ext.each(c,function(d){this.menu.getComponent(d).setVisible(b===SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},this);this.adjustReleasedText(b)},adjustReleasedText:function(d){var a=this.menu.getComponent(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED);var c=SYNO.SDS.VideoStation2.Controller.getClassificationString(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,d);var b=[a];if(this.getText()===a.text){b.push(this)}Ext.each(b,function(e){e.setText(c)})},onCategoryClick:function(a){switch(a.itemId){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyWatchCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyReleasedCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_ALL:SYNO.SDS.VideoStation2.VideoListController.toAllCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER:SYNO.SDS.VideoStation2.VideoListController.toFolderCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL:SYNO.SDS.VideoStation2.VideoListController.toChannelCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM:SYNO.SDS.VideoStation2.VideoListController.toProgramCategory();break}}});Ext.define("SYNO.SDS.VideoStation2.PlayerOption",{extend:"Ext.util.Observable",statics:{EVENT_SUBTITLE_LOAD:"subtitleload"},constructor:function(a){this.callParent(arguments)},loadData:function(){this.loadSubtitle({fn:function(){this.fireEvent(SYNO.SDS.VideoStation2.PlayerOption.EVENT_SUBTITLE_LOAD)},scope:this});this.getAudiotrackStore().load({params:{id:SYNO.SDS.VideoStation2.File.get().getCurrentID()}})},loadSubtitle:function(a){this.getSubtitleStore().load({params:{id:SYNO.SDS.VideoStation2.File.get().getCurrentID()},callback:a.fn,scope:a.scope})},clearData:function(){this.getSubtitleStore().removeAll();this.getAudiotrackStore().removeAll()},getSubtitleStore:function(){this._subtitle=this._subtitle||new SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore();return this._subtitle},getAudiotrackStore:function(){this._audiotrack=this._audiotrack||new SYNO.SDS.VideoStation2.PlayerOption.AudiotrackStore();return this._audiotrack},getSubtitleData:function(){var a=[];this.getSubtitleStore().each(function(b){if(b.get("format")==="srt"){a.push(SYNO.Util.copy(b.data))}});a.sort(function(e,c){var d=(e.embedded?2:0)+(e.display<c.display?0:1)+(e.id==="none"?-100:0);var b=(c.embedded?2:0)+(e.display>c.display?0:1)+(c.id==="none"?-100:0);return d-b});return a},getAudiotrackData:function(){var a=[];this.getAudiotrackStore().each(function(b){a.push(SYNO.Util.copy(b.data))});return a}});Ext.define("SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore",{extend:"SYNO.API.Store",statics:{NO_SUBTITLE_OBJECT:{embedded:false,format:"srt",id:"none",lang:"",title:_T("video_player","no_subtitle")}},constructor:function(b){var a={appWindow:SYNO.SDS.VideoStation2.Window,api:"SYNO.VideoStation2.Subtitle",method:"list",version:1,baseParams:{image_based:false},reader:new Ext.data.JsonReader({root:"subtitle",fields:[{name:"id",type:"string"},"embedded","format","lang","title",{name:"display",type:"string",convert:this.convertDisplay}]}),listeners:{scope:this,load:this.onStoreLoad}};this.callParent([Ext.apply(a,b)])},convertDisplay:function(c,b){var e=b.lang.toLowerCase();if(false===b.embedded){return String.format("{0}{1}",Ext.isEmpty(b.title)?_VST("options","external_subtitle"):b.title,e.length>0?(" - "+e):"")}var d=b.title||e||String.format("Subtitle Track #{0}",b.id);var a=b.format.toLowerCase();if(a!=="srt"){d+=String.format(" ({0})",a)}return d},onStoreLoad:function(b,a){var c=b.reader.readRecords({subtitle:[SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore.NO_SUBTITLE_OBJECT]}).records[0];if(Ext.isObject(c)){b.insert(0,c)}}});Ext.define("SYNO.SDS.VideoStation2.PlayerOption.AudiotrackStore",{extend:"SYNO.API.Store",constructor:function(b){var a={appWindow:SYNO.SDS.VideoStation2.Window,api:"SYNO.VideoStation2.File",method:"get_track_info",version:1,reader:new Ext.data.JsonReader({root:"audio",fields:["id","channel","codec","language","track",{name:"display",type:"string",convert:this.convertDisplay}]})};this.callParent([Ext.apply(a,b)])},convertDisplay:function(b,a){var c=(a.language.length>0)?(" - "+a.language):"";return String.format("#{0}{1} ({2})",a.track,c,a.codec)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailInfoArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this._panel=new SYNO.SDS.VideoStation2.ViewDetailPanel({});this.player_option=new SYNO.SDS.VideoStation2.PlayerOption({});this.dropdown_menu=new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,listeners:{scope:this,hide:this.onMenuHide}});var a={cls:"info-area",autoFlexcroll:true,items:[this._panel]};this.callParent([Ext.apply(a,b)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_EXPAND_COLLAPSE);this.relayEvents(this._panel,[SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_EXPAND_COLLAPSE]);this._panel.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.LOAD_PLAYER_OPTION,this.loadPlayerOption,this);this.mon(this,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_SUBTITLE,this.selectSubtitle,this);this.mon(this,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_AUDIOTRACK,this.selectAudiotrack,this);this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_INFO_UPDATE,this.onInfoUpdate,this);this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_SUBTITLE,this.expandSubtitle,this);this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_AUDIOTRACK,this.expandAudiotrack,this);this.mon(this.player_option,SYNO.SDS.VideoStation2.PlayerOption.EVENT_SUBTITLE_LOAD,this.selectFirstSubtitle,this)},onDeactivate:function(){this.getEl().select(".subtitle").each(function(a){a.update(Ext.util.Format.htmlEncode(_T("video_player","no_subtitle")))})},onVideoLoad:function(a){this.loadBackdrop(a);this._panel.onVideoLoad(a)},onInfoUpdate:function(){this.doLayout()},loadBackdrop:function(d){var c=SYNO.SDS.VideoStation2.Video.get().getCurrentType();var a=(c===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)?d.tvshow_backdrop_mtime||"":(d.additional&&d.additional.backdrop_mtime)||"";var b=SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:(c===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)?d.tvshow_mapper_id:d.mapper_id,mtime:a});SYNO.SDS.VideoStation2.Controller.setBackdrop(b)},loadPlayerOption:function(){this.player_option.clearData();this.player_option.loadData()},getMenuOption:function(a,b){return a.map(function(c){return{xtype:"menuitem",scope:this,itemId:c.id.toString(),text:Ext.util.Format.htmlEncode(c.display),handler:function(d){this.fireEvent(b,d.itemId,d.text)}}},this)},getSubtitleOption:function(){return this.getMenuOption(this.player_option.getSubtitleData(),SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_SUBTITLE)},getAudiotrackOption:function(){return this.getMenuOption(this.player_option.getAudiotrackData(),SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_AUDIOTRACK)},selectFirstSubtitle:function(){var b=this.player_option.getSubtitleData();var a=b[Ext.min([b.length-1,1])];if(Ext.isObject(a)){this.selectSubtitle(a.id.toString(),Ext.util.Format.htmlEncode(a.display))}},selectSubtitle:function(b,a){this.getEl().select(".subtitle").each(function(c){c.update(a)});SYNO.SDS.VideoStation2.PlaybackController.selectSubtitle(b)},selectAudiotrack:function(b,a){this.getEl().select(".audiotrack").each(function(c){c.update(a)});SYNO.SDS.VideoStation2.PlaybackController.selectAudiotrack(parseInt(b,10))},onMenuHide:function(){this.getEl().select(".dropdown-arrow").each(function(a){a.removeClass("expanded")})},expandSubtitle:function(a){this.dropdown_menu.removeAll();this.dropdown_menu.add(this.getSubtitleOption());this.dropdown_menu.showAt([a[0],a[1]+24])},expandAudiotrack:function(a){this.dropdown_menu.removeAll();this.dropdown_menu.add(this.getAudiotrackOption());this.dropdown_menu.showAt([a[0],a[1]+24])},reloadSubtitle:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.player_option.loadSubtitle({fn:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},scope:this})}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event",{statics:{EVENT_EXPAND_SUBTITLE:"expandsubtitle",EVENT_EXPAND_AUDIOTRACK:"expandaudiotrack",EVENT_SELECT_SUBTITLE:"selectsubtitle",EVENT_SELECT_AUDIOTRACK:"selectaudiotrack"}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailPanel",{extend:"Ext.Panel",statics:{EVENT_SUMMARY_EXPAND_COLLAPSE:"summaryexpandcollapse",EVENT_INFO_UPDATE:"infoupdate"},constructor:function(b){var a={tpl:this.getTpl(),cls:"detail-tpl-panel",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)])},onAfterRender:function(){this.mon(this.getEl(),"click",this.onPanelClick,this)},onVideoLoad:function(a){this._video=SYNO.Util.copy(a);this.update(a);this.applyViewMoreButtonAction();this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_INFO_UPDATE)},onPanelClick:function(c,d,a){var b=Ext.fly(d);if(b.hasClass("filter")){this.onFilterItemClick(d)}else{if(b.hasClass("reference")){this.onReferenceItemClick(b)}else{if(b.hasClass("subtitle")){b.addClass("expanded");this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_SUBTITLE,b.getXY())}else{if(b.hasClass("audiotrack")){b.addClass("expanded");this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_AUDIOTRACK,b.getXY())}else{if(b.hasClass("rating")){this.onStarClick(b)}}}}}},onStarClick:function(b){if(!_S("is_admin")){return}var a=SYNO.SDS.VideoStation2.Video.get();var c={success:function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO)}};SYNO.SDS.VideoStation2.OP.get().setVideoRating({id:a.getCurrentID(),rating:this.getRatingFromElement(b)},c,a.getCurrentType())},getRatingFromElement:function(c){for(var b=1,a=5;b<=a;b++){if(c.hasClass("star_"+b)){return b*20}}},onFilterItemClick:function(c){var a=Ext.fly(c).getAttribute("data-filter");var b=Ext.util.Format.htmlDecode(c.innerHTML);SYNO.SDS.VideoStation2.Controller.setFilter(a,{key:b,value:b})},onReferenceItemClick:function(a){window.open(a.getAttribute("url"))},applyViewMoreButtonAction:function(){var b=this.getEl();if(!b){return}var d=b.select(".view-btn").elements[0];var c=b.select(".summary").elements[0];if(!d||!c){return}if(Ext.fly(c).getHeight()<=72){Ext.fly(d).addClass("hide");return}var a=this;Ext.fly(d).on({click:function(j,k){var i=a.getEl();var h=Ext.fly(k);var l=h.hasClass("all");h.removeClass(l?"all":"less");h.addClass(l?"less":"all");h.update(Ext.util.Format.htmlEncode(l?_VST("action","view_less"):_VST("action","view_all")));h=null;var f=l?Ext.fly(i.select(".summary").elements[0]).getHeight():72;var g=Ext.fly(i.select(".summary-wrapper").elements[0]);g.setStyle("max-height",String.format("{0}px",f));g=null;a.fireEvent.defer(400,a,[SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_EXPAND_COLLAPSE])}})},getAudioDiv:function(c){if(""===c.audio_codec){return}var b='<td><div class="audio {0}">{1}</div></td>';var d=c.audio_codec.toLowerCase();var a="",e="";if(d.indexOf("aac")!==-1){a="aac"}else{e=d.toUpperCase()}return String.format(b,a,e)},getAudioChannelDiv:function(b){if(0===b.channel){return}var a='<td><div class="audio-channel">{0}</div></td>';var c=parseInt(b.channel,10)||0;switch(c){case 1:return String.format(a,"MONO");case 2:return String.format(a,"STEREO");case 6:return String.format(a,"5.1");case 8:return String.format(a,"7.1");default:return String.format(a,c.toFixed(1))}},getResolutionText:function(d){var b,e;if(d.display_x>=d.display_y){b=d.display_x;e=d.display_y}else{b=d.display_y;e=d.display_x}var c=function(f){var h=(f.x_from==-1||b>f.x_from)&&(f.x_to==-1||b<=f.x_to)&&(f.y_to==-1||e<=f.y_to);var g=(f.y_from==-1||e>f.y_from)&&(f.y_to==-1||e<=f.y_to)&&(f.x_to==-1||b<=f.x_to);return h||g};var a="SD";Ext.iterate(SYNO.SDS.VideoStation2.Constant.RESOLUTION_DEFINITION,function(g,h,f){if(c(h)){a=g;return false}});return a},getDateRatingTpl:function(a){var b=a.original_available||a.record_date||"0";return['<table cellspacing="0"><tbody><tr>',String.format('<td><div class="year">{0}</div></td>',(b==="0"?_VST("metadata","unknown"):b)),SYNO.SDS.VideoStation2.ViewDetailUtil.getRatingTpl(a),"</tr></tbody></table>"].join("")},getDateRatingAndCodecTpl:function(a){SYNO.Assert(Ext.isObject(a.default_file),"file not exist");var d=this.getDateRatingTpl(a);var c=a.default_file;var b=['<table cellspacing="0"><tbody><tr>',String.format('<td><div class="resolution">{0}</div></td>',this.getResolutionText(c)),this.getAudioDiv(c),this.getAudioChannelDiv(c),"</tr></tbody></table>"].join("");return['<div class="info-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',d,"</td>",'<td align="right">',b,"</td>","</tr></tbody></table></div>"].join("")},getSeasonEpisodeTpl:function(a){return["season","episode"].map(function(b){var c=a[b];if(!Ext.isNumber(c)||c<=0){return""}return String.format('<div class="info">{0}: <div class="item">{1}</div></div>',Ext.util.Format.htmlEncode(_VST(b,b+"_title")),c)}).join("")},genAdditionalValueTpl:function(b){var c=_VST(b,"title");var a=['<tpl if="this.hasValue(values.additional.{0})">','<div class="info tag">',c,": ",'<tpl for="values.additional.{0}">','<tpl if="xindex &gt; 1">, </tpl><div class="item filter" data-filter="',b,'">{.:htmlEncode}</div>',"</tpl>","</div>","</tpl>"].join("");return String.format(a,b)},getDurationTpl:function(a){SYNO.Assert(Ext.isObject(a.default_file),"file not exist");return['<div class="info">',Ext.util.Format.htmlEncode(_VST("duration","title")+": "),'<div class="item">',Ext.util.Format.htmlEncode(a.default_file.duration),"</div>","</div>"].join("")},getTitleAndCertificateTpl:function(a){var b=String.format('<div class="title">{0}</div>',Ext.util.Format.htmlEncode(a.title));if(Ext.isEmpty(a.certificate)){return b}return['<div class="title-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',b,"</td>",'<td align="right" class="certificate-wrapper">',String.format('<div class="certificate">{0}</div>',Ext.util.Format.htmlEncode(a.certificate)),"</td>","</tr></tbody></table></div>"].join("")},getReferenceTpl:function(){return['<tpl if="this.hasValue(values.reference)">','<div class="info tag">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("imdb","reference"))),'<tpl for="values.reference">','<tpl if="xindex &gt; 1">, </tpl><div class="item reference" url="{url:htmlEncode}">{title:htmlEncode}</div>',"</tpl>","</div>","</tpl>"].join("")},getSubtitleTpl:function(){return['<div class="info">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("options","subtitle"))),String.format('<div class="dropdown-arrow subtitle">{0}</div>',Ext.util.Format.htmlEncode(_T("video_player","no_subtitle"))),"</div>"].join("")},getAudiotrackTpl:function(){return['<div class="info">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("options","audio_track"))),String.format('<div class="dropdown-arrow audiotrack">{0}</div>',Ext.util.Format.htmlEncode(_VST("offline_conversion","default_audio_track"))),"</div>"].join("")},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">',"{[this.getTitleAndCertificate(values)]}",'<tpl if="this.hasTagline(values)"><div class="tagline">{values.tagline:htmlEncode}</div></tpl>',"{[this.getDateRatingAndCodec(values)]}",this.genAdditionalValueTpl("genre"),"{[this.getSeasonEpisode(values)]}","{[this.getDuration(values)]}",this.genAdditionalValueTpl("actor"),this.genAdditionalValueTpl("writer"),this.genAdditionalValueTpl("director"),this.getReferenceTpl(),'<tpl if="this.isSingleFile(values)">',"{[this.getSubtitle()]}","{[this.getAudiotrack()]}","</tpl>",'<tpl if="this.hasValue(values.additional && values.additional.summary)">',String.format('<div class="summary-title">{0}</div>',Ext.util.Format.htmlEncode(_VST("summary","title"))),'<div class="summary-wrapper">','<div class="summary">{values.additional.summary:htmlEncode}</div>',"</div>",'<div class="info-separator"></div>','<div class="view-btn all">{[_VST("action", "view_all")]}</div>',"</tpl>","</tpl>",'<div class="x-clear"></div>',{hasTagline:function(b){return !Ext.isEmpty(b.tagline)},hasValue:function(b){return !Ext.isEmpty(b)},isSingleFile:function(b){return Ext.isObject(b)&&Ext.isObject(b.additional)&&Ext.isArray(b.additional.file)&&b.additional.file.length===1},getTitleAndCertificate:this.getTitleAndCertificateTpl.createDelegate(this),getSeasonEpisode:this.getSeasonEpisodeTpl.createDelegate(this),getDuration:this.getDurationTpl.createDelegate(this),getDateRatingAndCodec:this.getDateRatingAndCodecTpl.createDelegate(this),getSubtitle:this.getSubtitleTpl.createDelegate(this),getAudiotrack:this.getAudiotrackTpl.createDelegate(this)});return a}});Ext.define("SYNO.SDS.VideoStation2.VideoStatusBar",{extend:"Ext.Toolbar",constructor:function(b){this.watched_status=new Ext.Toolbar.TextItem({text:_VST("advanced","unwatched"),cls:"watched-status"});this.video_action=new SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction();var a={cls:"video-status-bar",items:[this.watched_status,"->",this.video_action]};this.callParent([Ext.apply(a,b)]);this.video_action.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this);this.mon(this.video_action,SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction.EVENT_SHARING_UPDATE,this.doLayout,this)},onVideoLoad:function(a){this.updateVideoActionStatus(a);this.updateWatchedStatus(a)},updateVideoActionStatus:function(c){var b=(c.additional&&c.additional.collection)||[];var a=b.map(function(d){return d.id});this.video_action.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,a)},updateWatchedStatus:function(c){var b=c.additional&&c.additional.watched_ratio;var a=SYNO.SDS.VideoStation2.Constant.CLASS.UNWATCHED;this.watched_status[SYNO.SDS.VideoStation2.Util.isUnwatched(b)?"addClass":"removeClass"](a)}});Ext.define("SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction",{extend:"Ext.Container",statics:{EVENT_SHARING_UPDATE:"sharingupdate"},constructor:function(b){this.favorite=new SYNO.SDS.VideoStation2.ActionButton({cls:"favorite",tooltip:_VST("playlist","favorite"),handler:this.togglePlaylistAddRemove.createDelegate(this,[-1])});this.watchlist=new SYNO.SDS.VideoStation2.ActionButton({cls:"watchlist",tooltip:_VST("playlist","watchlist"),handler:this.togglePlaylistAddRemove.createDelegate(this,[-2])});this.playlist=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"playlist",tooltip:_VST("playlist","title"),menuBeforeShow:{fn:this.refreshPlaylistItem,scope:this}});this.sharing=new SYNO.SDS.VideoStation2.ActionButton({cls:"public-sharing",tooltip:_VST("advanced","public_sharing"),hidden:true,scope:this,handler:this.onSharingButtonClick});var a={layout:"hbox",layoutConfig:{type:"hbox",align:"top",pack:"end",defaultMargins:{top:0,right:0,bottom:0,left:8}},cls:"video-action",items:[this.favorite,this.watchlist,this.playlist,this.sharing]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,this.updateSharingStatus,this);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,this.updatePlaylistStatus,this)},updateSharingStatus:function(a){this.sharing.setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing());this.sharing.toggle(a||false);this.fireEvent(SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction.EVENT_SHARING_UPDATE)},updatePlaylistStatus:function(b){this.current_playlists=b||[];var a={favorite:false,watchlist:false,playlist:false};Ext.each(this.current_playlists,function(c){if(c>0){a.playlist=true}else{if(c===-1){a.favorite=true}else{if(c===-2){a.watchlist=true}}}});Ext.iterate(a,function(d,e,c){this[d].toggle(e)},this)},onSharingButtonClick:function(){var a=(function(c){this.updateSharingStatus(c)}).createDelegate(this);var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();SYNO.SDS.VideoStation2.VideoActionController.publicSharing([b],a)},refreshPlaylistItem:function(d){var b=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();var a=this.current_playlists;var c=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:function(e){return(Ext.isArray(a)&&a.indexOf(e.id)!==-1)?"checked":""},hideOnClickFn:function(e){return b===e.id},filterPlaylistFn:function(e){return e.id>0&&e.type===SYNO.SDS.VideoStation2.Constant.PLAYLIST_TYPE.ORIGINAL},createPlaylistFn:this.createPlaylistHandler,clickPlaylistFn:this.playlistItemClickHandler},this);d.removeAll();d.add(c)},createPlaylistHandler:function(){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();var a=(function(c){if(this.current_playlists.indexOf(c.id)===-1){this.current_playlists.push(c.id)}this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,this.current_playlists)}).createDelegate(this);SYNO.SDS.VideoStation2.VideoActionController.createPlaylist([b],a)},playlistItemClickHandler:function(c){var b=parseInt(c.itemId,10);var a=(function(){if(c&&!c.isDestroyed){c.getEl()[(this.current_playlists.indexOf(b)!==-1)?"addClass":"removeClass"]("checked")}}).createDelegate(this);this.togglePlaylistAddRemove(b,a)},togglePlaylistAddRemove:function(e,d){var b=this.current_playlists.indexOf(e)===-1;var a=Ext.emptyFn;if(!b&&e===SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()){a=SYNO.SDS.VideoStation2.Controller.goback}else{a=(function(){var f=b?this.current_playlists.concat(e):this.current_playlists.filter(function(g){return g!==e});this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,f);if(Ext.isFunction(d)){d()}}).createDelegate(this)}var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist([c],e,b,a)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetail",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.action_area=new SYNO.SDS.VideoStation2.ViewDetailActionArea({region:"west"});this.info_area=new SYNO.SDS.VideoStation2.ViewDetailInfoArea({region:"center"});var a={layout:"border",cls:"view-detail",items:[this.action_area,this.info_area,this.backBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"back",handler:this.onBackBtnClick,scope:this}),this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"next",handler:this.onNextBtnClick,scope:this})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.action_area.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.info_area.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.relayEvents(this.info_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoDetailLoad,this);this.mon(this.action_area,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,this.onVideoDetailLoad,this);this.mon(this.action_area,SYNO.SDS.VideoStation2.ViewDetail.Event.EVENT_PLAY_VIDEO,this.playVideo,this)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.refreshAll,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this);this.loadFullData({load_path:false,load_file:true})},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.refreshAll,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},onVideoDetailLoad:function(){this.detailLoadCount=this.detailLoadCount+1;if(this.detailLoadCount===2){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.info_area.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.LOAD_PLAYER_OPTION)}},onBackBtnClick:function(){if(!this.prevVideo){return}SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.prevVideo)},onNextBtnClick:function(){if(!this.nextVideo){return}SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.nextVideo)},refreshAll:function(){var a=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER?true:false;this.loadFullData({load_path:a,load_file:true})},updatePrevNextBtn:function(){this.prevVideo=SYNO.SDS.VideoStation2.Video.get().getPrevFromVideolist();this.nextVideo=SYNO.SDS.VideoStation2.Video.get().getNextFromVideolist();this.backBtn.setDisabled(!this.prevVideo);this.nextBtn.setDisabled(!this.nextVideo)},loadFullData:function(a){this.updatePrevNextBtn();this.detailLoadCount=0;this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.action_area.fireEvent(SYNO.SDS.VideoStation2.ViewDetailActionArea.EVENT_LOAD_SHARING);SYNO.SDS.VideoStation2.PlaybackController.loadPlayer();this.loadVideoData(a)},refreshInfo:function(a){var b=SYNO.SDS.VideoStation2.Constant.REFRESH_INFO;switch(a){case b.VIDEO:this.loadVideoOnly();break;case b.SUBTITLE:this.loadSubtitleOnly();break;case b.NEXT_PREV_BTN:this.updatePrevNextBtn();break}},loadVideoOnly:function(){this.loadVideoData({load_path:false,load_file:false})},loadSubtitleOnly:function(){if(SYNO.SDS.VideoStation2.File.get().hasMultipleFile()){return}this.info_area.reloadSubtitle()},playVideo:function(){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING);SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:SYNO.SDS.VideoStation2.File.get().getCurrentID(),video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),subtitle_id:SYNO.SDS.VideoStation2.File.get().getSubtitle(),audiotrack_id:SYNO.SDS.VideoStation2.File.get().getAudiotrack()},{fn:SYNO.SDS.VideoStation2.Controller.refreshViewInfo,args:[SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO]})},loadVideoData:function(a){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentType();var c={id:[SYNO.SDS.VideoStation2.Video.get().getCurrentID()],additional:SYNO.SDS.VideoStation2.Constant.ADDITIONAL_DICT[b]};var d={success:function(i,h,e){if(Ext.isEmpty(i[SYNO.SDS.VideoStation2.Util.getVideoRoot(b)])){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.goback();return}var g=i[SYNO.SDS.VideoStation2.Util.getVideoRoot(b)][0];SYNO.SDS.VideoStation2.ViewDetailUtil.processVideoData(g);if(a.load_path){g.type=g.type||b;g.pathTitle=g.pathTitle||this.getPathTitle(g);SYNO.SDS.VideoStation2.Controller.updateVideoInfo(g)}if(a.load_file){SYNO.SDS.VideoStation2.Controller.loadFile(g.additional.file);var f=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();SYNO.SDS.VideoStation2.Controller.switchFile((f!==null)?f:g.default_file.id);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,g)}else{this.action_area.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,g);this.info_area.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,g)}},failure:function(){this.detailLoadCount=2;this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.goback()},scope:this};SYNO.SDS.VideoStation2.OP.get().getInfo(c,d,b)},getPathTitle:function(a){if(a.type!=SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE){return a.title}var b;if(Ext.isEmpty(SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow())){b=SYNO.SDS.VideoStation2.Util.getPathTitleForOfflineEpisode(a)}else{b=SYNO.SDS.VideoStation2.Util.getPathTitleForEpisode(a.episode,a.tagline)}return b}});Ext.define("SYNO.SDS.VideoStation2.ViewDetail.Event",{statics:{EVENT_PLAY_VIDEO:"playvideo"}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailActionArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_LOAD_SHARING:"loadsharing"},constructor:function(b){this.image=new SYNO.SDS.VideoStation2.ViewDetailImage({region:"north"});this.video_status_bar=new SYNO.SDS.VideoStation2.VideoStatusBar({region:"center"});var a={layout:"border",cls:"action-area",items:[this.image,this.video_status_bar]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.ViewDetailActionArea.EVENT_LOAD_SHARING,this.loadSharing,this);this.relayEvents(this.image,[SYNO.SDS.VideoStation2.ViewDetail.Event.EVENT_PLAY_VIDEO]);this.image.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.video_status_bar.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD])},loadSharing:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,false);return}var a={video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),need_url:false};var b={success:function(e,d,c){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,(e.enable)?true:false)},scope:this};SYNO.SDS.VideoStation2.OP.get().getPublicSharing(a,b)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailImage",{extend:"Ext.Container",constructor:function(b){var a={cls:"image",overCls:"over",items:[new Ext.Container({cls:"border"}),new SYNO.SDS.VideoStation2.ActionButton({cls:"play",tooltip:_VST("action","play"),scope:this,handler:this.onPlayButtonClick}),this.getProgress(),this.getFileIndicator()]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.loadImage,this)},getFileIndicator:function(){this._file_indicator=this._file_indicator||new SYNO.SDS.VideoStation2.ViewDetailActionArea.FileIndicator({});return this._file_indicator},getProgress:function(){this._progress=this._progress||new Ext.Container({tpl:new Ext.XTemplate('<tpl for=".">',"{[SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(values)]}","</tpl>")});return this._progress},chooseFileToPlay:function(){var b=(function(c){SYNO.SDS.VideoStation2.Controller.switchFile(c.id);this.playVideo()}).createDelegate(this);var a={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType()};SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a,b)},playVideo:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewDetail.Event.EVENT_PLAY_VIDEO)},onPlayButtonClick:function(){this[SYNO.SDS.VideoStation2.File.get().hasMultipleFile()?"chooseFileToPlay":"playVideo"]()},loadImage:function(b){this.getProgress().update(b);var a=SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),id:b.id,mtime:(b.additional&&b.additional.poster_mtime)||""});this.getEl().setStyle("background-image",String.format("url({0})",a))}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailActionArea.FileIndicator",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"file-indicator",hidden:true,menu:new SYNO.SDS.VideoStation2.DropdownMenu({cls:"file-list",noicon:true,listeners:{scope:this,beforeshow:this.refreshFileItem}})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.File.get(),SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD,this.onFileLoaded,this)},onFileLoaded:function(){this.files=SYNO.SDS.VideoStation2.File.get().getAllFiles()||[];var a=this.files.length>99?"99+":this.files.length.toString();this.setText(a);this.setVisible(this.files.length>1)},refreshFileItem:function(b){b.removeAll();var a=this.files.map(function(c){return new Ext.menu.Item({text:SYNO.SDS.VideoStation2.Util.extractFileName(c.sharepath)})},this);b.add(a)}});Ext.define("SYNO.SDS.VideoStation2.RotateElement",{extend:"Ext.Container",collapsedCls:"collapse",constructor:function(b){var a={cls:"rotate-sliding-element",items:[this.poster=new SYNO.SDS.VideoStation2.RotateElement.Poster({video:b.video}),this.backdrop=new SYNO.SDS.VideoStation2.RotateElement.Backdrop({video:b.video})],listeners:{scope:this,afterrender:this.onAfterRenderFn}};this.callParent([Ext.apply(a,b)])},onAfterRenderFn:function(a){this.collapse()},collapse:function(){this._collapsed=true;var a=this.getEl();if(!a){return}a.addClass(this.collapsedCls)},expand:function(){this._collapsed=false;var a=this.getEl();if(!a){return}a.removeClass(this.collapsedCls)}});Ext.define("SYNO.SDS.VideoStation2.RotateElement.Poster",{extend:"Ext.BoxComponent",constructor:function(b){var a={cls:"poster",listeners:{scope:this,afterrender:this.onAfterRenderFn}};this.callParent([Ext.apply(a,b)])},onAfterRenderFn:function(){var c=this.video;var b=SYNO.SDS.VideoStation2.Constant.MOVIE;var a=SYNO.SDS.VideoStation2.Util.getImageURL({type:b,id:c.id,mtime:(c.additional&&c.additional.poster_mtime)||""});this.addClass("loading");this.getEl().set({url:a},true)}});Ext.define("SYNO.SDS.VideoStation2.RotateElement.Backdrop",{extend:"Ext.BoxComponent",constructor:function(b){var a={tpl:this.getTpl(),cls:"backdrop",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)])},onAfterRender:function(a){this.update(this.video)},getImageURL:function(b){var a=(b.additional&&b.additional.backdrop_mtime)||"";return Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:b.mapper_id,mtime:a}))},getTitleDateDivTpl:function(a){var b=a.original_available||a.record_date||0;var c=a.title;if(b!==0){c=String.format("{0}({1})",c,b.split("-")[0])}return String.format('<div class="title" ext:qtip="{0}">{1}</div>',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(c)),Ext.util.Format.htmlEncode(c))},getTaglineDivTpl:function(a){if(Ext.isEmpty(a.tagline)){return""}return String.format('<div class="tagline">{0}</div>',Ext.util.Format.htmlEncode(a.tagline))},getCertifiateTpl:function(a){if(Ext.isEmpty(a.certificate)){return""}return['<div class="certificate-wrapper">',String.format('<div class="certificate">{0}</div>',Ext.util.Format.htmlEncode(a.certificate)),"</div>"].join("")},getRatingAndDurationCertificateTpl:function(a){var c=['<table cellspacing="0"><tbody><tr>',SYNO.SDS.VideoStation2.ViewDetailUtil.getRatingTpl(a),"</tr></tbody></table>"].join("");var b=['<table cellspacing="0"><tbody><tr>',String.format("<td>{0}</td>",this.getDurationTpl(a)),String.format("<td>{0}</td>",this.getCertifiateTpl(a)),"</tr></tbody></table>"].join("");return['<div class="info-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',c,"</td>",'<td align="right">',b,"</td>","</tr></tbody></table></div>"].join("")},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="background-backdrop loading" url="{[this.getImageURL(values)]}"><div class="background-backdrop-gradient"></div></div>','<div class="detail-info-area">',"{[this.getTitleDateDiv(values)]}","{[this.getTaglineDiv(values)]}","{[this.getRatingAndDurationCertificate(values)]}","</div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getTitleDateDiv:this.getTitleDateDivTpl.createDelegate(this),getTaglineDiv:this.getTaglineDivTpl.createDelegate(this),getRatingAndDurationCertificate:this.getRatingAndDurationCertificateTpl.createDelegate(this)});return a},getDurationTpl:function(a){SYNO.Assert(Ext.isObject(a.default_file),"file not exist");return['<div class="duration">',Ext.util.Format.htmlEncode(a.default_file.duration),"</div>"].join("")}});Ext.define("SYNO.SDS.VideoStation2.WindowSize",{statics:{EVENT_SIZE_MODE_CHANGE:"size_mode_change",NORMAIL_SIZE:"normal_size",LARGE_SIZE:"large_size",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.WindowSize.instance)){SYNO.SDS.VideoStation2.WindowSize.instance=new SYNO.SDS.VideoStation2.WindowSize()}return SYNO.SDS.VideoStation2.WindowSize.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},setSizeMode:function(a){SYNO.Assert(a===SYNO.SDS.VideoStation2.WindowSize.NORMAIL_SIZE||a===SYNO.SDS.VideoStation2.WindowSize.LARGE_SIZE,String.format("{0} setSizeMode failed",a));var b=this.size_mode;this.size_mode=a;if(b!=this.size_mode){this.fireEvent(SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE)}},isLargeSizeMode:function(){return this.size_mode===SYNO.SDS.VideoStation2.WindowSize.LARGE_SIZE},size_mode:null});Ext.define("SYNO.SDS.VideoStation2.RotateSlidingView",{extend:"Ext.Container",constructor:function(b){this.dataView=new SYNO.SDS.VideoStation2.RotateDataView();var a={cls:"rotate-sliding-view",items:[this.dataView],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(a,b)]);this.dataView.relayEvents(this,["activate","deactivate"])},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadView,this);this.loadView()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadView,this)},loadView:function(){this[SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show")?"hide":"show"]()}});Ext.define("SYNO.SDS.VideoStation2.RotateDataView",{extend:"Ext.Container",statics:{EVENT_LOAD_FAILED:"load_fail",CONSTANT:{WIDTH_EXPAND_ELEMENT:754,WIDTH_COLLAPSE_ELEMENT:60,GAP:2,WIDTH_EXPAND_ELEMENT_LARGE:1200,WIDTH_COLLAPSE_ELEMENT_LARGE:96,LOADED_VIDEO_COUNT:20}},_enableAutoRotateAndTransition:true,constructor:function(b){this.allElement=new Ext.CompositeElementLite();this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get();this.isActivate=false;var a={cls:"rotate-data-view",hideParent:true,listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,afterrender:this.onAfterRenderFn}};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.RotateDataView.EVENT_LOAD_FAILED,this.onLoadFailed,this);this.mon(SYNO.SDS.VideoStation2.WindowSize.get(),SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE,this.onSizeModeChange,this)},restartRotateTask:function(){this.getAutoRotateTask().stop();if(this._enableAutoRotateAndTransition){this.getAutoRotateTask().restart(false)}},onActivate:function(){if(SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show")){return}this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.applyAutoRotateTask,this);this.isActivate=true;this.afterEffect();this.loadImage();this.applyAutoRotateTask()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.applyAutoRotateTask,this);this.isActivate=false;this.getAutoRotateTask().stop()},applyAutoRotateTask:function(){this._enableAutoRotateAndTransition=!SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","disable_slide_show");this.restartRotateTask()},onAfterRenderFn:function(c){var a=SYNO.SDS.VideoStation2.RotateDataView.CONSTANT;var b=(a.LOADED_VIDEO_COUNT*2-1)*(a.WIDTH_COLLAPSE_ELEMENT_LARGE+a.GAP)+(a.WIDTH_EXPAND_ELEMENT_LARGE+a.GAP);this.setWidth(b);this.getStore().load();this.mon(this.getEl(),"click",this.onDataViewClick,this)},onSizeModeChange:function(){this.setupOffset();if(this.isActivate&&this.isVisible()){this.afterEffect()}},onLoadFailed:function(){this.mun(SYNO.SDS.VideoStation2.WindowSize.get(),SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE,this.onSizeModeChange,this);this.hide()},onDataViewClick:function(d){var c=d.getTarget("div.rotate-sliding-element",this.getEl());if(!c){return}var b=this.allElement.indexOf(c);var a=this.getStore().getAt(b%this.getStore().getCount());if(!c.hasClassName("collapse")){this.intoVideoDatail(b,c,a);return}this.select(b);this.restartRotateTask()},setupOffset:function(){var b=SYNO.SDS.VideoStation2.RotateDataView.CONSTANT;var c=SYNO.SDS.VideoStation2.WindowSize.get().isLargeSizeMode();var d=c?b.WIDTH_EXPAND_ELEMENT_LARGE:b.WIDTH_EXPAND_ELEMENT;var a=c?b.WIDTH_COLLAPSE_ELEMENT_LARGE:b.WIDTH_COLLAPSE_ELEMENT;this.width_expand=d+b.GAP;this.width_collapse=a+b.GAP;this.shift_offset=(a/2)+b.GAP},getStore:function(){this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation2.AcrossLibrary",method:"list_movie",version:1,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),api:"SYNO.VideoStation2.AcrossLibrary",method:"list_movie",version:1,baseParams:{additional:["poster_mtime","summary"]},reader:new Ext.data.JsonReader({id:"id",root:"movie",totalProperty:"total",fields:["id","mapper_id","library_id","title","tagline","certificate","rating","original_available","metadata_locked","additional","type","path","sharepath","file_count","last_watched","create_time"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:function(){this.fireEvent(SYNO.SDS.VideoStation2.RotateDataView.EVENT_LOAD_FAILED)}}});return this._store},onBeforeLoadStore:function(a,b){this.removeAll(true);this.allElement.clear();var c=b.params;Ext.apply(c,{policy:"top_rating",limit:SYNO.SDS.VideoStation2.RotateDataView.CONSTANT.LOADED_VIDEO_COUNT,additional:["summary","poster_mtime","backdrop_mtime","file"]});Ext.applyIf(c,a.baseParams)},onAfterLoadStore:function(a){if(0===a.getCount()){this.fireEvent(SYNO.SDS.VideoStation2.RotateDataView.EVENT_LOAD_FAILED);return}this.videos=[];a.each(function(c){var d=c.data;SYNO.SDS.VideoStation2.ViewDetailUtil.processVideoData(d);this.videos.push(d)},this);var b=function(c){this.add(new SYNO.SDS.VideoStation2.RotateElement({video:c}))};Ext.each(this.videos,b,this);Ext.each(this.videos,b,this);this.doLayout();this.allElement.fill(Ext.query("div.rotate-sliding-element",this.getEl().dom));this.loadImage();this.setupOffset();this.cursor=0;this.getAt(this.cursor).expand();this.afterEffect()},getAt:function(a){var b=this.allElement.getCount();SYNO.Assert(Ext.isNumber(a)&&a<2*b-1&&a>-b,String.format("unexpceted index {0}",a));SYNO.Assert(Ext.isNumber(b)&&b>0,String.format("unexpceted count {0}",b));a=(a+b)%b;return this.items.itemAt(a)},select:function(a){var c=this.allElement.getCount();SYNO.Assert(Ext.isNumber(a)&&a<c&&a>=0,String.format("unexpceted index {0}",a));if(!Ext.isEmpty(this.cursor)){this.getAt(this.cursor).collapse()}this.getAt(a).expand();var b=this.cursor;this.cursor=a;this.updateElementPosition(b)},updateElementPosition:function(a){this.beforeEffect(a);this.delayAfterEffect()},beforeEffect:function(e){var a=this.getAt(this.cursor).getPosition(true)[0];var d=this.getAt(e).getPosition(true)[0];this.items.each(function(i,h){i.removeClass(["mask-element"]);if(this._enableAutoRotateAndTransition){i.addClass(["transition-effect"])}if(h!=this.cursor){i.addClass(["mask-element"])}},this);var f=a>0;if(f){var g=a-d;var c=1+Math.floor((g-this.width_expand)/this.width_collapse);var b=c*(this.width_collapse);this.items.each(function(j,h){var i=j.getPosition(true)[0];var k=b;if(d<i&&i<=a){k=k+(this.width_expand-this.width_collapse)}j.setPosition(i-k,0)},this)}else{this.items.each(function(j,h){var i=j.getPosition(true)[0];var k=this.width_collapse;if(h===e){k=k+(this.width_expand-this.width_collapse)}j.setPosition(i+k,0)},this)}},afterEffect:function(){this.items.each(function(c,b){c.removeClass(["transition-effect"]);var a=b-this.cursor,d;if(a<-2){a=this.allElement.getCount()+a}else{if(a>this.allElement.getCount()-3){a=a-this.allElement.getCount()}}c.getEl().setStyle("z-index",a+3);if(0===a){c.setPosition(this.shift_offset,0)}else{if(-1===a||-2===a){d=a*(this.width_collapse)+this.shift_offset;c.setPosition(d,0);c.addClass("mask-element")}else{d=this.width_expand+(a-1)*(this.width_collapse)+this.shift_offset;c.setPosition(d,0);c.addClass("mask-element")}}},this)},delayAfterEffect:function(){this.delayAffectEffectTask=this.delayAffectEffectTask||new Ext.util.DelayedTask(this.afterEffect,this);this.delayAffectEffectTask.cancel();this.delayAffectEffectTask.delay(1000)},getVideoData:function(a){return{id:this.getVideoID(a),type:this.getVideoType(),pathTitle:this.getVideoTitle(a),mapper_id:this.getVideoMapperID(a),library_id:this.getLibraryID(a)}},getLibraryID:function(a){return a.get("library_id")},getVideoType:function(){return SYNO.SDS.VideoStation2.Constant.MOVIE},getVideoID:function(a){return a.get("id")},getVideoMapperID:function(a){return a.get("mapper_id")},getVideoTitle:function(a){return a.get("title")},intoVideoDatail:function(b,d,a){var f=this.getStore().getRange().map(function(g){return this.getVideoData(g)},this);var c={videolist:f};var e=String.format("{0}-{1}",this.getVideoType(),this.getLibraryID(a));SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(e);SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(c))},selectNext:function(){if(Ext.isEmpty(this.cursor)||0===this.allElement.getCount()){return}var a=(this.cursor+1)%this.allElement.getCount();this.select(a)},getAutoRotateTask:function(){this._autoRotateTask=this._autoRotateTask||this.addTask({interval:8000,scope:this,run:this.selectNext});return this._autoRotateTask},loadImage:function(){this.allElement.each(function(b){var a=Ext.fly(b).select(".loading");Ext.each(a.elements,this.loader.appendJob,this.loader)},this)}});Ext.define("SYNO.SDS.VideoStation2.ViewHomePage",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={cls:"view-home-page",autoFlexcroll:true,items:[this.rotateSlidingView=new SYNO.SDS.VideoStation2.RotateSlidingView(),this.librarySlidingView=new SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.librarySlidingView,[SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView.EVENT_SLIDINGVIEW_TOGGLE,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView.EVENT_SLIDINGVIEW_TOGGLE)}});Ext.define("SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView",{statics:{EVENT_SLIDINGVIEW_TOGGLE:"slidingviewtoggle"},extend:"SYNO.ux.Panel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)},fillConfig:function(a){var b={cls:"library-sliding-view",layout:"anchor",items:[],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadView,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadView,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.loadView,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadAllLibrary,this);this.loadView()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadView,this);this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadView,this);this.mun(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.loadView,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadAllLibrary,this);this.items.each(function(a){a.onDeactivate()},this)},loadView:function(){this.getStore().load()},getStore:function(){this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation2.AcrossLibrary",method:"list_library",version:1,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),api:"SYNO.VideoStation2.AcrossLibrary",method:"list_library",version:1,baseParams:{policy:"recently_added"},reader:new Ext.data.JsonReader({id:"id",root:"library",totalProperty:"total",fields:["id","is_public","title","type","visible"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)}}});return this._store},onBeforeLoadStore:function(){this.removeAll(true);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this)},onAfterLoadStore:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);if(this.hidden){return}if(0===b.getCount()){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this);return}Ext.each(a,function(d){if(d.get("visible")===false){return true}var c=new SYNO.SDS.VideoStation2.HomePageSlidingView({libraryData:Ext.copyTo({},d.data,["type","id","title"])});this.mon(c,SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_SHOWHIDE_TOGGLE,function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView.EVENT_SLIDINGVIEW_TOGGLE)},this,{buffer:100});this.add(c)},this);this.doLayout();this.loadAllLibrary()},loadAllLibrary:function(){this.items.each(function(a){a.onActivate()},this)}});Ext.define("SYNO.SDS.VideoStation2.HomePageSlidingView",{statics:{EVENT_CURSOR_CHANGE:"cursorchange",EVENT_SHOWHIDE_TOGGLE:"showhidetoggle",DATA_VIEW_PADDING_TOP:4},extend:"SYNO.ux.Panel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.mon(this,SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_CURSOR_CHANGE,this.updatePagingBar,this)},fillConfig:function(a){this.libraryType=a.libraryData.type;this.libraryId=a.libraryData.id;this.imageStyle=(this.libraryType===SYNO.SDS.VideoStation2.Constant.MOVIE||this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW)?"poster":"landscape";this.slideview=new SYNO.SDS.VideoStation2.SlidableDataView({getView:this.getDataView.createDelegate(this),height:(this.imageStyle==="poster"?238:176)+SYNO.SDS.VideoStation2.HomePageSlidingView.DATA_VIEW_PADDING_TOP,dataViewMargin:0});var b={cls:String.format("{0} {1}","sliding-view",this.imageStyle),tbar:[{xtype:"tbspacer",width:2},{xtype:"box",cls:String.format("{0} {1}","library-icon",this.libraryId===0?this.libraryType:"library")},{xtype:"tbspacer",width:6},{xtype:"button",cls:"library-title",html:Ext.util.Format.htmlEncode(a.libraryData.title),scope:this,handler:this.intoLibraryPage},"->",this.prevBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"prev-button",scope:this,handler:this.intoPrevPage}),{xtype:"tbspacer",width:16},this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"next-button",scope:this,handler:this.intoNextPage})],items:[this.slideview]};Ext.apply(b,a);return b},onActivate:function(){this.mon(this,"resize",this.onResizeEvent,this);this.loadView()},onDeactivate:function(){this.mun(this,"resize",this.onResizeEvent,this)},loadView:function(){this.hideMode="visibility";this.hide();this.updatePageSize();this.total=0;this.setCursor(0);this.onResetStore();this.slideview.onActivate()},onResizeEvent:function(){this.updatePageSize();this.slideview.onActivate()},updatePageSize:function(){var a=this.imageStyle==="poster"?120:180,c=this.imageStyle==="poster"?20:17,b=a+c;this.pageSize=Math.floor(this.getInnerWidth()/b)},onResetStore:function(){var a=[this.slideview.getLeftView(),this.slideview.getCenterView(),this.slideview.getRightView()];Ext.each(a,function(b){var c=b.dataView.getStore();c.setBaseParam("offset",0);c.lastParams=null},this)},prepareFn:function(a,c){var b=a.dataView.getStore();if(b.baseParams&&b.baseParams.offset===c){return}b.setBaseParam("offset",c);a.fireEvent("activate")},prepareView:function(){var a=this.cursor-this.pageSize;if(a>=0){this.prepareFn(this.slideview.getLeftView(),a)}a=this.cursor+this.pageSize;if(a<=this.total){this.prepareFn(this.slideview.getRightView(),a)}},intoPrevPage:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.setCursor(Math.max(this.cursor-this.pageSize,0));this.slideview.prepareView(a.left,true);this.slideview.intoLeft(true);this.prepareView()},intoNextPage:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.setCursor(Math.min(this.cursor+this.pageSize,this.total));this.slideview.prepareView(a.right,true);this.slideview.intoRight(true);this.prepareView()},intoLibraryPage:function(){var a=String.format("{0}-{1}",this.libraryType,this.libraryId);SYNO.SDS.VideoStation2.Controller.switchLibrary(a)},getDataView:function(b){var c=this;var a={decoratorConfig:{thumbCls:c.imageStyle},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores[c.libraryType]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore}});return this._store},onBeforeLoadStore:function(d,e){var f=e.params;Ext.apply(f,SYNO.SDS.VideoStation2.Sort.get().getSortOption());Ext.apply(f,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());Ext.apply(f,{library_id:c.libraryId,limit:c.pageSize});Ext.applyIf(f,d.baseParams);if(Ext.isDefined(d.lastParams)&&SYNO.ux.Utils.checkObjectConsistency(d.lastParams,f)){return false}d.lastParams=f},onAfterLoadStore:function(d){c.total=d.getTotalCount();if(0===c.total){c.hideMode="display";c.hide();c.fireEvent(SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_SHOWHIDE_TOGGLE);return}if(!c.isVisible()){c.show();c.fireEvent(SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_SHOWHIDE_TOGGLE)}c.updatePagingBar();c.prepareView()},getImageURL:function(d){return SYNO.SDS.VideoStation2.Util.getImageURL({type:c.libraryType,id:d.id,mtime:d.additional?d.additional.poster_mtime||"":""})},getLibraryID:function(){return c.libraryId},startVideoAction:function(d){this.clearVideoSelection();this.addVideoSelection(d);var e=SYNO.SDS.VideoStation2.Library.get().getLibraryByIDAndType(c.libraryId,c.libraryType);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(e.opid)},listeners:{scope:c,click:this.onViewItemClick}};return new SYNO.SDS.VideoStation2.HomePageWrapperDataView(Ext.apply(b,{childCfg:{decorator:a,disableAction:(this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW),videoType:this.libraryType}}))},onViewItemClick:function(b,c,f,g){var i=String.format("{0}-{1}",this.libraryType,this.libraryId);var a=b.getRecord(f);var h=function(e){return e.map(function(j){return b.getVideoData(j)})};var d={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(b.getStore().lastParams),totalCount:b.getStore().getTotalCount(),toVideos:h,videolist:h(b.getStore().getRange())};SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(i);switch(this.libraryType){case SYNO.SDS.VideoStation2.Constant.TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow(a.data);break;default:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(d));break}},setCursor:function(a){SYNO.Assert(Ext.isNumber(a)&&a>=0,String.format("unexpceted cursor {0}",a));this.cursor=a;this.fireEvent(SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_CURSOR_CHANGE)},updatePagingBar:function(){var b=Math.ceil((this.cursor+this.pageSize)/this.pageSize),a=this.total<this.pageSize?1:Math.ceil(this.total/this.pageSize);if(1===a){this.prevBtn.hide();this.nextBtn.hide()}else{this.prevBtn.show();this.nextBtn.show()}this.prevBtn.setDisabled(b===1);this.nextBtn.setDisabled(b===a)},show:function(){var a=this.getVisibilityEl();if(a){a.removeClass(["x-hide-display","x-hide-visibility"])}this.callParent(arguments)},hide:function(){var a=this.getVisibilityEl();if(a){a.removeClass(["x-hide-display","x-hide-visibility"])}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.HomePageWrapperDataView",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.dataView=new SYNO.SDS.VideoStation2.ThumbDataView(a.childCfg);var b={layout:"fit",items:[this.dataView]};delete a.childCfg;Ext.apply(b,a);return b},onActivate:function(){this.dataView.getStore().load()}});Ext.define("SYNO.SDS.VideoStation2.ViewPlaylist",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.dataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Playlist",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn,resize:this.onResizeEvent}});var a={cls:"view-playlist",layout:"fit",items:[this.dataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists();this.callParent(arguments)},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);this.callParent(arguments)},onPlaylistLoaded:function(){this.dataview.getDataviewStore().loadData(SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists());this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onViewItemClick:function(b,c,d,f){var a=b.getRecord(d);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PLAYLIST,a.get("id"),a.get("playlist_title"))},onResizeEvent:function(a,f,d,b,e,c){this.updatePlaylistMargin(f)},updatePlaylistMargin:function(b){var a=".syno-vs2-win .view-playlist .thumb-dataview .thumb-wrap.square",e="margin-right",d=204,c=10;SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(a,e,b,d,c)}});Ext.define("SYNO.SDS.VideoStation2.ViewPoster",{extend:"SYNO.ux.Panel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.items.each(function(b){this.relayEvents(b,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO])},this)},fillConfig:function(a){this.dataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Common",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn,resize:this.onDataviewResizeEvent}});this.folderDataView=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Byfolder",listeners:{scope:this,click:this.onFolderViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn,resize:this.onSquareDataviewResizeEvent}});this.byChannelDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"RecordingSpecific",listeners:{scope:this,click:this.onChannelViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,beforeselect:function(){return false},contextmenu:Ext.emptyFn,resize:this.onSquareDataviewResizeEvent}},{decoration:{specialTVRecordType:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL}});this.byProgramDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"RecordingSpecific",listeners:{scope:this,click:this.onProgramViewItemClick,dblclick:Ext.emptyFn,beforeselect:function(){return false},contextmenu:Ext.emptyFn,resize:this.onSquareDataviewResizeEvent}},{decoration:{specialTVRecordType:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM}});this.playlistPosterDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"PlaylistPoster",listeners:{scope:this,click:this.onPlaylistViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn,resize:this.onDataviewResizeEvent}});var b={layout:"card",cls:"view-poster-panel",items:[this.dataview,this.folderDataView,this.byChannelDataview,this.byProgramDataview,this.playlistPosterDataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onViewItemClick:function(b,c,f,g){var a=b.getRecord(f);var h=function(e){return e.map(function(i){return b.getVideoData(i)})};var d={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(b.getStore().lastOptions.params),totalCount:b.getStore().getTotalCount(),toVideos:h,videolist:h(b.getStore().getRange())};switch(SYNO.SDS.VideoStation2.Library.get().getCurrentType()){case SYNO.SDS.VideoStation2.Constant.TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow(a.data);break;default:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(d));break}},onPlaylistViewItemClick:function(b,c,f,g){var a=b.getRecord(f);var h=function(e){return e.map(function(i){return b.getVideoData(i)})};var d={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(b.getStore().lastOptions.params),totalCount:b.getStore().getTotalCount(),toVideos:h,videolist:h(b.getStore().getRange())};SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(d))},onFolderViewItemClick:function(b,c,g,h){var a=b.getRecord(g);if(a.get("type")===SYNO.SDS.VideoStation2.Constant.FOLDER){SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.FOLDER,a.get("id"),a.get("title"));return}var d=(a.get("additional")||{}).metadata;if(!d){return}var i=function(e){return e.map(function(k){if("file"!==k.get("type")){return}var j=(k.get("additional")||{}).metadata;if(!j){return}return b.getVideoData(k)}).filter(function(j){return Ext.isObject(j)})};var f={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(b.getStore().lastOptions.params),totalCount:b.getStore().getTotalCount(),toVideos:i,videolist:i(b.getStore().getRange())};SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(f))},onChannelViewItemClick:function(b,c,d,f){var a=b.getRecord(d);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.CHANNEL,null,a.get("title"))},onProgramViewItemClick:function(b,c,d,f){var a=b.getRecord(d);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PROGRAM,null,a.get("title"))},onCategoryChange:function(a,b){if(SYNO.SDS.VideoStation2.Category.isSpecialCategory(a)||SYNO.SDS.VideoStation2.Category.isSpecialCategory(b)){this.activateCurrentDataView();return}this.onSortChanged()},onSortChanged:function(){if(this.dataview===this.layout.activeItem||this.byChannelDataview===this.layout.activeItem||this.byProgramDataview===this.layout.activeItem||this.playlistPosterDataview===this.layout.activeItem){this.layout.activeItem.resetPaging()}},onFilterChange:function(){if(this.dataview===this.layout.activeItem){this.dataview.resetPaging()}},onRecordingSpecificSet:function(){if(this.dataview!==this.layout.activeItem){this.activateCurrentDataView()}},onRecordingSpecificClear:function(){if(this.dataview===this.layout.activeItem){this.activateCurrentDataView()}},activateCurrentDataView:function(){var c;var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var a=SYNO.SDS.VideoStation2.RecordingSpecific.get().isSet();if(SYNO.SDS.VideoStation2.Constant.PLAYLIST===SYNO.SDS.VideoStation2.Library.get().getCurrentType()){c=this.playlistPosterDataview}else{if(SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER===b){c=this.folderDataView}else{if(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL===b){c=!a?this.byChannelDataview:this.dataview}else{if(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM===b){c=!a?this.byProgramDataview:this.dataview}else{c=this.dataview}}}}var d=this.layout.activeItem;SYNO.Assert(c,String.format("unexpceted dataView in view_poster"));if(d!==c){this.layout.setActiveItem(c)}else{if(d){d.fireEvent("activate")}}},clearActiveItem:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this);this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onSortChanged,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificSet,this);this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificClear,this);this.activateCurrentDataView();if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW){this.dataview.items.each(function(a){a.enableSelectMode=false;a.hideAction()})}else{this.dataview.items.each(function(a){a.enableSelectMode=true;a.showAction()})}},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this);this.mun(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onSortChanged,this);this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificSet,this);this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificClear,this);this.clearActiveItem()},onDataviewResizeEvent:function(a,f,d,b,e,c){this.updatePosterMargin(f);this.updateLandscapeMargin(f)},onSquareDataviewResizeEvent:function(a,f,d,b,e,c){this.updatePosterMargin(f);this.updateLandscapeMargin(f);this.updateSquareMargin(f)},updatePosterMargin:function(b){var a=".syno-vs2-win .view-poster-panel .thumb-dataview .thumb-wrap.poster",e="margin-right",d=120,c=10;SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(a,e,b,d,c)},updateLandscapeMargin:function(b){var a=".syno-vs2-win .view-poster-panel .thumb-dataview .thumb-wrap.landscape",e="margin-right",d=180,c=10;SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(a,e,b,d,c)},updateSquareMargin:function(b){var a=".syno-vs2-win .view-poster-panel .thumb-dataview .thumb-wrap.square",e="margin-right",d=204,c=10;SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(a,e,b,d,c)}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.detail_area=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea();this.season_area=new SYNO.SDS.VideoStation2.ViewTVShow.SeasonArea({region:"center"});var a={cls:"view-tvshow",layout:"border",items:[this.detail_area,this.season_area],listeners:{scope:this,resize:this.adjustAreaSize,afterlayout:this.onAfterLayout}};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.season_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED]);this.mon(this.detail_area,"afterrender",this.onDetailAreaAfterRender,this);this.mon(this.season_area,"flexcroll",this.onDataviewScrolled,this);this.mon(this.detail_area.season_bar,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar.EVENT_SEASON_CLICK,this.onSeasonClick,this)},adjustAreaSize:function(b,c,a){c=this.getInnerWidth();if(c>26){c=c-26}this.detail_area.setWidth(c);this.season_area.getAllDataViews().each(function(d){d.getEl().setStyle("padding-top",this.detail_area.getHeight()+"px")},this);this.updateEpisodeMargin(c)},onAfterLayout:function(a){var b=a.getEl().query(".flexcrollactive")[0];this.adjustDetailAreaAlign(b)},onDataviewScrolled:function(a){var b=a.getEl().dom;this.adjustDetailAreaAlign(b,true)},adjustDetailAreaAlign:function(e,b){if(!e||!e.fleXdata){return}if(false===e.fleXdata.scrollPosition[1][0]&&!b){return}var d=this.getEl();if(!d){return}var c=e.fleXdata.scrollPosition[1][0]||0;var g=Ext.max([0,this.detail_area.getHeight()-this.detail_area.getBottomScrollMargin()]);var f=(c>g);this.detail_area[(f)?"addClass":"removeClass"]("block-background");var a=(f)?g:c;this.detail_area.getEl().alignTo(d,"tl-tl",[d.getPadding("l"),d.getPadding("t")-a])},onDetailAreaMouseWheel:function(a){this.season_area.updateDataviewScroll(a)},onDetailAreaAfterRender:function(){this.mon(this.detail_area.getEl(),"mousewheel",this.onDetailAreaMouseWheel,this)},onSeasonClick:function(b){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.season_area.prepareSeason(a,b)},onActivate:function(){this.adjustAreaSize();this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this);this.refreshInfo()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},loadBackdrop:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();var b=SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:a.mapper_id,mtime:(a.additional&&a.additional.backdrop_mtime)||""});SYNO.SDS.VideoStation2.Controller.setBackdrop(b)},refreshInfo:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);SYNO.SDS.VideoStation2.OP.get().getInfo({id:[SYNO.SDS.VideoStation2.TVShow.get().getCurrentID()],additional:["poster_mtime","summary","backdrop_mtime"]},{scope:this,success:this.onInfoLoad,failure:this.onInfoLoadFail},SYNO.SDS.VideoStation2.Constant.TVSHOW)},onInfoLoad:function(c,b,a){if(Ext.isEmpty(c.tvshow)){this.onInfoLoadFail();return}SYNO.SDS.VideoStation2.TVShow.get().updateTVShow(c.tvshow[0]);SYNO.SDS.VideoStation2.Controller.updatePath();this.loadBackdrop();this.detail_area.reloadInfo();this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onInfoLoadFail:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.goback()},updateEpisodeMargin:function(b){var a=".syno-vs2-win .view-tvshow .thumb-dataview .thumb-wrap.landscape",e="margin-right",d=180,c=7;SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(a,e,b,d,c)}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.image=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Image({region:"west"});this.info_area=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.InfoArea({region:"center"});this.season_bar=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar({region:"south"});var a={cls:"detail-area",floating:true,shadow:false,layout:"border",height:480,items:[this.image,this.info_area,this.season_bar]};this.callParent([Ext.apply(a,b)])},getBottomScrollMargin:function(){if(!this.season_bar.getEl()){return 0}var a=parseInt(this.season_bar.getEl().getMargins("b"),10);return this.season_bar.getHeight()+a},onActivate:function(){this.image.loadImage();this.season_bar.loadSeasons()},reloadInfo:function(){this.image.loadImage();this.info_area.loadSummary()}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Image",{extend:"Ext.Container",constructor:function(b){var a={cls:"image",margins:"0 30 0 0"};this.callParent([Ext.apply(a,b)])},loadImage:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();var b=SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Constant.TVSHOW,id:a.id,mtime:(a.additional&&a.additional.poster_mtime)||""});this.getEl().setStyle("background-image",String.format("url({0})",b))}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.InfoArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.dataview=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Dataview();var a={cls:"info-area",autoFlexcroll:true,height:50,items:[this.dataview]};this.callParent([Ext.apply(a,b)])},loadSummary:function(){this.dataview.loadSummary()}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Dataview",{extend:"Ext.DataView",constructor:function(b){var a={tpl:this.getTpl(),cls:"tvshow-dataview",store:this.getStore(),singleSelect:true,listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(a,b)])},onActivate:function(){this.bindStore(this.getStore());this.loadSummary()},onDeactivate:function(){this.bindStore(null)},loadSummary:function(){this.getStore().loadData([SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow()])},getStore:function(){this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","title","mapper_id","metadata_locked","original_available","sort_title","additional"]});return this.store},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="title">{values.title:htmlEncode}</div>','<div class="info tag">{[_VST("original_available", "title")]}: {values.original_available:htmlEncode}</div>',String.format('<div class="summary-title">{0}</div>',Ext.util.Format.htmlEncode(_VST("summary","title"))),'<div class="summary">{values.additional.summary:htmlEncode}</div>',"</tpl>",'<div class="x-clear"></div>');return a}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar",{statics:{EVENT_SEASON_CLICK:"seasonclick"},extend:"Ext.Container",constructor:function(b){this.season_list=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList();this.season_action=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction({region:"east"});var a={cls:"season-bar",layout:"border",margins:"20 0 10 0",listeners:{scope:this,afterlayout:this.fixSelectPosition},items:[{xtype:"tbtext",text:_VST("season","season_title"),cls:"season-label",region:"west",margins:"0 6 0 18"},{xtype:"container",cls:"season-viewport",region:"center",items:[this.season_list]},this.season_action]};this.callParent([Ext.apply(a,b)]);this.mon(this.season_action,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,this.onScrollBtnClick,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED,this.loadSeasons,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this)},loadSeasons:function(){var e=this.season_list.getEl();var d=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SELECTOR_WIDTH;var c=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SEASON_MARGIN;if(e){e.setLeft(-d)}this.season_list.removeAll();var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(!a){return}this.season_select=new SYNO.SDS.VideoStation2.ActionButton({cls:"season-select",x:d+c/2,floating:true});this.season_list.add(this.season_select);a.each(function(f){this.season_list.add(new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item",text:f||"?",itemId:f.toString(),margins:"10 16 10 16",enableToggle:true,toggleGroup:"season-item",handler:this.onSeasonClick,scope:this}))},this);this.season_list.doLayout();var b=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();if(Ext.isNumber(b)){this.scrollToButton(b,true);this.moveSelectToButton(b)}else{this.scrollToButton(a[0])}},moveSelectToButton:function(a){if(!Ext.isNumber(a)){return}var b=this.season_list.getComponent(a.toString());if(!b){return}b.toggle(true);var c=b.getEl().getOffsetsTo(this.season_list.getEl());var d=this.season_select.getEl();d.setLeftTop.apply(d,c);this.season_select.setWidth(b.getWidth())},scrollToButton:function(f,a){if(!Ext.isNumber(f)){return}if(a){var i=this.getMaxVisibleSeasonCount();var d=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(i>=d.length){f=d[0]}else{var j=Math.floor(d.indexOf(f)-i/2);f=d[j>=0?j:0]}}var e=this.season_list.getComponent(f.toString());var g=this.season_list.getEl();var h=e.getEl();var c=h.getOffsetsTo(g)[0];var b=e.margins.left;g.setLeft(-(c-b));this.currentScroll=f;this.season_action.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED,this.currentScroll)},fixSelectPosition:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.moveSelectToButton(a)},getMaxVisibleSeasonCount:function(){var c=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SELECTOR_WIDTH;var b=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SEASON_MARGIN;var a=this.season_list.ownerCt.getWidth();return Math.floor(a/(c+b))},onSeasonChanged:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.moveSelectToButton(a)},onSeasonClick:function(a){a.toggle(false);var b=parseInt(a.itemId,10);if(SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason()!==b){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar.EVENT_SEASON_CLICK,parseInt(a.itemId,10))}else{a.toggle(true)}},onScrollBtnClick:function(c){var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();var b=a.indexOf(this.currentScroll)+c;if(b<=-1||b>=a.length){return}this.scrollToButton(a[b])}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList",{statics:{SELECTOR_WIDTH:28,SEASON_MARGIN:32},extend:"Ext.Container",constructor:function(b){var a={layout:"hbox",cls:"season-list",layoutConfig:{align:"top"},items:[]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction",{statics:{EVENT_SCROLL_BTN_CLICK:"scrollbtnclick",EVENT_SCROLL_CHANGED:"scrollchanged"},extend:"Ext.Container",constructor:function(b){var a={layout:"hbox",margins:"0 4 0 0",layoutConfig:{align:"top"},cls:"season-action",width:2*(24+7),items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item back",margins:"10 7 10 0",handler:this.scrollLeft,scope:this}),new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item next",margins:"10 0 10 7",handler:this.scrollRight,scope:this})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK);this.addEvents(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED);this.mon(this,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED,this.onScrollChange,this)},scrollLeft:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,-1)},scrollRight:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,1)},onScrollChange:function(a){var b=SYNO.SDS.VideoStation2.TVShow.get().getTotalSeasons();this.items.items[0].setDisabled(a===1);this.items.items[1].setDisabled(a===b)}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.SeasonArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.relayEvents(this.slideview,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED])},fillConfig:function(a){this.slideview=new SYNO.SDS.VideoStation2.SlidableDataView({getView:this.getSwitchableView.createDelegate(this),dataViewMargin:20});var b={layout:"fit",cls:"view-tvshow-panel",items:[this.slideview]};Ext.apply(b,a);return b},updateDataviewScroll:function(c){var a=this.slideview.getCenterView().getActiveView();var b=null;if(!a||!(b=a.getEl())){return}var d=b.hasClass("flexcrollactive")?b.dom:b.query(".flexcrollactive")[0];if(!d){return}d.fleXcroll.scrollContent(0,c.getWheelDelta()*-120)},onViewItemClick:function(b,c,f,g){var a=b.getRecord(f);var h=b.getStore().data.items.map(function(e){return this.getVideoData(e)},b);var d={videolist:h};SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(d))},onFlexcroll:function(a){if(this.slideview.getCenterView().getActiveView()===a){this.fireEvent("flexcroll",a)}},onSeasonChanged:function(d,f){if(d===null){this.prepareSeason(d,f);return}var b=this.slideview.getCenterView().getActiveView();var e=null;var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();var c=a.indexOf(f);var g=a.indexOf(d);if(c<g){e=this.slideview.getLeftView().getActiveView();this.slideview.getLeftView().filterStore();this.syncScroll(b,e);this.slideview.intoLeft(true)}else{e=this.slideview.getRightView().getActiveView();this.slideview.getRightView().filterStore();this.syncScroll(b,e);this.slideview.intoRight(true)}this.slideview.getCenterView().getActiveView().onVideoSelectionChange()},onSeasonPrepared:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.TVShow.get().selectSeason(this.preparingSeason);if(this.preparingStore){this.mun(this.preparingStore,"load",this.onSeasonPrepared,this);this.preparingStore=null}},syncScroll:function(d,c){var b=d.getEl().dom;var a=c.getEl().dom;if(!a.fleXcroll){return}a.fleXcroll.setScrollPos(0,b.fleXdata.scrollPosition[1][0]||0,false)},prepareSeason:function(d,f){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);if(this.preparingStore){this.mun(this.preparingStore,"load",this.onSeasonPrepared,this);this.preparingStore=null}this.preparingSeason=f;var e=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;var c;if(Ext.isNumber(d)){var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();var b=a.indexOf(f);var g=a.indexOf(d);if(b<g){this.slideview.prepareView(e.left);c=this.slideview.getLeftView()}else{this.slideview.prepareView(e.right);c=this.slideview.getRightView()}}else{c=this.slideview.getCenterView()}if(c.isNeedLoadStore()){this.preparingStore=c.getDataviewStore();this.mon(this.preparingStore,"load",this.onSeasonPrepared,this,{delay:100,single:true})}else{this.onSeasonPrepared()}},getSwitchableView:function(b){var a={decorator:"Season",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,flexcroll:this.onFlexcroll,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}};return new SYNO.SDS.VideoStation2.SwitchableDataView(a,b)},getAllDataViews:function(){var a=[];a=a.concat(this.slideview.getLeftView().items.items);a=a.concat(this.slideview.getCenterView().items.items);a=a.concat(this.slideview.getRightView().items.items);return a},onActivate:function(){this.callParent(arguments);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this)},onDeactivate:function(){this.callParent(arguments);this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this);this.slideview.items.each(function(a){a.clearLoadedInfo();a.fireEvent("deactivate",a)})}});Ext.define("SYNO.SDS.VideoStation2.NavigationPanel",{extend:"SYNO.SDS.VideoStation2.ViewCardPanel",constructor:function(c){var a={};a[SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE]=new SYNO.SDS.VideoStation2.ViewHomePage({itemId:"homepage"});a[SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST]=new SYNO.SDS.VideoStation2.ViewPlaylist({itemId:"playlist"});a[SYNO.SDS.VideoStation2.View.VIEW_POSTER]=new SYNO.SDS.VideoStation2.ViewPoster({itemId:"poster"});a[SYNO.SDS.VideoStation2.View.VIEW_DETAIL]=new SYNO.SDS.VideoStation2.ViewDetail({itemId:"detail"});a[SYNO.SDS.VideoStation2.View.VIEW_TVSHOW]=new SYNO.SDS.VideoStation2.ViewTVShow({itemId:"tvshow"});var b={views:a,tbar:new SYNO.SDS.VideoStation2.NavigationBar(),listeners:{scope:this,afterrender:this.insertBackgroundPosterEl}};this.callParent([Ext.apply(b,c)])},insertBackgroundPosterEl:function(a){a.getEl().insertFirst({tag:"div",cls:"background-poster",cn:[{tag:"div",cls:"background-poster-gradient"}]})}});Ext.define("SYNO.SDS.VideoStation2.MainPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={cls:"main-panel",border:false,layout:"border",items:[new SYNO.SDS.VideoStation2.MainList({region:"west"}),new SYNO.SDS.VideoStation2.MainCardPanel({region:"center"})]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.MainCardPanel",{extend:"SYNO.SDS.VideoStation2.ViewCardPanel",constructor:function(b){var a={cls:"main-card-panel",views:{navigation:new SYNO.SDS.VideoStation2.NavigationPanel({itemId:"navigation"}),dtv:new SYNO.SDS.VideoStation2.DTVNavigationPanel({itemId:"dtv"})},listeners:{scope:this,afterrender:this.insertBackgroundPanel,afterlayout:this.onPanelLayout,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.loadView,this);this.onActivate()},insertBackgroundPanel:function(a){if(!this._no_video_panel){this._no_video_panel=new SYNO.SDS.VideoStation2.NoVideoPanelWrapper({renderTo:a.getEl()})}else{this._no_video_panel.render(a.getEl())}},onPanelLayout:function(){this._no_video_panel.doLayout()},onBeforeDestroy:function(){this._no_video_panel.destory();this._no_video_panel=null},getItemByView:function(){var a;this.items.each(function(b){if(b.getItemByView()){a=b;return false}},this);return a},onViewLoading:function(a,b){this._no_video_panel.hide();if(a){SYNO.SDS.VideoStation2.Util.unmask(a)}if(b){SYNO.SDS.VideoStation2.Util.maskLoadingMsg(this,b,true)}else{SYNO.SDS.VideoStation2.Util.maskLoading(this,true)}},onViewLoaded:function(){SYNO.SDS.VideoStation2.Util.unmask(this)},onViewNoVideo:function(b){var c=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE;var f=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();if(c&&!f){this._no_video_panel.show();this._no_video_panel.doLayout();return}var g=SYNO.SDS.VideoStation2.Library.get().getCurrentType();var a=(g!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&g!==SYNO.SDS.VideoStation2.Constant.PLAYLIST);var e=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED;var d=!SYNO.SDS.VideoStation2.Filter.get().isFilterEmpty();if(_S("is_admin")&&!f&&!d&&!e&&a){SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("tip","click_create_folder"),this.launchAddFolderDialog,true)}else{SYNO.SDS.VideoStation2.Util.maskInfo(b,_VST("common","no_video_item"),null,true)}},onViewChannelScan:function(){if(_S("is_admin")||SYNO.SDS.VideoStation2.Capability.get().ableToControlDTV()){SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("error","dtv_channeltable_not_found"),this.launchScanChannelDialog,true)}else{SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("error","dtv_no_function"),null,true)}},onViewNoTuner:function(){SYNO.SDS.VideoStation2.Util.maskInfo(this,String.format(_VST("error","dtv_request_dongle2"),'<a target="_blank" style="color:#FFFFFF; text-decoration: underline;" href="https://www.synology.com/en-global/compatibility?search_by=category&category=usb_tv_dongles&p=1&not_recommend_mode=false">Synology website</a>'),Ext.emptyFn,false)},launchAddFolderDialog:function(){var a=new SYNO.SDS.VideoStation2.Setting.Dialog({initActiveTab:0});SYNO.SDS.VideoStation2.SettingController.get().openDialog(a)},launchScanChannelDialog:function(){var a=new SYNO.SDS.VideoStation2.ChannelScanDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentDTV(),onChannelScaned:SYNO.SDS.VideoStation2.Controller.refreshView});a.open()}});Ext.define("SYNO.SDS.VideoStation2.NoVideoPanelWrapper",{extend:"Ext.Container",constructor:function(b){var a={cls:"no-video-panel",layout:"fit",hidden:true,items:[new SYNO.SDS.VideoStation2.NoVideoPanel({})]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.NoVideoPanel",{extend:"Ext.Container",constructor:function(b){var a={cls:"inner",html:this.getContent()};this.callParent([Ext.apply(a,b)])},getContent:function(){var a=_S("is_admin")?_VST("common","homepage_no_video_admin"):_VST("common","homepage_no_video");return['<div class="empty-icon"></div>',String.format('<div class="description">{0}</div>',Ext.util.Format.htmlEncode(a))].join("")}});Ext.define("SYNO.SDS.VideoStation2.AccountButton",{extend:"SYNO.SDS.VideoStation2.TransparentButton",constructor:function(b){var a={cls:"account",text:_S("user"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:[new Ext.Action({text:_VST("common","about"),handler:function(){SYNO.SDS.VideoStation2.Window.showAboutWindow()}}),new Ext.Action({text:_T("common","logout"),handler:function(){SYNO.SDS.Utils.Logout.logout(true)}})]}),menuAlign:"tr-br"};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu",{extend:"SYNO.SDS.VideoStation2.CompositeMenu",constructor:function(b){var a={cls:"filter-menu",items:[this.panel=new SYNO.SDS.VideoStation2.FilterMenu.Panel({owner:this})]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.panel,[SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU]);this.mon(this.panel,SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU,this.onCloseMenu,this);this.mon(this.panel,SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT,this.doLayout,this)},show:function(b,c,a){if(this.alignTarget){b=this.alignTarget.getEl()||b}this.callParent(arguments)},onCloseMenu:function(){this.hide()}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Panel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={tbar:new SYNO.SDS.VideoStation2.FilterMenu.Toolbar(),layout:"accordion",cls:"filter-menu-panel",layoutConfig:{titleCollapse:false,animate:true,activeOnTop:false},items:[this.commonOptions=[new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR}),new SYNO.SDS.VideoStation2.FilterMenu.RatingOption({owner:b.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_RATING})],this.tvRecordingOptions=[new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_DATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DATE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_TITLE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_TITLE})],new SYNO.SDS.VideoStation2.FilterMenu.ResolutionOption({owner:b.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION}),new SYNO.SDS.VideoStation2.FilterMenu.WatchedStatusOption({owner:b.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS}),new SYNO.SDS.VideoStation2.FilterMenu.FileCountOption({owner:b.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:b.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER}),new SYNO.SDS.VideoStation2.FilterMenu.DurationOption({owner:b.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION}),new SYNO.SDS.VideoStation2.FilterMenu.KeywordOption({owner:b.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD})],listeners:{scope:this,activate:this.onActivate}};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.getTopToolbar(),[SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU]);this.items.each(function(c){this.relayEvents(c,[SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT])},this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this);this.onLibraryChanged()},onActivate:function(){if(this.layout.activeItem){this.layout.activeItem.fireEvent("activate")}},onLibraryChanged:function(){var c=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TV_RECORDING;this.commonOptions.each(function(d){d.setVisible(!c)});this.tvRecordingOptions.each(function(d){d.setVisible(c)});if(this.rendered){this.items.each(function(d){d.collapse(false)});var b=this[c?"tvRecordingOptions":"commonOptions"][0];b.expand(false);var a=b.header.getHeight();b.items.each(function(d){a+=d.getOuterSize().height});b.setHeight(a);this.doLayout()}else{if(this.ownerCt){this.ownerCt.render()}}}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Toolbar",{extend:"SYNO.ux.Toolbar",statics:{EVENT_CLOSE_MENU:"closemenu"},constructor:function(b){var a={cls:"filter-menu-toolbar",items:[{xtype:"tbtext",text:_VST("filter","title")},"->",this.createSmartPlaylistBtn=new SYNO.SDS.VideoStation2.FilterMenu.ActionButton({cls:"list_add",scope:this,handler:this.onCreateSmartPlaylist,tooltip:_VST("playlist","action_save_as_smart"),disabled:true}),{xtype:"tbseparator"},new SYNO.SDS.VideoStation2.FilterMenu.ActionButton({cls:"erase_s",tooltip:_VST("filter","clean_filter"),scope:this,handler:this.onClearAllFilter})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this)},onFilterChange:function(){var a=SYNO.SDS.VideoStation2.Filter.get().isFilterEmpty();var b=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();this.createSmartPlaylistBtn.setDisabled(a&&!b)},onClearAllFilter:function(){SYNO.SDS.VideoStation2.Filter.get().clearAllFilter()},onCreateSmartPlaylist:function(){this.fireEvent(SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU);SYNO.SDS.VideoStation2.PlaylistActionController.createSmartPlaylist()}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.ActionButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(){this.callParent(arguments);this.addClass("filter-action-button")}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Option",{extend:"SYNO.SDS.VideoStation2.AccordionPanel",statics:{EVENT_UPDATE_LAYOUT:"updatelayout"},category:null,local:false,constructor:function(b){var c=b.category||this.category;var a={cls:"filter-menu-option",items:[this.filterField=new SYNO.SDS.VideoStation2.FilterMenu.OptionFilter({width:280-12*2,store:this.getStore()}),this.detailPanel=new SYNO.SDS.VideoStation2.FilterMenu.OptionDetail({store:this.getStore(),category:c})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy,afterrender:this.onAfterRender,activate:this.onActivate,collapse:this.updateTitle,expand:this.updateTitle}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT);this.updateTitle()},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this._store},updateTitle:function(){var b=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(this.category);this.setTitle('<span class="filter-category-title">'+b+"</span>");if(!this.collapsed){return}var a=SYNO.SDS.VideoStation2.Filter.get().getFilter(this.category);if(!a){return}a=a.map(function(c){return Ext.util.Format.htmlEncode(c.key)}).join(", ");this.setTitle(['<div class="filter-cancel"></div>','<div class="filter-detail">','<span class="filter-title">',b," : </span>",a,"</div>"].join(""))},toggleCollapse:function(){if(!this.collapsed){return}this.callParent(arguments)},onBeforeLoadStore:function(a,b){var d=b.params;var c=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();Ext.apply(d,{type:c,category:this.category,library_id:[SYNO.SDS.VideoStation2.Library.get().getCurrentID()]});Ext.apply(d,SYNO.SDS.VideoStation2.Filter.get().getFilterOption());delete d[this.category]},onAfterRender:function(){this.mon(this.header,"click",this.onHeaderClick,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this)},onBeforeDestroy:function(){this.getStore().destroy()},onHeaderClick:function(a,b){if(Ext.fly(b).hasClass("filter-cancel")){SYNO.SDS.VideoStation2.Filter.get().clearFilter(this.category);return}this.toggleCollapse()},onFilterChange:function(a){if(a===this.category){this.updateTitle()}else{if(!this.collapsed&&!this.local&&!this.owner.hidden){this.getStore().load()}}},onActivate:function(){if(this.owner.hidden){return}if(this.local){this.detailPanel.updateScrollbar()}else{this.getStore().load()}}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.RatingOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_RATING,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_RATING});return this._store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.ResolutionOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_RESOLUTION});return this._store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.WatchedStatusOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_WATCHED_STATUS});return this._store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.FileCountOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_FILE_COUNT});return this._store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.DurationOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_DURATION});return this._store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.KeywordOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,local:true,constructor:function(b){var a={hideCollapseTool:true};this.callParent([Ext.apply(a,b)])},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter();return this._store},toggleCollapse:function(){return},updateTitle:function(){this.setVisible(SYNO.SDS.VideoStation2.Filter.get().hasKeyword());this.fireEvent(SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT);var b=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(this.category);var a=SYNO.SDS.VideoStation2.Filter.get().getKeyword();this.setTitle(['<div class="filter-cancel"></div>','<div class="filter-detail">','<span class="filter-title">',b," : </span>",Ext.util.Format.htmlEncode(a),"</div>"].join(""))}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.OptionFilter",{extend:"SYNO.SDS.VideoStation2.TextFilter",constructor:function(b){var a={localFilter:true,localFilterField:"key"};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("filter-menu-searchfield")})}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.OptionDetail",{statics:{EVENT_FIELD_CHANGE:"fieldchange",EVENT_FIELD_VISIBLE_CHANGE:"fieldvisiblechange"},category:null,extend:"SYNO.SDS.Utils.DataView.LazyDataView",constructor:function(b){var a={height:176,cls:"filter-menu-detail",tpl:this.getTpl(),itemSelector:"div.item-wrap",listeners:{scope:this,click:this.onOptionClick}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.mon(this.store,"datachanged",this.onFilterChange.createDelegate(this,[this.category]),this);this.mon(this.store,"load",this.onFilterChange.createDelegate(this,[this.category]),this)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div ext:qtip="{[this.doubleEncode(values.key)]}" class="item-wrap','<tpl if="this.isSelected(key)"> x-view-selected</tpl>','">','<div class="checkbox"></div>{key:htmlEncode}',"</div>","</tpl>",{isSelected:this.isSelected.createDelegate(this),doubleEncode:function(a){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a))}})},isSelected:function(b){var c=SYNO.SDS.VideoStation2.Filter.get().getFilter(this.category);if(!c){return false}var a=false;c.each(function(d){if(d.key===b){a=true;return false}});return a},onOptionClick:function(e,a,d,c){var b=this.store.getAt(a);SYNO.SDS.VideoStation2.FilterController.togggleFilter(this.category,b.data)},onFilterChange:function(b){if(this.category!==b){return}this.getNodes().each(function(c){Ext.fly(c).removeClass("x-view-selected")});var a=SYNO.SDS.VideoStation2.Filter.get().getFilter(b);if(!a){return}a.each(function(d){var c=this.store.getById(d.key);if(!c){return}var e=this.getNode(c);if(!e){return}Ext.fly(e).addClass("x-view-selected")},this)}});Ext.define("SYNO.SDS.VideoStation2.FilterButton",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"filter",tooltip:_VST("filter","title"),menu:new SYNO.SDS.VideoStation2.FilterMenu({})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeFilterState,this);this.mon(SYNO.SDS.VideoStation2.Folder.get(),SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED,this.changeFilterState,this);this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED,this.changeFilterState,this);this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.changeFilterState,this);this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.changeFilterState,this)},changeFilterState:function(){var b=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_POSTER;var d=SYNO.SDS.VideoStation2.Folder.get().isSet();var c=SYNO.SDS.VideoStation2.Playlist.get().isSet();var a=SYNO.SDS.VideoStation2.RecordingSpecific.get().isSet();this.setVisible(b&&!c&&!d&&!a)}});Ext.define("SYNO.SDS.VideoStation2.MainSearchField",{extend:"SYNO.SDS.VideoStation2.SearchField",constructor:function(b){var a={width:214,listeners:{scope:this,keypress:this.onSearchFieldKeypress}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.changeSearchState,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeSearchState,this);this.changeSearchState()},changeSearchState:function(){var a=SYNO.SDS.VideoStation2.View.get().getView();this.setDisabled(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST||a===SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE)},onSearchFieldKeypress:function(c,b){if(b.getKey()!==Ext.EventObject.ENTER){return}var a=c.getValue().trim();if(SYNO.SDS.VideoStation2.Filter.get().getKeyword()===a){return}SYNO.SDS.VideoStation2.Controller.setFilter(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,a)},onFilterChange:function(a){if(a!==SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){return}if(this.rendered){this.setValue(SYNO.SDS.VideoStation2.Filter.get().getKeyword())}}});Ext.define("SYNO.SDS.VideoStation2.NotificationPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={title:_VST("notification","title")};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionStatusDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{EVENT_RELOAD:"reload",EVENT_ON_DELETE:"on_delete",STATUS_WAIT:"wait",STATUS_PROCESS:"process",STATUS_ERROR:"error",STATUS_STOP:"stop",STATUS_DONE:"done"},constructor:function(b){var a={tpl:this.getTpl(),cls:"offline-conversion-status-dataview",itemSelector:"div.offline-conversion-wrap",overClass:"x-view-over",singleSelect:true,trackResetOnLoad:false};this.callParent([Ext.apply(a,b)])},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="offline-conversion-wrap">','<div class="thumb" style="background-image: url({[this.getImageURL(values.setting.additional.video)]})"></div>','<div class="info">','<div class="title-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">','<div class="title" ext:qtip="{[this.getDoubleEncodeTitle(values.setting.additional.video)]}">{[this.getEncodeTitle(values.setting.additional.video)]}</div>',"</td>",'<td align="right">','<div class="status status-{values.status.state}">{[this.getStatus(values)]}</div>',"{[this.getErrorIcon(values)]}","</td>","</tr></tbody></table></div>",'<div class="setting-wrap">','<div class="owner-name" ext:qtip="{[this.getDoubleEncode(values.status.owner_name)]}">{values.status.owner_name:htmlEncode}</div>','<div class="sep"></div>','<div class="video-profile">{[this.getVideoProfiles(values)]}</div>','<div class="sep"></div>','<div class="audio-track">{[this.getAudioTrack(values)]}</div>','<div class="progress">{[this.getProgress(values)]}%</div>',"</div>",'<div class="progress-bar-wrap">','<div class="blue-bar"></div>','<div class="grey-bar" style="width:{[this.getInverseProgress(values)]}%"></div>',"</div>","</div>",'<div class="action {[this.getRestartStopAction(values)]}"></div>','<div class="action delete"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getEncodeTitle:this.getEncodeTitle.createDelegate(this),getErrorIcon:this.getErrorIcon.createDelegate(this),getDoubleEncodeTitle:this.getDoubleEncodeTitle.createDelegate(this),getDoubleEncode:this.getDoubleEncode.createDelegate(this),getStatus:this.getStatus.createDelegate(this),getVideoProfiles:this.getVideoProfiles.createDelegate(this),getAudioTrack:this.getAudioTrack.createDelegate(this),getProgress:this.getProgress.createDelegate(this),getRestartStopAction:this.getRestartStopAction.createDelegate(this),getInverseProgress:this.getInverseProgress.createDelegate(this)});return a},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:a.type,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})},getEncodeTitle:function(a){if(SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE!==a.type){return Ext.util.Format.htmlEncode(a.title)}return Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.getPathTitleForOfflineEpisode(a))},getDoubleEncodeTitle:function(a){return Ext.util.Format.htmlEncode(this.getEncodeTitle(a))},getDoubleEncode:function(a){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a))},getTimeLeftString:function(a){return[(Math.floor(a/3600)),("00"+Math.floor((a%3600)/60)).substr(-2),("00"+Math.floor(a%60)).substr(-2)].join(":")},getStatus:function(a){switch(a.status.state){case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_WAIT:return _VST("offline_conversion","status_wait");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS:return this.getTimeLeftString(a.status.time_left);case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR:return _VST("offline_conversion","status_error");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_STOP:return _VST("offline_conversion","status_stop");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE:return _VST("offline_conversion","status_done")}return""},getVideoProfiles:function(a){return SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(a.setting.video_profile)},getAudioTrack:function(b){var a=b.setting.audio_id;if(a<0){return _VST("offline_conversion","default_audio_track")}return String.format("#{0}",a)},getErrorIcon:function(b){if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR!=b.status.state){return""}var a=this.getErrorMessage(b.status.error);return String.format('<div class="error-icon" ext:qtip="{0}"></div>',Ext.util.Format.htmlEncode(a))},getErrorMessage:function(a){switch(a){case 100:return _VST("controller","in_transcoding");case 101:return _T("error","error_error_system");case 102:return _T("error","error_error_system");case 103:return _VST("controller","unsupported_audio_codec");case 104:return String.format(_VST("controller","unsupported_format"));case 105:return _VST("controller","need_change_mem_layout");case 106:return _VST("controller","unsupported_hardware_transcode_format");case 107:return _VST("controller","out_of_transcoding_resolution_capability");case 108:return _VST("controller","out_of_transcoding_framerate_capability");case 109:return _VST("controller","out_of_transcoding_profile_capability");case 110:return _T("error","error_error_system");default:return _T("error","error_error_system")}},getProgress:function(a){if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS===a.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE===a.status.state){return a.status.progress?Math.floor(a.status.progress*10000)/100:0}return 0},getRestartStopAction:function(b){var a="";if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_WAIT===b.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS===b.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE===b.status.state){a="stop"}else{if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR===b.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_STOP===b.status.state){a="restart"}}if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE===b.status.state){a+=" x-item-disabled"}return a},getInverseProgress:function(a){return 100-this.getProgress(a)},onRequestSuccess:function(){this.fireEvent(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_RELOAD)},onDeleteTask:function(b){var a=SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE!==b.data.status.state;this.fireEvent(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_ON_DELETE,b,a)},onRestartTask:function(a){SYNO.SDS.VideoStation2.OP.get().restartOfflineConversionTask({id:[a.id]},{scope:this,success:this.onRequestSuccess})},onStopTask:function(a){SYNO.SDS.VideoStation2.OP.get().stopOfflineConversionTask({id:[a.id]},{scope:this,success:this.onRequestSuccess})},onClick:function(i,h,g){var c=Ext.fly(h);if(!c){return}var a,f,b;f=i.getTarget(this.itemSelector,this.getTemplateTarget());if(!f){return}a=this.indexOf(f);b=this.store.getAt(a);if(c.hasClass("delete")){this.onDeleteTask(b)}else{if(c.hasClass("restart")){this.onRestartTask(b)}else{if(c.hasClass("stop")&&!c.hasClass("x-item-disabled")){this.onStopTask(b)}else{if(c.hasClass("thumb")){var d=b.data.setting.additional.video;d.pathTitle=this.getEncodeTitle(d);SYNO.SDS.VideoStation2.Controller.intoVideoDetailFromOfflineVideo(d)}else{this.callParent(arguments)}}}}}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionStatusPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_DELETE_CONFIRM:"delete_confirm"},constructor:function(b){var a={title:_VST("offline_conversion","title"),autoFlexcroll:true,layout:"fit",cls:"offline-conversion-status-panel",items:[this.getDataView()]};this.callParent([Ext.apply(a,b)]);this.mon(this.getDataView(),SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_RELOAD,this.onReloadDataView,this);this.mon(this.getDataView(),SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_ON_DELETE,this.onDeleteTask,this)},onActivate:function(){this.getReloadTask().restart(true)},onDeactivate:function(){this.getReloadTask().stop()},onReloadDataView:function(){this.getReloadTask().stop();this.getReloadTask().restart(true)},onDeleteTask:function(b,a){var c={fn:function(){SYNO.SDS.VideoStation2.OP.get().deleteOfflineConversionTask({id:[b.id]},{scope:this,success:this.onReloadDataView})},scope:this};if(a){this.fireEvent(SYNO.SDS.VideoStation2.OfflineConversionStatusPanel.EVENT_DELETE_CONFIRM,_VST("action","remove_confirm"),c);return}SYNO.SDS.VideoStation2.Util.applyCallback(c)},getStore:function(){this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation.OfflineConversion",method:"list",version:1,listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),api:"SYNO.VideoStation.OfflineConversion",method:"list",version:1,baseParams:{additional:["video"]},reader:new Ext.data.JsonReader({root:"task",totalProperty:"total",fields:["id","setting","status"]}),listeners:{scope:this,exception:function(){this.getReloadTask().stop()}}});return this._store},getDataView:function(){this._dataView=this._dataView||new SYNO.SDS.VideoStation2.OfflineConversionStatusDataView({store:this.getStore()});return this._dataView},getReloadTask:function(){this._reloadTask=this._reloadTask||this.addTask({interval:5000,run:this.getStore().load,scope:this.getStore()});return this._reloadTask}});Ext.define("SYNO.SDS.VideoStation2.NotificationDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){var a={title:_VST("offline_conversion","title"),layout:"fit",width:480,height:580,minWidth:480,minHeight:280,resizable:false,draggable:false,cls:"notification-dialog",items:[this.getOfflineConversionPanel()],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)]);this.on("show",this.onActivate,this);this.on("hide",this.onDeactivate,this);this.mon(this.getOfflineConversionPanel(),SYNO.SDS.VideoStation2.OfflineConversionStatusPanel.EVENT_DELETE_CONFIRM,this.onDeleteConfirm,this)},onActivate:function(){this.mon(Ext.getDoc(),"mousedown",this.onMouseDown,this);this.getOfflineConversionPanel().fireEvent("activate");this.callParent(arguments)},onDeactivate:function(){this.mun(Ext.getDoc(),"mousedown",this.onMouseDown,this);this.getOfflineConversionPanel().fireEvent("deactivate");this.callParent(arguments)},onApply:function(){this.hide()},onCancel:function(){this.hide()},onMouseDown:function(a){if(!this.isVisible()){return}if(a.within(this.el)){return}if(this.confirmDialog&&a.within(this.confirmDialog.el)){return}this.hide()},getTabPanel:function(){var a=[this.getNotificationPanel()];if(SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion()){a.push(this.getOfflineConversionPanel())}this._tabPanel=this._tabPanel||new SYNO.SDS.VideoStation2.TabPanel({activeTab:0,items:a});return this._tabPanel},getNotificationPanel:function(){this._notification=this._notification||new SYNO.SDS.VideoStation2.NotificationPanel();return this._notification},getOfflineConversionPanel:function(){this._offlineConversion=this._offlineConversion||new SYNO.SDS.VideoStation2.OfflineConversionStatusPanel();return this._offlineConversion},onDeleteConfirm:function(a,b){this.confirmDialog=this.getMsgBox().confirm(this.title,a,function(c){if(c==="yes"){SYNO.SDS.VideoStation2.Util.applyCallback(b)}},this)}});Ext.define("SYNO.SDS.VideoStation2.MainToolbar",{statics:{spacerConfig:function(a){return{xtype:"tbspacer",width:a}}},extend:"SYNO.ux.Toolbar",constructor:function(b){var a={cls:"main-toolbar",items:this.getItems()};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:true})},getItems:function(){var a=[new SYNO.ux.Button({cls:"logo",handler:SYNO.SDS.VideoStation2.Controller.intoHomePage}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(26),new SYNO.SDS.VideoStation2.ActionButton({cls:"home",tooltip:_VST("common","homepage"),handler:SYNO.SDS.VideoStation2.Controller.intoHomePage}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(12),new SYNO.SDS.VideoStation2.MainSearchField({}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(8),new SYNO.SDS.VideoStation2.FilterButton({hidden:true}),"->",new SYNO.SDS.VideoStation2.AccountButton(),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(16),{xtype:"tbseparator"},new SYNO.SDS.VideoStation2.ActionButton({cls:"help",tooltip:_T("common","alt_help"),handler:SYNO.SDS.VideoStation2.Util.launchHelp}),this.notificationBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"offline-conversion-queue",tooltip:_VST("offline_conversion","title"),handler:this.launchNotification,scope:this,hidden:true}),new SYNO.SDS.VideoStation2.ActionButton({cls:"setting",tooltip:_VST("action","settings"),scope:this,handler:this.launchSetting})];return a},launchSetting:function(){var a=new SYNO.SDS.VideoStation2.Setting.Dialog();SYNO.SDS.VideoStation2.SettingController.get().openDialog(a)},launchNotification:function(){var a=this.getNotificationDialog();if(a.isVisible()){a.hide()}else{a.show()}},getNotificationDialog:function(){if(!this.notificationDialog){this.notificationDialog=new SYNO.SDS.VideoStation2.NotificationDialog({listeners:{scope:this,show:function(){this.notificationBtn.addClass("x-btn-click")},hide:function(){this.notificationBtn.removeClass("x-btn-click")}}});this.addManagedComponent(this.notificationDialog)}return this.notificationDialog},onCapabilityReady:function(){this.notificationBtn.setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion())}});Ext.define("SYNO.SDS.VideoStation2.Wizard",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){this.tabPanel=new SYNO.SDS.VideoStation2.Wizard.TabPanel();var a={width:724,height:510,resizable:false,header:false,draggable:false,elements:"body",fbar:false,cls:"syno-vs2-wizard",layout:"fit",items:[this.tabPanel],listeners:{scope:this,afterrender:this.addSkipBtn}};this.callParent([Ext.apply(a,b)]);this.mon(this.tabPanel,SYNO.SDS.VideoStation2.Wizard.TabPanel.EVENT_WIZARD_CLOSE,this.closeDialog,this)},fillPadding:Ext.emptyFn,afterShow:function(){this.callParent(arguments);var a=Ext.Element.data(SYNO.SDS.VideoStation2.Window.el.dom,"mask");a.addClass("syno-vs2-wizard-mask");SYNO.SDS.VideoStation2.Window.setMaskOpacity(0.5)},closeDialog:function(){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","hide_vs2_wizard",true);this.close()},addSkipBtn:function(){var b=this.getEl();var a=b.createChild({cls:"skip-btn",html:_VST("record","skip")});a.on("click",this.closeDialog,this)}});Ext.define("SYNO.SDS.VideoStation2.Wizard.TabPanel",{statics:{EVENT_WIZARD_CLOSE:"wizard_close",HEADER_ITEM_WIDTH:106},extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(c){var a=[];var d=["getWizardWelcome","getWizardVideo","getWizardTranscoding","getWizardDTV","getWizardSettings","getWizardFinal"];Ext.each(d,function(f){var e=this[f]();if(!Ext.isObject(e)){return}a.push(e)},this);var b={cls:"wizard-tab-panel",itemTpl:this.getTabTpl(),bbar:new SYNO.ux.Toolbar({cls:"wizard-bottom-tool-bar",items:[this.getPrevButton(),"->",this.getNextButton()]}),activeTab:0,items:a,listeners:{scope:this,tabchange:this.onTabChange}};this.callParent([Ext.apply(b,c)])},getWizardWelcome:function(){this._wizardWelcome=this._wizardWelcome||new SYNO.SDS.VideoStation2.Wizard.Welcome();return this._wizardWelcome},getWizardVideo:function(){this._wizardVideo=this._wizardVideo||new SYNO.SDS.VideoStation2.Wizard.Video();return this._wizardVideo},getWizardTranscoding:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()){return null}this._wizardTranscoding=this._wizardTranscoding||new SYNO.SDS.VideoStation2.Wizard.Transcoding();return this._wizardTranscoding},getWizardDTV:function(){this._wizardDTV=this._wizardDTV||new SYNO.SDS.VideoStation2.Wizard.DTV();return this._wizardDTV},getWizardSettings:function(){this._wizardSettings=this._wizardSettings||new SYNO.SDS.VideoStation2.Wizard.Settings();return this._wizardSettings},getWizardFinal:function(){this._wizardFinal=this._wizardFinal||new SYNO.SDS.VideoStation2.Wizard.Final();return this._wizardFinal},getTabTpl:function(){var a=new Ext.Template('<li class="{cls}" role="tab" id="{id}" aria-label="{text}" aria-expanded="false" aria-selected="false"><a class="x-tab-strip-close"></a>','<div class="x-tab-right" tabIndex="-1" aria-labelledby="{id}">','<div class="x-tab-left icon"></div>','<span class="x-tab-strip-inner"><span class="x-tab-strip-text {iconCls}">{text}</span></span>',"</div>","</li>");a.disableFormats=true;a.compile();return a},getPrevButton:function(){this._prev_btn=this._prev_btn||new SYNO.ux.Button({cls:"action prev",hidden:true,scope:this,handler:this.goPrevious});return this._prev_btn},getNextButton:function(){this._next_btn=this._next_btn||new SYNO.ux.Button({cls:"action next",scope:this,handler:this.goNext});return this._next_btn},goPrevious:function(){this.changePage(function(a){SYNO.Assert(0<a,String.format("goPrevious index {0} error",a));return --a})},goNext:function(){this.changePage(function(a){SYNO.Assert(0<=a&&a<this.items.length,String.format("goNext index {0} error",a));return ++a})},changePage:function(b){var a=this.getCurrentIndex();a=b.apply(this,[a]);if(this.items.length<=a){this.fireEvent(SYNO.SDS.VideoStation2.Wizard.TabPanel.EVENT_WIZARD_CLOSE);return}this.setActiveTab(a)},onTabChange:function(){var b=this.getCurrentIndex();var d=0===b;var c=(this.items.length-1)===b;this.getPrevButton()[d?"hide":"show"]();this.getNextButton()[c?"addClass":"removeClass"]("done");var a=this.getHeaderIndicator();a.getEl().alignTo(this.header,"bl-bl",[(b-1)*SYNO.SDS.VideoStation2.Wizard.TabPanel.HEADER_ITEM_WIDTH,0]);a[d||c?"removeClass":"addClass"]("show")},getCurrentIndex:function(){return this.items.indexOf(this.getLayout().activeItem)},getHeaderIndicator:function(){this._headerIndicator=this._headerIndicator||new Ext.BoxComponent({renderTo:this.getEl(),cls:"header-indicator"});return this._headerIndicator}});Ext.define("SYNO.SDS.VideoStation2.Wizard.ItemBase",{extend:"Ext.Container",constructor:function(c){var a=Ext.isString(c.cls)?(c.cls+" wizard-base"):"wizard-base";c.cls=a;var d=Ext.isString(c.tabCls)?(c.tabCls+" tab-wrapper"):"tab-wrapper";c.tabCls=d;var b={layout:"border",items:[this.getMessageItem(),this.getPictureItem()],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,beforedestroy:this.onDeactivate}};this.callParent([Ext.apply(b,c)])},getMessageItem:function(){this._messageItem=this._messageItem||new Ext.BoxComponent({cls:"message",region:"north",html:this.getMessageCfg()});return this._messageItem},getPictureItem:function(){this._pictureItem=this._pictureItem||new Ext.BoxComponent({cls:"picture",region:"center",html:this.getPictureCfg()});return this._pictureItem},getMessageCfg:Ext.emptyFn,getPictureCfg:Ext.emptyFn,onActivate:Ext.emptyFn,onDeactivate:Ext.emptyFn,createTopWindowElement:function(b){var a=Ext.isString(b.cls)?(b.cls+" syno-wizard-highlight-item"):"syno-wizard-highlight-item";b.cls=a;return new Ext.BoxComponent(Ext.apply({renderTo:SYNO.SDS.VideoStation2.Window.getEl()},b))}});Ext.define("SYNO.SDS.VideoStation2.Wizard.Welcome",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(b){var a={tabCls:"wizard-no-icon",cls:"syno-vs2-wizard-welcome"};this.callParent([Ext.apply(a,b)])},getMessageCfg:function(a){return _VST("tip","welcome_desc")},getPictureCfg:function(){return['<div class="wizard-welcome-picture">',"</div>"].join()}});Ext.define("SYNO.SDS.VideoStation2.Wizard.Video",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(b){var a={title:_VST("video_info","video"),tabCls:"wizard-video-icon",cls:"syno-vs2-wizard-video"};this.callParent([Ext.apply(a,b)])},getMessageCfg:function(){return _VST("tip","videostation_desc")},getPictureCfg:function(){var a=[{cls:"create-library",desc:_VST("tip","ceatre_customize_library")},{cls:"customize-library-vidibility",desc:_VST("tip","customize_library_vidibility")},{cls:"add-video-folder",desc:_VST("tip","add_video_folder")}];var c=-1===["cht","chs","rus","jpn","krn"].indexOf(_S("lang"))?"":"normal-lang";var b=['<div class="action-wrapper {0}">','<div class="action-icon {1}"></div>','<div class="dash">&nbsp;-&nbsp;</div>','<div class="desc">{2}</div>',"</div>"].join("");return a.map(function(d){return String.format(b,c,d.cls,d.desc)}).join("")},onActivate:function(){this.arrow=this.createTopWindowElement({cls:"video-arrow"});this.library=this.createTopWindowElement({cls:"video-library",html:String.format('<div class="text">{0}</div>',_VST("library","title"))});this.playlist=this.createTopWindowElement({cls:"video-playlist",html:String.format('<div class="text">{0}</div>',_VST("playlist","title"))})},onDeactivate:function(){if(this.arrow){this.arrow.destroy()}if(this.library){this.library.destroy()}if(this.playlist){this.playlist.destroy()}}});Ext.define("SYNO.SDS.VideoStation2.Wizard.Transcoding",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(b){var a={title:_VST("tip","transcode_title"),tabCls:"wizard-transcoding-icon",cls:"syno-vs2-wizard-transcoding"};this.callParent([Ext.apply(a,b)])},getMessageCfg:function(){var a=[{title:_VST("tip","online_transcoding_title"),desc:String.format(_VST("tip","online_transcoding_simple_desc"),"")},{title:_VST("offline_conversion","title"),desc:String.format(_VST("tip","offline_transcoding_desc"),"")},{title:_VST("tip","transcoding_queue_title"),desc:String.format(_VST("tip","transcoding_queue_desc"),"")}];var b=['<div class="transcoding-message-wrapper">','<span class="title">{0}</span>',"<span>&nbsp;{1}</span>","</div>"].join("");return a.map(function(c){return String.format(b,c.title,c.desc)}).join("")},getPictureCfg:function(){return['<div class="wizard-transcoding-picture">',"</div>"].join("")}});Ext.define("SYNO.SDS.VideoStation2.Wizard.DTV",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(b){var a={title:_VST("dtv","title"),tabCls:"wizard-dtv-icon",cls:"syno-vs2-wizard-dtv"};this.callParent([Ext.apply(a,b)])},getMessageCfg:function(){var a=[_VST("tip","dtv_live_stream"),_VST("tip","dtv_recording"),_VST("tip","dtv_enable")];return a.map(function(b){return String.format("<span>{0}</span>",b)}).join("")},getPictureCfg:function(){return['<div class="wizard-dtv-picture">',"</div>"].join("")}});Ext.define("SYNO.SDS.VideoStation2.Wizard.Settings",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(b){var a={title:_VST("action","settings"),tabCls:"wizard-setting-icon",cls:"syno-vs2-wizard-settings"};this.callParent([Ext.apply(a,b)])},getMessageCfg:function(){return _VST("tip","setting_desc")},getPictureCfg:function(){var a=[{iconCls:"privilege",desc:_VST("privilege","title")},{iconCls:"sharing",desc:_VST("helptoc","sharing")},{iconCls:"dtv",desc:_VST("dtv","title")},{iconCls:"video",desc:_VST("tip","video_title")}];var b=['<div class="settings-icon-wrapper">','<div class="settings-icon {0}"></div>','<div class="title">{1}</div>',"</div>"].join("");return a.map(function(c,d){var e="";if(0!==d){e+='<div class="spacer"></div>'}e+=String.format(b,c.iconCls,c.desc);return e}).join("")},onActivate:function(){this.arrow=this.createTopWindowElement({cls:"setting-arrow"});this.setting=this.createTopWindowElement({cls:"setting-setting-icon"})},onDeactivate:function(){if(this.arrow){this.arrow.destroy()}if(this.setting){this.setting.destroy()}}});Ext.define("SYNO.SDS.VideoStation2.Wizard.Final",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(b){var a={tabCls:"wizard-no-icon",cls:"syno-vs2-wizard-final"};this.callParent([Ext.apply(a,b)])},getMessageCfg:function(){return _VST("tip","enjoy_videostation")},getPictureCfg:function(){return['<div class="wizard-final-picture">',"</div>"].join("")}});Ext.define("SYNO.SDS.VideoStation.AppInstance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.VideoStation2.MainWindow"});Ext.define("SYNO.SDS.VideoStation2.MainWindow",{extend:"SYNO.SDS.AppWindow",statics:{INIT_SEQUENCE:["checkCapability","loadSession","loadLibrary","loadPlaylists","loadDTV","loadCastSender","initHistoryController"]},isBeta:false,aboutTitleColor:"#D13B3B",constructor:function(b){SYNO.SDS.VideoStation2.Window=this;var a={cls:"syno-vs2-win",layout:"fit",height:580,width:1080,minHeight:480,minWidth:1080,tbar:new SYNO.SDS.VideoStation2.MainToolbar(),items:[new SYNO.SDS.VideoStation2.MainPanel()],listeners:{scope:this,beforerender:this.onBeforeRenderFn,resize:this.onResizeFn}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChanged,this);this.initSequence()},init_progress:0,initSequence:function(){if(this.init_progress>=SYNO.SDS.VideoStation2.MainWindow.INIT_SEQUENCE.length){this.lunchWizard();return}if(this.init_progress===0){SYNO.SDS.VideoStation2.Util.maskLoading(this,true)}this[SYNO.SDS.VideoStation2.MainWindow.INIT_SEQUENCE[this.init_progress]]()},initSequenceCallback:function(){this.init_progress++;this.initSequence()},checkCapability:function(){SYNO.SDS.VideoStation2.SettingController.get().checkCapability({scope:this,fn:this.initSequenceCallback})},loadSession:function(){SYNO.SDS.VideoStation2.SettingController.get().loadSession({scope:this,fn:this.initSequenceCallback})},loadLibrary:function(){this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.initSequenceCallback,this,{single:true});SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()},loadPlaylists:function(){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.initSequenceCallback,this,{single:true});SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists()},loadDTV:function(){this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,this.initSequenceCallback,this,{single:true});SYNO.SDS.VideoStation2.DTVController.loadDTV()},loadCastSender:function(){if(!Ext.isChrome){this.initSequenceCallback();return}var b={jsBaseURL:this.jsConfig.jsBaseURL+"/controller/ui"};var a="cast_sender.js?v=0760";SYNO.VideoController2.Util.loadScript(b,a,this.initSequenceCallback.createDelegate(this))},initHistoryController:function(){this.mon(SYNO.SDS.VideoStation2.HistoryController.get(),SYNO.SDS.VideoStation2.HistoryController.EVENT_HISTORYCONTROLLER_INITED,this.initSequenceCallback,this,{single:true});SYNO.SDS.VideoStation2.Util.unmask(this);SYNO.SDS.VideoStation2.HistoryController.get().init()},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)},showAboutWindow:function(){if(!this.aboutWindow||this.aboutWindow.isDestroyed){this.aboutWindow=new SYNO.SDS.VideoStation2.AboutWindow({owner:this,aboutHeader:this.aboutHeader,pkgColor:this.aboutTitleColor||"#0086E5"})}return this.callParent(arguments)},onViewChanged:function(){var c=this.getEl();if(!c){return}var b=SYNO.SDS.VideoStation2.View.get().getView();var a=(b===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW||b===SYNO.SDS.VideoStation2.View.VIEW_DETAIL);c[a?"addClass":"removeClass"]("with-background")},onBeforeRenderFn:function(){this.mon(SYNO.SDS.VideoStation2.WindowSize.get(),SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE,this.onSizeModeChange,this)},onResizeFn:function(b,d,a){if(!d||!a){return}var c=(d>=1760)?SYNO.SDS.VideoStation2.WindowSize.LARGE_SIZE:SYNO.SDS.VideoStation2.WindowSize.NORMAIL_SIZE;SYNO.SDS.VideoStation2.WindowSize.get().setSizeMode(c)},onSizeModeChange:function(){if(SYNO.SDS.VideoStation2.WindowSize.get().isLargeSizeMode()){this.addClass("syno-vs2-large-size")}else{this.removeClass("syno-vs2-large-size")}},lunchWizard:function(){if(!_S("is_admin")){return}if(true===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_vs2_wizard")){return}var a=new SYNO.SDS.VideoStation2.Wizard({owner:this});a.open()}});