/* Copyright (c) 2016 Synology Inc. All rights reserved. */

Ext.define("SYNO.VideoController2.Constant",{statics:{UNLIMIT:500000}});Ext.define("SYNO.VideoController2.SharingHelper",{statics:{isPublicSharing:function(){return _S("IsPublicSharing")===true},getSharingID:function(){return SYNO.VideoController2.SharingHelper.isPublicSharing()?_S("SharingId"):""},API:{Movie:["SYNO.VideoStation2.Movie","getinfo",1],TVShowEpisode:["SYNO.VideoStation2.TVShowEpisode","getinfo",1],HomeVideo:["SYNO.VideoStation2.HomeVideo","getinfo",1],TVRecord:["SYNO.VideoStation2.TVRecording","getinfo",1],File:["SYNO.VideoStation2.File","getinfo",1],AudioTrack:["SYNO.VideoStation2.File","get_track_info",1],DownloadFile:["SYNO.VideoStation2.File","download",1],StreamingOpen:["SYNO.VideoStation2.Streaming","open",1],Streaming:["SYNO.VideoStation2.Streaming","stream",1],StreamingClose:["SYNO.VideoStation2.Streaming","close",1],SubtitleList:["SYNO.VideoStation2.Subtitle","list",1],Subtitle:["SYNO.VideoStation2.Subtitle","get",1],CollectionListVideo:["SYNO.VideoStation2.Collection","list_video",1]},LEGACY_API:{Movie:["SYNO.VideoStation.Movie","getinfo",2],TVShowEpisode:["SYNO.VideoStation.TVShowEpisode","getinfo",2],HomeVideo:["SYNO.VideoStation.HomeVideo","getinfo",2],TVRecord:["SYNO.VideoStation.TVRecording","getinfo",2],AudioTrack:["SYNO.VideoStation.AudioTrack","list",1],DownloadFile:["SYNO.VideoStation.Video","download",1],StreamingOpen:["SYNO.VideoStation.Streaming","open",3],Streaming:["SYNO.VideoStation.Streaming","stream",1],StreamingClose:["SYNO.VideoStation.Streaming","close",1],SubtitleList:["SYNO.VideoStation.Subtitle","list",2],Subtitle:["SYNO.VideoStation.Subtitle","get",2],CollectionListVideo:["SYNO.VideoStation.Collection","video_list",2]},ROOT:{Movie:"movie",TVShowEpisode:"episode",HomeVideo:"video",TVRecord:"recording",File:"video",AudioTrack:"audio",SubtitleList:"subtitle",CollectionListVideo:"video"},LEGACY_ROOT:{Movie:"movies",TVShowEpisode:"episodes",HomeVideo:"videos",TVRecord:"recordings",AudioTrack:"trackinfo",CollectionListVideo:"videos"},VIDEO_TYPE_MAP:{movie:"Movie",tvshow_episode:"TVShowEpisode",home_video:"HomeVideo",tv_record:"TVRecord",filevideo:"File"},getAPI:function(a){var b=[];if(SYNO.VideoController2.SharingHelper.isPublicSharing()){b=SYNO.VideoController2.SharingHelper.LEGACY_API[a]}else{b=SYNO.VideoController2.SharingHelper.API[a]}if(b.length===3){return{api:b[0],method:b[1],version:b[2]}}throw String.format("Wrong API name: {0}",a)},getAPIRoot:function(a){if(SYNO.VideoController2.SharingHelper.isPublicSharing()){return SYNO.VideoController2.SharingHelper.LEGACY_ROOT.hasOwnProperty(a)?SYNO.VideoController2.SharingHelper.LEGACY_ROOT[a]:""}else{return SYNO.VideoController2.SharingHelper.ROOT.hasOwnProperty(a)?SYNO.VideoController2.SharingHelper.ROOT[a]:""}},getVideoAPI:function(b){var a=SYNO.VideoController2.SharingHelper.VIDEO_TYPE_MAP[b];return SYNO.VideoController2.SharingHelper.getAPI(a)},getVideoAPIRoot:function(b){var a=SYNO.VideoController2.SharingHelper.VIDEO_TYPE_MAP[b];return SYNO.VideoController2.SharingHelper.getAPIRoot(a)},getCGIPath:function(a){var b=SYNO.VideoController2.SharingHelper.isPublicSharing()?"VideoStation/"+a:"entry";return String.format("webapi/{0}.cgi",b)},getVideoParams:function(b){var c=SYNO.VideoController2.SharingHelper.isPublicSharing();var d=c?b:[b];var a=c?Ext.encode(["file"]):["file"];return{id:d,additional:a}},getSubtitleParam:function(a){return{subtitle_id:SYNO.VideoController2.SharingHelper.isPublicSharing()?a:Ext.encode(a)}},getDownloadFileParam:function(){var a=Ext.util.Cookies.get("id");return{_sid:SYNO.VideoController2.SharingHelper.isPublicSharing()?a:Ext.encode(a)}},getTranscodeVideoParam:function(b,a,c){var d={};if(SYNO.VideoController2.SharingHelper.isPublicSharing()){d=b;Ext.apply(d,c);d.accept_format=a;d.audio_id=d.audio_track;delete d.audio_track}else{d.file=b;d[a]=c}return d},getForceOpenVTEParam:function(a){if(SYNO.VideoController2.SharingHelper.isPublicSharing()){a.force_open_vte=true}else{a.hls.force_open_vte=true}return a},getStreamingParam:function(a){var b={};if(SYNO.VideoController2.SharingHelper.isPublicSharing()){b.id=a}else{b._sid=Ext.encode(Ext.util.Cookies.get("id"));b.stream_id=Ext.encode(a)}return b},getStreamingCloseParam:function(a){var b={};if(SYNO.VideoController2.SharingHelper.isPublicSharing()){b.id=a}else{b.stream_id=a}return b},getCollectionListVideoParam:function(c,e){var d=SYNO.VideoController2.SharingHelper.isPublicSharing();var a=d?-1:SYNO.VideoController2.Constant.UNLIMIT;var b={sort_by:c.sort_by,sort_direction:c.sort_direction,offset:0,limit:a};if(d){b.sharing_id=SYNO.VideoController2.SharingHelper.getSharingID();b.additional=Ext.encode(["file"])}else{b.id=e}return b}}});_VCT=function(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}};Ext.define("SYNO.VideoController2.Util",{statics:{IS_MOBILE:(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Opera Mini|IEMobile|windows phone os 7|windows phone 8/i.test(navigator.userAgent)),STATE:{NO_MEDIA:0,STOPPED:1,PLAYING:2,PAUSED:3,BUFFERING:4,ERROR:5,CLEAR:6},MimeType:{ogg:"audio/ogg",ogv:"video/ogg",wav:"audio/wav",mp3:"audio/mpeg",m4a:"audio/mp4",m4b:"audio/mp4",m4v:"video/mp4",mov:"video/mp4"},getFileExt:function(a){var b=(/[.]/.exec(a))?/[^.]+$/.exec(a)[0]:"";return b.toLowerCase()},createVLCElement:function(e,f,d,a,c){var b;if(Ext.isIE||Ext.isIE11){b=e.createChild({tag:"object",id:f,classid:"clsid:9BE31822-FDAD-461B-AD51-BE1D1C159921",codebase:"http://download.videolan.org/pub/videolan/vlc/last/win32/axvlc.cab",width:d||"100%",height:a||"100%",style:c||"",cn:[{tag:"param",name:"src",value:""},{tag:"param",name:"allowfullscreen",value:"false"},{tag:"param",name:"bgcolor",value:"#000000"},{tag:"param",name:"toolbar",value:"false"}]})}else{b=e.createChild({tag:"embed",id:f,type:"application/x-vlc-plugin",version:"VideoLAN.VLCPlugin.2",pluginspage:"http://www.videolan.org/",width:d||"100%",height:a||"100%",style:c||"",src:"",allowfullscreen:"false",bgcolor:"#000000",toolbar:"false"})}return b},isVLCSupported:function(){if(this.isMobile()){return false}var a=SYNO.VideoController2.Util.detectPlugin("VideoLAN.VLCPlugin.2","VideoLAN","VLC")||SYNO.VideoController2.Util.detectPlugin("VideoLAN.VLCPlugin.2","VLC","VLC");return a},detectPlugin:function(){var b,d,a,c=navigator.plugins||[],f=arguments;if(Ext.isIE||Ext.isIE11){try{if((new ActiveXObject(f[0]))){return true}}catch(g){}return false}for(b=0;b<c.length;++b){a=true;for(d=1;d<f.length;++d){if(-1===c[b].name.indexOf(f[d])&&-1===c[b].description.indexOf(f[d])){a=false;break}}if(a){return true}}return false},addDomListener:function(a){return function(d,c,b){if(!d||!Ext.isString(c)||!Ext.isFunction(b)){return}if(a&&Ext.isIE&&d.attachEvent){d.attachEvent(c,b)}else{if(Ext.isFunction(d.addEventListener)){d.addEventListener(c,b,false)}else{d["on"+c]=b}}}},removeDomListener:function(a){return function(d,c,b){if(!d||!Ext.isString(c)||!Ext.isFunction(b)){return}if(a&&Ext.isIE&&d.detachEvent){d.detachEvent(c,b)}else{if(Ext.isFunction(d.removeEventListener)){d.removeEventListener(c,b,false)}else{d["on"+c]=null}}}},FullscreenEventMap:{requestFullscreen:"fullscreenchange",webkitRequestFullscreen:"webkitfullscreenchange",mozRequestFullScreen:"mozfullscreenchange",msRequestFullscreen:"MSFullscreenChange"},FullscreenFn:["requestFullscreen","webkitRequestFullscreen","mozRequestFullScreen","msRequestFullscreen"],exitFullscreenFn:["exitFullscreen","webkitExitFullscreen","mozCancelFullScreen","msExitFullscreen"],isFullscreen:function(){return !Ext.isEmpty(document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement)},hookDoLayout:function(a){var c;var b=a.getEl();Ext.each(SYNO.VideoController2.Util.FullscreenFn,function(e){if(Ext.isFunction(b.dom[e])){c=SYNO.VideoController2.Util.FullscreenEventMap[e];return false}});if(Ext.isString(c)){var d=function(){SYNO.Debug("dolayout");a.getOptionsBar().getFullscreenButton().setFullscreen(SYNO.VideoController2.Util.isFullscreen());a.doLayout()};SYNO.Debug("add fullscreen listener to: ",c);document.addEventListener(c,d,false)}},setDomFullscreen:function(a){Ext.each(SYNO.VideoController2.Util.FullscreenFn,function(b){if(Ext.isFunction(a[b])){a[b]();return false}})},exitFullscreen:function(){Ext.each(SYNO.VideoController2.Util.exitFullscreenFn,function(a){if(Ext.isFunction(document[a])){document[a]();return false}})},isDomFullscreenSupported:function(){var b=document.body;var a=false;Ext.each(SYNO.VideoController2.Util.FullscreenFn,function(c){if(Ext.isFunction(b[c])){a=true;return false}});return a},isMobile:function(){return SYNO.VideoController2.Util.IS_MOBILE},isMacSafari:function(){return Ext.isMac&&Ext.isSafari},REPEAT_NONE:0,REPEAT_ALL:1,REPEAT_ONE:2,APIErrorStringMap:{"SYNO.VideoStation.Streaming":{413:_VCT("controller","unsupported_format"),420:_VCT("controller","in_transcoding"),421:_VCT("controller","unsupported_format"),439:_VCT("controller","unsupported_audio_codec"),440:_VCT("controller","unsupported_format"),444:_VCT("controller","need_change_mem_layout"),445:_VCT("controller","unsupported_hardware_transcode_format"),446:_VCT("controller","out_of_transcoding_resolution_capability"),447:_VCT("controller","out_of_transcoding_framerate_capability"),448:_VCT("controller","out_of_transcoding_profile_capability"),449:_VCT("offline_conversion","error_confirm"),450:_VCT("offline_conversion","error_block")},"SYNO.VideoStation2.Streaming":{1212:_VCT("controller","unsupported_format"),1200:_VCT("controller","in_transcoding"),1211:_VCT("controller","unsupported_format"),1204:_VCT("controller","unsupported_audio_codec"),1205:_VCT("controller","unsupported_format"),1206:_VCT("controller","need_change_mem_layout"),1207:_VCT("controller","unsupported_hardware_transcode_format"),1208:_VCT("controller","out_of_transcoding_resolution_capability"),1209:_VCT("controller","out_of_transcoding_framerate_capability"),1210:_VCT("controller","out_of_transcoding_profile_capability"),1201:_VCT("offline_conversion","error_confirm"),1202:_VCT("offline_conversion","error_block")},"SYNO.DTV.Streaming":{425:_VCT("controller","unsupported_format"),442:_VCT("controller","unsupported_transcode_channel"),443:_VCT("controller","dtv_bad_signal")},"SYNO.VideoStation2.Controller.Playback":{117:_VCT("controller","error_state"),2001:_VCT("controller","unsupported_format"),1200:_VCT("controller","in_transcoding"),1204:_VCT("controller","unsupported_audio_codec"),1205:_VCT("controller","unsupported_format"),1206:_VCT("controller","need_change_mem_layout"),1207:_VCT("controller","unsupported_hardware_transcode_format"),1208:_VCT("controller","out_of_transcoding_resolution_capability"),1209:_VCT("controller","out_of_transcoding_framerate_capability"),1210:_VCT("controller","out_of_transcoding_profile_capability")},"SYNO.VideoStation2.Controller.Volume":{117:_VCT("controller","error_state")},"SYNO.VideoStation2.Controller.Password":{117:_VCT("controller","error_state"),2002:_VCT("controller","error_renderer_password_incorrect")}},STREAMING_ID:"streaming",CHROMECAST_ID:"chromecast",PLAYERTYPE_STREAMING:"streaming",PLAYERTYPE_AIRPLAY:"airplay",PLAYERTYPE_UPNP:"upnp",PLAYERTYPE_CHROMECAST:"chromecast",SUBTITLE_NONE:"none",SUBTITLE_DISCOVER:"discover",SUBTITLE_SEARCH:"search",SUBTITLE_BROWSE:"browse",SUBTITLE_SYNC:"sync",SUBTITLE_RESIZE:"resize",QUALITY_RAW:null,QUALITY_HD_HIGH:"hd_high",QUALITY_HD_MEDIUM:"hd_medium",QUALITY_HD_LOW:"hd_low",getErrorString:function(a,b){if(!Ext.isObject(a)){return""}var g;var c=a.code;if(Ext.isArray(a.errors)&&a.errors.length>0){var f=a.errors[0];if(Ext.isNumber(f.code)){c=f.code}}c=Ext.isNumber(c)?c:100;try{if(c<400){g=SYNO.API.Errors.common[c]||_T("error","error_error_system")}else{g=SYNO.VideoController2.Util.APIErrorStringMap[b][c]||_T("error","error_error_system")}}catch(d){g=_T("error","error_error_system")}return g},getLocationFullPath:function(){var a=window.location.pathname.replace(new RegExp("(?:\\/+[^\\/]*){0,1}$"),"/");return String.format("{0}{1}",window.location.origin,a)},getStreamURL:function(c,a){var d={format:a};Ext.apply(d,SYNO.VideoController2.SharingHelper.getAPI("Streaming"));Ext.apply(d,SYNO.VideoController2.SharingHelper.getStreamingParam(c));SYNO.VideoController2.Util.applySharingID(d);var b=String.format("{0}{1}/1.m3u8",SYNO.VideoController2.Util.getLocationFullPath(),SYNO.VideoController2.SharingHelper.getCGIPath("vtestreaming"));return Ext.urlAppend(b,Ext.urlEncode(d))},getExtM3U:function(c,a,b){var e={width:c,height:a,url:b};var d=String.format("{0}webman/3rdparty/VideoStation/controller/ui/cgi/extm3u.cgi/1.m3u8",SYNO.VideoController2.Util.getLocationFullPath());return Ext.urlAppend(d,Ext.urlEncode(e))},getLiveStreamURL:function(b,a){var c={api:"SYNO.DTV.Streaming",method:"stream",version:1,tuner:b,stream_id:a,format:"hls"};return Ext.urlAppend("webapi/VideoStation/dtvstreaming.cgi/1.m3u8",Ext.urlEncode(c))},getLocationOrigin:function(){var a=location.origin;var b=a[a.length-1];return(b==="/"?a:a+"/")},getImageURL:function(b,a){var c={api:"SYNO.VideoStation.Poster",method:"getimage",version:1,id:b,type:a};SYNO.VideoController2.Util.applySharingID(c);if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(c,{hr:2})}return Ext.urlAppend("webapi/VideoStation/poster.cgi",Ext.urlEncode(c))},getSubtitleUrl:function(a){var b={id:a.video_list.getFileUniqueKey(),subtitle_codepage:a.subtitle_codepage,_sid:Ext.encode(Ext.util.Cookies.get("id"))};Ext.apply(b,SYNO.VideoController2.SharingHelper.getAPI("Subtitle"));Ext.apply(b,SYNO.VideoController2.SharingHelper.getSubtitleParam(a.subtitle_id));return Ext.urlAppend(String.format("{0}{1}",SYNO.VideoController2.Util.getLocationFullPath(),SYNO.VideoController2.SharingHelper.getCGIPath("subtitle")),Ext.urlEncode(b))},getBackdropURL:function(a){var c={api:"SYNO.VideoStation.Backdrop",method:"get",version:"1",mapper_id:a};var b=Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode(c));return b},toHex:function(c){var b="";for(var a=0;a<c.length;++a){b+=c.charCodeAt(a).toString(16)}return b},roundPercentage:function(a){return Ext.isNumber(a)?Math.round(parseFloat(a)*100):NaN},tryCallback:function(a){if(Ext.isFunction(a)){a()}},isVideoControllerOnly:function(){return Ext.query(".syno-vc-appwin.sds-standalone-main-window").length>0||SYNO.VideoController2.Util.isPublicSharing()},isPublicSharing:function(){return _S("IsPublicSharing")===true},applySharingID:function(a){if(SYNO.VideoController2.Util.isPublicSharing()){a.sharing_id=SYNO.VideoController2.SharingHelper.getSharingID()}},getIDorPathParam:function(a){var b={};if(Ext.isString(a)){b={path:a}}else{b={id:a}}return b},isMP4Container:function(a){return -1!=a.indexOf("mp4")},isWebPlayableMP4:function(a,b){if(b!=="mp3"&&b.indexOf("aac")===-1){return false}if(Ext.isMac&&Ext.isSafari&&a=="mpeg4"){return true}return a==="h264"},hasScript:function(a){return document.querySelectorAll('script[src*="'+a+'"]').length>0},loadScript:function(b,a,g){if(this.hasScript(a)){this.tryCallback(g);return}var c=document.getElementsByTagName("head")[0];var f=document.createElement("script");var e=String.format("{0}/{1}",b.jsBaseURL,a);if(Ext.isIE){f.onready=g;f.onreadystatechange=function d(){if("complete"!==this.readyState&&"loaded"!==this.readyState){return}this.onready()}}else{f.onload=g}f.type="text/javascript";f.src=e;c.appendChild(f)},setCastApiAvailable:function(a){if(Ext.isDefined(window.chrome)&&Ext.isDefined(window.chrome.cast)){a.chromecast_api=window.chrome.cast.isAvailable}window.__onGCastApiAvailable=function(b,c){a.chromecast_api=b}},getComboBoxCodepageList:function(b){var a=[["BIG5",_T("codepage","chinese_traditional")+" (BIG5)"],["BIG5-HKSCS",_T("codepage","chinese_traditional")+" (BIG5-HKSCS)"],["GBK",_T("codepage","chinese_simplified")+" (GBK)"],["GB18030",_T("codepage","chinese_simplified")+" (GB18030)"],["EUC-JP",_T("codepage","japanese")+" (EUC-JP)"],["SHIFT_JIS",_T("codepage","japanese")+" (SHIFT_JIS)"],["ISO-2022-JP",_T("codepage","japanese")+" (ISO-2022-JP)"],["EUC-KR",_T("codepage","korean")+" (EUC-KR)"],["CP949",_T("codepage","korean")+" (CP949)"],["CP1258",_T("codepage","vietnamese")+" (CP1258)"],["VISCII",_T("codepage","vietnamese")+" (VISCII)"],["TIS-620",_T("codepage","thai")+" (TIS-620)"],["ISO-8859-11",_T("codepage","thai")+" (ISO-8859-11)"],["ISO-8859-2",_T("codepage","central_european")+" (ISO-8859-2)"],["CP1250",_T("codepage","central_european")+" (CP1250)"],["ISO-8859-10",_T("codepage","nordic")+" (ISO-8859-10)"],["ISO-8859-1",_T("codepage","western")+" (ISO-8859-1)"],["ISO-8859-15",_T("codepage","western")+" (ISO-8859-15)"],["CP1252",_T("codepage","western")+" (CP1252)"],["Macintosh",_T("codepage","western")+" (Macintosh)"],["CP1254",_T("codepage","turkish")+" (CP1254)"],["CP1255",_T("codepage","hebrew")+" (CP1255)"],["ISO-8859-8",_T("codepage","hebrew")+" (ISO-8859-8)"],["ISO-8859-7",_T("codepage","greek")+" (ISO-8859-7)"],["CP1253",_T("codepage","greek")+" (CP1253)"],["CP1256",_T("codepage","arabic")+" (CP1256)"],["ISO-8859-6",_T("codepage","arabic")+" (ISO-8859-6)"],["ISO-8859-4",_T("codepage","baltic")+" (ISO-8859-4)"],["ISO-8859-13",_T("codepage","baltic")+" (ISO-8859-13)"],["CP1257",_T("codepage","baltic")+" (CP1257)"],["ISO-8859-3",_T("codepage","south_european")+" (ISO-8859-3)"],["ISO-8859-5",_T("codepage","cyrillic")+" (ISO-8859-5)"],["CP1251",_T("codepage","cyrillic")+" (CP1251)"],["KOI8-R",_T("codepage","cyrillic")+" (KOI8-R)"],["KOI8-U",_T("codepage","cyrillic")+" (KOI8-U)"],["ISO-8859-14",_T("codepage","celtic")+" (ISO-8859-14)"],["ISO-8859-16",_T("codepage","romanian")+" (ISO-8859-16)"],["ARMSCII-8",_T("codepage","armenian")+" (ARMSCII-8)"],["Georgian-Academy",_T("codepage","georgian")+" (Georgian-Academy)"],["KOI8-T",_T("codepage","tajik")+" (KOI8-T)"],["CP1133",_T("codepage","laotian")+" (CP1133)"],["PT154",_T("codepage","kazakh")+" (PT154)"]];a.sort(function(d,c){return d[1].localeCompare(c[1])});a.unshift(["UTF-16",_T("codepage","unicode")+" (UTF-16)"]);a.unshift(["UTF-8",_T("codepage","unicode")+" (UTF-8)"]);if(b){a.unshift(["auto",_VCT("controller","auto_detect")])}return a},SubtitleExtensions:{ssa:"plain_text",ass:"plain_text",srt:"plain_text",smi:"plain_text",sami:"plain_text"},TextFileExtensions:{abap:"abap",as:"actionsctipt",ada:"ada",s:"assembly_x86",ahk:"autohotkey",bat:"batchfile",c:"c_cpp",cpp:"c_cpp",clj:"clojure",edn:"clojure",cbl:"cobol",coffee:"coffee",cfm:"coldfusion",cs:"csharp",css:"css",d:"d",dart:"dart",diff:"diff",dot:"dot",ejs:"ejs",erl:"erlang",f:"forth",fth:"forth",forth:"forth",ftl:"ftl",glsl:"glsl",go:"golang",groovy:"groovy",haml:"haml",handlebars:"handlebars",hs:"haskell",hx:"haxe",ht3:"html",htm:"html",html:"html",htmls:"html",ini:"ini",jack:"jack",jade:"jade",java:"java",js:"javascript",json:"json",jsp:"jsp",jsx:"jsx",jl:"julia",latex:"latex",less:"less",liquid:"liquid",lisp:"lisp",ls:"livescript",lsl:"lsl",lua:"lua",mk:"makefile",markdown:"markdown",m:"matlab",mysql:"mysql",nix:"nix",ocaml:"ocaml",pascal:"pascal",perl:"perl",php:"php",txt:"plain_text",pl:"prolog",py:"python",r:"r",rhtml:"rhtml",rb:"ruby",rbw:"ruby",rs:"rust",sass:"sass",scad:"scad",scala:"scala",scm:"scheme",ss:"scheme",scss:"scss",sh:"sh",sjs:"sjs",sql:"sql",styl:"stylus",svg:"svg",tcl:"tcl",tex:"tex",textile:"textile",vb:"vbscript",v:"verilog",vhdl:"vhdl",xml:"xml",xq:"xquery",xqy:"xquery",xquery:"xquery",yml:"yaml",yaml:"yaml","!!!":"plain_text","$00":"plain_text","$01":"plain_text","$02":"plain_text","$04":"plain_text","$05":"plain_text","$o1":"plain_text","$ol":"plain_text","001":"plain_text","12da":"plain_text","1st":"plain_text","7":"plain_text","82t":"plain_text","92t":"plain_text",abl:"plain_text",ac:"plain_text",adiumhtmllog:"plain_text",adiumlog:"plain_text",adl:"plain_text",adt:"plain_text",adw:"plain_text",aiml:"plain_text",alx:"plain_text",aml:"plain_text",android:"plain_text",annot:"plain_text",ans:"plain_text",ansi:"plain_text",application:"plain_text",aprj:"plain_text",apx:"plain_text",aqt:"plain_text",arff:"plain_text",ARTask:"plain_text",asc:"plain_text",ascii:"plain_text",asl:"plain_text",asp:"plain_text",ass:"plain_text",assoc:"plain_text",atc:"plain_text",att:"plain_text",awa:"plain_text",awb:"plain_text",awd:"plain_text",awh:"plain_text",awp:"plain_text",axt:"plain_text",ba1:"plain_text",bad:"plain_text",bas:"plain_text",bbs:"plain_text",bbxt:"plain_text",bcr:"plain_text",bdp:"plain_text",bdr:"plain_text",bea:"plain_text",bel:"plain_text",bep:"plain_text",big:"plain_text",big5:"plain_text",bk:"plain_text",blm:"plain_text",bln:"plain_text",blw:"plain_text",bmtp:"plain_text",bna:"plain_text",bnx:"plain_text",bog:"plain_text",box:"plain_text",bpdx:"plain_text",brf:"plain_text",bsdl:"plain_text",bss:"plain_text",bt:"plain_text",bzw:"plain_text",cag:"plain_text",cas:"plain_text",cascii:"plain_text",cc:"plain_text",cd2:"plain_text",charset:"plain_text",cho:"plain_text",chord:"plain_text",cif:"plain_text",cil:"plain_text",ckn:"plain_text",clg:"plain_text",cli:"plain_text",clix:"plain_text",cmd:"plain_text",cmtx:"plain_text",cof:"plain_text",conf:"plain_text",coo:"plain_text",crash:"plain_text",crd:"plain_text",csassembly:"plain_text",csmanifest:"plain_text",csv:"plain_text",ctd:"plain_text",ctf:"plain_text",ctl:"plain_text",ctx:"plain_text",dat:"plain_text",dcd:"plain_text",dce:"plain_text",ddd:"plain_text",ddt:"plain_text",de:"plain_text",dectest:"plain_text",des:"plain_text",desc:"plain_text",dfe:"plain_text",dfm:"plain_text",dii:"plain_text",diskdefines:"plain_text",diz:"plain_text",dk:"plain_text",dkz:"plain_text",dmr:"plain_text",dne:"plain_text",dok:"plain_text",dp:"plain_text",dpv:"plain_text",dqy:"plain_text",drp:"plain_text",dsc:"plain_text",dsml:"plain_text",dtd:"plain_text",dwl:"plain_text",ecsv:"plain_text",edml:"plain_text",edt:"plain_text",efm:"plain_text",eia:"plain_text",emulecollection:"plain_text",en:"plain_text",enc:"plain_text",enf:"plain_text",eng:"plain_text",err:"plain_text",es:"plain_text",esw:"plain_text",etf:"plain_text",etx:"plain_text",euc:"plain_text",ext:"plain_text",extra:"plain_text",faq:"plain_text",fff:"plain_text",ffp:"plain_text",fin:"plain_text",first:"plain_text",flr:"plain_text",fmr:"plain_text",fnx:"plain_text",fon:"plain_text",fr:"plain_text",fra:"plain_text",frm:"plain_text",fsa:"plain_text",full:"plain_text",gbf:"plain_text",gdt:"plain_text",gen:"plain_text",ger:"plain_text",gnu:"plain_text",gpl:"plain_text",gs:"plain_text",gthr:"plain_text",gtx:"plain_text",guide:"plain_text",hdr:"plain_text",hhc:"plain_text",hhs:"plain_text",hlm:"plain_text",hlx:"plain_text",hp8:"plain_text",hsk:"plain_text",htx:"plain_text",hvc:"plain_text",hwl:"plain_text",hz:"plain_text",id31:"plain_text",id32:"plain_text",idc:"plain_text",idt:"plain_text",idx:"plain_text",iem:"plain_text",igv:"plain_text",igy:"plain_text",iif:"plain_text",ill:"plain_text",inc:"plain_text",inuse:"plain_text",ion:"plain_text",ipr:"plain_text",iqy:"plain_text",isr:"plain_text",it:"plain_text",ivp:"plain_text",ja:"plain_text",jad:"plain_text",jam:"plain_text",jeb:"plain_text",jis:"plain_text",jp1:"plain_text",jss:"plain_text",jtx:"plain_text",kahl:"plain_text",kar:"plain_text",kch:"plain_text",kix:"plain_text",klg:"plain_text",kor:"plain_text",la:"plain_text",label:"plain_text",las:"plain_text",lay:"plain_text",lin:"plain_text",linux:"plain_text",linx:"plain_text",lnc:"plain_text",log:"plain_text",lo_:"plain_text",lrc:"plain_text",lst:"plain_text",ltr:"plain_text",ltt:"plain_text",ltx:"plain_text",lue:"plain_text",luf:"plain_text",lwd:"plain_text",lxfml:"plain_text",lyr:"plain_text",lyt:"plain_text",man:"plain_text",manifest:"plain_text",map:"plain_text",mar:"plain_text",mathml:"plain_text",maxFR:"plain_text",mcw:"plain_text",md:"plain_text",mdl:"plain_text",mdle:"plain_text",mdown:"plain_text",mdtext:"plain_text",mdtxt:"plain_text",mdwn:"plain_text",me:"plain_text",mez:"plain_text",mf:"plain_text",mib:"plain_text",mit:"plain_text",mkd:"plain_text",mkdn:"plain_text",mno:"plain_text",mnu:"plain_text",modd:"plain_text",mpsub:"plain_text",mss:"plain_text",mtx:"plain_text",mtxt:"plain_text",mvg:"plain_text",mw:"plain_text",nbr:"plain_text",nclk:"plain_text",ncm:"plain_text","new":"plain_text",nfo:"plain_text",nlc:"plain_text",nmbd:"plain_text",nokogiri:"plain_text",not:"plain_text",notes:"plain_text",now:"plain_text",npdt:"plain_text",nt:"plain_text",nwctxt:"plain_text",ocr:"plain_text",odc:"plain_text",oh:"plain_text",ojp:"plain_text",omn:"plain_text",oogl:"plain_text",oot:"plain_text",opc:"plain_text",openbsd:"plain_text",opml:"plain_text",ort:"plain_text",osi:"plain_text",p3x:"plain_text",panic:"plain_text",pbd:"plain_text",pc5:"plain_text",pcl:"plain_text",pd:"plain_text",pdu:"plain_text",pfs:"plain_text",pgw:"plain_text",pjs:"plain_text",pla:"plain_text",plf:"plain_text",plg:"plain_text",plist:"plain_text",plk:"plain_text",pln:"plain_text",pml:"plain_text",pmo:"plain_text",pod:"plain_text",prc:"plain_text",prn:"plain_text",pro:"plain_text",prr:"plain_text",ps:"plain_text",psb:"plain_text",psi2:"plain_text",pt3:"plain_text",pts:"plain_text",pvj:"plain_text",pvw:"plain_text","q&a":"plain_text",qdt:"plain_text",qud:"plain_text",rbdf:"plain_text",rdf:"plain_text",rea:"plain_text",readme:"plain_text",reg:"plain_text",rel:"plain_text",rep:"plain_text",resp:"plain_text",rest:"plain_text",rff:"plain_text",ris:"plain_text",rml:"plain_text",rqy:"plain_text",rst:"plain_text",rt:"plain_text",rtf:"plain_text",rtl:"plain_text",rtx:"plain_text",ru:"plain_text",rus:"plain_text",rzk:"plain_text",rzn:"plain_text",s19:"plain_text",s2k:"plain_text",sami:"plain_text",sbv:"plain_text",sct:"plain_text",sdnf:"plain_text",sen:"plain_text",seq:"plain_text",set:"plain_text",sfb:"plain_text",sgp:"plain_text",sha1:"plain_text",sha512:"plain_text",skcard:"plain_text",skv:"plain_text",sls:"plain_text",smali:"plain_text",smf:"plain_text",smi:"plain_text",sms:"plain_text",snw:"plain_text",soap:"plain_text",soundscript:"plain_text",spa:"plain_text",spec:"plain_text",spg:"plain_text",spn:"plain_text",spx:"plain_text",srt:"plain_text",srx:"plain_text",ssa:"plain_text",ssf:"plain_text",st1:"plain_text",stf:"plain_text",stq:"plain_text",strings:"plain_text",sub:"plain_text",syn:"plain_text",t:"plain_text",t2t:"plain_text",tab:"plain_text",tbd:"plain_text",tbl:"plain_text",tbx:"plain_text",tce:"plain_text",tcm:"plain_text",tdf:"plain_text",ted:"plain_text",text:"plain_text",textclipping:"plain_text",tfw:"plain_text",tgf:"plain_text",thml:"plain_text",thp:"plain_text",tlb:"plain_text",tle:"plain_text",tlx:"plain_text",tm:"plain_text",tml:"plain_text",tmprtf:"plain_text",tmx:"plain_text",tnef:"plain_text",tph:"plain_text",tpl:"plain_text",trn:"plain_text",trt:"plain_text",tsv:"plain_text",tt:"plain_text",ttbl:"plain_text",tte:"plain_text",ttf:"plain_text",ttpl:"plain_text",ttxt:"plain_text",tx8:"plain_text","tx?":"plain_text",txa:"plain_text",txd:"plain_text",txe:"plain_text",txh:"plain_text",u3i:"plain_text",uax:"plain_text",uhtml:"plain_text",uk:"plain_text",unauth:"plain_text",uni:"plain_text",unx:"plain_text",us:"plain_text",usa:"plain_text",user:"plain_text",usf:"plain_text",usg:"plain_text",utf8:"plain_text",utx:"plain_text",utxt:"plain_text",ver:"plain_text",vet:"plain_text",vfk:"plain_text",vhd:"plain_text",vis:"plain_text",vkp:"plain_text",vmg:"plain_text",vmsg:"plain_text",vna:"plain_text",vsmproj:"plain_text",vw:"plain_text",vw3:"plain_text",vxml:"plain_text",wer:"plain_text",wir:"plain_text",wkf:"plain_text",wn:"plain_text",wrd:"plain_text",wrl:"plain_text",wsc:"plain_text",wst:"plain_text",wtf:"plain_text",wtl:"plain_text",wtx:"plain_text",x20:"plain_text",x60:"plain_text",x70:"plain_text",x80:"plain_text",x90:"plain_text",xb0:"plain_text",xc0:"plain_text",xct:"plain_text",xd0:"plain_text",xdl:"plain_text",xdp:"plain_text",xfd:"plain_text",xff:"plain_text",xhtm:"plain_text",xlf:"plain_text",xsd:"plain_text",xsl:"plain_text",xslt:"plain_text",xsr:"plain_text",xwp:"plain_text",xy:"plain_text",xy3:"plain_text",xyp:"plain_text",xyw:"plain_text",xyz:"plain_text",zanebug:"plain_text",zed:"plain_text",zhp:"plain_text",zib:"plain_text",zw:"plain_text",zxe:"plain_text",_me:"plain_text"}}});Ext.define("SYNO.VideoController2.SupportFileVideo",{});Ext.define("SYNO.VideoController2.HLSHandler",{constructor:function(a){this.controller=a.controller},ableToRemux:function(d){if(!this.controller.supportRemux()){return false}var a=d.container_type;var c=d.video_codec;var b=("h264"===c)&&(SYNO.VideoController2.Util.isMP4Container(a)||"matroska,webm"===a);return b},closeStream:function(){if(Ext.isEmpty(this.controller.stream_id)||Ext.isEmpty(this.controller.stream_format)){return}var a={async:false,params:Ext.apply({format:this.controller.stream_format},SYNO.VideoController2.SharingHelper.getStreamingCloseParam(this.controller.stream_id)),scope:this,callback:function(e,d,c,b){if(e){this.controller.stream_id=null;this.controller.stream_format=null}}};Ext.apply(a,SYNO.VideoController2.SharingHelper.getAPI("StreamingClose"));SYNO.VideoController2.Util.applySharingID(a.params);SYNO.API.Request(a)}});Ext.onReady(function(){if(SYNO.VideoController2.Util.isPublicSharing()){return}Ext.define("SYNO.VideoController2.BrowseSubtitleDialog",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",constructor:function(b){this.appWin=b.appWin;this.sharepath=b.sharepath||"";var a={cls:"syno-vc-dialog",owner:this.appWin,width:960,height:480,title:_VCT("controller","browse_subtitle"),gotoPath:this.sharepath,listeners:{afterrender:function(){this.getEl().select(".syno-ux-treepanel").each(function(d){d.addClass("syno-vc-treepanel")});this.getEl().select(".syno-ux-gridpanel").each(function(d){d.addClass("syno-vc-gridpanel")});this.getEl().select(".syno-ux-pagingtoolbar").each(function(d){d.addClass("syno-vc-pagingtoolbar")});this.getEl().select(".syno-ux-button").each(function(d){d.addClass("syno-vc-button")});this.getEl().select(".syno-ux-combobox").each(function(d){d.addClass("syno-vc-combobox")});var c=this.items.itemAt(1).items;c.itemAt(0).items.itemAt(0).listClass="syno-vc-combobox-list";c.itemAt(0).items.itemAt(1).listClass="syno-vc-combobox-list"}},columnCfg:{filename:{width:500}},comboOption:[{label:_VCT("controller","file_type"),value:"allSubtitle",data:[["allSubtitle",_VCT("controller","subtitle_type")],["allText",_VCT("controller","all_text_file")],["all",_VCT("controller","all_file")]]},{label:_VCT("controller","codepage"),value:"auto",data:SYNO.VideoController2.Util.getComboBoxCodepageList(true)}],getFilterPattern:function(c){var d=[],e={};if("allSubtitle"===c[0].value){for(e in SYNO.VideoController2.Util.SubtitleExtensions){if(SYNO.VideoController2.Util.SubtitleExtensions.hasOwnProperty(e)){d.push(e)}}return d.join()}if("allText"===c[0].value){for(e in SYNO.VideoController2.Util.TextFileExtensions){if(SYNO.VideoController2.Util.TextFileExtensions.hasOwnProperty(e)){d.push(e)}}return d.join()}return""}};this.callParent([a])},initBottomPanelConfig:function(b){var a=this.callParent([b]);a.height=36*b.comboOption.length+12;return a}})});Ext.define("SYNO.VideoController2.ChannelStore",{extend:"SYNO.API.Store",ChannelRecord:Ext.data.Record.create([{name:"channel",type:"int"},{name:"id",type:"string"},{name:"title",type:"string"}]),constructor:function(b){var a={api:"SYNO.DTV.Channel",method:"list",version:1,baseParams:{offset:0,limit:-1},reader:new Ext.data.JsonReader({root:"channels"},this.ChannelRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.Player",{extend:"Ext.util.Observable",constructor:function(b){var a=Ext.apply({subtitle_is_srt:true,name:"",player:null,pluginInit:false},b);this.callParent([a]);Ext.apply(this,a)},canPlayType:Ext.emptyFn,isAvailable:Ext.emptyFn,getName:function(){return this.name},fullscreen:Ext.emptyFn,play:Ext.emptyFn,pause:Ext.emptyFn,resume:Ext.emptyFn,stop:Ext.emptyFn,seek:Ext.emptyFn,getPosition:Ext.emptyFn,getDuration:Ext.emptyFn,getVolume:Ext.emptyFn,setVolume:Ext.emptyFn,getMute:Ext.emptyFn,setMute:Ext.emptyFn,getState:Ext.emptyFn,disablePlayerSubtitle:Ext.emptyFn,setPlayerSubtitle:Ext.emptyFn,setSubtitleDelay:Ext.emptyFn,setSubtitleSize:Ext.emptyFn,setStartPosition:function(a){if(Ext.isNumber(a)&&a>0){this.start_position=a}},notifyClear:function(){this.controller.updateState(SYNO.VideoController2.Util.STATE.CLEAR)},clear:function(){if(this.player){this.el.remove();this.el=null;this.player=null;this.pluginInit=false;this.notifyClear()}},stateHandler:function(d){var c=this.getState();if(c===SYNO.VideoController2.Util.STATE.PLAYING){this.disablePlayerSubtitle();if(Ext.isNumber(this.start_position)){var a=this.start_position;this.start_position=null;var b=this.seek.createDelegate(this,[a]);b.defer(200)}}this.controller.updateState(c,d)},durationHandler:function(b){var a=Ext.isNumber(b)?b:this.getDuration();this.controller.updateDuration(a)},positionHandler:function(a){var b=Ext.isNumber(a)?a:this.getPosition();this.controller.updatePosition(b)},volumeHandler:function(){this.controller.updateMute(this.getMute());var a=this.getVolume();if(Ext.isNumber(a)&&a>=0&&a<=100){this.controller.updateVolume(a)}},webkitHandler:function(){this.controller.stop();this.controller.play();this.controller.pause()},registerEventHandler:Ext.emptyFn,unregisterEventHandler:Ext.emptyFn,createPollingTask:function(){this.task_runner=new SYNO.SDS.TaskRunner();this.polling_status=this.task_runner.createTask({scope:this,run:function(){this.pollingTaskFn()},interval:100});this.polling_status.start(true)},destroyPollingTask:function(){if(this.task_runner){this.polling_status=null;this.task_runner.destroy();this.task_runner=null}},pollingTaskFn:Ext.emptyFn});Ext.define("SYNO.VideoController2.ChromecastPlayer",{extend:"SYNO.VideoController2.Player",constructor:function(b){var a={id:SYNO.VideoController2.Util.CHROMECAST_ID,type:SYNO.VideoController2.Util.PLAYERTYPE_CHROMECAST,name:"Chromecast",pluginInit:false,retry_request_session:10,state:SYNO.VideoController2.Util.STATE.STOPPED,volume:50,muted:false,password_protected:false,volume_adjustable:true,seekable:true,video_url:"",enable_ac3_passthrough:(SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","enable_ac3_passthrough")===true),app_id:"41BF9C95",namespace:"urn:x-cast:com.synology.dsvideo",session:null,auth_key:"",identify_command:{version:1,command:"identify",data:{platform:"videostation",platform_version:"1.5",app_version:108,client_id:""}}};this.callParent([Ext.apply(a,b)]);this.hls_handler=new SYNO.VideoController2.HLSHandler(b);this.initializeCastApi()},StateMap:{STOPPED:SYNO.VideoController2.Util.STATE.STOPPED,PLAYING:SYNO.VideoController2.Util.STATE.PLAYING,PAUSED:SYNO.VideoController2.Util.STATE.PAUSED,ERROR:SYNO.VideoController2.Util.STATE.ERROR},CastRepeatMap:["REPEAT_OFF","REPEAT_OFF","REPEAT_SINGLE"],getIdentifyCommand:function(){return SYNO.Util.copy(this.identify_command)},getChallengeCommand:function(b){this.auth_key=md5(b);var a=this.getIdentifyCommand();Ext.apply(a.data,{auth_key:this.auth_key});return a},getTimeoutTask:function(){if(!Ext.isDefined(this.timeout_task)){this.timeout_task=new Ext.util.DelayedTask(this.showNetworkError.createDelegate(this),this)}return this.timeout_task},getVideoUrl:function(a){this.video_url=a||this.video_url;var b=SYNO.VideoController2.Util.getLocationOrigin();return(this.video_url.indexOf(b)===0)?this.video_url:b+this.video_url},getPosterUrl:function(a){var b=SYNO.VideoController2.Util.getLocationOrigin();var c=SYNO.VideoController2.Util.getImageURL(a.id,a.type);return String.format("{0}{1}&_sid={2}",b,c,Ext.util.Cookies.get("id"))},ableToPlayRaw:function(d,b){var a=b.width/b.height>1;if(a===true&&(b.width>1920||b.height>1080)||a===false&&(b.width>1080||b.height>1920)){return false}if(!SYNO.VideoController2.Util.isMP4Container(d.container_type)&&d.container_type.indexOf("webm")===-1){return false}var c=d.video_codec;if(c!=="mpeg4"&&c!=="h264"&&c!=="mjpeg"){return false}return this.ableToPlayRawAudio(d.audio_codec)},ableToPlayRawAudio:function(a){return a.indexOf("aac")!==-1||a.indexOf("mp3")!==-1||(a.indexOf("ac3")!==-1&&this.enable_ac3_passthrough)},ableToRemux:function(b,a){if(a.width>1920||a.height>1080){return false}return this.hls_handler.ableToRemux(b)},ableToTranscode:function(){return this.controller.supportTranscode()},isRaw:function(a){return a.indexOf("SYNO.VideoStation2.File")!==-1},canPlayType:function(a){return a==="mp4"},isAvailable:function(){return this.available},play:function(b){var a=this.getVideoUrl(b);var h=this.controller.video_info;var g=SYNO.VideoController2.Util.getSubtitleUrl(this.controller);var e=this.controller.getDelayedTime();var f=this.controller.getSubtitleSize();this.timeout=this.isRaw(a)?15000:30000;var c=new chrome.cast.media.MediaInfo(a);c.contentType=this.isRaw(a)?"video/mp4":"application/x-mpegURL";c.duration=this.controller.video_list.getDuration();c.customData={type:h.type,title:this.controller.video_list.getName(),date:this.controller.video_list.getDate(),poster_uri:this.getPosterUrl(h),video_format:this.isRaw(a)?"mp4":"hls",subtitle_uri:g,subtitle_offset:e,subtitle_size:f};var i=new chrome.cast.media.QueueItem(c);i.autoplay=true;i.startTime=this.start_position||0;var d=new chrome.cast.media.QueueLoadRequest([i]);d.startIndex=0;d.repeatMode=this.CastRepeatMap[this.controller.repeat];this.media_loading=true;this.session.queueLoad(d,this.onMediaDiscovered.createDelegate(this,["loadMedia"],true),this.onError.createDelegate(this));this.state=SYNO.VideoController2.Util.STATE.BUFFERING;this.startPolling()},onMediaDiscovered:function(b,a){this.media=b;this.media_loading=false},pause:function(){this.media.pause(null,Ext.emptyFn,this.onError.createDelegate(this))},resume:function(){this.media.play(null,Ext.emptyFn,this.onError.createDelegate(this))},stop:function(){if(this.task_runner){this.media.stop(null,Ext.emptyFn,this.onError.createDelegate(this))}},seek:function(a){if(!this.media||this.media_loading){return}var b=new chrome.cast.media.SeekRequest();b.currentTime=a.toFixed(0);this.media.seek(b,Ext.emptyFn,this.onError.createDelegate(this))},getPosition:function(){if(!this.pluginInit){return -1}return this.position},getDuration:function(){if(!this.pluginInit){return -1}return this.duration},getVolume:function(){return this.volume},setVolume:function(a){this.session.setReceiverVolumeLevel(a/100)},getMute:function(){return this.muted},setMute:function(a){this.session.setReceiverMuted(a)},getState:function(){return this.state},disablePlayerSubtitle:Ext.emptyFn,setPlayerSubtitle:function(a){this.sendMessage({version:1,command:"subtitle.uri",data:{subtitle_uri:a}})},setSubtitleDelay:function(a){this.sendMessage({version:1,command:"subtitle.offset",data:{offset:a}})},setSubtitleSize:function(a){this.sendMessage({version:1,command:"subtitle.size",data:{size:a}})},setRepeat:function(a){this.media.queueSetRepeatMode(this.CastRepeatMap[a],Ext.emptyFn,this.onError.createDelegate(this))},close:function(){this.sendMessage({version:1,command:"close"})},clear:function(){this.stopPolling();this.stopAttachPolling();this.hls_handler.closeStream();this.notifyClear()},initializeCastApi:function(){var b=new chrome.cast.SessionRequest(this.app_id);var c=new chrome.cast.ApiConfig(b,this.sessionListener.createDelegate(this),this.receiverListener.createDelegate(this));var d=Ext.emptyFn;var a=Ext.emptyFn;chrome.cast.initialize(c,d,a)},sessionListener:function(a){this.session=a},receiverListener:function(a){this.available=(a==="available")},sessionUpdateListener:function(a){this.getTimeoutTask().cancel();if(!a&&this.state===1){this.clear()}else{this.showNetworkError()}},launchApp:function(c,b){if((!Ext.isDefined(this.available)||this.available!==true)&&this.retry_request_session>=0){this.launchApp.defer(100,this,arguments);this.retry_request_session--;return}this.initPlay=c;var d=function(f){this.session=f;this.session.sendMessage(this.namespace,this.getIdentifyCommand(),this.onSuccess.createDelegate(this),this.onError.createDelegate(this));this.session.addUpdateListener(this.sessionUpdateListener.createDelegate(this));this.session.addMessageListener(this.namespace,this.receiverMessage.createDelegate(this))};var a=function(f){b();if(f.code==="receiver_unavailable"){f.description=_VCT("controller","error_state")}this.onError(f)}.createDelegate(this);chrome.cast.requestSession(d.createDelegate(this),a)},stopApp:function(){this.getTimeoutTask().cancel();this.stopPolling();if(!this.session){return}var a=function(b){this.pluginInit=false};this.session.stop(a.createDelegate(this),this.onError.createDelegate(this))},sendMessage:function(a){if(this.session!==null){this.session.sendMessage(this.namespace,a,this.onSuccess.createDelegate(this,[Ext.encode(a)]),this.onError.createDelegate(this))}else{if(a.command==="stop"){return}this.launchApp(Ext.emptyFn,Ext.emptyFn)}},receiverMessage:function(a,d){this.getTimeoutTask().cancel();this.stopAttachPolling();var e=Ext.decode(d);if(!e||!e.type){this.state=SYNO.VideoController2.Util.STATE.ERROR;this.prev_state=this.state;return}if(e.type==="challenge"){this.sendMessage(this.getChallengeCommand(e.data.seed));return}if(e.type==="status"&&e.data&&e.data.state){this.state=this.StateMap[e.data.state.toUpperCase()]||SYNO.VideoController2.Util.STATE.ERROR}if(this.state===SYNO.VideoController2.Util.STATE.STOPPED&&!this.pluginInit){this.pluginInit=true;this.initPlay()}else{if(this.state===SYNO.VideoController2.Util.STATE.PLAYING){if(this.prev_state===SYNO.VideoController2.Util.STATE.ERROR){this.pluginInit=true;this.startPolling()}else{if(e.data.video_uri!==this.getVideoUrl()){this.pluginInit=true;this.initPlay();this.prev_state=this.state;return}}this.getTimeoutTask().delay(this.timeout);this.position=e.data.position;this.duration=e.data.duration;var c=this.session.receiver.volume.level*100;var b=this.session.receiver.volume.muted;if(c!==this.volume){this.volume=c}if(b!==this.muted){this.muted=b}}}this.prev_state=this.state},onSuccess:function(a){},showNetworkError:function(){this.onError({code:"timeout_error",description:_VCT("controller","error_state")})},onError:function(a){this.getTimeoutTask().cancel();this.stopPolling();if(this.controller.getPlayer().id!==SYNO.VideoController2.Util.CHROMECAST_ID&&this.controller.init_player_id!==SYNO.VideoController2.Util.CHROMECAST_ID){return}if(a.code==="cancel"||a.code==="receiver_unavailable"||a.code==="channel_error"||a.code==="timeout_error"||(a.code==="session_error"&&!this.attach_polling_status)){this.pluginInit=false;this.state=SYNO.VideoController2.Util.STATE.ERROR;this.prev_state=this.state;this.stateHandler(a.description)}if(a.code==="timeout_error"){this.startAttachPolling()}},startAttachPolling:function(){this.stopAttachPolling();this.attach_task_runner=new SYNO.SDS.TaskRunner();this.attach_polling_status=this.attach_task_runner.createTask({scope:this,run:this.sendMessage.createDelegate(this,[this.getIdentifyCommand()]),interval:1000});this.attach_polling_status.start(true)},stopAttachPolling:function(){if(this.attach_task_runner){this.attach_polling_status=null;this.attach_task_runner.destroy();this.attach_task_runner=null}},startPolling:function(){this.stopPolling();this.task_runner=new SYNO.SDS.TaskRunner();this.polling_status=this.task_runner.createTask({scope:this,run:function(){this.stateHandler();this.positionHandler();this.durationHandler();this.volumeHandler()},interval:150});this.polling_status.start(true)},stopPolling:function(){if(this.task_runner){this.polling_status=null;this.task_runner.destroy();this.task_runner=null}}});Ext.define("SYNO.VideoController2.FlashPlayer",{extend:"SYNO.VideoController2.Player",constructor:function(b){var a={name:"Flash",player_id:"_flash_video_player",error:false};this.callParent([Ext.apply(a,b)]);this.hls_handler=new SYNO.VideoController2.HLSHandler(b)},ableToRemux:function(a){return this.hls_handler.ableToRemux(a)},ableToTranscode:function(){return this.controller.supportTranscode()},canPlayType:function(a){var b=["mp4","mov","m4v","flv","f4v"];return(-1!==b.indexOf(a))},isAvailable:function(){return SYNO.VideoController2.Util.detectPlugin("ShockwaveFlash.ShockwaveFlash","Shockwave","Flash")},fullscreen:function(){if(this.pluginInit){SYNO.VideoController2.Util.setDomFullscreen(this.controller.container.dom)}},clear:function(){this.delayDestroy.defer(1,this,arguments);this.hls_handler.closeStream()},play:function(a){this.error=false;this.url=a;if(!this.createPlayer()){this.player.load([{file:this.url}])}},pause:function(){if(this.pluginInit){this.player.pause(true)}},resume:function(){if(this.pluginInit){this.player.play(true)}},stop:function(){if(this.pluginInit){this.player.stop()}this.hls_handler.closeStream()},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.getDuration()){this.player.seek(a)}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.getPosition()},getDuration:function(){if(!this.pluginInit){return -1}return this.player.getDuration()},getVolume:function(){if(!this.pluginInit){return -1}return this.player.getVolume()},setVolume:function(a){if(this.pluginInit){this.player.setVolume(a)}},getMute:function(){if(!this.pluginInit){return false}return this.player.getMute()},setMute:function(a){if(this.pluginInit){this.player.setMute(a)}},StateMap:{IDLE:SYNO.VideoController2.Util.STATE.STOPPED,BUFFERING:SYNO.VideoController2.Util.STATE.BUFFERING,PLAYING:SYNO.VideoController2.Util.STATE.PLAYING,PAUSED:SYNO.VideoController2.Util.STATE.PAUSED},getPlayerState:function(){if(!this.pluginInit){return"IDLE"}return this.player.getState()},getState:function(){if(!this.pluginInit){return SYNO.VideoController2.Util.STATE.NO_MEDIA}if(this.error){return SYNO.VideoController2.Util.STATE.ERROR}var a=this.StateMap[this.getPlayerState()]||SYNO.VideoController2.Util.STATE.ERROR;return a},delayDestroy:function(){if(this.player){this.player.remove();this.el.remove();this.el=null;this.player=null;this.pluginInit=false;this.notifyClear()}},onReady:function(){this.pluginInit=true;this.player=jwplayer(this.player_id);this.registerEventHandler();this.setVolume(this.controller.volume)},onError:function(){this.error=true;this.stateHandler()},onPlaylist:function(){this.player.playlistItem(0)},onTime:function(a){if(!Ext.isObject(a)){return}if(Ext.isNumber(a.duration)){this.durationHandler(a.duration)}if(Ext.isNumber(a.position)){this.positionHandler(a.position)}},createPlayer:function(){if(this.player){return false}if(!Ext.isDefined(window.jwplayer)){this.loadJWScript();return true}this.el=Ext.get(this.player_id)||this.controller.video.createChild({tag:"div",id:this.player_id,style:{width:"100%",height:"100%"}});var b=String.format("{0}/skin/empty-controlbar.xml",this.controller.jsBaseURL);var a=String.format("{0}/jwplayer.flash.swf?v=6.8.4616",this.controller.jsBaseURL);this.player=jwplayer(this.player_id).setup({fallback:false,flashplayer:a,file:this.url,controls:false,autostart:false,skin:b,height:"100%",width:"100%",stretching:"uniform",primary:"flash",analytics:{enabled:false}});this.registerSetupHandler();return true},registerSetupHandler:function(){jwplayer(this.player_id).onReady(this.onReady.createDelegate(this));jwplayer(this.player_id).onSetupError(this.onError.createDelegate(this))},registerEventHandler:function(){this.player.onPlaylist(this.onPlaylist.createDelegate(this));this.player.onPlaylistComplete(this.stateHandler.createDelegate(this));this.player.onPlay(this.stateHandler.createDelegate(this));this.player.onPause(this.stateHandler.createDelegate(this));this.player.onBuffer(this.stateHandler.createDelegate(this));this.player.onIdle(this.stateHandler.createDelegate(this));this.player.onComplete(this.stateHandler.createDelegate(this));this.player.onError(this.onError.createDelegate(this));this.player.onTime(this.onTime.createDelegate(this));this.player.onMute(this.volumeHandler.createDelegate(this));this.player.onVolume(this.volumeHandler.createDelegate(this))},loadJWScript:function(){var a=document.getElementsByTagName("head")[0];var b=document.createElement("script");var e=String.format("{0}/jwplayer.js?v=6.8.4616",this.controller.jsBaseURL);var d=this.setJWPlayerKey.createSequence(this.createPlayer,this);b.type="text/javascript";if(Ext.isIE){b.onready=d;b.onreadystatechange=function c(){if("complete"!==this.readyState&&"loaded"!==this.readyState){return}this.onready()}}else{b.onload=d}b.src=e;a.appendChild(b)},setJWPlayerKey:function(){if(jwplayer.key){return}jwplayer.key="ADrNpyYVQ13xVOfDuZpCXl4Bioq40D0Omx8S/CIM46w="}});Ext.define("SYNO.VideoController2.HTML5Player",{extend:"SYNO.VideoController2.Player",constructor:function(b){var a={name:"HTML5",player_id:"_html5_video_player",stopped:false};this.callParent([Ext.apply(a,b)]);this.hls_handler=new SYNO.VideoController2.HLSHandler(b)},ableToRemux:function(a){return this.hls_handler.ableToRemux(a)},ableToTranscode:function(){return this.controller.supportTranscode()},canPlayType:function(b){var a=document.createElement("video"),c=SYNO.VideoController2.Util.MimeType[b]||("video/"+b);if(!a||!Ext.isFunction(a.canPlayType)){return false}return a.canPlayType(c)},isAvailable:function(){var a=document.createElement("video");if(!a||!Ext.isFunction(a.canPlayType)){return false}return true},fullscreen:function(){if(this.pluginInit){SYNO.VideoController2.Util.setDomFullscreen(this.controller.container.dom)}},clear:function(){this.unregisterEventHandler();this.callParent(arguments);this.hls_handler.closeStream()},play:function(a){this.stopped=false;this.createPlayer();this.player.src=a;this.player.play();this.setVolume(this.controller.volume)},pause:function(){if(this.pluginInit){this.player.pause()}},resume:function(){if(this.pluginInit){this.player.play()}},stop:function(){if(this.pluginInit){this.stopped=true;this.player.pause();this.stateHandler()}this.hls_handler.closeStream()},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.duration){this.player.currentTime=a}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.currentTime},getDuration:function(){if(!this.pluginInit){return -1}return this.player.duration},getVolume:function(){if(!this.pluginInit){return -1}return this.player.volume*100},setVolume:function(a){if(this.pluginInit){this.player.volume=a/100}},getMute:function(){var a=false;if(this.pluginInit){a=this.player.muted}return a},setMute:function(a){if(this.pluginInit){this.player.muted=a}},getState:function(){if(!this.pluginInit){return SYNO.VideoController2.Util.STATE.NO_MEDIA}if(this.player.error){return SYNO.VideoController2.Util.STATE.ERROR}if(this.player.ended||this.player.HAVE_NOTHING===this.player.readyState||this.stopped){return SYNO.VideoController2.Util.STATE.STOPPED}if(this.player.paused){return SYNO.VideoController2.Util.STATE.PAUSED}if(this.player.HAVE_CURRENT_DATA>=this.player.readyState){return SYNO.VideoController2.Util.STATE.BUFFERING}return SYNO.VideoController2.Util.STATE.PLAYING},setVisible:function(a){if(Ext.isSafari&&this.el){this.el.setVisible(a)}},createPlayer:function(){if(this.player){return false}this.el=Ext.get(this.player_id)||this.controller.video.createChild({tag:"video",id:this.player_id,style:{width:"100%",height:"100%"}});this.player=this.el.dom;this.registerEventHandler();this.pluginInit=true;this.el.enableDisplayMode();this.el.show();this.player.pause();return true},registerEventHandler:function(){this._stateHandlerWithScope=this.stateHandler.createDelegate(this);this._durationHandlerWithScope=this.durationHandler.createDelegate(this);this._volumeHandlerWithScope=this.volumeHandler.createDelegate(this);this._webkitHandlerWithScope=this.webkitHandler.createDelegate(this);var a=SYNO.VideoController2.Util.addDomListener(false);a(this.player,"play",this._stateHandlerWithScope);a(this.player,"playing",this._stateHandlerWithScope);a(this.player,"waiting",this._stateHandlerWithScope);a(this.player,"pause",this._stateHandlerWithScope);a(this.player,"ended",this._stateHandlerWithScope);a(this.player,"error",this._stateHandlerWithScope);a(this.player,"durationchange",this._durationHandlerWithScope);a(this.player,"volumechange",this._volumeHandlerWithScope);a(this.player,"webkitendfullscreen",this._webkitHandlerWithScope);this.createPollingTask()},unregisterEventHandler:function(){var a=SYNO.VideoController2.Util.removeDomListener(false);a(this.player,"play",this._stateHandlerWithScope);a(this.player,"playing",this._stateHandlerWithScope);a(this.player,"waiting",this._stateHandlerWithScope);a(this.player,"pause",this._stateHandlerWithScope);a(this.player,"ended",this._stateHandlerWithScope);a(this.player,"error",this._stateHandlerWithScope);a(this.player,"durationchange",this._durationHandlerWithScope);a(this.player,"volumechange",this._volumeHandlerWithScope);a(this.player,"webkitendfullscreen",this._webkitHandlerWithScope);this.destroyPollingTask();this._stateHandlerWithScope=null;this._durationHandlerWithScope=null;this._volumeHandlerWithScope=null;this._webkitHandlerWithScope=null},pollingTaskFn:function(){this.positionHandler()}});Ext.define("SYNO.VideoController2.MessageBox",{extend:"SYNO.SDS.MessageBoxV5",constructor:function(){this.callParent(arguments);this.addClass("syno-vc-msgbox")},onRender:function(){this.callParent(arguments);this.progressBar.addClass("syno-vc-progress")},getButtons:function(){var a=this.callParent(arguments);a.each(function(b){b.addClass("syno-vc-button")});return a}});Ext.define("SYNO.VideoController2.Dialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(c){var a=Ext.isString(c.cls)?(c.cls+" syno-vc-dialog"):"syno-vc-dialog";c.cls=a;var b=Ext.apply({},c);b.listeners=b.listeners||{};Ext.apply(b.listeners,{show:this.onDialogShow.createDelegate(this),hide:this.onDialogHide.createDelegate(this),close:this.onDialogClose.createDelegate(this)});this.callParent([b])},onDialogShow:function(){if(Ext.isDefined(this.controller)){this.controller.spaceenabled=false}},onDialogHide:function(){if(Ext.isDefined(this.controller)){this.controller.spaceenabled=true}},onDialogClose:function(){if(Ext.isDefined(this.controller)){this.controller.spaceenabled=true}},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.VideoController2.MessageBox({owner:a})}return this.callParent(arguments)}});Ext.define("SYNO.VideoController2.ListDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.setDataFromStore(b.orgStore);this.pageSize=10;var a={padding:0,autoFlexcroll:true,cls:"syno-vs-sharing-list-dialog",title:_VCT("controller","share_playlist_title"),closable:true,maximized:SYNO.VideoController2.Util.isMobile(),minWidth:540,width:540,minHeight:586,height:586,useStatusBar:false,layout:"fit",closeAction:"hide",items:[this.getDataView()],bbar:this.getPagingToolbar(),listeners:{scope:this,beforerender:function(){this.orig_useShims=Ext.useShims;Ext.useShims=true},afterrender:function(){Ext.useShims=this.orig_useShims}}};this.callParent([Ext.apply(a,b)]);this.grid=this.getComponent("list_gridpanel");if(this.data.videos.length===0){this.grid.addClass("syno-vs-sharing-empty")}this.maskEl.on("click",function(){this.hide()},this);this.maskEl.addClass("syno-vs-sharing-mask")},getDataView:function(){var a={xtype:"syno_flexcroll_dataview",singleSelect:true,itemSelector:"div.vc-sharing-list-playicon",store:this.getStore(),tpl:this.getTpl(),listeners:{scope:this,click:function(b,c,f){var e=b.getStore().getAt(c).data;var d=e.unique_id;this.controller.jump(d);this.hide()}}};return a},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="vc-sharing-list-video">','<div class="{[this.getImgClass(values.type)]}" style="{[this.getBackground(values.type, values.video_id)]}"></div>','<div class="vc-sharing-list-info">','<div class="vc-sharing-list-title">{[this.getTitle(values)]}</div>','<div class="vc-sharing-list-filename">{[this.getFileName(values)]}</div>',"</div>",'<div class="vc-sharing-list-playicon" unique_id="{unique_id}"></div>',"</div>","</tpl>",{getImgClass:function(a){return a==="movie"?"vc-sharing-poster":"vc-sharing-screenshot"},getBackground:function(d,a){var f=SYNO.VideoController2.Util.getImageURL(a,d);var c="filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')";var e="background-image: url('{0}')";var b=String.format((Ext.isIE8||Ext.isIE7)?c:e,f);return b},getTitle:function(a){var f=a.original_data;var g=f.title;var b=Date.parseDate(f.time,"Y-m-d H:i:s");var d=f.type;if("movie"===d){return g+(!Ext.isEmpty(b)?" ("+b.getFullYear()+")":"")}else{if("tvshow_episode"===d){var e=this.getFormatNumber(f.season);var c=this.getFormatNumber(f.episode);return g+"("+f.tagline+" "+_VST("season_title")+" "+e+"-"+c+(!Ext.isEmpty(b)?" ("+b.getFullYear()+")":"")}else{return g+(!Ext.isEmpty(b)?" ("+f.time+")":"")}}},getFormatNumber:function(a){return a<10?"0"+a:a},getFileName:function(b){var c=b.original_data.additional.file[0].path;var a=c.substr(c.lastIndexOf("/")+1);return a}})},getPagingToolbar:function(){if(!Ext.isDefined(this.paging)){this.paging=new SYNO.ux.PagingToolbar({displayInfo:true,showRefreshBtn:false,store:this.getStore(),hidden:this.data.videos.length===0,pageSize:this.pageSize,cls:"syno-vc-pagingtoolbar"})}return this.paging},setDataFromStore:function(a){if(Ext.isEmpty(a)){this.data={offset:0,total:0,videos:[]};return}this.data={offset:a.getTotalCount(),total:a.getTotalCount(),videos:[]};a.data.each(function(b){this.data.videos.push(b.data)},this)},getStore:function(){if(this.gridStore){return this.gridStore}var a=new Ext.data.MemoryProxy([]);a.allData=this.data;a.on("beforeload",function(b,d){var c={offset:d.start,total:b.allData.total,videos:b.allData.videos.slice(d.start,d.start+d.limit)};b.data=c});this.gridStore=new Ext.data.JsonStore({data:{offset:this.pageSize,total:this.data.total,videos:this.data.videos.slice(0,this.pageSize)},proxy:a,root:"videos",idProperty:"unique_id",fields:["unique_id","type","video_id","original_data"],listeners:{scope:this,load:this.onAfterLoadStore}});return this.gridStore},onAfterLoadStore:function(){if(!Ext.isDefined(this.grid)){return}this.grid.view.updateScroller();var a=Ext.select(".syno-vs-sharing-playicon");a.elements.each(function(d){var c=d.getAttribute("unique_id");var b=Ext.fly(d);b.addClassOnOver("playicon-mouseover");b.addClassOnClick("playicon-click");b.on("click",function(){this.controller.jump(c);this.hide()},this)},this)},show:function(){this.playerState=this.controller.getPlayer().getState();if(this.playerState===SYNO.VideoController2.Util.STATE.PLAYING){this.controller.play()}this.callParent(arguments)},hide:function(){if(this.data.videos.length===0){return}if(this.playerState===SYNO.VideoController2.Util.STATE.PLAYING&&this.controller.getPlayer().getState()===SYNO.VideoController2.Util.STATE.PAUSED){this.controller.play()}this.callParent(arguments)}});Ext.define("SYNO.VideoController2.NullPlayer",{extend:"SYNO.VideoController2.Player",constructor:function(b){var a={name:"Null",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(){return false},isAvailable:function(){return true},play:function(){this.error=true;var b=!Ext.isMac&&!SYNO.VideoController2.Util.isVLCSupported();var a=SYNO.VideoController2.Util.isMobile();var c=_T("video_player","error_play");if(!a&&!Ext.isMac){c=b?_T("video_player","error_play_vlc"):_T("video_player","error_play_pc")}this.stateHandler(c)},getState:function(){return this.error?SYNO.VideoController2.Util.STATE.ERROR:SYNO.VideoController2.Util.STATE.STOPPED}});Ext.define("SYNO.VideoController2.PasswordDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.player_title=b.player_title;var a={dsmStyle:"v5",cls:"password-dialog",title:_VCT("controller","renderer_password_title"),width:460,height:180,padding:"8px 30px 8px 30px",items:[this.getFormPanel()],buttons:[{cls:"syno-vc-button",text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.applyHandler},{cls:"syno-vc-button",text:_T("common","cancel"),btnStyle:"grey",scope:this,handler:this.cancelHandler}],listeners:{scope:this,afterrender:this.focusInputField}};this.callParent([Ext.apply(a,b)])},getFormPanel:function(){if(this.form){return this.form}var a={cls:"password-form",items:[{xtype:"syno_displayfield",cls:"syno-vc-displayfield",value:String.format(_VCT("controller","renderer_password_desc"),this.player_title)},{xtype:"syno_textfield",cls:"syno-vc-base-textfield",textType:"password",fieldLabel:_VCT("common","password"),name:"password",maxlength:50}]};this.form=new SYNO.ux.FormPanel(a);return this.form},getPasswordField:function(){return this.getFormPanel().getForm().findField("password")},focusInputField:function(){this.getPasswordField().focus(false,300)},applyHandler:function(){var a=this.getPasswordField().getValue();if(Ext.isString(a)&&!Ext.isEmpty(a)){this.setPassword(a)}else{this.focusInputField()}},cancelHandler:function(){this.close()},setPassword:function(a){SYNO.API.Request({api:"SYNO.VideoStation2.Controller.Password",method:"set",version:1,params:{device_id:this.player_id,password:a},scope:this,callback:function(f,e,d,b){if(f){this.correctCallback.defer(1);this.close()}else{var c=(e.code&&e.code===2002)?_T("video_player","title"):this.title;this.getMsgBox().show({title:c,msg:SYNO.VideoController2.Util.getErrorString(e,"SYNO.VideoStation2.Controller.Password"),buttons:Ext.MessageBox.OK})}}})}});Ext.define("SYNO.VideoController2.PlayerStore",{extend:"SYNO.API.Store",PlayerRecord:Ext.data.Record.create([{name:"id",type:"string"},{name:"type",type:"string"},{name:"title",type:"string"},{name:"volume_adjustable",type:"boolean"},{name:"password_protected",type:"boolean"},{name:"seekable",type:"boolean"}]),constructor:function(b){var a={api:"SYNO.VideoStation2.Controller.Device",method:"list",version:1,baseParams:{limit:SYNO.VideoController2.Constant.UNLIMIT},reader:new Ext.data.JsonReader({root:"device"},this.PlayerRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.RemotePlayer",{extend:"SYNO.VideoController2.Player",PlaybackAPI:{api:"SYNO.VideoStation2.Controller.Playback",version:1},VolumeAPI:{api:"SYNO.VideoStation2.Controller.Volume",version:1},constructor:function(b){var a={name:"Remote",pluginInit:true,initPlaying:false,state:SYNO.VideoController2.Util.STATE.STOPPED,volume:50,volume_adjustable:true,seekable:true};this.callParent([Ext.apply(a,b)])},ableToPlayRaw:function(d,a){if(this.type!==SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY){return true}if(a.width>1920||a.height>1080){return false}if(!SYNO.VideoController2.Util.isMP4Container(d.container_type)){return false}var c=d.video_codec;if(c!=="mpeg4"&&c!=="h264"&&c!=="mjpeg"){return false}var b=d.audio_codec;if(b.indexOf("aac")===-1&&b.indexOf("ac3")===-1&&b.indexOf("mp3")===-1){return false}return true},ableToRemux:function(e,b){if(!this.controller.supportRemux()||this.type!==SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY){return false}if(b.width>1920||b.height>1080){return false}var a=e.container_type;var d=e.video_codec;var c=("h264"===d)&&(SYNO.VideoController2.Util.isMP4Container(a)||"matroska,webm"===a);return c},getState:function(){return this.state},getDuration:function(){return this.duration},getPosition:function(){return this.position},getMute:function(){return false},getVolume:function(){return this.volume},getClientID:function(){return this.client_id},generateClientID:function(){this.client_id=SYNO.Encryption.Base64.hex2b64(SYNO.VideoController2.Util.toHex(this.title))+new Date().format("U");return this.client_id},sendControllerAPI:function(b,f,d,e,c){var a=Ext.isBoolean(c)?!c:true;SYNO.API.Request({async:a,api:b,method:f,version:1,params:d,scope:this,callback:function(j,i,h,g){if(j){SYNO.VideoController2.Util.tryCallback(e)}else{this.controller.onAPIError.apply(this.controller,arguments)}}})},sendPlaybackAPI:function(d,b,c,a){this.sendControllerAPI("SYNO.VideoStation2.Controller.Playback",d,b,c,a)},sendVolumeAPI:function(d,b,c,a){this.sendControllerAPI("SYNO.VideoStation2.Controller.Volume",d,b,c,a)},play:function(){var a={device_id:this.id,file_id:this.file_id,client_id:this.generateClientID(),playback_target:"file_id"};if(Ext.isNumber(this.start_position)){a.position=this.start_position;this.start_position=null}a.subtitle={};if(!Ext.isEmpty(this.subtitle_id)){a.subtitle.id=this.subtitle_id}if(!Ext.isEmpty(this.subtitle_codepage)){a.subtitle.codepage=this.subtitle_codepage}if(!Ext.isEmpty(this.audio_id)){a.audio_track=this.audio_id}if(!Ext.isEmpty(this.profile)){a.profile=this.profile}this.state=SYNO.VideoController2.Util.STATE.BUFFERING;this.stateHandler();this.sendPlaybackAPI("play",a,this.startPolling.createDelegate(this))},pause:function(){this.sendPlaybackAPI("pause",{device_id:this.id},Ext.emptyFn)},resume:function(){this.pause()},stop:function(){if(this.task_runner){this.sendPlaybackAPI("stop",{device_id:this.id},Ext.emptyFn,true)}else{this.notifyClear()}},seek:function(a){if(!this.seekable){return}var b={device_id:this.id,position:parseInt(a.toFixed(0),10)};this.sendPlaybackAPI("seek",b,Ext.emptyFn)},setVolume:function(a){if(!this.volume_adjustable){return}var b={device_id:this.id,volume:a};this.sendVolumeAPI("set",b,Ext.emptyFn)},clear:function(){this.stopPolling();this.notifyClear()},StateMap:{STOPPED:SYNO.VideoController2.Util.STATE.STOPPED,PLAYING:SYNO.VideoController2.Util.STATE.PLAYING,PAUSED:SYNO.VideoController2.Util.STATE.PAUSED,TRANSITIONING:SYNO.VideoController2.Util.STATE.BUFFERING,ERROR:SYNO.VideoController2.Util.STATE.ERROR},updateStatus:function(d,c,b,a){if(!d){this.setStatusError();return}this.duration=c.duration;this.position=c.position;this.state=this.StateMap[c.state]||SYNO.VideoController2.Util.STATE.ERROR;if(this.client_id!==c.client_id){this.state=SYNO.VideoController2.Util.STATE.STOPPED}this.durationHandler(this.duration);this.positionHandler(this.position);if(this.state===SYNO.VideoController2.Util.STATE.ERROR){this.setStatusError()}else{this.stateHandler()}},setStatusError:function(){this.state=SYNO.VideoController2.Util.STATE.ERROR;this.stopPolling();this.stateHandler(_VCT("controller","error_state"))},updateVolume:function(d,c,b,a){this.volume=c.volume;this.volumeHandler()},startPolling:function(){this.stopPolling();this.task_runner=new SYNO.SDS.TaskRunner();this.polling_status=this.task_runner.createWebAPITask({id:"SYNOVideoControllerPollingStatus",interval:1000,api:"SYNO.VideoStation2.Controller.Playback",method:"status",version:1,params:{device_id:this.id},scope:this,callback:this.updateStatus});this.polling_status.start(true);if(this.volume_adjustable){this.polling_volume=this.task_runner.createWebAPITask({id:"SYNOVideoControllerPollingVolume",interval:1000,api:"SYNO.VideoStation2.Controller.Volume",method:"get",version:1,params:{device_id:this.id},scope:this,callback:this.updateVolume});this.polling_volume.start(true)}},stopPolling:function(){if(this.task_runner){this.task_runner.destroy();this.task_runner=null;this.polling_status=null;this.polling_volume=null}}});Ext.define("SYNO.VideoController2.TimeText",{extend:"Ext.Toolbar.TextItem",constructor:function(b){var a={text:"00:00"};this.callParent([Ext.apply(a,b)])},formatTime:function(c){c=parseInt(Math.round(c),10);var a=parseInt(c/3600,10);var d=parseInt((c%3600)/60,10);var b=c%60;return((a>0)?a+":":"")+String.leftPad(d,2,"0")+":"+String.leftPad(b,2,"0")},updateView:function(a){if(!Ext.isNumber(a)||0>=a){this.setText("00:00")}else{this.setText(this.formatTime(a))}}});Ext.define("SYNO.SDS.VideoController2.Radio",{extend:"SYNO.ux.Radio",xtype:"syno_vc_radio",checkIconCls:"syno-vc-radio syno-ux-radio-icon",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoController2.RadioGroup",{extend:"SYNO.ux.RadioGroup",xtype:"syno_vc_radiogroup",defaultType:"syno_vc_radio",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.VideoController2.Button",{extend:"SYNO.ux.Button",constructor:function(b){var a={cls:"vc-button",handler:this.clickHandler};this.callParent([Ext.apply(a,b)])},getController:function(){return this.module.getController()},clickHandler:Ext.emptyFn});Ext.define("SYNO.VideoController2.MenuButton",{extend:"SYNO.VideoController2.Button",constructor:function(b){var a={menu:this.createMenu(),menuAlign:"br-tr"};this.callParent([Ext.apply(a,b)])},createMenu:Ext.emptyFn,getMenuClass:function(){return""}});Ext.define("SYNO.VideoController2.Menu",{extend:"Ext.menu.Menu",constructor:function(b){var a={cls:"syno-vc-menu",listeners:{scope:this,beforerender:function(){this.orig_useShims=Ext.useShims;Ext.useShims=true},afterrender:function(){Ext.useShims=this.orig_useShims;this.keyNav.disable()},show:Ext.isFunction(b.onShow)?b.onShow:Ext.emptyFn}};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.Slider",{extend:"Ext.slider.SingleSlider",constructor:function(b){var a={animate:false,increment:1,value:0,listeners:{scope:this,change:this.onChange,changecomplete:this.onChangeComplete,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.addClass("vc-slider")},onChange:Ext.emptyFn,onChangeComplete:Ext.emptyFn,onAfterRender:Ext.emptyFn,isDragging:function(){if(this.isDestroyed){return true}return this.thumbs[0].dragging}});Ext.define("SYNO.VideoController2.ItemMenu",{extend:"SYNO.VideoController2.Menu",constructor:function(b){var a={defaultOffsets:[0,-11]};this.callParent([Ext.apply(a,b)]);this.addClass("item-menu")},addItemGeneral:function(g,f,a,d,b){var e=Ext.util.Format.ellipsis(f,40,false);var c=new Ext.menu.Item({item_id:g,text:e,cls:a,group:d||"",scope:this,handler:b,listeners:{render:function(){this.getEl().dom.qtip=Ext.util.Format.htmlEncode(f)}}});this.addItem(c)},addTitle:function(b,a){if(!Ext.isString(b)){return}this.addItemGeneral(Ext.id(),b,"title",a,Ext.emptyFn)},addOneItem:function(f,e,a,c,d){if(!Ext.isDefined(f)||!Ext.isString(e)||!Ext.isFunction(a)){return}var b=function(){this.setItemSelected(f,d);a()};this.addItemGeneral(f,e,((true===c)?"selected":""),d,b)},setItemSelected:function(b,a){if(!this.items||!Ext.isDefined(b)){return}this.items.each(function(c){var d=Ext.get(c.getId());if(!Ext.isDefined(a)||c.group===a){d.removeClass("selected");d[(c.item_id===b)?"addClass":"removeClass"]("selected")}})},removeGroup:function(a){if(!Ext.isObject(this.items)){return}this.items.each(function(b){if(b.group===a){this.remove(b)}},this)}});Ext.define("SYNO.VideoController2.MenuDataView",{extend:"SYNO.ux.FleXcroll.DataView",constructor:function(b){var a={singleSelect:true,itemSelector:"div.item",selectedClass:"x-view-selected",overClass:"x-view-over",store:this.getStore(),tpl:this.getTpl(),listeners:{scope:this,beforeclick:function(d,f,g,h){var c=d.getRecord(g);if(c.get("disabled")){return false}if(c.get("able_to_be_selected")===false){c.get("handler")();return false}},click:function(d,f,g,h){var c=d.getRecord(g);c.get("handler")()},selectionchange:function(c,e,d){if(e.length===0){this.setItemSelected(this.getSelectedItem().id)}},afterrender:function(){this.setItemSelected(this.default_id)}}};this.callParent([Ext.apply(a,b)])},getStore:function(){if(!Ext.isDefined(this.store)){this.store=new Ext.data.JsonStore({fields:["id","title","handler","able_to_be_selected","disabled","visible"]})}return this.store},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="item sds-ellipsis {[this.getDisabledClass(values.disabled)]} {[this.getHiddenClass(values.visible)]}" ext:qtip="{[this.doubleEncode(values.title)]}">','<span class="menu-tick">&nbsp;</span>',"{title:htmlEncode}","</div>","</tpl>",{doubleEncode:function(a){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a))},getDisabledClass:function(a){return a?"x-item-disabled":""},getHiddenClass:function(a){return a===true?"":"x-hide-display"}})},getSelectedItem:function(){return this.selected_item},setItemSelected:function(b){var a=this.store.getAt(0);this.store.each(function(c){if(c.id===b){a=c;return false}});this.select(a);this.selected_item=a;return a},setInitItem:function(b){this.default_id=b;var a=this.setItemSelected(b);a.data.handler()}});Ext.define("SYNO.VideoController2.MenuPanel",{extend:"SYNO.ux.Panel",constructor:function(b){this.module=b.module;this.list=[];var a={header:true,autoFlexcroll:true,layout:"fit",items:[this.getDataview()]};this.callParent([Ext.apply(a,b)])},getDataview:function(){if(!Ext.isDefined(this.dataview)){this.dataview=new SYNO.VideoController2.MenuDataView()}return this.dataview},getListLength:function(){return this.list.length},setDefault:function(a){this.getDataview().default_id=a},setItemSelected:function(a){this.getDataview().setItemSelected(a)},setInitItem:function(a){this.getDataview().setInitItem(a)},setItemVisible:function(d,c){for(var a=0,b=this.list.length;a<b;a++){if(this.list[a].id===d){this.list[a].visible=c}}this.loadItems()},addItem:function(e,c,b,d,a){this.list.push({id:e,title:c,handler:b,able_to_be_selected:d,disabled:(a||false),visible:true})},loadItems:function(){if(this.isDestroyed){return}this.getDataview().store.loadData(this.list)},removeItems:function(){if(this.isDestroyed){return}this.list=[];this.getDataview().store.removeAll()}});Ext.define("SYNO.VideoController2.ResizeSubtitleDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){var a={title:_VCT("controller","resize_subtitle"),cls:"resize-subtitle-dialog",layout:"fit",width:"290px",height:"250px",items:this.getRadioGroup(),buttons:[{cls:"syno-vc-button",text:_T("common","ok"),btnStyle:"blue",itemId:"ok",scope:this,handler:this.closeHandler},{cls:"syno-vc-button",text:_T("common","cancel"),btnStyle:"grey",itemId:"cancel",scope:this,handler:this.cancelHandler}]};this.callParent([Ext.apply(a,b)])},getRadioGroup:function(){this.radio_group=this.radio_group||new SYNO.SDS.VideoController2.RadioGroup({items:[{boxLabel:_VCT("controller","subtitle_extra_large"),inputValue:"extra-large",name:"size"},{boxLabel:_VCT("controller","subtitle_large"),inputValue:"large",name:"size"},{boxLabel:_VCT("controller","subtitle_medium"),inputValue:"medium",name:"size"},{boxLabel:_VCT("controller","subtitle_small"),inputValue:"small",name:"size"},{boxLabel:_VCT("controller","subtitle_extra_small"),inputValue:"extra-small",name:"size"}],listeners:{change:this.changeHandler.createDelegate(this),afterrender:this.selectedHandler.createDelegate(this)}});return this.radio_group},closeHandler:function(){this.close()},changeHandler:function(b,a){this.controller.setSubtitleSize(a.getInputValue())},cancelHandler:function(){this.controller.setSubtitleSize(this.current_size);this.close()},selectedHandler:function(a){this.current_size=this.controller.getSubtitleSize();a.setValue(this.current_size)}});Ext.define("SYNO.VideoController2.SubtitleDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.unique_key=b.unique_key;var a={cls:"search-subtitle-dialog",title:_VCT("controller","search_subtitle"),width:720,height:380,layout:"fit",items:[this.getGridPanel()],buttons:[{cls:"syno-vc-button",text:_T("common","ok"),btnStyle:"blue",disabled:true,itemId:"ok",scope:this,handler:this.applyHandler},{cls:"syno-vc-button",text:_T("common","cancel"),btnStyle:"grey",itemId:"cancel",scope:this,handler:this.cancelHandler}]};this.callParent([Ext.apply(a,b)])},getGridPanel:function(){var a={cls:"syno-vc-gridpanel",xtype:"syno_gridpanel",itemId:"grid",stripeRows:true,loadMask:{msg:_VCT("search","searching")},viewConfig:{autoFill:true,forceFit:true,emptyText:_T("search","no_search_result")},selModel:this.getSelectionModel(),colModel:new Ext.grid.ColumnModel({columns:[this.getSelectionModel(),{header:_VCT("language","title"),dataIndex:"language",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}},{header:_VCT("file","file_name"),dataIndex:"filename",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}},{header:_VCT("video_info","source"),dataIndex:"plugin_title",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}}]}),enableHdMenu:false,enableColumnMove:false,listeners:{scope:this,rowdblclick:function(){this.downloadSubtitle()}},store:this.getStore()};return a},getStore:function(){if(this.gridStore){return this.gridStore}var a=SYNO.VideoController2.Util.getIDorPathParam(this.unique_key);this.gridStore=new SYNO.API.JsonStore({api:"SYNO.VideoStation2.Subtitle",method:"search",version:1,appWindow:false,autoLoad:true,baseParams:a,root:"subtitle",fields:["id","language","language_id","plugin_id","plugin_title","filename","downloaded","subtitle_id"]});return this.gridStore},getSelectionModel:function(){this.selection_model=this.selection_model||new Ext.grid.CheckboxSelectionModel({width:34,checkOnly:true,listeners:{scope:this,selectionchange:function(){this.setOkDisabled(!this.isGridHasSelection())}}});return this.selection_model},isGridHasSelection:function(){return this.getComponent("grid").getSelectionModel().hasSelection()},setOkDisabled:function(a){this.getFooterToolbar().getComponent("ok").setDisabled(a)},getRecordSelections:function(){return this.getComponent("grid").getSelectionModel().getSelections()},downloadSubtitle:function(){this.setStatusBusy();this.downloadSubtitleByRecords(this.getRecordSelections())},downloadSubtitleByRecords:function(a){var c,b;if(a.length===0){return}c=a.shift();if(c.get("downloaded")){if(a.length===0){this.setDownloadedSubtitle(c.get("subtitle_id"));this.clearStatusBusy();return}this.downloadSubtitleByRecords(a);return}b=SYNO.VideoController2.Util.getIDorPathParam(this.unique_key);b.plugin_id=c.get("plugin_id");b.download_id=c.get("id");SYNO.API.Request({recs:a,api:"SYNO.VideoStation2.Subtitle",method:"download",version:1,params:b,scope:this,callback:this.downloadSubtitleCallback})},downloadSubtitleCallback:function(e,d,c,a){var b=a.recs;if(e&&d){if(Ext.isString(d.id)){if(b.length===0){this.setDownloadedSubtitle(d.id);this.clearStatusBusy();return}this.downloadSubtitleByRecords(b);return}}this.clearStatusBusy();this.getMsgBox().alert(this.title,_VCT("controller","download_subtitle_fail"))},setDownloadedSubtitle:function(a,b){this.findAppWindow().getController().setDownloadedSubtitle(a,b);this.close()},applyHandler:function(){this.downloadSubtitle()},cancelHandler:function(){this.findAppWindow().getController().setDownloadedSubtitle();this.close()}});Ext.define("SYNO.VideoController2.SubtitleManager",{extend:"Ext.Component",constructor:function(b){this.addEvents({subtitleready:true,discoverready:true});var a=Ext.apply({subtitle:{}},b);Ext.apply(this,a);this.callParent([a])},isSubtitleReady:function(a,b,c){return Ext.isDefined(this.subtitle[a])&&Ext.isDefined(this.subtitle[a][b])&&Ext.isString(this.subtitle[a][b][c])},getSubtitle:function(a,b,c){if(this.isSubtitleReady(a,b,c)){return this.subtitle[a][b][c]}return""},putSubtitle:function(a,b,c,d){if(!Ext.isDefined(this.subtitle[a])){this.subtitle[a]={}}if(!Ext.isDefined(this.subtitle[a][b])){this.subtitle[a][b]={}}this.subtitle[a][b][d]=c},requestSubtitle:function(a,c,b,d){if(this.isSubtitleReady(a,c,d)){this.fireEvent("subtitleready",a,c,d);return}if(b){this.sendRequest(a,c,true,d)}this.sendRequest(a,c,false,d)},sendRequest:function(c,d,a,f){var e=SYNO.VideoController2.Util.getIDorPathParam(c);Ext.apply(e,{subtitle_codepage:f,preview:a,keep_srt_tag:true,remove_special_char:false});Ext.apply(e,SYNO.VideoController2.SharingHelper.getAPI("Subtitle"));Ext.apply(e,SYNO.VideoController2.SharingHelper.getSubtitleParam(d));var b={requestTimeout:360,url:SYNO.VideoController2.SharingHelper.getCGIPath("subtitle"),method:"POST",single:true,params:e,scope:this,success:function(g,i){try{Ext.decode(g.responseText)}catch(j){var h=g.responseText;this.putSubtitle(c,d,h,f);this.fireEvent("subtitleready",c,d,f)}}};SYNO.VideoController2.Util.applySharingID(b.params);this.addAjaxTask(b).start(true)},getDiscoverRequest:function(a){if(SYNO.VideoController2.Util.isPublicSharing()){return}SYNO.API.Request({api:"SYNO.VideoStation2.Subtitle",method:"discover",version:1,params:{id:a,keep_srt_tag:true,remove_special_char:false},scope:this,callback:function(g,c,f,e){var b=(c.status===200);if(b){var d=c.responseText;this.putSubtitle(a,SYNO.VideoController2.Util.SUBTITLE_DISCOVER,d,"auto")}this.fireEvent("discoverready",b)}})}});Ext.define("SYNO.VideoController2.SubtitleParser",{extend:"Ext.util.Observable",subtitles:null,destroy:function(){delete this.subtitles},parseSeconds:function(d){if(!d){return}var a=0;var c=d.split(":");if(c.length>3){return}for(var b=0;b<c.length;++b){a=a*60+parseFloat(c[b].replace(",","."))}return a},parseSrt:function(f){var d=f.replace(/\r\n|\r/g,"\n").trim();var e=d.split("\n\n");this.clear();for(var b=0;b<e.length;++b){var c=e[b].split("\n");if(c.length<3){continue}c.shift();var a=c.shift().split(" --> ");this.subtitles.push({from:this.parseSeconds(a[0]),to:this.parseSeconds(a[1]),text:c.join("<br/>")})}this.subtitles.sort(function(h,g){return(h.from<g.from?-1:1)})},clear:function(){this.subtitles=[]},getText:function(c){var e=this.subtitles;var d=[];if(!e){return""}for(var a=0;a<e.length;++a){var b=e[a];if(c<b.from){break}if(b.from<=c&&c<=b.to){d.push(b.text)}}return d.join("<br/>")}});Ext.define("SYNO.VideoController2.SyncDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.controller=b.controller;this.sync_time_field=new SYNO.ux.NumberField({cls:"syno-vc-base-textfield",layout:"fix",fieldLabel:"Shift Time",allowNegative:true,allowDecimals:true,decimalPrecision:3,scope:this,listeners:{scope:this,change:this.shiftValueHandler,keyup:this.shiftValueHandler},value:this.controller.getDelayedTime()});this.sync_time_unit={cls:"sync-time-unit",xtype:"label",html:"S"};this.shift_right_button=new SYNO.ux.Button({cls:"syno-vc-button icon-add",scope:this,handler:this.shiftRightHandler});this.shift_left_button=new SYNO.ux.Button({cls:"syno-vc-button icon-delete",scope:this,handler:this.shiftLeftHandler});this.reset_button=new SYNO.ux.Button({cls:"syno-vc-button icon-undo",scope:this,handler:this.resetHandler});this.panel=new SYNO.ux.Panel({border:false,frame:false,layout:{type:"table",columns:5},scope:this,items:[this.sync_time_field,this.sync_time_unit,this.shift_right_button,this.shift_left_button,this.reset_button]});var a={cls:"sync-subtitle-dialog",title:_VCT("controller","shift_subtitle"),layout:"fit",width:"350px",height:"142px",resizable:false,offset:0.25,items:[this.panel],buttons:[{cls:"syno-vc-button",text:_T("common","ok"),btnStyle:"blue",itemId:"ok",scope:this,handler:this.applyHandler}]};this.callParent([Ext.apply(a,b)])},shiftLeftHandler:function(){var a=this.controller.getDelayedTime()-this.offset;this.controller.setDelayedTime(a);this.sync_time_field.setValue(a)},shiftRightHandler:function(){var a=this.controller.getDelayedTime()+this.offset;this.controller.setDelayedTime(a);this.sync_time_field.setValue(a)},shiftValueHandler:function(){var a=this.sync_time_field.getValue();this.controller.setDelayedTime(a)},resetHandler:function(){this.controller.setDelayedTime(0);this.sync_time_field.setValue(0)},applyHandler:function(){var a=this.controller.video_list.getSubtitleList();var b=this.controller.getUsingSubtitle(a);this.controller.setSubtitle(b.subtitle_id);this.close()}});Ext.define("SYNO.VideoController2.VLCPlayer",{extend:"SYNO.VideoController2.Player",constructor:function(b){var a={name:"VLC",player_id:"_vlc_video_player",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(a){return("ogg"!==a)&&("ogv"!==a)},isAvailable:function(){return SYNO.VideoController2.Util.isVLCSupported()},fullscreen:function(){if(this.pluginInit){SYNO.VideoController2.Util.setDomFullscreen(this.controller.container.dom)}},clear:function(){this.unregisterEventHandler();this.callParent(arguments)},play:function(a){this.url=a;if(!this.createPlayer()){this.onVLCReady()}},pause:function(){if(this.pluginInit){this.player.playlist.pause()}},resume:function(){if(this.pluginInit){this.player.playlist.play()}},stop:function(){var a=this.getState();if(this.pluginInit){if(a===SYNO.VideoController2.Util.STATE.PLAYING||a===SYNO.VideoController2.Util.STATE.PAUSED){this.player.playlist.stop()}else{this.stop.defer(100,this,arguments)}}},seek:function(a){var b=a*1000;if(this.pluginInit&&b>=0&&b<=this.player.input.length){this.player.input.time=b}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.input.time/1000},getDuration:function(){if(!this.pluginInit){return -1}return this.player.input.length/1000},getVolume:function(){if(!this.pluginInit){return -1}return this.player.audio.volume},setVolume:function(a){if(this.pluginInit){this.player.audio.volume=a;this.volumeHandler()}},getMute:function(){var a=false;if(this.pluginInit){a=this.player.audio.mute}return a},setMute:function(a){if(this.pluginInit){this.player.audio.mute=a;this.volumeHandler()}},StateMap:{0:SYNO.VideoController2.Util.STATE.NO_MEDIA,1:SYNO.VideoController2.Util.STATE.BUFFERING,2:SYNO.VideoController2.Util.STATE.BUFFERING,3:SYNO.VideoController2.Util.STATE.PLAYING,4:SYNO.VideoController2.Util.STATE.PAUSED,5:SYNO.VideoController2.Util.STATE.STOPPED,6:SYNO.VideoController2.Util.STATE.STOPPED,7:SYNO.VideoController2.Util.STATE.ERROR},getPlayerState:function(){var a=1;try{a=this.player.input.state}catch(b){}if(a===7){this.error=true}return a},getState:function(){if(!this.pluginInit){return SYNO.VideoController2.Util.STATE.NO_MEDIA}if(this.error){return SYNO.VideoController2.Util.STATE.ERROR}var a=this.StateMap[this.getPlayerState()]||SYNO.VideoController2.Util.STATE.ERROR;return a},disablePlayerSubtitle:function(){if(this.pluginInit&&this.subtitle_is_srt===true){var c=this.player.VersionInfo.match(/\d+/g);var a=parseInt(c[0],10);var b=parseInt(c[1],10);if(a<2||(a==2&&b<2)){this.player.subtitle.track=-1}else{if(this.player.subtitle.count>0){this.player.subtitle.track=0}}}},setPlayerSubtitle:function(a){if(this.pluginInit&&this.subtitle_is_srt!==true){this.player.subtitle.track=a}},createPlayer:function(){if(this.player){return false}this.el=SYNO.VideoController2.Util.createVLCElement(this.controller.video,this.player_id);this.player=this.el.dom;this.registerEventHandler();this.el.enableDisplayMode();this.el.show();this.pluginInit=true;this.onVLCReady();return true},onVLCReady:function(){if(!this.player){return}if(!this.player.VersionInfo){this.onVLCReady.defer(100,this);return}this.fitPlayer.defer(100,this);this.fitPlayer.defer(500,this);if(Ext.isString(this.url)){if(this.player.playlist.items&&this.player.playlist.items.count>0){this.player.playlist.items.clear()}this.playlistItemId=this.player.playlist.add(this.url);this.player.playlist.playItem(this.playlistItemId)}if(Ext.isIE){this.adjustPlayerWidthHack()}return},fitPlayer:function(){if(this.el){this.el.setSize("100%","100%")}},adjustPlayerWidthHack:function(){if(this.el){this.el.setWidth(this.el.getWidth()+1);this.el.setWidth(this.el.getWidth()-1)}},durationHandler:function(b){var a=Ext.isNumber(b)?(b/1000):null;this.callParent([a])},positionHandler:function(a){this.callParent([a/1000])},stateHandler:function(){if(!this.volume_inited){this.setVolume.defer(1000,this,[this.controller.volume]);this.volume_inited=true}this.durationHandler();this.callParent(arguments)},needUsePollingTask:function(){return(Ext.isIE11||(Ext.isMac&&Ext.isSafari))},registerEventHandler:function(){this.volume_inited=false;this[this.needUsePollingTask()?"createPollingTask":"registerDomEventHandler"]()},registerDomEventHandler:function(){this._stateHandlerWithScope=this.stateHandler.createDelegate(this);this._durationHandlerWithScope=this.durationHandler.createDelegate(this);this._positionHandlerWithScope=this.positionHandler.createDelegate(this);var a=SYNO.VideoController2.Util.addDomListener(true);a(this.player,"MediaPlayerOpening",this._stateHandlerWithScope);a(this.player,"MediaPlayerPlaying",this._stateHandlerWithScope);a(this.player,"MediaPlayerPaused",this._stateHandlerWithScope);a(this.player,"MediaPlayerStopped",this._stateHandlerWithScope);a(this.player,"MediaPlayerEndReached",this._stateHandlerWithScope);a(this.player,"MediaPlayerEncounteredError",this._stateHandlerWithScope);a(this.player,"MediaPlayerTimeChanged",this._positionHandlerWithScope);a(this.player,"MediaPlayerLengthChanged",this._durationHandlerWithScope)},unregisterEventHandler:function(){this[this.needUsePollingTask()?"destroyPollingTask":"unregisterDomEventHandler"]()},unregisterDomEventHandler:function(){var a=SYNO.VideoController2.Util.removeDomListener(true);a(this.player,"MediaPlayerOpening",this._stateHandlerWithScope);a(this.player,"MediaPlayerPlaying",this._stateHandlerWithScope);a(this.player,"MediaPlayerPaused",this._stateHandlerWithScope);a(this.player,"MediaPlayerStopped",this._stateHandlerWithScope);a(this.player,"MediaPlayerEndReached",this._stateHandlerWithScope);a(this.player,"MediaPlayerEncounteredError",this._stateHandlerWithScope);a(this.player,"MediaPlayerTimeChanged",this._positionHandlerWithScope);a(this.player,"MediaPlayerLengthChanged",this._durationHandlerWithScope);this._stateHandlerWithScope=null;this._positionHandlerWithScope=null;this._durationHandlerWithScope=null},pollingTaskFn:function(){this.stateHandler();this.positionHandler();this.durationHandler()}});Ext.define("SYNO.VideoController2.AudioTrackStore",{extend:"SYNO.API.Store",AudioTrackRecord:Ext.data.Record.create([{name:"id",type:"int"},{name:"track",type:"int"},{name:"codec",type:"string"},{name:"language",type:"string"}]),constructor:function(b){var a={reader:new Ext.data.JsonReader({root:SYNO.VideoController2.SharingHelper.getAPIRoot("AudioTrack")},this.AudioTrackRecord)};Ext.apply(a,SYNO.VideoController2.SharingHelper.getAPI("AudioTrack"));this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.SubtitleStore",{extend:"SYNO.API.Store",SubtitleRecord:Ext.data.Record.create([{name:"subtitle_id",type:"string",mapping:"id"},{name:"lang",type:"string"},{name:"title",type:"string"},{name:"format",type:"string"},{name:"embedded",type:"boolean"},{name:"need_preview",type:"boolean"}]),constructor:function(b){var a={baseParams:{image_based:true},reader:new Ext.data.JsonReader({root:SYNO.VideoController2.SharingHelper.getAPIRoot("SubtitleList")},this.SubtitleRecord)};Ext.apply(a,SYNO.VideoController2.SharingHelper.getAPI("SubtitleList"));this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.VideoFile",{extend:"Ext.Component",constructor:function(b){var a={video_info_fetched:false,video_id:null,type:null,seasion:null,episode:null,file_id:null,title:null,name:null,duration:null,resolution:null,rotation:0,codec_info:null,position:0,last_watched_position:0,audio_track_fetched:false,audio_store:null,audio_track:[],subtitle_fetched:false,subtitle_store:null,subtitle_list:[],path:null,symlink:null};this.callParent([Ext.apply(a,b)])},onLoad:Ext.emptyFn,isAllFetched:function(){return this.audio_track_fetched&&this.video_info_fetched&&this.subtitle_fetched},getInfo:function(a){if(!this.isAllFetched()){this.getInfoSequence(a)}else{SYNO.VideoController2.Util.tryCallback(a)}},getInfoSequence:function(a){if(!this.video_info_fetched){this.getVideoInfo(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.audio_track_fetched){this.getAudioTrack(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.subtitle_fetched){this.getSubtitleList(this.getInfoSequence.createDelegate(this,[a]));return}SYNO.VideoController2.Util.tryCallback(a)},getVideoInfo:function(d){var b=SYNO.VideoController2.SharingHelper.getVideoAPI(this.type);if(!Ext.isDefined(b)){SYNO.VideoController2.Util.tryCallback(d);return}var c={};if(this.type==="filevideo"){c=this.getFileParams()}else{c=SYNO.VideoController2.SharingHelper.getVideoParams(this.video_id)}var a={params:c,scope:this,callback:function(i,h,g,f){this.video_info_fetched=true;if(i){this.fillVideoInfo(h,f);SYNO.VideoController2.Util.tryCallback(d)}else{var e=this.list.appWin.getController();e.onAPIError.apply(e,arguments)}}};Ext.apply(a,b);SYNO.VideoController2.Util.applySharingID(a.params);SYNO.API.Request(a)},fillVideoInfo:function(c,l){var i=c[SYNO.VideoController2.SharingHelper.getVideoAPIRoot(this.type)][0];var b=i.additional;var g=b.file;if(Ext.isNumber(this.file_id)){var e=this.file_id;g=g.filter(function(m){return(e==m.id)})}else{var d=this.parseDuration;g.sort(function(n,m){return(d(m.duration)-d(n.duration))})}var a=g[0];var k=a.path;var j=a.sharepath;var h={};var f=k.substring(k.lastIndexOf("/")+1);Ext.copyTo(h,a,["container_type","audio_codec","video_codec"]);Ext.apply(this,{mapper_id:this.getMapperId(i),name:this.getName(i)||f,date:this.getDate(i),title:f,file_id:parseInt(a.id,10),resolution:{width:a.resolutionx,height:a.resolutiony},display_resolution:{width:a.display_x,height:a.display_y},rotation:a.rotation,duration:this.parseDuration(a.duration),codec_info:h,path:k,sharepath:j});if(this.type==="filevideo"||SYNO.VideoController2.Util.isVideoControllerOnly()){return}Ext.apply(this,{position:a.position,watched_ratio:a.watched_ratio})},getName:function(e){if(this.type!=="tvshow_episode"){return e.title}var d=e.season<10?"0"+e.season:e.season;var c=e.episode<10?"0"+e.episode:e.episode;var b=!Ext.isEmpty(e.tagline)?", "+e.tagline:"";var a=String.format("{0} - S{1}E{2}{3}",e.title,d,c,b);return a},getDate:function(a){if(this.type==="movie"||this.type==="tvshow_episode"){return a.original_available}if(this.type==="home_video"||this.type==="tv_record"){return a.record_date}return""},getMapperId:function(b){var a=(this.type==="tvshow_episode")?b.tvshow_mapper_id:b.mapper_id;return a},getResumePosition:function(c){var b=parseInt(Math.max(0,(Ext.isNumber(this.position)?this.position-2:0)),10);if(c===true){return b}var a=SYNO.VideoController2.Util.roundPercentage(this.watched_ratio);if(!Ext.isNumber(this.watched_ratio)||a===0||a===100){return null}return b},updateWatchedPosition:function(a){if(!Ext.isNumber(a)||a<this.last_watched_position+10){return}this.last_watched_position=a;this.setWatchStatus(a,Ext.emptyFn,false)},setWatched:function(a){this.setWatchStatus(this.duration,a,false)},setWatchStatus:function(a,e,d){if(SYNO.VideoController2.Util.isVideoControllerOnly()){SYNO.VideoController2.Util.tryCallback(e);return}if(!Ext.isNumber(this.file_id)||!Ext.isNumber(a)||a<=0){SYNO.VideoController2.Util.tryCallback(e);return}var c=Ext.isBoolean(d)?!d:true;var b=c?e:Ext.emptyFn;this.position=a;if(this.position>=0&&this.duration>0){this.watched_ratio=(this.position/this.duration);this.watched_ratio=(this.watched_ratio<=0.02)?0:this.watched_ratio;this.watched_ratio=(this.watched_ratio>=0.98)?1:this.watched_ratio}SYNO.API.Request({async:c,api:"SYNO.VideoStation2.File",method:"set_watchstatus",version:1,params:{id:this.file_id,position:Math.floor(a)},scope:this,callback:b});if(!c){SYNO.VideoController2.Util.tryCallback(e)}},deleteSymLink:function(){if(Ext.isEmpty(this.path)){return}SYNO.API.Request({async:false,api:"SYNO.VideoStation2.File",method:"delete_symlink",version:1,params:{path:this.path,symlink:this.symlink},scope:this,callback:Ext.emptyFn})},getUniqueKey:function(){if(this.type==="filevideo"){return this.path}else{return this.file_id}},getFileParams:function(){var a={};if(this.type==="filevideo"){if(Ext.isString(this.symlink)){a={path:this.path,symlink:this.symlink}}else{a={path:this.path}}}else{a={id:this.file_id}}return a},getAudioTrack:function(c){if(this.audio_track_fetched){SYNO.VideoController2.Util.tryCallback(c);return}this.audio_store=new SYNO.VideoController2.AudioTrackStore({appWindow:this.list.appWin});this.addManagedComponent(this.audio_store);var b=this.getFileParams();var a={scope:this,callback:function(){this.audio_track_fetched=true;this.audio_store.data.each(function(d){this.audio_track.push(d.data)},this);SYNO.VideoController2.Util.tryCallback(c)},params:b};SYNO.VideoController2.Util.applySharingID(a.params);this.audio_store.load(a)},getSubtitleList:function(a){if(this.subtitle_fetched){SYNO.VideoController2.Util.tryCallback(a);return}this.subtitle_store=new SYNO.VideoController2.SubtitleStore({appWindow:this.list.appWin});this.addManagedComponent(this.subtitle_store);this.loadSubtitleStore(a)},loadSubtitleStore:function(c){var b=this.getFileParams();var a={scope:this,callback:function(){this.subtitle_fetched=true;this.subtitle_list=[];this.subtitle_store.data.each(function(d){this.subtitle_list.push(d.data)},this);SYNO.VideoController2.Util.tryCallback(c)},params:b};SYNO.VideoController2.Util.applySharingID(a.params);this.subtitle_store.load(a)},parseDuration:function(d){if(!Ext.isDefined(d)){return 0}if(Ext.isNumber(d)){return d}var c=0;var b=d.split(":");for(var a=0;a<b.length;++a){c=c*60+parseFloat(b[a])}return c}});Ext.define("SYNO.VideoController2.VideoStore",{extend:"SYNO.API.Store",CollectionRecord:Ext.data.Record.create([{name:"video_id",type:"int",mapping:"id"},{name:"type",type:"string"},{name:"original_data",type:"object",convert:function(b,a){return a}},{name:"unique_id",type:"string",convert:function(b,a){return String.format("{0}-{1}",a.type,a.id)}}]),TvshowRecord:Ext.data.Record.create([{name:"episode",type:"int"},{name:"season",type:"int"},{name:"video_id",type:"int",mapping:"id"},{name:"type",type:"string",defaultValue:"tvshow_episode"},{name:"unique_id",type:"string",convert:function(b,a){return String.format("{0}-{1}",a.type,a.id)}}]),constructor:function(c){var a=(c.is_collection)?this.CollectionRecord:this.TvshowRecord;var b={reader:new Ext.data.JsonReader({root:c.reader_root,idProperty:"unique_id"},a)};this.callParent([Ext.apply(b,c)])}});Ext.define("SYNO.VideoController2.VideoList",{extend:"Ext.Component",constructor:function(b){var a={loaded:false,browse_type:null,sharing_id:null,type_id:null,store:null,video_list:[],current_index:-1};this.callParent([Ext.apply(a,b)])},NullVideoFile:new SYNO.VideoController2.VideoFile(),isCollection:function(){return("collection"===this.browse_type)},isTVShow:function(){return("tvshow_episode"===this.browse_type||"tvshow"===this.browse_type)},isSingleVideo:function(){return((!Ext.isNumber(this.type_id)&&!Ext.isString(this.sharing_id))||(!this.isCollection()&&!this.isTVShow()))},getStore:function(){if(this.store){return this.store}var a;if(this.isCollection()){a={is_collection:true};Ext.apply(a,SYNO.VideoController2.SharingHelper.getAPI("CollectionListVideo"));Ext.apply(a,{reader_root:SYNO.VideoController2.SharingHelper.getAPIRoot("CollectionListVideo")});Ext.apply(a,{baseParams:SYNO.VideoController2.SharingHelper.getCollectionListVideoParam(this.sort_info,this.type_id)})}else{a={is_collection:false,reader_root:"episodes",api:"SYNO.VideoStation.TVShowEpisode",method:"list",version:1,baseParams:{tvshow:this.type_id}}}this.store=new SYNO.VideoController2.VideoStore(Ext.apply(a,{appWindow:this.appWin}));this.addManagedComponent(this.store);return this.store},initSingleVideo:function(a,b){this.video_list.push(new SYNO.VideoController2.VideoFile(Ext.apply({list:this},a)));this.current_index=0;this.loaded=true;SYNO.VideoController2.Util.tryCallback(b)},init:function(a,b){if(this.isSingleVideo()){this.initSingleVideo(a,b);return}this.getStore().load({callback:this.onVideoListLoad.createDelegate(this,[a,b]),scope:this})},onVideoListLoad:function(e,g){var b=e.video_id;var c=e.file_id;var f=e.title;this.store.data.each(function(h){this.video_list.push(new SYNO.VideoController2.VideoFile(Ext.apply({list:this},h.data)))},this);var a=this.video_list[this.getCurrentIndex(b,e.type)];a.file_id=c;a.title=f;if(this.isTVShow()){var d=a.season;this.video_list=this.video_list.filter(function(h){return(d===h.season)});this.video_list.sort(this.tvshowSortFunction)}this.getCurrentIndex(b,e.type);this.loaded=true;SYNO.VideoController2.Util.tryCallback(g)},tvshowSortFunction:function(d,c){var f=0,e=0;f+=(0===d.episode)?1024:0;e+=(0===c.episode)?1024:0;f+=(d.season>c.season)?2:0;e+=(c.season>d.season)?2:0;f+=(d.episode>c.episode)?1:0;e+=(c.episode>d.episode)?1:0;return f-e},getCurrentIndex:function(b,a){if(!Ext.isDefined(b)||!Ext.isDefined(a)){if(Ext.isNumber(this.current_index)&&0<=this.current_index){return this.current_index}else{return -1}}for(var c=0;c<this.video_list.length;++c){if(b===this.video_list[c].video_id&&a===this.video_list[c].type){this.current_index=c;break}}return this.current_index},getCurrentVideo:function(){var a=this.getCurrentIndex();return(0>a)?this.NullVideoFile:this.video_list[a]},getNextIndex:function(){if(Ext.isNumber(this.current_index)&&this.current_index>=0&&this.hasNext()){return this.current_index+1}else{return -1}},getNextVideo:function(){var a=this.getNextIndex();return(0>a)?this.NullVideoFile:this.video_list[a]},getVideoID:function(){return this.getCurrentVideo().video_id},getVideoType:function(){return this.getCurrentVideo().type},getFileUniqueKey:function(){return this.getCurrentVideo().getUniqueKey()},getFileParams:function(){return this.getCurrentVideo().getFileParams()},getTitle:function(){return this.getCurrentVideo().title},getName:function(){return this.getCurrentVideo().name},getDate:function(){return this.getCurrentVideo().date},getDuration:function(){return this.getCurrentVideo().duration},getResolution:function(){return this.getCurrentVideo().resolution},getDisplayResolution:function(){return this.getCurrentVideo().display_resolution},getCodecInfo:function(){return this.getCurrentVideo().codec_info},getAudioTrack:function(){return this.getCurrentVideo().audio_track},getDefaultAudioID:function(){var b=0;var a=this.getAudioTrack();if(a.length>0){b=a[0].id}return b},getDefaultAudioCodec:function(){var b="";var a=this.getAudioTrack();if(a.length>0){b=a[0].codec}return b},getSubtitleList:function(){return this.getCurrentVideo().subtitle_list},hasPrev:function(){return(this.current_index-1>=0)},hasNext:function(){return(this.video_list.length>this.current_index+1)},goPrev:function(a){if(!this.hasPrev()){if(true===a){this.current_index=this.video_list.length-1;return true}else{return false}}this.current_index--;return true},goNext:function(a){if(!this.hasNext()){if(true===a){this.current_index=0;return true}else{return false}}this.current_index++;return true},goJump:function(b){var a=-1;this.video_list.each(function(d,c){if(d.unique_id===b){a=c}});if(a===-1){return false}this.current_index=a;return true},canDiscoverSubtitle:function(){if(SYNO.VideoController2.Util.isPublicSharing()){return false}var a=this.getSubtitleList().length>0;var b=this.getVideoType()==="movie";var c=this.getVideoType()==="tvshow_episode";return(!a&&(b||c))&&SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","enable_discover")===true}});Ext.define("SYNO.VideoController2.Controller",{statics:{ERROR_CODE_OFFLINE_CONVFERTING_CONFIRM_LEGACY:449,ERROR_CODE_OFFLINE_CONVFERTING_BLOCK_LEGACY:450,ERROR_CODE_OFFLINE_CONVFERTING_CONFIRM:1201,ERROR_CODE_OFFLINE_CONVFERTING_BLOCK:1202},extend:"Ext.util.Observable",constructor:function(b){this.addEvents({statechange:true,mutechange:true,volumechange:true,timechange:true,subtitlechange:true,discoverchange:true,capabilityready:true,playerlistchange:true,videolistready:true,busy:true,clear:true,rawdisabled:true,targetchange:true,titlechange:true,videochange:true});var a=Ext.apply({audio_id:null,subtitle_id:null,subtitle_codepage:"auto",profile:null,player_info:{id:null,type:SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,title:_VCT("controller","streaming_mode"),volume_adjustable:true,seekable:false,password_protected:false},repeat:SYNO.VideoController2.Util.REPEAT_NONE,player_store:null,player_list:null,video_list:null,channel_id:null,channel_list:null,force_resume:false,start_position:0,delayed_time:0,subtitle_size:"small",support_remux:null,support_transcode:null,rawdisabled:false,spaceenabled:true,subtitle_visible:false,mute:false,state:SYNO.VideoController2.Util.STATE.STOPPED,volume:50,position:0,duration:0,initPlaying:false,isFirstTime:true},b);Ext.apply(this,a);this.callParent([a]);this.initPlayers();this.subtitle_manager=new SYNO.VideoController2.SubtitleManager({listeners:{subtitleready:this.onSubtitleReady.createDelegate(this),discoverready:this.onDiscoverReady.createDelegate(this)}})},onStateChange:function(a,b){this.fireEvent("statechange",a,b)},onMuteChange:function(a){this.fireEvent("mutechange",a)},onVolumeChange:function(a){this.fireEvent("volumechange",a)},onTimeChange:function(a,b){this.fireEvent("timechange",a,b)},onSubtitleChange:function(b,a){this.fireEvent("subtitlechange",b,a)},initPlayers:function(){var a;a=[new SYNO.VideoController2.NullPlayer({controller:this}),this.html5Player(),this.flashPlayer(),new SYNO.VideoController2.VLCPlayer({controller:this})];this.players=[];Ext.each(a,function(b){if(b.isAvailable()){this.players.push(b)}},this)},updatePlayer:function(d){var a=d.filename;var b;if(Ext.isString(a)){var c=SYNO.VideoController2.Util.getFileExt(a);Ext.each(this.players,function(e){if(e.canPlayType(c)){b=e;return false}},this)}this.player=b||this.players[0]},closePlayers:function(){Ext.each(this.players,function(a){a.unregisterEventHandler()},this)},selectPlayer:function(a){var b=null;Ext.each(this.players,function(c){if(a===c.getName()){b=c;return false}});if(b===null){b=this.players[0]}this.player=b;return b},getPlayer:function(){if(Ext.isObject(this.player)){return this.player}return this.players[0]},play:function(b){switch(this.state){case SYNO.VideoController2.Util.STATE.ERROR:var a=this.play.createDelegate(this,arguments);this.initPlaying=false;this.updateState(SYNO.VideoController2.Util.STATE.NO_MEDIA);this.stop(a);break;case SYNO.VideoController2.Util.STATE.NO_MEDIA:case SYNO.VideoController2.Util.STATE.CLEAR:case SYNO.VideoController2.Util.STATE.STOPPED:if(this.isFirstTime&&Ext.isChrome&&SYNO.VideoController2.Util.isMobile()){this.isFirstTime=false;break}this.isFirstTime=false;this.initPlaying=true;this.url=b||this.url;this.playCurrentVideo();break;case SYNO.VideoController2.Util.STATE.PLAYING:this.getPlayer().pause();break;case SYNO.VideoController2.Util.STATE.PAUSED:this.getPlayer().resume();break;default:break}},loadVideoList:function(d){var a=this.type_info;var b=this.video_info;this.video_list=new SYNO.VideoController2.VideoList({appWin:this.appWin,browse_type:a.type,sharing_id:a.sharing_id,type_id:parseInt(a.id,10),sort_info:Ext.apply({sort_by:"title",sort_direction:"asc"},a.sort_info)});var c={video_id:parseInt(b.id,10),type:b.type,file_id:parseInt(b.file_id,10),title:b.title,path:b.path,symlink:b.symlink};this.video_list.init(c,d)},requestTranscodeCapability:function(b){if(_S("demo_mode")){this.support_remux=false;this.support_transcode=false;this.support_hardware_transcode=false;SYNO.VideoController2.Util.tryCallback(b);return}var a={api:"SYNO.VideoStation.Info",method:"getinfo",version:1,scope:this,params:{},callback:function(f,e,d,c){if(f){Ext.apply(this,e);this.fireEvent("capabilityready",this.support_transcode,this.support_remux,this.support_dtv_transcode);SYNO.VideoController2.Util.tryCallback(b)}else{this.onAPIError.apply(this,arguments)}}};SYNO.VideoController2.Util.applySharingID(a.params);SYNO.API.Request(a)},requestPlayerList:function(a){if(_S("demo_mode")||SYNO.VideoController2.Util.isVideoControllerOnly()){this.player_list=[];SYNO.VideoController2.Util.tryCallback(a);return}this.player_store=new SYNO.VideoController2.PlayerStore({appWindow:this.appWin});this.player_store.load({scope:this,callback:function(e,d,c,b){if(e){this.player_list=[];this.player_store.each(function(f){this.player_list.push(f.data)},this);this.fireEvent("playerlistchange",this.player_list);SYNO.VideoController2.Util.tryCallback(a)}}})},requestCurrentChannel:function(a){SYNO.API.Request({api:"SYNO.DTV.Controller",method:"getchannel",version:1,params:{tuner:this.tuner_id},scope:this,callback:function(e,d,c,b){if(e){this.channel_id=d.streaming_id}SYNO.VideoController2.Util.tryCallback(a)}})},requestChannelList:function(a){if(_S("demo_mode")){this.channel_list=[];SYNO.VideoController2.Util.tryCallback(a);return}this.channel_store=new SYNO.VideoController2.ChannelStore({appWindow:this.appWin});this.channel_store.load({scope:this,params:{tuner:this.tuner_id},callback:function(e,d,c,b){if(e){this.channel_list=[];this.channel_store.each(function(f){this.channel_list.push(f.data)},this);this.fireEvent("channellistready",this.channel_list);SYNO.VideoController2.Util.tryCallback(a)}}})},initSequenceDTV:function(){var a=this.initSequenceDTV.createDelegate(this);if(!Ext.isBoolean(this.support_remux)){this.requestTranscodeCapability(a);return}if(Ext.isEmpty(this.channel_id)){this.tuner_id=this.dtv_url.substr(this.dtv_url.lastIndexOf("/")+1);this.requestCurrentChannel(a);return}if(this.privilege.dtv&&!Ext.isArray(this.channel_list)){this.requestChannelList(a);return}this.fireEvent("clear");this.playDTV()},initSequenceVideo:function(){var c=this.initSequenceVideo.createDelegate(this);var a="md5.min.js?v=0760";if(!SYNO.VideoController2.Util.hasScript(a)){SYNO.VideoController2.Util.loadScript(this,a,c);return}var b="cast_sender.js?v=0760";if(Ext.isChrome&&!SYNO.VideoController2.Util.hasScript(b)){SYNO.VideoController2.Util.loadScript(this,b,c);return}if(!Ext.isObject(this.video_list)||!this.video_list.loaded){this.loadVideoList(c);return}this.fireEvent("videolistready");if(!Ext.isBoolean(this.support_remux)){this.requestTranscodeCapability(c);return}if(!Ext.isArray(this.player_list)){this.requestPlayerList(c);return}this.fireEvent("clear");this.onReadyToPlay()},flashPlayer:function(){return new SYNO.VideoController2.FlashPlayer({controller:this})},html5Player:function(){return new SYNO.VideoController2.HTML5Player({controller:this})},getChromecastPlayer:function(){if(this.chromecast_player){return this.chromecast_player}this.chromecast_player=new SYNO.VideoController2.ChromecastPlayer({controller:this});return this.chromecast_player},onReadyToPlay:function(){var a=function(){if(SYNO.VideoController2.Util.isPublicSharing()){var b=this.video_list.getCurrentVideo();location.hash="!"+btoa(b.type+"-"+b.video_id)}this.fireEvent("clear");this.audio_id=this.video_list.getDefaultAudioID();this.fireEvent("videochange",this.video_list.hasPrev(),this.video_list.hasNext(),this.video_list.getCurrentVideo(),this.video_list.getAudioTrack(),this.video_list.getSubtitleList());this.subtitle_decided=false;this.fireEvent("titlechange",this.video_list.getName());if(!Ext.isEmpty(this.init_subtitle_id)){this.appWin.getSettingsMenu().getSubtitlePanel().setInitItem(this.init_subtitle_id)}if(!Ext.isEmpty(this.init_audiotrack_id)){this.appWin.getSettingsMenu().getAudioTrackPanel().setInitItem(this.init_audiotrack_id)}if(!Ext.isEmpty(this.init_player_id)){this.appWin.getSettingsMenu().getPlayerPanel().setInitItem(this.init_player_id)}else{this.checkUpnextVideo()}if(this.video_list.hasNext()){this.video_list.getNextVideo().getInfo(Ext.emptyFn)}this.fireEvent("discoverchange",false);if(this.video_list.canDiscoverSubtitle()){this.subtitle_manager.getDiscoverRequest(this.video_list.getFileUniqueKey())}}.createDelegate(this);if(!this.video_list.getCurrentVideo().isAllFetched()){this.fireEvent("busy");this.video_list.getCurrentVideo().getInfo(a)}else{SYNO.VideoController2.Util.tryCallback(a)}},playCurrentVideo:function(){if(Ext.isEmpty(this.channel_id)){this.checkResumeVideo()}else{this.playDTV()}},checkUpnextVideo:function(){var a=this.video_list.getCurrentVideo();if(this.is_after_playback&&!this.is_target_change){var b=SYNO.VideoController2.Util.getImageURL(a.video_id,a.type);this.appWin.getUpnextView().confirmPlayNextVideo(this.play.createDelegate(this));this.appWin.getHeaderPanel().setPoster(b)}else{this.play()}},checkResumeVideo:function(){var c=this.video_list.getCurrentVideo().getResumePosition(this.force_resume);if(!Ext.isNumber(c)){this.start_position=0;this.playVideo();return}else{if(this.force_resume){this.start_position=c;this.playVideo();return}else{if(this.repeat!==SYNO.VideoController2.Util.REPEAT_NONE){this.start_position=0;this.playVideo();return}else{if(this.is_after_playback){this.start_position=0;this.playVideo();return}}}}var a={title:_T("video_player","title"),msg:_VCT("controller","resume_watch_desc"),buttons:Ext.MessageBox.YESNO,scope:this,fn:function(d){if("no"===d){this.start_position=0}else{this.start_position=c}this.playVideo()}};var b=this.appWin.getMsgBox();b.show(a);this.appWin.hidePanels()},playVideo:function(){this.updateAfterPlaybackAction();if(this.isRemoteMode()){var b=this.isChromecast();var a=(b)?this.playChromecast.createDelegate(this):this.playRemote.createDelegate(this);if(this.player_info.password_protected){this.checkPassword(a)}else{a()}}else{this.playStreaming()}},rotateVideo:function(){var c=this.video_list.getCurrentVideo();if(Ext.isChrome||Ext.isSafari||c.rotation===0||this.profile!==null){return}var b=1;var a=this.video.dom;var d=this.getPlayer().player;var e=c.rotation;if(c.resolution.width<c.resolution.height){b=(Math.abs(e%180)===90)?a.offsetHeight/d.offsetWidth:1}else{b=(Math.abs(e%180)===90)?a.offsetWidth/d.offsetHeight:1}this.getPlayer().player.style.transform="rotate("+e+"deg) scale("+b+")"},switchChannel:function(c,a,b){if(_S("demo_mode")||!this.privilege.dtv){SYNO.VideoController2.Util.tryCallback(b);return}this.fireEvent("busy");SYNO.API.Request({api:"SYNO.DTV.Controller",method:"setchannel",version:1,params:{id:c,tuner:this.tuner_id},scope:this,callback:function(g,f,e,d){this.fireEvent("clear");if(g){this.channel_id=c;this.fireEvent("titlechange",a);SYNO.VideoController2.Util.tryCallback(b)}else{this.onAPIError.apply(this,arguments)}}})},getErrorPlayMessage:function(c){var b=_VCT("video_player","error_play");var a=SYNO.VideoController2.Util.isMobile();var e=(!a&&!Ext.isMac);var d=SYNO.VideoController2.Util.isVLCSupported();c=c||false;if(!e){return b}if(d){b=_VCT("video_player","error_play_pc")}else{b=c?_VCT("video_player","error_play_vlc"):b}return b},playDTV:function(){this.setRawDisabled(this.selectPlayer("VLC").getName()!=="VLC");if(Ext.isString(this.profile)){if(this.selectPlayer("Flash").getName()==="Flash"){this.onPlayerDecided(false);this.openDTVStream(this.profile)}else{this.onErrorOccur(this.getErrorPlayMessage())}return}if(this.selectPlayer("VLC").getName()==="VLC"){this.onPlayerDecided(true);this.openDTVStream("raw")}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.onPlayerDecided(false);this.openDTVStream("hd_high",this.audio_id)}else{this.onErrorOccur(this.getErrorPlayMessage(true))}}},openDTVStream:function(a){var b=a!=="raw";this.fireEvent("busy");SYNO.API.Request({api:"SYNO.DTV.Streaming",method:"open",version:1,params:{tuner:this.tuner_id,profile:a,accept_format:b?"hls":"raw"},scope:this,callback:function(g,f,e,d){this.fireEvent("clear");if(g){var c=b?SYNO.VideoController2.Util.getLiveStreamURL(this.tuner_id,f.stream_id):this.dtv_url;this.getPlayer().play(c);this.appWin.setVideoDisplayHeight()}else{this.onAPIError.apply(this,arguments)}}})},playStreaming:function(){this.setRawDisabled(!this.ableToPlayRawQuality());if(Ext.isString(this.profile)){if(this.selectPlayer("HTML5").getName()==="HTML5"&&SYNO.VideoController2.Util.isMacSafari()){this.onPlayerDecided(false);this.playTranscodeVideo(this.profile,this.audio_id)}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.onPlayerDecided(false);this.playTranscodeVideo(this.profile,this.audio_id)}else{this.onPlayerDecided(false);this.onErrorOccur(this.getErrorPlayMessage())}}return}this.updateToRawPlayer();if(this.getPlayer().getName()!=="Null"&&(this.audio_id===this.video_list.getDefaultAudioID())){var a=SYNO.VideoController2.Util.getFileExt(this.video_list.getTitle());this.onPlayerDecided(this.getPlayer().getName()==="VLC");this.playRawVideo(a)}else{if(this.selectPlayer("HTML5").getName()==="HTML5"&&SYNO.VideoController2.Util.isMacSafari()){this.onPlayerDecided(false);this.playTranscodeVideo(this.profile,this.audio_id)}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.onPlayerDecided(false);this.playTranscodeVideo(this.profile,this.audio_id)}else{this.onPlayerDecided(false);this.onErrorOccur(this.getErrorPlayMessage())}}}},updateToRawPlayer:function(){var a=this.video_list.getTitle();this.updatePlayer({filename:a});var b=this.video_list.getCodecInfo();if(this.getPlayer().getName()!=="VLC"&&SYNO.VideoController2.Util.isMP4Container(b.container_type)&&!SYNO.VideoController2.Util.isWebPlayableMP4(b.video_codec,this.video_list.getDefaultAudioCodec())){this.selectPlayer("VLC")}},ableToPlayRawQuality:function(){this.updateToRawPlayer();var b=(this.getPlayer().getName()!=="Null");var a=false;if(this.selectPlayer("Flash").getName()==="Flash"||(SYNO.VideoController2.Util.isMacSafari()&&this.selectPlayer("HTML5").getName()==="HTML5")){a=this.getPlayer().ableToRemux(this.video_list.getCodecInfo(),this.video_list.getResolution())}return(b||a)},playRawVideo:function(c){var d=this.video_list.getFileParams();Ext.apply(d,SYNO.VideoController2.SharingHelper.getAPI("DownloadFile"));Ext.apply(d,SYNO.VideoController2.SharingHelper.getDownloadFileParam());SYNO.VideoController2.Util.applySharingID(d);var b=String.format("{0}{1}/1.{2}",SYNO.VideoController2.Util.getLocationFullPath(),SYNO.VideoController2.SharingHelper.getCGIPath("video"),c);var a=Ext.urlAppend(b,Ext.urlEncode(d));this.getPlayer().setStartPosition(this.start_position);this.getPlayer().play(a);this.force_resume=false;this.appWin.setVideoDisplayHeight();this.rotateVideo()},playTranscodeVideo:function(c,f){var i=this.video_list.getCodecInfo();var a=this.getPlayer().ableToRemux(i,this.video_list.getResolution());var h=this.getPlayer().ableToTranscode();if(!a&&!h){this.onErrorOccur(String.format(_VCT("controller","unsupported_format"),this.player_info.title));return}var b=(!a||Ext.isString(c))?"hls":"hls_remux";var d=this.video_list.getFileParams();var g={hls_header:this.canUseHlsHeader(b)};if(Ext.isString(c)){g.profile=c}else{if(b==="hls"){g.profile="hd_high"}}if(Ext.isNumber(f)){g.audio_track=f}if(this.isChromecast()&&i.audio_codec.indexOf("ac3")!==-1&&this.getChromecastPlayer().enable_ac3_passthrough){g.audio_format="ac3_copy"}if(this.isChromecast()){g.device="chromecast"}var e=SYNO.VideoController2.SharingHelper.getTranscodeVideoParam(d,b,g);SYNO.VideoController2.Util.applySharingID(e);this.sendVTETranscodeAPI(e)},canUseHlsHeader:function(a){var d=this.isChromecast();var b=(SYNO.VideoController2.Util.isMacSafari()&&this.getPlayer().getName()==="HTML5");var c=(a==="hls");return !d&&!(b&&c)},sendVTETranscodeAPI:function(a){this.fireEvent("busy");SYNO.API.Request(Ext.apply({async:SYNO.VideoController2.Util.isMacSafari()&&SYNO.VideoController2.Util.isMobile()?false:true,params:a,scope:this,callback:function(f,e,d,b){this.fireEvent("clear");if(f){this.onVTEStreamReady(e)}else{if(SYNO.VideoController2.Controller.ERROR_CODE_OFFLINE_CONVFERTING_CONFIRM===e.code||SYNO.VideoController2.Controller.ERROR_CODE_OFFLINE_CONVFERTING_BLOCK==e.code||SYNO.VideoController2.Controller.ERROR_CODE_OFFLINE_CONVFERTING_BLOCK_LEGACY==e.code||SYNO.VideoController2.Controller.ERROR_CODE_OFFLINE_CONVFERTING_CONFIRM_LEGACY==e.code){var c=SYNO.VideoController2.Util.getErrorString(e,b.params.api);this.appWin.getMsgBox().confirm(_T("video_player","title"),c,function(g){if("yes"==g){this.sendVTETranscodeAPI(SYNO.VideoController2.SharingHelper.getForceOpenVTEParam(d))}else{this.onErrorOccur(String.format(_VCT("controller","in_transcoding"),this.player_info.title))}},this)}else{this.onAPIError.apply(this,arguments)}}}},SYNO.VideoController2.SharingHelper.getAPI("StreamingOpen")))},onVTEStreamReady:function(c){this.stream_id=c.stream_id;this.stream_format=c.format;var b=this.video_list.getDisplayResolution();var a=SYNO.VideoController2.Util.getStreamURL(this.stream_id,this.stream_format);if(this.getPlayer().getName()==="Flash"){a=SYNO.VideoController2.Util.getExtM3U(b.width,b.height,a)}this.getPlayer().setStartPosition(this.start_position);this.getPlayer().play(a);this.force_resume=false},checkPassword:function(a){SYNO.API.Request({api:"SYNO.VideoStation2.Controller.Password",method:"test",version:1,params:{device_id:this.player_info.id},scope:this,callback:function(e,d,c,b){if(e){if(d.correct){SYNO.VideoController2.Util.tryCallback(a)}else{this.promptPasswordDialog(a)}}else{this.onAPIError.apply(this,arguments)}}})},promptPasswordDialog:function(c){var a={owner:this.appWin,correctCallback:c,player_title:this.player_info.title,player_id:this.player_info.id,controller:this};var b=new SYNO.VideoController2.PasswordDialog(a);b.show()},playRemote:function(){this.onPlayerDecided(false);var b={controller:this,id:this.player_info.id,type:this.player_info.type,volume_adjustable:this.player_info.volume_adjustable,seekable:this.player_info.seekable,file_id:this.video_list.getFileUniqueKey(),title:this.video_list.getTitle(),profile:this.profile};if(!Ext.isEmpty(this.subtitle_id)&&this.subtitle_id!==SYNO.VideoController2.Util.SUBTITLE_NONE){b.subtitle_id=this.subtitle_id}if(!Ext.isEmpty(this.subtitle_codepage)){b.subtitle_codepage=this.subtitle_codepage}if(this.audio_id!==this.video_list.getDefaultAudioID()){b.audio_id=this.audio_id}var c=this.video_list.getCodecInfo();var a=this.video_list.getResolution();this.player=new SYNO.VideoController2.RemotePlayer(b);this.setRawDisabled(!this.player.ableToPlayRaw(c,a)&&!this.player.ableToRemux(c,a));this.getPlayer().setStartPosition(this.start_position);this.player.play();this.force_resume=false},playChromecast:function(){this.player=this.getChromecastPlayer();var c=this.video_list.getCodecInfo();var a=this.video_list.getResolution();this.setRawDisabled(!this.player.ableToPlayRaw(c,a)&&!this.player.ableToRemux(c,a));this.onPlayerDecided(false);if(!Ext.isString(this.profile)&&(this.audio_id===this.video_list.getDefaultAudioID())&&this.getPlayer().ableToPlayRaw(c,a)){var b=SYNO.VideoController2.Util.getFileExt(this.video_list.getTitle());this.playRawVideo(b)}else{this.playTranscodeVideo(this.profile,this.audio_id)}},unlink:function(){if(Ext.isObject(this.video_info)&&Ext.isString(this.video_info.symlink)){this.video_list.getCurrentVideo().deleteSymLink()}},updateState:function(a,b){this.state=a;if(!this.initPlaying&&a===SYNO.VideoController2.Util.STATE.STOPPED){this.getPlayer().clear();this.updateDuration(0);this.updatePosition(0)}if(this.initPlaying&&(a===SYNO.VideoController2.Util.STATE.PLAYING||a===SYNO.VideoController2.Util.STATE.BUFFERING)){this.initPlaying=false}if(a===SYNO.VideoController2.Util.STATE.ERROR){b=Ext.isString(b)?b:_T("video_player","error_play")}this.onStateChange(this.state,b);if(a===SYNO.VideoController2.Util.STATE.CLEAR&&Ext.isFunction(this.clearCallback)){var c=this.clearCallback;this.clearCallback=null;c()}},toggleMute:function(){this.getPlayer().setMute(!this.mute)},updateMute:function(a){this.mute=a;this.onMuteChange(this.mute)},setVolume:function(a){this.getPlayer().setVolume(a)},updateVolume:function(a){this.volume=a;this.onVolumeChange(this.volume)},updateDuration:function(a){this.duration=a;this.onTimeChange(this.position,this.duration)},seek:function(a){if(Ext.isNumber(a)){this.video_list.getCurrentVideo().last_watched_position=a}this.getPlayer().seek(a)},updatePosition:function(a){this.position=a;this.onTimeChange(this.position,this.duration)},toggleFullscreen:function(){var a=SYNO.VideoController2.Util.isFullscreen();if(!a){SYNO.VideoController2.Util.setDomFullscreen(Ext.getBody().dom)}else{SYNO.VideoController2.Util.exitFullscreen()}},isSubtitleVisible:function(){return this.subtitle_visible},setSubtitleEnabled:function(b,a){this.subtitle_visible=b;this.onSubtitleChange(b,a)},getSubtitleParser:function(){if(!Ext.isDefined(this.subtitle_parser)){this.subtitle_parser=new SYNO.VideoController2.SubtitleParser()}return this.subtitle_parser},stop:function(d,b){this.clearCallback=null;var a=this.getPlayer().getPosition();if(!Ext.isEmpty(this.dtv_url)||!Ext.isNumber(a)||a<=0){this.stopActual(d);return}var c=this.stopActual.createDelegate(this,arguments);this.video_list.getCurrentVideo().setWatchStatus(a,c,b)},stopActual:function(a){if(!this.getPlayer().pluginInit){if(Ext.isFunction(a)){a()}return}this.clearCallback=a;this.getPlayer().stop()},prev:function(){this.stop(this.goPrev.createDelegate(this))},goPrev:function(a){if(this.video_list.goPrev(a)){this.is_after_playback=false;this.onReadyToPlay()}},next:function(){this.stop(this.goNext.createDelegate(this))},goNext:function(b,a){if(this.video_list.goNext(b)){this.is_after_playback=a||false;this.is_target_change=false;this.onReadyToPlay()}else{if(!SYNO.VideoController2.Util.isVideoControllerOnly()){this.appWin.close()}}},jump:function(a){this.initPlaying=false;this.stop(this.goJump.createDelegate(this,[a]))},goJump:function(a){if(this.video_list.goJump(a)){this.onReadyToPlay()}},setProfile:function(a){if(a===this.profile){return}if(this.rawdisabled&&a==="hd_high"&&this.profile===null){return}this.profile=a;this.force_resume=true;this.stop(this.close.createDelegate(this,[this.play.createDelegate(this)]))},close:function(b){if(Ext.isEmpty(this.dtv_url)){SYNO.VideoController2.Util.tryCallback(b);return}var a={async:false,api:"SYNO.DTV.Streaming",method:"close",version:1,params:{tuner:this.tuner_id,hls:true},scope:this,callback:function(f,e,d,c){SYNO.VideoController2.Util.tryCallback(b)}};SYNO.API.Request(a)},setAudioTrack:function(a){if(a===this.audio_id){return}this.audio_id=a;this.force_resume=true;this.stop(this.play.createDelegate(this))},onPlayerDecided:function(b){var a=[];if(!this.isDTV()){a=this.video_list.getSubtitleList()}this.fireEvent("playerdecided",a,b);if(this.isChromecast()){return}this.selectUsingSubtitle(a,b)},selectSubtitle:function(f,b,d){var e=(d!==true);this.subtitle_decided=true;this.subtitle_id=f;this.getPlayer().subtitle_is_srt=e;if(this.isRemoteMode()){this.setSubtitleEnabled(false,f);if(this.isChromecast()){var c=SYNO.VideoController2.Util.getSubtitleUrl(this);this.getPlayer().setPlayerSubtitle(c)}return}if(e){this.getPlayer().disablePlayerSubtitle()}else{this.getPlayer().setPlayerSubtitle(parseInt(f,10))}var a=(f!==SYNO.VideoController2.Util.SUBTITLE_NONE&&e);if(a){this.subtitle_manager.requestSubtitle(this.video_list.getFileUniqueKey(),f,b,this.subtitle_codepage)}this.setSubtitleEnabled(a,f)},findPreviousSubtitle:function(b,a){if(!this.subtitle_decided){return null}var c=null;Ext.each(b,function(d){if(d.subtitle_id===this.subtitle_id&&(a||d.format==="srt")){c=d;return false}},this);return c},getUsingSubtitle:function(b,a){var d={subtitle_id:SYNO.VideoController2.Util.SUBTITLE_NONE,need_preview:false,format:"srt"};if(this.subtitle_id===SYNO.VideoController2.Util.SUBTITLE_NONE){return d}if(this.subtitle_id===SYNO.VideoController2.Util.SUBTITLE_DISCOVER){return{subtitle_id:SYNO.VideoController2.Util.SUBTITLE_DISCOVER,need_preview:false,format:"srt"}}var c=this.findPreviousSubtitle(b,a);if(Ext.isObject(c)){return c}if(a&&b.length>0){return b[0]}Ext.each(b,function(e){if(e.format==="srt"){d=e;return false}});return d},selectUsingSubtitle:function(b,a){var c=this.getUsingSubtitle(b,a);this.selectSubtitle(c.subtitle_id,c.need_preview,c.format!=="srt")},setSubtitle:function(c,a,b){if(this.isRemoteMode()&&c===this.subtitle_id){return}this.selectSubtitle(c,a,b);if(this.isRemoteMode()&&!this.isChromecast()){this.force_resume=true;this.stop(this.play.createDelegate(this))}},browseSubtitle:function(){this.getPlayer().pause();var a=this.video_list.getCurrentVideo();var c=a.sharepath.substring(0,a.sharepath.lastIndexOf("/"));var b=new SYNO.VideoController2.BrowseSubtitleDialog({appWin:this.appWin,sharepath:c});b.mon(b,"choose",this.onBrowseSelect,this);b.mon(b,"cancel",this.onBrowseCancel,this);b.open()},onBrowseSelect:function(h,c,g){var j=-1;this.subtitle_codepage=g[1];if(c&&Ext.isString(c.fullpath)){var m=this.video_list.getSubtitleList();var e=new RegExp(/[srt|ass|ssa|sami|smi]/i);var d=c.fullpath.substr(c.fullpath.lastIndexOf(".")+1);var k=c.fullpath.substr(c.fullpath.lastIndexOf("/")+1);var f={embedded:false,format:(e.test(d))?"srt":d,lang:this.subtitle_codepage,subtitle_id:c.fullpath,title:k,need_preview:false};for(var b=0,a=m.length;b<a;b++){if(m[b].subtitle_id===c.fullpath){j=b;break}}if(j!==-1){m[j]=f}else{m.push(f)}this.appWin.getSettingsMenu().getSubtitlePanel().setList(m,c.fullpath);this.setSubtitle(c.fullpath)}h.close();this.getPlayer().resume()},onBrowseCancel:function(){var a=this.video_list.getSubtitleList();var b=this.getUsingSubtitle(a);this.setSubtitle(b.subtitle_id);this.getPlayer().resume()},getDelayedTime:function(){return this.delayed_time},setDelayedTime:function(a){this.delayed_time=a;this.getPlayer().setSubtitleDelay(this.delayed_time)},syncSubtitle:function(){var a=new SYNO.VideoController2.SyncDialog({owner:this.appWin,controller:this});a.show()},resizeSubtitle:function(){var a=new SYNO.VideoController2.ResizeSubtitleDialog({owner:this.appWin,controller:this});a.show()},getSubtitleSize:function(){return this.subtitle_size},setSubtitleSize:function(a){this.subtitle_size=a;this.appWin.getDisplay().setSubtitleSize(a);this.getPlayer().setSubtitleSize(a)},setPlayer:function(a){if(a.id===this.player_info.id){return}this.player_info=a;this.fireEvent("targetchange",this.player_info);this.is_target_change=true;this.force_resume=Ext.isEmpty(this.init_player_id);this.init_player_id=null;this.stop(this.play.createDelegate(this))},setChannel:function(a){if(a.id===this.channel_id){return}this.channel_id=a.id;this.stop(this.switchChannel.createDelegate(this,[a.id,a.title,this.play.createDelegate(this)]))},toggleList:function(){var a=this.getListDialog();a.show()},getListDialog:function(){if(!Ext.isDefined(this.listDialog)){var a=!Ext.isEmpty(this.video_list)?this.video_list.getStore():null;this.listDialog=new SYNO.VideoController2.ListDialog({controller:this,orgStore:a})}return this.listDialog},setRepeat:function(a){this.repeat=a;if(this.isChromecast()){this.getPlayer().setRepeat(this.repeat)}this.updateAfterPlaybackAction()},updateAfterPlaybackAction:function(){var b=Ext.emptyFn;if(this.repeat===SYNO.VideoController2.Util.REPEAT_ALL){b=this.goNext.createDelegate(this,[true,true])}else{if(this.repeat===SYNO.VideoController2.Util.REPEAT_ONE){b=this.play.createDelegate(this)}else{if(this.repeat===SYNO.VideoController2.Util.REPEAT_NONE){b=this.goNext.createDelegate(this,[false,true])}}}var a=this.video_list.getCurrentVideo();this.clearCallback=a.setWatched.createDelegate(a,[b])},setRawDisabled:function(a){this.rawdisabled=a;this.fireEvent("rawdisabled",a,this.profile)},onSubtitleReady:function(b,c,d){if((b!==this.video_list.getFileUniqueKey())||c!==this.subtitle_id){return}var a=this.subtitle_manager.getSubtitle(b,c,d);this.getSubtitleParser().parseSrt(a)},onDiscoverReady:function(a){this.fireEvent("discoverchange",a)},onAPIError:function(e,d,c,a){if(e){return}var b=SYNO.VideoController2.Util.getErrorString(d,a.params.api);this.onErrorOccur(String.format(b,this.player_info.title))},onErrorOccur:function(a){this.updateState(SYNO.VideoController2.Util.STATE.ERROR,a)},isRemoteMode:function(){return(this.player_info.type!==SYNO.VideoController2.Util.PLAYERTYPE_STREAMING)},isChromecast:function(){return(this.player_info.type===SYNO.VideoController2.Util.PLAYERTYPE_CHROMECAST)},isDTV:function(){return !Ext.isEmpty(this.appWin.dtv_url)},searchSubtitle:function(){this.getPlayer().pause();this.promptSubtitleDialog()},promptSubtitleDialog:function(){var a={owner:this.appWin,unique_key:this.video_list.getFileUniqueKey(),controller:this};var b=new SYNO.VideoController2.SubtitleDialog(a);b.show()},setDownloadedSubtitle:function(a,b){if(a){this.setSubtitle(a);if(b!==false){this.reloadSubtitleList(a)}}this.getPlayer().resume()},reloadSubtitleList:function(b){var a=this;this.video_list.getCurrentVideo().loadSubtitleStore(function(){a.onPlayerDecided(a.getPlayer().getName()==="VLC");a.selectSubtitle(b)})},seekInterval:function(a){var b=this.position+a;if(b<0){b=0}if(b>this.duration){b=this.duration}this.seek(b)},adjustVolume:function(a){var b=this.volume+a;if(b<0){b=0}if(b>100){b=100}this.setVolume(b);this.updateVolume(b)},updateWatchedPosition:function(a){if(Ext.isObject(this.video_list)&&this.video_list.loaded){this.video_list.getCurrentVideo().updateWatchedPosition(a)}},supportRemux:function(){return this.support_remux===true},supportTranscode:function(){return this.support_transcode===true}});Ext.define("SYNO.VideoController2.PlayButton",{extend:"SYNO.VideoController2.Button",constructor:function(a){this.callParent([a]);this.addClass("play")},clickHandler:function(){this.getController().play()}});Ext.define("SYNO.VideoController2.StopButton",{extend:"SYNO.VideoController2.Button",constructor:function(a){this.callParent([a]);this.addClass("stop")},clickHandler:function(){this.getController().stop()}});Ext.define("SYNO.VideoController2.PrevButton",{extend:"SYNO.VideoController2.Button",constructor:function(a){this.callParent([a]);this.addClass("prev")},clickHandler:function(){this.getController().prev()}});Ext.define("SYNO.VideoController2.NextButton",{extend:"SYNO.VideoController2.Button",constructor:function(a){this.callParent([a]);this.addClass("next")},clickHandler:function(){this.getController().next()}});Ext.define("SYNO.VideoController2.ControlsBar",{extend:"Ext.Container",constructor:function(b){this.module=b.module;var a={items:[this.getPrevButton(),this.getPlayButton(),this.getNextButton()]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-controls-bar")},getPlayButton:function(){if(!Ext.isDefined(this.play_button)){this.play_button=new SYNO.VideoController2.PlayButton({module:this.module})}return this.play_button},getPrevButton:function(){if(!Ext.isDefined(this.prev_button)){this.prev_button=new SYNO.VideoController2.PrevButton({module:this.module})}return this.prev_button},getNextButton:function(){if(!Ext.isDefined(this.next_button)){this.next_button=new SYNO.VideoController2.NextButton({module:this.module})}return this.next_button}});Ext.define("SYNO.VideoController2.ChannelMenu",{extend:"SYNO.VideoController2.ItemMenu",constructor:function(a){this.callParent([a])},setChannelList:function(b,a){this.removeAll();Ext.each(b,function(c){this.addOneItem(c.id,c.title,this.selectChannel.createDelegate(this,[c]),(c.id===a))},this)},selectChannel:function(a){this.button.getController().setChannel(a)}});Ext.define("SYNO.VideoController2.AudiotrackPanel",{extend:"SYNO.VideoController2.MenuPanel",constructor:function(b){var a={title:_VCT("options","audio_track"),itemId:"audiotrack"};this.callParent([Ext.apply(a,b)])},setList:function(a,b){this.setDefault(b);this.removeItems();this.addAvailableAudioTrack(a,b);this.loadItems()},addAvailableAudioTrack:function(a,b){Ext.each(a,function(c){var e=c.language;var d=String.format("#{0}{1} ({2})",c.track,((0>=e.length)?"":" - "+e),c.codec);this.addItem(c.id,d,this.selectAudioTrack.createDelegate(this,[c.id]),true)},this)},selectAudioTrack:function(a){this.module.getController().setAudioTrack(a)}});Ext.define("SYNO.VideoController2.PlayerPanel",{extend:"SYNO.VideoController2.MenuPanel",constructor:function(b){var a={title:_VCT("controller","tooltip_player"),itemId:"player"};this.callParent([Ext.apply(a,b)]);this.addStreamingPlayer();this.loadItems()},setList:function(a,b){this.setDefault(b);this.removeItems();this.addStreamingPlayer();if(this.module.getController().chromecast_api){this.addChromecastPlayer()}this.addRemotePlayers(a);this.loadItems()},addStreamingPlayer:function(){this.addItem(SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,_VCT("controller","streaming_mode"),this.selectStreamingPlayer.createDelegate(this),true)},addChromecastPlayer:function(){this.addItem(SYNO.VideoController2.Util.PLAYERTYPE_CHROMECAST,_VCT("controller","chromecast_mode"),this.selectChromecastPlayer.createDelegate(this),false)},addRemotePlayers:function(a){Ext.each(a,function(b){this.addItem(b.id,b.title,this.selectPlayer.createDelegate(this,[b]),true)},this)},selectPlayer:function(a){this.module.getController().setPlayer(a);this.setItemSelected(a.id)},selectStreamingPlayer:function(){var a={id:SYNO.VideoController2.Util.STREAMING_ID,type:SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,title:_VCT("controller","streaming_mode"),volume_adjustable:true,password_protected:false,seekable:true};this.selectPlayer(a)},selectChromecastPlayer:function(){var b={id:SYNO.VideoController2.Util.CHROMECAST_ID,type:SYNO.VideoController2.Util.PLAYERTYPE_CHROMECAST,title:_VCT("controller","chromecast_mode"),password_protected:false,volume_adjustable:true,seekable:true};var c=this.module.getController().getChromecastPlayer();var d=function(){this.selectPlayer(b)};var a=function(){return false};c.launchApp(d.createDelegate(this),a.createDelegate(this))}});Ext.define("SYNO.VideoController2.QualityPanel",{extend:"SYNO.VideoController2.MenuPanel",constructor:function(b){var a={title:_VCT("controller","playback_quality"),itemId:"quality"};this.callParent([Ext.apply(a,b)]);this.setList();this.transcode_disable=true},setList:function(){this.removeItems();this.addRaw();this.addHigh();this.addMedium();this.addLow();this.loadItems()},addRaw:function(){this.addItem(SYNO.VideoController2.Util.QUALITY_RAW,_VCT("controller","quality_raw"),this.selectProfile.createDelegate(this,[SYNO.VideoController2.Util.QUALITY_RAW]),true,this.raw_disable)},addHigh:function(){this.addItem(SYNO.VideoController2.Util.QUALITY_HD_HIGH,_VCT("controller","quality_high"),this.selectProfile.createDelegate(this,[SYNO.VideoController2.Util.QUALITY_HD_HIGH]),true,this.transcode_disable)},addMedium:function(){this.addItem(SYNO.VideoController2.Util.QUALITY_HD_MEDIUM,_VCT("controller","quality_medium"),this.selectProfile.createDelegate(this,[SYNO.VideoController2.Util.QUALITY_HD_MEDIUM]),true,this.transcode_disable)},addLow:function(){this.addItem(SYNO.VideoController2.Util.QUALITY_HD_LOW,_VCT("controller","quality_low"),this.selectProfile.createDelegate(this,[SYNO.VideoController2.Util.QUALITY_HD_LOW]),true,this.transcode_disable)},selectProfile:function(a){this.module.getController().setProfile(a);this.setItemSelected(a)},setRawDisabled:function(a){this.raw_disable=a;this.setList()},setTranscodeDisabled:function(a){this.transcode_disable=a}});Ext.define("SYNO.VideoController2.RepeatPanel",{extend:"SYNO.VideoController2.MenuPanel",constructor:function(b){var a={title:_VCT("controller","repeat_mode"),itemId:"repeat"};this.callParent([Ext.apply(a,b)]);this.setDefault(SYNO.VideoController2.Util.REPEAT_NONE);this.setList()},setList:function(){this.removeItems();this.addRepeatNone();this.addRepeatAll();this.addRepeatOne();this.loadItems()},addRepeatNone:function(){this.addItem(SYNO.VideoController2.Util.REPEAT_NONE,_VCT("controller","repeat_none"),this.selectRepeatMode.createDelegate(this,[SYNO.VideoController2.Util.REPEAT_NONE]),true)},addRepeatAll:function(){this.addItem(SYNO.VideoController2.Util.REPEAT_ALL,_VCT("controller","repeat_all"),this.selectRepeatMode.createDelegate(this,[SYNO.VideoController2.Util.REPEAT_ALL]),true)},addRepeatOne:function(){this.addItem(SYNO.VideoController2.Util.REPEAT_ONE,_VCT("controller","repeat_one"),this.selectRepeatMode.createDelegate(this,[SYNO.VideoController2.Util.REPEAT_ONE]),true)},selectRepeatMode:function(a){this.module.getController().setRepeat(a)}});Ext.define("SYNO.VideoController2.SubtitlePanel",{extend:"SYNO.VideoController2.MenuPanel",constructor:function(b){var a={title:_VCT("options","subtitle"),itemId:"subtitle"};this.callParent([Ext.apply(a,b)])},setList:function(b,a){this.removeItems();this.addNoneSubtitle();this.addAvailableSubtitles(b,a);this.addDiscoverSubtitle(b);this.addSearchItem();this.addBrowseItem();this.addSyncItem();this.addResizeItem();this.loadItems()},addNoneSubtitle:function(){this.addItem(SYNO.VideoController2.Util.SUBTITLE_NONE,_VCT("controller","no_subtitle"),this.selectSubtitle.createDelegate(this,[SYNO.VideoController2.Util.SUBTITLE_NONE]),true)},addDiscoverSubtitle:function(a){if(!this.module.getController().video_list||!this.module.getController().video_list.canDiscoverSubtitle()){return}this.addItem(SYNO.VideoController2.Util.SUBTITLE_DISCOVER,_VCT("controller","discover_subtitle"),this.selectSubtitle.createDelegate(this,[SYNO.VideoController2.Util.SUBTITLE_DISCOVER]),true)},addSearchItem:function(){if(SYNO.VideoController2.Util.isPublicSharing()){return}this.addItem(SYNO.VideoController2.Util.SUBTITLE_SEARCH,_VCT("controller","search_subtitle"),this.searchSubtitle.createDelegate(this),false)},addBrowseItem:function(){if(SYNO.VideoController2.Util.isPublicSharing()){return}this.addItem(SYNO.VideoController2.Util.SUBTITLE_BROWSE,_VCT("controller","browse_subtitle"),this.browseSubtitle.createDelegate(this),false)},addSyncItem:function(){this.addItem(SYNO.VideoController2.Util.SUBTITLE_SYNC,_VCT("controller","shift_subtitle"),this.syncSubtitle.createDelegate(this),false)},addResizeItem:function(){if(!this.module.getController().isChromecast()&&this.module.getController().isRemoteMode()){return}this.addItem(SYNO.VideoController2.Util.SUBTITLE_RESIZE,_VCT("controller","resize_subtitle"),this.resizeSubtitle.createDelegate(this),false)},addAvailableSubtitles:function(c,a){var b=[];Ext.each(c,function(d){var e=d.format.toLowerCase();if(!this.supportedSubtitle(e,a)){return true}b.push(this.convertSubtitleItem(d))},this);b.sort(function(g,e){var f=(g.embedded?2:0)+(g.display<e.display?0:1);var d=(e.embedded?2:0)+(g.display>e.display?0:1);return f-d});Ext.each(b,function(d){this.addItem(d.subtitle_id,d.display,this.selectSubtitle.createDelegate(this,[d.subtitle_id,d.need_preview,!d.is_srt]),true)},this)},convertSubtitleItem:function(b){var a=SYNO.Util.copy(b);var d=b.format.toLowerCase();var c=d==="srt";var f=b.lang.toLowerCase();var e;if(false===b.embedded){if(b.title===""){e=_VCT("controller","external_subtitle")}else{e=b.title}e+=f.length>0?(" - "+f):""}else{if(!Ext.isEmpty(b.title)){e=b.title}else{if(!Ext.isEmpty(f)){e=f}else{e=String.format("Subtitle Track #{0}",b.subtitle_id)}}if(!c){e+=String.format(" ({0})",d)}}a.is_srt=c;a.display=e||"";return a},selectSubtitle:function(c,a,b){this.module.getController().setSubtitle(c,a,b)},searchSubtitle:function(){this.module.getController().searchSubtitle();this.module.getOptionsBar().getSettingsButton().hideMenu()},browseSubtitle:function(){this.module.getController().browseSubtitle();this.module.getOptionsBar().getSettingsButton().hideMenu()},syncSubtitle:function(){this.module.getController().syncSubtitle();this.module.getOptionsBar().getSettingsButton().hideMenu()},resizeSubtitle:function(){this.module.getController().resizeSubtitle();this.module.getOptionsBar().getSettingsButton().hideMenu()},supportedSubtitle:function(b,a){if(!Ext.isString(b)){return false}if(!a){return b==="srt"}else{return["srt","pgs","dvdsub"].indexOf(b)!==-1}}});Ext.define("SYNO.VideoController2.SettingsMenu",{extend:"SYNO.ux.Panel",constructor:function(b){this.module=b.module;var a={header:true,title:_VCT("action","settings"),cls:"vc-setting-panel",layout:"accordion",layoutConfig:{titleCollapse:true,animate:true},items:[this.getQualityPanel(),this.getAudioTrackPanel(),this.getSubtitlePanel(),this.getPlayerPanel(),this.getRepeatPanel()],listeners:{scope:this,afterrender:function(){var d=!b.module.getController().isDTV()?"subtitle":"quality";var c=this.getComponent(d);this.getLayout().setActiveItem(c);this.setMenuHeight()}}};this.callParent([Ext.apply(a,b)])},getQualityPanel:function(){if(!Ext.isDefined(this.quality_panel)){this.quality_panel=new SYNO.VideoController2.QualityPanel({module:this.module})}return this.quality_panel},getAudioTrackPanel:function(){if(!Ext.isDefined(this.audiotrack_panel)){this.audiotrack_panel=new SYNO.VideoController2.AudiotrackPanel({module:this.module})}return this.audiotrack_panel},getSubtitlePanel:function(){if(!Ext.isDefined(this.subtitle_panel)){this.subtitle_panel=new SYNO.VideoController2.SubtitlePanel({module:this.module})}return this.subtitle_panel},getPlayerPanel:function(){if(!Ext.isDefined(this.player_panel)){this.player_panel=new SYNO.VideoController2.PlayerPanel({module:this.module})}return this.player_panel},getRepeatPanel:function(){if(!Ext.isDefined(this.repeat_panel)){this.repeat_panel=new SYNO.VideoController2.RepeatPanel({module:this.module})}return this.repeat_panel},getItemMaxLength:function(){var a=this.items.getRange().map(function(b){return b.getListLength()});return Math.max.apply(null,a)},setMenuHeight:function(){var d=5+6;var a=(this.items.length+1)*34;var e=this.getItemMaxLength()*32;var c=d+a+e;var b=Ext.getBody().getViewSize().height-80-10-10;this.setHeight(c>b?b:c)}});Ext.define("SYNO.VideoController2.VolumePanel",{extend:"Ext.Panel",constructor:function(b){this.volumeBar=new SYNO.VideoController2.VolumeBar({module:b.module});var a={cls:"vc-volume-panel",frame:true,items:[this.volumeBar]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.VolumeBar",{extend:"SYNO.VideoController2.Slider",constructor:function(b){var a={cls:"vc-volume-bar",minValue:0,maxValue:100,vertical:true};this.callParent([Ext.apply(a,b)])},updateView:function(a){if(!this.disabled&&!this.isDragging()){this.setValue(a)}},insertVolumeStrip:function(){if(this.volumeStrip){return}this.volumeStrip=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"volume"},true);this.volumeStrip.setHeight(0);this.halfThumb=8},onAfterRender:function(){this.insertVolumeStrip();var a=this.getValue();this.setValue(1);this.setValue(a)},onChange:function(c,d,b){var a=d/100*138;this.volumeStrip.setHeight(a)},onChangeComplete:function(b,c,a){if(!this.disabled){this.module.getController().setVolume(c)}},setDisable:function(a){if(a){this.setValue(0);this.volumeStrip.setWidth(0);this.disable()}else{this.enable()}}});Ext.define("SYNO.VideoController2.VolumeButton",{extend:"SYNO.VideoController2.MenuButton",constructor:function(b){this.module=b.module;var a={muted:false,menuAlign:"b-t"};this.callParent([Ext.apply(a,b)]);this.addClass("volume")},createMenu:function(){this.volume_panel=new SYNO.VideoController2.VolumePanel({module:this.module});var a=new SYNO.VideoController2.Menu({cls:"syno-vc-volume-menu",defaultOffsets:[0,-11],items:[this.volume_panel]});return a},setMute:function(a){if(this.isDestroyed){return}this.muted=a;if(this.muted){this.addClass("mute");this.hideMenu()}else{this.removeClass("mute");if(this.getEl().hasClass("x-btn-over")){this.showMenu()}}},setVolume:function(a){this.volume_panel.volumeBar.updateView(a)},clickHandler:function(){this.getController().toggleMute()},onClick:function(a){if(a){a.preventDefault()}if(a.button!==0||this.disabled){return}this.doToggle();this.fireEvent("click",this,a);if(this.handler){this.handler.call(this.scope||this,this,a)}},onMouseOver:function(a){if(!this.muted&&!this.disabled){this.showMenu()}this.callParent(arguments)}});Ext.define("SYNO.VideoController2.SettingsButton",{extend:"SYNO.VideoController2.MenuButton",constructor:function(b){this.module=b.module;this.align_config="br-tr";this.align_offset=[88,-18];var a={menuAlign:this.align_config};this.callParent([Ext.apply(a,b)]);this.addClass("setting")},createMenu:function(){var a=new SYNO.VideoController2.Menu({cls:"syno-vc-setting-panel",defaultOffsets:this.align_offset,items:this.getSettingsMenu(),onShow:function(b){b.getEl().alignTo(this.getEl(),this.align_config,this.align_offset);this.getSettingsMenu().items.each(function(d,c){d.updateFleXcroll();d.getDataview().updateFleXcroll()})}.createDelegate(this)});return a},getSettingsMenu:function(){if(!Ext.isDefined(this.settings_menu)){this.settings_menu=new SYNO.VideoController2.SettingsMenu({module:this.module})}return this.settings_menu}});Ext.define("SYNO.VideoController2.FullscreenButton",{extend:"SYNO.VideoController2.Button",constructor:function(b){var a={isFullscreen:false,disabled:!SYNO.VideoController2.Util.isDomFullscreenSupported()};this.callParent([Ext.apply(a,b)]);this.addClass("fullscreen")},setFullscreen:function(a){if(this.isDestroyed){return}this.fullscreen=a;if(this.fullscreen){this.addClass("fitscreen")}else{this.removeClass("fitscreen")}},clickHandler:function(){this.getController().toggleFullscreen()}});Ext.define("SYNO.VideoController2.ListButton",{extend:"SYNO.VideoController2.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("list")},clickHandler:function(){this.getController().toggleList()}});Ext.define("SYNO.VideoController2.RepeatButton",{extend:"SYNO.VideoController2.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("repeat")},clickHandler:function(){this.getController().toggleRepeat()}});Ext.define("SYNO.VideoController2.SubtitleButton",{extend:"SYNO.VideoController2.MenuButton",constructor:function(a){this.callParent([a]);this.addClass("subtitle")},createMenu:function(){return new SYNO.VideoController2.SubtitleMenu({button:this})}});Ext.define("SYNO.VideoController2.PlayerButton",{extend:"SYNO.VideoController2.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("player")},createMenu:function(){return new SYNO.VideoController2.PlayerMenu({button:this})}});Ext.define("SYNO.VideoController2.ChannelButton",{extend:"SYNO.VideoController2.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("channel")},createMenu:function(){return new SYNO.VideoController2.ChannelMenu({button:this})}});Ext.define("SYNO.VideoController2.SettingButton",{extend:"SYNO.VideoController2.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("setting")},createMenu:function(){return new SYNO.VideoController2.SettingMenu({button:this})}});Ext.define("SYNO.VideoController2.OptionsBar",{extend:"Ext.Container",constructor:function(b){this.module=b.module;var a={items:[this.getListButton(),this.getChannelButton(),this.getVolumeButton(),this.getSettingsButton(),this.getFullscreenButton()]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-options-bar")},hasMenuVisible:function(){return this.getVolumeButton().menu.isVisible()||this.getSettingsButton().menu.isVisible()||this.getChannelButton().menu.isVisible()},getVolumeButton:function(){if(!Ext.isDefined(this.volume_button)){this.volume_button=new SYNO.VideoController2.VolumeButton({module:this.module})}return this.volume_button},getSettingsButton:function(){if(!Ext.isDefined(this.settings_button)){this.settings_button=new SYNO.VideoController2.SettingsButton({module:this.module})}return this.settings_button},getFullscreenButton:function(){if(!Ext.isDefined(this.fullscreen_button)){this.fullscreen_button=new SYNO.VideoController2.FullscreenButton({module:this.module})}return this.fullscreen_button},getListButton:function(){if(!Ext.isDefined(this.list_button)){this.list_button=new SYNO.VideoController2.ListButton({module:this.module,hidden:true})}return this.list_button},getChannelButton:function(){if(!Ext.isDefined(this.channel_button)){this.channel_button=new SYNO.VideoController2.ChannelButton({module:this.module,hidden:true})}return this.channel_button}});Ext.define("SYNO.VideoController2.ProgressSlider",{extend:"SYNO.VideoController2.Slider",promoteThumb:Ext.emptyFn,progressMax:10000,constructor:function(b){var a={minValue:0,maxValue:this.progressMax};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-progress-slider");this.duration=0},getTimeText:function(){if(!Ext.isDefined(this.time_text)){this.time_text=new SYNO.VideoController2.TimeText({cls:"time-bubble"})}return this.time_text},updateView:function(a,b){this.duration=b||this.duration;if(Ext.isNumber(this.duration)&&this.duration>0){this.setDisable(false);if(!this.isDragging()){this.setValue(this.progressMax*a/this.duration);this.getTimeText().updateView(a)}}else{this.setDisable(true)}},insertSeekProgress:function(){if(this.seekProgress){return}this.seekProgress=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"progress"},true);this.seekProgress.setWidth(0);this.halfThumb=0},onAfterRender:function(){this.insertSeekProgress();this.setValue(1);this.setValue(0)},onChange:function(c,d,b){var a=this.duration*d/this.progressMax;this.module.getControlPanel().setPlaybackPosition(a);this.seekProgress.setWidth(b.el.getLeft(true)+this.halfThumb);this.getTimeText().updateView(a);Ext.DomHelper.overwrite(b.el.dom,{tag:"div",cls:"time-bubble",html:this.getTimeText().text})},onChangeComplete:function(c,d,b){var a=this.duration*d/this.progressMax;if(Ext.isNumber(a)){this.module.getController().seek(a)}},setDisable:function(a){if(this.isDestroyed){return}if(a){this.setValue(0);this.seekProgress.setWidth(0);this.disable()}else{this.enable()}}});Ext.define("SYNO.VideoController2.ProgressBar",{extend:"Ext.Container",constructor:function(b){this.module=b.module;var a={items:[this.getProgressSlider(),this.getPositionText(),this.getDurationText()]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-progress-bar")},getProgressSlider:function(){if(!Ext.isDefined(this.progress_slider)){this.progress_slider=new SYNO.VideoController2.ProgressSlider({module:this.module})}return this.progress_slider},getPositionText:function(){if(!Ext.isDefined(this.position_text)){this.position_text=new SYNO.VideoController2.TimeText({cls:"position"})}return this.position_text},getDurationText:function(){if(!Ext.isDefined(this.duration_text)){this.duration_text=new SYNO.VideoController2.TimeText({cls:"duration"})}return this.duration_text}});Ext.define("SYNO.VideoController2.MetaDisplay",{extend:"Ext.Container",constructor:function(b){var a={itemId:"meta_display",cls:"meta-display",hidden:true,hideMode:"offsets",html:this.getHtml()};this.callParent([Ext.apply(a,b)])},setImage:function(b){if(this.isDestroyed){return}var a=Ext.get(this.getIconID());if(""===b){this.icon_src="";a.hide();a.setStyle("background-image","")}else{if(b===this.icon_src){return}this.icon_src=b;a.setStyle("background-image",String.format("url({0})",b));a.show()}},setText:function(a){if(this.isDestroyed||!Ext.isString(a)){return}Ext.get(this.getTextID()).update(a)},getTextID:function(){if(!Ext.isDefined(this.text_id)){this.text_id=Ext.id()}return this.text_id},getIconID:function(){if(!Ext.isDefined(this.icon_id)){this.icon_id=Ext.id()}return this.icon_id},getHtml:function(){return['<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0">',"<tbody>","<tr><td>",'<div class="frame">','<div class="cover-frame"></div>','<div class="icon-frame"><div class="icon" id="'+this.getIconID()+'"></div></div>',"</div>",'<div class="status-text" id="'+this.getTextID()+'"></div>',"</td></tr>","</tbody>","</table>"].join("")}});Ext.define("SYNO.VideoController2.SubtitleDisplay",{extend:"Ext.Container",SUBTITLE_HEIGHT:80,MAX_LINE:6,PADDING:4,constructor:function(b){var a={itemId:"subtitle",hidden:true,cls:"subtitle",prev_text:"",margin_bottom:0,font_size_list:{"extra-large":56,large:48,medium:40,small:36,"extra-small":28}};this.callParent([Ext.apply(a,b)]);this.mac_safari_repaint_workaround=SYNO.VideoController2.Util.isMacSafari()},getFontSize:function(a){if(this.font_size_list.hasOwnProperty(a)){return this.font_size_list[a]}return this.font_size_list.small},setText:function(c){if(c===this.prev_text){return}var a=this.font_size;var b=Ext.min([c.split("<br/>").length,this.MAX_LINE]);this.prev_text=c;this.getEl().update(c||"&nbsp;");this.updateSize(a,this.getLineHeight(),b);if(this.mac_safari_repaint_workaround&&Ext.isString(c)&&c!==""){this.getEl().repaint()}},setSubtitleSize:function(b){var a=Ext.min([this.prev_text.split("<br/>").length,this.MAX_LINE]);this.font_size=b||this.font_size;this.updateSize(this.font_size,this.getLineHeight(),a)},updateSize:function(b,e,c){if(this.is_vlc){var a=e*2;e=(c>1)?(a/c):a;b=(c>1)?(e*0.9):this.getFontSize(this.font_size);this.setHeight(a)}else{b=this.getFontSize(this.font_size)}var d=this.getEl();d.setStyle("padding-top","10px");d.setStyle("padding-bottom","10px");d.setStyle("font-size",String.format("{0}px",b));d.setStyle("line-height",String.format("{0}px",e))},setIsVLC:function(a){this.is_vlc=a},getLineHeight:function(){return this.getFontSize(this.font_size)+this.PADDING},setSubtitleMarginBottom:function(c,b){var d=56;var f=58;var e=this.SUBTITLE_HEIGHT/2;var a=c+e;this.margin_bottom=0;if(!this.is_vlc){this.margin_bottom=a;if(b){this.margin_bottom=this.margin_bottom-(this.margin_bottom>d?f:0);this.margin_bottom=(this.margin_bottom<d?d:this.margin_bottom)}}this.getEl().setStyle("margin-bottom",String.format("{0}px",this.margin_bottom))}});Ext.define("SYNO.VideoController2.VideoDisplay",{extend:"Ext.Container",constructor:function(b){var a={itemId:"video_display",cls:"video-display",hideMode:"offsets",items:[this.getVideoContainer(),this.getSubtitleDisplay()]};this.callParent([Ext.apply(a,b)])},getVideoContainer:function(){return{xtype:"container",itemId:"video",cls:"video"}},getSubtitleDisplay:function(){this.subtitle_display=this.subtitle_display||new SYNO.VideoController2.SubtitleDisplay();return this.subtitle_display}});Ext.define("SYNO.VideoController2.Display",{extend:"Ext.Container",ALL_META_CLASSES:["poster","screenshot","buffer","error"],constructor:function(b){var a={layout:"card",itemId:"body",cls:"syno-vc-body",activeItem:this.getInitItemID(),items:[this.getVideoDisplay(),this.getMetaDisplay()],listeners:{scope:this},remote_mode:false,video_info:{}};this.callParent([Ext.apply(a,b)])},getInitItemID:function(){return((Ext.isLinux&&Ext.isGecko)||(Ext.isMac&&Ext.isGecko))?0:1},setSubtitle:function(a){if(this.getVideoDisplay().getComponent("subtitle")){this.getVideoDisplay().getComponent("subtitle").setText(a)}},setSubtitleSize:function(a){if(this.getVideoDisplay().getComponent("subtitle")){this.getVideoDisplay().getComponent("subtitle").setSubtitleSize(a)}},showSubtitle:function(a){this.getVideoDisplay().getComponent("subtitle")[(true===a)?"show":"hide"]();this.doLayout()},getVideoDisplay:function(){if(!Ext.isDefined(this.video_display)){this.video_display=new SYNO.VideoController2.VideoDisplay()}return this.video_display},getMetaDisplay:function(){if(!Ext.isDefined(this.meta_display)){this.meta_display=new SYNO.VideoController2.MetaDisplay()}return this.meta_display},setState:function(a,b){switch(a){case SYNO.VideoController2.Util.STATE.CLEAR:case SYNO.VideoController2.Util.STATE.STOPPED:this.setStopped();break;case SYNO.VideoController2.Util.STATE.PAUSED:case SYNO.VideoController2.Util.STATE.PLAYING:this.setPlaying();break;case SYNO.VideoController2.Util.STATE.BUFFERING:this.setBuffering();break;case SYNO.VideoController2.Util.STATE.ERROR:SYNO.Debug("error: ",b);this.setError(b);break;default:break}},getVideoInfo:function(){return this.video_info},setVideoInfo:function(a){this.video_info=a;this.playing_cls=((this.video_info.type==="movie")?"poster":"screenshot");this.playing_exclude_cls=this.ALL_META_CLASSES.filter(function(b){return(this.playing_cls!==b)},this);this.image_url=SYNO.VideoController2.Util.getImageURL(a.video_id,a.type)},setRemoteMode:function(b,a){this.remote_mode=b;if(this.remote_mode){this.status_text=String.format(_VCT("controller","playing_on"),a)}},setStopped:function(){if(!this.remote_mode){this.layout.setActiveItem(0);this.getMetaDisplay().removeClass(["buffer","error"]);return}this.layout.setActiveItem(1);this.getMetaDisplay().removeClass(this.ALL_META_CLASSES);this.getMetaDisplay().setImage("");this.getMetaDisplay().setText("")},setPlaying:function(){if(this.isDestroyed){return}if(!this.remote_mode){this.layout.setActiveItem(0);return}this.layout.setActiveItem(1);this.getMetaDisplay().removeClass(this.playing_exclude_cls);this.getMetaDisplay().addClass(this.playing_cls);this.getMetaDisplay().setImage(this.image_url);this.getMetaDisplay().setText(this.status_text)},setBuffering:function(){this.getMetaDisplay().removeClass("error");this.getMetaDisplay().setText("")},setError:function(a){if(this.isDestroyed){return}this.layout.setActiveItem(1);this.getMetaDisplay().addClass("error");this.getMetaDisplay().removeClass("buffer");this.getMetaDisplay().setText(a);this.getMetaDisplay().setImage("")}});Ext.define("SYNO.VideoController2.ControlPanel",{extend:"Ext.Container",constructor:function(b){this.module=b.module;var a={mouse_over:false,items:[this.getControlsBar(),this.getProgressBar(),this.getOptionsBar()]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-control-panel")},getControlsBar:function(){if(!Ext.isDefined(this.controls_bar)){this.controls_bar=new SYNO.VideoController2.ControlsBar({module:this.module})}return this.controls_bar},getProgressBar:function(){if(!Ext.isDefined(this.progress_bar)){this.progress_bar=new SYNO.VideoController2.ProgressBar({module:this.module})}return this.progress_bar},getOptionsBar:function(){if(!Ext.isDefined(this.options_bar)){this.options_bar=new SYNO.VideoController2.OptionsBar({module:this.module})}return this.options_bar},setTime:function(a,b){var c=this.getProgressBar().getProgressSlider();c.updateView(a,b);this.setPlaybackDuration(b)},setPlaybackPosition:function(a){this.getProgressBar().getPositionText().updateView(a)},setPlaybackDuration:function(a){this.getProgressBar().getDurationText().updateView(a)},setMute:function(a){this.getOptionsBar().getVolumeButton().setMute(a)},setVolume:function(a){this.getOptionsBar().getVolumeButton().setVolume(a)},setState:function(b,c){if(this.isDestroyed){return}var a=this.getControlsBar().getPlayButton();switch(b){case SYNO.VideoController2.Util.STATE.CLEAR:case SYNO.VideoController2.Util.STATE.STOPPED:case SYNO.VideoController2.Util.STATE.PAUSED:case SYNO.VideoController2.Util.STATE.ERROR:a.removeClass("pause");a.addClass("play");break;case SYNO.VideoController2.Util.STATE.BUFFERING:case SYNO.VideoController2.Util.STATE.PLAYING:a.removeClass("play");a.addClass("pause");break;default:break}a.setDisabled(b===SYNO.VideoController2.Util.STATE.ERROR)},setPrevNext:function(b,a){this.getControlsBar().getPrevButton().setDisabled(!b);this.getControlsBar().getNextButton().setDisabled(!a)},setMouseOver:function(a){this.mouse_over=a},isMouseOver:function(){return this.mouse_over}});Ext.define("SYNO.VideoController2.HeaderPanel",{extend:"Ext.Container",constructor:function(b){this.appwin=b.module;var a={items:[this.getHeaderPoster(),this.getTextArea(),this.getCloseButton()]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-header-panel")},getCloseButton:function(){if(!Ext.isDefined(this.close_button)){this.close_button=new SYNO.VideoController2.CloseButton({appwin:this.appwin})}return this.close_button},getTextArea:function(){if(!Ext.isDefined(this.text_area)){this.text_area=new SYNO.VideoController2.TextArea({appwin:this.appwin})}return this.text_area},getTitleText:function(){return this.getTextArea().getTitleText()},getHeaderPoster:function(){if(!Ext.isDefined(this.header_poster)){this.header_poster=new SYNO.VideoController2.HeaderPoster()}return this.header_poster},setTitle:function(a){this.getTextArea().getTitleText().setText(a)},setPoster:function(a){this.getHeaderPoster().setPoster(a)},showUpnextMode:function(){if(!this.getEl().hasClass("upnext-mode")){this.appwin.showPanels();this.getEl().addClass("upnext-mode")}},hideUpnextMode:function(){if(this.getEl().hasClass("upnext-mode")){this.appwin.hidePanels();this.getEl().removeClass("upnext-mode")}}});Ext.define("SYNO.VideoController2.CloseButton",{extend:"SYNO.ux.Button",constructor:function(b){this.appwin=b.appwin;var a={scope:this,listeners:{scope:this,click:this.close}};this.callParent([Ext.apply(a,b)]);this.addClass("close")},close:function(){this.appwin.stop_callback_sync=false;this.appwin.restoreDsmBeforeUnload();this.appwin.close()}});Ext.define("SYNO.VideoController2.TextArea",{extend:"Ext.Container",constructor:function(b){var a={items:[this.getNextText(),this.getTitleText()]};this.callParent([Ext.apply(a,b)]);this.addClass("text-area")},getTitleText:function(){if(!Ext.isDefined(this.title_text)){this.title_text=new SYNO.VideoController2.TitleText()}return this.title_text},getNextText:function(){if(!Ext.isDefined(this.next_text)){this.next_text=new SYNO.VideoController2.NextText()}return this.next_text}});Ext.define("SYNO.VideoController2.NextText",{extend:"Ext.Toolbar.TextItem",constructor:function(b){var a={text:"Next"};this.callParent([Ext.apply(a,b)]);this.addClass("next-text")}});Ext.define("SYNO.VideoController2.TitleText",{extend:"Ext.Toolbar.TextItem",constructor:function(b){var a={text:""};this.callParent([Ext.apply(a,b)]);this.addClass("title")}});Ext.define("SYNO.VideoController2.HeaderPoster",{extend:"Ext.Container",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("header-poster")},setPoster:function(a){this.getEl().setStyle("background-image",String.format("url({0})",a))}});Ext.define("SYNO.VideoController2.BackdropView",{extend:"Ext.Container",constructor:function(b){var a={cls:"backdrop",items:[{xtype:"container",cls:"image"},{xtype:"container",cls:"gradient"}]};this.callParent([Ext.apply(a,b)])},setState:function(b,c,a){if(this.isDestroyed){return}switch(b){case SYNO.VideoController2.Util.STATE.PLAYING:case SYNO.VideoController2.Util.STATE.PAUSED:case SYNO.VideoController2.Util.STATE.BUFFERING:this.show();break;case SYNO.VideoController2.Util.STATE.ERROR:this.hide();break;default:this.show()}},setBackdrop:function(a){this.setBackdropByMapperId(a.mapper_id)},setBackdropByMapperId:function(a){if(SYNO.VideoController2.Util.isVideoControllerOnly()){return}var b=SYNO.VideoController2.Util.getBackdropURL(a);this.getEl().select(".image").setStyle("background-image",String.format('url("{0}")',b))}});Ext.define("SYNO.VideoController2.BufferView",{extend:"Ext.Container",constructor:function(b){var a={cls:"buffer",items:[{xtype:"container",cls:"loading"}]};this.callParent([Ext.apply(a,b)])},setState:function(a){if(this.isDestroyed){return}switch(a){case SYNO.VideoController2.Util.STATE.BUFFERING:this.show();break;default:this.hide()}}});Ext.define("SYNO.VideoController2.UpnextView",{extend:"Ext.Container",constructor:function(b){var a={cls:"upnext",count:0,countdown:10000,interval:100,hidden:true,items:[this.getPlayButton(),this.getRingProgress(),this.getCancelButton()]};this.callParent([Ext.apply(a,b)])},confirmPlayNextVideo:function(a){this.module.getHeaderPanel().showUpnextMode();this.show();this.getCancelButton().show();if(this.getEl().hasClass("canceled")){this.getEl().removeClass("canceled")}this.callback=a;this.startCountdown()},getRingProgress:function(){this.ring_progress=this.ring_progress||new Ext.Container({cls:"ring",listeners:{scope:this,afterrender:function(a){Ext.DomHelper.append(a.getEl(),this.getRingSvg())}}});return this.ring_progress},getRingSvg:function(){this.circle_diameter=108;this.circle_radius=this.circle_diameter/2;this.ring_width=4;this.ring_radius=this.circle_radius-this.ring_width/2;this.ring_diameter=this.ring_radius*2;this.ring_perimeter=this.ring_diameter*Math.PI;return{tag:"svg",version:"1.1",viewBox:"0 0 108 108",style:"width:108px;height:108px;",children:[{tag:"circle",cls:"ring",cx:this.circle_radius,cy:this.circle_radius,r:this.circle_radius,fill:"#FFFFFF","fill-opacity":"0.15"},{tag:"circle",cls:"circle",cx:this.circle_radius,cy:this.circle_radius,r:this.circle_radius-this.ring_width,fill:"#000000","fill-opacity":"0.4"},{tag:"circle",cls:"progress",cx:(-1*this.circle_radius),cy:this.circle_radius,r:this.ring_radius,"fill-opacity":"0",stroke:"#BF2A2A","stroke-dasharray":this.ring_perimeter,"stroke-dashoffset":(-1*this.ring_perimeter),"stroke-width":"4",transform:"rotate(-90)"}]}},getPlayButton:function(){this.play_button=this.play_button||new Ext.Container({cls:"play",listeners:{scope:this,afterrender:function(a){a.mon(a.getEl(),"click",this.onPlayButtonClick,this)}}});return this.play_button},getCancelButton:function(){this.cancel_button=this.cancel_button||new Ext.Container({cls:"cancel",html:_T("common","cancel"),listeners:{scope:this,afterrender:function(a){a.mon(a.getEl(),"click",this.onCancelButtonClick,this)}}});return this.cancel_button},onPlayButtonClick:function(){this.stopCountdown();this.callback();this.hide();this.module.getHeaderPanel().hideUpnextMode()},onCancelButtonClick:function(){this.stopCountdown();this.getCancelButton().hide();this.getEl().addClass("canceled");this.count=0},getDashOffset:function(a){return -1*this.ring_perimeter-this.ring_perimeter*a},refetchRingProgress:function(){var a=this.count/this.countdown;this.getRingProgress().getEl().query(".progress")[0].setAttribute("stroke-dashoffset",this.getDashOffset(a))},startCountdown:function(){this.stopCountdown();this.task_runner=new SYNO.SDS.TaskRunner();this.polling_status=this.task_runner.createTask({scope:this,run:function(){this.count=this.count+this.interval;this.refetchRingProgress();if(this.count>=this.countdown){this.onPlayButtonClick()}},interval:this.interval});this.polling_status.start(true)},stopCountdown:function(){if(this.task_runner){this.count=0;this.refetchRingProgress();this.polling_status=null;this.task_runner.destroy();this.task_runner=null}}});Ext.define("SYNO.VideoController2.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.VideoController2.AppWindow"});Ext.define("SYNO.VideoController2.AppWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(b){var a={dsmStyle:"v5",showHelp:false,cls:"syno-vc-appwin",minHeight:480,minWidth:720,stop_callback_sync:true,items:[this.getBufferView(),this.getBackdropView(),this.getHeaderPanel(),this.getDisplay(),this.getControlPanel(),this.getUpnextView()],listeners:{scope:this,show:this.onMainWindowShow,afterrender:function(){this.initTask();this.bindKeyboardEvent();this.bindMouseEvent();this.bindAppwinResize()}}};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vc-win");this.addClass("show-panels");this.addClass("backdrop");if(_S("standalone")){this.onModalWindowResize();Ext.EventManager.onWindowResize(this.onModalWindowResize,this)}},onMainWindowShow:Ext.emptyFn,onModalWindowResize:function(){var b=0,a=0;this.setPosition(b,a);this.setSize(Ext.lib.Dom.getViewWidth()-b*2,Ext.lib.Dom.getViewHeight()-a*2)},getBufferView:function(){if(!Ext.isDefined(this.buffer_view)){this.buffer_view=new SYNO.VideoController2.BufferView({module:this})}return this.buffer_view},getBackdropView:function(){if(!Ext.isDefined(this.backdrop_view)){this.backdrop_view=new SYNO.VideoController2.BackdropView({module:this})}return this.backdrop_view},getUpnextView:function(){if(!Ext.isDefined(this.upnext_view)){this.upnext_view=new SYNO.VideoController2.UpnextView({module:this})}return this.upnext_view},getHeaderPanel:function(){if(!Ext.isDefined(this.header_panel)){this.header_panel=new SYNO.VideoController2.HeaderPanel({module:this})}return this.header_panel},getDisplay:function(){if(!Ext.isDefined(this.display)){this.display=new SYNO.VideoController2.Display()}return this.display},getControlPanel:function(){if(!Ext.isDefined(this.control_panel)){this.control_panel=new SYNO.VideoController2.ControlPanel({module:this})}return this.control_panel},getControlsBar:function(){return this.getControlPanel().getControlsBar()},getProgressBar:function(){return this.getControlPanel().getProgressBar()},getOptionsBar:function(){return this.getControlPanel().getOptionsBar()},getSettingsMenu:function(){return this.getOptionsBar().getSettingsButton().getSettingsMenu()},getController:function(){if(!Ext.isDefined(this.controller)){var a=this.getControlPanel();this.controller=new SYNO.VideoController2.Controller({appWin:this,container:this.getDisplay().getEl(),video:this.getDisplay().getComponent("video_display").getComponent("video").getEl(),jsBaseURL:String.format("{0}/controller/ui",this.jsConfig.jsBaseURL),init_player_id:this.init_player_id,init_subtitle_id:this.init_subtitle_id,init_audiotrack_id:this.init_audiotrack_id,type_info:this.type_info,video_info:this.video_info,dtv_url:this.dtv_url,listeners:{busy:this.setStatusBusy.createDelegate(this),clear:this.clearStatusBusy.createDelegate(this),rawdisabled:this.onRawDisabled.createDelegate(this),capabilityready:this.onCapabilityReady.createDelegate(this),channellistready:this.onChannelListReady.createDelegate(this),videolistready:this.onVideoListReady.createDelegate(this),playerlistchange:this.onPlayerListChange.createDelegate(this),playerdecided:this.onPlayerDecided.createDelegate(this),targetchange:this.onTargetChange.createDelegate(this),titlechange:this.onTitleChange.createDelegate(this),videochange:this.onVideoChange.createDelegate(this),statechange:this.setState.createDelegate(this),mutechange:a.setMute.createDelegate(a),volumechange:a.setVolume.createDelegate(a),timechange:this.setTime.createDelegate(this),subtitlechange:this.setSubtitle.createDelegate(this),discoverchange:this.onDiscoverChange.createDelegate(this)}})}return this.controller},onDiscoverChange:function(a){this.getSettingsMenu().getSubtitlePanel().setItemVisible(SYNO.VideoController2.Util.SUBTITLE_DISCOVER,a);if(a){this.getController().setSubtitle(SYNO.VideoController2.Util.SUBTITLE_DISCOVER,false)}else{this.getController().setSubtitle(this.init_subtitle_id,false)}},setSubtitle:function(b,a){this.getDisplay().showSubtitle(b);this.getDisplay().setSubtitleSize(this.getController().getSubtitleSize());this.getSettingsMenu().getSubtitlePanel().setDefault(a);this.getSettingsMenu().getSubtitlePanel().setItemSelected(a)},setTime:function(a,b){if(this.getController().isSubtitleVisible()){var c=this.getController().getSubtitleParser().getText(a-this.getController().getDelayedTime());this.getDisplay().setSubtitle((a===0)?"":c)}this.getController().updateWatchedPosition(a);this.getControlPanel().setTime(a,b)},setState:function(b,c){var a=this.getController().isRemoteMode();this.getBufferView().setState(b);this.getBackdropView().setState(b,c,a);this.getDisplay().setState(b,c);this.getControlPanel().setState(b,c)},hasModalWin:function(){return(this.modalWin!==null&&this.modalWin.length>0)},onRawDisabled:function(a,c){var b=c;if(c===null){b=a?"hd_high":null}this.getSettingsMenu().getQualityPanel().setRawDisabled(a);this.getSettingsMenu().getQualityPanel().selectProfile(b);this.getSettingsMenu().getQualityPanel().setDefault(b)},onCapabilityReady:function(c,a,b){if(!a){this.getSettingsMenu().getQualityPanel().hide();this.getSettingsMenu().getAudioTrackPanel().hide();return}if(!c||(this.dtv_url&&!b)){this.getSettingsMenu().getQualityPanel().hide()}else{this.getSettingsMenu().getQualityPanel().setTranscodeDisabled(false);this.getSettingsMenu().getQualityPanel().selectProfile(this.getController().profile)}},onChannelListReady:function(a){var b=this.getOptionsBar().getChannelButton();b.enable();b.menu.setChannelList(a,this.getController().channel_id)},onVideoListReady:function(){this.mon(this.getDisplay().getComponent("video_display"),"resize",function(){this.getController().rotateVideo()},this)},onPlayerListChange:function(a){this.getSettingsMenu().getPlayerPanel().setList(a,this.getController().player_info.id)},onPlayerDecided:function(b,a){this.getSettingsMenu().getSubtitlePanel().setList(b,a);this.getDisplay().getVideoDisplay().getComponent("subtitle").setIsVLC(a);if(a&&!Ext.isMac){this.addClass("vlc")}else{this.removeClass("vlc")}},onTargetChange:function(a){if(this.isDestroyed){return}this.stopChromecast();this.getDisplay().setRemoteMode(this.getController().isRemoteMode(),a.title);this.getOptionsBar().getVolumeButton().setDisabled(true!==a.volume_adjustable);this.getSettingsMenu().getQualityPanel().setDisabled(SYNO.VideoController2.Util.PLAYERTYPE_UPNP===a.type);this.getSettingsMenu().getAudioTrackPanel().setDisabled(SYNO.VideoController2.Util.PLAYERTYPE_UPNP===a.type);var c=(SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY!==a.type)||this.getController().supportRemux();this.getSettingsMenu().getSubtitlePanel().setDisabled(!c);var b=!this.getController().isRemoteMode()&&SYNO.VideoController2.Util.isDomFullscreenSupported();this.getOptionsBar().getFullscreenButton().setDisabled(!b)},onVideoChange:function(f,d,e,c,b){this.getBackdropView().setBackdrop(e);this.getDisplay().setVideoInfo(e);this.getControlPanel().setPrevNext(f,d);var a=this.getController();this.getSettingsMenu().getSubtitlePanel().setList(b);if(a.supportRemux()){this.getSettingsMenu().getAudioTrackPanel().setList(c,a.audio_id)}},onTitleChange:function(a){this.setTitle(a);this.getHeaderPanel().getTitleText().setText(a)},registerOnExitHandler:function(){var b=this;this.backupDsmBeforeUnload();var a=function(){b.closeHandler();b.runDsmBeforeUnload()};this.setBeforeUnloadOrPageHide(a)},runDsmBeforeUnload:function(){if(Ext.isFunction(this.dsm_beforeunload)){this.dsm_beforeunload()}},backupDsmBeforeUnload:function(){if(Ext.isFunction(window.onbeforeunload)){this.dsm_beforeunload=window.onbeforeunload;window.onbeforeunload=null}},restoreDsmBeforeUnload:function(){if(Ext.isFunction(this.dsm_beforeunload)){window.onbeforeunload=this.dsm_beforeunload}},setBeforeUnloadOrPageHide:function(a){if(Ext.isSafari&&navigator.userAgent.match(/iPhone|iPad/i)){window.onpagehide=a}else{window.onbeforeunload=a}},registerCastApiHandler:function(){SYNO.VideoController2.Util.setCastApiAvailable(this.getController())},onOpen:function(c){this.callParent(arguments);this.registerOnExitHandler();var a=this.getControlPanel().getControlsBar();var b=this.getControlPanel().getOptionsBar();var d=b.getSettingsButton().getSettingsMenu();this.setStatusBusy();if(Ext.isString(c.dtv_url)){this.dtv_url=c.dtv_url;if(!Ext.isEmpty(Ext.util.Cookies.get("id"))){this.dtv_url+="_"+Ext.util.Cookies.get("id");if(!Ext.isEmpty(_S("SynoToken"))){this.dtv_url+="_"+_S("SynoToken")}}a.getPrevButton().hide();a.getNextButton().hide();b.getChannelButton().disable();b.getChannelButton().show();d.getAudioTrackPanel().hide();d.getSubtitlePanel().hide();d.getPlayerPanel().hide();d.getRepeatPanel().hide();this.getController().initSequenceDTV()}else{if(Ext.isDefined(c.video_id)){this.init_player_id=c.player_id;this.init_subtitle_id=c.subtitle_id;this.init_audiotrack_id=c.audiotrack_id;this.type_info={type:c.browse_type,sort_info:c.sort_info,id:parseInt(c.type_id,10)};this.video_info={id:parseInt(c.video_id,10),type:c.video_type,file_id:c.file_id,title:c.title};this.registerCastApiHandler();this.getController().initSequenceVideo()}else{if(Ext.isDefined(c.path)){this.getSettingsMenu().getPlayerPanel().hide();this.init_player_id=c.player_id;this.type_info={type:c.browse_type};this.video_info={path:c.path,type:c.video_type,symlink:Ext.isString(c.symlink)?c.symlink:null};this.getController().initSequenceVideo()}}}},onClose:function(){this.closeHandler();this.callParent(arguments)},closeHandler:function(){this.getController().unlink();this.getController().stop(Ext.emptyFn,this.stop_callback_sync);this.getController().closePlayers();this.stopChromecast();this.unbindAppwinResize();this.unbindKeyboardEvent();this.unbindMouseEvent();SYNO.VideoController2.Util.exitFullscreen()},stopChromecast:function(){if(this.getController().getPlayer().id===SYNO.VideoController2.Util.CHROMECAST_ID){this.getController().getChromecastPlayer().stopApp();this.getController().chromecast_player=null}},initTask:function(){SYNO.VideoController2.Util.hookDoLayout(this);if(SYNO.VideoController2.Util.isVideoControllerOnly()){this.getHeaderPanel().getCloseButton().hide()}this.pollingTask=this.addTask({interval:5000,scope:this,run:function(){if(this.isDestroyed){this.pollingTask.stop();return}if(this.getController().spaceenabled){document.activeElement.blur()}}}).start();if(!SYNO.VideoController2.Util.isPublicSharing()){this.preventTimeoutTask=this.addWebAPITask({interval:30000,single:false,api:"SYNO.VideoStation2.Misc",version:1,method:"reset_timeout",scope:this,callback:Ext.emptyFn}).start()}},bindAppwinResize:function(){this.mon(this,"resize",this.setVideoDisplayHeight,this)},unbindAppwinResize:function(){this.mun(this,"resize",this.setVideoDisplayHeight,this)},setVideoDisplayHeight:function(){var e=this.getDisplay().getVideoInfo();if(e.resolution){var b=e.resolution.height*this.getWidth()/e.resolution.width;var d=(this.getHeight()-b)/2;d=d>0?d:0;this.getDisplay().getVideoDisplay().getSubtitleDisplay().setSubtitleMarginBottom(d,this.isPanelsShow())}this.getSettingsMenu().setMenuHeight();if(!this.getEl().hasClass("vlc")){return}var a=this.getHeight();var c=80+56;this.getDisplay().getVideoDisplay().setHeight(a-c)},bindKeyboardEvent:function(){Ext.getBody().on("keydown",this.setBodyToggleFullscreen,this,{buffer:250});Ext.getBody().on("keydown",this.setBodyPlayPause,this,{buffer:100});Ext.getBody().on("keydown",this.setBodySeekInterval,this,{buffer:100});Ext.getBody().on("keydown",this.setBodyAdjustVolume,this,{buffer:100})},unbindKeyboardEvent:function(){Ext.getBody().un("keydown",this.setBodyToggleFullscreen,this);Ext.getBody().un("keydown",this.setBodyPlayPause,this);Ext.getBody().un("keydown",this.setBodySeekInterval,this);Ext.getBody().un("keydown",this.setBodyAdjustVolume,this)},setBodyToggleFullscreen:function(a){if(a.keyCode==Ext.EventObject.ENTER&&!this.hasModalWin()){this.getController().toggleFullscreen()}},setBodyPlayPause:function(a){if(a.keyCode==Ext.EventObject.SPACE&&this.getController().spaceenabled){this.getController().play()}},setBodySeekInterval:function(c){var a={"37":{none:-10,ctrl:-30,shift:-60},"39":{none:10,ctrl:30,shift:60}};if((c.keyCode==Ext.EventObject.LEFT||c.keyCode==Ext.EventObject.RIGHT)&&!this.hasModalWin()){var b=this.getFnKey(c);this.getController().seekInterval(a[c.keyCode][b])}},setBodyAdjustVolume:function(c){var a={"38":{none:10,ctrl:25,shift:50},"40":{none:-10,ctrl:-25,shift:-50}};if((c.keyCode==Ext.EventObject.UP||c.keyCode==Ext.EventObject.DOWN)&&!this.hasModalWin()){var b=this.getFnKey(c);this.getController().adjustVolume(a[c.keyCode][b])}},getFnKey:function(b){var a="none";if(b.ctrlKey&&!b.shiftKey){a="ctrl"}if(!b.ctrlKey&&b.shiftKey){a="shift"}return a},bindMouseEvent:function(){Ext.getBody().on("mousemove",this.setBodyMouseMove,this);this.getControlPanel().getEl().on("mouseover",this.setControlPanelMouseOver,this);this.getControlPanel().getEl().on("mouseout",this.setControlPanelMouseOut,this)},unbindMouseEvent:function(){Ext.getBody().un("mousemove",this.setBodyMouseMove,this);this.getControlPanel().getEl().un("mouseover",this.setControlPanelMouseOver,this);this.getControlPanel().getEl().un("mouseout",this.setControlPanelMouseOut,this)},setBodyMouseMove:function(a){if(this.getMsgBox().isVisible()){this.hidePanels();return}this.getHidePanelsEvent().cancel();if(this.getEl().hasClass("hide-panels")){this.showPanels()}if(this.getController().state===SYNO.VideoController2.Util.STATE.PLAYING){this.getHidePanelsEvent().delay(2000)}},setControlPanelMouseOver:function(a){this.getControlPanel().setMouseOver(true)},setControlPanelMouseOut:function(a){this.getControlPanel().setMouseOver(false)},getHidePanelsEvent:function(){if(!Ext.isDefined(this.hide_panels)){this.hide_panels=new Ext.util.DelayedTask(function(){if(this.getController().state===SYNO.VideoController2.Util.STATE.PLAYING&&!this.hasModalWin()&&!this.getController().isRemoteMode()&&!this.getControlPanel().isMouseOver()&&!this.getOptionsBar().hasMenuVisible()){this.hidePanels()}},this)}return this.hide_panels},showPanels:function(){this.removeClass("hide-panels");this.addClass("show-panels");this.setVideoDisplayHeight()},hidePanels:function(){if(this.isDestroyed){return}this.removeClass("show-panels");this.addClass("hide-panels");this.setVideoDisplayHeight()},isPanelsShow:function(){if(this.isDestroyed){return}return this.getEl().hasClass("show-panels")},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.VideoController2.MessageBox({owner:a})}return this.callParent(arguments)}});