#!/bin/sh
. /var/packages/VideoStation/scripts/common

SYNO_VIDEO_CONTROLLER_D=synovpcd
FULL_SYNO_VIDEO_CONTROLLER_D="${PACKAGE_DIR}/target/sbin/${SYNO_VIDEO_CONTROLLER_D}"

case $1 in
	start)
		pidof ${SYNO_VIDEO_CONTROLLER_D} > /dev/null 2>&1
		if [ $? -eq "0" ]; then
			killall -s KILL ${SYNO_VIDEO_CONTROLLER_D} > /dev/null 2>&1
			sleep 1
		fi
		echo "Starting video controller daemon ..."
		${FULL_SYNO_VIDEO_CONTROLLER_D}
		;;
	stop)
		echo "Stopping video controller daemon ..."
		killall -s TERM ${SYNO_VIDEO_CONTROLLER_D} > /dev/null 2>&1
		;;
	restart)
		$0 stop
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
		;;
esac

