#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

PSQL="/usr/bin/psql"
Script="/var/packages/VideoStation/target/scripts/sql/upgrade/006_watch_status_view_and_tz_adjust.pgsql"

ExecSqlCommand()
{
	${PSQL} -U VideoStation video_metadata -c "$1" > /dev/null 2>&1
}

GenerateScript()
{
	local time_zone="`/bin/get_key_value /etc/synoinfo.conf timezone`"
	local script_tpl="${Script}.tpl"
	local sed_cmd=""
	if [ -n ${time_zone} ]; then
		sed_cmd="s/__SYSTEM_TIME_ZONE__/Timezone\/${time_zone}/g"
	else
		sed_cmd="s/__SYSTEM_TIME_ZONE__/GMT/g"
	fi

	cat ${script_tpl} | sed "${sed_cmd}" > ${Script}
}

DATABASE="video_metadata"
VIEW="watch_status_view"

echo "test $VIEW view in $DATABASE DB"
ExecSqlCommand "SELECT * FROM $VIEW LIMIT 1"
Ret=$?
if [ $Ret = 1 ]; then
	GenerateScript

	echo "Create $VIEW view in $DATABASE DB"
	${PSQL} -U VideoStation ${DATABASE} < ${Script}
	if [ $? != 0 ]; then
		echo "Failed to create $VIEW view in $DATABASE DB"
		exit
	fi
fi
