BEGIN;

CREATE TABLE library (
	id serial NOT NULL,
	title varchar(255) NOT NULL,
	type video_type NOT NULL,
	is_public boolean NOT NULL DEFAULT true,
	CONSTRAINT library_pkey PRIMARY KEY (id),
	CONSTRAINT library_ukey UNIQUE (title)
)
WITHOUT OIDS;

CREATE TYPE privilege_type AS ENUM ('none', 'read_only', 'read_write');
CREATE TABLE library_privilege (
	id serial NOT NULL,
	uid bigint NOT NULL,
	library_id int NOT NULL,
	type privilege_type NOT NULL,

	CONSTRAINT privilege_pkey PRIMARY KEY (id),
	CONSTRAINT privilege_ukey UNIQUE (uid, library_id),
	CONSTRAINT privilege_library_fkey FOREIGN KEY (library_id)
		REFERENCES library (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;
CREATE INDEX library_privilege_idx ON library_privilege USING btree (uid);

ALTER TABLE movie ADD COLUMN library_id int;
ALTER TABLE movie ADD CONSTRAINT movie_library_fkey FOREIGN KEY (library_id)
	REFERENCES library (id) MATCH SIMPLE
	ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE movie DROP CONSTRAINT movie_ukey;
ALTER TABLE movie ADD CONSTRAINT movie_ukey UNIQUE (library_id, title, year);

ALTER TABLE tvshow ADD COLUMN library_id int;
ALTER TABLE tvshow ADD CONSTRAINT tvshow_library_fkey FOREIGN KEY (library_id)
		REFERENCES library (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE tvshow DROP CONSTRAINT tvshow_ukey;
ALTER TABLE tvshow ADD CONSTRAINT tvshow_ukey UNIQUE (library_id, title, year);

ALTER TABLE tvshow_episode ADD COLUMN library_id int;
ALTER TABLE tvshow_episode ADD CONSTRAINT tvshow_episode_library_fkey FOREIGN KEY (library_id)
		REFERENCES library (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE home_video ADD COLUMN library_id int;
ALTER TABLE home_video ADD CONSTRAINT home_video_library_fkey FOREIGN KEY (library_id)
		REFERENCES library (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE home_video DROP CONSTRAINT home_video_ukey;
ALTER TABLE home_video ADD CONSTRAINT home_video_ukey UNIQUE (library_id, title, record_time);

COMMIT;
