BEGIN;

CREATE TABLE collection_sharing (
	id varchar(64) NOT NULL,
	collection_id integer NOT NULL,
	avail_date date NOT NULL DEFAULT '1970-01-01',
	exp_date date NOT NULL DEFAULT '1970-01-01',
	permanent boolean NOT NULL DEFAULT true,
	CONSTRAINT sharing_pkey PRIMARY KEY (id),
	CONSTRAINT sharing_ukey UNIQUE (collection_id),
	CONSTRAINT sharing_collection_id_fkey FOREIGN KEY (collection_id)
		REFERENCES collection (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE TABLE collection_smart (
	collection_id integer NOT NULL,
	type varchar(16) NOT NULL,
	has_default_library boolean NOT NULL DEFAULT true,
	filter text NOT NULL,

	CONSTRAINT smart_pkey PRIMARY KEY (collection_id),
	CONSTRAINT smart_collection_id_fkey FOREIGN KEY (collection_id)
		REFERENCES collection (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE TABLE collection_has_library (
	collection_id integer NOT NULL,
	library_id integer NOT NULL,

	CONSTRAINT has_library_ukey UNIQUE (collection_id, library_id),
	CONSTRAINT has_library_collection_id_fkey FOREIGN KEY (collection_id)
		REFERENCES collection (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT has_library_library_id_fkey FOREIGN KEY (library_id)
		REFERENCES library (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

ALTER TABLE collection ADD COLUMN is_smart boolean NOT NULL DEFAULT false;

CREATE VIEW original_collection_video_list AS
	(SELECT 0 AS type, UPPER(sort_title) AS title, 0 AS season, 0 AS episode, mapper_id, sort_time FROM movie) UNION
	(SELECT 2 AS type, UPPER(sort_title) AS title, 0 AS season, 0 AS episode, mapper_id, record_time AS sort_time FROM home_video) UNION
	(SELECT 3 AS type, UPPER(sort_title) AS title, 0 AS season, 0 AS episode, mapper_id, record_time AS sort_time FROM tv_record) UNION
	(SELECT 1 AS type, tv.t AS title, season, episode, mapper_id, sort_time FROM tvshow_episode LEFT JOIN (SELECT id, UPPER(sort_title) AS t FROM tvshow) as tv ON tvshow_episode.tvshow_id = tv.id);

CREATE VIEW tvshow_episode_with_title AS
	SELECT e.id, e.tvshow_id, e.library_id, e.mapper_id, e.tag_line, e.season, e.episode,
	       e.year, e.originally_available, e.sort_time, e.islock, e.create_date, e.modify_date, tv.sort_title FROM tvshow_episode AS e
	LEFT JOIN (SELECT id, UPPER(sort_title) AS sort_title FROM tvshow) AS tv ON e.tvshow_id = tv.id;

COMMIT;
