#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.
VIDEO_METADATA_DB="video_metadata"

PG_SCRIPT="/var/packages/VideoStation/target/scripts/sql/video_metadata.pgsql"
CREATE_DB="/usr/bin/createdb"
PSQL="/usr/bin/psql"
UPGRADE_DIR="/var/packages/VideoStation/target/scripts/sql/upgrade"
SETUP_HANDLER="/var/packages/VideoStation/target/bin/db_setup_handler"

Upgrade=0

echo "Update video_file table where video id = 0 to test db existence"
$PSQL -U postgres $VIDEO_METADATA_DB -c "UPDATE video_file SET duration = 0 WHERE id = 0"
Ret=$?
if [ $Ret = 2 ]; then
   $CREATE_DB -U postgres $VIDEO_METADATA_DB
   if [ $? != 0 ]; then
      echo "Failed to create database"
      exit
   fi
   Ret=1
fi

if [ $Ret = 1 ]; then
   $PSQL -U postgres $VIDEO_METADATA_DB -f $PG_SCRIPT
   if [ $? != 0 ]; then
      echo "Failed to create tables in video_metadata database"
      exit
   fi
fi

upgrades=`find $UPGRADE_DIR -name "*.sh" | sort`
for ThisArg in $upgrades;
do
	$ThisArg
	Ret=$?
	if [ $Ret = 1 ]; then
		NeedReindex=1
	fi
done

$SETUP_HANDLER
if [ $? != 0 ]; then
  echo "Failed to setup database"
  exit
fi
