/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.VideoStation2.Capability",{extend:"Ext.util.Observable",statics:{EVENT_CAPABILITY_READY:"capabilityready",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Capability.instance)){SYNO.SDS.VideoStation2.Capability.instance=new SYNO.SDS.VideoStation2.Capability()}return SYNO.SDS.VideoStation2.Capability.instance}},constructor:function(){this.callParent(arguments)},loadCapability:function(a){a=a||{};a.privilege=a.privilege||{};this.remux=a.support_remux===true;this.transcode=a.support_transcode===true;this.hardware_transcode=a.support_hardware_transcode===true;this.dtv=a.privilege.dtv===true;this.renderer=a.privilege.renderer===true;this.sharing=a.privilege.sharing===true;this.fireEvent(SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY)},ableToRemux:function(){return this.remux},ableToTranscode:function(){return this.transcode},ableToHardwareTranscode:function(){return this.hardware_transcode},ableToControlDTV:function(){return this.dtv},ableToControlRenderer:function(){return this.renderer},ableToControlSharing:function(){return this.sharing},remux:false,transcode:false,hardware_transcode:false,dtv:false,renderer:false,sharing:false});Ext.define("SYNO.SDS.VideoStation2.Button",{extend:"SYNO.ux.Button",xtype:"syno_vs_button",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-button")}});Ext.define("SYNO.SDS.VideoStation2.MessageBox",{extend:"SYNO.SDS.MessageBoxV5",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-msgbox")},onRender:function(){this.callParent(arguments);this.progressBar.addClass("syno-vs2-progress")},getButtons:function(){var a=this.callParent(arguments);a.each(function(b){b.addClass("syno-vs2-button")});return a}});Ext.define("SYNO.SDS.VideoStation2.Dialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){b=b||{};b.owner=b.owner||SYNO.SDS.VideoStation2.Window;var a=Ext.isString(b.cls)?(b.cls+" syno-vs2-dialog"):"syno-vs2-dialog";b.cls=a;this.callParent([b])},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Error",{singleton:true,VIDEO_STATION_ERROR:{400:_VST("error","download_failed"),417:_VST("error","image_format"),418:String.format(_VST("error","image_too_big"),4),431:_VST("playlist","error_name_duplicated")},getAPIErrorString:function(c){var b=100;if(Ext.isNumber(c)){b=c}else{if(Ext.isObject(c)){var a=SYNO.API.Util.GetFirstError(c)||c;b=Ext.isNumber(a.code)?a.code:100}}if(b<400){return SYNO.API.Errors.common[b]||_T("error","error_error_system")}return SYNO.SDS.VideoStation2.Error.VIDEO_STATION_ERROR[b]||_T("error","error_error_system")},getErrorInfoString:function(a,b){if(!Ext.isObject(a)){return b}if(a.success===true){return""}var d;var c=a.errinfo||{};if(c.sec&&c.key){d=_VST(c.sec,c.key)||_T(c.sec,c.key)||String.format("{0}:{1}",c.sec,c.key)}else{d=_T("error","error_error_system")}if(Ext.isNumber(c.line)){d=String.format("{0} ({1})",d,c.line)}return d}});Ext.define("SYNO.SDS.VideoStation2.Filter",{statics:{EVENT_FILTER_CHANGE:"filterchange",FILTER_ACTOR:"actor",FILTER_DIRECTOR:"director",FILTER_GENRE:"genre",FILTER_WRITER:"writer",FILTER_CERTIFICATE:"certificate",FILTER_YEAR:"year",FILTER_RESOLUTION:"resolution",FILTER_WATCHED_STATUS:"watchedstatus",FILTER_FILE_COUNT:"filecount",FILTER_CONTAINER:"container",FILTER_DURATION:"duration",FILTER_DATE:"date",FILTER_CHANNEL_NAME:"channel_name",FILTER_TITLE:"title",FILTER_KEYWORD:"keyword",DATA_RESOLUTION:[{key:_VST("filter","resolution_sd"),value:{x_from:-1,x_to:1024,y_from:-1,y_to:576}},{key:"720p",value:{x_from:1024,x_to:1280,y_from:576,y_to:720}},{key:String.format(_VST("filter","andabove"),"1080p"),value:{x_from:1280,x_to:-1,y_from:720,y_to:-1}}],DATA_WATCHED_STATUS:[{key:_VST("advanced","unwatched"),value:"unwatched"},{key:_VST("advanced","watching"),value:"watching"},{key:_VST("advanced","watched"),value:"watched"}],DATA_FILE_COUNT:[{key:_VST("filter","singlefile"),value:"single"},{key:_VST("filter","multiplefile"),value:"multiple"}],DATA_DURATION:[{key:String.format(_VST("filter","andbelow"),"10 "+_VST("common","minutes")),value:{from:0,to:10}},{key:String.format("{0} ~ {1} {2}","10","30",_VST("common","minutes")),value:{from:10,to:30}},{key:String.format("{0} ~ {1} {2}","30","60",_VST("common","minutes")),value:{from:30,to:60}},{key:String.format("{0} ~ {1} {2}","60","120",_VST("common","minutes")),value:{from:60,to:120}},{key:String.format(_VST("filter","andabove"),"120 "+_VST("common","minutes")),value:{from:120,to:-1}}],instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Filter.instance)){SYNO.SDS.VideoStation2.Filter.instance=new SYNO.SDS.VideoStation2.Filter()}return SYNO.SDS.VideoStation2.Filter.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE);this.current_filter={};this.current_keyword=""},addFilter:function(a,b){if(this.hasFilter(a,b)){return}this.current_filter[a]=this.current_filter[a]||[];this.current_filter[a].push(b);this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,a)},deleteFilter:function(a,b){if(!this.hasFilter(a,b)){return}this.current_filter[a]=this.current_filter[a].filter(function(c){return c.key!==b.key});if(this.current_filter[a].length===0){delete this.current_filter[a]}this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,a)},toggleFilter:function(a,b){if(this.hasFilter(a,b)){this.deleteFilter(a,b)}else{this.addFilter(a,b)}},hasFilter:function(a,b){if(!this.current_filter[a]){return false}var c=false;Ext.each(this.current_filter[a],function(d){if(d.key===b.key){c=true;return false}});return c},setKeyword:function(a){if(this.current_keyword===a){return}this.current_keyword=a;this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)},hasKeyword:function(){return !Ext.isEmpty(this.current_keyword)},clearFilter:function(a){if(a===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){if(this.hasKeyword()){this.current_keyword="";this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)}return}if(!this.current_filter[a]){return}delete this.current_filter[a];this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,a)},clearAllFilter:function(){Object.keys(this.current_filter).each(function(a){this.clearFilter(a)},this);this.clearFilter(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)},isFilterEmpty:function(){return Object.keys(this.current_filter).length===0},getFilter:function(a){return this.current_filter[a]},getFilterOption:function(a){var b={};Ext.iterate(this.current_filter,function(d,c){var e=c.map(function(f){return f.value});b[d]=(a)?e:Ext.encode(e)});return b},getKeywordOption:function(){var a={};if(this.hasKeyword()){a[SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD]=this.getKeyword()}return a},getKeyword:function(){return this.current_keyword},current_filter:null,current_keyword:null});function _VST(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}}Ext.define("SYNO.SDS.VideoStation2.Constant",{singleton:true,CLASS:{UNWATCHED:"unwatched"},EVENT:{PLAYLIST_CHANGE:"playlistchange",SHARING_STATUS_LOAD:"sharingstatusload",VIDEO_LOAD:"videoload",VIEW_LOADING:"viewloading",VIEW_LOADED:"viewloaded",VIEW_NOVIDEO:"viewnovideo",LOAD_PLAYER_OPTION:"loadplayeroption"},EXTRA:{KEY_RATING:"rating",KEY_REFERENCE:"reference"},PLAYLIST_TYPE:{ORIGINAL:"original",SMART:"smart"},REFRESH_INFO:{VIDEO:"video",SUBTITLE:"subtitle"},PLAYER_STREAMING:"streaming",TITLE_FAVORITE:"syno_favorite",TITLE_WATCHLIST:"syno_watchlist",COLLECTION:"collection",PLAYLIST:"playlist",MOVIE:"movie",TVSHOW:"tvshow",TVSHOW_EPISODE:"tvshow_episode",HOME_VIDEO:"home_video",TV_RECORDING:"tv_record",GETINFO_ADDITIONAL:["summary","file","actor","writer","director","extra","genre","collection","poster_mtime","watched_ratio","backdrop_mtime"],FOLDER:"folder",FILE:"file",VIDEO_PROFILE_ORIGINAL:"original",VIDEO_PROFILE_HIGH:"high",VIDEO_PROFILE_MEDIUM:"medium",VIDEO_PROFILE_LOW:"low",RESOLUTION_DEFINITION:{SD:{x_from:-1,x_to:640,y_from:-1,y_to:480},"480p":{x_from:640,x_to:1024,y_from:480,y_to:576},"720p":{x_from:1024,x_to:1280,y_from:576,y_to:720},"1080p":{x_from:1280,x_to:-1,y_from:720,y_to:-1}}});Ext.define("SYNO.SDS.VideoStation2.Util",{singleton:true,applyCallback:function(a){if(!Ext.isObject(a)||!Ext.isFunction(a.fn)){return}a.fn.apply(a.scope||window,a.args||[])},convertCollectionID:function(a){if(!Ext.isArray(a)){return a}return a.map(function(c){var d=parseInt(c.id,10);var b=c.title;if(SYNO.SDS.VideoStation2.Constant.TITLE_FAVORITE===b){d=-1}else{if(SYNO.SDS.VideoStation2.Constant.TITLE_WATCHLIST===b){d=-2}}return{id:d,title:c.title}})},getVideoActionString:function(a){return _VST("action",a)||_VST("controller",a)||_VST("advanced",a)||_VST(a,"action")},getFilterCategoryString:function(a){switch(a){case SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR:return _VST("actor","title");case SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR:return _VST("director","title");case SYNO.SDS.VideoStation2.Filter.FILTER_GENRE:return _VST("genre","title");case SYNO.SDS.VideoStation2.Filter.FILTER_WRITER:return _VST("writer","title");case SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE:return _VST("metadata","rating_classification");case SYNO.SDS.VideoStation2.Filter.FILTER_YEAR:return _VST("year","title");case SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION:return _VST("video_info","resolution");case SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS:return _VST("common","watch_status");case SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT:return _VST("filter","file_count");case SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER:return _VST("video_info","container");case SYNO.SDS.VideoStation2.Filter.FILTER_DURATION:return _VST("duration","title");case SYNO.SDS.VideoStation2.Filter.FILTER_DATE:return _VST("classification","bydate");case SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME:return _VST("classification","bychannlename");case SYNO.SDS.VideoStation2.Filter.FILTER_TITLE:return _VST("classification","bytitle");case SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD:return _VST("search","keyword");default:return""}},getAPIName:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.MOVIE:return"SYNO.VideoStation.Movie";case SYNO.SDS.VideoStation2.Constant.TVSHOW:return"SYNO.VideoStation.TVShow";case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return"SYNO.VideoStation.TVShowEpisode";case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return"SYNO.VideoStation.HomeVideo";case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return"SYNO.VideoStation.TVRecording";default:throw String.format("unexpected type {0}",a)}},getVideoRoot:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.MOVIE:return"movies";case SYNO.SDS.VideoStation2.Constant.TVSHOW:return"tvshows";case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return"episodes";case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return"videos";case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return"recordings";default:throw String.format("unexpected type {0}",a)}},getWebAPIURL:function(a){return String.format("{0}/{1}","webapi/VideoStation",a)},getCGIURL:function(a){return String.format("webman/3rdparty/VideoStation/cgi/{0}",a)},getImageURL:function(b){b=Ext.apply(b||{},{api:"SYNO.VideoStation.Poster",method:"getimage",version:"2"});if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(b,{hr:2})}var a=Ext.urlAppend(SYNO.SDS.VideoStation2.Util.getWebAPIURL("poster.cgi"),Ext.urlEncode(b));return a},getBackdropURL:function(b){b=Ext.apply(b||{},{api:"SYNO.VideoStation.Backdrop",method:"get",version:"1"});var a=Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode(b));return a},getVideoDate:function(a){if(Ext.isString(a.original_available)&&!Ext.isEmpty(a.original_available)){return a.original_available==="0"?"":a.original_available.split("-")[0]}else{if(Ext.isString(a.record_date)&&!Ext.isEmpty(a.record_date)){return a.record_date==="0"?"":a.record_date.split(" ")[0]}else{return""}}},hideDTVUI:function(){return SYNO.SDS.isNSM||_D("support_dual_head")==="yes"||SYNO.SDS.Utils.isInVirtualDSM()||_D("dockerdsm")==="yes"},isWatched:function(a){return Ext.isNumber(a)&&a===1},isUnwatched:function(a){return Ext.isNumber(a)&&Math.floor(a*100)===0},classifyVideos:function(a){var b={};a.each(function(c){b[c.type]=b[c.type]||[];b[c.type].push(c)});return b},formatBitrate:function(c){var b=parseInt(c,10);var a=(b/1024).toFixed(1);return String.format("{0} Kbps",a)},extractFileName:function(a){return a.substring(a.lastIndexOf("/")+1)},getShareData:function(d){var c=d;var a=c.indexOf("/",1);var b="";c=c.substr(1);if(a>0){b=c.substr(a);c=c.substr(0,a-1)}return{share:Ext.util.Format.lowercase(c),orishare:c,subpath:b}},getLangStore:function(){var b=SYNO.SDS.Utils.getSupportedLanguage(),a;a=new Ext.data.SimpleStore({fields:["value","display"],data:b,autoDestroy:true});return a},onProxyBeforeLoad:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}},getCombinationPosterDiv:function(b,a){if(!Ext.isArray(b)||!Ext.isFunction(a)){return""}if(1===b.length){return String.format('<div class="center loading" url="{0}"></div>',a(b[0]))}else{if(2===b.length){return[String.format('<div class="top loading" url="{0}"></div>',a(b[0])),String.format('<div class="bottom loading" url="{0}"></div>',a(b[1]))].join("")}else{if(3===b.length){return[String.format('<div class="top loading" url="{0}"></div>',a(b[0])),String.format('<div class="bottom-left loading" url="{0}"></div>',a(b[1])),String.format('<div class="bottom-right loading" url="{0}"></div>',a(b[2]))].join("")}else{if(4<=b.length){return[String.format('<div class="top-left loading" url="{0}"></div>',a(b[0])),String.format('<div class="top-right loading" url="{0}"></div>',a(b[1])),String.format('<div class="bottom-left loading" url="{0}"></div>',a(b[2])),String.format('<div class="bottom-right loading" url="{0}"></div>',a(b[3]))].join("")}}}}return""},getWatchStatusDiv:function(c){var a=c.additional||{};if(Ext.isDefined(a.total_seasons)){return""}var b=a.watched_ratio||0;b=(0===b?0:Math.floor(b*100));if(100===b){return""}return['<div class="watch-status-wrap">','<div class="grey-bar"></div>',String.format('<div class="blue-bar" style="width:{0}%"></div>',b),"</div>"].join("")},mask:function(c,h,b,g,e){var f;if(!c||!(f=c.getEl())){return}if(f.delayedUnmask){f.delayedUnmask.cancel();f.delayedUnmask=null}f.mask.apply(f,Array.prototype.slice.call(arguments,1,3));var a=f.down(".ext-el-mask");a.addClass("syno-vs2-el-mask");if(Ext.isFunction(g)){var d=f.down(".ext-el-mask-msg div");d.addClass("clickable");d.on("click",g)}if(!f.delayedMask){f.delayedMask=new Ext.util.DelayedTask(function(){if(a&&a.dom){a.addClass("mask")}f.delayedMask=null})}f.delayedMask.delay(e||1)},delayMask:function(b,d,a,c){SYNO.SDS.VideoStation2.Util.mask(b,d,a,c,500)},unmask:function(b){var c;if(!b||!(c=b.getEl())){return}if(c.delayedMask){c.delayedMask.cancel();c.delayedMask=null}var a=c.down(".ext-el-mask");if(!a){return}if(!c.delayedUnmask){a.addClass("unmask");c.delayedUnmask=new Ext.util.DelayedTask(function(){c.unmask();c.delayedUnmask=null})}c.delayedUnmask.delay(300)},maskLoading:function(b,c){var d=_T("common","loading");var a="x-mask-loading syno-vs2-mask-loading";SYNO.SDS.VideoStation2.Util[c?"delayMask":"mask"](b,d,a)},maskInfo:function(b,e,d,c){var a="syno-ux-mask-info syno-vs2-mask-info";SYNO.SDS.VideoStation2.Util[c?"delayMask":"mask"](b,e,a,d)},findValueInObject:function(c,a){var b;Ext.iterate(c,function(e,d){if(e===a){b=d;return false}if(Ext.isObject(d)){var f=SYNO.SDS.VideoStation2.Util.findValueInObject(d,a);if(Ext.isDefined(f)){b=f;return false}}});return b},launchHelp:function(){SYNO.SDS.WindowLaunch("SYNO.SDS.HelpBrowser.Application",{topic:"SYNO.SDS.VideoStation.AppInstance"})}});Ext.define("SYNO.SDS.VideoStation2.FilteringBaseHttpProxy",{extend:"Ext.data.HttpProxy",constructor:function(a){this.callParent([a])},onRead:function(d,g,b){try{var c=Ext.decode(b.responseText);var a=g.reader.getRoot(c);Ext.each(a,function(e){if(e.additional&&e.additional.collection){e.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(e.additional.collection)}},this);b.responseText=Ext.encode(c);this.callParent(arguments)}catch(f){this.fireEvent("loadexception",this,g,b,f);this.fireEvent("exception",this,"response",d,g,b,f);return}}});Ext.define("SYNO.SDS.VideoStation2.ByFolderHttpProxy",{extend:"Ext.data.HttpProxy",constructor:function(a){this.callParent([a])},onRead:function(f,h,b){try{var d=Ext.decode(b.responseText);var a=h.reader.getRoot(d);var c=0;Ext.each(a,function(e){if(e.additional&&e.additional.collection){e.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(e.additional.collection)}if(SYNO.SDS.VideoStation2.Constant.FOLDER===e.type){c=c+1}},this);if(0<c){a[c-1].last_folder=true}b.responseText=Ext.encode(d);this.callParent(arguments)}catch(g){this.fireEvent("loadexception",this,h,b,g);this.fireEvent("exception",this,"response",f,h,b,g);return}}});Ext.define("SYNO.SDS.VideoStation2.FilterMetadataHttpProxy",{extend:"Ext.data.HttpProxy",constructor:function(a){this.callParent([a])},onRead:function(c,f,a){try{var b=Ext.decode(a.responseText);if(Ext.isObject(b),Ext.isObject(b.data)&&Ext.isArray(b.data.metadatas)){b.data.metadatas=b.data.metadatas.map(function(e){return{key:e,value:e}});a.responseText=Ext.encode(b)}this.callParent(arguments)}catch(d){this.fireEvent("loadexception",this,f,a,d);this.fireEvent("exception",this,"response",c,f,a,d);return}}});Ext.define("SYNO.SDS.VideoStation2.Library",{statics:{EVENT_LIBRARY_LOAD:"libraryload",EVENT_LIBRARY_CHANGED:"librarychanged",DEFAULT_LIBRARY:[{id:0,title:_VST("playlist","title"),type:SYNO.SDS.VideoStation2.Constant.PLAYLIST},{id:0,title:_VST("type","movie"),type:SYNO.SDS.VideoStation2.Constant.MOVIE},{id:0,title:_VST("type","tv_show"),type:SYNO.SDS.VideoStation2.Constant.TVSHOW},{id:0,title:_VST("type","home_video"),type:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO},{id:0,title:_VST("type","tv_recorder"),type:SYNO.SDS.VideoStation2.Constant.TV_RECORDING}],instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Library.instance)){SYNO.SDS.VideoStation2.Library.instance=new SYNO.SDS.VideoStation2.Library()}return SYNO.SDS.VideoStation2.Library.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED);this.prepareDefaultLibrary();this.cursor=this.default_library[1].get("opid");this.current_id=this.default_library[1].get("id");this.current_type=this.default_library[1].get("type")},getLibraryStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.LibraryStore({appWindow:SYNO.SDS.VideoStation2.Window,listeners:{scope:this,load:this.onLibraryLoad}});return this.store},loadLibrary:function(){this.getLibraryStore().load()},onLibraryLoad:function(){this.store.insert(0,this.default_library);this.store.commitChanges();this.updateCurrentDataByCursor();this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD)},prepareDefaultLibrary:function(){if(Ext.isEmpty(this.default_library)){var a=SYNO.SDS.VideoStation2.Library.DEFAULT_LIBRARY.filter(function(b){return !(b.type===SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&SYNO.SDS.VideoStation2.Util.hideDTVUI())});this.default_library=a.map(function(b){return new SYNO.SDS.VideoStation2.LibraryStore.Record(Ext.apply(b,{opid:SYNO.SDS.VideoStation2.LibraryStore.convertOPID(b)}))})}},updateCurrentDataByCursor:function(){this.current_id=null;this.current_type=null;var a=this.cursor||this.tmp_cursor;this.store.each(function(d,b,c){if(d.get("opid")===a){this.current_id=d.get("id");this.current_type=d.get("type");return false}return true},this)},activate:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted library opid {0}",a));this.cursor=a;this.tmp_cursor=null;this.updateCurrentDataByCursor();this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED)},activateTemporary:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted library opid {0}",a));this.tmp_cursor=a;this.updateCurrentDataByCursor();this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED)},activateFromTemporary:function(){this.activate(this.tmp_cursor)},isDeactivated:function(){return Ext.isEmpty(this.cursor)},getCurrentID:function(){return this.current_id},getCurrentType:function(){return this.current_type},getLibraryByFn:function(b){var a=null;this.store.each(function(c){if(b(c)){a=SYNO.Util.copy(c.data);return false}});return a},getLibraryByOPID:function(a){return this.getLibraryByFn(function(b){return b.get("opid")===a})},getLibraryByIDAndType:function(b,a){return this.getLibraryByFn(function(c){return c.get("id")===b&&c.get("type")===a})},getAllLibraries:function(){var a=[];this.store.each(function(c){var b=c.get("type");if(b===SYNO.SDS.VideoStation2.Constant.PLAYLIST||b===SYNO.SDS.VideoStation2.Constant.TV_RECORDING){return}a.push(SYNO.Util.copy(c.data))});return a},getCurrentVideoType:function(){var a=this.getCurrentType();return(a===SYNO.SDS.VideoStation2.Constant.TVSHOW)?SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:a},getDefaultLibraryNumber:function(){return this.default_library.length},cursor:null,tmp_cursor:null,current_id:null,current_type:null});Ext.define("SYNO.SDS.VideoStation2.LibraryStore",{statics:{convertOPID:function(a){return String.format("{0}-{1}",a.type,a.id)},Record:Ext.data.Record.create([{name:"id",type:"int"},{name:"title",type:"string"},{name:"type",type:"string"},{name:"is_public",type:"boolean"},{name:"opid",type:"string",convert:function(b,a){return SYNO.SDS.VideoStation2.LibraryStore.convertOPID(a)}}])},extend:"SYNO.API.Store",constructor:function(b){var a={api:"SYNO.VideoStation.Library",method:"list",version:1,reader:new Ext.data.JsonReader({root:"libraries",idProperty:"opid"},SYNO.SDS.VideoStation2.LibraryStore.Record)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Stores",{extend:"SYNO.API.Store",statics:{CONFIG:{paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"}}},proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseHttpProxy",readerClass:"Ext.data.JsonReader",constructor:function(c){c=c||{};var b=Ext.apply(this.baseConfigs.reader,c.readerCfg);var a={method:"POST",proxy:new (Ext.getClassByName(c.proxyClass||this.proxyClass))({url:this.baseConfigs.url,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),baseParams:Ext.apply({},this.baseConfigs.baseParams),paramNames:SYNO.SDS.VideoStation2.Stores.CONFIG.paramNames,reader:new (Ext.getClassByName(this.readerClass))(b)};if(c.baseParams){Ext.applyIf(c.baseParams,this.baseConfigs.baseParams)}Ext.apply(a,c);this.callParent([a])}});Ext.define("SYNO.SDS.VideoStation2.Stores.movie",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("movie.cgi"),baseParams:{api:"SYNO.VideoStation.Movie",version:"2",method:"list",additional:Ext.encode(["poster_mtime","summary","watched_ratio","collection"])},reader:{id:"id",root:"data.movies",totalProperty:"data.total",fields:["id","mapper_id","title","original_available","metadata_locked","additional","type","path","sharepath","file_count","last_watched","create_time"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.tvshow",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("tvshow.cgi"),baseParams:{api:"SYNO.VideoStation.TVShow",version:"2",method:"list",additional:Ext.encode(["poster_mtime","summary","backdrop_mtime"])},reader:{id:"id",root:"data.tvshows",totalProperty:"data.total",fields:["id","mapper_id","title","original_available","metadata_locked","additional","mapper_id","sort_title","last_watched","create_time"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.tvshow_episode",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("tvshow_episode.cgi"),baseParams:{api:"SYNO.VideoStation.TVShowEpisode",version:"2",method:"list",additional:Ext.encode(["summary","collection","poster_mtime","watched_ratio"])},reader:{id:"id",root:"data.episodes",totalProperty:"data.total",fields:["id","mapper_id","season","last_watched","episode","tagline","original_available","metadata_locked","additional","mapper_id","sort_title","create_time"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.home_video",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("homevideo.cgi"),baseParams:{api:"SYNO.VideoStation.HomeVideo",version:"2",method:"list",additional:Ext.encode(["summary","collection","poster_mtime","watched_ratio"])},reader:{id:"id",root:"data.videos",totalProperty:"data.total",fields:["id","mapper_id","title","record_date","additional","type","path","sharepath","file_count","last_watched","create_time"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.tv_record",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("tvrecord.cgi"),baseParams:{api:"SYNO.VideoStation.TVRecording",version:"2",method:"list",additional:Ext.encode(["summary","collection","poster_mtime","watched_ratio"])},reader:{id:"id",root:"data.recordings",totalProperty:"data.total",fields:["id","mapper_id","title","channel_name","record_date","additional","last_watched","create_time"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.playlist",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("collection.cgi"),baseParams:{api:"SYNO.VideoStation.Collection",version:"2",method:"list",offset:0,limit:-1,sort_by:"title",sort_direction:"ASC",preview_video:4,additional:Ext.encode(["sharing_info","filter_info"])},reader:{id:"id",root:"data.collections",totalProperty:"data.total",fields:["id","title","additional","type","preview_video"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.folder",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("folder.cgi"),baseParams:{api:"SYNO.VideoStation.Folder",version:"2",method:"list",preview_video:4,additional:Ext.encode(["poster_mtime","summary","watched_ratio","collection"])},reader:{id:"id",root:"data.objects",totalProperty:"data.total",fields:["id","title","additional","type","path","sharepath","file_count","preview_video","last_folder"]}},proxyClass:"SYNO.SDS.VideoStation2.ByFolderHttpProxy",constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.playlistvideolist",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("collection.cgi"),baseParams:{api:"SYNO.VideoStation.Collection",version:"2",method:"video_list",sort_by:"filename",sort_direction:"ASC",additional:Ext.encode(["summary","poster_mtime","watched_ratio","collection"])},reader:{id:"mapper_id",root:"data.videos",totalProperty:"data.total",fields:["id","mapper_id","title","type","metadata_locked","additional","season","episode","tagline","library_id","original_available","record_date","date"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.filter",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("metadata.cgi"),baseParams:{api:"SYNO.VideoStation.Metadata",version:"2",method:"list",sort:"name",dir:"ASC"},reader:{id:"key",root:"data.metadatas",totalProperty:"data.total",fields:["key","value"]}},proxyClass:"SYNO.SDS.VideoStation2.FilterMetadataHttpProxy",constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.metafilter",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("metadata.cgi"),baseParams:{api:"SYNO.VideoStation.Metadata",version:"1",method:"list",sort:"name",dir:"ASC"},reader:{id:"id",root:"data.metadatas",totalProperty:"data.total",fields:["id","name"]}},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Stores.localfilter",{extend:"Ext.data.JsonStore",constructor:function(b){var a={id:"key",fields:["key","value"]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Stores.internet_search",{extend:"SYNO.SDS.VideoStation2.Stores",baseConfigs:{url:SYNO.SDS.VideoStation2.Util.getWebAPIURL("pluginsearch.cgi"),baseParams:{api:"SYNO.VideoStation.PluginSearch",version:"1",method:"list"},reader:{id:"id",root:"data.results",totalProperty:"data.total",fields:["title","certificate","tag_line","original_available","actor","director","genre","writer","summary","extra","tvshow_original_available","episode","season","tvshow_extra","tvshow_summary","tvshow_index"]}},sortInfo:{field:"title",direction:"ASC"},constructor:function(){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.Playlist",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded",TYPE_ORIGIONAL:"original",TYPE_SMART:"smart",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Playlist.instance)){SYNO.SDS.VideoStation2.Playlist.instance=new SYNO.SDS.VideoStation2.Playlist()}return SYNO.SDS.VideoStation2.Playlist.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)},getStore:function(){this.playlist_store=this.playlist_store||new SYNO.SDS.VideoStation2.Stores.playlist({listeners:{scope:this,load:function(b,a){var c=a.map(function(d){var e=d.data;switch(e.id){case -1:e.playlist_title=_VST("playlist","favorite");break;case -2:e.playlist_title=_VST("playlist","watchlist");break;case -3:e.playlist_title=_VST("playlist","default_shared");break;default:e.playlist_title=e.title;break}return e});this.current_playlists=c;this.dirty=false;this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)}}});return this.playlist_store},loadPlaylists:function(){if(this.dirty){this.getStore().load()}else{this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)}},selectPlaylist:function(b,a){SYNO.Assert(Ext.isNumber(b)&&b>=-3,String.format("unexpceted playlist info {0}",b));this.current_id=b;this.current_path_title=a},markDirty:function(){this.dirty=true},getCurrentPlaylists:function(){return this.current_playlists},getCurrentID:function(){return this.current_id},getCurrentPathTitle:function(){return this.current_path_title},getPlaylistByID:function(a){if(!this.current_playlists){return undefined}return this.current_playlists.filter(function(b){return b.id===a})[0]},isDirty:function(){return this.dirty},current_id:null,current_path_title:null,current_playlists:null,dirty:true,playlist_store:null});Ext.define("SYNO.SDS.VideoStation2.OP",{statics:{defaultFailureCallback:function(d,c,a){var b=SYNO.SDS.VideoStation2.Error.getAPIErrorString(d);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",b)},sendRequest:function(d,h,b,f,g,a,c){var e=SYNO.API.Request({api:d,method:h,version:b,params:f,callback:function(l,k,j,i){if(!l){if(Ext.isFunction(e.failure_callback)){e.failure_callback.call(this,k,j,i)}else{SYNO.SDS.VideoStation2.OP.defaultFailureCallback(k,j,i)}return}if(Ext.isFunction(e.success_callback)){e.success_callback.call(this,k,j,i)}},scope:c});e.success_callback=g;e.failure_callback=a;return e},compound:function(g,f,b,e){f=Ext.isFunction(f)?f:Ext.emptyFn;b=Ext.isFunction(b)?b:Ext.emptyFn;e=e||window;var c=0;var a=0;var d=function(){if(c!==g.length){return}if(a===0){f.apply(e)}else{b.apply(e)}};g.each(function(j){var h=Ext.isFunction(j.success_callback)?j.success_callback:Ext.emptyFn;var i=Ext.isFunction(j.failure_callback)?j.failure_callback:Ext.emptyFn;j.success_callback=function(){h.apply(this,arguments);c+=1;d()};j.failure_callback=function(){i.apply(this,arguments);c+=1;a+=1;d()}})},abort:function(a){Ext.Ajax.abort(a)},classifyRequest:function(c,e,h,a,d){e=Ext.isFunction(e)?e:Ext.emptyFn;h=Ext.isFunction(h)?h:Ext.emptyFn;a=Ext.isFunction(a)?a:Ext.emptyFn;d=d||window;var g=SYNO.SDS.VideoStation2.Util.classifyVideos(c);var b=Object.keys(g);var f=b.map(function(i){return e.call(d,g,i)}).filter(function(i){return i});SYNO.SDS.VideoStation2.OP.compound(f,h,a,d)},pollingRequest:function(h,e,i,b,d){var f=null;var a=function(){if(f){SYNO.SDS.VideoStation2.OP.abort(f);f=null}f=SYNO.SDS.VideoStation2.OP.get()[h](c.params,i,d)};var c=SYNO.SDS.VideoStation2.Window.addTask({interval:b,run:a});var g=c.stop;c.stop=function(){if(f){Ext.Ajax.abort(f);f=null}g.apply(c,arguments)};c.params=e;c.start(true);return c},instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.OP.instance)){SYNO.SDS.VideoStation2.OP.instance=new SYNO.SDS.VideoStation2.OP()}return SYNO.SDS.VideoStation2.OP.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);var a={getVideoStationInfo:["SYNO.VideoStation.Info","getinfo",1],getInfo:[SYNO.SDS.VideoStation2.Util.getAPIName,"getinfo",2],addVideoToPlaylist:["SYNO.VideoStation.Collection","addvideo",2],removeVideoFromPlaylist:["SYNO.VideoStation.Collection","deletevideo",2],setVideoWatched:[SYNO.SDS.VideoStation2.Util.getAPIName,"set_watched",2],deleteVideo:[SYNO.SDS.VideoStation2.Util.getAPIName,"delete",3],deleteFile:["SYNO.VideoStation.Video","delete",2],getPublicSharing:["SYNO.VideoStation.Sharing","get",1],setPublicSharing:["SYNO.VideoStation.Sharing","set",1],createPlaylist:["SYNO.VideoStation.Collection","create",2],createSmartPlaylist:["SYNO.VideoStation.Collection","create_smart",2],deletePlaylist:["SYNO.VideoStation.Collection","delete",2],editPlaylist:["SYNO.VideoStation.Collection","edit",2],editSmartPlaylist:["SYNO.VideoStation.Collection","edit_smart",2],listPlayer:["SYNO.VideoController.Device","list",1],listMetadata:["SYNO.VideoStation.Metadata","list",2],searchSubtitle:["SYNO.VideoStation.Subtitle","search",3],downloadSubtitle:["SYNO.VideoStation.Subtitle","download",3],listAudioTrack:["SYNO.VideoStation.AudioTrack","list",1],setPoster:["SYNO.VideoStation.Poster","setimage",1],setBackdrop:["SYNO.VideoStation.Backdrop","add",1],editMetadata:[SYNO.SDS.VideoStation2.Util.getAPIName,"edit",1],startSearchMetadata:["SYNO.VideoStation.PluginSearch","start",1],listSearchMetadata:["SYNO.VideoStation.PluginSearch","list",1],querySearchMetadata:["SYNO.VideoStation.PluginSearch","query",1],stopSearchMetadata:["SYNO.VideoStation.PluginSearch","stop",1]};Ext.iterate(a,function(c,d,b){this[c]=function(h,j,e){var g=Ext.isFunction(d[0])?d[0](e):d[0];var i=d[1];var f=d[2];return SYNO.SDS.VideoStation2.OP.sendRequest(g,i,f,h,j.success,j.failure,j.scope)}},this)}});Ext.define("SYNO.SDS.VideoStation2.PlaylistController",{statics:{loadPlaylists:function(){SYNO.SDS.VideoStation2.Playlist.get().loadPlaylists()},doPlaylistRequest:function(d,c,a,f,e){a=Ext.isFunction(a)?a:Ext.emptyFn;f=Ext.isFunction(f)?f:Ext.emptyFn;e=e||window;var b=function(g){a.call(e,g);SYNO.SDS.VideoStation2.Playlist.get().markDirty();SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists()};SYNO.SDS.VideoStation2.OP.get()[d](c,{success:b,failure:f,scope:e})},addVideoToPlaylist:function(a,b,c){SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(a,b,true,c)},removeVideoFromPlaylist:function(a,b,c){SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(a,b,false,c)},setVideoWithPlaylist:function(b,c,a,e){var d=b.map(function(f){return{video_id:f.id,video_type:f.type}});SYNO.SDS.VideoStation2.OP.get()[(a)?"addVideoToPlaylist":"removeVideoFromPlaylist"]({id:c,video_collections:Ext.encode(d)},{success:e})},applyPlaylistChangeToVideo:function(b,c,a){b.each(function(e){if(!e.record){return}var d=e.record.get("additional");d.collection=d.collection||[];if(a){d.collection.push({id:c.id,title:c.title})}else{d.collection=d.collection.filter(function(f){return f.id!==c.id})}e.record.set("additional",d);e.record.commit()});SYNO.SDS.VideoStation2.Playlist.get().markDirty()},createPlaylistActions:function(f,j){var a=Ext.isFunction(f.clsFn)?f.clsFn:Ext.emptyFn;var d=Ext.isFunction(f.disabledFn)?f.disabledFn:Ext.emptyFn;var b=Ext.isFunction(f.createPlaylistFn)?f.createPlaylistFn:Ext.emptyFn;var c=Ext.isFunction(f.clickPlaylistFn)?f.clickPlaylistFn:Ext.emptyFn;var g=function(k){return -3!==k.id&&SYNO.SDS.VideoStation2.Constant.PLAYLIST_TYPE.ORIGINAL===k.type};var h=Ext.isFunction(f.filterPlaylistFn)?f.filterPlaylistFn:g;var e=[new Ext.Action({text:_VST("playlist","action_create"),scope:j,handler:b})];var i=SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists().filter(h);if(!i){return e}return e.concat(i.map(function(k){return new Ext.menu.Item({text:Ext.util.Format.htmlEncode(k.playlist_title),scope:j,itemId:k.id.toString(),cls:a.call(j,k)||"",hideOnClick:false,disabled:d.call(j,k)||false,handler:c})}))}}});Ext.define("SYNO.SDS.VideoStation2.Checkbox",{extend:"SYNO.ux.Checkbox",xtype:"syno_vs_checkbox",checkIconCls:"syno-vs2-checkbox syno-ux-checkbox-icon",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.FormPanel",{extend:"SYNO.ux.FormPanel",xtype:"syno_vs_form",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-form")}});Ext.define("SYNO.SDS.VideoStation2.TextField",{extend:"SYNO.ux.TextField",xtype:"syno_vs_textfield",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-textfield");this.addClass("syno-vs2-base-textfield")}});Ext.define("SYNO.SDS.VideoStation2.PlaylistSharingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",playlist:null,editable:null,constructor:function(b){var a={layout:"fit",width:450,height:(b.editable)?230:120,buttons:[this.doneBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.onDoneBtn}),this.openLinkBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","open_link"),scope:this,handler:this.onOpenLinkBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel(b)],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED,this.onPlaylistSharingChanged,this)},onAfterRender:function(){this.setTitle(String.format(_VST("playlist","link_to"),this.playlist.playlist_title));this.firePlaylistLoaded()},onDoneBtn:function(){if(!this.panel.isValid()){return}if(!this.panel.isDirty()){this.close();return}this.isFinalRequest=true;this.onPlaylistSharingChanged()},onOpenLinkBtn:function(){window.open(this.panel.getPublicSharingURL())},onPlaylistSharingChanged:function(){if(!this.panel.isValid()){return}this.setStatusBusy();var a=this.panel.getValues();a.id=this.playlist.id;SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editPlaylist",a,this.onPlaylistSharing,this.onPlaylistSharingFail,this)},onPlaylistSharing:function(){if(!this.waitingPlaylist){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)}this.waitingPlaylist=this.playlist.id},onPlaylistSharingFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onPlaylistLoaded:function(){this.clearStatusBusy();this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);if(this.isFinalRequest){this.close();return}this.playlist=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(this.waitingPlaylist);this.waitingPlaylist=null;this.firePlaylistLoaded()},firePlaylistLoaded:function(){var a=SYNO.Util.copy(this.playlist.additional.sharing_info);this.openLinkBtn.setDisabled(!a.enable_sharing);this.panel.fireEvent(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED,a)}});Ext.define("SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel",{statics:{EVENT_PLAYLIST_SHARING_CHANGED:"playlistsharingchanged",EVENT_PLAYLIST_SHARING_LOADED:"playlistsharingloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","action_share"),name:"enable_sharing",itemId:"enable_sharing",hidden:!b.editable,listeners:{scope:this,check:this.onEnableSharingChecked}},this.urlTextfield=new SYNO.SDS.VideoStation2.TextField({name:"url",cls:"selectabletext",itemId:"url",disabled:true,readOnly:true,selectOnFocus:true,hideLabel:true}),this.enableCustomizeDurationCheckbox=new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("playlist","customize_duration"),name:"enable_customize_duration",itemId:"enable_customize_duration",disabled:true,hidden:!b.editable}),this.customizeDurationFields=new SYNO.ux.CompositeField({hideLabel:true,disabled:true,indent:1,hidden:!b.editable,itemId:"customize_duration",items:[this.dateAvailableField=new SYNO.SDS.VideoStation2.DateField({name:"date_available",itemId:"date_available",editable:false,format:"Y-m-d",value:new Date()}),{xtype:"syno_vs_displayfield",value:"-",hideLabel:true},this.dateExpiredField=new SYNO.SDS.VideoStation2.DateField({name:"date_expired",itemId:"date_expired",editable:false,minValue:new Date(),format:"Y-m-d",value:new Date().add(Date.DAY,7),validator:this.customizeDurationValidator.createDelegate(this)})]})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED);this.mon(this,SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED,this.onPlaylistSharingLoaded,this);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_sharing",["url","enable_customize_duration"]),new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_customize_duration",["customize_duration"])]},customizeDurationValidator:function(a){if(this.dateAvailableField.getValue()>this.dateExpiredField.getValue()){return _VST("playlist","error_exp_before_avail")}return true},isValid:function(){return this.getForm().isValid()},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getPublicSharingURL:function(){return this.getForm().getValues().url},getValues:function(){var a=this.getForm().getValues();if(a.enable_customize_duration!=="true"){a.date_available=0;a.date_expired=0}a.enable_sharing=(a.enable_sharing==="true");delete a.enable_customize_duration;return a},onPlaylistSharingLoaded:function(a){if(!a.date_available||a.date_available==="0"||!a.date_expired||a.date_expired==="0"){a.enable_customize_duration=false;delete a.date_available;delete a.date_expired}else{a.enable_customize_duration=true}this.getForm().setValues(a);this.oriValue=this.getValues()},onEnableSharingChecked:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED)}});Ext.define("SYNO.SDS.VideoStation2.CreatePlaylistDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",forcePublicSharing:null,smartPlaylist:null,videos:null,constructor:function(b){var a={layout:"fit",width:560,height:280,title:(b.smartPlaylist)?_VST("playlist","action_create_smart"):(b.forcePublicSharing)?_VST("advanced","public_sharing"):_VST("playlist","action_create"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.CreatePlaylistDialog.Panel(b)]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){if(!this.panel.isValid()){return}this.setStatusBusy();var a=this.panel.getValues();if(this.smartPlaylist){var b=Ext.apply({type:SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType(),library_id:[SYNO.SDS.VideoStation2.Library.get().getCurrentID()]},SYNO.SDS.VideoStation2.Filter.get().getFilterOption(true));Ext.apply(b,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());a.filter_info=Ext.encode(b);SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("createSmartPlaylist",a,this.onCreatePlaylist,this.onCreatePlaylistFail,this)}else{SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("createPlaylist",a,this.onCreatePlaylist,this.onCreatePlaylistFail,this)}},onCreatePlaylist:function(a){if(!this.waitingPlaylist){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)}this.waitingPlaylist=a.id},onCreatePlaylistFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onPlaylistLoaded:function(){this.clearStatusBusy();this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);var b=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(this.waitingPlaylist);this.waitingPlaylist=null;if(!this.smartPlaylist){SYNO.SDS.VideoStation2.PlaylistController.addVideoToPlaylist(this.videos,b.id,this.onVideoAdded.createDelegate(this,[b]))}if(this.forcePublicSharing){var a=new SYNO.SDS.VideoStation2.PlaylistSharingDialog({owner:this.owner,playlist:b});a.open()}this.close()},onVideoAdded:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.CreatePlaylistDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var c=SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing();var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_displayfield",value:_VST("playlist","share_desc"),hideLabel:true,hidden:!b.forcePublicSharing||!c},this.titleTextField=new SYNO.SDS.VideoStation2.TextField({fieldLabel:_VST("playlist","playlist_name"),name:"title",itemId:"title"}),{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","action_share"),name:"enable_sharing",hidden:b.forcePublicSharing||!c,checked:b.forcePublicSharing&&c},{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","customize_duration"),hidden:!c,name:"enable_customize_duration",itemId:"enable_customize_duration"},this.customizeDurationFields=new SYNO.ux.CompositeField({hidden:!c,hideLabel:true,disabled:true,indent:1,itemId:"customize_duration",items:[this.dateAvailableField=new SYNO.SDS.VideoStation2.DateField({name:"date_available",itemId:"date_available",editable:false,format:"Y-m-d",value:new Date()}),{xtype:"syno_vs_displayfield",value:"-",hideLabel:true},this.dateExpiredField=new SYNO.SDS.VideoStation2.DateField({name:"date_expired",itemId:"date_expired",editable:false,minValue:new Date(),format:"Y-m-d",value:new Date().add(Date.DAY,7),validator:this.customizeDurationValidator.createDelegate(this)})]})],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_customize_duration",["customize_duration"])]},customizeDurationValidator:function(a){if(this.dateAvailableField.getValue()>this.dateExpiredField.getValue()){return _VST("playlist","error_exp_before_avail")}return true},getValues:function(){var a=this.getForm().getValues();if(a.enable_customize_duration!=="true"){a.date_available=0;a.date_expired=0}a.enable_sharing=(a.enable_sharing==="true");delete a.enable_customize_duration;return a},isValid:function(){return this.getForm().isValid()},onAfterRender:function(){var a=_VST("playlist","untitled_name");var b=SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists();var c=b.filter(function(d){return d.title.substr(0,a.length)===a}).length;if(c>0){a=a+String.format(" ({0})",c)}this.titleTextField.setValue(a)}});Ext.define("SYNO.SDS.VideoStation2.SuperBox",{statics:{CLASS_MENU_EXPANDED:"menu-expanded"},extend:"SYNO.ux.SuperBoxSelect",xtype:"syno_vs_superbox",listClass:"syno-vs2-combobox-list",extraItemCls:"syno-vs2-superbox-item",ctCls:"syno-vs2-superbox",tplHtmlEncode:true,constructor:function(){this.callParent(arguments);this.mon(this,"expand",this.addExpandedClass,this);this.mon(this,"collapse",this.removeExpandedClass,this)},addExpandedClass:function(){this.addClass(SYNO.SDS.VideoStation2.SuperBox.CLASS_MENU_EXPANDED)},removeExpandedClass:function(){this.removeClass(SYNO.SDS.VideoStation2.SuperBox.CLASS_MENU_EXPANDED)},onDestroy:function(){this.mun(this,"expand",this.addExpandedClass,this);this.mun(this,"collapse",this.removeExpandedClass,this);this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",playlist:null,constructor:function(b){var a={layout:"anchor",width:560,height:280,padding:"0 20",buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel(Ext.apply({anchor:"100%"},b)),this.smartPanel=new SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel(Ext.apply({anchor:"100% -35",hidden:true},b))],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)])},isSmart:function(){return this.playlist.type===SYNO.SDS.VideoStation2.Playlist.TYPE_SMART},isValid:function(){var a=this.panel.isValid();if(this.isSmart()){a=this.smartPanel.isValid()&&a}return a},isDirty:function(){var a=this.panel.isDirty();if(this.isSmart()){a=this.smartPanel.isDirty()||a}return a},getValues:function(){var a=this.panel.getValues();if(this.isSmart()){var b=this.playlist.additional.filter_info;var c=this.smartPanel.getValues();c.type=b.type;c.library_id=b.library_id;a.filter_info=Ext.encode(c)}return a},onOKBtn:function(){if(!this.isValid()){return}if(!this.isDirty()){this.close();return}this.setStatusBusy();if(this.isSmart()){SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editSmartPlaylist",this.getValues(),this.onEditPlaylist,this.onEditPlaylistFail,this)}else{SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editPlaylist",this.getValues(),this.onEditPlaylist,this.onEditPlaylistFail,this)}},onAfterRender:function(){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED,this.playlist);if(this.isSmart()){this.smartPanel.fireEvent(SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED,this.playlist);this.smartPanel.show();this.setTitle(_VST("playlist","action_edit_smart"))}else{this.setTitle(_VST("playlist","action_edit"))}},onEditPlaylist:function(){this.clearStatusBusy();this.close()},onEditPlaylistFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={height:35,defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_numberfield",name:"id",itemId:"id",hidden:true},this.titleTextField=new SYNO.SDS.VideoStation2.TextField({fieldLabel:_VST("playlist","playlist_name"),name:"title",itemId:"title"})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED);this.mon(this,SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)},getValues:function(){return this.getForm().getValues()},isValid:function(){return this.getForm().isValid()},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},onPlaylistLoaded:function(a){this.getForm().setValues(a);this.oriValue=this.getValues()}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(c){var a={getFilterOption:this.getFilterOption.createDelegate(this),listeners:{scope:this,valuechanged:this.doLayout}};var b={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,name:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,name:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,name:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,name:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.ResolutionOption(Ext.apply({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,name:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.WatchedStatusOption(Ext.apply({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,name:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.FileCountOption(Ext.apply({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,name:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,name:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER},a)),new SYNO.SDS.VideoStation2.EditPlaylistDialog.DurationOption(Ext.apply({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION,name:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION},a)),{xtype:"syno_vs_textfield",itemId:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,name:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)}]};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED);this.mon(this,SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)},getValues:function(){var a={};this.items.each(function(b){var c=b.getValue();if(!c||(Ext.isArray(c)&&c.length===0)){return}a[b.name]=c});return a},isValid:function(){return this.getForm().isValid()},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getFilterOption:function(){var a={};Ext.iterate(this.getValues(),function(b,c){if(b==="keyword"){return}a[b]=Ext.encode(c)});Ext.apply(a,{type:this.type,library_id:Ext.encode(this.library_id)});return a},onPlaylistLoaded:function(b){var a=b.additional.filter_info;this.type=a.type;this.library_id=a.library_id;Ext.iterate(a,function(c,d){if(c==="type"||c==="library_id"||c==="keyword"){return}var e=this.getComponent(c);if(!e||e.local){return}d.each(function(f){e.addNewItem({key:f,value:f})})},this);this.getForm().setValues(a);this.oriValue=this.getValues()}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",{extend:"SYNO.SDS.VideoStation2.SuperBox",category:null,type:null,library_id:null,local:false,getFilterOption:Ext.emptyFn,constructor:function(c){var b=c.local||this.local;var d=c.category||this.category;var a={valueField:"value",displayField:"key",triggerAction:"all",mode:b?"local":"remote",minChars:2,allowQueryAll:true,pageSize:300,editable:true,grow:true,typeAhead:true,allowAddNewData:true,addNewDataOnBlur:true,fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(d),store:this.getStore()};this.callParent([Ext.apply(a,c)])},getStore:function(a){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this.store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{category:this.category});Ext.apply(c,this.getFilterOption());delete c[this.category]},getValue:function(){var a=[];this.items.each(function(b){a.push(b.value)});return a},findRecord:function(c,b){var a;if(this.store.getCount()>0){this.store.each(function(d){if(SYNO.ux.Utils.checkObjectConsistency(d.data[c],b)){a=d;return false}})}return a}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.ResolutionOption",{extend:"SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_RESOLUTION});return this.store}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.WatchedStatusOption",{extend:"SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_WATCHED_STATUS});return this.store}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.FileCountOption",{extend:"SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_FILE_COUNT});return this.store}});Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.DurationOption",{extend:"SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_DURATION});return this.store}});Ext.define("SYNO.SDS.VideoStation2.PlaylistActionController",{statics:{ACTION_DELETE:"action_delete",ACTION_SHARE:"action_share",ACTION_EDIT:"action_edit",getAllActions:function(){return[SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE,SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE,SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT]},doPlaylistAction:function(b,a){switch(b){case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE:return SYNO.SDS.VideoStation2.PlaylistActionController.deletePlaylist(a);case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE:return SYNO.SDS.VideoStation2.PlaylistActionController.sharePlaylist(a);case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT:return SYNO.SDS.VideoStation2.PlaylistActionController.editPlaylist(a);default:SYNO.Debug.error(String.format("unknown playlist action {0}",b))}},deletePlaylist:function(a){var b=_VST("playlist","delete_confirm");SYNO.SDS.VideoStation2.Window.getMsgBox().confirmDelete("",b,function(c){if(c==="yes"){SYNO.SDS.VideoStation2.PlaylistActionController.doDeletePlaylist(a)}})},doDeletePlaylist:function(a){SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("deletePlaylist",{id:a})},sharePlaylist:function(b){var c=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(b);var a=new SYNO.SDS.VideoStation2.PlaylistSharingDialog({owner:SYNO.SDS.VideoStation2.Window,playlist:c,editable:true});a.open()},editPlaylist:function(b){var c=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(b);var a=new SYNO.SDS.VideoStation2.EditPlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,playlist:c});a.open()},createSmartPlaylist:function(){var a=new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,smartPlaylist:true});a.open()}}});Ext.define("SYNO.SDS.VideoStation2.SourceDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){var a={title:_VST("video_info","source"),layout:"fit",cls:"source-dialog",width:460,height:480,minWidth:300,minHeight:280,padding:24,buttons:[{xtype:"syno_vs_button",text:_T("common","close"),scope:this,handler:this.close}],items:[this.panel=new SYNO.SDS.VideoStation2.SourceDialog.Panel()]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.SourceDialog.Panel",{extend:"Ext.DataView",constructor:function(b){var a={tpl:this.getTpl(),store:this.getStore(),cls:"source-list",itemSelector:"div.source-wrap"};this.callParent([Ext.apply(a,b)])},getTpl:function(){this.tpl=this.tpl||new Ext.XTemplate('<tpl for=".">','<div class="source-wrap {id}">',"{[this.getLink(values)]}","</div>","</tpl>",'<div class="desc">{[_VST("video_info", "source_description")]}</div>',{getLink:function(a){var b=String.format('<a target="_blank" class="link" href="{0}">{1}</a>',a.link,a.title);return String.format(_VST("video_info","license_under"),b)}});return this.tpl},getStore:function(){this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","link","title"],data:[{id:"atmovies",link:"http://www.atmovies.com.tw/home/",title:_VST("video_info","source_atmovies")},{id:"tmdb",link:"https://www.themoviedb.org/",title:_VST("video_info","tmdb")},{id:"freebase",link:"http://creativecommons.org/licenses/by/2.5/",title:_VST("video_info","cc_by")},{id:"TVDB",link:"http://creativecommons.org/licenses/by/3.0/us/",title:_VST("video_info","cc_by")},{id:"allocine",link:"http://www.allocine.fr/",title:_VST("video_info","allocine")}]});return this.store}});Ext.define("SYNO.SDS.VideoStation2.ImageSelector",{extend:"SYNO.SDS.Utils.ImageSelector",constructor:function(b){var a={state:"fromDS"};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vs2-dialog");this.addClass("syno-vs2-imageselector");this.tree_myimage.hide();this.tree_myimage.getSelectionModel().clearSelections();this.centerPanel.layout.setActiveItem(this.view);Ext.each(this.buttons,function(c){c.addClass("syno-vs2-button")})},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.GridPanel",{extend:"SYNO.ux.GridPanel",xtype:"syno_vs_gridpanel",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-gridpanel")}});Ext.define("SYNO.SDS.VideoStation2.PagingToolbar",{extend:"SYNO.ux.PagingToolbar",xtype:"syno_vs_paging",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-paging")}});Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",type:null,defaultQuery:null,onVideoMetadataSelected:Ext.emptyFn,constructor:function(b){var c=b.type||this.type;var a={title:_VST("action","search_correct"),layout:"border",cls:"internet-search-dialog",width:800,height:400,minWidth:200,minHeight:200,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",disabled:true,scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.form=new SYNO.SDS.VideoStation2.InternetSearchDialog.Form({enableEpisodeField:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE===c,region:"north"}),this.grid=new SYNO.SDS.VideoStation2.InternetSearchDialog.Grid({enableEpisodeField:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE===c,store:this.getStore(),region:"center"})],listeners:{scope:this,afterrender:this.onAfterRender,beforedestroy:this.onBeforeDestory,show:{fn:this.onShow,single:true}}};this.callParent([Ext.apply(a,b)]);this.mon(this.form,SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH,this.onSearch,this);this.mon(this.grid,SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE,this.onOKBtn,this);this.mon(this.grid,SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.internet_search({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}});return this.store},clearPollingTask:function(){if(this.pollingTask){SYNO.SDS.VideoStation2.OP.get().stopSearchMetadata({id:this.pollingTask.params.id},{});this.pollingTask.stop();this.pollingTask.remove();this.pollingTask=null}},clearMetaRequest:function(){if(this.metaRequest){SYNO.SDS.VideoStation2.OP.abort(this.metaRequest);this.metaRequest=null}},getStoreState:function(){return this.grid.getStoreState()},updateStore:function(e,d){var c=this.getStoreState();if(!SYNO.ux.Utils.checkObjectConsistency(d,c)){return}var b=this.getStore();b.storeOptions({params:d});var a=b.reader.readRecords({data:e});b.loadRecords(a,{add:false,params:d},true)},showStatusBusy:function(){this.setStatus({text:_T("common","loading"),iconCls:"syno-ux-statusbar-loading"})},hideStatusBusy:function(){this.clearStatus()},formMetadata:function(a){return{additional:{actor:Ext.decode(a.actor||null),director:Ext.decode(a.director||null),genre:Ext.decode(a.genre||null),writer:Ext.decode(a.writer||null),summary:a.summary,extra:a.extra,tvshow_extra:a.tvshow_extra,tvshow_summary:a.tvshow_summary},title:a.title,certificate:a.certificate,tagline:a.tag_line,original_available:a.original_available,tvshow_original_available:a.tvshow_original_available,episode:parseInt(a.episode,10),season:parseInt(a.season,10),update_tvshow:this.form.getValues().preferlanguage,from_internet:true}},correctTVShowMetadata:function(a){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().querySearchMetadata({id:this.getStore().baseParams.id,type:this.type,data:Ext.encode(a)},{scope:this,success:this.onCorrectTVShowMetadata,failure:this.onRequestFail})},onBeforeDestory:function(){this.getStore().destroy()},onAfterRender:function(){this.form.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY,this.defaultQuery)},onShow:function(){SYNO.SDS.VideoStation2.Util.maskInfo(this.grid,_VST("search","desc"))},onCancelBtn:function(){this.clearMetaRequest();this.clearPollingTask();this.close()},onOKBtn:function(){var a=this.grid.getSelected();if(!a){return}if(this.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE){this.correctTVShowMetadata(a.data);return}this.onVideoMetadataSelected(this.formMetadata(a.data));this.clearMetaRequest();this.clearPollingTask();this.close()},onSearch:function(){SYNO.SDS.VideoStation2.Util.unmask(this.grid);this.setStatusBusy();this.clearMetaRequest();this.clearPollingTask();this.metaRequest=SYNO.SDS.VideoStation2.OP.get().startSearchMetadata(Ext.apply({type:this.type},this.form.getValues()),{scope:this,success:this.onStartSearchMetadata,failure:this.onRequestFail})},onStartSearchMetadata:function(c,b,a){this.getStore().baseParams.id=c.id;this.pollingTask=SYNO.SDS.VideoStation2.OP.pollingRequest("listSearchMetadata",this.getStoreState(),{scope:this,success:this.onPollingSearchMetadata,failure:this.onRequestFail},1500);this.clearStatusBusy();this.showStatusBusy()},onPollingSearchMetadata:function(c,b,a){this.updateStore(c,b);if("updated"!==c.status){return}this.pollingTask.stop();if(this.maskCnt===0){this.hideStatusBusy()}},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)});this.clearMetaRequest();this.clearPollingTask()},onBeforeLoadStore:function(a,b){this.setStatusBusy();if(this.pollingTask){Ext.apply(this.pollingTask.params,b.params)}},onLoadStore:function(){this.clearStatusBusy();if(this.pollingTask){this.showStatusBusy()}},onCorrectTVShowMetadata:function(c,b,a){this.clearStatusBusy();this.onVideoMetadataSelected(this.formMetadata(c.results));this.clearMetaRequest();this.clearPollingTask();this.close()},onSelectionChange:function(a){this.okBtn.setDisabled(!a)}});Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog.Form",{statics:{EVENT_SEARCH:"search",EVENT_SET_QUERY:"setquery"},extend:"SYNO.SDS.VideoStation2.FormPanel",enableEpisodeField:false,constructor:function(c){var a=c.enableEpisodeField||this.enableEpisodeField;var b={defaults:{anchor:"100%"},updateFormForScrollbar:true,height:40,items:[{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"container",height:32,layout:"fit",flex:2,items:[{xtype:"syno_vs_textfilter",name:"title",itemId:"title",hideLabel:true,listeners:{scope:this,keypress:this.onFieldKeypress}}]},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:true,value:_VST("language","title")+": "},{xtype:"syno_vs_combobox",name:"preferlanguage",itemId:"preferlanguage",hideLabel:true,displayField:"display",valueField:"value",store:SYNO.SDS.VideoStation2.Util.getLangStore(),value:"enu",flex:1},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:true,value:_VST("season","season_title")+": ",hidden:!a},{xtype:"syno_vs_numberfield",name:"season",itemId:"season",hideLabel:true,allowNegative:false,allowDecimals:false,disabled:!a,hidden:!a,flex:1,enableKeyEvents:true,listeners:{scope:this,keypress:this.onFieldKeypress}},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:true,value:_VST("episode","episode_title")+": ",hidden:!a},{xtype:"syno_vs_numberfield",name:"episode",itemId:"episode",hideLabel:true,allowNegative:false,allowDecimals:false,disabled:!a,hidden:!a,flex:1,enableKeyEvents:true,listeners:{scope:this,keypress:this.onFieldKeypress}},{xtype:"syno_vs_button",text:_VST("search","title"),scope:this,handler:this.fireSearch}]}]};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY);this.mon(this,SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY,this.onSetQuery,this)},onFieldKeypress:function(b,a){if(a.getKey()!==Ext.EventObject.ENTER){return}this.fireSearch()},onSetQuery:function(a){this.getForm().setValues(a)},getValues:function(){return this.getForm().getValues()},fireSearch:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH)}});Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog.Grid",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:500,enableEpisodeField:false,constructor:function(c){var a=c.enableEpisodeField||this.enableEpisodeField;var b={trackResetOnLoad:false,bbar:new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:c.store,displayInfo:true,showRefreshBtn:true}),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("common","title"),dataIndex:"title"},{header:a?String.format("{0} ({1})",_VST("original_available","title"),_VST("type","tv_show")):_VST("original_available","title"),dataIndex:"original_available"},{header:_VST("episode","name_title"),dataIndex:"tag_line",hidden:!a},{header:_VST("season","season_title"),dataIndex:"season",hidden:!a},{header:_VST("episode","episode_title"),dataIndex:"episode",hiddne:!a},{header:a?String.format("{0} ({1})",_VST("summary","title"),_VST("episode","episode_title")):_VST("summary","title"),dataIndex:"summary"}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(b,c)]);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE)},getSelected:function(){return this.getSelectionModel().getSelected()},getStoreState:function(){var b=this.getStore();var a=b.getSortState();var c={};c[b.paramNames.start]=this.getBottomToolbar().cursor;c[b.paramNames.limit]=this.getBottomToolbar().pageSize;if(a){c[b.paramNames.sort]=a.field;c[b.paramNames.dir]=a.direction}c.id=b.baseParams.id;return c},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",type:null,library_id:null,defaultQuery:null,pageSize:500,onVideoMetadataSelected:Ext.emptyFn,constructor:function(b){if(b.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE){b.type=SYNO.SDS.VideoStation2.Constant.TVSHOW}var a={title:_VST("action","select_db"),layout:"border",cls:"video-metadata-choose-dialog",width:800,height:400,minWidth:200,minHeight:200,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",disabled:true,scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.form=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form({region:"north"}),this.grid=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid({pageSize:this.pageSize,store:this.getStore(b),region:"center"})],listeners:{scope:this,beforedestroy:this.onBeforeDestory}};this.callParent([Ext.apply(a,b)]);this.mon(this.form,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH,this.onSearch,this);this.mon(this.grid,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE,this.onOKBtn,this);this.mon(this.grid,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},getStore:function(a){if(!this.store){var b=a.type||this.type;this.store=new SYNO.SDS.VideoStation2.Stores[b]({autoLoad:true,listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}});this.store.on("beforeload",this.onFirstBeforeLoadStore,this,{single:true})}return this.store},onBeforeDestory:function(){this.getStore().destroy()},onFirstBeforeLoadStore:function(){this.form.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY,this.defaultQuery)},onOKBtn:function(){var a=this.grid.getSelected();if(!a){return}this.onVideoMetadataSelected(a.data);this.close()},onSearch:function(){this.getStore().load()},onBeforeLoadStore:function(b,c){this.setStatusBusy();var d=c.params;d.additional=Ext.encode(["tvshow_summary","tvshow_extra","summary","file","actor","writer","director","extra","genre","poster_mtime"]);d.library_id=this.library_id;Ext.apply(d,this.form.getValues());var a={};a[b.paramNames.start]=0;a[b.paramNames.limit]=this.pageSize;Ext.applyIf(d,a)},onLoadStore:function(){this.clearStatusBusy()},onSelectionChange:function(a){this.okBtn.setDisabled(!a)}});Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form",{statics:{EVENT_SEARCH:"search",EVENT_SET_QUERY:"setquery"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,height:40,items:[{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"container",height:32,layout:"fit",flex:1,items:[{xtype:"syno_vs_textfilter",name:"keyword",itemId:"keyword",hideLabel:true,listeners:{scope:this,keypress:this.onFieldKeypress}}]},{xtype:"syno_vs_button",text:_VST("search","title"),scope:this,handler:this.fireSearch}]}]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY);this.mon(this,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY,this.onSetQuery,this)},onFieldKeypress:function(b,a){if(a.getKey()!==Ext.EventObject.ENTER){return}this.fireSearch()},onSetQuery:function(a){this.getForm().setValues({keyword:a.title})},getValues:function(){var a=this.getForm().getValues();if(Ext.isEmpty(a.keyword)){delete a.keyword}return a},fireSearch:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH)}});Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},extend:"SYNO.SDS.VideoStation2.GridPanel",constructor:function(b){var a={trackResetOnLoad:false,bbar:new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:b.pageSize,store:b.store,displayInfo:true,showRefreshBtn:true}),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("common","title"),dataIndex:"title"},{header:_VST("original_available","title"),dataIndex:"original_available"},{header:_VST("summary","title"),dataIndex:"summary"}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE)},getSelected:function(){return this.getSelectionModel().getSelected()},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.Toolbar",{statics:{EVENT_RESET:"reset",EVENT_IMPORT_METADATA:"importmetadata",EVENT_INTERNET_SEARCH:"internetsearch"},extend:"SYNO.ux.Toolbar",video:null,disableInternetSearch:false,onBeforeOpenDialog:Ext.emptyFn,constructor:function(b){var c=b.disableInternetSearch||c;var a={items:[this.internetSearchBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","search_correct"),handler:this.onInternetSearchBtnClick,scope:this,hidden:c}),this.videoMetadataChooseBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","select_db"),handler:this.onVideoMetadataChooseBtnClick,scope:this}),this.resetBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","reset"),handler:this.onResetBtnClick,scope:this})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH);if(!c){this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH,this.onInternetSearchBtnClick,this)}},onResetBtnClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET)},onInternetSearchBtnClick:function(){var a=new SYNO.SDS.VideoStation2.InternetSearchDialog({type:this.video.type,owner:this.owner,defaultQuery:this.onBeforeOpenDialog(),onVideoMetadataSelected:this.onVideoMetadataSelected.createDelegate(this)});a.open()},onVideoMetadataChooseBtnClick:function(){var a=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog({type:this.video.type,library_id:this.video.library_id,owner:this.owner,defaultQuery:this.onBeforeOpenDialog(),onVideoMetadataSelected:this.onVideoMetadataSelected.createDelegate(this)});a.open()},onVideoMetadataSelected:function(a){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA,a)}});Ext.define("SYNO.SDS.VideoStation2.Radio",{extend:"SYNO.ux.Radio",xtype:"syno_vs_radio",checkIconCls:"syno-vs2-radio syno-ux-radio-icon",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.RadioGroup",{extend:"SYNO.ux.RadioGroup",xtype:"syno_vs_radiogroup",defaultType:"syno_vs_radio",constructor:function(a){this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.Source",{extend:"SYNO.SDS.VideoStation2.Button",constructor:function(b){var a={text:_VST("video_info","source"),scope:this,handler:this.onClick};this.callParent([Ext.apply(a,b)])},onClick:function(){var a=new SYNO.SDS.VideoStation2.SourceDialog({owner:this.owner});a.open()}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.FileSelect",{statics:{EVENT_FILE_CHOOSE:"filechoose"},extend:"SYNO.SDS.VideoStation2.Button",gotoPath:null,constructor:function(b){var a={text:_VST("common","select"),scope:this,handler:this.onClick};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE)},setGotoPath:function(a){this.gotoPath=a},onClick:function(){var a=new SYNO.SDS.VideoStation2.ImageSelector({owner:SYNO.SDS.VideoStation2.Window,gotoPath:this.gotoPath});a.mon(a,"choose",function(b){this.onImageChoose(b);a.close()},this);a.open()},onImageChoose:function(a){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE,a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.MetaSelector",{extend:"SYNO.SDS.VideoStation2.SuperBox",type:null,library_id:null,category:null,owner:null,htmlEncode:true,constructor:function(b){var c=b.category||this.category;var a={valueField:"name",displayField:"name",triggerAction:"all",mode:"remote",minChars:1,allowQueryAll:true,pageSize:300,editable:true,grow:true,queryParam:"filter",typeAhead:true,allowAddNewData:true,addNewDataOnBlur:true,valueDelimiter:"|",fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(c),store:this.getStore()};this.callParent([Ext.apply(a,b)]);this.mon(this,"newitem",this.onNewItem,this)},getStore:function(a){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.metafilter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this.store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{type:this.type,library_id:this.library_id,category:this.category,sort_by:this.category,sort_direction:"ASC"})},onNewItem:function(b,a){b.addNewItem({name:a},true)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",{statics:{EVENT_META_LOADED:"metaloaded",EVENT_POSTER_CHANGE:"posterchange",EVENT_POSTER_ERROR:"postererror",EVENT_POSTER_SET:"posterset"},extend:"SYNO.SDS.VideoStation2.FormPanel",disableToolbar:false,disableInternetSearch:false,video:null,constructor:function(b){var c=b.video||this.video;var d=this.disableToolbar?null:new SYNO.SDS.VideoStation2.EditMetadata.Toolbar({video:c,owner:b.owner,disableInternetSearch:this.disableInternetSearch,onBeforeOpenDialog:this.onBeforeOpenToolbarDialog.createDelegate(this)});var a={title:Ext.isNumber(c.file)?_VST("action","correct_metadata"):_VST("metadata","title"),tbar:d};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_ERROR);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET);this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.onMetaLoaded,this);if(d){this.mon(d,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET,this.onReset,this);this.mon(d,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA,this.onImportMetadata,this)}},getFileFieldConfig:function(a){var b=a.video||this.video;return[{xtype:"syno_vs_displayfield",fieldLabel:_VST("file","file_name"),name:"filename",itemId:"filename",hidden:!Ext.isNumber(b.file)},{xtype:"syno_vs_displayfield",fieldLabel:_VST("file","file_path"),name:"sharepath",itemId:"sharepath",hidden:!Ext.isNumber(b.file)}]},getChannelFieldConfig:function(a){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("schedule","channel"),name:"channel_name",itemId:"channel_name",readOnly:true}]},getTitleFieldConfig:function(a){var b=a.video||this.video;var c=_VST("common","title");switch(b.type){case SYNO.SDS.VideoStation2.Constant.TVSHOW:case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:c=_VST("tvshow","title");break;case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:c=_VST("programguide","title");break}return[{xtype:"syno_vs_textfield",fieldLabel:c,name:"title",itemId:"title",allowBlank:false,validator:this.lengthValidator.createDelegate(this,[255],true)}]},getTaglineFieldConfig:function(a){var b=a.video||this.video;return[{xtype:"syno_vs_textfield",fieldLabel:b.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?_VST("episode","name_title"):_VST("tagline","title"),name:"tagline",itemId:"tagline",validator:this.lengthValidator.createDelegate(this,[255],true)}]},getOriginalAvailableFieldConfig:function(a){var b=a.video||this.video;return[{xtype:"syno_vs_datefield",fieldLabel:b.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?String.format("{0} ({1})",_VST("original_available","title"),_VST("episode","episode_title")):_VST("original_available","title"),name:"original_available",itemId:"original_available",format:"Y-m-d",editable:false}]},getTVShowOriginalAvailableFieldConfig:function(a){return[{xtype:"syno_vs_datefield",fieldLabel:String.format("{0} ({1})",_VST("original_available","title"),_VST("type","tv_show")),name:"tvshow_original_available",itemId:"tvshow_original_available",format:"Y-m-d",editable:false}]},getSeasonFieldConfig:function(a){return[{xtype:"syno_vs_numberfield",fieldLabel:_VST("season","season_title"),name:"season",itemId:"season",allowDecimals:false,allowNegative:false}]},getEpisodeFieldConfig:function(a){return[{xtype:"syno_vs_numberfield",fieldLabel:_VST("episode","episode_title"),name:"episode",itemId:"episode",allowDecimals:false,allowNegative:false}]},getRecordDateFieldConfig:function(a){return[{xtype:"syno_compositefield",fieldLabel:_VST("video_info","record_time"),itemId:"record_date",items:[{xtype:"syno_vs_datefield",name:"record_date_date",itemId:"record_date_date",format:"Y-m-d",editable:false,allowBlank:false,flex:1},{xtype:"syno_vs_timefield",name:"record_date_time",itemId:"record_date_time",format:"H:i:s",editable:false,allowBlank:false,increment:1,flex:1}]}]},getCertificateFieldConfig:function(a){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("metadata","rating_classification"),name:"certificate",itemId:"certificate",validator:this.lengthValidator.createDelegate(this,[255],true)}]},getMetaSelectors:function(b){if(!this.metaSelectors){var c=b.video||this.video;var a={type:c.type,library_id:c.library_id,validator:this.lengthValidator.createDelegate(this,[255],true),listeners:{scope:this,valuechanged:this.doLayout}};this.metaSelectors=[new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,name:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE},a)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR},a)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,name:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER},a)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR},a))]}return this.metaSelectors},getMetadataLockFieldConfig:function(a){return[{xtype:"radiogroup",vertical:false,fieldLabel:String.format('{0}<img src="webman/resources/images/components/icon_information_mini.png" style="vertical-align:bottom;" border="0" ext:qtip="{1}">',_VST("lock","status"),Ext.util.Format.htmlEncode(_VST("lock","desc"))),itemId:"metadata_locked",items:[{xtype:"syno_vs_radio",boxLabel:_VST("lock","status_lock"),name:"metadata_locked",itemId:"metadata_locked_true",inputValue:"true"},{xtype:"syno_vs_radio",boxLabel:_VST("lock","status_unlock"),name:"metadata_locked",itemId:"metadata_locked_false",inputValue:"false"}]}]},getSummaryFieldConfig:function(a){return[{xtype:"syno_vs_textarea",fieldLabel:_VST("summary","title"),grow:true,growMax:200,name:"summary",itemId:"summary",validator:this.lengthValidator.createDelegate(this,[4096],true),listeners:{scope:this,autosize:this.doLayout}}]},getUpdateTVShowFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"update_tvshow",itemId:"update_tvshow",hidden:true}]},getExtraFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"extra",itemId:"extra",hidden:true}]},getTVShowExtraFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"tvshow_extra",itemId:"tvshow_extra",hidden:true}]},getBackdropFieldConfig:function(a){return[{xtype:"syno_vs_textfield",name:"backdrop",itemId:"backdrop",hidden:true}]},getSourceField:function(a){if(!this.sourceField){this.sourceField=new SYNO.ux.CompositeField({hideLabel:true,itemId:"source",items:[this.getSourceBtn(a)]});this.sourceField.innerCt.layoutConfig={pack:"end"}}return this.sourceField},getSourceBtn:function(a){this.sourceBtn=this.sourceBtn||new SYNO.SDS.VideoStation2.EditMetadata.Source(a);return this.sourceBtn},getPosterFieldConfig:function(a){return[{xtype:"syno_vs_radiogroup",hideLabel:true,vertical:true,itemId:"poster",listeners:{scope:this,change:this.firePosterChange},items:[this.getPosterOriginalRadio(a),this.getPosterUrlRadio(a),this.getPosterUrlField(a),this.getPosterFileRadio(a),this.getPosterFileSelectField(a),this.getPosterFileField(a),{xtype:"syno_vs_displayfield",value:_VST("poster","set_image_desc"),hideLabel:true}]}]},getPosterOriginalRadio:function(a){this.posterOriginalRadio=this.posterOriginalRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","original"),name:"poster",itemId:"poster_original",inputValue:"original",checked:true});return this.posterOriginalRadio},getPosterUrlRadio:function(a){this.posterUrlRadio=this.posterUrlRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","url"),name:"poster",itemId:"poster_url",inputValue:"url",listeners:{scope:this,check:function(b,c){this.getPosterUrlField().setDisabled(!c)}}});return this.posterUrlRadio},getPosterFileRadio:function(a){this.posterFileRadio=this.posterFileRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","select_existed_image"),name:"poster",itemId:"poster_file",inputValue:"file",listeners:{scope:this,check:function(b,c){this.getPosterFileField().setDisabled(!c);this.getFileSelectTextField().setDisabled(!c);this.getFileSelectBtn().setDisabled(!c)}}});return this.posterFileRadio},getPosterUrlField:function(a){this.posterUrlField=this.posterUrlField||new SYNO.SDS.VideoStation2.TextField({name:"url",itemId:"url",indent:1,vtype:"url",allowBlank:false,disabled:true,listeners:{scope:this,change:this.firePosterChange}});return this.posterUrlField},getPosterFileSelectField:function(a){this.posterFileSelectField=this.posterFileSelectField||new SYNO.ux.CompositeField({hideLabel:true,name:"file_select",itemId:"file_select",indent:1,items:[this.getFileSelectTextField(a),this.getFileSelectBtn(a)]});return this.posterFileSelectField},getFileSelectTextField:function(a){this.fileSelectTextField=this.fileSelectTextField||new SYNO.SDS.VideoStation2.TextField({name:"sharepath",itemId:"sharepath",allowBlank:false,disabled:true,readOnly:true,flex:1,listeners:{scope:this,change:this.firePosterChange}});return this.fileSelectTextField},getPosterFileField:function(a){this.posterFileField=this.posterFileField||new SYNO.SDS.VideoStation2.TextField({name:"file",itemId:"file",allowBlank:false,disabled:true,readOnly:true,hidden:true});return this.posterFileField},getFileSelectBtn:function(a){if(!this.fileSelectBtn){this.fileSelectBtn=new SYNO.SDS.VideoStation2.EditMetadata.FileSelect({disabled:true});this.fileSelectBtn.mon(this.fileSelectBtn,SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE,this.onDSMFileChoose,this)}return this.fileSelectBtn},setMetaSelectorsValue:function(a){this.getMetaSelectors().each(function(c){var b=a.additional[c.itemId]||[];c.clearValue();b.each(function(d){c.addNewItem({name:d})})},this)},maybeSetFileValue:function(b){if(!Ext.isNumber(this.video.file)){return}var a=this.findFileFromData(b);if(!a){return}this.getForm().setValues({filename:a.sharepath.substr(a.sharepath.lastIndexOf("/")+1),sharepath:a.sharepath})},setPosterFieldValue:function(a){this.getPosterOriginalRadio().setValue(false);this.getPosterUrlRadio().setValue(false);this.getPosterFileRadio().setValue(false);switch(a.poster){case"original":this.getPosterOriginalRadio().setValue(true);break;case"url":this.getPosterUrlRadio().setValue(true);this.getPosterUrlField().setValue(a.url);break;case"file":this.getPosterFileRadio().setValue(true);this.getFileSelectTextField().setValue(a.sharepath);this.getPosterFileField().setValue(a.file);break}},getPosterFieldValue:function(){var a={};if(this.getPosterOriginalRadio().getValue()){a.poster=this.getPosterOriginalRadio().inputValue}else{if(this.getPosterUrlRadio().getValue()){a.poster=this.getPosterUrlRadio().inputValue;a[this.getPosterUrlField().name]=this.getPosterUrlField().getValue()}else{if(this.getPosterFileRadio().getValue()){a.poster=this.getPosterFileRadio().inputValue;a[this.getFileSelectTextField().name]=this.getFileSelectTextField().getValue();a[this.getPosterFileField().name]=this.getPosterFileField().getValue()}}}return a},findFileFromData:function(b){var a;Ext.each(b.additional.file,function(c){if(c.id===this.video.file){a=c;return false}},this);return a},correctOriginalAvailable:function(a){if(!Ext.isString(a)){return""}return(a.indexOf("-")===-1)?a+"-01-01":a},lengthValidator:function(b,a){return window.unescape(encodeURIComponent(b)).length<=a},firePosterChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_CHANGE)},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},isValid:function(){return this.getForm().isValid()},getImportMetadata:function(){return{raw:this.importRaw,value:this.importValue}},getOriValues:function(){return this.oriValue},getValues:Ext.emptyFn,setValues:Ext.emptyFn,isVideoChanged:function(){return false},onMetaLoaded:function(a){this.setValues(a);this.oriRaw=a;this.oriValue=this.getValues()},onReset:function(){this.setValues(this.oriRaw)},parseImageUrl:function(c,b){var a;try{a=Ext.decode(c.additional.extra)}catch(f){return}var d=SYNO.SDS.VideoStation2.Util.findValueInObject(a,b);if(!Ext.isDefined(d)){return}d=d.filter(function(e){return !Ext.isEmpty(e)});if(Ext.isEmpty(d)){return}return d[0]},onImportMetadata:function(b){this.setValues(b);this.importRaw=b;this.importValue=this.getValues();var a=this.parseImageUrl(b,"poster");if(!Ext.isString(a)){return}this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET,{poster:"url",url:a})},onPosterError:function(){switch(this.getValues().poster){case"url":this.getPosterUrlField().markInvalid(_VST("error","image_format"));break;case"file":this.getFileSelectTextField().markInvalid(_VST("error","image_format"));this.getPosterFileField().markInvalid(_VST("error","image_format"));break}},onDSMFileChoose:function(a){this.getFileSelectTextField().setValue(a.get("path"));this.getPosterFileField().setValue(a.get("real_path"));this.firePosterChange()},onBeforeOpenToolbarDialog:function(){return this.getValues()}});Ext.define("SYNO.SDS.VideoStation2.OverwritePolicyDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",statics:{POLICY_SKIP:"skip",POLICY_OVERWRITE:"overwrite"},video:null,onPolicyChoosed:Ext.emptyFn,constructor:function(b){var c=b.video||this.video;var a={title:_VST("action","edit_metadata"),layout:"fit",cls:"overwrite-policy-dialog",width:475,height:280,minWidth:475,minHeight:280,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.OverwritePolicyDialog.Panel({video:c})]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){if(Ext.isFunction(this.onPolicyChoosed)){this.onPolicyChoosed.call(this,this.panel.getValues().policy)}this.close()}});Ext.define("SYNO.SDS.VideoStation2.OverwritePolicyDialog.Panel",{video:null,extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(d){var f=d.video||this.video;var c=f.library_id;var e=f.type;if(e===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE){e=SYNO.SDS.VideoStation2.Constant.TVSHOW}var a=SYNO.SDS.VideoStation2.Library.get().getLibraryByIDAndType(c,e)||{};var b={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[{xtype:"syno_vs_displayfield",hideLabel:true,itemId:"desc",value:String.format(_VST("metadata","duplicate_desc"),a.title)},{xtype:"syno_vs_radiogroup",hideLabel:true,itemId:"policy",items:[{boxLabel:_VST("metadata","duplicate_keep"),name:"policy",itemId:"policy_skip",inputValue:"skip",checked:true},{boxLabel:_VST("metadata","duplicate_replace"),name:"policy",itemId:"policy_overwrite",inputValue:"overwrite"}]}]};this.callParent([Ext.apply(b,d)])},getValues:function(){return this.getForm().getValues()}});Ext.define("SYNO.SDS.VideoStation2.TabPanel",{extend:"SYNO.ux.TabPanel",xtype:"syno_vs_tabpanel",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-tabpanel")}});Ext.define("SYNO.SDS.VideoStation2.ActivablePanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a=Ext.apply({},b);a.listeners=Ext.apply({scope:this,activate:this.onActivate.createDelegate(this),deactivate:this.onDeactivate.createDelegate(this)},b.listeners);this.callParent([a]);if(this.items){this.items.each(function(c){c.relayEvents(this,["activate","deactivate"])},this)}},onActivate:Ext.emptyFn,onDeactivate:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,onVideoMetadataEdited:Ext.emptyFn,constructor:function(b){var c=b.video||this.video;this.correct_info=Ext.isNumber((c||{}).file);var a={title:this.correct_info?_VST("action","correct_metadata"):_VST("action","edit_metadata"),layout:"fit",cls:"edit-meta-dialog",width:690,height:580,minWidth:400,minHeight:280,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],listeners:{scope:this,afterrender:this.onAfterRender},items:[this.panel=new SYNO.SDS.VideoStation2.EditMetadataDialog.Panel({video:c,owner:this})]};this.callParent([Ext.apply(a,b)])},maybeShowApplyConfirm:function(){if(!this.correct_info){this.maybeApplyMetadata();return}if(this.panel.isVideoChanged()){this.maybeApplyMetadata();return}var a=this.panel.getOriValues();var b=String.format(_VST("metadata","correct_metadata_confirm"),a.meta.title);this.getMsgBox().confirm(this.title,b,function(c){if(c==="yes"){this.maybeApplyMetadata()}},this)},maybeApplyMetadata:function(){this.setStatusBusy();var c=this.panel.getValues();if(!c.meta){this.maybeApplyPoster();return}var d=this.panel.getImportMetadata().meta;var a=d.raw;var b=d.value;if(a&&!a.from_internet&&SYNO.ux.Utils.checkObjectConsistency(b,c.meta)){this.applyMetadataWithOverwrite(SYNO.SDS.VideoStation2.OverwritePolicyDialog.POLICY_SKIP);return}var e=Ext.apply(this.getIDParameter(),c.meta);SYNO.SDS.VideoStation2.OP.get().editMetadata(e,{scope:this,success:this.maybeApplyPoster,failure:this.onApplyMetadataFail},this.video.type)},applyMetadataWithOverwrite:function(b){this.setStatusBusy();var a=this.panel.getValues();var c=Ext.apply(this.getIDParameter(),a.meta,{overwrite:b});SYNO.SDS.VideoStation2.OP.get().editMetadata(c,{scope:this,success:this.maybeApplyPoster,failure:this.onRequestFail},this.video.type)},maybeApplyPoster:function(b){if(b){if(this.correct_info){this.video.file=b.id}else{this.video.id=b.id}}var a=this.panel.getValues();if(!a.poster){this.maybeApplyBackdrop();return}SYNO.SDS.VideoStation2.OP.get().setPoster(Ext.apply(this.getImageParameter(),a.poster),{scope:this,success:this.maybeApplyBackdrop,failure:this.onRequestFail})},maybeApplyBackdrop:function(){var a=this.panel.getValues();if(!a.meta||!a.meta.backdrop){this.onEditMetadata();return}SYNO.SDS.VideoStation2.OP.get().setBackdrop(Ext.apply(this.getImageParameter(),{url:a.meta.backdrop,keep_one:true}),{scope:this,success:this.onEditMetadata,failure:this.onRequestFail})},getIDParameter:function(){var a={library_id:this.video.library_id};if(this.correct_info){a.video_id=this.video.file}else{a.id=this.video.id}return a},getImageParameter:function(){var b=this.correct_info?this.video.file:this.video.id;var a=this.correct_info?"video":this.video.type;return{id:b,type:a}},onOKBtn:function(){if(!this.panel.isValid()){return}if(!this.panel.isDirty()){this.close()}this.maybeShowApplyConfirm()},onCancelBtn:function(){if(!this.panel.isDirty()){this.close();return}this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(a){if(a==="yes"){this.close()}},this)},onApplyMetadataFail:function(d,c,a){if(d.code!==422){this.onRequestFail(d,c,a);return}this.clearStatusBusy();var b=new SYNO.SDS.VideoStation2.OverwritePolicyDialog({owner:this,video:this.video,onPolicyChoosed:this.applyMetadataWithOverwrite.createDelegate(this)});b.open()},onEditMetadata:function(){this.clearStatusBusy();if(Ext.isFunction(this.onVideoMetadataEdited)){this.onVideoMetadataEdited()}this.close()},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().getInfo({id:this.video.id,additional:Ext.encode(["title","tvshow_summary","tvshow_extra","summary","file","actor","writer","director","extra","genre","poster_mtime"])},{scope:this,success:this.onInfoLoaded,failure:this.onRequestFail},this.video.type)},onInfoLoaded:function(c,b,a){this.clearStatusBusy();this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,c[SYNO.SDS.VideoStation2.Util.getVideoRoot(this.video.type)][0])},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.Panel",{extend:"SYNO.SDS.VideoStation2.TabPanel",video:null,constructor:function(c){var e=c.video||this.video;var d=[];var b=[];switch(e.type){case SYNO.SDS.VideoStation2.Constant.MOVIE:d=new SYNO.SDS.VideoStation2.EditMetadataDialog.MovieMetaPanel({video:e,owner:c.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TVSHOW:d=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMetaPanel({video:e,owner:c.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:d=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowEpisodeMetaPanel({video:e,owner:c.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:d=new SYNO.SDS.VideoStation2.EditMetadataDialog.HomeVideoMetaPanel({video:e,owner:c.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:d=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVRecordingMetaPanel({video:e,owner:c.owner,itemId:"meta"});break}if(e.type!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING){b=new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel({video:e,owner:c.owner,itemId:"poster"});b.mon(d,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET,b.onPosterSet,b)}var a={activeTab:0,items:[d,b]};this.callParent([Ext.apply(a,c)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED);this.items.each(function(f){f.relayEvents(this,[SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED])},this)},isValid:function(){var a=true;var b;this.items.each(function(c){if(!(b=c.isValid())){this.setActiveTab(c)}a=b&&a},this);return a},isDirty:function(){var a=false;this.items.each(function(b){return !(a=(a||b.isDirty()))},this);return a},isVideoChanged:function(){var a=false;this.items.each(function(b){return !(a=(a||b.isVideoChanged()))},this);return a},getImportMetadata:function(){var a={};this.items.each(function(b){a[b.itemId]=b.getImportMetadata()},this);return a},getValues:function(){var a={};this.items.each(function(b){if(b.isDirty()){a[b.itemId]=this.serializedValues(b.getValues())}},this);return a},getOriValues:function(){var a={};this.items.each(function(b){a[b.itemId]=b.getOriValues()},this);return a},serializedValues:function(a){if(!Ext.isObject(a)){return a}var b={};Ext.iterate(a,function(c,d){if(Ext.isArray(d)){b[c]=d.join("|")}else{b[c]=d}});return b}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.MovieMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getFileFieldConfig(b),this.getTitleFieldConfig(b),this.getTaglineFieldConfig(b),this.getOriginalAvailableFieldConfig(b),this.getCertificateFieldConfig(b),this.getMetaSelectors(b),this.getMetadataLockFieldConfig(b),this.getSummaryFieldConfig(b),this.getExtraFieldConfig(b),this.getBackdropFieldConfig(b),this.getSourceField(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.metadata_locked=a.metadata_locked==="true";return a},setValues:function(a){this.getForm().setValues({title:a.title,tagline:a.tagline,original_available:this.correctOriginalAvailable(a.original_available),certificate:a.certificate,metadata_locked:a.metadata_locked||false,summary:a.additional.summary,extra:a.additional.extra,backdrop:this.parseImageUrl(a,"backdrop")});this.setMetaSelectorsValue(a);this.maybeSetFileValue(a)},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.original_available!==a.original_available)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getTitleFieldConfig(b),this.getOriginalAvailableFieldConfig(b),this.getMetadataLockFieldConfig(b),this.getSummaryFieldConfig(b),this.getExtraFieldConfig(b),this.getUpdateTVShowFieldConfig(b),this.getBackdropFieldConfig(b),this.getSourceField(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.metadata_locked=a.metadata_locked==="true";return a},setValues:function(a){this.getForm().setValues({title:a.title,original_available:this.correctOriginalAvailable(a.original_available),metadata_locked:a.metadata_locked||false,summary:a.additional.summary,extra:a.additional.extra,update_tvshow:a.update_tvshow,backdrop:this.parseImageUrl(a,"backdrop")})},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.original_available!==a.original_available)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowEpisodeMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getFileFieldConfig(b),this.getTitleFieldConfig(b),this.getTVShowOriginalAvailableFieldConfig(b),this.getTaglineFieldConfig(b),this.getSeasonFieldConfig(b),this.getEpisodeFieldConfig(b),this.getOriginalAvailableFieldConfig(b),this.getCertificateFieldConfig(b),this.getMetaSelectors(b),this.getMetadataLockFieldConfig(b),this.getSummaryFieldConfig(b),this.getExtraFieldConfig(b),this.getTVShowExtraFieldConfig(b),this.getSourceField(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.metadata_locked=a.metadata_locked==="true";return a},setValues:function(a){this.getForm().setValues({title:a.title,tagline:a.tagline,original_available:this.correctOriginalAvailable(a.original_available),tvshow_original_available:this.correctOriginalAvailable(a.tvshow_original_available),episode:a.episode,season:a.season,certificate:a.certificate,metadata_locked:a.metadata_locked||false,extra:a.additional.extra,tvshow_extra:a.additional.tvshow_extra,summary:a.additional.summary});this.setMetaSelectorsValue(a);this.maybeSetFileValue(a)},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.tvshow_original_available!==a.tvshow_original_available||this.oriValue.season!==a.season||this.oriValue.episode!==a.episode)},onImportMetadata:function(b){this.callParent(arguments);var a=this.getValues();if(a.title===this.oriValue.title||a.tvshow_original_available===this.oriValue.tvshow_original_available||b.from_internet){return}var d=_VST("metadata","title");var c=_VST("metadata","research_msg");this.owner.getMsgBox().confirm(d,c,function(e){if(e==="yes"){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH)}},this)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.HomeVideoMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableInternetSearch:true,constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getFileFieldConfig(b),this.getTitleFieldConfig(b),this.getRecordDateFieldConfig(b),this.getCertificateFieldConfig(b),this.getMetaSelectors(b),this.getSummaryFieldConfig(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){var a=this.getForm().getValues();a.record_date=String.format("{0} {1}",a.record_date_date,a.record_date_time);return a},setValues:function(b){var a=(b.record_date||" ").split(" ");this.getForm().setValues({title:b.title,record_date_date:a[0],record_date_time:a[1],certificate:b.certificate,summary:b.additional.summary});this.setMetaSelectorsValue(b);this.maybeSetFileValue(b)},isVideoChanged:function(){var a=this.getValues();return(this.oriValue.title!==a.title||this.oriValue.record_date!==a.record_date)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVRecordingMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableToolbar:true,constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getChannelFieldConfig(b),this.getTitleFieldConfig(b),this.getSummaryFieldConfig(b)]};this.callParent([Ext.apply(a,b)])},getValues:function(){return this.getForm().getValues()},setValues:function(a){this.getForm().setValues({title:a.title,channel_name:a.channel_name,summary:a.additional.summary})},isVideoChanged:function(){return true}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={title:_VST("poster","title"),layout:"border",items:[this.image=new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image({region:"west",owner:b.owner,video:b.video}),this.panel=new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Form({region:"center",owner:b.owner,video:b.video})]};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_CHANGE,this.loadPoster,this);this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.onMetaLoaded,this);this.mon(this.image,SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image.EVENT_POSTER_ERROR,this.onPosterError,this);this.mon(this,"activate",this.loadPoster,this,{single:true})},loadPoster:function(){this.image.setPoster(this.getValues())},isDirty:function(){return !SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},isValid:function(){return this.panel.isValid()},getValues:function(){return this.panel.getValues()},getOriValues:function(){return this.panel.getOriValues()},getImportMetadata:function(){return this.panel.getImportMetadata()},isVideoChanged:function(){return this.panel.isVideoChanged()},setValues:function(a){this.image.setPosterMtime((a.additional||{}).poster_mtime);this.panel.setValues(a)},onMetaLoaded:function(a){this.setValues(a);this.oriRaw=a;this.oriValue=this.getValues()},onPosterError:function(){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_ERROR)},onPosterSet:function(a){this.panel.setValues(a)}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image",{statics:{EVENT_POSTER_ERROR:"postererror"},extend:"Ext.Container",video:null,mtime:null,constructor:function(b){var a={cls:"image",margins:"0 30 0 0"};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image.EVENT_POSTER_ERROR)},setPosterMtime:function(a){this.mtime=a},setPoster:function(b){var c=this.getPosterUrl(b);if(Ext.isEmpty(c)){return}var a=new Image();a.onerror=this.setDefaultImage.createDelegate(this);a.onload=this.setPosterImage.createDelegate(this,[c]);a.src=c},getPosterUrl:function(a){switch(a.poster){case"original":return SYNO.SDS.VideoStation2.Util.getImageURL({type:this.video.type,id:this.video.id,mtime:this.mtime||""});case"url":return a.url;case"file":return Ext.isEmpty(a.file)?a.file:this.getBaseURL({api:"SYNO.Core.File.Thumbnail",method:"get",version:1,params:{path:SYNO.API.EscapeStr(a.sharepath),size:"medium"}});default:return SYNO.SDS.VideoStation2.Util.getImageURL({type:this.video.type,id:0})}},setDefaultImage:function(){var a=this.getPosterUrl({});this.setPosterImage(a);this.fireEvent(SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image.EVENT_POSTER_ERROR)},setPosterImage:function(a){var b=this.getEl();if(!b){return}b.setStyle("background-image",String.format("url('{0}')",a))}});Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Form",{disableToolbar:true,extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.getPosterFieldConfig(b)]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_ERROR,this.onPosterError,this)},getValues:function(){return this.getPosterFieldValue()},setValues:function(b){if(b.poster){this.setPosterFieldValue(b);return}if(!b.additional.file){return}var a=this.correct_info?this.findFileFromData(b):b.additional.file[0];var c=a.sharepath;this.getFileSelectBtn().setGotoPath(c.substring(0,c.lastIndexOf("/")))},isValid:function(){var a=this.getForm().isValid();a=this.getPosterUrlField().isValid()&&a;a=this.getPosterFileField().isValid()&&a;return a}});Ext.define("SYNO.SDS.VideoStation2.DropdownMenu",{extend:"SYNO.ux.Menu",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-dropdown-menu");if(a.noicon===true){this.addClass("no-icon")}}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionUtil",{singleton:true,getVideoProfiles:function(){return[SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_MEDIUM,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_LOW]},isFileSupportRemux:function(a){return("mp4"===a.container_type||"matroska,webm"===a.container_type)&&("h264"===a.video_codec)},videoProfileToString:function(a){switch(a){case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL:return _VST("controller","quality_raw");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH:return _VST("controller","quality_high");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_MEDIUM:return _VST("controller","quality_medium");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_LOW:return _VST("controller","quality_low");default:}return""},audioCodecToString:function(a){return String.format("#{0} - {1}({2})",a.id,a.language,a.codec)}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",constructor:function(b){var a={tpl:this.getTpl(),cls:"offline-conversion-action-dataview",itemSelector:"div.offlne-conversion-wrap",overClass:"x-view-over",singleSelect:true};this.callParent([Ext.apply(a,b)])},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="offlne-conversion-wrap">','<div class="rearrange"></div>','<div class="thumb" style="background-image: url({[this.getImageURL(values)]})"></div>','<div class="info-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left" class="counter-wrap">','<div class="counter">{#} - </div>',"</td>",'<td align="left">','<div class="info">','<div class="title-wrap">',"{[this.getTitleBtnTpl(values)]}","</div>",'<div class="video-profile-wrap">','<div class="field">{[_VST("offline_conversion", "video_pofile")]}</div>',"{[this.getVideoProfileBtnTpl(values)]}","</div>",'<div class="audio-track-wrap">','<div class="field">{[_VST("offline_conversion", "audio_track")]}</div>',"{[this.getAudioTrackBtnTpl(values)]}","</div>","</div>","</td>","</tr></tbody></table></div>",'<div class="delete"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getTitleBtnTpl:this.getTitleBtnTpl.createDelegate(this),getVideoProfileBtnTpl:this.getVideoProfileBtnTpl.createDelegate(this),getAudioTrackBtnTpl:this.getAudioTrackBtnTpl.createDelegate(this)});return a},getImageURL:function(b){var a=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:a,id:b.id,mtime:b.poster_mtime})},getBtnTpl:function(a,b){return[String.format('<div class="dropdown-btn {0}">',a),String.format("<span>{0}</span>",b),"</div>"].join("")},getTitleBtnTpl:function(b){var a=b.file[b.selectedFileIndex];var c=Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.extractFileName(a.sharepath));return this.getBtnTpl("title",c)},getVideoProfileBtnTpl:function(a){var b=SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(a.selectedVideoProfile);return this.getBtnTpl("video-profile",b)},getAudioTrackBtnTpl:function(c){var a=c.file[c.selectedFileIndex];var b="";if(0>c.selectedAudioIndex||!Ext.isArray(a.audio_codecs)){b=_VST("offline_conversion","default_audio_track")}else{var d=a.audio_codecs[c.selectedAudioIndex];b=SYNO.SDS.VideoStation2.OfflineConversionUtil.audioCodecToString(d)}return this.getBtnTpl("audio-track",b)},getMenu:function(){this._menu=this._menu||new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true});return this._menu},showMenu:function(b,a){var c=this.getMenu();c.removeAll();Ext.each(b,function(d){c.add(d)},this);c.showAt(a)},onTitleClick:function(b,a){var d=function(g){b.data.selectedFileIndex=g.fileIndex;b.data.selectedAudioIndex=-1;var f=b.get("file")[b.get("selectedFileIndex")];if(SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(f)){b.data.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL}else{b.data.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH}b.commit()};var e=b.get("file");var c=[];Ext.each(e,function(g,f){c.push(new Ext.menu.Item({text:Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.extractFileName(g.sharepath)),fileIndex:f,scope:this,handler:d}))},this);this.showMenu(c,a)},onVideoProfileClick:function(b,a){var f=function(g){b.data.selectedVideoProfile=g.itemId;b.commit()};var e=b.get("file")[b.get("selectedFileIndex")];var d=SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(e);var c=[];Ext.each(SYNO.SDS.VideoStation2.OfflineConversionUtil.getVideoProfiles(),function(g){if(!d&&SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL===g){return}c.push({xtype:"menuitem",text:SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(g),itemId:g,scope:this,handler:f})},this);this.showMenu(c,a)},onAudioTrackClick:function(b,a){var d=function(h){b.data.selectedAudioIndex=h.audioIndex;b.commit()};var e=this;var g=function(i){var h=[];Ext.each(i,function(k,j){h.push(new Ext.menu.Item({text:SYNO.SDS.VideoStation2.OfflineConversionUtil.audioCodecToString(k),audioIndex:j,scope:this,handler:d}))},this);e.showMenu(h,a)};var c=b.get("file")[b.get("selectedFileIndex")];if(Ext.isArray(c.audio_codecs)){g(c.audio_codecs)}else{var f={success:function(j,i,h){b.data.file[b.get("selectedFileIndex")].audio_codecs=j.trackinfo;g(c.audio_codecs)},scope:this};SYNO.SDS.VideoStation2.OP.get().listAudioTrack({id:c.id},f)}},onClick:function(f,d,c){var g=Ext.get(d);var b=f.getTarget(this.itemSelector,this.getTemplateTarget());if(!g||!b){this.callParent(arguments);return}var a=this.getRecord(b);if(g.hasClass("title")||g.parent(".title")){this.onTitleClick(a,[g.getLeft(),g.getBottom()])}else{if(g.hasClass("video-profile")||g.parent(".video-profile")){this.onVideoProfileClick(a,[g.getLeft(),g.getBottom()])}else{if(g.hasClass("audio-track")||g.parent(".audio-track")){this.onAudioTrackClick(a,[g.getLeft(),g.getBottom()])}}}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){var a={layout:"fit",width:586,height:540,title:_VST("offline_conversion","action"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.OfflineConversionActionPanel(b)]};this.callParent([Ext.apply(a,b)])},onOKBtn:function(){var b=[];this.panel.getStore().each(function(c){var e=c.get("file")[c.get("selectedFileIndex")];var d=c.get("selectedAudioIndex");var f={file_id:e.id,video_profile:c.get("selectedVideoProfile")};if(0<=d){Ext.apply(f,{audio_id:parseInt(e.audio_codecs[d].id,10)})}b.push({api:"SYNO.VideoStation.OfflineConversion",method:"create",version:1,params:f})},this);var a={params:b,stopwhenerror:true};this.setStatusBusy();SYNO.API.Request({compound:a,callback:function(c,e,f,d){this.clearStatusBusy();if(!c||e.has_fail){this.setStatusError()}else{this.close()}},scope:this})}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.videos=b.videos;this.video_type=this.videos[0].type;this.callback=this.callback||{};var a={autoFlexcroll:true,layout:"fit",items:[this.getDataView()]};this.callParent([Ext.apply(a,b)]);this.loadView()},loadView:function(){var a=[];Ext.each(this.videos,function(c){a.push(c.id)},this);var b={id:Ext.encode(a)};this.getStore().load({params:b})},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores[this.video_type]({baseParams:{method:"getinfo",version:3,additional:Ext.encode(["poster_mtime","file"])},proxyClass:"SYNO.SDS.VideoStation2.OfflineConversionActionHttpProxy",readerCfg:{fields:["id","title","poster_mtime","type","selectedFileIndex","selectedAudioIndex","selectedVideoProfile","file"]}});return this._store},getDataView:function(){this._dataView=this._dataView||new SYNO.SDS.VideoStation2.OfflineConversionActionDataView({store:this.getStore()});return this._dataView}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionHttpProxy",{extend:"Ext.data.HttpProxy",constructor:function(a){this.callParent([a])},onRead:function(d,g,b){try{var c=Ext.decode(b.responseText);var a=g.reader.getRoot(c);Ext.each(a,function(e){SYNO.Assert(Ext.isDefined(e.additional)&&Ext.isArray(e.additional.file)&&0<e.additional.file.length,"OfflineConversionActionHttpProxy parser file failed");e.poster_mtime=e.additional.poster_mtime||"";e.selectedFileIndex=0;e.selectedAudioIndex=-1;e.file=e.additional.file;if(SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(e.file[e.selectedFileIndex])){e.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL}else{e.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH}},this);b.responseText=Ext.encode(c);this.callParent(arguments)}catch(f){this.fireEvent("loadexception",this,g,b,f);this.fireEvent("exception",this,"response",d,g,b,f);return}}});Ext.define("SYNO.SDS.VideoStation2.PublicSharingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,constructor:function(b){var a={layout:"fit",title:_VST("advanced","public_sharing"),width:450,height:160,buttons:[this.doneBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.close}),this.openLinkBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","open_link"),disabled:true,scope:this,handler:this.onOpenLinkBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.PublicSharingDialog.Panel()],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED,this.onPublicSharingChanged,this)},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().getPublicSharing({id:this.video.id,type:this.video.type},{scope:this,success:this.onPublicSharingLoaded,failure:this.onRequestFail})},onPublicSharingLoaded:function(c,b,a){this.clearStatusBusy();this.openLinkBtn.setDisabled(!c.enable);this.panel.fireEvent(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED,c)},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})},onPublicSharingChanged:function(a){this.setStatusBusy();this.openLinkBtn.setDisabled(!a);SYNO.SDS.VideoStation2.OP.get().setPublicSharing({enable:a,id:this.video.id,type:this.video.type},{scope:this,success:this.onUpdatePublicSharing,failure:this.onRequestFail})},onUpdatePublicSharing:function(c,b,a){this.clearStatusBusy();this.onEnableChanged(b.enable)},onOpenLinkBtn:function(){window.open(this.panel.getPublicSharingURL())},onEnableChanged:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation2.PublicSharingDialog.Panel",{statics:{EVENT_PUBLIC_SHARING_CHANGED:"publicsharingchanged",EVENT_PUBLIC_SHARING_LOADED:"publicsharingloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={defaults:{anchor:"100%"},updateFormForScrollbar:true,items:[this.enableCheckbox=new SYNO.SDS.VideoStation2.Checkbox({name:"enable",itemId:"enable",boxLabel:_VST("advanced","public_sharing"),listeners:{scope:this,check:this.onPublicSharingChecked}}),this.urlTextfield=new SYNO.SDS.VideoStation2.TextField({name:"url",itemId:"url",cls:"selectabletext",disabled:true,readOnly:true,selectOnFocus:true,hideLabel:true})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED);this.mon(this,SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED,this.onPublicSharingLoaded,this);this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable",["url"])]},getPublicSharingURL:function(){return this.getForm().getValues().url},onPublicSharingLoaded:function(a){this.getForm().setValues(a)},onPublicSharingChecked:function(b,a){this.fireEvent(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED,a)}});Ext.define("SYNO.SDS.VideoStation2.SearchSubtitleDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",file:null,onSubtitleDownloaded:Ext.emptyFn,constructor:function(b){var a={layout:"fit",title:_VST("controller","search_subtitle"),width:600,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),disabled:true,btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel(b)],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE,this.onSelectionChange,this);this.mon(this.panel,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_CHOOSE,this.onOKBtn,this)},onSelectionChange:function(a){this.okBtn.setDisabled(a.length===0)},onOKBtn:function(){var a=this.panel.getSelections();if(a.length===0){return}this.setStatusBusy();var b=a.map(function(c){if(c.get("downloaded")){return}return SYNO.SDS.VideoStation2.OP.get().downloadSubtitle({id:this.file.id,plugin_id:c.get("plugin_id"),download_id:c.get("id")},{})},this).filter(function(c){return Ext.isObject(c)});if(b.length===0){this.close();return}SYNO.SDS.VideoStation2.OP.compound(b,this.onRequestDone,this.onRequestFail,this)},onAfterRender:function(){this.setStatusBusy();SYNO.SDS.VideoStation2.OP.get().searchSubtitle({id:this.file.id},{scope:this,success:this.onSubtitleLoaded,failure:this.onRequestFail})},onSubtitleLoaded:function(c,b,a){this.clearStatusBusy();this.panel.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED,c.subtitles)},onRequestDone:function(c,b,a){this.clearStatusBusy();this.onSubtitleDownloaded();this.close()},onRequestFail:function(c,b,a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(c)})}});Ext.define("SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel",{extend:"SYNO.SDS.VideoStation2.GridPanel",statics:{EVENT_SUBTITLE_LOADED:"subtitleloaded",EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},constructor:function(b){var a={trackResetOnLoad:false,store:this.getStore(),viewConfig:{emptyText:_T("search","no_search_result")},colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("language","title"),dataIndex:"language"},{header:_VST("file","file_name"),dataIndex:"filename"},{header:_VST("video_info","source"),dataIndex:"plugin_title"}]}),selModel:new Ext.grid.RowSelectionModel({listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED);this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_CHOOSE);this.mon(this,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED,this.onSubtitleLoaded,this)},getStore:function(){this.store=this.store||new Ext.data.JsonStore({autoDestroy:true,id:"id",fields:["id","downloaded","filename","language","language_id","plugin_id","plugin_title","subtitle_id"]});return this.store},getSelections:function(){return this.getSelectionModel().getSelections()},onSubtitleLoaded:function(a){this.getStore().loadData(a)},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE,this.getSelections())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.VideoFileChooseDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,onVideoChoosed:Ext.emptyFn,files:null,constructor:function(b){var a={layout:"fit",title:_VST("error","select_one_video"),width:600,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),disabled:true,btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel(b)],listeners:{scope:this,beforeshow:{single:true,fn:this.onBeforeShow}}};this.callParent([Ext.apply(a,b)]);this.mon(this.panel,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE,this.onSelectionChange,this);this.mon(this.panel,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE,this.onOKBtn,this)},getFileByID:function(b){var a;Ext.each(this.files,function(c){if(c.id===b){a=c;return false}});return a},callVideoChoosed:function(a){this.onVideoChoosed.call(this,a);this.close()},onSelectionChange:function(a){this.okBtn.setDisabled(!a)},onOKBtn:function(){var a=this.panel.getSelected();if(!a){return}Ext.each(this.files,function(b){if(b.id===a.get("id")){this.callVideoChoosed(b);return false}},this)},onBeforeShow:function(){SYNO.SDS.VideoStation2.OP.get().getInfo({id:this.video.id,additional:Ext.encode(["file"])},{scope:this,success:this.onInfoLoaded,failure:this.onRequestFail},this.video.type);return false},onInfoLoaded:function(d,c,a){this.files=d[SYNO.SDS.VideoStation2.Util.getVideoRoot(this.video.type)][0].additional.file;var b;if(Ext.isNumber(this.video.file)){b=this.getFileByID(this.video.file)}else{if(this.files.length===1){b=this.files[0]}}if(b){this.callVideoChoosed(b);return}this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED,this.files);this.show()},onRequestFail:function(c,b,a){SYNO.SDS.VideoStation2.OP.defaultFailureCallback(c,b,a);this.close()}});Ext.define("SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel",{extend:"SYNO.SDS.VideoStation2.GridPanel",statics:{EVENT_INFO_LOADED:"infoloaded",EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},constructor:function(b){var a={trackResetOnLoad:false,store:this.getStore(),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("file","file_name"),dataIndex:"sharepath",renderer:function(e,d){var c=e.substr(e.lastIndexOf("/")+1);c=Ext.util.Format.htmlEncode(c);d.attr=String.format('ext:qtip="{0}"',Ext.util.Format.htmlEncode(e));return c}},{header:_VST("duration","title"),dataIndex:"duration"},{header:_T("common","size"),dataIndex:"filesize",renderer:function(c){return Ext.util.Format.fileSize(c)}}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED);this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE);this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE);this.mon(this,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED,this.onInfoLoaded,this)},getStore:function(){this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","sharepath","duration","filesize"],autoDestroy:true});return this.store},getSelected:function(){return this.getSelectionModel().getSelected()},onInfoLoaded:function(a){this.store.loadData(a)},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE)}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",statics:{EVENT_FILE_CHANGE:"filechange"},files:[],index:0,constructor:function(b){var a={padding:"20px 30px 0px 48px",cls:"video-info-dialog",layout:"fit",title:_VST("action","view_video_info"),width:680,height:500,useStatusBar:false,buttonAlign:"left",fbar:new SYNO.ux.Toolbar({cls:"x-statusbar",items:[{xtype:"tbspacer",width:10},this.getPrevButton(),this.getNextButton(),"->",this.getCloseButton()]}),items:[this.panel=new SYNO.SDS.VideoStation2.VideoInfoDialog.Panel()],listeners:{scope:this,afterrender:{fn:this.onAfterRender,single:true}}};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.onFileChange,this);this.mon(this.panel,SYNO.SDS.VideoStation2.VideoInfoDialog.Panel.EVENT_INFO_UPDATE,this.doLayout,this);this.getPrevButton().setVisible(this.files.length>1);this.getNextButton().setVisible(this.files.length>1)},onAfterRender:function(){this.onFileChange(this.index)},onFileChange:function(a){this.getPrevButton().setDisabled(a<=0);this.getNextButton().setDisabled(a+1>=this.files.length);this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.Panel.EVENT_LOAD_FILE,this.files[a])},getPrevButton:function(){this._prev_btn=this._prev_btn||new SYNO.SDS.VideoStation2.Button({cls:"action prev",scope:this,handler:this.goPrevious});return this._prev_btn},getNextButton:function(){this._next_btn=this._next_btn||new SYNO.SDS.VideoStation2.Button({cls:"action next",scope:this,handler:this.goNext});return this._next_btn},getCloseButton:function(){this._close_btn=this._close_btn||new SYNO.SDS.VideoStation2.Button({text:_T("common","close"),scope:this,handler:this.close});return this._close_btn},goPrevious:function(){SYNO.Assert(this.index>0,"unable to go previous");this.index--;this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.index)},goNext:function(){SYNO.Assert(this.index+1<this.files.length,"unable to go next");this.index++;this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.index)}});Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",{statics:{EVENT_LOAD_FILE:"loadfile",EVENT_INFO_UPDATE:"infoupdate",FIELDS:[{name:"filename",label:_VST("file","file_name")},{name:"sharepath",label:_VST("file","file_path")},{name:"duration",label:_VST("duration","title")},{name:"formated_filesize",label:_T("common","size")},{name:"resolution",label:_VST("video_info","resolution")},{name:"container_type",label:_VST("video_info","container")},{name:"video_codec",label:_VST("video_info","video_codec")},{name:"audio_codec",label:_VST("video_info","audio_codec")},{name:"video_bitrate",label:_VST("video_info","video_bitrate")}]},extend:"SYNO.ux.Panel",constructor:function(b){var a={cls:"info-panel",layout:"table",layoutConfig:{columns:2},autoFlexcroll:true,items:this.getItems()};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.VideoInfoDialog.Panel.EVENT_LOAD_FILE);this.mon(this,SYNO.SDS.VideoStation2.VideoInfoDialog.Panel.EVENT_LOAD_FILE,this.loadFile,this)},getItems:function(){return SYNO.SDS.VideoStation2.VideoInfoDialog.Panel.FIELDS.map(function(a){return[{xtype:"container",cls:"label",html:Ext.util.Format.htmlEncode(a.label)},{xtype:"container",itemId:a.name,cls:"value",html:""}]}).reduce(function(a,b){return a.concat(b)},[])},loadFile:function(a){a.filename=a.sharepath.split("/").pop();a.formated_filesize=Ext.util.Format.fileSize(a.filesize);a.resolution=String.format("{0} x {1}",a.resolutionx,a.resolutiony);a.video_bitrate=SYNO.SDS.VideoStation2.Util.formatBitrate(a.frame_bitrate);this.setPanelValues(a)},setPanelValues:function(a){this.items.each(function(b){if(Ext.isString(b.itemId)&&Ext.isDefined(a[b.itemId])&&Ext.isFunction(b.update)){b.update(Ext.util.Format.htmlEncode(a[b.itemId]))}});this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.Panel.EVENT_INFO_UPDATE)}});Ext.define("SYNO.SDS.VideoStation2.VideoActionController",{statics:{ACTION_VIEW_VIDEO_INFO:"view_video_info",ACTION_EDIT_METADATA:"edit_metadata",ACTION_CORRECT_METADATA:"correct_metadata",ACTION_SEARCH_SUBTITLE:"search_subtitle",ACTION_PUBLIC_SHARING:"public_sharing",ACTION_SET_WATCHED:"set_watched",ACTION_SET_UNWATCHED:"set_unwatched",ACTION_DEL_VIDEO:"del_video",ACTION_DEL_FILE:"del_file",ACTION_OFFLINE_CONVERSION:"offline_conversion",getAllActions:function(){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_VIEW_VIDEO_INFO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE,SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE]},doVideoAction:function(b,a,c){switch(b){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_VIEW_VIDEO_INFO:return SYNO.SDS.VideoStation2.VideoActionController.viewVideoInfo(a);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.correctMetadata(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.editMetadata(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE:return SYNO.SDS.VideoStation2.VideoActionController.searchSubtitle(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING:return SYNO.SDS.VideoStation2.VideoActionController.publicSharing(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:return SYNO.SDS.VideoStation2.VideoActionController.setWatched(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:return SYNO.SDS.VideoStation2.VideoActionController.setUnwatched(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO:return SYNO.SDS.VideoStation2.VideoActionController.delVideo(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE:return SYNO.SDS.VideoStation2.VideoActionController.delFile(a,c);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION:return SYNO.SDS.VideoStation2.VideoActionController.offlineConversion(a,c);default:SYNO.Debug.error(String.format("unknown video action {0}",b))}},createPlaylist:function(c,a){var b=new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,videos:c,onVideoAdded:a});b.open()},getOneVideoFileInfo:function(b,c){var a=new SYNO.SDS.VideoStation2.VideoFileChooseDialog({owner:SYNO.SDS.VideoStation2.Window,video:b,onVideoChoosed:c});a.open()},viewVideoInfo:function(a){SYNO.Assert(a.length===1,"viewVideoInfo only allow one video");var b=a[0];var c=function(g,f,d){var e=new SYNO.SDS.VideoStation2.VideoInfoDialog({owner:SYNO.SDS.VideoStation2.Window,files:g[SYNO.SDS.VideoStation2.Util.getVideoRoot(b.type)][0].additional.file||[]});e.open()};SYNO.SDS.VideoStation2.OP.get().getInfo({id:b.id,additional:Ext.encode(["file"])},{scope:this,success:c},b.type)},correctMetadata:function(a,c){SYNO.Assert(a.length===1,"correctMetadata only allow one video");var b=a[0];if(Ext.isNumber(b.file)){SYNO.SDS.VideoStation2.VideoActionController.doCorrectMetadata(b,c)}else{SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(b,function(d){b.file=d.id;SYNO.SDS.VideoStation2.VideoActionController.doCorrectMetadata(b,c)})}},editMetadata:function(b,d){SYNO.Assert(b.length===1,"editMetadata only allow one video");var c=b[0];c.library_id=SYNO.SDS.VideoStation2.Library.get().getCurrentID();var a=new SYNO.SDS.VideoStation2.EditMetadataDialog({owner:SYNO.SDS.VideoStation2.Window,video:c,onVideoMetadataEdited:d});a.open()},searchSubtitle:function(a,b){SYNO.Assert(a.length===1,"searchSubtitle only allow one video");SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a[0],function(d){var c=new SYNO.SDS.VideoStation2.SearchSubtitleDialog({owner:SYNO.SDS.VideoStation2.Window,file:d,onSubtitleDownloaded:b});c.open()})},publicSharing:function(b,d){var a;d=Ext.isFunction(d)?d:Ext.emptyFn;var c={};b.each(function(e){c[e.id.toString()+","+e.type]=true});c=Object.keys(c).map(function(f){var e=f.split(",");return{id:parseInt(e[0],10),type:e[1]}});if(c.length===1){a=new SYNO.SDS.VideoStation2.PublicSharingDialog({owner:SYNO.SDS.VideoStation2.Window,video:c[0],onEnableChanged:d})}else{a=new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,forcePublicSharing:true,videos:c,onVideoAdded:d})}a.open()},setWatched:function(a,b){SYNO.SDS.VideoStation2.VideoActionController.setWatchStatus(a,true,b)},setUnwatched:function(a,b){SYNO.SDS.VideoStation2.VideoActionController.setWatchStatus(a,false,b)},setWatchStatus:function(b,c,d){var a=function(g,f){var e=g[f].map(function(h){return h.id}).uniq();return SYNO.SDS.VideoStation2.OP.get().setVideoWatched({id:Ext.encode(e),watched:(c)?true:false},{},f)};SYNO.SDS.VideoStation2.OP.classifyRequest(b,a,d)},offlineConversion:function(b,c){var a=new SYNO.SDS.VideoStation2.OfflineConversionActionDialog({videos:b,callback:c});a.open()},confirmDelete:function(a,b){var c=String.format(_VST("action","delete_video_confirm"),b);SYNO.SDS.VideoStation2.Window.getMsgBox().confirmDelete("",c,function(d){if(d==="yes"){a()}})},delFile:function(a,b){SYNO.Assert(a.length===1,"delete file only allow one video");SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a[0],function(d){var c=function(){SYNO.SDS.VideoStation2.VideoActionController.doDelFile([d.id],b)};SYNO.SDS.VideoStation2.VideoActionController.confirmDelete(c,1)})},delVideo:function(b,c){var a=function(){SYNO.SDS.VideoStation2.VideoActionController.doDelVideo(b,c)};SYNO.SDS.VideoStation2.VideoActionController.confirmDelete(a,b.length)},doCorrectMetadata:function(b,c){var a=new SYNO.SDS.VideoStation2.EditMetadataDialog({owner:SYNO.SDS.VideoStation2.Window,video:b,onVideoMetadataEdited:c});a.open()},doDelVideo:function(b,d){if(Ext.isNumber(b[0].file)){var c=b.map(function(e){return e.file});SYNO.SDS.VideoStation2.VideoActionController.doDelFile(c,d)}else{var a=function(g,f){var e=g[f].map(function(h){return h.id}).uniq();return SYNO.SDS.VideoStation2.OP.get().deleteVideo({videos:Ext.encode(e)},{},f)};SYNO.SDS.VideoStation2.OP.classifyRequest(b,a,d)}},doDelFile:function(a,b){SYNO.SDS.VideoStation2.OP.get().deleteFile({files:Ext.encode(a)},{success:b})},applyWatchStatusChangeToVideo:function(a,b){a.each(function(d){var c=d.record.get("additional")||{};c.watched_ratio=(b)?1:0;d.record.set("additional",c);d.record.commit()})}}});Ext.define("SYNO.SDS.VideoStation2.ActionUtil",{singleton:true,isAdminAction:function(a){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE].indexOf(a)!==-1},getAvailablePlaylistActions:function(){var a=SYNO.SDS.VideoStation2.PlaylistActionController.getAllActions();return a.filter(function(b){if(b===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()){return false}return true})},getAvailableVideoActions:function(){var a=SYNO.SDS.VideoStation2.VideoActionController.getAllActions();return a.filter(function(b){if(!_S("is_admin")&&SYNO.SDS.VideoStation2.ActionUtil.isAdminAction(b)){return false}if(b===SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()){return false}return true})}});Ext.define("SYNO.SDS.VideoStation2.AboutWindow",{extend:"SYNO.SDS.AboutWindow",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-about-window")}});Ext.define("SYNO.SDS.VideoStation2.AccordionPanel",{extend:"SYNO.ux.Panel",header:true,constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-accordion-panel");this.mon(this,"activate",this.addExpandedClass,this);this.mon(this,"deactivate",this.removeExpandedClass,this);this.mon(this,"afterrender",this.initExpandedClass,this,{single:true})},initExpandedClass:function(){if(this.header&&!this.collapsed){this.addExpandedClass()}},addExpandedClass:function(){if(this.header){this.header.addClass("expanded")}},removeExpandedClass:function(){if(this.header){this.header.removeClass("expanded")}}});Ext.define("SYNO.SDS.VideoStation2.ActionButton",{extend:"SYNO.ux.Button",constructor:function(a){this.callParent([a]);this.addClass("syno-vs2-action-button")}});Ext.define("SYNO.SDS.VideoStation2.MenuActionButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(d){d=d||{};var b=d.noicon===true?true:false;var a=d.menuBeforeShow||{};var c={handler:Ext.emptyFn,menu:d.menu||new SYNO.SDS.VideoStation2.DropdownMenu({noicon:b,items:[],listeners:{beforeshow:{scope:a.scope||this,fn:a.fn||Ext.emptyFn}}})};delete d.beforeshow;delete d.noicon;this.callParent([Ext.apply(c,d)]);this.addClass("menu-action-button")}});Ext.define("SYNO.SDS.VideoStation2.BrowsingAction",{statics:{EVENT_BROWSING_ACTION_CHANGED:"browsingactionchanged",ACTION_NONE:"none",ACTION_SELECT:"select",ACTION_DETAIL:"detail",ACTION_LIST:"list",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.BrowsingAction.instance)){SYNO.SDS.VideoStation2.BrowsingAction.instance=new SYNO.SDS.VideoStation2.BrowsingAction()}return SYNO.SDS.VideoStation2.BrowsingAction.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED);this.toList()},selectAction:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted action {0}",a));if(this.current_action!==a){this.current_action=a;this.fireEvent(SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED)}},toNone:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_NONE)},toSelect:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_SELECT)},toDetail:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_DETAIL)},toList:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_LIST)},getCurrentAction:function(){SYNO.Assert(Ext.isString(this.current_action),String.format("unexpceted action {0}",this.current_action));return this.current_action},current_action:null});Ext.define("SYNO.SDS.VideoStation2.Category",{statics:{instance:null,EVENT_CATEGORY_CHANGED:"categorychanged",CATEGORY_RECENTLY_ADDED:"recently_added",CATEGORY_RECENTLY_WATCHED:"recently_watched",CATEGORY_RECENTLY_RELEASED:"recently_released",CATEGORY_ALL:"all",CATEGORY_FOLDER:"folder",get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Category.instance)){SYNO.SDS.VideoStation2.Category.instance=new SYNO.SDS.VideoStation2.Category()}return SYNO.SDS.VideoStation2.Category.instance},getAllCategories:function(){return[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED);this.current_category=SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED},selectCategory:function(b){SYNO.Assert(Ext.isString(b),String.format("unexpceted category {0}",b));if(this.current_category!==b){var a=this.current_category;this.current_category=b;this.fireEvent(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,a,b)}},getCurrentCategory:function(){SYNO.Assert(Ext.isString(this.current_category),String.format("unexpceted category {0}",this.current_category));return this.current_category},getSortOption:function(){var a={};switch(this.current_category){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:a.sort_by="added";break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:a.sort_by="watched";break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:a.sort_by="date";break;default:break}if(a.sort_by){a.sort_direction="desc"}return a},current_category:null});Ext.define("SYNO.SDS.VideoStation2.File",{statics:{EVENT_FILE_CHANGE:"filechange",EVENT_FILE_LOAD:"fileload",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.File.instance)){SYNO.SDS.VideoStation2.File.instance=new SYNO.SDS.VideoStation2.File()}return SYNO.SDS.VideoStation2.File.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},loadFile:function(a){SYNO.Assert(Ext.isArray(a)&&!Ext.isEmpty(a),String.format("bad file object array {0}",a));this.files=a;this.current_idx=null;this.fireEvent(SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD)},selectFile:function(b){SYNO.Assert(Ext.isNumber(b)&&b>0,"bad file id");try{if(this.getCurrentID()===b){return}}catch(a){}this.audiotrack=null;this.subtitle=null;this.current_idx=this.getFileIndexByID(b);this.fireEvent(SYNO.SDS.VideoStation2.File.EVENT_FILE_CHANGE)},selectAudiotrack:function(a){SYNO.Assert(Ext.isNumber(a),String.format("bad audiotrack id ({0})",a));this.audiotrack=a},selectSubtitle:function(a){SYNO.Assert(Ext.isString(a),String.format("bad subtitle id ({0})",a));this.subtitle=a},setPreSelectFile:function(a){this.pre_select_file=a},getFileIndexByID:function(b){var a=null;Ext.each(this.files||[],function(d,c){if(d.id===b){a=c;return false}});return a},hasMultipleFile:function(){return this.files.length>1},getCurrentID:function(){SYNO.Assert(Ext.isNumber(this.current_idx)&&Ext.isArray(this.files)&&!Ext.isEmpty(this.files),"file not set");return this.files[this.current_idx].id},getFileByID:function(b){var a=this.getFileIndexByID(b);return Ext.isNumber(a)?SYNO.Util.copy(this.files[a]):null},getAllFiles:function(){return SYNO.Util.copy(this.files)},getPreSelectFile:function(){return this.pre_select_file},getAudiotrack:function(){return this.audiotrack},getSubtitle:function(){return this.subtitle},files:null,current_idx:null,audiotrack:null,pre_select_file:null,subtitle:null});Ext.define("SYNO.SDS.VideoStation2.Folder",{statics:{FOLDER_NULL:null,instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Folder.instance)){SYNO.SDS.VideoStation2.Folder.instance=new SYNO.SDS.VideoStation2.Folder()}return SYNO.SDS.VideoStation2.Folder.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.resetData()},resetData:function(){this.current_folder=[]},selectFolder:function(b,a){SYNO.Assert(Ext.isString(b),String.format("unexpceted FolderPath {0}",b));this.current_folder.push({id:b,pathTitle:a})},thrinkFolderStackTo:function(b){if(b===SYNO.SDS.VideoStation2.Folder.FOLDER_NULL){this.resetData();return}var a=-1;Ext.each(this.current_folder,function(d,c){if(d.id===b.id){a=c;return false}});if(a!==-1){this.current_folder=this.current_folder.slice(0,a+1)}},getCurrentID:function(){if(this.current_folder.length===0){return null}return this.current_folder.last().id},getCurrentPathTitle:function(){if(this.current_folder.length===0){return null}return this.current_folder.last().pathTitle},getCurrentFolderStack:function(){return SYNO.Util.copy(this.current_folder)},current_folder:null});Ext.define("SYNO.SDS.VideoStation2.Navigation",{statics:{EVENT_NAVIGATION_PATH_CHANGED:"navpathchanged",EVENT_NAVIGATION_TYPE_CHANGED:"navtypechanged",EVENT_NAVIGATION_GOBACK:"navgoback",TYPE_PATH:"path",TYPE_CATEGORY:"category",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Navigation.instance)){SYNO.SDS.VideoStation2.Navigation.instance=new SYNO.SDS.VideoStation2.Navigation()}return SYNO.SDS.VideoStation2.Navigation.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK);this.toCategory()},setNavigation:function(a,b){if(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted type {0}",a));if(this.current_type!==a){this.current_type=a;this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED)}}if(b!==null){SYNO.Assert(Ext.isArray(b),["unexpceted path {0}",b]);if(!SYNO.ux.Utils.checkObjectConsistency(this.current_path,b)){this.current_path=b;this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED)}}},toPath:function(a){this.setNavigation(SYNO.SDS.VideoStation2.Navigation.TYPE_PATH,a)},toCategory:function(){this.setNavigation(SYNO.SDS.VideoStation2.Navigation.TYPE_CATEGORY,null)},goback:function(){this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK)},getCurrentPath:function(){return this.current_path},getCurrentType:function(){SYNO.Assert(Ext.isString(this.current_type),String.format("unexpceted nav type {0}",this.current_type));return this.current_type},current_path:null,current_type:null});Ext.define("SYNO.SDS.VideoStation2.TVShow",{statics:{EVENT_TVSHOW_CHANGED:"tvshowchanged",EVENT_SEASON_CHANGED:"seasonchanged",EVENT_AVAIL_SEASONS_LOADED:"availseasonsloaded",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.TVShow.instance)){SYNO.SDS.VideoStation2.TVShow.instance=new SYNO.SDS.VideoStation2.TVShow()}return SYNO.SDS.VideoStation2.TVShow.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED)},selectTVShow:function(a){SYNO.Assert(Ext.isObject(a),["unexpceted tvshow",a]);var b=this.current_tvshow;this.current_tvshow=a;this.avail_seasons=null;this.current_season=null;this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,b,a)},updateTVShow:function(a){SYNO.Assert(Ext.isObject(a)&&a.id===this.current_tvshow.id,["unexpceted tvshow",a]);this.current_tvshow=a},selectSeason:function(b){SYNO.Assert(Ext.isNumber(b),String.format("unexpceted season {0}",b));if(b!==this.current_season){var a=this.current_season;this.current_season=b;this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,a,b)}},setAvailableSeasons:function(a){SYNO.Assert(Ext.isArray(a),["unexpceted seasons",a]);if(!SYNO.ux.Utils.checkObjectConsistency(this.avail_seasons,a)){this.avail_seasons=a;if(this.avail_seasons.indexOf(this.current_season)===-1){this.current_season=null}this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED);this.selectSeason(a[0])}},getCurrentTVShow:function(){return this.current_tvshow},getCurrentID:function(){SYNO.Assert(Ext.isObject(this.current_tvshow),["unexpceted tvshow",this.current_tvshow]);var a=this.current_tvshow.id;SYNO.Assert(Ext.isNumber(a),String.format("unexpceted tvshow id {0}",a));return a},getCurrentSeason:function(){return this.current_season},getTotalSeasons:function(){SYNO.Assert(Ext.isObject(this.current_tvshow),["unexpceted tvshow",this.current_tvshow]);var a=this.current_tvshow.additional;SYNO.Assert(Ext.isObject(a),["unexpceted tvshow additional",a]);var b=this.current_tvshow.additional.total_seasons;SYNO.Assert(Ext.isNumber(b),String.format("unexpceted total seasons {0}",b));return b},getAvailableSeasons:function(){return this.avail_seasons},current_tvshow:null,current_season:null,avail_seasons:null});Ext.define("SYNO.SDS.VideoStation2.Video",{statics:{EVENT_VIDEO_SELECTION_CHANGED:"videoselectionchanged",EVENT_VIDEO_SELECT_MODE_CHANGED:"videoselectmodechanged",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Video.instance)){SYNO.SDS.VideoStation2.Video.instance=new SYNO.SDS.VideoStation2.Video()}return SYNO.SDS.VideoStation2.Video.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.current_video_selection=[];this.current_videolist=[];this.select_mode=false},selectVideo:function(a){SYNO.Assert(Ext.isObject(a)&&Ext.isNumber(a.id)&&a.id>0&&Ext.isString(a.type),String.format("bad video object {0}",a));this.video=a},clearVideo:function(){this.video={}},addVideoSelection:function(e,a,c,b,d){SYNO.Assert(Ext.isNumber(e)&&e>0&&Ext.isString(c),String.format("unexpceted video info {0}:{1}",e,c));if(!this.hasVideoSelection(e,a,c,b)){this.current_video_selection.push({id:e,type:c,mapper_id:a,file:b,playlists:d});this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED)}},removeVideoSelection:function(d,a,c,b){SYNO.Assert(Ext.isNumber(d)&&d>0&&Ext.isString(c),String.format("unexpceted video info {0}:{1}",d,c));if(this.hasVideoSelection(d,a,c,b)){this.current_video_selection=this.current_video_selection.filter(function(e){return e.id!==d||e.type!==c||e.mapper_id!==a||e.file!==b});this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED)}},hasVideoSelection:function(e,a,c,b){SYNO.Assert(Ext.isNumber(e)&&e>0&&Ext.isString(c),String.format("unexpceted video info {0}:{1}",e,c));var d=false;Ext.each(this.current_video_selection,function(f){if(f.id===e&&f.type===c&&f.mapper_id===a&&f.file===b){d=true;return false}});return d},toggleVideoSelection:function(e,a,c,b,d){SYNO.Assert(Ext.isNumber(e)&&e>0&&Ext.isString(c),String.format("unexpceted video info {0}:{1}",e,c));if(this.hasVideoSelection(e,a,c,b)){this.removeVideoSelection(e,a,c,b)}else{this.addVideoSelection(e,a,c,b,d)}},clearVideoSelection:function(){if(this.current_video_selection.length!==0){this.current_video_selection=[];this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED)}},enterSelectMode:function(){if(!this.select_mode){this.select_mode=true;this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED)}},leaveSelectMode:function(){if(this.select_mode){this.select_mode=false;this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED)}},setVideolist:function(a){SYNO.Assert(Ext.isArray(a),["unexpceted video list",a]);this.current_videolist=a},clearVideolist:function(){this.current_videolist=[]},getCurrentID:function(){return this.video.id},getCurrentType:function(){return this.video.type},getCurrentVideo:function(){return SYNO.Util.copy(this.video)},getIdxInVideolist:function(d,c,b){var a=-1;Ext.each(this.current_videolist,function(f,e){if(f.id===d&&f.type===c&&(!Ext.isDefined(f.file)||f.file===b)){a=e;return false}});return a},getNextFromVideolist:function(){var b=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();var a=this.getIdxInVideolist(this.video.id,this.video.type,b);if(a===-1||a===this.current_videolist.length-1){return}return this.current_videolist[a+1]},getPrevFromVideolist:function(){var b=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();var a=this.getIdxInVideolist(this.video.id,this.video.type,b);if(a===-1||a===0){return}return this.current_videolist[a-1]},getCurrentPathTitle:function(){return this.video.pathTitle},getCurrentVideoSelection:function(){return this.current_video_selection},isVideoSelectionEmpty:function(){return Ext.isEmpty(this.current_video_selection)},isInSelectMode:function(){return this.select_mode},video:{},current_video_selection:null,select_mode:null,current_videolist:null});Ext.define("SYNO.SDS.VideoStation2.Sort",{statics:{instance:null,EVENT_SORT_CHANGED:"sortchanged",SORT_RECENTLY_ADDED:"recently_added",SORT_RECENTLY_RELEASED:"recently_released",SORT_TITLE:"title",DIR_DESC:"desc",DIR_ASC:"asc",get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Sort.instance)){SYNO.SDS.VideoStation2.Sort.instance=new SYNO.SDS.VideoStation2.Sort()}return SYNO.SDS.VideoStation2.Sort.instance},getAllSorts:function(){return[SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Sort.SORT_TITLE]},getAllDirections:function(){return[SYNO.SDS.VideoStation2.Sort.DIR_ASC,SYNO.SDS.VideoStation2.Sort.DIR_DESC]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.current_sort=SYNO.SDS.VideoStation2.Sort.SORT_TITLE;this.current_dir=SYNO.SDS.VideoStation2.Sort.DIR_ASC},setSort:function(b,a){var c=false;if(null!==b){SYNO.Assert(Ext.isString(b),String.format("unexpceted sort {0}",b));if(this.current_sort!==b){this.current_sort=b;c=true}}if(null!==a){SYNO.Assert(Ext.isString(a),String.format("unexpceted dir {0}",a));if(this.current_dir!==a){this.current_dir=a;c=true}}if(c){this.fireEvent(SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED)}},setSortType:function(a){this.setSort(a,null)},setSortDir:function(a){this.setSort(null,a)},getCurrentSort:function(){SYNO.Assert(Ext.isString(this.current_sort),String.format("unexpceted sort {0}"),this.current_sort);return this.current_sort},getCurrentSortDir:function(){SYNO.Assert(Ext.isString(this.current_dir),String.format("unexpceted sort dir {0}"),this.current_dir);return this.current_dir},getSortOption:function(){var a={};switch(this.current_sort){case SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED:a.sort_by="added";break;case SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED:a.sort_by="date";break;case SYNO.SDS.VideoStation2.Sort.SORT_TITLE:a.sort_by="title";break;default:break}if(this.current_dir){a.sort_direction=this.current_dir}return a},current_sort:null,current_dir:null});Ext.define("SYNO.SDS.VideoStation2.VideoListController",{statics:{toRecentlyAddedCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toRecentlyWatchCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false)},toRecentlyReleasedCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toAllCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_ALL);SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_TITLE,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toFolderCategory:function(){SYNO.SDS.VideoStation2.Folder.get().resetData();SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER)},toSortType:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSortType(a)},toSortDirection:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.Sort.get().setSortDir(a)},toSelectMode:function(c,a){var b=SYNO.SDS.VideoStation2.Video.get();b.clearVideoSelection();if(c){b.enterSelectMode()}else{b.leaveSelectMode()}if(a){if(c){SYNO.SDS.VideoStation2.BrowsingAction.get().toSelect()}else{SYNO.SDS.VideoStation2.BrowsingAction.get().toList()}}}}});Ext.define("SYNO.SDS.VideoStation2.View",{statics:{VIEW_HOMEPAGE:"view_homepage",VIEW_PLAYLIST:"view_playlist",VIEW_POSTER:"view_poster",VIEW_DETAIL:"view_detail",VIEW_TVSHOW:"view_tvshow",TYPE_THUMBNAIL:"thumbnail",TYPE_TILE:"tile",TYPE_LIST:"list",EVENT_VIEW_CHANGED:"viewchanged",EVENT_VIEWTYPE_CHANGED:"viewtypechanged",EVENT_VIEW_REFRESH:"viewrefresh",EVENT_VIEW_REFRESH_INFO:"viewrefreshinfo",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.View.instance)){SYNO.SDS.VideoStation2.View.instance=new SYNO.SDS.VideoStation2.View()}return SYNO.SDS.VideoStation2.View.instance},getAllTypes:function(){return[SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL,SYNO.SDS.VideoStation2.View.TYPE_TILE,SYNO.SDS.VideoStation2.View.TYPE_LIST]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH);this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO);this.viewType=SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL},setPageView:function(a){if(this.view!==a){this.view=a;this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED)}else{this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)}},toHomePageView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE)},toPlaylistView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST)},toPosterView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_POSTER)},toDetailView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_DETAIL)},toTVShowView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_TVSHOW)},toEmptyView:function(){this.setPageView(null)},setViewType:function(a){SYNO.Assert(Ext.isString(a),String.format("unexpceted viewtype {0}",a));if(this.viewType!==a){this.viewType=a;this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED)}},toThumbnailType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL)},toTileType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_TILE)},toListType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_LIST)},getView:function(){return this.view},getViewType:function(){SYNO.Assert(Ext.isString(this.viewType),String.format("unexpceted viewtype {0}",this.viewType));return this.viewType},view:null,viewType:null});Ext.define("SYNO.SDS.VideoStation2.Controller",{statics:{setBackdrop:function(a){var b=String.format('url("{0}")',a);SYNO.SDS.VideoStation2.Window.getEl().select(".background-poster").each(function(c){c.setStyle("background-image",b)})},switchLibrary:function(c){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);var b=SYNO.SDS.VideoStation2.Library.get();var a=SYNO.SDS.VideoStation2.View.get();SYNO.SDS.VideoStation2.View.get().toEmptyView();SYNO.SDS.VideoStation2.Folder.get().resetData();SYNO.SDS.VideoStation2.Filter.get().clearAllFilter();SYNO.SDS.VideoStation2.Video.get().clearVideo();if(Ext.isString(c)){b.activate(c)}if(SYNO.SDS.VideoStation2.Constant.TV_RECORDING===b.getCurrentType()){SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory()}if(SYNO.SDS.VideoStation2.Constant.PLAYLIST===b.getCurrentType()){if(SYNO.SDS.VideoStation2.View.get().getViewType()===SYNO.SDS.VideoStation2.View.TYPE_TILE){SYNO.SDS.VideoStation2.View.get().toThumbnailType()}SYNO.SDS.VideoStation2.BrowsingAction.get().toList();a.toPlaylistView()}else{SYNO.SDS.VideoStation2.BrowsingAction.get().toList();a.toPosterView()}SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},switchLibraryTemporary:function(a){SYNO.SDS.VideoStation2.Library.get().activateTemporary(a)},refreshView:function(){SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)},refreshViewInfo:function(a){SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,a)},intoHomePage:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory();SYNO.SDS.VideoStation2.BrowsingAction.get().toNone();if(a!==true){SYNO.SDS.VideoStation2.View.get().toEmptyView();SYNO.SDS.VideoStation2.Filter.get().clearAllFilter()}SYNO.SDS.VideoStation2.View.get().toHomePageView();SYNO.SDS.VideoStation2.Library.get().activate("");SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},intoPlaylistView:function(b,a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toList();if(Ext.isDefined(b)){SYNO.SDS.VideoStation2.Playlist.get().selectPlaylist(b,a)}SYNO.SDS.VideoStation2.View.get().toPlaylistView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},intoPosterView:function(c,b,a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);if(Ext.isDefined(c)){SYNO.SDS.VideoStation2.View.get().toEmptyView();if(SYNO.SDS.VideoStation2.Constant.PLAYLIST===c){SYNO.SDS.VideoStation2.Playlist.get().selectPlaylist(b,a)}else{SYNO.SDS.VideoStation2.Folder.get().selectFolder(b,a)}}if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW){SYNO.SDS.VideoStation2.Video.get().clearVideo()}SYNO.SDS.VideoStation2.BrowsingAction.get().toList();SYNO.SDS.VideoStation2.View.get().toPosterView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},intoVideoDetail:function(a,b){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toDetail();if(Ext.isArray(b)){SYNO.SDS.VideoStation2.Video.get().setVideolist(b)}if(Ext.isObject(a)){SYNO.SDS.VideoStation2.Video.get().selectVideo(a);SYNO.SDS.VideoStation2.Controller.preSelectFile(Ext.isNumber(a.file)?a.file:null)}SYNO.SDS.VideoStation2.View.get().toDetailView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},intoTVShow:function(a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toList();if(Ext.isDefined(a)){SYNO.SDS.VideoStation2.TVShow.get().selectTVShow(a)}SYNO.SDS.VideoStation2.View.get().toTVShowView();SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},loadFile:function(a){SYNO.SDS.VideoStation2.File.get().loadFile(a)},switchFile:function(a){SYNO.SDS.VideoStation2.File.get().selectFile(a)},preSelectFile:function(a){SYNO.SDS.VideoStation2.File.get().setPreSelectFile(a)},setFilter:function(a,b){SYNO.SDS.VideoStation2.View.get().toEmptyView();if(a===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){SYNO.SDS.VideoStation2.Filter.get().setKeyword(b)}else{SYNO.SDS.VideoStation2.Filter.get().clearAllFilter();SYNO.SDS.VideoStation2.Filter.get().addFilter(a,b);if(SYNO.SDS.VideoStation2.Library.get().isDeactivated()){SYNO.SDS.VideoStation2.Library.get().activateFromTemporary()}}if(SYNO.SDS.VideoStation2.Library.get().isDeactivated()){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toNone();SYNO.SDS.VideoStation2.View.get().toHomePageView()}else{SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false);SYNO.SDS.VideoStation2.BrowsingAction.get().toList();SYNO.SDS.VideoStation2.VideoListController.toAllCategory();SYNO.SDS.VideoStation2.View.get().toPosterView()}SYNO.SDS.VideoStation2.Controller.updatePath();SYNO.SDS.VideoStation2.Controller.updateHistory()},goback:function(){SYNO.SDS.VideoStation2.Navigation.get().goback()},getClassificationString:function(b,c){var a="";if(c===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO&&b===SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED){a="recently_recoded"}else{a=b}return _VST("classification",a)},updatePath:function(){var a=SYNO.SDS.VideoStation2.Category.get();var k=SYNO.SDS.VideoStation2.Library.get();var j=SYNO.SDS.VideoStation2.View.get();var d=SYNO.SDS.VideoStation2.TVShow.get();var b=SYNO.SDS.VideoStation2.Video.get();var f=SYNO.SDS.VideoStation2.Navigation.get();var g=SYNO.SDS.VideoStation2.Playlist.get();var c=SYNO.SDS.VideoStation2.Folder.get();var l=null;var e=null;if(a.getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER){var i=c.getCurrentFolderStack();if(i.length!==0){e=i.map(function(m){return{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:m.pathTitle,folder:m}})}}var h=SYNO.SDS.VideoStation2.Controller.getClassificationString(a.getCurrentCategory(),k.getCurrentType());switch(j.getView()){case SYNO.SDS.VideoStation2.View.VIEW_TVSHOW:l=[{view:k.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:k.isDeactivated()?_VST("common","homepage"):h},{view:SYNO.SDS.VideoStation2.View.VIEW_TVSHOW,value:d.getCurrentTVShow().title}];break;case SYNO.SDS.VideoStation2.View.VIEW_DETAIL:if(e){l=[].concat({view:k.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:k.isDeactivated()?_VST("common","homepage"):h,folder:SYNO.SDS.VideoStation2.Folder.FOLDER_NULL}).concat(e).concat({view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()})}else{if(k.getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW){l=[{view:k.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:k.isDeactivated()?_VST("common","homepage"):h},{view:SYNO.SDS.VideoStation2.View.VIEW_TVSHOW,value:d.getCurrentTVShow().title},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()}]}else{if(k.getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){l=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:g.getCurrentPathTitle()},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()}]}else{l=[{view:k.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:k.isDeactivated()?_VST("common","homepage"):h},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:b.getCurrentPathTitle()}]}}}break;case SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST:l=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")}];break;case SYNO.SDS.VideoStation2.View.VIEW_POSTER:if(e){l=[].concat({view:k.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:k.isDeactivated()?_VST("common","homepage"):h,folder:SYNO.SDS.VideoStation2.Folder.FOLDER_NULL}).concat(e)}else{if(k.getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){l=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:g.getCurrentPathTitle()}]}}break;default:break}SYNO.Debug("updatePath",l,j.getView());if(l){f.toPath(l)}else{f.toCategory()}},updateHistory:function(){}}});Ext.define("SYNO.SDS.VideoStation2.Player",{statics:{EVENT_PLAYER_LOAD:"playerload",instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.Player.instance)){SYNO.SDS.VideoStation2.Player.instance=new SYNO.SDS.VideoStation2.Player()}return SYNO.SDS.VideoStation2.Player.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},loadPlayer:function(a){SYNO.Assert(Ext.isArray(a),String.format("bad player object array {0}",a));this.players=[];if(Ext.isDefined(window.chrome)&&Ext.isDefined(window.chrome.cast)&&window.chrome.cast.isAvailable){var b={title:_VST("controller","chromecast_mode"),id:SYNO.VideoController2.Util.CHROMECAST_ID};this.players=this.players.concat(b)}this.players=this.players.concat(a);this.current_idx=null;this.streaming=true;this.fireEvent(SYNO.SDS.VideoStation2.Player.EVENT_PLAYER_LOAD)},selectPlayer:function(a){SYNO.Assert(Ext.isString(a),"bad player id");this.current_idx=null;this.streaming=true;Ext.each(this.players,function(c,b){if(c.id===a){this.current_idx=b;this.streaming=false;return false}},this)},getCurrentID:function(){if(this.streaming){return SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING}SYNO.Assert(Ext.isNumber(this.current_idx)&&Ext.isArray(this.players)&&!Ext.isEmpty(this.players),"player not set");return this.players[this.current_idx].id},getAllPlayers:function(){return SYNO.Util.copy(this.players)},players:null,current_idx:null,streaming:true});Ext.define("SYNO.SDS.VideoStation2.PlaybackController",{statics:{loadPlayer:function(){var a={success:function(d,c,b){SYNO.SDS.VideoStation2.Player.get().loadPlayer(d.devices)},failure:function(){SYNO.SDS.VideoStation2.Player.get().loadPlayer([])}};SYNO.SDS.VideoStation2.OP.get().listPlayer({},a)},selectPlayer:function(a){SYNO.SDS.VideoStation2.Player.get().selectPlayer(a)},selectSubtitle:function(a){SYNO.SDS.VideoStation2.File.get().selectSubtitle(a)},selectAudiotrack:function(a){SYNO.SDS.VideoStation2.File.get().selectAudiotrack(a)},launchVideoPlayer:function(b,f){var e=null;var d=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(d===SYNO.SDS.VideoStation2.Constant.PLAYLIST){d=SYNO.SDS.VideoStation2.Constant.COLLECTION;e=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()}else{if(d===SYNO.SDS.VideoStation2.Constant.TVSHOW){e=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow().id}}var c={file_id:b.file_id,player_id:SYNO.SDS.VideoStation2.Player.get().getCurrentID(),title:"",browse_type:d,type_id:e,sort_info:null,video_id:b.video_id,video_type:b.video_type,subtitle_id:b.subtitle_id||null,audiotrack_id:b.audiotrack_id||null};var a=function(g){SYNO.SDS.VideoStation2.Window.mon(g||SYNO.SDS.WindowMgr.front,"close",function(){SYNO.SDS.VideoStation2.Util.applyCallback(f)},{single:true})};SYNO.SDS.AppLaunch("SYNO.VideoController2.Application",c,false,a)}}});Ext.define("SYNO.SDS.VideoStation2.ActionDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{ACTION_ADD:"add",ACTION_PLAY:"play",ACTION_MORE:"more",ACTION_PLAYLIST_EDIT:"playlist-edit",ACTION_PLAYLIST_MORE:"playlist-more"},disableAction:false,enableSelectMode:false,videoType:null,videoActionFilterCurrentPlaylist:null,trackResetOnLoad:false,constructor:function(){this.callParent(arguments);this.addClass("action-dataview");if(this.disableAction){this.addClass("hide-action")}if(this.enableSelectMode){this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED,this.onVideoSelectModeChange,this);this.onVideoSelectModeChange();this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED,this.onVideoSelectionChange,this)}this.mon(this,"beforedestroy",this.onBeforeDestroy,this);this.mon(this,"activate",this.onActivate,this);this.mon(this,"deactivate",this.onDeactivate,this)},hideAction:function(){if(this.disableAction){return}this.addClass("hide-action")},showAction:function(){if(this.disableAction){return}this.removeClass("hide-action")},getVideoData:function(a){return{id:this.getVideoID(a),type:this.getVideoType(a),pathTitle:this.getVideoTitle(a),mapper_id:this.getVideoMapperID(a),library_id:this.getLibraryID()}},getLibraryID:function(){return SYNO.SDS.VideoStation2.Library.get().getCurrentID()},getVideoType:function(a){return a.get("type")||this.videoType||SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()},getVideoID:function(a){return a.get("id")},getVideoMapperID:function(a){return a.get("mapper_id")},getVideoTitle:function(a){return a.get("title")},getVideoPlaylists:function(a){if(a.get("additional")&&a.get("additional").collection){return a.get("additional").collection}return null},getVideoFile:function(a){return null},getRecordBySelection:function(d){var e;var b=this.getStore();if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){e=b.findExact("mapper_id",d.mapper_id)}else{e=b.findExact("id",d.id)}if(e===-1){return}var a=b.getAt(e);var c=this.getVideoType(a);if(c!==d.type){return}return a},formRelatedSelections:function(b){var a=this.getRecordBySelection(b);b.record=a;return[b]},startVideoAction:function(a){this.clearVideoSelection();this.addVideoSelection(a)},clearVideoSelection:function(){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection()},addVideoSelection:function(a){SYNO.SDS.VideoStation2.Video.get().addVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a),this.getVideoPlaylists(a))},removeVideoSelection:function(a){SYNO.SDS.VideoStation2.Video.get().removeVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a),this.getVideoPlaylists(a))},toggleVideoSelection:function(a){SYNO.SDS.VideoStation2.Video.get().toggleVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a),this.getVideoPlaylists(a))},hasVideoSelection:function(a){return SYNO.SDS.VideoStation2.Video.get().hasVideoSelection(this.getVideoID(a),this.getVideoMapperID(a),this.getVideoType(a),this.getVideoFile(a))},isVideoSelectionEmpty:function(){return SYNO.SDS.VideoStation2.Video.get().isVideoSelectionEmpty()},onActivate:function(){var a=this.getStore();this.bindStore(a);this.mon(a,"load",this.onVideoSelectionChange,this);this.onVideoSelectionChange()},onDeactivate:function(){var a=this.getStore();this.mun(a,"load",this.onVideoSelectionChange,this);this.bindStore(null)},onVideoSelectModeChange:function(){if(!this.enableSelectMode){return}if(SYNO.SDS.VideoStation2.Video.get().isInSelectMode()){this.hideAction()}else{this.lastSelect=null;this.showAction()}},onVideoSelectionChange:function(){if(!this.enableSelectMode){return}if(this.hidden){return}if(!SYNO.SDS.VideoStation2.Video.get().isInSelectMode()){return}var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();this.getNodes().each(function(c){var b=Ext.fly(c);b.removeClass("x-view-selected")});a.each(function(d){var b=this.getRecordBySelection(d);if(!b){return}var e=this.getNode(b);var c=Ext.fly(e);c.addClass("x-view-selected")},this)},onStoreLoad:function(){this.updateScrollbar(this.trackResetOnLoad);this.fireEvent("afterUpdateScrollbar",this)},onClick:function(h,g,f){var b=Ext.fly(g);var c=h.getTarget(this.itemSelector,this.getTemplateTarget());var a=null;if(c){a=this.getRecord(c)}var d=SYNO.SDS.VideoStation2.Video.get().isInSelectMode();if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_ADD)){this.onActionAddClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAY)){this.onActionPlayClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_MORE)){this.onActionMoreClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAYLIST_EDIT)){this.onActionPlaylistEditClick(this,h,a)}else{if(b.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAYLIST_MORE)){this.onActionPlaylistMoreClick(this,h,a)}else{if(this.enableSelectMode&&a){if((h.ctrlKey||h.shiftKey)&&!d){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(true,true);d=true}if(d){this.onSelect(this,h,a)}else{this.callParent(arguments)}}else{this.callParent(arguments)}}}}}}},onActionAddClick:function(j,a,h){this.startVideoAction(h);var d=this.getVideoPlaylists(h);if(d){d=d.map(function(k){return k.id})}var e=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();var b=function(k){return(d&&d.indexOf(k.id)!==-1)?"checked":""};var f=function(k){return this.videoActionFilterCurrentPlaylist&&e===k.id};var g=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:b,disabledFn:f,createPlaylistFn:this.onCreatePlaylist,clickPlaylistFn:this.onPlaylistClick},this);var i=function(k){k.destroy()};var c=new SYNO.SDS.VideoStation2.DropdownMenu({items:g,listeners:{hide:i}});c.showAt(a.getXY())},onActionPlayClick:function(b,d,a){this.startVideoAction(a);var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(c,function(e){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING);SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:e.id,video_id:c.id,video_type:c.type},{fn:SYNO.SDS.VideoStation2.Controller.refreshView})})},onActionMoreClick:function(b,c,a){this.startVideoAction(a);var f=this.filterNotAllowedAction(SYNO.SDS.VideoStation2.ActionUtil.getAvailableVideoActions(),a);var d=f.map(function(h){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getVideoActionString(h),itemId:h,scope:this,handler:this.onVideoAction})},this);var g=function(h){h.destroy()};var e=new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:d,listeners:{hide:g}});e.showAt(c.getXY())},onActionPlaylistEditClick:function(b,c,a){if(Ext.fly(c.target).hasClass("x-item-disabled")){return}SYNO.SDS.VideoStation2.PlaylistActionController.doPlaylistAction(SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT,a.id)},onActionPlaylistMoreClick:function(b,c,a){if(Ext.fly(c.target).hasClass("x-item-disabled")){return}var g=a.id;var d=[];SYNO.SDS.VideoStation2.ActionUtil.getAvailablePlaylistActions().each(function(h){if(h===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT){return}d.push(new Ext.Action({text:_VST("playlist",h),itemId:h,disabled:h===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE&&g<0,handler:SYNO.SDS.VideoStation2.PlaylistActionController.doPlaylistAction.createDelegate(this,[h,g])}))},this);var f=function(h){h.destroy()};var e=new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:d,listeners:{hide:f}});e.showAt(c.getXY())},onCreatePlaylist:function(e){var d=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];var b=this.getRecordBySelection(d);if(!b){return}var a=this.formRelatedSelections(d);var c=function(f){SYNO.SDS.VideoStation2.PlaylistController.applyPlaylistChangeToVideo(a,f,true)};SYNO.SDS.VideoStation2.VideoActionController.createPlaylist([d],c)},onPlaylistClick:function(e){var d=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];var b=this.getRecordBySelection(d);if(!b){return}var a=this.formRelatedSelections(d);var c=!e.getEl().hasClass("checked");var f=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(parseInt(e.itemId,10));var g=this.onPlaylistAddRemove.createDelegate(this,[a,f,c,e]);SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist([d],f.id,c,g)},onPlaylistAddRemove:function(b,d,a,c){if(c&&!c.isDestroyed){c.getEl()[a?"addClass":"removeClass"]("checked")}SYNO.SDS.VideoStation2.PlaylistController.applyPlaylistChangeToVideo(b,d,a)},onVideoAction:function(d){var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];var b=this.getRecordBySelection(c);if(!b){return}var a=this.formRelatedSelections(c);var e;switch(d.itemId){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:e=SYNO.SDS.VideoStation2.VideoActionController.applyWatchStatusChangeToVideo(a,true);break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:e=SYNO.SDS.VideoStation2.VideoActionController.applyWatchStatusChangeToVideo(a,false);break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:e=SYNO.SDS.VideoStation2.Controller.refreshView;break}SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(d.itemId,[c],e)},onBeforeDestroy:function(){this.getStore().destroy()},onSelect:function(b,f,a){if(!Ext.isNumber(this.getVideoID(a))){return}var c=this.getStore();if(f.shiftKey&&this.lastSelect){this.clearVideoSelection();var g=[c.indexOf(this.lastSelect),c.indexOf(a)].sortBy(function(h){return h});for(var d=g[0];d<=g[1];++d){var e=c.getAt(d);if(!Ext.isNumber(this.getVideoID(e))){continue}this.addVideoSelection(e)}return}if(!this.hasVideoSelection(a)){this.lastSelect=a}this.toggleVideoSelection(a);if(this.lastSelect&&!this.hasVideoSelection(this.lastSelect)){this.lastSelect=null}if(f.ctrlKey&&this.isVideoSelectionEmpty()){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(false,true)}},filterNotAllowedAction:function(d,a){var c=(a.get("additional"))?a.get("additional").watched_ratio:0;var b=a.get("type")===SYNO.SDS.VideoStation2.Constant.FILE;return d.filter(function(e){if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA&&b){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA&&!b){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED&&SYNO.SDS.VideoStation2.Util.isWatched(c)){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED&&SYNO.SDS.VideoStation2.Util.isUnwatched(c)){return false}if(e===SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE){return false}return true})},getTitle:function(a){return Ext.isString(a.title)?a.title:""},getStore:function(){SYNO.Debug.error("need to implement interface getStore")},getImageURL:function(){SYNO.Debug.error("need to implement interface getImageURL")}});Ext.define("SYNO.SDS.VideoStation2.CompositeMenu",{extend:"SYNO.ux.Menu",alignTarget:null,constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-composite-menu")},show:function(b,c,a){if(this.alignTarget){b=this.alignTarget.getEl()||b}this.items.each(function(d){d.fireEvent("activate")});this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.FileChooser",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",constructor:function(b){var a={usage:{type:"chooseDir"},folderToolbar:true,treeFilter:function(d,c){if(c&&(c.spath==="/home"||c.spath==="/homes"||c.mountType==="remote")){return false}return true},listeners:{afterrender:this.addButtonClass}};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vs2-filechooser");this.addClass("syno-vs2-dialog")},addButtonClass:function(){var c=this.topToolbar.items.item(0);var b=this.topToolbar.items.item(1);c.addClass("syno-vs2-button");c.addClass("syno-vs2-button-grey");b.addClass("syno-vs2-button");b.addClass("syno-vs2-button-grey");var d=this.items.item(1).items.item(1).items.item(1);var a=this.items.item(1).items.item(2).items.item(1);d.addClass("syno-vs2-button");d.addClass("syno-vs2-button-blue");a.addClass("syno-vs2-button");a.addClass("syno-vs2-button-grey")},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)},createFolder:function(){if(!this.crtDialog||this.crtDialog.isDestroyed){this.crtDialog=new SYNO.SDS.VideoStation2.FileChooser.CrtFdrDialog({RELURL:this.RELURL,owner:this,cls:this.initialConfig.cls})}return this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.FileChooser.CrtFdrDialog",{extend:"SYNO.SDS.Utils.FileChooser.CrtFdrDialog",constructor:function(){this.callParent(arguments);this.addClass(["syno-vs2-dialog","syno-vs2-filechooser-crtfdrdialog"]);this.buttons.each(function(c){c.addClass("syno-vs2-button")});var a=this.items.get(0);a.addClass(["syno-ux-formpanel","syno-vs2-form"]);var b=a.getComponent("name");b.addClass(["syno-vs2-textfield","syno-vs2-base-textfield"])}});Ext.define("SYNO.SDS.VideoStation2.ComboBox",{statics:{CLASS_MENU_EXPANDED:"menu-expanded"},extend:"SYNO.ux.ComboBox",xtype:"syno_vs_combobox",listClass:"syno-vs2-combobox-list",tplHtmlEncode:true,constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-combobox");this.mon(this,"expand",this.addExpandedClass,this);this.mon(this,"collapse",this.removeExpandedClass,this)},addExpandedClass:function(){this.addClass(SYNO.SDS.VideoStation2.ComboBox.CLASS_MENU_EXPANDED)},removeExpandedClass:function(){this.removeClass(SYNO.SDS.VideoStation2.ComboBox.CLASS_MENU_EXPANDED)},onDestroy:function(){this.mun(this,"expand",this.addExpandedClass,this);this.mun(this,"collapse",this.removeExpandedClass,this);this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.DateField",{extend:"SYNO.ux.DateField",xtype:"syno_vs_datefield",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-datefield")},onTriggerClick:function(){this.callParent(arguments);if(!this.menu.el.hasClass("syno-vs2-datefield-menu")){this.menu.addClass("syno-vs2-datefield-menu")}}});Ext.define("SYNO.SDS.VideoStation2.DisplayField",{extend:"SYNO.ux.DisplayField",xtype:"syno_vs_displayfield",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-displayfield")}});Ext.define("SYNO.SDS.VideoStation2.FieldSet",{extend:"SYNO.ux.FieldSet",xtype:"syno_vs_fieldset",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-fieldset")}});Ext.define("SYNO.SDS.VideoStation2.NumberField",{extend:"SYNO.ux.NumberField",xtype:"syno_vs_numberfield",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-numberfield");this.addClass("syno-vs2-base-textfield")}});Ext.define("SYNO.SDS.VideoStation2.TextArea",{extend:"SYNO.ux.TextArea",xtype:"syno_vs_textarea",constructor:function(){this.callParent(arguments);this.addClass("syno-vs2-textarea");this.addClass("syno-vs2-base-textfield")}});Ext.define("SYNO.SDS.VideoStation2.TimeField",{extend:"SYNO.ux.TimeField",xtype:"syno_vs_timefield",listClass:"syno-vs2-combobox-list",constructor:function(a){this.callParent(arguments);this.addClass("syno-vs2-timefield")}});Ext.define("SYNO.SDS.VideoStation2.ListView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){Ext.apply(this,a.decorator);var b={tpl:this.getTpl(),cls:"list-view",store:this.getStore(),itemSelector:"div.list-wrap",overClass:"x-view-over",singleSelect:true};Ext.apply(b,a);delete b.decorator;return b},getTemplateTarget:function(){if(!this.el.dom){return}this.scrollBar=this.scrollBar||this.el.createChild({tag:"div",style:"display:inline-block;width:100%;"});return this.scrollBar},getTpl:function(){var b=this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster";var a=new Ext.XTemplate('<tpl for=".">','<div class="list-wrap '+b+'">','<div class="select-mark"></div>',"{[this.getListThumbDiv(values)]}",'<div class="title sds-ellipsis">','<tpl if="this.hasEpisode(values)">{[this.getEpisodeDiv(values)]}</tpl>',"{[this.singleEncode(this.getTitle(values))]}","{[this.getTitleDecorateDiv(values)]}","</div>",'<div class="action">',"{[this.getActionDiv(values)]}","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{getTitle:this.getTitle.createDelegate(this),getEpisodeDiv:function(c){if(c.episode){return String.format('<span class="episode sds-ellipsis">{0}</span>',String.format(_VST("episode","title"),c.episode))}return""},hasEpisode:function(c){return c.episode!==undefined},singleEncode:function(c){return Ext.util.Format.htmlEncode(c)},doubleEncode:function(c){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(c))},getListThumbDiv:this.getListThumbDiv.createDelegate(this),getActionDiv:this.getActionDiv.createDelegate(this),getTitleDecorateDiv:this.getTitleDecorateDiv.createDelegate(this)});return a},getListThumbDiv:function(a){return""},getTitleDecorateDiv:function(a){return""},getWatchedInfo:function(a){if(!Ext.isObject(a)||!Ext.isNumber(a.watched_ratio)){return""}return SYNO.SDS.VideoStation2.Util.isUnwatched(a.watched_ratio)?SYNO.SDS.VideoStation2.Constant.CLASS.UNWATCHED:""},getDate:function(a){return SYNO.SDS.VideoStation2.Util.getVideoDate(a)},getActionDiv:function(a){if(a.type===SYNO.SDS.VideoStation2.Constant.FOLDER){return}return['<div class="date">'+this.getDate(a)+"</div>",'<div class="yellow-dot '+this.getWatchedInfo(a.additional)+'"></div>','<div class="add action-btn"></div>','<div class="play action-btn"></div>','<div class="more action-btn"></div>'].join("")}});Ext.define("SYNO.SDS.VideoStation2.NavigationToolbar",{extend:"SYNO.ux.Toolbar",constructor:function(a){this.callParent(arguments);this.addClass("nav-toolbar")}});Ext.define("SYNO.SDS.VideoStation2.SearchField",{extend:"SYNO.ux.TextFilter",constructor:function(b){var a={emptyText:_VST("search","keyword"),enableKeyEvents:true};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("syno-vs2-searchfield");c.wrap.addClassOnOver("over")})}});Ext.define("SYNO.SDS.VideoStation2.SlidableDataView",{extend:"SYNO.ux.Panel",statics:{POSITION:{left:-1,center:0,right:1}},dataViewMargin:20,constructor:function(c){SYNO.Assert(Ext.isFunction(c.getView),"need to implement getView");var d=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;var b={floating:true,hidden:true,shadow:false};this.views={};this.views[d.center]=c.getView(b);this.views[d.left]=c.getView(b);this.views[d.right]=c.getView(b);var a={cls:"slidable-viewport",layout:"fit",items:Object.values(this.views)};Ext.apply(a,c);this.callParent([a]);this.mon(this,"activate",this.onActivate,this);this.mon(this,"deactivate",this.onDeactivate,this);this.mon(this,"resize",this._onResize,this);this.mon(this,"afterlayout",this._onAfterLayout,this);this.items.each(function(e){this.mon(e,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,function(){if(e===this.views[d.center]){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)}},this);this.mon(e,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,function(){if(e===this.views[d.center]){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)}},this)},this)},prepareView:function(a,d){var c=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;SYNO.Assert(Object.values(c).indexOf(a)!==-1,String.format("unexpected position {0}",a));var b=this.views[a];this._setViewPosition(b,a);b.show();if(!d){b.fireEvent("activate",a)}},intoLeft:function(b){var c=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,a=this._getOriginView();if(!b){this.prepareView(c.left)}this._clearSlideClass();this.views[c.center].addClass("slidable-out");this.views[c.left].addClass("slidable-in");this._setViewPosition(this.views[c.center],c.right);this._setViewPosition(this.views[c.left],c.center);this.views[c.right].hide();this._setViewPosition(this.views[c.right],c.left);this.views[c.right].fireEvent("deactivate");this.views[c.left]=a[c.right];this.views[c.center]=a[c.left];this.views[c.right]=a[c.center];this._delayClearSlideClass()},intoRight:function(b){var c=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,a=this._getOriginView();if(!b){this.prepareView(c.right)}this._clearSlideClass();this.views[c.center].addClass("slidable-out");this.views[c.right].addClass("slidable-in");this._setViewPosition(this.views[c.center],c.left);this._setViewPosition(this.views[c.right],c.center);this.views[c.left].hide();this._setViewPosition(this.views[c.left],c.right);this.views[c.left].fireEvent("deactivate");this.views[c.right]=a[c.left];this.views[c.center]=a[c.right];this.views[c.left]=a[c.center];this._delayClearSlideClass()},getLeftView:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[a.left]},getRightView:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[a.right]},getCenterView:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[a.center]},_delayClearSlideClass:function(){this._delayClearSlideClassTask=this._delayClearSlideClassTask||new Ext.util.DelayedTask(this._clearSlideClass,this);this._delayClearSlideClassTask.cancel();this._delayClearSlideClassTask.delay(800)},_clearSlideClass:function(){Ext.iterate(this.views,function(b,a){a.removeClass(["slidable-in","slidable-out"])})},_setViewPosition:function(b,a){b.setPosition(this._getLeft(a),0)},_getOriginView:function(){var b=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;var a={};a[b.center]=this.views[b.center];a[b.left]=this.views[b.left];a[b.right]=this.views[b.right];return a},_onResize:function(){var b=this.getWidth(),a=this.getHeight();Object.values(this.views).each(function(c){c.setSize(b,a)})},_onAfterLayout:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this._setViewPosition(this.views[a.center],a.center);this._setViewPosition(this.views[a.left],a.left);this._setViewPosition(this.views[a.right],a.right)},onActivate:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.prepareView(a.center)},onDeactivate:function(){this.getCenterView().fireEvent("deactivate")},_getLeft:function(a){return(this.getWidth()+this.dataViewMargin)*a},getView:function(a){SYNO.Debug.error("need to implement getView")}});Ext.define("SYNO.SDS.VideoStation2.ImageLoadManager",{extend:"Ext.Component",MAX_CONCURRENT:3,running:0,jobs:null,preemptJobs:null,delegate:null,statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.ImageLoadManager.instance)){SYNO.SDS.VideoStation2.ImageLoadManager.instance=new SYNO.SDS.VideoStation2.ImageLoadManager()}return SYNO.SDS.VideoStation2.ImageLoadManager.instance}},constructor:function(){this.callParent(arguments);this.jobs=[];this.preemptJobs=[];this.delayedPreemptJob=new Ext.util.DelayedTask(this.preemptJob,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.clear,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.clear,this);this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.clear,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.clear,this)},clear:function(){this.jobs=[];this.preemptJobs=[]},appendJob:function(a){if(-1!==this.jobs.indexOf(a)){return}this.jobs.push(a);this.dispatch()},insertJob:function(a){this.preemptJobs.push(a);this.delayedPreemptJob.delay(100)},preemptJob:function(){Ext.each(this.preemptJobs,function(a){this.jobs.remove(a)},this);this.jobs.unshift.apply(this.jobs,this.preemptJobs);this.preemptJobs=[];this.dispatch()},dispatch:function(){while(this.MAX_CONCURRENT>this.running){var a=this.jobs.shift();if(!a){break}this.running++;this.setImgURL(a)}},setImgURL:function(c){var b=Ext.fly(c).getAttribute("url");if(!b){this.running--;this.dispatch.defer(0,this);return}var a=document.createElement("img");Ext.fly(a).on({load:this.onImageLoad.createDelegate(this,[c,a,b]),error:this.onImageError.createDelegate(this,[c,a,b])});c.removeAttribute("url");a.src=b},finalizedImageLoad:function(){this.running--;this.dispatch.defer(0,this)},onImageLoad:function(d,a,b){this.finalizedImageLoad();if(this.delegate){this.delegate.onImageLoad(a)}var c=Ext.fly(d);c.setStyle("background-image",String.format("url({0})",b));c.removeClass("loading");a=null},onImageError:function(c,a,b){this.finalizedImageLoad();if(this.delegate){this.delegate.onImageError(c,a)}}});Ext.define("SYNO.SDS.VideoStation2.ThumbDataView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(a){this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get();this.callParent([this.fillConfig(a)])},fillConfig:function(a){Ext.apply(this,a.decorator);var b={tpl:this.getTpl(),cls:"thumb-dataview",store:this.getStore(),itemSelector:"div.thumb-wrap",overClass:"x-view-over",singleSelect:true};Ext.apply(b,a);delete b.decorator;return b},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="thumb-wrap {[this.getImageStyle(values)]}">',"{[this.getThumbDiv(values)]}",'<div class="title sds-ellipsis" ext:qtip="{[this.doubleEncode(this.getTitle(values))]}">{[this.singleEncode(this.getTitle(values))]}',"{[this.getTitleDecorateDiv(values)]}","</div>",'<div class="description sds-ellipsis" ext:qtip="{[this.doubleEncode(this.getDescription(values))]}">{[this.singleEncode(this.getDescription(values))]}</div>',"</div>","{[this.getAfterThumbDiv(values)]}","</tpl>",'<div class="x-clear"></div>',{getImageStyle:this.getImageStyle.createDelegate(this),getThumbDiv:this.getThumbDiv.createDelegate(this),getTitle:this.getTitle.createDelegate(this),getTitleDecorateDiv:this.getTitleDecorateDiv.createDelegate(this),getDescription:this.getDescription.createDelegate(this),getAfterThumbDiv:this.getAfterThumbDiv.createDelegate(this),singleEncode:function(b){return Ext.util.Format.htmlEncode(b)},doubleEncode:function(b){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(b))}});return a},getImageStyle:function(a){return this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster"},getTitleDecorateDiv:function(){return""},getDescription:function(a){return SYNO.SDS.VideoStation2.Util.getVideoDate(a)},getIconDiv:function(c){var d;if(SYNO.SDS.VideoStation2.Constant.FOLDER===this.getImageStyle(c)||SYNO.SDS.VideoStation2.Constant.PLAYLIST===this.getImageStyle(c)){d='<div class="thumb">'}else{var b=this.getImageURL(c);d=String.format('<div class="thumb loading" url="{0}">',Ext.util.Format.htmlEncode(b))}var a=[d,Ext.isFunction(this.getAdditionThumbDiv)?this.getAdditionThumbDiv(c):"",this.getOnScreenBtnDiv(c),"</div>"].join("");return a},getThumbDiv:function(b){var a=[this.getIconDiv(b),this.getWatchStatusDiv(b),'<div class="select-mark"></div>','<div class="border"></div>'].join("");if(SYNO.SDS.VideoStation2.Constant.FOLDER===this.getImageStyle(b)||SYNO.SDS.VideoStation2.Constant.PLAYLIST===this.getImageStyle(b)){a=String.format('<div class="background-shadow">{0}</div>',a)}return a},getWatchStatusDiv:function(a){if(SYNO.SDS.VideoStation2.Constant.FOLDER===this.getImageStyle(a)||SYNO.SDS.VideoStation2.Constant.PLAYLIST===this.getImageStyle(a)){return""}return SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(a)},getOnScreenBtnDiv:function(b){var a=['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("");return a},getAfterThumbDiv:function(a){return""},refresh:function(){this.callParent(arguments);this.preloadItems()},preloadItems:function(){var a=this.getNodes();this.getImageItems(a,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(a){this.getImageItems([a],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(a,b){Ext.each(a,function(f,c,e){var d=Ext.fly(f).select(".loading");Ext.each(d.elements,b)})}});Ext.define("SYNO.SDS.VideoStation2.TileDataView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(a){this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get();this.callParent([this.fillConfig(a)])},fillConfig:function(a){Ext.apply(this,a.decorator);var b={tpl:this.getTpl(),cls:"tile-dataview",store:this.getStore(),itemSelector:"div.tile-wrap",overClass:"x-view-over",singleSelect:true};Ext.apply(b,a);delete b.decorator;return b},getTemplateTarget:function(){if(!this.el.dom){return}this.scrollBar=this.scrollBar||this.el.createChild({tag:"div",style:"display:inline-block;width:100%;"});return this.scrollBar},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="tile-wrap {[this.getImageStyle(values)]}">','<div class="tile-img">',"{[this.getIconDiv(values)]}","{[this.getWatchStatusDiv(values)]}",'<div class="select-mark"></div>','<div class="border"></div>',"</div>",'<div class="tile-desc">','<div class="title sds-ellipsis">',"{[this.singleEncode(this.getTitle(values))]}","{[this.getEpisodeDiv(values)]}",'<span class="date">{[this.getDate(values)]}</span>',"</div>",'<div class="summary">{values.additional.summary:htmlEncode}</div>',"</div>",'<div class="x-clear"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getTitle:this.getTitle.createDelegate(this),getImageStyle:this.getImageStyle.createDelegate(this),getIconDiv:this.getIconDiv.createDelegate(this),getWatchStatusDiv:this.getWatchStatusDiv.createDelegate(this),getDate:this.getDate.createDelegate(this),getEpisodeDiv:function(b){if(b.episode){return String.format('<span class="episode">{0}</span>',String.format(_VST("episode","title"),b.episode))}return""},singleEncode:function(b){return Ext.util.Format.htmlEncode(b)},doubleEncode:function(b){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(b))}});return a},getImageStyle:function(a){return this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster"},getIconDiv:function(c){var d;if(SYNO.SDS.VideoStation2.Constant.FOLDER===this.getImageStyle(c)||SYNO.SDS.VideoStation2.Constant.PLAYLIST===this.getImageStyle(c)){d='<div class="thumb">'}else{var b=this.getImageURL(c);d=String.format('<div class="thumb loading" url="{0}">',Ext.util.Format.htmlEncode(b))}var a=[d,this.getOnScreenBtnDiv(c),"</div>"].join("");return a},getOnScreenBtnDiv:function(b){var a=['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("");return a},getWatchStatusDiv:function(a){if(SYNO.SDS.VideoStation2.Constant.FOLDER===this.getImageStyle(a)||SYNO.SDS.VideoStation2.Constant.PLAYLIST===this.getImageStyle(a)){return""}return SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(a)},getDate:function(a){return SYNO.SDS.VideoStation2.Util.getVideoDate(a)},refresh:function(){this.callParent(arguments);this.preloadItems()},preloadItems:function(){var a=this.getNodes();this.getImageItems(a,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(a){this.getImageItems([a],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(a,b){Ext.each(a,function(f,c,e){var d=Ext.fly(f).select(".loading");Ext.each(d.elements,b)})}});Ext.define("SYNO.SDS.VideoStation2.SwitchableDataView",{enablePagingToolbar:false,pageSize:0,extend:"SYNO.ux.Panel",statics:{AVAILABLE_DECORATORS:["Season","Common","Byfolder","Playlist","PlaylistPoster"]},constructor:function(b,c){this.decorator=this.getDecorator(b);this.applyDecorator();this.applyDecoratorToChild(b);this.views={};this.views[SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL]=new SYNO.SDS.VideoStation2.ThumbDataView(b);this.views[SYNO.SDS.VideoStation2.View.TYPE_TILE]=new SYNO.SDS.VideoStation2.TileDataView(b);this.views[SYNO.SDS.VideoStation2.View.TYPE_LIST]=new SYNO.SDS.VideoStation2.ListView(b);var a={layout:"card",items:Object.values(this.views),listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,beforedestroy:this.onBeforeDestroy}};if(this.enablePagingToolbar){this._paging=new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:this.getDataviewStore(),displayInfo:true,showRefreshBtn:true});a.bbar=this._paging}Ext.apply(a,c||{});this.callParent([a]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO)},getDecorator:function(a){var b=SYNO.SDS.VideoStation2.SwitchableDataView.AVAILABLE_DECORATORS;SYNO.Assert(b.indexOf(a.decorator)!==-1,String.format("unexpceted decorator {0}",a.decorator));return SYNO.SDS.VideoStation2.DataViewDecorator[a.decorator]},applyDecoratorToChild:function(a){a.decorator={getStore:function(){return this.owner.getDataviewStore()}};this.decorator.decorations.each(function(b){a.decorator[b]=this.decorator[b]},this);a.decorator.owner=this},applyDecorator:function(a){this.decorator.switchableDecorations.each(function(b){this[b]=this.decorator[b]},this)},onViewTypeChange:function(){if(this.hidden){SYNO.Debug("view is hidden, by pass");return}this.loadView()},loadView:function(){var a=SYNO.SDS.VideoStation2.View.get().getViewType();var c=this.layout.activeItem;var b=this.views[a];SYNO.Assert(b,String.format("unexpceted viewType {0}",a));if(c!==b){this.layout.setActiveItem(b)}else{if(c){c.fireEvent("activate")}}},getActiveView:function(){return this.layout.activeItem},clearActiveItem:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},resetPaging:function(){if(!this.enablePagingToolbar){return}this._paging.moveFirst()},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);var a=this.getDataviewStore();this.mon(a,"beforeload",this.onDataviewBeforeLoad,this);this.mon(a,"load",this.onDataviewStoreLoad,this);this.loadView();var b;if(this.enablePagingToolbar){b=this._paging.cursor;this._paging.bindStore(a)}if(this.isNeedLoadStore()){if(this.enablePagingToolbar){if(this.isNeedMovePagingToFirst()){this._paging.moveFirst()}else{this.keepScrollOnce=true;this._paging.cursor=b;this._paging.doRefresh()}}else{if(!this.isNeedMovePagingToFirst()){this.keepScrollOnce=true}a.load()}this.getActiveView().getTemplateTarget().update("")}},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this);var a=this.getDataviewStore();this.mun(a,"beforeload",this.onDataviewBeforeLoad,this);this.mun(a,"load",this.onDataviewStoreLoad,this);if(this.enablePagingToolbar){this._paging.bindStore(null)}this.clearActiveItem();this.keepScrollOnce=false},onViewRefresh:function(){if(this.enablePagingToolbar){this._paging.doRefresh()}else{this.getDataviewStore().load()}},onBeforeDestroy:function(){this.getDataviewStore().destroy()},onDataviewBeforeLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this)},onDataviewStoreLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);if(0===this.getDataviewStore().getTotalCount()){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)}if(this.keepScrollOnce){this.keepScrollOnce=false;return}this.getActiveView().updateScrollbar(true)},getDataviewStore:function(){SYNO.Debug.error("need to implement interface getDataviewStore")},isNeedLoadStore:function(){return true},isNeedMovePagingToFirst:function(){return true}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Common",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","enablePagingToolbar","pageSize","isNeedMovePagingToFirst"],decorations:["decoratorConfig","getImageStyle","getImageURL","enableSelectMode"],enablePagingToolbar:true,pageSize:120,getDataviewStore:function(){this.stores=this.stores||{};var a=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(!this.stores[a]){SYNO.Assert(SYNO.SDS.VideoStation2.Stores[a],String.format("unexpceted library type {0}",a));this.stores[a]=new SYNO.SDS.VideoStation2.Stores[a]({listeners:{scope:this,beforeload:this.onBeforeLoadStore}})}return this.stores[a]},onBeforeLoadStore:function(a,b){var f=b.params;var c=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var e=(c!==SYNO.SDS.VideoStation2.Category.CATEGORY_ALL)?SYNO.SDS.VideoStation2.Category.get().getSortOption():SYNO.SDS.VideoStation2.Sort.get().getSortOption();var d=null;if(c===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){d=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(d,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption())}Ext.apply(f,e);Ext.apply(f,d);Ext.apply(f,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})},isNeedMovePagingToFirst:function(){return !Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:true,decoratorConfig:{thumbCls:"poster"},getImageStyle:function(b){var a=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(a===SYNO.SDS.VideoStation2.Constant.MOVIE||a===SYNO.SDS.VideoStation2.Constant.TVSHOW){return"poster"}return"landscape"},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Library.get().getCurrentType(),id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Season",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","filterStore","isNeedLoadStore","clearLoadedInfo","isNeedMovePagingToFirst"],decorations:["decoratorConfig","getDescription","getImageURL","enableSelectMode","getVideoTitle","getTitle"],getDataviewStore:function(){if(!this._store){var a=SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE;this._store=new SYNO.SDS.VideoStation2.Stores[a]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}})}return this._store},onBeforeLoadStore:function(a,b){var d=b.params;var c={};if(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){c=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(c,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption())}Ext.apply(d,c);Ext.apply(d,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),tvshow_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID()})},onLoadStore:function(c,b,d){this.loadedLibrary=d.params.library_id;this.loadedTVShow=d.params.tvshow_id;var a=b.reduce(function(e,f){e[f.get("season")]=true;return e},{});a=Object.keys(a).map(function(e){return parseInt(e,10)}).sortBy(function(e){return e});if(Ext.isEmpty(a)){SYNO.SDS.VideoStation2.Controller.goback();return}if(a[0]===0){a=a.slice(1).concat(0)}SYNO.SDS.VideoStation2.TVShow.get().setAvailableSeasons(a);this.filterStore()},filterStore:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this._store.filter({property:"season",value:a})},isNeedLoadStore:function(){var b=SYNO.SDS.VideoStation2.Library.get().getCurrentID();var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentID();return(this.loadedLibrary!==b||this.loadedTVShow!==a)},clearLoadedInfo:function(){this.loadedLibrary=null;this.loadedTVShow=null},isNeedMovePagingToFirst:function(){return !Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:true,decoratorConfig:{thumbCls:"landscape"},getDescription:function(a){return a.episode>0?String.format(_VST("episode","title"),a.episode):""},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})},getVideoTitle:function(a){var b=[a.get("episode")>0?String.format(_VST("episode","title"),a.get("episode")):_VST("metadata","unknown")];if(!Ext.isEmpty(a.get("tagline"))){b.push(a.get("tagline"))}return b.join(" - ")},getTitle:function(b){var a=b.episode>0?String.format(_VST("episode","title"),b.episode):_VST("metadata","unknown");return Ext.isString(b.tagline)&&!Ext.isEmpty(b.tagline)?b.tagline:a}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Byfolder",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","enablePagingToolbar","pageSize"],decorations:["getImageStyle","getListThumbDiv","getOnScreenBtnDiv","getAdditionThumbDiv","getImageURL","enableSelectMode","getVideoData","getVideoID","getVideoMapperID","getVideoType","getVideoFile","getRecordBySelection","getRelatedVideoRecordsBySelection","getAfterThumbDiv","formRelatedSelections","isFolder"],enablePagingToolbar:true,pageSize:120,getDataviewStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.folder({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this._store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),id:SYNO.SDS.VideoStation2.Folder.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Library.get().getCurrentType()})},enableSelectMode:true,getVideoData:function(a){return{id:this.getVideoID(a),type:this.getVideoType(a),pathTitle:this.getVideoTitle(a),mapper_id:this.getVideoMapperID(a),library_id:this.getLibraryID(),file:this.getVideoFile(a)}},getVideoID:function(a){var b=(a.get("additional")||{}).metadata;if(!b){return}return b.id},getVideoMapperID:function(a){var b=(a.get("additional")||{}).metadata;if(!b){return}return b.mapper_id},getVideoType:function(a){return SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()},getVideoFile:function(a){return parseInt(a.get("id"),10)},getRecordBySelection:function(a){return this.getStore().getById(a.file.toString())},getRelatedVideoRecordsBySelection:function(b){var a=[];this.getStore().each(function(c){if(b.mapper_id===this.getVideoMapperID(c)){a.push(c)}},this);return a},formRelatedSelections:function(a){return this.getRelatedVideoRecordsBySelection(a).map(function(b){return{id:this.getVideoID(b),type:this.getVideoType(b),mapper_id:this.getVideoMapperID(b),file:this.getVideoFile(b),record:b}},this)},getAdditionThumbDiv:function(b){if(!this.isFolder(b)){return""}var a=function(d){var c=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:c,id:d.id,mtime:d.additional?d.additional.poster_mtime||"":""})};return SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(b.preview_video,a)},isFolder:function(a){return SYNO.SDS.VideoStation2.Constant.FOLDER===a.type},getImageStyle:function(a){if(this.isFolder(a)){return SYNO.SDS.VideoStation2.Constant.FOLDER}if(SYNO.SDS.VideoStation2.Constant.MOVIE===SYNO.SDS.VideoStation2.Library.get().getCurrentType()){return"poster"}return"landscape"},getListThumbDiv:function(b){var a="";if(b.type===SYNO.SDS.VideoStation2.Constant.FOLDER){a=b.type}else{a=this.getVideoType()}return String.format('<div class="thumb-icon {0}"></div>',a)},getOnScreenBtnDiv:function(b){if(this.isFolder(b)){return""}var a=['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("");return a},getAfterThumbDiv:function(a){if(a.last_folder){return'<div class="x-clear"></div>'}return""},getImageURL:function(b){var a=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:a,id:b.additional.metadata.id,mtime:b.additional?b.additional.poster_mtime||"":""})}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Playlist",{singleton:true,switchableDecorations:["getDataviewStore","isNeedLoadStore"],decorations:["getImageURL","onActivate","decoratorConfig","getActionDiv","getListThumbDiv","getTitle","getTitleDecorateDiv","getAdditionThumbDiv","getAfterThumbDiv","getOnScreenBtnDiv"],getDataviewStore:function(){this._store=this._store||new Ext.data.JsonStore({id:"id",fields:["id","title","additional","type","playlist_title","preview_video"]});return this._store},isNeedLoadStore:function(){return false},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:a.type,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})},onActivate:function(){this.bindStore(this.getStore())},onDeactivate:function(){this.bindStore(null)},decoratorConfig:{thumbCls:SYNO.SDS.VideoStation2.Constant.PLAYLIST},getActionDiv:function(a){return[String.format('<div class="playlist-edit action-btn {0}"></div>',(a.id<0)?"x-item-disabled":""),String.format('<div class="playlist-more action-btn {0}"></div>',(a.id===-3)?"x-item-disabled":"")].join("")},getListThumbDiv:function(b){var a=b.type;if(-1===b.id){a="favorite"}else{if(-2===b.id){a="watchlist"}else{if(-3===b.id){a="shared"}}}return String.format('<div class="thumb-icon {0}"></div>',a)},getTitle:function(a){return Ext.isString(a.playlist_title)?a.playlist_title:""},getTitleDecorateDiv:function(a){var b=(a.additional||{}).sharing_info;if(!b||!b.status||b.status==="none"){return""}if(-3===a.id){return""}return String.format('<div class="share-icon {0}"></div>',b.status)},getAdditionThumbDiv:function(c){var b=SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(c.preview_video,this.getImageURL.createDelegate(this));var a="",d="";if(-1===c.id){a="favorite"}else{if(-2===c.id){a="watchlist"}else{if(-3===c.id){a="shared"}}}if(!Ext.isEmpty(a)){d=String.format('{0}<div class="playlist-icon {1} {2}"></div>',Ext.isEmpty(b)?"":'<div class="playlist-mask"></div>',a,Ext.isEmpty(b)?"":"has_contain")}return b+d},getAfterThumbDiv:function(a){if(-3===a.id){return'<div class="x-clear"></div>'}return""},getOnScreenBtnDiv:function(b){var a=['<div class="gradient"></div>','<div class="left-btn playlist-edit larger ',(b.id<0)?"x-item-disabled":"",'"></div>','<div class="right-btn playlist-more larger ',(b.id===-3)?"x-item-disabled":"",'"></div>'].join("");return a}});Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.PlaylistPoster",{singleton:true,switchableDecorations:["getDataviewStore","onBeforeLoadStore","enablePagingToolbar","pageSize","isNeedMovePagingToFirst"],decorations:["getImageStyle","getImageURL","videoActionFilterCurrentPlaylist","enableSelectMode"],enablePagingToolbar:true,pageSize:200,getDataviewStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores.playlistvideolist({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this._store},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()})},isNeedMovePagingToFirst:function(){return !Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:true,videoActionFilterCurrentPlaylist:true,getImageStyle:function(a){if(a.type&&SYNO.SDS.VideoStation2.Constant.MOVIE===a.type){return"poster"}return"landscape"},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:a.type,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})}});Ext.define("SYNO.SDS.VideoStation2.TextFilter",{extend:"SYNO.ux.TextFilter",xtype:"syno_vs_textfilter",constructor:function(b){var a={emptyText:_VST("search","keyword"),enableKeyEvents:true};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("syno-vs2-textfilter");c.wrap.addClass("syno-vs2-base-textfield");c.wrap.addClassOnOver("over")})}});Ext.define("SYNO.SDS.VideoStation2.TransparentButton",{extend:"SYNO.ux.Button",constructor:function(a){this.callParent([a]);this.addClass("syno-vs2-transparent-button")}});Ext.define("SYNO.SDS.VideoStation2.LibraryController",{statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.LibraryController.instance)){SYNO.SDS.VideoStation2.LibraryController.instance=new SYNO.SDS.VideoStation2.LibraryController()}return SYNO.SDS.VideoStation2.LibraryController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments)},loadLibrary:function(){SYNO.SDS.VideoStation2.Library.get().loadLibrary()}});Ext.define("SYNO.SDS.VideoStation2.AddEditDialog",{statics:{MODE_ADD:"add",MODE_EDIT:"edit"},extend:"SYNO.SDS.VideoStation2.Dialog",addAction:"create",editAction:"modify",constructor:function(b){b=b||{};this.mode=b.mode;var a={title:this.isAddMode()?_T("common","add"):_T("common","alt_edit"),width:500,height:350,layout:"fit",items:[this.getFormPanel()],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","alt_apply"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)])},isAddMode:function(){return this.mode===SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD},isDirty:Ext.emptyFn,isValid:Ext.emptyFn,getFormPanel:function(){this.form_panel=this.form_panel||new SYNO.SDS.VideoStation2.FormPanel(this.getFormConfig());return this.form_panel},getInvalidError:Ext.emptyFn,getParameter:Ext.emptyFn,onApply:function(a){if(!this.isValid()){this.getMsgBox().alert(this.title,this.getInvalidError());return}var b=this.isAddMode()?this.addAction:this.editAction;this.setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:SYNO.SDS.VideoStation2.Util.getCGIURL(this.cgi),method:"POST",single:true,autoJsonDecode:true,params:Ext.apply(this.getParameter(),{action:b}),scope:this,callback:this.onRequestDone.createDelegate(this)},this).start(true)},onCancel:function(){if(this.isAddMode()||!this.isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),a,this)},onRequestDone:function(b,d,a){this.clearStatusBusy();if(a&&a.success){this.onRequestSuccess(b,a);this.close()}else{var c=SYNO.SDS.VideoStation2.Error.getErrorInfoString(a,_T("common","commfail"));this.getMsgBox().alert(_VST("library","title"),c)}},onRequestSuccess:function(b,a){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(this.callback,{args:[b,a]}))}});Ext.define("SYNO.SDS.VideoStation2.FolderDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",cgi:"folder_manage.cgi",constructor:function(b){this.library=SYNO.Util.copy(b.library);this.folder=SYNO.Util.copy(b.folder);this.callback=b.callback||{};var a={resizable:false};this.callParent([Ext.apply(a,b)])},onOpen:function(){var a=this.isAddMode()?"enu":this.folder.preferlang;var c=this.isAddMode()?"":this.folder.path;var b=this.getFormPanel().getForm();b.findField("library").setValue(this.library.opid);b.findField("preferlanguage").setValue(a);b.findField("path").setValue(c);this.original_values=b.getValues();this.callParent(arguments)},getFormConfig:function(){var b={xtype:"syno_vs_fieldset",title:_VST("videofolder","title"),labelWidth:100,items:[{xtype:"syno_compositefield",fieldLabel:_T("common","folder"),defaults:{hideLabel:true},items:[{xtype:"syno_vs_textfield",width:200,name:"path",readOnly:true,allowBlank:false,blankText:_VST("videofolder","specify_path"),validationEvent:"afterrender"},{xtype:"syno_vs_button",text:_VST("common","select"),btnStyle:"blue",scope:this,handler:this.editPathHandler}]}]};var a={xtype:"syno_vs_fieldset",title:_VST("library","title"),items:[{disabled:!this.isAddMode(),xtype:"syno_vs_combobox",name:"library",fieldLabel:_VST("library","title"),displayField:"title",valueField:"opid",store:this.getLibraryStore(),listeners:{scope:this,select:this.onLibrarySelect}}]};var c={xtype:"syno_vs_fieldset",title:_VST("videofolder","prefer_lang"),items:[{xtype:"syno_vs_combobox",disabled:(SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type),name:"preferlanguage",fieldLabel:_VST("language","title"),displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation2.Util.getLangStore())}]};return{trackResetOnLoad:true,border:false,items:[b,a,c]}},getLibraryStore:function(){this.library_store=this.library_store||new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,root:"data",idProperty:"opid",fields:["id","opid","title","type"],data:{data:SYNO.SDS.VideoStation2.Library.get().getAllLibraries()}});return this.library_store},editPathHandler:function(){var a=new SYNO.SDS.VideoStation2.FileChooser({owner:this,title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},isDirty:function(){if(!Ext.isObject(this.folder)||!Ext.isObject(this.library)){return false}return !SYNO.ux.Utils.checkObjectConsistency(this.getFormPanel().getForm().getValues(),this.original_values)},isValid:function(){return this.getFormPanel().getForm().isValid()},getInvalidError:function(){return _VST("videofolder","specify_path")},getParameter:function(){var b=this.getFormPanel().getForm();var c=b.findField("path").getValue();var a=SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(b.findField("library").getValue());var e=SYNO.SDS.VideoStation2.Util.getShareData(c);var d={share:e.orishare,subpath:e.subpath,section:a.type,preferlang:b.findField("preferlanguage").getValue()};if(a.id>0){d.library_id=a.id}if(!this.isAddMode()){Ext.apply(d,{old_share:this.folder.share,old_subpath:this.folder.subpath})}return d},onChooserSelect:function(b,c){if(c&&Ext.isString(c.path)){var a=this.getFormPanel().getForm();a.findField("path").setValue(c.path)}b.close()},onLibrarySelect:function(c,a,b){var d=this.getFormPanel().getForm().findField("preferlanguage");d.setDisabled(a.get("type")===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO)}});Ext.define("SYNO.SDS.VideoStation2.SettingController",{statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.SettingController.instance)){SYNO.SDS.VideoStation2.SettingController.instance=new SYNO.SDS.VideoStation2.SettingController()}return SYNO.SDS.VideoStation2.SettingController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments)},launchFolderDialog:function(b,a,d){var c=new SYNO.SDS.VideoStation2.FolderDialog({owner:this.getActiveWindow(),library:a,mode:SYNO.SDS.VideoStation2.AddEditDialog[b?"MODE_ADD":"MODE_EDIT"],callback:d});this.openDialog(c)},openDialog:function(a){this.activeDialog.push(a);this.mon(a,"close",this.onDialogClosed,this,{single:true});a.open()},getActiveWindow:function(){return Ext.isEmpty(this.activeDialog)?SYNO.SDS.VideoStation2.Window:this.activeDialog.last()},onDialogClosed:function(a){if(this.activeDialog.last()===a){this.activeDialog.splice(-1)}},confirm:function(c,b,d,a){this.getActiveWindow().getMsgBox().confirm(c,b,d,a)},alert:function(b,a){this.getActiveWindow().getMsgBox().alert(b,a)},confirmAction:function(e,d,c,b){var a=function(f){if("yes"===f){SYNO.SDS.VideoStation2.Util.applyCallback({fn:c,scope:b})}};this.confirm(e,d,a)},sendRequest:function(b){var a=function(d,f,c){this.getActiveWindow().clearStatusBusy();if(c&&c.success){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(b.callback,{args:[d,c]}))}else{var e=SYNO.SDS.VideoStation2.Error.getErrorInfoString(c,_T("common","commfail"));this.alert("",e)}};this.getActiveWindow().setStatusBusy({text:b.loading_text||_T("common","saving")});this.addAjaxTask({url:b.url,method:"POST",single:true,autoJsonDecode:true,params:b.params,scope:this,callback:a},this).start(true)},checkCapability:function(a){SYNO.SDS.VideoStation2.OP.get().getVideoStationInfo({},{success:function(d,c,b){SYNO.SDS.VideoStation2.Capability.get().loadCapability(d);SYNO.SDS.VideoStation2.Util.applyCallback(a)}})},deleteFolder:function(a,b){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),params:{action:"delete",share:a.share,subpath:a.subpath},callback:b})},deleteLibrary:function(a,b){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),params:{action:"delete",id:a.id,type:a.type},callback:b})},exportMetadata:function(a,b){if(!Ext.isObject(a)||!Ext.isString(a.type)||!Ext.isNumber(a.id)){return}this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),params:{action:"export_metadata",id:a.id>0?a.id:0,type:a.type},callback:b})},activeDialog:[]});Ext.define("SYNO.SDS.VideoStation2.EnableColumn",{extend:"SYNO.ux.EnableColumn",constructor:function(){this.callParent(arguments)},isIgnore:function(b,a){if(Ext.isEmpty(this.ignoreKey)){return this.callParent(arguments)}return(true===a.get(this.ignoreKey))},renderer:function(g,e,a,f,c,b){var d=this.scope;if(Ext.isString(d.ignoreKey)&&a.get(d.ignoreKey)===true){return SYNO.SDS.VideoStation2.EnableColumn.superclass.renderer.call(this,"gray",e,a,f,c,b)}else{return SYNO.SDS.VideoStation2.EnableColumn.superclass.renderer.apply(this,arguments)}}});Ext.define("SYNO.SDS.VideoStation2.EnableGrid",{extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:50,constructor:function(a){this.pageSize=a.pageSize||this.pageSize;this.callParent([Ext.apply(this.getConfig(),a)]);this.addClass("enable-grid");this.mon(this.getStore(),"beforeload",this.onBeforeLoad,this)},confirm:Ext.emptyFn,getStore:Ext.emptyFn,getColumns:Ext.emptyFn,saveChanges:Ext.emptyFn,getPagingToolbar:function(){this._paging=this._paging||new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:this.getStore(),displayInfo:true});return this._paging},getConfig:function(){return{store:this.getStore(),border:false,flex:1,viewConfig:{scrollDelay:false,borderHeight:0,cacheSize:50,forceFit:false},stripeRows:true,enableColLock:false,enableColumnMove:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),cm:this.getColumns(),bbar:this.getPagingToolbar()}},saveChangesAndLoadStore:function(a){this.saveChanges({scope:this,fn:function(){this.getStore().commitChanges();this.getStore().load(a)}})},onBeforeLoad:function(a,b){if(!this.isDirty()){return true}var c=function(d){if("yes"===d){this.saveChangesAndLoadStore(b)}else{a.rejectChanges();a.load(b)}};this.confirm("",_T("share","share_save_chg_before_reload"),c,this);return false},isDirty:function(){return !Ext.isEmpty(this.getStore().getModifiedRecords())}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPermissionDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){this.callback=b.callback||{};var a={title:_VST("library","permission"),width:500,height:580,minWidth:300,minHeight:280,resizable:true,layout:"fit",items:[this.getGridPanel(b)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)])},getGridPanel:function(a){this._grid=this._grid||new SYNO.SDS.VideoStation2.Setting.LibraryPermissionGrid({library_id:a.library_id,permission:a.permission});return this._grid},onApply:function(){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(this.callback,{args:[this.getGridPanel().getChanges()]}));this.close()},onCancel:function(){if(!this.getGridPanel().isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this.getMsgBox().confirm("",_T("common","confirm_lostchange"),a,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPermissionGrid",{extend:"SYNO.SDS.VideoStation2.EnableGrid",constructor:function(b){this.library_id=b.library_id;this.changes=b.permission;var a={autoExpandColumn:"name",plugins:[this.getBrowseColumn()]};this.callParent([Ext.apply(a,b)]);this.mon(this.getStore(),"load",this.applyLocalChanges,this)},confirm:function(c,b,d,a){SYNO.SDS.VideoStation2.SettingController.get().confirm(c,b,d,a)},getStore:function(){this._store=this._store||new Ext.data.JsonStore({proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),autoLoad:true,root:"data.users",totalProperty:"data.total",baseParams:{action:"list_permission",id:this.library_id},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"browse",type:"boolean",defaulValue:false}]});return this._store},getColumns:function(){this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getBrowseColumn()]});return this._cm},saveChanges:function(a){this.changes=this.getChanges();SYNO.SDS.VideoStation2.Util.applyCallback(a)},getBrowseColumn:function(){this._browse_column=this._browse_column||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("common","browse"),dataIndex:"browse",id:"browse",width:150,ignoreKey:"is_admin"});return this._browse_column},getStoreChanges:function(){var a={};Ext.each(this.getStore().getModifiedRecords(),function(b){var c=b.get("uid");a[c]=a[c]||{};a[c].browse=b.get("browse")});return a},getChanges:function(){return Ext.apply(this.changes||{},this.getStoreChanges())},applyLocalChanges:function(b,a,c){if(!Ext.isObject(this.changes)){return}b.each(function(d){var e=d.get("uid");if(Ext.isDefined(this.changes[e])){d.set("browse",this.changes[e].browse)}},this);b.commitChanges()}});Ext.define("SYNO.SDS.VideoStation2.LibraryDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",cgi:"library_manage.cgi",constructor:function(b){this.library=SYNO.Util.copy(b.library);this.callback=b.callback||{};var a={resizable:false};this.callParent([Ext.apply(a,b)])},onOpen:function(){this.callParent(arguments);if(this.isAddMode()){return}var a=this.getFormPanel().getForm();a.findField("title").setValue(this.library.title);a.findField("type").setValue(this.library.type);a.findField("is_public").setValue(this.library.is_public?1:0);this.original_values=a.getValues()},getFormConfig:function(){var d={xtype:"syno_vs_textfield",itemId:"title",fieldLabel:_T("common","name"),allowBlank:false,maxLength:50};var b={xtype:"syno_vs_radiogroup",itemId:"type",fieldLabel:_VST("type","tile"),hideLabel:false,columns:1,items:[{boxLabel:_VST("type","movie"),inputValue:SYNO.SDS.VideoStation2.Constant.MOVIE,name:"type",checked:true},{boxLabel:_VST("type","tv_show"),inputValue:SYNO.SDS.VideoStation2.Constant.TVSHOW,name:"type",checked:false},{boxLabel:_VST("type","others"),inputValue:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO,name:"type",checked:false}]};var a={xtype:"syno_vs_radiogroup",itemId:"is_public",fieldLabel:_VST("library","permission_title"),hideLabel:false,columns:1,items:[{boxLabel:_VST("library","public"),inputValue:1,name:"is_public",checked:true},{boxLabel:_VST("library","private"),inputValue:0,name:"is_public",checked:false}],listeners:{scope:this,change:function(f,e){this.getPermissionButton().setDisabled(e.inputValue===1)}}};var c={xtype:"syno_compositefield",items:[this.getPermissionButton()]};return{trackResetOnLoad:true,border:false,labelWidth:180,hideLabels:false,items:[d,b,a,c]}},getPermissionButton:function(){this._permission_btn=this._permission_btn||new SYNO.SDS.VideoStation2.Button({btnStyle:"red",itemId:"permissionButton",disabled:true,text:_VST("library","permission"),handler:this.openPermissionDialog.createDelegate(this)});return this._permission_btn},openPermissionDialog:function(){var a=Ext.isObject(this.library)?this.library.id:0;var c=SYNO.SDS.VideoStation2.SettingController.get();var b=new SYNO.SDS.VideoStation2.Setting.LibraryPermissionDialog({owner:c.getActiveWindow(),library_id:a,permission:this.permission,callback:{scope:this,fn:function(d){this.permission=this.permission||{};Ext.apply(this.permission,d)}}});c.openDialog(b)},isDirty:function(){if(!Ext.isObject(this.library)){return false}return Ext.isObject(this.permission)||!SYNO.ux.Utils.checkObjectConsistency(this.getFormPanel().getForm().getValues(),this.original_values)},isValid:function(){return this.getFormPanel().getForm().isValid()},getInvalidError:function(){return _T("error","error_bad_field")},getParameter:function(){var a=this.getFormPanel().getForm();var b={title:a.findField("title").getValue(),is_public:a.findField("is_public").getValue().inputValue,type:a.findField("type").getValue().inputValue,permission:Ext.encode(this.permission||{})};if(Ext.isObject(this.library)&&!this.isAddMode()){Ext.apply(b,{id:this.library.id,old_type:this.library.type,old_is_public:this.library.is_public?1:0,old_title:this.library.title})}return b}});Ext.define("SYNO.SDS.VideoStation2.MainList",{extend:"SYNO.ux.Panel",constructor:function(b){var a={cls:"main-list",width:200,layout:"fit",items:[new SYNO.SDS.VideoStation2.LibraryPanel()]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.LibraryPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={layout:"fit",items:[this.getDataview()]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.onLibraryLoad,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this)},getDataview:function(){if(!Ext.isObject(this.dataview)){this.dataview=new SYNO.SDS.VideoStation2.ListDataView({cls:"library-dataview",store:SYNO.SDS.VideoStation2.Library.get().getLibraryStore(),listeners:{selectionchange:{buffer:100,scope:this,fn:this.onLibrarySelected}}})}return this.dataview},selectToCurrentLibrary:function(){var a=this.dataview.getStore();var b=a.find("opid",SYNO.SDS.VideoStation2.Library.get().cursor);if(b===-1){return}this.dataview.select(a.getAt(b),true,true)},onLibraryLoad:function(){this.dataview.refresh();this.selectToCurrentLibrary()},onLibraryChanged:function(){if(SYNO.SDS.VideoStation2.Library.get().isDeactivated()){this.dataview.clearSelections()}else{this.selectToCurrentLibrary()}},onLibrarySelected:function(c,a){if(0===a.length){return}var b=this.getDataview().getRecord(a[0]);SYNO.SDS.VideoStation2.Controller.switchLibrary(b.get("opid"))}});Ext.define("SYNO.SDS.VideoStation2.ListDataView",{extend:"SYNO.ux.FleXcroll.DataView",onContainerClick:Ext.emptyFn,constructor:function(b){var a={itemSelector:"dl.list-template",trackOver:false,selectedClass:"selected",overClass:"over",hideHeaders:true,singleSelect:true,tpl:this.getListTpl()};this.callParent([Ext.apply(a,b)])},onClick:function(g,f,d){var b=Ext.fly(f);if(b.hasClass("add")){var c=g.getTarget(this.itemSelector,this.getTemplateTarget());var a=this.getRecord(c);this.addFolderToLibrary(a)}else{if(b.hasClass("add-library")){this.addLibrary()}else{this.callParent(arguments)}}},addFolderToLibrary:function(a){SYNO.SDS.VideoStation2.SettingController.get().launchFolderDialog(true,a.data)},addLibrary:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.LibraryDialog({owner:b.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD,callback:{fn:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}}});b.openDialog(a)},getListTpl:function(){var b=SYNO.SDS.VideoStation2.Library.get().getDefaultLibraryNumber();var a=['<dl class="list-template">',"{[this.getAddFolderIcon(values)]}",'<dt><table cellspacing="0"><tbody><tr>','<td><div class="icon {[this.getIconClass(values)]}"></div></td>','<td><div class="text sds-ellipsis" ext:qtip="{[this.doubleEncode(values.title)]}">',"{title:htmlEncode}","</div></td>","</tr><tbody></table></dt>","</dl>"].join("");var c=new Ext.XTemplate('<dl class="library-title">',"{[this.getAddLibraryIcon(values)]}",'<dt><div>{[_VST("library", "title")]}</div></dt>',"</dl>",'<tpl for=".">','<tpl if="id == 0">',a,"</tpl>",String.format('<tpl if="xindex == {0}"><dl class="divider"></dl></tpl>',b+1),'<tpl if="id &gt; 0">',a,"</tpl>","</tpl>",'<div class="x-clear"></div>',{compiled:true,doubleEncode:function(d){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(d))},getIconClass:function(d){return d.id===0?d.type:"library"},getAddLibraryIcon:function(d){return _S("is_admin")?'<div class="add-library"></div>':""},getAddFolderIcon:function(e){var d=[SYNO.SDS.VideoStation2.Constant.MOVIE,SYNO.SDS.VideoStation2.Constant.TVSHOW,SYNO.SDS.VideoStation2.Constant.HOME_VIDEO].indexOf(e.type)!==-1;return(_S("is_admin")&&d)?'<div class="icon add"></div>':""}});return c}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu",{extend:"SYNO.SDS.VideoStation2.CompositeMenu",constructor:function(b){var a={cls:"filter-menu",items:[this.panel=new SYNO.SDS.VideoStation2.FilterMenu.Panel(b)]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.panel,[SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU]);this.mon(this.panel,SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU,this.onCloseMenu,this);this.mon(this.panel,SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT,this.doLayout,this)},show:function(b,c,a){if(this.alignTarget){b=this.alignTarget.getEl()||b}this.callParent(arguments)},onCloseMenu:function(){this.hide()}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Panel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={tbar:new SYNO.SDS.VideoStation2.FilterMenu.Toolbar(),layout:"accordion",cls:"filter-menu-panel",layoutConfig:{titleCollapse:false,animate:true,activeOnTop:false},items:[this.commonOptions=[new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR})],this.tvRecordingOptions=[new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_DATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DATE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_TITLE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_TITLE})],new SYNO.SDS.VideoStation2.FilterMenu.ResolutionOption({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION}),new SYNO.SDS.VideoStation2.FilterMenu.WatchedStatusOption({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS}),new SYNO.SDS.VideoStation2.FilterMenu.FileCountOption({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT}),new SYNO.SDS.VideoStation2.FilterMenu.Option({category:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER}),new SYNO.SDS.VideoStation2.FilterMenu.DurationOption({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION}),new SYNO.SDS.VideoStation2.FilterMenu.KeywordOption({itemId:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD})],listeners:{scope:this,activate:this.onActivate}};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.getTopToolbar(),[SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU]);this.items.each(function(c){this.relayEvents(c,[SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT])},this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this);this.onLibraryChanged()},onActivate:function(){if(this.layout.activeItem){this.layout.activeItem.fireEvent("activate")}},onLibraryChanged:function(){var c=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TV_RECORDING;this.commonOptions.each(function(d){d.setVisible(!c)});this.tvRecordingOptions.each(function(d){d.setVisible(c)});if(this.rendered){this.items.each(function(d){d.collapse(false)});var b=this[c?"tvRecordingOptions":"commonOptions"][0];b.expand(false);var a=b.header.getHeight();b.items.each(function(d){a+=d.getOuterSize().height});b.setHeight(a);this.doLayout()}else{if(this.ownerCt){this.ownerCt.render()}}}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Toolbar",{extend:"SYNO.ux.Toolbar",statics:{EVENT_CLOSE_MENU:"closemenu"},constructor:function(b){var a={cls:"filter-menu-toolbar",items:[{xtype:"tbtext",text:_VST("filter","title")},"->",this.createSmartPlaylistBtn=new SYNO.SDS.VideoStation2.FilterMenu.ActionButton({cls:"list_add",scope:this,handler:this.onCreateSmartPlaylist,tooltip:_VST("playlist","action_save_as_smart"),disabled:true}),{xtype:"tbseparator"},new SYNO.SDS.VideoStation2.FilterMenu.ActionButton({cls:"erase_s",tooltip:_VST("filter","clean_filter"),scope:this,handler:this.onClearAllFilter})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.onFilterChange()},onFilterChange:function(){var a=SYNO.SDS.VideoStation2.Filter.get().isFilterEmpty();var b=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();this.createSmartPlaylistBtn.setDisabled(a&&!b)},onClearAllFilter:function(){SYNO.SDS.VideoStation2.Filter.get().clearAllFilter()},onCreateSmartPlaylist:function(){this.fireEvent(SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU);SYNO.SDS.VideoStation2.PlaylistActionController.createSmartPlaylist()}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.ActionButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(){this.callParent(arguments);this.addClass("filter-action-button")}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Option",{extend:"SYNO.SDS.VideoStation2.AccordionPanel",statics:{EVENT_UPDATE_LAYOUT:"updatelayout"},category:null,local:false,constructor:function(b){var c=b.category||this.category;var a={cls:"filter-menu-option",items:[this.filterField=new SYNO.SDS.VideoStation2.FilterMenu.OptionFilter({width:280-12*2,store:this.getStore()}),this.detailPanel=new SYNO.SDS.VideoStation2.FilterMenu.OptionDetail({store:this.getStore(),category:c})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy,afterrender:this.onAfterRender,activate:this.onActivate,collapse:this.updateTitle,expand:this.updateTitle}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT);this.updateTitle()},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}});return this.store},updateTitle:function(){var b=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(this.category);this.setTitle('<span class="filter-category-title">'+b+"</span>");if(!this.collapsed){return}var a=SYNO.SDS.VideoStation2.Filter.get().getFilter(this.category);if(!a){return}a=a.map(function(c){return Ext.util.Format.htmlEncode(c.key)}).join(", ");this.setTitle(['<div class="filter-cancel"></div>','<div class="filter-detail">','<span class="filter-title">',b," : </span>",a,"</div>"].join(""))},toggleCollapse:function(){if(!this.collapsed){return}this.callParent(arguments)},onBeforeLoadStore:function(a,b){var d=b.params;var c=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();Ext.apply(d,{type:c,category:this.category,library_id:Ext.encode([SYNO.SDS.VideoStation2.Library.get().getCurrentID()])});Ext.apply(d,SYNO.SDS.VideoStation2.Filter.get().getFilterOption());delete d[this.category]},onAfterRender:function(){this.mon(this.header,"click",this.onHeaderClick,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this)},onBeforeDestroy:function(){this.getStore().destroy()},onHeaderClick:function(a,b){if(Ext.fly(b).hasClass("filter-cancel")){SYNO.SDS.VideoStation2.Filter.get().clearFilter(this.category);return}this.toggleCollapse()},onFilterChange:function(a){if(a===this.category){this.updateTitle()}else{if(!this.collapsed&&!this.local){this.getStore().load()}}},onActivate:function(){if(!this.local){this.getStore().load()}}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.ResolutionOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_RESOLUTION});return this.store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.WatchedStatusOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_WATCHED_STATUS});return this.store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.FileCountOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_FILE_COUNT});return this.store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.DurationOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION,local:true,constructor:function(a){this.callParent(arguments)},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_DURATION});return this.store}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.KeywordOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,local:true,constructor:function(b){var a={hideCollapseTool:true};this.callParent([Ext.apply(a,b)])},getStore:function(){this.store=this.store||new SYNO.SDS.VideoStation2.Stores.localfilter();return this.store},toggleCollapse:function(){return},updateTitle:function(){this.setVisible(SYNO.SDS.VideoStation2.Filter.get().hasKeyword());this.fireEvent(SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT);var b=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(this.category);var a=SYNO.SDS.VideoStation2.Filter.get().getKeyword();this.setTitle(['<div class="filter-cancel"></div>','<div class="filter-detail">','<span class="filter-title">',b," : </span>",Ext.util.Format.htmlEncode(a),"</div>"].join(""))}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.OptionFilter",{extend:"SYNO.SDS.VideoStation2.TextFilter",constructor:function(b){var a={localFilter:true,localFilterField:"key"};this.callParent([Ext.apply(a,b)]);this.mon(this,"render",function(c){c.container.addClass("filter-menu-searchfield")})}});Ext.define("SYNO.SDS.VideoStation2.FilterMenu.OptionDetail",{statics:{EVENT_FIELD_CHANGE:"fieldchange",EVENT_FIELD_VISIBLE_CHANGE:"fieldvisiblechange"},category:null,extend:"SYNO.SDS.Utils.DataView.LazyDataView",constructor:function(b){var a={height:176,cls:"filter-menu-detail",tpl:this.getTpl(),itemSelector:"div.item-wrap",listeners:{scope:this,click:this.onOptionClick}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.mon(this.store,"datachanged",this.onFilterChange.createDelegate(this,[this.category]),this);this.mon(this.store,"load",this.onFilterChange.createDelegate(this,[this.category]),this)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div ext:qtip="{[this.doubleEncode(values.key)]}" class="item-wrap','<tpl if="this.isSelected(key)"> x-view-selected</tpl>','">','<div class="checkbox"></div>{key:htmlEncode}',"</div>","</tpl>",{isSelected:this.isSelected.createDelegate(this),doubleEncode:function(a){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a))}})},isSelected:function(b){var c=SYNO.SDS.VideoStation2.Filter.get().getFilter(this.category);if(!c){return false}var a=false;c.each(function(d){if(d.key===b){a=true;return false}});return a},onOptionClick:function(e,a,d,c){var b=this.store.getAt(a);SYNO.SDS.VideoStation2.Filter.get().toggleFilter(this.category,b.data)},onFilterChange:function(b){if(this.category!==b){return}this.getNodes().each(function(c){Ext.fly(c).removeClass("x-view-selected")});var a=SYNO.SDS.VideoStation2.Filter.get().getFilter(b);if(!a){return}a.each(function(d){var c=this.store.getById(d.key);if(!c){return}var e=this.getNode(c);if(!e){return}Ext.fly(e).addClass("x-view-selected")},this)}});Ext.define("SYNO.SDS.VideoStation2.DetailActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"detail-action-bar",items:[new SYNO.SDS.VideoStation2.DetailActionBar.SelectPlayer(),new SYNO.SDS.VideoStation2.DetailActionBar.MoreAction()]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.DetailActionBar.SelectPlayer",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"device",tooltip:_VST("controller","tooltip_player"),noicon:true,disabled:true,menuBeforeShow:{scope:this,fn:this.refreshPlayerItem}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Player.get(),SYNO.SDS.VideoStation2.Player.EVENT_PLAYER_LOAD,this.onPlayerLoad,this)},refreshPlayerItem:function(c){c.removeAll();var a=SYNO.SDS.VideoStation2.Player.get().getAllPlayers();var b=a.map(function(d){return new Ext.menu.Item({text:Ext.util.Format.htmlEncode(d.title),scope:this,itemId:d.id,handler:this.onPlayerItemClick})},this);c.add(b)},onPlayerLoad:function(){this.setDisabled(Ext.isEmpty(SYNO.SDS.VideoStation2.Player.get().getAllPlayers()))},onPlayerItemClick:function(a){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(a.itemId);this[SYNO.SDS.VideoStation2.File.get().hasMultipleFile()?"chooseFileToPlay":"playVideo"]()},chooseFileToPlay:function(){var b=(function(c){SYNO.SDS.VideoStation2.Controller.switchFile(c.id);this.playVideo()}).createDelegate(this);var a={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType()};SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a,b)},playVideo:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:SYNO.SDS.VideoStation2.File.get().getCurrentID(),video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),subtitle_id:SYNO.SDS.VideoStation2.File.get().getSubtitle(),audiotrack_id:SYNO.SDS.VideoStation2.File.get().getAudiotrack()},{fn:SYNO.SDS.VideoStation2.Controller.refreshViewInfo,args:[SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO]})}});Ext.define("SYNO.SDS.VideoStation2.DetailActionBar.MoreAction",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"more",tooltip:_VST("action","start"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:[this.getActions()]})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.File.get(),SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD,this.onFileLoad,this)},onFileLoad:function(){var a=this.menu.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA);if(a){a.setVisible(SYNO.SDS.VideoStation2.File.get().hasMultipleFile())}},getActions:function(){var a=SYNO.SDS.VideoStation2.ActionUtil.getAvailableVideoActions().filter(function(b){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO].indexOf(b)===-1});return a.map(function(b){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getVideoActionString(b),itemId:b,scope:this,handler:this.doVideoAction})},this)},doVideoAction:function(b){var c;switch(b.itemId){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE:c=SYNO.SDS.VideoStation2.Controller.refreshView;break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE:c=function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.SUBTITLE)};break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:c=function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO)};break;default:c=Ext.emptyFn;break}var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();delete a.file;SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(b.itemId,[a],c)}});Ext.define("SYNO.SDS.VideoStation2.NavigationToolbarPath",{extend:"SYNO.SDS.VideoStation2.TransparentButton",path:null,constructor:function(a){this.callParent(arguments);this.setPath(this.path);this.addClass("nav-toolbar-path");this.mon(this,"click",this.onPathClick)},setPath:function(a){this.path=a;this.setText(Ext.util.Format.htmlEncode(this.path.value))},onPathClick:function(){if(Ext.isDefined(this.path.folder)){SYNO.SDS.VideoStation2.Folder.get().thrinkFolderStackTo(this.path.folder)}switch(this.path.view){case SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.Controller.intoHomePage(true);break;case SYNO.SDS.VideoStation2.View.VIEW_POSTER:SYNO.SDS.VideoStation2.Controller.intoPosterView();break;case SYNO.SDS.VideoStation2.View.VIEW_DETAIL:SYNO.SDS.VideoStation2.Controller.intoVideoDetail();break;case SYNO.SDS.VideoStation2.View.VIEW_TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow();break;case SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST:SYNO.SDS.VideoStation2.Controller.intoPlaylistView();break}}});Ext.define("SYNO.SDS.VideoStation2.NavigationToolbarFilter",{extend:"SYNO.SDS.VideoStation2.TransparentButton",category:null,constructor:function(a){this.callParent(arguments);this.setCategory(this.category);this.addClass("nav-toolbar-filter");this.mon(this,"afterrender",this.onAfterRender,this)},setCategory:function(a){this.category=a;var b=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(a);this.setText(b)},onAfterRender:function(){var a=this.getEl();var b=a.createChild({tag:"div",cls:"filter-cancel"},a.down("em"));this.mon(b,"click",this.onFilterClick,this)},onFilterClick:function(){SYNO.SDS.VideoStation2.Filter.get().clearFilter(this.category)}});Ext.define("SYNO.SDS.VideoStation2.NavigationLeftContainer",{extend:"Ext.Container",constructor:function(b){var a={cls:"left-container",items:[this.categoryBar=new SYNO.SDS.VideoStation2.NavigationBar.CategoryBar(),this.pathBar=new SYNO.SDS.VideoStation2.NavigationBar.PathBar()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.categoryBar,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR]);this.relayEvents(this.pathBar,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR]);this._active=this.categoryBar;this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED,this.switchType,this);this.switchType()},getActiveWidth:function(){return this._active.getResizeEl()?this._active.getWidth():0},switchType:function(){var a=SYNO.SDS.VideoStation2.Navigation.get().getCurrentType();switch(a){case SYNO.SDS.VideoStation2.Navigation.TYPE_CATEGORY:this._active=this.categoryBar;this._deactive=this.pathBar;break;default:this._deactive=this.categoryBar;this._active=this.pathBar;break}this._active.show();this._deactive.hide();this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR)}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",statics:{EVENT_ADJUST_TOOLBAR:"adjusttoolbar"},constructor:function(b){var a={cls:"main-navbar",items:[this.leftContainer=new SYNO.SDS.VideoStation2.NavigationLeftContainer(),"->",this.actionBar=new SYNO.SDS.VideoStation2.NavigationBar.ActionBar()],listeners:{afterlayout:this.adjustToolbarSize,scope:this}};this.callParent([Ext.apply(a,b)]);this.mon(this.leftContainer,SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR,this.adjustToolbarSize,this);this.mon(this.actionBar,SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR,this.adjustToolbarSize,this)},adjustToolbarSize:function(){var b=this.getEl();if(!b){return}var c=b.getWidth()-b.getPadding("lr");var a=this.actionBar.container.getWidth();var d=c-a;this.leftContainer.setWidth(d);this.leftContainer.setWidth(Ext.min([this.leftContainer.getActiveWidth(),d]))}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.CategoryBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-categorybar",items:[this.categoryBtn=new SYNO.SDS.VideoStation2.NavigationBar.CategoryButton(),this.filterBtn=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"filter",tooltip:_VST("filter","title"),menu:new SYNO.SDS.VideoStation2.FilterMenu({alignTarget:this.categoryBtn})}),this.filterBar=new SYNO.SDS.VideoStation2.NavigationBar.FilterBar()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.filterBar,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR]);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.changeFilterState,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeFilterState,this);this.changeFilterState()},changeFilterState:function(){var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL;var a=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE;this.categoryBtn.setVisible(!a);this.filterBtn.setVisible(b);this.filterBar.setVisible(b||a);this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR)},hide:function(){this.callParent(arguments);this.categoryBtn.menu.hide();this.filterBtn.menu.hide()}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.FilterBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-filterbar",items:[]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadFilter,this);this.loadFilter()},loadFilter:function(){this.removeAll();var a=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(a,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());this.add(Object.keys(a).map(function(b){return new SYNO.SDS.VideoStation2.NavigationToolbarFilter({category:b})}));this.doLayout();this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR)}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.PathBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-pathbar",items:[]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED,this.loadPath,this);this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK,this.goback,this);this.loadPath()},loadPath:function(){this.removeAll();var a=SYNO.SDS.VideoStation2.Navigation.get().getCurrentPath();if(!a){return}this.add(a.map(function(b){return new SYNO.SDS.VideoStation2.NavigationToolbarPath({path:b})}));this.doLayout();this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR)},goback:function(){if(this.hidden){return}if(this.items.length<=1){return}this.items.get(this.items.length-2).fireEvent("click")}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.ActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(b){var a={cls:"navbar-actionbar",items:[this.detailActionBar=new SYNO.SDS.VideoStation2.DetailActionBar(),this.listActionBar=new SYNO.SDS.VideoStation2.NavigationBar.ListActionBar()]};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.detailActionBar,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR]);this.relayEvents(this.listActionBar,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR]);this.mon(SYNO.SDS.VideoStation2.BrowsingAction.get(),SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED,this.switchAction,this);this.switchAction()},switchAction:function(){var a=SYNO.SDS.VideoStation2.BrowsingAction.get().getCurrentAction();switch(a){case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_NONE:this.detailActionBar.hide();this.listActionBar.hide();break;case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_DETAIL:this.detailActionBar.show();this.listActionBar.hide();break;default:this.detailActionBar.hide();this.listActionBar.show();break}this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR)}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.ListActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(c){var d=SYNO.SDS.VideoStation2.View.getAllTypes().map(function(e){return new Ext.Action({text:_VST("common","mode_"+e),scope:this,itemId:e,handler:this.onViewTypeClick})},this);var a=SYNO.SDS.VideoStation2.Sort.getAllSorts().map(function(e){return new Ext.Action({text:String.format(_VST("sort","sort_by"),_VST("common",e)||_VST("classification",e)),scope:this,itemId:e,handler:this.onSortTypeClick})},this);a=a.concat(SYNO.SDS.VideoStation2.Sort.getAllDirections().map(function(e){return new Ext.Action({text:_VST("sort","order_"+e),scope:this,itemId:e,handler:this.onSortDirClick})},this));var b={cls:"navbar-list-actionbar",items:[this.selectModeBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"select_mode",tooltip:_VST("common","selection_mode"),enableToggle:true,scope:this,toggleHandler:this.onSelectModeToggle}),this.selectActionBar=new SYNO.SDS.VideoStation2.NavigationBar.SelectActionBar(),this.viewTypeBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"view_list",menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:d})}),this.sortBtn=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"sort",tooltip:_VST("action","sort"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:a})}),this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",tooltip:_VST("action","edit_metadata"),scope:this,handler:this.onEditClick})]};this.callParent([Ext.apply(b,c)]);this.relayEvents(this.selectActionBar,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR]);this.mon(SYNO.SDS.VideoStation2.BrowsingAction.get(),SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED,this.switchAction,this);this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.loadSort,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChange,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChange,this);this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED,this.onVideoSelectModeChange,this)},switchAction:function(){var a=SYNO.SDS.VideoStation2.BrowsingAction.get().getCurrentAction();switch(a){case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_SELECT:this.selectActionBar.show();break;default:this.selectActionBar.hide();break}},loadViewType:function(){var a=SYNO.SDS.VideoStation2.View.get().getViewType();var b=SYNO.SDS.VideoStation2.View.getAllTypes().map(function(c){return"view_"+c});this.viewTypeBtn.removeClass(b);this.viewTypeBtn.addClass("view_"+a);this.viewTypeBtn.setTooltip(_VST("common","mode_"+a));this.viewTypeBtn.menu.getComponent(SYNO.SDS.VideoStation2.View.TYPE_TILE).setVisible(SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST);this.viewTypeBtn.menu.items.each(function(c){c.removeClass("checked");if(c.itemId===a){c.addClass("checked")}})},loadSort:function(){var a=[SYNO.SDS.VideoStation2.Sort.get().getCurrentSort(),SYNO.SDS.VideoStation2.Sort.get().getCurrentSortDir()];this.sortBtn.menu.items.each(function(b){b.removeClass("checked");if(-1!==a.indexOf(b.itemId)){b.addClass("checked")}},this)},changeSortBtnState:function(){this.sortBtn.setDisabled(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_ALL||SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW||SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST)},changeSelectModeBtnState:function(){var a=SYNO.SDS.VideoStation2.View.get().getView();var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();this.selectModeBtn.setVisible(!((SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW&&a===SYNO.SDS.VideoStation2.View.VIEW_POSTER&&b!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER)||(a===SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST)));this.selectModeBtn.toggle(SYNO.SDS.VideoStation2.Video.get().isInSelectMode())},changeEditBtnState:function(){this.editBtn.setVisible(SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW&&!SYNO.SDS.VideoStation2.Video.get().isInSelectMode());this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR)},onViewChange:function(){this.loadViewType();this.changeSortBtnState();this.changeSelectModeBtnState();this.changeEditBtnState()},onViewTypeChange:function(){this.loadViewType()},onVideoSelectModeChange:function(){this.changeSelectModeBtnState();this.changeEditBtnState()},onLibraryChange:function(){this.changeSortBtnState();this.changeSelectModeBtnState()},onCategoryChange:function(){this.changeSortBtnState();this.changeSelectModeBtnState()},onViewTypeClick:function(a){SYNO.SDS.VideoStation2.View.get().setViewType(a.itemId)},onSortTypeClick:function(a){SYNO.SDS.VideoStation2.VideoListController.toSortType(a.itemId)},onSortDirClick:function(a){SYNO.SDS.VideoStation2.VideoListController.toSortDirection(a.itemId)},onSelectModeToggle:function(b,a){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(a,true)},onEditClick:function(){SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,[{id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Constant.TVSHOW,mapper_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow().mapper_id}],SYNO.SDS.VideoStation2.Controller.refreshViewInfo)},hide:function(){this.callParent(arguments);this.viewTypeBtn.menu.hide();this.sortBtn.menu.hide()}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.SelectActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(c){var b={scope:this,handler:this.onVideoAction};var a={cls:"navbar-select-actionbar",hideMode:"custom",items:[new SYNO.SDS.VideoStation2.MenuActionButton({cls:"select_collection",tooltip:_VST("playlist","title"),menuBeforeShow:{scope:this,fn:this.onBeforeSelectPlaylistShow}}),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_share",tooltip:_VST("advanced","public_sharing"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_view",tooltip:_VST("action","set_watched"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_view_off",tooltip:_VST("action","set_unwatched"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED},b)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_delete",tooltip:_VST("action","del_video"),hidden:!_S("is_admin"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO},b))],listeners:{scope:this}};this.callParent([Ext.apply(a,c)]);this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED,this.onVideoSelectionChange,this);this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:true});this.onVideoSelectionChange()},recalculateWidth:function(){var a;if(!(a=this.getEl())){return}this.setWidth(this.items.items.reduce(function(b,c){return b+c.container.getWidth()},0))},onCapabilityReady:function(){this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING).setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing())},onVideoSelectionChange:function(){var a=SYNO.SDS.VideoStation2.Video.get().isVideoSelectionEmpty();this.items.each(function(b){b.setDisabled(a)})},onBeforeSelectPlaylistShow:function(h){h.removeAll();var c=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();var f={};var a=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST;var e=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();c.each(function(i){if(!i.playlists){return}i.playlists.each(function(j){f[j.id]=(f[j.id]||0)+1})});var b=function(i){return(f[i.id]===c.length)?"checked":""};var d=function(i){return(a&&e===i.id)};var g=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:b,disabledFn:d,createPlaylistFn:this.onCreatePlaylist,clickPlaylistFn:this.onPlaylistClick},this);h.add(g)},onVideoAction:function(a){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();if(b.length===0){return}SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(a.itemId,b,SYNO.SDS.VideoStation2.Controller.refreshView)},onCreatePlaylist:function(){var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();SYNO.SDS.VideoStation2.VideoActionController.createPlaylist(a,SYNO.SDS.VideoStation2.Controller.refreshView)},onPlaylistClick:function(c){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();var d=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(parseInt(c.itemId,10));var a=!c.getEl().hasClass("checked");var e=this.onPlaylistAddRemove.createDelegate(this,[a,c]);SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(b,d.id,a,e)},onPlaylistAddRemove:function(a,b){if(b&&!b.isDestroyed){b.getEl()[a?"addClass":"removeClass"]("checked")}SYNO.SDS.VideoStation2.Controller.refreshView()},onShow:function(){this.callParent(arguments);this.removeClass("hide");this.addClass("show");this.recalculateWidth();this.fireEvent.defer(500,this,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR])},onHide:function(){this.callParent(arguments);this.addClass("hide");this.removeClass("show");this.setWidth(0);this.fireEvent.defer(500,this,[SYNO.SDS.VideoStation2.NavigationBar.EVENT_ADJUST_TOOLBAR])}});Ext.define("SYNO.SDS.VideoStation2.NavigationBar.CategoryButton",{extend:"SYNO.SDS.VideoStation2.TransparentButton",constructor:function(b){var c=SYNO.SDS.VideoStation2.Category.getAllCategories().map(function(d){return new Ext.Action({text:_VST("classification",d),scope:this,itemId:d,handler:this.onCategoryClick})},this);var a={cls:"category-button",menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:c})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadCategory,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChange,this);this.loadCategory()},loadCategory:function(){var a=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();var b=this.menu.getComponent(a);this.setText(b.text)},onLibraryChange:function(){var b=SYNO.SDS.VideoStation2.Library.get().getCurrentType();var a=[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER];Ext.each(a,function(c){this.menu.getComponent(c).setVisible(b!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},this);this.adjustReleasedText(b)},adjustReleasedText:function(d){var a=this.menu.getComponent(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED);var c=SYNO.SDS.VideoStation2.Controller.getClassificationString(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,d);var b=[a];if(this.getText()===a.text){b.push(this)}Ext.each(b,function(e){e.setText(c)})},onCategoryClick:function(a){switch(a.itemId){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyWatchCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyReleasedCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_ALL:SYNO.SDS.VideoStation2.VideoListController.toAllCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER:SYNO.SDS.VideoStation2.VideoListController.toFolderCategory();break}}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",statics:{EVENT_HEIGHT_CHANGE:"heightchange"},constructor:function(b){var a={title:_VST("advanced","panel_title"),labelWidth:200,trackResetOnLoad:true,items:[new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.TranscodingSet(),new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet(),new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet()],listeners:{scope:this,afterrender:{fn:this.initEnableCheckGroup,single:true},activate:{fn:this.loadData}}};this.callParent([Ext.apply(a,b)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.EVENT_HEIGHT_CHANGE);this.items.each(function(c){this.relayEvents(c,[SYNO.SDS.VideoStation2.Setting.AdvancedPanel.EVENT_HEIGHT_CHANGE])},this)},isDirty:function(){return this.getForm().isDirty()},initEnableCheckGroup:function(){var a;a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"cmzvideo_cover",["cmzvideo_cover_rule"]);a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"opensubtitles_enable",["opensubtitles_username","opensubtitles_password","opensubtitles_language"])},loadData:function(){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:{action:"load"},callback:{scope:this,fn:function(b,a){this.getForm().setValues(a.data)}}})},saveChanges:function(d){var b=this.getForm();if(!b.isValid()){return}var c=b.findField("cmzvideo_cover_rule");if(Ext.isEmpty(c.getValue().trim())){c.setValue(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet.DEFAULT_COVER_RULE)}var a=b.getValues();if(a.opensubtitles_password&&a.opensubtitles_password.indexOf("\t")!==-1){a.opensubtitles_password="\t\t\t\t\t\t\t\t"}if(Ext.isArray(a.opensubtitles_language)){a.opensubtitles_language=a.opensubtitles_language.join(",")}SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:Ext.apply({action:"save"},a),callback:{fn:function(f,e){b.setValues(a);SYNO.SDS.VideoStation2.Util.applyCallback(d)}}})},rejectChanges:function(){this.getForm().reset()}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.TranscodingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={title:_VST("advanced","transcoding_settings"),collapsible:true,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){var b=["getEnableAC3Passthrough","getEnableHardwareTranscode","getSharingTranscodeOption"];var a=[];Ext.each(b,function(d){var c=this[d]();if(Ext.isObject(c)){a.push(c)}},this);return a},getEnableAC3Passthrough:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("advanced","pass_through_ac3"),name:"not_trans_audio_ac3_to_mp3"})},getEnableHardwareTranscode:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToHardwareTranscode()){return null}return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("advanced","enable_hardware_accelerate"),name:"hardware_transcode"})},getSharingTranscodeOption:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToRemux()){return null}var a=[["disable",_VST("advanced","disallow_transcode")],["remux",_VST("advanced","allow_remux")],["transcode",_VST("advanced","allow_transcode")]];if(!SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()){a.splice(-1)}return new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("advanced","public_sharing"),displayField:"display",valueField:"value",name:"public_sharing_transcode_option",store:new Ext.data.ArrayStore({fields:["value","display"],data:a})})}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",statics:{DEFAULT_COVER_RULE:"cover.jpg;Cover.jpg;COVER.jpg;folder.jpg;Folder.jpg;FOLDER.jpg"},constructor:function(b){var a={title:_VST("advanced","video_cover_settings"),collapsible:true,labelWidth:250,items:[this.getEnableCoverRule(),this.getCoverRuleDescription(),this.getCustomizedCoverRule()]};this.callParent([Ext.apply(a,b)])},getEnableCoverRule:function(){return new SYNO.SDS.VideoStation2.Checkbox({name:"cmzvideo_cover",boxLabel:_VST("advanced","customized_video_cover")})},getCoverRuleDescription:function(){return{xtype:"syno_vs_displayfield",indent:1,name:"video_cover_note",value:String.format('<span class="syno-ux-note">{0}: </span>{1} {2}',_T("common","note"),_VST("advanced","only_apply_to"),_VST("advanced","same_filename_high_priority"))}},getCustomizedCoverRule:function(){return new SYNO.SDS.VideoStation2.TextField({indent:1,width:300,name:"cmzvideo_cover_rule",fieldLabel:_VST("advanced","filename"),validator:this.coverRuleValidator})},coverRuleValidator:function(b){if(Ext.isEmpty(b.trim())){return true}var a=null;var c=b.split(";");Ext.each(c,function(d){if(-1===d.search(/.+\.([jJ][pP][gG]|[jJ][pP][eE][gG])$/)){a=String.format(_VST("advanced","cover_format_error"),SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet.DEFAULT_COVER_RULE);return false}});return a||true}});Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",statics:{LANGUAGE_MAPPING:{csy:"cze",dan:"dan",enu:"eng",fre:"fre",ger:"ger",hun:"hun",ita:"ita",jpn:"jpn",krn:"kor",nld:"dut",nor:"nor",plk:"pol",ptb:"pob",ptg:"por",rus:"rus",spn:"spa",sve:"swe",trk:"tur"},EXTRA_LANGUAGE:[["chi",_VST("language","chinese")],["fin",_VST("language","finnish")],["ara",_VST("language","arabic")]]},constructor:function(b){var a={title:_VST("advanced","subtitle_settings"),collapsible:true,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){return[{xtype:"syno_vs_checkbox",name:"opensubtitles_enable",boxLabel:_VST("advanced","opensubtitles_enable")},{xtype:"syno_vs_textfield",name:"opensubtitles_username",emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_username"),indent:1},{xtype:"syno_vs_textfield",textType:"password",maxLength:"32",name:"opensubtitles_password",emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_password"),indent:1},{xtype:"syno_vs_superbox",name:"opensubtitles_language",fieldLabel:_VST("advanced","opensubtitles_language"),store:this.getOpenSubtitlesLanguageStore(),allowBlank:false,allowAddNewData:false,editable:false,mode:"local",indent:1,listeners:{scope:this,additem:this.notifyHeightChange,removeitem:this.notifyHeightChange}},{xtype:"syno_vs_checkbox",name:"shooter_enable",boxLabel:_VST("advanced","shooter_enable")}]},getOpenSubtitlesLanguageStore:function(){var a=SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.LANGUAGE_MAPPING;return SYNO.SDS.Utils.getSupportedLanguage().map(function(b){return !Ext.isEmpty(a[b[0]])?[a[b[0]],b[1]]:null}).filter(function(b){return !Ext.isEmpty(b)}).concat(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.EXTRA_LANGUAGE)},notifyHeightChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.EVENT_HEIGHT_CHANGE)}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={title:_VST("dtv","title"),itemId:"dtv_settings",labelWidth:200,trackResetOnLoad:true,items:this.getItems(),listeners:{scope:this}};this.callParent([Ext.apply(a,b)])},getItems:function(){return[new SYNO.SDS.VideoStation2.Setting.DTVPanel.FolderSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.StreamingSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.RecordingSet(),new SYNO.SDS.VideoStation2.Setting.DTVPanel.TVGuideSet(),new SYNO.SDS.VideoStation2.FieldSet({collapsible:true,title:_T("common","advanced"),items:[new SYNO.SDS.VideoStation2.Setting.DTVDisableCheckbox({owner:this})]})]}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.FolderSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("dtvfolder","title"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){return[{xtype:"hidden",name:"share"},{xtype:"hidden",name:"subpath"},{xtype:"syno_compositefield",fieldLabel:_VST("dtvfolder","dtv_destination"),defaults:{hideLabel:true},items:[this.getDestination(),this.getFolderButton()]},{xtype:"syno_compositefield",items:[this.getExportButton()]}]},getExportButton:function(){this._export=this._export||new SYNO.SDS.VideoStation2.Button({text:_VST("action","export_metadata"),disabled:true,scope:this});return this._export},getDestination:function(){this._destination=this._destination||new SYNO.SDS.VideoStation2.TextField({name:"dtv_destination",readOnly:true,width:157,listeners:{scope:this}});return this._destination},getFolderButton:function(){this._folder=this._folder||new SYNO.SDS.VideoStation2.Button({btnStyle:"blue",text:_VST("common","select"),scope:this});return this._folder}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.StreamingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("programguide","broadcast_streaming"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){var a=[{xtype:"syno_vs_checkbox",boxLabel:_VST("streaming","enable_streaming_auth"),name:"enableauth"}];a.push(this.getAccountField());a.push(this.getPasswordField());a.push(this.getPasswordConfirmField());a.push({xtype:"syno_vs_checkbox",boxLabel:_VST("streaming","enable_stream_limit"),name:"enable_viewer_limit"});a.push(this.getStreamingLimitField());return a},getAccountField:function(){this._account=this._account||new SYNO.SDS.VideoStation2.TextField({name:"account",fieldLabel:_VST("streaming","stream_auth_user"),width:160,indent:1});return this._account},getPasswordField:function(){this._passwd=this._passwd||new SYNO.SDS.VideoStation2.TextField({name:"passwd",textType:"password",fieldLabel:_T("common","password"),width:160,indent:1});return this._passwd},getPasswordConfirmField:function(){this._confirm=this._confirm||new SYNO.SDS.VideoStation2.TextField({name:"password_confirm",textType:"password_confirm",fieldLabel:_VST("streaming","pass_confirm"),width:160,indent:1});return this._confirm},getStreamingLimitField:function(){this._limit=this._limit||new SYNO.SDS.VideoStation2.NumberField({name:"streaming_limit",fieldLabel:_VST("streaming","streaming_limit_viewer"),width:160,indent:1,decimalPrecision:0,minValue:1,maxlength:6});return this._limit}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.RecordingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("record","record_setting"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(a,b)])},getItems:function(){var a=[{xtype:"syno_vs_checkbox",boxLabel:_VST("record","record_first_stream"),name:"closestreaming"}];a.push(this.getPreRecordingField());a.push(this.getPostRecordingField());return a},getPreRecordingField:function(){this._pre=this._pre||new SYNO.SDS.VideoStation2.NumberField({name:"pre_recording",fieldLabel:_VST("record","pre_recording_interval"),indent:1,width:160,minValue:0,maxValue:3600,maxlength:4,emptyText:_T("common","time_seconds")});return this._pre},getPostRecordingField:function(){this._post=this._post||new SYNO.SDS.VideoStation2.NumberField({name:"post_recording",fieldLabel:_VST("record","post_recording_interval"),indent:1,width:160,minValue:0,maxValue:3600,maxlength:4,emptyText:_T("common","time_seconds")});return this._post}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.TVGuideSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(b){var a={collapsible:true,title:_VST("programguide","setting"),labelWidth:250,items:[this.getFrequencyCombo()]};this.callParent([Ext.apply(a,b)])},getFrequencyCombo:function(){this._frequency=this._frequency||new SYNO.SDS.VideoStation2.ComboBox({name:"epg_update_frequency",fieldLabel:_VST("programguide","update_frequency"),displayField:"display",valueField:"value",value:"daily",store:this.getFrequencyStore()});return this._frequency},getFrequencyStore:function(){this._store=this._store||new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:[["twiceaday",_VST("programguide","frequency_twice_a_day")],["daily",_VST("programguide","frequency_daily")],["3days",_VST("programguide","frequency_3_day")],["weekly",_VST("programguide","frequency_weekly")],["never",_VST("programguide","frequency_never")]]});return this._store}});Ext.define("SYNO.SDS.VideoStation2.Setting.DTVDisableCheckbox",{extend:"SYNO.SDS.VideoStation2.Checkbox",constructor:function(b){var a={boxLabel:_VST("dtv","disable_dtv"),name:"disable_dtv"};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPanel",{statics:{EVENT_HEIGHT_CHANGE:"heightchange",EVENT_DO_REINDEX:"doreindex",EVENT_DO_SEARCH_INFO:"dosearchinfo",EVENT_DO_RELOAD_FOLDER:"doreloadfolder"},extend:"SYNO.ux.Panel",constructor:function(b){var a={title:_VST("library","title"),cls:"library-panel",autoFlexcroll:true,layout:"accordion",layoutConfig:{animate:false,activeOnTop:false,fill:false,hideCollapseTool:true,titleCollapse:true},tbar:this.getToolbar(),items:[this.getItems()]};this.callParent([Ext.apply(a,b)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_HEIGHT_CHANGE);this.bindAllEvents();this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.refreshLibrary,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE,this.onFolderSelectionChange,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_LIBRARY_SELECTION_CHANGE,this.onLibrarySelectionChange,this)},getToolbar:function(){this._tbar=this._tbar||new SYNO.ux.Toolbar({items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"add-library",tooltip:_VST("library","create"),scope:this,handler:this.addLibrary}),this.getReindexButton(),this.getSearchInfoButton(),this.getExportButton()]});return this._tbar},getItems:function(){var a=SYNO.SDS.VideoStation2.Library.get().getAllLibraries();return a.map(function(b){return new SYNO.SDS.VideoStation2.Setting.FolderPanel({library:b})})},getReindexButton:function(){this._reindex=this._reindex||new SYNO.SDS.VideoStation2.ActionButton({cls:"reindex",tooltip:_VST("action","reindex_no_update"),scope:this,disabled:true,handler:this.doReindex});return this._reindex},getSearchInfoButton:function(){this._search=this._search||new SYNO.SDS.VideoStation2.ActionButton({cls:"search-info",tooltip:_VST("action","reindex_with_update"),scope:this,disabled:true,handler:this.doSearchInfo});return this._search},getExportButton:function(){this._export=this._export||new SYNO.SDS.VideoStation2.ActionButton({cls:"export",tooltip:_VST("action","export_metadata"),scope:this,handler:this.exportMetadata});return this._export},bindAllEvents:function(){this.items.each(function(a){this.relayEvents(a,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_HEIGHT_CHANGE,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_LIBRARY_SELECTION_CHANGE]);a.relayEvents(this,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_REINDEX,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_SEARCH_INFO,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_RELOAD_FOLDER])},this)},refreshLibrary:function(){this.removeAll();this.add(this.getItems());this.bindAllEvents();this.doLayout()},onLibrarySelectionChange:function(a){this.active_library=SYNO.Util.copy(a);this.getExportButton().setDisabled(!Ext.isObject(this.active_library))},onFolderSelectionChange:function(a){this.getReindexButton().setDisabled(!Ext.isObject(a));this.getSearchInfoButton().setDisabled(!Ext.isObject(a));this.getExportButton().setDisabled(Ext.isObject(a))},addLibrary:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.LibraryDialog({owner:b.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD,callback:{fn:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}}});b.openDialog(a)},doReindex:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_REINDEX,this.active_library)},doSearchInfo:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_SEARCH_INFO,this.active_library)},doReloadCurrentLibrary:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_RELOAD_FOLDER,this.active_library)},exportMetadata:function(){var a=function(){SYNO.SDS.VideoStation2.SettingController.get().exportMetadata(this.active_library||{},{fn:this.doReloadCurrentLibrary,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","export_metadata_desc"),a,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.FolderPanel",{statics:{ACTION_ADD_FOLDER:{cls:"add-folder",qtip:_VST("videofolder","add"),fn:"addFolder"},ACTION_EDIT_LIBRARY:{cls:"edit",qtip:_VST("library","edit"),fn:"editLibrary"},ACTION_DELETE_LIBRARY:{cls:"delete",qtip:_VST("library","delete"),fn:"deleteLibrary"},EVENT_FOLDER_CHANGE:"folderchange",EVENT_FOLDER_SELECTION_CHANGE:"folderselectionchange",EVENT_LIBRARY_SELECTION_CHANGE:"libraryselectionchange",EVENT_EDIT_FOLDER:"editfolder",EVENT_DELETE_FOLDER:"deletefolder"},extend:"SYNO.SDS.VideoStation2.AccordionPanel",header:false,headerAsText:false,title:null,constructor:function(b){this.library=SYNO.Util.copy(b.library);this.dataview=new SYNO.SDS.VideoStation2.Setting.FolderDataView({store:this.getStore()});var a={cls:"folder-panel",headerCfg:this.getHeaderConfig(),items:[this.dataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,expand:this.notifyHeightChange,collapse:this.notifyHeightChange}};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.dataview,[SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE]);this.mon(this,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_CHANGE,this.loadData,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE,this.onFolderSelectionChange,this);this.mon(this.dataview,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_EDIT_FOLDER,this.editFolder,this);this.mon(this.dataview,SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_DELETE_FOLDER,this.deleteFolder,this)},getHeaderConfig:function(){var b={tag:"td",align:"left",cn:[{tag:"div",cls:(this.library.id===0?this.library.type:"library")+" icon"},{tag:"div",cls:"title",html:Ext.util.Format.htmlEncode(this.library.title)}]};var c=[SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_ADD_FOLDER)];if(this.library.id>0){Array.prototype.push.apply(c,[SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_EDIT_LIBRARY),SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_DELETE_LIBRARY)])}c=c.map(function(d){return{tag:"div","ext:qtip":Ext.util.Format.htmlEncode(d.qtip),cls:String.format("action {0}",d.cls),fnname:d.fn}});var a={tag:"td",align:"right",cn:c};return{tag:"div",cls:"x-panel-header",cn:[{tag:"table",cls:"x-toolbar-ct",cn:[{tag:"tbody",cn:[{tag:"tr",cn:[b,a]}]}]}]}},getStoreParameter:function(){var a={action:"list",section:this.library.type};if(this.library.id>0){Ext.apply(a,{library_id:this.library.id})}return a},getStore:function(){this._store=this._store||new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,idProperty:"path",root:"data.folders",baseParams:this.getStoreParameter(),fields:["exist","path","preferlang","status","share","subpath"],proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),listeners:{scope:this,load:this.onFolderLoad}});return this._store},toggleCollapse:function(b){var a=Ext.fly(b.getTarget());if(a.hasClass("action")){this[a.getAttribute("fnname")]()}else{this.callParent(arguments)}},addFolder:function(){SYNO.SDS.VideoStation2.SettingController.get().launchFolderDialog(true,this.library,{fn:this.loadData,scope:this})},editFolder:function(b){var c=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.FolderDialog({owner:c.getActiveWindow(),library:this.library,folder:b,mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,callback:{scope:this,fn:this.notifyFolderChange}});c.openDialog(a)},editLibrary:function(){var b=SYNO.SDS.VideoStation2.SettingController.get();var a=new SYNO.SDS.VideoStation2.LibraryDialog({owner:b.getActiveWindow(),library:this.library,mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,callback:{scope:this,fn:this.reloadLibrary}});b.openDialog(a)},deleteFolder:function(b){var a=function(){SYNO.SDS.VideoStation2.SettingController.get().deleteFolder(SYNO.Util.copy(b),{fn:this.notifyFolderChange,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("videofolder","delete_confirm"),a,this)},deleteLibrary:function(){var a=function(){SYNO.SDS.VideoStation2.SettingController.get().deleteLibrary(this.library,{fn:this.reloadLibrary,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","delete_confirm"),a,this)},reloadLibrary:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()},reindexRequest:function(a){if(!Ext.isObject(this.active_folder)){SYNO.Debug.error("no folder selection");return}SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),params:{action:a,share:this.active_folder.share,subpath:this.active_folder.subpath},loading_text:_T("common","loading"),callback:{fn:this.loadData,scope:this}})},doReindex:function(a){if(SYNO.ux.Utils.checkObjectConsistency(this.library,a)){this.reindexRequest("reindex-noupdate")}},doSearchInfo:function(a){if(SYNO.ux.Utils.checkObjectConsistency(this.library,a)){this.reindexRequest("reindex-update")}},doReloadFolder:function(a){if(SYNO.ux.Utils.checkObjectConsistency(this.library,a)){this.loadData()}},notifyHeightChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_HEIGHT_CHANGE)},notifyFolderChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_CHANGE)},onFolderLoad:function(b,a,c){if(!this.collapsed){this.notifyHeightChange()}},onActivate:function(){this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_REINDEX,this.doReindex,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_SEARCH_INFO,this.doSearchInfo,this);this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_RELOAD_FOLDER,this.doReloadFolder,this);this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_LIBRARY_SELECTION_CHANGE,this.library);this.loadData()},onDeactivate:function(){this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_REINDEX,this.doReindex,this);this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_SEARCH_INFO,this.doSearchInfo,this);this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.EVENT_DO_RELOAD_FOLDER,this.doReloadFolder,this);this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE,null)},onFolderSelectionChange:function(a){this.active_folder=SYNO.Util.copy(a)},loadData:function(){this.getStore().load()}});Ext.define("SYNO.SDS.VideoStation2.Setting.FolderDataView",{extend:"Ext.DataView",constructor:function(b){var a={cls:"folder-dataview",tpl:this.getTpl(),itemSelector:"div.item-wrap",overClass:"x-view-over",singleSelect:true,listeners:{scope:this,selectionchange:this.onSelectionChange}};this.callParent([Ext.apply(a,b)])},getTpl:function(){var a=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("videofolder","edit")));var b=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("videofolder","delete")));return new Ext.XTemplate('<tpl for=".">','<div class="item-wrap">','<div class="select-mark"></div>','<table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">','<div class="text-wrapper sds-ellipsis">','<span class="path">{path}</span>{[this.getStatusSpan(values)]}',"</div>","</td>",'<td align="right">','<div class="action-wrapper">',String.format('<div ext:qtip="{0}" class="action edit"></div><div ext:qtip="{1}", class="action delete"></div>',a,b),"</div>","</td>","</tr></tbody></table>","</div>","</tpl>",{compiled:true,getStatusSpan:this.getStatusSpan.createDelegate(this)})},getStatusSpan:function(a){return !Ext.isEmpty(a.status)?String.format('<span class="status">({0}...)</span>',a.status):""},onClick:function(g,f,d){var b=Ext.fly(f);var c=g.getTarget(this.itemSelector,this.getTemplateTarget());var a=this.getRecord(c);if(b.hasClass("delete")){this.deleteFolder(a)}else{if(b.hasClass("edit")){this.editFolder(a)}else{this.callParent(arguments)}}},onSelectionChange:function(a,b){if(Ext.isEmpty(b)){this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE,null)}else{this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_FOLDER_SELECTION_CHANGE,a.getRecord(b[0]).data)}},editFolder:function(a){this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_EDIT_FOLDER,a.data)},deleteFolder:function(a){this.fireEvent(SYNO.SDS.VideoStation2.Setting.FolderPanel.EVENT_DELETE_FOLDER,a.data)}});Ext.define("SYNO.SDS.VideoStation2.Setting.PrivilegePanel",{extend:"SYNO.SDS.VideoStation2.EnableGrid",constructor:function(b){var a={title:_VST("privilege","title"),autoExpandColumn:"name",plugins:this.getEnableColumns(),listeners:{scope:this,activate:this.onActivate}};this.callParent([Ext.apply(a,b)])},onActivate:function(){this.getStore().load()},confirm:function(c,b,d,a){SYNO.SDS.VideoStation2.SettingController.get().confirm(c,b,d,a)},getStore:function(){this._store=this._store||new Ext.data.JsonStore({proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("privilege_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),autoLoad:false,root:"data.users",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"dtv",type:"boolean",defaulValue:false},{name:"renderer",type:"boolean",defaulValue:false},{name:"sharing",type:"boolean",defaulValue:false}]});return this._store},getColumns:function(){this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"}].concat(this.getEnableColumns())});return this._cm},getEnableColumns:function(){var a=[];return a.concat([this.getRendererColumn(),this.getSharingColumn()])},saveChanges:function(a){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("privilege_manage.cgi"),params:{action:"save",privilege:Ext.encode(this.getChanges()||{})},callback:a})},rejectChanges:function(){this.getStore().rejectChanges()},getDTVColumn:function(){this._dtv=this._dtv||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","dtv_control"),dataIndex:"dtv",id:"dtv",width:150,ignoreKey:"is_admin"});return this._dtv},getRendererColumn:function(){this._renderer=this._renderer||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","renderer_control"),dataIndex:"renderer",id:"renderer",width:200,ignoreKey:"is_admin"});return this._renderer},getSharingColumn:function(){this._sharing=this._sharing||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","public_sharing"),dataIndex:"sharing",id:"sharing",width:150,ignoreKey:"is_admin"});return this._sharing},getChanges:function(){if(!this.isDirty()){return}var a={};Ext.each(this.getStore().getModifiedRecords(),function(b){var c=b.get("uid");a[c]=a[c]||{};Ext.each(["dtv","renderer","sharing"],function(d){a[c][d]=b.get(d)})});return a}});Ext.define("SYNO.SDS.VideoStation2.Setting.Dialog",{extend:"SYNO.SDS.VideoStation2.Dialog",initActiveTab:0,constructor:function(b){var a={title:_VST("action","settings"),layout:"fit",width:690,height:580,minWidth:400,minHeight:280,items:[this.getTabPanel(b)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)])},getTabPanel:function(a){this._tab_panel=this._tab_panel||new SYNO.SDS.VideoStation2.Setting.TabPanel({activeTab:(a||{}).initActiveTab||this.initActiveTab});return this._tab_panel},onApply:function(){var b=this.getTabPanel();var a=b.getActiveTab();if(b.isActiveTabDirty()&&Ext.isFunction(a.saveChanges)){a.saveChanges({scope:this,fn:this.close})}else{this.close()}},onCancel:function(){this.confirmLostChange({scope:this,fn:this.close})},confirmLostChange:function(b){if(!this.getTabPanel().isActiveTabDirty()){SYNO.SDS.VideoStation2.Util.applyCallback(b);return}var a=function(c){if("yes"===c){SYNO.SDS.VideoStation2.Util.applyCallback(b)}};SYNO.SDS.VideoStation2.SettingController.get().confirm(this.title,_T("common","confirm_lostchange"),a,this)}});Ext.define("SYNO.SDS.VideoStation2.Setting.TabPanel",{extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(a){this.callParent([Ext.apply(this.getConfig(),a)])},getConfig:function(){var a=[];var c=["getLibrarySettingPanel","getPrivilegePanel","getAdvancedSettingPanel"];Ext.each(c,function(e){var d=this[e]();if(Ext.isObject(d)){a.push(d)}},this);var b={activeTab:0,items:a,listeners:{scope:this,beforetabchange:this.onBeforeTabChange}};return b},getLibrarySettingPanel:function(){if(!_S("is_admin")){return null}this._library=this._library||new SYNO.SDS.VideoStation2.Setting.LibraryPanel({});return this._library},getDTVSettingPanel:function(){if(!_S("is_admin")||SYNO.SDS.VideoStation2.Util.hideDTVUI()){return null}this._dtv=this._dtv||new SYNO.SDS.VideoStation2.Setting.DTVPanel({});return this._dtv},getPrivilegePanel:function(){if(!_S("is_admin")){return null}this._privilege=this._privilege||new SYNO.SDS.VideoStation2.Setting.PrivilegePanel({});return this._privilege},getAdvancedSettingPanel:function(){if(!_S("is_admin")){return null}this._advanced=this._advanced||new SYNO.SDS.VideoStation2.Setting.AdvancedPanel({});return this._advanced},onBeforeTabChange:function(b,c,a){if(!this.isActiveTabDirty()){return true}this.ownerCt.confirmLostChange({fn:function(){if(Ext.isFunction(a.rejectChanges)){a.rejectChanges()}b.setActiveTab(c)}});return false},isActiveTabDirty:function(){var a=this.getActiveTab();return Ext.isObject(a)&&Ext.isFunction(a.isDirty)&&a.isDirty()}});Ext.define("SYNO.SDS.VideoStation2.PlayerOption",{extend:"Ext.util.Observable",statics:{EVENT_SUBTITLE_LOAD:"subtitleload"},constructor:function(a){this.callParent(arguments)},loadData:function(){this.loadSubtitle({fn:function(){this.fireEvent(SYNO.SDS.VideoStation2.PlayerOption.EVENT_SUBTITLE_LOAD)},scope:this});this.getAudiotrackStore().load({params:{id:SYNO.SDS.VideoStation2.File.get().getCurrentID()}})},loadSubtitle:function(a){this.getSubtitleStore().load({params:{id:SYNO.SDS.VideoStation2.File.get().getCurrentID()},callback:a.fn,scope:a.scope})},clearData:function(){this.getSubtitleStore().removeAll();this.getAudiotrackStore().removeAll()},getSubtitleStore:function(){this._subtitle=this._subtitle||new SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore();return this._subtitle},getAudiotrackStore:function(){this._audiotrack=this._audiotrack||new SYNO.SDS.VideoStation2.PlayerOption.AudiotrackStore();return this._audiotrack},getSubtitleData:function(){var a=[];this.getSubtitleStore().each(function(b){a.push(SYNO.Util.copy(b.data))});a.sort(function(e,c){var d=(e.embedded?2:0)+(e.display<c.display?0:1)+(e.id==="none"?-100:0);var b=(c.embedded?2:0)+(e.display>c.display?0:1)+(c.id==="none"?-100:0);return d-b});return a},getAudiotrackData:function(){var a=[];this.getAudiotrackStore().each(function(b){a.push(SYNO.Util.copy(b.data))});return a}});Ext.define("SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore",{extend:"SYNO.API.Store",statics:{NO_SUBTITLE_OBJECT:{embedded:false,format:"srt",id:"none",lang:"",title:_T("video_player","no_subtitle")}},constructor:function(b){var a={appWindow:SYNO.SDS.VideoStation2.Window,api:"SYNO.VideoStation.Subtitle",method:"list",version:2,baseParams:{image_based:false},reader:new Ext.data.JsonReader({fields:[{name:"id",type:"string"},"embedded","format","lang","title",{name:"display",type:"string",convert:this.convertDisplay}]}),listeners:{scope:this,load:this.onStoreLoad}};this.callParent([Ext.apply(a,b)])},convertDisplay:function(c,b){var e=b.lang.toLowerCase();if(false===b.embedded){return String.format("{0}{1}",Ext.isEmpty(b.title)?_VST("options","external_subtitle"):b.title,e.length>0?(" - "+e):"")}var d=b.title||e||String.format("Subtitle Track #{0}",b.id);var a=b.format.toLowerCase();if(a!=="srt"){d+=String.format(" ({0})",a)}return d},onStoreLoad:function(b,a){var c=b.reader.readRecords(SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore.NO_SUBTITLE_OBJECT).records[0];if(Ext.isObject(c)){b.insert(0,c)}}});Ext.define("SYNO.SDS.VideoStation2.PlayerOption.AudiotrackStore",{extend:"SYNO.API.Store",constructor:function(b){var a={appWindow:SYNO.SDS.VideoStation2.Window,api:"SYNO.VideoStation.AudioTrack",method:"list",version:1,reader:new Ext.data.JsonReader({root:"trackinfo",fields:["id","channel","codec","language","track",{name:"display",type:"string",convert:this.convertDisplay}]})};this.callParent([Ext.apply(a,b)])},convertDisplay:function(b,a){var c=(a.language.length>0)?(" - "+a.language):"";return String.format("#{0}{1} ({2})",a.track,c,a.codec)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailInfoArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_EXPAND_SUBTITLE:"expandsubtitle",EVENT_EXPAND_AUDIOTRACK:"expandaudiotrack",EVENT_SELECT_SUBTITLE:"selectsubtitle",EVENT_SELECT_AUDIOTRACK:"selectaudiotrack"},constructor:function(b){this._panel=new SYNO.SDS.VideoStation2.ViewDetailPanel({});this.player_option=new SYNO.SDS.VideoStation2.PlayerOption({});this.dropdown_menu=new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,listeners:{scope:this,hide:this.onMenuHide}});var a={cls:"info-area",autoFlexcroll:true,items:[this._panel]};this.callParent([Ext.apply(a,b)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_EXPAND_COLLAPSE);this.relayEvents(this._panel,[SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_EXPAND_COLLAPSE]);this._panel.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.LOAD_PLAYER_OPTION,this.loadPlayerOption,this);this.mon(this,SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_SELECT_SUBTITLE,this.selectSubtitle,this);this.mon(this,SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_SELECT_AUDIOTRACK,this.selectAudiotrack,this);this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_INFO_UPDATE,this.onInfoUpdate,this);this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_EXPAND_SUBTITLE,this.expandSubtitle,this);this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_EXPAND_AUDIOTRACK,this.expandAudiotrack,this);this.mon(this.player_option,SYNO.SDS.VideoStation2.PlayerOption.EVENT_SUBTITLE_LOAD,this.selectFirstSubtitle,this)},onDeactivate:function(){this.getEl().select(".subtitle").each(function(a){a.update(Ext.util.Format.htmlEncode(_T("video_player","no_subtitle")))})},onVideoLoad:function(a){this.loadBackdrop(a)},onInfoUpdate:function(){this.doLayout()},loadBackdrop:function(d){var c=SYNO.SDS.VideoStation2.Video.get().getCurrentType();var a=(c===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)?d.tvshow_backdrop_mtime||"":(d.additional&&d.additional.backdrop_mtime)||"";var b=SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:(c===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)?d.tvshow_mapper_id:d.mapper_id,mtime:a});SYNO.SDS.VideoStation2.Controller.setBackdrop(b)},loadPlayerOption:function(){this.player_option.clearData();this.player_option.loadData()},getMenuOption:function(a,b){return a.map(function(c){return{xtype:"menuitem",scope:this,itemId:c.id.toString(),text:Ext.util.Format.htmlEncode(c.display),handler:function(d){this.fireEvent(b,d.itemId,d.text)}}},this)},getSubtitleOption:function(){return this.getMenuOption(this.player_option.getSubtitleData(),SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_SELECT_SUBTITLE)},getAudiotrackOption:function(){return this.getMenuOption(this.player_option.getAudiotrackData(),SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_SELECT_AUDIOTRACK)},selectFirstSubtitle:function(){var b=this.player_option.getSubtitleData();var a=b[Ext.min([b.length-1,1])];if(Ext.isObject(a)){this.selectSubtitle(a.id.toString(),Ext.util.Format.htmlEncode(a.display))}},selectSubtitle:function(b,a){this.getEl().select(".subtitle").each(function(c){c.update(a)});SYNO.SDS.VideoStation2.PlaybackController.selectSubtitle(b)},selectAudiotrack:function(b,a){this.getEl().select(".audiotrack").each(function(c){c.update(a)});SYNO.SDS.VideoStation2.PlaybackController.selectAudiotrack(parseInt(b,10))},onMenuHide:function(){this.getEl().select(".dropdown-arrow").each(function(a){a.removeClass("expanded")})},expandSubtitle:function(a){this.dropdown_menu.removeAll();this.dropdown_menu.add(this.getSubtitleOption());this.dropdown_menu.showAt([a[0],a[1]+24])},expandAudiotrack:function(a){this.dropdown_menu.removeAll();this.dropdown_menu.add(this.getAudiotrackOption());this.dropdown_menu.showAt([a[0],a[1]+24])},reloadSubtitle:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.player_option.loadSubtitle({fn:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},scope:this})}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailPanel",{extend:"Ext.Panel",statics:{EVENT_SUMMARY_EXPAND_COLLAPSE:"summaryexpandcollapse",EVENT_INFO_UPDATE:"infoupdate",REFERENCE_SOURCE:[{key:"imdb",title:_VST("imdb","title"),url_fn:"getIMDBURL"},{key:"atmovie",title:_VST("video_info","source_atmovies"),url_fn:"getATMovieURL"}]},constructor:function(b){var a={tpl:this.getTpl(),cls:"detail-tpl-panel",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this)},onAfterRender:function(){this.mon(this.getEl(),"click",this.onPanelClick,this)},onVideoLoad:function(a){this.update(a);this.applyViewMoreButtonAction();this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_INFO_UPDATE)},onPanelClick:function(c,d,a){var b=Ext.fly(d);if(b.hasClass("filter")){this.onFilterItemClick(d)}else{if(b.hasClass("reference")){this.onReferenceItemClick(b)}else{if(b.hasClass("subtitle")){b.addClass("expanded");this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_EXPAND_SUBTITLE,b.getXY())}else{if(b.hasClass("audiotrack")){b.addClass("expanded");this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailInfoArea.EVENT_EXPAND_AUDIOTRACK,b.getXY())}}}}},onFilterItemClick:function(c){var a=Ext.fly(c).getAttribute("data-filter");var b=Ext.util.Format.htmlDecode(c.innerHTML);SYNO.SDS.VideoStation2.Controller.setFilter(a,{key:b,value:b})},onReferenceItemClick:function(a){window.open(a.getAttribute("url"))},applyViewMoreButtonAction:function(){var b=this.getEl();if(!b){return}var d=b.select(".view-btn").elements[0];var c=b.select(".summary").elements[0];if(!d||!c){return}if(Ext.fly(c).getHeight()<=72){Ext.fly(d).addClass("hide");return}var a=this;Ext.fly(d).on({click:function(j,k){var i=a.getEl();var h=Ext.fly(k);var l=h.hasClass("all");h.removeClass(l?"all":"less");h.addClass(l?"less":"all");h.update(Ext.util.Format.htmlEncode(l?_VST("action","view_less"):_VST("action","view_all")));h=null;var f=l?Ext.fly(i.select(".summary").elements[0]).getHeight():72;var g=Ext.fly(i.select(".summary-wrapper").elements[0]);g.setStyle("max-height",String.format("{0}px",f));g=null;a.fireEvent.defer(400,a,[SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_EXPAND_COLLAPSE])}})},getAudioDiv:function(c){var b='<td><div class="audio {0}">{1}</div></td>';var d=c.audio_codec.toLowerCase();var a="",e="";if(d.indexOf("aac")!==-1){a="aac"}else{e=d.toUpperCase()}return String.format(b,a,e)},getAudioChannelText:function(a){var b=parseInt(a.channel,10)||0;switch(b){case 1:return"MONO";case 2:return"STEREO";case 6:return"5.1";case 8:return"7.1";default:return b.toFixed(1)}},getResolutionText:function(d){var b=d.display_x,e=d.display_y;var c=function(f){var h=(f.x_from==-1||b>f.x_from)&&(f.x_to==-1||b<=f.x_to)&&(f.y_to==-1||e<=f.y_to);var g=(f.y_from==-1||e>f.y_from)&&(f.y_to==-1||e<=f.y_to)&&(f.x_to==-1||b<=f.x_to);return h||g};var a="SD";Ext.iterate(SYNO.SDS.VideoStation2.Constant.RESOLUTION_DEFINITION,function(g,h,f){if(c(h)){a=g;return false}});return a},getRatingTpl:function(a){if(!Ext.isNumber(a.rating)||a.rating<0){return""}var b='<td ext:qtip="{0}"><div class="rating base">{1}</div></td>';var d=a.rating.toString();var c=Ext.util.Format.round(a.rating,0);return[0,1,2,3,4].map(function(f){var g=c-f*2;var e;if(g<1){e=""}else{if(g===1){e='<div class="rating half"></div>'}else{if(g>=2){e='<div class="rating"></div>'}}}return String.format(b,d,e)}).join("")},getDateRatingAndCodecTpl:function(a){SYNO.Assert(Ext.isObject(a.default_file),"file not exist");var b=a.original_available||a.record_date;var e=['<table cellspacing="0"><tbody><tr>',String.format('<td><div class="year">{0}</div></td>',(b==="0"?_VST("metadata","unknown"):b)),this.getRatingTpl(a),"</tr></tbody></table>"].join("");var d=a.default_file;var c=['<table cellspacing="0"><tbody><tr>',String.format('<td><div class="resolution">{0}</div></td>',this.getResolutionText(d)),this.getAudioDiv(d),String.format('<td><div class="audio-channel">{0}</div></td>',this.getAudioChannelText(d)),"</tr></tbody></table>"].join("");return['<div class="info-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',e,"</td>",'<td align="right">',c,"</td>","</tr></tbody></table></div>"].join("")},getSeasonEpisodeTpl:function(a){return["season","episode"].map(function(b){var c=a[b];if(!Ext.isNumber(c)||c<=0){return""}return String.format('<div class="info">{0}: <div class="item">{1}</div></div>',Ext.util.Format.htmlEncode(_VST(b,b+"_title")),c)}).join("")},genAdditionalValueTpl:function(b){var c=_VST(b,"title");var a=['<tpl if="this.hasValue(values.additional.{0})">','<div class="info tag">',c,": ",'<tpl for="values.additional.{0}">','<tpl if="xindex &gt; 1">, </tpl><div class="item filter" data-filter="',b,'">{.:htmlEncode}</div>',"</tpl>","</div>","</tpl>"].join("");return String.format(a,b)},getDurationTpl:function(a){SYNO.Assert(Ext.isObject(a.default_file),"file not exist");return['<div class="info">',Ext.util.Format.htmlEncode(_VST("duration","title")+": "),'<div class="item">',Ext.util.Format.htmlEncode(a.default_file.duration),"</div>","</div>"].join("")},getTitleAndCertificateTpl:function(a){var b=String.format('<div class="title">{0}</div>',Ext.util.Format.htmlEncode(a.title));if(Ext.isEmpty(a.certificate)){return b}return['<div class="title-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',b,"</td>",'<td align="right" class="certificate-wrapper">',String.format('<div class="certificate">{0}</div>',Ext.util.Format.htmlEncode(a.certificate)),"</td>","</tr></tbody></table></div>"].join("")},getReferenceTpl:function(){return['<tpl if="this.hasValue(values.reference)">','<div class="info tag">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("imdb","reference"))),'<tpl for="values.reference">','<tpl if="xindex &gt; 1">, </tpl><div class="item reference" url="{url:htmlEncode}">{title:htmlEncode}</div>',"</tpl>","</div>","</tpl>"].join("")},getSubtitleTpl:function(){return['<div class="info">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("options","subtitle"))),String.format('<div class="dropdown-arrow subtitle">{0}</div>',Ext.util.Format.htmlEncode(_T("video_player","no_subtitle"))),"</div>"].join("")},getAudiotrackTpl:function(){return['<div class="info">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("options","audio_track"))),String.format('<div class="dropdown-arrow audiotrack">{0}</div>',Ext.util.Format.htmlEncode(_VST("offline_conversion","default_audio_track"))),"</div>"].join("")},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">',"{[this.getTitleAndCertificate(values)]}",'<tpl if="this.hasTagline(values)"><div class="tagline">{values.tagline:htmlEncode}</div></tpl>',"{[this.getDateRatingAndCodec(values)]}",this.genAdditionalValueTpl("genre"),"{[this.getSeasonEpisode(values)]}","{[this.getDuration(values)]}",this.genAdditionalValueTpl("actor"),this.genAdditionalValueTpl("writer"),this.genAdditionalValueTpl("director"),this.getReferenceTpl(),'<tpl if="this.isSingleFile(values)">',"{[this.getSubtitle()]}","{[this.getAudiotrack()]}","</tpl>",'<tpl if="this.hasValue(values.additional && values.additional.summary)">',String.format('<div class="summary-title">{0}</div>',Ext.util.Format.htmlEncode(_VST("summary","title"))),'<div class="summary-wrapper">','<div class="summary">{values.additional.summary:htmlEncode}</div>',"</div>",'<div class="info-separator"></div>','<div class="view-btn all">{[_VST("action", "view_all")]}</div>',"</tpl>","</tpl>",'<div class="x-clear"></div>',{hasTagline:function(b){return !Ext.isEmpty(b.tagline)},hasValue:function(b){return !Ext.isEmpty(b)},isSingleFile:function(b){return Ext.isObject(b)&&Ext.isObject(b.additional)&&Ext.isArray(b.additional.file)&&b.additional.file.length===1},getTitleAndCertificate:this.getTitleAndCertificateTpl.createDelegate(this),getSeasonEpisode:this.getSeasonEpisodeTpl.createDelegate(this),getDuration:this.getDurationTpl.createDelegate(this),getDateRatingAndCodec:this.getDateRatingAndCodecTpl.createDelegate(this),getSubtitle:this.getSubtitleTpl.createDelegate(this),getAudiotrack:this.getAudiotrackTpl.createDelegate(this)});return a}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailPanel.PlusInfoHandler",{extend:"Ext.util.Observable",constructor:function(a){this.plus_info=a.plus_info||{};this.callParent(arguments)},collect:function(a,b){Ext.iterate(this.plus_info,function(c,d){Ext.iterate(d,function(e,f){if(!a(e)){return}Ext.iterate(f,function(h,g){b(h,g)})})})},collectReference:function(){var c={};var a=[];var b=function(e){return e===SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_REFERENCE};var d=function(f,h){var g=f.toLowerCase();var e=String.format("{0}:{1}",g,h);if(e in c){return}Ext.each(SYNO.SDS.VideoStation2.ViewDetailPanel.REFERENCE_SOURCE,function(i){if(g===i.key){c[e]=true;a.push({title:i.title,url:SYNO.SDS.VideoStation2.ViewDetailPanel.ReferenceHandler[i.url_fn](h)})}})};this.collect(b,d);return Ext.isEmpty(a)?null:a},calculateMaxRating:function(){var c=-1;var a=function(d){return d===SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_RATING};var b=function(e,d){c=Ext.max([c,d])};this.collect(a,b);return c<0?null:c}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailPanel.ReferenceHandler",{singleton:true,IMDB_LANGUAGE_MAP:{enu:"com",ger:"de",spn:"es",fre:"fr",ita:"it"},getIMDBURL:function(b){var a=SYNO.SDS.VideoStation2.ViewDetailPanel.ReferenceHandler.IMDB_LANGUAGE_MAP[_S("lang")]||"com";return String.format("http://www.imdb.{0}/title/{1}",a,b)},getATMovieURL:function(a){return String.format("http://synology.atmovies.com.tw:8088/film/?sid={0}",a)}});Ext.define("SYNO.SDS.VideoStation2.VideoStatusBar",{extend:"Ext.Toolbar",constructor:function(b){this.watched_status=new Ext.Toolbar.TextItem({text:_VST("advanced","unwatched"),cls:"watched-status"});this.video_action=new SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction();var a={cls:"video-status-bar",items:[this.watched_status,"->",this.video_action]};this.callParent([Ext.apply(a,b)]);this.video_action.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this);this.mon(this.video_action,SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction.EVENT_SHARING_UPDATE,this.doLayout,this)},onVideoLoad:function(a){this.updateVideoActionStatus(a);this.updateWatchedStatus(a)},updateVideoActionStatus:function(c){var b=(c.additional&&c.additional.collection)||[];var a=b.map(function(d){return d.id});this.video_action.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,a)},updateWatchedStatus:function(c){var b=c.additional&&c.additional.watched_ratio;var a=SYNO.SDS.VideoStation2.Constant.CLASS.UNWATCHED;this.watched_status[SYNO.SDS.VideoStation2.Util.isUnwatched(b)?"addClass":"removeClass"](a)}});Ext.define("SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction",{extend:"Ext.Container",statics:{EVENT_SHARING_UPDATE:"sharingupdate"},constructor:function(b){this.favorite=new SYNO.SDS.VideoStation2.ActionButton({cls:"favorite",tooltip:_VST("playlist","favorite"),handler:this.togglePlaylistAddRemove.createDelegate(this,[-1])});this.watchlist=new SYNO.SDS.VideoStation2.ActionButton({cls:"watchlist",tooltip:_VST("playlist","watchlist"),handler:this.togglePlaylistAddRemove.createDelegate(this,[-2])});this.playlist=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"playlist",tooltip:_VST("playlist","title"),menuBeforeShow:{fn:this.refreshPlaylistItem,scope:this}});this.sharing=new SYNO.SDS.VideoStation2.ActionButton({cls:"public-sharing",tooltip:_VST("advanced","public_sharing"),hidden:true,scope:this,handler:this.onSharingButtonClick});var a={layout:"hbox",layoutConfig:{type:"hbox",align:"top",pack:"end",defaultMargins:{top:0,right:0,bottom:0,left:8}},cls:"video-action",items:[this.favorite,this.watchlist,this.playlist,this.sharing]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,this.updateSharingStatus,this);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,this.updatePlaylistStatus,this)},updateSharingStatus:function(a){this.sharing.setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing());this.sharing.toggle(a||false);this.fireEvent(SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction.EVENT_SHARING_UPDATE)},updatePlaylistStatus:function(b){this.current_playlists=b||[];var a={favorite:false,watchlist:false,playlist:false};Ext.each(this.current_playlists,function(c){if(c>0){a.playlist=true}else{if(c===-1){a.favorite=true}else{if(c===-2){a.watchlist=true}}}});Ext.iterate(a,function(d,e,c){this[d].toggle(e)},this)},onSharingButtonClick:function(){var a=(function(c){this.updateSharingStatus(c)}).createDelegate(this);var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();SYNO.SDS.VideoStation2.VideoActionController.publicSharing([b],a)},refreshPlaylistItem:function(e){var b=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();var c=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST;var a=this.current_playlists;var d=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:function(f){return(Ext.isArray(a)&&a.indexOf(f.id)!==-1)?"checked":""},disabledFn:function(f){return c&&b===f.id},filterPlaylistFn:function(f){return f.id>0&&f.type===SYNO.SDS.VideoStation2.Constant.PLAYLIST_TYPE.ORIGINAL},createPlaylistFn:this.createPlaylistHandler,clickPlaylistFn:this.playlistItemClickHandler},this);e.removeAll();e.add(d)},createPlaylistHandler:function(){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();var a=(function(c){if(this.current_playlists.indexOf(c.id)===-1){this.current_playlists.push(c.id)}this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,this.current_playlists)}).createDelegate(this);SYNO.SDS.VideoStation2.VideoActionController.createPlaylist([b],a)},playlistItemClickHandler:function(c){var b=parseInt(c.itemId,10);var a=(function(){if(c&&!c.isDestroyed){c.getEl()[(this.current_playlists.indexOf(b)!==-1)?"addClass":"removeClass"]("checked")}}).createDelegate(this);this.togglePlaylistAddRemove(b,a)},togglePlaylistAddRemove:function(e,d){var b=this.current_playlists.indexOf(e)!==-1;var c=(function(){var f=b?this.current_playlists.filter(function(g){return g!==e}):this.current_playlists.concat(e);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,f);if(Ext.isFunction(d)){d()}}).createDelegate(this);var a=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist([a],e,!b,c)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetail",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_PLAY_VIDEO:"playvideo"},constructor:function(b){this.action_area=new SYNO.SDS.VideoStation2.ViewDetailActionArea({region:"west"});this.info_area=new SYNO.SDS.VideoStation2.ViewDetailInfoArea({region:"center"});var a={layout:"border",cls:"view-detail",items:[this.action_area,this.info_area,this.backBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"back",handler:this.onBackBtnClick,scope:this}),this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"next",handler:this.onNextBtnClick,scope:this})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.action_area.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.info_area.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.relayEvents(this.info_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoDetailLoad,this);this.mon(this.action_area,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,this.onVideoDetailLoad,this);this.mon(this.action_area,SYNO.SDS.VideoStation2.ViewDetail.EVENT_PLAY_VIDEO,this.playVideo,this)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadFullData,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this);this.loadFullData()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadFullData,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},onVideoDetailLoad:function(){this.detailLoadCount=this.detailLoadCount+1;if(this.detailLoadCount===2){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.info_area.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.LOAD_PLAYER_OPTION)}},onBackBtnClick:function(){if(!this.prevVideo){return}SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.prevVideo)},onNextBtnClick:function(){if(!this.nextVideo){return}SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.nextVideo)},loadFullData:function(){this.prevVideo=SYNO.SDS.VideoStation2.Video.get().getPrevFromVideolist();this.nextVideo=SYNO.SDS.VideoStation2.Video.get().getNextFromVideolist();this.backBtn.setDisabled(!this.prevVideo);this.nextBtn.setDisabled(!this.nextVideo);this.detailLoadCount=0;this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.action_area.fireEvent(SYNO.SDS.VideoStation2.ViewDetailActionArea.EVENT_LOAD_SHARING);SYNO.SDS.VideoStation2.PlaybackController.loadPlayer();this.loadVideoData(true)},refreshInfo:function(a){this[a===SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO?"loadVideoOnly":"loadSubtitleOnly"]()},loadVideoOnly:function(){this.loadVideoData(false)},loadSubtitleOnly:function(){if(SYNO.SDS.VideoStation2.File.get().hasMultipleFile()){return}this.info_area.reloadSubtitle()},playVideo:function(){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING);SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:SYNO.SDS.VideoStation2.File.get().getCurrentID(),video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),subtitle_id:SYNO.SDS.VideoStation2.File.get().getSubtitle(),audiotrack_id:SYNO.SDS.VideoStation2.File.get().getAudiotrack()},{fn:SYNO.SDS.VideoStation2.Controller.refreshViewInfo,args:[SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO]})},loadVideoData:function(a){var b=SYNO.SDS.VideoStation2.Video.get().getCurrentType();var c={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),additional:Ext.encode(SYNO.SDS.VideoStation2.Constant.GETINFO_ADDITIONAL)};var d={success:function(j,i,f){var h=j[SYNO.SDS.VideoStation2.Util.getVideoRoot(b)][0];this.processVideoData(h);if(a){SYNO.SDS.VideoStation2.Controller.loadFile(h.additional.file);var g=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();SYNO.SDS.VideoStation2.Controller.switchFile((g!==null)?g:h.default_file.id)}var e=a?this:this.action_area;e.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,h)},failure:function(){this.detailLoadCount=2;this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.goback()},scope:this};SYNO.SDS.VideoStation2.OP.get().getInfo(c,d,b)},processVideoData:function(b){if(b.additional&&b.additional.collection){b.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(b.additional.collection)}var d={};try{d=Ext.decode((b.additional&&b.additional.extra))}catch(c){}var a=new SYNO.SDS.VideoStation2.ViewDetailPanel.PlusInfoHandler({plus_info:d});b.rating=a.calculateMaxRating();b.reference=a.collectReference();this.chooseDefaultFile(b)},chooseDefaultFile:function(b){var a=function(c){return(c||"0").split(":").reduce(function(d,e){return d*60+parseFloat(e)},0)};b.default_file=Ext.max(b.additional.file,function(d,c){return a(d.duration)>a(c.duration)?1:-1})}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailActionArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_LOAD_SHARING:"loadsharing"},constructor:function(b){this.image=new SYNO.SDS.VideoStation2.ViewDetailImage({region:"north"});this.video_status_bar=new SYNO.SDS.VideoStation2.VideoStatusBar({region:"center"});var a={layout:"border",cls:"action-area",items:[this.image,this.video_status_bar]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.ViewDetailActionArea.EVENT_LOAD_SHARING,this.loadSharing,this);this.relayEvents(this.image,[SYNO.SDS.VideoStation2.ViewDetail.EVENT_PLAY_VIDEO]);this.image.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]);this.video_status_bar.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD])},loadSharing:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,false);return}var a={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),need_url:false};var b={success:function(e,d,c){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,(e.enable)?true:false)},scope:this};SYNO.SDS.VideoStation2.OP.get().getPublicSharing(a,b)}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailImage",{extend:"Ext.Container",constructor:function(b){var a={cls:"image",overCls:"over",items:[new Ext.Container({cls:"border"}),new SYNO.SDS.VideoStation2.ActionButton({cls:"play",tooltip:_VST("action","play"),scope:this,handler:this.onPlayButtonClick}),this.getProgress(),this.getFileIndicator()]};this.callParent([Ext.apply(a,b)]);this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.loadImage,this)},getFileIndicator:function(){this._file_indicator=this._file_indicator||new SYNO.SDS.VideoStation2.ViewDetailActionArea.FileIndicator({});return this._file_indicator},getProgress:function(){this._progress=this._progress||new Ext.Container({tpl:new Ext.XTemplate('<tpl for=".">',"{[SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(values)]}","</tpl>")});return this._progress},chooseFileToPlay:function(){var b=(function(c){SYNO.SDS.VideoStation2.Controller.switchFile(c.id);this.playVideo()}).createDelegate(this);var a={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType()};SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(a,b)},playVideo:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewDetail.EVENT_PLAY_VIDEO)},onPlayButtonClick:function(){this[SYNO.SDS.VideoStation2.File.get().hasMultipleFile()?"chooseFileToPlay":"playVideo"]()},loadImage:function(b){this.getProgress().update(b);var a=SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),id:b.id,mtime:(b.additional&&b.additional.poster_mtime)||""});this.getEl().setStyle("background-image",String.format("url({0})",a))}});Ext.define("SYNO.SDS.VideoStation2.ViewDetailActionArea.FileIndicator",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(b){var a={cls:"file-indicator",hidden:true,menu:new SYNO.SDS.VideoStation2.DropdownMenu({cls:"file-list",noicon:true,listeners:{scope:this,beforeshow:this.refreshFileItem}})};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.File.get(),SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD,this.onFileLoaded,this)},onFileLoaded:function(){this.files=SYNO.SDS.VideoStation2.File.get().getAllFiles()||[];var a=this.files.length>99?"99+":this.files.length.toString();this.setText(a);this.setVisible(this.files.length>1)},refreshFileItem:function(b){b.removeAll();var a=this.files.map(function(c){return new Ext.menu.Item({text:Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.extractFileName(c.sharepath))})},this);b.add(a)}});Ext.define("SYNO.SDS.VideoStation2.ViewHomePage",{statics:{EVENT_SLIDINGVIEW_SHOW:"slidingviewshow"},extend:"SYNO.ux.Panel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewHomePage.EVENT_SLIDINGVIEW_SHOW);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.createPreLoadStore,this)},fillConfig:function(a){var b={cls:"view-home-page",autoFlexcroll:true,layout:"anchor",items:[],listeners:{scope:this,add:this.checkPreLoadStoreFinish,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadView,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadView,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadAllLibrary,this);this.loadView()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadView,this);this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadView,this);this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadAllLibrary,this);this.items.each(function(a){a.onDeactivate()},this)},loadView:function(){this.removeAll(true);this.notCreateCount=0;this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this);Ext.each(this.stores_,function(a){var b=SYNO.SDS.VideoStation2.Category.get().getSortOption();Ext.apply(b,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());a.load({params:b})},this)},loadAllLibrary:function(){this.items.each(function(a){a.onActivate()},this)},createPreLoadStore:function(){if(this.stores_&&Ext.isArray(this.stores_)){Ext.each(this.stores_,function(a){a.destroy()},this)}this.stores_=[];SYNO.SDS.VideoStation2.Library.get().getLibraryStore().each(function(a){if(a.get("type")===SYNO.SDS.VideoStation2.Constant.PLAYLIST){return true}var b=new SYNO.SDS.VideoStation2.Stores[a.get("type")]({libraryData:Ext.copyTo({},a.data,["type","id","title"]),baseParams:{library_id:a.get("id"),limit:1},listeners:{scope:this,load:this.onAfterLoadStoreFn,exception:function(){this.notCreateCount=this.notCreateCount+1;this.checkPreLoadStoreFinish()}}});this.stores_.push(b)},this)},checkPreLoadStoreFinish:function(){if((this.items.getCount()+this.notCreateCount)<this.stores_.length){return}if(this.hidden){return}this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);if(this.items.getCount()===0){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)}this.doLayout();this.loadAllLibrary()},getSortTime:function(a){if(!Ext.isDefined(a)){return 0}var b=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();switch(b){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:return a.get("create_time")||0;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:return a.get("last_watched")||0;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:var c=a.get("original_available")||a.get("record_date")||0;return Date.parse(c)/1000;default:return 0}return 0},onAfterLoadStoreFn:function(c,b){if(0===c.getTotalCount()){this.notCreateCount=this.notCreateCount+1;this.checkPreLoadStoreFinish();return}var a=new SYNO.SDS.VideoStation2.HomePageSlidingView({sortTime:this.getSortTime(b[0]),libraryData:c.libraryData,listeners:{show:{buffer:100,scope:this,fn:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewHomePage.EVENT_SLIDINGVIEW_SHOW)}}}});if(0===a.sortTime){this.add(a)}else{var d=this.items.length;this.items.each(function(f,e){if(a.sortTime>f.sortTime){d=e;return false}},this);this.insert(d,a)}}});Ext.define("SYNO.SDS.VideoStation2.HomePageSlidingView",{statics:{EVENT_CURSOR_CHANGE:"cursorchange",DATA_VIEW_PADDING_TOP:4},extend:"SYNO.ux.Panel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.mon(this,SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_CURSOR_CHANGE,this.updatePagingBar,this)},fillConfig:function(a){this.libraryType=a.libraryData.type;this.libraryId=a.libraryData.id;this.imageStyle=(this.libraryType===SYNO.SDS.VideoStation2.Constant.MOVIE||this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW)?"poster":"landscape";this.slideview=new SYNO.SDS.VideoStation2.SlidableDataView({getView:this.getDataView.createDelegate(this),height:(this.imageStyle==="poster"?238:176)+SYNO.SDS.VideoStation2.HomePageSlidingView.DATA_VIEW_PADDING_TOP,dataViewMargin:0});var b={cls:String.format("{0} {1}","sliding-view",this.imageStyle),tbar:[{xtype:"tbspacer",width:2},{xtype:"box",cls:String.format("{0} {1}","library-icon",this.libraryId===0?this.libraryType:"library")},{xtype:"tbspacer",width:6},{xtype:"box",cls:"library-title",html:Ext.util.Format.htmlEncode(a.libraryData.title)},"->",this.prevBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"prev-button",scope:this,handler:this.intoPrevPage}),{xtype:"tbspacer",width:16},this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"next-button",scope:this,handler:this.intoNextPage})],items:[this.slideview]};Ext.apply(b,a);return b},onActivate:function(){this.mon(this,"resize",this.onResizeEvent,this);this.loadView()},onDeactivate:function(){this.mun(this,"resize",this.onResizeEvent,this)},loadView:function(){this.hideMode="visibility";this.hide();this.updatePageSize();this.total=0;this.setCursor(0);this.onResetStore();this.slideview.onActivate()},onResizeEvent:function(){this.updatePageSize();this.slideview.onActivate()},updatePageSize:function(){var a=this.imageStyle==="poster"?120:180,c=this.imageStyle==="poster"?20:17,b=a+c;this.pageSize=Math.floor(this.getInnerWidth()/b)},onResetStore:function(){var a=[this.slideview.getLeftView(),this.slideview.getCenterView(),this.slideview.getRightView()];Ext.each(a,function(b){var c=b.dataView.getStore();c.setBaseParam("offset",0);c.lastParams=null},this)},prepareFn:function(a,c){var b=a.dataView.getStore();if(b.baseParams&&b.baseParams.offset===c){return}b.setBaseParam("offset",c);a.fireEvent("activate")},prepareView:function(){var a=this.cursor-this.pageSize;if(a>=0){this.prepareFn(this.slideview.getLeftView(),a)}a=this.cursor+this.pageSize;if(a<=this.total){this.prepareFn(this.slideview.getRightView(),a)}},intoPrevPage:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.setCursor(Math.max(this.cursor-this.pageSize,0));this.slideview.prepareView(a.left,true);this.slideview.intoLeft(true);this.prepareView()},intoNextPage:function(){var a=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.setCursor(Math.min(this.cursor+this.pageSize,this.total));this.slideview.prepareView(a.right,true);this.slideview.intoRight(true);this.prepareView()},getDataView:function(b){var c=this;var a={decoratorConfig:{thumbCls:c.imageStyle},getStore:function(){this._store=this._store||new SYNO.SDS.VideoStation2.Stores[c.libraryType]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore}});return this._store},onBeforeLoadStore:function(d,e){var f=e.params;Ext.apply(f,SYNO.SDS.VideoStation2.Category.get().getSortOption());Ext.apply(f,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption());Ext.apply(f,{library_id:c.libraryId,limit:c.pageSize});Ext.applyIf(f,d.baseParams);if(Ext.isDefined(d.lastParams)&&SYNO.ux.Utils.checkObjectConsistency(d.lastParams,f)){return false}d.lastParams=f},onAfterLoadStore:function(d){c.total=d.getTotalCount();if(0===c.total){c.hideMode="display";c.hide();return}c.show();c.updatePagingBar();c.prepareView()},getImageURL:function(d){return SYNO.SDS.VideoStation2.Util.getImageURL({type:c.libraryType,id:d.id,mtime:d.additional?d.additional.poster_mtime||"":""})},getLibraryID:function(){return c.libraryId},startVideoAction:function(d){this.clearVideoSelection();this.addVideoSelection(d);var e=SYNO.SDS.VideoStation2.Library.get().getLibraryByIDAndType(c.libraryId,c.libraryType);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(e.opid)},listeners:{scope:c,click:this.onViewItemClick}};return new SYNO.SDS.VideoStation2.HomePageWrapperDataView(Ext.apply(b,{childCfg:{decorator:a,disableAction:(this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW),videoType:this.libraryType}}))},onViewItemClick:function(b,c,d,f){var h=String.format("{0}-{1}",this.libraryType,this.libraryId);var a=b.getRecord(d);var g=b.getStore().data.items.map(function(e){return this.getVideoData(e)},b);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(h);switch(this.libraryType){case SYNO.SDS.VideoStation2.Constant.TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow(a.data);break;default:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),g);break}},setCursor:function(a){SYNO.Assert(Ext.isNumber(a)&&a>=0,String.format("unexpceted cursor {0}",a));this.cursor=a;this.fireEvent(SYNO.SDS.VideoStation2.HomePageSlidingView.EVENT_CURSOR_CHANGE)},updatePagingBar:function(){var b=Math.ceil((this.cursor+this.pageSize)/this.pageSize),a=this.total<this.pageSize?1:Math.ceil(this.total/this.pageSize);if(1===a){this.prevBtn.hide();this.nextBtn.hide()}else{this.prevBtn.show();this.nextBtn.show()}this.prevBtn.setDisabled(b===1);this.nextBtn.setDisabled(b===a)},show:function(){var a=this.getVisibilityEl();if(a){a.removeClass(["x-hide-display","x-hide-visibility"])}this.callParent(arguments)},hide:function(){var a=this.getVisibilityEl();if(a){a.removeClass(["x-hide-display","x-hide-visibility"])}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation2.HomePageWrapperDataView",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.dataView=new SYNO.SDS.VideoStation2.ThumbDataView(a.childCfg);var b={layout:"fit",items:[this.dataView]};delete a.childCfg;Ext.apply(b,a);return b},onActivate:function(){this.dataView.getStore().load()}});Ext.define("SYNO.SDS.VideoStation2.ViewPlaylist",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.dataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Playlist",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}});var a={cls:"view-playlist",layout:"fit",items:[this.dataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists();this.callParent(arguments)},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);this.callParent(arguments)},onPlaylistLoaded:function(){this.dataview.getDataviewStore().loadData(SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists());this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onViewItemClick:function(b,c,d,f){var a=b.getRecord(d);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PLAYLIST,a.get("id"),a.get("playlist_title"))}});Ext.define("SYNO.SDS.VideoStation2.ViewPoster",{extend:"SYNO.ux.Panel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.items.each(function(b){this.relayEvents(b,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO])},this)},fillConfig:function(a){this.dataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Common",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}});this.folderDataView=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Byfolder",listeners:{scope:this,click:this.onFolderViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}});this.playlistPosterDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"PlaylistPoster",listeners:{scope:this,click:this.onPlaylistViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}},{cls:"plist-list-poster"});var b={layout:"card",cls:"view-poster-panel",items:[this.dataview,this.folderDataView,this.playlistPosterDataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onViewItemClick:function(b,c,d,f){var a=b.getRecord(d);var g=b.getStore().data.items.map(function(e){return this.getVideoData(e)},b);switch(SYNO.SDS.VideoStation2.Library.get().getCurrentType()){case SYNO.SDS.VideoStation2.Constant.TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow(a.data);break;default:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),g);break}},onPlaylistViewItemClick:function(b,c,d,f){var a=b.getRecord(d);var g=b.getStore().data.items.map(function(e){return this.getVideoData(e)},b);SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),g)},onFolderViewItemClick:function(b,c,f,g){var a=b.getRecord(f);if(a.get("type")===SYNO.SDS.VideoStation2.Constant.FOLDER){SYNO.SDS.VideoStation2.Controller.intoPosterView("folder",a.get("id"),a.get("title"));return}var d=(a.get("additional")||{}).metadata;if(!d){return}var h=b.getStore().data.items.map(function(i){if("file"!==i.get("type")){return}var e=(i.get("additional")||{}).metadata;if(!e){return}return this.getVideoData(i)},b).filter(function(e){return Ext.isObject(e)});SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),h)},onCategoryChange:function(a,b){if(b===SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER&&this.layout.activeItem===this.folderDataView){SYNO.SDS.VideoStation2.Controller.refreshView();return}if(SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER===a||SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER===b){this.activateCurrentDataView();return}this.onSortChanged()},onSortChanged:function(){if(this.dataview===this.layout.activeItem){this.dataview.resetPaging()}},onFilterChange:function(){if(this.dataview===this.layout.activeItem){this.dataview.resetPaging()}},activateCurrentDataView:function(){var a;if(SYNO.SDS.VideoStation2.Constant.PLAYLIST===SYNO.SDS.VideoStation2.Library.get().getCurrentType()){a=this.playlistPosterDataview}else{if(SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER===SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()){a=this.folderDataView}else{a=this.dataview}}var b=this.layout.activeItem;SYNO.Assert(a,String.format("unexpceted dataView in view_poster"));if(b!==a){this.layout.setActiveItem(a)}else{if(b){b.fireEvent("activate")}}},clearActiveItem:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this);this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onSortChanged,this);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.activateCurrentDataView();if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW){this.dataview.items.each(function(a){a.enableSelectMode=false;a.hideAction()})}else{this.dataview.items.each(function(a){a.enableSelectMode=true;a.showAction()})}},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this);this.mun(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onSortChanged,this);this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.clearActiveItem()}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.detail_area=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea();this.season_area=new SYNO.SDS.VideoStation2.ViewTVShow.SeasonArea({region:"center"});var a={cls:"view-tvshow",layout:"border",items:[this.detail_area,this.season_area],listeners:{scope:this,resize:this.adjustAreaSize,afterlayout:this.onAfterLayout}};this.callParent([Ext.apply(a,b)]);this.relayEvents(this.season_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED]);this.mon(this.detail_area,"afterrender",this.onDetailAreaAfterRender,this);this.mon(this.season_area,"flexcroll",this.onDataviewScrolled,this);this.mon(this.detail_area.season_bar,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar.EVENT_SEASON_CLICK,this.onSeasonClick,this)},adjustAreaSize:function(b,c,a){c=this.getInnerWidth();if(c>26){c=c-26}this.detail_area.setWidth(c);this.season_area.getAllDataViews().each(function(d){d.getEl().setStyle("padding-top",this.detail_area.getHeight()+"px")},this)},onAfterLayout:function(a){var b=a.getEl().query(".flexcrollactive")[0];this.adjustDetailAreaAlign(b)},onDataviewScrolled:function(a){var b=a.getEl().dom;this.adjustDetailAreaAlign(b,true)},adjustDetailAreaAlign:function(e,b){if(!e||!e.fleXdata){return}if(false===e.fleXdata.scrollPosition[1][0]&&!b){return}var d=this.getEl();if(!d){return}var c=e.fleXdata.scrollPosition[1][0]||0;var g=Ext.max([0,this.detail_area.getHeight()-this.detail_area.getBottomScrollMargin()]);var f=(c>g);this.detail_area[(f)?"addClass":"removeClass"]("block-background");var a=(f)?g:c;this.detail_area.getEl().alignTo(d,"tl-tl",[d.getPadding("l"),d.getPadding("t")-a])},onDetailAreaMouseWheel:function(a){this.season_area.updateDataviewScroll(a)},onDetailAreaAfterRender:function(){this.mon(this.detail_area.getEl(),"mousewheel",this.onDetailAreaMouseWheel,this)},onSeasonClick:function(b){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.season_area.prepareSeason(a,b)},onActivate:function(){this.adjustAreaSize();this.loadBackdrop();this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},loadBackdrop:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();var b=SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:a.mapper_id,mtime:(a.additional&&a.additional.backdrop_mtime)||""});SYNO.SDS.VideoStation2.Controller.setBackdrop(b)},refreshInfo:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);SYNO.SDS.VideoStation2.OP.get().getInfo({id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID(),additional:Ext.encode(["poster_mtime","summary"])},{scope:this,success:this.onInfoLoad,failure:this.onInfoLoadFail},SYNO.SDS.VideoStation2.Constant.TVSHOW)},onInfoLoad:function(c,b,a){SYNO.SDS.VideoStation2.TVShow.get().updateTVShow(c.tvshows[0]);SYNO.SDS.VideoStation2.Controller.updatePath();this.loadBackdrop();this.detail_area.reloadInfo();this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onInfoLoadFail:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.Controller.goback()}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.image=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Image({region:"west"});this.info_area=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.InfoArea({region:"center"});this.season_bar=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar({region:"south"});var a={cls:"detail-area",floating:true,shadow:false,layout:"border",height:480,items:[this.image,this.info_area,this.season_bar]};this.callParent([Ext.apply(a,b)])},getBottomScrollMargin:function(){if(!this.season_bar.getEl()){return 0}var a=parseInt(this.season_bar.getEl().getMargins("b"),10);return this.season_bar.getHeight()+a},onActivate:function(){this.image.loadImage();this.season_bar.loadSeasons()},reloadInfo:function(){this.image.loadImage();this.info_area.loadSummary()}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Image",{extend:"Ext.Container",constructor:function(b){var a={cls:"image",margins:"0 30 0 0"};this.callParent([Ext.apply(a,b)])},loadImage:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();var b=SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Constant.TVSHOW,id:a.id,mtime:(a.additional&&a.additional.poster_mtime)||""});this.getEl().setStyle("background-image",String.format("url({0})",b))}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.InfoArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){this.dataview=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Dataview();var a={cls:"info-area",autoFlexcroll:true,height:50,items:[this.dataview]};this.callParent([Ext.apply(a,b)])},loadSummary:function(){this.dataview.loadSummary()}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Dataview",{extend:"Ext.DataView",constructor:function(b){var a={tpl:this.getTpl(),cls:"tvshow-dataview",store:this.getStore(),singleSelect:true,listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(a,b)])},onActivate:function(){this.bindStore(this.getStore());this.loadSummary()},onDeactivate:function(){this.bindStore(null)},loadSummary:function(){this.getStore().loadData([SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow()])},getStore:function(){this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","title","mapper_id","metadata_locked","original_available","sort_title","additional"]});return this.store},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="title">{values.title:htmlEncode}</div>','<div class="info tag">{[_VST("original_available", "title")]}: {values.original_available:htmlEncode}</div>',String.format('<div class="summary-title">{0}</div>',Ext.util.Format.htmlEncode(_VST("summary","title"))),'<div class="summary">{values.additional.summary:htmlEncode}</div>',"</tpl>",'<div class="x-clear"></div>');return a}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar",{statics:{EVENT_SEASON_CLICK:"seasonclick"},extend:"Ext.Container",constructor:function(b){this.season_list=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList();this.season_action=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction({region:"east"});var a={cls:"season-bar",layout:"border",margins:"20 0 10 0",listeners:{scope:this,afterlayout:this.fixSelectPosition},items:[{xtype:"tbtext",text:"Season",cls:"season-label",region:"west",margins:"0 6 0 18"},{xtype:"container",cls:"season-viewport",region:"center",items:[this.season_list]},this.season_action]};this.callParent([Ext.apply(a,b)]);this.mon(this.season_action,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,this.onScrollBtnClick,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED,this.loadSeasons,this);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this)},loadSeasons:function(){var e=this.season_list.getEl();var d=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SELECTOR_WIDTH;var c=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SEASON_MARGIN;if(e){e.setLeft(-d)}this.season_list.removeAll();var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(!a){return}this.season_select=new SYNO.SDS.VideoStation2.ActionButton({cls:"season-select",x:d+c/2,floating:true});this.season_list.add(this.season_select);a.each(function(f){this.season_list.add(new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item",text:f||"?",itemId:f.toString(),margins:"10 16 10 16",enableToggle:true,toggleGroup:"season-item",handler:this.onSeasonClick,scope:this}))},this);this.season_list.doLayout();var b=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();if(Ext.isNumber(b)){this.scrollToButton(b,true);this.moveSelectToButton(b)}else{this.scrollToButton(a[0])}},moveSelectToButton:function(a){if(!Ext.isNumber(a)){return}var b=this.season_list.getComponent(a.toString());if(!b){return}b.toggle(true);var c=b.getEl().getOffsetsTo(this.season_list.getEl());var d=this.season_select.getEl();d.setLeftTop.apply(d,c)},scrollToButton:function(f,a){if(!Ext.isNumber(f)){return}if(a){var i=this.getMaxVisibleSeasonCount();var d=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(i>=d.length){f=d[0]}else{var j=Math.floor(d.indexOf(f)-i/2);f=d[j>=0?j:0]}}var e=this.season_list.getComponent(f.toString());var g=this.season_list.getEl();var h=e.getEl();var c=h.getOffsetsTo(g)[0];var b=e.margins.left;g.setLeft(-(c-b));this.currentScroll=f;this.season_action.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED,this.currentScroll)},fixSelectPosition:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.moveSelectToButton(a)},getMaxVisibleSeasonCount:function(){var c=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SELECTOR_WIDTH;var b=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SEASON_MARGIN;var a=this.season_list.ownerCt.getWidth();return Math.floor(a/(c+b))},onSeasonChanged:function(){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.moveSelectToButton(a)},onSeasonClick:function(a){a.toggle(false);var b=parseInt(a.itemId,10);if(SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason()!==b){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar.EVENT_SEASON_CLICK,parseInt(a.itemId,10))}else{a.toggle(true)}},onScrollBtnClick:function(c){var b=this.currentScroll+c;var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(-1===a.indexOf(b)||b===this.currentScroll){return}this.scrollToButton(b)}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList",{statics:{SELECTOR_WIDTH:28,SEASON_MARGIN:32},extend:"Ext.Container",constructor:function(b){var a={layout:"hbox",cls:"season-list",layoutConfig:{align:"top"},items:[]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction",{statics:{EVENT_SCROLL_BTN_CLICK:"scrollbtnclick",EVENT_SCROLL_CHANGED:"scrollchanged"},extend:"Ext.Container",constructor:function(b){var a={layout:"hbox",margins:"0 4 0 0",layoutConfig:{align:"top"},cls:"season-action",width:2*(24+7),items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item back",margins:"10 7 10 0",handler:this.scrollLeft,scope:this}),new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item next",margins:"10 0 10 7",handler:this.scrollRight,scope:this})]};this.callParent([Ext.apply(a,b)]);this.addEvents(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK);this.addEvents(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED);this.mon(this,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED,this.onScrollChange,this)},scrollLeft:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,-1)},scrollRight:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,1)},onScrollChange:function(a){var b=SYNO.SDS.VideoStation2.TVShow.get().getTotalSeasons();this.items.items[0].setDisabled(a===1);this.items.items[1].setDisabled(a===b)}});Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.SeasonArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(a){this.callParent([this.fillConfig(a)]);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);this.relayEvents(this.slideview,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED])},fillConfig:function(a){this.slideview=new SYNO.SDS.VideoStation2.SlidableDataView({getView:this.getSwitchableView.createDelegate(this),dataViewMargin:20});var b={layout:"fit",cls:"view-tvshow-panel",items:[this.slideview]};Ext.apply(b,a);return b},updateDataviewScroll:function(c){var a=this.slideview.getCenterView().getActiveView();var b=null;if(!a||!(b=a.getEl())){return}var d=b.hasClass("flexcrollactive")?b.dom:b.query(".flexcrollactive")[0];if(!d){return}d.fleXcroll.scrollContent(0,c.getWheelDelta()*-120)},onViewItemClick:function(b,c,d,f){var a=b.getRecord(d);var g=b.getStore().data.items.map(function(e){return this.getVideoData(e)},b);SYNO.SDS.VideoStation2.Controller.intoVideoDetail(b.getVideoData(a),g)},onFlexcroll:function(a){if(this.slideview.getCenterView().getActiveView()===a){this.fireEvent("flexcroll",a)}},onSeasonChanged:function(d,f){if(d===null){this.prepareSeason(d,f);return}var b=this.slideview.getCenterView().getActiveView();var e=null;var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();var c=a.indexOf(f);var g=a.indexOf(d);if(c<g){e=this.slideview.getLeftView().getActiveView();this.slideview.getLeftView().filterStore();this.syncScroll(b,e);this.slideview.intoLeft(true)}else{e=this.slideview.getRightView().getActiveView();this.slideview.getRightView().filterStore();this.syncScroll(b,e);this.slideview.intoRight(true)}},onSeasonPrepared:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);SYNO.SDS.VideoStation2.TVShow.get().selectSeason(this.preparingSeason);if(this.preparingStore){this.mun(this.preparingStore,"load",this.onSeasonPrepared,this);this.preparingStore=null}},syncScroll:function(d,c){var b=d.getEl().dom;var a=c.getEl().dom;if(!a.fleXcroll){return}a.fleXcroll.setScrollPos(0,b.fleXdata.scrollPosition[1][0]||0,false)},prepareSeason:function(d,f){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);if(this.preparingStore){this.mun(this.preparingStore,"load",this.onSeasonPrepared,this);this.preparingStore=null}this.preparingSeason=f;var e=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;var c;if(Ext.isNumber(d)){var a=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();var b=a.indexOf(f);var g=a.indexOf(d);if(b<g){this.slideview.prepareView(e.left);c=this.slideview.getLeftView()}else{this.slideview.prepareView(e.right);c=this.slideview.getRightView()}}else{c=this.slideview.getCenterView()}if(c.isNeedLoadStore()){this.preparingStore=c.getDataviewStore();this.mon(this.preparingStore,"load",this.onSeasonPrepared,this,{delay:100,single:true})}else{this.onSeasonPrepared()}},getSwitchableView:function(b){var a={decorator:"Season",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,flexcroll:this.onFlexcroll,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}};return new SYNO.SDS.VideoStation2.SwitchableDataView(a,b)},getAllDataViews:function(){var a=[];a=a.concat(this.slideview.getLeftView().items.items);a=a.concat(this.slideview.getCenterView().items.items);a=a.concat(this.slideview.getRightView().items.items);return a},onActivate:function(){this.callParent(arguments);this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this)},onDeactivate:function(){this.callParent(arguments);this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this);this.slideview.items.each(function(a){a.clearLoadedInfo()})}});Ext.define("SYNO.SDS.VideoStation2.NavigationPanel",{extend:"SYNO.ux.Panel",constructor:function(b){this.views={};this.views[SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE]=new SYNO.SDS.VideoStation2.ViewHomePage({itemId:"homepage"});this.views[SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST]=new SYNO.SDS.VideoStation2.ViewPlaylist({itemId:"playlist"});this.views[SYNO.SDS.VideoStation2.View.VIEW_POSTER]=new SYNO.SDS.VideoStation2.ViewPoster({itemId:"poster"});this.views[SYNO.SDS.VideoStation2.View.VIEW_DETAIL]=new SYNO.SDS.VideoStation2.ViewDetail({itemId:"detail"});this.views[SYNO.SDS.VideoStation2.View.VIEW_TVSHOW]=new SYNO.SDS.VideoStation2.ViewTVShow({itemId:"tvshow"});var a={cls:"navigation-panel",activeItem:null,layout:"card",tbar:new SYNO.SDS.VideoStation2.NavigationBar(),items:Object.values(this.views),listeners:{scope:this,afterrender:this.insertBackgroundPanels,afterlayout:this.onPanelLayout,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.loadView,this);this.items.each(function(c){this.mon(c,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,function(d){if(c===this.layout.activeItem){this.onViewLoading(d)}},this);this.mon(c,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,function(){if(c===this.layout.activeItem){this.onViewLoaded()}},this);this.mon(c,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,function(d){if(c===this.layout.activeItem){this.onViewNoVideo(d)}},this)},this)},loadView:function(){var a=SYNO.SDS.VideoStation2.View.get().getView();if(!a){this.clearActiveItem();return}var c=this.layout.activeItem;var b=this.views[a];SYNO.Assert(b,String.format("unexpceted view {0}",a));if(c!==b){this.layout.setActiveItem(b)}else{if(c){c.fireEvent("activate")}}},clearActiveItem:function(){var a=this.layout.activeItem;if(a){a.hide();if(!a.hidden){return false}a.fireEvent("deactivate",a);this.layout.activeItem=null}},insertBackgroundPanels:function(a){if(!this._no_video_panel){this._no_video_panel=new SYNO.SDS.VideoStation2.NoVideoPanelWrapper({renderTo:a.getEl()})}else{this._no_video_panel.render(a.getEl())}this.insertBackgroundPosterEl(a)},insertBackgroundPosterEl:function(a){a.getEl().insertFirst({tag:"div",cls:"background-poster",cn:[{tag:"div",cls:"background-poster-gradient"}]})},onPanelLayout:function(){this._no_video_panel.doLayout()},onBeforeDestroy:function(){this._no_video_panel.destory();this._no_video_panel=null},onViewLoading:function(a){this._no_video_panel.hide();if(a){SYNO.SDS.VideoStation2.Util.unmask(a)}SYNO.SDS.VideoStation2.Util.maskLoading(this,true)},onViewLoaded:function(){SYNO.SDS.VideoStation2.Util.unmask(this)},onViewNoVideo:function(b){var c=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE;var f=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();if(c&&!f){this._no_video_panel.show();this._no_video_panel.doLayout();return}var g=SYNO.SDS.VideoStation2.Library.get().getCurrentType();var a=(g!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&g!==SYNO.SDS.VideoStation2.Constant.PLAYLIST);var e=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED;var d=!SYNO.SDS.VideoStation2.Filter.get().isFilterEmpty();if(_S("is_admin")&&!f&&!d&&!e&&a){SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("tip","click_create_folder"),this.launchAddFolderDialog,true)}else{SYNO.SDS.VideoStation2.Util.maskInfo(b,_VST("common","no_video_item"),null,true)}},launchAddFolderDialog:function(){var a=new SYNO.SDS.VideoStation2.Setting.Dialog({initActiveTab:0});SYNO.SDS.VideoStation2.SettingController.get().openDialog(a)}});Ext.define("SYNO.SDS.VideoStation2.NoVideoPanelWrapper",{extend:"Ext.Container",constructor:function(b){var a={cls:"no-video-panel",layout:"fit",hidden:true,items:[new SYNO.SDS.VideoStation2.NoVideoPanel({})]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.NoVideoPanel",{extend:"Ext.Container",constructor:function(b){var a={cls:"inner",html:this.getContent()};this.callParent([Ext.apply(a,b)])},getContent:function(){var a=_S("is_admin")?_VST("common","homepage_no_video_admin"):_VST("common","homepage_no_video");return['<div class="empty-icon"></div>',String.format('<div class="description">{0}</div>',Ext.util.Format.htmlEncode(a))].join("")}});Ext.define("SYNO.SDS.VideoStation2.MainPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={cls:"main-panel",border:false,layout:"border",items:[new SYNO.SDS.VideoStation2.MainList({region:"west"}),new SYNO.SDS.VideoStation2.NavigationPanel({region:"center"})]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.AccountButton",{extend:"SYNO.SDS.VideoStation2.TransparentButton",constructor:function(b){var a={cls:"account",text:_S("user"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:true,items:[new Ext.Action({text:_VST("common","about"),handler:function(){SYNO.SDS.VideoStation2.Window.showAboutWindow()}}),new Ext.Action({text:_T("common","logout"),handler:function(){SYNO.SDS.Utils.Logout.logout(true)}})]}),menuAlign:"tr-br"};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.NotificationPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(b){var a={title:_VST("notification","title")};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionStatusDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{STATUS_WAIT:"wait",STATUS_PROCESS:"process",STATUS_ERROR:"error",STATUS_STOP:"stop",STATUS_DONE:"done"},constructor:function(b){var a={tpl:this.getTpl(),cls:"offline-conversion-status-dataview",itemSelector:"div.offlne-conversion-wrap",overClass:"x-view-over",singleSelect:true};this.callParent([Ext.apply(a,b)])},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="offlne-conversion-wrap">','<div class="thumb" style="background-image: url({[this.getImageURL(values.setting.video)]})"></div>','<div class="info">','<div class="title-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">','<div class="title" ext:qtip="{[this.getDoubleEncodeTitle(values.setting.video)]}">{[this.getEncodeTitle(values.setting.video)]}</div>',"</td>",'<td align="right" class="status-wrap">','<div class="status status-{values.status.state}">{[this.getStatus(values)]}</div>',"</td>","</tr></tbody></table></div>",'<div class="setting-wrap">','<div class="owner-name">{values.status.owner_name:htmlEncode}</div>','<div class="sep"></div>','<div class="video-profile">{values.setting.video_profile}</div>','<div class="sep"></div>','<div class="audio-track">{[this.getAudioTrack(values)]}</div>','<div class="progress">{[this.getProgress(values)]}%</div>',"</div>",'<div class="progress-bar-wrap">','<div class="blue-bar"></div>','<div class="grey-bar" style="width:{[this.getInverseProgress(values)]}%"></div>',"</div>","</div>",'<div class="action stop"></div>','<div class="action delete"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getEncodeTitle:this.getEncodeTitle.createDelegate(this),getDoubleEncodeTitle:this.getDoubleEncodeTitle.createDelegate(this),getStatus:this.getStatus.createDelegate(this),getAudioTrack:this.getAudioTrack.createDelegate(this),getProgress:this.getProgress.createDelegate(this),getInverseProgress:this.getInverseProgress.createDelegate(this)});return a},getImageURL:function(a){return SYNO.SDS.VideoStation2.Util.getImageURL({type:a.type,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})},getEncodeTitle:function(b){if(SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE!==b.type){return Ext.util.Format.htmlEncode(b.title)}var c=[b.title];var a="";if(0!==b.season){a=String.format("S{0}",b.season)}if(0!==b.episode){a+=String.format("E{0}",b.episode)}if(!Ext.isEmpty(a)){c.push(a)}if(!Ext.isEmpty(b.tagline)){c.push(b.tagline)}return Ext.util.Format.htmlEncode(c.join(" - "))},getDoubleEncodeTitle:function(a){return Ext.util.Format.htmlEncode(this.getEncodeTitle(a))},getStatus:function(a){switch(a.status.state){case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_WAIT:return _VST("offline_conversion","status_wait");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS:return _VST("offline_conversion","status_process");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR:return _VST("offline_conversion","status_error");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_STOP:return _VST("offline_conversion","status_stop");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE:return _VST("offline_conversion","status_done")}return""},getAudioTrack:function(c){var a=c.setting.audio_id;if(a<0){return _VST("offline_conversion","default_audio_track")}var b=c.setting.audio_codec.toUpperCase();if(b.indexOf("AAC")!==-1){return"AAC"}return b},getProgress:function(a){if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS===a.status.state){return a.status.progress?a.status.progress*100:0}return 0},getInverseProgress:function(a){return 100-this.getProgress(a)}});Ext.define("SYNO.SDS.VideoStation2.OfflineConversionStatusPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(b){var a={title:_VST("offline_conversion","title"),autoFlexcroll:true,layout:"fit",items:[this.getDataView()]};this.callParent([Ext.apply(a,b)])},onActivate:function(){this.getStore().load()},getStore:function(){this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation.OfflineConversion",method:"list",version:1,listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),api:"SYNO.VideoStation.OfflineConversion",method:"list",version:1,reader:new Ext.data.JsonReader({root:"task",totalProperty:"total",fields:["id","setting","status"]})});return this._store},getDataView:function(){this._dataView=this._dataView||new SYNO.SDS.VideoStation2.OfflineConversionStatusDataView({store:this.getStore()});return this._dataView}});Ext.define("SYNO.SDS.VideoStation2.NotificationDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(b){var a={title:_VST("notification","title"),layout:"fit",width:480,height:580,minWidth:480,minHeight:280,resizable:false,draggable:false,cls:"notification-dialog",items:[this.getTabPanel()],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(a,b)]);this.on("show",this.onActivate,this);this.on("hide",this.onDeactivate,this)},onActivate:function(){this.mon(Ext.getDoc(),"mousedown",this.onMouseDown,this);this.callParent(arguments)},onDeactivate:function(){this.mun(Ext.getDoc(),"mousedown",this.onMouseDown,this);this.callParent(arguments)},onApply:function(){this.hide()},onCancel:function(){this.hide()},onMouseDown:function(a){if(this.isVisible()&&!a.within(this.el)){this.hide()}},getTabPanel:function(){this._tabPanel=this._tabPanel||new SYNO.SDS.VideoStation2.TabPanel({activeTab:0,items:[this.getNotificationPanel(),this.getOfflineConversionPanel()]});return this._tabPanel},getNotificationPanel:function(){this._notification=this._notification||new SYNO.SDS.VideoStation2.NotificationPanel();return this._notification},getOfflineConversionPanel:function(){this._offlineConversion=this._offlineConversion||new SYNO.SDS.VideoStation2.OfflineConversionStatusPanel();return this._offlineConversion}});Ext.define("SYNO.SDS.VideoStation2.MainToolbar",{statics:{spacerConfig:function(a){return{xtype:"tbspacer",width:a}}},extend:"SYNO.ux.Toolbar",constructor:function(b){var a={cls:"main-toolbar",items:this.getItems()};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this);this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.changeSearchState,this);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeSearchState,this);this.changeSearchState();this.onFilterChange(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)},getItems:function(){var a=[new SYNO.ux.Button({cls:"logo",handler:SYNO.SDS.VideoStation2.Controller.intoHomePage}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(26),new SYNO.SDS.VideoStation2.ActionButton({cls:"back",handler:SYNO.SDS.VideoStation2.Controller.goback}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(6),new SYNO.SDS.VideoStation2.ActionButton({cls:"home",tooltip:_VST("common","homepage"),handler:SYNO.SDS.VideoStation2.Controller.intoHomePage}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(12),this.searchField=new SYNO.SDS.VideoStation2.SearchField({width:214,listeners:{scope:this,keypress:this.onSearchFieldKeypress}}),"->",new SYNO.SDS.VideoStation2.AccountButton(),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(16),{xtype:"tbseparator"},SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(12),new SYNO.SDS.VideoStation2.ActionButton({cls:"help",tooltip:_T("common","alt_help"),handler:SYNO.SDS.VideoStation2.Util.launchHelp})];if(_S("is_admin")){Array.prototype.push.apply(a,[SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(12),new SYNO.SDS.VideoStation2.ActionButton({cls:"setting",tooltip:_VST("action","settings"),scope:this,handler:this.launchSetting})])}return a},launchSetting:function(){var a=new SYNO.SDS.VideoStation2.Setting.Dialog();SYNO.SDS.VideoStation2.SettingController.get().openDialog(a)},launchNotification:function(){var a=this.getNotificationDialog();if(a.isVisible()){a.hide()}else{a.show()}},getNotificationDialog:function(){if(!this.notificationDialog){this.notificationDialog=new SYNO.SDS.VideoStation2.NotificationDialog({listeners:{scope:this,show:function(){this.notificationBtn.addClass("x-btn-click")},hide:function(){this.notificationBtn.removeClass("x-btn-click")}}});this.addManagedComponent(this.notificationDialog)}return this.notificationDialog},changeSearchState:function(){this.searchField.setDisabled(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST||SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_DETAIL)},onSearchFieldKeypress:function(c,b){if(b.getKey()!==Ext.EventObject.ENTER){return}var a=c.getValue().trim();if(SYNO.SDS.VideoStation2.Filter.get().getKeyword()===a){return}SYNO.SDS.VideoStation2.Controller.setFilter(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,a)},onFilterChange:function(a){if(a!==SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){return}if(this.searchField.rendered){this.searchField.setValue(SYNO.SDS.VideoStation2.Filter.get().getKeyword())}}});Ext.define("SYNO.SDS.VideoStation.AppInstance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.VideoStation2.MainWindow"});Ext.define("SYNO.SDS.VideoStation2.MainWindow",{extend:"SYNO.SDS.AppWindow",statics:{INIT_SEQUENCE:["checkCapability","loadLibrary","loadPlaylists","loadCastSender"]},isBeta:true,aboutTitleColor:"#D13B3B",constructor:function(b){SYNO.SDS.VideoStation2.Window=this;var a={cls:"syno-vs2-win",layout:"fit",height:580,width:1080,minHeight:480,minWidth:1080,tbar:new SYNO.SDS.VideoStation2.MainToolbar(),items:[new SYNO.SDS.VideoStation2.MainPanel()]};this.callParent([Ext.apply(a,b)]);this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChanged,this);this.initSequence()},init_progress:0,initSequence:function(){if(this.init_progress>=SYNO.SDS.VideoStation2.MainWindow.INIT_SEQUENCE.length){SYNO.SDS.VideoStation2.Util.unmask(this);SYNO.SDS.VideoStation2.Controller.intoHomePage();return}if(this.init_progress===0){SYNO.SDS.VideoStation2.Util.maskLoading(this,true)}this[SYNO.SDS.VideoStation2.MainWindow.INIT_SEQUENCE[this.init_progress]]()},initSequenceCallback:function(){this.init_progress++;this.initSequence()},checkCapability:function(){SYNO.SDS.VideoStation2.SettingController.get().checkCapability({scope:this,fn:this.initSequenceCallback})},loadLibrary:function(){this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.initSequenceCallback,this,{single:true});SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()},loadPlaylists:function(){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.initSequenceCallback,this,{single:true});SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists()},loadCastSender:function(){if(!Ext.isChrome){this.initSequenceCallback();return}var b={jsBaseURL:this.jsConfig.jsBaseURL+"/controller/ui"};var a="cast_sender.js?v=0760";SYNO.VideoController2.Util.loadScript(b,a,this.initSequenceCallback.createDelegate(this))},getMsgBox:function(b){if(!this.msgBox||this.msgBox.isDestroyed){var a=(b&&b.owner)||this;a=a.isDestroyed?null:a;this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:a})}return this.callParent(arguments)},showAboutWindow:function(){if(!this.aboutWindow||this.aboutWindow.isDestroyed){this.aboutWindow=new SYNO.SDS.VideoStation2.AboutWindow({owner:this,aboutHeader:this.aboutHeader,pkgColor:this.aboutTitleColor||"#0086E5"})}return this.callParent(arguments)},onViewChanged:function(){var c=this.getEl();if(!c){return}var b=SYNO.SDS.VideoStation2.View.get().getView();var a=(b===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW||b===SYNO.SDS.VideoStation2.View.VIEW_DETAIL);c[a?"addClass":"removeClass"]("with-background")}});Ext.define("SYNO.SDS.VideoStation2.History",{statics:{instance:null,get:function(){if(!Ext.isObject(SYNO.SDS.VideoStation2.History.instance)){SYNO.SDS.VideoStation2.History.instance=new SYNO.SDS.VideoStation2.History()}return SYNO.SDS.VideoStation2.History.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)}});