PACKAGE_DIR="/var/packages/VideoStation"
SYNODTV_BIN="${PACKAGE_DIR}/target/sbin/synodtvd"
DTV_SETTING_CONF="${PACKAGE_DIR}/etc/dtv_setting.conf"
SYNOPKG_PKG_STATUS="$2"

if [ -e "/usr/syno/sbin/syno_dvb_admin.sh" ]; then
	DVB_ADMIN="/usr/syno/sbin/syno_dvb_admin.sh"
else
	DVB_ADMIN="${PACKAGE_DIR}/target/scripts/DVB_Admin.sh"
fi

start()
{
	[ -e "${DVB_ADMIN}" ] && ${DVB_ADMIN} "start" "${PACKAGE_DIR}"

	# synodtv daemon
	${SYNODTV_BIN} start
	${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh add
	${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh hupapache &
}

stop()
{
	# synodtv daemon
	${SYNODTV_BIN} stop

	[ -e "${DVB_ADMIN}" ] && ${DVB_ADMIN} "stop" "${PACKAGE_DIR}"

	${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh delete
	if [ "UPGRADE" != "$SYNOPKG_PKG_STATUS" ]; then
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh hupapache &
	fi
}

# exit when synodtvd not exists
if [ ! -e ${SYNODTV_BIN} ]; then
	exit 0
fi

# exit when platform is applepie
if [ "yes" == "`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`" ]; then
	exit
fi

case $1 in
	start)
		start
		exit 0
	;;
	stop)
		stop
		exit 0
	;;
esac
