BEGIN;

ALTER TABLE movie ADD COLUMN certificate varchar(255) DEFAULT '' NOT NULL;
ALTER TABLE tvshow_episode ADD COLUMN certificate varchar(255) DEFAULT '' NOT NULL;
ALTER TABLE home_video ADD COLUMN certificate varchar(255) DEFAULT '' NOT NULL;

DROP VIEW tvshow_episode_with_title;

CREATE VIEW tvshow_episode_with_title AS
	SELECT e.id, e.tvshow_id, e.library_id, e.mapper_id, e.tag_line, e.season, e.episode,
	       e.year, e.originally_available, e.sort_time, e.islock, e.create_date, e.modify_date, e.certificate, tv.sort_title FROM tvshow_episode AS e
	LEFT JOIN (SELECT id, UPPER(sort_title) AS sort_title FROM tvshow) AS tv ON e.tvshow_id = tv.id;

ALTER TABLE video_file ADD COLUMN ff_video_profile integer DEFAULT -99 NOT NULL;
ALTER TABLE video_file ADD COLUMN rotation integer DEFAULT 0 NOT NULL;

COMMIT;
