#!/bin/sh

SYNO_PKG_TOOL="/usr/syno/bin/synopkg"
SYNO_SERVICE_TOOL="/usr/syno/sbin/synoservice"

SYNOPKG_PKGNAME="${SYNOPKG_PKGNAME:-VideoStation}"
#SYNOPKG_PKGNAME="${SYNOPKG_PKGNAME:-DownloadStation}"

PKG_DIR="/var/packages/${SYNOPKG_PKGNAME}"
PKG_SCRIPT_DIR="${PKG_DIR}/scripts"
PKG_SCRIPT_START="${PKG_SCRIPT_DIR}/start-stop-status"

PKG_INFO="${PKG_DIR}/INFO"
PKG_ENABLED_FILE="${PKG_DIR}/enabled"

PKG_INDEX_DIR="${PKG_DIR}/target/indexdb"
DSM_INDEX_ADD="/usr/syno/bin/pkgindexer_add"
DSM_INDEX_DEL="/usr/syno/bin/pkgindexer_del"

DSM_VERSION_PATH="/etc.defaults/VERSION"
SYNOPKG_DSM_VERSION_MAJOR="${SYNOPKG_DSM_VERSION_MAJOR:-`/bin/get_key_value ${DSM_VERSION_PATH} majorversion`}"
SYNOPKG_DSM_VERSION_MINOR="${SYNOPKG_DSM_VERSION_MINOR:-`/bin/get_key_value ${DSM_VERSION_PATH} minorversion`}"
SYNOPKG_DSM_VERSION_BUILD="${SYNOPKG_DSM_VERSION_BUILD:-`/bin/get_key_value ${DSM_VERSION_PATH} buildnumber`}"

pkg_check_version_older() {
	local base_major=$1
	local base_minor=$2
	local base_minor=$3
	local target_major=$4
	local target_minor=$5
	local target_build=$6
	
	# compare major, version must equal or above limitation
	if [ $target_major -lt $base_major ]; then
		return 1;
	elif [ $target_major -gt $base_major ]; then
		return 0;
	fi
	# compare minor
	if [ $target_minor -lt $base_minor ]; then
		return 1;
	elif [ $target_minor -gt $base_minor ]; then
		return 0;
	fi
        # compare build
	if [ $target_build -lt $base_build ]; then
		return 1;
	else
		return 0;
	fi
}

pkg_is_dsm_match() {
	pkg_check_version_older 4 1 2625 $SYNOPKG_DSM_VERSION_MAJOR $SYNOPKG_DSM_VERSION_MINOR $SYNOPKG_DSM_VERSION_BUILD
	return $?
}

pkg_is_enabled() {	
	if pkg_is_dsm_match; then
		`${SYNO_PKG_TOOL} status ${SYNOPKG_PKGNAME} | grep -sq "package is started"`
		return $?
	elif [ -f "${PKG_ENABLED_FILE}" ]; then
		return 0
	else
		return 1
	fi
}

pkg_restart() {
	if pkg_is_dsm_match; then
		${SYNO_PKG_TOOL} restart ${SYNOPKG_PKGNAME}
	else
		${PKG_SCRIPT_START} restart
	fi
}

pkg_get_info() { #<key>
	if [ -f "${PKG_INFO}" ]; then
		echo `/bin/get_key_value ${PKG_INFO} $1`
		return 0
	else
		echo "Package info file does not exist";
		return 1
	fi
}

pkg_is_share_change() {
	if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ] || [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ] || 
	    [ "${ORIGIN_SHARE_STATUS}" = "normal" -a "${SHARE_STATUS}" = "decrypt" ]; then
		return 0
	else                                                                                  
		return 1                                                                   
	fi                                                                                         
}
