BEGIN;

CREATE VIEW watch_status_view AS
	SELECT video_file.id AS video_file_id, video_file.mapper_id, video_file.duration, watch_status.uid, CAST(watch_status.position AS float) AS position, watch_status.modify_date
	FROM video_file LEFT JOIN watch_status ON video_file.id = watch_status.video_file_id;

ALTER TABLE home_video ADD COLUMN record_time_utc timestamp;
ALTER TABLE home_video DROP CONSTRAINT home_video_ukey CASCADE;
ALTER TABLE home_video ADD CONSTRAINT home_video_ukey UNIQUE(library_id, title, record_time_utc);
UPDATE home_video SET record_time_utc = (record_time at time zone '__SYSTEM_TIME_ZONE__');

ALTER TABLE tv_record ADD COLUMN record_time_utc timestamp;
ALTER TABLE tv_record DROP CONSTRAINT tv_record_ukey CASCADE;
ALTER TABLE tv_record ADD CONSTRAINT tv_record_ukey UNIQUE(title, record_time_utc, channel_name);
UPDATE tv_record SET record_time_utc = (record_time at time zone '__SYSTEM_TIME_ZONE__');

COMMIT;
