/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.VideoStation.ImageLoadManager",{extend:"Ext.util.Observable",MAX_CONCURRENT:5,running:0,jobs:null,preemptJobs:null,delegate:null,constructor:function(){this.callParent(arguments);this.jobs=[];this.preemptJobs=[];this.delayedPreemptJob=new Ext.util.DelayedTask(this.preemptJob,this)},clear:function(){this.running=0;this.jobs=[];this.preemptJobs=[]},appendJob:function(a){if(-1!==this.jobs.indexOf(a)){return}this.jobs.push(a);this.dispatch()},insertJob:function(a){this.preemptJobs.push(a);this.delayedPreemptJob.delay(100)},preemptJob:function(){Ext.each(this.preemptJobs,function(a){this.jobs.remove(a)},this);this.jobs.unshift.apply(this.jobs,this.preemptJobs);this.preemptJobs=[];this.dispatch()},dispatch:function(){while(this.MAX_CONCURRENT>=this.running){var a=this.jobs.shift();if(!a){break}this.running++;this.setImgURL(a)}},setImgURL:function(c){var b=c.getAttribute("url");if(!b){this.running--;this.dispatch.defer(0,this);return}var a=document.createElement("img");Ext.fly(a).on({load:this.onImageLoad.createDelegate(this,[c,a,b]),error:this.onImageError.createDelegate(this,[c,a,b])});c.dom.removeAttribute("url");a.src=b},finalizedImageLoad:function(b,a){this.running--;this.dispatch.defer(0,this)},onImageLoad:function(c,a,b){this.finalizedImageLoad(a);if(this.delegate){this.delegate.onImageLoad(a)}c.dom.setAttribute("style",String.format(SYNO.SDS.VideoStation.Util.BACKGROUND_IMAGE_STR,b));c.removeClass("loading");a=null},onImageError:function(c,a,b){this.finalizedImageLoad(c,a);if(this.delegate){this.delegate.onImageError(c,a)}}});Ext.define("SYNO.SDS.VideoStation.ImageSelector",{extend:"SYNO.SDS.Utils.ImageSelector",constructor:function(a){this.callParent([a,"login","logo"]);this.tree_myimage.hide();this.state="fromDS";if(this.tree_myimage.getSelectionModel().getSelectedNode()){this.tree_myimage.getSelectionModel().clearSelections()}this.centerPanel.layout.setActiveItem(this.view)},addDefaultRecord:function(b,a){}});Ext.define("SYNO.SDS.VideoStation.PagingToolbar",{extend:"SYNO.ux.PagingToolbar",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.filteringBase=a.filteringBase;this.callParent([a])},getStore:function(){return this.filteringBase.getStore()},onActivate:function(){this.bindStore(this.getStore());this.onLoad(this.store,null,{params:{offset:this._getHistoryInfo().status.offset}})},onDeactivate:function(){this.bindStore(null)}});Ext.ns("SYNO.SDS.VideoStation.Config");Ext.apply(SYNO.SDS.VideoStation.Config,{pageSize:120,recentadd:-1});Ext.ns("SYNO.SDS.VideoStation.Util");function _VST(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}}Ext.apply(SYNO.SDS.VideoStation.Util,{init:(function(){var a=SYNO.SDS.VideoStation.Util;a._MOVIE_ID="movie";a._TVSHOW_ID="tvshow";a._TVSHOW_EPISODE_ID="tvshow_episode";a._HOME_VIDEO_ID="home_video";a._TV_RECORDER_ID="tv_record";a._COLLECTION_ID="collection";a._VIEW_HOMEPAGE="view_homepage";a._VIEW_FILTERING="view_filtering";a._VIEW_DETAIL="view_detail";a._VIEW_EPISODE="view_episode";a._VIEW_GRID="view_grid";a._VIEW_COLLECTION="view_collection";a.MOD_IMG={};a.MOD_IMG[a._TVSHOW_EPISODE_ID]={};a.MOD_IMG[a._MOVIE_ID]={};a.MOD_IMG[a._TVSHOW_ID]={};a.MOD_IMG[a._TVSHOW_EPISODE_ID]={};a.MOD_IMG[a._HOME_VIDEO_ID]={};a.MOD_IMG[a._TV_RECORDER_ID]={}}),BACKGROUND_IMAGE_STR:((Ext.isIE8||Ext.isIE7)?"filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')":"background-image: url('{0}')"),setModImgTime:function(a,c){var b=SYNO.SDS.VideoStation.Util;if(!b.MOD_IMG[a]){b.MOD_IMG[a]={}}b.MOD_IMG[a][c]=(new Date().getTime())},getModImgTime:function(a,c){var b=SYNO.SDS.VideoStation.Util;if(!b.MOD_IMG[a]||!b.MOD_IMG[a][c]){return 0}return b.MOD_IMG[a][c]},getErrinfoString:function(c,a){var b=null;var d=Ext.isString(a)?a:"";if(c&&c.success!==true){b=c.errinfo||{};if(c.error&&Ext.isNumber(c.error.code)){d=_T("error","error_error_system")}else{if(b.sec&&b.key){d=_VST(b.sec,b.key)||_T(b.sec,b.key)||String.format("{0}:{1}",b.sec,b.key)}else{d=_T("error","error_error_system")}}if(Ext.isNumber(b.line)){d=String.format("{0} ({1})",d,b.line)}}return d},getWebAPIErr:function(a,c,b){if(!a){if(c&&c.code<400){return SYNO.API.CheckResponse(a,c,b)}else{switch(c.code){case 400:return _VST("error","download_failed");case 417:return _VST("error","image_format");case 418:return String.format(_VST("error","image_too_big"),4);case 431:return _VST("collection","collection_duplicate_name");default:return _T("error","error_error_system")}}}},_initWinWrappers:function(a){this._getOwner=function(){if(this.owner){return this.owner}else{if(a&&a.owner){return(this.owner=a.owner)}}return(this.owner=SYNO.SDS.VideoStation.Window)};Ext.each(["_getAbsoluteURL"],function(c){this[c]=function(){var d=SYNO.SDS.VideoStation.Window;return d[c].apply(d,arguments)}},this);var b=["_getCurId","_getCurType","_getSelectedVideoType","_getCurLibraryId","_getCurCategory","_gobackPanel","_getHistoryInfo","_getWebAPIURL","_checkIsByfolder","_checkIsTVEpisode"];Ext.each(b,function(c){this[c]=function(){var d=SYNO.SDS.VideoStation.Util;return d[c].apply(SYNO.SDS.VideoStation.Window,arguments)}},this)},_getCurId:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurId()},_getCurType:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurType()},_getCurLibraryTitle:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurLibraryTitle()},_getCurLibraryId:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurLibraryId()},_getCurCategory:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurCategory()},_addLibrary:function(b,a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").addLibrary(b,a)},_removeLibrary:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").removeLibrary(a)},_gotoHomePage:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gotoHomePage(a)},_gotoFilterView:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gotoFilterView(a)},_goSwitchFilterView:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").goSwitchFilterView()},_gotoDetileView:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gotoDetileView(a)},_gotoCollectionView:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gotoCollectionView(a)},_gotoTVSeasonView:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gotoTVSeasonView(a)},_gotoViewAgain:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gotoViewAgain()},_gobackPanel:function(a,b){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").gobackPanel(a,b)},_goSwitchLibrary:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").goSwithLibrary(a)},_getHistoryInfo:function(b,a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo(b,a)},_getHistoryAll:function(a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryAll(a)},_getWebAPIURL:function(a){return String.format("{0}/{1}","/webapi/VideoStation",a)},_updatePathBar:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").updatePathBar()},_loadFilterBaseStore:function(a){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.FilteringBase").onLoadStore(a)},_checkIsByfolder:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").checkIsByfolder()},_checkIsTVEpisode:function(){var b=SYNO.SDS.VideoStation.Util._getHistoryInfo();var a=SYNO.SDS.VideoStation.Util._getCurType();if(SYNO.SDS.VideoStation.Util._TVSHOW_ID===a){if(SYNO.SDS.VideoStation.Util._VIEW_DETAIL===b.view||SYNO.SDS.VideoStation.Util._VIEW_EPISODE===b.view){return true}if(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&SYNO.SDS.VideoStation.Util._VIEW_FILTERING===b.view){return true}}return false},_getSelectedVideoId:function(){var b=SYNO.SDS.VideoStation.Util._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_GRID===b.view){return null}var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedData();var d;if(c){if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){var a=c.get("additional");d=a.metadata.id}else{d=c.get("id")}}else{if(b.params.id){d=b.params.id}}return d},_getSelectedVideoCollections:function(){var c=SYNO.SDS.VideoStation.Util._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_GRID===c.view){return null}var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas();var a=[];if(Ext.isDefined(b[0])){b.each(function(i,g,h){var f,e;if(SYNO.SDS.VideoStation.Util._VIEW_COLLECTION===c.view){f=i.get("type")?i.get("type"):c.status.type}else{f=SYNO.SDS.VideoStation.Util._getSelectedVideoType()}if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){var d=i.get("additional");e=d.metadata.id}else{e=i.get("id")}a[g]={video_id:e,video_type:f}},this)}else{if(c.params.id){a[0]={video_id:c.params.id,video_type:SYNO.SDS.VideoStation.Util._getSelectedVideoType()}}}return a},_getSelectedVideoType:function(){var b=SYNO.SDS.VideoStation.Util._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_GRID===b.view){return null}var a=SYNO.SDS.VideoStation.Util._checkIsTVEpisode()?SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:SYNO.SDS.VideoStation.Util._getCurType();if(SYNO.SDS.VideoStation.Util._COLLECTION_ID!==a){return a}var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedData();return Ext.isObject(c)?c.get("type"):b.params.type},_getResponseRoot:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return"movies";case SYNO.SDS.VideoStation.Util._TVSHOW_ID:if(SYNO.SDS.VideoStation.Util._checkIsTVEpisode()){return"episodes"}else{return"tvshows"}break;case SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:return"episodes";case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return"videos";case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:return"recordings";default:break}},_createAction:function(b){var d=b.itemId||Ext.id();var c=b.text||_VST("action",d);var a=b.iconCls||("syno-vs-action-"+d);return(new Ext.Action(Ext.apply({itemId:d,text:c,iconCls:a,scope:b.scope||this,handler:b.handler||Ext.emptyFn},b)))},_createActions:function(b){if(!this.actions){this.actions={}}var a=[];if(!Ext.isArray(b)){b=[b]}Ext.each(b,function(c){var d=c.itemId||Ext.id();this.actions[d]=this._createAction(c);a.push(this.actions[d])},this);return a},_getAction:function(a){if(a in this.actions){return this.actions[a]}else{SYNO.Debug("no this action: "+a);return undefined}},_initUtilFnWrappers:function(a){Ext.each(a,function(b){this[b]=function(){return SYNO.SDS.VideoStation.Util[b].apply(this,arguments)}},this)},parseFullPathToFileName:function(d,c){var b=c?c:"/";var a="";var e=d.lastIndexOf(b);a=d.substring(e+1);return a},getShareData:function(c){var b=c;var d=b.indexOf("/",1);var a="";b=b.substr(1);if(d>0){a=b.substr(d);b=b.substr(0,d-1)}return{share:Ext.util.Format.lowercase(b),orishare:b,subpath:a}},deleteFiles:function(b,a){var c=a;SYNO.SDS.VideoStation.Window.sendWebAPI({api:"SYNO.VideoStation.Video",method:"delete",version:2,params:{files:Ext.encode(b)},scope:this,callback:function(g,f,e,d){c(g,f,e,d)}})},deleteVideos:function(d,j){var k=j;var g={};for(var f=0,e=d.length;f<e;f++){var b=d[f].video_id;var h=d[f].video_type;if(!Ext.isArray(g[h])){g[h]=[]}g[h].push(b)}var a=[];for(var c in g){var m={type:c,videos:g[c]};a.push(m)}if(a.length>0){this.deleteVideoFiles(a,0,k)}},deleteVideoFiles:function(b,c,e){var a=b;var d=Ext.apply(this.delete_WebAPI(a[c].type),{params:{videos:Ext.encode(a[c].videos)},scope:this,callback:function(i,h,g,f){if((c+1)<a.length&&i){this.deleteVideoFiles(a,(c+1),e)}else{e(i,h,g,f)}}});SYNO.SDS.VideoStation.Window.sendWebAPI(d)},ableToControlDTV:function(){var a=SYNO.SDS.VideoStation.Util.privilege;return Ext.isObject(a)?a.dtv:false},ableToControlRenderer:function(){var a=SYNO.SDS.VideoStation.Util.privilege;return Ext.isObject(a)?a.renderer:false},ableToControlSharing:function(){var a=SYNO.SDS.VideoStation.Util.privilege;return Ext.isObject(a)?a.sharing:false},hideDTVUI:function(){return _D("support_dual_head")==="yes"},encodedMsg:function(c,a){var b=c;if(!Ext.isDefined(c)){b=""}else{if(a){b=Ext.util.Format.stripTags(b)}}return Ext.util.Format.htmlEncode(b)},onProxyBeforeLoad:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}},onPlayAction:function(f,d,a,c){if(!d||!d.id||!d.path){return}var b=c||"streaming";var e=d.path;SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{ieMode:9,file_id:d.id,player_id:b,title:e.substr(e.lastIndexOf("/")+1),browse_type:a.pathType,sort_info:Ext.encode(a.sortInfo),type_id:a.typeID,video_id:a.videoID,video_type:a.videoType})},onOpenContainingFolder:function(a){SYNO.SDS.AppLaunch("SYNO.SDS.App.FileStation3.Instance",{openfile:a})},onGetHeight:function(d,c){var a=d.getHeight()+(c||0);var b=SYNO.SDS.Desktop.getEl().getHeight();if(b<a){a=b}return a},getinfo_WebAPI:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return{api:"SYNO.VideoStation.Movie",method:"getinfo",version:"2"};case SYNO.SDS.VideoStation.Util._TVSHOW_ID:return{api:"SYNO.VideoStation.TVShow",method:"getinfo",version:"1"};case SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:return{api:"SYNO.VideoStation.TVShowEpisode",method:"getinfo",version:"2"};case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return{api:"SYNO.VideoStation.HomeVideo",method:"getinfo",version:"2"};case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:return{api:"SYNO.VideoStation.TVRecording",method:"getinfo",version:"2"};case SYNO.SDS.VideoStation.Util._COLLECTION_ID:return{api:"SYNO.VideoStation.Collection",method:"getinfo",version:"1"};default:break}},delete_WebAPI:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return{api:"SYNO.VideoStation.Movie",method:"delete",version:3};case SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:return{api:"SYNO.VideoStation.TVShowEpisode",method:"delete",version:3};case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return{api:"SYNO.VideoStation.HomeVideo",method:"delete",version:3};case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:return{api:"SYNO.VideoStation.TVRecording",method:"delete",version:3};default:break}},_getCollectionStore:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr").getStore()},_getCollectionMenuItems:function(b,a){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr").getCollectionMenuItems(b,a)},_onRequestCollectionNoMesg:function(d,a,c,b){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr")._onRequestCollectionNoMesg(d,a,c,b)},_onRequestCollection:function(d,a,c,b){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr")._onRequestCollectionNoMesg(d,a,c,b)},getAddtionalText:function(a,b){if((!a||!a.additional||!a.additional[b])&&(!a.file||!a.file.additional||!a.file.additional[b])){return""}if(a.additional&&a.additional[b]){return a.additional[b].replace(/[\n\r\t]/g,"")}else{if(a.file&&a.file.additional&&a.file.additional[b]){return a.file.additional[b].replace(/[\n\r\t]/g,"")}else{return""}}},getImageURL:function(b,d){d=d||{};Ext.apply(d,{api:"SYNO.VideoStation.Poster",method:"getimage",version:"1"});var c=SYNO.SDS.VideoStation.Util.getModImgTime(d.type,d.id);if(c){Ext.apply(d,{_dc:c})}if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(d,{hr:2})}var a=Ext.urlAppend(b,Ext.urlEncode(d));return a},getLangStore:function(){var b=SYNO.SDS.Utils.getSupportedLanguage(),a;a=new Ext.data.SimpleStore({fields:["value","display"],data:b,autoDestroy:true});return a},onGetUserDefineCollectionID:function(b,a){var d,c="";d=b.indexOf(a);if(-1!==d){c=b.substring(0,d)}return c},getTVShowID:function(){var b=SYNO.SDS.VideoStation.Util._getCurType();if(SYNO.SDS.VideoStation.Util._TVSHOW_ID!==b){return null}if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){return null}var a=SYNO.SDS.VideoStation.Util._getHistoryInfo(SYNO.SDS.VideoStation.Util._getCurId(),2);return a?a.params.id:null},getCollectionID:function(){var a=SYNO.SDS.VideoStation.Util._getCurType();if(SYNO.SDS.VideoStation.Util._COLLECTION_ID!==a){return null}var b=SYNO.SDS.VideoStation.Util._getHistoryInfo(SYNO.SDS.VideoStation.Util._COLLECTION_ID,1);return b?b.params.collection_id:null},getPlayAdditionalInfo:function(){var e,d,b;var f=SYNO.SDS.VideoStation.Util._getHistoryInfo();var c=SYNO.SDS.VideoStation.Util._getCurType();var g=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedData();var a=(c===SYNO.SDS.VideoStation.Util._COLLECTION_ID)?SYNO.SDS.VideoStation.Util.getCollectionSortInfo():{};b=SYNO.SDS.VideoStation.Util.getTVShowID()||SYNO.SDS.VideoStation.Util.getCollectionID()||null;d=SYNO.SDS.VideoStation.Util._getSelectedVideoType();switch(f.view){case SYNO.SDS.VideoStation.Util._VIEW_DETAIL:e=f.params.id;break;case SYNO.SDS.VideoStation.Util._VIEW_COLLECTION:case SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE:case SYNO.SDS.VideoStation.Util._VIEW_FILTERING:case SYNO.SDS.VideoStation.Util._VIEW_EPISODE:e=g.get("id");break;default:e="";break}return{pathType:c,sortInfo:a,videoType:d,typeID:b,videoID:e}},getWatchStatusDiv:function(b){var a=b.additional?b.additional.watched_ratio||0:0;a=(0===a?0:Math.floor(a*100));if(100===a){return""}return'<div class="watch-status-wrap"><div class="watch-status-background"></div><div class="watch-status" style="width:'+a+'%"></div></div>'},getActiveItem:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").layout.activeItem},getCollectionName:function(a){if(a==="syno_favorite"){return _VST("collection","favorite")}else{if(a==="syno_watchlist"){return _VST("collection","watchlist")}else{if(a==="syno_default_shared"){return _VST("collection","default_shared")}else{return a}}}},getBlSelectedFolder:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas();var a=false;Ext.each(b,function(c){if(c&&Ext.isString(c.get("id"))&&-1!==c.get("id").indexOf("/")){a=true;return false}},this);return a},getRecordTime:function(a){var b=a.get("additional").metadata||{};return a.get("original_available")||a.get("record_date")||b.original_available||b.record_date},getSelectionMode:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").getSelectionMode()},getCollectionSortInfo:function(){return Ext.apply({sort_direction:"ASC",sort_by:"title"},SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","collection_sortstate"))},getFilteringViewLayout:function(){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").getTBar();var b=c.getComponent("display_button_group").getActiveBtn().itemId;var a;if("filtering_list"===b){a="SYNO.SDS.VideoStation.FilteringList"}else{if("filtering_tile"===b){a="SYNO.SDS.VideoStation.FilteringTile"}else{if("filtering_thumbnail"===b){a="SYNO.SDS.VideoStation.FilteringThumbnail"}}}return a},noItemHandler:function(b){var c=SYNO.SDS.VideoStation.Util._getCurType();if(!_S("is_admin")||_S("demo_mode")||SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===c||SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE!==SYNO.SDS.VideoStation.Util._getHistoryInfo().view){return{msg:_VST("common","no_video_item")}}var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.FolderMgr");var e=d.isLibraryContainsFolder(c,b);var f=function(){var g=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel");g.launchSettingDialog(0,{defaultLibraryTitle:SYNO.SDS.VideoStation.Util._getCurLibraryTitle(),openFolderDialog:true})};var a=function(){var j=Ext.isMac?"store_with_mac.html":"store_with_windows.html";var g=parseInt(_S("majorversion"),10),i=parseInt(_S("minorversion"),10);if(g===5&&i<2){window.open("https://help.synology.com/dsm/?section=DSM&version=5.1&link=Tutorial%2F"+j);return}var h="SYNO.SDS.Tutorial.Application:Tutorial/"+j;if(_S("standalone")){SYNO.SDS.WindowLaunch("SYNO.SDS.HelpBrowser.Application",{topic:h})}else{SYNO.SDS.AppLaunch("SYNO.SDS.HelpBrowser.Application",{topic:h},false)}};return{msg:e?_VST("tip","click_learn_upload_video"):_VST("tip","click_create_folder"),fn:e?a:f}}});Ext.define("SYNO.SDS.VideoStation.ModalWindow",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var a=Ext.isString(b.cls)?(b.cls+" syno-vs-dialog"):"syno-vs-dialog";b.cls=a;this.callParent([b])},_getAbsoluteURL:function(){return this._getOwner()._getAbsoluteURL.apply(this._getOwner(),arguments)},_getWebAPIURL:function(){return this._getOwner()._getWebAPIURL.apply(this._getOwner(),arguments)},_getOwner:function(){if(this.owner){return this.owner}return(this.owner=SYNO.SDS.VideoStation.Window)}});Ext.ns("SYNO.SDS.VideoStation.DTVUtil");Ext.apply(SYNO.SDS.VideoStation.DTVUtil,{mappingDTVStatus:function(a){switch(a){case 401:return _VST("error","error_someone_streaming");case 402:return _VST("error","error_someone_scaning");case 403:return _VST("error","dtv_channeltable_not_found");case 404:return _VST("error","recorde_program_not_exist");case 405:return _VST("error","recorde_duplicate");case 406:return _VST("error","dtv_folder_not_found");case 407:return _VST("error","dtv_request_dongle");case 408:return _VST("action","scan_fail");case 409:return _VST("error","no_data");case 412:return _VST("error","update_recording");case 413:return _VST("error","update_streaming");case 414:return _T("error","error_file_exist");case 415:return _VST("action","dvbs_scan_fail");default:return _T("common","error_system")}},programStatus:function(a){switch(a){case 0:return"";case 1:return"pass";case 2:return"streaming";case 3:return"recording";case 4:return"scheduled";case 22:return"repeatschedule";case 12:case 13:return"repeatschedule"}},getScheduleStatusString:function(a){switch(a){case 0:return _T("error","error_error");case 1:return _VST("record","task_waiting");case 2:return _VST("streaming","streaming_for_someone");case 3:return _VST("action","recording");case 4:return _VST("error","no_dtv_dongle");case 5:return _VST("record","record_interrupt");case 6:return _VST("record","task_finished");case 7:return _VST("error","record_dest_deny");case 8:return _VST("error","invalid_user");case 9:return _VST("error","record_quota_reached");case 10:return _VST("error","record_no_volume");case 11:return _VST("error","record_dest_not_exist");case 12:return _VST("repeat","repeat_weekly");case 13:return _VST("repeat","repeat_daily");case 14:return _VST("record","record_interrupt");case 15:return _VST("record","skip")}},modifyHM:function(a){var b=a;if(10>a){b="0"+a}return b},getWeekDayfromNumber:function(a){var b=false;switch(a){case 0:b=_VST("repeat","schedule_sun");break;case 1:b=_VST("repeat","schedule_mon");break;case 2:b=_VST("repeat","schedule_tue");break;case 3:b=_VST("repeat","schedule_wed");break;case 4:b=_VST("repeat","schedule_thu");break;case 5:b=_VST("repeat","schedule_fri");break;case 6:b=_VST("repeat","schedule_sat");break}return b},ableToPlayDTV:function(){var a=(SYNO.SDS.VideoStation.Util.support_transcode||SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported());return a}});Ext.ns("SYNO.SDS.VideoStation.FilterUtil");Ext.apply(SYNO.SDS.VideoStation.FilterUtil,{getHistoryFilter:function(a){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurId();var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo(b,1);if(!Ext.isDefined(c)){return{}}if(!Ext.isDefined(c.status.filter)){c.status.filter={}}if(!Ext.isDefined(a)){return c.status.filter}else{if("keyword"===a){if(!Ext.isDefined(c.status.filter.keyword)){c.status.filter.keyword=undefined}}else{if(!Ext.isArray(c.status.filter[a])){c.status.filter[a]=[]}}}return c.status.filter[a]},getFilterArrayByKey:function(b,a){var c=[];Ext.each(b,function(e,d){c.push(e[a])},this);return c},getFilterCondition:function(c){var b={};var a=SYNO.SDS.VideoStation.FilterUtil.getFilterTypes();Ext.each(a,function(h){var f=h.id;var e=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(f);if(Ext.isArray(e)&&0<e.length){var i={};var g=this.getFilterArrayByKey(e,"value");if(c){i[f]=Ext.encode(g)}else{i[f]=g}Ext.apply(b,i)}},this);var d=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter("keyword");if(d){Ext.apply(b,{keyword:d})}return b},getFilterTypes:function(b){var c=[];var a=b?b:SYNO.SDS.VideoStation.Util._getCurType();if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a){c=[{id:"date",name:_VST("date","title")},{id:"channel_name",name:_VST("schedule","channel")},{id:"title",name:_VST("filter","program")}]}else{c=[{id:"actor",name:_VST("actor","title")},{id:"director",name:_VST("director","title")},{id:"genre",name:_VST("genre","title")},{id:"writer",name:_VST("writer","title")},{id:"certificate",name:_VST("metadata","rating_classification")},{id:"year",name:_VST("year","title")}]}c=c.concat({id:"resolution",name:_VST("video_info","resolution")},{id:"watchedstatus",name:_VST("common","watch_status")},{id:"filecount",name:_VST("filter","file_count")},{id:"container",name:_VST("video_info","container")},{id:"duration",name:_VST("duration","title")});return c},getFilterDatas:function(a){var b=[];if(a==="date"||a==="channel_name"||a==="title"||a==="actor"||a==="director"||a==="genre"||a==="writer"||a==="certificate"||a==="year"||a==="container"){b=[]}else{if(a==="resolution"){b=[{name:_VST("filter","resolution_sd"),value:{x_from:-1,x_to:1024,y_from:-1,y_to:576}},{name:"720p",value:{x_from:1024,x_to:1280,y_from:576,y_to:720}},{name:String.format(_VST("filter","andabove"),"1080p"),value:{x_from:1280,x_to:-1,y_from:720,y_to:-1}}]}else{if(a==="filecount"){b=[{name:_VST("filter","singlefile"),value:"single"},{name:_VST("filter","multiplefile"),value:"multiple"}]}else{if(a==="duration"){b=[{name:String.format(_VST("filter","andbelow"),"10 "+_VST("common","minutes")),value:{from:0,to:10}},{name:"10 ~ 30 "+_VST("common","minutes"),value:{from:10,to:30}},{name:"30 ~ 60 "+_VST("common","minutes"),value:{from:30,to:60}},{name:"60 ~ 120 "+_VST("common","minutes"),value:{from:60,to:120}},{name:String.format(_VST("filter","andabove"),"120"+_VST("common","minutes")),value:{from:120,to:-1}}]}else{if(a==="watchedstatus"){b=[{name:_VST("advanced","watched"),value:"watched"},{name:_VST("advanced","watching"),value:"watching"},{name:_VST("advanced","unwatched"),value:"unwatched"}]}}}}}return b},isEqual:function(b,a){if(Ext.isObject(b)){for(var c in b){if(b[c]!==a[c]){return false}}for(var d in a){if(b[d]!==a[d]){return false}}return true}else{return b===a}}});Ext.define("SYNO.SDS.VideoStation.AddEditDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(c){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,c);this.module=c.module;this.mode=c.mode;var a=c.applyButton;var b=Ext.apply({title:("add"===this.mode)?_T("common","add"):_T("common","alt_edit"),width:500,height:350,layout:"fit",items:[this.getFormPanel()],buttons:[a,{btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}],addAction:"create",editAction:"modify"},c);this.callParent([b])},onRequest:function(a){var b=("add"===this.mode)?this.addAction:this.editAction;var c=Ext.apply(this.getParameter(),{action:b});this.setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getAbsoluteURL(a),method:"POST",single:true,autoJsonDecode:true,params:c,scope:this,callback:this.onRequestDone.createDelegate(this)},this).start(true)},onCancel:function(){if("edit"!==this.mode||!this.isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this._getOwner().getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),a,this)},isDirty:Ext.emptyFn,getFormPanel:Ext.emptyFn,onRequestDone:Ext.emptyFn,getParameter:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation.FileChooser",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",constructor:function(b){var a={usage:{type:"chooseDir"},folderToolbar:true,treeFilter:function(d,c){if(c&&(c.spath==="/home"||c.spath==="/homes"||c.mountType==="remote")){return false}return true}};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation.AddVideoDialog",{extend:"SYNO.SDS.VideoStation.AddEditDialog",constructor:function(b){this.folder=b.folder;this.library=b.library;var a=Ext.apply({resizable:false,width:500,applyButton:{btnStyle:"blue",text:_T("common","alt_apply"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onRequest}},b);this.callParent([a]);this.defaultItems=[new Ext.data.Record({title:_VST("type","movie"),type:"movie",is_public:true,field:"item",id:-1}),new Ext.data.Record({title:_VST("type","tv_show"),type:"tvshow",is_public:true,field:"item",id:-2}),new Ext.data.Record({title:_VST("type","home_video"),type:"home_video",is_public:true,field:"item",id:-3})];this.defaultTypeToId={movie:-1,tvshow:-2,home_video:-3}},getFormPanel:function(){if(this.formpanel){return this.formpanel}var b={xtype:"syno_fieldset",title:_VST("videofolder","title"),labelWidth:100,items:[{xtype:"syno_compositefield",fieldLabel:_T("common","folder"),defaults:{hideLabel:true},items:[{xtype:"syno_textfield",width:200,name:"path",readOnly:true,allowBlank:false,blankText:_VST("videofolder","specify_path"),validationEvent:"afterrender"},{xtype:"syno_button",text:_VST("common","select"),btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onEditPathBtnHandler}]}]};var d={xtype:"syno_fieldset",title:_VST("library","title"),items:[{disabled:true,xtype:"syno_combobox",name:"library_id",fieldLabel:_VST("library","title"),displayField:"title",valueField:"id",tpl:'<tpl for="."><div class="x-combo-list-item">{title:htmlEncode}</div></tpl>',store:this.getLibraryStore(),listeners:{scope:this,select:this.onLibrarySelect}}]};var c={xtype:"syno_fieldset",title:_VST("videofolder","prefer_lang"),items:[{xtype:"syno_combobox",disabled:(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===this.library.type),name:"preferlanguage",fieldLabel:_VST("language","title"),displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation.Util.getLangStore()),tpl:new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" ext:qtip="{display}">',"{display}","</div>","</tpl>")}]};var a={trackResetOnLoad:true,border:false,items:[b,d,c]};return(this.formpanel=new SYNO.ux.FormPanel(a))},getLibraryStore:function(){if(this.libraryStore){return this.libraryStore}this.libraryStore=new SYNO.SDS.VideoStation.LibraryManageStore({listeners:{scope:this,load:this.storeLoadHandler}});return this.libraryStore},storeLoadHandler:function(a){var b;a.insert(0,this.defaultItems);b=this.getFormPanel().getForm().findField("library_id");if(Ext.isString(this.library.id)){b.setValue(this.defaultTypeToId[this.library.type])}else{b.setValue(this.library.id)}},onOpen:function(){var b=this.getFormPanel().getForm();var a=("edit"===this.mode)?this.folder.preferlang:"enu";var c=("edit"==this.mode)?this.folder.path:"";b.findField("preferlanguage").setValue(a);b.findField("path").setValue(c);SYNO.SDS.VideoStation.FolderDialog.superclass.onOpen.call(this);this.libraryStore.reload()},onRequest:function(){if(!this.getFormPanel().getForm().findField("path").validate()){this.getMsgBox().alert(_VST("videofolder","title"),_VST("videofolder","specify_path"));return}SYNO.SDS.VideoStation.FolderDialog.superclass.onRequest.call(this,"folder_manage.cgi")},onRequestDone:function(a,d,b){this.clearStatusBusy();if(b&&b.success){this.close();this.updateFolderMgr(a)}else{var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),c)}},updateFolderMgr:function(b){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.FolderMgr");var c="/"+b.params.share;if(b.params.subpath){c+="/"+b.params.subpath}a.updateLibraryByPath(b.params.section,b.params.library_id,c,true,true)},getParameter:function(){var b=this.getFormPanel().getForm();var c=b.findField("path").getValue();var a=b.findField("library_id").getValue();var e=SYNO.SDS.VideoStation.Util.getShareData(c);var d={share:e.orishare,subpath:e.subpath,section:this.getValueByLibraryId(a,"type"),preferlang:b.findField("preferlanguage").getValue()};if(a>0){d.library_id=a}if("edit"===this.mode){Ext.apply(d,{old_share:this.folder.share,old_subpath:this.folder.subpath})}return d},getValueByLibraryId:function(c,b){var a=null;this.libraryStore.each(function(d){if(c===d.get("id")){a=d.get(b);return false}});return a},onChooserSelect:function(b,c){if(c&&Ext.isString(c.path)){var a=this.getFormPanel().getForm();a.findField("path").setValue(c.path)}b.close()},onEditPathBtnHandler:function(){var a=new SYNO.SDS.VideoStation.FileChooser({owner:this,title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},onLibrarySelect:function(d,a,c){var b=this.getFormPanel().getForm().findField("preferlanguage");b.setDisabled(a.get("type")===SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID)},isDirty:function(){if(!Ext.isDefined(this.folder)||!Ext.isDefined(this.library)){return false}var d=this.getFormPanel().getForm();var e=d.findField("path").getValue();var b=d.findField("library_id").getValue();var a=d.findField("preferlanguage").getValue();var c=(e!==this.folder.path)||(b!==this.library.id)||(a!==this.folder.preferlang);return c}});Ext.define("SYNO.SDS.VideoStation.LibraryListPanel",{extend:"SYNO.ux.ModuleList",updateScrollBarEventNames:["loadlibrary","afterlayout","resize","expandnode","collapsenode"],constructor:function(a){this.TitleMap={};this.TitleMap[SYNO.SDS.VideoStation.Util._MOVIE_ID]=_VST("type","movie");this.TitleMap[SYNO.SDS.VideoStation.Util._TVSHOW_ID]=_VST("type","tv_show");this.TitleMap[SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID]=_VST("type","home_video");this.TitleMap[SYNO.SDS.VideoStation.Util._TV_RECORDER_ID]=_VST("type","tv_recorder");this.TitleMap[SYNO.SDS.VideoStation.Util._COLLECTION_ID]=_VST("collection","title");this.current_library=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","default_library")||SYNO.SDS.VideoStation.Util._MOVIE_ID;SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.LibraryListPanel",this);SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_addLibrary","_removeLibrary","_goSwitchLibrary"]);this.callParent([this.fillConfig(a)]);this.addClass("syno-vs-listpanel");this.mon(this.getSelectionModel(),"selectionchange",this.onListSelect,this);this.getStore().load()},fillConfig:function(a){var b={cls:"syno-vs-list",listItems:this.getListItems()};return Ext.apply(b,a)},getListItems:function(){var b=[SYNO.SDS.VideoStation.Util._COLLECTION_ID,SYNO.SDS.VideoStation.Util._MOVIE_ID,SYNO.SDS.VideoStation.Util._TVSHOW_ID,SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,SYNO.SDS.VideoStation.Util._TV_RECORDER_ID];if(SYNO.SDS.VideoStation.Util.hideDTVUI()){b.splice(4,1)}var a=[];Ext.each(b,function(d){var c={id:d,type:d,title:this.TitleMap[d]};a.push({text:this.TitleMap[c.type],iconCls:this._getOwner().IconMap[c.type],fn:c.id,library:c,uiProvider:_S("is_admin")&&!_S("demo_mode")?SYNO.SDS.VideoStation.LibraryListTreeNodeUI:null});this._addLibrary(d,c)},this);return a},addLibrary:function(a){var b={text:SYNO.SDS.VideoStation.Util.encodedMsg(a.title),iconCls:"library",fn:a.id,library:a,uiProvider:_S("is_admin")&&!_S("demo_mode")?SYNO.SDS.VideoStation.LibraryListTreeNodeUI:null};this._addLibrary(a.id,a);this.appendModule(b)},clearCustomLibrary:function(){this.store.each(function(a){this.removeModule(a.data.id);this._removeLibrary(a.data.id)},this)},onLibraryLoad:function(){this.store.each(function(a){this.addLibrary(a.data)},this);this.selectDefaultLibrary();this.fireEvent("loadlibrary")},selectDefaultLibrary:function(){if(!this.getNodeById(this.current_library)){this.current_library=SYNO.SDS.VideoStation.Util._MOVIE_ID}this.selectModule(this.current_library)},loadLibrary:function(){this.getStore().load()},getStore:function(){if(this.store){return this.store}var a=new SYNO.SDS.VideoStation.LibraryStore({appWindow:SYNO.SDS.VideoStation.Window,listeners:{scope:this,beforeload:this.clearCustomLibrary,load:this.onLibraryLoad}});this.addManagedComponent(a);return(this.store=a)},onListSelect:function(a,b){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.FilteringBase").abortPreviousRequest();SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").getEl().unmask();var c=b||this.getNodeById(SYNO.SDS.VideoStation.Util._MOVIE_ID);this.current_library=c.id;SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","default_library",this.current_library);this._goSwitchLibrary(c.attributes.library)}});Ext.define("SYNO.SDS.VideoStation.LibraryStore",{extend:"SYNO.API.Store",constructor:function(b){var a={api:"SYNO.VideoStation.Library",method:"list",version:1,reader:new Ext.data.JsonReader({root:"libraries",fields:["id","title","type"]})};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation.LibraryListTreeNodeUI",{extend:"SYNO.ux.ModuleList.TreeNodeUI",base_renderElements:function(e,k,j,l){var b=e.attributes.library.type!==SYNO.SDS.VideoStation.Util._TV_RECORDER_ID&&e.attributes.library.type!==SYNO.SDS.VideoStation.Util._COLLECTION_ID;this.indentMarkup=e.parentNode?e.parentNode.ui.getChildIndent():"";var f=Ext.isBoolean(k.checked),c,d=Ext.isFunction(k.getTpl)?k.getTpl(this,e,k,j,l):['<li class="x-tree-node"><div ext:tree-node-id="',e.id,'" class="x-tree-node-el x-tree-node-leaf x-unselectable ',k.cls,'" unselectable="on">','<span class="x-tree-node-indent">',this.indentMarkup,"</span>",'<img alt="" src="',this.emptyIcon,'" class="x-tree-ec-icon x-tree-elbow" />','<img alt="" src="',k.icon||this.emptyIcon,'" class="x-tree-node-icon',(k.icon?" x-tree-node-inline-icon":""),(k.iconCls?" "+k.iconCls:""),'" unselectable="on" />',f?('<input class="x-tree-node-cb" type="checkbox" '+(k.checked?'checked="checked" />':"/>")):"",'<a hidefocus="on" class="x-tree-node-anchor"',k.href?' href="'+k.href+'"':"",' tabIndex="-1" ',k.hrefTarget?' target="'+k.hrefTarget+'"':"",'><span unselectable="on">',e.text,"</span></a>",b?'<div class="sep"></div><div class="add-video"></div></div>':"</div>",'<ul class="x-tree-node-ct" style="display:none;"></ul>',"</li>"].join("");if(l!==true&&e.nextSibling&&(c=e.nextSibling.ui.getEl())){this.wrap=Ext.DomHelper.insertHtml("beforeBegin",c,d)}else{this.wrap=Ext.DomHelper.insertHtml("beforeEnd",j,d)}this.elNode=this.wrap.childNodes[0];this.ctNode=this.wrap.childNodes[1];var i=this.elNode.childNodes;this.indentNode=i[0];this.ecNode=i[1];this.iconNode=i[2];var h=3;if(f){this.checkbox=i[3];this.checkbox.defaultChecked=this.checkbox.checked;h++}this.anchor=i[h];this.textNode=i[h].firstChild;if(!b){return}h++;this.sepNode=i[h];h++;this.addVideoNode=i[h];var g=Ext.fly(this.addVideoNode);g.on("click",function(n,m,p){var a=new SYNO.SDS.VideoStation.AddVideoDialog({owner:SYNO.SDS.VideoStation.Window,folder:null,library:e.attributes.library,mode:"add"});a.open()},this)}});Ext.define("SYNO.SDS.VideoStation.WelcomeTip",{extend:"Ext.Container",constructor:function(a){this.callParent([this.fillConfig(a)]);this.libListPanel=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.LibraryListPanel");this.libListPanel.getSelectionModel().clearSelections(true)},fillConfig:function(b){var a=[SYNO.SDS.VideoStation.TipNewFun,SYNO.SDS.VideoStation.TipCinemaWorld,SYNO.SDS.VideoStation.TipTVWorld,SYNO.SDS.VideoStation.TipUniqueMoment];var d=0;var e=[];Ext.each(a,function(f,g,h){e.push(new f({itemId:String.format("tip_{0}",d),page:d,finalPage:g===(h.length-1),listeners:{scope:this,gotonext:this.gotoNext,gotoback:this.gotoBack}}));d++},this);this.totalPage=e.length;var c={cls:"syno-vs-welcome-tip",layout:"card",activeItem:"tip_0",items:e};Ext.apply(c,b);return c},gotoNext:function(){var b=this,c=this.getLayout().activeItem.itemId,a=c.replace(/(tip_)(\d)/,function(g,f,d){var e=parseInt(d,10)+1;if(e<b.totalPage){return f+e}return""});if(a.match(/tip_\d/)){this.getLayout().setActiveItem(a)}else{this.getLayout().activeItem.hide();SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","hide_welcome_tip",true);this.hide();this.libListPanel.selectDefaultLibrary()}},gotoBack:function(){var b=this,c=this.getLayout().activeItem.itemId,a=c.replace(/(tip_)(\d)/,function(g,f,d){var e=parseInt(d,10)-1;if(0<=e){return f+e}return""});if(a.match(/tip_\d/)){this.getLayout().setActiveItem(a)}}});Ext.define("SYNO.SDS.VideoStation.TipItemBase",{extend:"Ext.Container",constructor:function(a){this.targetLibListPanel=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.LibraryListPanel");var b={items:[]};Ext.apply(b,a);b.items.push(this.getMessageTip(a));this.callParent([b]);this.on("activate",this.onActivate,this);this.addEvents("gotonext","gotoback")},onActivate:Ext.emptyFn,getMessageTip:function(a){if(!this.messageTip){this.messageTip=new Ext.Container({cls:"message-tip",items:[{cls:"message-title",xtype:"box",html:String.format('<div class="{0}"></div><div class="message-title-text">{1}</div>',a.messageTitleIcon?"message-title-icon "+a.messageTitleIcon:"",SYNO.SDS.VideoStation.Util.encodedMsg(a.messageTitle))},{cls:"sep",xtype:"box"},{cls:"message-desc",xtype:"box",html:SYNO.SDS.VideoStation.Util.encodedMsg(a.messageDesc)},{xtype:"container",cls:"tbar-btn",items:[{xtype:"box",cls:"back-btn",hidden:a.page===0,listeners:{scope:this,afterrender:function(b){var c=b.getEl();c.on("click",function(){this.fireEvent("gotoback")},this)}}},{xtype:"box",cls:a.finalPage?"final-btn":"next-btn",listeners:{scope:this,afterrender:function(b){b.getEl().on("click",function(){this.fireEvent("gotonext")},this)}}}]}]})}return this.messageTip}});Ext.define("SYNO.SDS.VideoStation.TipNewFun",{extend:"SYNO.SDS.VideoStation.TipItemBase",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={messageTitleIcon:null,messageTitle:_VST("tip","new_fun"),messageDesc:_VST("tip","click_add_video"),items:[{xtype:"box",cls:"tip_library_movie",html:String.format('<div class="tip_library_name">{0}</div>',_VST("type","movie"))},{xtype:"box",cls:"tip_arrow"}]};Ext.apply(b,a);return b},onActivate:function(){var c=this.items.items[0].el,a=this.items.items[1].el;var b=this.targetLibListPanel.getNodeById(SYNO.SDS.VideoStation.Util._MOVIE_ID).getUI().getEl();c.anchorTo(b,"c-c",[0,0]);a.anchorTo(c,"tl-tr",[-18,9]);this.messageTip.getEl().alignTo(this.getEl(),"c-c")}});Ext.define("SYNO.SDS.VideoStation.TipCinemaWorld",{extend:"SYNO.SDS.VideoStation.TipItemBase",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={messageTitleIcon:SYNO.SDS.VideoStation.Util._MOVIE_ID,messageTitle:_VST("tip","cinema_world"),messageDesc:_VST("tip","rich_video_metadta"),items:[{xtype:"box",cls:"tip_library_movie",html:String.format('<div class="tip_library_name">{0}</div>',_VST("type","movie"))}]};Ext.apply(b,a);return b},onActivate:function(){var b=this.items.items[0].el;var a=this.targetLibListPanel.getNodeById(SYNO.SDS.VideoStation.Util._MOVIE_ID).getUI().getEl();b.anchorTo(a,"c-c",[0,0]);this.messageTip.getEl().alignTo(this.getEl(),"c-c")}});Ext.define("SYNO.SDS.VideoStation.TipTVWorld",{extend:"SYNO.SDS.VideoStation.TipItemBase",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={messageTitleIcon:SYNO.SDS.VideoStation.Util._TVSHOW_ID,messageTitle:_VST("tip","tv_world"),messageDesc:_VST("tip","find_tvshow_mdtadata"),items:[{xtype:"box",cls:"tip_library_tvshow",html:String.format('<div class="tip_library_name">{0}</div>',_VST("type","tv_show"))}]};Ext.apply(b,a);return b},onActivate:function(){var b=this.items.items[0].el;var d=this.targetLibListPanel.getNodeById(SYNO.SDS.VideoStation.Util._TVSHOW_ID).getUI().getEl();b.anchorTo(d,"c-c",[0,0]);var a=b.getAnchorXY("bl");var c=this.getEl().getXY();this.messageTip.getEl().setXY([c[0]+(this.getWidth()-this.messageTip.getWidth())*0.5,a[1]+40])}});Ext.define("SYNO.SDS.VideoStation.TipUniqueMoment",{extend:"SYNO.SDS.VideoStation.TipItemBase",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={messageTitleIcon:SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,messageTitle:_VST("tip","unique_moment"),messageDesc:_VST("tip","upload_home_video"),items:[{xtype:"box",cls:"tip_library_home_video",html:String.format('<div class="tip_library_name">{0}</div>',_VST("type","home_video"))}]};Ext.apply(b,a);return b},onActivate:function(){var d=this.items.items[0].el;var a=this.targetLibListPanel.getNodeById(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID).getUI().getEl();d.anchorTo(a,"c-c",[0,0]);var c=d.getAnchorXY("bl");var b=this.getEl().getXY();this.messageTip.getEl().setXY([b[0]+(this.getWidth()-this.messageTip.getWidth())*0.5,c[1]+40])}});Ext.define("SYNO.SDS.VideoStation.FilterTypePanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoViewAgain"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FilterTypePanel",this);this.gotoSelectionPanel=a.gotoSelectionPanel;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-list-pane-filter-type",autoFlexcroll:true,items:this.getListView(),listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onActivate:function(){var a=SYNO.SDS.VideoStation.FilterUtil.getFilterTypes();var b=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter("keyword");if(b){a.push({id:"keyword",name:_VST("search","keyword")})}this.getStore().removeAll(true);this.getStore().loadData(a)},onDeactivate:function(){},getListView:function(){if(this.listView){return this.listView}this.listView=new Ext.list.ListView({store:this.getStore(),singleSelect:true,hideHeaders:true,tpl:this.getTpl(),itemSelector:"div.filter-item",cls:"syno-vs-filter-type-listview",columns:[{header:"Type",dataIndex:"name"}],listeners:{scope:this,click:this.onClick}});return this.listView},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({reader:this.reader=new Ext.data.JsonReader({id:"id",fields:["name","id"]}),listeners:{scope:this,load:function(b,a,c){this.updateListViewHeight(b)}}});return this.store},updateListViewHeight:function(b){var a=this.getListView();a.setHeight(b.getCount()*28+10);this.updateScroller()},getTypeName:function(c){var a=c.name;var b=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(c.id);if(b&&0<b.length){if(Ext.isArray(b)){a=a+":"+SYNO.SDS.VideoStation.FilterUtil.getFilterArrayByKey(b,"name").join(",")}else{a=a+":"+b}}return a},enableClick:function(b){var a=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(b.id);if((Ext.isArray(a)||Ext.isString(a))&&0<a.length){return"enable-click"}return""},getTpl:function(){var a=new Ext.XTemplate('<tpl for="rows">','<div class="filter-item-wrapper">','<div class="filter-item">','<div class="filter-icon {[this.enableClick(values)]}">',"</div>",'<div class="filter-text">',"{[this.getTypeName(values)]}","</div>",'<div class="x-clear">',"</div>","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{getTypeName:this.getTypeName.createDelegate(this),enableClick:this.enableClick.createDelegate(this)});return a},isClickingIcon:function(c){var b=c.getTarget();var a=Ext.get(b);if(a&&a.is("div.enable-click")){return true}return false},onClick:function(a,b,g,i){var d=this.getStore().getAt(b).get("id");if("keyword"===d){if(this.isClickingIcon(i)){var h=this._getHistoryInfo();h.status.filter.keyword=undefined;this._gotoViewAgain()}}else{if(!this.isClickingIcon(i)){this.gotoSelectionPanel()}else{var c=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(d);c.splice(0,c.length);i.getTarget().removeClassName("enable-click");var f=Ext.fly(i.getTarget()).parent().child(".filter-text");f.update(this.getStore().getAt(b).get("name"));this._gotoViewAgain()}}},onGetSelectedDatas:function(){return this.getListView().getSelectedRecords()},onGetSelectedData:function(){return this.getListView().getSelectedRecords()[0]}});Ext.define("SYNO.SDS.VideoStation.FilterSelectionPanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FilterSelectionPanel",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-list-pane-filter-selection",autoFlexcroll:true,items:[{xtype:"displayfield",itemId:"name",cls:"filter-type-title"},this.getTextFilter(),this.getListView()],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},getTextFilter:function(){if(this.textFilter){return this.textFilter}this.textFilter=new SYNO.ux.TextFilter({width:210,store:this.getStore(),iconStyle:"filter",localFilter:true,localFilterField:"name",onResize:Ext.emptyFn});return this.textFilter},onActivate:function(){this.filterType=this._getOwner().filterTypePanel.onGetSelectedData().get("id");this.getComponent("name").setValue(this._getOwner().filterTypePanel.onGetSelectedData().get("name"));this.loadStore()},onDeactivate:function(){},loadStore:function(){this.getStore().removeAll();var a=SYNO.SDS.VideoStation.FilterUtil.getFilterDatas(this.filterType);if(Ext.isEmpty(a)){this.getStore().load()}else{this.getStore().loadData(a)}},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({method:"POST",remoteSort:true,proxy:new SYNO.SDS.VideoStation.MetaDataV2HttpProxy({url:this._getWebAPIURL("metadata.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),baseParams:{api:"SYNO.VideoStation.Metadata",method:"list",version:"2"},sortInfo:{field:"name",direction:"ASC"},reader:new Ext.data.JsonReader({fields:["name","value"]}),listeners:{scope:this,beforeload:function(a,b){this._getOwner().getEl().mask();var e=b.params;var c=(SYNO.SDS.VideoStation.Util._TVSHOW_ID===this._getCurType()?SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:this._getCurType());var d=SYNO.SDS.VideoStation.FilterUtil.getFilterCondition(true);delete d[this.filterType];Ext.apply(e,d);Ext.apply(e,{type:c,library_id:Ext.encode([this._getCurLibraryId()]),category:this.filterType,sort_direction:"ASC"})},load:function(b,a,c){this._getOwner().getEl().unmask();this.updateListViewHeight(b)},exception:function(){this._getOwner().getEl().unmask()},datachanged:this.updateListViewHeight}});return this.store},getListView:function(){if(this.listView){return this.listView}this.listView=new Ext.list.ListView({store:this.getStore(),singleSelect:true,hideHeaders:true,tpl:this.getTpl(),itemSelector:"div.filter-item",cls:"syno-vs-filter-selection-listview",columns:[{header:"Type",dataIndex:"name"}],listeners:{scope:this,click:this.onClick}});return this.listView},updateListViewHeight:function(b){var a=this.getListView();a.setHeight(b.getCount()*28+5);this.updateScroller()},onClick:function(b,d,g,i){var f=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(this.filterType);var c=g.down(".filter-icon");var a=this.getStore().getAt(d);if(-1!==c.className.indexOf("enable-click")){c.removeClassName("enable-click");if(Ext.isArray(f)){f=f.filter(function(e){return !SYNO.SDS.VideoStation.FilterUtil.isEqual(e.value,a.get("value"))},this);var h=this._getHistoryInfo(this._getCurId(),1);h.status.filter[this.filterType]=f}}else{c.addClassName("enable-click");if(Ext.isArray(f)){f.push({name:a.get("name"),value:a.get("value")})}}SYNO.SDS.VideoStation.Util._loadFilterBaseStore()},isSelected:function(c){var b=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(this.filterType);var a="";if(!Ext.isArray(b)){return""}Ext.each(b,function(e,d){if(SYNO.SDS.VideoStation.FilterUtil.isEqual(e.value,c.value)){a="enable-click";return false}},this);return a},getTpl:function(){var a=new Ext.XTemplate('<tpl for="rows">','<div class="filter-item-wrapper">','<div class="filter-item">','<div class="filter-icon {[this.isSelected(values)]}">',"</div>",'<div class="filter-text">',"{name}","</div>",'<div class="x-clear">',"</div>","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{isSelected:this.isSelected.createDelegate(this)});return a}});Ext.define("SYNO.SDS.VideoStation.MetaDataV2HttpProxy",{extend:"Ext.data.HttpProxy",constructor:function(a){this.callParent([a])},onRead:function(f,h,b){try{var d=Ext.decode(b.responseText);var a=d.data.metadatas;var c=[];Ext.each(a,function(i){var e=i.name||i;c.push({name:Ext.util.Format.htmlEncode(e),value:i.value||i})},this);d=c;b.responseText=Ext.encode(d);SYNO.SDS.VideoStation.MetaDataV2HttpProxy.superclass.onRead.apply(this,arguments)}catch(g){this.fireEvent("loadexception",this,h,b,g);this.fireEvent("exception",this,"response",f,h,b,g);return}}});Ext.define("SYNO.SDS.VideoStation.FilterCardPanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.filterTypePanel=new SYNO.SDS.VideoStation.FilterTypePanel({itemId:"filterType",gotoSelectionPanel:this.gotoSelectionPanel.createDelegate(this),owner:this});this.filterSelectionPanel=new SYNO.SDS.VideoStation.FilterSelectionPanel({itemId:"filterSelection",owner:this});this.curView="SYNO.SDS.VideoStation.filterTypePanel";var b={cls:"syno-vs-filter-cardpanel",activeItem:0,layout:"card",tbar:this.getTBar(),items:[this.filterTypePanel,this.filterSelectionPanel]};Ext.apply(b,a);return b},onActivate:function(){var a=this._getHistoryInfo();if("all"===this._getCurCategory()){this.setVisible(true);if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===a.view){this.enable();this.gotoTypePanel()}else{this.disable()}}else{this.setVisible(false)}},onDeactivate:function(){},getTBar:function(){if(this.toolBar){return this.toolBar}this.toolBar=new SYNO.ux.Toolbar({cls:"filter-toolbar",items:[{xtype:"displayfield",itemId:"icom",cls:"filter-icon"},{xtype:"displayfield",itemId:"filter",value:_VST("filter","title"),cls:"filter-text"},"->",{itemId:"creatSmartCollection",tooltip:_VST("collection","save_smart_collection"),handler:this.creatSmartCollection.createDelegate(this),cls:"btn-creat-smart-colleciton"},"-",{itemId:"cleanFilter",tooltip:_VST("filter","clean_filter"),handler:this.cleanFilter.createDelegate(this),cls:"btn-clean-filter"},{itemId:"selectionDone",tooltip:_VST("common","done"),handler:this.gotoTypePanel.createDelegate(this),cls:"btn-selection-done"}]});return this.toolBar},getStore:function(){if(this.store){return this.store}},creatSmartCollection:function(){var a=new SYNO.SDS.VideoStation.NewEditCollectionDialog({create:true,smart:true,module:this});a.open()},cleanFilter:function(){if(!this.hasFilterCondition()){return}var a=this._getCurId();var b=this._getHistoryInfo(a,1);if(b){b.status.filter={}}this.gotoTypePanel();SYNO.SDS.VideoStation.Util._loadFilterBaseStore()},gotoSelectionPanel:function(){this.gotoPanelBase("SYNO.SDS.VideoStation.FilterSelectionPanel");this.updateToolBar()},gotoTypePanel:function(){this.gotoPanelBase("SYNO.SDS.VideoStation.FilterTypePanel");this.updateToolBar()},updateToolBar:function(){if(this.curView==="SYNO.SDS.VideoStation.FilterSelectionPanel"){this.toolBar.getComponent("creatSmartCollection").hide();this.toolBar.getComponent("cleanFilter").hide();this.toolBar.getComponent("selectionDone").show()}else{this.toolBar.getComponent("creatSmartCollection").show();this.toolBar.getComponent("cleanFilter").show();this.toolBar.getComponent("selectionDone").hide();if(this.hasFilterCondition()){this.toolBar.getComponent("creatSmartCollection").enable()}else{this.toolBar.getComponent("creatSmartCollection").disable()}}},hasFilterCondition:function(){if(SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter("keyword")){return true}var a=false;Ext.each(SYNO.SDS.VideoStation.FilterUtil.getFilterTypes(),function(c){var b=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter(c.id);if(Ext.isArray(b)&&0<b.length){a=true;return false}},this);return a},gotoPanelBase:function(a){var c=this.layout.activeItem;var b=SYNO.SDS.VideoStation.Window.getPanelScope(a);if(c!==b){this.layout.setActiveItem(b);this.curView=a}else{if(b.onActivate){b.onActivate()}}}});Ext.define("SYNO.SDS.VideoStation.CategoryListPanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.CategoryListPanel",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-listpanel-category",collapsed:true,slideAnchor:"l",items:[this.getCategoryListView(),this.getFilterCardPanel()],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,resize:this.updatePanelHeight,collapse:this.hide}};return Ext.apply(b,a)},updatePanelHeight:function(){var b=this.getCategoryListView(),a=this.getFilterCardPanel();if(a.isVisible()){a.setHeight(this.getHeight()-b.getHeight())}},onActivate:function(){this.filterCardPanel.onActivate();this.categoryListView.onActivate()},onDeactivate:function(){},getSearchField:function(){return this._getOwner().getSearchField()},getCategoryListView:function(){if(this.categoryListView){return this.categoryListView}this.categoryListView=new SYNO.SDS.VideoStation.CategoryListView({owner:this,itemId:"categoryListView"});return this.categoryListView},getFilterCardPanel:function(){if(this.filterCardPanel){return this.filterCardPanel}this.filterCardPanel=new SYNO.SDS.VideoStation.FilterCardPanel({owner:this,itemId:"filterCardPanel"});return this.filterCardPanel}});Ext.define("SYNO.SDS.VideoStation.CategoryListView",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoHomePage","_gotoFilterView","_getCurCategory","_getCurLibraryTitle"]);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-category-listview",tbar:this.getTBar(),items:this.getListView(),listeners:{scope:this,afterrender:this.onAfterRender}};return Ext.apply(b,a)},getTBar:function(){if(this.toolBar){return this.toolBar}this.toolBar=new SYNO.ux.Toolbar({cls:"syno-vs-category-toolbar",items:[{xtype:"displayfield",itemId:"gotoHomePage",cls:"syno-vs-filter-arrow"},{xtype:"displayfield",itemId:"libraryIcon",cls:"library-icon"},{xtype:"displayfield",itemId:"libraryName",cls:"library-name"}]});return this.toolBar},onAfterRender:function(){var a=this.toolBar.getEl();a.addClassOnOver("syno-vs-category-toolbar-over");a.addClassOnClick("syno-vs-category-toolbar-click");a.addListener("click",this._gotoHomePage,this)},getListView:function(){if(this.listView){return this.listView}this.listView=new Ext.list.ListView({store:this.getStore(),tpl:this.getTpl(),itemSelector:"div.list-item",singleSelect:true,hideHeaders:true,columns:[{header:"category",dataIndex:"category"}],listeners:{scope:this,selectionchange:this.onSelectionchange}});return this.listView},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.JsonStore({fields:[{name:"name",type:"string"},{name:"category",type:"string"}],listeners:{scope:this,load:function(){this.owner.updatePanelHeight()}}});return this.store},onActivate:function(){this.getStore().removeAll(true);this.getStore().loadData(this.getCategorys());var a=this._getCurCategory();this.getStore().each(function(c){if(a===c.get("category")){this.listView.select(c);return false}},this);var b=Ext.isNumber(this._getCurId())?"library":this._getOwner()._getOwner().IconMap[this._getCurId()];this.toolBar.getComponent("libraryName").setValue(SYNO.SDS.VideoStation.Util.encodedMsg(this._getCurLibraryTitle()));this.toolBar.getComponent("libraryIcon").removeClass(["movie","tvshow","homevideo","tvrecord","collection","library"]);this.toolBar.getComponent("libraryIcon").addClass(b)},getCategorys:function(){var b=[];var a=this._getCurType();if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a){b=[{category:"all",name:_VST("classification","all")},{category:"recently_added",name:_VST("classification","recently_added")},{category:"recently_watched",name:_VST("classification","recently_watched")}]}else{b=[{category:"all",name:_VST("classification","all")},{category:"folder",name:_VST("classification","folder")},{category:"recently_added",name:_VST("classification","recently_added")},{category:"recently_released",name:SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===a?_VST("classification","recently_recoded"):_VST("classification","recently_released")},{category:"recently_watched",name:_VST("classification","recently_watched")}]}return b},onSelectionchange:function(b,d){var f=b.getSelectedRecords()[0];if(!f){var a=this._getCurCategory();this.getStore().each(function(g){if(a===g.get("category")){this.listView.select(g);return false}},this);return}if(f.get("category")===this._getCurCategory()){return}var c=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter();var e=f.get("category");this._gotoHomePage({isFireEvent:false});this._gotoFilterView({params:{name:_VST("classification",e),category:e},status:{filter:c}})},getTpl:function(){var a=new Ext.XTemplate('<tpl for="rows">','<div class="list-item-wrapper">','<div class="list-item">','<div class="list-item-icon {[values.category]}">',"</div>",'<div class="list-item-name" ext:qtip="{[this.encodedMsg(values.name)]}">',"{values.name}","</div>",'<div class="x-clear">',"</div>","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{encodedMsg:function(b){if(b){return Ext.util.Format.htmlEncode(b)}return""}});return a}});Ext.define("SYNO.SDS.VideoStation.SearchField",{extend:"SYNO.ux.TextFilter",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoHomePage","_gotoFilterView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.SearchField",this);this.callParent([this.fillConfig(a)]);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoToPanel",this.eventGoToPanel,this)},fillConfig:function(a){var b={emptyText:_VST("search","keyword"),enableKeyEvents:true,width:212,listeners:{scope:this,keypress:this.onSearchFieldKeyDown}};Ext.apply(b,a);return b},onSearchFieldKeyDown:function(e,b){if(b.getKey()!==Ext.EventObject.ENTER){return}var c=e.getValue().trim();if(!c){return}if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===this._getCurType()){return}var a=SYNO.SDS.VideoStation.FilterUtil.getHistoryFilter();a.keyword=c;var d=this._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE!==d.view){this._gotoHomePage({isFireEvent:false})}this._gotoFilterView({params:{name:_VST("classification","all"),category:"all"},status:{filter:a}})},eventGoToPanel:function(){this.setValue("");if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===this._getCurType()){this.disable()}else{this.enable()}}});Ext.define("SYNO.SDS.VideoStation.MainListPanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)]);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoToPanel",this.eventGoToPanel,this)},fillConfig:function(a){this.IconMap={};this.IconMap[SYNO.SDS.VideoStation.Util._MOVIE_ID]="movie";this.IconMap[SYNO.SDS.VideoStation.Util._TVSHOW_ID]="tvshow";this.IconMap[SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID]="homevideo";this.IconMap[SYNO.SDS.VideoStation.Util._TV_RECORDER_ID]="tvrecord";this.IconMap[SYNO.SDS.VideoStation.Util._COLLECTION_ID]="collection";this.libraryListPanel=new SYNO.SDS.VideoStation.LibraryListPanel({owner:this,itemId:"libraryList",baseCls:"vs-x-panel",style:"z-index: 1",x:0,y:0,anchor:"100% 100%"});this.categoryListPanel=new SYNO.SDS.VideoStation.CategoryListPanel({owner:this,itemId:"categoryList",baseCls:"vs-x-panel",style:"z-index: 2",x:0,y:0,anchor:"100% 100%"});var b={forceLayout:true,activeItem:0,layout:"absolute",cls:"syno-vs-main-list-panel",tbar:{items:[this.getSearchField()]},items:[this.libraryListPanel,this.categoryListPanel]};Ext.apply(b,a);return b},getSearchField:function(){return new SYNO.SDS.VideoStation.SearchField()},eventGoToPanel:function(){var a=this._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===a.view||SYNO.SDS.VideoStation.Util._VIEW_GRID===a.view||SYNO.SDS.VideoStation.Util._VIEW_COLLECTION===a.view||SYNO.SDS.VideoStation.Util._COLLECTION_ID===this._getCurType()){this.categoryListPanel.collapse()}else{this.categoryListPanel.show();this.categoryListPanel.expand();this.categoryListPanel.onActivate()}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.TVseasonHttpProxy=Ext.extend(Ext.data.HttpProxy,{onRead:function(f,c,g){try{var a=Ext.decode(g.responseText);var h=a.data;var j={};var b=0;Ext.each(h.episodes,function(e){var l=e.season;l=l>0?l:-1;if(!j[l]){j[l]=[]}j[l].push(e);if(b<e.last_watched){b=e.last_watched}},this);a.newdata=[];for(var k in j){if(j.hasOwnProperty(k)){a.newdata.push({season:k,episodes:j[k]})}}a.newdata.sort(function(n,m){var l=parseInt(n.season,10);var e=parseInt(m.season,10);if(l<=0){return 1}else{if(e<=0){return -1}}return(l-e)});Ext.each(a.newdata,function(e){e.episodes.sort(function(o,m){var n=parseInt(o.episode,10);var l=parseInt(m.episode,10);if(n<=0){return 1}else{if(l<=0){return -1}}return(n-l)})});Ext.each(a.newdata,function(e){Ext.each(e.episodes,function(l){if(0<b&&b===l.last_watched){l.max_last_watched=true}if(!l.additional||!l.additional.collection){return}var m=l.additional.collection;var n=[];Ext.each(m,function(p){var q=parseInt(p.id,10);var o=p.title;if("syno_favorite"===o){q=-1}else{if("syno_watchlist"===o){q=-2}}n.push({id:q,title:o})},this);l.additional.collection=n})});if(a.newdata.length>0){var d=SYNO.SDS.VideoStation.Util._getHistoryInfo();a.newdata.splice(0,0,{season:-10,episodes:[{season:-10,title:d.params.name||"",original_available:d.params.original_available||"",additional:{summary:d.params.summary||""}}]})}g.responseText=Ext.encode(a);SYNO.SDS.VideoStation.TVseasonHttpProxy.superclass.onRead.apply(this,arguments)}catch(i){this.fireEvent("loadexception",this,c,g,i);this.fireEvent("exception",this,"response",f,c,g,i);return}}});Ext.define("SYNO.SDS.VideoStation.ViewTVseason",{extend:"SYNO.ux.Panel",constructor:function(a){this.updateScrollBarEventNames.push("load");this.addEvents("load");SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoDetileView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewTVseason",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={border:false,cls:"syno-vs-episode-panel",layout:"fit",autoFlexcroll:true,items:[],listeners:{activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({proxy:new SYNO.SDS.VideoStation.TVseasonHttpProxy({url:this._getWebAPIURL("tvshow_episode.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),method:"POST",baseParams:{api:"SYNO.VideoStation.TVShowEpisode",method:"list",version:"2"},reader:new Ext.data.JsonReader({id:"season",root:"newdata",totalProperty:"data.total",fields:["season","episodes"]}),listeners:{scope:this,beforeload:function(){this._getOwner()._getOwner().setStatusBusy();this.removeAll()},load:this.onAfterLoadStore,exception:function(){this._getOwner()._getOwner().clearStatusBusy()}}});return this.store},onAfterLoadStore:function(b,c){this._getOwner()._getOwner().clearStatusBusy();if(0===c.length){this._gobackPanel()}var a=this.collapsedseasons||[];Ext.each(c,function(e){var d=(a.indexOf(parseInt(e.id,10))!==-1);if(e.id===-10){this.add(this.createTVShowSummary(e.data,d))}else{this.add(this.createSeason(e.data,d))}return true},this);this.doLayout();this.fireEvent("load")},createTVShowSummary:function(c,f){var e=c.episodes[0].title;var b=new SYNO.SDS.VideoStation.EpisodePanel({module:this,season:-10});b.loadEpisodes(c);var d=this.getSeasonDesc(c);var a=new SYNO.ux.FieldSet({title:e,style:"width: 100%;",layout:"fit",autoHeight:true,collapsible:true,listeners:{afterlayout:{single:true,fn:function(h){var g=h.getEl().child("legend");Ext.DomHelper.insertFirst(g,{tag:"div",cls:"summary-header",html:d})}}},items:[b]});return a},createSeason:function(d,g){var f="";var c=parseInt(d.season,10);if(c>0){f=String.format(_VST("season","title"),c)}else{f=_VST("classification","other")}var b=new SYNO.SDS.VideoStation.EpisodePanel({module:this,season:c});b.loadEpisodes(d);var e=this.getSeasonDesc(d);var a=new SYNO.ux.FieldSet({title:f,style:"width: 100%;",layout:"fit",autoHeight:true,collapsible:true,listeners:{afterlayout:{single:true,fn:function(i){var h=i.getEl().child("legend");Ext.DomHelper.insertFirst(h,{tag:"div",cls:"season-header",html:e})}}},items:[b]});return a},getSeasonDesc:function(b){if(-10===b.season){var c="",a=b.episodes[0].original_available;if(a&&a!=="0"){c=a;c+=", "}c+=String.format(_VST("season","number"),this.getStore().getCount()-1);return c}return String.format(_VST("episode","number"),b.episodes.length)},selectEpisode:function(d,b,a){if(a){Ext.each(this.getSeasons(),function(e){e.clearSelections()})}var c=this.getSeasons(d);if(c.length>0&&c[0]){c[0].select(b,!a)}},getSeasons:function(b){var a=this.findBy(function(c){var e=Ext.isString(c.itemSelector)&&Ext.isNumber(c.season)&&c.season!==-10;var d=!Ext.isNumber(b)||c.season===b;return e&&d});return a},onGotoNext:function(b){var a=_VST("classification","other");if(b.episode){a=String.format(_VST("episode","title")+" - {1}",b.episode,b.title)}this._gotoDetileView({params:{id:b.id,name:a,poster_mtime:b.additional?b.additional.poster_mtime||"":""},status:{}})},onActivate:function(){var b=this._getHistoryInfo();var a=b.status;if(a.tvshow_id!==b.id){b.status.tvshow_id=undefined;this.collapsedseasons=undefined}this.onLoadStore()},onDeactivate:function(){this.collapsedseasons=SYNO.Util.copy(this.getCollapsedSeasons())},getCollapsedSeasons:function(){var a=[];this.items.each(function(b){if(b.collapsed){a.push(b.items.items[0].season)}});return a},hasSeasons:function(){var a=this.getStore().getCount();return !(0===a||(1===a&&this.getStore().data.first().data.season<=0))},checkFieldSetStatus:function(b){var a=false;this.items.each(function(c){if(c.collapsed===b){a=true;return false}});return a},isOneExpandSeason:function(){return this.checkFieldSetStatus(false)},isOneCollapseSeason:function(){return this.checkFieldSetStatus(true)},onExpandCollapseSeasons:function(a){this.items.each(function(b){b[a?"expand":"collapse"](false)})},onLoadStore:function(){var a=this._getCurCategory();var b=this._getHistoryInfo();var c={library_id:this._getCurLibraryId(),tvshow_id:b.params.id,additional:Ext.encode(["summary","collection","poster_mtime","watched_ratio"])};if("all"===a){Ext.apply(c,SYNO.SDS.VideoStation.FilterUtil.getFilterCondition(true))}this.getStore().load({params:c});Ext.apply(this._getHistoryInfo().status,{tvshow_id:b.id})},onGetSelectedDatas:function(){var a=[];Ext.each(this.getSeasons(),function(b){a.push.apply(a,b.getSelectedRecords())});return a},onGetSelectedData:function(){var a=null;Ext.each(this.getSeasons(),function(b){if(b.getSelectionCount()>0){a=b.getSelectedRecords()[0];return false}});return a},getSelectionCount:function(){var a=0;Ext.each(this.getSeasons(),function(b){a+=b.getSelectionCount()});return a},clearSelections:function(){Ext.each(this.getSeasons(),function(a){a.clearSelections()})}});Ext.define("SYNO.SDS.VideoStation.EpisodePanel",{extend:"SYNO.ux.Panel",constructor:function(b){this.dataview=new SYNO.SDS.VideoStation.EpisodeView({module:b.module,season:b.season,store:this.getStore()});var a={cls:"episode-panel",items:this.dataview};this.callParent([Ext.apply(a,b)])},loadEpisodes:function(a){this.getStore().loadData(a)},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({reader:new Ext.data.JsonReader({root:"episodes",fields:["id","additional","episode","season","tagline","title","tvshow_id","tvshow_mapper_id","tvshow_original_available","max_last_watched"]})});return this.store}});Ext.define("SYNO.SDS.VideoStation.EpisodeView",{extend:"Ext.DataView",summarylength:230,constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);this.season=b.season;var a={module:b.module,cls:"syno-vs-dataview-episode",itemSelector:"div.syno-vs-data-template",overClass:"syno-vs-data-item-over",trackOver:false,hideHeaders:true,multiSelect:true,listeners:{scope:this,beforeclick:function(c,d,f,g){var h=SYNO.SDS.VideoStation.Util.getSelectionMode();if(this.season===-10){return false}if(g.ctrlKey||h){if(this.isSelected(f)){this.deselect(f)}else{this.addThisSelection(d)}}else{if(this.isClickingIcon(g)){this.gotoDetail(f)}else{this.singleSelectThis(d)}}return false},selectionchange:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").fireEvent("afterSelectionChange")},contextmenu:function(c,d,f,g){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").showActionMenu(c,d,f,g)}},tpl:this.getTpl()};this.callParent([Ext.apply(a,b)])},isClickingIcon:function(c){var b=c.getTarget();var a=Ext.get(b);if(a&&a.is("div.syno-vs-data-icon")){return true}return false},gotoDetail:function(a){this.module.onGotoNext(this.getRecord(a).data)},singleSelectThis:function(a){this.module.selectEpisode(this.season,a,true)},addThisSelection:function(a){this.module.selectEpisode(this.season,a,false)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="syno-vs-data-template {[this.getEpisodeCls(values)]}">','<div class="data-container">','<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout syno-vs-data-template-table">',"<tbody><tr>",'<td class="x-table-layout-cell">',"{[this.getIcon(values)]}","{[this.getWatchStatusTag(values)]}","{[this.getWatchStatusBar(values)]}","</td>",'<td class="x-table-layout-cell" valign="top">','<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout"><tbody>',"{[this.getTitleRow(values)]}","{[this.getDescRow(values)]}","<tr>",'<td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-summary" valign="top">',"<div><span>","{[this.getSummary(values)]}","</span></div>","</td>","</tr>","</tbody></table>","</td>","</tr></tbody>","</table>","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{compiled:true,disableFormats:true,getEpisodeCls:this.getEpisodeCls.createDelegate(this),getTitleRow:this.getTitleRow.createDelegate(this),getDescRow:this.getDescRow.createDelegate(this),getIcon:this.getIcon.createDelegate(this),getSummary:this.getSummary.createDelegate(this),getWatchStatusTag:this.getWatchStatusTag.createDelegate(this),getWatchStatusBar:this.getWatchStatusBar.createDelegate(this)})},getEpisodeCls:function(a){if(-10===a.season){return"syno-vs-type-tv-season-main"}else{return"syno-vs-type-episode"}},getTitleRow:function(a){if(a.season===-10){return""}return["<tr>",'<td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-name" valign="top">','<div class="syno-vs-data-title">',"<span>"+this.getEpisodeTitle(a)+"</span>","</div>","</tr>"].join("")},getEpisodeTitle:function(b,a){if(b.episode===0){var c=_VST("classification","other");return a?c:"<i>"+c+"</i>"}return String.format(_VST("episode","title"),b.episode)},getDescRow:function(a){if(-10===a.season){return""}var b=this.getDesc(a,false);return["<tr>",'<td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-desc" valign="top">',"<div><span>",b,"</span></div>","</td>","</tr>"].join("")},getDesc:function(b,a){if(!b.tagline){return"&nbsp;"}return this.encodedMsg("- "+b.tagline,a)},getIcon:function(d){var a="screenshot";if(d.season===-10){a="poster"}var f=this.getImageURL(d);var e=String.format("filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",f);var c=String.format("background-image: url('{0}')",f);var b=String.format('style="{0};"',(Ext.isIE8||Ext.isIE7)?e:c);return'<div class="syno-vs-data-icon '+a+'" '+b+"></div>"},getImageURL:function(b){var a=SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID;var c=b.id;if(-10===b.season){a="tvshow";c=this._getHistoryInfo().params.id}return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a,id:c,mtime:b.additional?b.additional.poster_mtime||"":""})},getSummary:function(a){var b=SYNO.SDS.VideoStation.Util.getAddtionalText(a,"summary");if(-10===a.season){return b}else{return b.substr(0,this.summarylength)}},getWatchStatusTag:function(b){if(-10===b.season){return""}if(b.max_last_watched&&true===b.max_last_watched){return'<div class="last-watched-tag"></div>'}var a=b.additional?b.additional.watched_ratio||0:0;a=(0===a?0:Math.floor(a*100));if(0===a){return'<div class="unwatch-status-tag"></div>'}return""},getWatchStatusBar:function(a){if(-10===a.season){return""}return SYNO.SDS.VideoStation.Util.getWatchStatusDiv(a)},encodedMsg:function(b,a){return SYNO.SDS.VideoStation.Util.encodedMsg(b,a)}});Ext.define("SYNO.SDS.VideoStation.ViewMetaData",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewMetaData",this);SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_updatePathBar","_onRequestCollectionNoMesg","_getCollectionMenuItems","_gotoHomePage","_gotoFilterView"]);this.callParent([this.fillConfig(a)]);this.addManagedComponent(this.getStore());this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"afterLoadCollection",this.eventLoadCollection,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"afterAddDeleteVideoToCollection",this.eventAddDeleteVideoToCollection,this)},fillConfig:function(a){var b={cls:"syno-vs-meta-panel",layout:"border",items:[{cls:"syno-vs-meta-container",xtype:"syno_panel",region:"center",itemId:"container",layout:"border",items:[this.getImageBox(),this.getMetaForm()]},this.getFileGrid()],listeners:{buffer:80,activate:function(){this.onActivate()},deactivate:this.onDeactivate}};Ext.apply(b,a);return b},getImageContainer:function(){if(this.imageInnerContainer){return this.imageInnerContainer}this.playBtn=new Ext.Container({cls:"play",border:false,overCls:"over",listeners:{scope:this,afterrender:function(){var a=this.playBtn.getEl();a.addClassOnClick("click");this.mon(a,"click",this.playVideo.createDelegate(this,[]),this)}},html:""});this.imageInnerContainer=new Ext.Container({cls:"syno-vs-meta-image",border:false,items:[this.playBtn,{xtype:"container",cls:"watch-status-wrap",itemId:"watch-status-wrap",items:[{xtype:"container",cls:"watch-status-background"},{xtype:"container",cls:"watch-status",itemId:"watch-status"}]}]});return this.imageInnerContainer},getImageBox:function(){return new Ext.Container({cls:"image-box",border:false,region:"west",items:[this.getImageContainer(),{xtype:"container",layout:"hbox",layoutConfig:{type:"hbox",align:"stretchmax",pack:"start"},cls:"syno-vs-collect-rate-container",items:[this.getCollectionToolbar()]}]})},getCollectionToolbar:function(){if(this.collection_tb){return this.collection_tb}this.collection_tb=new SYNO.ux.Toolbar({height:24,width:120,cls:"collection-action-bar",defaultType:"syno_button",defaults:{scope:this},items:[{cls:"favorite",itemId:"add_favorite",tooltip:_VST("action","add_favorite"),handler:this.onAddFavoite},{cls:"favorite remove",itemId:"remove_favorite",tooltip:_VST("action","remove_favorite"),handler:this.onRemoveFavoite,hidden:true},{cls:"watchlist",itemId:"add_watchlist",tooltip:_VST("action","add_watch_list"),handler:this.onAddWatchList},{cls:"watchlist remove",itemId:"remove_watchlist",tooltip:_VST("action","remove_watch_list"),hidden:true,handler:this.onRemoveWatchList},{cls:"userdefine",itemId:"collections",tooltip:_VST("collection","user_define_collection"),menu:this.getUserDefineMenu(),getMenuClass:Ext.emptyFn,hideMode:"visibility"},{cls:"share-to-public",itemId:"share_to_public",tooltip:_VST("collection","share_to_public"),handler:this.onSharePublic}]});this.add_favorite=this.collection_tb.getComponent("add_favorite");this.remove_favorite=this.collection_tb.getComponent("remove_favorite");this.add_watchlist=this.collection_tb.getComponent("add_watchlist");this.remove_watchlist=this.collection_tb.getComponent("remove_watchlist");this.user_define_collections=this.collection_tb.getComponent("collections");this.share_to_public=this.collection_tb.getComponent("share_to_public");return this.collection_tb},getMetaForm:function(){if(this.form){return this.form}this.form=new SYNO.ux.FormPanel({cls:"syno-vs-meta-form",border:false,region:"center",autoFlexcroll:true,labelWidth:150,layoutConfig:{labelSeparator:""},labelSeparator:"",items:[{border:false,layout:{type:"table",columns:2},items:[{cellCls:"syno-vs-meta-title",hideLabel:true,itemId:"title",xtype:"displayfield",value:"&nbsp;"},{cellCls:"syno-vs-unwatched",itemId:"unwatched",xtype:"displayfield",value:_VST("advanced","unwatched")}]},this.getRater(),{itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel"),xtype:"displayfield",hidden:true},{itemId:"play_time",name:"play_time",fieldLabel:_VST("metadata","play_time"),xtype:"displayfield",hidden:true},{itemId:"record_date",name:"record_date",fieldLabel:_VST("video_info","record_time"),xtype:"displayfield",hidden:true},{itemId:"genre",name:"genre",fieldLabel:_VST("genre","title"),xtype:"displayfield"},{itemId:"season",name:"season",fieldLabel:_VST("season","season_title"),xtype:"displayfield",hidden:true},{itemId:"episode",name:"episode",fieldLabel:_VST("episode","episode_title"),xtype:"displayfield",hidden:true},{itemId:"original_available",name:"original_available",fieldLabel:_VST("original_available","title"),xtype:"displayfield"},{itemId:"duration",name:"duration",fieldLabel:_VST("duration","title"),xtype:"displayfield",hidden:true},{itemId:"certificate",name:"certificate",fieldLabel:_VST("metadata","rating_classification"),xtype:"displayfield",hidden:true},{itemId:"actor",name:"actor",fieldLabel:_VST("actor","title"),xtype:"displayfield"},{itemId:"writer",name:"writer",fieldLabel:_VST("writer","title"),xtype:"displayfield"},{itemId:"director",name:"director",fieldLabel:_VST("director","title"),xtype:"displayfield"},this.imdb=new Ext.form.DisplayField({itemId:"imdb",name:"imdb",fieldLabel:_VST("imdb","reference"),cls:"syno-vs-data-imdb",overCls:"syno-vs-data-over"}),{itemId:"summary",name:"summary",hideLabel:true,xtype:"displayfield",cls:"syno-vs-data-summary"}]});return this.form},getFileGrid:function(){if(this.grid){return this.grid}this.grid=new SYNO.ux.GridPanel({border:false,cls:"syno-vs-grid syno-vs-file-grid",minSize:75,maxSize:200,autoExpandColumn:"path",minColumnWidth:100,height:120,region:"south",ds:this.getStore(),cm:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({single:true}),viewConfig:{scrollDelay:false,rowHeight:36,borderHeight:0,cacheSize:50,forceFit:false},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,mouseover:function(b){var a=b.getTarget("div.syno-vs-action-play",2,true);if(a){a.addClass("syno-vs-action-over")}},mouseout:function(b){var a=b.getTarget("div.syno-vs-action-play",2,true);if(a){a.removeClass("syno-vs-action-over")}},mousedown:{scope:this,buffer:100,fn:function(c){var b=c.getTarget("div.syno-vs-action-play",2,true);if(b){b.addClass("syno-vs-action-click");var h=Ext.getDoc(),a=function(){b.removeClass("syno-vs-action-click");h.removeListener("mouseup",a)};h.on("mouseup",a);var g=b.findParent("div.x-grid3-row",11);if(g&&Ext.isNumber(g.rowIndex)){var i=this.grid.getSelectionModel();if(!i.isSelected(g.rowIndex)||c.hasModifier()){i.handleMouseDown(this.grid,g.rowIndex,c)}var f=this.grid.store.getAt(g.rowIndex);if(f){this.onPlayAction(f.data)}}}}},rowcontextmenu:function(a,d,b){b.preventDefault();var c=a.getSelectionModel();if(!c.isSelected(d)){c.selectRow(d)}this.getGirdCtxMenu().showAt(b.getXY())}}});return this.grid},getRater:function(){if(this.rater){return this.rater}this.rater=new Ext.ux.form.Rater({fieldLabel:_VST("metadata","rating_score"),animate:false,unit:24,name:"rating",maxValue:5});return this.rater},getUserDefineMenu:function(a){if(this.collectionMenu){this.collectionMenu.destroy()}if(!this.collectionMenu||a){this.collectionMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[],listeners:{scope:this,beforeshow:this.onUpdateCollectionMenu}});this.addManagedComponent(this.collectionMenu)}return this.collectionMenu},updateCollectionsMenuitems:function(){this.collectionMenu.removeAll(true);Ext.each(this._getCollectionMenuItems(false,this),function(c,a,b){this.collectionMenu.addItem(c)},this)},onSetCollectionMenuToDefault:function(){Ext.each(this.collectionMenu.items.items,function(a,b,c){if("creat_collection_list"!==a.itemId&&"sep_newcollection"!==a.itemId){if(0<a.itemId.indexOf("_remove_")&&0>a.itemId.indexOf("_add_")){a.hide()}else{a.show()}}},this)},onSetCollectionMenuIcon:function(b,a){Ext.each(this.collectionMenu.items.items,function(e,c,d){var g,f=null;g=e.itemId.indexOf("_add");if(-1!==g){f=parseInt(e.itemId.substring(0,g),10)}if(f===b){if(a){e.hide()}else{e.show()}}f=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(e.itemId,"_remove");g=e.itemId.indexOf("_remove");if(-1!==g){f=parseInt(e.itemId.substring(0,g),10)}if(f===b){if(a){e.show()}else{e.hide()}}},this)},onUpdateCollectionMenu:function(a){this.onShowHideCollection()},onShowHideCollection:function(){this.onSetCollectionMenuToDefault();Ext.each(this.currentAddCollection,function(a){this.onSetCollectionMenuIcon(a.id,true)},this)},getGirdCtxMenu:function(){if(this.gridCtxMenu){return this.gridCtxMenu}var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ActionMenu");var b=[];b=b.concat(a.getMetaActionGroup().getArray());b.push(new Ext.menu.Separator({itemId:"sep_meta"}));b=b.concat(a.getPlayViewActionGroup().getArray());return(this.gridCtxMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:b,listeners:{scope:this,beforeshow:this.onUpdateMenu}}))},onUpdateMenu:function(b){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ActionMenu");if(_S("is_admin")){a.getMetaActionGroup().get("edit_metadata").hide();a.getMetaActionGroup().get("correct_metadata").show()}a.getPlayViewActionGroup().showAll();a.onUpdateSepItem(b)},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.JsonStore({autoLoad:false,idProperty:"id",fields:[{name:"id"},{name:"path"},{name:"sharepath",sortType:function(a){if(!a){return""}var b=SYNO.SDS.VideoStation.Util.parseFullPathToFileName(a);return b.toLowerCase()}},{name:"duration",sortType:function(a){if(!a){return 0}var b=a.split(":",3);return parseInt(b[0],10)*10000+parseInt(b[1],10)*100+parseInt(b[2],10)}},{name:"filesize",type:"int"},{name:"resolutionx"},{name:"resolutiony"},{name:"container_type"},{name:"video_codec"},{name:"audio_codec"},{name:"frame_bitrate"}],data:[],listeners:{scope:this,load:function(){if(this.grid&&!this.grid.getSelectionModel().getSelected()){this.grid.getSelectionModel().selectRow(0)}}}}))},getColumnModel:function(){if(this.colmodel){return this.colmodel}this.colmodel=new Ext.grid.ColumnModel({defaults:{align:"left"},columns:[{id:"path",header:_T("common","name"),dataIndex:"sharepath",sortable:true,renderer:(function(h,f,a,e,g,b){var d=SYNO.SDS.VideoStation.Util.parseFullPathToFileName(h);var c=Ext.util.Format.htmlEncode(d);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(h))+'"';return c}).createDelegate(this)},{header:_VST("duration","title"),dataIndex:"duration",sortable:true,width:120,renderer:(function(g,e,a,d,f,b){var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_T("common","size"),dataIndex:"filesize",sortable:true,width:120,renderer:(function(g,e,a,d,f,b){if(Ext.isEmpty(g)){return""}g=Ext.util.Format.fileSize(g);var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{xtype:"actioncolumn",header:_VST("action","start"),dataIndex:"id",align:"center",width:100,sortable:false,getClass:function(){return"play"},handler:(function(b,c,a){var d=this.grid.getSelectionModel();d.selectRow(c);this.onPlayAction(d.getSelected().data,"streaming")}).createDelegate(this)}]});return this.colmodel},onActivate:function(){this.onLoadData(false);this.loadPlayer();this.updatePublicSharing()},onDeactivate:function(){if(this.ajaxTask){this.ajaxTask.remove()}this.setPlayerBtnVisibility(false)},getAPIParams:function(a){return SYNO.SDS.VideoStation.Util.getinfo_WebAPI(a)},getArrname:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return"movies";case SYNO.SDS.VideoStation.Util._TVSHOW_ID:return"episodes";case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return"videos";case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:return"recordings";case SYNO.SDS.VideoStation.Util._COLLECTION_ID:return"collections";default:return""}},encodedMsg:function(d,b){var c="";if(Ext.isArray(d)){for(var a=0;a<d.length;a++){if(a>0){c+="</span>, "}c+="<span>";c+=SYNO.SDS.VideoStation.Util.encodedMsg(d[a],b)}c+="</span>";return c}return SYNO.SDS.VideoStation.Util.encodedMsg(d,b)},onLoadData:function(c){this._getOwner().setStatusBusy();this.setImage();this.rater.hide();this.imdb.hide();this.form.getForm().reset();this.getStore().removeAll(true);this.form.getForm().findField("duration").hide();this.form.getForm().findField("season").hide();this.form.getForm().findField("episode").hide();if(this.playBtn){this.playBtn.hide()}this.grid.getView().updateHeaders();this.getStore().sortInfo={field:"sharepath",direction:"ASC"};this.setFieldValue("title","");this.setFieldValue("channel_name","");this.setFieldValue("original_available","");this.setFieldValue("summary","");this.setFieldValue("certificate","");this.setFieldValue("actor","");this.setFieldValue("writer","");this.setFieldValue("director","");this.setFieldValue("duration","");this.setFieldValue("genre","");this.setFieldValue("season","");this.setFieldValue("episode","");this.add_favorite.hide();this.add_watchlist.hide();this.remove_favorite.hide();this.remove_watchlist.hide();this.user_define_collections.hide();this.user_define_collections.removeClass("activate");this.form.getForm().findField("unwatched").hide();this.imageInnerContainer.getComponent("watch-status-wrap").hide();this.currentAddCollection=[];var b=this._getHistoryInfo();var a=this._getSelectedVideoType();this.ajaxTask=this.addAjaxTask({single:true,autoJsonDecode:true,url:this.getCgiURL(),method:"POST",params:Ext.apply({id:b.params.id,additional:Ext.encode(["summary","file","actor","writer","director","extra","genre","collection","poster_mtime","watched_ratio"])},this.getAPIParams(a)),scope:this,callback:function(e,n,h){if(this.isDestroyed){return}var k=false,d;this.watched_ratio=0;if(h&&h.success&&h.data&&!Ext.isEmpty((d=h.data[this.getArrname(this.getCurType())]))){var i=d[0];this.user_define_collections.show();if(i){var l;if(!Ext.isEmpty(i.title)&&!Ext.isEmpty(i.tagline)){l=i.title+" - "+i.tagline}else{if(!Ext.isEmpty(i.tagline)){l=i.tagline}else{l=i.title}}var g=this._getHistoryInfo();if(g.params.name){g.params.name=i.title;if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_ID){g.params.name=_VST("classification","other");if(i.episode){g.params.name=String.format(_VST("episode","title"),i.episode);if(i.tagline){g.params.name=g.params.name+" - "+i.tagline}}}this._updatePathBar()}this.setFieldValue("title",this.encodedMsg(l));this.setFieldValue("original_available",i.original_available==="0"?"":i.original_available,1);this.setFieldValue("certificate",this.encodedMsg(i.certificate));if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_ID){this.form.getForm().findField("season").show();this.form.getForm().findField("episode").show();this.setFieldValue("season",i.season===0?"":i.season,2);this.setFieldValue("episode",i.episode===0?"":i.episode,2)}this.add_favorite.show();this.add_watchlist.show()}if(i&&i.additional){this.onSetCollectionMenuToDefault();if(Ext.isArray(i.additional.collection)){Ext.each(i.additional.collection,function(p){var q,o;o=p.title;if("syno_favorite"===o){q=-1}else{if("syno_watchlist"===o){q=-2}else{q=parseInt(p.id,10)}}this.currentAddCollection.push({id:q,title:o})},this);this.updateCollectionToolbar()}if(i.additional.file){if(i.additional.file.length>1){k=true}this.getStore().loadData(i.additional.file);this.getStore().commitChanges();if(i.additional.file.length==1){this.form.getForm().findField("duration").show();this.setFieldValue("duration",i.additional.file[0].duration);this.setPlayAction(i.additional.file)}}if(i.additional.extra){this.setRating(i.additional.extra);this.setIMDB(i.additional.extra)}var m=this.encodedMsg(i.additional.summary).split("\n").join("<br />");this.setFieldValue("summary",m);this.setFieldValue("actor",this.encodedMsg(i.additional.actor),1);this.setFieldValue("writer",this.encodedMsg(i.additional.writer),1);this.setFieldValue("director",this.encodedMsg(i.additional.director),1);this.setFieldValue("genre",this.encodedMsg(i.additional.genre),1);this.watched_ratio=i.additional.watched_ratio?i.additional.watched_ratio:0}this.setWatchStatus();if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===this.getCurType()){this.form.getForm().findField("certificate").hide();this.form.getForm().findField("actor").hide();this.form.getForm().findField("writer").hide();this.form.getForm().findField("director").hide();this.form.getForm().findField("genre").hide();this.form.getForm().findField("channel_name").show();this.setFieldValue("channel_name",this.encodedMsg(i.channel_name))}else{this.form.getForm().findField("certificate").show();this.form.getForm().findField("actor").show();this.form.getForm().findField("writer").show();this.form.getForm().findField("director").show();this.form.getForm().findField("genre").show();this.form.getForm().findField("channel_name").hide()}switch(this.getCurType()){case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:this.form.getForm().findField("record_date").hide();this.form.getForm().findField("original_available").hide();this.form.getForm().findField("play_time").show();this.setFieldValue("play_time",this.encodedMsg(i.record_date));break;case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:this.form.getForm().findField("play_time").hide();this.form.getForm().findField("original_available").hide();this.form.getForm().findField("record_date").show();this.setFieldValue("record_date",this.encodedMsg(i.record_date));break;default:this.form.getForm().findField("record_date").hide();this.form.getForm().findField("play_time").hide();this.form.getForm().findField("original_available").show();break}}else{var j=function(){SYNO.SDS.VideoStation.Util._gobackPanel()};if(c!==false&&!(h&&h.success&&h.data&&(Ext.isEmpty(d)||Ext.isEmpty(d[0])))){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(h,_T("error","error_error_system"));this._getOwner().getMsgBox().alert(_VST("app","displayname"),f,function(){j()})}else{j.defer(100)}}this.grid.setVisible(k);this.doLayout();this._getOwner().clearStatusBusy()}}).start(true)},getCgiURL:function(){var a;switch(this.getCurType()){case SYNO.SDS.VideoStation.Util._MOVIE_ID:a="movie.cgi";break;case SYNO.SDS.VideoStation.Util._TVSHOW_ID:a="tvshow_episode.cgi";break;case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:a="homevideo.cgi";break;case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:a="tvrecord.cgi";break;default:a="movie.cgi";break}return this._getWebAPIURL(a)},getSelectedFile:function(){var a=this.grid.getSelectionModel();return a.getSelected()},getFiles:function(){return this.getStore().data},setFieldValue:function(d,e,a){var c=this.form.getForm();if(Ext.isEmpty(e)){e="<span>";switch(a){case 1:e+=_VST("metadata","unknown");break;case 2:e+=_VST("classification","other");break}e+="</span>"}var b;if(d==="actor"||d==="writer"||d==="director"||d==="genre"){b=c.findField(d).el.select("span");b.each(function(f){f.removeAllListeners()},this)}c.setValues([{id:d,value:e||""}]);if(d==="actor"||d==="writer"||d==="director"||d==="genre"){b=c.findField(d).el.select("span");b.each(function(f){f.addClassOnOver("syno-vs-data-over");this.mon(f,"click",this.onFilterFieldClick.createDelegate(this,[d],true))},this)}},onFilterFieldClick:function(f,b,a,d){if(Ext.isEmpty(b.innerText)){return}var c={};c[d]=[];c[d].push({name:b.innerText,value:b.innerText});this._gotoHomePage({isFireEvent:false});this._gotoFilterView({params:{name:_VST("classification","all"),category:"all"},status:{filter:c}})},setWatchStatus:function(){var a=Math.floor(this.watched_ratio*100);if(0===a){this.form.getForm().findField("unwatched").show()}if(100>a){this.imageInnerContainer.getComponent("watch-status-wrap").show();this.imageInnerContainer.getComponent("watch-status-wrap").getComponent("watch-status").setWidth(a+"%")}},setRating:function(c){if(Ext.isEmpty(c)){return}var j;try{j=Ext.decode(c)}catch(g){return}var h,d,f,a=false,i=-1;for(d in j){if(j.hasOwnProperty(d)){for(f in j[d]){if(j[d].hasOwnProperty(f)){if(-1!=f.toLowerCase().indexOf("rating")){for(h in j[d][f]){if(j[d][f].hasOwnProperty(h)){var b=j[d][f][h];if(Ext.isNumber(b)){if(i<b){i=b}a=true}}}}}}}}if(a){this.rater.disabled=false;this.rater.getStars().each(function(e){e.dom.setAttribute("ext:qtip",i)},this);this.rater.setValue(i/2,i);this.rater.show()}},setIMDB:function(d){if(Ext.isEmpty(d)){return}var k;try{k=Ext.decode(d)}catch(h){return}var j,f,g,c,l;var a,i,b;for(f in k){if(k.hasOwnProperty(f)){for(g in k[f]){if(k[f].hasOwnProperty(g)){if(-1!=g.toLowerCase().indexOf("reference")){for(j in k[f][g]){if(k[f][g].hasOwnProperty(j)){if(j.toLowerCase()==="imdb"){c=k[f][g][j];if(!Ext.isEmpty(c)){c=this.getIMDBURL(c);c=String.format('<a class="allowDefCtxMenu link-font" target="_blank" href="{0}">{1}</a>',c,_VST("imdb","title"));if(f.toLowerCase()==="com.synology.synovideodb"){a=c}else{if(f.toLowerCase()==="com.synology.themoviedb"){i=c}}}}if(j.toLowerCase()==="atmovie"){c=k[f][g][j];if(!Ext.isEmpty(c)){c=this.getATMovieURL(c);b=String.format('<a class="allowDefCtxMenu link-font" target="_blank" href="{0}">{1}</a>',c,_VST("video_info","source_atmovies"))}}}}}}}}}if(!Ext.isEmpty(b)){l=b}if(!Ext.isEmpty(l)){if(!Ext.isEmpty(a)){l=l+","+a}else{if(!Ext.isEmpty(i)){l=l+","+i}}}else{if(!Ext.isEmpty(a)){l=a}else{if(!Ext.isEmpty(i)){l=i}}}if(!Ext.isEmpty(l)){this.imdb.setValue(l);this.imdb.show()}},imdblang:{enu:"com",ger:"de",spn:"es",fre:"fr",ita:"it"},getIMDBURL:function(b){var a=this.imdblang[_S("lang")];a=a?a:"com";return String.format("http://www.imdb.{0}/title/{1}",a,b)},getATMovieURL:function(a){return String.format("http://synology.atmovies.com.tw:8088/film/?sid={0}",a)},getCurType:function(){var a=this._getSelectedVideoType();return(a==="tvshow_episode")?"tvshow":a},setImage:function(){var a=(SYNO.SDS.VideoStation.Util._MOVIE_ID===this.getCurType())?"poster":"screenshot";this.imageInnerContainer.removeClass(["poster","screenshot"]);this.imageInnerContainer.addClass(a);var b=this.getImageURL();if(Ext.isIE8||Ext.isIE7){this.imageInnerContainer.getEl().setStyle("filter",String.format("progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",b))}else{this.imageInnerContainer.getEl().setStyle("background-image",String.format("url('{0}')",b))}},getImageURL:function(){var a=this._getHistoryInfo();var b=a.params.id;return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:this._getSelectedVideoType(),id:b,mtime:a.params.poster_mtime||""})},playVideo:function(b){if(this.grid.isVisible()){var a=this.grid.getSelectionModel().getSelected();if(Ext.isObject(a)){this.onPlayAction(a.data,b||"streaming")}}else{if(Ext.isObject(this.current_file)){this.onPlayAction(this.current_file,b||"streaming")}}},setPlayAction:function(a){this.current_file=a[0];this.playBtn.show()},onPlayAction:function(b,a){SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),b,SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo(),a)},onAddFavoite:function(){var a={id:-1};this.onRequestCollection("addvideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onAddWatchList:function(){var a={id:-2};this.onRequestCollection("addvideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onRemoveFavoite:function(){var a={id:-1};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRemoveWatchList:function(){var a={id:-2};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRequestCollection:function(e,c,a,d,b){if(c){this._onRequestCollectionNoMesg.call(this,e,a,d,b)}else{this._onRequestCollectionNoMesg.call(this,e,a,d,b)}},onRequestCollectionCallBack:function(a,e,d,f,b){if(SYNO.SDS.VideoStation.Util.getActiveItem()!==this){return}if("addvideo"===f){this.currentAddCollection.push({id:b.id})}else{if("deletevideo"===f){var c;for(c=0;c<this.currentAddCollection.length;c++){if(this.currentAddCollection[c].id===b.id){this.currentAddCollection.splice(c,1);break}}}}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr").fireEvent("afterAddDeleteVideoToCollection")},onSharePublic:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ActionMenu");a.collectionMenu.onClickPublicSharing()},eventLoadCollection:function(){this.updateCollectionsMenuitems()},eventAddDeleteVideoToCollection:function(){if(SYNO.SDS.VideoStation.Util.getActiveItem()!==this){return}this.updateCollectionToolbar()},updateCollectionToolbar:function(){this.add_favorite.show();this.add_watchlist.show();this.remove_favorite.hide();this.remove_watchlist.hide();this.user_define_collections.removeClass("activate");this.onSetCollectionMenuToDefault();Ext.each(this.currentAddCollection,function(a){if(-1===a.id){this.add_favorite.hide();this.remove_favorite.show();return}if(-2===a.id){this.add_watchlist.hide();this.remove_watchlist.show();return}this.user_define_collections.addClass("activate");this.onSetCollectionMenuIcon(a.id,true)},this)},setPlayerBtnVisibility:function(a){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");var c=b.getPlayerButton();c.setVisible(a);b.toolbar.syncSize()},callbackUpdateSharePublic:function(d,c,b,a){if(!d||!this.share_to_public.isVisible()){return}if(true===b.enable){this.share_to_public.addClass("activate")}else{this.share_to_public.removeClass("activate")}},updatePublicSharing:function(){this.share_to_public.hide();if(!SYNO.SDS.VideoStation.Util.ableToControlSharing()){return}this.share_to_public.removeClass("activate");SYNO.API.Request({api:"SYNO.VideoStation.Sharing",method:"get",version:1,params:{id:SYNO.SDS.VideoStation.Util._getSelectedVideoId(),type:this._getSelectedVideoType()},scope:this,callback:function(d,c,b,a){if(!d){return}this.share_to_public.show();if(true===c.enable){this.share_to_public.addClass("activate")}else{this.share_to_public.removeClass("activate")}}})},onPlayerLoad:function(){var b=[];this.player_store.each(function(c){b.push(c.data)},this);if(b.length>0){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").getPlayerButton().menu;a.setPlayerList(b);this.setPlayerBtnVisibility(SYNO.SDS.VideoStation.Util.ableToControlRenderer())}},loadPlayer:function(){if(!this.player_store){this.player_store=new SYNO.VideoController2.PlayerStore({appWindow:SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main")})}this.player_store.load({scope:this,callback:this.onPlayerLoad})}});Ext.define("SYNO.SDS.VideoStation.ViewGrid",{extend:"SYNO.ux.GridPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewGrid",this);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoCollectionView","_getCollectionStore"]);this.callParent([this.fillConfig(a)]);this.addManagedComponent(this.getStore());this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"beforeLoadCollection",this.eventBeforeLoadCollection,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"afterLoadCollection",this.eventLoadCollection,this)},fillConfig:function(a){var b=Ext.apply({enableHdMenu:false,cls:"syno-vs-grid syno-vs-classification-grid",itemId:"grid",border:false,store:this.getStore(),columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").fireEvent("afterSelectionChange")}}}),viewConfig:{scrollDelay:false,rowHeight:36,borderHeight:0,cacheSize:50},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{activate:this.onActivate,deactivate:this.onDeactivate,dblclick:this.dbClick}},a);return b},getColumnModel:function(){if(this.colModel){return this.colModel}this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_VST("classification","title"),dataIndex:"title",sortable:true,width:150,align:"left",renderer:(function(e,h,f,l,b,k){var j;var c;if(!Ext.isDefined(e)||e===""){e=_VST("metadata","unknown");j="<i>"+e+"</i>"}else{var a=SYNO.SDS.VideoStation.Util.getCollectionName(e);j=Ext.util.Format.htmlEncode(a)}h.attr='ext:qtip="'+Ext.util.Format.htmlEncode(j)+'"';var i=f.get("title");var g=f.get("type");if(i==="syno_favorite"){c='<div class="collection-favorite">'+j+"</div>"}else{if(i==="syno_watchlist"){c='<div class="collection-watchlist">'+j+"</div>"}else{if(i==="syno_default_shared"){c='<div class="collection-default-shared">'+j+"</div>"}else{if(g==="smart"){c='<div class="collection-smart">'+j+"</div>"}else{c='<div class="collection-normal">'+j+"</div>"}}}}var d=f.get("additional").sharing_info;if(d.status==="valid"&&i!=="syno_default_shared"){c+='<div class="sharing-valid"></div>'}else{if(d.status==="invalid"||d.status==="expired"){c+='<div class="sharing-invalid"></div>'}}return c}).createDelegate(this)}]});return this.colModel},getStore:function(){return this._getCollectionStore()},eventBeforeLoadCollection:function(){if(SYNO.SDS.VideoStation.Util.getActiveItem()!==this){return}this._getOwner().setStatusBusy()},eventLoadCollection:function(){if(SYNO.SDS.VideoStation.Util.getActiveItem()!==this){return}this._getOwner().clearStatusBusy()},dbClick:function(a,c,b){this.rowanddbClick(a,c,b)},rowanddbClick:function(a,j,h){var f=this.getSelectionModel();var g=f.getSelected();if(!g){return}var c=g.get("id");var b=g.get("title");var i=g.get("type");var d=g.get("additional");if(!Ext.isDefined(b)||b===""){b=_VST("metadata","unknown")}else{b=SYNO.SDS.VideoStation.Util.getCollectionName(b)}this._gotoCollectionView({params:{name:b,collection_id:c,collection_type:i,sharing_valid:d.sharing_info.status==="valid"},status:{}})},onGetSelectedData:function(){return this.getSelectionModel().getSelected()},onGetSelectedDatas:function(){return this.getSelectionModel().getSelections()},onActivate:function(){var a=false;this.getStore().reload();this.setSortColumnModel(a)},onDeactivate:function(){if(this.ajaxTask){this.ajaxTask.remove()}},setSortColumnModel:function(d){var a=this.getColumnModel();var b=a.columns;var c=this._getCurType();if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===c){b[0].header=_VST("collection","title")}Ext.each(b,function(e){e.sortable=d});a.setConfig(b,false)}});Ext.define("SYNO.SDS.VideoStation.ViewCollection",{extend:"SYNO.ux.GridPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoDetileView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewCollection",this);this.callParent([this.fillConfig(a)]);this.addManagedComponent(this.getStore());this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"afterAddDeleteVideoToCollection",this.eventAddDeleteVideoToCollection,this)},fillConfig:function(a){this.paging=new SYNO.ux.PagingToolbar({store:this.getStore(),pageSize:200,displayInfo:true});var b=Ext.apply({cls:"syno-vs-grid syno-vs-grid-collection",itemId:"grid_collection",border:false,store:this.getStore(),enableColumnMove:false,minColumnWidth:100,autoExpandColumn:"title",enableHdMenu:false,columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({listeners:{scope:this,selectionchange:function(c){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").fireEvent("afterSelectionChange")}}}),bbar:this.paging,viewConfig:{scrollDelay:false,rowHeight:88,borderHeight:0,cacheSize:50,forceFit:false,rowSelectorDepth:12},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{activate:this.onActivate,deactivate:this.onDeactivate,sortchange:function(d,c){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","collection_sortstate",{sort_direction:c.direction,sort_by:c.field})},rowdblclick:function(d,i,f){var h=this.getSelectionModel();var g=h.getSelected();if(!g){return}var c=g.get("library_id");this._gotoDetileView({params:{name:g.get("title"),id:g.get("id"),type:g.get("type"),library_id:c===0?g.get("type"):c},status:{}})},columnresize:function(){if(Math.abs(this.columnModelwidth-this.getColumnModel().getColumnWidth(1))>10){var c=this.getView();c.refresh()}},resize:function(){if(Math.abs(this.columnModelwidth-this.getColumnModel().getColumnWidth(1))>10){var c=this.getView();c.refresh()}},rowcontextmenu:function(d,c,f){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").showGridActionMenu(d,c,f)}}});return b},getColumnModel:function(){if(this.colModel){return this.colModel}this.colModel=new Ext.grid.ColumnModel({defaultSortable:true,defaults:{align:"center"},columns:[{header:_VST("type","tile"),dataIndex:"type",width:90,renderer:(function(f,d,a,c,e,b){switch(a.data.type){case"movie":f=_VST("type","movie");break;case"tvshow":case"tvshow_episode":f=_VST("type","tv_show");break;case"home_video":f=_VST("type","home_video");break;case"tv_record":f=_VST("type","tv_recorder");break;default:break}d.attr='ext:qtip="'+f+'"';return this.getIcon(a.data)}).createDelegate(this)},{header:_VST("common","title"),id:"title",align:"left",dataIndex:"title",autoExpand:true,renderer:(function(g,e,a,d,f,b){var c=new Ext.Template('<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout"><tbody><tr><td height="18" class="x-table-layout-cell syno-vs-data-cell syno-vs-data-name" valign="top"><div><span>{title}</span></div></td></tr>{tvshowinfo}{summary}</tbody></table>');c.compile();return c.apply({title:this.encodedMsg(a.data.title),summary:this.getSummary(a.data),tvshowinfo:this.getTVShowInfo(a.data)})}).createDelegate(this)},{id:"time",dataIndex:"date",header:_VST("time","title"),width:100,renderer:(function(g,e,a,d,f,b){g=SYNO.SDS.VideoStation.Util.getRecordTime(a);if(g==="0"){return""}var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)}]});return this.colModel},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.Store({paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},remoteSort:true,proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("collection.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),method:"POST",baseParams:{api:"SYNO.VideoStation.Collection",version:"2"},reader:new Ext.data.JsonReader({id:"mapper_id",root:"data.videos",totalProperty:"data.total",fields:["mapper_id","id","title","type","metadata_locked","additional","season","episode","tagline","library_id","original_available","record_date","date"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}}))},onBeforeLoadStore:function(a,b){this._getOwner().setStatusBusy();var d=b.params;var c=this._getHistoryInfo();var e=c.params.collection_id;Ext.apply(d,{offset:Ext.isDefined(d.offset)?d.offset:this.paging.cursor,limit:this.paging.pageSize,additional:Ext.encode(["summary","poster_mtime","watched_ratio"]),method:"video_list",id:e})},onAfterLoadStore:function(){this._getOwner().clearStatusBusy();if(!this.getSelectionModel().getSelected()){this.getSelectionModel().selectRow(0)}},onGetSelectedDatas:function(){return this.getSelectionModel().getSelections()},onGetSelectedData:function(){return this.getSelectionModel().getSelected()},onExceptionLoadStore:function(){this._getOwner().clearStatusBusy()},onActivate:function(){this.getStore().removeAll();this.getStore().load()},onDeactivate:function(){},encodedMsg:function(b,a){return SYNO.SDS.VideoStation.Util.encodedMsg(b,a)},getSummary:function(c){var b="";if(c.type&&"tvshow_episode"!==c.type){var a=SYNO.SDS.VideoStation.Util.getAddtionalText(c,"summary");b='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-summary" valign="top" rowspan="4"><div><span>'+a+"</span></div></td></tr>"}return b},getTVShowInfo:function(b){var a="";if(b.type&&"tvshow_episode"===b.type){if(b.season){a=String.format(_VST("season","title"),b.season)}if(""!==a&&b.episode){a=a+", "+String.format(_VST("episode","title"),b.episode)}else{if(b.episode){a=String.format(_VST("episode","title"),b.episode)}}if(""!==a&&b.tagline){a=a+" - "+b.tagline}else{if(b.tagline){a=b.tagline}}var c=a;a='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-collection-tvshowinfo" valign="top" rowspan="4"><div><span>'+c+"</span></div></td></tr>"}return a},getIcon:function(b){var a=(b.type==="movie")?"poster":"screenshot";return['<div class="icon '+a+'"','style="',String.format(SYNO.SDS.VideoStation.Util.BACKGROUND_IMAGE_STR,this.getImageURL(b)),'">',"</div>"].join("")},getImageURL:function(a){return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a.type,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})},eventAddDeleteVideoToCollection:function(){if(SYNO.SDS.VideoStation.Util.getActiveItem()!==this){return}this.onActivate()}});Ext.define("SYNO.SDS.VideoStation.HomePage",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.HomePage",this);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoFilterView"]);this.callParent([this.fillConfig(a)]);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterSelectionChange",this.eventSelectionChange,this)},fillConfig:function(a){var b={cls:"syno-vs-homepage",layout:"border",items:[{cls:"syno-vs-home-top-panel",xtype:"syno_panel",region:"north",layout:"border",items:[this.getImageBox(),this.getMetaPanel()]},this.getRecentlyTabPanel()],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,resize:this.onTabChange}};Ext.apply(b,a);return b},onActivate:function(){this.clearTopPanel();var a=this._getOwner().filteringBase.getStyleClass({});if("poster"===a){this.getImageBox().setWidth(190)}else{this.getImageBox().setWidth(284)}this.doLayout();this.getRecentlyTabPanel().hideTabStripItem(this.watchedPanel);if(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===this._getCurType()){this.releasedPanel.setTitle(_VST("classification","recently_recoded"))}else{this.releasedPanel.setTitle(_VST("classification","recently_released"))}if(this.getRecentlyTabPanel().getActiveTab()===this.addedPanel){this.getRecentlyTabPanel().getActiveTab().onActivate();this.onTabChange()}else{this.getRecentlyTabPanel().activate(this.addedPanel)}this.watchedCountTask();if(SYNO.SDS.VideoStation.Util._TVSHOW_ID===this._getCurType()){this.maskBox.hide();this.playBtn.hide()}else{this.maskBox.show();this.playBtn.show()}},onDeactivate:function(){},getImageBox:function(){if(this.imageBox){return this.imageBox}this.playBtn=new Ext.Container({cls:"play",border:false,overCls:"over",listeners:{scope:this,afterrender:function(){var a=this.playBtn.getEl();a.addClassOnClick("click");this.mon(a,"click",this.onPlayAction.createDelegate(this,[]),this)}},html:""});this.maskBox=new Ext.Container({xtype:"container",cls:"image-box-mask",listeners:{scope:this,afterrender:function(b){var a=b.getEl();a.addClassOnClick("click");this.mon(a,"click",this.onGotoDetail.createDelegate(this,[]),this)}}});this.imageBox=new Ext.Container({region:"west",cls:"syno-vs-home-image-box",items:[this.maskBox,this.playBtn]});return this.imageBox},getDetailPanel:function(){if(this.detailPanel){return this.detailPanel}this.detailPanel=new SYNO.ux.Panel({region:"center",cls:"detail-panel",autoFlexcroll:true,items:[this.getSnippetContainer(),{xtype:"displayfield",itemId:"sep",cls:"sep"},{xtype:"displayfield",itemId:"summary",cls:"summary"}]});return this.detailPanel},getSnippetContainer:function(){if(this.snippetContainer){return this.snippetContainer}this.snippetContainer=new Ext.Container({cls:"snippet",items:[{itemId:"channel_name",name:"channel_name",xtype:"displayfield"},{itemId:"play_time",name:"play_time",xtype:"displayfield"},{itemId:"record_date",name:"record_date",xtype:"displayfield"},{itemId:"genre",name:"genre",xtype:"displayfield"},{itemId:"total_seasons",name:"total_seasons",xtype:"displayfield"},{itemId:"original_available",name:"original_available",xtype:"displayfield"},{itemId:"duration",name:"duration",xtype:"displayfield"},{itemId:"director",name:"director",xtype:"displayfield"}]});return this.snippetContainer},getMetaPanel:function(){if(this.metaPanel){return this.metaPanel}this.metaPanel=new SYNO.ux.Panel({region:"center",cls:"syno-vs-home-meta-panel",layout:"border",items:[this.getTitleContainer(),this.getDetailPanel()]});return this.metaPanel},getTitleContainer:function(){if(this.titleContainer){return this.titleContainer}this.titleContainer=new Ext.Container({region:"north",cls:"title-outer",items:[{xtype:"container",cls:"title",itemId:"title",items:[{xtype:"displayfield",itemId:"title_inner",cls:"title-inner"}]}]});return this.titleContainer},clearTopPanel:function(){this.getSnippetContainer().getComponent("channel_name").setValue("");this.getSnippetContainer().getComponent("play_time").setValue("");this.getSnippetContainer().getComponent("record_date").setValue("");this.getSnippetContainer().getComponent("genre").setValue("");this.getSnippetContainer().getComponent("total_seasons").setValue("");this.getSnippetContainer().getComponent("original_available").setValue("");this.getSnippetContainer().getComponent("duration").setValue("");this.getSnippetContainer().getComponent("director").setValue("");this.getTitleContainer().getComponent("title").getComponent("title_inner").setValue("");this.getDetailPanel().getComponent("sep").hide();this.getDetailPanel().getComponent("summary").setValue("");this.setImage();this.getDetailPanel().updateScroller()},updateTopPanel:function(b){var a=b.get("additional")||"";switch(this._getCurType()){case SYNO.SDS.VideoStation.Util._MOVIE_ID:this.setFieldValue("genre",_VST("genre","title"),a.genre);this.setFieldValue("original_available",_VST("original_available","title"),b.get("original_available"));this.setFieldValue("duration",_VST("duration","title"),a.file[0].duration);this.setFieldValue("director",_VST("director","title"),a.director);break;case SYNO.SDS.VideoStation.Util._TVSHOW_ID:this.setFieldValue("original_available",_VST("original_available","title"),b.get("original_available"));this.setFieldValue("total_seasons",_VST("season","total_seasons"),a.total_seasons);break;case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:this.setFieldValue("record_date",_VST("video_info","record_time"),b.get("record_date"));this.setFieldValue("genre",_VST("genre","title"),a.genre);this.setFieldValue("duration",_VST("duration","title"),a.file[0].duration);break;case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:this.setFieldValue("channel_name",_VST("schedule","channel"),b.get("channel_name"));this.setFieldValue("play_time",_VST("metadata","play_time"),b.get("record_date"));this.setFieldValue("duration",_VST("duration","title"),a.file[0].duration);break;default:break}this.getTitleContainer().getComponent("title").getComponent("title_inner").setValue(this.encodedMsg(b.get("title")));this.getDetailPanel().getComponent("sep").show();this.getDetailPanel().getComponent("summary").setValue(this.encodedMsg(b.get("additional").summary));this.setImage(b.data);this.getDetailPanel().updateScroller()},encodedMsg:function(d,b){if(!Ext.isArray(d)){return SYNO.SDS.VideoStation.Util.encodedMsg(d,b)}var c="";for(var a=0;a<d.length;a++){if(a>0){c+=", "}c+=SYNO.SDS.VideoStation.Util.encodedMsg(d[a],b)}return c},setFieldValue:function(b,e,d){var a=this.getSnippetContainer().getComponent(b);var c=this.encodedMsg(d);if(Ext.isEmpty(c)){c=_VST("metadata","unknown")}a.setValue(e+" : "+c)},setImage:function(a){if(a){var b=this._getOwner().filteringBase.getImageURL(a);if(Ext.isIE8||Ext.isIE7){this.getImageBox().getEl().setStyle("filter",String.format("progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",b))}else{this.getImageBox().getEl().setStyle("background-image",String.format("url('{0}')",b))}}else{if(Ext.isIE8||Ext.isIE7){this.getImageBox().getEl().setStyle("filter","progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled = false)")}else{this.getImageBox().getEl().setStyle("background-image","none")}}},getRecentlyTabPanel:function(){if(this.recentlyTabPanel){return this.recentlyTabPanel}this.addedPanel=new SYNO.SDS.VideoStation.FilteringThumbnail({isHomePage:true,filteringBase:this._getOwner().filteringBase,title:_VST("classification","recently_added"),itemId:"homepage_added",category:"recently_added"});this.watchedPanel=new SYNO.SDS.VideoStation.FilteringThumbnail({isHomePage:true,filteringBase:this._getOwner().filteringBase,title:_VST("classification","recently_watched"),itemId:"homepage_watched",category:"recently_watched"});this.releasedPanel=new SYNO.SDS.VideoStation.FilteringThumbnail({isHomePage:true,filteringBase:this._getOwner().filteringBase,title:_VST("classification","recently_released"),itemId:"homepage_released",category:"recently_released"});this.recentlyTabPanel=new SYNO.ux.TabPanel({region:"center",cls:"recently-tab-panel",activeTab:0,items:[this.addedPanel,this.releasedPanel,this.watchedPanel],listeners:{scope:this,tabchange:this.onTabChange}});return this.recentlyTabPanel},getLoadItemNumber:function(b){var e=162;var h=("poster"===b)?124:180;var i=this.getRecentlyTabPanel().getActiveTab().getHeight();var d=i<e?15:0;var a=this.getRecentlyTabPanel().getActiveTab().getWidth()-d;var j=Math.floor(i/e);var c=Math.floor(a/h);var f=(j<=0?1:j)*(c<=0?1:c);var k=("poster"===b)?39:24;var g=("poster"===b)?6:4;return Math.min(Math.max(f,g),k)},watchedCountTask:function(){var a=SYNO.SDS.VideoStation.Util.getinfo_WebAPI(this._getCurType());SYNO.API.Request({api:a.api,method:"list",version:2,params:{library_id:this._getCurLibraryId(),offset:0,limit:0,sort_by:"watched",sort_direction:"desc"},scope:this,callback:function(e,d,c,b){if(!e){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(e,d,b.params));return}if(0<d.total){this.getRecentlyTabPanel().unhideTabStripItem(this.watchedPanel)}}})},onTabChange:function(e,a){var c=this._getHistoryInfo();Ext.apply(c.params,{category:this.getRecentlyTabPanel().getActiveTab().category});var d={};var b=this._getOwner().filteringBase.getStyleClass({});Ext.apply(d,{limit:this.getLoadItemNumber(b)-1});SYNO.SDS.VideoStation.Util._loadFilterBaseStore(d)},onGetSelectedData:function(){return this.getRecentlyTabPanel().getActiveTab().onGetSelectedData()},onGetSelectedDatas:function(){return this.getRecentlyTabPanel().getActiveTab().onGetSelectedDatas()},onGetSelectionModel:function(){return this.getRecentlyTabPanel().getActiveTab().onGetSelectionModel()},eventSelectionChange:function(){if(SYNO.SDS.VideoStation.Util.getActiveItem()!==this){return}var a=this.onGetSelectedData();if(Ext.isDefined(a)&&true!==a.get("viewMore")){this.updateTopPanel(a)}else{this.clearTopPanel()}},onPlayAction:function(){var d=this.onGetSelectedData();if(d){var b=SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo();if(d.data.additional.file.length===1){var a=d.data.additional.file[0];if(Ext.isObject(a)){SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),a,b,"streaming")}}else{var c=new SYNO.SDS.VideoStation.VideoListDialog();c.playAdditionalInfo=b;c.onLoadData(d.data.additional.file)}}},onGotoDetail:function(){var b=this.onGetSelectedData();var a=this.getRecentlyTabPanel().getActiveTab().category;if(b){this._gotoFilterView({params:{name:_VST("classification",a),category:a},status:{selected_id:b.get("id")},isFireEvent:false});this._getOwner().filteringBase.onGotoNext(b)}}});Ext.define("SYNO.SDS.VideoStation.DTVHomePage",{extend:"SYNO.ux.GridPanel",constructor:function(a){this.hasDongle=false;SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.DTVHomePage",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.pageSize=50;var b={owner:a.owner,cls:"syno-vs-grid syno-vs-homepage-channel-grid",bbar:this.getBottomToolbar(),store:this.getStore(),sm:this.getSelectionModel(),cm:this.getColumnModel(),enableColumnMove:false,enableHdMenu:false,listeners:{scope:this,activate:this.onActivate}};return b},onActivate:function(){(function(){this.owner.pathBar.tbPanel.hide()}).defer(50,this);if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this.updateMaskInfo(false,false);return}else{if(false===this.hasDongle){this.getEl().mask(_T("common","loading"),"x-mask-loading");return}}this.getStore().reload()},editBtnListDone:function(a,e,d){this.getEl().unmask();var b=new Ext.data.Store();if(!a){SYNO.SDS.VideoStation.Window.getMsgBox().alert(title,SYNO.API.CheckResponse(a,e,d));return}else{Ext.each(e.channels,function(h,f,g){b.add(new Ext.data.Record(h))})}var c=new SYNO.SDS.VideoStation.ChannelEditDialog({owner:SYNO.SDS.VideoStation.Window,store:b,tunerInfo:this.tunerInfo});c.show()},getBottomToolbar:function(){if(this.pagingToolbar){return this.pagingToolbar}this.pagingToolbar=new SYNO.ux.PagingToolbar({store:this.getStore(),pageSize:this.pageSize,displayInfo:true});return this.pagingToolbar},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.JsonStore({idProperty:"id",totalProperty:"total",root:"channels",fields:["id","title","program_now","program_next","scrambled","streaming"],paramNames:{start:"offset",limit:"limit"},proxy:new SYNO.API.Proxy({api:"SYNO.DTV.Channel",method:"list",version:1}),baseParams:{tuner:Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0,ishomepage:true,offset:0,limit:this.pageSize},listeners:{scope:this,beforeload:function(){this.owner.scanBtn.disable();this.owner.editChannelBtn.disable();this.owner.scheduleRecordBtn.disable();this.getEl().unmask();this.getEl().mask(_T("common","loading"),"x-mask-loading")},load:function(a,c){this.getEl().unmask();if(c.length===0){this.updateMaskInfo(true,false);return}else{this.owner.scanBtn.enable();this.owner.editChannelBtn.enable();this.owner.scheduleRecordBtn.enable()}var b=Ext.select(".syno-vs-homepage-channel-grid .channel-streaming .channel-icon");b.elements.each(function(e){var d=Ext.get(e);d.addListener("click",function(){var f=new SYNO.SDS.VideoStation.StreamingDialog({currentTunerID:this.tunerInfo.id});f.show()},this)},this);b=Ext.select(".syno-vs-homepage-channel-grid .action-stream");b.elements.each(function(e){var d=Ext.get(e);d.addClassOnOver("icon-mouseover");d.addClassOnClick("icon-click");d.addListener("click",this.handleStreamAction,this)},this);b=Ext.select(".syno-vs-homepage-channel-grid .action-record");b.elements.each(function(e){var d=Ext.get(e);d.addClassOnOver("icon-mouseover");d.addClassOnClick("icon-click");d.addListener("click",this.handleRecordAction,this)},this);b=Ext.select(".syno-vs-homepage-channel-grid .action-epg");b.elements.each(function(e){var d=Ext.get(e);d.addClassOnOver("icon-mouseover");d.addClassOnClick("icon-click");d.addListener("click",this.handleEPGAction,this)},this)},exception:function(c,d,f,b,g,a){this.getEl().unmask();this.store.removeAll();this.owner.editChannelBtn.disable();this.owner.scheduleRecordBtn.disable();if(g.code<400){SYNO.SDS.VideoStation.Window.getMsgBox().alert("",SYNO.API.CheckResponse(succ,g,info));return}else{if(g.code===403){this.updateMaskInfo(true,false)}else{var e=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(g.code);this.getEl().mask(e,"syno-ux-grid-mask-info")}}}}});return this.store},enableAllStreamHandler:function(b){var a=Ext.select(".syno-vs-homepage-channel-grid .action-stream");a.elements.each(function(d){var c=Ext.get(d);c.removeListener("click",this.handleStreamAction,this);if(b){c.addListener("click",this.handleStreamAction,this);c.removeClass("stream-disabled")}else{c.addClass("stream-disabled")}},this)},getSelectionModel:function(){if(this.selModel){return this.selModel}this.selModel=new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:function(b){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel");if(!SYNO.SDS.VideoStation.Util.ableToControlDTV()){a.getTopToolbar().getComponent("action").disable()}else{a.getTopToolbar().getComponent("action")[b.getCount()!==1?"disable":"enable"]()}}}});return this.selModel},getColumnModel:function(){if(this.columnModel){return this.columnModel}this.columnModel=new Ext.grid.ColumnModel([{header:_VST("schedule","channel"),dataIndex:"title",id:"channel-title",width:300,sortable:false,align:"center",renderer:function(b,n,g){var k="<div class='channel {0}'><div class='channel-icon' {3}></div><div class='channel-title'>{1}</div>{2}</div>";var o='ext:qtip="{0}"';var f="";var a="";var h="";var j=g.get("program_now");var c=g.get("program_next");var l=Ext.util.Format.htmlEncode(b);if(Ext.isEmpty(j.start_time)&&Ext.isEmpty(c.start_time)){a+="record-disabled"}a+=g.get("scrambled")?" channel-encrypted":"";a+=g.get("streaming")?" channel-streaming":"";if(g.get("streaming")){f=String.format(o,_VST("action","live_stream"))}if(SYNO.SDS.VideoStation.Util.ableToControlDTV()){var e=String.format(o,_VST("action","live_stream"));var m=String.format(o,_VST("action","record"));var d=String.format(o,_VST("action","open_epg"));var i='<div class="action-stream" {0}></div><div class="action-record" {1}></div><div class="action-epg" {2}></div>';h=String.format(i,e,m,d)}return String.format(k,a,l,h,f)}},{header:_VST("record","now_playing"),dataIndex:"program_now",sortable:false,align:"center",id:"program-now",width:250,renderer:this.programColumnRenderer},{header:_VST("record","coming_next"),dataIndex:"program_next",sortable:false,align:"center",id:"program-next",width:250,renderer:this.programColumnRenderer}]);return this.columnModel},programColumnRenderer:function(e,b,d){var a='<div class="program-border"></div>';if(Ext.isEmpty(e.start_time)){return a+'<div class="program-title-empty">'+_VST("programguide","no_program")+"</div>"}else{var c=Ext.isEmpty(e.event_name)?_VST("programguide","no_title"):e.event_name;if(e.recording){a+='<div class="program-recording"></div>'}else{if(e.scheduled){a+='<div class="program-scheduled"></div>'}}a=a+'<div class="program-title">'+c+'</div><div class="program-time">'+e.schedule+"</div>";return a}},handleStreamAction:function(){this.getEl().mask(_T("common","loading"),"x-mask-loading");SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","setchannel","1",{id:this.onGetSelectedData().get("id"),tuner:this.tunerInfo.id},this.actionSetChannelDone,this)},handleRecordAction:function(a,b,c){if(Ext.isEmpty(this.onGetSelectedData().get("program_now").start_time)&&Ext.isEmpty(this.onGetSelectedData().get("program_next").start_time)){return}var d=this.getRecordMenu();d.showAt([Ext.get(b).getX(),Ext.get(b).getY()+24])},handleEPGAction:function(){var a=new SYNO.SDS.VideoStation.ProgramScheduleDialog({tunerInfo:this.tunerInfo,channelID:this.onGetSelectedData().get("id"),activeItem:0});a.open()},actionSetChannelDone:function(a,e,d){this.getEl().unmask();if(!a){SYNO.SDS.VideoStation.Window.getMsgBox().alert(_VST("action","program_guide"),SYNO.API.CheckResponse(a,e,d));return}else{this.getStore().reload();var b=9025+(this.tunerInfo.id%16);var c=new SYNO.SDS.VideoStation.StreamHintDialog({title:_VST("action","live_stream"),owner:SYNO.SDS.VideoStation.Window,port:b,tuner:this.tunerInfo.id,channel:this.onGetSelectedData().get("title")});c.open()}},getRecordMenu:function(){if(this.recordMenu){return this.recordMenu}this.recordMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[{scope:this,handler:function(){this.setupRecord(this.onGetSelectedData().get("program_now"))}},{scope:this,handler:function(){this.cancelRecord(this.onGetSelectedData().get("program_now"))}},{scope:this,handler:function(){this.setupRecord(this.onGetSelectedData().get("program_next"))}},{scope:this,handler:function(){this.cancelRecord(this.onGetSelectedData().get("program_next"))}}],listeners:{scope:this,beforeshow:function(c){var a=this.onGetSelectedData().get("program_now");var b=this.onGetSelectedData().get("program_next");this.updateRecordMenuItem(a,c.items.get(0),c.items.get(1),_VST("record","now_playing"));this.updateRecordMenuItem(b,c.items.get(2),c.items.get(3),_VST("record","coming_next"))}}});return this.recordMenu},setupRecord:function(a){this.getEl().mask(_T("common","loading"),"x-mask-loading");var b={tuner:this.tunerInfo.id,id:this.onGetSelectedData().get("id"),start_time:a.start_time};SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","create",1,b,this.recordActionDone,this)},cancelRecord:function(a){this.getEl().mask(_T("common","loading"),"x-mask-loading");var b={tuner:this.tunerInfo.id,id:a.start_time,channel_id:this.onGetSelectedData().get("id")};SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete",1,b,this.recordActionDone,this)},updateRecordMenuItem:function(d,a,b,c){if(Ext.isEmpty(d.start_time)){a.hide();b.hide();return}else{if(d.recording||d.scheduled){a.hide();b.show()}else{a.show();b.hide()}}var e=Ext.isEmpty(d.event_name)?c:d.event_name;a.setText(String.format(_VST("record","record_program"),e));b.setText(String.format(_VST("record","cancel_program"),e))},recordActionDone:function(a,e,c){this.getEl().unmask();var d=_VST("action","program_guide");if(!a){if(e.code<400){SYNO.SDS.VideoStation.Window.getMsgBox().alert(d,SYNO.API.CheckResponse(a,e,c))}else{var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(e.code);if(406===e.code){SYNO.SDS.VideoStation.Window.getMsgBox().alert(d,b,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").launchSettingDialog(1)},this)}else{SYNO.SDS.VideoStation.Window.getMsgBox().alert(d,b)}}return}this.store.reload()},onGetSelectedData:function(){var a=this.getSelectionModel();return a.getSelections()[0]},onGetSelectedDatas:function(){var a=this.getSelectionModel();return a.getSelections()},updateMaskInfo:function(c,e){var b,a;this.getStore().removeAll();this.getEl().unmask();this.owner.scanBtn.disable();this.owner.editChannelBtn.disable();this.owner.scheduleRecordBtn.disable();if(!SYNO.SDS.VideoStation.Util.ableToControlDTV()){if(!c||!this.hasDongle||!e){this.getEl().mask(_VST("error","dtv_no_function"),"syno-ux-grid-mask-info")}return}if(!c){var f=_S("is_admin")?_VST("error","dtv_disabled"):_VST("error","dtv_no_function");b=this.getEl().mask(f,"syno-ux-grid-mask-info");if(!_S("is_admin")){return}a=b.next().first();a.setStyle("cursor","pointer");a.on("click",function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").launchSettingDialog(1)});return}else{if(!this.hasDongle){var g=String.format('<a target="_blank" class="link-font" href="https://www.synology.com/en-global/knowledgebase/faq/532">{0}</a>',_VST("common","synology_website"));var d=String.format(_VST("error","dtv_request_dongle2"),g);this.getEl().mask(d,"syno-ux-grid-mask-info");return}else{if(!e){b=this.getEl().mask(_VST("error","dtv_channeltable_not_found"),"syno-ux-grid-mask-info");a=b.next().first();a.setStyle("cursor","pointer");a.on("click",function(){var i=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var h=new SYNO.SDS.VideoStation.ChannelScanDialog({owner:SYNO.SDS.VideoStation.Window,closeAction:"close",tunerInfo:i.tunerInfo},this);h.open()});this.owner.scanBtn.enable();return}}}this.owner.scanBtn.enable();this.owner.editChannelBtn.enable();this.owner.scheduleRecordBtn.enable();return}});Ext.define("SYNO.SDS.VideoStation.FilteringBase",{extend:"Ext.Component",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoFilterView","_gotoDetileView","_gotoTVSeasonView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FilteringBase",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={};Ext.apply(b,a);return b},onLoadStore:function(a){this.getStore().removeAll(true);this.getStore().load({params:Ext.apply({offset:(a?(a.start||0):0)},a||{})})},getStore:function(){if(this.stores&&this.stores[this._getCurType()]){return this.stores[this._getCurType()]}this.stores={};this.Proxies={};this.Readers={};this.Roots={};this.WebAPIUrls={};this.WebAPI={};this.createStores();return(this.stores[this._getCurType()])},getRoot:function(){if(this.Roots&&this.Roots[this._getCurType()]){return this.Roots[this._getCurType()]}},getReader:function(){if(this.Readers&&this.Readers[this._getCurType()]){return this.Readers[this._getCurType()]}},changeReaderRoot:function(a){this.getReader().meta.root=a;delete this.getStore().reader.ef;this.getReader().buildExtractors()},changeWebAPIandProxyToFolder:function(){if(this.stores[this._getCurType()].proxy.url!==this._getWebAPIURL("folder.cgi")){this.stores[this._getCurType()].baseParams.api="SYNO.VideoStation.Folder";this.stores[this._getCurType()].proxy.setApi(Ext.data.Api.actions.read,this._getWebAPIURL("folder.cgi"))}},chageWebAPIandProxyToDef:function(){this.stores[this._getCurType()].baseParams.api=this.WebAPI[this._getCurType()];this.stores[this._getCurType()].proxy.setApi(Ext.data.Api.actions.read,this.WebAPIUrls[this._getCurType()])},getTimeSort:function(b){var a=this._getCurCategory();if("recently_watched"===a){Ext.apply(b,{sort_by:"watched",sort_direction:"desc"})}else{if("recently_added"===a){Ext.apply(b,{sort_by:"added",sort_direction:"desc"})}else{if("recently_released"===a){Ext.apply(b,{sort_by:"date",sort_direction:"desc"})}}}},selectData:function(b){var a=SYNO.SDS.VideoStation.Util.getActiveItem().onGetSelectionModel();if(a.selectRow){a.selectRow(b)}else{a.select(b)}},insertViewMoreData:function(a){var b=new Ext.data.Record({viewMore:true,title:_VST("action","view_more"),additional:{summary:""}});a.insert(a.getCount(),b)},onBeforeLoadStore:function(b,d){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");c.getEl().mask(_T("common","loading"),"x-mask-loading");var g=d.params;var e=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance",this._getCurType()+"sortstate");if(!g.sort_by&&!g.sort_direction){if(e&&e.sort_by&&e.sort_direction){g.sort_by=e.sort_by;g.sort_direction=e.sort_direction}else{g.sort_by=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainToolBar.SortButton").getParamSortBy();g.sort_direction=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainToolBar.SortButton").getParamSortOrder()}}var a=("1"===b.baseParams.version?this.getAdditional().join(","):Ext.encode(this.getAdditional()));Ext.apply(g,{offset:Ext.isDefined(g.offset)?g.offset:0,limit:Ext.isDefined(g.limit)?g.limit:SYNO.SDS.VideoStation.Config.pageSize,additional:a,library_id:this._getCurLibraryId()});if(g.sort_by&&g.sort_direction){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance",this._getCurType()+"sortstate",{sort_by:g.sort_by,sort_direction:g.sort_direction})}if(this._checkIsByfolder()){if(this.getReader()&&"data.objects"!==this.getReader().meta.root){this.changeWebAPIandProxyToFolder();this.changeReaderRoot("data.objects")}g.sort_by="filename";var f=this._getHistoryInfo();Ext.apply(g,{method:"list",id:(f.params&&f.params.id)?f.params.id:"",type:this._getCurType(),version:"2"})}else{if(this.getReader()&&"data.objects"===this.getReader().meta.root){this.chageWebAPIandProxyToDef();this.changeReaderRoot(this.getRoot())}if("all"===this._getCurCategory()){Ext.apply(g,SYNO.SDS.VideoStation.FilterUtil.getFilterCondition(true))}Ext.apply(g,{method:"list"})}this.getTimeSort(g)},onAfterLoadStore:function(g,d,i){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");var b=this._getHistoryInfo();var f=this._getCurType();c.getEl().unmask();if(g&&0===g.getCount()&&i.params.library_id===this._getCurLibraryId()&&(i.params.api===this.WebAPI[f]||(this._checkIsByfolder()&&i.params.api==="SYNO.VideoStation.Folder"))){var h=SYNO.SDS.VideoStation.Util.noItemHandler(i.params.library_id);var j=c.getEl().mask(h.msg,"syno-ux-mask-info");if(Ext.isFunction(h.fn)){var a=j.next().first();a.setStyle("cursor","pointer");a.on("click",h.fn)}return}if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===b.view){if(!this.getSelectionCount()){this.selectData(0)}if(g.getTotalCount()>d.length){this.insertViewMoreData(g)}}else{if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===b.view){Ext.apply(b.status,{offset:i.params.offset,limit:i.params.limit});if(b.status.selected_id){var e=g.findExact("id",b.status.selected_id);this.gotoScroll(e)}}}},onExceptionLoadStore:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");a.getEl().unmask()},abortPreviousRequest:function(){for(var b in this.Proxies){if(this.Proxies.hasOwnProperty(b)){var a=this.Proxies[b];var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}},createProxies:function(){var a=SYNO.SDS.VideoStation.Util;this.WebAPIUrls[a._MOVIE_ID]=this._getWebAPIURL("movie.cgi");this.Proxies[a._MOVIE_ID]=new SYNO.SDS.VideoStation.FilteringBaseHttpProxy({url:this.WebAPIUrls[a._MOVIE_ID]});this.WebAPIUrls[a._TVSHOW_ID]=this._getWebAPIURL("tvshow.cgi");this.Proxies[a._TVSHOW_ID]=new SYNO.SDS.VideoStation.FilteringBaseHttpProxy({url:this.WebAPIUrls[a._TVSHOW_ID]});this.WebAPIUrls[a._HOME_VIDEO_ID]=this._getWebAPIURL("homevideo.cgi");this.Proxies[a._HOME_VIDEO_ID]=new SYNO.SDS.VideoStation.FilteringBaseHttpProxy({url:this.WebAPIUrls[a._HOME_VIDEO_ID]});this.Proxies[a._TV_RECORDER_ID]=new SYNO.SDS.VideoStation.FilteringBaseHttpProxy({url:this._getWebAPIURL("tvrecord.cgi")});this.Proxies[a._COLLECTION_ID]=new SYNO.SDS.VideoStation.FilteringBaseHttpProxy({url:this._getWebAPIURL("collection.cgi")})},createStores:function(){var b=SYNO.SDS.VideoStation.Util;this.createProxies();this.Roots[b._MOVIE_ID]="data.movies";this.Readers[b._MOVIE_ID]=new Ext.data.JsonReader({id:"id",root:this.Roots[b._MOVIE_ID],totalProperty:"data.total",fields:["id","title","original_available","metadata_locked","additional","type","path","sharepath","file_count"]});this.WebAPI[b._MOVIE_ID]="SYNO.VideoStation.Movie";this.stores[b._MOVIE_ID]=new Ext.data.Store({proxy:this.Proxies[b._MOVIE_ID],method:"POST",baseParams:{api:this.WebAPI[b._MOVIE_ID],version:"2"},paramNames:this.paramNames,reader:this.Readers[b._MOVIE_ID],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.Roots[b._TVSHOW_ID]="data.tvshows";this.Readers[b._TVSHOW_ID]=new Ext.data.JsonReader({root:this.Roots[b._TVSHOW_ID],totalProperty:"data.total",id:"id",fields:["id","title","original_available","metadata_locked","additional","type","path","sharepath","file_count"]});this.WebAPI[b._TVSHOW_ID]="SYNO.VideoStation.TVShow";this.stores[b._TVSHOW_ID]=new Ext.data.Store({proxy:this.Proxies[b._TVSHOW_ID],baseParams:{api:this.WebAPI[b._TVSHOW_ID],version:"2"},paramNames:this.paramNames,reader:this.Readers[b._TVSHOW_ID],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.Roots[b._HOME_VIDEO_ID]="data.videos";this.Readers[b._HOME_VIDEO_ID]=new Ext.data.JsonReader({id:"id",root:this.Roots[b._HOME_VIDEO_ID],totalProperty:"data.total",fields:["id","title","record_date","additional","type","path","sharepath","file_count"]});this.WebAPI[b._HOME_VIDEO_ID]="SYNO.VideoStation.HomeVideo";this.stores[b._HOME_VIDEO_ID]=new Ext.data.Store({proxy:this.Proxies[b._HOME_VIDEO_ID],method:"POST",baseParams:{api:this.WebAPI[b._HOME_VIDEO_ID],version:"2"},paramNames:this.paramNames,reader:this.Readers[b._HOME_VIDEO_ID],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.WebAPI[b._TV_RECORDER_ID]="SYNO.VideoStation.TVRecording";this.stores[b._TV_RECORDER_ID]=new Ext.data.Store({proxy:this.Proxies[b._TV_RECORDER_ID],baseParams:{api:this.WebAPI[b._TV_RECORDER_ID],version:"2"},paramNames:this.paramNames,reader:new Ext.data.JsonReader({root:"data.recordings",totalProperty:"data.total",id:"id",fields:["id","title","channel_name","record_date","additional"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.WebAPI[b._COLLECTION_ID]="SYNO.VideoStation.Collection";this.stores[b._COLLECTION_ID]=new Ext.data.Store({proxy:this.Proxies[b._COLLECTION_ID],method:"POST",baseParams:{api:this.WebAPI[b._COLLECTION_ID],version:"1"},paramNames:this.paramNames,reader:new Ext.data.JsonReader({id:"id",root:"data.collections",totalProperty:"data.total",fields:["id","title","additional"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});for(var a in this.stores){this.addManagedComponent(this.stores[a])}},getSelectedDatas:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas()},getSelectionCount:function(){var a=this.getSelectedDatas();if(0<a.length&&a[0]){return a.length}return 0},getAdditional:function(){var a=["poster_mtime","summary","watched_ratio"];if(this._getCurType()!==SYNO.SDS.VideoStation.Util._TVSHOW_ID||this._checkIsTVEpisode()){a.push("collection")}if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===this._getHistoryInfo().view){a.push("file");a.push("director");a.push("genre")}return a},gotoScroll:function(a){var b=SYNO.SDS.VideoStation.Util.getActiveItem();if(b.onGotoScroll){b.onGotoScroll(a)}},getTimeTitle:function(){var a=this._getCurType();if(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===a){return _VST("video_info","record_time")}else{if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a){return _VST("metadata","play_time")}}return _VST("original_available","title")},getStyleClass:function(d){var e=SYNO.SDS.VideoStation.Util;var c=this._getCurType();var a=(Ext.isDefined(d.type)&&"folder"===d.type);var b;if(c===e._MOVIE_ID||(c===e._TVSHOW_ID&&!this._checkIsByfolder())){b="poster"}else{b="screenshot"}if(a){b=b+"_folder"}return b},getImageURL:function(b){var a=this._getCurType();var c;if(this._checkIsByfolder()&&SYNO.SDS.VideoStation.Util._TVSHOW_ID===a){a=SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID}if(this._checkIsByfolder()&&b.additional&&b.additional.metadata){c=b.additional.metadata.id}else{c=b.id}return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a,id:c,mtime:b.additional?b.additional.poster_mtime||"":""})},onGotoNext:function(e){var f,d,b,c,a;f=e.get("id");a=e.get("additional");if(this._checkIsByfolder()&&"file"===e.get("type")&&a&&a.metadata){f=a.metadata.id}d=(this._checkIsByfolder()&&a)?a.original_available:e.get("original_available");if(this._checkIsByfolder()&&a&&a.summary){b=a.summary}else{b=(e.get("additional")?(e.get("additional").summary||""):"")}if(this._checkIsByfolder()&&a&&a.poster_mtime){c=a.poster_mtime}else{c=(e.get("additional")?(e.get("additional").poster_mtime||""):"")}if(this._checkIsByfolder()&&"folder"===e.get("type")){this._gotoFilterView({params:{id:f,name:e.get("title"),category:"folder"},status:{}})}else{if(!this._checkIsByfolder()&&SYNO.SDS.VideoStation.Util._TVSHOW_ID===this._getCurType()){this._gotoTVSeasonView({params:{id:f,name:e.get("title"),original_available:d,summary:b,poster_mtime:c},status:{}})}else{this._gotoDetileView({params:{id:f,name:e.get("title"),original_available:d,poster_mtime:c},status:{}})}}}});Ext.define("SYNO.SDS.VideoStation.FilteringBaseHttpProxy",{extend:"Ext.data.HttpProxy",constructor:function(a){this.callParent([a])},onRead:function(d,g,b){try{var c=Ext.decode(b.responseText);var a=g.reader.getRoot(c);Ext.each(a,function(i){if(!i.additional||!i.additional.collection){return}var e=i.additional.collection;var h=[];Ext.each(e,function(k){var l=parseInt(k.id,10);var j=k.title;if("syno_favorite"===j){l=-1}else{if("syno_watchlist"===j){l=-2}}h.push({id:l,title:j})},this);i.additional.collection=h},this);b.responseText=Ext.encode(c);SYNO.SDS.VideoStation.FilteringBaseHttpProxy.superclass.onRead.apply(this,arguments)}catch(f){this.fireEvent("loadexception",this,g,b,f);this.fireEvent("exception",this,"response",d,g,b,f);return}}});Ext.define("SYNO.SDS.VideoStation.FilteringList",{extend:"SYNO.ux.GridPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FilteringList",this);this.filteringBase=a.filteringBase;this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.paging=new SYNO.SDS.VideoStation.PagingToolbar({displayInfo:true,store:this.getStore(),filteringBase:this.filteringBase,pageSize:SYNO.SDS.VideoStation.Config.pageSize});var b={cls:"syno-vs-grid syno-vs-list-dataview",store:this.getStore(),enableHdMenu:false,columns:this.getColumnModel(),autoExpandColumn:"title",selModel:new Ext.grid.RowSelectionModel({handleMouseDown:function(h,k,i){var j=SYNO.SDS.VideoStation.Util.getSelectionMode();if(i.button!==0||this.isLocked()){return}var c=this.grid.getView();if(i.shiftKey&&!this.singleSelect&&this.last!==false){var f=this.last;this.selectRange(f,k,i.ctrlKey);this.last=f;c.focusRow(k)}else{var d=this.isSelected(k);if((i.ctrlKey||j)&&d){this.deselectRow(k)}else{if(!d||this.getCount()>1){this.selectRow(k,i.ctrlKey||i.shiftKey||j);c.focusRow(k)}}}},listeners:{scope:this,selectionchange:function(d){if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===this._getHistoryInfo().view){if("SYNO.SDS.VideoStation.FilteringList"!==SYNO.SDS.VideoStation.Util.getFilteringViewLayout()){return}var c=d.getSelections();if(c[0]){Ext.apply(this._getHistoryInfo().status,{selected_id:c[0].get("id")})}}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").fireEvent("afterSelectionChange")}}}),bbar:this.paging,viewConfig:{scrollDelay:false,cacheSize:50},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,rowclick:function(c,i,d){var h=this.getSelectionModel();var g=h.getSelected();var f=SYNO.SDS.VideoStation.Util.getSelectionMode();if(!g){return}if(!d.ctrlKey&&!d.shiftKey&&!f){this.filteringBase.onGotoNext(g)}},activate:this.onActivate,deactivate:this.onDeactivate,rowcontextmenu:function(d,c,f){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").showGridActionMenu(d,c,f)}}};Ext.apply(b,a);return b},getStore:function(){return this.filteringBase.getStore()},getColumnModel:function(){this.colModel=new Ext.grid.ColumnModel({columns:[{header:_VST("common","title"),dataIndex:"title",width:150,renderer:this.titleRender.createDelegate(this)},{align:"center",header:this.filteringBase.getTimeTitle(),width:50,renderer:(function(g,e,a,d,f,b){g=SYNO.SDS.VideoStation.Util.getRecordTime(a);if(g==="0"){return""}var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{align:"center",header:_VST("common","watch_status"),width:50,renderer:(function(g,e,a,c,f,b){var d=a.data.additional.watched_ratio;if(Ext.isDefined(d)&&SYNO.SDS.VideoStation.Util._TVSHOW_ID!==this._getCurId()){d=(0===d?0:Math.floor(d*100));if(100===d){return _VST("advanced","watched")}else{if(0===d){return _VST("advanced","unwatched")}}return String.format("{0} %",d)}else{return""}}).createDelegate(this)}]});return this.colModel},onActivate:function(){this.reconfigure(this.getStore(),this.getColumnModel());this.paging.onActivate()},onDeactivate:function(){},titleRender:function(g,e,b,d,f,c){var a;if(this.checkIsFolderItem(b.data)){a="folder"}else{a=this._getCurType()}return String.format('<div class="title {0}">{1}</div>',a,Ext.util.Format.htmlEncode(g))},checkIsFolderItem:function(a){return(Ext.isDefined(a.type)&&"folder"===a.type)},onGetSelectedDatas:function(){return this.getSelectionModel().getSelections()},onGetSelectedData:function(){return this.getSelectionModel().getSelected()},onGetSelectionModel:function(){return this.getSelectionModel()},onSelectedDatas:function(a){this.getSelectionModel().selectRecords(a)},clearSelections:function(){this.getSelectionModel().clearSelections()},onGotoScroll:function(a){Ext.defer(function(b){var c=this.getView().getRow(b);if(c){this.fleXcrollTo(c)}},Ext.isIE?750:550,this,[a])}});Ext.define("SYNO.SDS.VideoStation.FilteringTile",{extend:"SYNO.ux.GridPanel",poster_summarylength:270,constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FilteringTile",this);this.filteringBase=a.filteringBase;this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.paging=new SYNO.SDS.VideoStation.PagingToolbar({displayInfo:true,store:this.getStore(),filteringBase:this.filteringBase,pageSize:SYNO.SDS.VideoStation.Config.pageSize});var b={cls:"syno-vs-grid syno-vs-grid-collection",store:this.getStore(),autoExpandColumn:"title",enableHdMenu:false,columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({handleMouseDown:function(h,k,i){var j=SYNO.SDS.VideoStation.Util.getSelectionMode();if(i.button!==0||this.isLocked()){return}var c=this.grid.getView();if(i.shiftKey&&!this.singleSelect&&this.last!==false){var f=this.last;this.selectRange(f,k,i.ctrlKey);this.last=f;c.focusRow(k)}else{var d=this.isSelected(k);if((i.ctrlKey||j)&&d){this.deselectRow(k)}else{if(!d||this.getCount()>1){this.selectRow(k,i.ctrlKey||i.shiftKey||j);c.focusRow(k)}}}},listeners:{scope:this,selectionchange:function(d){if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===this._getHistoryInfo().view){if("SYNO.SDS.VideoStation.FilteringTile"!==SYNO.SDS.VideoStation.Util.getFilteringViewLayout()){return}var c=d.getSelections();if(c[0]){Ext.apply(this._getHistoryInfo().status,{selected_id:c[0].get("id")})}}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").fireEvent("afterSelectionChange")}}}),bbar:this.paging,viewConfig:{scrollDelay:false,rowHeight:88,borderHeight:0,cacheSize:50,forceFit:false,rowSelectorDepth:12},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,rowclick:function(c,i,d){var h=this.getSelectionModel();var g=h.getSelected();var f=SYNO.SDS.VideoStation.Util.getSelectionMode();if(!g){return}if(!d.ctrlKey&&!d.shiftKey&&!f){this.filteringBase.onGotoNext(g)}},columnresize:function(){if(Math.abs(this.columnModelwidth-this.getColumnModel().getColumnWidth(1))>10){var c=this.getView();c.refresh()}},resize:function(){if(Math.abs(this.columnModelwidth-this.getColumnModel().getColumnWidth(1))>10){var c=this.getView();c.refresh()}},rowcontextmenu:function(d,c,f){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").showGridActionMenu(d,c,f)}}};Ext.apply(b,a);return b},getStore:function(){return this.filteringBase.getStore()},getColumnModel:function(){this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_VST("poster","title"),dataIndex:"type",width:90,renderer:(function(f,d,a,c,e,b){return this.getIcon(a.data)}).createDelegate(this)},{header:_VST("common","title_and_summary"),id:"title",align:"left",dataIndex:"title",autoExpand:true,renderer:(function(g,e,a,d,f,b){var c=new Ext.Template('<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout"><tbody><tr><td height="18" class="x-table-layout-cell syno-vs-data-cell syno-vs-data-name" valign="top"><div><span>{title}</span></div></td></tr>{summary}</tbody></table>');c.compile();return c.apply({title:this.encodedMsg(a.data.title),summary:this.getSummary(a.data)})}).createDelegate(this)},{id:"time",header:this.filteringBase.getTimeTitle(),width:100,renderer:(function(g,e,a,d,f,b){g=SYNO.SDS.VideoStation.Util.getRecordTime(a);if(g==="0"){return""}var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_VST("common","watch_status"),width:100,renderer:(function(g,e,a,c,f,b){var d=a.data.additional.watched_ratio;e.css="syno-vs-col-watchstatus";if(Ext.isDefined(d)&&SYNO.SDS.VideoStation.Util._TVSHOW_ID!==this._getCurId()){d=(0===d?0:Math.floor(d*100));if(100===d){return _VST("advanced","watched")}else{if(0===d){return _VST("advanced","unwatched")}}return String.format("{0} %",d)}else{return""}}).createDelegate(this)}]});return this.colModel},onActivate:function(){this.reconfigure(this.getStore(),this.getColumnModel());this.paging.onActivate()},onDeactivate:function(){},encodedMsg:function(b,a){return SYNO.SDS.VideoStation.Util.encodedMsg(b,a)},getSummary:function(c){var b="";if(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID!==this._getCurId()){var a=SYNO.SDS.VideoStation.Util.getAddtionalText(c,"summary").substr(0,this.poster_summarylength);b='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-summary" valign="top" rowspan="4"><div><span>'+a+"</span></div></td></tr>"}return b},getIcon:function(c){var b=this._checkIsByfolder()&&c.type==="folder";var a=this.filteringBase.getStyleClass(c);return['<div class="icon '+a+'"','style="',(b?"":String.format(SYNO.SDS.VideoStation.Util.BACKGROUND_IMAGE_STR,this.filteringBase.getImageURL(c))),'">',"</div>"].join("")},onGetSelectedDatas:function(){return this.getSelectionModel().getSelections()},onGetSelectedData:function(){return this.getSelectionModel().getSelected()},onGetSelectionModel:function(){return this.getSelectionModel()},onSelectedDatas:function(a){this.getSelectionModel().selectRecords(a)},clearSelections:function(){this.getSelectionModel().clearSelections()},onGotoScroll:function(a){Ext.defer(function(b){var c=this.getView().getRow(b);if(c){this.fleXcrollTo(c)}},Ext.isIE?750:550,this,[a])}});Ext.define("SYNO.SDS.VideoStation.FilteringThumbnail",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FilteringThumbnail",this);this.filteringBase=a.filteringBase;this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.dataView=new SYNO.SDS.VideoStation.ThumbDataView({moudle:this,filteringBase:this.filteringBase,isHomePage:a.isHomePage});if(a.isHomePage!==true){this.paging=new SYNO.SDS.VideoStation.PagingToolbar({displayInfo:true,store:this.dataView.getStore(),filteringBase:this.filteringBase,pageSize:SYNO.SDS.VideoStation.Config.pageSize})}var b={layout:"fit",bodyStyle:"overflow: visible;",cls:"syno-vs-thumbnail-panel",items:[this.dataView],bbar:this.paging,listeners:{activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onActivate:function(){if(this.paging){this.paging.onActivate()}this.dataView.onActivate()},onDeactivate:function(){this.dataView.onDeactivate()},onGetSelectedDatas:function(){return this.dataView.getSelectedRecords()},onGetSelectedData:function(){return this.dataView.getSelectedRecords()[0]},onGetSelectionModel:function(){return this.dataView},onSelectedDatas:function(a){this.dataView.select(a)},clearSelections:function(){this.dataView.clearSelections()},onGotoScroll:function(a){Ext.defer(function(b){var c=this.dataView.getNode(b);if(c){this.fleXcrollTo(c)}},Ext.isIE?750:550,this,[a])},onSelectionModeChange:function(){var a=SYNO.SDS.VideoStation.Util.getSelectionMode();if(a){this.dataView.simpleSelect=true}else{this.dataView.simpleSelect=false}}});Ext.define("SYNO.SDS.VideoStation.ThumbDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.apply(this,arguments);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoFilterView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ThumbDataView",this);this.loader=new SYNO.SDS.VideoStation.ImageLoadManager();this.filteringBase=a.filteringBase;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={tpl:this.getTpl(),cls:"syno-vs-thumb-dataview",store:this.getStore(),itemSelector:"div.thumb-wrap",overClass:"x-view-over",multiSelect:true!==a.isHomePage,singleSelect:true===a.isHomePage,listeners:{scope:this,click:this.onNodeClick,dblclick:this.onDBClick,activate:this.onActivate,deactivate:this.onDeactivate,selectionchange:this.onSelectionChange,beforeclick:this.onBeforeClick,contextmenu:function(c,d,f,g){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").showActionMenu(c,d,f,g)}}};Ext.apply(b,a);return b},onActivate:function(){this.bindStore(this.getStore())},onDeactivate:function(){this.bindStore(null)},onSelectionChange:function(a,b){if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===this._getHistoryInfo().view){if("SYNO.SDS.VideoStation.FilteringThumbnail"!==SYNO.SDS.VideoStation.Util.getFilteringViewLayout()){return}var c=this.getSelectedRecords()[0];if(c){Ext.apply(this._getHistoryInfo().status,{selected_id:c.get("id")})}}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").fireEvent("afterSelectionChange")},onNodeClick:function(a,b,d,g){var i=a.getStore().getAt(b);var h=SYNO.SDS.VideoStation.Util.getSelectionMode();if(!i){return false}if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===this._getHistoryInfo().view){if(true===i.get("viewMore")){var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.HomePage");var c=f.getRecentlyTabPanel().getActiveTab().category;this._gotoFilterView({params:{name:_VST("classification",c),category:c},status:{}});return}}else{if(!g.ctrlKey&&!g.shiftKey&&!h){this.filteringBase.onGotoNext(i);return}}},onDBClick:function(a,b,d,g){var i=a.getStore().getAt(b);var h=SYNO.SDS.VideoStation.Util.getSelectionMode();if(!i){return false}if(g.ctrlKey||g.shiftKey||h){return}if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE==this._getHistoryInfo().view){var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.HomePage");var c=f.getRecentlyTabPanel().getActiveTab().category;if(true===i.get("viewMore")){this._gotoFilterView({params:{name:_VST("classification",c),category:c},status:{}});return}else{this._gotoFilterView({params:{name:_VST("classification",c),category:c},status:{selected_id:i.get("id")},isFireEvent:false})}}this.filteringBase.onGotoNext(i)},onBeforeClick:function(a,b,c,d){var f=SYNO.SDS.VideoStation.Util.getSelectionMode();if(d.ctrlKey||d.shiftKey||f||this.isHomePage){this.selectedClass="x-view-selected"}else{this.selectedClass=""}},select:function(b,c,a){this.selectedClass="x-view-selected";SYNO.SDS.VideoStation.ThumbDataView.superclass.select.apply(this,arguments)},getStore:function(){return this.filteringBase.getStore()},getTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="thumb-wrap {[this.getStyleClass(values)]} {[this.isViewMore(values)]}">',"{[this.getIcon(values)]}",'<div class="thumb-selected-mask"></div><div class="thumb-selected-icon"></div>','<div class="thumb-title-gradient"></div>','<div class="thumb-title">','<div class="thumb-text-outer">','<div class="thumb-text" {[this.getHideCoverTitleAttr(values)]}>','<div class="thumb-text-inner" ext:qtip="{[this.encodedMsg(this.encodedMsg(values.title))]}">{[this.encodedMsg(values.title)]}</div>',"</div>","</div>","</div>","{[this.getWatchStatusDiv(values)]}","</div>","</tpl>",'<div class="x-clear"></div>',{getStyleClass:this.filteringBase.getStyleClass.createDelegate(this),isViewMore:function(b){if(b.viewMore===true){return"view-more"}return""},getIcon:this.getIcon.createDelegate(this),encodedMsg:function(b){if(b){return Ext.util.Format.htmlEncode(b)}return""},getWatchStatusDiv:this.getWatchStatusDiv.createDelegate(this),getHideCoverTitleAttr:this.getHideCoverTitleAttr.createDelegate(this)});return a},getIcon:function(b){var a=this._checkIsByfolder()&&b.type==="folder";var c=a?"":this.filteringBase.getImageURL(b);if(true===b.viewMore){return String.format('<div class="thumb"></div><div class="thumb-btn"></div>')}return String.format('<div class="thumb {0}" url="{1}"></div>',(a?"":"loading"),Ext.util.Format.htmlEncode(c))},getWatchStatusDiv:function(a){if(true===a.viewMore){return""}return SYNO.SDS.VideoStation.Util.getWatchStatusDiv(a)},getHideCoverTitleAttr:function(d){var c=this._checkIsByfolder()&&d.type==="folder";var b=(this.filteringBase.getStyleClass(d)==="poster"&&(Ext.isDefined(d.additional.poster_mtime)&&d.additional.poster_mtime!==""))?true:false;var a=Ext.isDefined(SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","blHideTitleOnPoster"))?SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","blHideTitleOnPoster"):false;if(a&&!c&&b){return'style="visibility:hidden"'}else{return'style="visibility:visible"'}},refresh:function(){SYNO.SDS.VideoStation.ThumbDataView.superclass.refresh.apply(this,arguments);this.loader.clear();this.preloadItems()},preloadItems:function(){var a=this.getNodes();this.getImageItems(a,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(a){this.getImageItems([a],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(a,b){Ext.each(a,function(f,c,e){var d=Ext.fly(f).select(".thumb");if(0<d.elements.length&&d.item(0).hasClass("loading")){b(d.item(0))}})}});Ext.define("SYNO.SDS.VideoStation.StreamingDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){a=a||{};this.currentTunerID=a.currentTunerID;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:this._getOwner(),width:600,height:_S("is_admin")?300:250,minWidth:300,minHeight:250,title:_VST("programguide","broadcast_streaming"),layout:"fit",plain:true,items:[this.getFormPanel()],buttons:[this.playbtn=new SYNO.ux.Button({btnStyle:"blue",text:_VST("action","play"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.DTVUtil.ableToPlayDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onPlayStreaming}),{btnStyle:"red",text:_VST("streaming","streaming_stop"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onStopStreaming},{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onStopStreaming},{key:27,scope:this,handler:this.close}]};return Ext.apply(b,a)},show:function(){this.setStatusBusy({text:_T("common","loading")});this.basePort=9025;SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","list","1",{additional:"channel_status"},this.getTunerListDone,this);this.callParent(arguments)},getTunerListDone:function(a,g,f){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,g,f));return}if(!g.tuners||0===g.tuners.length){this.clearStatusBusy();return}var c=this.formPanel.tunerCombo.getStore();var d=[];Ext.each(g.tuners,function(j,h,i){if(j&&j.additional&&j.additional.channel_status&&j.additional.channel_status.streaming_id&&-1!==j.additional.channel_status.streaming_id){if(!Ext.isDefined(this.currentTunerID)){this.currentTunerID=j.id}d.push([j.id,j.title])}},this);var b=this.basePort;if(Ext.isDefined(this.currentTunerID)){b=this.currentTunerID%16+b}var e=String.format(_VST("streaming","streaming_description"),b);this.formPanel.getForm().findField("description").setValue(e);c.loadData(d,false);c.sort("display","ASC");if(Ext.isDefined(this.currentTunerID)){this.formPanel.tunerCombo.setValue(this.currentTunerID)}else{this.formPanel.tunerCombo.setValue(0)}SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","getchannel","1",{tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.getChannelDone,this)},getChannelDone:function(a,c,b){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,c,b));return}if(c&&c.streaming_id){SYNO.API.currentManager.requestAPI("SYNO.DTV.Channel","getinfo","1",{id:c.streaming_id,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.getChannelInfoDone,this)}else{this.clearStatusBusy()}},getChannelInfoDone:function(a,d,c){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,d,c));return}var b=this.formPanel.form.findField("channel_name");this.ChannelName=d.channels[0].title;b.setValue(Ext.util.Format.htmlEncode(d.channels[0].title));SYNO.API.currentManager.requestAPI("SYNO.DTV.Statistic","getinfo","1",{},this.getStatistic,this)},getStatistic:function(a,f,d){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,f,d));return}var c=this.formPanel.getForm();var e=c.findField("watchnumber");var b=(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0);Ext.each(f.statistics,function(i,g,h){if(b===i.id){e.setValue(i.brocasting_count);return}},this);this.setupStreamURL()},setupStreamURL:function(){this.clearStatusBusy();var c=this.formPanel.getForm();var b=c.findField("url");var a=window.location.port;var d=window.location.protocol;this.streamUrl=d+"//"+window.location.hostname;this.streamUrl+=!Ext.isEmpty(a)?(":"+a):"";this.streamUrl+="/VideoStation/livestreaming/"+(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0);b.setValue(this.streamUrl);b.selectText(0,b.length)},onStopStreaming:function(){if(_S("demo_mode")){this.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));return}this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","setchannel","1",{id:-1,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.onStopStreamingDone,this)},onStopStreamingDone:function(a,c,b){this.clearStatusBusy();if(!a){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,c,b));return}else{this.owner.mainpanel.mainCardPanel.cardPanel.tunerStatus.restart();this.owner.mainpanel.mainCardPanel.cardPanel.dtvhomepage.getStore().reload();this.close()}},onPlayStreaming:function(){if(this.streamUrl){SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{dtv_url:this.streamUrl,title:this.ChannelName})}},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.StreamingFormpanel({module:this})}return this.formPanel}});Ext.define("SYNO.SDS.VideoStation.StreamingFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.module=a.module;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=Ext.apply({frame:false,border:false,labelWidth:160,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[this.tunerCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dongle","tuner2"),name:"tuner",triggerAction:"all",resizable:false,store:this.createTunerStore(),editable:false,displayField:"display",valueField:"value",value:"no_dongle",mode:"local",listeners:{scope:this,select:this.onChangeTuner}}),{xtype:"syno_displayfield",itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel")},{xtype:"syno_displayfield",itemId:"watchnumber",name:"watchnumber",fieldLabel:_VST("streaming","streaming_watch")},{xtype:"syno_textfield",itemId:"url",name:"url",fieldLabel:_VST("streaming","streaming_url"),width:350,readOnly:true,cls:"selectabletext allowDefCtxMenu"},{xtype:"syno_displayfield",name:"description",value:String.format(_VST("streaming","streaming_description"),"9025~9040"),hidden:!_S("is_admin")}]},a);return b},createTunerStore:function(){this.defTunerValue=["no_dongle",_VST("error","no_dtv_dongle")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defTunerValue]});this.addManagedComponent(a);return a},onChangeTuner:function(e,a,c){this.module.setStatusBusy({text:_T("common","loading")});this.module.currentTunerID=a.data.value;var b=this.module.basePort;if(Ext.isDefined(this.module.currentTunerID)){b=this.module.currentTunerID%16+b}var d=String.format(_VST("streaming","streaming_description"),b);this.getForm().findField("description").setValue(d);SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","getchannel","1",{tuner:Ext.isDefined(this.module.currentTunerID)?this.module.currentTunerID:0},this.module.getChannelDone,this.module)}});Ext.define("SYNO.SDS.VideoStation.RecordingDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:this._getOwner(),width:400,height:200,minWidth:210,minHeight:150,title:_VST("programguide","programguide_recording"),layout:"fit",items:[this.getFormPanel()],buttons:[{btnStyle:"red",text:_VST("record","stop_record"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onStopRecording},{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onStopRecording},{key:27,scope:this,handler:this.close}]};return Ext.apply(b,a)},show:function(){this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","list","1",{additional:"channel_status"},this.getTunerListDone,this);this.callParent(arguments)},getTunerListDone:function(a,e,d){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,e,d));return}if(!e.tuners||0===e.tuners.length){this.clearStatusBusy();return}var b=this.formPanel.tunerCombo.getStore();var c=[];Ext.each(e.tuners,function(h,f,g){if(h&&h.additional&&h.additional.channel_status&&h.additional.channel_status.recording_id&&-1!==h.additional.channel_status.recording_id){if(!Ext.isDefined(this.currentTunerID)){this.currentTunerID=h.id}c.push([h.id,h.title])}},this);b.loadData(c,false);b.sort("display","ASC");if(Ext.isDefined(this.currentTunerID)){this.formPanel.tunerCombo.setValue(this.currentTunerID)}else{this.formPanel.tunerCombo.setValue(0)}SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","list","1",{start:0,limit:-1,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.getRecordingDone,this)},getRecordingDone:function(a,e,c){this.clearStatusBusy();if(!a){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,e,c));return}var b=this.formPanel.form.findField("channel_name");var d=this.formPanel.form.findField("title");Ext.each(e.schedules,function(h,f,g){if(h.status&&"recording"===SYNO.SDS.VideoStation.DTVUtil.programStatus(h.status)){b.setValue(Ext.util.Format.htmlEncode(h.channel_name));d.setValue(h.title)}},this)},onStopRecording:function(){if(_S("demo_mode")){this.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));return}this.getMsgBox().confirm(this.title,_VST("schedule","pause_record"),function(a){if("yes"===a){this.setStatusBusy({text:_T("common","saving")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete","1",{tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},function(b,e,d){this.clearStatusBusy();if(!b){if(e.code<400){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(b,e,d))}else{var c=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(e.code);this.getMsgBox().alert(this.title,c)}}else{this.owner.mainpanel.mainCardPanel.cardPanel.tunerStatus.restart();this.owner.mainpanel.mainCardPanel.cardPanel.dtvhomepage.getStore().reload();this.close()}},this)}},this)},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.RecordingFormpanel({module:this})}return this.formPanel}});Ext.define("SYNO.SDS.VideoStation.RecordingFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=Ext.apply({frame:false,border:false,labelWidth:160,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[this.tunerCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dongle","tuner2"),name:"tuner",triggerAction:"all",resizable:false,store:this.createTunerStore(),editable:false,displayField:"display",valueField:"value",value:"no_dongle",mode:"local",listeners:{scope:this,select:this.onChangeTuner}}),{xtype:"syno_displayfield",itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel")},{xtype:"syno_displayfield",itemId:"title",name:"title",fieldLabel:_VST("programguide","title")}]},a);return b},createTunerStore:function(){this.defTunerValue=["no_dongle",_VST("error","no_dtv_dongle")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defTunerValue]});this.addManagedComponent(a);return a},onChangeTuner:function(c,a,b){this.module.setStatusBusy({text:_T("common","loading")});this.module.currentTunerID=a.data.value;SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","list","1",{start:0,limit:-1,tuner:Ext.isDefined(this.module.currentTunerID)?this.module.currentTunerID:0},this.module.getRecordingDone,this.module)}});Ext.define("SYNO.SDS.VideoStation.SignalMenu",{extend:"SYNO.ux.Menu",constructor:function(b){var a={cls:"syno-vs-signal-panel",items:[this.getPanel()],defaultOffsets:[34,0],listeners:{scope:this,beforeshow:function(){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");this.getPanel().loadData(c.tuners)}}};this.callParent([Ext.apply(a,b)])},getPanel:function(){if(this.panel){return this.panel}this.panel=new SYNO.SDS.VideoStation.SignalPanel({tuners:this.tuners});return this.panel}});Ext.define("SYNO.SDS.VideoStation.SignalPanel",{extend:"SYNO.ux.Panel",constructor:function(b){this.tuners=b.tuners||[];var a={shadow:false,frame:true,footer:true,layout:"fit",autoHeight:true,items:this.getDataView()};this.callParent([Ext.apply(a,b)])},getDataView:function(){if(this.dataview){return this.dataview}this.dataview=new Ext.DataView({itemSelector:"div.item",emptyText:"No tuner",itemId:"dataview",cls:"syno-vs-dtv-signalpanel-dataview",store:this.getStore(),tpl:new Ext.XTemplate('<div class="header-text">'+_VST("dongle","signal_strength")+"</div>",'<tpl for=".">','<div class="item">','<div class="image-{values.signal}"></div>','<span class="title">{values.title}</span>',"</div>","</tpl>",{compiled:true,disableFormats:true})});return this.dataview},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.ArrayStore({data:[],idIndex:0,autoDestroy:true,fields:["id","title","signal"]});this.addManagedComponent(this.store);return this.store},getItems:function(){var a=[];Ext.each(this.tuners,function(b){if(!Ext.isNumber(b.signal)||b.signal<=0){return true}var c=Ext.min([100,Math.ceil(b.signal/20)*20]);a.push([b.id,b.title,c])},this);return a},loadData:function(a){this.tuners=a;this.getStore().loadData(this.getItems(),false)}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.CardPanel",{extend:"SYNO.ux.Panel",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoFilterView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.CardPanel",this);this.addEvents("afterOptionsSettingChange");this.addListener("afterOptionsSettingChange",this.eventOptionsSettingChange,this);this.pathBar=new SYNO.SDS.VideoStation.PathBar({scope:this});var d=(function(){var f=0;a.items.each(function(h){if(true!==h.hidden){try{f+=h.getOuterSize().width}catch(i){}}});f-=this.pathBar.tbPanel.getWidth();var e=a.getWidth()-a.getResizeEl().getPadding("lr")-2;var g=e-f;if(g>0){this.pathBar.setWidth(g)}}).createDelegate(this);var a=new Ext.Toolbar({toolbarCls:"syno-vs-path-bar",itemId:"topToolbar",enableOverflow:false,autoHeight:true,items:[this.getScanBtn(),this.getEditChannelBtn(),this.getScheduleRecordBtn(),this.pathBar.getPanel(),"->",{xtype:"syno_button",cls:"dtv-signal",itemId:"showsignal",hidden:true,menu:new SYNO.SDS.VideoStation.SignalMenu(),menuAlign:"tr-br",getMenuClass:Ext.emptyFn},{xtype:"syno_button",tooltip:_VST("programguide","programguide_recording"),cls:"dtv-showrecording",itemId:"showrecording",disabled:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),hidden:true,scope:this,handler:function(){var e=new SYNO.SDS.VideoStation.RecordingDialog();e.show()}},{xtype:"syno_button",tooltip:_VST("programguide","broadcast_streaming"),cls:"dtv-showstreaming",itemId:"showstreaming",hidden:true,scope:this,handler:function(){if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("dtv","error_disabled"))}else{var e=new SYNO.SDS.VideoStation.StreamingDialog();e.show()}}},this.getPlayerButton(),this.getFolderButton(),this.getAllButton()],listeners:{buffer:100,show:d,resize:d,scope:this}});this.toolbar=a;this.showrecordingbtn=a.getComponent("showrecording");this.showstreamingbtn=a.getComponent("showstreaming");this.showsignalbtn=a.getComponent("showsignal");this.filteringBase=new SYNO.SDS.VideoStation.FilteringBase();this.groupgrid=new SYNO.SDS.VideoStation.ViewTVseason({itemId:"groupgrid",owner:this});this.homepage=new SYNO.SDS.VideoStation.HomePage({itemId:"homepage",owner:this});this.dtvhomepage=new SYNO.SDS.VideoStation.DTVHomePage({itemId:"dtvhomepage",owner:this});this.filteringList=new SYNO.SDS.VideoStation.FilteringList({itemId:"filtering_list",filteringBase:this.filteringBase});this.filteringTile=new SYNO.SDS.VideoStation.FilteringTile({itemId:"filtering_tile",filteringBase:this.filteringBase});this.filteringThumbnail=new SYNO.SDS.VideoStation.FilteringThumbnail({itemId:"filtering_thumbnail",filteringBase:this.filteringBase});this.metadata=new SYNO.SDS.VideoStation.ViewMetaData({itemId:"metadata"});this.grid=new SYNO.SDS.VideoStation.ViewGrid({itemId:"grid"});this.collection=new SYNO.SDS.VideoStation.ViewCollection();var c={activeItem:0,layout:"card",tbar:a,items:[this.homepage,this.dtvhomepage,this.filteringList,this.filteringTile,this.filteringThumbnail,this.metadata,this.grid,this.collection,this.groupgrid],border:false};Ext.apply(c,b);SYNO.SDS.VideoStation.CardPanel.superclass.constructor.call(this,c);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoToPanel",this.eventGoToPanel,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoSwitchFilterView",this.eventGoSwitchFilter,this)},eventGoToPanel:function(){var a=this._getCurType();var b=this._getHistoryInfo();this.showrecordingbtn.hide();this.showstreamingbtn.hide();this.showsignalbtn.hide();if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a){this.getTunerStatus();this.tunerStatus.restart();this.getAllButton().setText(_VST("classification","recorded"))}else{if(this.tunerStatus){this.tunerStatus.stop()}this.getAllButton().setText(_VST("classification","all"))}if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===b.view){SYNO.SDS.VideoStation.Util._loadFilterBaseStore({offset:b.status.offset,limit:b.status.limit})}if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===b.view){this.getAllButton().show()}else{this.getAllButton().hide()}this.scanBtn.hide();this.editChannelBtn.hide();this.scheduleRecordBtn.hide();if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===b.view&&SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a){this.getEl().unmask();if(SYNO.SDS.VideoStation.Util.ableToControlDTV()){this.scanBtn.show();this.editChannelBtn.show();this.scheduleRecordBtn.show()}}if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this.scanBtn.disable();this.editChannelBtn.disable();this.scheduleRecordBtn.disable()}else{this.scanBtn.enable();this.editChannelBtn.enable();this.scheduleRecordBtn.enable()}if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===b.view&&SYNO.SDS.VideoStation.Util._TV_RECORDER_ID!==a){this.getFolderButton().show()}else{this.getFolderButton().hide()}this.toolbar.syncSize();this.eventGoSwitchFilter()},eventGoSwitchFilter:function(){var e=this._getHistoryInfo();var f=this.layout.activeItem;var a;var b=this._getCurType();if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===e.view){if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID!==b){a="SYNO.SDS.VideoStation.HomePage"}else{a="SYNO.SDS.VideoStation.DTVHomePage"}}else{if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===e.view){a=SYNO.SDS.VideoStation.Util.getFilteringViewLayout()}else{if(SYNO.SDS.VideoStation.Util._VIEW_DETAIL===e.view){a="SYNO.SDS.VideoStation.ViewMetaData"}else{if(SYNO.SDS.VideoStation.Util._VIEW_EPISODE===e.view){a="SYNO.SDS.VideoStation.ViewTVseason"}else{if(SYNO.SDS.VideoStation.Util._VIEW_GRID===e.view){a="SYNO.SDS.VideoStation.ViewGrid"}else{if(SYNO.SDS.VideoStation.Util._VIEW_COLLECTION===e.view){a="SYNO.SDS.VideoStation.ViewCollection"}}}}}}var c=SYNO.SDS.VideoStation.Window.getPanelScope(a);if(f!==c){var d;if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===e.view&&(f.itemId==="filtering_list"||f.itemId==="filtering_tile"||f.itemId==="filtering_thumbnail")){d=f.onGetSelectedDatas()}this.layout.setActiveItem(c);if(d){c.onSelectedDatas(d)}}else{if(c.onActivate){c.onActivate()}}},onGetSelectedData:function(){var a=this.layout.activeItem;if(a.onGetSelectedData){return a.onGetSelectedData()}return undefined},onGetSelectedDatas:function(){var a=SYNO.SDS.VideoStation.Util.getActiveItem();var b=[];if(a.onGetSelectedDatas){b=a.onGetSelectedDatas()}else{b=[this.onGetSelectedData()]}return b},getTunerStatus:function(){if(!this.tunerStatus){this.tunerStatus=this.addTask({interval:8000,scope:this,run:function(){SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","list","1",{additional:"channel_status"},this.getTunerListDone,this)}})}},getTunerListDone:function(h,c,b){var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel");var g=f.getTBar().getComponent("digitaltv");var k=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");if(!h||!c||!c.tuners||0===c.tuners.length){if(!this.showNoDongle&&SYNO.SDS.VideoStation.Util.ableToControlDTV()){if(true!==SYNO.SDS.VideoStation.gData.disable_dtv&&SYNO.SDS.VideoStation.Window.isVisible()){var a=String.format('<a target="_blank" class="link-font" href="https://www.synology.com/en-global/knowledgebase/faq/532">{0}</a>',_VST("common","synology_website"));var i=String.format(_VST("error","dtv_request_dongle2"),a);this._getOwner().getMsgBox().alert(_VST("type","tv_recorder"),i)}this.showNoDongle=true}k.hasDongle=false;g.setDisabled(true);this.showstreamingbtn.hide();this.showrecordingbtn.hide();this.showsignalbtn.hide();f.updateReloadTunerInfo(null);return}k.hasDongle=true;if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===this._getCurId()){g.setDisabled(false);f.updateScheduleMenuItems(c.tuners);var d=false,e=false,j=false;Ext.each(c.tuners,function(n,l,m){if(-1!==n.additional.channel_status.streaming_id){d=true}if(-1!==n.additional.channel_status.recording_id){e=true}if(n.signal&&n.signal>0){j=true}if(n.id===k.tunerInfo.id){k.enableAllStreamHandler(-1===n.additional.channel_status.recording_id)}},this);if(d){this.showstreamingbtn.show()}else{this.showstreamingbtn.hide()}if(e){this.showrecordingbtn.show()}else{this.showrecordingbtn.hide()}if(j){this.showsignalbtn.show()}else{this.showsignalbtn.hide()}this.tuners=c.tuners}this.toolbar.syncSize()},getScanBtn:function(){if(this.scanBtn){return this.scanBtn}this.scanBtn=new SYNO.ux.Button({tooltip:_VST("action","channelscan"),cls:"dtv-btn dtv-scan-btn",scope:this,handler:function(){var a=new SYNO.SDS.VideoStation.ChannelScanDialog({owner:SYNO.SDS.VideoStation.Window,closeAction:"close",tunerInfo:this.dtvhomepage.tunerInfo});a.open()}});return this.scanBtn},getEditChannelBtn:function(){if(this.editChannelBtn){return this.editChannelBtn}this.editChannelBtn=new SYNO.ux.Button({tooltip:_VST("action","channeledit"),cls:"dtv-btn dtv-edit-btn",scope:this,handler:function(){this.dtvhomepage.getEl().mask(_T("common","loading"),"x-mask-loading");var a={tuner:this.dtvhomepage.tunerInfo.id,ishomepage:true,offset:0,limit:-1};SYNO.API.currentManager.requestAPI("SYNO.DTV.Channel","list",1,a,this.dtvhomepage.editBtnListDone,this.dtvhomepage)}});return this.editChannelBtn},getScheduleRecordBtn:function(){if(this.scheduleRecordBtn){return this.scheduleRecordBtn}this.scheduleRecordBtn=new SYNO.ux.Button({tooltip:_VST("schedule","schedule_recording"),cls:"dtv-btn dtv-record-btn",scope:this,handler:function(){var a=new SYNO.SDS.VideoStation.ProgramScheduleDialog({tunerInfo:this.dtvhomepage.tunerInfo,activeItem:1});a.open()}});return this.scheduleRecordBtn},getPlayerButton:function(){if(this.playerBtn){return this.playerBtn}var b=new SYNO.VideoController2.PlayerMenu({cls:"no-tick",defaultOffsets:[0,0],addStreamingItem:Ext.emptyFn,selectPlayer:function(c){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData").playVideo(c.id)}});var a={tooltip:_VST("controller","tooltip_player"),cls:"player",itemId:"player",hidden:true,scope:this,getMenuClass:Ext.emptyFn,menuAlign:"tr-br",menu:b};this.playerBtn=new SYNO.ux.Button(a);return this.playerBtn},getAllButton:function(){if(this.allBtn){return this.allBtn}var a=function(){var b=this._getCurType();var c={};if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===b){c={name:_VST("classification","recently_added"),category:"recently_added"}}else{c={name:_VST("classification","all"),category:"all"}}this._gotoFilterView({params:c,status:{}})};this.allBtn=new SYNO.ux.Button({cls:"all-btn",text:_VST("classification","all"),handler:a,scope:this});return this.allBtn},getFolderButton:function(){if(this.folderBtn){return this.folderBtn}var a=function(){this._gotoFilterView({params:{name:_VST("classification","folder"),category:"folder"},status:{}})};this.folderBtn=new SYNO.ux.Button({cls:"folder-btn",text:_VST("classification","folder"),handler:a,scope:this});return this.folderBtn},getSelectionMode:function(){return SYNO.SDS.VideoStation.Util.getSelectionMode()},onSelectionModeChange:function(){var a=this._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING!==a.view&&SYNO.SDS.VideoStation.Util._VIEW_EPISODE!==a.view){return}var c=this.layout.activeItem;var b=SYNO.SDS.VideoStation.Util.getSelectionMode();this.filteringThumbnail.onSelectionModeChange();if(!b){if(c.clearSelections){c.clearSelections()}}},eventOptionsSettingChange:function(){var a=this._getHistoryInfo();if((SYNO.SDS.VideoStation.Util._VIEW_FILTERING===a.view&&this.layout.activeItem.itemId==="filtering_thumbnail")||SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===a.view){SYNO.SDS.VideoStation.Util._gotoViewAgain()}}});Ext.define("SYNO.SDS.VideoStation.MainToolBar.SortButton",{extend:"SYNO.ux.Button",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.MainToolBar.SortButton",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-sort-btn",tooltip:_VST("action","sort"),getMenuClass:Ext.emptyFn,disabled:true,menu:this.getSortMenu()};Ext.apply(b,a);return b},getSortMenu:function(){if(this.sortMenu){return this.sortMenu}this.sortMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[{itemId:"item_title",text:String.format(_VST("sort","sort_by"),_VST("common","title")),iconCls:"syno-vs-tbar-sel-sort",listeners:{click:{fn:function(a){this.onChangeSortItem(a)},scope:this}}},{itemId:"item_added",text:String.format(_VST("sort","sort_by"),_VST("sort","added_time")),listeners:{click:{fn:function(a){this.onChangeSortItem(a)},scope:this}}},{itemId:"item_released",text:String.format(_VST("sort","sort_by"),_VST("sort","released_time")),listeners:{click:{fn:function(a){this.onChangeSortItem(a)},scope:this}}},"-",{itemId:"order_asc",text:_VST("sort","order_asc"),iconCls:"syno-vs-tbar-sel-sort",listeners:{click:{fn:function(a){this.onChangeSortOrder(a)},scope:this}}},{itemId:"order_desc",text:_VST("sort","order_desc"),listeners:{click:{fn:function(a){this.onChangeSortOrder(a)},scope:this}}}],listeners:{scope:this,beforeshow:function(){var b;var a=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance",this._getCurType()+"sortstate");if(a&&a.sort_direction&&"desc"===a.sort_direction){b="order_desc"}else{b="order_asc"}this.onChangeSortOrder(this.sortMenu.items.get(b),true);b="item_title";if(a){switch(a.sort_by){case"added":b="item_added";break;case"date":b="item_released";break;default:break}}this.onChangeSortItem(this.sortMenu.items.get(b),true)}}});this.addManagedComponent(this.sortMenu);return this.sortMenu},getParamSortBy:function(){var a=this.sort_item||"item_title";switch(a){case"item_title":return"title";case"item_added":return"added";case"item_released":return"date";default:return"title"}},getParamSortOrder:function(){var a=this.sort_order||"order_asc";switch(a){case"order_asc":return"asc";case"order_desc":return"desc";default:return"asc"}},onChangeSortItem:function(c,b){var a=c.itemId;if(this.sort_item!=a){this.sort_item=a;c.parentMenu.items.each(function(d){if(d.itemId===a){d.setIconClass("syno-vs-tbar-sel-sort")}else{if(d.itemId&&d.itemId.substr(0,5)==="item_"){d.setIconClass(undefined)}}});if(true!==b){SYNO.SDS.VideoStation.Util._loadFilterBaseStore({sort_by:this.getParamSortBy(),sort_direction:this.getParamSortOrder()})}}},onChangeSortOrder:function(c,b){var a=c.itemId;if(this.sort_order!=a){this.sort_order=a;c.parentMenu.items.each(function(d){if(d.itemId===a){d.setIconClass("syno-vs-tbar-sel-sort")}else{if(d.itemId&&d.itemId.substr(0,6)==="order_"){d.setIconClass(undefined)}}});if(true!==b){SYNO.SDS.VideoStation.Util._loadFilterBaseStore({sort_by:this.getParamSortBy(),sort_direction:this.getParamSortOrder()})}}}});Ext.define("SYNO.SDS.VideoStation.MainCardPanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_gotoHomePage","_goSwitchFilterView"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.MainCardPanel",this);this.callParent([this.fillConfig(a)]);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoToPanel",this.eventGoToPanel,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterSelectionChange",this.updateActionBtn,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoSwitchFilterView",this.updateActionBtn,this)},fillConfig:function(a){this.cardPanel=new SYNO.SDS.VideoStation.CardPanel({itemId:"grid",baseCls:"vs-x-panel"});var b={cls:"syno-vs-card",layout:"fit",tbar:this.getTBar(),items:[this.cardPanel]};Ext.apply(b,a);return b},getTBar:function(){if(this.toolbar){return this.toolbar}var a=[{text:_VST("action","start"),itemId:"action",menu:this.getActionMenu(),cls:"syno-vs-action"},{text:_VST("action","settings"),itemId:"settings",handler:function(){this.launchSettingDialog(0)},scope:this},{text:_VST("dtv","title"),itemId:"digitaltv",hidden:true,menu:this.getTunerMenu(),cls:"syno-vs-action"},"->",{cls:"syno-vs-selectionmode-btn",itemId:"selection_mode",tooltip:_VST("common","selection_mode"),enableToggle:true,hidden:true,listeners:{scope:this,toggle:function(c){this.onSelectionModeChange()}}},this.getViewModeGroupBtn(),this.getSortBtn(),{cls:"syno-vs-expand-btn",tooltip:_VST("action","expand_seasons")+" / "+_VST("action","collapse_seasons"),itemId:"expand",hidden:true,getMenuClass:Ext.emptyFn,menu:(this.expaneMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:this.getSeasonActionGroup().getArray(),listeners:{scope:this,beforeshow:this.onShowHideSeason}}))}];var b=new SYNO.ux.Toolbar({cls:"syno-vs-toolbar",items:a});this.digitaltvbtn=b.getComponent("digitaltv");this.toolbar=b;return this.toolbar},getSortBtn:function(){if(this.sortBtn){return this.sortBtn}this.sortBtn=new SYNO.SDS.VideoStation.MainToolBar.SortButton({itemId:"sort"});return this.sortBtn},getActionMenu:function(){if(!this.actionMenu){this.actionMenu=new SYNO.SDS.VideoStation.ActionMenu({});this.actionMenu.updateActionMenuItems()}return this.actionMenu},getSelectionMode:function(){var a=this.getTBar().getComponent("selection_mode");return a.pressed},launchSettingDialog:function(a,b){var c=new SYNO.SDS.VideoStation.SettingDialog(b);c.open(a)},getSeasonActionGroup:function(){if(this.seasonAction){return this.seasonAction}var a=SYNO.SDS.VideoStation.Util;var b=a._createAction({itemId:"collapse_seasons",handler:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewTVseason").onExpandCollapseSeasons(false)},scope:this});var c=a._createAction({itemId:"expand_seasons",handler:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewTVseason").onExpandCollapseSeasons(true)},scope:this});return(this.seasonAction=new SYNO.SDS.Utils.ActionGroup([b,c]))},onShowHideSeason:function(){var a=SYNO.SDS.VideoStation.Util.getActiveItem();if(a.hasSeasons()){this.getSeasonActionGroup().get("collapse_seasons")[a.isOneExpandSeason()?"show":"hide"]();this.getSeasonActionGroup().get("expand_seasons")[a.isOneCollapseSeason()?"show":"hide"]()}else{this.getSeasonActionGroup().hideAll()}},getTunerMenu:function(){if(!this.tunerMenu){this.tunerMenu=new SYNO.ux.Menu({cls:"syno-ux-groupcheck-menu",items:[]});this.addManagedComponent(this.tunerMenu)}return this.tunerMenu},getViewModeGroupBtn:function(){if(this.viewModeGroupBtn){return this.viewModeGroupBtn}this.viewModeGroupBtn=new SYNO.SDS.VideoStation.ViewModeGroupBtn({cls:"syno-vs-filtering-viewmode-btn",itemId:"display_button_group",hidden:true,activeBtn:2,autoBtnWidth:false,buttons:[{itemId:"filtering_list",tooltip:_VST("common","mode_list")},{itemId:"filtering_tile",tooltip:_VST("common","mode_tile")},{itemId:"filtering_thumbnail",tooltip:_VST("poster","title")}],listeners:{scope:this,activebuttonchange:function(a,b){this._goSwitchFilterView()}}});return this.viewModeGroupBtn},updateScheduleMenuItems:function(f){var d=[];this.tunerMenu.removeAll(true);var e=this.digitaltvbtn.getText();var a=true;var b={FE_QPSK:0,FE_QAM:1,FE_OFDM:2,FE_ATSC:3};Ext.each(f,function(i,g,h){if((b.FE_QPSK==i.type)&&(_S("version")<3731)&&(-1!==_D("unique").indexOf("x86")||-1!==_D("unique").indexOf("cedarview")||-1!==_D("unique").indexOf("bromolow"))){return}d.push(new Ext.menu.CheckItem({itemId:i.id,group:"tuners",handler:this.updateReloadTunerInfo,text:i.title,type:i.type,scope:this}));if(e===i.title){d.last().setChecked(true);a=false}},this);Ext.each(d,function(i,g,h){this.tunerMenu.addItem(i)},this);if(a){var c=this.tunerMenu.items.get(0);c.setChecked(true);this.updateReloadTunerInfo(c)}},updateReloadTunerInfo:function(c,d){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var a=Ext.isObject(b.tunerInfo)?b.tunerInfo.id:-1;b.tunerInfo={id:-1,title:_VST("dtv","title"),type:-1};if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this.digitaltvbtn.setText(_VST("dtv","title"));b.updateMaskInfo(false,false);return}else{if(Ext.isEmpty(c)){this.digitaltvbtn.setText(_VST("dtv","title"));b.updateMaskInfo(true,false);return}}this.digitaltvbtn.setText(c.text);b.getStore().setBaseParam("tuner",c.itemId);b.tunerInfo={id:c.itemId,title:c.text,type:c.type};if(SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE!==SYNO.SDS.VideoStation.Util._getHistoryInfo().view&&!Ext.isEmpty(d)){this._gotoHomePage({})}if(a!==c.itemId){b.getStore().load()}},launchProgramScheduleDialog:function(b,d){var c={id:b.itemId,title:b.text,type:b.type};var a=new SYNO.SDS.VideoStation.ProgramScheduleDialog({tunerInfo:c});a.open()},getSelectedDatas:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas()},updateActionBtn:function(){var g=this._getHistoryInfo();var e=this._getCurType();var h=SYNO.SDS.VideoStation.Util;var f=this.getTBar().getComponent("action");f.enable();f.menu.onUpdateMenu();if(!f.menu.hasVisibleMenu()){f.disable()}if(h._VIEW_DETAIL===g.view||h._VIEW_EPISODE===g.view){return}var b=(this.getSelectedDatas().length>0);var d=SYNO.SDS.VideoStation.Util.getBlSelectedFolder();var c=(this.getSelectedDatas().length>1);var a=this._checkIsByfolder();if(!b){f.disable()}if(d&&c){f.disable()}if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===g.view&&e===SYNO.SDS.VideoStation.Util._TVSHOW_ID&&c&&!a){f.disable()}},showActionMenu:function(a,b,c,d){if(!a.isSelected(b)){a.select(b,false)}if(!this.getTBar().getComponent("action").disabled){this.getActionMenu().showAt(d.getXY())}},showGridActionMenu:function(a,d,b){var c=a.getSelectionModel();if(!c.isSelected(d)){c.selectRow(d)}if(!this.getTBar().getComponent("action").disabled){this.getActionMenu().showAt(b.getXY())}},eventGoToPanel:function(){var a=this._getCurType();var c=this._getHistoryInfo();var b=this._getCurCategory();this.updateActionBtn();if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a&&SYNO.SDS.VideoStation.Util.ableToControlDTV()){this.digitaltvbtn.show()}else{this.digitaltvbtn.hide()}if(SYNO.SDS.VideoStation.Util._COLLECTION_ID!==a&&SYNO.SDS.VideoStation.Util._VIEW_FILTERING===c.view){this.toolbar.getComponent("display_button_group").show()}else{this.toolbar.getComponent("display_button_group").hide()}if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===c.view||SYNO.SDS.VideoStation.Util._VIEW_EPISODE===c.view){this.toolbar.getComponent("selection_mode").show()}else{this.toolbar.getComponent("selection_mode").hide()}this.toolbar.getComponent("selection_mode").toggle(false);if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===c.view){this.toolbar.getComponent("sort").show();if("all"===b){this.toolbar.getComponent("sort").enable()}else{this.toolbar.getComponent("sort").disable()}}else{this.toolbar.getComponent("sort").hide()}this.toolbar.getComponent("expand").setVisible(SYNO.SDS.VideoStation.Util._VIEW_EPISODE===c.view)},onSelectionModeChange:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onSelectionModeChange()}});Ext.define("SYNO.SDS.VideoStation.ViewModeGroupBtn",{extend:"SYNO.ux.StateButtonGroup",constructor:function(){this.callParent(arguments)},getSingleBtnConfig:function(b,a){if(b.width){this.autoBtnWidth=false}return{id:b.id,itemId:b.itemId,text:b.text||"",width:b.width,minWidth:b.minWidth,iconCls:b.iconCls||"",cls:this.getBtnCls(b.cls,a),disabled:b.disabled,tooltip:b.tooltip||"",xtype:"syno_button",scope:this,handler:this.onClickBtnGeneralHandler}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.PathBar=Ext.extend(Ext.Component,{constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getHistoryAll"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.PathBar",this);this.init();SYNO.SDS.VideoStation.PathBar.superclass.constructor.apply(this,arguments);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"afterGoToPanel",this.eventGoToPanel,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"updatePathBar",this.eventGoToPanel,this)},init:function(){this.tbPanel=new SYNO.SDS.VideoStation.PathButtonsPanel({cls:"syno-vs-ux-pathtoolbar"});return this},addPathButton:function(f,e,c,g,b,d,a){return this.tbPanel.addButton(f,e,c,g,b,d,a)},updatePathButton:function(e,d,c,f,b,a){return this.tbPanel.updateButton(e,d,c,f,b,a)},addPathButtons:function(c){var b=(this.tbPanel.items.length<c.length)?c.length:this.tbPanel.items.length;var d=c.length-1;for(var a=0;a<b;a++){if(a<this.tbPanel.items.length&&a<c.length){this.updatePathButton(a,c[a].text,c[a].tooltip,c[a].callback,c[a].scope,a===d)}else{if(a<c.length){this.addPathButton(this.tbPanel.items.length,c[a].text,c[a].tooltip,c[a].callback,c[a].scope,a===0,a===d)}else{this.removePathButtons(a,b);break}}}this.tbPanel.setActiveButton(this.tbPanel.items[this.tbPanel.items.length-1])},removePathButtons:function(b,a){this.tbPanel.removeButtons(b,a)},setWidth:function(a){this.tbPanel.setWidth(a)},getPanel:function(){return this.tbPanel},onClickBtn:function(a){this._gobackPanel(a)},eventGoToPanel:function(){this.getPanel().show();var e=this._getHistoryAll();var c=[];var b=0;for(b=0;b<e.length;b++){var d=this._getHistoryInfo(this.curID,b);var a=SYNO.SDS.VideoStation.Util.encodedMsg(d.params.name);c[b]={text:Ext.util.Format.ellipsis(a,100),tooltip:a,callback:this.onClickBtn.createDelegate(this,[b])}}this.addPathButtons(c)}});SYNO.SDS.VideoStation.PathButtonsPanel=Ext.extend(Ext.BoxComponent,{activeButton:null,enableScroll:true,scrollIncrement:0,scrollRepeatInterval:400,scrollDuration:0.35,animScroll:true,buttonWidthSet:false,allowDomMove:false,onRender:function(){SYNO.SDS.VideoStation.PathButtonsPanel.superclass.onRender.call(this,arguments);this.mon(this,"resize",this.delegateUpdates);this.items=[];var a=Ext.get(this.el);this.stripWrap=a.createChild({cls:"ux-pathbuttons-strip-wrap",cn:{tag:"ul",cls:"ux-pathbuttons-strip"}});this.stripSpacer=a.createChild({cls:"ux-pathbuttons-strip-spacer"});this.strip=new Ext.Element(this.stripWrap.dom.firstChild);this.edge=this.strip.createChild({tag:"li",cls:"ux-pathbuttons-edge"});this.strip.createChild({cls:"x-clear"});this.addEvents("updatepath")},addButton:function(c,f,i,e,h,b,g){var d=this.strip.createChild({tag:"li"},this.edge);var a=new SYNO.SDS.VideoStation.PathBar.PathButton(this,d,c,f,i,e,h,b,g);this.items.push(a);if(!this.buttonWidthSet){this.lastButtonWidth=a.container.getWidth()}this.addManagedComponent(a);return a},updateButton:function(f,e,d,g,c,b){var a=this.items[f];a.updateButton(e,d,g,c,b)},removeButtons:function(f,e){var a;var c;for(var b=f;b<e;b++){c=this.items[b];a=document.getElementById(c.container.id);this.removeManagedComponent(c);c.purgeListeners();c.destroy();a.parentNode.removeChild(a)}var d=[];for(b=0;b<f;b++){d.push(this.items[b])}this.items=d;this.delegateUpdates()},setActiveButton:function(a){this.activeButton=a;this.delegateUpdates()},delegateUpdates:function(){if(this.enableScroll&&this.rendered){this.onAutoScroll()}},onAutoScroll:function(){var e=this.items.length;var c=this.el.dom.clientWidth;var d=this.stripWrap;var b=d.dom.offsetWidth;var f=this.getScrollPos();var a=this.edge.getOffsetsTo(this.stripWrap)[0]+f;if(!this.enableScroll||e<1||b<20){return}d.setWidth(c);if(a<=c){d.dom.scrollLeft=0;if(this.scrolling){this.scrolling=false;this.el.removeClass("x-pathbuttons-scrolling");this.scrollLeft.hide();this.scrollRight.hide()}}else{if(!this.scrolling){this.el.addClass("x-pathbuttons-scrolling")}c-=d.getMargins("lr");d.setWidth(c>20?c:20);if(!this.scrolling){if(!this.scrollLeft){this.createScrollers()}else{this.scrollLeft.show();this.scrollRight.show()}}this.scrolling=true;if(f>(a-c)){d.dom.scrollLeft=a-c}else{this.scrollToButton(this.activeButton,false)}this.updateScrollButtons()}},createScrollers:function(){var c=this.el.dom.offsetHeight;var a=this.el.insertFirst({cls:"ux-pathbuttons-scroller-left"});a.setHeight(c);a.addClassOnOver("over");this.leftRepeater=new Ext.util.ClickRepeater(a,{interval:this.scrollRepeatInterval,handler:this.onScrollLeft,scope:this});this.scrollLeft=a;var b=this.el.insertFirst({cls:"ux-pathbuttons-scroller-right"});b.setHeight(c);b.addClassOnOver("over");this.rightRepeater=new Ext.util.ClickRepeater(b,{interval:this.scrollRepeatInterval,handler:this.onScrollRight,scope:this});this.scrollRight=b},getScrollWidth:function(){return this.edge.getOffsetsTo(this.stripWrap)[0]+this.getScrollPos()},getScrollPos:function(){return parseInt(this.stripWrap.dom.scrollLeft,10)||0},getScrollArea:function(){return parseInt(this.stripWrap.dom.clientWidth,10)||0},getScrollAnim:function(){return{duration:this.scrollDuration,callback:this.updateScrollButtons,scope:this}},getScrollIncrement:function(){return(this.scrollIncrement||this.lastButtonWidth+2)},scrollToButton:function(e,a){if(!e.el.dom){return}e=e.el.dom.parentNode;if(!e){return}var c=e;var g=this.getScrollPos(),d=this.getScrollArea();var f=Ext.fly(c).getOffsetsTo(this.stripWrap)[0]+g;var b=f+c.offsetWidth;if(f<g){this.scrollTo(f,a)}else{if(b>(g+d)){this.scrollTo(b-d,a)}}},scrollTo:function(b,a){this.stripWrap.scrollTo("left",b,a?this.getScrollAnim():false);if(!a){this.updateScrollButtons()}},onScrollRight:function(){var a=this.getScrollWidth()-this.getScrollArea();var c=this.getScrollPos();var b=Math.min(a,c+this.getScrollIncrement());if(b!=c){this.scrollTo(b,this.animScroll)}},onScrollLeft:function(){var b=this.getScrollPos();var a=Math.max(0,b-this.getScrollIncrement());if(a!=b){this.scrollTo(a,this.animScroll)}},updateScrollButtons:function(){var a=this.getScrollPos();this.scrollLeft[a==0?"addClass":"removeClass"]("disabled");this.scrollRight[a>=(this.getScrollWidth()-this.getScrollArea())?"addClass":"removeClass"]("disabled")}});SYNO.SDS.VideoStation.PathBar.PathButton=function(a,b,f,i,l,h,k,d,g){var c=d?this.firstBtnCls:"";var j=g?this.lastBtnCls:"";var e=Ext.isFunction(h)?h:Ext.emptyFn;SYNO.SDS.VideoStation.PathBar.PathButton.superclass.constructor.call(this,{text:i,itemId:f,renderTo:b,tooltip:l,clickEvent:"mousedown",listeners:{click:{fn:e,scope:k||this}},template:new Ext.Template('<table cellspacing="0" class="x-btn '+c+" "+j+' {3}"><tbody><tr>','<td class="ux-pathbutton-left"></td>','<td class="ux-pathbutton-center"><em class="{5}" unselectable="on">','<button class="x-btn-text {2}" type="{1}">{0}</button>',"</em></td>",'<td class="ux-pathbutton-right"></td>',"</tr></tbody></table>")});if(d){this.setIconClass("syno-vs-home-icon")}};Ext.extend(SYNO.SDS.VideoStation.PathBar.PathButton,Ext.Button,{firstBtnCls:"x-first-btn",lastBtnCls:"x-last-btn",updateButton:function(e,d,f,c,b){var a=Ext.isFunction(f)?f:Ext.emptyFn;this.purgeListeners();this.mon(this,"click",a,c||this);this.setText(e);this.setTooltip(d);if(b){this.addClass(this.lastBtnCls)}else{this.removeClass(this.lastBtnCls)}}});Ext.define("SYNO.SDS.VideoStation.EditSmartCollectionFromPanel",{extend:"SYNO.ux.FormPanel",pageSize:300,constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.collectionID=a.collectionID;var b={flex:1,labelWidth:100,items:[],listeners:{scope:this,afterrender:this.onAfterRender}};Ext.apply(b,a);return b},onAfterRender:function(){this._getOwner().setStatusBusy();SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:"getinfo",version:2,params:{id:this.collectionID},scope:this,callback:function(d,c,b,a){this._getOwner().clearStatusBusy();if(!d){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(d,c,a.params));return}else{this.collectionType=c.additional.filter_info.type;this.libraryID=c.additional.filter_info.library_id;this.removeAll();this.addItems();this.onLoadData(c.additional.filter_info)}}})},addItems:function(){Ext.each(SYNO.SDS.VideoStation.FilterUtil.getFilterTypes(this.collectionType),function(b){var a=SYNO.SDS.VideoStation.FilterUtil.getFilterDatas(b.id);this.add({xtype:"syno_superboxselect",itemId:b.id,name:b.id,fieldLabel:b.name,allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore(b.id,a),mode:Ext.isEmpty(a)?"remote":"local",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"value",findRecord:this.findRecord,listeners:{scope:this,additem:this.updateScroller,removeitem:this.updateScroller}})},this);this.add({xtype:"syno_textfield",fieldLabel:_VST("search","keyword"),itemId:"keyword",name:"keyword"});this.doLayout()},findRecord:function(f,d){var e;if(this.store.getCount()>0){this.store.each(function(a){if(SYNO.SDS.VideoStation.FilterUtil.isEqual(a.data[f],d)){e=a;return false}})}return e},getCategoryStore:function(b,a){if(Ext.isEmpty(a)){return new Ext.data.Store({method:"POST",remoteSort:false,proxy:new SYNO.SDS.VideoStation.MetaDataV2HttpProxy({url:this._getWebAPIURL("metadata.cgi"),listeners:{scope:this,beforeload:function(c,d){var e=c.activeRequest.read;if(e){Ext.Ajax.abort(e)}}}}),baseParams:{api:"SYNO.VideoStation.Metadata",method:"list",version:"2",category:b,sort_by:b,sort_direction:"ASC"},paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},reader:new Ext.data.JsonReader({fields:["name","value"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore}})}else{return new SYNO.SDS.VideoStation.FilterStore({remoteSort:true,reader:new Ext.data.JsonReader({fields:["name","value"]}),data:a})}},onBeforeLoadStore:function(a,b){var d=b.params;var c=this.getFilterCondition(true);delete c[a.baseParams.category];Ext.apply(d,c);return d},onAfterLoadStore:function(b,a,c){var d=b.baseParams.filter;if(!Ext.isEmpty(d)){b.filter("name",d,true,false)}},onLoadData:function(d){if(Ext.isEmpty(d)){this.owner.getMsgBox().alert(_VST("metadata","title"),_VST("error","no_data"),function(){},this);return}var b=this.getForm();var c=b.getFieldValues();for(var a in c){if(c.hasOwnProperty(a)){var e=d[a];this.setFieldValue(a,e)}}this.loadedFormString=this.getForm().getValues(true)},isModified:function(){return this.loadedFormString!==this.getForm().getValues(true)},getNameByValue:function(c,d){var b=d;var a=SYNO.SDS.VideoStation.FilterUtil.getFilterDatas(c);Ext.each(a,function(e){if(SYNO.SDS.VideoStation.FilterUtil.isEqual(e.value,d)){b=e.name;return false}},this);return Ext.util.Format.htmlEncode(b)},setFieldValue:function(f,e){var d;if((d=this.getForm().findField(f))&&Ext.isDefined(e)){if(Ext.isArray(e)&&Ext.isFunction(d.setValueEx)){var a=[],b;for(var c=0;c<e.length;c++){b=e[c];a.push({name:this.getNameByValue(f,b),value:b})}d.setValueEx(a);d.originalValue=d.getValue()}else{this.getForm().setValues([{id:f,value:e||""}])}}},getFilterCondition:function(b){var a={};Ext.each(SYNO.SDS.VideoStation.FilterUtil.getFilterTypes(this.collectionType),function(d){var e={};var c=[];Ext.each(this.getForm().findField(d.id).getValueEx(),function(f){c.push(f.value)},this);if(0<c.length){if(b){e[d.id]=Ext.encode(c)}else{e[d.id]=c}Ext.apply(a,e)}},this);if(this.getForm().findField("keyword").getValue()){Ext.apply(a,{keyword:this.getForm().findField("keyword").getValue().trim()})}Ext.apply(a,{type:this.collectionType,library_id:b?Ext.encode(this.libraryID):this.libraryID});return a}});Ext.define("SYNO.SDS.VideoStation.FilterStore",{extend:"Ext.data.Store",constructor:function(a){this.callParent([a])},filter:function(d,c,e,a,b){e=Ext.isDefined(e)?e:true;a=Ext.isDefined(a)?a:false;SYNO.SDS.VideoStation.FilterStore.superclass.filter.apply(this,[d,c,e,a,b])}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.NewEditCollectionDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getCollectionStore"]);var b=this.fillConfig(a);this.callParent([b]);this.sharingObj={enable_sharing:a.sharing===true,enable_sharing_org:a.sharing===true,date_available:"0",date_available_org:"0",date_expired:"0",date_expired_org:"0"}},fillConfig:function(a){Ext.apply(this,{collectionID:a.collectionID,create:a.create,smart:a.smart,sharing:a.sharing});var b={owner:this._getOwner(),width:this.getDialogWidth(),height:this.getDialogHeight(),title:this.getDialogTitle(),layout:"vbox",layoutConfig:{type:"vbox",align:"stretch",pack:"start",padding:"0 20"},plain:true,items:[this.getItems(a)],buttons:[{text:_T("common","ok"),btnStyle:"blue",scope:this,disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onSaveCollectionName},{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onSaveCollectionName},{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},getDialogWidth:function(){var a=470;if(this.sharing||this.isSmartEdit()){a=560}return a},isSmartEdit:function(){return false===this.create&&true===this.smart},getDialogHeight:function(){var a=130;a+=SYNO.SDS.VideoStation.Util.ableToControlSharing()&&this.create?110:0;a+=this.sharing?40:0;a+=this.isSmartEdit()?280:0;return a},getDialogTitle:function(){var a;if(this.sharing){a=_VST("collection","share_to_public")}else{if(this.create){if(this.smart){a=_VST("collection","save_smart_collection")}else{a=_VST("collection","new_collection")}}else{if(this.smart){a=_VST("collection","edit_smart_collection")}else{a=_VST("collection","edit_collection")}}}return a},show:function(){if(!this.create&&this.collectionTitle){var a=this.getFormPanel().getForm();var b=new Ext.data.Record({collection_name:this.collectionTitle,sharing_checkbox:this.collectionSharing.enable_sharing});a.loadRecord(b);if(this.collectionID<=0){a.findField("collection_name").disable()}this.initSharingObj()}this.callParent(arguments)},initSharingObj:function(){this.sharingObj.enable_sharing=this.collectionSharing.enable_sharing;if(this.collectionSharing.enable_sharing){this.sharingObj.date_available=this.collectionSharing.date_available;this.sharingObj.date_expired=this.collectionSharing.date_expired}else{this.sharingObj.date_available="0";this.sharingObj.date_expired="0"}this.sharingObj.enable_sharing_org=this.sharingObj.enable_sharing;this.sharingObj.date_available_org=this.sharingObj.date_available;this.sharingObj.date_expired_org=this.sharingObj.date_expired;var a=this.getFormPanel();if("0"!==this.sharingObj.date_available&&"0"!==this.sharingObj.date_expired){a.periodCheck.setValue(true);a.availDate.setValue(this.sharingObj.date_available);a.expDate.setValue(this.sharingObj.date_expired);a.availDate.initValue();a.expDate.initValue()}else{a.periodCheck.setValue(false)}a.periodCheck.initValue()},onSaveCollectionName:function(){var a=false;var b=this.getFormPanel().getForm();if(!b.isValid()){return false}this.collectionTitle=b.findField("collection_name").getValue();if(""===this.collectionTitle){this.setStatusError({text:_VST("collection","collection_isnotempty"),clear:true});return}this._getCollectionStore().each(function(d){var f=d.get("id");var e=d.get("title");if(e===this.collectionTitle){if(this.create){a=true}else{if(this.collectionID!==f){a=true}}return}},this);if(this.collectionTitle==="syno_default_shared"){a=true}if(a){this.setStatusError({text:_VST("collection","collection_duplicate_name"),clear:true});return}if(this.getFormPanel().periodCheck.checked){this.sharingObj.date_available=this.getFormPanel().availDate.getValue().format("Y-m-d");this.sharingObj.date_expired=this.getFormPanel().expDate.getValue().format("Y-m-d");if(!this.getFormPanel().availDate.isValid()||!this.getFormPanel().expDate.isValid()){return}}else{this.sharingObj.date_available="0";this.sharingObj.date_expired="0"}var c={title:this.collectionTitle,enable_sharing:this.sharingObj.enable_sharing,date_available:this.sharingObj.date_available,date_expired:this.sharingObj.date_expired};if(this.smart){Ext.apply(c,{filter_info:this.getFilterInfo()})}this.setStatusBusy({text:_T("common","save")});if(this.create){SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:this.smart?"create_smart":"create",version:2,params:c,scope:this,callback:this.newediteCollectionDone})}else{c.id=this.collectionID;if(this.isModified()){SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:this.smart?"edit_smart":"edit",version:2,params:c,scope:this,callback:this.newediteCollectionDone})}else{this.clearStatusBusy();this.close()}}},getFilterInfo:function(){var b;var c={};if(this.create){var a=this._getCurType();Ext.apply(c,{type:SYNO.SDS.VideoStation.Util._TVSHOW_ID===a?SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:a,library_id:[this._getCurLibraryId()]});b=SYNO.SDS.VideoStation.FilterUtil.getFilterCondition(false)}else{b=this.getEditSmartFormPanel().getFilterCondition(false)}Ext.apply(c,b);return Ext.encode(c)},isModified:function(){var c=this.getFormPanel().getForm();var b=false;if(this.sharingObj.enable_sharing!==this.sharingObj.enable_sharing_org){b=true}else{if(this.sharingObj.enable_sharing){if(this.sharingObj.date_available!==this.sharingObj.date_available_org||this.sharingObj.date_expired!==this.sharingObj.date_expired_org){b=true}}}var a=false;if(this.isSmartEdit()&&this.getEditSmartFormPanel().isModified()){a=true}return c.isDirty()||b||a},newediteCollectionDone:function(a,h,g,d){var f=d.params;if(!a){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation.Util.getWebAPIErr(a,h,f),clear:true});return}var e=0;var c=g.title;if("create"===f.method){e=h.id;var b={id:e};this._getCollectionStore().reload();this.module.onRequestCollection("addvideo",false,b,function(i,k,j){this.onRequestCollectionCallBack(i,k,j,"addvideo",b)},this.module)}else{e=g.id;this._getCollectionStore().reload()}if(!this.sharingObj.enable_sharing||(this.sharingObj.enable_sharing_org&&(f.method==="edit"||f.method==="edit_smart"))){this.close();return}SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:"getinfo",version:2,params:{id:e},scope:this,callback:function(o,n,m,k){var i=this.owner;this.close();if(!o){return}if(n.additional.sharing_info.status!=="valid"){return}var j=n.additional.sharing_info.url;var l=new SYNO.SDS.VideoStation.SharingLinkDialog({title:String.format(_VST("collection","link_to"),c),url:j,owner:i});l.show()}})},getItems:function(a){var b=[this.getFormPanel(a)];if(this.isSmartEdit()){b.push(this.getEditSmartFormPanel())}return b},getFormPanel:function(a){if(!this.formPanel){var b=a||{};this.formPanel=new SYNO.SDS.VideoStation.NewEditCollectionFormpanel({owner:this,sharing:b.sharing,create:b.create})}return this.formPanel},getEditSmartFormPanel:function(){if(this.editSmartFromPanel){return this.editSmartFromPanel}this.editSmartFromPanel=new SYNO.SDS.VideoStation.EditSmartCollectionFromPanel({owner:this,collectionID:this.collectionID});return this.editSmartFromPanel}});Ext.define("SYNO.SDS.VideoStation.NewEditCollectionFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});var b=this.fillConfig(a);this.callParent([b]);this.getForm().findField("collection_name").focus(true,500);this.periodCheck=this.getComponent("period_checkbox");this.periodComposite=this.getComponent("period_composite");this.availDate=this.periodComposite.items.get(0);this.expDate=this.periodComposite.items.get(2);this.periodCheck.on("disable",function(){this.availDate.disable();this.expDate.disable()},this);this.periodCheck.on("enable",function(){if(this.periodCheck.checked){this.availDate.enable();this.expDate.enable()}},this)},fillConfig:function(a){var b=Ext.apply({flex:1,frame:false,border:false,autoFlexcroll:true,height:a.sharing?180:(!a.create||!SYNO.SDS.VideoStation.Util.ableToControlSharing()?50:140),labelWidth:120,trackResetOnLoad:true,items:[{xtype:"syno_displayfield",value:_VST("collection","share_to_public_desc"),hidden:a.sharing!==true},{xtype:"syno_textfield",itemId:"collection_name",fieldLabel:_VST("collection","collection_name"),width:280,value:this.getDefaultCollectionName(a),maxLength:255,maxLengthText:_VST("collection","collection_name_too_long")},{xtype:"syno_checkbox",itemId:"sharing_checkbox",checked:a.sharing===true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlSharing()||a.sharing===true||a.create!==true,boxLabel:_VST("collection","share_to_public"),listeners:{scope:this,check:function(c,d){this.owner.sharingObj.enable_sharing=d;this.periodCheck.setDisabled(!d)}}},{xtype:"syno_checkbox",itemId:"period_checkbox",indent:a.sharing?0:1,hidden:!SYNO.SDS.VideoStation.Util.ableToControlSharing()||a.create!==true,disabled:a.sharing!==true,boxLabel:_VST("collection","customize_duration"),listeners:{scope:this,check:function(c,d){this.availDate.setDisabled(!d);this.expDate.setDisabled(!d)}}},{xtype:"syno_compositefield",itemId:"period_composite",indent:a.sharing?1:2,hidden:!SYNO.SDS.VideoStation.Util.ableToControlSharing()||a.create!==true,hideLabel:true,items:[{xtype:"syno_datefield",itemId:"availDate",hideLabel:true,format:"Y-m-d",editable:false,disabled:true,width:150,listeners:{scope:this,change:function(){this.expDate.validate()}}},{xtype:"syno_displayfield",value:" - "},{xtype:"syno_datefield",itemId:"expDate",hideLabel:true,format:"Y-m-d",editable:false,disabled:true,width:150,validator:a.create?SYNO.SDS.VideoStation.CollectionUtil.checkPeriodValid.createDelegate(this):undefined}]}],listeners:{scope:this,afterrender:a.create?this.initTimePeriod:Ext.emptyFn}},b);return b},initTimePeriod:function(){SYNO.SDS.VideoStation.CollectionUtil.getDSInfo(this.owner,this)},getDefaultCollectionName:function(b){if(b.sharing!==true){return undefined}var d=_VST("collection","untitled_name");var g=[];this.owner._getCollectionStore().each(function(h){var i=h.get("title");if(i.substr(0,d.length)===d){g.push(i)}},this);var a=1;var e=d;do{var f=false;for(var c=0;c<g.length;c++){if(g[c]===e){f=true;e=String.format(d+" ({0})",a++);break}}}while(f);return e}});Ext.define("SYNO.SDS.VideoStation.SharingLinkDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.isSingleVideo=!Ext.isEmpty(a.video_type)&&!Ext.isEmpty(a.video_id);this.isCollection=!Ext.isEmpty(a.collection_id);var b=this.fillConfig(a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getCollectionStore"]);this.callParent([b]);this.enableCheck=this.getComponent("enable_sharing");this.linkText=this.getComponent("link_text");this.periodBtn=this.getComponent("period_btn");this.linkBtn=this.getFooterToolbar().getComponent("open_link_btn");this.linkText.focus(true,500)},fillConfig:function(a){var b={layout:"form",width:450,height:this.isSingleVideo?160:(this.isCollection?200:120),padding:"0 20px",constrain:true,closable:false,resizable:false,items:[{xtype:"syno_checkbox",itemId:"enable_sharing",hidden:!this.isSingleVideo&&!this.isCollection,boxLabel:_VST("collection","share_to_public"),listeners:{scope:this,buffer:50,check:this.onCheckSharing}},{xtype:"syno_textfield",itemId:"link_text",readOnly:true,selectOnFocus:true,cls:"selectabletext",hideLabel:true,value:a.url,width:410},{xtype:"syno_button",itemId:"period_btn",hidden:!this.isCollection,text:_VST("collection","customize_duration"),scope:this,disabled:true,handler:this.handleCustomizeDate}],buttons:[{text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.handleDone},{text:_VST("action","open_link"),itemId:"open_link_btn",scope:this,handler:this.handleGoLink}],keys:[{key:Ext.EventObject.ESC,scope:this,fn:this.handleCancel}],listeners:{scope:this,show:this.initSharingInfo}};Ext.apply(b,a);return b},handleDone:function(){this.close();if(this.collectionChanged){this._getCollectionStore().reload()}},onCheckSharing:function(a,b){if(!this.loadDone){return}if(this.isSingleVideo){this.setVideoSharing()}else{if(this.isCollection){this.setCollectionSharing()}}},setVideoSharing:function(){this.setStatusBusy();SYNO.API.Request({api:"SYNO.VideoStation.Sharing",method:"set",version:1,params:{enable:this.enableCheck.getValue(),id:this.video_id,type:this.video_type},scope:this,callback:function(d,c,b,a){this.clearStatusBusy();this.linkBtn.setDisabled(!b.enable);this.linkText.setDisabled(!b.enable);if(Ext.isFunction(this.setSharingCallback)){this.setSharingCallback.call(this.setSharingCallbackScope,d,c,b,a)}if(!d){this.setStatusError({text:SYNO.SDS.VideoStation.Util.getWebAPIErr(d,c,a.params),clear:true});return}}})},setCollectionSharing:function(){this.collectionChanged=true;this.setStatusBusy();SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:"edit",version:2,params:{id:this.collection_id,enable_sharing:this.enableCheck.getValue(),date_available:this.sharing_info.date_available,date_expired:this.sharing_info.date_expired},scope:this,callback:function(d,c,b,a){if(!d){this.clearStatusBusy();this.setStatusError({text:SYNO.SDS.VideoStation.Util.getWebAPIErr(d,c,a.params),clear:true});return}this.loadCollectionLink()}})},initSharingInfo:function(){if(!this.isSingleVideo&&!this.isCollection){return}this.setStatusBusy();if(this.isSingleVideo){this.loadVideoLink()}else{if(this.isCollection){this.loadCollectionLink()}}},loadVideoLink:function(){SYNO.API.Request({api:"SYNO.VideoStation.Sharing",method:"get",version:1,params:{id:this.video_id,type:this.video_type},scope:this,callback:function(d,c,b,a){this.clearStatusBusy();if(!d){this.close();return}this.loadDone=false;this.enableCheck.setValue(c.enable);this.linkText.setValue(c.url);this.linkBtn.setDisabled(!c.enable);this.linkText.setDisabled(!c.enable);(function(){this.loadDone=true}).defer(100,this)}})},loadCollectionLink:function(){SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:"getinfo",version:2,params:{id:this.collection_id},scope:this,callback:function(d,c,b,a){this.clearStatusBusy();if(!d){this.close();return}this.loadDone=false;this.sharing_info=c.additional.sharing_info;this.enableCheck.setValue(this.sharing_info.enable_sharing);this.linkText.setValue(this.sharing_info.url);this.linkBtn.setDisabled(this.sharing_info.status!=="valid");this.linkText.setDisabled(this.sharing_info.status!=="valid");this.periodBtn.setDisabled(!this.sharing_info.enable_sharing);(function(){this.loadDone=true}).defer(100,this)}})},handleGoLink:function(){window.open(this.getComponent("link_text").getValue())},handleCustomizeDate:function(){var a=new SYNO.SDS.VideoStation.SharingPeriodDialog({owner:this});a.show()}});Ext.define("SYNO.SDS.VideoStation.SharingPeriodDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){var b=this.fillConfig(a);this.callParent([b]);this.periodCheck=this.getComponent("period_checkbox");var c=this.getComponent("period_composite");this.availDate=c.items.get(0);this.expDate=c.items.get(2)},fillConfig:function(a){var b={title:_VST("collection","customize_duration"),layout:"form",width:420,height:170,padding:"0 20px",constrain:true,closable:false,resizable:false,labelWidth:120,items:[{xtype:"syno_checkbox",itemId:"period_checkbox",boxLabel:_VST("collection","customize_duration"),listeners:{scope:this,check:function(c,d){this.availDate.setDisabled(!d);this.expDate.setDisabled(!d)}}},{xtype:"syno_compositefield",itemId:"period_composite",indent:1,hideLabel:true,items:[{xtype:"syno_datefield",itemId:"availDate",hideLabel:true,format:"Y-m-d",editable:false,disabled:true,width:150,listeners:{scope:this,change:function(){this.expDate.validate()}}},{xtype:"syno_displayfield",value:" - "},{xtype:"syno_datefield",itemId:"expDate",hideLabel:true,format:"Y-m-d",editable:false,disabled:true,width:150,validator:SYNO.SDS.VideoStation.CollectionUtil.checkPeriodValid.createDelegate(this)}]}],buttons:[{text:_T("common","ok"),btnStyle:"blue",scope:this,disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.handleApply},{text:_T("common","cancel"),scope:this,handler:this.handleCancel}],keys:[{key:Ext.EventObject.ENTER,scope:this,fn:this.handleApply},{key:Ext.EventObject.ESC,scope:this,fn:this.handleCancel}],listeners:{show:{fn:this.initTimePeriod,scope:this}}};Ext.apply(b,a);return b},initTimePeriod:function(){if("0"!==this.owner.sharing_info.date_available&&"0"!==this.owner.sharing_info.date_expired){this.periodCheck.setValue(true);this.availDate.setValue(this.owner.sharing_info.date_available);this.expDate.setValue(this.owner.sharing_info.date_expired);this.periodCheck.initValue();this.availDate.initValue();this.expDate.initValue()}SYNO.SDS.VideoStation.CollectionUtil.getDSInfo(this,this)},handleApply:function(){if(_S("demo_mode")){return}if(!this.availDate.isValid()||!this.expDate.isValid()){return}if(!this.periodCheck.isDirty()&&!this.availDate.isDirty()&&!this.expDate.isDirty()){this.close();return}if(this.periodCheck.getValue()){this.owner.sharing_info.date_available=this.availDate.getValue().format("Y-m-d");this.owner.sharing_info.date_expired=this.expDate.getValue().format("Y-m-d")}else{this.owner.sharing_info.date_available="0";this.owner.sharing_info.date_expired="0"}this.owner.setCollectionSharing();this.close()},handleCancel:function(){this.close()}});SYNO.SDS.VideoStation.CollectionUtil={getNDaysAfter:function(a,b){a.setTime(a.getTime()+b*86400000);return a.format("Y-m-d")},checkPeriodValid:function(){var a=this.expDate;if(Ext.isDate(a.minValue)&&a.getValue()<a.minValue){return String.format(_JSLIBSTR("extlang","afterdate"),a.minValue.format("Y-m-d"))}if(a.getValue()<this.availDate.getValue()){return _VST("collection","exp_before_avail")}return true},getDSInfo:function(b,a){b.setStatusBusy();b.sendWebAPI({api:"SYNO.DSM.Info",method:"GetInfo",version:1,scope:a,callback:function(i,f,h){var g=this.expDate.format;var d=new Date();if(i&&f.time){d=new Date(Date.parse(f.time))}var c=d.format(g);if(this.periodCheck.getValue()){var e=this.availDate.getValue()<d?this.availDate.getValue().format(g):c;this.availDate.setMinValue(e);this.expDate.setMinValue(c);this.availDate.validate();this.expDate.validate()}else{this.availDate.setMinValue(c);this.expDate.setMinValue(c);this.availDate.setValue(c);this.expDate.setValue(SYNO.SDS.VideoStation.CollectionUtil.getNDaysAfter(d,7));this.availDate.initValue();this.expDate.initValue()}b.clearStatusBusy()}})}};Ext.define("SYNO.SDS.VideoStation.CollectionMenu",{extend:"SYNO.ux.Menu",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_onRequestCollection","_onRequestCollectionNoMesg","_getCollectionMenuItems","_getCollectionStore"]);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-menu",items:[],listeners:{scope:this,beforeshow:this.onUpdateCollectionMenu}};Ext.apply(b,a);return b},onUpdateCollectionMenu:function(a){this.onShowHideCollection()},updateCollectionsMenuitems:function(){this.removeAll(true);Ext.each(this._getCollectionMenuItems(true,this),function(c,a,b){this.addItem(c)},this)},onRemoveFavoite:function(){var a={id:-1};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRemoveWatchList:function(){var a={id:-2};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onClickGetShareLink:function(){var g=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewGrid");var e=g.getSelectionModel().getSelected();if(Ext.isEmpty(e)){SYNO.Debug("click share link out of a collection");return}var i=SYNO.SDS.VideoStation.Util;var a=i._getHistoryInfo();var h=this.onGetSelectedData().get("title");var b={title:String.format(_VST("collection","link_to"),h),owner:g._getOwner()};if(a.view===i._VIEW_GRID){b.collection_id=e.get("id")}else{if(a.view===i._VIEW_COLLECTION){var d=i._getSelectedVideoId();var c=i._getSelectedVideoType();b.url=e.get("additional").sharing_info.url+"#!"+btoa(c+"-"+d)}else{SYNO.Debug("click share link in a wrong view");return}}var f=new SYNO.SDS.VideoStation.SharingLinkDialog(b);f.show()},onClickPublicSharing:function(){var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas();if(f.length===1){var b=SYNO.SDS.VideoStation.Util._getSelectedVideoId();var a=SYNO.SDS.VideoStation.Util._getSelectedVideoType();var g,e;if(SYNO.SDS.VideoStation.Util._VIEW_DETAIL===this._getHistoryInfo().view){e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData");g=e.callbackUpdateSharePublic}var d=new SYNO.SDS.VideoStation.SharingLinkDialog({title:_VST("collection","share_to_public"),video_id:b,video_type:a,owner:this._getOwner(),setSharingCallback:g,setSharingCallbackScope:e});d.open()}else{var c=new SYNO.SDS.VideoStation.NewEditCollectionDialog({create:true,sharing:true,module:this});c.open()}},onRemoveFromUserDefCollection:function(b,c){var f,d;if(b.itemId){d=b.itemId.indexOf("_remove");f=parseInt(b.itemId.substring(0,d),10)}var a={id:f};this.onRequestCollection("deletevideo",false,a,function(e,h,g){this.onRequestCollectionCallBack(e,h,g,"deletevideo",a)},this)},onDeleteCollection:function(){var a,c=-1;var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewGrid");if(d.getSelectionModel()){a=d.getSelectionModel().getSelected()}if(a){c=a.data.id}var b={id:c};this._getOwner().getMsgBox().confirm(_VST("collection","title"),_VST("collection","delete_collection_alert"),function(e,f){if(e==="yes"){this.onRequestCollection("delete",false,b,function(g,i,h){this.onRequestCollectionCallBack(g,i,h,"delete",b)},this)}else{return false}},this)},onEditCollection:function(){var a,d=0,c,e={};var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewGrid");if(f.getSelectionModel()){a=f.getSelectionModel().getSelected()}if(a){d=a.get("id");c=SYNO.SDS.VideoStation.Util.getCollectionName(a.get("title"));e=a.get("additional")}var b=new SYNO.SDS.VideoStation.NewEditCollectionDialog({create:false,smart:"smart"===a.get("type"),collectionTitle:c,collectionID:d,collectionSharing:e.sharing_info,module:this});b.open()},onSetCollectionMenuToDefault:function(){this.onSetCollectionMenuIcon(-1,"",false);this.onSetCollectionMenuIcon(-2,"",false);Ext.each(this.items.items,function(a,b,c){if("add_favorite_from_menu"!==a.itemId&&"remove_favorite_from_menu"!==a.itemId&&"add_watch_list_from_menu"!==a.itemId&&"remove_watch_list_from_menu"!==a.itemId){if(0<a.itemId.indexOf("_remove_")&&0>a.itemId.indexOf("_add_")){a.hide()}else{a.show()}}},this)},onSetCollectionMenuIcon:function(b,d,a){var c="";Ext.each(this.items.items,function(g,e,f){if(-1===b||"syno_favorite"===d){if("add_favorite_from_menu"===g.itemId){if(a){g.hide()}else{g.show()}return}else{if("remove_favorite_from_menu"===g.itemId){if(a){g.show()}else{g.hide()}return}}}else{if(-2===b||"syno_watchlist"===d){if("add_watch_list_from_menu"===g.itemId){if(a){g.hide()}else{g.show()}return}else{if("remove_watch_list_from_menu"===g.itemId){if(a){g.show()}else{g.hide()}return}}}else{c=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(g.itemId,"_add");if(""!==c&&parseInt(c,10)===parseInt(b,10)){if(a){g.hide()}else{g.show()}}c=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(g.itemId,"_remove");if(""!==c&&parseInt(c,10)===parseInt(b,10)){if(a){g.show()}else{g.hide()}}}}},this)},onRequestCollection:function(e,c,a,d,b){if(c){this._onRequestCollectionNoMesg.call(this,e,a,d,b)}else{this._onRequestCollection.call(this,e,a,d,b)}},onRequestCollectionCallBack:function(a,g,e,h,c){var f=this._getHistoryInfo();if("deletevideo"===h||"addvideo"===h){if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===f.view||SYNO.SDS.VideoStation.Util._VIEW_EPISODE===f.view||SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===f.view){var d=this.onGetSelectedDatas();Ext.each(d,function(m){if(!Ext.isObject(m.data.additional)){m.data.additional={}}var j=m.data.additional;if(!Ext.isArray(j.collection)){j.collection=[]}var l=j.collection;if("deletevideo"===h){var k;for(k=0;k<l.length;k++){if(parseInt(l[k].id,10)===c.id){l.splice(k,1);break}}}else{if("addvideo"===h){l.push({id:c.id})}}},this);SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr").fireEvent("afterAddDeleteVideoToCollection")}else{if(SYNO.SDS.VideoStation.Util._VIEW_DETAIL===f.view){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData");b.onRequestCollectionCallBack(a,g,e,h,c)}else{SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr").fireEvent("afterAddDeleteVideoToCollection")}}}else{if("delete"===h){this._getCollectionStore().each(function(i){var j=i.get("id");if(j===c.id){this._getCollectionStore().remove(i);SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr").fireEvent("afterLoadCollection");return false}},this)}}},onShowHideCollection:function(){var g=this._getHistoryInfo();var e;if(SYNO.SDS.VideoStation.Util._VIEW_FILTERING===g.view||SYNO.SDS.VideoStation.Util._VIEW_EPISODE===g.view||SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===g.view){var f=this.onGetSelectedDatas();if(!Ext.isObject(f[0].data.additional)){f[0].data.additional={}}var a=f[0].data.additional;if(!Ext.isArray(a.collection)){a.collection=[]}e=a.collection;for(var c=1;c<f.length;c++){if(!Ext.isObject(f[c].data.additional)){e=[];break}var d=f[c].data.additional;if(!Ext.isArray(d.collection)){e=[];break}Ext.each(e,function(i){var h=d.collection.map(function(j){return j.id});if(undefined!==i&&0>h.indexOf(i.id)){e.remove(i)}},this)}}else{if(SYNO.SDS.VideoStation.Util._VIEW_DETAIL===g.view){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData");e=b.currentAddCollection}}this.onSetCollectionMenuToDefault();if(Ext.isArray(e)){Ext.each(e,function(h){this.onSetCollectionMenuIcon(h.id,h.title,true)},this)}},onGetSelectedData:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedData()},onGetSelectedDatas:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.VideoInfoDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){var b=this.fillConfig(a);SYNO.SDS.VideoStation.VideoInfoDialog.superclass.constructor.call(this,b)},fillConfig:function(a){var b={cls:"syno-vs-video-info-win",owner:this._getOwner(),width:750,height:500,minWidth:200,minHeight:200,title:_VST("action","view_video_info"),layout:"fit",items:[{itemId:"form",xtype:"syno_formpanel",border:false,autoFlexcroll:true,labelWidth:130,defaults:{anchor:"100%"},items:[{itemId:"file_name",name:"file_name",xtype:"syno_displayfield",style:"word-wrap: break-word",fieldLabel:_VST("file","file_name")},{itemId:"file_path",name:"file_path",xtype:"syno_displayfield",style:"word-wrap: break-word",fieldLabel:_VST("file","file_path")},{itemId:"duration",name:"duration",xtype:"syno_displayfield",fieldLabel:_VST("duration","title")},{itemId:"filesize",name:"filesize",xtype:"syno_displayfield",fieldLabel:_T("common","size")},{itemId:"resolution",name:"resolution",xtype:"syno_displayfield",fieldLabel:_VST("video_info","resolution")},{itemId:"container_type",name:"container_type",xtype:"syno_displayfield",fieldLabel:_VST("video_info","container")},{itemId:"video_codec",name:"video_codec",xtype:"syno_displayfield",fieldLabel:_VST("video_info","video_codec")},{itemId:"audio_codec",name:"audio_codec",xtype:"syno_displayfield",fieldLabel:_VST("video_info","audio_codec")},{itemId:"video_bitrate",name:"video_bitrate",xtype:"syno_displayfield",fieldLabel:_VST("video_info","video_bitrate")}]}],buttons:[{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},formatBitrate:function(c){var b=parseInt(c,10);var a=(b/1024).toFixed(1);return String.format("{0} Kbps",a)},onLoad:function(c){var a=this.get("form").getForm();if("aac_invalid"===c.get("audio_codec")){c.data.audio_codec="aac"}a.loadRecord(c);var b=c.get("path");a.setValues({file_name:SYNO.SDS.VideoStation.Util.parseFullPathToFileName(b),file_path:c.get("sharepath"),resolution:c.get("resolutionx")+" X "+c.get("resolutiony"),filesize:Ext.util.Format.fileSize(c.get("filesize")),video_bitrate:this.formatBitrate(c.get("frame_bitrate"))});this.show();this.setHeight(SYNO.SDS.VideoStation.Util.onGetHeight(this.get("form"),120))}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.VideoListDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){var b=this.fillConfig(a);SYNO.SDS.VideoStation.VideoListDialog.superclass.constructor.call(this,b);this.createPollingTask()},getTBar:function(a){return[{xtype:"syno_button",itemId:"play",text:_VST("action","play"),handler:function(){var b;if(!(b=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}SYNO.SDS.VideoStation.Util.onPlayAction(this,b.data,SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo())},scope:this},{xtype:"syno_button",itemId:"open_folder",text:_VST("action","open_folder"),hidden:(_S("standalone")||!SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.App.FileStation3.Instance")),handler:function(){var b;if(!(b=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}SYNO.SDS.VideoStation.Util.onOpenContainingFolder(b.get("sharepath"))},scope:this},{xtype:"syno_button",itemId:"view_video_info",text:_VST("action","view_video_info"),handler:function(){var c;if(!(c=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}var b=new SYNO.SDS.VideoStation.VideoInfoDialog({owner:this});b.onLoad(c)},scope:this},{xtype:"syno_button",itemId:"search_subtitle",text:_VST("controller","search_subtitle"),handler:function(){var c;if(!(c=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}var b=new SYNO.SDS.VideoStation.SubtitleDialog({owner:this,videoId:c.get("id")});b.show()},scope:this}]},getGrid:function(a){if(this.grid){return this.grid}this.grid=new SYNO.ux.GridPanel({stripeRows:true,itemId:"grid",border:false,store:this.getStore(),tbar:this.getTBar(),bbar:[{itemId:"desc",xtype:"displayfield",value:_VST("error","select_one_video")}],cm:this.getColumnModel(),sm:new Ext.grid.RowSelectionModel({singleSelect:true})});return this.grid},fillConfig:function(a){var b=Ext.apply({cls:"syno-vs-video-list-win",owner:this._getOwner(),width:650,height:400,minWidth:200,minHeight:200,title:_VST("app","displayname"),layout:"fit",items:this.getGrid(),buttons:[{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:27,scope:this,handler:this.close}]});return b},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.JsonStore({autoLoad:false,idProperty:"id",fields:["id","path","sharepath","duration","filesize","resolutionx","resolutiony","container_type","video_codec","audio_codec","frame_bitrate"]}))},getColumnModel:function(){if(this.colmodel){return this.colmodel}this.colmodel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_VST("file","file_name"),dataIndex:"sharepath",sortable:true,width:150,align:"left",renderer:(function(g,e,a,d,f,b){g=SYNO.SDS.VideoStation.Util.parseFullPathToFileName(g);var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_VST("file","file_path"),dataIndex:"sharepath",sortable:true,width:250,align:"left",renderer:(function(g,e,a,d,f,b){var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_VST("duration","title"),dataIndex:"duration",sortable:true,width:100,align:"left",renderer:(function(g,e,a,d,f,b){var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_T("common","size"),dataIndex:"filesize",sortable:true,width:100,align:"left",renderer:(function(g,e,a,d,f,b){if(Ext.isEmpty(g)){return""}g=Ext.util.Format.fileSize(g);var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)}]});return this.colmodel},onLoadData:function(a){this.mon(this,"show",function(){if(this.grid&&!this.onGetSelectedFile()){this.grid.getSelectionModel().selectRow(0)}},this,{single:true,buffer:100});this.show();this.getStore().loadData(a)},onGetSelectedFile:function(){return this.grid.getSelectionModel().getSelected()},createPollingTask:function(){this.pollingTask=this.addTask({interval:800,scope:this,run:function(){if(this.isDestroyed){this.pollingTask.stop();return}var a=false;if(this.onGetSelectedFile()){a=true}this.getGrid().getTopToolbar().items.each(function(b){b.setDisabled(!a)})}}).start()}});Ext.define("SYNO.SDS.VideoStation.PlayViewActionGroup",{extend:"SYNO.SDS.Utils.ActionGroup",constructor:function(){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getSelectedVideoId","_getSelectedVideoType","_getResponseRoot"]);this.callParent([this.fillConfig()])},fillConfig:function(){var a=[this.getPlayAction()];if(!_S("standalone")&&SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.App.FileStation3.Instance")){a.push(this.getOpenFolderAction())}a.push(this.getViewVideoInfoAction());a.push(this.getSearchSubtitleAction());return a},getPlayAction:function(){if(this.playAction){return this.playAction}var a={itemId:"play",handler:function(){var b;if((b=this.getSelectedFile())){SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),b.data,SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo())}else{this.onLoadMetaData(function(d){var c=Ext.apply(SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo(),{videoID:d.id});if(d.additional.file.length===1){var f=d.additional.file[0];SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),f,c)}else{var e=new SYNO.SDS.VideoStation.VideoListDialog();e.playAdditionalInfo=c;e.onLoadData(d.additional.file)}})}},scope:this};this.playAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.playAction},getOpenFolderAction:function(){if(this.openFolderAction){return this.openFolderAction}var a={itemId:"open_folder",handler:function(){var b;if((b=this.getSelectedFile())){SYNO.SDS.VideoStation.Util.onOpenContainingFolder(b.get("sharepath"))}else{if(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&(b=this.onCheckIsFolderChoose())){SYNO.SDS.VideoStation.Util.onOpenContainingFolder(b.get("sharepath"))}else{this.onLoadMetaData(function(c){if(c.additional.file.length===1){SYNO.SDS.VideoStation.Util.onOpenContainingFolder(c.additional.file[0].sharepath)}else{var d=new SYNO.SDS.VideoStation.VideoListDialog();d.onLoadData(c.additional.file)}})}}},scope:this};this.openFolderAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.openFolderAction},getViewVideoInfoAction:function(){if(this.viewVideoInfoAction){return this.viewVideoInfoAction}var a={itemId:"view_video_info",handler:function(){var c;if((c=this.getSelectedFile())){var b=new SYNO.SDS.VideoStation.VideoInfoDialog();b.onLoad(c)}else{this.onLoadMetaData(function(d){var e;if(d.additional.file.length===1){var f=new Ext.data.Record(d.additional.file[0]);e=new SYNO.SDS.VideoStation.VideoInfoDialog();e.onLoad(f)}else{e=new SYNO.SDS.VideoStation.VideoListDialog();e.onLoadData(d.additional.file)}})}},scope:this};this.viewVideoInfoAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.viewVideoInfoAction},getSearchSubtitleAction:function(){if(this.searchSubtitleAction){return this.searchSubtitleAction}var a={itemId:"search_subtitle",text:_VST("controller","search_subtitle"),handler:function(){var c,b;if((c=this.getSelectedFile())){b=new SYNO.SDS.VideoStation.SubtitleDialog({videoId:c.get("id")});b.show()}else{this.onLoadMetaData(function(d){if(d.additional.file.length===1){c=new Ext.data.Record(d.additional.file[0]);b=new SYNO.SDS.VideoStation.SubtitleDialog({videoId:d.additional.file[0].id});b.show()}else{b=new SYNO.SDS.VideoStation.VideoListDialog();b.onLoadData(d.additional.file)}})}},scope:this};this.searchSubtitleAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.searchSubtitleAction},getSelectedFile:function(){var a=SYNO.SDS.VideoStation.Util.getActiveItem();if(a.getSelectedFile){return a.getSelectedFile()}},onCheckIsFolderChoose:function(){var a=this.getSelectedData();if(a&&a.get("sharepath")){return a}},onLoadMetaData:function(e){var d=this._getSelectedVideoId();if(!d){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}this._getOwner().setStatusBusy();var a=this._getSelectedVideoType();var b={id:d,additional:Ext.encode(["file"])};var c=SYNO.SDS.VideoStation.Util.getinfo_WebAPI(a);SYNO.API.currentManager.requestAPI(c.api,c.method||"getinfo",c.version||1,b,function(f,h,g){this.onLoadMetaDataCallBack(f,h,g,e)},this)},onLoadMetaDataCallBack:function(f,c,d,i){if(this.isDestroyed){return}this._getOwner().clearStatusBusy();if(!f){this._getOwner().getMsgBox().alert(this._getOwner().title,SYNO.SDS.VideoStation.Util.getWebAPIErr(f,c,d));return}if(c){var h=this._getResponseRoot(this._getSelectedVideoType());var a=(c[h]);var e;if(a&&!Ext.isEmpty(a)&&(e=a[0])&&(e&&e.additional&&Ext.isArray(e.additional.file))){if(this._checkIsByfolder()){var g=this.getSelectedData();var k=g.get("path");var b="";Ext.each(e.additional.file,function(l){if(k===l.path){b=l}},this);if(""!==b){e.additional.file=[b]}}if(Ext.isFunction(i)){i.call(this,e)}}else{this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("error","no_data"));var j=SYNO.SDS.VideoStation.Util.getActiveItem();j.onActivate(false);return}}},getSelectedData:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedData()}});Ext.define("SYNO.SDS.VideoStation.WatchStatusActionGroup",{extend:"SYNO.SDS.Utils.ActionGroup",constructor:function(){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getSelectedVideoId","_getSelectedVideoType","_gotoViewAgain"]);this.watchTypes=[SYNO.SDS.VideoStation.Util._MOVIE_ID,SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID,SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,SYNO.SDS.VideoStation.Util._TV_RECORDER_ID];this.videoIDs={};Ext.each(this.watchTypes,function(a){this.videoIDs[a]=[]},this);this.callParent([this.fillConfig()])},fillConfig:function(){var a=[this.getSetWatched(),this.getSetUnWatched()];return a},getSetWatched:function(){if(this.setWatched){return this.setWatched}var a={itemId:"set_watched",handler:this.setWatchStatusFn.createDelegate(this,[{watched:true}]),scope:this};this.setWatched=SYNO.SDS.VideoStation.Util._createAction(a);return this.setWatched},getSetUnWatched:function(){if(this.setUnWatched){return this.setUnWatched}var a={itemId:"set_unwatched",handler:this.setWatchStatusFn.createDelegate(this,[{watched:false}]),scope:this};this.setUnWatched=SYNO.SDS.VideoStation.Util._createAction(a);return this.setUnWatched},typeHasVideo:function(a){return this.videoIDs[a]&&0<this.videoIDs[a].length},setWatchStatusFn:function(a){var b=SYNO.SDS.VideoStation.Util._getSelectedVideoCollections();Ext.each(this.watchTypes,function(c){this.videoIDs[c]=[]},this);Ext.each(b,function(c){var d=(Ext.isString(c.video_id)?parseInt(c.video_id,10):c.video_id);this.videoIDs[c.video_type].push(d)},this);Ext.each(this.watchTypes,function(c){if(!this.typeHasVideo(c)){return}SYNO.API.Request({api:SYNO.SDS.VideoStation.Util.getinfo_WebAPI(c).api,method:"set_watched",version:2,params:Ext.apply({id:Ext.encode(this.videoIDs[c])},a),scope:this,callback:function(h,g,f,d){if(!h){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(h,g,d.params));return}var e=true;Ext.each(this.watchTypes,function(i){if(d.params.api===SYNO.SDS.VideoStation.Util.getinfo_WebAPI(i).api){this.videoIDs[i]=[]}if(this.typeHasVideo(i)){e=false}},this);if(e){this._gotoViewAgain()}}})},this)}});Ext.define("SYNO.SDS.VideoStation.DTVActionGroup",{extend:"SYNO.SDS.Utils.ActionGroup",constructor:function(){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,[]);this.callParent([this.fillConfig()])},fillConfig:function(){var a=[this.getStreaming(),this.getRecordNow(),this.getCancelNow(),this.getRecordNext(),this.getCancelNext(),this.getOpenEPG()];return a},getStreaming:function(){if(this.streamAction){return this.streamAction}var a={itemId:"dtv_stream",text:_VST("action","live_stream"),scope:this,handler:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");b.handleStreamAction()}};this.streamAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.streamAction},getRecordNow:function(){if(this.recordNowAction){return this.recordNowAction}var a={itemId:"dtv_record_now",scope:this,handler:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var c=b.onGetSelectedData();b.setupRecord(c.get("program_now"))}};this.recordNowAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.recordNowAction},getCancelNow:function(){if(this.cancelNowAction){return this.cancelNowAction}var a={itemId:"dtv_cancel_now",scope:this,handler:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var c=b.onGetSelectedData();b.cancelRecord(c.get("program_now"))}};this.cancelNowAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.cancelNowAction},getRecordNext:function(){if(this.recordNextAction){return this.recordNextAction}var a={itemId:"dtv_record_next",scope:this,handler:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var c=b.onGetSelectedData();b.setupRecord(c.get("program_next"))}};this.recordNextAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.recordNextAction},getCancelNext:function(){if(this.cancelNextAction){return this.cancelNextAction}var a={itemId:"dtv_cancel_next",scope:this,handler:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var c=b.onGetSelectedData();b.cancelRecord(c.get("program_next"))}};this.cancelNextAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.cancelNextAction},getOpenEPG:function(){if(this.openEPGAction){return this.openEPGAction}var a={itemId:"dtv_open_epg",text:_VST("action","open_epg"),scope:this,handler:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");b.handleEPGAction()}};this.openEPGAction=SYNO.SDS.VideoStation.Util._createAction(a);return this.openEPGAction},updateRecordItem:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");var a=b.onGetSelectedData().get("program_now");var c=b.onGetSelectedData().get("program_next");b.updateRecordMenuItem(a,this.getRecordNow(),this.getCancelNow(),_VST("record","now_playing"));b.updateRecordMenuItem(c,this.getRecordNext(),this.getCancelNext(),_VST("record","coming_next"))}});Ext.define("SYNO.SDS.VideoStation.DTVMetaDataDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-metadata-win",owner:this._getOwner(),width:400,height:250,minWidth:300,minHeight:200,title:_VST("action","edit_metadata"),layout:"fit",items:[this.getFormPanel()],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,handler:function(){this.onApply()}},{text:_T("common","cancel"),scope:this,handler:this.onCloseDialog}],keys:[{key:27,scope:this,handler:this.onCloseDialog}]};return Ext.apply(b,a)},show:function(b){this.data_id=b;var a={id:b,additional:"summary,files"};this.webAPIID=SYNO.SDS.VideoStation.Util.getinfo_WebAPI(SYNO.SDS.VideoStation.Util._getSelectedVideoType()).api;this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.webAPIID,"getinfo",1,a,this.onLoadDataDone,this);this.callParent(arguments)},onCloseDialog:function(){var a=this.formPanel.getForm();if(a.isDirty()){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.hide()}},this)}else{this.hide()}},onApply:function(d){if(_S("demo_mode")){this.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}var c=this.formPanel.getForm();if(!c.isDirty()){this.hide();return}var b=c.findField("channel_name").getValue();var f=c.findField("title").getValue();var a=c.findField("summary").getValue();var e={id:this.data_id,channel_name:b,title:f,summary:a};this.setStatusBusy();SYNO.API.currentManager.requestAPI(this.webAPIID,"edit",1,e,this.onSaveDone,this)},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.DTVMetaDataFormpanel()}return this.formPanel},onLoadDataDone:function(a,d,c){this.clearStatusBusy();if(!a){var e=SYNO.SDS.VideoStation.Util.getWebAPIErr(a,d,c);this.setStatusError({text:e,clear:true});return false}if(!d&&!d.recordings&&d.recordings[0]){return}var b=this.formPanel.getForm();b.setValues({channel_name:d.recordings[0].channel_name,title:d.recordings[0].title,summary:d.recordings[0].additional.summary})},onSaveDone:function(a,c,b){this.clearStatusBusy();if(!a){var d=SYNO.SDS.VideoStation.Util.getWebAPIErr(a,c,b);this.setStatusError({text:d,clear:true});return false}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").layout.activeItem.onActivate(false);this.hide()}});Ext.define("SYNO.SDS.VideoStation.DTVMetaDataFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=function(e,d){return unescape(encodeURIComponent(e)).length<=d};var c=Ext.apply({frame:false,border:false,labelWidth:90,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[{xtype:"syno_displayfield",itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel")},{xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("programguide","title"),allowBlank:false,validator:b.createDelegate(this,[255],true)},{xtype:"syno_textarea",itemId:"summary",name:"summary",fieldLabel:_VST("programguide","description"),width:280,height:70,validator:b.createDelegate(this,[4096],true)}]},a);return c}});Ext.define("SYNO.SDS.VideoStation.DateField",{extend:"SYNO.ux.DateField",constructor:function(b){var a={format:"Y-m-d",altFormats:"Y"};this.callParent([Ext.apply(a,b)]);this.yearValue=null},isYear:function(){return Ext.isString(this.yearValue)&&!Ext.isEmpty(this.yearValue)},getYearValue:function(){return this.isYear()?this.yearValue:""},setValue:function(a){if(!Date.parseDate(a,"Y-m-d")&&Date.parseDate(a,"Y")){this.yearValue=a}else{this.yearValue=null}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation.MetadataPanel",{extend:"SYNO.ux.FormPanel",pageSize:300,szkDifferentValueKey:"@SYNO_DIFFERENT_VALUE",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getResponseRoot"]);this.callParent([this.fillConfig(a)])},getItems:function(){var d=this.getCurType();var f=SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID===d?SYNO.SDS.VideoStation.Util._TVSHOW_ID:d;var b=[];var a=function(h,g){return unescape(encodeURIComponent(h)).length<=g};b.push({xtype:"syno_displayfield",itemId:"file_name",name:"file_name",fieldLabel:_VST("file","file_name")},{xtype:"syno_displayfield",itemId:"file_path",name:"file_path",fieldLabel:_VST("file","file_path")});switch(f){case SYNO.SDS.VideoStation.Util._MOVIE_ID:b.push({xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("common","title"),allowBlank:false,validator:a.createDelegate(this,[255],true)},{xtype:"syno_textfield",itemId:"tagline",name:"tagline",fieldLabel:_VST("tagline","title"),validator:a.createDelegate(this,[255],true)});break;case SYNO.SDS.VideoStation.Util._TVSHOW_ID:b.push({xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("tvshow","title"),allowBlank:false,validator:a.createDelegate(this,[255],true)});if(d!=="tvshow"){b.push(new SYNO.SDS.VideoStation.DateField({itemId:"tvshow_original_available",name:"tvshow_original_available",fieldLabel:_VST("original_available","title")+" ("+_VST("type","tv_show")+")",editable:false,preFocus:function(){this.el.blur()}}),{xtype:"syno_textarea",itemId:"tvshow_summary",name:"tvshow_summary",hideLabel:true,hidden:true},{xtype:"syno_textfield",itemId:"tagline",name:"tagline",fieldLabel:_VST("episode","name_title"),validator:a.createDelegate(this,[255],true)},{xtype:"syno_numberfield",itemId:"season",name:"season",fieldLabel:_VST("season","season_title"),allowBlank:true,allowDecimals:false,allowNegative:false},{xtype:"syno_numberfield",itemId:"episode",name:"episode",fieldLabel:_VST("episode","episode_title"),allowBlank:true,allowDecimals:false,allowNegative:false})}break;default:b.push({xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("common","title"),allowBlank:false,validator:a.createDelegate(this,[255],true)});break}switch(f){case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:b.push({xtype:"syno_compositefield",fieldLabel:_VST("video_info","record_time"),layout:"hbox",anchor:"100%",items:[{xtype:"syno_datefield",itemId:"original_available",name:"original_available",format:"Y-m-d",editable:false,allowBlank:false,flex:1,preFocus:function(){this.el.blur()}},{xtype:"syno_timefield",listClass:"syno-vs-combo-list",itemId:"record_date",name:"record_date",format:"H:i:s",editable:false,increment:1,allowBlank:false,flex:1,preFocus:function(){this.el.blur()}}]});break;default:var c=(f===SYNO.SDS.VideoStation.Util._TVSHOW_ID&&d==="tvshow_episode")?(_VST("original_available","title")+" ("+_VST("episode","episode_title")+")"):_VST("original_available","title");b.push({xtype:"syno_datefield",itemId:"original_available",name:"original_available",fieldLabel:c,editable:false,format:"Y-m-d",preFocus:function(){this.el.blur()}});break}if(f!==SYNO.SDS.VideoStation.Util._TVSHOW_ID||d!=="tvshow"){b.push({xtype:"syno_textfield",itemId:"certificate",name:"certificate",fieldLabel:_VST("metadata","rating_classification"),validator:a.createDelegate(this,[255],true)},{xtype:"syno_superboxselect",itemId:"genre",name:"genre",fieldLabel:_VST("genre","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("genre"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",validator:a.createDelegate(this,[255],true),listeners:{scope:this,additem:this.updateScroller,removeitem:this.updateScroller,newitem:this.onAddNewitem}},{xtype:"syno_superboxselect",itemId:"actor",name:"actor",fieldLabel:_VST("actor","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("actor"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",validator:a.createDelegate(this,[255],true),listeners:{scope:this,additem:this.updateScroller,removeitem:this.updateScroller,newitem:this.onAddNewitem}},{xtype:"syno_superboxselect",itemId:"writer",name:"writer",fieldLabel:_VST("writer","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("writer"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",validator:a.createDelegate(this,[255],true),listeners:{scope:this,additem:this.updateScroller,removeitem:this.updateScroller,newitem:this.onAddNewitem}},{xtype:"syno_superboxselect",itemId:"director",name:"director",fieldLabel:_VST("director","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("director"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",validator:a.createDelegate(this,[255],true),listeners:{scope:this,additem:this.updateScroller,removeitem:this.updateScroller,newitem:this.onAddNewitem}})}b.push({xtype:"radiogroup",itemId:"lock",name:"metadata_locked",column:2,labelStyle:"line-height: 24px",fieldLabel:String.format('{0} <img src="{1}" style="vertical-align:bottom;" border="0" ext:qtip="{2}">',Ext.util.Format.htmlEncode(_VST("lock","status")),SYNO.SDS.isNSM?"/webman/resources/images/theme/router/components/icon_information_mini.png":"/webman/resources/images/components/icon_information_mini.png",Ext.util.Format.htmlEncode(_VST("lock","desc"))),items:[{xtype:"syno_radio",boxLabel:_VST("lock","status_lock"),name:"metadata_locked",inputValue:true,checked:true},{xtype:"syno_radio",boxLabel:_VST("lock","status_unlock"),name:"metadata_locked",inputValue:false}]});b.push({xtype:"syno_textarea",itemId:"summary",name:"summary",fieldLabel:_VST("summary","title"),width:300,height:130,validator:a.createDelegate(this,[4096],true)});if(f===SYNO.SDS.VideoStation.Util._MOVIE_ID||f===SYNO.SDS.VideoStation.Util._TVSHOW_ID){b.push({xtype:"syno_textfield",hideLabel:true,itemId:"extra",name:"extra",style:"display:none;"});if(d==="tvshow_episode"){b.push({xtype:"syno_textfield",hideLabel:true,itemId:"tvshow_extra",name:"tvshow_extra",style:"display:none;"})}this.sourceID=Ext.id();var e='<div class="syno-vs-source-link" style="float: right;"><a id = "{0}" style = "cursor: pointer; text-decoration: none;color: #916CD9;float:right;height:20px;">{1}</a></div>';b.push({xtype:"syno_displayfield",hideLabel:true,name:"source",value:String.format(e,this.sourceID,_VST("video_info","source"))})}return b},getCategoryStore:function(a){return new Ext.data.Store({method:"POST",remoteSort:false,proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("metadata.cgi"),listeners:{scope:this,beforeload:function(b,c){var d=b.activeRequest.read;if(d){Ext.Ajax.abort(d)}}}}),baseParams:{api:"SYNO.VideoStation.Metadata",method:"list",version:"1",type:this.getCurType(),library_id:this._getCurLibraryId(),category:a,sort_by:a,sort_direction:"ASC"},paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},reader:new Ext.data.JsonReader({id:"id",root:"data.metadatas",totalProperty:"data.total",fields:["id","name"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore}})},fillConfig:function(a){var b={trackResetOnLoad:true,cls:"syno-vs-meta-form-setting",padding:"10px 10px 0 10px",border:false,autoFlexcroll:true,labelWidth:140,defaults:{anchor:"100%"},items:this.getItems(),tbar:{xtype:"syno_toolbar",items:[]}};var c=this.getCurType();if(c===SYNO.SDS.VideoStation.Util._TVSHOW_ID||c===SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID||c===SYNO.SDS.VideoStation.Util._MOVIE_ID){b.tbar.items.push({disabled:_S("demo_mode"),itemId:"search_correct",text:_VST("action","search_correct"),scope:this,handler:this.onLaunchSearchDialog})}b.tbar.items.push({itemId:"select_db",text:_VST("action","select_db"),scope:this,handler:function(){var d=new SYNO.SDS.VideoStation.VideoSelectionDialog({owner:this.owner});d.onLoad(this.getForm().findField("title").getValue())}},{itemId:"reset",text:_T("common","reset"),scope:this,handler:function(){this.getForm().reset()}});return Ext.apply(SYNO.LayoutConfig.fill(b),a)},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{library_id:this._getCurLibraryId()});return c},onLaunchSearchDialog:function(){var e=new SYNO.SDS.VideoStation.SearchDialog({owner:this.owner});var c=this.getForm().findField("episode");var a=this.getForm().findField("season");var d,b;if(a){d=a.getValue()}if(c){b=c.getValue()}e.onLoad(this.getForm().findField("title").getValue(),d,b)},onAddNewitem:function(b,a,c){a=a.trim();if(a){if(/[|]/.test(a)){this.owner.getMsgBox().alert(_VST("metadata","title"),_VST("error","illegal_char"));return}b.addItem({name:a,display:Ext.util.Format.htmlEncode(a)},true)}this.updateScroller()},loadResponse:function(d){var b=this.getCurType();var a=SYNO.SDS.VideoStation.Util._TVSHOW_ID===b?"tvshows":this._getResponseRoot(b);var c=d[a];if(Ext.isArray(c)){c=c[0]}this.onLoadData(c)},onSetData:function(d,c){var a=false;if(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID===this.getCurType()){a=(d.title!==this.getForm().findField("title").getValue())&&(d.tvshow_original_available!==this.getForm().findField("tvshow_original_available").getValue())}var b=this.getForm();b.trackResetOnLoad=false;this.onLoadData(d);b.trackResetOnLoad=true;if(c!==true&&a){this.owner.getMsgBox().confirm(_VST("metadata","title"),_VST("metadata","research_msg"),function(e){if("yes"===e){this.onLaunchSearchDialog()}},this)}},onLoadData:function(f){if(Ext.isEmpty(f)){this.owner.getMsgBox().alert(_VST("metadata","title"),_VST("error","no_data"),function(){var j=SYNO.SDS.VideoStation.Util.getActiveItem();j.onActivate(false);this.owner.getTabPanel().resetAllForm();this.owner.close()},this);return}var c=this.getForm();var h=c.getFieldValues();for(var b in h){if(h.hasOwnProperty(b)){var e=f[b]||(f.additional?f.additional[b]:undefined);this.setFieldValue(b,e)}}var g=this.getForm().findField("metadata_locked");if(g){g.setVisible(Ext.isBoolean(f.metadata_locked));var i=g.items.items[f.metadata_locked===false?1:0];i.setValue(true);g.eachItem(function(j){j.initValue()})}var a,d;if(f.original_available){d=this.getForm().findField("original_available");a=f.original_available.split("-");if(a.length!==3&&a.length===1){f.original_available=f.original_available+"-01-01";a=f.original_available.split("-")}this.getForm().setValues({original_available:(a.length===3)?f.original_available:""})}if(f.record_date){d=this.getForm().findField("original_available");a=f.record_date.split(" ");this.getForm().setValues({original_available:a[0],record_date:a[1]})}this.loadedFormString=this.getForm().getValues(true);this.doLayout()},isModified:function(){return this.loadedFormString!==this.getForm().getValues(true)},setFieldValue:function(f,e){var d;if((d=this.getForm().findField(f))&&Ext.isDefined(e)){if(Ext.isArray(e)&&Ext.isFunction(d.setValueEx)){var a=[],b;for(var c=0;c<e.length;c++){b=e[c];a.push({name:b,display:Ext.util.Format.htmlEncode(b)})}d.setValueEx(a);d.originalValue=d.getValue()}else{this.getForm().setValues([{id:f,value:e||""}])}}},onSetVisibleFileFields:function(a,d){var c=this.getForm().findField("file_name");var b=this.getForm().findField("file_path");if(c&&b){c.setVisible(a||false);b.setVisible(a||false);if(d){this.getForm().setValues({file_name:SYNO.SDS.VideoStation.Util.parseFullPathToFileName(d),file_path:d})}}},clearValues:function(){var a=this.getForm();a.items.each(function(b){if(b.name&&b.name==="source"){return}if(b.xtype==="radiogroup"){b.items.items[0].setValue(true);b.items.items[1].setValue(false)}else{if(b.clearValue){b.clearValue()}else{b.setValue("")}}})},onLoadDatas:function(c){var b=this.getForm();var a=["title","tvshow_original_available","season","episode"];b.items.each(function(d){if(-1===a.indexOf(d.itemId)){d.hide();d.disable()}});b.setValues(Ext.apply({title:c[0].get("title"),tvshow_original_available:c[0].get("tvshow_original_available")},this.getSeasonEpisodeValues(c)));this.loadedFormString=this.getForm().getValues(true);this.doLayout()},getSeasonEpisodeValues:function(e){var d,c=true;var b,f=true;Ext.each(e,function(g){if(!d){d=g.get("season")}else{if(d!==g.get("season")){c=false}}if(!b){b=g.get("episode")}else{if(b!==g.get("episode")){f=false}}});var a={};if(c&&d){a.season=d}if(f&&b){a.episode=b}return a},getCurType:function(){return this._getOwner().getCurType()}});Ext.define("SYNO.SDS.VideoStation.SourceDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var c=new SYNO.SDS.VideoStation.SourceListPanel();var b={owner:this._getOwner(),width:460,height:480,minWidth:300,minHeight:280,title:_VST("video_info","source"),layout:"fit",padding:24,autoScroll:false,resizable:false,items:[c],buttons:[{text:_T("common","close"),scope:this,handler:this.onClose}],keys:[{key:27,scope:this,handler:this.onClose}]};Ext.apply(b,a);return b},onClose:function(){this.hide()}});Ext.define("SYNO.SDS.VideoStation.SourceListPanel",{extend:"Ext.list.ListView",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var g='<a target="_blank" class="syno-vs-source-link" href="http://www.atmovies.com.tw/home/">'+_VST("video_info","source_atmovies")+"</a>";var h='<a target="_blank" class="syno-vs-source-link" href="https://www.themoviedb.org/">'+_VST("video_info","tmdb")+"</a>";var d='<a target="_blank" class="syno-vs-source-link" href="http://creativecommons.org/licenses/by/2.5/">'+_VST("video_info","cc_by")+"</a>";var e='<a target="_blank" class="syno-vs-source-link" href="http://creativecommons.org/licenses/by/3.0/us/">'+_VST("video_info","cc_by")+"</a>";var f='<a target="_blank" class="syno-vs-source-link" href="http://www.allocine.fr/">'+_VST("video_info","allocine")+"</a>";var b=new Ext.data.JsonStore({data:{items:[{title:String.format(_VST("video_info","license_under"),g),id:"atmovies"},{title:String.format(_VST("video_info","license_under"),h),id:"tmdbdescription"},{title:String.format(_VST("video_info","license_under"),d),id:"ccby"},{title:String.format(_VST("video_info","license_under"),e),id:"tvdb"},{title:String.format(_VST("video_info","license_under"),f),id:"allocine"},{title:_VST("video_info","source_description"),id:"description",type:"description"}]},autoLoad:true,root:"items",fields:["title","id",{name:"type",defaultValue:"item"}]});var c={cls:"syno-vs-source-list",split:false,trackOver:false,hideHeaders:true,autoScroll:false,store:b,tpl:new Ext.XTemplate('<tpl for="rows">',"<dl>",'<tpl for="parent.columns">','<dt style="width:431px;text-align:{align};">',"{[values.tpl.apply(parent)]}","</dt>","</tpl>",'<div class="x-clear"></div>',"</dl>","</tpl>"),columns:[{dataIndex:"title",sortable:false,tpl:'<div class="container-{type}"><div class="ml-{type}"></div><div class="mc-{type}"><div class="video-source-{id}"><span>{title}</span></div></div><div class="mr-{type}"></div></div>'}],listeners:{scope:this,activate:this.onActivate}};Ext.apply(c,a);return c},onActivate:function(){}});Ext.define("SYNO.SDS.VideoStation.PosterPanel",{extend:"SYNO.ux.Panel",constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getResponseRoot"]);this.owner=b.owner;this.poster_images={};var a={itemId:"poster",cls:"poster-panel",layout:{type:"hbox",pack:"start",align:"middle"},items:[{xtype:"container",width:20},this.getPosterContainer(),{xtype:"container",width:14},this.getPosterForm()]};this.callParent([Ext.apply(a,b)])},getPosterID:function(){if(this.poster_id){return this.poster_id}this.poster_id=Ext.id();return this.poster_id},getPosterContainer:function(){if(this.poster){return this.poster}var a={cls:"frame",width:200,height:296,html:['<div class="icon" id="'+this.getPosterID()+'">',"</div>"].join("")};this.poster=new Ext.Container(a);return this.poster},setPosterContainer:function(b){var c=this.getPosterImage(b);var a=Ext.get(this.getPosterID());if(Ext.isIE8||Ext.isIE7){a.setStyle("filter",String.format("progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",c))}else{a.setStyle("background-image",String.format("url('{0}')",c))}},setPosterImage:function(b,c){var a=this;this.poster_images[b]=c;this.setPosterContainer(b);this.checkImage(b,c,function(d){a.setPosterImage(b,a.poster_images.error);a.getForm().findField("url").markInvalid(_VST("error","image_format"))})},getPosterImage:function(a){var b=this.poster_images[a];if(b===undefined||b===""){return this.poster_images.error}return b},checkImage:function(b,d,c){var a=new Image();a.onerror=function(){c(b,d)};a.src=d},getForm:function(){return this.getPosterForm().getForm()},isValid:function(){return this.getPosterForm().isValid()},isDirty:function(){return this.getPosterForm().isDirty()},getPosterForm:function(){if(this.form){return this.form}var a={width:450,owner:this.owner};this.form=new SYNO.SDS.VideoStation.PosterForm(a);return this.form},loadResponse:function(c){var b=this.convertResponseToData(c);if(Ext.isEmpty(b)){return}this.setIcon(b);this.setCorrespondingFolderPath(b);var a=this.getCurType();this.form.remindField.setVisible(a===SYNO.SDS.VideoStation.Util._MOVIE_ID||a===SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID)},setIcon:function(c){var d=SYNO.SDS.VideoStation.Util;var b=this.getCurType();var a=(b===d._MOVIE_ID||b===d._TVSHOW_ID)?"poster":"screenshot";this.poster.removeClass(["poster","screenshot"]);this.poster.addClass(a);var e=this.getImageURL(c);this.setPosterImage("error",this.getImageURL({id:0}));this.setPosterImage("original",e)},getImageURL:function(b){var a=this.getCurType();var c=b.id;return SYNO.SDS.VideoStation.Util.getImageURL(SYNO.SDS.VideoStation.Util._getWebAPIURL("poster.cgi"),{type:a,id:c,mtime:b.additional?b.additional.poster_mtime||"":""})},clearValues:function(){this.getForm().reset()},getCurType:function(){return this._getOwner().getCurType()},convertResponseToData:function(d,a){if(!a){var b=this.getCurType();a=SYNO.SDS.VideoStation.Util._TVSHOW_ID===b?"tvshows":this._getResponseRoot(b)}var c=d[a];if(Ext.isArray(c)){c=c[0]}return c},setCorrespondingFolderPath:function(a){if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_ID){this.owner.setStatusBusy();this.sendWebAPI({api:"SYNO.VideoStation.TVShowEpisode",method:"list",version:2,params:{tvshow_id:a.id,library_id:this._getCurLibraryId(),additional:Ext.encode(["file"])},scope:this,callback:function(f,e,d,b){this.owner.clearStatusBusy();var c=this.convertResponseToData(e,this._getResponseRoot(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID));this.setFolderPath(c)}})}else{this.setFolderPath(a)}},setFolderPath:function(b){var a=b.additional.file[0].sharepath;this.form.folderPath=a.substring(0,a.lastIndexOf("/"))}});Ext.define("SYNO.SDS.VideoStation.PosterForm",{extend:"SYNO.ux.FormPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={trackResetOnLoad:true,width:500,autoHeight:true,cls:"syno-vs-meta-form-setting",border:false,labelWidth:130,defaults:{anchor:"100%"},items:[this.radio_group=new Ext.form.RadioGroup({itemId:"poster",vertical:true,columns:1,hideLabel:true,items:[this.radio_original=new SYNO.ux.Radio({boxLabel:_VST("poster","original"),name:"poster",itemId:"original",inputValue:"original",checked:true}),{xtype:"syno_radio",boxLabel:_VST("poster","url"),name:"poster",inputValue:"url"},{xtype:"syno_textfield",name:"url",width:500,indent:1,vtype:"url",allowBlank:false,disabled:true,listeners:{scope:this,change:function(){this.owner.PosterPanel.setPosterImage("url",this.getForm().findField("url").value)}}},{xtype:"syno_radio",boxLabel:_VST("poster","select_existed_image"),name:"poster",inputValue:"file"},{xtype:"syno_compositefield",items:[{xtype:"syno_textfield",value:"",width:350,indent:1,name:"displayedFile",disabled:true},{xtype:"syno_button",text:_VST("common","select"),scope:this,handler:this.onSelectClick}]},{xtype:"syno_textfield",name:"file",width:500,indent:1,allowBlank:false,hidden:true,disabled:true}],listeners:{scope:this,change:function(d,c){this.getForm().findField("url").setDisabled((c.inputValue!=="url"));this.getForm().findField("file").setDisabled((c.inputValue!=="file"));this.owner.PosterPanel.setPosterContainer(c.inputValue)}},validate:this.validateUrl.createDelegate(this)}),{xtype:"syno_displayfield"},this.remindField=new SYNO.ux.DisplayField({value:_VST("poster","set_image_desc"),hidden:true})]};return Ext.apply(b,a)},validateUrl:function(){var b=Ext.form.RadioGroup.prototype.validate.apply(this.radio_group,arguments);var a=this.getForm().findField("url").isValid();return(b&&a)?true:false},onSelectClick:function(){if(this.imageSelector){this.imageSelector.show()}else{this.imageSelector=new SYNO.SDS.VideoStation.ImageSelector({owner:this.owner,gotoPath:this.folderPath});this.imageSelector.mon(this.imageSelector,"choose",this.onSelectDone,this);this.imageSelector.open()}},onSelectDone:function(a){if(!a){return}var b=this.getBaseURL({api:"SYNO.Core.File.Thumbnail",method:"get",version:1,params:{path:SYNO.API.EscapeStr(a.get("path")),size:"medium"}});this.owner.PosterPanel.setPosterImage("file",b);this.radio_group.setValue("poster","file");this.getForm().findField("displayedFile").setValue(a.get("path"));this.getForm().findField("file").setValue(a.get("real_path"));this.imageSelector.hide()}});Ext.define("SYNO.SDS.VideoStation.MetaDataDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getCurLibraryTitle"]);this.callParent([this.fillConfig(a)]);this.getTabPanel().addDeactivateCheck(this)},fillConfig:function(a){this.type=a.type;var b={cls:"syno-vs-metadata-win",owner:this._getOwner(),width:800,height:560,minWidth:200,minHeight:200,title:_VST("action","edit_metadata"),layout:"fit",items:[this.getTabPanel()],buttons:[{btnStyle:"blue",disabled:_S("demo_mode"),text:_T("common","ok"),scope:this,handler:function(){this.onApply()}},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:27,scope:this,handler:this.onCancel}]};return Ext.apply(b,a)},onCancel:function(){var b,a;b=this.getMetadataPanel().getForm();if(this.getPosterPanel()){a=this.getPosterPanel().getForm()}if(b.isDirty()||(a&&a.isDirty())){this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(c){if(c==="yes"){this.onHideDialog()}},this)}else{this.onHideDialog()}},onHideDialog:function(){if(this.getTabPanel()){this.getTabPanel().setActiveTab(0)}this.clearValues();this.clearDirty();this.setting_count=0;this.hide()},clearDirty:function(){var f=this.getMetadataPanel().getForm();var d,b=f.items.items,a=b.length,e;for(d=0;d<a;d++){e=b[d];e.originalValue=String(e.getValue())}},sourceHandle:function(){var a=Ext.fly(this.metadataPanel.sourceID);a.dom.onclick=this.onClicSource.createDelegate(this)},onClicSource:function(){if(!this.sourceDialog){this.sourceDialog=new SYNO.SDS.VideoStation.SourceDialog({owner:this})}this.sourceDialog.open()},onLoads:function(b){this.getTabPanel().hideTabStripItem("poster");this.getMetadataPanel().onLoadDatas(b);this.fromInternet="";this.show();var a=SYNO.SDS.VideoStation.Util.onGetHeight(this.getMetadataPanel(),140);this.setHeight(a<350?350:a);this.episode_recs=b;if(this.metadataPanel.sourceID){this.sourceHandle()}},onLoad:function(c,a){this.data_id=c;this.fromInternet="";var b={id:c,additional:Ext.encode(["title","tvshow_summary","tvshow_extra","summary","file","actor","writer","director","extra","genre","poster_mtime"])};this.data_video_rec=a;if(a){this.setTitle(_VST("action","correct_metadata"));this.getMetadataPanel().onSetVisibleFileFields(true,a.get("sharepath"))}else{this.getMetadataPanel().onSetVisibleFileFields(false);this.setTitle(_VST("action","edit_metadata"))}this.mon(this,"beforeshow",function(){this.getTabPanel().loadAllForm({method:"getinfo",api:this.getWebAPIID(),version:2},b)},this,{single:true});this.show();if(this.metadataPanel.sourceID){this.sourceHandle()}},clearValues:function(){this.getMetadataPanel().clearValues();this.getPosterPanel().clearValues();this.searchmetadata=undefined},onSetMetaData:function(a){this.clearValues();this.getMetadataPanel().onSetData(a,!!this.episode_recs)},onSetRecords:function(e,f){this.clearValues();var b=this.getMetadataPanel().getForm();var c=SYNO.Util.copy(e.data);if(!Ext.isEmpty(c.tag_line)){Ext.apply(c,{tagline:c.tag_line});delete c.tag_line}this.onSetRecord(b,c);var a=this.getPoster(c.extra),d;b=this.getPosterPanel().getForm();d=b.findField("poster");if(a){d.setValue("url");d=b.findField("url");d.setValue(a)}this.searchmetadata=this.getTitleAndDateString();this.fromInternet=Ext.isString(f)?f:""},getTitleAndDateString:function(){var b=this.getMetadataPanel().getForm();var a=b.findField("original_available");var c=b.findField("title");return c+a},getPoster:function(a){if(!a){return}var f;try{f=Ext.decode(a)}catch(d){return}var c,b;for(c in f){if(f.hasOwnProperty(c)){for(b in f[c]){if(f[c].hasOwnProperty(b)){if(-1!=b.toLowerCase().indexOf("poster")){var g;Ext.each(f[c][b],function(e){if(!Ext.isEmpty(e)){g=e}});return g}}}}}},onSetRecord:function(c,b){var e,h;for(h in b){if(!Ext.isFunction(b[h])&&(e=c.findField(h))){if(Ext.isEmpty(b[h])){continue}if(e.xtype==="syno_superboxselect"){var a=[],g=Ext.decode(b[h]);if(!Ext.isArray(g)){g=[g]}Ext.each(g,function(i){a.push({name:i,display:Ext.util.Format.htmlEncode(i)})});e.setValueEx(a)}else{if(b[h]==="0"){continue}e.setValue(b[h])}}}var f;if(b.original_available){e=c.findField("original_available");f=b.original_available.split("-");var d=f[0]+"-"+(Ext.isEmpty(f[1])?"01":f[1])+"-"+(Ext.isEmpty(f[2])?"01":f[2]);e.setValue(d)}},isModified:function(){return this.getMetadataPanel().isModified()},onApply:function(f,r){if(_S("demo_mode")){this.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}if(!r&&!this.isModified()){r={overwrite:"skip"}}r=r||{};var m,n;var c=this.getMetadataPanel().getForm();if(this.episode_recs){r={};var g=[],v,t,b;var l=["title","tvshow_original_available","season","episode"];for(var p=0;p<this.episode_recs.length;p++){v={};m=this.episode_recs[p].get("id");for(var o=0;o<l.length;o++){t=l[o];b=c.findField(t);if(b.isDirty()){v[t]=b.getValue()}}if(Ext.isEmpty(v)){continue}v.id=m;g.push(v)}n=Ext.apply({episodes:Ext.encode(g)},r)}else{if(this.data_video_rec){r=Ext.apply({video_id:this.data_video_rec.get("id")},r);if(!f){var h=c.findField("tvshow_original_available")||c.findField("original_available")||c.findField("record_date");var w=c.findField("title");var u=c.findField("season"),k=c.findField("episode");var s=false;if(u&&k){s=u.isDirty()||k.isDirty()}if(!h.isDirty()&&!w.isDirty()&&!s){w=this._getCurLibraryTitle();var e=String.format(_VST("metadata","correct_metadata_confirm"),w);this.getMsgBox().confirm(this.title,e,function(i){if(i==="yes"){this.onApply(true)}else{this.mun(this,"beforeclose",this.getTabPanel().onBeforeDeactivate,this);this.getTabPanel().resetAllForm();this.onHideDialog()}},this);return}}}else{r=Ext.apply({id:this.data_id},r)}}var a=c.findField("record_date");if(a){var q=c.findField("original_available");a=(Ext.form.DateField.superclass.getValue.call(q)+" "+a.getValue());Ext.apply(r,{record_date:a,original_available:""})}if(!this.episode_recs&&this.searchmetadata&&this.searchmetadata!==this.getTitleAndDateString()){Ext.apply(r,{extra:"",tvshow_extra:""})}var d=this.episode_recs?"edit_adv":"edit";if(SYNO.SDS.VideoStation.Util._TVSHOW_ID===this.getCurType()){Ext.apply(r,{update_tvshow:this.fromInternet||""})}Ext.apply(r,{library_id:this._getCurLibraryId()});this.getTabPanel().applyAllForm({method:d,api:this.getWebAPIID()},r,n)},getTabPanel:function(){if(!this.tabPanel){var a=[this.getMetadataPanel()];a.push(this.getPosterPanel());var b={owner:this,activeTab:0,checkFormDirty:true,items:a,listeners:{applysuccess:(function(e,c,g,f){this.setting_count=this.setting_count||1;var i=Ext.isBoolean(this.blOverwrite)?this.blOverwrite:true;if(this.episode_recs||!this.getPosterPanel().getForm().findField("poster").isDirty()||1<this.setting_count||!i){var d=this._getHistoryInfo();if(SYNO.SDS.VideoStation.Util._VIEW_EPISODE===d.view&&"SYNO.VideoStation.TVShow"===f.api){Ext.apply(d.params,{id:g.id,name:f.title,original_available:f.original_available||d.params.original_available,summary:f.summary})}(function(){SYNO.SDS.VideoStation.Util._gotoViewAgain()}).defer(100);return true}var h=g.id||this.data_id;this.setting_count++;this.getTabPanel().applyAllForm({method:"setimage",api:"SYNO.VideoStation.Poster"},{id:h,type:this.data_video_rec?"video":this.getCurType()});SYNO.SDS.VideoStation.Util.setModImgTime(this.getCurType(),h);return false}).createDelegate(this),loadsuccess:(function(){var c=SYNO.SDS.VideoStation.Util.onGetHeight(this.getMetadataPanel(),140);this.setHeight(c<350?350:c)}).createDelegate(this),requestfail:(function(e,c,g,f){if(!c&&g&&(422===g.code)){var d=new SYNO.SDS.VideoStation.MetaDataConfirmDialog({owner:this});this.mon(d,"onapply",function(h,i){this.blOverwrite=i;this.onApply(true,{overwrite:i?"overwrite":"skip"})},this,{single:true});d.show()}else{this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation.Util.getWebAPIErr(c,g,f),function(h){},this)}this.setting_count=0}).createDelegate(this)}};this.tabPanel=new SYNO.SDS.VideoStation.MetadataTabPanel(b)}return this.tabPanel},getMetadataPanel:function(){if(this.metadataPanel){return this.metadataPanel}return(this.metadataPanel=new SYNO.SDS.VideoStation.MetadataPanel({title:_VST("metadata","title"),owner:this}))},getPosterPanel:function(){if(this.PosterPanel){return this.PosterPanel}return(this.PosterPanel=new SYNO.SDS.VideoStation.PosterPanel({title:_VST("poster","title"),owner:this}))},getWebAPIID:function(){return SYNO.SDS.VideoStation.Util.getinfo_WebAPI(this.getCurType()).api},getCurType:function(){return this.type}});Ext.define("SYNO.SDS.VideoStation.MetadataTabPanel",{extend:"SYNO.SDS.Utils.SettingTabPanel",loadAllForm:function(b,a){if(!b){SYNO.Debug("No api in TabPanel");return}this.load_apimethod=b.method;if(false===this.onBeforeRequest(b,a)){return false}this.sendAjaxRequest(b,a)},applyAllForm:function(b,a,c){if(!b){SYNO.Debug("No url in TabPanel");return false}this.save_apimethod=b.method;if(this.checkFormDirty&&!this.isAnyFormDirty()){this.owner.mun(this.owner,"beforeclose",this.onBeforeDeactivate,this);this.owner.onHideDialog();return true}if(false===this.onBeforeRequest(b,a)){return false}if(!Ext.isDefined(c)){c=c||{};this.items.each(function(j,f,i){if(!j.getForm){return}var h=j.getForm();var e=h.getValues();if(h.findField("original_available")&&!h.findField("original_available").isDirty()){delete e.original_available}var d=h.findField("tvshow_original_available");if(d&&d.isYear()){e.tvshow_original_available=d.getYearValue()}if(h.findField("extra")&&!h.findField("extra").isDirty()){delete e.extra}if(h.findField("tvshow_extra")&&!h.findField("tvshow_extra").isDirty()){delete e.tvshow_extra}var g;for(g in e){if(e.hasOwnProperty(g)){if(Ext.isArray(e[g])){e[g]=e[g].join("|")}if(h.findField(g)&&h.findField(g).disabled){delete e[g]}}}Ext.apply(c,e)},this)}else{c=c||{}}a=a||{};Ext.apply(c,a);this.sendAjaxRequest(b,c)},sendAjaxRequest:function(b,a){if(b.method===this.load_apimethod){this.owner.setStatusBusy()}else{this.owner.setStatusBusy({text:_T("common","saving")})}SYNO.API.currentManager.requestAjaxAPI(b.api,b.method||"getinfo",b.version||1,{timeout:3600000},a,this.onRequestDone,this)},onBeforeRequest:function(c,b){var a=this.getAllForms();var d=true;if(c.method===this.load_apimethod){return true}Ext.each(a,function(g,e,f){if(!g.isValid()){d=false;this.setActiveByForm(g,e);return false}},this);if(!d){return false}return true},onRequestDone:function(a,d,c,b){if(this.isDestroyed){return}this.owner.clearStatusBusy();if(!a){this.reportFail(a,d,b.params)}else{this.reportSuccess(a,d,b.params)}},reportSuccess:function(a,d,c){var b=c.method;if(b===this.save_apimethod){this.owner.setStatusOK();if(false!==this.fireEvent("applysuccess",this,a,d,c)){this.owner.mun(this.owner,"beforeclose",this.onBeforeDeactivate,this);this.owner.onHideDialog()}return}this.items.each(function(h,e,g){if(h.loadResponse){h.loadResponse(d)}else{if(h.getForm){var f=h.getForm();f.loadRecord(d);return}}},this);this.fireEvent("loadsuccess",this,a,d,c)},reportFail:function(a,c,b){this.fireEvent("requestfail",this,a,c,b)}});Ext.define("SYNO.SDS.VideoStation.MetaDataConfirmDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getCurLibraryTitle"]);var b={owner:a.owner,resizable:false,minimizable:false,maximizable:false,closable:true,stateful:false,buttonAlign:"center",width:400,height:240,title:_VST("action","edit_metadata"),items:[this.getFormPanel()],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:27,fn:this.close,scope:this}]};SYNO.SDS.VideoStation.MetaDataConfirmDialog.superclass.constructor.call(this,b)},getFormPanel:function(){if(this.form){return this.form}this.form=new SYNO.ux.FormPanel({items:[{xtype:"syno_displayfield",value:String.format(_VST("metadata","duplicate_desc"),this._getCurLibraryTitle())},{xtype:"radiogroup",itemId:"mode",columns:1,vertical:true,hideLabel:true,items:[{xtype:"syno_radio",boxLabel:_VST("metadata","duplicate_keep"),inputValue:"skip",name:"mode",checked:true},{xtype:"syno_radio",boxLabel:_VST("metadata","duplicate_replace"),name:"mode",inputValue:"overwrite",checked:false}]}]});return this.form},onApply:function(){var a=false;if("overwrite"===this.getFormPanel().getForm().findField("mode").getValue().inputValue){a=true}this.fireEvent("onapply",this,a);this.close()}});Ext.define("SYNO.SDS.VideoStation.ActionMenu",{extend:"SYNO.ux.Menu",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getSelectedVideoId","_getCollectionStore"]);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ActionMenu",this);this.callParent([this.fillConfig(a)]);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"afterLoadCollection",this.eventLoadCollection,this);this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CollectionMgr"),"afterAddDeleteVideoToCollection",this.eventAddDeleteVideoToCollection,this)},fillConfig:function(a){var b={cls:"syno-vs-menu",items:[],listeners:{scope:this,beforeshow:this.onUpdateMenu}};Ext.apply(b,a);return b},updateActionMenuItems:function(){var b=[];this.removeAll(true);b.push({text:_VST("collection","title"),itemId:"collections",menu:this.getCollectionMenu(true),hideOnClick:false,cls:"syno-vs-action"});b.push({itemId:"edit_collection",handler:this.collectionMenu.onEditCollection,text:_VST("collection","edit_collection"),hidden:true,scope:this.collectionMenu});b.push({itemId:"delete_collection",handler:this.collectionMenu.onDeleteCollection,text:_VST("collection","delete_collection"),hidden:true,scope:this.collectionMenu});b.push({itemId:"get_public_sharing_link",handler:this.collectionMenu.onClickGetShareLink,text:_VST("action","get_share_link"),hidden:true,scope:this.collectionMenu});b.push({itemId:"-3_remove_default_shared_from_collection",handler:this.collectionMenu.onRemoveFromUserDefCollection,text:_VST("action","stop_sharing"),hidden:true,scope:this.collectionMenu});b.push({xtype:"menuseparator",itemId:"sep_collection"});b.push({itemId:"remove_favorite_from_collection",handler:this.collectionMenu.onRemoveFavoite,text:_VST("action","remove_favorite"),hidden:true,scope:this.collectionMenu});b.push({itemId:"remove_watch_list_from_collection",handler:this.collectionMenu.onRemoveWatchList,text:_VST("action","remove_watch_list"),hidden:true,scope:this.collectionMenu});this._getCollectionStore().each(function(c){var f=c.get("id");var e=SYNO.SDS.VideoStation.Util.getCollectionName(c.get("title"));var d=c.get("type");if(-1!==f&&-2!==f&&-3!==f&&"original"===d){b.push({itemId:f+"_remove_"+e+"from_collection",handler:this.collectionMenu.onRemoveFromUserDefCollection,text:String.format(_VST("collection","remove_from_colection"),e),hidden:true,scope:this.collectionMenu})}},this);b=b.concat(this.getPlayViewActionGroup().getArray());var a=b.length-1;b.splice.apply(b,[a,0].concat(this.getMetaActionGroup().getArray()));b.push({xtype:"menuseparator",itemId:"sep_play"});b.push({itemId:"public_sharing",handler:this.collectionMenu.onClickPublicSharing,text:_VST("collection","share_to_public"),hidden:true,scope:this.collectionMenu});b=b.concat(this.getWatchStatusActionGroup().getArray());b=b.concat(this.getDTVActionGroup().getArray());b.push({xtype:"menuseparator",itemId:"sep_add_del_video"});b.push({text:_VST("action","del_video"),itemId:"del_video",handler:this.delVideoHandler,scope:this,hidden:true});Ext.each(b,function(e,c,d){this.addItem(e)},this)},hasVisibleMenu:function(){for(var b=0,a=this.items.items.length;b<a;b++){var c=this.items.items[b];if(!c.hidden){return true}}return false},onUpdateMenu:function(c){c=(c===undefined)?this:c;var i=SYNO.SDS.VideoStation.Util;var d=this._getHistoryInfo();var g=this._getCurType();var j=SYNO.SDS.VideoStation.Util.getActiveItem();var k=this._checkIsByfolder();var e=this.getSelectedData();var h=this.getSelectedDatas();var b=SYNO.SDS.VideoStation.Util.getBlSelectedFolder();var a=(h.length>0);var f=(h.length>1);this.onUpdateDelVideoAction(c,g,i,d,a,b,k);this.onUpdateCollectionMenu(c,d,g,i,k,b,a,f);this.onUpdateShareToPublicAction(c,d,g,i,k,b,a,f);this.onUpdateMetaData(d,g,i,j,k,b,a,f);this.onUpdatePlayView(d,g,i,j,k,b,a,f);this.onUpdateWatchStatus(d,g,i,j,k,b,a,f);this.onUpdateCollectionAction(d,i,a,f,e);this.onUpdateGetShareLinkAction(d,i,f,e,a);this.onUpdateRemoveCollection(j,d);this.onUpdateSepItem(c);this.onUpdateDTVActions(d,g,i,a)},onUpdateAddVideoAction:function(d,a,c){var b=d.getComponent("add_video");if(!_S("is_admin")){b.hide();return}switch(a){case c._MOVIE_ID:case c._TVSHOW_ID:case c._TVSHOW_EPISODE_ID:case c._HOME_VIDEO_ID:b.show();break;default:b.hide();break}},onUpdateDelVideoAction:function(c,g,h,e,b,d,j){var a=false;var i=c.getComponent("del_video");var f=(g===h._MOVIE_ID||g===h._HOME_VIDEO_ID||g===h._TV_RECORDER_ID);if(!_S("is_admin")||!b||d){i.hide();return}switch(e.view){case h._VIEW_HOMEPAGE:a=f;break;case h._VIEW_FILTERING:a=f||(h._TVSHOW_ID&&j);break;case h._VIEW_EPISODE:a=(g===h._TVSHOW_ID);break;case h._VIEW_DETAIL:a=(this.getSelectedDetailDatas().length>0);break;case h._VIEW_COLLECTION:a=true;break;case h._VIEW_GRID:a=false;break}if(a){i.show()}else{i.hide()}},onUpdateCollectionMenu:function(b,d,g,h,i,c,a,e){var f=false;switch(d.view){case h._VIEW_HOMEPAGE:if(a&&h._TVSHOW_ID!==g){f=true}break;case h._VIEW_FILTERING:if(i){if(!c){f=true}}else{if(h._TVSHOW_ID!==g){f=true}}break;case h._VIEW_DETAIL:f=true;break;case h._VIEW_EPISODE:if(a){f=true}break;case h._VIEW_GRID:break;case h._VIEW_COLLECTION:break}itemCollection=b.get("collections");if(!f||h._COLLECTION_ID===g){itemCollection.hide()}else{itemCollection.show()}},onUpdateShareToPublicAction:function(b,d,f,g,i,c,a,e){if(!SYNO.SDS.VideoStation.Util.ableToControlSharing()){return}var h=false;switch(d.view){case g._VIEW_HOMEPAGE:h=a&&(g._TVSHOW_ID!==f);break;case g._VIEW_FILTERING:h=(i&&!c)||(!i&&g._TVSHOW_ID!==f);break;case g._VIEW_DETAIL:h=true;break;case g._VIEW_EPISODE:h=a;break;case g._VIEW_GRID:break;case g._VIEW_COLLECTION:h=a&&!e;break}if(!h||d.params.collection_id===-3){this.getComponent("public_sharing").hide()}else{this.getComponent("public_sharing").show()}},onUpdateMetaData:function(c,f,g,h,i,b,a,e){var d=false;switch(c.view){case g._VIEW_HOMEPAGE:if(a){d=_S("is_admin")}break;case g._VIEW_FILTERING:if(!i&&!e){d=_S("is_admin")}break;case g._VIEW_DETAIL:d=_S("is_admin");break;case g._VIEW_EPISODE:d=_S("is_admin");break;case g._VIEW_GRID:break;case g._VIEW_COLLECTION:if(1===h.getSelectionModel().getCount()){d=_S("is_admin")}break}this.getMetaActionGroup()[!d?"hideAll":"showAll"]();if(_S("is_admin")){this.getMetaActionGroup().get("correct_metadata").hide();if(h.getFiles&&!Ext.isEmpty(h.getFiles)&&h.getFiles().length>1){this.getMetaActionGroup().get("correct_metadata").show()}if((f===g._MOVIE_ID||f===g._TVSHOW_ID||f===g._HOME_VIDEO_ID)&&i&&g._VIEW_FILTERING===c.view&&!b&&!e){this.getMetaActionGroup().get("correct_metadata").show()}}},onUpdatePlayView:function(c,f,g,h,i,b,a,e){var d=false;switch(c.view){case g._VIEW_HOMEPAGE:if(a&&g._TVSHOW_ID!==f){d=true}break;case g._VIEW_FILTERING:if(i){d=true}else{if(g._TVSHOW_ID!==f){d=true}}break;case g._VIEW_DETAIL:d=true;break;case g._VIEW_EPISODE:if(a){d=true}break;case g._VIEW_GRID:break;case g._VIEW_COLLECTION:if(1===h.getSelectionModel().getCount()){d=true}break}this.getPlayViewActionGroup()[!d||e?"hideAll":"showAll"]();if((f===g._MOVIE_ID||f===g._TVSHOW_ID||f===g._HOME_VIDEO_ID)&&i&&b&&g._VIEW_FILTERING===c.view){this.getPlayViewActionGroup().get("play").hide();this.getPlayViewActionGroup().get("view_video_info").hide();this.getPlayViewActionGroup().get("search_subtitle").hide()}},onUpdateWatchStatus:function(e,h,i,j,k,d,b,f){var a=false;switch(e.view){case i._VIEW_HOMEPAGE:if(b&&i._TVSHOW_ID!==h){a=true}break;case i._VIEW_FILTERING:if(k){if(!d){a=true}}else{if(i._TVSHOW_ID!==h){a=true}}break;case i._VIEW_EPISODE:if(b){a=true}break;case i._VIEW_DETAIL:if(b){a=true}break;case i._VIEW_COLLECTION:break}this.getWatchStatusActionGroup().hideAll();if(!a){return}var g=false,c=false;if(i._VIEW_DETAIL===e.view){if(0!==j.watched_ratio){c=true}if(1!==j.watched_ratio){g=true}}else{Ext.each(this.getSelectedDatas(),function(n){var l=n?n.get("additional"):undefined;var m=l?l.watched_ratio:0;if(0!==m){c=true}if(1!==m){g=true}},this)}if(g){this.getWatchStatusActionGroup().get("set_watched").show()}if(c){this.getWatchStatusActionGroup().get("set_unwatched").show()}},onUpdateCollectionAction:function(c,f,a,b,e){this.getComponent("edit_collection").hide();this.getComponent("delete_collection").hide();if(f._VIEW_GRID!==c.view||!a||b){return}this.getComponent("edit_collection").show();this.getComponent("delete_collection").show();var d=e.get("title");this.getComponent("edit_collection").setDisabled(d==="syno_favorite"||d==="syno_watchlist"||d==="syno_default_shared");this.getComponent("delete_collection").setDisabled(d==="syno_favorite"||d==="syno_watchlist"||d==="syno_default_shared")},onUpdateGetShareLinkAction:function(c,e,b,d,a){if(!SYNO.SDS.VideoStation.Util.ableToControlSharing()||!a){return}var f=this.getComponent("get_public_sharing_link");if(b||(e._VIEW_GRID!==c.view&&e._VIEW_COLLECTION!==c.view)){f.hide();return}f.show();if(e._VIEW_GRID===c.view){f.setText(_VST("collection","share_to_public"));f.setDisabled(d.get("title")==="syno_default_shared")}else{if(c.params.collection_id===-3){f.setText(_VST("action","get_video_share_link"))}else{f.setText(_VST("action","get_share_link"))}f.setDisabled(!c.params.sharing_valid)}},onUpdateRemoveCollection:function(a,b){var h,e;var f=this._getCurType();if(SYNO.SDS.VideoStation.Util._VIEW_COLLECTION===b.view){var d=this._getHistoryInfo();e=d?d.params.collection_id:null}var j=this.items.items;for(var c=0;c<j.length;c++){h=-1;if(-1===j[c].itemId.indexOf("remove_")){continue}if(SYNO.SDS.VideoStation.Util._COLLECTION_ID!==f){j[c].hide();continue}var g=j[c].itemId.indexOf("_remove_");h=(-1!==g)?parseInt(j[c].itemId.substring(0,g),10):-1;if(-1===e&&"remove_favorite_from_collection"===j[c].itemId){j[c].show()}else{if(-2===e&&"remove_watch_list_from_collection"===j[c].itemId){j[c].show()}else{if(-3===e&&"-3_remove_default_shared_from_collection"===j[c].itemId){j[c].show()}else{if(-1!==h&&h===e){j[c].show()}else{j[c].hide()}}}}}},onUpdateDTVActions:function(e,c,f,a){var d=f._VIEW_HOMEPAGE===e.view&&f._TV_RECORDER_ID===c;if(d){var g=this.items.items;for(var b=0;b<g.length;b++){g[b].hide()}if(a){this.getDTVActionGroup().showAll();this.getDTVActionGroup().updateRecordItem()}}else{this.getDTVActionGroup().hideAll()}},onUpdateSepItem:function(e){var a=0,b=0,d=false,c=null;e.items.each(function(f){if(f.itemId.substr(0,3)==="sep"){f.show()}});e.items.each(function(f){if(!f.hidden){a++;if(f.itemId.substr(0,3)==="sep"){b++;if(1===a||2<=b){f.hide()}else{f.show();c=f;d=true}}else{d=false;b=0}}},this);if(d){c.hide()}},getCollectionMenu:function(a){if(this.collectionMenu){this.collectionMenu.destroy()}if(!this.collectionMenu||a){this.collectionMenu=new SYNO.SDS.VideoStation.CollectionMenu();this.addManagedComponent(this.collectionMenu)}return this.collectionMenu},getMetaActionGroup:function(){if(this.metaAction){return this.metaAction}var b=SYNO.SDS.VideoStation.Util;var a=b._createAction({hidden:!_S("is_admin"),itemId:"edit_metadata",handler:function(){this.onEditMetaData()},scope:this});var c=b._createAction({hidden:!_S("is_admin"),itemId:"correct_metadata",handler:function(){this.onEditMetaData(true)},scope:this});return(this.metaAction=new SYNO.SDS.Utils.ActionGroup([a,c]))},onEditMetaData:function(c){var f=this._getHistoryInfo();var d=SYNO.SDS.VideoStation.Util.getActiveItem();var h,e,g,b;e=this.getSelectedDatas();if(SYNO.SDS.VideoStation.Util._VIEW_EPISODE===f.view&&e.length===0){this.dialogMetaData=new SYNO.SDS.VideoStation.MetaDataDialog({type:SYNO.SDS.VideoStation.Util._TVSHOW_ID});this.dialogMetaData.onLoad(f.params.id,b);return}if(e.length===0){return}g=e[0];if(g&&this._checkIsByfolder()){b=g}h=this._getSelectedVideoId();if(!h){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}var a=this._getSelectedVideoType();if(c&&SYNO.SDS.VideoStation.Util._VIEW_DETAIL===f.view){g=d.getSelectedFile();b=g}if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===a){this.dialogDTVMetaData=new SYNO.SDS.VideoStation.DTVMetaDataDialog();this.dialogDTVMetaData.show(h)}else{this.dialogMetaData=new SYNO.SDS.VideoStation.MetaDataDialog({type:a});if(1==e.length){this.dialogMetaData.onLoad(h,b)}else{this.dialogMetaData.onLoads(e)}}},getPlayViewActionGroup:function(){if(this.playviewAction){return this.playviewAction}return(this.playviewAction=new SYNO.SDS.VideoStation.PlayViewActionGroup())},getWatchStatusActionGroup:function(){if(this.watchstatusAction){return this.watchstatusAction}return(this.watchstatusAction=new SYNO.SDS.VideoStation.WatchStatusActionGroup())},getDTVActionGroup:function(){if(this.dtvAction){return this.dtvAction}return(this.dtvAction=new SYNO.SDS.VideoStation.DTVActionGroup())},getSelectedData:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedData()},getSelectedDatas:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").onGetSelectedDatas()},getSelectedDetailDatas:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData").grid.getSelectionModel().getSelections()},eventLoadCollection:function(){this.updateActionMenuItems();this.collectionMenu.updateCollectionsMenuitems()},eventAddDeleteVideoToCollection:function(){this.collectionMenu.onUpdateCollectionMenu()},getLibrary:function(){var a;a={type:SYNO.SDS.VideoStation.Util._getCurType(),id:SYNO.SDS.VideoStation.Util._getCurLibraryId(),title:SYNO.SDS.VideoStation.Util._getCurLibraryTitle()};return a},addVideoHandler:function(){var a=new SYNO.SDS.VideoStation.AddVideoDialog({owner:SYNO.SDS.VideoStation.Window,folder:null,library:this.getLibrary(),mode:"add"});a.open()},delVideoHandler:function(){var h=SYNO.SDS.VideoStation.Util;var g=this._getHistoryInfo();var d=SYNO.SDS.VideoStation.Util._getSelectedVideoType();var a=this._checkIsByfolder();var b=[],c=[],e=[];var f=0;if(g.view===SYNO.SDS.VideoStation.Util._VIEW_DETAIL){b=this.getSelectedDetailDatas();e=b.map(function(i){return i.id})}else{if(g.view===SYNO.SDS.VideoStation.Util._VIEW_COLLECTION){c=SYNO.SDS.VideoStation.Util._getSelectedVideoCollections()}else{if(g.view===SYNO.SDS.VideoStation.Util._VIEW_FILTERING&&a){b=this.getSelectedDatas();e=b.map(function(i){return i.id})}else{b=this.getSelectedDatas();c=b.map(function(j){var i={video_id:j.id,video_type:d};return i})}}}f=c.length>0?c.length:e.length;SYNO.SDS.VideoStation.Window.getMsgBox().confirmDelete(_VST("action","del_video"),String.format(_VST("action","delete_video_confirm"),f),function(i){if(i!=="yes"){return}var j=function(n,m,l,k){if(!n){SYNO.SDS.VideoStation.Window.getMsgBox().alert(_VST("action","delete_video_failed"),SYNO.SDS.VideoStation.Util.getErrinfoString(m,_T("common","commfail")))}else{SYNO.SDS.VideoStation.Util._gotoViewAgain()}};if(g.view===SYNO.SDS.VideoStation.Util._VIEW_DETAIL||a){h.deleteFiles(e,j)}else{h.deleteVideos(c,j)}},this)}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.Main",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.Main",this);var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.listPanel=new SYNO.SDS.VideoStation.MainListPanel({itemId:"mainListPanel",region:"west",width:240});this.mainCardPanel=new SYNO.SDS.VideoStation.MainCardPanel({itemId:"mainCardPanel",region:"center",baseCls:"vs-x-panel"});var b={border:false,layout:"border",cls:"syno-vs-panel",bodyCssClass:"syno-vs-panel-body",width:800,height:500,monitorResize:true,items:[this.listPanel,this.mainCardPanel]};Ext.apply(b,a);return b}});Ext.define("SYNO.SDS.VideoStation.ListDataView",{statics:{ViewWidth:180},extend:"SYNO.ux.FleXcroll.DataView",constructor:function(b){this.desc_key=b.desc_key||"";var a={cls:"syno-vs-dataview-list",itemSelector:"dl.list-template",trackOver:false,overClass:"over",hideHeaders:true,singleSelect:true,tpl:this.getListTpl(b.getItemClass)};this.callParent([Ext.apply(a,b)])},getListTpl:function(c){var b=[];Ext.each(this.cls_key,function(e){b.push("{"+e+"}")});var d=c||Ext.emptyFn;var a=new Ext.XTemplate('<tpl for=".">','<dl class="list-template">','<dt class="{[this.getItemClass(values)]}">','<div class="sds-ellipsis" ext:qtip="{[this.doubleEncode(values.'+this.desc_key+')]}">',"{"+this.desc_key+":htmlEncode}","</div>","</dt>","</dl>","</tpl>",'<div class="x-clear"></div>',{compiled:true,doubleEncode:function(e){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(e))},getItemClass:d.createDelegate(this)});return a}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.LibraryManageStore",{extend:"Ext.data.JsonStore",constructor:function(b){var a=this.fillConfig(b);this.callParent([a])},fillConfig:function(b){var a={autoLoad:false,root:"data.libraries",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"title",type:"string"},{name:"id",type:"int"},{name:"type",type:"string"},{name:"is_public",type:"boolean",defaulValue:true},{name:"field",type:"string",defaultValue:"item"}],proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation.Window._getAbsoluteURL("library_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}})};Ext.apply(a,b);return a}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.LibraryList",{extend:"SYNO.ux.Panel",DefaultLibrary:{title:_VST("library","default"),field:"category",id:0},Movie:{title:_VST("type","movie"),type:"movie",is_public:true,field:"item",id:-1},TVShow:{title:_VST("type","tv_show"),type:"tvshow",is_public:true,field:"item",id:-2},HomeVideo:{title:_VST("type","home_video"),type:"home_video",is_public:true,field:"item",id:-3},CustomLibrary:{title:_VST("library","custom"),field:"category",id:-4},constructor:function(a){this.module=a.module;this.defaultListItems=[new Ext.data.Record(this.DefaultLibrary),new Ext.data.Record(this.Movie),new Ext.data.Record(this.TVShow),new Ext.data.Record(this.HomeVideo),new Ext.data.Record(this.CustomLibrary)];this.callParent([this.fillConfig(a)])},fillConfig:function(b){this.dataview=new SYNO.SDS.VideoStation.ListDataView({desc_key:"title",store:this.getStore(),getItemClass:function(c){return c.field},listeners:{beforeclick:function(d,e,f,c){var g=d.getRecord(f);return("category"===g.get("field"))?false:true},selectionchange:{buffer:100,scope:this,fn:this.onListSelect},dblclick:this.module.openLibraryEditDialog.createDelegate(this.module,["edit"])}});var a={width:SYNO.SDS.VideoStation.ListDataView.ViewWidth,layout:"fit",cls:"syno-vs-library-list",items:this.dataview};return Ext.apply(a,b)},getStore:function(){if(this.store){return this.store}this.store=new SYNO.SDS.VideoStation.LibraryManageStore({listeners:{scope:this,load:this.onLibraryLoad}});return this.store},onListSelect:function(c,a){this.module.onChangeButtonStatus();if(0===a.length){return}var b=this.dataview.getRecord(a[0]);var d={section:b.get("type")};if(b.get("id")>0){d.library_id=b.get("id")}this.module.folderGrid.reload(d)},onLibraryLoad:function(b,a,c){this.module._getOwner().clearStatusBusy();this.getStore().insert(0,this.defaultListItems);var d;if(Ext.isDefined(c.options)&&Ext.isDefined(c.options.title)){b.each(function(e){if("category"!==e.get("field")&&c.options.title===e.get("title")){d=e;return false}})}else{b.each(function(e){if("category"!==e.get("field")){d=e;return false}})}if(Ext.isDefined(d)){this.dataview.select(d)}if(c.options&&true===c.options.openFolderDialog){this.module.openFolderEditDialog("add")}this.getStore().fireEvent("update")},getSelectedLibrary:function(){if(0>=this.dataview.getSelectionCount()){return null}var a=this.dataview.getSelectedRecords()[0];return{title:a.get("title"),type:a.get("type"),id:a.get("id"),is_public:a.get("is_public")}},getLibraryCount:function(){return Ext.max([0,this.getStore().getCount()-2])},getLibraryList:function(){var a=[];this.getStore().each(function(b){if("item"===b.get("field")){var c=Ext.copyTo({},b.data,["id","title","type","is_public"]);a.push(c)}});return a},reload:function(a){this.module._getOwner().setStatusBusy({text:_T("common","loading")});this.store.load({options:a})}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.FolderGrid",{extend:"SYNO.ux.GridPanel",constructor:function(a){this.module=a.module;this.callParent([this.fillConfig(a)])},fillConfig:function(b){var a={stripeRows:true,cls:"syno-vs-folder-grid",itemId:"grid",border:false,store:this.getStore(),columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{selectionchange:{fn:this.module.onChangeButtonStatus,buffer:50,scope:this.module}}}),listeners:{dblclick:this.module.openFolderEditDialog.createDelegate(this.module,["edit"])}};return Ext.apply(a,b)},getColumnModel:function(){if(this.colModel){return this.colModel}this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_T("common","folder"),dataIndex:"path",sortable:true,width:150,align:"left",renderer:function(g,a,d,f,i,h){var e=d.get("exist");var c=Ext.util.Format.htmlEncode(g);var b=e?Ext.util.Format.htmlEncode(c):_T("mediaservice","error_folder_not_exist");a.attr=String.format('ext:qtip="{0}"',b);return e?c:'<font color="red">'+c+"</font>"}},{header:_VST("common","status"),dataIndex:"status",width:50,renderer:function(f,b,a,g,d,c){if(f!=="indexing"){return""}var e=Ext.util.Format.htmlEncode(_VST("reindex","indexing"));b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(e)+'"';return e}}]});return this.colModel},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,idProperty:"path",root:"data.folders",baseParams:{action:"list"},fields:["exist","path","share","subpath","status","preferlang","section"],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL("folder_manage.cgi"),listeners:{scope:this,beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}}),listeners:{scope:this,load:this.onFolderLoad}});return this.store},getSelectedFolder:function(){var a=this.getSelectionModel();if(0>=a.getCount()){return null}var b=a.getSelected();var c={path:b.get("path"),share:b.get("share"),subpath:b.get("subpath"),preferlang:b.get("preferlang"),section:b.get("section")};return c},onFolderLoad:function(d,c,e){var f=this.getEl();var g=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.FolderMgr");var h=false;g.updateLibrary(e.params.section,e.params.library_id,c,e.reloadHomepage);if(d.getCount()===0){var b=f.mask(_VST("videofolder","hint"),"syno-ux-mask-info");var a=b.next().first();a.setStyle("cursor","pointer");a.on("click",function(){this.module.openFolderEditDialog("add")},this)}else{if(d.getAt(0).get("status")==="exporting"){f.mask(_VST("library","metadata_exporting"),"x-mask-loading");this.module.library_exporting=true;this.module.onChangeButtonStatus();h=true}else{if(f.isMasked()){f.unmask()}this.module.library_exporting=false;this.getSelectionModel().selectFirstRow()}}if(h){this.getPollingExportingTask().delay(5000)}else{this.stopPollingExportingTask()}},getPollingExportingTask:function(){if(!Ext.isEmpty(this.pollingExportingTask)){return this.pollingExportingTask}this.pollingExportingTask=new Ext.util.DelayedTask(this.reload,this);return this.pollingExportingTask},stopPollingExportingTask:function(){if(!Ext.isEmpty(this.pollingExportingTask)){this.pollingExportingTask.cancel()}},reload:function(a,b){if(Ext.isObject(a)){this.params=a}this.store.load({params:this.params,reloadHomepage:b===true})}});Ext.define("SYNO.SDS.VideoStation.FolderDialog",{extend:"SYNO.SDS.VideoStation.AddEditDialog",constructor:function(b){this.folder=b.folder;this.library=b.library;var a=Ext.apply({resizable:false,width:500,applyButton:{btnStyle:"blue",text:_T("common","alt_apply"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onRequest}},b);this.callParent([a])},getFormPanel:function(){if(this.formpanel){return this.formpanel}var b={xtype:"syno_fieldset",title:_VST("videofolder","title"),labelWidth:100,items:[{xtype:"syno_compositefield",fieldLabel:_T("common","folder"),defaults:{hideLabel:true},items:[{xtype:"syno_textfield",width:200,name:"path",readOnly:true,allowBlank:false,blankText:_VST("videofolder","specify_path"),validationEvent:"afterrender"},{xtype:"syno_button",text:_VST("common","select"),btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onEditPathBtnHandler}]}]};var d={xtype:"syno_fieldset",title:_VST("library","title"),items:[{disabled:("edit"===this.mode),xtype:"syno_combobox",name:"library_id",fieldLabel:_VST("library","title"),displayField:"title",valueField:"id",tpl:'<tpl for="."><div class="x-combo-list-item">{title:htmlEncode}</div></tpl>',store:this.getLibraryStore(),listeners:{scope:this,select:this.onLibrarySelect}}]};var c={xtype:"syno_fieldset",title:_VST("videofolder","prefer_lang"),items:[{xtype:"syno_combobox",disabled:(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===this.library.type),name:"preferlanguage",fieldLabel:_VST("language","title"),displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation.Util.getLangStore()),tpl:new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" ext:qtip="{display}">',"{display}","</div>","</tpl>")}]};var a={trackResetOnLoad:true,border:false,items:[b,d,c]};return(this.formpanel=new SYNO.ux.FormPanel(a))},getLibraryStore:function(){if(this.libraryStore){return this.libraryStore}var a=this.module.libraryList.getLibraryList();this.libraryStore=new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,root:"data",fields:[{name:"id",type:"int"},{name:"title",type:"string"},{name:"type",type:"string"}],data:{data:a}});return this.libraryStore},onOpen:function(){var b=this.getFormPanel().getForm();var a=("edit"===this.mode)?this.folder.preferlang:"enu";var c=("edit"==this.mode)?this.folder.path:"";b.findField("library_id").setValue(this.library.id);b.findField("preferlanguage").setValue(a);b.findField("path").setValue(c);SYNO.SDS.VideoStation.FolderDialog.superclass.onOpen.call(this)},onRequest:function(){if(!this.getFormPanel().getForm().findField("path").validate()){this.getMsgBox().alert(_VST("videofolder","title"),_VST("videofolder","specify_path"));return}SYNO.SDS.VideoStation.FolderDialog.superclass.onRequest.call(this,"folder_manage.cgi")},onRequestDone:function(a,d,b){this.clearStatusBusy();if(b&&b.success){this.module.folderGrid.reload(null,true);this.close()}else{var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),c)}},getParameter:function(){var b=this.getFormPanel().getForm();var c=b.findField("path").getValue();var a=b.findField("library_id").getValue();var e=SYNO.SDS.VideoStation.Util.getShareData(c);var d={share:e.orishare,subpath:e.subpath,section:this.getLibraryByID(a).type,preferlang:b.findField("preferlanguage").getValue()};if(a>0){d.library_id=a}if("edit"===this.mode){Ext.apply(d,{old_share:this.folder.share,old_subpath:this.folder.subpath})}return d},getLibraryByID:function(b){var a=null;this.libraryStore.each(function(c){if(b===c.get("id")){a=c.json;return false}});return a},onChooserSelect:function(b,c){if(c&&Ext.isString(c.path)){var a=this.getFormPanel().getForm();a.findField("path").setValue(c.path)}b.close()},onEditPathBtnHandler:function(){var a=new SYNO.SDS.VideoStation.FileChooser({owner:this,title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},onLibrarySelect:function(d,a,c){var b=this.getFormPanel().getForm().findField("preferlanguage");b.setDisabled(a.get("type")===SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID)},isDirty:function(){if(!Ext.isDefined(this.folder)||!Ext.isDefined(this.library)){return false}var d=this.getFormPanel().getForm();var e=d.findField("path").getValue();var b=d.findField("library_id").getValue();var a=d.findField("preferlanguage").getValue();var c=(e!==this.folder.path)||(b!==this.library.id)||(a!==this.folder.preferlang);return c}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.MAX_LIBRARY=100;Ext.define("SYNO.SDS.VideoStation.LibrarySettingPanel",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(b){var a={title:_VST("library","title"),border:false,layout:"border",monitorResize:true,tbar:this.createToolbarActions(),items:[this.libraryList=new SYNO.SDS.VideoStation.LibraryList({module:this,region:"west"}),this.folderGrid=new SYNO.SDS.VideoStation.FolderGrid({module:this,region:"center"})],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(a,b);return a},createToolbarActions:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[{xtype:"syno_button",disabled:_S("demo_mode"),text:_T("common","create"),itemId:"create",scope:this,menu:this.createCreateMenu()},{xtype:"syno_button",disabled:true,text:_T("common","alt_edit"),itemId:"edit",scope:this,menu:this.createEditMenu()},{xtype:"syno_button",disabled:true,text:_T("common","delete"),itemId:"delete",scope:this,menu:this.createDeleteMenu()},{xtype:"syno_button",disabled:true,text:_VST("action","reindex"),itemId:"reindex",scope:this,menu:this.createReindexMenu()},{xtype:"syno_button",disabled:true,tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_VST("action","export_metadata"),itemId:"export_metadata",scope:this,handler:this.onClickExportMetadata}]})},createCreateMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"create-library",text:_VST("library","create"),handler:this.openLibraryEditDialog.createDelegate(this,["add"])},{itemId:"create-folder",text:_VST("videofolder","add"),handler:this.openFolderEditDialog.createDelegate(this,["add"])}],listeners:{scope:this,beforeshow:function(d){var b=this.libraryList.getSelectedLibrary();var c=this.libraryList.getLibraryList().length;d.items.get("create-library").setDisabled(SYNO.SDS.VideoStation.MAX_LIBRARY<=c);d.items.get("create-folder").setDisabled(!Ext.isObject(b))}}};return new Ext.menu.Menu(a)},createEditMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"edit-library",text:_VST("library","edit"),handler:this.openLibraryEditDialog.createDelegate(this,["edit"])},{itemId:"edit-folder",text:_VST("videofolder","edit"),handler:this.openFolderEditDialog.createDelegate(this,["edit"])}],listeners:{scope:this,beforeshow:function(d){var b=this.libraryList.getSelectedLibrary();var c=this.folderGrid.getSelectionModel().getCount();d.items.get("edit-library").setDisabled(b.id<=0);d.items.get("edit-folder").setDisabled(c<=0)}}};return new Ext.menu.Menu(a)},createDeleteMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"delete-library",text:_VST("library","delete"),handler:this.onDelete.createDelegate(this,["library"])},{itemId:"delete-folder",text:_VST("videofolder","delete"),handler:this.onDelete.createDelegate(this,["folder"])}],listeners:{scope:this,beforeshow:function(d){var b=this.libraryList.getSelectedLibrary();var c=this.folderGrid.getSelectionModel().getCount();d.items.get("delete-library").setDisabled(b.id<=0);d.items.get("delete-folder").setDisabled(c<=0)}}};return new Ext.menu.Menu(a)},createReindexMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"reindex-noupdate",text:_VST("action","reindex_no_update"),handler:this.onFolderRequest.createDelegate(this,["reindex-noupdate"])},{itemId:"reindex-update",text:_VST("action","reindex_with_update"),handler:this.onFolderRequest.createDelegate(this,["reindex-update"])}],listeners:{scope:this,beforeshow:function(c){var b=this.libraryList.getSelectedLibrary();c.items.get("reindex-update").setDisabled(b.type===SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID)}}};return new Ext.menu.Menu(a)},openLibraryEditDialog:function(d){if(_S("demo_mode")){return}var b={module:this,owner:this._getOwner(),mode:d};if("edit"===d){var a=this.libraryList.getSelectedLibrary();if(!Ext.isDefined(a)||!Ext.isNumber(a.id)||a.id<=0){return}Ext.apply(b,{library:a})}var c=new SYNO.SDS.VideoStation.LibraryDialog(b);c.open()},openFolderEditDialog:function(b){if(_S("demo_mode")){return}var a=new SYNO.SDS.VideoStation.FolderDialog({module:this,owner:this._getOwner(),folder:"edit"===b?this.folderGrid.getSelectedFolder():null,library:this.libraryList.getSelectedLibrary(),mode:b});a.open()},onFolderRequest:function(b){var a=this.folderGrid.getSelectedFolder();var c={action:b,share:a.share,subpath:a.subpath};this._getOwner().setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getAbsoluteURL("folder_manage.cgi"),method:"POST",single:true,autoJsonDecode:true,params:c,scope:this,callback:function(d,g,e){this._getOwner().clearStatusBusy();this.folderGrid.reload(null,g&&b==="delete");if(!e||!e.success){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),f)}}},this).start(true)},initLoadData:Ext.emptyFn,onActivate:function(){this.libraryList.reload({title:this.defaultLibraryTitle,openFolderDialog:this.openFolderDialog})},onDeactivate:function(){this.folderGrid.stopPollingExportingTask()},save:Ext.emptyFn,isDirty:function(){return false},getAction:function(a){return this.getTopToolbar().getComponent(a)},onChangeButtonStatus:function(){if(_S("demo_mode")){return}var c=this.folderGrid.getSelectionModel().getCount();var d=this.folderGrid.store.getCount();var a=this.libraryList.getSelectedLibrary();var b=this.libraryList.getLibraryCount();this.getAction("create").setDisabled(SYNO.SDS.VideoStation.MAX_LIBRARY<=b);this.getAction("edit").setDisabled(0===c&&a.id<=0);this.getAction("delete").setDisabled(0===c&&a.id<=0);this.getAction("reindex").setDisabled(0===c);this.getAction("export_metadata").setDisabled(_S("demo_mode")||!Ext.isObject(a)||0===d||true===this.library_exporting)},onDelete:function(c){var d=c==="library"?_VST("library","delete_confirm"):_VST("videofolder","delete_confirm");var b=c==="library"?this.deleteLibrary.createDelegate(this):this.onFolderRequest.createDelegate(this,["delete"]);var a=function(e){if("yes"===e){b()}};this._getOwner().getMsgBox().confirm(_VST("action","settings"),d,a)},deleteLibrary:function(){var a=this.libraryList.getSelectedLibrary();this._getOwner().setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getOwner()._getAbsoluteURL("library_manage.cgi"),method:"POST",single:true,autoJsonDecode:true,params:{action:"delete",id:a.id,type:a.type},scope:this,callback:function(c,e,b){this._getOwner().clearStatusBusy();if(b&&b.success){this.libraryList.reload();SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.LibraryListPanel").loadLibrary()}else{var d=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),d)}}},this).start(true)},onClickExportMetadata:function(){var a=function(b){if("yes"===b){this._getOwner().requestExportMetadata(this.libraryList.getSelectedLibrary(),this.folderGrid.reload.createDelegate(this.folderGrid))}};this._getOwner().getMsgBox().confirm(_VST("action","settings"),_VST("library","export_metadata_desc"),a,this)}});Ext.define("SYNO.SDS.VideoStation.DTVSettingPanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var c={xtype:"syno_fieldset",collapsible:true,title:_VST("programguide","broadcast_streaming"),labelWidth:250,items:[{xtype:"syno_checkbox",boxLabel:_VST("streaming","enable_streaming_auth"),name:"enableauth"},{xtype:"syno_compositefield",itemId:"username_item",indent:1,hideLabel:false,fieldLabel:_VST("streaming","stream_auth_user"),width:300,items:[{xtype:"syno_textfield",name:"account",width:157}]},{xtype:"syno_compositefield",itemId:"passwd_item",indent:1,hideLabel:false,fieldLabel:_T("common","password"),width:300,items:[{xtype:"syno_textfield",textType:"password",name:"passwd",width:157}]},{xtype:"syno_compositefield",indent:1,hideLabel:false,fieldLabel:_VST("streaming","pass_confirm"),width:300,items:[{xtype:"syno_textfield",textType:"password_confirm",name:"password_confirm",width:157}]},{xtype:"syno_checkbox",boxLabel:_VST("streaming","enable_stream_limit"),name:"enable_viewer_limit"},{xtype:"syno_compositefield",hideLabel:false,fieldLabel:_VST("streaming","streaming_limit_viewer"),width:300,indent:1,items:[{xtype:"syno_numberfield",name:"streaming_limit",width:157,decimalPrecision:0,minValue:1,maxlength:6}]}]};var b={itemId:"dtv_settings",labelWidth:200,trackResetOnLoad:true,hideMode:"offsets",items:[{xtype:"syno_fieldset",collapsible:true,title:_VST("dtvfolder","title"),labelWidth:250,items:[{xtype:"hidden",name:"share"},{xtype:"hidden",name:"subpath"},{xtype:"syno_compositefield",itemId:"destselectfield",fieldLabel:_VST("dtvfolder","dtv_destination"),defaults:{hideLabel:true},items:[{xtype:"syno_textfield",name:"dtv_destination",postBlur:this.checkDestValid.createDelegate(this),readOnly:true,width:157,listeners:{scope:this,enable:this.updateFolderButtonStatus,disable:this.updateFolderButtonStatus}},this.btnDTVFolder=new SYNO.ux.Button({btnStyle:"blue",text:_VST("common","select"),scope:this,disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",handler:this.onDTVFolderChoose})]},{xtype:"syno_compositefield",items:[this.btnExportMetadata=new SYNO.ux.Button({text:_VST("action","export_metadata"),disabled:true,tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onClickExportMetadata})]}]},c,{xtype:"syno_fieldset",collapsible:true,title:_VST("record","record_setting"),labelWidth:250,items:[{xtype:"syno_checkbox",boxLabel:_VST("record","record_first_stream"),name:"closestreaming"},{xtype:"syno_compositefield",itemId:"pre_recording_item",hideLabel:false,fieldLabel:_VST("record","pre_recording_interval"),indent:1,width:300,items:[{xtype:"syno_numberfield",name:"pre_recording",minValue:0,maxValue:3600,maxlength:4,width:157},{xtype:"syno_displayfield",value:_T("common","time_seconds")}]},{xtype:"syno_compositefield",itemId:"post_recording_item",hideLabel:false,fieldLabel:_VST("record","post_recording_interval"),indent:1,width:300,items:[{xtype:"syno_numberfield",name:"post_recording",minValue:0,maxValue:3600,maxlength:4,width:157},{xtype:"syno_displayfield",value:_T("common","time_seconds")}]}]},{xtype:"syno_fieldset",collapsible:true,title:_VST("programguide","setting"),labelWidth:250,items:[{xtype:"syno_combobox",fieldLabel:_VST("programguide","update_frequency"),name:"epg_update_frequency",displayField:"display",valueField:"value",value:"daily",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:[["twiceaday",_VST("programguide","frequency_twice_a_day")],["daily",_VST("programguide","frequency_daily")],["3days",_VST("programguide","frequency_3_day")],["weekly",_VST("programguide","frequency_weekly")],["never",_VST("programguide","frequency_never")]]})}]},{xtype:"syno_fieldset",collapsible:true,title:_T("common","advanced"),items:[new SYNO.SDS.VideoStation.DTVDisableCheckbox({owner:this})]}],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};SYNO.LayoutConfig.fill(b);Ext.apply(b,a);return b},checkDestValid:function(){if(true===this.destInvalid){this.getForm().findField("dtv_destination").markInvalid(_VST("error","record_dest_not_exist"))}},onDTVFolderChoose:function(){var a=new SYNO.SDS.VideoStation.FileChooser({owner:this._getOwner(),title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},save:function(k){var a=this.getForm();var f=a.findField("enableauth").getValue();var i=a.findField("account").getValue();var b=a.findField("passwd").getValue();var h=a.findField("password_confirm").getValue();if(f&&this.invalidCheck(i,b,h)){this._getOwner().tabPanel.setActiveTab(1);return false}var d=a.findField("dtv_destination").getValue();var g=SYNO.SDS.VideoStation.Util.getShareData(d);var j=Ext.apply(a.getValues(),{share:g.orishare,subpath:g.subpath});var c=a.findField("disable_dtv").getValue();SYNO.SDS.VideoStation.gData.disable_dtv=(c.toString()==="true");var e=Ext.apply({action:"save"},j);e.disable_dtv=c?"yes":"no";this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("dtv_manage.cgi"),params:e,method:"POST",scope:this,callback:function(l,o,m){this._getOwner().clearStatusBusy();if(m&&m.success){this.getForm().setValues(j);k.fn.call(k.scope)}else{var n=SYNO.SDS.VideoStation.Util.getErrinfoString(m,_T("common","commfail"));this._getOwner().getMsgBox().alert(_VST("action","settings"),n)}}},this).start(true)},invalidCheck:function(e,c,a){var b=false,d;if(this.isEmptyUserPwd(e,c)){d=_VST("error","invalid_userpwd");b=true}else{if(this.isInvalidUser(e,c)){d=_VST("streaming","msg_invalid_user");b=true}else{if(this.isInvalidPassword(e,c)){d=_VST("streaming","error_empty_password");b=true}else{if(this.isConfirmPassword(c,a)){d=_VST("streaming","nzb_confirmpass");b=true}}}}if(b){this._getOwner().getMsgBox().alert(_VST("action","settings"),d)}return b},isEmptyUserPwd:function(b,a){if(!b&&!a){return true}},isInvalidUser:function(b,a){if(!b&&a){return true}return false},isInvalidPassword:function(b,a){if(b&&!a){return true}return false},isConfirmPassword:function(b,a){if(b&&(b!=a)&&(b!="12345678"||a!="87654321")){return true}return false},isDirty:function(){return this.getForm().isDirty()},onChooserSelect:function(a,b){if(b&&Ext.isString(b.path)){this.destInvalid=false;this.getForm().findField("dtv_destination").setValue(b.path);this.updateFolderButtonStatus()}a.close()},check_group_init_done:false,initEnableCheckGroup:function(){if(this.check_group_init_done){return}var c,b,a;c=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enableauth",["account","passwd","password_confirm"]);b=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_viewer_limit",["streaming_limit"]);a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"disable_dtv",[],["dtv_destination","enableauth","enable_viewer_limit","closestreaming","pre_recording","post_recording","epg_update_frequency"]);this.check_group_init_done=true},initLoadData:Ext.emptyFn,onActivate:function(){this.initEnableCheckGroup();this.reload()},onDeactivate:function(){this.stopPollingExportingTask()},reload:function(){this._getOwner().setStatusBusy({text:_T("common","loading")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("dtv_manage.cgi"),params:{action:"load"},method:"POST",scope:this,callback:this.onLoadDTVSettingDone},this).start(true)},onLoadDTVSettingDone:function(b,d,a){this._getOwner().clearStatusBusy();if(!a||!a.success){var c=SYNO.SDS.VideoStation.Util.getErrinfoString(a,_T("common","commfail"));this._getOwner().getMsgBox().alert(this.title,c);return}if(!a.data.dtv_destination_exists&&""!==a.data.dtv_destination){this.destInvalid=true}this.OrigDisableDTV=a.data.disable_dtv;this.getForm().setValues(a.data);this.destinationExporting=a.data.dtv_destination_exporting;this.checkDestValid();this.updateFolderButtonStatus();if(this.destinationExporting){this.getPollingExportingTask().delay(5000)}else{this.stopPollingExportingTask()}},updateFolderButtonStatus:function(){var a=this.getForm().findField("dtv_destination");if(_S("demo_mode")||a.disabled===true){this.btnDTVFolder.disable();this.btnExportMetadata.disable();return}this.btnExportMetadata.setDisabled(this.destinationExporting||a.isDirty()||this.destInvalid||Ext.isEmpty(a.getValue()));this.btnDTVFolder.setDisabled(this.destinationExporting);if(this.destinationExporting){var b=Ext.util.Format.htmlEncode(_VST("library","metadata_exporting"));this.btnExportMetadata.setTooltip(b);this.btnDTVFolder.setTooltip(b)}else{this.btnExportMetadata.setTooltip("");this.btnDTVFolder.setTooltip("")}},getPollingExportingTask:function(){if(!Ext.isEmpty(this.pollingExportingTask)){return this.pollingExportingTask}this.pollingExportingTask=new Ext.util.DelayedTask(this.reload,this);return this.pollingExportingTask},stopPollingExportingTask:function(){if(!Ext.isEmpty(this.pollingExportingTask)){this.pollingExportingTask.cancel()}},onClickExportMetadata:function(){var a={type:"tv_record",id:0};var b=function(){this.destinationExporting=true;this.updateFolderButtonStatus();this.getPollingExportingTask().delay(5000)};var c=function(d){if("yes"===d){this._getOwner().requestExportMetadata(a,b.createDelegate(this))}};this._getOwner().getMsgBox().confirm(_VST("action","settings"),_VST("library","export_metadata_desc"),c,this)}});Ext.define("SYNO.SDS.VideoStation.DTVDisableCheckbox",{extend:"SYNO.ux.Checkbox",constructor:function(b){var a={boxLabel:_VST("dtv","disable_dtv"),name:"disable_dtv"};this.callParent([Ext.apply(a,b)])},onClick:function(){if(true===this.getValue()&&true===this.owner.DVB_conflict){this.owner.owner.getMsgBox().alert(this.owner.title,_VST("dtv","enable_conflict"))}else{this.callParent(arguments)}}});Ext.define("SYNO.SDS.VideoStation.AdvancedSettingPanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.default_cmzvideo_cover_rule="cover.jpg;Cover.jpg;COVER.jpg;folder.jpg;Folder.jpg;FOLDER.jpg";SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={itemId:"advanced_settings",labelWidth:200,trackResetOnLoad:true,hideMode:"offsets",items:[this.getTranscodingConfig(a),this.getCustomVideoCoverConfig(a),this.getSubtitleConfig(a)]};SYNO.LayoutConfig.fill(b);Ext.apply(b,a);return b},getTranscodingConfig:function(a){var d={xtype:"syno_fieldset",collapsible:true,title:_VST("advanced","transcoding_settings"),items:[new SYNO.ux.Checkbox({boxLabel:_VST("advanced","pass_through_ac3"),name:"not_trans_audio_ac3_to_mp3"})]};if(SYNO.SDS.VideoStation.Util.support_hardware_transcode){var f=new SYNO.ux.Checkbox({boxLabel:_VST("advanced","enable_hardware_accelerate"),name:"hardware_transcode"});d.items.push(f)}if(SYNO.SDS.VideoStation.Util.support_remux){var c=[["disable",_VST("advanced","disallow_transcode")],["remux",_VST("advanced","allow_remux")]];if(SYNO.SDS.VideoStation.Util.support_transcode){c.push(["transcode",_VST("advanced","allow_transcode")])}var b=new Ext.data.ArrayStore({fields:["value","display"],data:c});var e=new SYNO.ux.ComboBox({fieldLabel:_VST("advanced","public_sharing"),displayField:"display",valueField:"value",name:"public_sharing_transcode_option",store:b});d.items.push(e)}return d},getCustomVideoCoverConfig:function(a){var b=String.format(_VST("advanced","cover_format_error"),this.default_cmzvideo_cover_rule);var c={xtype:"syno_fieldset",collapsible:true,title:_VST("advanced","video_cover_settings"),items:[new SYNO.ux.Checkbox({name:"cmzvideo_cover",boxLabel:_VST("advanced","customized_video_cover")}),{xtype:"syno_displayfield",indent:1,name:"video_cover_note",value:String.format('<span class="syno-ux-note">{0}: </span>{1} {2}',_T("common","note"),_VST("advanced","only_apply_to"),_VST("advanced","same_filename_high_priority"))},{xtype:"syno_textfield",indent:1,width:300,name:"cmzvideo_cover_rule",fieldLabel:_VST("advanced","filename"),validator:function(e){if(Ext.isEmpty(e.trim())){return true}var f=e.split(";");for(var d=0;d<f.size();d++){if(-1==f[d].search(/.+\.([jJ][pP][gG]|[jJ][pP][eE][gG])$/)){return b}}return true}}]};return c},getSubtitleConfig:function(a){var b={xtype:"syno_fieldset",collapsible:true,title:_VST("advanced","subtitle_settings"),items:[{xtype:"syno_checkbox",name:"opensubtitles_enable",boxLabel:_VST("advanced","opensubtitles_enable")},{xtype:"syno_textfield",name:"opensubtitles_username",emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_username"),indent:1},{xtype:"syno_textfield",textType:"password",maxLength:"32",name:"opensubtitles_password",emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_password"),indent:1},{xtype:"syno_superboxselect",name:"opensubtitles_language",fieldLabel:_VST("advanced","opensubtitles_language"),store:this.getOpenSubtitlesLanguageStore(),allowBlank:false,allowAddNewData:false,editable:false,mode:"local",indent:1,listeners:{scope:this,additem:this.updateScroller,removeitem:this.updateScroller}},{xtype:"syno_checkbox",name:"shooter_enable",boxLabel:_VST("advanced","shooter_enable")}]};return b},save:function(e){var b=this.getForm(),a,c=b.findField("cmzvideo_cover_rule");if(!c.isValid()){return}if(Ext.isEmpty(c.getValue().trim())){c.setValue(this.default_cmzvideo_cover_rule)}a=b.getValues();if(a.opensubtitles_password&&a.opensubtitles_password.indexOf("\t")!==-1){a.opensubtitles_password="\t\t\t\t\t\t\t\t"}if(Ext.isArray(a.opensubtitles_language)){a.opensubtitles_language=a.opensubtitles_language.join(",")}var d=Ext.apply({action:"save"},a);this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("advanced_manage.cgi"),params:d,method:"POST",scope:this,callback:function(f,i,g){this._getOwner().clearStatusBusy();if(g&&g.success){b.setValues(a);e.fn.call(e.scope)}else{var h=SYNO.SDS.VideoStation.Util.getErrinfoString(g,_T("common","commfail"));this._getOwner().getMsgBox().alert(_VST("action","settings"),h)}}},this).start(true)},isDirty:function(){return this.getForm().isDirty()},initEnableCheckGroup:function(){var a;a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"cmzvideo_cover",["cmzvideo_cover_rule"]);a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"opensubtitles_enable",["opensubtitles_username","opensubtitles_password","opensubtitles_language"])},initLoadData:function(){this.initEnableCheckGroup();this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("advanced_manage.cgi"),params:{action:"load"},method:"POST",scope:this,callback:function(a,d,b){this._getOwner().clearStatusBusy();if(!b||!b.success){var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this._getOwner().getMsgBox().alert(this.title,c);return}this.getForm().setValues(b.data)}},this).start(true)},getOpenSubtitlesLanguageStore:function(){var c,a,b;c=SYNO.SDS.Utils.getSupportedLanguage();a=this.getLanguageIdMapping();b=[];Ext.each(c,function(d){if(a[d[0]]){b.push([a[d[0]],d[1]])}});b=b.concat(this.getExtraLanguageList());return b},getExtraLanguageList:function(){var a=[["chi",_VST("language","chinese")],["fin",_VST("language","finnish")],["ara",_VST("language","arabic")]];return a},getLanguageIdMapping:function(){var a={csy:"cze",dan:"dan",enu:"eng",fre:"fre",ger:"ger",hun:"hun",ita:"ita",jpn:"jpn",krn:"kor",nld:"dut",nor:"nor",plk:"pol",ptb:"pob",ptg:"por",rus:"rus",spn:"spa",sve:"swe",trk:"tur"};return a}});Ext.define("SYNO.SDS.VideoStation.CheckBoxGrid",{extend:"SYNO.ux.GridPanel",pageSize:50,constructor:function(a){this.callParent([this.fillConfig(a)]);this.getStore().on("beforeload",this.onBeforeLoad,this)},fillConfig:function(b){var c=new SYNO.ux.PagingToolbar({pageSize:b.pageSize||this.pageSize,store:this.getStore(),displayInfo:true});var a={itemId:"grid",store:this.getStore(),border:false,flex:1,viewConfig:{scrollDelay:false,borderHeight:0,cacheSize:50,forceFit:false},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},stripeRows:true,enableColLock:false,enableColumnMove:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),bbar:c,columns:this.getColumns()};return Ext.apply(a,b)},getStore:Ext.emptyFn,getColumns:Ext.emptyFn,isDirty:function(){return 0<this.getStore().getModifiedRecords().length},getSaveParams:Ext.emptyFn,saveChanges:function(a,c){var b=this.module;b._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:b._getAbsoluteURL(this.cgiURL),method:"POST",params:this.getSaveParams(),scope:this,callback:function(e,g,d){b._getOwner().clearStatusBusy();if(d&&d.success){this.getStore().commitChanges();if(!Ext.isDefined(c)){this.getStore().load(a)}else{c.fn.call(c.scope)}}else{var f=SYNO.SDS.VideoStation.Util.getErrinfoString(d,_T("common","commfail"));b._getOwner().getMsgBox().alert(_VST("action","settings"),f)}}},this).start(true)},onBeforeLoad:function(a,b){if(!this.isDirty()){return true}var c=function(d){if("yes"===d){this.saveChanges(b)}else{a.rejectChanges();a.load(b)}};this.module._getOwner().getMsgBox().confirm(this.module.title,_T("share","share_save_chg_before_reload"),c,this);return false}});Ext.define("SYNO.SDS.VideoStation.EnableColumn",{extend:"SYNO.ux.EnableColumn",constructor:function(a){this.callParent([a])},isIgnore:function(b,a){if(Ext.isEmpty(this.ignoreKey)){return false}return(true===a.get(this.ignoreKey))},renderer:function(g,e,a,f,c,b){var d=this.scope;if(Ext.isString(d.ignoreKey)&&a.data[d.ignoreKey]===true){return SYNO.SDS.VideoStation.EnableColumn.superclass.renderer.call(this,"gray",e,a,f,c,b)}else{return SYNO.SDS.VideoStation.EnableColumn.superclass.renderer.apply(this,arguments)}}});Ext.namespace("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.PrivilegeGrid=Ext.extend(SYNO.SDS.VideoStation.CheckBoxGrid,{cgiURL:"privilege_manage.cgi",constructor:function(b){this.module=b.module;var a=Ext.apply({cls:"privilege-grid",autoExpandColumn:"name",plugins:[this.getDTVColumn(),this.getRendererColumn(),this.getSharingColumn()]},b);if(SYNO.SDS.VideoStation.Util.hideDTVUI()){a.plugins.splice(0,1)}SYNO.SDS.VideoStation.PrivilegeGrid.superclass.constructor.call(this,a);this.getStore().on("load",this.onUserLoad,this)},getStore:function(){if(this.store){return this.store}var a=new Ext.data.JsonStore({autoLoad:false,root:"data.users",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"dtv",type:"boolean",defaulValue:false},{name:"renderer",type:"boolean",defaulValue:false},{name:"sharing",type:"boolean",defaulValue:false}],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL("privilege_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}})});return(this.store=a)},getColumns:function(){if(this.colModel){return this.colModel}var a={defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getDTVColumn(),this.getRendererColumn(),this.getSharingColumn()]};if(SYNO.SDS.VideoStation.Util.hideDTVUI()){a.columns.splice(1,1)}return(this.colModel=new Ext.grid.ColumnModel(a))},getDTVColumn:function(){if(this.dtvColumn){return this.dtvColumn}return(this.dtvColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("privilege","dtv_control"),dataIndex:"dtv",id:"dtv",width:150,ignoreKey:"is_admin"}))},getRendererColumn:function(){if(this.rendererColumn){return this.rendererColumn}return(this.rendererColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("privilege","renderer_control"),dataIndex:"renderer",id:"renderer",width:200,ignoreKey:"is_admin"}))},getSharingColumn:function(){if(this.sharingColumn){return this.sharingColumn}return(this.sharingColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("privilege","public_sharing"),dataIndex:"sharing",id:"sharing",width:150,ignoreKey:"is_admin"}))},getChanges:function(){if(!this.isDirty()){return}var a=this.getStore().getModifiedRecords();var b={};Ext.each(a,function(c){var d=c.get("uid");if(!Ext.isDefined(b[d])){b[d]={}}b[d]["dtv"]=c.get("dtv");b[d]["renderer"]=c.get("renderer");b[d]["sharing"]=c.get("sharing")});return b},getSaveParams:function(){return{action:"save",privilege:Ext.util.JSON.encode(this.getChanges())}},save:function(a){this.saveChanges(null,a)},initLoadData:function(){this.getStore().load({start:0,limit:50})},onUserLoad:function(b,a,c){var d=this.getEl();if(!d){this.on("afterrender",this.onUserLoad,this,{single:true,delay:1000});return}if(this.getStore().getCount()===0){d.mask(_VST("privilege","no_user_hint"),"syno-ux-mask-info")}else{if(d.isMasked()){d.unmask()}}}});Ext.define("SYNO.SDS.VideoStation.OptionsSettingPanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={itemId:"options_settings",labelWidth:200,trackResetOnLoad:true,hideMode:"offsets",hasChanged:false,items:[new SYNO.ux.Checkbox({name:"hide_cover_title",boxLabel:_VST("options","hide_title_on_poster")})]};SYNO.LayoutConfig.fill(b);Ext.apply(b,a);return b},save:function(c){this._getOwner().setStatusBusy({text:_T("common","saving")});var b=this.getForm();var a=b.findField("hide_cover_title").checked;this.hasChanged=true;SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","blHideTitleOnPoster",a);b.setValues([{id:"hide_cover_title",value:a}]);this._getOwner().clearStatusBusy();c.fn.call(c.scope)},isDirty:function(){return this.getForm().isDirty()},initLoadData:function(){var a=Ext.isDefined(SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","blHideTitleOnPoster"))?SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","blHideTitleOnPoster"):false;this.getForm().setValues([{id:"hide_cover_title",value:a}])}});Ext.define("SYNO.SDS.VideoStation.SettingDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:this._getOwner(),width:690,height:580,minWidth:400,minHeight:280,title:_VST("action","settings"),layout:"fit",items:[this.getTabPanel(a||{})],buttons:[{btnStyle:"blue",disabled:_S("demo_mode"),text:_T("common","ok"),scope:this,handler:this.onApply},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],listeners:{scope:this,beforeshow:{fn:this.onBeforeShow,scope:this,single:true},close:{fn:this.onClose,scope:this}}};Ext.apply(b,a);return b},open:function(a){if(this.tabPanel&&a){this.tabPanel.setActiveTab(a)}SYNO.SDS.VideoStation.SettingDialog.superclass.open.apply(this,arguments)},onBeforeShow:function(){this.getTabPanel().loadAllForm();var a=SYNO.SDS.Desktop?SYNO.SDS.Desktop.getEl().getHeight():Ext.lib.Dom.getViewHeight();if(a<this.getHeight()){this.setSize(this.getWidth(),a)}},onClose:function(){if(this.getOptionsSettingPanel().hasChanged){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").fireEvent("afterOptionsSettingChange")}},getTabPanel:function(a){if(!this.tabPanel){var b;if(_S("is_admin")){b=[this.getLibrarySettingPanel(a),this.getDTVSettingPanel(),this.getPrivilegeGrid(),this.getOptionsSettingPanel(),this.getAdvancedSettingPanel()];if(SYNO.SDS.VideoStation.Util.hideDTVUI()){b.splice(1,1)}}else{b=[this.getOptionsSettingPanel()]}var c={owner:this,items:b};this.tabPanel=new SYNO.SDS.VideoStation.SettingTabPanel(c)}return this.tabPanel},getDTVSettingPanel:function(){if(this.dtvSettingPanel){return this.dtvSettingPanel}return(this.dtvSettingPanel=new SYNO.SDS.VideoStation.DTVSettingPanel({title:_VST("dtv","title"),owner:this}))},getLibrarySettingPanel:function(a){if(this.librarySettingPanel){return this.librarySettingPanel}return(this.librarySettingPanel=new SYNO.SDS.VideoStation.LibrarySettingPanel({title:_VST("library","title"),owner:this,defaultLibraryTitle:a.defaultLibraryTitle,openFolderDialog:a.openFolderDialog}))},getPrivilegeGrid:function(){if(this.privilegeGrid){return this.privilegeGrid}return(this.privilegeGrid=new SYNO.SDS.VideoStation.PrivilegeGrid({title:_VST("privilege","title"),module:this,owner:this}))},getOptionsSettingPanel:function(){if(this.optionsSettingPanel){return this.optionsSettingPanel}return(this.optionsSettingPanel=new SYNO.SDS.VideoStation.OptionsSettingPanel({title:_VST("options","title"),owner:this}))},getAdvancedSettingPanel:function(){if(this.advancedSettingPanel){return this.advancedSettingPanel}return(this.advancedSettingPanel=new SYNO.SDS.VideoStation.AdvancedSettingPanel({title:_VST("advanced","panel_title"),owner:this}))},onCancel:function(){if((_S("is_admin")&&(this.dtvSettingPanel.isDirty()||this.privilegeGrid.isDirty()||this.advancedSettingPanel.isDirty()))||this.optionsSettingPanel.isDirty()){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(a){if(a==="yes"){this.close()}},this)}else{this.close()}},checkFormPanelValid:function(a){if(!a.rendered){return true}return a.getForm().isValid()},onApply:function(){var d=this.privilegeGrid;var e=this.dtvSettingPanel;var c=this.advancedSettingPanel;var b=this.optionsSettingPanel;if((_S("is_admin")&&(!this.checkFormPanelValid(e)||!this.checkFormPanelValid(c)))||!this.checkFormPanelValid(b)){return false}if((_S("is_admin")&&(!e.isDirty()&&!d.isDirty()&&(!Ext.isDefined(c)||!c.isDirty())))&&!b.isDirty()){this.close();return false}if(_S("is_admin")){var a=("true"===e.getForm().findField("disable_dtv").getValue())?true:false;if(true===a&&a!==e.OrigDisableDTV){this.getMsgBox().confirm(_VST("action","settings"),_VST("dtv","disable_dtv_desc"),function(f){if("yes"===f){this.tabPanel.doApplyAll()}},this);return false}}this.tabPanel.doApplyAll()},requestExportMetadata:function(a,c){if(!Ext.isObject(a)||!Ext.isString(a.type)||!Ext.isNumber(a.id)){return}var b={action:"export_metadata",id:a.id>0?a.id:0,type:a.type};this.setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getAbsoluteURL("library_manage.cgi"),method:"POST",single:true,autoJsonDecode:true,params:b,scope:this,callback:function(d,g,e){this.clearStatusBusy();if(!e||!e.success){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),f)}else{if(Ext.isFunction(c)){c()}}}},this).start(true)}});Ext.define("SYNO.SDS.VideoStation.SettingTabPanel",{extend:"SYNO.ux.TabPanel",constructor:function(b){var a={activeTab:0};this.callParent([Ext.apply(a,b)])},loadAllForm:function(){this.items.each(function(a){a.initLoadData()})},doApplyAll:function(){var a=false;var b={fn:this.doApplyAll,scope:this};this.items.each(function(c){if(c.isDirty()){c.save(b);a=true;return false}});if(!a){this.owner.close()}}});Ext.define("SYNO.SDS.VideoStation.SearchDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",displayNum:500,constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)]);this.createPollingTask()},fillConfig:function(a){var b={cls:"syno-vs-search-dialog",width:800,height:400,minWidth:200,minHeight:200,title:_VST("action","search_correct"),layout:"border",border:false,items:[this.createTBar(),this.fillGridConfig()],buttons:[this.btnApply=new SYNO.ux.Button({btnStyle:"blue",disabled:true,text:_T("common","commit"),scope:this,handler:this.onApply}),{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onSearch},{key:27,scope:this,handler:this.close}],listeners:{scope:this,beforeshow:{fn:this.onBeforeShow,scope:this,single:true}}};Ext.apply(b,a);return b},onApply:function(){var a=this.getSearchPanel().getSelectionModel().getSelected();if(this.getCurType()!==SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID){if(a){this.owner.onSetRecords(a,this.preferlang.getValue());this.close()}}else{this.setStatusBusy();SYNO.API.currentManager.requestAPI("SYNO.VideoStation.PluginSearch","query",1,{id:this.searchId,type:this.getCurType(),data:Ext.encode(a.data)},function(c,g,f){var b;if(this.isDestroyed){return}this.clearStatusBusy();if(c){try{b=this.reader.readRecords({data:g});if(!Ext.isEmpty(a=b.records[0])){this.owner.onSetRecords(a);this.close();return}}catch(d){SYNO.Debug("Fail to read data",d,g)}}var h=SYNO.SDS.VideoStation.Util.getWebAPIErr(c,g,f);this.getMsgBox().alert(_VST("app","displayname"),h,function(){},this)},this)}},onClose:function(){this.onStop();SYNO.SDS.VideoStation.SearchDialog.superclass.onClose.apply(this,arguments)},onMask:function(b,a){this.getSearchPanel().getGridEl().mask(b,a||"syno-ux-mask-info")},onUnMask:function(){this.getSearchPanel().getGridEl().unmask()},onIsMask:function(){return this.getSearchPanel().getGridEl().isMasked()},onBeforeShow:function(){this.onMask(_VST("search","desc"))},createTBar:function(){var a=this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID;var b=[this.searchfield=new SYNO.ux.TextFilter({itemId:"search_field",emptyText:_VST("search","keyword"),flex:2}),{xtype:"syno_displayfield",margins:"0px 3px 0 3px",value:_VST("language","title")+": "},{xtype:"container",cls:"syno-search-preferlang-container",items:[this.preferlang=new SYNO.ux.ComboBox({itemId:"preferlanguage",displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation.Util.getLangStore()),mode:"local",triggerAction:"all",resizable:false,editable:false,value:SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","search_lang")||"enu",listeners:{scope:this,change:function(e,d,c){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","search_lang",d)}}})]},{xtype:"syno_displayfield",margins:"0px 3px 0px 3px",value:_VST("season","season_title")+": ",hidden:!a},this.season=new SYNO.ux.NumberField({itemId:"season",name:"season",xtype:"numberfield",allowNegative:false,allowDecimals:false,allowBlank:true,style:"position: absolute",hidden:!a,flex:1}),{xtype:"syno_displayfield",margins:"0px 3px 0px 3px",value:_VST("episode","episode_title")+": ",hidden:!a},this.episode=new SYNO.ux.NumberField({itemId:"episode",name:"episode",allowNegative:false,allowDecimals:false,allowBlank:true,style:"position: absolute",hidden:!a,flex:1}),{xtyp:"tbspacer",border:false,width:6},this.btnSearch=new SYNO.ux.Button({text:_VST("search","title"),tooltip:_VST("search","title"),itemId:"search",disabled:_S("demo_mode"),scope:this,handler:this.onSearch})];return{region:"north",height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-window-tbar",items:[{flex:1,height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-toolbar x-toolbar-cell",style:"border-top:0 none;",items:b}]}},createPollingTask:function(){var a=this.addTask({interval:800,scope:this,run:function(){if(this.isDestroyed){a.stop();return}if(this.getSearchPanel().getSelectionModel().getSelected()){this.btnApply.enable()}else{this.btnApply.disable()}}}).start()},onSearch:function(){var c=this.searchfield.getValue();var a=this.preferlang.getValue();c=c.trim();if(Ext.isEmpty(c)){this.getMsgBox().alert(_VST("app","displayname"),_VST("search","desc"));return}if(this.searchId){this.onStop()}this.onMask(_VST("search","searching"),"x-mask-loading");this.btnSearch.disable();var b={title:c,type:this.getCurType(),preferlanguage:a,offset:0};if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID){this.onRemoveAll();if(!Ext.isEmpty(this.season.getValue())){Ext.apply(b,{season:this.season.getValue()})}if(!Ext.isEmpty(this.episode.getValue())){Ext.apply(b,{episode:this.episode.getValue()})}}SYNO.API.currentManager.requestAPI("SYNO.VideoStation.PluginSearch","start",1,b,function(d,g,f){if(this.isDestroyed){return}if(d&&g&&g.id){this.searchId=g.id;if(this.isDestroyed){this.onStop();return}this.onList()}else{var e=SYNO.SDS.VideoStation.Util.getErrinfoString(d,_T("common","commfail"));this.getMsgBox().alert(_VST("app","displayname"),e);this.onUnMask();this.btnSearch.enable()}},this)},onStop:function(){if(Ext.isEmpty(this.searchId)){return}if(!this.isDestroyed){this.onUnMask();this.onHideLoading()}SYNO.API.currentManager.requestAPI("SYNO.VideoStation.PluginSearch","stop",1,{id:this.searchId});if(this.updateTask){this.updateTask.remove();this.updateTask=null}},onList:function(a){this.btnSearch.enable();this.onShowLoading();if(!this.updateTask||this.updateTask.removed){this.updateTask=this.addAjaxTask({id:"updateTask",interval:1500,url:this._getWebAPIURL("pluginsearch.cgi"),params:this.getUpdateRecordParams(),method:"POST",autoJsonDecode:true,callback:this.onStoreUpdated,scope:this});var b=this.getTaskRunner();this.mon(b,"beforestart",this.onBeforeStartUpdateRecords,this)}this.updateTask.start(a||false)},getUpdateRecordParams:function(){var a=this.getStore().getSortState();var b={api:"SYNO.VideoStation.PluginSearch",method:"list",version:1,id:this.searchId,offset:this.paging.cursor,limit:this.paging.pageSize,sort_by:a.field,sort_direction:a.direction};return b},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{api:"SYNO.VideoStation.PluginSearch",method:"list",version:1,offset:Ext.isDefined(c.offset)?c.offset:this.paging.cursor,limit:this.paging.pageSize,id:this.searchId});return c},onBeforeStartUpdateRecords:function(a){if(this.updateTask===a){a.reqConfig.params=this.getUpdateRecordParams()}},getSearchPanel:function(){if(this.searchPanel){return this.searchPanel}return(this.searchPanel=this.getComponent("grid"))},fillGridConfig:function(){return this.fillMainGridConfig()},createPaging:function(b){var c=new SYNO.ux.Button({tooltip:_VST("search","searching"),overflowText:_VST("search","searching"),cls:"loading",hidden:true});var a=Ext.apply({showRefreshBtn:false,loading:c,pageSize:this.displayNum,displayInfo:true,items:[c],hideLoading:function(){this.refresh.show();this.loading.hide()},showLoading:function(){this.refresh.hide();this.loading.show()}},b);return new SYNO.ux.PagingToolbar(a)},fillMainGridConfig:function(){this.paging=this.createPaging({store:this.getStore()});var a=Ext.apply({xtype:"syno_gridpanel",cls:"syno-vs-info-search-grid",stripeRows:true,loadMask:true,region:"center",itemId:"grid",border:false,autoExpandMin:160,autoExpandColumn:"title",bbar:this.paging,store:this.getStore(),cm:this.getColumnModel(),sm:new Ext.grid.RowSelectionModel({single:true,silentMode:true}),viewConfig:{autoFill:true,forceFit:true,scrollDelay:false,cacheSize:50,rowHeight:27},getView:function(){if(!this.view){this.view=new SYNO.SDS.VideoStation.HoldBufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,rowdblclick:function(b,g,c){var f=b.getSelectionModel();var d=f.getSelected();if(!d){return}this.onApply()}}});return a},onRemoveAll:function(){this.getStore().removeAll();this.paging.jumpPageByOffset(0);this.searchPanel.getView().setHoldScroll(undefined)},getColumnModel:function(){if(this.colModel){return this.colModel}var a=[{id:"title",header:_VST("common","title"),dataIndex:"title",sortable:true,width:200,autoExpand:true,renderer:(function(h,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"original_available",header:(this.getCurType()!==SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID)?_VST("original_available","title"):(_VST("original_available","title")+" ("+_VST("type","tv_show")+")"),dataIndex:"original_available",sortable:true,width:150,renderer:(function(h,f,b,e,g,c){if(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID===this.getCurType()){h=b.data.tvshow_original_available}if(h==="0"){h=""}var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)}];if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID){a.push({id:"episode_name_title",header:_VST("episode","name_title"),dataIndex:"tag_line",width:100,renderer:(function(h,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"season",header:_VST("season","season_title"),dataIndex:"season",width:70,renderer:(function(h,f,b,e,g,c){if(h==="0"){return""}var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"episode",header:_VST("episode","episode_title"),dataIndex:"episode",width:70,renderer:(function(h,f,b,e,g,c){if(h==="0"){return""}var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)})}a.push({id:"summary",header:(this.getCurType()!==SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID)?_VST("summary","title"):(_VST("summary","title")+" ("+_VST("episode","episode_title")+")"),dataIndex:"summary",width:300,renderer:(function(h,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)});this.colModel=new Ext.grid.ColumnModel({defaults:{align:"left",sortable:true},columns:a});return this.colModel},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.Store({autoLoad:false,method:"POST",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},remoteSort:true,sortInfo:{field:"title",direction:"ASC"},proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("pluginsearch.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),reader:this.reader=new Ext.data.JsonReader({id:"id",root:"data.results",totalProperty:"data.total",fields:["id","title","tag_line","certificate","original_available","summary","season","episode","writer","director","actor","genre","extra","tvshow_summary","tvshow_extra","tvshow_original_available","tvshow_year","tvshow_sort_time","tvshow_index"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onStoreLoad,exception:this.onExceptionLoadStore}}))},onStoreLoad:function(){if(!this.getSearchPanel().getSelectionModel().getSelected()){this.getSearchPanel().getSelectionModel().selectRow(0)}},onExceptionLoadStore:function(){this.onStop()},onLoadData:function(a){if(this.isDestroyed){return}this.getStore().loadData(a)},onUpdateError:function(a){this.onUnMask();var b=SYNO.SDS.VideoStation.Util.getErrinfoString(a,_T("common","commfail"));this.getMsgBox().alert(_VST("app","displayname"),b);this.onStop()},onStoreUpdated:function(b,m,e){if(this.isDestroyed){this.updateTask.stop();return}if(!m||!e||!e.success||!e.data){this.onUpdateError(e);return}var g=this.getStore().getSortState();if(b.params.id!=this.searchId||b.params.sort_by!==g.field||b.params.sort_direction!==g.direction||b.params.offset!==this.paging.cursor){return}var f=e.data;if(this.onIsMask()){if(f.status==="updated"||(f.results&&f.results.length>0)){this.onUnMask()}}if(f.status==="updated"){this.onHideLoading();this.updateTask.stop();this.searchPanel.getView().setHoldScroll(false)}var c=false;var k=f.results;if(this.getStore()&&(f.total!=this.getStore().getTotalCount())){c=true}else{for(var d=0;d<k.length;d++){var i=this.getStore().getById(k[d].id);var h=this.getStore().getAt(d);if(!i||!h||k[d].id!=h.get("id")){c=true;break}if(i){for(var l in i.data){i.data[l]=k[d][l]}i.commit()}else{c=true;break}}}if(c){var a=this.paging.cursor;this.paging.unbind(this.getStore());this.getStore().loadData(e,false);this.paging.bind(this.getStore());this.paging.onLoad(this.getStore(),k,{params:{offset:a}})}},onLoad:function(c,b,a){if(!Ext.isEmpty(c)){this.searchfield.setValue(c);this.searchfield.trigger.show();this.mon(this,"show",function(){this.searchfield.selectText(0,0)},this,{delay:800,single:true})}if(!Ext.isEmpty(b)&&!Ext.isEmpty(a)){if(b!=="0"){this.season.setValue(b)}if(a!=="0"){this.episode.setValue(a)}}this.show()},onHideLoading:function(){this.paging.hideLoading()},onShowLoading:function(){this.paging.showLoading()},getCurType:function(){return this._getOwner().getCurType()}});Ext.define("SYNO.SDS.VideoStation.HoldBufferView",{extend:"SYNO.ux.FleXcroll.grid.BufferView",onLoad:function(){if(!this.holdPosition){this.callParent(arguments)}if(!Ext.isDefined(this.holdPosition)){this.holdPosition=true}},setHoldScroll:function(a){this.holdPosition=a}});Ext.define("SYNO.SDS.VideoStation.VideoSelectionDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",displayNum:300,constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)]);this.createPollingTask()},fillConfig:function(a){var b={cls:"syno-vs-video-selection-dialog",width:750,height:400,minWidth:200,minHeight:200,title:_VST("action","select_db"),layout:"border",border:false,bodyBorder:false,hideBorders:true,items:[this.createTBar(),this.fillGridConfig()],buttons:[this.btnApply=new SYNO.ux.Button({btnStyle:"blue",disabled:true,text:_T("common","commit"),scope:this,handler:this.onApply}),{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onSearch},{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},onApply:function(){var c=this.getSearchPanel().getSelectionModel().getSelected();if(c){var a=this.getCurType(),b=c.data;if(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID===a){b={tvshow_original_available:c.data.original_available,tvshow_summary:SYNO.SDS.VideoStation.Util.getAddtionalText(c.data,"summary"),title:c.data.title}}this.owner.onSetMetaData(b)}this.close()},getSearchPanel:function(){if(this.searchPanel){return this.searchPanel}return(this.searchPanel=this.getComponent("grid"))},createPollingTask:function(){var a=this.addTask({interval:800,scope:this,run:function(){if(this.isDestroyed){a.stop();return}if(this.getSearchPanel().getSelectionModel().getSelected()){this.btnApply.enable()}else{this.btnApply.disable()}}}).start()},createTBar:function(){var a=[this.searchfield=new SYNO.ux.TextFilter({itemId:"search_field",emptyText:_VST("search","keyword"),flex:1}),{xtype:"tbspacer",width:6},this.btnSearch=new SYNO.ux.Button({text:_VST("search","title"),tooltip:_VST("search","title"),itemId:"search",scope:this,handler:this.onSearch})];return{region:"north",height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-window-tbar",items:[{flex:1,height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-toolbar x-toolbar-cell",style:"border-top:0 none;",items:a}]}},fillGridConfig:function(a){this.paging=new SYNO.ux.PagingToolbar({store:this.getStore(),pageSize:this.displayNum,displayInfo:true});var b=Ext.apply({xtype:"syno_gridpanel",cls:"syno-vs-video-selection-grid",stripeRows:true,loadMask:true,region:"center",itemId:"grid",border:false,autoExpandMin:160,autoExpandColumn:"title",bbar:this.paging,store:this.getStore(),cm:this.getColumnModel(),sm:new Ext.grid.RowSelectionModel({single:true}),viewConfig:{autoFill:true,forceFit:true,scrollDelay:false,cacheSize:50,rowHeight:27},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,rowdblclick:function(c,h,d){var g=c.getSelectionModel();var f=g.getSelected();if(!f){return}this.onApply()}}});return b},getColumnModel:function(){if(this.colModel){return this.colModel}var a=this.getCurType();this.colModel=new Ext.grid.ColumnModel({defaults:{align:"left",sortable:true},columns:[{id:"title",header:_VST("common","title"),dataIndex:"title",sortable:true,width:200,autoExpand:true,renderer:(function(h,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"original_available",header:a==="home_video"?_VST("video_info","record_time"):_VST("original_available","title"),dataIndex:a==="home_video"?"record_date":"original_available",sortable:true,width:150,renderer:(function(h,f,b,e,g,c){if(h==="0"){h=""}var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{sortable:false,id:"additional",header:_VST("summary","title"),dataIndex:"additional",width:300,renderer:(function(h,f,b,e,g,c){if(!h||!h.summary){return}h=h.summary;var d=Ext.util.Format.htmlEncode(h);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)}]});return this.colModel},getRoot:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return"movies";case SYNO.SDS.VideoStation.Util._TVSHOW_ID:case SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:return"tvshows";case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return"videos";default:return""}},getStore:function(){if(this.store){return this.store}var b,c=this.getCurType();c=SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID===c?SYNO.SDS.VideoStation.Util._TVSHOW_ID:c;b=SYNO.SDS.VideoStation.Util.getinfo_WebAPI(c).api;var a=this.getRoot(c);return(this.store=new Ext.data.JsonStore({autoDestroy:true,autoLoad:true,method:"POST",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},remoteSort:true,sortInfo:{field:"title",direction:"ASC"},proxy:new SYNO.API.Proxy({api:b,method:"list",version:2,listeners:{scope:this,beforeload:function(d,e){var f=d.activeRequest.read;if(f){Ext.Ajax.abort(f)}}}}),baseParams:{additional:Ext.encode(["summary","actor","writer","director","extra","genre"])},root:a,totalProperty:"total",fields:["id","title","tagline","original_available","record_date","certificate","metadata_locked","additional"],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onStoreLoad,exception:this.onExceptionLoadStore}}))},onSearch:function(){var a=this.searchfield.getValue();a=a.trim();if(Ext.isEmpty(a)){this.getStore().load({offset:0});return}this.getStore().load({params:{offset:0,keyword:a}})},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{library_id:this._getCurLibraryId(),offset:Ext.isDefined(c.offset)?c.offset:this.paging.cursor,limit:this.paging.pageSize});return c},onStoreLoad:function(){if(this.isDestroyed){return}if(!this.getSearchPanel().getSelectionModel().getSelected()){this.getSearchPanel().getSelectionModel().selectRow(0)}},onExceptionLoadStore:function(b,c,d,a,e){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("error","error_error_system"));this.getMsgBox().alert(_VST("app","displayname"),f,function(){this.close()},this);SYNO.Debug("Ajax load failure ",arguments)},onLoad:function(c,b,a){this.show();this.searchfield.setValue(c)},getCurType:function(){return this._getOwner().getCurType()}});Ext.define("SYNO.SDS.VideoStation.PathHistoryMgr",{extend:"Ext.Component",constructor:function(a){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr",this);this.pathHistory=new SYNO.SDS.VideoStation.PathHistory();this.addManagedComponent(this.pathHistory);this.libInfo={};this.curID=SYNO.SDS.VideoStation.Util._MOVIE_ID;this.callParent([a])},getCurId:function(){return this.curID},getCurType:function(){return this.libInfo[this.curID].type},getCurLibraryTitle:function(){return this.libInfo[this.curID].title},getCurLibraryId:function(){return Ext.isNumber(this.curID)?this.curID:0},getCurCategory:function(){var a=this.pathHistory.objHistory[this.curID];if(Ext.isDefined(a[1])){return a[1].params.category}if(Ext.isDefined(a[0].params.category)){return a[0].params.category}},addLibrary:function(b,a){this.libInfo[b]=a;if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===b){this.pathHistory.pushHistory(b,{view:SYNO.SDS.VideoStation.Util._VIEW_GRID,params:{},status:{}})}else{this.pathHistory.pushHistory(b,{view:SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE,params:{},status:{}})}},removeLibrary:function(a){this.libInfo[a]=null;this.pathHistory.objHistory[a]=null},gotoHomePage:function(a){this.gobackPanel(0,a)},gotoFilterView:function(a){this.gotoView(a,SYNO.SDS.VideoStation.Util._VIEW_FILTERING)},goSwitchFilterView:function(b){if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===this.getCurType()){return false}var a=this.getHistoryInfo();if(a.view===SYNO.SDS.VideoStation.Util._VIEW_FILTERING){this.fireEvent("afterGoSwitchFilterView")}},gotoDetileView:function(a){this.gotoView(a,SYNO.SDS.VideoStation.Util._VIEW_DETAIL)},gotoCollectionView:function(a){this.gotoView(a,SYNO.SDS.VideoStation.Util._VIEW_COLLECTION)},gotoTVSeasonView:function(a){this.gotoView(a,SYNO.SDS.VideoStation.Util._VIEW_EPISODE)},gotoView:function(b,a){this.pathHistory.pushHistory(this.curID,{view:a,params:b.params||{},status:b.status||{}});if(false!==b.isFireEvent){this.fireEvent("afterGoToPanel")}},gotoViewAgain:function(){this.fireEvent("afterGoToPanel")},gobackPanel:function(a,b){this.pathHistory.popHistory(this.curID,a);if(!b||false!==b.isFireEvent){this.fireEvent("afterGoToPanel")}},goSwithLibrary:function(a){this.curID=a.id;this.fireEvent("afterGoToPanel")},getHistoryInfo:function(b,a){if(!Ext.isDefined(b)){b=this.curID}if(!Ext.isDefined(a)){a=this.pathHistory.objHistory[b].length-1}return this.pathHistory.objHistory[b][a]},getHistoryAll:function(a){if(!Ext.isDefined(a)){a=this.curID}return this.pathHistory.objHistory[a]},updatePathBar:function(){this.fireEvent("updatePathBar")},checkIsByfolder:function(){var a=this.pathHistory.objHistory[this.curID];if(Ext.isDefined(a[1])&&"folder"===a[1].params.category){return true}return false}});Ext.define("SYNO.SDS.VideoStation.PathHistory",{constructor:function(a){this.objHistory={}},pushHistory:function(b,a){if(!this.objHistory[b]){this.objHistory[b]=[]}if(!Ext.isDefined(a)){return false}this.objHistory[b].push(a);return true},popHistory:function(b,a){if(!Ext.isArray(this.objHistory[b])){return false}if(!Ext.isDefined(a)){a=(1<this.objHistory[b].length)?(this.objHistory[b].length-2):0}this.objHistory[b]=this.objHistory[b].slice(0,a+1);return true},getHistorySize:function(a){if(!Ext.isArray(this.objHistory[a])){return 0}return this.objHistory[a].length}});Ext.define("SYNO.SDS.VideoStation.CollectionMgr",{extend:"Ext.Component",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.CollectionMgr",this);this.addEvents("beforeLoadCollection");this.getStore().load();this.callParent([a])},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({method:"POST",proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("collection.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),baseParams:{api:"SYNO.VideoStation.Collection",method:"list",version:2,offset:0,limit:-1,sort_by:"title",sort_direction:"ASC",additional:'["sharing_info"]'},reader:new Ext.data.JsonReader({id:"id",root:"data.collections",totalProperty:"data.total",fields:["id","title","additional","type"]}),listeners:{scope:this,beforeload:function(){this.fireEvent("beforeLoadCollection")},load:function(){this.fireEvent("afterLoadCollection")},exception:function(){this.fireEvent("afterLoadCollection")}}});this.addManagedComponent(this.store);return this.store},getCollectionMenuItems:function(d,b){var c=[];var a={itemId:"creat_collection_list",handler:this.launchCreatCollectionList,text:_VST("collection","new_collection"),disabled:_S("demo_mode"),scope:b};c=c.concat(a);if(d){c.push({xtype:"menuseparator",itemId:"sep_newcollection"});c.push({itemId:"add_favorite_from_menu",handler:this.onMenuAddFavoite,text:_VST("collection","favorite"),disabled:_S("demo_mode"),hideOnClick:false,scope:b});c.push({itemId:"remove_favorite_from_menu",handler:this.onMenuRemoveFavoite,text:_VST("collection","favorite"),disabled:_S("demo_mode"),hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:b});c.push({itemId:"add_watch_list_from_menu",handler:this.onMenuAddWatchList,text:_VST("collection","watchlist"),disabled:_S("demo_mode"),hideOnClick:false,scope:b});c.push({itemId:"remove_watch_list_from_menu",handler:this.onMenuRemoveWatchList,text:_VST("collection","watchlist"),disabled:_S("demo_mode"),hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:b})}else{if(2<this.getStore().getTotalCount()){c.push({xtype:"menuseparator",itemId:"sep_newcollection"})}}this.getStore().each(function(e){var h=e.get("id");var g=e.get("title");var f=e.get("type");if(g!=="syno_favorite"&&g!=="syno_watchlist"&&g!=="syno_default_shared"&&"original"===f){c.push({itemId:h+"_add_"+g,handler:this.onMenuAddToUserDefCollection,text:g,hideOnClick:false,scope:b});c.push({itemId:h+"_remove_"+g,handler:this.onMenuRemoveFromUserDefCollection,text:g,hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:b})}},this);return c},launchCreatCollectionList:function(){var a=new SYNO.SDS.VideoStation.NewEditCollectionDialog({create:true,module:this});a.open()},onMenuAddFavoite:function(){var a={id:-1};this.onRequestCollection("addvideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onMenuRemoveFavoite:function(){var a={id:-1};this.onRequestCollection("deletevideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onMenuAddWatchList:function(){var a={id:-2};this.onRequestCollection("addvideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onMenuRemoveWatchList:function(){var a={id:-2};this.onRequestCollection("deletevideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onMenuAddToUserDefCollection:function(b,c){var f,d;if(b.itemId){d=b.itemId.indexOf("_add");f=parseInt(b.itemId.substring(0,d),10)}var a={id:f};this.onRequestCollection("addvideo",true,a,function(e,h,g){this.onRequestCollectionCallBack(e,h,g,"addvideo",a)},this)},onMenuRemoveFromUserDefCollection:function(b,c){var f,d;if(b.itemId){d=b.itemId.indexOf("_remove");f=parseInt(b.itemId.substring(0,d),10)}var a={id:f};this.onRequestCollection("deletevideo",true,a,function(e,h,g){this.onRequestCollectionCallBack(e,h,g,"deletevideo",a)},this)},_onRequestCollectionNoMesg:function(d,a,c,b){SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:d,version:2,params:Ext.apply({video_collections:Ext.encode(SYNO.SDS.VideoStation.Util._getSelectedVideoCollections())},a),scope:this,callback:function(i,h,g,e){if(!i){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(i,h,e.params));return}else{if(Ext.isFunction(c)){c.call(b,i,h,g)}else{var f=SYNO.SDS.VideoStation.Util.getActiveItem();f.onActivate()}}}})},_onRequestCollection:function(d,b,c,a){this._getOwner().setStatusBusy();SYNO.API.Request({api:"SYNO.VideoStation.Collection",method:d,version:2,params:Ext.apply({video_collections:Ext.encode(SYNO.SDS.VideoStation.Util._getSelectedVideoCollections())},b),scope:this,callback:function(j,i,h,e){this._getOwner().clearStatusBusy();if(!j){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(j,i,e.params));return}else{var g=_VST("common","saved");switch(d){case"addvideo":if(-1===b.id){g=_VST("collection","favorite_added")}else{if(-2===b.id){g=_VST("collection","watchlist_added")}}break;case"deletevideo":if(-1===b.id){g=_VST("collection","favorite_removed")}else{if(-2===b.id){g=_VST("collection","watchlist_removed")}}break;default:break}this._getOwner().getMsgBox().alert(_VST("app","displayname"),g);if(Ext.isFunction(c)){c.call(a,j,i,h)}else{var f=SYNO.SDS.VideoStation.Util.getActiveItem();f.onActivate()}}}})}});Ext.define("SYNO.SDS.VideoStation.FolderMgr",{extend:"Ext.Component",constructor:function(a){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.FolderMgr",this);this.callParent([a]);this.initLibrary()},initLibrary:function(){this.path_map={};this.path_map[SYNO.SDS.VideoStation.Util._MOVIE_ID]={};this.path_map[SYNO.SDS.VideoStation.Util._TVSHOW_ID]={};this.path_map[SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID]={};this.path_map[SYNO.SDS.VideoStation.Util._TV_RECORDER_ID]={}},applyFolder:function(a){if(!Ext.isArray(a)){return}Ext.each(a,function(d){var c=d.section;var b=Ext.isEmpty(d.library_id)?0:parseInt(d.library_id,10);this.path_map[c][b]=d.path},this)},updateLibrary:function(b,e,a,d){if(!Ext.isArray(a)){return}var c=a.length>0?a[0].get("path"):"";this.updateLibraryByPath(b,e,c,d)},updateLibraryByPath:function(b,f,d,e,c){if(!Ext.isString(b)||!Ext.isString(d)){return}var a=Ext.isEmpty(f)?0:parseInt(f,10);if(c===true){if(!this.path_map[b][a]&&d){this.path_map[b][a]=d}}else{this.path_map[b][a]=(d.length>0)?d:null}if(e&&SYNO.SDS.VideoStation.Util._VIEW_HOMEPAGE===SYNO.SDS.VideoStation.Util._getHistoryInfo().view){SYNO.SDS.VideoStation.Util._gotoViewAgain()}},getLibraryFolderPath:function(a,b){return this.path_map[a][b]},isLibraryContainsFolder:function(a,b){return Ext.isString(this.path_map[a][b])}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.TpSettingPanel=Ext.extend(SYNO.ux.Panel,{constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.TpSettingPanel.superclass.constructor.call(this,b)},fillConfig:function(a){this.owner=a.owner;var b={region:"center",layout:"vbox",layoutConfig:{type:"vbox",align:"stretch",pack:"start"},items:[this.grid=new SYNO.SDS.VideoStation.TpGrid({owner:this._getOwner(),border:true,flex:0.8})]};Ext.apply(b,a);return b},isDirty:function(){return this.grid.isDirty()},load:function(a){if(a==this.grid.lnb){return}this.grid.lnb=a;var c=("add_lnb"==this.grid.lnb)?"get_tp_default":"get_tp";var b={tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite,lnb:this.grid.lnb};this._getOwner().setStatusBusy();SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,c,this.owner.ChannelScanAPIVerion,b,this.grid.onLoadDone,this.grid)},onSave:function(){this.owner.setStatusBusy();this.grid.onClickSave(this.onSaveDone)},onSaveDone:function(a,c,b){this.owner.clearStatusBusy();if(!a){this.owner.alertErrorMesg(a,c,b);return}this.owner.close()}});SYNO.SDS.VideoStation.TpGrid=Ext.extend(SYNO.ux.GridPanel,{constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);this.owner=b.owner;this.clickedDefault=false;var a=Ext.apply({stripeRows:true,cls:"syno-vs-setting-grid",itemId:"grid",border:false,store:this.getStore(),tbar:this.createActions(),columns:this.getColumnModel(),plugins:[this.enableColumn],selModel:new Ext.grid.RowSelectionModel({single:true,listeners:{selectionchange:{fn:this.onChgButtonStatus,buffer:50,scope:this}}}),viewConfig:{scrollDelay:false,cacheSize:50,rowHeight:24},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{rowcontextmenu:{scope:this,fn:function(d,f,c){c.preventDefault();var e=d.getSelectionModel();e.selectRow(f,e.isSelected(f))}},rowdblclick:function(){this.openTpDialog("edit_tp")},scope:this}},b);SYNO.SDS.VideoStation.TpGrid.superclass.constructor.call(this,a);this.addManagedComponent(this.getStore())},createActions:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[{text:_T("common","create"),itemId:"create",scope:this,handler:function(b,a){this.openTpDialog("create_tp")}},{text:_T("common","alt_edit"),itemId:"edit",disabled:true,scope:this,handler:function(b,a){this.openTpDialog("edit_tp")}},{text:_T("common","delete"),itemId:"delete",disabled:true,scope:this,handler:this.onClickDelete},{text:_VST("dtvsscan","apply_default"),scope:this,handler:this.onClickDefault}]})},onClickDefault:function(){this.clickedDefault=true;var a={tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite,lnb:this.owner.lnbSettingPanel.form.getValues().profile};this._getOwner().setStatusBusy();SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,"get_tp_default",this.owner.ChannelScanAPIVerion,a,this.onLoadDone,this)},onClickDelete:function(){this.owner.getMsgBox().confirm(this.title,_VST("dtvsscan","delete_cfrmrm"),function(a){if("yes"===a){var b=this.selModel.getSelected();this.store.modified.remove(b);this.store.removed.push(b);this.store.remove(b)}},this)},onClickSave:function(c){var a=[];Ext.each(this.store.data.items,function(f,d,e){a.push(f.data)},this);var b={tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite,lnb:this.lnb,tps:Ext.encode(a)};SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,"save_tp",this.owner.ChannelScanAPIVerion,b,c,this)},getColumnModel:function(){if(this.colModel){return this.colModel}this.enableColumn=new SYNO.ux.EnableColumn({dataIndex:"checked",width:50,align:"center",menuDisabled:true,enableFastSelectAll:true});this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[this.enableColumn,{header:_VST("video_info","frequency")+"(MHz)",dataIndex:"freq",sortable:true,width:180},{header:_VST("dtvsscan","symbol_rate")+"(Ksym/s)",dataIndex:"sr",width:180},{header:_VST("dtvsscan","polarisation"),dataIndex:"pol",width:90}]});return this.colModel},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.ArrayStore({autoDestroy:true,sortInfo:{field:"freq",direction:"ASC"},fields:["freq","sr","pol","checked"],data:[]});this.addManagedComponent(this.store);return this.store},onLoadDone:function(a,d,c){this._getOwner().clearStatusBusy();if(!a){this.alertErrorMesg(a,d,c);return}var b=[];Ext.each(d.tps,function(g,e,f){b.push([g.freq,g.sr,g.pol,g.checked])},this);this.store.loadData(b,false);if(this.store.getCount()){this.getSelectionModel().selectFirstRow()}else{this.onChgButtonStatus()}},isDirty:function(){return(0<this.store.getModifiedRecords().length||0<this.store.removed.length||this.clickedDefault)},onChgButtonStatus:function(){if(_S("demo_mode")){return}var a=this.getSelectionModel().getCount();this.getTopToolbar().getComponent("edit").setDisabled(1!==a);this.getTopToolbar().getComponent("delete").setDisabled(0===a)},openTpDialog:function(d){var a={freq:"",sr:"",pol:"V"};var b=-1;if("edit_tp"==d){if(1!=this.selModel.getCount()){return}a=this.selModel.getSelected().data;b=this.store.indexOf(this.selModel.getSelected())}var c=new SYNO.SDS.VideoStation.TpDialog({owner:this._getOwner(),store:this.store,method:d,index:b,values:a,grid:this});c.open()}});SYNO.SDS.VideoStation.TpDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){this.init(a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.TpDialog.superclass.constructor.call(this,b)},init:function(a){this.owner=a.owner;this.method=a.method;this.store=a.store;this.values=a.values;this.index=a.index;this.grid=a.grid;Ext.form.VTypes.normalname=/^[^\:"<>\*\\\/\|\?\,]*$/;Ext.form.VTypes.first_digital=/^[\d]/;Ext.form.VTypes.only_dash=/^-+$/},fillConfig:function(a){var c=new SYNO.ux.FormPanel(SYNO.LayoutConfig.fill({fileUpload:false,labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:false,labelWidth:130,defaults:{width:189},items:[{xtype:"syno_textfield",fieldLabel:_VST("video_info","frequency")+"(MHz)",name:"freq",allowBlank:false,maxLength:64,value:this.values.freq,stripCharsRe:/(^\s+|\s+$)/g,validator:function(d){return Ext.form.VTypes.only_digital.test(d)&&d==0||(d>2999&&d<20001)}},{xtype:"syno_textfield",fieldLabel:_VST("dtvsscan","symbol_rate")+"(Ksym/s)",name:"sr",allowBlank:false,maxLength:16,value:this.values.sr,stripCharsRe:/(^\s+|\s+$)/g,validator:function(d){return Ext.form.VTypes.only_digital.test(d)}},{xtype:"syno_combobox",fieldLabel:_VST("dtvsscan","polarisation"),name:"pol",value:this.values.pol,store:new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[["H","H"],["V","V"]]}),triggerAction:"all",resizable:false,editable:false,displayField:"display",valueField:"value",mode:"local"}]}));var b={width:400,height:260,minWidth:300,minHeight:240,layout:"fit",plain:true,buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,disabled:_S("demo_mode"),hidden:!_S("is_admin"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onSave},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:[10,13],scope:this,handler:this.onSave},{key:27,scope:this,handler:this.onCancel}],items:[c],listeners:{scope:this,beforeshow:this.beforeShow}};Ext.apply(b,a);return b},beforeShow:function(){var a=this.items.get(0).getForm();a.findField("freq").clearInvalid();a.findField("sr").clearInvalid();if("edit_tp"==this.method){this.setTitle(_VST("dtvsscan","edit_transponder"))}else{this.setTitle(_VST("dtvsscan","add_transponder"))}return},onSave:function(){var c=this.items.get(0).getForm();if(!c.isValid()){return}if(!c.isDirty()){this.close();return}var d=c.getValues();if(-1==this.index){var e=d.freq+"_"+d.sr+"_"+d.pol;if(this.store.getById(e)){this.owner.getMsgBox().alert(this.title,_T("error","error_file_exist"));return}var a=new this.store.recordType({checked:true,freq:parseInt(d.freq,10),sr:parseInt(d.sr,10),pol:d.pol});a.markDirty();this.store.addSorted(a);var b=this.store.indexOf(a);this.grid.getSelectionModel().selectRow(b);this.grid.getView().getRow(b).scrollIntoView();this.close()}else{this.store.getAt(this.index).set("pol",d.pol);this.store.getAt(this.index).set("freq",parseInt(d.freq,10));this.store.getAt(this.index).set("sr",parseInt(d.sr,10));this.close()}return},onCancel:function(){this.close()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.LnbSettingPanel=Ext.extend(SYNO.ux.FormPanel,{constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.init(a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.LnbSettingPanel.superclass.constructor.call(this,b);var c;c=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enablediseqc",["diseqc"])},init:function(a){this.owner=a.owner;this.params=this.owner.params;this.lnbpreset=this.params.preset;Ext.form.VTypes.normalname=/^[^\:"<>\*\\\/\|\?\,]*$/;Ext.form.VTypes.only_dash=/^-+$/;Ext.form.VTypes.only_digital=/^([0-9]+)$/},fillConfig:function(b){var a=("customize"==this.params.profile)?false:true;this.lnbNameItems=new SYNO.ux.FieldSet(SYNO.LayoutConfig.fill({title:"LNB",hidden:this.params.preset,items:[{xtype:"syno_textfield",fieldLabel:_VST("dtvsscan","lnb_name"),name:"name",value:this.params.name,width:189,allowBlank:false,maxLength:32,stripCharsRe:/(^\s+|\s+$)/g,validator:function(e){return Ext.form.VTypes.normalname.test(e)&&!Ext.form.VTypes.only_dash.test(e)}}]}));this.displayLnbNameItems=new SYNO.ux.FieldSet({title:"LNB",hidden:!this.params.preset,items:[{xtype:"syno_displayfield",fieldLabel:_VST("dtvsscan","lnb_name"),name:"display_name",value:this.params.name,width:189}]});this.displayLnbItems=new SYNO.ux.FieldSet({title:_VST("dtvsscan","general_setting"),hidden:!this.params.preset,defaults:{width:189},items:[{xtype:"syno_displayfield",fieldLabel:_VST("dtvsscan","lnb_type"),value:this.params.profile,name:"display_profile"},{xtype:"syno_displayfield",fieldLabel:"Low Band(MHz)",value:this.params.low,name:"display_low"},{xtype:"syno_displayfield",fieldLabel:"High Band(MHz)",value:this.params.high,name:"display_high"},{xtype:"syno_displayfield",fieldLabel:_VST("dtvsscan","switch")+"(MHz)",value:this.params["switch"],name:"display_switch"}]});this.lnbItems=new SYNO.ux.FieldSet(SYNO.LayoutConfig.fill({title:_VST("dtvsscan","general_setting"),hidden:this.params.preset,defaults:{width:189},items:[{xtype:"syno_combobox",fieldLabel:_VST("dtvsscan","lnb_type"),value:this.params.profile,name:"profile",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createProfileStore(),editable:false,displayField:"display",valueField:"profile",hiddenName:"profile",allowBlank:false,width:189,mode:"local",listeners:{scope:this,select:function(e,f,g){var h=f.data;this.setLnbProfile(h)},expand:function(e){if(e.wrap.getWidth()>=e.list.getWidth()){e.list.setSize(e.wrap.getWidth(),0)}else{e.list.setSize("auto",0)}}}},{xtype:"syno_textfield",fieldLabel:"Low Band(MHz)",disabled:a,value:this.params.low,name:"low",allowBlank:false,maxLength:5,validator:function(e){var f=parseInt(e,10);return Ext.form.VTypes.only_digital.test(e)&&0==f||(20001>f&&2999<f)}},{xtype:"syno_textfield",fieldLabel:"High Band(MHz)",disabled:a,value:this.params.high,name:"high",allowBlank:false,maxLength:5,validator:function(e){var f=parseInt(e,10);return Ext.form.VTypes.only_digital.test(e)&&0==f||(20001>f&&2999<f)}},{xtype:"syno_textfield",fieldLabel:_VST("dtvsscan","switch")+"(MHz)",disabled:a,value:this.params["switch"],name:"switch",allowBlank:false,maxLength:5,validator:function(e){var f=parseInt(e,10);return Ext.form.VTypes.only_digital.test(e)&&0==f||(20001>f&&2999<f)}}]}));var d=SYNO.LayoutConfig.fill({xtype:"syno_fieldset",title:_VST("dtvsscan","adv_setting"),defaults:{width:189},items:[{xtype:"syno_checkbox",hideLabel:true,triMode:false,boxLabel:_VST("dtvsscan","use_diseqc"),value:this.params.enablediseqc,name:"enablediseqc",checked:this.params.enablediseqc},{xtype:"syno_combobox",indent:1,fieldLabel:"DiSEqC",value:this.params.diseqc,name:"diseqc",triggerAction:"all",resizable:false,store:new Ext.data.ArrayStore({fields:["value","display"],data:[[0,0],[1,1],[2,2],[3,3]]}),editable:false,displayField:"display",valueField:"value",mode:"local"},{xtype:"syno_textfield",value:this.params.name,name:"lnb",hidden:true}]});var c={labelWidth:200,autoFlexcroll:true,trackResetOnLoad:true,hideMode:"offsets",items:[this.lnbNameItems,this.displayLnbNameItems,this.lnbItems,this.displayLnbItems,d]};Ext.apply(c,b);return c},createProfileStore:function(){var b=[["C-BAND","C-BAND","5150","0","0"],["C-MULTI","C-MULTI","5150","5750","0"],["DBS","DBS","11250","0","0"],["ENHANCED","ENHANCED","9750","0","0"],["STANDARD","STANDARD","10000","0","0"],["UNIVERSAL","UNIVERSAL","9750","10600","11700"]];if("customize"==this.params.profile){b.push(["customize",_T("common","customize"),this.params.low,this.params.high,this.params["switch"]])}else{b.push(["customize",_T("common","customize"),"","",""])}var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["profile","display","low","high","switch"],data:b});this.addManagedComponent(a);return a},setLnbProfile:function(g){var e=this.form.findField("profile");var b=this.form.findField("low");var j=this.form.findField("high");var h=this.form.findField("switch");var a=this.form.findField("display_profile");var i=this.form.findField("display_low");var f=this.form.findField("display_high");var d=this.form.findField("display_switch");var c=("customize"==g.profile)?false:true;e.setValue(g.profile);b.setValue(g.low);j.setValue(g.high);h.setValue(g["switch"]);a.setValue(g.profile);i.setValue(g.low);f.setValue(g.high);d.setValue(g["switch"]);b.setDisabled(c);j.setDisabled(c);h.setDisabled(c)},isDirty:function(){var b=this.form.isDirty();if(b){var a=this.form.findField("enablediseqc");a.setDisabled(true);if(false==this.form.isDirty()&&"false"==a.originalValue&&!a.getValue()){b=false}a.setDisabled(false)}return b},onSave:function(){var a=this.getForm();if(!a.isValid()){var b=this.owner.tabPanel;if(b.getActiveTab()!=this){b.setActiveTab(this)}return}a.submit({url:Ext.urlAppend(this._getWebAPIURL(this.owner.APIUrl)),params:{method:this.params.method,version:this.owner.ChannelScanAPIVerion,api:this.owner.ChannelScanAPI,tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite},failure:function(e,f){if(f.result.error&&f.result.error.code){var d=f.result.error.code;var c=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(d);this.owner.getMsgBox().alert(_VST("action","channelscan"),c)}},success:this.onSaveSuccess,scope:this})},onSaveSuccess:function(e,f){var b=this.owner.owner.LnbCombo;var h=b.getStore();var g=this.owner.owner.lnbData;var a={name:e.findField("name").getValue(),low:parseInt(e.findField("low").getValue(),10),high:parseInt(e.findField("high").getValue(),10),"switch":parseInt(e.findField("switch").getValue(),10),diseqc:parseInt(e.findField("diseqc").getValue(),10),profile:e.findField("profile").getValue(),enablediseqc:e.findField("enablediseqc").getValue()};var c=e.findField("lnb").getValue();var d=a.name;if(c){if(c!=d){h.remove(h.data.map[c])}Ext.each(g,function(k,i,j){if(c==k.name){a.preset=k.preset;a.tp_count=k.tp_count;g[i]=a}return},this)}else{this.owner.tpSettingPanel.grid.lnb=d;a.preset=false;a.tp_count=0;g.push(a)}if(c!=d){h.add(new h.recordType({value:d,display:d},d));this.owner.owner.sortLnbCombo(h);b.setValue(d);b.nextSibling().setDisabled(false)}this.owner.onApplySecond()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.DVBSSettingDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){this.init(a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.DVBSSettingDialog.superclass.constructor.call(this,b)},init:function(a){this.owner=a.owner;this.ChannelScanAPI=this.owner.ChannelScanAPI;this.ChannelScanAPIVerion=this.owner.ChannelScanAPIVerion;this.APIUrl=this.owner.APIUrl;this.tunerInfo=this.owner.tunerInfo;this.params=a.params;this.satellite=this.params.satellite;this.lnb=this.params.lnb},fillConfig:function(a){var b={title:this.satellite,width:490,height:520,minWidth:400,minHeight:280,layout:"fit",items:[this.getTabPanel()],buttons:[{btnStyle:"red",hidden:true,id:"dvbssettings_deletebtn",text:_T("common","delete"),scope:this,handler:this.tabPanel.onDelete},{btnStyle:"blue",disabled:_S("demo_mode"),text:_T("common","ok"),scope:this,handler:this.tabPanel.onApply},{text:_T("common","cancel"),scope:this,handler:this.tabPanel.onClose}],listeners:{scope:this,beforeshow:{fn:this.onBeforeShow,scope:this,single:true}}};Ext.apply(b,a);return b},open:function(a){this.tpSettingPanel.load(this.lnb);SYNO.SDS.VideoStation.DVBSSettingDialog.superclass.open.apply(this,arguments)},onBeforeShow:function(){var a=SYNO.SDS.Desktop?SYNO.SDS.Desktop.getEl().getHeight():Ext.lib.Dom.getViewHeight();if(a<this.getHeight()){this.setSize(this.getWidth(),a)}},getTabPanel:function(){if(!this.tabPanel){var a={owner:this,height:380,activeTab:0,items:[this.getLnbSettingPanel(),this.getTPSettingPanel()]};this.tabPanel=new SYNO.SDS.VideoStation.LnbSettingTabpanel(a)}return this.tabPanel},getLnbSettingPanel:function(){if(this.lnbSettingPanel){return this.lnbSettingPanel}return(this.lnbSettingPanel=new SYNO.SDS.VideoStation.LnbSettingPanel({title:"LNB",owner:this}))},getTPSettingPanel:function(){if(this.tpSettingPanel){return this.tpSettingPanel}return(this.tpSettingPanel=new SYNO.SDS.VideoStation.TpSettingPanel({title:_VST("dtvsscan","transponder"),owner:this}))},onApplySecond:function(){if(this.tpSettingPanel.isDirty()||"add_lnb"==this.lnb){this.tpSettingPanel.onSave()}else{this.close()}return},alertErrorMesg:function(a,d,c){this.clearStatusBusy();if(d.code&&d.code<400){this.getMsgBox().alert(_VST("action","channelscan"),SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(d.code);this.getMsgBox().alert(_VST("action","channelscan"),b)}}});SYNO.SDS.VideoStation.LnbSettingTabpanel=Ext.extend(SYNO.SDS.Utils.SettingTabPanel,{defineBehaviors:function(){SYNO.SDS.VideoStation.LnbSettingTabpanel.superclass.defineBehaviors.apply(this,arguments);this.ERR_STR_FN=_VST;this.ERR_STR_STRUCT=SYNO.SDS.Strings["SYNO.SDS.VideoStation.AppInstance"]},onBeforeRequest:function(a){return SYNO.SDS.VideoStation.LnbSettingTabpanel.superclass.onBeforeRequest.apply(this,arguments)},onApply:function(){if(this.lnbSettingPanel.isDirty()||"add_lnb"==this.tpSettingPanel.grid.lnb){this.lnbSettingPanel.onSave()}else{this.onApplySecond()}},onDelete:function(){if(!this.satellite||!this.lnb){return}this.owner.getMsgBox().confirm(_VST("action","channelscan"),_VST("dtvsscan","delete_cfrmrm"),function(a){if("yes"===a){SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"delete_lnb",this.ChannelScanAPIVerion,{satellite:this.satellite,lnb:this.lnb,tuner:this.tunerInfo.id},this.tabPanel.onDeleteDone,this)}},this)},onDeleteDone:function(b,g,f){if(!b){this.owner.alertErrorMesg(b,g,f)}else{var c=this.owner.LnbCombo;var d=c.getStore();var a,e=[];Ext.each(this.owner.lnbData,function(j,h,i){if(this.lnb==j.name){return}if(!a){a=j.name}e.push(j)},this);this.owner.lnbData=e;d.remove(d.data.map[this.lnb]);this.owner.sortLnbCombo(d);if(a){c.setValue(a)}else{c.setValue("add_lnb")}}this.close()},onApplyRequestFail:function(a,b,c){},onLostChangeClose:function(a){this.owner.getMsgBox().confirm(_VST("action","channelscan"),_T("common","confirm_lostchange"),function(b){if("yes"===b){this.owner.close()}else{this.setActiveTab(a)}},this)},onClose:function(){var a=this.tabPanel.getActiveTab();if(a.isDirty()){this.tabPanel.onLostChangeClose(a)}else{if(a.previousSibling()&&a.previousSibling().isDirty()){this.tabPanel.onLostChangeClose(a.previousSibling())}else{if(a.nextSibling()&&a.nextSibling().isDirty()){this.tabPanel.onLostChangeClose(a.nextSibling())}else{this.close()}}}},onBeforeTabChange:function(c,a,d){if(a.disabled===true){return false}var b=Ext.getCmp("dvbssettings_deletebtn");if(a instanceof Ext.form.FormPanel){b.setVisible(!a.lnbpreset&&"add_lnb"!=a.owner.lnb)}else{b.setVisible(false)}return true}});Ext.define("SYNO.SDS.VideoStation.ChannelScanDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.init(a);this.callParent([this.fillConfig(a)])},init:function(a){this.tunerInfo=a.tunerInfo;this.tunerType={FE_QPSK:0,FE_QAM:1,FE_OFDM:2,FE_ATSC:3}},fillConfig:function(a){var b={width:420,height:240,minWidth:300,minHeight:200,title:_VST("action","channelscan"),layout:"fit",closeAction:"hide",items:[this.initFormConfig()],buttons:[{btnStyle:"blue",text:_VST("action","scan"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onScanHandler},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:[10,13],scope:this,handler:this.onScanHandler},{key:27,scope:this,handler:this.onCancel}],listeners:{scope:this,beforeshow:this.beforeShow}};Ext.apply(b,a);return b},beforeShow:function(){if(this.tunerInfo.type==this.tunerType.FE_QPSK){var b=this.SatelliteBtn.getWidth();var c=this.LnbSettingBtn.getWidth();var a=b>c?b:c;if(a>40){this.setWidth(380+a)}}return true},onCancel:function(){if(this.hasScaned){this.hasScaned=false;this.reloadProgramList()}if(this.closeAction==="close"){this.close()}else{this.hide()}},onScanHandler:function(){if(_S("demo_mode")){this.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));return}if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")&&"country_value"===this.CountryCombo.getValue()){this.getMsgBox().alert(this.title,_VST("dtvtscan","choose_conutry_model"));return}if(this.tunerInfo.type==this.tunerType.FE_QPSK&&("satellite_value"==this.SatelliteCombo.getValue()||"lnb_value"==this.LnbCombo.getValue()||"add_lnb"==this.LnbCombo.getValue())){this.getMsgBox().alert(this.title,_VST("dtvsscan","choose_satellite_lnb"));return}if(this.tunerInfo.type!==this.tunerType.FE_QPSK&&-1===this.tunerInfo.title.indexOf("HDHomeRun")&&("country_value"===this.CountryCombo.getValue()||"region_value"===this.RegionCombo.getValue())){this.getMsgBox().alert(this.title,_VST("dtvtscan","choose_conutry_region"));return}if(this.tunerInfo.type!==this.tunerType.FE_QPSK&&this.SelectCountry&&this.SelectRegion){this.getMsgBox().confirm(this.title,_VST("action","rescan_message"),function(a){if("yes"===a){this.sendStartScan()}},this)}else{this.sendStartScan()}},sendStartScan:function(){this.getEl().mask(_VST("action","scanning"),"x-mask-loading");var a={tuner:this.tunerInfo.id};if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.satellite=this.SatelliteCombo.getValue();a.lnb=this.LnbCombo.getValue()}else{if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")){a.country=this.CountryCombo.getValue();a.region=this.modelCombo.getValue()}else{a.country=this.CountryCombo.getValue();a.region=this.RegionCombo.getValue()}}SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"start",this.ChannelScanAPIVerion,a,this.startScanDone,this)},startScanDone:function(a,c,b){if(!a){this.alertErrorMesg(a,c,b);return}this.ScanPollingTask=this.addAjaxTask({id:"channelScanPollingTask",interval:5000,autoJsonDecode:true,url:this._getWebAPIURL(this.APIUrl),params:{api:this.ChannelScanAPI,version:this.ChannelScanAPIVerion,method:"status",tuner:this.tunerInfo.id},success:this.updateScanProgress,failure:function(d,e){this.getEl().unmask();SYNO.Debug("Ajax load failure ",d)},scope:this});this.ScanPollingTask.start();this.getMsgBox().show({title:_VST("action","scanning"),progress:true,closable:true,hideDlg:false,width:310,minWidth:250,buttons:Ext.MessageBox.CANCEL,fn:this.pauseButton,scope:this})},updateScanProgress:function(b,c){if(!b.success){this.ScanPollingTask.remove();this.getMsgBox().hide();var a=_T("common","error_system");if(b.error&&b.error.code){a=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(b.error.code)}this.getMsgBox().alert(this.title,a);this.getEl().unmask();return}if(!b.data){return}var d;if(100===b.data.progress){d=_VST("action","scanning_finish")+"<br />"+String.format(_VST("action","scan_finish_show"),b.data.scaned_count);this.updateProgress=this.getMsgBox().updateProgress(1,"",d);this.updateProgress.fbButtons.cancel.setText(_T("common","close"));this.updateProgress.setTitle(_VST("dtv","title_scan_done"));this.ScanPollingTask.remove()}else{if((0!==b.data.scaned_count&&!b.data.service_name)||"(null)"===b.data.service_name||"null"===b.data.service_name||null===b.data.service_name){d=_VST("action","unknown_channel")+"<br />"+String.format(_VST("action","scan_total_show"),b.data.scaned_count)}else{if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")&&50<=b.data.progress){d=_VST("dtvtscan","scan_epging")}else{d=b.data.service_name+"<br />"+String.format(_VST("action","scan_total_show"),b.data.scaned_count)}}if(b.data.lnb_name){d="LNB - "+b.data.lnb_name+"<br />"+d}this.getMsgBox().updateProgress(b.data.progress/100,"",d)}},reloadProgramList:function(){if(Ext.isDefined(this.owner.ProgramScheduleTabPanel)){var b=this.owner.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramList;this.owner.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.owner.Channel_API,"list",this.owner.Channel_APIVerion,{tuner:this.tunerInfo.id,offset:0,limit:-1},b.channelListDone,b)}else{var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");a.getStore().load()}return},pauseButton:function(a,b){var c=true;if(this.updateProgress){c=false;this.updateProgress=null;this.reloadProgramList();if(this.closeAction==="close"){this.close()}else{this.hide()}}if(c){if(!this.getEl().isMasked()){this.getEl().mask(_T("common","saving"),"x-mask-loading")}this.ScanPollingTask.remove();SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"stop",this.ChannelScanAPIVerion,{tuner:this.tunerInfo.id},this.stopScanDone,this)}this.hasScaned=true},stopScanDone:function(a,c,b){if(!a){this.alertErrorMesg(a,c,b);return}if(this.getEl().isMasked()){this.getEl().unmask()}},show:function(){if(!this.defined){this.defineBehaviors();this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"getconfig",this.ChannelScanAPIVerion,{tuner:this.tunerInfo.id},this.getConfigDone,this)}this.setPosition(this.x,this.y);SYNO.SDS.VideoStation.ChannelScanDialog.superclass.show.apply(this,arguments)},defineBehaviors:function(){this.defined=true;this.TunerAPI="SYNO.DTV.Tuner";this.TunerAPIVersion="1";if(this.tunerInfo.type==this.tunerType.FE_QPSK){this.ChannelScanAPI="SYNO.DTV.DVBSScan";this.ChannelScanAPIVerion="1";this.APIUrl="dvbsscan.cgi"}else{this.ChannelScanAPI="SYNO.DTV.ChannelScan";this.ChannelScanAPIVerion="1";this.APIUrl="channelscan.cgi"}},initFormConfig:function(){this.CountryCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dtvtscan","country"),name:"country",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createCountryStore(),editable:false,displayField:"display",valueField:"value",value:"country_value",mode:"local",listeners:{scope:this,select:this.onChangeCountry,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.RegionCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dtvtscan","region"),name:"region",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createRegionStore(),editable:false,displayField:"display",valueField:"value",value:"region_value",mode:"local",listeners:{scope:this,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.modelCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dtvtscan","model"),name:"model",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createModelStore(),editable:false,displayField:"display",valueField:"value",value:"region_value",mode:"local",hidden:true,listeners:{scope:this,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.SatelliteCombo=new SYNO.ux.ComboBox({name:"satellite",triggerAction:"all",resizable:false,store:this.createSatelliteStore(),editable:false,displayField:"display",valueField:"value",value:"satellite_value",mode:"local",listeners:{scope:this,select:this.onChangeCountry,beforeselect:this.beforeSatelliteSelect,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.LnbCombo=new SYNO.ux.ComboBox({listWidth:"auto",name:"lnb",editable:false,resizable:false,store:this.createLnbStore(),mode:"local",triggerAction:"all",displayField:"display",valueField:"value",value:"lnb_value",allowBlank:false,listeners:{scope:this,beforeselect:this.beforeLnbSelect,select:function(e,c,d){this.LnbSettingBtn.setDisabled(false)},expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});var a=[{xtype:"syno_displayfield",name:"tuner",fieldLabel:_VST("dongle","tuner2"),value:this.tunerInfo.title}];if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.push({xtype:"syno_compositefield",fieldLabel:_VST("dtvsscan","satellite"),items:[this.SatelliteCombo,this.SatelliteBtn=new SYNO.ux.Button({disabled:true,text:_T("common","alt_edit"),scope:this,handler:this.launchSatelliteSettingDialog})]})}else{a.push(this.CountryCombo)}if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.push({xtype:"syno_compositefield",fieldLabel:"LNB",items:[this.LnbCombo,this.LnbSettingBtn=new SYNO.ux.Button({text:_VST("action","settings"),disabled:true,scope:this,handler:function(){var c=this.LnbCombo.getValue();return this.launchLnbSettingDialog(c)}})]})}else{a.push(this.RegionCombo);a.push(this.modelCombo)}var b={xtype:"syno_formpanel",url:this._getWebAPIURL(this.APIUrl),fileUpload:false,itemId:"channelscanform",labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:false,labelWidth:100,items:a};return b},launchSatelliteSettingDialog:function(){this.setSatelliteEditBtn();if(this.SatelliteBtn.disabled){return}var a=new SYNO.SDS.VideoStation.SatelliteDialog({owner:this,satellite:this.SatelliteCombo.value});a.open();return},launchLnbSettingDialog:function(c){var b=this.SatelliteCombo.getValue();var a={};if("satellite_value"==b){this.getMsgBox().alert(this.title,_VST("dtvsscan","choose_satellite_lnb"));return}if("add_lnb"==c){a={name:"",low:"5150",high:"0","switch":"0",diseqc:"0",profile:"C-BAND",preset:false,enablediseqc:false};a.method="create_lnb"}else{Ext.each(this.lnbData,function(f,d,e){if(c==f.name){a=f;a.method="edit_lnb"}},this)}if(!a.method){this.getMsgBox().alert(this.title,_VST("dtvsscan","choose_satellite_lnb"));return}a.satellite=b;a.lnb=c;this.lnbSettingDialog=new SYNO.SDS.VideoStation.DVBSSettingDialog({owner:this,params:a});this.lnbSettingDialog.open();return},createCountryStore:function(){this.defCountryValue=["country_value",_VST("action","select_country")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defCountryValue]});this.addManagedComponent(a);return a},createRegionStore:function(){this.defRegionValue=["region_value",_VST("action","select_region")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[this.defRegionValue]});this.addManagedComponent(a);return a},createModelStore:function(){this.defmodelValue=["region_value",_VST("dtvtscan","pls_select_model")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[this.defmodelValue]});this.addManagedComponent(a);return a},createSatelliteStore:function(){this.defmodelValue=["satellite_value",_VST("dtvsscan","pls_select_satellite")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display","preset"],data:[this.defmodelValue]});this.addManagedComponent(a);return a},createLnbStore:function(){this.defmodelValue=["lnb_value",_VST("dtvsscan","pls_select_lnb")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[this.defmodelValue]});this.addManagedComponent(a);return a},getConfigDone:function(a,c,b){if(c&&c.select_country&&c.select_region){this.SelectCountry=c.select_country;this.SelectRegion=c.select_region}else{if(c&&c.select_satellite&&c.select_lnb){this.SelectCountry=c.select_satellite;this.SelectRegion=c.select_lnb}else{this.SelectCountry=undefined;this.SelectRegion=undefined}}if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")){this.modelCombo.show();this.RegionCombo.hide()}else{this.modelCombo.hide();this.RegionCombo.show()}this.getCountry()},getCountry:function(){var a=(this.tunerInfo.type==this.tunerType.FE_QPSK)?"get_satellite":"getcountry";SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,a,this.ChannelScanAPIVerion,{tuner:this.tunerInfo.id},this.getCountryDone,this)},getCountryDone:function(a,g,d){if(!a){this.alertErrorMesg(a,g,d);return}if(!g||(!g.country&&!g.satellite)){this.clearStatusBusy();return}var f=false;var e=[];var c=this.CountryCombo;if(g.satellite){e.push(["add_satellite",_VST("dtvsscan","add_satellite"),false]);e.push(["--","--",false]);Ext.each(g.satellite,function(j,h,i){if(this.SelectCountry===j.name){f=true}e.push([j.name,j.name,j.preset])},this);c=this.SatelliteCombo}else{Ext.each(g.country,function(j,h,i){if(this.SelectCountry===j){f=true}e.push([j,j])},this)}var b=c.getStore();b.loadData(e,false);if(!g.satellite){b.sort("display","ASC")}if(this.SelectCountry&&this.SelectRegion&&f){c.setValue(this.SelectCountry);if(this.tunerInfo.type==this.tunerType.FE_QPSK){this.setSatelliteEditBtn()}this.getRegion(this.SelectCountry)}else{this.clearStatusBusy()}},getRegion:function(b){var c=(this.tunerInfo.type==this.tunerType.FE_QPSK)?"get_lnb":"getregion";var a={tuner:this.tunerInfo.id};if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.satellite=b}else{a.country=b}SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,c,this.ChannelScanAPIVerion,a,this.getRegionDone,this)},getRegionDone:function(b,g,f){var c,a,d=false;var e=[];this.clearStatusBusy();if(!b){this.alertErrorMesg(b,g,f);return}if(g.lnb){this.lnbData=g.lnb;c=this.LnbCombo.getStore();this.lnbData.sort(function(i,h){var k=i.name,j=h.name;return(k>j)?1:((j>k)?-1:0)});e.push(["add_lnb",_VST("dtvsscan","add_lnb")]);e.push(["--","--"]);Ext.each(this.lnbData,function(j,h,i){if(!a){a=j.name}if(this.SelectRegion&&j.name==this.SelectRegion){d=true}e.push([j.name,j.name])},this);c.loadData(e,false);this.sortLnbCombo(c);if(this.SelectRegion&&d){this.LnbCombo.setValue(this.SelectRegion);this.LnbSettingBtn.setDisabled(false)}else{if(a){this.LnbCombo.setValue(a);this.LnbSettingBtn.setDisabled(false)}else{this.LnbCombo.setValue("--");this.LnbSettingBtn.setDisabled(true)}}}else{if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")){c=this.modelCombo.getStore();this.modelCombo.setValue([]);Ext.each(g.region,function(j,h,i){if(!a){a=j}if(this.SelectRegion&&j===this.SelectRegion){d=true}e.push([j,j])},this);c.loadData(e,false);c.sort("display","ASC");if(this.SelectRegion&&d){this.modelCombo.setValue(this.SelectRegion)}else{this.modelCombo.setValue(a)}}else{c=this.RegionCombo.getStore();this.RegionCombo.setValue([]);Ext.each(g.region,function(j,h,i){if(!a){a=j}if(this.SelectRegion&&j===this.SelectRegion){d=true}e.push([j,j])},this);c.loadData(e,false);c.sort("display","ASC");if(this.SelectRegion&&d){this.RegionCombo.setValue(this.SelectRegion)}else{this.RegionCombo.setValue(a)}}}},onChangeCountry:function(c,a,b){this.SelectRegion=null;this.getRegion(a.data.value);if(this.tunerInfo.type==this.tunerType.FE_QPSK){this.setSatelliteEditBtn()}},beforeSatelliteSelect:function(c,a,b){if("add_satellite"==a.data.value){this.addSatellite();c.collapse();return false}if("--"==a.data.value){return false}return true},beforeLnbSelect:function(c,a,b){if("add_lnb"==a.data.value){this.launchLnbSettingDialog("add_lnb");c.collapse();return false}if("--"==a.data.value){return false}return true},setSatelliteEditBtn:function(){var c=this.SatelliteCombo.value;var a=this.SatelliteCombo.getStore();var b=a.data.map[c].data.preset;return this.SatelliteBtn.setDisabled(b)},addSatellite:function(){var a=new SYNO.SDS.VideoStation.SatelliteDialog({owner:this,satellite:""});a.open()},setComboToDefault:function(){var d=[],c=[],b=[],a;d.push(this.defCountryValue);a=this.CountryCombo.getStore();a.loadData(d,false);this.CountryCombo.setValue("country_value");c.push(this.defRegionValue);a=this.RegionCombo.getStore();a.loadData(c,false);this.RegionCombo.setValue("region_value");b.push(this.defmodelValue);a=this.modelCombo.getStore();a.loadData(b,false);this.modelCombo.setValue("region_value")},sortLnbCombo:function(a){a.remove(a.data.map["--"]);a.remove(a.data.map.add_lnb);a.sort("display","ASC");var b=[new a.recordType({value:"add_lnb",display:_VST("dtvsscan","add_lnb")},"add_lnb"),new a.recordType({value:"--",display:"--"},"--")];a.insert(0,b)},alertErrorMesg:function(a,d,c){this.clearStatusBusy();if(d.code&&d.code<400){this.getMsgBox().alert(_VST("action","channelscan"),SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(d.code);this.getMsgBox().alert(_VST("action","channelscan"),b)}}});Ext.define("SYNO.SDS.VideoStation.SatelliteDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.init(a);this.callParent([this.fillConfig(a)])},init:function(a){this.owner=a.owner;this.satellite=a.satellite;this.method=(!this.satellite)?"create_satellite":"edit_satellite";Ext.form.VTypes.normalname=/^[^\:"<>\*\\\/\|\?\,]*$/;Ext.form.VTypes.only_dash=/^-+$/},fillConfig:function(a){var c=new SYNO.ux.FormPanel(SYNO.LayoutConfig.fill({fileUpload:false,labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:false,labelWidth:100,items:[{xtype:"syno_textfield",fieldLabel:_T("common","name"),name:"name",allowBlank:false,maxLength:32,width:189,value:this.satellite,stripCharsRe:/(^\s+|\s+$)/g,validator:function(d){return Ext.form.VTypes.normalname.test(d)&&!Ext.form.VTypes.only_dash.test(d)}},{xtype:"syno_textfield",name:"satellite",value:this.satellite,hidden:true}]}));var b={title:(!this.satellite)?_VST("dtvsscan","add_satellite"):_VST("dtvsscan","edit_satellite"),width:400,height:140,minWidth:300,minHeight:100,layout:"fit",buttons:[{btnStyle:"red",text:_T("common","delete"),scope:this,disabled:_S("demo_mode"),hidden:!_S("is_admin")||(!this.satellite),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onDelete},{btnStyle:"blue",text:_T("common","ok"),scope:this,disabled:_S("demo_mode"),hidden:!_S("is_admin"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onSave},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:[10,13],scope:this,handler:this.onSave},{key:27,scope:this,handler:this.onCancel}],items:[c],listeners:{scope:this,beforeshow:this.beforeShow}};Ext.apply(b,a);return b},beforeShow:function(){this.alignTo(this.owner.el,"tl-tl",[50,50]);if(!this.satellite){var a=this.items.get(0).getForm();a.findField("name").clearInvalid()}return},onDelete:function(){if(!this.satellite){return}this.getMsgBox().confirm(this.title,_VST("dtvsscan","delete_cfrmrm"),function(a){if("yes"===a){SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,"delete_satellite",this.owner.ChannelScanAPIVerion,{satellite:this.satellite,tuner:this.owner.tunerInfo.id},this.onDeleteDone,this)}},this)},onDeleteDone:function(a,e,d){if(!a){this.owner.alertErrorMesg(a,e,d)}else{var c=this.owner.SatelliteCombo;var b=c.getStore();b.remove(b.data.map[this.satellite]);this.sortSatelliteCombo(b);c.setValue(b.getAt(2).data.value);this.owner.setSatelliteEditBtn();this.owner.getRegion(b.getAt(2).data.value)}this.close()},onSave:function(){var a=this.items.get(0).getForm();if(!a.isValid()){return}if(!a.isDirty()){this.close();return}a.submit({url:this._getWebAPIURL(this.owner.APIUrl),params:{method:this.method,version:this.owner.ChannelScanAPIVerion,api:this.owner.ChannelScanAPI,tuner:this.owner.tunerInfo.id},failure:function(d,e){if(e.result.error&&e.result.error.code){var c=e.result.error.code;var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(c);this.getMsgBox().alert(_VST("action","channelscan"),b)}},success:function(d,e){if(!e||!e.result){return}var c=d.findField("name").getValue();var f=this.owner.SatelliteCombo;var b=f.getStore();if(this.satellite){b.remove(b.data.map[this.satellite])}b.add(new b.recordType({value:c,display:c,preset:false},c));this.sortSatelliteCombo(b);f.setValue(c);this.owner.setSatelliteEditBtn();this.owner.getRegion(c);this.close()},scope:this});return},onCancel:function(){var a=this.items.get(0).getForm();if(!a.isDirty()){this.close();return}this.getMsgBox().confirm(_VST("action","channelscan"),_T("common","confirm_lostchange"),function(b){if("yes"===b){this.close()}},this)},sortSatelliteCombo:function(a){var b=[a.getAt(0),a.getAt(1)];a.removeAt(0);a.removeAt(0);a.sort("display","ASC");a.insert(0,b);return}});Ext.define("SYNO.SDS.VideoStation.ChannelEditDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.tunerInfo=a.tunerInfo;this.callParent([this.fillConfig(a)]);this.addManagedComponent(a.store)},fillConfig:function(a){var b={owner:a.owner,width:420,height:580,cls:"syno-vs-video-channel-edit-dialog",title:_VST("action","channeledit"),layout:"fit",items:[this.panel=new SYNO.SDS.VideoStation.ChannelEditPanel({owner:this,store:a.store})],buttons:[{text:_T("common","save"),btnStyle:"blue",scope:this,handler:this.hSave},{text:_T("common","close"),scope:this,handler:this.hClose}]};return b},hSave:function(){if(!this.panel.isChannelChanged){this.close();return}this.setStatusBusy();var a=[];this.panel.store.each(function(c){var d={};d.id=c.get("id");d.title=c.get("title");d.scrambled=c.get("scrambled");a.push(d)},this);var b={tuner:this.tunerInfo.id,channels:Ext.encode(a)};SYNO.API.currentManager.requestAPI("SYNO.DTV.Channel","edit",1,b,this.onSaveDone,this)},onSaveDone:function(a,e,c){this.clearStatusBusy();if(!a){var d="";if(e.code<400){d=SYNO.API.CheckResponse(a,e,c)}else{d=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(e.code)}this.setStatusError({text:d,clear:true})}else{if(Ext.isDefined(this.owner.ProgramScheduleTabpanel)){this.owner.ProgramScheduleTabpanel.ProgramGuidePanel.reloadChannels()}else{var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.DTVHomePage");b.getStore().load()}this.close()}},hClose:function(){if(this.panel.isChannelChanged){this.getMsgBox().confirm("",_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this)}else{this.close()}}});Ext.define("SYNO.SDS.VideoStation.ChannelEditPanel",{extend:"SYNO.ux.GridPanel",isChannelChanged:false,constructor:function(a){this.callParent([this.fillConfig(a)]);this.mon(this.getSelectionModel(),"selectionchange",this.hSelectionChange,this)},fillConfig:function(a){var b={owner:a.owner,cls:"syno-vs-grid",enableDragDrop:true,ddGroup:"ChannelListDD",tbar:this.getTopToolbar(),cm:this.getColumnModel(),store:a.store,bbar:this.getBottomToolbar(),listeners:{scope:this,viewready:this.onGridViewReady,afterrender:this.onGridAfterRender,rowclick:this.onGridRowClick,rowdblclick:this.onEditChannel,destroy:this.onGridDestroy}};return b},getTopToolbar:function(){if(this.topToolbar){return this.topToolbar}this.topToolbar=new SYNO.ux.Toolbar({items:[this.deleteBtn=new SYNO.ux.Button({text:_T("common","delete"),scope:this,disabled:true,handler:this.onDeleteChannel}),this.editBtn=new SYNO.ux.Button({text:_VST("action","rename"),scope:this,disabled:true,handler:this.onEditChannel})]});return this.topToolbar},getBottomToolbar:function(){if(this.bottomToolbar){return this.bottomToolbar}this.bottomToolbar=new SYNO.ux.Toolbar({items:[{xtype:"syno_displayfield",value:'<span class="syno-ux-note">'+_VST("common","hint")+":</span> "+_VST("action","drag_drop_channels")}]});return this.bottomToolbar},getColumnModel:function(){if(this.columnModel){return this.columnModel}this.columnModel=new Ext.grid.ColumnModel([{header:_VST("schedule","channel"),dataIndex:"title",sortable:false,renderer:function(d,a,c){var b=c.get("scrambled");d=Ext.util.Format.htmlEncode(d);if(!b){return d}else{return'<div class="syno-vs-channel-encrypted">'+d+"</div>"}}}]);return this.columnModel},onDeleteChannel:function(){var a=_VST("action","remove_confirm");this.owner.getMsgBox().confirmDelete("",a,this.deleteChannels,this)},onEditChannel:function(){var c=this.getSelectionModel();var a=c.getSelections();var d=a[0].get("title");var b=new SYNO.SDS.VideoStation.ChannelNameEditDialog({owner:this.owner,channel:d});b.open()},deleteChannels:function(c){if("no"===c){return}var d=this.getSelectionModel();var a=d.getSelections();var b;for(b=0;b<a.length;++b){this.store.remove(a[b])}this.isChannelChanged=true},onGridViewReady:function(){this.view.updateScroller()},onGridAfterRender:function(a){if(!this.ChannelDropTarget){this.ChannelDropTarget=new SYNO.SDS.VideoStation.ChannelListDropTarget(a,{panel:a,ddGroup:"ChannelListDD"})}},onGridRowClick:function(a,c,b){if(b&&c&&!b.hasModifier()){a.getSelectionModel().selectRow(c)}},onGridDestroy:function(){if(this.ChannelDropTarget){this.ChannelDropTarget.removeFromGroup(this.ddGroup)}},hSelectionChange:function(){var c=this.getSelectionModel();var b=c.getCount();var a=b!==0;var d=b===1;if(a){this.deleteBtn.enable()}else{this.deleteBtn.disable()}if(d){this.editBtn.enable()}else{this.editBtn.disable()}}});Ext.define("SYNO.SDS.VideoStation.ChannelNameEditDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:a.owner,width:350,height:140,title:_VST("action","rename"),items:[this.panel=new SYNO.ux.FormPanel({owner:this,items:[this.channelField=new SYNO.ux.TextField({width:300,maxLength:32,maskRe:/[^\:]/,hideLabel:true,value:a.channel})]})],buttons:[{text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.hApply},{text:_T("common","cancel"),scope:this,handler:this.close}]};return b},hApply:function(){if(!this.panel.getForm().isDirty()){this.close();return}if(!this.panel.getForm().isValid()){return}var a=this.channelField.getValue();a=a.replace(/:/g,"_");this.owner.panel.isChannelChanged=true;var b=this.owner.panel.getSelectionModel();var c=b.getSelections()[0];c.set("title",a);c.commit();this.close()}});SYNO.SDS.VideoStation.ChannelListDropTarget=function(a,b){this.ddTarget=a;this.store=a.store;SYNO.SDS.VideoStation.ChannelListDropTarget.superclass.constructor.call(this,a.container,b)};Ext.extend(SYNO.SDS.VideoStation.ChannelListDropTarget,Ext.dd.DropTarget,{ddTarget:null,store:null,notifyDrop:function(j,g,c){var f=-1,a=this.ddTarget,d,k,h,b=new Date().getTime();if(b<this.dropTargetLastTime+500){return false}else{this.dropTargetLastTime=b}f=a.view.findRowIndex(g.getTarget());if(false===f){j.endDrag();return false}k=c.selections;for(d=0;d<k.length;d++){this.store.remove(k[d]);if(0===d){h=f}else{h=this.store.indexOf(k[d-1])+1}this.store.insert(h,k[d]);a.isChannelChanged=true}a.selModel.selectRecords(k);j.endDrag();return true}});Ext.define("SYNO.SDS.VideoStation.StreamHintDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(b){this.port=b.port;this.tuner=b.tuner;this.channel=b.channel;var a={title:_VST("action","program_guide"),width:660,height:250,layout:"fit",items:[this.getForm()],buttons:[this.playbtn=new SYNO.ux.Button({btnStyle:"blue",text:_VST("action","play"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.DTVUtil.ableToPlayDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:function(){SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{dtv_url:this.stream_url,title:this.channel})}}),{text:_T("common","close"),scope:this,handler:function(){this.close()}}],listeners:{scope:this,show:function(){var c=this.getForm().getForm().findField("url");c.selectText(0,c.length)}}};this.callParent([Ext.apply(a,b)])},getUrlID:function(){if(this.url_id){return this.url_id}this.url_id=Ext.id();return this.url_id},getForm:function(){if(this.form){return this.form}this.stream_url=String.format("{0}//{1}:{2}/VideoStation/livestreaming/{3}",window.location.protocol,window.location.hostname,window.location.port,Ext.isNumber(this.tuner)?this.tuner:0);this.form=new SYNO.ux.FormPanel({items:[{xtype:"syno_displayfield",value:_VST("streaming","streaming_open_ok")},{xtype:"syno_textfield",fieldLabel:_VST("streaming","streaming_url"),cls:"selectabletext allowDefCtxMenu",readOnly:true,width:400,name:"url",id:this.getUrlID(),value:this.stream_url},{xtype:"syno_displayfield",value:String.format(_VST("streaming","streaming_description"),this.port)}]});return this.form}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.ProgramGuideListPanel",{extend:"SYNO.ux.Panel",constructor:function(a){Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.DefaultChannel={title:_VST("schedule","channel"),type:"category",scrambled:false,id:"0@0"};this.dataview=new SYNO.SDS.VideoStation.ListDataView({desc_key:"title",store:this.getStore(),getItemClass:function(d){var c=d.type;if(d.scrambled){c+=" lock"}return c},listeners:{beforeclick:function(d,e,f,c){var g=d.getRecord(f);return("category"===g.get("type"))?false:true},selectionchange:{buffer:100,scope:this,fn:this.onListSelect}}});var b={cls:"syno-vs-dtv-channellist",width:SYNO.SDS.VideoStation.ListDataView.ViewWidth,layout:"fit",items:this.dataview};return Ext.apply(b,a)},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.JsonStore({data:{channels:[this.DefaultChannel]},autoLoad:false,root:"channels",fields:["title","id","scrambled",{name:"type",defaultValue:"item"}]});return this.store},onListSelect:function(b,a){if(0==a.length){return}var e=this.dataview.getRecord(a[0]);var f=e.get("id");if("epgsearchresult"===f){this.isAtChannlelist=false;if(!this.module.ProgramGuidePanel.ProgramGrid.isNewSearch){this.module.ProgramGuidePanel.ProgramGrid.doSearch()}this.module.btnStream.setDisabled(true);var d=this.module.ProgramGuidePanel.ProgramGrid;if(d.programGuideStatus){d.programGuideStatus.stop()}if(d.programGuideStatusForSearch){d.programGuideStatusForSearch.stop()}d.Bbar.hide();d.doLayout();return}this.changeProgramList(f);var c=Ext.get(this.dataview.getNode(e));if(c.getY()<this.dataview.getEl().getY()||c.getY()>this.dataview.getEl().getY()+this.dataview.getHeight()){this.dataview.focusNode(e)}},changeProgramList:function(a){var b;if(!a){return}this.isAtChannlelist=true;b=this.module.ProgramGuidePanel.ProgramGrid;if(b.programGuideStatus){b.programGuideStatus.stop()}if(b.programGuideStatusForSearch){b.programGuideStatusForSearch.stop()}b.isNewSearch=false;b.Bbar.show();this.module.ProgramGuidePanel.ProgramGrid.doLayout();b.getColumnModel().setConfig(b.ChannelCM,false);b.clearProgramStatus();b.ServiceID=a;this.module.owner.setStatusBusy({text:_T("common","loading")});b.store.load()},channelListDone:function(i,e,c){var l,f,j,a,k;var h=_VST("action","unknown_channel");var g="Unknown";this.module.owner.clearStatusBusy();if(!i){if(e.code<400){this.module.owner.getMsgBox().alert(_VST("schedule","channel"),SYNO.API.CheckResponse(i,e,c))}else{if(403==e.code&&!this.EmptyChannelScanAsked){this.EmptyChannelScanAsked=true;this.launchChannelScanDialog()}else{var n=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(e.code);this.module.owner.getMsgBox().alert(_VST("schedule","channel"),n)}}}else{if(e.channels&&0===e.channels.length){this.module.owner.getMsgBox().alert(_VST("schedule","channel"),_VST("error","dtv_channeltable_not_found"))}}l=this.store;j=this.DefaultChannel;f={channels:[j]};Ext.each(e.channels,function(q,o,p){if(!a||q.id===this.channelID){a=q.id}if(g===q.title){k=h}else{k=q.title}j={title:k,id:q.id,scrambled:q.scrambled,type:"item"};f.channels.push(j)},this);l.loadData(f,false);if(a){var d=this.getCurrentRecord();if(!d){var b=this.dataview.store.getById(a);this.dataview.select(b)}this.module.btnStream.setDisabled(false||_S("demo_mode"));this.module.btnUpdateEPG.setDisabled(false||_S("demo_mode"));this.recordmenu.getComponent("userdefine_record").setDisabled(false||_S("demo_mode"));this.module.btnDeleteallchannels.setDisabled(false||_S("demo_mode"))}else{var m=this.module.ProgramGuidePanel.ProgramGrid;if(m.getEl().isMasked()){m.getEl().unmask()}this.recordmenu.getComponent("userdefine_record").setDisabled(true);this.module.btnDeleteallchannels.setDisabled(true)}},stream:function(){this.module.owner.setStatusBusy();SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","setchannel","1",{id:this.getCurrentRecord().id,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.streamDone,this)},streamDone:function(a,c,b){this.module.owner.clearStatusBusy();if(!a){this.module.owner.getMsgBox().alert(_VST("action","program_guide"),SYNO.API.CheckResponse(a,c,b))}else{this.module.owner.owner.mainpanel.mainCardPanel.cardPanel.tunerStatus.restart();this.ChannelName=this.getCurrentRecord().get("title");this.createSteamMsgWindow().open()}},createSteamMsgWindow:function(){var a=9025;if(Ext.isDefined(this.tunerInfo)){a=this.tunerInfo.id%16+a}return new SYNO.SDS.VideoStation.StreamHintDialog({owner:this.module.owner,port:a,tuner:this.tunerInfo.id,channel:this.ChannelName})},requesUpdateEPG:function(){var a=this.module.ProgramGuidePanel.ProgramGrid;if(a.getEl().isMasked()){a.getEl().unmask()}this.module.getEl().mask(_VST("programguide","updating_epg"),"x-mask-loading");SYNO.API.currentManager.requestAPI("SYNO.DTV.Program","update","1",{id:this.getCurrentRecord().id,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.updateEPGDone,this)},updateEPGDone:function(a,d,c){if(!a){this.module.getEl().unmask();var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(d.code);this.module.owner.getMsgBox().alert(_VST("action","program_guide"),b)}else{if(!this.programGuideStatus){this.programGuideStatus=this.module.owner.addAjaxTask({id:"updateGuideStatusPollingTask",interval:5000,autoJsonDecode:true,url:this.module.owner._getWebAPIURL("tuner.cgi"),params:{api:"SYNO.DTV.Tuner",method:"getinfo",version:"1",id:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},success:this.updateGuideStatusDone,failure:function(e,f){this.module.getEl().unmask();SYNO.Debug("Ajax load failure ",e)},scope:this})}this.programGuideStatus.restart()}},updateGuideStatusDone:function(b,c){if(!b.success||!b.data||!b.data.tuners||!b.data.tuners.status||"ready"===b.data.tuners.status){this.module.getEl().unmask();this.programGuideStatus.stop();var a=this.module.ProgramGuidePanel.ProgramGrid;a.store.load()}},launchChannelScanDialog:function(){if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("dtv","error_disabled"));return}if(!this.dialogChannelScan){this.dialogChannelScan=new SYNO.SDS.VideoStation.ChannelScanDialog({owner:this.module.owner,tunerInfo:this.tunerInfo})}this.dialogChannelScan.open()},launchChannelEditDialog:function(){if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("dtv","error_disabled"));return}var b=[];this.store.each(function(d){if("item"===d.get("type")&&/\d@\d/.test(d.get("id"))){b.push(d.copy())}});var a=new Ext.data.Store({recordType:this.store.recordType});a.add(b);var c=new SYNO.SDS.VideoStation.ChannelEditDialog({owner:this.module.owner,store:a,tunerInfo:this.tunerInfo});c.show()},delteAllChannels:function(){var b="delete_all_channels";var a={tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)};this.module.owner.getMsgBox().confirm(_VST("schedule","channel"),_VST("action","delete_all_channels_confirm"),function(c){if("yes"===c){this.module.getEl().mask(_VST("common","deleting"),"x-mask-loading");SYNO.API.currentManager.requestAPI(this.module.owner.Channel_API,b,this.module.owner.Channel_APIVerion,a,this.delteAllChannelsDone,this)}},this)},delteAllChannelsDone:function(a,c,b){if(this.module.getEl().isMasked()){this.module.getEl().unmask()}if(!a){this.module.owner.getMsgBox().alert(_VST("schedule","channel"),_VST("action","delete_all_channels_failed"))}else{this.module.owner.getMsgBox().alert(_VST("schedule","channel"),_VST("action","delete_all_channels_completed"),function(){this.module.ProgramGuidePanel.reloadChannels();this.module.ProgramGuidePanel.ProgramGrid.store.removeAll();this.module.ProgramGuidePanel.ProgramGrid.dayComponentShow(false)},this)}this.recordmenu.getComponent("userdefine_record").setDisabled(true);this.module.btnStream.setDisabled(true);this.module.btnUpdateEPG.setDisabled(true);this.module.btnDeleteallchannels.setDisabled(true)},getCurrentRecord:function(){return this.dataview.getSelectedRecords()[0]}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.RepeatScheduleDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){Ext.apply(this,a||{});this.defineBehaviors();var b=this.fillConfig(a);SYNO.SDS.VideoStation.RepeatScheduleDialog.superclass.constructor.call(this,b)},fillConfig:function(a){this.RepeatScheduleFormpanel=new SYNO.SDS.VideoStation.RepeatScheduleFormpanel({owner:this,itemId:"RepeatScheduleFormpanel"});this.pragramstore=this.owner.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramGrid.store;this.schedulestore=this.owner.ProgramScheduleTabpanel.ProgramScheduleGridPanel.store;var b={owner:this.owner,width:430,height:480,minWidth:420,minHeight:450,title:_VST("schedule","schedule"),layout:"fit",items:[this.RepeatScheduleFormpanel],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this.RepeatScheduleFormpanel,handler:this.RepeatScheduleFormpanel.Apply},{text:_T("common","close"),scope:this,handler:this.onCloseDialog}],keys:[{key:[10,13],scope:this.RepeatScheduleFormpanel,handler:this.RepeatScheduleFormpanel.Apply},{key:27,scope:this,handler:this.onCloseDialog}]};Ext.apply(b,a);return b},onCloseDialog:function(){var a=this.RepeatScheduleFormpanel.getForm();if(a.isDirty()&&this.loadsetting){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close()}},this)}else{this.close()}},defineBehaviors:function(){}});Ext.define("SYNO.SDS.VideoStation.RepeatScheduleFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.owner=a.owner;var d="";for(var c=0;c<this.owner.weekdaystatus.length;c++){if(this.owner.weekdaystatus[c]){d+=(0==d.length)?"":",";d+=c}}var b={owner:this.owner,border:false,trackResetOnLoad:true,deferredRender:false,labelWidth:150,items:[{xtype:"syno_displayfield",itemId:"channelname",fieldLabel:_VST("schedule","channel"),value:this.owner.channel_name},{xtype:"syno_displayfield",itemId:"programtitle",fieldLabel:_VST("programguide","title"),value:this.owner.program_title},{xtype:"syno_combobox",fieldLabel:_VST("repeat","repeat"),triggerAction:"all",resizable:false,store:this.createRepeatCycleStore(),editable:false,displayField:"display",valueField:"value",value:this.owner.isweekly?"weekly":"daily",mode:"local",name:"repeat_cycle",listeners:{scope:this,select:this.onChangeRepeatCycle}},{fieldLabel:_VST("repeat","repeat_data"),width:189,name:"repeat_days",xtype:"syno_superboxselect",allowAddNewData:false,editable:false,resizable:true,store:this.createDaysStore(),mode:"local",grow:false,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"display",valueField:"value",value:d,allowBlank:false,settingValue:false,listeners:{beforeremoveitem:function(h,g,i){var e=new Date(this.owner.start_date).getDay();return h.settingValue||(e!==g)},scope:this},resetStore:function(){this.store.clearFilter();if(!this.removeValuesFromStore){return this}this.usedRecords.each(function(e){this.store.add(e)},this);this.usedRecords.clear();this.store.sort(this.valueField,"ASC");return this}},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_displayfield",width:150,value:_VST("repeat","end_day")+_T("common","colon")},{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_never"),inputValue:"never",name:"end_never",checked:(this.owner.end_date&&this.owner.end_date!=="1")?false:true,listeners:{scope:this,check:function(e,f){this.getForm().findField("end_on").setValue(!f);this.getForm().findField("end_value").setDisabled(f)}}}]},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_displayfield",width:150,value:""},{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_on"),inputValue:"on",name:"end_on",checked:(this.owner.end_date&&this.owner.end_date!=="1")?true:false,listeners:{scope:this,check:function(e,f){this.getForm().findField("end_never").setValue(!f)}}},{xtype:"syno_datefield",format:"Y-m-d",name:"end_value",editable:false,allowBlank:false,value:((this.owner.end_date&&this.owner.end_date!=="1")?this.owner.end_date:this.owner.start_date),disabled:(this.owner.end_date&&this.owner.end_date!=="1")?false:true,preFocus:function(){this.el.blur()},validator:(function(f){var g=f.substring(0,4)+f.substring(5,7)+f.substring(8,10);var e=this.owner.start_date.substring(0,4)+this.owner.start_date.substring(5,7)+this.owner.start_date.substring(8,10);if(parseInt(g,10)<parseInt(e,10)){return _VST("repeat","repeat_endday_error")}return true}).createDelegate(this)}]}]};Ext.apply(b,a);SYNO.SDS.VideoStation.RepeatScheduleFormpanel.superclass.constructor.call(this,b)},createDaysStore:function(){var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[[0,_VST("repeat","schedule_sun")],[1,_VST("repeat","schedule_mon")],[2,_VST("repeat","schedule_tue")],[3,_VST("repeat","schedule_wed")],[4,_VST("repeat","schedule_thu")],[5,_VST("repeat","schedule_fri")],[6,_VST("repeat","schedule_sat")]]});return a},createRepeatCycleStore:function(){var a=new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:[["weekly",_VST("repeat","repeat_weekly")],["daily",_VST("repeat","repeat_daily")]]});return a},onChangeRepeatCycle:function(d,a,b){var c=this.getForm().findField("repeat_days");if("daily"===a.data.value){c.settingValue=true;c.setValue("0,1,2,3,4,5,6");c.settingValue=false;c.setDisabled(true)}else{c.reset();c.setDisabled(false)}},Apply:function(){var h=false;var d=this.getForm();if(!d.isValid()){return}var f=d.findField("repeat_cycle").getValue();var i=d.findField("repeat_days").getValueEx();var j=d.findField("end_never").getValue();var a=d.findField("end_value").getValue();var b;if(j){b=1}else{b=a.getFullYear()+"-"+SYNO.SDS.VideoStation.DTVUtil.modifyHM(a.getMonth()+1)+"-"+SYNO.SDS.VideoStation.DTVUtil.modifyHM(a.getDate());if(0===a.length){this.owner.getMsgBox().alert(this.owner.title,_VST("repeat","repeat_endday_empty"));return}var c=b.substring(0,4)+b.substring(5,7)+b.substring(8,10);var g=this.owner.start_date.substring(0,4)+this.owner.start_date.substring(5,7)+this.owner.start_date.substring(8,10);if(parseInt(c,10)<parseInt(g,10)){this.owner.getMsgBox().alert(this.owner.title,_VST("repeat","repeat_endday_error"));return}}if("weekly"===f){h=true}this.owner.weekdaystatus=[0,0,0,0,0,0,0];i.each(function(k){this.owner.weekdaystatus[k.value]=1},this);var e;this.owner.setStatusBusy({text:_T("common","saving")});if(this.owner.loadsetting){e={id:this.owner.id,start_time:this.owner.start_time,isweekly:h,weekdaystatus:this.owner.weekdaystatus.join(","),end_date:b,tuner:Ext.isDefined(this.owner.tunerInfo)?this.owner.tunerInfo.id:0};SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","edit_repeat","1",e,this.ApplyDone,this)}else{e={id:this.owner.id,channel_name:this.owner.channel_name,start_time:this.owner.start_time,start_date:this.owner.start_date,duration:this.owner.duration,title:this.owner.program_title,description:this.owner.description,weekday:this.owner.weekday,isweekly:h,weekdaystatus:this.owner.weekdaystatus.join(","),end_date:b,tuner:Ext.isDefined(this.owner.tunerInfo)?this.owner.tunerInfo.id:0};SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","create_repeat","1",e,this.ApplyDone,this)}},ApplyDone:function(a,d,c){this.owner.clearStatusBusy();if(!a){if(d.code<400){this.owner.getMsgBox().alert(this.owner.title,SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(d.code);if(406===d.code){this.owner.getMsgBox().alert(this.owner.title,b,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").launchSettingDialog(1)},this)}else{this.owner.getMsgBox().alert(this.owner.title,b)}}}else{if(!this.owner.loadsetting){this.owner.pragramstore.load({params:{start:0,limit:-1}})}else{this.owner.schedulestore.reload()}this.owner.close()}}});Ext.define("SYNO.SDS.VideoStation.ProgramGuideGridPanel",{extend:"SYNO.ux.GridPanel",ServiceID:0,Today:null,ShowDay:null,Timezone:null,constructor:function(a){Ext.apply(this,a||{});this.BaseUrl=this.module.owner.owner.jsConfig.jsBaseURL;var b=this.createStore();this.callParent([this.fillConfig(a,b)])},fillConfig:function(a,b){this.ChannelCM=[{id:"schedule",header:_VST("schedule","schedule"),dataIndex:"schedule",width:150,align:"left",renderer:this.scheduleRenderer.createDelegate(this)},{id:"event_name",header:_VST("programguide","title"),dataIndex:"title",width:220,align:"left",renderer:this.titleDesRender.createDelegate(this)},{id:"text_name",header:_VST("programguide","description"),dataIndex:"description",width:230,align:"left",renderer:this.titleDesRender.createDelegate(this)}];this.SearchCM=[{id:"channelname",header:_VST("schedule","channel"),dataIndex:"channel_name",width:90,align:"left",sortable:true,renderer:this.scheduleRenderer.createDelegate(this)},{id:"event_name",header:_VST("programguide","title"),dataIndex:"title",width:140,align:"left",sortable:true,renderer:this.titleDesRender.createDelegate(this)},{id:"text_name",header:_VST("programguide","description"),dataIndex:"description",width:180,align:"left",renderer:this.titleDesRender.createDelegate(this)},{id:"start",header:_T("common","start"),dataIndex:"start",width:140,align:"left",sortable:true,renderer:this.startRenderer.createDelegate(this)},{id:"duration",header:_VST("schedule","duration"),dataIndex:"duration",width:80,align:"left",renderer:this.durationRender.createDelegate(this)}];var c={cls:"syno-vs-dtv-program-grid",border:false,bbar:this.Bbar=this.createBBar(),getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},stripeRows:true,split:false,enableColumnMove:false,enableColLock:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,sm:new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{scope:this,selectionchange:function(h){var e=this.getSelectionModel().getSelections();var g=true,f=true;var d=this.getAllowedRecordes("recorde",e);if(d&&0<d.length){g=false}d=this.getAllowedRecordes("remove",e);if(d&&0<d.length){f=false}this.recordmenu.getComponent("record").setDisabled((_S("demo_mode")||g));this.btnRemove.setDisabled(f)}}}),loadMask:true,store:b,colModel:new Ext.grid.ColumnModel({columns:this.ChannelCM,defaults:{sortable:false,menuDisabled:false,align:"right"}}),listeners:{rowcontextmenu:function(d,h,f){},rowclick:function(d,h,f){if(f&&h&&!f.hasModifier()){d.getSelectionModel().selectRow(h)}},rowdblclick:function(d,h,f){},scope:this}};Ext.apply(c,a);b.on("load",this.onLoad,this);b.on("beforeload",this.onBeforeLoad,this);return c},createStore:function(){var a=new Ext.data.JsonStore({autoLoad:false,pruneModifiedRecords:true,totalProperty:"total",idProperty:"start_time",proxy:new SYNO.API.Proxy({api:this.module.owner.Program_API,method:"list",version:this.module.owner.Program_APIVerion,listeners:{scope:this,load:function(c,d,b){if(!d||!d.id||!d.timezone||!d.day){return}this.ServiceID=d.id;this.Timezone=d.timezone;this.ShowDay=d.day;this.WeekDayNumber=d.weekday;this.WeekDay=SYNO.SDS.VideoStation.DTVUtil.getWeekDayfromNumber(this.WeekDayNumber);if(null===this.Today){this.Today=this.ShowDay}this.isFinalProgram=false;if(0===d.programs.length){this.getEl().mask(_VST("dtvtscan","no_data"),"syno-ux-mask-info")}else{if(this.getEl().isMasked()){this.getEl().unmask()}}Ext.each(d.programs,function(g,e,f){if(g.finalprogram){this.isFinalProgram=true}},this);this.handlePreNextDay();this.Bbar.syncSize()}}}),root:"programs",fields:["channel_id","channel_name","start_time","start","schedule","weekday","duration","title","description","status"],baseParams:{start:0,limit:-1,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},listeners:{exception:function(c,d,f,b,g){this.module.owner.clearStatusBusy();var e=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(g.code);this.getEl().mask(e,"syno-ux-mask-info")},scope:this}});this.addManagedComponent(a);return a},createBBar:function(){var a=new Ext.Toolbar.TextItem({cls:"date",hidden:true});var b=[{tooltip:_T("common","prevpage"),iconCls:"previous",itemId:"preday",hidden:true,handler:this.requestPreDay,scope:this},a,{tooltip:_T("common","nextpage"),iconCls:"next",itemId:"nexday",hidden:true,handler:this.requestNexDay,scope:this}];var c=new SYNO.ux.Toolbar({cls:"syno-vs-dtv-programguide-bottombar",buttonAlign:"center",items:b});this.btnPreday=c.getComponent("preday");this.txtShowDay=a;this.btnNexday=c.getComponent("nexday");return c},scheduleRenderer:function(h,e,g,d,f,c){var b=SYNO.SDS.VideoStation.DTVUtil.programStatus(g.get("status"));e.attr=this.columeUtilRender(h,g);var a=b||"";return['<div class="'+a+'">',"<span>",h,"</span>","</div>"].join("")},titleDesRender:function(g,d,f,c,e,a){var b=Ext.util.Format.htmlEncode(g);d.attr=this.columeUtilRender(b,f);return b},columeUtilRender:function(d,c){var b="";b='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';var a=SYNO.SDS.VideoStation.DTVUtil.programStatus(c.get("status"));if("pass"===a){b+='style="color:#96A0AA;"'}else{if("scheduled"===a){b+='style="color:#1470CC;"'}else{if("repeatschedule"===a){b+='style="color:#1470CC;"'}else{b+='style="color:#3C3C3C;"'}}}return b},startRenderer:function(h,d,g,c,f,b){var a;var e=SYNO.SDS.VideoStation.DTVUtil.getWeekDayfromNumber(g.get("weekday"));if(e){e=" ("+e+")";a=h+e}else{a=h}d.attr=this.columeUtilRender(a,g);return a},durationRender:function(c,h,e,j,a,i){if(c){var g,f,d;g=SYNO.SDS.VideoStation.DTVUtil.modifyHM(c%60);f=SYNO.SDS.VideoStation.DTVUtil.modifyHM(((c-g)/60)%60);if(0<(c-(g+f*60))){d=SYNO.SDS.VideoStation.DTVUtil.modifyHM((c-(g+f*60))/3600)}else{d=SYNO.SDS.VideoStation.DTVUtil.modifyHM(0)}var b=d+":"+f+":"+g;h.attr=this.columeUtilRender(b,e);return b}},onLoad:function(c,f,d){this.module.owner.clearStatusBusy();if(c.getCount()<1){return}c.sort("start_time","ASC");this.HaveCanRecordItem=false;this.HaveRecordItem=false;if(!this.selectRow){this.selectFirsRecordRow(c)}else{this.getSelectionModel().selectRow(this.selectRow)}var b=this.getSelectionModel().getSelections();var e=b.length;var a=false;if(e===1&&"recording"===SYNO.SDS.VideoStation.DTVUtil.programStatus(b[0].get("status"))){a=true}this.recordmenu.getComponent("record").setDisabled((_S("demo_mode")||!this.HaveCanRecordItem||a));if(e===1&&!_S("demo_mode")){this.recordmenu.getComponent("repeat_record").setDisabled(false)}this.btnRemove.setDisabled(!this.HaveRecordItem);SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","getinfo","1",{id:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.getTunerInfoDone,this);c.each(function(i,h){if(1!==i.get("status")){var g=Math.floor(this.view.el.getHeight()/28);this.view.focusRow.defer(200,this.view,[Math.min(c.getCount()-1,h+Math.floor(g/2))]);return false}},this)},onBeforeLoad:function(a,b){this.getStore().removeAll();if(this.getEl().isMasked()){this.getEl().unmask()}if(0===this.ServiceID){return false}b.params.id=this.ServiceID;if(this.ShowDay){b.params.day=this.ShowDay}if(this.Timezone){b.params.timezone=this.Timezone}},clearProgramStatus:function(){this.Today=null;this.ShowDay=null;this.WeekDayNumber=0;this.WeekDay=null;this.btnPreday.setDisabled(false);this.btnNexday.setDisabled(false);this.ServiceID=0;this.dayComponentShow(false)},dayConvert:function(a){var b,d,c;b=a.substring(0,4)+"/"+a.substring(4,6)+"/"+a.substring(6,8);b=new Date(b);d=SYNO.SDS.VideoStation.DTVUtil.modifyHM((parseInt(b.getMonth(),10)+1));c=SYNO.SDS.VideoStation.DTVUtil.modifyHM(b.getDate());b=b.getFullYear()+"/"+d+"/"+c;return b},dayComponentShow:function(a){if(a){this.btnPreday.show();this.txtShowDay.show();this.btnNexday.show()}else{this.btnPreday.hide();this.txtShowDay.hide();this.btnNexday.hide()}},handlePreNextDay:function(){var a=this.dayConvert(this.ShowDay);if(this.WeekDay){a=a+" ("+this.WeekDay+")"}this.txtShowDay.setText(a);this.btnPreday.setDisabled((this.Today===this.ShowDay)?true:false);this.btnNexday.setDisabled(this.isFinalProgram);this.dayComponentShow(true)},requestDayCom:function(d){var c,e,a,b;b=new Date(this.dayConvert(this.ShowDay));if("next"===d){b=new Date(b.valueOf()+60*60*24*1000)}else{b=new Date(b.valueOf()-60*60*24*1000)}c=b.getFullYear();e=SYNO.SDS.VideoStation.DTVUtil.modifyHM((parseInt(b.getMonth(),10)+1));a=SYNO.SDS.VideoStation.DTVUtil.modifyHM(b.getDate());return(c.toString()+e.toString()+a.toString())},requestNexDay:function(){this.ShowDay=this.requestDayCom("next");this.btnNexday.setDisabled(true);this.store.load()},requestPreDay:function(){this.ShowDay=this.requestDayCom("pre");this.btnPreday.setDisabled(true);this.store.load()},selectFirsRecordRow:function(b){var a;Ext.each(b.data.items,function(e,c,d){a=SYNO.SDS.VideoStation.DTVUtil.programStatus(e.data.status);if("pass"!=a&&!this.HaveCanRecordItem){this.getSelectionModel().selectRow(c);this.firstSelectStartTime=e.data.start_time;this.HaveCanRecordItem=true}if(("scheduled"===a||"recording"===a)&&!this.HaveRecordItem){this.HaveRecordItem=true}},this)},getAllowedRecordes:function(e,c){var a=[];var d,b;for(d=0;d<c.length;d++){b=SYNO.SDS.VideoStation.DTVUtil.programStatus(c[d].get("status"));if("recorde"===e&&(""===b||"streaming"===b)){a.push(c[d].get("start_time"))}if("remove"===e&&("recording"===b||"scheduled"===b)){a.push(c[d].get("start_time"))}}return a.join(",")},checkBeforeRequest:function(){var a=true;if(_S("demo_mode")){this.module.owner.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));a=false}if(this.getStore().getTotalCount()===0){a=false}if(this.getSelectionModel().hasSelection()===false){this.module.owner.getMsgBox().alert(_VST("action","program_guide"),_VST("action","dvt_cfrm_select"));a=false}return a},requestRecord:function(){if(!this.checkBeforeRequest()){return}var b=[];var c=this.getSelectionModel().getSelections();var a=this.getAllowedRecordes("recorde",c);for(var d=0;d<c.length;d++){if(this.firstSelectStartTime===c[d].get("start_time")){this.disableBtnStream=true}if(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){b.push(c[d].get("channel_id"))}}b=b.join(",");var e;if(this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){e={id:this.ServiceID,start_time:a}}else{e={id:b,start_time:a}}e=Ext.apply({tuner:Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0},e);if(a&&0<a.length){SYNO.API.currentManager.requestAPI(this.module.owner.Schedule_API,"create",this.module.owner.Schedule_APIVerion,e,this.requestDone,this)}},getTunerInfoDone:function(a,c,b){if(!a){return}if(!c.tuners||!c.tuners.additional||!c.tuners.additional.channel_status){return}if(-1!==c.tuners.additional.channel_status.recording_id||this.disableBtnStream){this.module.btnStream.setDisabled(true)}else{this.disableBtnStream=false;this.module.btnStream.setDisabled(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist||_S("demo_mode"))}},requestDone:function(a,f,d){if(this.module.getEl().isMasked()){this.module.getEl().unmask()}var e=_VST("action","program_guide");if(!a){if(f.code<400){this.module.owner.getMsgBox().alert(e,SYNO.API.CheckResponse(a,f,d))}else{var c=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(f.code);if(406===f.code){this.module.owner.getMsgBox().alert(e,c,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").launchSettingDialog(1)},this)}else{this.module.owner.getMsgBox().alert(e,c)}}return}if(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){this.requesthDoneForSearch(d);return}this.store.load({params:{start:0,limit:-1}});this.module.btnStream.setDisabled(this.disableBtnStream||_S("demo_mode"));this.module.owner.updateStreamBtnTask.delay(15000,function(){this.module.owner.updateStreamBtn()},this);if(!this.programGuideStatus){this.programGuideStatus=this.module.owner.addAjaxTask({id:"programGuideStatusPollingTask",interval:10000,autoJsonDecode:true,url:this.module.owner.Program_APIURL,params:{api:this.module.owner.Program_API,method:"list",version:this.module.owner.Program_APIVerion,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0),start:0,limit:-1,id:this.ServiceID,timezone:this.Timezone,day:this.ShowDay},success:this.programGuideStatusDone,failure:function(g,h){SYNO.Debug("Ajax load failure ",g)},scope:this})}if("create"===d.method){var b=new Ext.util.DelayedTask();b.delay(8000,function(){this.programGuideStatus.restart()},this)}},requesthDoneForSearch:function(b){this.doSearch();if(!this.programGuideStatusForSearch){this.programGuideStatusForSearch=this.module.owner.addAjaxTask({id:"programGuideStatusPollingTaskForSearch",interval:11000,autoJsonDecode:true,url:this.module.owner.Program_APIURL,params:{api:this.module.owner.Program_API,method:"search",version:this.module.owner.Program_APIVerion,offset:0,limit:-1,keyword:this.searchkey},success:this.programGuideStatusDone,failure:function(c,d){SYNO.Debug("Ajax load failure ",c)},scope:this})}if("create"===b.method){var a=new Ext.util.DelayedTask();a.delay(8000,function(){this.programGuideStatusForSearch.restart()},this)}},generateRemoveServiceID:function(c){var b=[];var d,a;for(d=0;d<c.length;d++){a=SYNO.SDS.VideoStation.DTVUtil.programStatus(c[d].get("status"));if("recording"===a||"scheduled"===a){if(this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){b.push(this.ServiceID)}else{b.push(c[d].get("channel_id"))}}}return b.join(",")},requesRecordRemove:function(){if(!this.checkBeforeRequest()){return}var b=this.getSelectionModel().getSelections();var a=this.getAllowedRecordes("remove",b);for(var c=0;c<b.length;c++){if(this.firstSelectStartTime===b[c].get("start_time")){this.disableBtnStream=false}}if(a&&0<a.length){var d=this.generateRemoveServiceID(b);SYNO.API.currentManager.requestAPI(this.module.owner.Schedule_API,"delete",this.module.owner.Schedule_APIVerion,{id:a,channel_id:d,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}this.module.getEl().mask(_T("common","loading"),"x-mask-loading")},programGuideStatusDone:function(b,c){var d;if(b.data.programs){d=b.data.programs;this.programGuideStatus.stop()}else{if(b.data.results){d=b.data.results;this.programGuideStatusForSearch.stop()}}for(var a=0;a<d.length;a++){var e=this.getStore().getById(d[a].start_time);if(e){e.data.status=d[a].status;e.commit()}}},onSearchEPG:function(){this.searchkey=this.searchField.getValue();if(0===this.searchkey.length){this.module.owner.getMsgBox().alert(_VST("schedule","schedule"),_VST("search","search_keyword_empty"));return}this.searchkey=this.searchkey.trim();this.isNewSearch=true;this.doSearch()},doSearch:function(){if(this.isNewSearch){var a={channels:[{title:_VST("search","title"),type:"category",id:"epgsearch"},{title:_VST("search","search_result"),type:"item",id:"epgsearchresult"}]};var c=this.module.ProgramGuidePanel.ProgramList;var b=c.getStore();b.loadData(a,true);c.dataview.select(b.getCount()-1);if(c.getEl().dom){c.getEl().dom.lastChild.scrollTop=c.getEl().dom.lastChild.scrollHeight}}this.module.owner.setStatusBusy({text:_T("search","searching")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Program","search","1",{keyword:this.searchkey,offset:0,limit:-1,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.doSearchDone,this)},doSearchDone:function(a,d,c){this.getColumnModel().setConfig(this.SearchCM,false);this.module.owner.clearStatusBusy();var e;var b={programs:[]};Ext.each(d.results,function(h,f,g){e={channel_id:h.channel_id,channel_name:h.channel_name,title:h.title,description:h.description,start_time:h.start_time,duration:h.duration,start:h.start,weekday:h.weekday,status:h.status};b.programs.push(e)},this);this.store.loadData(b,false);if(0===d.results.length){this.getEl().mask(_VST("dtvtscan","no_data"),"syno-ux-mask-info")}else{if(this.getEl().isMasked()){this.getEl().unmask()}}},onRecordMenuBeforeShow:function(c){if(this.getSelectionModel().hasSelection()===false){c.getComponent("record").setDisabled(true);c.getComponent("repeat_record").setDisabled(true);return}var b=this.getSelectionModel().getSelections();var a=this.getAllowedRecordes("recorde",b);if(1===this.getSelectionModel().getCount()&&a&&0<a.length){c.getComponent("repeat_record").setDisabled(false||_S("demo_mode"))}else{c.getComponent("repeat_record").setDisabled(true)}if(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){c.getComponent("repeat_record").setDisabled(true)}},onRecordItemClick:function(f,b){var g=[];if("record"===f.itemId){this.requestRecord()}else{if("repeat_record"===f.itemId){var c=this.getSelectionModel().getSelections();for(var e=0;e<=6;e++){if(this.WeekDayNumber===e){g.push(1)}else{g.push(0)}}var a=this.ShowDay;a=a.substring(0,4)+"-"+a.substring(4,6)+"-"+a.substring(6,8);var d=new SYNO.SDS.VideoStation.RepeatScheduleDialog({owner:this.module.owner,id:this.ServiceID,channel_name:this.module.ProgramGuidePanel.ProgramList.getCurrentRecord().data.title,start_date:a,start_time:c[0].get("start_time"),duration:c[0].get("duration"),program_title:c[0].get("title"),description:c[0].get("description"),weekday:this.WeekDayNumber,isweekly:true,weekdaystatus:g,loadsetting:false,title:_VST("repeat","repeat_schedule"),tunerInfo:this.tunerInfo});d.open()}else{if("userdefine_record"===f.itemId){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","getinfo_userdefine",1,{tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0),start_time:-1},this.getUserdefineInfoDone,this)}}}},getUserdefineInfoDone:function(b,h,f){var g=_VST("schedule","schedule_recording");if(!b){if(h.code<400){this.module.owner.getMsgBox().alert(g,SYNO.API.CheckResponse(b,h,f))}else{var e=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(h.code);this.module.owner.getMsgBox().alert(g,e)}}else{if(h){var a=h.weekdaystatus.split(",");h.weekdaystatus="";for(var d=0;d<a.length;d++){if("1"==a[d]){h.weekdaystatus+=(0<h.weekdaystatus.length)?",":"";h.weekdaystatus+=d}}var c=new SYNO.SDS.VideoStation.UserDefineScheduleDialog({owner:this.module.owner,id:this.ServiceID,channel_name:this.module.ProgramGuidePanel.ProgramList.getCurrentRecord().data.title,loadsetting:(0<f.start_time),title:_VST("schedule","user_define_schedule"),data:h,tunerInfo:this.tunerInfo});c.open()}}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.UserDefineScheduleDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){Ext.apply(this,a||{});var b=this.fillConfig(a);SYNO.SDS.VideoStation.UserDefineScheduleDialog.superclass.constructor.call(this,b)},fillConfig:function(a){this.UserDefineScheduleFormpanel=new SYNO.SDS.VideoStation.UserDefineScheduleFormpanel({owner:this,itemId:"UserDefineScheduleFormpanel"});this.schedulestore=this.owner.ProgramScheduleTabpanel.ProgramScheduleGridPanel.store;var b={owner:this.owner,width:430,height:580,minWidth:420,minHeight:450,title:_VST("schedule","user_define_schedule"),layout:"fit",items:[this.UserDefineScheduleFormpanel],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this.UserDefineScheduleFormpanel,handler:this.UserDefineScheduleFormpanel.Apply},{text:_T("common","close"),scope:this,handler:this.onCloseDialog}],keys:[{key:[10,13],scope:this.UserDefineScheduleFormpanel,handler:this.UserDefineScheduleFormpanel.Apply},{key:27,scope:this,handler:this.onCloseDialog}]};Ext.apply(b,a);return b},onCloseDialog:function(){var a=this.UserDefineScheduleFormpanel.getForm();if(a.isDirty()&&this.loadsetting){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close()}},this)}else{this.close()}}});Ext.define("SYNO.SDS.VideoStation.UserDefineScheduleFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.owner=a.owner;var c=this.owner.data;var b={owner:this.owner,border:false,trackResetOnLoad:false,deferredRender:false,labelWidth:150,items:[{xtype:"syno_displayfield",fieldLabel:_VST("schedule","channel"),width:200,name:"channel_name",value:this.owner.channel_name||c.channel_name},{xtype:"syno_textfield",fieldLabel:_VST("programguide","title"),allowBlank:false,maxLength:256,width:200,value:c.title||"",name:"title"},{xtype:"syno_textfield",fieldLabel:_VST("programguide","description"),width:200,maxLength:256,value:c.description,name:"description"},{xtype:"syno_compositefield",fieldLabel:_T("common","start"),items:[{xtype:"syno_datefield",format:"Y-m-d",name:"start_date",editable:false,width:140,allowBlank:false,value:c.start_date,validator:(function(f){var d=this.owner.data.today_date;var g=f.substring(0,4)+f.substring(5,7)+f.substring(8,10);var e=d.substring(0,4)+d.substring(5,7)+d.substring(8,10);if(this.owner.loadsetting&&f==this.owner.data.start_date&&("undefined"==typeof this.form.getValues().start_time||this.form.getValues().start_time==this.owner.data.start_time)){this.gangWeekday(f);return true}if(parseInt(e,10)>parseInt(g,10)){return _VST("repeat","repeat_endday_error")}this.gangWeekday(f);return true}).createDelegate(this)},{xtype:"syno_textfield",name:"start_time",width:54,value:c.start_time,allowBlank:false,listeners:{scope:this,blur:function(h){var e=this.getForm().findField("end_time");if(!h.isValid()||!e.isValid()){return}var k=h.getValue();var d=e.getValue();var j=parseInt(k.split(":")[0],10)*60+parseInt(k.split(":")[1],10);var i=parseInt(d.split(":")[0],10)*60+parseInt(d.split(":")[1],10);var g=i-j>=0?i-j:i-j+1440;var f=new Date(0,0,0,Math.floor(g/60),g%60,0);this.getForm().findField("duration").setValue(f.format("H:i"))}},validator:this.generalTimeValidator.createDelegate(this)}]},{xtype:"syno_textfield",fieldLabel:_VST("schedule","end")+" (hh:mm)",width:200,value:this.calcEndTime(c.start_time,c.duration),name:"end_time",allowBlank:false,listeners:{scope:this,blur:function(h){var e=this.getForm().findField("start_time");if(!h.isValid()||!e.isValid()){return}var k=e.getValue();var d=h.getValue();var j=parseInt(k.split(":")[0],10)*60+parseInt(k.split(":")[1],10);var i=parseInt(d.split(":")[0],10)*60+parseInt(d.split(":")[1],10);var g=i-j+1440;var f=new Date(0,0,0,Math.floor(g/60),g%60,0);this.getForm().findField("duration").setValue(f.format("H:i"))}},validator:(function(e){var d=this.generalTimeValidator(e);if(true!==d){return d}if(this.getForm().findField("start_time").getValue()===e){return _VST("schedule","time_conflict")}return true}).createDelegate(this)},{xtype:"syno_textfield",fieldLabel:_VST("schedule","duration")+" (hh:mm)",width:200,value:c.duration,allowBlank:false,name:"duration",listeners:{scope:this,blur:function(e){var d=this.getForm().findField("start_time");if(!e.isValid()||!d.isValid()){return}this.getForm().findField("end_time").setValue(this.calcEndTime(d.getValue(),e.getValue()))}},validator:(function(e){var d=this.generalTimeValidator(e);if(true!==d){return d}if("00:00"==e){return false}return true}).createDelegate(this)},{xtype:"syno_checkbox",name:"is_repeat",boxLabel:_VST("action","repeat_record"),checked:c.is_repeat,hideLabel:true},{xtype:"syno_superboxselect",indent:1,fieldLabel:_VST("repeat","repeat_data"),width:200,name:"repeat_days",allowAddNewData:false,editable:false,resizable:true,store:this.createDaysStore(),mode:"local",grow:false,minChars:1,queryParam:"filter",disabled:!c.is_repeat,triggerAction:"all",displayField:"display",valueField:"value",value:c.weekdaystatus,allowBlank:false,settingValue:false,listeners:{beforeremoveitem:function(e,d,g){return e.settingValue||(d!==this.form.findField("start_date").getValue().getDay())},scope:this},resetStore:function(){this.store.clearFilter();if(!this.removeValuesFromStore){return this}this.usedRecords.each(function(d){this.store.add(d)},this);this.usedRecords.clear();this.store.sort(this.valueField,"ASC");return this}},{xtype:"syno_compositefield",indent:1,fieldLabel:_VST("repeat","end_day"),items:[{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_never"),inputValue:"never",name:"end_never",disabled:!c.is_repeat,checked:(c.end_date==1)?true:false,listeners:{scope:this,check:function(d,e){this.getForm().findField("end_on").setValue(!e);this.getForm().findField("end_value").setDisabled(e)}}}]},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_displayfield",width:150,value:""},{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_on"),inputValue:"on",name:"end_on",disabled:!c.is_repeat,checked:(c.end_date==1)?false:true,listeners:{scope:this,check:function(d,e){this.getForm().findField("end_never").setValue(!e)}}},{xtype:"syno_datefield",format:"Y-m-d",name:"end_value",editable:false,allowBlank:false,width:140,disabled:!c.is_repeat,value:(c.end_date==1)?c.today_date:c.end_date,preFocus:function(){this.el.blur()},validator:(function(f){if(0===f.length){this.owner.getMsgBox().alert(this.owner.title,_VST("repeat","repeat_endday_empty"));return}var d=this.owner.data.today_date;var g=f.substring(0,4)+f.substring(5,7)+f.substring(8,10);var e=d.substring(0,4)+d.substring(5,7)+d.substring(8,10);if(parseInt(e,10)>parseInt(g,10)){return _VST("repeat","repeat_endday_error")}return true}).createDelegate(this)}]}]};Ext.apply(b,a);SYNO.SDS.VideoStation.UserDefineScheduleFormpanel.superclass.constructor.call(this,b);this.GangCheckBox(this.form,"is_repeat",["repeat_days","end_never","end_on"])},calcEndTime:function(c,d){var g=c.split(":");var b=d.split(":");var f=parseInt(g[0],10)*60+parseInt(g[1],10);var e=f+parseInt(b[0],10)*60+parseInt(b[1],10);var a=new Date(0,0,0,Math.floor(e/60),e%60,0);return a.format("H:i")},generalTimeValidator:function(a){if(""===a||""!==a.replace(/\d\d:\d\d/,"")){return String.format(_VST("schedule","format_error"),"hh:mm")}if(23<parseInt(a.split(":")[0],10)){return _VST("schedule","hour_exceed")}if(59<parseInt(a.split(":")[1],10)){return _VST("schedule","minute_exceed")}return true},createDaysStore:function(){var a=new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],idIndex:0,data:[[0,_VST("repeat","schedule_sun")],[1,_VST("repeat","schedule_mon")],[2,_VST("repeat","schedule_tue")],[3,_VST("repeat","schedule_wed")],[4,_VST("repeat","schedule_thu")],[5,_VST("repeat","schedule_fri")],[6,_VST("repeat","schedule_sat")]]});return a},gangWeekday:function(b){if(this.isVisible()){var d=this.form.findField("repeat_days");var a=new Date(b).getDay();var e=d.store.getById(a);if(e&&d.disabled){d.setValue(a)}else{if(e&&!d.disabled){var c=d.getValueEx();c.push({display:e.get("display"),value:e.get("value")});c.sort(function(g,f){return g.value>f.value});d.settingValue=true;d.setValueEx(c);d.settingValue=false}}}},Apply:function(){var d=this.getForm();if(!d.isValid()){return}var a=d.getValues();var c=d.getFieldValues();var g={id:this.owner.id,channel_name:this.owner.channel_name,start_time:a.start_time,start_date:a.start_date,duration:a.duration,title:a.title,description:a.description,tuner:Ext.isDefined(this.owner.tunerInfo)?this.owner.tunerInfo.id:0,is_repeat:c.is_repeat};if(c.is_repeat){var e=[0,0,0,0,0,0,0];var f=d.findField("repeat_days").getValue().split(",");f.each(function(h){this[h]=1},e);Ext.apply(g,{isweekly:(7!=f.length),weekdaystatus:e.join(","),end_date:(a.end_never)?1:a.end_value})}this.owner.setStatusBusy({text:_T("common","saving")});if(this.owner.loadsetting){var b=new Date(this.form.findField("start_date").originalValue);Ext.apply(g,{orig_start_time:this.form.findField("start_time").originalValue,orig_start_date:b.format("Y-m-d")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","edit_userdefine","1",g,this.ApplyDone,this)}else{SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","create_userdefine","1",g,this.ApplyDone,this)}},ApplyDone:function(a,d,c){this.owner.clearStatusBusy();if(!a){if(d.code<400){this.owner.getMsgBox().alert(this.owner.title,SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(d.code);if(406===d.code){this.owner.getMsgBox().alert(this.owner.title,b,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.MainCardPanel").launchSettingDialog(1)},this)}else{this.owner.getMsgBox().alert(this.owner.title,b)}}}else{this.owner.schedulestore.reload();this.owner.close()}},GangCheckBox:function(c,b,a){var d=SYNO.SDS.Utils.FieldFind(c,b);this.fields=a;this.form=c;d.mon(d,"check",function(j,h){var g,f,e;if(h){for(g=0,f=this.fields.length;g<f;g++){e=SYNO.SDS.Utils.FieldFind(this.form,this.fields[g]);e.setDisabled(false)}}else{for(g=0,f=this.fields.length;g<f;g++){e=SYNO.SDS.Utils.FieldFind(this.form,this.fields[g]);e.setDisabled(true)}}},this)}});Ext.define("SYNO.SDS.VideoStation.ProgramScheduleGridPanel",{extend:"SYNO.ux.GridPanel",PageSize:10,constructor:function(a){Ext.apply(this,a||{});this.BaseUrl=this.module.owner.owner.jsConfig.jsBaseURL;var b=this.createStore();var c=this.fillConfig(a,b);SYNO.SDS.VideoStation.ProgramScheduleGridPanel.superclass.constructor.call(this,c)},fillConfig:function(a,b){var c={cls:"syno-vs-dtv-schedule-grid",border:false,getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},stripeRows:true,split:false,enableColumnMove:false,enableColLock:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,tbar:this.createTBar(),bbar:this.createBBar(b),title:_VST("schedule","schedule_recording"),sm:new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{scope:this,selectionchange:function(f){var e=f.getSelections();if(!e[0]){return}var d=e[0].get("status");if(1===f.getCount()&&(12===d||13===d||(1===d&&e[0].get("is_userdefine")))){this.btnEditRepeatSchedule.setDisabled(false)}else{this.btnEditRepeatSchedule.setDisabled(true)}}}}),loadMask:true,store:b,colModel:new Ext.grid.ColumnModel({columns:[{id:"channelname",header:_VST("schedule","channel"),dataIndex:"channel_name",width:90,align:"left",renderer:this.channelRenderer.createDelegate(this)},{id:"title",header:_VST("programguide","title"),dataIndex:"title",width:140,align:"left",renderer:this.qtipRenderer.createDelegate(this)},{id:"description",header:_VST("programguide","description"),dataIndex:"description",width:180,align:"left",renderer:this.qtipRenderer.createDelegate(this)},{id:"start",header:_T("common","start"),dataIndex:"start",width:180,align:"left",renderer:this.startRenderer.createDelegate(this)},{id:"duration",header:_VST("schedule","duration"),dataIndex:"duration",width:80,align:"left",renderer:this.durationRender.createDelegate(this)},{id:"status",header:_VST("common","status"),dataIndex:"status",width:100,align:"center",renderer:this.statusRender.createDelegate(this)}],defaults:{sortable:false,menuDisabled:false,align:"right"}}),listeners:{rowcontextmenu:function(d,h,f){},rowclick:function(d,h,f){if(f&&h&&!f.hasModifier()){d.getSelectionModel().selectRow(h)}},rowdblclick:function(d,h,f){},scope:this}};Ext.apply(c,a);b.on("load",this.onLoad,this);return c},createStore:function(){var a=new Ext.data.JsonStore({autoLoad:false,pruneModifiedRecords:true,totalProperty:"total",idProperty:"primeid",proxy:new SYNO.API.Proxy({api:this.module.owner.Schedule_API,method:"list",version:this.module.owner.Schedule_APIVerion}),root:"schedules",fields:["id","channel_name","title","description","start_time","start","weekday","duration","status","primeid","is_userdefine"],baseParams:{api:this.module.owner.Schedule_API,version:this.module.owner.Schedule_APIVerion,method:"list",start:0,limit:this.PageSize,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},listeners:{exception:function(c,d,e,b,f){SYNO.Debug("Ajax load failure ",f)},scope:this}});this.addManagedComponent(a);return a},createTBar:function(){var a=[{tooltip:_VST("action","cancel_recording"),text:_VST("action","cancel_recording"),disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),itemId:"removerecording",handler:function(){if(_S("demo_mode")){this.module.owner.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}if(this.getStore().getTotalCount()===0){return}if(this.getSelectionModel().hasSelection()===false){this.module.owner.getMsgBox().alert(this.title,_VST("action","dvt_cfrm_select"));return}var h=this.getSelectionModel().getSelections();var c=[];var d=[];var q=[];var n=[];var g=[];var o=[];for(var m=0;m<h.length;m++){if(h[m].get("is_userdefine")){g.push(h[m].get("start_time"));o.push(h[m].get("id"))}else{if(12===h[m].get("status")||13===h[m].get("status")){q.push(h[m].get("start_time"));n.push(h[m].get("id"))}else{c.push(h[m].get("start_time"));d.push(h[m].get("id"))}}}var f=c.join(",");var e=d.join(",");if(f&&0<f.length){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete",1,{id:f,channel_id:e,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}var p=q.join(",");var j=n.join(",");if(p&&0<p.length){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete_repeat",1,{id:p,channel_id:j,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}var l=g.join(",");var k=o.join(",");if(l&&0<l.length){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete_userdefine",1,{id:l,channel_id:k,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}this.module.owner.setStatusBusy({text:_T("common","loading")})},scope:this},{tooltip:_VST("action","edit_repeat_schedule"),text:_T("common","alt_edit"),disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),itemId:"edit_repeat_schedule",handler:function(){if(_S("demo_mode")){this.module.owner.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}if(this.getStore().getTotalCount()===0){return}if(this.getSelectionModel().hasSelection()===false){this.module.owner.getMsgBox().alert(this.title,_VST("action","dvt_cfrm_select"));return}var c=this.getSelectionModel().getSelections();var d=c[0].get("start_time");var e=c[0].get("id");if(c[0].get("is_userdefine")){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","getinfo_userdefine",1,{tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0),start_time:d},this.getUserdefineInfoDone,this)}else{SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","getinfo_repeat",1,{id:e,start_time:d,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.getRepeatInfoDone,this)}},scope:this},{tooltip:_VST("action","clear_pass_task"),text:_VST("action","clearpasstask"),disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),itemId:"clear_pass_task",handler:function(){if(_S("demo_mode")){this.module.owner.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete_passed",1,{tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)},scope:this}];var b=new SYNO.ux.Toolbar({items:a});this.btnRemove=b.getComponent("removerecording");this.btnClearPassTask=b.getComponent("clear_pass_task");this.btnEditRepeatSchedule=b.getComponent("edit_repeat_schedule");return b},createBBar:function(a){this.pagingbar=new SYNO.ux.PagingToolbar({store:a,displayInfo:true,pageSize:this.PageSize});return this.pagingbar},channelRenderer:function(b,e,c,i,a,g){var f=Ext.util.Format.htmlEncode(b);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(f)+'"';var d=SYNO.SDS.VideoStation.DTVUtil.programStatus(c.get("status"));var h=d||"";return['<div class="'+h+'">',"<span>",f,"</span>","</div>"].join("")},qtipRenderer:function(f,c,e,b,d,a){c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(f)+'"';return f},startRenderer:function(h,d,g,c,f,b){var a;var e=SYNO.SDS.VideoStation.DTVUtil.getWeekDayfromNumber(g.get("weekday"));if(e){e=" ("+e+")"}a=h+e;d.attr='ext:qtip="'+Ext.util.Format.htmlEncode(a)+'"';return a},durationRender:function(b,g,d,i,a,h){if(b){var f,e,c;f=SYNO.SDS.VideoStation.DTVUtil.modifyHM(b%60);e=SYNO.SDS.VideoStation.DTVUtil.modifyHM(((b-f)/60)%60);if(0<(b-(f+e*60))){c=SYNO.SDS.VideoStation.DTVUtil.modifyHM((b-(f+e*60))/3600)}else{c=SYNO.SDS.VideoStation.DTVUtil.modifyHM(0)}return c+":"+e+":"+f}},statusRender:function(g,c,f,b,e,a){var d=SYNO.SDS.VideoStation.DTVUtil.getScheduleStatusString(g);c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d},onLoad:function(c,e,d){if(c.getCount()<1){this.btnRemove.setDisabled(true);this.btnClearPassTask.setDisabled(true);this.btnEditRepeatSchedule.setDisabled(true);return}c.sort("start_time","ASC");this.StartOffset=d.params.start;this.getSelectionModel().selectFirstRow();this.btnRemove.setDisabled(_S("demo_mode"));this.btnClearPassTask.setDisabled(_S("demo_mode"));this.btnEditRepeatSchedule.setDisabled(_S("demo_mode"));var b=this.getSelectionModel().getSelections();if(b&&b[0]){var a=b[0].get("status");if(12===a||13===a||(1===a&&b[0].get("is_userdefine"))){this.btnEditRepeatSchedule.setDisabled(false||_S("demo_mode"))}else{this.btnEditRepeatSchedule.setDisabled(true)}}},requestDone:function(a,e,c){if(this.getEl().isMasked()){this.getEl().unmask()}this.module.owner.clearStatusBusy();var d=_VST("action","program_guide");if(!a){if(e.code<400){this.module.owner.getMsgBox().alert(d,SYNO.API.CheckResponse(a,e,c))}else{var b=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(e.code);this.module.owner.getMsgBox().alert(d,b)}}if("delete_passed"===c.method){this.pagingbar.moveFirst();return}if(0!=this.StartOffset&&this.StartOffset>=(this.getStore().getTotalCount()-this.getSelectionModel().getSelections().length)){this.StartOffset=this.StartOffset-this.PageSize}this.store.load({params:{start:this.StartOffset,limit:this.PageSize}});this.module.owner.updateStreamBtnTask.delay(15000,function(){this.module.owner.updateStreamBtn()},this)},getRepeatInfoDone:function(a,g,e){var f=_VST("action","program_guide");if(!a){if(g.code<400){this.module.owner.getMsgBox().alert(f,SYNO.API.CheckResponse(a,g,e))}else{var c=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(g.code);this.module.owner.getMsgBox().alert(f,c)}}if(g){var d=[];d=g.weekdaystatus.split(",");Ext.each(d,function(j,h,i){d[h]=parseInt(d[h],10)},this);var b=new SYNO.SDS.VideoStation.RepeatScheduleDialog({owner:this.module.owner,id:g.id,channel_name:g.channel_name,start_date:g.start_date,start_time:g.start_time,program_title:g.title,description:g.description,isweekly:g.isweekly,weekdaystatus:d,end_date:g.end_date,loadsetting:true,title:_VST("repeat","repeat_schedule"),tunerInfo:this.tunerInfo});b.open()}},getUserdefineInfoDone:function(b,h,f){var g=_VST("schedule","schedule_recording");if(!b){if(h.code<400){this.module.owner.getMsgBox().alert(g,SYNO.API.CheckResponse(b,h,f))}else{var e=SYNO.SDS.VideoStation.DTVUtil.mappingDTVStatus(h.code);this.module.owner.getMsgBox().alert(g,e)}}else{if(h){var a=h.weekdaystatus.split(",");h.weekdaystatus="";for(var d=0;d<a.length;d++){if("1"==a[d]){h.weekdaystatus+=(0<h.weekdaystatus.length)?",":"";h.weekdaystatus+=d}}var c=new SYNO.SDS.VideoStation.UserDefineScheduleDialog({owner:this.module.owner,id:h.channel_id,channel_name:h.channel_name,loadsetting:(0<f.start_time),title:_VST("schedule","user_define_schedule"),data:h,tunerInfo:this.tunerInfo});c.open()}}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.ProgramScheduleDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){this.owner=this._getOwner();this.defineBehaviors();var b=this.fillConfig(a);SYNO.SDS.VideoStation.ProgramScheduleDialog.superclass.constructor.call(this,b)},fillConfig:function(a){this.ProgramScheduleTabpanel=new SYNO.SDS.VideoStation.ProgramScheduleTabpanel({owner:this,itemId:"ProgramScheduleTablpanel",activeItem:Ext.isDefined(a.activeItem)?a.activeItem:0,channelID:a.channelID,tunerInfo:a.tunerInfo});var b={owner:this.owner,width:850,height:520,minWidth:700,minHeight:550,title:_VST("schedule","schedule")+"  -  "+a.tunerInfo.title,layout:"fit",items:[this.ProgramScheduleTabpanel],buttons:[{text:_T("common","close"),scope:this,handler:this.handleClose}],keys:[{key:[10,13],scope:this.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramGrid,handler:this.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramGrid.onSearchEPG},{key:27,scope:this,handler:this.handleClose}]};Ext.apply(b,a);return b},handleClose:function(){this.owner.mainpanel.mainCardPanel.cardPanel.dtvhomepage.getStore().reload();this.close()},defineBehaviors:function(){this.Channel_API="SYNO.DTV.Channel";this.Channel_APIVerion="1";this.Program_API="SYNO.DTV.Program";this.Program_APIVerion="1";this.Program_APIURL=this.owner._getWebAPIURL("programlist.cgi");this.Schedule_API="SYNO.DTV.Schedule";this.Schedule_APIVerion="1";if(!this.updateStreamBtnTask){this.updateStreamBtnTask=new Ext.util.DelayedTask()}},updateStreamBtn:function(){if(this.owner){this.ProgramScheduleTabpanel.btnStream.setDisabled(!this.owner.mainpanel.mainCardPanel.cardPanel.showrecordingbtn.hidden||_S("demo_mode"))}}});Ext.define("SYNO.SDS.VideoStation.ProgramScheduleTabpanel",{extend:"SYNO.ux.TabPanel",constructor:function(a){this.owner=a.owner;this.ProgramGuidePanel=new SYNO.SDS.VideoStation.ProgramGuidePanel({module:this,tunerInfo:a.tunerInfo,channelID:a.channelID,itemId:"ProgramGuidePanel"});this.ProgramScheduleGridPanel=new SYNO.SDS.VideoStation.ProgramScheduleGridPanel({module:this,tunerInfo:a.tunerInfo,itemId:"ProgramScheduleGridPanel"});var b={owner:this.owner,activeTab:a.activeItem,plain:true,deferredRender:false,items:[this.ProgramGuidePanel,this.ProgramScheduleGridPanel],listeners:{scope:this,tabchange:this.onTabchange}};Ext.apply(b,a);SYNO.SDS.VideoStation.ProgramScheduleTabpanel.superclass.constructor.call(this,b)},onTabchange:function(b,a){if("ProgramScheduleGridPanel"===a.itemId){this.ProgramScheduleGridPanel.store.load()}else{if(this.ProgramGuidePanel.ProgramList.isAtChannlelist){if(this.ProgramGuidePanel.ProgramList.dataview.getSelectedRecords().length){this.ProgramGuidePanel.ProgramGrid.store.load()}}else{this.ProgramGuidePanel.ProgramGrid.doSearch()}}}});Ext.define("SYNO.SDS.VideoStation.ProgramGuidePanel",{extend:"SYNO.ux.Panel",constructor:function(a){this.init();Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},init:function(){this.tunerType={FE_QPSK:0,FE_QAM:1,FE_OFDM:2,FE_ATSC:3}},fillConfig:function(a){this.ProgramList=new SYNO.SDS.VideoStation.ProgramGuideListPanel({module:this.module,itemId:"ProgramList",region:"west",isAtChannlelist:true,channelID:a.channelID,tunerInfo:a.tunerInfo});this.ProgramGrid=new SYNO.SDS.VideoStation.ProgramGuideGridPanel({module:this.module,itemId:"ProgramGrid",region:"center",tunerInfo:a.tunerInfo});var b={border:false,title:_VST("action","program_guide"),layout:"border",width:680,height:500,monitorResize:true,tbar:this.createTBar(),items:[this.ProgramList,this.ProgramGrid],listeners:{scope:this,activate:{fn:this.onActivate,scope:this}}};Ext.apply(b,a);return b},createTBar:function(){var a=this.ProgramGrid;var b=this.ProgramList;var e;var c=new SYNO.ux.Menu({cls:"syno-vs-menu",itemId:"recordingmenu",items:[{text:_VST("action","record"),itemId:"record"},{text:_VST("action","repeat_record"),itemId:"repeat_record"},{text:_VST("schedule","user_define_schedule"),itemId:"userdefine_record"},{text:_VST("action","cancel_recording"),disabled:true,itemId:"remove_record",handler:a.requesRecordRemove,scope:a}],listeners:{scope:a,beforeshow:a.onRecordMenuBeforeShow,itemclick:a.onRecordItemClick}});this.addManagedComponent(c);a.recordmenu=c;b.recordmenu=c;var f=new SYNO.ux.Menu({cls:"syno-vs-menu",itemId:"startmenu",items:[{text:_VST("action","channelscan"),itemId:"channelscan",disabled:_S("demo_mode"),handler:b.launchChannelScanDialog,scope:b},{text:_VST("action","channeledit"),itemId:"channeledit",disabled:_S("demo_mode"),handler:b.launchChannelEditDialog,scope:b},{text:_VST("action","delete_all_channels"),itemId:"deleteallchannels",disabled:_S("demo_mode"),hidden:(this.tunerInfo.type!=this.tunerType.FE_QPSK),handler:b.delteAllChannels,scope:b},{text:_VST("programguide","update_epg"),disabled:true,itemId:"updateepg",hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),handler:b.requesUpdateEPG,scope:b}]});var d=[{tooltip:_VST("programguide","broadcast_streaming"),text:_VST("programguide","broadcast_streaming"),itemId:"broadcaststreaming",disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),handler:b.stream,scope:b},{text:_VST("action","record"),itemId:"recordingaction",hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),menu:c},{text:_VST("action","start"),itemId:"startaction",hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),menu:f},"->",e=new SYNO.ux.TextFilter({itemId:"search_field",emptyText:_VST("search","keyword")})];var g=new SYNO.ux.Toolbar({cls:"syno-vs-dtv-programguide-toolbar",items:d});a.searchField=e;a.btnRemove=c.getComponent("remove_record");this.module.btnStream=g.getComponent("broadcaststreaming");this.module.btnUpdateEPG=f.getComponent("updateepg");this.module.btnDeleteallchannels=f.getComponent("deleteallchannels");return g},reloadChannels:function(){this.IsHaveLoadChannel=false;this.onActivate()},onActivate:function(){if(!this.IsHaveLoadChannel){this.module.owner.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.module.owner.Channel_API,"list",this.module.owner.Channel_APIVerion,{tuner:(Ext.isDefined(this.module.owner.tunerInfo)?this.module.owner.tunerInfo.id:0),offset:0,limit:-1},this.ProgramList.channelListDone,this.ProgramList);this.IsHaveLoadChannel=true}}});Ext.namespace("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.LibraryPermissionGrid=Ext.extend(SYNO.SDS.VideoStation.CheckBoxGrid,{cgiURL:"library_manage.cgi",constructor:function(b){this.module=b.module;this.library_id=b.library_id;var a=Ext.apply({cls:"library-permission-grid",autoExpandColumn:"name",plugins:[this.getBrowseColumn()]},b);SYNO.SDS.VideoStation.LibraryPermissionGrid.superclass.constructor.call(this,a);this.changes=b.permission;this.saveChanges=this.saveLocalChanges;this.getStore().on("load",this.applyLocalChanges,this);this.getStore().on("load",this.onUserLoad,this)},getStore:function(){if(this.store){return this.store}var b={action:"list_permission"};if(Ext.isDefined(this.library_id)){Ext.apply(b,{id:this.library_id})}var a=new Ext.data.JsonStore({autoLoad:true,root:"data.users",totalProperty:"data.total",baseParams:b,fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"browse",type:"boolean",defaulValue:false}],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL(this.cgiURL),listeners:{beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}})});return(this.store=a)},getColumns:function(){if(this.colModel){return this.colModel}var a={defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getBrowseColumn()]};return(this.colModel=new Ext.grid.ColumnModel(a))},getBrowseColumn:function(){if(this.browseColumn){return this.browseColumn}return(this.browseColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("common","browse"),dataIndex:"browse",id:"browse",width:150,ignoreKey:"is_admin"}))},getChanges:function(){if(!this.isDirty()){return}var a=this.getStore().getModifiedRecords();var b={};Ext.each(a,function(c){var d=c.get("uid");if(!Ext.isDefined(b[d])){b[d]={}}b[d]["browse"]=c.get("browse")});return b},getLocalChanges:function(){var a=this.changes||{};return Ext.apply(a,this.getChanges())},saveLocalChanges:function(a){if(!Ext.isDefined(this.changes)){this.changes={}}Ext.apply(this.changes,this.getChanges());this.getStore().commitChanges();this.getStore().load(a)},applyLocalChanges:function(b,a,c){if(!Ext.isDefined(this.changes)){return}b.each(function(d){var e=d.get("uid");if(Ext.isDefined(this.changes[e])){d.set("browse",this.changes[e]["browse"])}},this);b.commitChanges()},onUserLoad:function(b,a,c){var d=this.getEl();if(b.getCount()===0){d.mask(_VST("privilege","no_user_hint"),"syno-ux-mask-info")}else{if(d.isMasked()){d.unmask()}}}});Ext.define("SYNO.SDS.VideoStation.LibraryPermissionDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.library_id=a.library_id;this.callParent([this.fillConfig(a)])},fillConfig:function(b){var a={width:500,height:580,minWidth:300,minHeight:280,resizable:true,cls:"syno-vs-library-dialog",title:_VST("library","permission"),layout:"fit",items:[this.getGridPanel()],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{text:_T("common","cancel"),scope:this,handler:this.onCancel}]};return Ext.apply(a,b)},getGridPanel:function(){if(this.grid){return this.grid}this.grid=new SYNO.SDS.VideoStation.LibraryPermissionGrid({module:this,library_id:this.library_id,permission:this._getOwner().permission});return this.grid},onApply:function(){if(!this.grid.isDirty()){this.close();return}this.save()},save:function(){var a=this._getOwner();if(!Ext.isDefined(a.permission)){a.permission=this.grid.getLocalChanges()}else{Ext.apply(a.permission,this.grid.getLocalChanges())}this.close()},onCancel:function(){if(!this.grid.isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this._getOwner().getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),a,this)}});Ext.define("SYNO.SDS.VideoStation.LibraryDialog",{extend:"SYNO.SDS.VideoStation.AddEditDialog",constructor:function(b){this.library=b.library;var a=Ext.apply({width:485,height:320,resizable:false,cls:"syno-vs-library-dialog",applyButton:{btnStyle:"blue",text:_T("common","alt_apply"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onRequest}},b);this.callParent([a])},getFormPanel:function(){if(this.formPanel){return this.formPanel}var d={xtype:"syno_textfield",itemId:"title",fieldLabel:_T("common","name"),width:250,allowBlank:false,maxLength:50};var c={xtype:"radiogroup",itemId:"type",fieldLabel:_VST("type","tile"),columns:1,items:[{xtype:"syno_radio",boxLabel:_VST("type","movie"),inputValue:SYNO.SDS.VideoStation.Util._MOVIE_ID,name:"type",checked:true},{xtype:"syno_radio",boxLabel:_VST("type","tv_show"),inputValue:SYNO.SDS.VideoStation.Util._TVSHOW_ID,name:"type",checked:false},{xtype:"syno_radio",boxLabel:_VST("type","others"),inputValue:SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,name:"type",checked:false}]};var e={xtype:"radiogroup",itemId:"is_public",fieldLabel:_VST("library","permission_title"),columns:1,items:[{xtype:"syno_radio",boxLabel:_VST("library","public"),inputValue:1,name:"is_public",checked:true},{xtype:"syno_radio",boxLabel:_VST("library","private"),inputValue:0,name:"is_public",checked:false}],listeners:{scope:this,change:{fn:function(g,f){this.getFormPanel().getComponent("permissionButton").setDisabled(f.inputValue===1)}}}};var b={xtype:"syno_button",btnStyle:"red",style:"margin-left: 185px;",cls:"form-button",itemId:"permissionButton",disabled:true,text:_VST("library","permission"),handler:this.openPermissionDialog.createDelegate(this)};var a={trackResetOnLoad:true,border:false,labelWidth:180,hideLabels:false,items:[d,c,e,b]};return(this.formPanel=new SYNO.ux.FormPanel(a))},openPermissionDialog:function(){var a=new SYNO.SDS.VideoStation.LibraryPermissionDialog({owner:this,library_id:Ext.isDefined(this.library)?this.library.id:undefined});a.open()},onOpen:function(){if("edit"===this.mode){var a=this.getFormPanel().getForm();a.findField("title").setValue(this.library.title);a.findField("type").setValue(this.library.type);a.findField("is_public").setValue(this.library.is_public?1:0)}this.callParent()},onRequest:function(){if(!this.getFormPanel().getForm().findField("title").validate()){this.getMsgBox().alert(_VST("library","title"),_T("error","error_bad_field"));return}SYNO.SDS.VideoStation.LibraryDialog.superclass.onRequest.call(this,"library_manage.cgi")},onRequestDone:function(a,d,b){this.clearStatusBusy();if(b&&b.success){this.module.libraryList.reload(a.params);SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.LibraryListPanel").loadLibrary();this.close()}else{var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this.getMsgBox().alert(_VST("library","title"),c)}},getParameter:function(){var b=this.getFormPanel().getForm();var e=b.findField("title").getValue();var a=b.findField("type").getValue().inputValue;var c=b.findField("is_public").getValue().inputValue;var d={title:e,is_public:c,type:a,permission:Ext.util.JSON.encode(this.permission||{})};if("edit"===this.mode&&Ext.isDefined(this.library)){Ext.apply(d,{id:this.library.id,old_type:this.library.type,old_is_public:this.library.is_public?1:0,old_title:this.library.title})}return d},isDirty:function(){if(!Ext.isDefined(this.library)){return false}var d=this.getFormPanel().getForm();var f=d.findField("title").getValue();var c=d.findField("type").getValue().inputValue;var e=d.findField("is_public").getValue().inputValue;var a=this.library.is_public?1:0;var b=(f!==this.library.title)||(c!==this.library.type)||(e!==a)||Ext.isObject(this.permission);return b}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.AppInstance=Ext.extend(SYNO.SDS.AppInstance,{appWindowName:"SYNO.SDS.VideoStation.AppWindow",constructor:function(){SYNO.SDS.VideoStation.Util.init();SYNO.SDS.VideoStation.AppInstance.superclass.constructor.apply(this,arguments)}});Ext.define("SYNO.SDS.VideoStation.AppWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(a){this.panellist={};SYNO.SDS.VideoStation.Window=this;this.callParent([this.fillConfig(a)]);this.setStatusBusy();SYNO.API.currentManager.queryAPI("all",function(b,d,c){if(!SYNO.API.CheckResponse(b,d,c)){this.getMsgBox().alert(_VST("app","displayname"),_T("common","commfail"))}},this);this.addAjaxTask({autoJsonDecode:true,url:this._getAbsoluteURL("session.cgi"),params:{action:"load"},method:"POST",single:true,callback:function(e,f,d){SYNO.SDS.VideoStation.gData={};if(!f||!d||!d.success){this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation.Util.getErrinfoString(d,_T("common","commfail")))}else{SYNO.SDS.VideoStation.gData=SYNO.Util.copy(d.data);this.getFolderMgr().applyFolder(d.data.video_folder);if(SYNO.SDS.QuickConnect.Utils.isInTunnel()&&!SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","blNotShowQuickConnectMsg")){var c={items:[{xtype:"syno_displayfield",value:_VST("app","warn_quickconnect_tunnel")},{xtype:"syno_checkbox",boxLabel:_T("plugin","plugin_not_remind"),listeners:{scope:this,check:function(h,g){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","blNotShowQuickConnectMsg",g)}}}]};var b=new SYNO.SDS.ModalWindow({owner:this,cls:"syno-vs-dialog",layout:"fit",resizable:false,width:550,height:200,hideLabel:false,title:_VST("app","displayname"),buttons:[{text:_T("common","ok"),btnStyle:"blue",handler:function(){b.close()}}],items:new SYNO.SDS.Utils.FormPanel(c)});b.open()}}this.delayConstructor(function(){if(!SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_welcome_tip")&&_S("is_admin")){this.lunchWelcomeTip()}})},scope:this}).start();this.queryPrivilege()},fillConfig:function(a){var b={layout:"fit",cls:"syno-vs-win syno-vs-main-win",width:1022,height:600,minWidth:480,minHeight:360,html:""};Ext.apply(b,a);return b},delayConstructor:function(b){if(this.isDestroyed){return}if(!this.rendered){this.delayConstructor.defer(10,this,arguments);return}this.getPathMgr();this.getCollectionMgr();this.clearStatusBusy();var a=[];a.push(this.mainpanel=new SYNO.SDS.VideoStation.Main({header:false,itemId:"main"}));this.mon(this.mainpanel,"afterlayout",b,this,{single:true,buffer:100});this.removeAll();this.add(a);this.doLayout()},lunchWelcomeTip:function(){var a=this.el.createChild();var b=new SYNO.SDS.VideoStation.WelcomeTip({renderTo:a})},_getAbsoluteURL:function(a,b){return String.format("{0}/{1}/{2}",this.jsConfig.jsBaseURL,(b||"cgi"),a)},_getWebAPIURL:function(a){return String.format("{0}/{1}","/webapi/VideoStation",a)},addPanelScope:function(b,a){this.panellist[b]=a},getPanelScope:function(a){if(a in this.panellist){return this.panellist[a]}return null},getPathMgr:function(){if(this.pathMgr){return this.pathMgr}return(this.pathMgr=new SYNO.SDS.VideoStation.PathHistoryMgr())},getCollectionMgr:function(){if(this.collectionMgr){return this.collectionMgr}return(this.collectionMgr=new SYNO.SDS.VideoStation.CollectionMgr())},getFolderMgr:function(){if(!this.folderMgr){this.folderMgr=new SYNO.SDS.VideoStation.FolderMgr()}return this.folderMgr},queryPrivilege:function(){var a={api:"SYNO.VideoStation.Info",version:1,method:"getinfo"};var b=function(f,c,d){this.clearStatusBusy();if(f){SYNO.SDS.VideoStation.Util.privilege=c.privilege;SYNO.SDS.VideoStation.Util.support_hardware_transcode=c.support_hardware_transcode;SYNO.SDS.VideoStation.Util.support_transcode=c.support_transcode;SYNO.SDS.VideoStation.Util.support_remux=c.support_remux}else{var e=SYNO.SDS.VideoStation.Util.getWebAPIErr(f,c,d);this.getMsgBox().alert(this.title,e)}};this.setStatusBusy();SYNO.API.currentManager.requestAPI(a.api,a.method,a.version,{},b,this)}});Ext.define("SYNO.SDS.VideoStation.SubtitleDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.params={id:a.videoId};var b={owner:this._getOwner(),cls:"syno-vs-metadata-win",title:_VST("controller","search_subtitle"),width:720,height:380,layout:"fit",items:[this.getGridPanel()],buttons:[{text:_T("common","ok"),btnStyle:"blue",disabled:true,itemId:"ok",scope:this,handler:this.onApply},{text:_T("common","cancel"),btnStyle:"grey",itemId:"cancel",scope:this,handler:this.onCancel}],keys:[{key:27,scope:this,handler:this.onCancel}]};return Ext.apply(b,a)},getGridPanel:function(){var a={xtype:"syno_gridpanel",itemId:"grid",stripeRows:true,loadMask:{msg:_VST("search","searching")},viewConfig:{autoFill:true,forceFit:true,emptyText:_T("search","no_search_result")},selModel:new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{scope:this,selectionchange:function(){this.setOkDisabled(!this.isGridHasSelection())}}}),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("language","title"),dataIndex:"language",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}},{header:_VST("file","file_name"),dataIndex:"filename",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}},{header:_VST("video_info","source"),dataIndex:"plugin_title",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}}]}),enableHdMenu:false,enableColumnMove:false,listeners:{scope:this,rowdblclick:function(){this.downloadSubtitle()}},store:this.getStore()};return a},getStore:function(){if(this.gridStore){return this.gridStore}this.gridStore=new SYNO.API.JsonStore({api:"SYNO.VideoStation.Subtitle",method:"search",version:3,appWindow:false,autoLoad:true,baseParams:this.params,root:"subtitles",fields:["id","language","language_id","plugin_id","plugin_title","filename","downloaded","subtitle_id"]});return this.gridStore},isGridHasSelection:function(){return this.getComponent("grid").getSelectionModel().hasSelection()},setOkDisabled:function(a){this.getFooterToolbar().getComponent("ok").setDisabled(a)},getRecordSelections:function(){return this.getComponent("grid").getSelectionModel().getSelections()},downloadSubtitle:function(){this.setStatusBusy();this.downloadSubtitleByRecords(this.getRecordSelections())},downloadSubtitleByRecords:function(a){if(a.length===0){this.clearStatusBusy();this.close();return}firstRec=a.shift();if(firstRec.get("downloaded")){this.downloadSubtitleByRecords(a);return}var b=this.params;b.plugin_id=firstRec.get("plugin_id");b.download_id=firstRec.get("id");SYNO.API.Request({recs:a,api:"SYNO.VideoStation.Subtitle",method:"download",version:3,params:b,scope:this,callback:this.downloadSubtitleCallback})},downloadSubtitleCallback:function(d,c,b,a){if(d&&c){this.downloadSubtitleByRecords(a.recs);return}this.clearStatusBusy();this.getMsgBox().alert(this.title,_VST("controller","download_subtitle_fail"))},onApply:function(){this.downloadSubtitle()},onCancel:function(){this.close()}});