#!/usr/bin/php
<?php
/* Copyright (c) 2013 Synology Inc. All rights reserved. */

define("INDEX_DAEMON_PID", 				"/var/run/synoindexd.pid");
define("VIDEO_INDEX_DAEMON_PID", 		"/var/run/synovideoindexd.pid");
define("VIDEO_METADATA_DAEMON_PID", 	"/var/run/synovideometadatad.pid");

define("FOLDER_CONF_PATH", 				"/var/packages/VideoStation/etc/folder.conf");
define("SYNO_INDEX_BIN", 				"/usr/syno/bin/synoindex");

define("SIGUSR2",						12);

function Usage()
{
	$program = basename(__FILE__);

echo <<<EOF
Usage:
    ./$program [-a action] [options]
Required:
    -a action
        rename, move, delete
    -s
        original share name
    -o
        original share path
Options:
    -n
        share name
    -p
        share path

Example:
    ./$program -a d -s a1 -o /volume1/a1
    ./$program -a r -s a1 -o /volume1/a1 -n a2 -p /volume1/a2
    ./$program -a m -s a1 -o /volume1/a1 -n a1 -p /volume2/a1

EOF;
}

function GetOptions()
{
	$opts = getopt('ha:s:o:n:p:');

	if (isset($opts['h']) || !isset($opts['s'])) {
		Usage();
		exit(0);
	}

	return $opts;
}

function ReadPidFile($pid_file)
{
	//Open file
	$handle = fopen($pid_file, "r");
	if (false == $handle) {
		return -1;
	}

	//Readline
	if (false == ($buffer = fgets($handle))) {
		fclose($handle);
		return -1;
	}

	//close file
	fclose($handle);

	//Read pid
	$pid = (int)trim($buffer);

	return $pid;
}

function ProcSignalByPidFile($pid_file, $signo)
{
	//Get pid
	if (0 > ($pid = ReadPidFile($pid_file))) {
		return -1;
	}

	//Send singno to this process
	if (false == posix_kill($pid, $signo)) {
		return -1;
	}

	return 0;
}

function NotifyDaemon()
{
	ProcSignalByPidFile(VIDEO_INDEX_DAEMON_PID, 	SIGUSR2);
	ProcSignalByPidFile(VIDEO_METADATA_DAEMON_PID, 	SIGUSR2);
}

function GetRealPath($share_path, $subpath)
{
	$path = $share_path;
	if (!empty($subpath)) {
		$path .= "/{$subpath}";
	}
	return $path;
}

function Main()
{
	//Get options
	$opts = GetOptions();

	//Gey folder.conf
	$content = file_get_contents(FOLDER_CONF_PATH);
	$folder_conf = json_decode($content, true);

	//Get new folder.conf
	$new_folder_conf = array();
	for ($i = 0; $i < count($folder_conf); $i++) {

		if ($folder_conf[$i]['share'] != $opts['s']) {
			array_push($new_folder_conf, $folder_conf[$i]);
			continue;
		}

		//Delete share folder
		if ('d' == $opts['a'] && isset($opts['s'], $opts['o'])) {
			array_push($new_folder_conf, $folder_conf[$i]);
		//Rename share folder
		} else if ('r' == $opts['a'] && isset($opts['s'], $opts['o'], $opts['n'], $opts['p'])) {
			$tmp = $folder_conf[$i];
			$tmp['share'] = $opts['n'];
			array_push($new_folder_conf, $tmp);
		//Move share folder
		} else if ('m' == $opts['a'] && isset($opts['s'], $opts['o'], $opts['n'], $opts['p'])) {
			array_push($new_folder_conf, $folder_conf[$i]);
		}
	}

	//Notify Daemon
	file_put_contents(FOLDER_CONF_PATH, json_encode($new_folder_conf));
	NotifyDaemon();
	sleep(3);

	//For each share folder in video station
	for ($i = 0; $i < count($folder_conf); $i++) {

		if ($folder_conf[$i]['share'] != $opts['s']) {
			continue;
		}

		//Delete share folder
		if ('d' == $opts['a'] && isset($opts['s'], $opts['o'])) {
			$path = GetRealPath($opts['o'], $folder_conf[$i]['subpath']);
			$cmd = SYNO_INDEX_BIN . " -D '$path' -P VideoStation";
			exec($cmd);

		//Rename share folder, affact folder.conf
		} else if ('r' == $opts['a'] && isset($opts['s'], $opts['o'], $opts['n'], $opts['p'])) {
			//find path
			$ori_path = GetRealPath($opts['o'], $folder_conf[$i]['subpath']);
			$new_path = GetRealPath($opts['p'], $folder_conf[$i]['subpath']);

			//execute synoindex rename
			$cmd = SYNO_INDEX_BIN . " -N '$new_path' '$ori_path' -P VideoStation";
			exec($cmd);

		//Move share folder path, affact real file path
		} else if ('m' == $opts['a'] && isset($opts['s'], $opts['o'], $opts['n'], $opts['p'])) {
			//find path
			$ori_path = GetRealPath($opts['o'], $folder_conf[$i]['subpath']);
			$new_path = GetRealPath($opts['p'], $folder_conf[$i]['subpath']);

			//execute synoindex rename
			$cmd = SYNO_INDEX_BIN . " -N '$new_path' '$ori_path' -P VideoStation";
			exec($cmd);
		}
	}
}

Main();

?>
