PACKAGE_DIR="/var/packages/VideoStation"
SYNODTV_BIN="${PACKAGE_DIR}/target/sbin/synodtvd"
DTV_SETTING_CONF="${PACKAGE_DIR}/etc/dtv_setting.conf"
SYNOPKG_PKG_STATUS="$2"

if [ -e "/usr/syno/sbin/syno_dvb_admin.sh" ]; then
	DVB_ADMIN="/usr/syno/sbin/syno_dvb_admin.sh"
else
	DVB_ADMIN="${PACKAGE_DIR}/target/scripts/DVB_Admin.sh"
fi

start()
{
	[ -e "${DVB_ADMIN}" ] && ${DVB_ADMIN} "start" "${PACKAGE_DIR}"

	# synodtv daemon
	${SYNODTV_BIN} start
	if [ -n "$SYNOPKG_PKG_STATUS" ]; then
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh add
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh hupapache &
	fi
}

stop()
{
	# synodtv daemon
	${SYNODTV_BIN} stop

	[ -e "${DVB_ADMIN}" ] && ${DVB_ADMIN} "stop" "${PACKAGE_DIR}"

	if [ -n "$SYNOPKG_PKG_STATUS" ]; then
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh delete
		if [ "UPGRADE" != "$SYNOPKG_PKG_STATUS" ]; then
			${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh hupapache &
		fi
	fi
}

case $1 in
	start)
		start
		exit 0
	;;
	stop)
		stop
		exit 0
	;;
esac
