#!/bin/sh

. /etc.defaults/rc.subr;

################## List Modules Start ######################

# Main
MAIN_MODULES="rc-core dvb-core lirc_dev ir-lirc-codec dvb-usb"

# frontends
FRONTEND_MODULES="dvb-pll dibx000_common dib3000mc af9013 mt352 stv6110 cx24116 tda10023 isl6423 zl10353 stv0900 stb6100 stb0899 \
                  atbm8830 dib7000p lgs8gxx dib0070 lgdt330x cx22702 dib0090 dib7000m dib8000 dib9000 s5h1411 lgdt3305 dib3000mb \
				  nxt6000 stb6000 ds3000 si21xx mt312 zl10039 stv0299 stv0288 ec100 tda826x tda10086 ix2505v tda1004x \
				  stv090x stv6110x lnbp21 tda10048 it913x-fe"

# tuners
TUNER_MODULES="mt2060 qt1010 tda18271 mxl5007t mc44s803 tda18218 mxl5005s tuner-xc2028 max2165 tuner-types tuner-simple mt2266 \
               xc5000 xc4000 tda827x tda18212"

# usb
USB_MODULES="dvb-usb-dibusb-common dvb-usb-a800 dvb-usb-af9005-remote dvb-usb-af9005 dvb-usb-af9015 dvb-usb-anysee dvb-usb-au6610 \
             dvb-usb-az6027 dvb-usb-ce6230 dvb-usb-cinergyT2 dvb-usb-cxusb dvb-usb-dib0700 dvb-usb-dibusb-mb dvb-usb-dibusb-mc \
             dvb-usb-digitv dvb-usb-dtt200u dvb-usb-dtv5100 dvb-usb-dw2102 dvb-usb-ec168 dvb-usb-friio dvb-usb-gl861 dvb-usb-gp8psk \
			 dvb-usb-it9135 dvb-usb-lmedm04 dvb-usb-m920x dvb-usb-nova-t-usb2 dvb-usb-opera dvb-usb-technisat-usb2 dvb-usb-ttusb2 \
			 dvb-usb-umt-010 dvb-usb-vp702x dvb-usb-vp7045 dvb-usb-it913x"

# All
ALL_MODULES="$MAIN_MODULES $FRONTEND_MODULES $TUNER_MODULES $USB_MODULES"

#################### List Modules end ######################

case $1 in
	start)
		SYNOLoadModules $ALL_MODULES
	;;
	stop)
		SYNOUnloadModules $ALL_MODULES
	;;
	restart)
		$0 stop
		$0 start
	;;
	*)
		echo "$1 <= Not supported !"
	;;
esac
