/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.VideoPlayerCommonVC.VideoDisplay",{extend:"Ext.Container",constructor:function(b){var a={layout:"border",itemId:"video_display",cls:"video-display",hideMode:"offsets",items:[{xtype:"container",itemId:"video",region:"center",cls:"video"},new SYNO.SDS.VideoPlayerCommonVC.SubtitleDisplay({itemId:"subtitle",region:"south",hidden:true})]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleDisplay",{extend:"Ext.Container",SUBTITLE_HEIGHT:80,MAX_LINE:6,constructor:function(b){var a={height:this.SUBTITLE_HEIGHT,cls:"subtitle",prev_text:null};this.callParent([Ext.apply(a,b)])},setText:function(f){if(f===this.prev_text){return}this.prev_text=f;var b=this.SUBTITLE_HEIGHT;var c=Ext.min([f.split("<br/>").length,this.MAX_LINE]);var e=(c>1)?(b/c):b;var a=(c>1)?(e*0.9):(b*0.45);var d=this.getEl();d.update(f);d.setStyle("padding-top","10px");d.setStyle("padding-bottom","10px");d.setStyle("font-size",a.toFixed(2)+"px");d.setStyle("line-height",e.toFixed(2)+"px")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.MetaDisplay",{extend:"Ext.Container",constructor:function(b){var a={itemId:"meta_display",cls:"meta-display",hidden:true,hideMode:"offsets",html:this.getHtml()};this.callParent([Ext.apply(a,b)])},setImage:function(b){var a=Ext.get(this.getIconID());if(""===b){this.icon_src="";a.hide();a.setStyle("background-image","")}else{if(b===this.icon_src){return}this.icon_src=b;a.setStyle("background-image",String.format("url({0})",b));a.show()}},setText:function(a){if(!Ext.isString(a)){return}Ext.get(this.getTextID()).update(Ext.util.Format.htmlEncode(a))},getTextID:function(){if(!Ext.isDefined(this.text_id)){this.text_id=Ext.id()}return this.text_id},getIconID:function(){if(!Ext.isDefined(this.icon_id)){this.icon_id=Ext.id()}return this.icon_id},getHtml:function(){return['<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0">',"<tbody>","<tr><td>",'<div class="frame">','<div class="cover-frame"></div>','<div class="icon-frame"><div class="icon" id="'+this.getIconID()+'"></div></div>',"</div>",'<div class="status-text" id="'+this.getTextID()+'"></div>',"</td></tr>","</tbody>","</table>"].join("")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Display",{extend:"Ext.Container",constructor:function(b){var a={layout:"card",itemId:"body",cls:"syno-vp-body",activeItem:0,items:[this.getVideoDisplay(),this.getMetaDisplay()],listeners:{scope:this,afterrender:function(){SYNO.SDS.VideoPlayerCommonVC.Util.hookDoLayout(this)}}};this.callParent([Ext.apply(a,b)])},setSubtitle:function(a){this.getVideoDisplay().getComponent("subtitle").setText(a)},showSubtitle:function(a){this.getVideoDisplay().getComponent("subtitle")[(true===a)?"show":"hide"]();this.doLayout()},getVideoDisplay:function(){if(!Ext.isDefined(this.video_display)){this.video_display=new SYNO.SDS.VideoPlayerCommonVC.VideoDisplay()}return this.video_display},getMetaDisplay:function(){if(!Ext.isDefined(this.meta_display)){this.meta_display=new SYNO.SDS.VideoPlayerCommonVC.MetaDisplay()}return this.meta_display},setState:function(a,b){switch(a){case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED:this.setStopped();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING:this.setPlaying();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING:this.setBuffering();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:SYNO.Debug("error: ",b);this.setError(b);break;default:break}},setStopped:function(){this.layout.setActiveItem(0);this.getMetaDisplay().removeClass(["buffer","error"])},setPlaying:function(){this.layout.setActiveItem(0)},setBuffering:function(){this.layout.setActiveItem(1);this.getMetaDisplay().addClass("buffer");this.getMetaDisplay().removeClass("error");this.getMetaDisplay().setText("")},setError:function(a){this.layout.setActiveItem(1);this.getMetaDisplay().addClass("error");this.getMetaDisplay().removeClass("buffer");this.getMetaDisplay().setText(a);this.getMetaDisplay().setImage("")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Util",{statics:{STATE:{NO_MEDIA:0,STOPPED:1,PLAYING:2,PAUSED:3,BUFFERING:4,ERROR:5,CLEAR:6},MimeType:{ogg:"audio/ogg",ogv:"video/ogg",wav:"audio/wav",mp3:"audio/mpeg",m4a:"audio/mp4",m4b:"audio/mp4",m4v:"video/mp4",mov:"video/mp4"},getFileExt:function(a){var b=(/[.]/.exec(a))?/[^.]+$/.exec(a)[0]:"";return b.toLowerCase()},createVLCElement:function(e,f,d,a,c){var b;if(Ext.isIE||Ext.isIE11){b=e.createChild({tag:"object",id:f,classid:"clsid:9BE31822-FDAD-461B-AD51-BE1D1C159921",codebase:"http://download.videolan.org/pub/videolan/vlc/last/win32/axvlc.cab",width:d||"100%",height:a||"100%",style:c||"",cn:[{tag:"param",name:"src",value:""},{tag:"param",name:"allowfullscreen",value:"false"},{tag:"param",name:"bgcolor",value:"#000000"},{tag:"param",name:"toolbar",value:"false"}]})}else{b=e.createChild({tag:"embed",id:f,type:"application/x-vlc-plugin",version:"VideoLAN.VLCPlugin.2",pluginspage:"http://www.videolan.org/",width:d||"100%",height:a||"100%",style:c||"",src:"",allowfullscreen:"false",bgcolor:"#000000",toolbar:"false"})}return b},isVLCSupported:function(){if(Ext.isMac&&Ext.isSafari){return false}var a=SYNO.SDS.VideoPlayerCommonVC.Util.detectPlugin("VideoLAN.VLCPlugin.2","VideoLAN","VLC")||SYNO.SDS.VideoPlayerCommonVC.Util.detectPlugin("VideoLAN.VLCPlugin.2","VLC","VLC");return a},detectPlugin:function(){var b,d,a,c=navigator.plugins||[],f=arguments;if(Ext.isIE||Ext.isIE11){try{if((new ActiveXObject(f[0]))){return true}}catch(g){}return false}for(b=0;b<c.length;++b){a=true;for(d=1;d<f.length;++d){if(-1===c[b].name.indexOf(f[d])&&-1===c[b].description.indexOf(f[d])){a=false;break}}if(a){return true}}return false},addDomListener:function(a){return function(f,e,d,c,b){if(!f||!Ext.isString(e)||!Ext.isFunction(d)||!Ext.isObject(c)){return}if(a&&Ext.isIE&&f.attachEvent){f.attachEvent(e,d.createDelegate(c,b))}else{if(Ext.isFunction(f.addEventListener)){f.addEventListener(e,d.createDelegate(c,b),false)}else{f["on"+e]=d.createDelegate(c,b)}}}},FullscreenEventMap:{requestFullscreen:"fullscreenchange",webkitRequestFullscreen:"webkitfullscreenchange",mozRequestFullScreen:"mozfullscreenchange",msRequestFullscreen:"MSFullscreenChange"},FullscreenFn:["requestFullscreen","webkitRequestFullscreen","mozRequestFullScreen","msRequestFullscreen"],hookDoLayout:function(a){var c;var b=a.getEl();Ext.each(SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenFn,function(e){if(Ext.isFunction(b.dom[e])){c=SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenEventMap[e];return false}});if(Ext.isString(c)){var d=function(){SYNO.Debug("dolayout");a.doLayout()};SYNO.Debug("add fullscreen listener to: ",c);document.addEventListener(c,d,false)}},setDomFullscreen:function(a){Ext.each(SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenFn,function(b){if(Ext.isFunction(a[b])){a[b]();return false}})},isDomFullscreenSupported:function(){var b=document.body;var a=false;Ext.each(SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenFn,function(c){if(Ext.isFunction(b[c])){a=true;return false}});return a}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Button",{extend:"SYNO.ux.Button",constructor:function(b){var a={cls:"vp-button",handler:this.clickHandler};this.callParent([Ext.apply(a,b)])},getController:function(){return this.module.getController()},clickHandler:Ext.emptyFn});Ext.define("SYNO.SDS.VideoPlayerCommonVC.PlayButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(a){this.callParent([a]);this.addClass("big");this.addClass("play-pause");this.addClass("play")},clickHandler:function(){this.getController().play()}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.StopButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(a){this.callParent([a]);this.addClass("stop")},clickHandler:function(){this.getController().stop()}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Slider",{extend:"Ext.slider.SingleSlider",constructor:function(b){var a={animate:false,increment:1,value:0,listeners:{scope:this,change:this.onChange,changecomplete:this.onChangeComplete,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.addClass("vp-slider")},onChange:Ext.emptyFn,onChangeComplete:Ext.emptyFn,onAfterRender:Ext.emptyFn,isDragging:function(){return this.thumbs[0].dragging}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ProgressBar",{extend:"SYNO.SDS.VideoPlayerCommonVC.Slider",progressMax:10000,constructor:function(b){var a={minValue:0,maxValue:this.progressMax};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vp-progress-bar");this.duration=0},updateView:function(a,b){this.duration=b||this.duration;if(Ext.isNumber(this.duration)&&this.duration>0){this.setDisable(false);if(!this.isDragging()){this.setValue(this.progressMax*a/this.duration)}}else{this.setDisable(true)}},insertSeekProgress:function(){if(this.seekProgress){return}this.seekProgress=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"progress"},true);this.seekProgress.setWidth(0);this.halfThumb=12},onAfterRender:function(){this.insertSeekProgress();this.setValue(1);this.setValue(0)},onChange:function(c,d,b){var a=this.duration*d/this.progressMax;this.module.getControlPanel().setPlaybackPosition(a);this.seekProgress.setWidth(b.el.getLeft(true)+this.halfThumb)},onChangeComplete:function(c,d,b){var a=this.duration*d/this.progressMax;if(Ext.isNumber(a)){this.module.getController().seek(a)}},setDisable:function(a){if(a){this.setValue(0);this.seekProgress.setWidth(0);this.disable()}else{this.enable()}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Menu",{extend:"Ext.menu.Menu",constructor:function(b){var a={cls:"syno-vp-menu",listeners:{scope:this,beforerender:function(){this.orig_useShims=Ext.useShims;Ext.useShims=true},afterrender:function(){Ext.useShims=this.orig_useShims;this.keyNav.disable()}}};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ItemMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.Menu",constructor:function(b){var a={defaultOffsets:[0,-11]};this.callParent([Ext.apply(a,b)]);this.addClass("item-menu")},addItemGeneral:function(g,f,a,d,b){var e=Ext.util.Format.ellipsis(f,40,false);var c=new Ext.menu.Item({item_id:g,text:Ext.util.Format.htmlEncode(e),cls:a,group:d||"",scope:this,handler:b,listeners:{render:function(){this.getEl().dom.qtip=Ext.util.Format.htmlEncode(f)}}});this.addItem(c)},addTitle:function(b,a){if(!Ext.isString(b)){return}this.addItemGeneral(Ext.id(),b,"title",a,Ext.emptyFn)},addOneItem:function(f,e,a,c,d){if(!Ext.isDefined(f)||!Ext.isString(e)||!Ext.isFunction(a)){return}var b=function(){this.setItemSelected(f,d);a()};this.addItemGeneral(f,e,((true===c)?"selected":""),d,b)},setItemSelected:function(b,a){if(!this.items||!Ext.isDefined(b)){return}this.items.each(function(c){if(!Ext.isDefined(a)||c.group===a){c.removeClass("selected");c[(c.item_id===b)?"addClass":"removeClass"]("selected")}})},removeGroup:function(a){if(!Ext.isObject(this.items)){return}this.items.each(function(b){if(b.group===a){this.remove(b)}},this)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu",{statics:{ID_NO_SUBTITLE:"no_subtitle",ID_EXTERNAL:"external",ID_BROWSE_SUBTITLE:"browse_subtitle",ID_SHIFT_SUBTITLE:"shift_subtitle"},extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",constructor:function(a){this.callParent([a]);this.addNoSubtitleItem()},addNoSubtitleItem:function(){this.addOneItem(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,_T("video_player","no_subtitle"),this.setNoSubtitle.createDelegate(this),true)},setNoSubtitle:function(){this.button.getController().setSubtitleEnabled(false)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.MenuButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={menu:this.createMenu(),menuAlign:"br-tr"};this.callParent([Ext.apply(a,b)])},createMenu:Ext.emptyFn,getMenuClass:function(){return""}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(a){this.callParent([a]);this.addClass("subtitle")},createMenu:function(){return new SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu({button:this})}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.FullscreenButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={disabled:!SYNO.SDS.VideoPlayerCommonVC.Util.isDomFullscreenSupported()};this.callParent([Ext.apply(a,b)]);this.addClass("fullscreen")},clickHandler:function(){this.getController().fullscreen()}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VolumeButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){this.module=b.module;var a={muted:false,menuAlign:"b-t"};this.callParent([Ext.apply(a,b)]);this.addClass("volume")},createMenu:function(){this.volumePanel=new SYNO.SDS.VideoPlayerCommonVC.VolumePanel({module:this.module});var a=new SYNO.SDS.VideoPlayerCommonVC.Menu({cls:"syno-vp-volume-menu",defaultOffsets:[0,-11],items:[this.volumePanel]});return a},setMute:function(a){this.muted=a;if(this.muted){this.addClass("mute");this.hideMenu()}else{this.removeClass("mute");if(this.getEl().hasClass("x-btn-over")){this.showMenu()}}},setVolume:function(a){this.volumePanel.volumeBar.updateView(a)},clickHandler:function(){this.getController().toggleMute()},onClick:function(a){if(a){a.preventDefault()}if(a.button!==0||this.disabled){return}this.doToggle();this.fireEvent("click",this,a);if(this.handler){this.handler.call(this.scope||this,this,a)}},onMouseOver:function(a){if(!this.muted&&!this.disabled){this.showMenu()}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VolumePanel",{extend:"Ext.Panel",constructor:function(b){this.volumeBar=new SYNO.SDS.VideoPlayerCommonVC.VolumeBar({module:b.module});var a={cls:"vp-volume-panel",frame:true,items:[this.volumeBar]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VolumeBar",{extend:"SYNO.SDS.VideoPlayerCommonVC.Slider",constructor:function(b){var a={cls:"vp-volume-bar",minValue:0,maxValue:100,vertical:true};this.callParent([Ext.apply(a,b)])},updateView:function(a){if(!this.disabled&&!this.isDragging()){this.setValue(a)}},insertVolumeStrip:function(){if(this.volumeStrip){return}this.volumeStrip=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"volume"},true);this.volumeStrip.setHeight(0);this.halfThumb=8},onAfterRender:function(){this.insertVolumeStrip();var a=this.getValue();this.setValue(1);this.setValue(a)},onChange:function(c,d,b){var a=d/100*138;this.volumeStrip.setHeight(a)},onChangeComplete:function(b,c,a){if(!this.disabled){this.module.getController().setVolume(c)}},setDisable:function(a){if(a){this.setValue(0);this.volumeStrip.setWidth(0);this.disable()}else{this.enable()}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.TimeText",{extend:"Ext.Toolbar.TextItem",constructor:function(b){var a={text:"00:00"};this.callParent([Ext.apply(a,b)])},formatTime:function(c){c=parseInt(Math.round(c),10);var a=parseInt(c/3600,10);var d=parseInt((c%3600)/60,10);var b=c%60;return((a>0)?a+":":"")+String.leftPad(d,2,"0")+":"+String.leftPad(b,2,"0")},updateView:function(a){if(!Ext.isNumber(a)||0>=a){this.setText("00:00")}else{this.setText(this.formatTime(a))}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ControlBar",{extend:"SYNO.ux.Toolbar",slashConfig:{cls:"slash",xtype:"tbtext",text:" / "},constructor:function(b){this.module=b.module;var a={items:[{xtype:"tbspacer",width:14},this.getPlayButton(),this.getStopButton(),{xtype:"tbspacer",width:14},{xtype:"tbseparator",cls:"vp-separator"},{xtype:"tbspacer",width:30},this.getPositionText(),this.slashConfig,this.getDurationText(),"->",this.getVolumeButton(),this.getSubtitleButton(),this.getFullscreenButton(),{xtype:"tbspacer",width:14}]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vp-control-bar")},getPlayButton:function(){if(!Ext.isDefined(this.playButton)){this.playButton=new SYNO.SDS.VideoPlayerCommonVC.PlayButton({module:this.module})}return this.playButton},getStopButton:function(){if(!Ext.isDefined(this.stopButton)){this.stopButton=new SYNO.SDS.VideoPlayerCommonVC.StopButton({module:this.module})}return this.stopButton},getPositionText:function(){if(!Ext.isDefined(this.positionText)){this.positionText=new SYNO.SDS.VideoPlayerCommonVC.TimeText({cls:"position"})}return this.positionText},getDurationText:function(){if(!Ext.isDefined(this.durationText)){this.durationText=new SYNO.SDS.VideoPlayerCommonVC.TimeText({cls:"duration"})}return this.durationText},getVolumeButton:function(){if(!Ext.isDefined(this.volumeButton)){this.volumeButton=new SYNO.SDS.VideoPlayerCommonVC.VolumeButton({module:this.module})}return this.volumeButton},getSubtitleButton:function(){if(!Ext.isDefined(this.subtitleButton)){this.subtitleButton=new SYNO.SDS.VideoPlayerCommonVC.SubtitleButton({module:this.module})}return this.subtitleButton},getFullscreenButton:function(){if(!Ext.isDefined(this.fullscreenButton)){this.fullscreenButton=new SYNO.SDS.VideoPlayerCommonVC.FullscreenButton({module:this.module})}return this.fullscreenButton}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Player",{extend:"Ext.util.Observable",constructor:function(b){var a=Ext.apply({subtitle_is_srt:true,name:"",player:null,pluginInit:false},b);this.callParent([a]);Ext.apply(this,a)},canPlayType:Ext.emptyFn,isAvailable:Ext.emptyFn,getName:function(){return this.name},fullscreen:Ext.emptyFn,play:Ext.emptyFn,pause:Ext.emptyFn,resume:Ext.emptyFn,stop:Ext.emptyFn,seek:Ext.emptyFn,getPosition:Ext.emptyFn,getDuration:Ext.emptyFn,getVolume:Ext.emptyFn,setVolume:Ext.emptyFn,getMute:Ext.emptyFn,setMute:Ext.emptyFn,getState:Ext.emptyFn,disablePlayerSubtitle:Ext.emptyFn,setPlayerSubtitle:Ext.emptyFn,setStartPosition:function(a){if(Ext.isNumber(a)&&a>0){this.start_position=a}},notifyClear:function(){this.controller.updateState(SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR)},clear:function(){if(this.player){this.el.remove();this.el=null;this.player=null;this.pluginInit=false;this.notifyClear()}},stateHandler:function(d){var c=this.getState();if(c===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING){this.disablePlayerSubtitle();if(Ext.isNumber(this.start_position)){var a=this.start_position;this.start_position=null;var b=this.seek.createDelegate(this,[a]);b.defer(200)}}this.controller.updateState(c,d)},durationHandler:function(b){var a=Ext.isNumber(b)?b:this.getDuration();this.controller.updateDuration(a)},positionHandler:function(a){var b=Ext.isNumber(a)?a:this.getPosition();this.controller.updatePosition(b)},volumeHandler:function(){this.controller.updateMute(this.getMute());var a=this.getVolume();if(Ext.isNumber(a)&&a>=0&&a<=100){this.controller.updateVolume(a)}},webkitHandler:function(){this.controller.stop();this.controller.play();this.controller.pause()},registerEventHandler:Ext.emptyFn});Ext.define("SYNO.SDS.VideoPlayerCommonVC.HTML5Player",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"HTML5",player_id:"_html5_video_player",stopped:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(b){var a=document.createElement("video"),c=SYNO.SDS.VideoPlayerCommonVC.Util.MimeType[b]||("video/"+b);if(!a||!Ext.isFunction(a.canPlayType)){return false}return a.canPlayType(c)},isAvailable:function(){var a=document.createElement("video");if(!a||!Ext.isFunction(a.canPlayType)){return false}return true},fullscreen:function(){if(this.pluginInit){SYNO.SDS.VideoPlayerCommonVC.Util.setDomFullscreen(this.controller.container.dom)}},play:function(a){this.stopped=false;this.createPlayer();this.player.src=a;this.player.play();this.setVolume(this.controller.volume)},pause:function(){if(this.pluginInit){this.player.pause()}},resume:function(){if(this.pluginInit){this.player.play()}},stop:function(){if(this.pluginInit){this.stopped=true;this.player.pause();this.stateHandler()}},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.duration){this.player.currentTime=a}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.currentTime},getDuration:function(){if(!this.pluginInit){return -1}return this.player.duration},getVolume:function(){if(!this.pluginInit){return -1}return this.player.volume*100},setVolume:function(a){if(this.pluginInit){this.player.volume=a/100}},getMute:function(){var a=false;if(this.pluginInit){a=this.player.muted}return a},setMute:function(a){if(this.pluginInit){this.player.muted=a}},getState:function(){if(!this.pluginInit){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA}if(this.player.error){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR}if(this.player.ended||this.player.HAVE_NOTHING===this.player.readyState||this.stopped){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED}if(this.player.paused){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED}if(this.player.HAVE_CURRENT_DATA>=this.player.readyState){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING}return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING},setVisible:function(a){if(Ext.isSafari&&this.el){this.el.setVisible(a)}},createPlayer:function(){if(this.player){return false}this.el=Ext.get(this.player_id)||this.controller.video.createChild({tag:"video",id:this.player_id,style:{width:"100%",height:"100%"}});this.player=this.el.dom;this.registerEventHandler();this.pluginInit=true;this.el.enableDisplayMode();this.el.show();this.player.pause();return true},registerEventHandler:function(){var a=SYNO.SDS.VideoPlayerCommonVC.Util.addDomListener(false);a(this.player,"play",this.stateHandler,this);a(this.player,"playing",this.stateHandler,this);a(this.player,"waiting",this.stateHandler,this);a(this.player,"pause",this.stateHandler,this);a(this.player,"ended",this.stateHandler,this);a(this.player,"error",this.stateHandler,this);a(this.player,"durationchange",this.durationHandler,this);a(this.player,"timeupdate",this.positionHandler,this);a(this.player,"volumechange",this.volumeHandler,this);a(this.player,"webkitendfullscreen",this.webkitHandler,this)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VLCPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"VLC",player_id:"_vlc_video_player",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(a){return("ogg"!==a)&&("ogv"!==a)},isAvailable:function(){return SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported()},fullscreen:function(){if(this.pluginInit){SYNO.SDS.VideoPlayerCommonVC.Util.setDomFullscreen(this.controller.container.dom)}},play:function(a){this.url=a;if(!this.createPlayer()){this.onVLCReady()}},pause:function(){if(this.pluginInit){this.player.playlist.pause()}},resume:function(){if(this.pluginInit){this.player.playlist.play()}},stop:function(){var a=this.getState();if(this.pluginInit){if(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING||a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED){this.player.playlist.stop()}else{this.stop.defer(100,this,arguments)}}},seek:function(a){var b=a*1000;if(this.pluginInit&&b>=0&&b<=this.player.input.length){this.player.input.time=b}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.input.time/1000},getDuration:function(){if(!this.pluginInit){return -1}return this.player.input.length/1000},getVolume:function(){if(!this.pluginInit){return -1}return this.player.audio.volume},setVolume:function(a){if(this.pluginInit){this.player.audio.volume=a;this.volumeHandler()}},getMute:function(){var a=false;if(this.pluginInit){a=this.player.audio.mute}return a},setMute:function(a){if(this.pluginInit){this.player.audio.mute=a;this.volumeHandler()}},StateMap:{0:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA,1:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,2:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,3:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING,4:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED,5:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,6:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,7:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR},getPlayerState:function(){var a=1;try{a=this.player.input.state}catch(b){}if(a===7){this.error=true}return a},getState:function(){if(!this.pluginInit){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA}if(this.error){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR}var a=this.StateMap[this.getPlayerState()]||SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;return a},disablePlayerSubtitle:function(){if(this.pluginInit&&this.subtitle_is_srt===true){var c=this.player.VersionInfo.match(/\d+/g);var a=parseInt(c[0],10);var b=parseInt(c[1],10);if(a<2||(a==2&&b<2)){this.player.subtitle.track=-1}else{if(this.player.subtitle.count>0){this.player.subtitle.track=0}}}},setPlayerSubtitle:function(a){if(this.pluginInit&&this.subtitle_is_srt!==true){this.player.subtitle.track=a}},createPlayer:function(){if(this.player){return false}this.el=SYNO.SDS.VideoPlayerCommonVC.Util.createVLCElement(this.controller.video,this.player_id);this.player=this.el.dom;this.registerEventHandler();this.el.enableDisplayMode();this.el.show();this.pluginInit=true;this.onVLCReady();return true},onVLCReady:function(){if(!this.player){return}if(!this.player.VersionInfo){this.onVLCReady.defer(100,this);return}this.fitPlayer.defer(100,this);this.fitPlayer.defer(500,this);if(Ext.isString(this.url)){if(this.player.playlist.items&&this.player.playlist.items.count>0){this.player.playlist.items.clear()}this.playlistItemId=this.player.playlist.add(this.url);this.player.playlist.playItem(this.playlistItemId)}if(Ext.isIE){this.adjustPlayerWidthHack()}return},fitPlayer:function(){if(this.el){this.el.setSize("100%","100%")}},adjustPlayerWidthHack:function(){if(this.el){this.el.setWidth(this.el.getWidth()+1);this.el.setWidth(this.el.getWidth()-1)}},durationHandler:function(b){var a=Ext.isNumber(b)?(b/1000):null;this.callParent([a])},positionHandler:function(a){this.callParent([a/1000])},stateHandler:function(){this.setVolume.defer(1000,this,[this.controller.volume]);this.durationHandler();this.callParent(arguments)},registerEventHandler:function(){var a=SYNO.SDS.VideoPlayerCommonVC.Util.addDomListener(true);a(this.player,"MediaPlayerOpening",this.stateHandler,this);a(this.player,"MediaPlayerPlaying",this.stateHandler,this);a(this.player,"MediaPlayerPaused",this.stateHandler,this);a(this.player,"MediaPlayerStopped",this.stateHandler,this);a(this.player,"MediaPlayerEndReached",this.stateHandler,this);a(this.player,"MediaPlayerEncounteredError",this.stateHandler,this);a(this.player,"MediaPlayerTimeChanged",this.positionHandler,this);a(this.player,"MediaPlayerLengthChanged",this.durationHandler,this)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.FlashPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"Flash",player_id:"_flash_video_player",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(a){var b=["mp4","mov","m4v","flv","f4v"];return(-1!==b.indexOf(a))},isAvailable:function(){return SYNO.SDS.VideoPlayerCommonVC.Util.detectPlugin("ShockwaveFlash.ShockwaveFlash","Shockwave","Flash")},fullscreen:function(){if(this.pluginInit){SYNO.SDS.VideoPlayerCommonVC.Util.setDomFullscreen(this.controller.container.dom)}},play:function(a){this.error=false;this.url=a;if(!this.createPlayer()){this.player.load([{file:this.url}])}},pause:function(){if(this.pluginInit){this.player.pause(true)}},resume:function(){if(this.pluginInit){this.player.play(true)}},stop:function(){if(this.pluginInit){this.player.stop()}},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.getDuration()){this.player.seek(a)}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.getPosition()},getDuration:function(){if(!this.pluginInit){return -1}return this.player.getDuration()},getVolume:function(){if(!this.pluginInit){return -1}return this.player.getVolume()},setVolume:function(a){if(this.pluginInit){this.player.setVolume(a)}},getMute:function(){if(!this.pluginInit){return false}return this.player.getMute()},setMute:function(a){if(this.pluginInit){this.player.setMute(a)}},StateMap:{IDLE:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,BUFFERING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,PLAYING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING,PAUSED:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED},getPlayerState:function(){if(!this.pluginInit){return"IDLE"}return this.player.getState()},getState:function(){if(!this.pluginInit){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA}if(this.error){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR}var a=this.StateMap[this.getPlayerState()]||SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;return a},clear:function(){this.delayDestroy.defer(1,this,arguments)},delayDestroy:function(){if(this.player){this.player.remove();this.el.remove();this.el=null;this.el=Ext.get(this.player_id);this.el.remove();this.el=null;this.player=null;this.pluginInit=false;this.notifyClear()}},onReady:function(){this.pluginInit=true;this.player=jwplayer(this.player_id);this.registerEventHandler();this.setVolume(this.controller.volume)},onError:function(){this.error=true;this.stateHandler()},onPlaylist:function(){this.player.playlistItem(0)},onTime:function(a){if(!Ext.isObject(a)){return}if(Ext.isNumber(a.duration)){this.durationHandler(a.duration)}if(Ext.isNumber(a.position)){this.positionHandler(a.position)}},createPlayer:function(){if(this.player){return false}if(!Ext.isDefined(window.jwplayer)){this.loadJWScript();return true}this.el=Ext.get(this.player_id)||this.controller.video.createChild({tag:"div",id:this.player_id,style:{width:"100%",height:"100%"}});var b=String.format("{0}/skin/empty-controlbar.xml",this.controller.jsBaseURL);var a=String.format("{0}/jwplayer.flash.swf?v=6.8.4616",this.controller.jsBaseURL);this.player=jwplayer(this.player_id).setup({fallback:false,flashplayer:a,file:this.url,controls:false,autostart:false,skin:b,height:"100%",width:"100%",stretching:"uniform",primary:"flash",analytics:{enabled:false}});this.registerSetupHandler();return true},registerSetupHandler:function(){jwplayer(this.player_id).onReady(this.onReady.createDelegate(this));jwplayer(this.player_id).onSetupError(this.onError.createDelegate(this))},registerEventHandler:function(){this.player.onPlaylist(this.onPlaylist.createDelegate(this));this.player.onPlaylistComplete(this.stateHandler.createDelegate(this));this.player.onPlay(this.stateHandler.createDelegate(this));this.player.onPause(this.stateHandler.createDelegate(this));this.player.onBuffer(this.stateHandler.createDelegate(this));this.player.onIdle(this.stateHandler.createDelegate(this));this.player.onComplete(this.stateHandler.createDelegate(this));this.player.onError(this.onError.createDelegate(this));this.player.onTime(this.onTime.createDelegate(this));this.player.onMute(this.volumeHandler.createDelegate(this));this.player.onVolume(this.volumeHandler.createDelegate(this))},loadJWScript:function(){var a=document.getElementsByTagName("head")[0];var b=document.createElement("script");var e=String.format("{0}/jwplayer.js?v=6.8.4616",this.controller.jsBaseURL);var d=this.setJWPlayerKey.createSequence(this.createPlayer,this);b.type="text/javascript";if(Ext.isIE){b.onready=d;b.onreadystatechange=function c(){if("complete"!==this.readyState&&"loaded"!==this.readyState){return}this.onready()}}else{b.onload=d}b.src=e;a.appendChild(b)},setJWPlayerKey:function(){if(jwplayer.key){return}jwplayer.key="ADrNpyYVQ13xVOfDuZpCXl4Bioq40D0Omx8S/CIM46w="}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.NullPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"Null",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(){return false},isAvailable:function(){return true},play:function(){this.error=true;var a=!Ext.isMac&&!SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported();this.stateHandler(a?_T("video_player","error_play_vlc"):_T("video_player","error_play"))},getState:function(){return this.error?SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleParser",{extend:"Ext.util.Observable",subtitles:null,destroy:function(){delete this.subtitles},parseSeconds:function(d){if(!d){return}var a=0;var c=d.split(":");if(c.length>3){return}for(var b=0;b<c.length;++b){a=a*60+parseFloat(c[b].replace(",","."))}return a},parseSrt:function(f){var d=f.replace(/\r\n|\r/g,"\n").trim();var e=d.split("\n\n");this.clear();for(var b=0;b<e.length;++b){var c=e[b].split("\n");if(c.length<3){continue}c.shift();var a=c.shift().split(" --> ");this.subtitles.push({from:this.parseSeconds(a[0]),to:this.parseSeconds(a[1]),text:c.join("<br/>")})}this.subtitles.sort(function(h,g){return(h.from<g.from?-1:1)})},clear:function(){this.subtitles=[]},getText:function(c){var e=this.subtitles;var d=[];if(!e){return""}for(var a=0;a<e.length;++a){var b=e[a];if(c<b.from){break}if(b.from<=c&&c<=b.to){d.push(b.text)}}return d.join("<br/>")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Controller",{extend:"Ext.util.Observable",constructor:function(b){this.addEvents({statechange:true,mutechange:true,volumechange:true,timechange:true,subtitlechange:true});var a=Ext.apply({subtitle_visible:false,mute:false,state:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,volume:50,position:0,duration:0,initPlaying:false},b);Ext.apply(this,a);this.callParent([a]);this.initPlayers()},onStateChange:function(a,b){this.fireEvent("statechange",a,b)},onMuteChange:function(a){this.fireEvent("mutechange",a)},onVolumeChange:function(a){this.fireEvent("volumechange",a)},onTimeChange:function(a,b){this.fireEvent("timechange",a,b)},onSubtitleChange:function(b,a){this.fireEvent("subtitlechange",b,a)},initPlayers:function(){var a;a=[new SYNO.SDS.VideoPlayerCommonVC.NullPlayer({controller:this}),new SYNO.SDS.VideoPlayerCommonVC.HTML5Player({controller:this}),this.flashPlayer(),new SYNO.SDS.VideoPlayerCommonVC.VLCPlayer({controller:this})];this.players=[];Ext.each(a,function(b){if(b.isAvailable()){this.players.push(b)}},this)},flashPlayer:function(){return new SYNO.SDS.VideoPlayerCommonVC.FlashPlayer({controller:this})},updatePlayer:function(d){var a=d.filename;var b;if(Ext.isString(a)){var c=SYNO.SDS.VideoPlayerCommonVC.Util.getFileExt(a);Ext.each(this.players,function(e){if(e.canPlayType(c)){b=e;return false}},this)}this.player=b||this.players[0]},selectPlayer:function(a){var b=null;Ext.each(this.players,function(c){if(a===c.getName()){b=c;return false}});if(b===null){b=this.players[0]}this.player=b;return b},getPlayer:function(){if(Ext.isObject(this.player)){return this.player}return this.players[0]},play:function(b){switch(this.state){case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:var a=this.play.createDelegate(this,arguments);this.initPlaying=false;this.updateState(SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA);this.stop(a);break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED:this.initPlaying=true;this.url=b||this.url;this.playCurrentVideo();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING:this.getPlayer().pause();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED:this.getPlayer().resume();break;default:break}},playCurrentVideo:function(){this.getPlayer().play(this.url)},stop:function(a){if(!this.getPlayer().pluginInit){if(Ext.isFunction(a)){a()}return}this.clearCallback=a;this.getPlayer().stop()},updateState:function(a,b){this.state=a;if(!this.initPlaying&&a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED){this.getPlayer().clear();this.updateDuration(0);this.updatePosition(0)}if(this.initPlaying&&(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING||a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING)){this.initPlaying=false}if(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR){b=Ext.isString(b)?b:_T("video_player","error_play")}this.onStateChange(this.state,b);if(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR&&Ext.isFunction(this.clearCallback)){var c=this.clearCallback;this.clearCallback=null;c()}},toggleMute:function(){this.getPlayer().setMute(!this.mute)},updateMute:function(a){this.mute=a;this.onMuteChange(this.mute)},setVolume:function(a){this.getPlayer().setVolume(a)},updateVolume:function(a){this.volume=a;this.onVolumeChange(this.volume)},updateDuration:function(a){this.duration=a;this.onTimeChange(this.position,this.duration)},seek:function(a){this.getPlayer().seek(a)},updatePosition:function(a){this.position=a;this.onTimeChange(this.position,this.duration)},fullscreen:function(){this.getPlayer().fullscreen()},isSubtitleVisible:function(){return this.subtitle_visible},setSubtitleEnabled:function(b,a){this.subtitle_visible=b;this.onSubtitleChange(b,a)},getSubtitleParser:function(){if(!Ext.isDefined(this.subtitle_parser)){this.subtitle_parser=new SYNO.SDS.VideoPlayerCommonVC.SubtitleParser()}return this.subtitle_parser}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ControlPanel",{extend:"Ext.Container",constructor:function(b){this.module=b.module;var a={overCls:"control-panel-over",items:[this.getProgressBar(),this.getControlBar()]};this.callParent([Ext.apply(a,b)])},getControlBar:function(){if(!Ext.isDefined(this.controlBar)){this.controlBar=new SYNO.SDS.VideoPlayerCommonVC.ControlBar({module:this.module})}return this.controlBar},getProgressBar:function(){if(!Ext.isDefined(this.progressBar)){this.progressBar=new SYNO.SDS.VideoPlayerCommonVC.ProgressBar({module:this.module})}return this.progressBar},setMute:function(a){this.getControlBar().getVolumeButton().setMute(a)},setVolume:function(a){this.getControlBar().getVolumeButton().setVolume(a)},setState:function(b,c){var a=this.getControlBar().getPlayButton();switch(b){case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:a.removeClass("pause");a.addClass("play");break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING:a.removeClass("play");a.addClass("pause");break;default:break}a.setDisabled(b===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR)},setTime:function(a,c){var b=this.getProgressBar();b.updateView(a,c);this.setPlaybackDuration(c)},setPlaybackPosition:function(a){this.getControlBar().getPositionText().updateView(a)},setPlaybackDuration:function(a){this.getControlBar().getDurationText().updateView(a)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.AppWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(b){var a={dsmStyle:"v5",showHelp:false,cls:"syno-vp-appwin",minHeight:480,minWidth:720,items:[this.getDisplay()],bbar:this.getControlPanel()};this.callParent([Ext.apply(a,b)])},getDisplay:function(){if(!Ext.isDefined(this.display)){this.display=new SYNO.SDS.VideoPlayerCommonVC.Display()}return this.display},getControlPanel:function(){if(!Ext.isDefined(this.control_panel)){this.control_panel=new SYNO.SDS.VideoPlayerCommonVC.ControlPanel({module:this})}return this.control_panel},setState:function(a,b){this.getDisplay().setState(a,b);this.getControlPanel().setState(a,b)},setTime:function(a,b){if(this.getController().isSubtitleVisible()){var c=this.getController().getSubtitleParser().getText(a);this.getDisplay().setSubtitle(c)}this.getControlPanel().setTime(a,b)},setSubtitle:function(a){this.getDisplay().showSubtitle(a)}});Ext.define("SYNO.VideoController2.ChannelStore",{extend:"SYNO.API.Store",ChannelRecord:Ext.data.Record.create([{name:"channel",type:"int"},{name:"id",type:"string"},{name:"title",type:"string"}]),constructor:function(b){var a={api:"SYNO.DTV.Channel",method:"list",version:1,baseParams:{offset:0,limit:-1},reader:new Ext.data.JsonReader({root:"channels"},this.ChannelRecord)};this.callParent([Ext.apply(a,b)])}});_VCT=function(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}};Ext.define("SYNO.VideoController2.Util",{statics:{REPEAT_NONE:0,REPEAT_ALL:1,REPEAT_ONE:2,APIErrorStringMap:{"SYNO.VideoStation.Streaming":{413:_VCT("controller","unsupported_format"),420:_VCT("controller","in_transcoding"),421:_VCT("controller","unsupported_format"),439:_VCT("controller","unsupported_audio_codec"),440:_VCT("controller","unsupported_format")},"SYNO.DTV.Streaming":{425:_VCT("controller","unsupported_format"),442:_VCT("controller","unsupported_transcode_channel"),443:_VCT("controller","dtv_bad_signal")},"SYNO.VideoController.Playback":{400:_VCT("controller","error_state"),450:_VCT("controller","unsupported_format"),451:_VCT("controller","in_transcoding"),452:_VCT("controller","unsupported_audio_codec"),453:_VCT("controller","unsupported_format")},"SYNO.VideoController.Volume":{400:_VCT("controller","error_state")},"SYNO.VideoController.Password":{400:_VCT("controller","error_state")}},STREAMING_ID:"streaming",PLAYERTYPE_STREAMING:"streaming",PLAYERTYPE_AIRPLAY:"airplay",PLAYERTYPE_UPNP:"upnp",getErrorString:function(a,b){if(!Ext.isObject(a)){return""}var g;var c=a.code;if(Ext.isArray(a.errors)&&a.errors.length>0){var f=a.errors[0];if(Ext.isNumber(f.code)){c=f.code}}c=Ext.isNumber(c)?c:100;try{if(c<400){g=SYNO.API.Erros.common[c]||_T("common","error_error_system")}else{g=SYNO.VideoController2.Util.APIErrorStringMap[b][c]||_T("common","error_error_system")}}catch(d){g=_T("common","error_error_system")}return g},getHost:function(){return String.format("{0}//{1}",window.location.protocol,window.location.host)},getDisplayResolution:function(b){if(!Ext.isDefined(b)||!Ext.isNumber(b.resolutionx)||!Ext.isNumber(b.resolutiony)||!Ext.isNumber(b.sample_aspect_ratio_den)||!Ext.isNumber(b.sample_aspect_ratio_num)){return null}var a=(b.sample_aspect_ratio_den>0)?b.sample_aspect_ratio_num/b.sample_aspect_ratio_den:1;return 90===b.rotate||270===b.rotate?{width:b.resolutiony/a,height:b.resolutionx}:{width:b.resolutionx,height:b.resolutiony/a}},getStreamURL:function(c,a){var d={api:"SYNO.VideoStation.Streaming",method:"stream",version:1,_sid:Ext.util.Cookies.get("id"),id:c,format:a};SYNO.VideoController2.Util.applySharingID(d);var b=String.format("{0}{1}/{2}/1.m3u8",SYNO.VideoController2.Util.getHost(),"/webapi/VideoStation","vtestreaming.cgi");return Ext.urlAppend(b,Ext.urlEncode(d))},getExtM3U:function(c,a,b,d){var f={width:c,height:a,url:b};var e=String.format("{0}/cgi/{1}/1.m3u8",d,"extm3u.cgi");return Ext.urlAppend(e,Ext.urlEncode(f))},getLiveStreamURL:function(b,a){var c={api:"SYNO.DTV.Streaming",method:"stream",version:1,tuner:b,stream_id:a,format:"hls"};return Ext.urlAppend("/webapi/VideoStation/dtvstreaming.cgi/1.m3u8",Ext.urlEncode(c))},getImageURL:function(b,a){var c={api:"SYNO.VideoStation.Poster",method:"getimage",version:1,id:b,type:a};SYNO.VideoController2.Util.applySharingID(c);if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(c,{hr:2})}return Ext.urlAppend("/webapi/VideoStation/poster.cgi",Ext.urlEncode(c))},toHex:function(c){var b="";for(var a=0;a<c.length;++a){b+=c.charCodeAt(a).toString(16)}return b},roundPercentage:function(a){return Ext.isNumber(a)?Math.round(parseFloat(a)*100):NaN},tryCallback:function(a){if(Ext.isFunction(a)){a()}},isPublicSharing:function(){return _S("IsPublicSharing")===true},isMobile:function(){return _S("IsMobile")===true},getSharingID:function(){return SYNO.VideoController2.Util.isPublicSharing()?_S("SharingId"):""},applySharingID:function(a){if(SYNO.VideoController2.Util.isPublicSharing()){a.sharing_id=SYNO.VideoController2.Util.getSharingID()}},getIDorPathParam:function(a){var b={};if(Ext.isString(a)){b={path:a}}else{b={id:a}}return b},isWebPlayableMP4:function(a,b){if(b!=="mp3"&&b.indexOf("aac")===-1){return false}if(Ext.isMac&&Ext.isSafari&&a=="mpeg4"){return true}return a==="h264"},getComboBoxCodepageList:function(b){var a=[["BIG5",_T("texteditor","chinese_traditional")+" (BIG5)"],["BIG5-HKSCS",_T("texteditor","chinese_traditional")+" (BIG5-HKSCS)"],["GBK",_T("texteditor","chinese_simplified")+" (GBK)"],["GB18030",_T("texteditor","chinese_simplified")+" (GB18030)"],["EUC-JP",_T("texteditor","japanese")+" (EUC-JP)"],["SHIFT_JIS",_T("texteditor","japanese")+" (SHIFT_JIS)"],["ISO-2022-JP",_T("texteditor","japanese")+" (ISO-2022-JP)"],["EUC-KR",_T("texteditor","korean")+" (EUC-KR)"],["CP949",_T("texteditor","korean")+" (CP949)"],["CP1258",_T("texteditor","vietnamese")+" (CP1258)"],["VISCII",_T("texteditor","vietnamese")+" (VISCII)"],["TIS-620",_T("texteditor","thai")+" (TIS-620)"],["ISO-8859-11",_T("texteditor","thai")+" (ISO-8859-11)"],["ISO-8859-2",_T("texteditor","central_european")+" (ISO-8859-2)"],["CP1250",_T("texteditor","central_european")+" (CP1250)"],["ISO-8859-10",_T("texteditor","nordic")+" (ISO-8859-10)"],["ISO-8859-1",_T("texteditor","western")+" (ISO-8859-1)"],["ISO-8859-15",_T("texteditor","western")+" (ISO-8859-15)"],["CP1252",_T("texteditor","western")+" (CP1252)"],["Macintosh",_T("texteditor","western")+" (Macintosh)"],["CP1254",_T("texteditor","turkish")+" (CP1254)"],["CP1255",_T("texteditor","hebrew")+" (CP1255)"],["ISO-8859-8",_T("texteditor","hebrew")+" (ISO-8859-8)"],["ISO-8859-7",_T("texteditor","greek")+" (ISO-8859-7)"],["CP1253",_T("texteditor","greek")+" (CP1253)"],["CP1256",_T("texteditor","arabic")+" (CP1256)"],["ISO-8859-6",_T("texteditor","arabic")+" (ISO-8859-6)"],["ISO-8859-4",_T("texteditor","baltic")+" (ISO-8859-4)"],["ISO-8859-13",_T("texteditor","baltic")+" (ISO-8859-13)"],["CP1257",_T("texteditor","baltic")+" (CP1257)"],["ISO-8859-3",_T("texteditor","south_european")+" (ISO-8859-3)"],["ISO-8859-5",_T("texteditor","cyrillic")+" (ISO-8859-5)"],["CP1251",_T("texteditor","cyrillic")+" (CP1251)"],["KOI8-R",_T("texteditor","cyrillic")+" (KOI8-R)"],["KOI8-U",_T("texteditor","cyrillic")+" (KOI8-U)"],["ISO-8859-14",_T("texteditor","celtic")+" (ISO-8859-14)"],["ISO-8859-16",_T("texteditor","romanian")+" (ISO-8859-16)"],["ARMSCII-8",_T("texteditor","armenian")+" (ARMSCII-8)"],["Georgian-Academy",_T("texteditor","georgian")+" (Georgian-Academy)"],["KOI8-T",_T("texteditor","tajik")+" (KOI8-T)"],["CP1133",_T("texteditor","laotian")+" (CP1133)"],["PT154",_T("texteditor","kazakh")+" (PT154)"]];a.sort(function(d,c){return d[1].localeCompare(c[1])});a.unshift(["UTF-16",_T("texteditor","unicode")+" (UTF-16)"]);a.unshift(["UTF-8_withBOM",_T("texteditor","unicode")+" (UTF-8 with BOM)"]);a.unshift(["UTF-8",_T("texteditor","unicode")+" (UTF-8)"]);if(b){a.unshift(["auto",_T("texteditor","AutoDetect")])}return a},SubtitleExtensions:{ssa:"plain_text",ass:"plain_text",srt:"plain_text",smi:"plain_text",sami:"plain_text"},TextFileExtensions:{abap:"abap",as:"actionsctipt",ada:"ada",s:"assembly_x86",ahk:"autohotkey",bat:"batchfile",c:"c_cpp",cpp:"c_cpp",clj:"clojure",edn:"clojure",cbl:"cobol",coffee:"coffee",cfm:"coldfusion",cs:"csharp",css:"css",d:"d",dart:"dart",diff:"diff",dot:"dot",ejs:"ejs",erl:"erlang",f:"forth",fth:"forth",forth:"forth",ftl:"ftl",glsl:"glsl",go:"golang",groovy:"groovy",haml:"haml",handlebars:"handlebars",hs:"haskell",hx:"haxe",ht3:"html",htm:"html",html:"html",htmls:"html",ini:"ini",jack:"jack",jade:"jade",java:"java",js:"javascript",json:"json",jsp:"jsp",jsx:"jsx",jl:"julia",latex:"latex",less:"less",liquid:"liquid",lisp:"lisp",ls:"livescript",lsl:"lsl",lua:"lua",mk:"makefile",markdown:"markdown",m:"matlab",mysql:"mysql",nix:"nix",ocaml:"ocaml",pascal:"pascal",perl:"perl",php:"php",txt:"plain_text",pl:"prolog",py:"python",r:"r",rhtml:"rhtml",rb:"ruby",rbw:"ruby",rs:"rust",sass:"sass",scad:"scad",scala:"scala",scm:"scheme",ss:"scheme",scss:"scss",sh:"sh",sjs:"sjs",sql:"sql",styl:"stylus",svg:"svg",tcl:"tcl",tex:"tex",textile:"textile",vb:"vbscript",v:"verilog",vhdl:"vhdl",xml:"xml",xq:"xquery",xqy:"xquery",xquery:"xquery",yml:"yaml",yaml:"yaml","!!!":"plain_text","$00":"plain_text","$01":"plain_text","$02":"plain_text","$04":"plain_text","$05":"plain_text","$o1":"plain_text","$ol":"plain_text","001":"plain_text","12da":"plain_text","1st":"plain_text","7":"plain_text","82t":"plain_text","92t":"plain_text",abl:"plain_text",ac:"plain_text",adiumhtmllog:"plain_text",adiumlog:"plain_text",adl:"plain_text",adt:"plain_text",adw:"plain_text",aiml:"plain_text",alx:"plain_text",aml:"plain_text",android:"plain_text",annot:"plain_text",ans:"plain_text",ansi:"plain_text",application:"plain_text",aprj:"plain_text",apx:"plain_text",aqt:"plain_text",arff:"plain_text",ARTask:"plain_text",asc:"plain_text",ascii:"plain_text",asl:"plain_text",asp:"plain_text",ass:"plain_text",assoc:"plain_text",atc:"plain_text",att:"plain_text",awa:"plain_text",awb:"plain_text",awd:"plain_text",awh:"plain_text",awp:"plain_text",axt:"plain_text",ba1:"plain_text",bad:"plain_text",bas:"plain_text",bbs:"plain_text",bbxt:"plain_text",bcr:"plain_text",bdp:"plain_text",bdr:"plain_text",bea:"plain_text",bel:"plain_text",bep:"plain_text",big:"plain_text",big5:"plain_text",bk:"plain_text",blm:"plain_text",bln:"plain_text",blw:"plain_text",bmtp:"plain_text",bna:"plain_text",bnx:"plain_text",bog:"plain_text",box:"plain_text",bpdx:"plain_text",brf:"plain_text",bsdl:"plain_text",bss:"plain_text",bt:"plain_text",bzw:"plain_text",cag:"plain_text",cas:"plain_text",cascii:"plain_text",cc:"plain_text",cd2:"plain_text",charset:"plain_text",cho:"plain_text",chord:"plain_text",cif:"plain_text",cil:"plain_text",ckn:"plain_text",clg:"plain_text",cli:"plain_text",clix:"plain_text",cmd:"plain_text",cmtx:"plain_text",cof:"plain_text",conf:"plain_text",coo:"plain_text",crash:"plain_text",crd:"plain_text",csassembly:"plain_text",csmanifest:"plain_text",csv:"plain_text",ctd:"plain_text",ctf:"plain_text",ctl:"plain_text",ctx:"plain_text",dat:"plain_text",dcd:"plain_text",dce:"plain_text",ddd:"plain_text",ddt:"plain_text",de:"plain_text",dectest:"plain_text",des:"plain_text",desc:"plain_text",dfe:"plain_text",dfm:"plain_text",dii:"plain_text",diskdefines:"plain_text",diz:"plain_text",dk:"plain_text",dkz:"plain_text",dmr:"plain_text",dne:"plain_text",dok:"plain_text",dp:"plain_text",dpv:"plain_text",dqy:"plain_text",drp:"plain_text",dsc:"plain_text",dsml:"plain_text",dtd:"plain_text",dwl:"plain_text",ecsv:"plain_text",edml:"plain_text",edt:"plain_text",efm:"plain_text",eia:"plain_text",emulecollection:"plain_text",en:"plain_text",enc:"plain_text",enf:"plain_text",eng:"plain_text",err:"plain_text",es:"plain_text",esw:"plain_text",etf:"plain_text",etx:"plain_text",euc:"plain_text",ext:"plain_text",extra:"plain_text",faq:"plain_text",fff:"plain_text",ffp:"plain_text",fin:"plain_text",first:"plain_text",flr:"plain_text",fmr:"plain_text",fnx:"plain_text",fon:"plain_text",fr:"plain_text",fra:"plain_text",frm:"plain_text",fsa:"plain_text",full:"plain_text",gbf:"plain_text",gdt:"plain_text",gen:"plain_text",ger:"plain_text",gnu:"plain_text",gpl:"plain_text",gs:"plain_text",gthr:"plain_text",gtx:"plain_text",guide:"plain_text",hdr:"plain_text",hhc:"plain_text",hhs:"plain_text",hlm:"plain_text",hlx:"plain_text",hp8:"plain_text",hsk:"plain_text",htx:"plain_text",hvc:"plain_text",hwl:"plain_text",hz:"plain_text",id31:"plain_text",id32:"plain_text",idc:"plain_text",idt:"plain_text",idx:"plain_text",iem:"plain_text",igv:"plain_text",igy:"plain_text",iif:"plain_text",ill:"plain_text",inc:"plain_text",inuse:"plain_text",ion:"plain_text",ipr:"plain_text",iqy:"plain_text",isr:"plain_text",it:"plain_text",ivp:"plain_text",ja:"plain_text",jad:"plain_text",jam:"plain_text",jeb:"plain_text",jis:"plain_text",jp1:"plain_text",jss:"plain_text",jtx:"plain_text",kahl:"plain_text",kar:"plain_text",kch:"plain_text",kix:"plain_text",klg:"plain_text",kor:"plain_text",la:"plain_text",label:"plain_text",las:"plain_text",lay:"plain_text",lin:"plain_text",linux:"plain_text",linx:"plain_text",lnc:"plain_text",log:"plain_text",lo_:"plain_text",lrc:"plain_text",lst:"plain_text",ltr:"plain_text",ltt:"plain_text",ltx:"plain_text",lue:"plain_text",luf:"plain_text",lwd:"plain_text",lxfml:"plain_text",lyr:"plain_text",lyt:"plain_text",man:"plain_text",manifest:"plain_text",map:"plain_text",mar:"plain_text",mathml:"plain_text",maxFR:"plain_text",mcw:"plain_text",md:"plain_text",mdl:"plain_text",mdle:"plain_text",mdown:"plain_text",mdtext:"plain_text",mdtxt:"plain_text",mdwn:"plain_text",me:"plain_text",mez:"plain_text",mf:"plain_text",mib:"plain_text",mit:"plain_text",mkd:"plain_text",mkdn:"plain_text",mno:"plain_text",mnu:"plain_text",modd:"plain_text",mpsub:"plain_text",mss:"plain_text",mtx:"plain_text",mtxt:"plain_text",mvg:"plain_text",mw:"plain_text",nbr:"plain_text",nclk:"plain_text",ncm:"plain_text","new":"plain_text",nfo:"plain_text",nlc:"plain_text",nmbd:"plain_text",nokogiri:"plain_text",not:"plain_text",notes:"plain_text",now:"plain_text",npdt:"plain_text",nt:"plain_text",nwctxt:"plain_text",ocr:"plain_text",odc:"plain_text",oh:"plain_text",ojp:"plain_text",omn:"plain_text",oogl:"plain_text",oot:"plain_text",opc:"plain_text",openbsd:"plain_text",opml:"plain_text",ort:"plain_text",osi:"plain_text",p3x:"plain_text",panic:"plain_text",pbd:"plain_text",pc5:"plain_text",pcl:"plain_text",pd:"plain_text",pdu:"plain_text",pfs:"plain_text",pgw:"plain_text",pjs:"plain_text",pla:"plain_text",plf:"plain_text",plg:"plain_text",plist:"plain_text",plk:"plain_text",pln:"plain_text",pml:"plain_text",pmo:"plain_text",pod:"plain_text",prc:"plain_text",prn:"plain_text",pro:"plain_text",prr:"plain_text",ps:"plain_text",psb:"plain_text",psi2:"plain_text",pt3:"plain_text",pts:"plain_text",pvj:"plain_text",pvw:"plain_text","q&a":"plain_text",qdt:"plain_text",qud:"plain_text",rbdf:"plain_text",rdf:"plain_text",rea:"plain_text",readme:"plain_text",reg:"plain_text",rel:"plain_text",rep:"plain_text",resp:"plain_text",rest:"plain_text",rff:"plain_text",ris:"plain_text",rml:"plain_text",rqy:"plain_text",rst:"plain_text",rt:"plain_text",rtf:"plain_text",rtl:"plain_text",rtx:"plain_text",ru:"plain_text",rus:"plain_text",rzk:"plain_text",rzn:"plain_text",s19:"plain_text",s2k:"plain_text",sami:"plain_text",sbv:"plain_text",sct:"plain_text",sdnf:"plain_text",sen:"plain_text",seq:"plain_text",set:"plain_text",sfb:"plain_text",sgp:"plain_text",sha1:"plain_text",sha512:"plain_text",skcard:"plain_text",skv:"plain_text",sls:"plain_text",smali:"plain_text",smf:"plain_text",smi:"plain_text",sms:"plain_text",snw:"plain_text",soap:"plain_text",soundscript:"plain_text",spa:"plain_text",spec:"plain_text",spg:"plain_text",spn:"plain_text",spx:"plain_text",srt:"plain_text",srx:"plain_text",ssa:"plain_text",ssf:"plain_text",st1:"plain_text",stf:"plain_text",stq:"plain_text",strings:"plain_text",sub:"plain_text",syn:"plain_text",t:"plain_text",t2t:"plain_text",tab:"plain_text",tbd:"plain_text",tbl:"plain_text",tbx:"plain_text",tce:"plain_text",tcm:"plain_text",tdf:"plain_text",ted:"plain_text",text:"plain_text",textclipping:"plain_text",tfw:"plain_text",tgf:"plain_text",thml:"plain_text",thp:"plain_text",tlb:"plain_text",tle:"plain_text",tlx:"plain_text",tm:"plain_text",tml:"plain_text",tmprtf:"plain_text",tmx:"plain_text",tnef:"plain_text",tph:"plain_text",tpl:"plain_text",trn:"plain_text",trt:"plain_text",tsv:"plain_text",tt:"plain_text",ttbl:"plain_text",tte:"plain_text",ttf:"plain_text",ttpl:"plain_text",ttxt:"plain_text",tx8:"plain_text","tx?":"plain_text",txa:"plain_text",txd:"plain_text",txe:"plain_text",txh:"plain_text",u3i:"plain_text",uax:"plain_text",uhtml:"plain_text",uk:"plain_text",unauth:"plain_text",uni:"plain_text",unx:"plain_text",us:"plain_text",usa:"plain_text",user:"plain_text",usf:"plain_text",usg:"plain_text",utf8:"plain_text",utx:"plain_text",utxt:"plain_text",ver:"plain_text",vet:"plain_text",vfk:"plain_text",vhd:"plain_text",vis:"plain_text",vkp:"plain_text",vmg:"plain_text",vmsg:"plain_text",vna:"plain_text",vsmproj:"plain_text",vw:"plain_text",vw3:"plain_text",vxml:"plain_text",wer:"plain_text",wir:"plain_text",wkf:"plain_text",wn:"plain_text",wrd:"plain_text",wrl:"plain_text",wsc:"plain_text",wst:"plain_text",wtf:"plain_text",wtl:"plain_text",wtx:"plain_text",x20:"plain_text",x60:"plain_text",x70:"plain_text",x80:"plain_text",x90:"plain_text",xb0:"plain_text",xc0:"plain_text",xct:"plain_text",xd0:"plain_text",xdl:"plain_text",xdp:"plain_text",xfd:"plain_text",xff:"plain_text",xhtm:"plain_text",xlf:"plain_text",xsd:"plain_text",xsl:"plain_text",xslt:"plain_text",xsr:"plain_text",xwp:"plain_text",xy:"plain_text",xy3:"plain_text",xyp:"plain_text",xyw:"plain_text",xyz:"plain_text",zanebug:"plain_text",zed:"plain_text",zhp:"plain_text",zib:"plain_text",zw:"plain_text",zxe:"plain_text",_me:"plain_text"}}});Ext.define("SYNO.VideoController2.SupportFileVideo",{});Ext.define("SYNO.VideoController2.FlashPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.FlashPlayer",AbleToRemux:function(d){if(true!==this.controller.support_remux){return false}var a=d.container_type;var c=d.video_codec;var b=("h264"===c)&&("mp4"===a||"matroska,webm"===a);return b},AbleToTranscode:function(){var a=(true===this.controller.support_transcode);return a},clear:function(){this.callParent(arguments);this.closeStream()},stop:function(){this.callParent(arguments);this.closeStream()},closeStream:function(){if(Ext.isEmpty(this.controller.stream_id)||Ext.isEmpty(this.controller.stream_format)){return}var a={async:false,api:"SYNO.VideoStation.Streaming",method:"close",version:1,params:{id:this.controller.stream_id,format:this.controller.stream_format},scope:this,callback:function(e,d,c,b){if(e){this.controller.stream_id=null;this.controller.stream_format=null}}};SYNO.VideoController2.Util.applySharingID(a.params);SYNO.API.Request(a)}});Ext.define("SYNO.VideoController2.RemotePlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",PlaybackAPI:{api:"SYNO.VideoController.Playback",version:1},VolumeAPI:{api:"SYNO.VideoController.Volume",version:1},constructor:function(b){var a={name:"Remote",pluginInit:true,initPlaying:false,state:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,volume:50,volume_adjustable:true,seekable:true};this.callParent([Ext.apply(a,b)])},AbleToPlayRaw:function(c){if(this.type!==SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY){return true}if(c.container_type!=="mp4"){return false}var b=c.video_codec;if(b!=="mpeg4"&&b!=="h264"&&b!=="mjpeg"){return false}var a=c.audio_codec;if(a.indexOf("aac")===-1&&a.indexOf("ac3")===-1&&a.indexOf("mp3")===-1){return false}return true},AbleToRemux:function(d){if(true!==this.controller.support_remux||this.type!==SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY){return false}var a=d.container_type;var c=d.video_codec;var b=("h264"===c)&&("mp4"===a||"matroska,webm"===a);return b},getState:function(){return this.state},getDuration:function(){return this.duration},getPosition:function(){return this.position},getMute:function(){return false},getVolume:function(){return this.volume},getClientID:function(){return this.client_id},generateClientID:function(){this.client_id=SYNO.Encryption.Base64.hex2b64(SYNO.VideoController2.Util.toHex(this.title))+new Date().format("U");return this.client_id},sendControllerAPI:function(b,f,d,e,c){var a=Ext.isBoolean(c)?!c:true;SYNO.API.Request({async:a,api:b,method:f,version:1,params:d,scope:this,callback:function(j,i,h,g){if(j){SYNO.VideoController2.Util.tryCallback(e)}else{this.controller.onAPIError.apply(this.controller,arguments)}}})},sendPlaybackAPI:function(d,b,c,a){this.sendControllerAPI("SYNO.VideoController.Playback",d,b,c,a)},sendVolumeAPI:function(d,b,c,a){this.sendControllerAPI("SYNO.VideoController.Volume",d,b,c,a)},play:function(){var a={id:this.id,uri:String.format("videostation://{0}",this.file_id),title:this.title,client_id:this.generateClientID()};if(Ext.isNumber(this.start_position)){a.position=this.start_position;this.start_position=null}if(!Ext.isEmpty(this.subtitle_id)){a.subtitle_id=this.subtitle_id}if(!Ext.isEmpty(this.subtitle_codepage)){a.subtitle_codepage=this.subtitle_codepage}if(!Ext.isEmpty(this.audio_id)){a.audio_id=this.audio_id}if(!Ext.isEmpty(this.profile)){a.profile=this.profile}this.state=SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING;this.stateHandler();this.sendPlaybackAPI("play",a,this.startPolling.createDelegate(this))},pause:function(){this.sendPlaybackAPI("pause",{id:this.id},Ext.emptyFn)},resume:function(){this.pause()},stop:function(){if(this.task_runner){this.sendPlaybackAPI("stop",{id:this.id},Ext.emptyFn,true)}else{this.notifyClear()}},seek:function(a){if(!this.seekable){return}var b={id:this.id,position:a.toFixed(0)};this.sendPlaybackAPI("seek",b,Ext.emptyFn)},setVolume:function(a){if(!this.volume_adjustable){return}var b={id:this.id,volume:a};this.sendVolumeAPI("setvolume",b,Ext.emptyFn)},clear:function(){this.stopPolling();this.notifyClear()},StateMap:{STOPPED:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,PLAYING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING,PAUSED:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED,TRANSITIONING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,ERROR:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR},updateStatus:function(d,c,b,a){if(!d){this.setStatusError();return}this.duration=c.duration;this.position=c.position;this.state=this.StateMap[c.state]||SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;if(this.client_id!==c.client_id){this.state=SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED}this.durationHandler(this.duration);this.positionHandler(this.position);if(this.state===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR){this.setStatusError()}else{this.stateHandler()}},setStatusError:function(){this.state=SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;this.stopPolling();this.stateHandler(_VCT("controller","error_state"))},updateVolume:function(d,c,b,a){this.volume=c.volume;this.volumeHandler()},startPolling:function(){this.stopPolling();this.task_runner=new SYNO.SDS.TaskRunner();this.polling_status=this.task_runner.createWebAPITask({id:"SYNOVideoControllerPollingStatus",interval:1000,api:"SYNO.VideoController.Playback",method:"status",version:1,params:{id:this.id},scope:this,callback:this.updateStatus});this.polling_status.start(true);if(this.volume_adjustable){this.polling_volume=this.task_runner.createWebAPITask({id:"SYNOVideoControllerPollingVolume",interval:1000,api:"SYNO.VideoController.Volume",method:"getvolume",version:1,params:{id:this.id},scope:this,callback:this.updateVolume});this.polling_volume.start(true)}},stopPolling:function(){if(this.task_runner){this.task_runner.destroy();this.task_runner=null;this.polling_status=null;this.polling_volume=null}}});Ext.define("SYNO.VideoController2.PlayerStore",{extend:"SYNO.API.Store",PlayerRecord:Ext.data.Record.create([{name:"id",type:"string"},{name:"type",type:"string"},{name:"title",type:"string"},{name:"volume_adjustable",type:"boolean"},{name:"password_protected",type:"boolean"},{name:"seekable",type:"boolean"}]),constructor:function(b){var a={api:"SYNO.VideoController.Device",method:"list",version:1,reader:new Ext.data.JsonReader({root:"devices"},this.PlayerRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.Dialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var a=Ext.apply({},b);a.listeners=a.listeners||{};Ext.apply(a.listeners,{show:this.onDialogShow.createDelegate(this),hide:this.onDialogHide.createDelegate(this),close:this.onDialogClose.createDelegate(this)});this.callParent([a])},onDialogShow:function(){if(Ext.isDefined(this.controller)){this.controller.spaceenabled=false}},onDialogHide:function(){if(Ext.isDefined(this.controller)){this.controller.spaceenabled=true}},onDialogClose:function(){if(Ext.isDefined(this.controller)){this.controller.spaceenabled=true}}});Ext.define("SYNO.VideoController2.PasswordDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.player_title=b.player_title;var a={dsmStyle:"v5",cls:"password-dialog syno-vc-dark-dialog",title:_VCT("controller","renderer_password_title"),width:460,height:180,padding:"8px 30px 8px 30px",items:[this.getFormPanel()],buttons:[{text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.applyHandler},{text:_T("common","cancel"),btnStyle:"grey",scope:this,handler:this.cancelHandler}],listeners:{scope:this,afterrender:this.focusInputField}};this.callParent([Ext.apply(a,b)])},getFormPanel:function(){if(this.form){return this.form}var a={cls:"password-form",items:[{xtype:"syno_displayfield",value:String.format(_VCT("controller","renderer_password_desc"),this.player_title)},{xtype:"syno_textfield",textType:"password",fieldLabel:_VCT("common","password"),name:"password",maxlength:50}]};this.form=new SYNO.ux.FormPanel(a);return this.form},getPasswordField:function(){return this.getFormPanel().getForm().findField("password")},focusInputField:function(){this.getPasswordField().focus(false,300)},applyHandler:function(){var a=this.getPasswordField().getValue();if(Ext.isString(a)&&!Ext.isEmpty(a)){this.testPassword(a)}else{this.focusInputField()}},cancelHandler:function(){this.close()},testPassword:function(a){SYNO.API.Request({api:"SYNO.VideoController.Password",method:"testpassword",version:1,params:{id:this.player_id,password:a},scope:this,callback:function(e,d,c,b){if(e){if(d.correct){this.setPassword(a)}else{this.showPasswordIncorrect()}}else{this.getMsgBox().alert(this.title,SYNO.VideoController2.Util.getErrorString(d,"SYNO.VideoController.Password"))}}})},setPassword:function(a){SYNO.API.Request({api:"SYNO.VideoController.Password",method:"setpassword",version:1,params:{id:this.player_id,password:a},scope:this,callback:function(e,d,c,b){if(e){this.correctCallback.defer(1);this.close()}else{this.getMsgBox().alert(this.title,SYNO.VideoController2.Util.getErrorString(d,"SYNO.VideoController.Password"))}}})},showPasswordIncorrect:function(){var a={title:_T("video_player","title"),msg:_VCT("controller","error_renderer_password_incorrect"),buttons:Ext.MessageBox.OK};this.getMsgBox().show(a)}});Ext.define("SYNO.VideoController2.SubtitleDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.unique_key=b.unique_key;var a={cls:"subtitle-dialog syno-vc-dark-dialog",title:_VCT("controller","search_subtitle"),width:720,height:380,layout:"fit",items:[this.getGridPanel()],buttons:[{text:_T("common","ok"),btnStyle:"blue",disabled:true,itemId:"ok",scope:this,handler:this.applyHandler},{text:_T("common","cancel"),btnStyle:"grey",itemId:"cancel",scope:this,handler:this.cancelHandler}]};this.callParent([Ext.apply(a,b)])},getGridPanel:function(){var a={xtype:"syno_gridpanel",itemId:"grid",stripeRows:true,loadMask:{msg:_VCT("search","searching")},viewConfig:{autoFill:true,forceFit:true,emptyText:_T("search","no_search_result")},selModel:new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{scope:this,selectionchange:function(){this.setOkDisabled(!this.isGridHasSelection())}}}),colModel:new Ext.grid.ColumnModel({columns:[{header:_VCT("language","title"),dataIndex:"language",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}},{header:_VCT("file","file_name"),dataIndex:"filename",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}},{header:_VCT("video_info","source"),dataIndex:"plugin_title",renderer:function(e,c,d){var b=Ext.util.Format.htmlEncode(e);return b}}]}),enableHdMenu:false,enableColumnMove:false,listeners:{scope:this,rowdblclick:function(){this.downloadSubtitle()}},store:this.getStore()};return a},getStore:function(){if(this.gridStore){return this.gridStore}var a=SYNO.VideoController2.Util.getIDorPathParam(this.unique_key);this.gridStore=new SYNO.API.JsonStore({api:"SYNO.VideoStation.Subtitle",method:"search",version:3,appWindow:false,autoLoad:true,baseParams:a,root:"subtitles",fields:["id","language","language_id","plugin_id","plugin_title","filename","downloaded","subtitle_id"]});return this.gridStore},isGridHasSelection:function(){return this.getComponent("grid").getSelectionModel().hasSelection()},setOkDisabled:function(a){this.getFooterToolbar().getComponent("ok").setDisabled(a)},getRecordSelections:function(){return this.getComponent("grid").getSelectionModel().getSelections()},downloadSubtitle:function(){this.setStatusBusy();this.downloadSubtitleByRecords(this.getRecordSelections())},downloadSubtitleByRecords:function(a){var c,b;if(a.length===0){return}c=a.shift();if(c.get("downloaded")){if(a.length===0){this.setDownloadedSubtitle(c.get("subtitle_id"));this.clearStatusBusy();return}this.downloadSubtitleByRecords(a);return}b=SYNO.VideoController2.Util.getIDorPathParam(this.unique_key);b.plugin_id=c.get("plugin_id");b.download_id=c.get("id");SYNO.API.Request({recs:a,api:"SYNO.VideoStation.Subtitle",method:"download",version:3,params:b,scope:this,callback:this.downloadSubtitleCallback})},downloadSubtitleCallback:function(e,d,c,a){var b=a.recs;if(e&&d){if(Ext.isString(d.id)){if(b.length===0){this.setDownloadedSubtitle(d.id);this.clearStatusBusy();return}this.downloadSubtitleByRecords(b);return}}this.clearStatusBusy();this.getMsgBox().alert(this.title,_VCT("controller","download_subtitle_fail"))},setDownloadedSubtitle:function(a,b){this.findAppWindow().getController().setDownloadedSubtitle(a,b);this.close()},applyHandler:function(){this.downloadSubtitle()},cancelHandler:function(){this.findAppWindow().getController().setDownloadedSubtitle();this.close()}});Ext.define("SYNO.VideoController2.ShiftDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.controller=b.controller;this.shift_left_button=new SYNO.ux.Button({btnStyle:"blue",text:"-",scope:this,handler:this.shiftLeftHandler});this.shift_right_button=new SYNO.ux.Button({btnStyle:"blue",text:"+",scope:this,handler:this.shiftRightHandler});this.reset_button=new SYNO.ux.Button({btnStyle:"blue",text:_T("common","reset"),scope:this,handler:this.resetHandler});this.shift_time_field=new SYNO.ux.NumberField({layout:"fix",fieldLabel:"Shift Time",allowNegative:true,allowDecimals:true,decimalPrecision:3,scope:this,listeners:{scope:this,change:this.shiftValueHandler,keyup:this.shiftValueHandler},value:this.controller.getShiftTime()});this.panel=new SYNO.ux.Panel({border:false,frame:false,layout:{type:"table",columns:3},scope:this,items:[this.shift_left_button,this.reset_button,this.shift_right_button]});this.vpanel=new SYNO.ux.Panel({layout:{type:"vbox",align:"center",pack:"center"},scope:this,items:[this.shift_time_field,this.panel]});var a={title:_VCT("controller","shift_subtitle"),layout:"fit",width:"300px",height:"250px",offset:0.25,items:[this.vpanel],buttons:[{text:_T("common","ok"),btnStyle:"blue",itemId:"ok",scope:this,handler:this.applyHandler}]};this.callParent([Ext.apply(a,b)])},shiftLeftHandler:function(){var a=this.controller.getShiftTime()-this.offset;this.controller.setShiftTime(a);this.shift_time_field.setValue(a)},shiftRightHandler:function(){var a=this.controller.getShiftTime()+this.offset;this.controller.setShiftTime(a);this.shift_time_field.setValue(a)},shiftValueHandler:function(){var a=this.shift_time_field.getValue();this.controller.setShiftTime(a)},resetHandler:function(){this.controller.setShiftTime(0);this.shift_time_field.setValue(0)},applyHandler:function(){var a=this.controller.video_list.getSubtitleList();var b=this.controller.getUsingSubtitle(a);this.controller.setSubtitle(b.subtitle_id);this.close()}});Ext.define("SYNO.VideoController2.ListDialog",{extend:"SYNO.VideoController2.Dialog",constructor:function(b){this.setDataFromStore(b.orgStore);this.pageSize=10;var a={padding:0,cls:"syno-vs-sharing-list-dialog syno-vc-dark-dialog",title:_VCT("controller","share_playlist_title"),closable:true,maximized:SYNO.VideoController2.Util.isMobile(),minWidth:540,width:540,minHeight:580,height:580,useStatusBar:false,layout:"fit",closeAction:"hide",items:[this.getGridPanel()],listeners:{scope:this,beforerender:function(){this.orig_useShims=Ext.useShims;Ext.useShims=true},afterrender:function(){Ext.useShims=this.orig_useShims}}};this.callParent([Ext.apply(a,b)]);this.grid=this.getComponent("list_gridpanel");if(this.data.videos.length===0){this.grid.addClass("syno-vs-sharing-empty")}this.maskEl.on("click",function(){this.hide()},this);this.maskEl.addClass("syno-vs-sharing-mask")},getGridPanel:function(){var a={xtype:"syno_gridpanel",itemId:"list_gridpanel",hideHeaders:true,autoExpandColumn:"title_filename",viewConfig:{deferEmptyText:false,emptyText:'<div class="syno-vs-sharing-empty-wrapper"><div class="syno-vs-sharing-empty-icon">'+_VCT("controller","empty_list_msg")+"</div></div>"},disableSelection:true,colModel:new Ext.grid.ColumnModel({columns:[{id:"poster",dataIndex:"unique_id",width:108,renderer:function(g,e,f){var b=f.get("type")==="movie"?"syno-vs-sharing-poster":"syno-vs-sharing-screenshot";var d=SYNO.VideoController2.Util.getImageURL(f.get("video_id"),f.get("type"));var c=String.format((Ext.isIE8||Ext.isIE7)?"filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')":"background-image: url('{0}')",d);return String.format('<div class="{0}" style="{1}"></div>',b,c)}},{id:"title_filename",dataIndex:"original_data",renderer:function(e,f,h){var c='<div class="syno-vs-sharing-list-title">{0}</div><div class="syno-vs-sharing-list-filename">{1}</div>';var g=this.organizeTitle(e);var d=e.additional.file[0].path;var b=d.substr(d.lastIndexOf("/")+1);return String.format(c,g,b)},organizeTitle:function(f){var g=f.title;var b=Date.parseDate(f.time,"Y-m-d H:i:s");var d=f.type;if("movie"===d){return g+(!Ext.isEmpty(b)?" ("+b.getFullYear()+")":"")}else{if("tvshow_episode"===d){var e=this.getFormatNumber(f.season);var c=this.getFormatNumber(f.episode);return g+" - "+f.tagline+" S"+e+" E"+c+(!Ext.isEmpty(b)?" ("+b.getFullYear()+")":"")}else{return g+(!Ext.isEmpty(b)?" ("+f.time+")":"")}}},getFormatNumber:function(b){return b<10?"0"+b:b}},{id:"play",width:72,renderer:function(d,b,c){return String.format('<div class="syno-vs-sharing-playicon" unique_id="{0}"></div>',c.get("unique_id"))}}]}),bbar:this.getPagingToolbar(),enableHdMenu:false,listeners:{scope:this,rowdblclick:function(d,b,c){var e=d.store.getAt(b);var f=e.get("unique_id");this.controller.jump(f);this.hide()},viewready:this.onAfterLoadStore},store:this.getStore()};return a},getPagingToolbar:function(){if(!Ext.isDefined(this.paging)){this.paging=new SYNO.ux.PagingToolbar({displayInfo:true,showRefreshBtn:false,store:this.getStore(),hidden:this.data.videos.length===0,pageSize:this.pageSize})}return this.paging},setDataFromStore:function(a){if(Ext.isEmpty(a)){this.data={offset:0,total:0,videos:[]};return}this.data={offset:a.getTotalCount(),total:a.getTotalCount(),videos:[]};a.data.each(function(b){this.data.videos.push(b.data)},this)},getStore:function(){if(this.gridStore){return this.gridStore}var a=new Ext.data.MemoryProxy([]);a.allData=this.data;a.on("beforeload",function(b,d){var c={offset:d.start,total:b.allData.total,videos:b.allData.videos.slice(d.start,d.start+d.limit)};b.data=c});this.gridStore=new Ext.data.JsonStore({data:{offset:this.pageSize,total:this.data.total,videos:this.data.videos.slice(0,this.pageSize)},proxy:a,root:"videos",idProperty:"unique_id",fields:["unique_id","type","video_id","original_data"],listeners:{scope:this,load:this.onAfterLoadStore}});return this.gridStore},onAfterLoadStore:function(){if(!Ext.isDefined(this.grid)){return}this.grid.view.updateScroller();var a=Ext.select(".syno-vs-sharing-playicon");a.elements.each(function(d){var c=d.getAttribute("unique_id");var b=Ext.fly(d);b.addClassOnOver("playicon-mouseover");b.addClassOnClick("playicon-click");b.on("click",function(){this.controller.jump(c);this.hide()},this)},this)},show:function(){this.playerState=this.controller.getPlayer().getState();if(this.playerState===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING){this.controller.play()}this.callParent(arguments)},hide:function(){if(this.data.videos.length===0){return}if(this.playerState===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING&&this.controller.getPlayer().getState()===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED){this.controller.play()}this.callParent(arguments)}});Ext.define("SYNO.VideoController2.SubtitleManager",{extend:"Ext.Component",constructor:function(b){this.addEvents({subtitleready:true});var a=Ext.apply({subtitle:{}},b);Ext.apply(this,a);this.callParent([a])},isSubtitleReady:function(a,b,c){return Ext.isDefined(this.subtitle[a])&&Ext.isDefined(this.subtitle[a][b])&&Ext.isString(this.subtitle[a][b][c])},getSubtitle:function(a,b,c){if(this.isSubtitleReady(a,b,c)){return this.subtitle[a][b][c]}return""},putSubtitle:function(a,b,c,d){if(!Ext.isDefined(this.subtitle[a])){this.subtitle[a]={}}if(!Ext.isDefined(this.subtitle[a][b])){this.subtitle[a][b]={}}this.subtitle[a][b][d]=c},requestSubtitle:function(a,c,b,d){if(this.isSubtitleReady(a,c,d)){this.fireEvent("subtitleready",a,c,d);return}if(b){this.sendRequest(a,c,true,d)}this.sendRequest(a,c,false,d)},sendRequest:function(c,d,a,f){var e=SYNO.VideoController2.Util.getIDorPathParam(c);Ext.apply(e,{api:"SYNO.VideoStation.Subtitle",method:"get",version:2,subtitle_id:d,subtitle_codepage:f,preview:a});var b={requestTimeout:360,url:"/webapi/VideoStation/subtitle.cgi",method:"POST",single:true,params:e,scope:this,success:function(g,i){try{Ext.decode(g.responseText)}catch(j){var h=g.responseText;this.putSubtitle(c,d,h,f);this.fireEvent("subtitleready",c,d,f)}}};SYNO.VideoController2.Util.applySharingID(b.params);this.addAjaxTask(b).start(true)}});Ext.define("SYNO.VideoController2.VideoFile",{extend:"Ext.Component",constructor:function(b){var a={video_info_fetched:false,video_id:null,type:null,seasion:null,episode:null,file_id:null,title:null,duration:null,resolution:null,codec_info:null,position:0,audio_track_fetched:false,audio_store:null,audio_track:[],subtitle_fetched:false,subtitle_store:null,subtitle_list:[],path:null,symlink:null};this.callParent([Ext.apply(a,b)])},onLoad:Ext.emptyFn,GetInfoAPIMap:{movie:"SYNO.VideoStation.Movie",tvshow_episode:"SYNO.VideoStation.TVShowEpisode",home_video:"SYNO.VideoStation.HomeVideo",tv_record:"SYNO.VideoStation.TVRecording",filevideo:"SYNO.VideoStation.Video"},GetInfoRootMap:{movie:"movies",tvshow_episode:"episodes",home_video:"videos",tv_record:"recordings",filevideo:"filevideos"},getInfo:function(a){if(!this.audio_track_fetched||!this.video_info_fetched||!this.subtitle_fetched){this.getInfoSequence(a)}else{SYNO.VideoController2.Util.tryCallback(a)}},getInfoSequence:function(a){if(!this.video_info_fetched){this.getVideoInfo(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.audio_track_fetched){this.getAudioTrack(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.subtitle_fetched){this.getSubtitleList(this.getInfoSequence.createDelegate(this,[a]));return}SYNO.VideoController2.Util.tryCallback(a)},getVideoInfo:function(d){var b=this.GetInfoAPIMap[this.type];if(!Ext.isDefined(b)){SYNO.VideoController2.Util.tryCallback(d);return}var c={};if(this.type==="filevideo"){c=this.getFileParams()}else{c={id:this.video_id}}Ext.apply(c,{additional:Ext.encode(["file"])});var a={api:b,method:"getinfo",version:(this.type==="filevideo"?1:2),params:c,scope:this,callback:function(i,h,g,f){this.video_info_fetched=true;if(i){this.fillVideoInfo(h,f);SYNO.VideoController2.Util.tryCallback(d)}else{var e=this.list.appWin.getController();e.onAPIError.apply(e,arguments)}}};SYNO.VideoController2.Util.applySharingID(a.params);SYNO.API.Request(a)},fillVideoInfo:function(c,j){var b=c[this.GetInfoRootMap[this.type]][0].additional;var f=b.file;if(Ext.isNumber(this.file_id)){var e=this.file_id;f=f.filter(function(k){return(e==k.id)})}else{var d=this.parseDuration;f.sort(function(l,k){return(d(k.duration)-d(l.duration))})}var a=f[0];var i=a.path;var h=a.sharepath;var g={};Ext.copyTo(g,a,["container_type","audio_codec","video_codec"]);Ext.apply(this,{title:i.substring(i.lastIndexOf("/")+1),file_id:parseInt(a.id,10),resolution:{width:a.resolutionx,height:a.resolutiony},duration:this.parseDuration(a.duration),codec_info:g,path:i,sharepath:h});if(this.type==="filevideo"||SYNO.VideoController2.Util.isPublicSharing()){return}Ext.apply(this,{position:a.position,watched_ratio:a.watched_ratio})},getResumePosition:function(c){var b=Math.max(0,(Ext.isNumber(this.position)?this.position-2:0));if(c===true){return b}var a=SYNO.VideoController2.Util.roundPercentage(this.watched_ratio);if(!Ext.isNumber(this.watched_ratio)||a===0||a===100){return null}return b},setWatched:function(a){this.setWatchStatus(this.duration,a,false)},setWatchStatus:function(a,e,d){if(SYNO.VideoController2.Util.isPublicSharing()){SYNO.VideoController2.Util.tryCallback(e);return}if(!Ext.isNumber(this.file_id)||!Ext.isNumber(a)||a<=0){SYNO.VideoController2.Util.tryCallback(e);return}var c=Ext.isBoolean(d)?!d:true;var b=c?e:Ext.emptyFn;this.position=a;SYNO.API.Request({async:c,api:"SYNO.VideoStation.WatchStatus",method:"setinfo",version:1,params:{id:this.file_id,position:a},scope:this,callback:b});if(!c){SYNO.VideoController2.Util.tryCallback(e)}},deleteSymLink:function(){if(Ext.isEmpty(this.path)){return}SYNO.API.Request({async:false,api:"SYNO.VideoStation.Video",method:"delete_symlink",version:1,params:{path:this.path,symlink:this.symlink},scope:this,callback:Ext.emptyFn})},getUniqueKey:function(){if(this.type==="filevideo"){return this.path}else{return this.file_id}},getFileParams:function(){var a={};if(this.type==="filevideo"){if(Ext.isString(this.symlink)){a={path:this.path,symlink:this.symlink}}else{a={path:this.path}}}else{a={id:this.file_id}}return a},getAudioTrack:function(c){if(this.audio_track_fetched){SYNO.VideoController2.Util.tryCallback(c);return}this.audio_store=new SYNO.VideoController2.AudioTrackStore({appWindow:this.list.appWin});this.addManagedComponent(this.audio_store);var b=this.getFileParams();var a={scope:this,callback:function(){this.audio_track_fetched=true;this.audio_store.data.each(function(d){this.audio_track.push(d.data)},this);SYNO.VideoController2.Util.tryCallback(c)},params:b};SYNO.VideoController2.Util.applySharingID(a.params);this.audio_store.load(a)},getSubtitleList:function(a){if(this.subtitle_fetched){SYNO.VideoController2.Util.tryCallback(a);return}this.subtitle_store=new SYNO.VideoController2.SubtitleStore({appWindow:this.list.appWin});this.addManagedComponent(this.subtitle_store);this.loadSubtitleStore(a)},loadSubtitleStore:function(c){var b=this.getFileParams();var a={scope:this,callback:function(){this.subtitle_fetched=true;this.subtitle_list=[];this.subtitle_store.data.each(function(d){this.subtitle_list.push(d.data)},this);SYNO.VideoController2.Util.tryCallback(c)},params:b};SYNO.VideoController2.Util.applySharingID(a.params);this.subtitle_store.load(a)},parseDuration:function(d){if(!Ext.isDefined(d)){return 0}if(Ext.isNumber(d)){return d}var c=0;var b=d.split(":");for(var a=0;a<b.length;++a){c=c*60+parseFloat(b[a])}return c}});Ext.define("SYNO.VideoController2.AudioTrackStore",{extend:"SYNO.API.Store",AudioTrackRecord:Ext.data.Record.create([{name:"id",type:"int"},{name:"track",type:"int"},{name:"codec",type:"string"},{name:"language",type:"string"}]),constructor:function(b){var a={api:"SYNO.VideoStation.AudioTrack",method:"list",version:1,reader:new Ext.data.JsonReader({root:"trackinfo"},this.AudioTrackRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.SubtitleStore",{extend:"SYNO.API.Store",SubtitleRecord:Ext.data.Record.create([{name:"subtitle_id",type:"string",mapping:"id"},{name:"lang",type:"string"},{name:"title",type:"string"},{name:"format",type:"string"},{name:"embedded",type:"boolean"},{name:"need_preview",type:"boolean"}]),constructor:function(b){var a={api:"SYNO.VideoStation.Subtitle",method:"list",version:2,baseParams:{image_based:true},reader:new Ext.data.JsonReader({},this.SubtitleRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.VideoList",{extend:"Ext.Component",constructor:function(b){var a={loaded:false,browse_type:null,sharing_id:null,type_id:null,store:null,video_list:[],current_index:-1};this.callParent([Ext.apply(a,b)])},NullVideoFile:new SYNO.VideoController2.VideoFile(),isCollection:function(){return("collection"===this.browse_type)},isTVShow:function(){return("tvshow_episode"===this.browse_type||"tvshow"===this.browse_type)},isSingleVideo:function(){return((!Ext.isNumber(this.type_id)&&!Ext.isString(this.sharing_id))||(!this.isCollection()&&!this.isTVShow()))},getStore:function(){if(this.store){return this.store}var a;if(this.isCollection()){a={is_collection:true,reader_root:"videos",api:"SYNO.VideoStation.Collection",method:"video_list",version:2,baseParams:{sort_by:this.sort_info.sort_by,sort_direction:this.sort_info.sort_direction,offset:0,limit:-1}};if(SYNO.VideoController2.Util.isPublicSharing()){a.baseParams.sharing_id=SYNO.VideoController2.Util.getSharingID();a.baseParams.additional=Ext.encode(["file"])}else{a.baseParams.id=this.type_id}}else{a={is_collection:false,reader_root:"episodes",api:"SYNO.VideoStation.TVShowEpisode",method:"list",version:1,baseParams:{tvshow:this.type_id}}}this.store=new SYNO.VideoController2.VideoStore(Ext.apply(a,{appWindow:this.appWin}));this.addManagedComponent(this.store);return this.store},initSingleVideo:function(a,b){this.video_list.push(new SYNO.VideoController2.VideoFile(Ext.apply({list:this},a)));this.current_index=0;this.loaded=true;SYNO.VideoController2.Util.tryCallback(b)},init:function(a,b){if(this.isSingleVideo()){this.initSingleVideo(a,b);return}this.getStore().load({callback:this.onVideoListLoad.createDelegate(this,[a,b]),scope:this})},onVideoListLoad:function(e,g){var b=e.video_id;var c=e.file_id;var f=e.title;this.store.data.each(function(h){this.video_list.push(new SYNO.VideoController2.VideoFile(Ext.apply({list:this},h.data)))},this);var a=this.video_list[this.getCurrentIndex(b,e.type)];a.file_id=c;a.title=f;if(this.isTVShow()){var d=a.season;this.video_list=this.video_list.filter(function(h){return(d===h.season)});this.video_list.sort(this.tvshowSortFunction)}this.getCurrentIndex(b,e.type);this.loaded=true;SYNO.VideoController2.Util.tryCallback(g)},tvshowSortFunction:function(d,c){var f=0,e=0;f+=(0===d.episode)?1024:0;e+=(0===c.episode)?1024:0;f+=(d.season>c.season)?2:0;e+=(c.season>d.season)?2:0;f+=(d.episode>c.episode)?1:0;e+=(c.episode>d.episode)?1:0;return f-e},getCurrentIndex:function(b,a){if(!Ext.isDefined(b)||!Ext.isDefined(a)){if(Ext.isNumber(this.current_index)&&0<=this.current_index){return this.current_index}else{return -1}}for(var c=0;c<this.video_list.length;++c){if(b===this.video_list[c].video_id&&a===this.video_list[c].type){this.current_index=c;break}}return this.current_index},getCurrentVideo:function(){var a=this.getCurrentIndex();return(0>a)?this.NullVideoFile:this.video_list[a]},getVideoID:function(){return this.getCurrentVideo().video_id},getVideoType:function(){return this.getCurrentVideo().type},getFileUniqueKey:function(){return this.getCurrentVideo().getUniqueKey()},getFileParams:function(){return this.getCurrentVideo().getFileParams()},getTitle:function(){return this.getCurrentVideo().title},getDuration:function(){return this.getCurrentVideo().duration},getResolution:function(){return this.getCurrentVideo().resolution},getCodecInfo:function(){return this.getCurrentVideo().codec_info},getAudioTrack:function(){return this.getCurrentVideo().audio_track},getDefaultAudioID:function(){var b=0;var a=this.getAudioTrack();if(a.length>0){b=a[0].id}return b},getDefaultAudioCodec:function(){var b="";var a=this.getAudioTrack();if(a.length>0){b=a[0].codec}return b},getSubtitleList:function(){return this.getCurrentVideo().subtitle_list},hasPrev:function(){return(this.current_index-1>=0)},hasNext:function(){return(this.video_list.length>this.current_index+1)},goPrev:function(a){if(!this.hasPrev()){if(true===a){this.current_index=this.video_list.length-1;return true}else{return false}}this.current_index--;return true},goNext:function(a){if(!this.hasNext()){if(true===a){this.current_index=0;return true}else{return false}}this.current_index++;return true},goJump:function(b){var a=-1;this.video_list.each(function(d,c){if(d.unique_id===b){a=c}});if(a===-1){return false}this.current_index=a;return true}});Ext.define("SYNO.VideoController2.VideoStore",{extend:"SYNO.API.Store",CollectionRecord:Ext.data.Record.create([{name:"video_id",type:"int",mapping:"id"},{name:"type",type:"string"},{name:"original_data",type:"object",convert:function(b,a){return a}},{name:"unique_id",type:"string",convert:function(b,a){return String.format("{0}-{1}",a.type,a.id)}}]),TvshowRecord:Ext.data.Record.create([{name:"episode",type:"int"},{name:"season",type:"int"},{name:"video_id",type:"int",mapping:"id"},{name:"type",type:"string",defaultValue:"tvshow_episode"},{name:"unique_id",type:"string",convert:function(b,a){return String.format("{0}-{1}",a.type,a.id)}}]),constructor:function(c){var a=(c.is_collection)?this.CollectionRecord:this.TvshowRecord;var b={reader:new Ext.data.JsonReader({root:c.reader_root,idProperty:"unique_id"},a)};this.callParent([Ext.apply(b,c)])}});Ext.define("SYNO.VideoController2.Controller",{extend:"SYNO.SDS.VideoPlayerCommonVC.Controller",constructor:function(b){this.addEvents({capabilityready:true,playerlistchange:true,busy:true,clear:true,rawdisabled:true,repeatchange:true,targetchange:true,titlechange:true,videochange:true});var a={audio_id:null,subtitle_id:null,subtitle_codepage:"auto",profile:null,player_info:{id:null,type:SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,title:_VCT("controller","streaming_mode"),volume_adjustable:true,seekable:false,password_protected:false},repeat:SYNO.VideoController2.Util.REPEAT_NONE,player_store:null,player_list:null,video_list:null,channel_id:null,channel_list:null,force_resume:false,start_position:0,shift_time:0,support_remux:null,support_transcode:null,rawdisabled:false,spaceenabled:true};this.callParent([Ext.apply(a,b)]);this.subtitle_manager=new SYNO.VideoController2.SubtitleManager({listeners:{subtitleready:this.onSubtitleReady.createDelegate(this)}})},loadVideoList:function(d){var a=this.type_info;var b=this.video_info;this.video_list=new SYNO.VideoController2.VideoList({appWin:this.appWin,browse_type:a.type,sharing_id:a.sharing_id,type_id:parseInt(a.id,10),sort_info:Ext.apply({sort_by:"title",sort_direction:"asc"},a.sort_info)});var c={video_id:parseInt(b.id,10),type:b.type,file_id:parseInt(b.file_id,10),title:b.title,path:b.path,symlink:b.symlink};this.video_list.init(c,d)},requestTranscodeCapability:function(b){if(_S("demo_mode")){this.support_remux=false;this.support_transcode=false;this.support_hardware_transcode=false;SYNO.VideoController2.Util.tryCallback(b);return}var a={api:"SYNO.VideoStation.Info",method:"getinfo",version:1,scope:this,params:{},callback:function(f,e,d,c){if(f){Ext.apply(this,e);this.fireEvent("capabilityready",this.support_transcode,this.support_remux);SYNO.VideoController2.Util.tryCallback(b)}else{this.onAPIError.apply(this,arguments)}}};SYNO.VideoController2.Util.applySharingID(a.params);SYNO.API.Request(a)},requestPlayerList:function(a){if(_S("demo_mode")||SYNO.VideoController2.Util.isPublicSharing()){this.player_list=[];SYNO.VideoController2.Util.tryCallback(a);return}this.player_store=new SYNO.VideoController2.PlayerStore({appWindow:this.appWin});this.player_store.load({scope:this,callback:function(e,d,c,b){if(e){this.player_list=[];this.player_store.each(function(f){this.player_list.push(f.data)},this);this.fireEvent("playerlistchange",this.player_list);SYNO.VideoController2.Util.tryCallback(a)}}})},requestCurrentChannel:function(a){SYNO.API.Request({api:"SYNO.DTV.Controller",method:"getchannel",version:1,params:{tuner:this.tuner_id},scope:this,callback:function(e,d,c,b){if(e){this.channel_id=d.streaming_id}SYNO.VideoController2.Util.tryCallback(a)}})},requestChannelList:function(a){if(_S("demo_mode")){this.channel_list=[];SYNO.VideoController2.Util.tryCallback(a);return}this.channel_store=new SYNO.VideoController2.ChannelStore({appWindow:this.appWin});this.channel_store.load({scope:this,params:{tuner:this.tuner_id},callback:function(e,d,c,b){if(e){this.channel_list=[];this.channel_store.each(function(f){this.channel_list.push(f.data)},this);this.fireEvent("channellistready",this.channel_list);SYNO.VideoController2.Util.tryCallback(a)}}})},initSequenceDTV:function(){var a=this.initSequenceDTV.createDelegate(this);if(!Ext.isBoolean(this.support_remux)){this.requestTranscodeCapability(a);return}if(Ext.isEmpty(this.channel_id)){this.tuner_id=this.dtv_url.substr(this.dtv_url.lastIndexOf("/")+1);this.requestCurrentChannel(a);return}if(this.privilege.dtv&&!Ext.isArray(this.channel_list)){this.requestChannelList(a);return}this.fireEvent("clear");this.playDTV()},initSequenceVideo:function(){var a=this.initSequenceVideo.createDelegate(this);if(!Ext.isObject(this.video_list)||!this.video_list.loaded){this.loadVideoList(a);return}if(!Ext.isBoolean(this.support_remux)){this.requestTranscodeCapability(a);return}if(!Ext.isArray(this.player_list)){this.requestPlayerList(a);return}this.fireEvent("clear");this.onReadyToPlay()},flashPlayer:function(){return new SYNO.VideoController2.FlashPlayer({controller:this})},onReadyToPlay:function(){var a=function(){if(SYNO.VideoController2.Util.isPublicSharing()){var b=this.video_list.getCurrentVideo();location.hash="!"+btoa(b.type+"-"+b.video_id)}this.fireEvent("clear");this.audio_id=this.video_list.getDefaultAudioID();this.fireEvent("videochange",this.video_list.hasPrev(),this.video_list.hasNext(),this.video_list.getCurrentVideo(),this.video_list.getAudioTrack(),this.video_list.getSubtitleList());this.subtitle_decided=false;this.fireEvent("titlechange",this.video_list.getTitle());if(!Ext.isEmpty(this.init_player_id)){this.appWin.getControlBar().getPlayerButton().menu.setInitPlayer(this.init_player_id);this.init_player_id=null}else{this.play()}}.createDelegate(this);this.fireEvent("busy");this.video_list.getCurrentVideo().getInfo(a)},playCurrentVideo:function(){if(Ext.isEmpty(this.channel_id)){this.checkResumeVideo()}else{this.playDTV()}},checkResumeVideo:function(){var b=this.video_list.getCurrentVideo().getResumePosition(this.force_resume);if(!Ext.isNumber(b)){this.start_position=0;this.playVideo();return}else{if(this.force_resume){this.start_position=b;this.playVideo();return}else{if(this.repeat!==SYNO.VideoController2.Util.REPEAT_NONE){this.start_position=0;this.playVideo();return}}}var a={title:_T("video_player","title"),msg:_VCT("controller","resume_watch_desc"),buttons:Ext.MessageBox.YESNO,scope:this,fn:function(c){if("no"===c){this.start_position=0}else{this.start_position=b}this.playVideo()}};this.appWin.getMsgBox().show(a)},playVideo:function(){this.updateAfterPlaybackAction();if(this.isRemoteMode()){if(this.player_info.password_protected){this.checkPassword(this.playRemote.createDelegate(this))}else{this.playRemote()}}else{this.playStreaming()}},switchChannel:function(c,a,b){if(_S("demo_mode")||!this.privilege.dtv){SYNO.VideoController2.Util.tryCallback(b);return}this.fireEvent("busy");SYNO.API.Request({api:"SYNO.DTV.Controller",method:"setchannel",version:1,params:{id:c,tuner:this.tuner_id},scope:this,callback:function(g,f,e,d){this.fireEvent("clear");if(g){this.channel_id=c;this.fireEvent("titlechange",a);SYNO.VideoController2.Util.tryCallback(b)}else{this.onAPIError.apply(this,arguments)}}})},playDTV:function(){this.setRawDisabled(this.selectPlayer("VLC").getName()!=="VLC");if(Ext.isString(this.profile)){if(this.selectPlayer("Flash").getName()==="Flash"){this.openDTVStream(this.profile)}else{this.onErrorOccur(_T("video_player","error_play"))}return}if(this.selectPlayer("VLC").getName()==="VLC"){this.openDTVStream("raw")}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.openDTVStream("hd_high",this.audio_id)}else{var a=!Ext.isMac&&!SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported();this.onErrorOccur(a?_T("video_player","error_play_vlc"):_T("video_player","error_play"))}}},openDTVStream:function(a){var b=a!=="raw";this.fireEvent("busy");SYNO.API.Request({api:"SYNO.DTV.Streaming",method:"open",version:1,params:{tuner:this.tuner_id,profile:a,accept_format:b?"hls":"raw"},scope:this,callback:function(g,f,e,d){this.fireEvent("clear");if(g){var c=b?SYNO.VideoController2.Util.getLiveStreamURL(this.tuner_id,f.stream_id):this.dtv_url;this.getPlayer().play(c)}else{this.onAPIError.apply(this,arguments)}}})},playStreaming:function(){this.setRawDisabled(!this.ableToPlayRawQuality());if(Ext.isString(this.profile)){if(this.selectPlayer("Flash").getName()==="Flash"){this.onPlayerDecided(false);this.playTranscodeVideo(this.profile,this.audio_id)}else{this.onPlayerDecided(false);this.onErrorOccur(_T("video_player","error_play"))}return}this.updateToRawPlayer();if(this.getPlayer().getName()!=="Null"&&(this.audio_id===this.video_list.getDefaultAudioID())){var a=SYNO.SDS.VideoPlayerCommonVC.Util.getFileExt(this.video_list.getTitle());this.onPlayerDecided(this.getPlayer().getName()==="VLC");this.playRawVideo(a)}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.onPlayerDecided(false);this.playTranscodeVideo(this.profile,this.audio_id)}else{this.onPlayerDecided(false);this.onErrorOccur(_T("video_player","error_play"))}}},updateToRawPlayer:function(){var a=this.video_list.getTitle();this.updatePlayer({filename:a});var b=this.video_list.getCodecInfo();if(this.getPlayer().getName()!=="VLC"&&"mp4"===b.container_type&&!SYNO.VideoController2.Util.isWebPlayableMP4(b.video_codec,this.video_list.getDefaultAudioCodec())){this.selectPlayer("VLC")}},ableToPlayRawQuality:function(){this.updateToRawPlayer();var b=(this.getPlayer().getName()!=="Null");var a=false;if(this.selectPlayer("Flash").getName()==="Flash"){a=this.getPlayer().AbleToRemux(this.video_list.getCodecInfo())}return(b||a)},playRawVideo:function(c){var d=this.video_list.getFileParams();Ext.apply(d,{api:"SYNO.VideoStation.Video",method:"download",version:1,_sid:Ext.util.Cookies.get("id")});SYNO.VideoController2.Util.applySharingID(d);var b=String.format("/{0}/{1}/1.{2}","webapi/VideoStation","video.cgi",c);var a=Ext.urlAppend(b,Ext.urlEncode(d));this.getPlayer().setStartPosition(this.start_position);this.getPlayer().play(a);this.force_resume=false},playTranscodeVideo:function(d,b){var e=this.getPlayer().AbleToRemux(this.video_list.getCodecInfo());var c=this.getPlayer().AbleToTranscode();if(!e&&!c){this.onErrorOccur(String.format(_VCT("controller","unsupported_format"),this.player_info.title));return}var a=(!e||Ext.isString(d))?"hls":"hls_remux";var f=this.video_list.getFileParams();Ext.apply(f,{hls_header:1,accept_format:a});if(Ext.isString(d)){f.profile=d}else{if(a==="hls"){f.profile="hd_high"}}if(Ext.isNumber(b)){f.audio_id=b}SYNO.VideoController2.Util.applySharingID(f);this.fireEvent("busy");SYNO.API.Request({api:"SYNO.VideoStation.Streaming",method:"open",version:1,params:f,scope:this,callback:function(j,i,h,g){this.fireEvent("clear");if(j){this.onVTEStreamReady(i)}else{this.onAPIError.apply(this,arguments)}}})},onVTEStreamReady:function(c){this.stream_id=c.stream_id;this.stream_format=c.format;var b=SYNO.VideoController2.Util.getDisplayResolution(c.video)||this.video_list.getResolution();var a=SYNO.VideoController2.Util.getStreamURL(this.stream_id,this.stream_format);a=SYNO.VideoController2.Util.getExtM3U(b.width,b.height,a,"/webman/3rdparty/VideoStation/controller/ui");this.getPlayer().setStartPosition(this.start_position);this.getPlayer().play(a);this.force_resume=false},checkPassword:function(a){SYNO.API.Request({api:"SYNO.VideoController.Password",method:"testpassword",version:1,params:{id:this.player_info.id},scope:this,callback:function(e,d,c,b){if(e){if(d.correct){SYNO.VideoController2.Util.tryCallback(a)}else{this.promptPasswordDialog(a)}}else{this.onAPIError.apply(this,arguments)}}})},promptPasswordDialog:function(c){var a={owner:this.appWin,correctCallback:c,player_title:this.player_info.title,player_id:this.player_info.id,controller:this};var b=new SYNO.VideoController2.PasswordDialog(a);b.show()},playRemote:function(){this.onPlayerDecided(false);var a={controller:this,id:this.player_info.id,type:this.player_info.type,volume_adjustable:this.player_info.volume_adjustable,seekable:this.player_info.seekable,file_id:this.video_list.getFileUniqueKey(),title:this.video_list.getTitle(),profile:this.profile};if(!Ext.isEmpty(this.subtitle_id)&&this.subtitle_id!==SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE){a.subtitle_id=this.subtitle_id}if(!Ext.isEmpty(this.subtitle_codepage)){a.subtitle_codepage=this.subtitle_codepage}if(this.audio_id!==this.video_list.getDefaultAudioID()){a.audio_id=this.audio_id}var b=this.video_list.getCodecInfo();this.player=new SYNO.VideoController2.RemotePlayer(a);this.setRawDisabled(!this.player.AbleToPlayRaw(b)&&!this.player.AbleToRemux(b));this.getPlayer().setStartPosition(this.start_position);this.player.play();this.force_resume=false},unlink:function(){if(Ext.isObject(this.video_info)&&Ext.isString(this.video_info.symlink)){this.video_list.getCurrentVideo().deleteSymLink()}},stop:function(d,b){this.clearCallback=null;var a=this.getPlayer().getPosition();if(!Ext.isEmpty(this.dtv_url)||!Ext.isNumber(a)||a<=0){this.callParent(arguments);return}var c=SYNO.VideoController2.Controller.superclass.stop.createDelegate(this,arguments);this.video_list.getCurrentVideo().setWatchStatus(a,c,b)},prev:function(){this.stop(this.goPrev.createDelegate(this))},goPrev:function(a){if(this.video_list.goPrev(a)){this.video_list.getCurrentVideo().video_info_fetched=false;this.onReadyToPlay()}},next:function(){this.stop(this.goNext.createDelegate(this))},goNext:function(a){if(this.video_list.goNext(a)){this.video_list.getCurrentVideo().video_info_fetched=false;this.onReadyToPlay()}},jump:function(a){this.stop(this.goJump.createDelegate(this,[a]))},goJump:function(a){if(this.video_list.goJump(a)){this.onReadyToPlay()}},setProfile:function(a){if(a===this.profile){return}if(this.rawdisabled&&a==="hd_high"&&this.profile===null){return}this.profile=a;this.force_resume=true;this.stop(this.close.createDelegate(this,[this.play.createDelegate(this)]))},close:function(b){if(Ext.isEmpty(this.dtv_url)){SYNO.VideoController2.Util.tryCallback(b);return}var a={async:false,api:"SYNO.DTV.Streaming",method:"close",version:1,params:{tuner:this.tuner_id,hls:true},scope:this,callback:function(f,e,d,c){SYNO.VideoController2.Util.tryCallback(b)}};SYNO.API.Request(a)},setAudioTrack:function(a){if(a===this.audio_id){return}this.audio_id=a;this.force_resume=true;this.stop(this.play.createDelegate(this))},onPlayerDecided:function(b){var a=this.video_list.getSubtitleList();this.fireEvent("playerdecided",a,b);this.selectUsingSubtitle(a,b)},selectSubtitle:function(e,b,c){var d=(c!==true);this.subtitle_decided=true;this.subtitle_id=e;this.getPlayer().subtitle_is_srt=d;if(this.isRemoteMode()){this.setSubtitleEnabled(false,e)}else{if(d){this.getPlayer().disablePlayerSubtitle()}else{this.getPlayer().setPlayerSubtitle(parseInt(e,10))}var a=(e!==SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE&&d);if(a){this.subtitle_manager.requestSubtitle(this.video_list.getFileUniqueKey(),e,b,this.subtitle_codepage)}this.setSubtitleEnabled(a,e)}},findPreviousSubtitle:function(b,a){if(!this.subtitle_decided){return null}var c=null;Ext.each(b,function(d){if(d.subtitle_id===this.subtitle_id&&(a||d.format==="srt")){c=d;return false}},this);return c},getUsingSubtitle:function(b,a){var d={subtitle_id:SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,need_preview:false,format:"srt"};if(this.subtitle_id===SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE){return d}var c=this.findPreviousSubtitle(b,a);if(Ext.isObject(c)){return c}if(a&&b.length>0){return b[0]}Ext.each(b,function(e){if(e.format==="srt"){d=e;return false}});return d},selectUsingSubtitle:function(b,a){var c=this.getUsingSubtitle(b,a);this.selectSubtitle(c.subtitle_id,c.need_preview,c.format!=="srt")},setSubtitle:function(c,a,b){if(this.isRemoteMode()&&c===this.subtitle_id){return}this.selectSubtitle(c,a,b);if(this.isRemoteMode()){this.force_resume=true;this.stop(this.play.createDelegate(this))}},browseSubtitle:function(){this.getPlayer().pause();var e=this.video_list.getCurrentVideo();var g=e.sharepath.substring(0,e.sharepath.lastIndexOf("/"));var c={owner:this.appWin,width:960,height:480,title:_VCT("controller","browse_subtitle"),columnCfg:{filename:{width:500}},comboOption:[{label:_T("texteditor","FileType"),value:"allSubtitle",data:[["allSubtitle",_VCT("controller","subtitle_type")],["allText",_T("texteditor","AllTextFile")],["all",_T("texteditor","AllFile")]]},{label:_T("texteditor","Codepage"),value:"auto",data:SYNO.VideoController2.Util.getComboBoxCodepageList(true)}],getFilterPattern:function(h){var i=[],j={};if("allSubtitle"===h[0].value){for(j in SYNO.VideoController2.Util.SubtitleExtensions){i.push(j)}return i.join()}if("allText"===h[0].value){for(j in SYNO.VideoController2.Util.TextFileExtensions){i.push(j)}return i.join()}return""}};var b=parseInt(_S("majorversion"),10);var d=parseInt(_S("minorversion"),10);var a=parseInt(_S("version"),10);if((b===5&&((d===0&&a>=4531)||(d===1&&a>=5029)||(d>=2)))||b>=6){Ext.apply(c,{gotoPath:g})}var f=new SYNO.SDS.Utils.FileChooser.Chooser(c);f.mon(f,"choose",this.onBrowseSelect,this);f.mon(f,"cancel",this.onBrowseCancel,this);f.open()},onBrowseSelect:function(h,c,g){var j=-1;this.subtitle_codepage=g[1];if(c&&Ext.isString(c.fullpath)){var m=this.video_list.getSubtitleList();var e=new RegExp(/[srt|ass|ssa|sami|smi]/i);var d=c.fullpath.substr(c.fullpath.lastIndexOf(".")+1);var k=c.fullpath.substr(c.fullpath.lastIndexOf("/")+1);var f={embedded:false,format:(e.test(d))?"srt":d,lang:this.subtitle_codepage,subtitle_id:c.fullpath,title:k,need_preview:false};for(var b=0,a=m.length;b<a;b++){if(m[b].subtitle_id===c.fullpath){j=b;break}}if(j!==-1){m[j]=f}else{m.push(f)}this.appWin.getControlBar().getSubtitleButton().menu.setSubtitleList(m);this.setSubtitle(c.fullpath)}h.close();this.getPlayer().resume()},onBrowseCancel:function(){var a=this.video_list.getSubtitleList();var b=this.getUsingSubtitle(a);this.setSubtitle(b.subtitle_id);this.getPlayer().resume()},getShiftTime:function(){return this.shift_time},setShiftTime:function(a){this.shift_time=a},shiftSubtitle:function(){var a=new SYNO.VideoController2.ShiftDialog({owner:this.appWin,controller:this});a.show()},setPlayer:function(a){if(a.id===this.player_info.id){return}this.player_info=a;this.fireEvent("targetchange",this.player_info);this.force_resume=Ext.isEmpty(this.init_player_id);this.stop(this.play.createDelegate(this))},setChannel:function(a){if(a.id===this.channel_id){return}this.channel_id=a.id;this.stop(this.switchChannel.createDelegate(this,[a.id,a.title,this.play.createDelegate(this)]))},toggleList:function(){var a=this.getListDialog();a.show()},getListDialog:function(){if(!Ext.isDefined(this.listDialog)){var a=!Ext.isEmpty(this.video_list)?this.video_list.getStore():null;this.listDialog=new SYNO.VideoController2.ListDialog({controller:this,orgStore:a})}return this.listDialog},toggleRepeat:function(){switch(this.repeat){case SYNO.VideoController2.Util.REPEAT_NONE:this.repeat=SYNO.VideoController2.Util.REPEAT_ALL;break;case SYNO.VideoController2.Util.REPEAT_ALL:this.repeat=SYNO.VideoController2.Util.REPEAT_ONE;break;case SYNO.VideoController2.Util.REPEAT_ONE:this.repeat=SYNO.VideoController2.Util.REPEAT_NONE;break;default:this.repeat=SYNO.VideoController2.Util.REPEAT_NONE;break}this.updateAfterPlaybackAction();this.fireEvent("repeatchange",this.repeat)},updateAfterPlaybackAction:function(){var b=Ext.emptyFn;if(this.repeat===SYNO.VideoController2.Util.REPEAT_ALL){b=this.goNext.createDelegate(this,[true])}else{if(this.repeat===SYNO.VideoController2.Util.REPEAT_ONE){b=this.play.createDelegate(this)}else{if(this.repeat===SYNO.VideoController2.Util.REPEAT_NONE){b=this.goNext.createDelegate(this,[false])}}}var a=this.video_list.getCurrentVideo();this.clearCallback=a.setWatched.createDelegate(a,[b])},setRawDisabled:function(a){this.rawdisabled=a;this.fireEvent("rawdisabled",a,this.profile)},onSubtitleReady:function(b,c,d){if((b!==this.video_list.getFileUniqueKey())||c!==this.subtitle_id){return}var a=this.subtitle_manager.getSubtitle(b,c,d);this.getSubtitleParser().parseSrt(a)},onAPIError:function(e,d,c,a){if(e){return}var b=SYNO.VideoController2.Util.getErrorString(d,a.params.api);this.onErrorOccur(String.format(b,this.player_info.title))},onErrorOccur:function(a){this.updateState(SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR,a)},isRemoteMode:function(){return(this.player_info.type!==SYNO.VideoController2.Util.PLAYERTYPE_STREAMING)},searchSubtitle:function(){this.getPlayer().pause();this.promptSubtitleDialog()},promptSubtitleDialog:function(){var a={owner:this.appWin,unique_key:this.video_list.getFileUniqueKey(),controller:this};var b=new SYNO.VideoController2.SubtitleDialog(a);b.show()},setDownloadedSubtitle:function(a,b){if(a){this.setSubtitle(a);if(b!==false){this.reloadSubtitleList(a)}}this.getPlayer().resume()},reloadSubtitleList:function(b){var a=this;this.video_list.getCurrentVideo().loadSubtitleStore(function(){a.onPlayerDecided(a.getPlayer().getName()==="VLC");a.selectSubtitle(b)})},seekInterval:function(a){var b=this.position+a;if(b<0){b=0}if(b>this.duration){b=this.duration}this.seek(b)},adjustVolume:function(a){var b=this.volume+a;if(b<0){b=0}if(b>100){b=100}this.setVolume(b);this.updateVolume(b)}});Ext.define("SYNO.VideoController2.ChannelMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",constructor:function(a){this.callParent([a])},setChannelList:function(b,a){this.removeAll();Ext.each(b,function(c){this.addOneItem(c.id,c.title,this.selectChannel.createDelegate(this,[c]),(c.id===a))},this)},selectChannel:function(a){this.button.getController().setChannel(a)}});Ext.define("SYNO.VideoController2.PrevButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("prev")},clickHandler:function(){this.getController().prev()}});Ext.define("SYNO.VideoController2.NextButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(a){this.callParent([a]);this.addClass("next")},clickHandler:function(){this.getController().next()}});Ext.define("SYNO.VideoController2.PlayerMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",constructor:function(a){this.callParent([a]);this.addStreamingItem(true)},addStreamingItem:function(b){var a={id:SYNO.VideoController2.Util.STREAMING_ID,type:SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,title:_VCT("controller","streaming_mode"),volume_adjustable:true,password_protected:false,seekable:true};this.addOneItem(SYNO.VideoController2.Util.STREAMING_ID,_VCT("controller","streaming_mode"),this.selectPlayer.createDelegate(this,[a]),b)},setPlayerList:function(a,b){this.removeAll();this.addStreamingItem(b===SYNO.VideoController2.Util.STREAMING_ID);Ext.each(a,function(c){this.addOneItem(c.id,c.title,this.selectPlayer.createDelegate(this,[c]),(b===c.id))},this)},setInitPlayer:function(b){var a=this.items.itemAt(0);this.items.each(function(c){if(c.item_id===b){a=c;return false}});a.handler.call(this)},selectPlayer:function(a){this.button.getController().setPlayer(a)}});Ext.define("SYNO.VideoController2.SettingMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",GROUPNAME_AUDIOTRACK:"audiotrack",GROUPNAME_PROFILE:"profile",QUALITY_LIST:[{title:_VCT("controller","quality_raw"),profile:null},{title:_VCT("controller","quality_high"),profile:"hd_high"},{title:_VCT("controller","quality_medium"),profile:"hd_medium"},{title:_VCT("controller","quality_low"),profile:"hd_low"}],constructor:function(a){this.callParent([a])},setQualityGroup:function(a){this.removeGroup(this.GROUPNAME_PROFILE);this.addTitle(_VCT("controller","playback_quality"),this.GROUPNAME_PROFILE);Ext.each(this.QUALITY_LIST,function(b){this.addOneItem(b.profile,b.title,this.selectProfile.createDelegate(this,[b.profile]),(b.profile===a),this.GROUPNAME_PROFILE)},this)},setRawDisabled:function(a){if(!this.items||!Ext.isBoolean(a)){return}var b=null;this.items.each(function(c){if(c.group===this.GROUPNAME_PROFILE&&c.item_id===null){b=c;return false}},this);if(!Ext.isObject(b)){return}b.setDisabled(a)},selectProfile:function(a){this.button.getController().setProfile(a)},setAudioTrackGroup:function(a,b){this.removeGroup(this.GROUPNAME_AUDIOTRACK);this.addTitle(_VCT("controller","audio_track"),this.GROUPNAME_AUDIOTRACK);Ext.each(a,function(c){var e=c.language;var d=String.format("#{0}{1} ({2})",c.track,((0>=e.length)?"":" - "+e),c.codec);this.addOneItem(c.id,d,this.selectAudioTrack.createDelegate(this,[c.id]),(c.id===b),this.GROUPNAME_AUDIOTRACK)},this)},selectAudioTrack:function(a){this.button.getController().setAudioTrack(a)}});Ext.define("SYNO.VideoController2.SubtitleMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu",constructor:function(a){this.callParent([a])},supportedSubtitle:function(b,a){if(!Ext.isString(b)){return false}if(!a){return b==="srt"}else{return["srt","pgs","dvdsub"].indexOf(b)!==-1}},setSubtitleList:function(b,a){this.removeAll();this.addNoSubtitleItem();Ext.each(b,function(c){var f=c.format.toLowerCase();if(!this.supportedSubtitle(f,a)){return true}var e=f==="srt";var d=c.subtitle_id;var h=c.lang.toLowerCase();var g;if(false===c.embedded){if(c.title===""){g=_VCT("controller","external_subtitle")}else{g=c.title}g+=h.length>0?(" - "+h):""}else{if(!Ext.isEmpty(c.title)){g=c.title}else{if(!Ext.isEmpty(h)){g=h}else{g=String.format("Subtitle Track #{0}",d)}}if(!e){g+=String.format(" ({0})",f)}}this.addOneItem(d,g,this.selectSubtitle.createDelegate(this,[d,c.need_preview,!e]),false)},this);this.addSearchSubtitleItem();this.addBrowseSubtitleItem();this.addShiftSubtitleItem()},addNoSubtitleItem:function(){this.addOneItem(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,_T("video_player","no_subtitle"),this.selectSubtitle.createDelegate(this,[SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,false]))},addSearchSubtitleItem:function(){if(SYNO.VideoController2.Util.isPublicSharing()||this.button.getController().is_subtitle_search_enabled!==true){return}this.addItemGeneral(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_SEARCH_SUBTITLE,_VCT("controller","search_subtitle"),"","",this.searchSubtitle.createDelegate(this))},addBrowseSubtitleItem:function(){if(SYNO.VideoController2.Util.isPublicSharing()){return}this.addOneItem(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_BROWSE_SUBTITLE,_VCT("controller","browse_subtitle"),this.browseSubtitle.createDelegate(this))},addShiftSubtitleItem:function(){this.addOneItem(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_SHIFT_SUBTITLE,_VCT("controller","shift_subtitle"),this.shiftSubtitle.createDelegate(this))},selectSubtitle:function(c,a,b){this.button.getController().setSubtitle(c,a,b)},searchSubtitle:function(){if(_S("demo_mode")){this.button.findWindow().getMsgBox().alert(_VCT("app","displayname"),_JSLIBSTR("uicommon","error_demo"));return}this.button.getController().searchSubtitle()},browseSubtitle:function(){this.button.getController().browseSubtitle()},shiftSubtitle:function(){this.button.getController().shiftSubtitle()}});Ext.define("SYNO.VideoController2.ListButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("list")},clickHandler:function(){this.getController().toggleList()}});Ext.define("SYNO.VideoController2.RepeatButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("repeat")},clickHandler:function(){this.getController().toggleRepeat()}});Ext.define("SYNO.VideoController2.SettingButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("setting")},createMenu:function(){return new SYNO.VideoController2.SettingMenu({button:this})}});Ext.define("SYNO.VideoController2.SubtitleButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.SubtitleButton",constructor:function(a){this.callParent([a])},createMenu:function(){return new SYNO.VideoController2.SubtitleMenu({button:this})}});Ext.define("SYNO.VideoController2.PlayerButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("player")},createMenu:function(){return new SYNO.VideoController2.PlayerMenu({button:this})}});Ext.define("SYNO.VideoController2.ChannelButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("channel")},createMenu:function(){return new SYNO.VideoController2.ChannelMenu({button:this})}});Ext.define("SYNO.VideoController2.ControlBar",{extend:"SYNO.SDS.VideoPlayerCommonVC.ControlBar",constructor:function(b){this.module=b.module;var a={items:[{xtype:"tbspacer",width:14},this.getPrevButton(),this.getPlayButton(),this.getStopButton(),this.getNextButton(),{xtype:"tbspacer",width:14},{xtype:"tbseparator",cls:"vp-separator"},{xtype:"tbspacer",width:30},this.getPositionText(),this.slashConfig,this.getDurationText(),"->",this.getListButton(),this.getRepeatButton(),this.getVolumeButton(),this.getSettingButton(),this.getSubtitleButton(),this.getPlayerButton(),this.getChannelButton(),this.getFullscreenButton(),{xtype:"tbspacer",width:14}],listeners:{scope:this,afterrender:this.setupScrollButton}};this.callParent([Ext.apply(a,b)])},hasMenuVisible:function(){return this.getVolumeButton().menu.isVisible()||this.getSettingButton().menu.isVisible()||this.getSubtitleButton().menu.isVisible()||this.getPlayerButton().menu.isVisible()||this.getChannelButton().menu.isVisible()},setupScrollButton:function(){this.scrollRightBtn=new SYNO.ux.Button({cls:"scroll-right-btn",scope:this,handler:this.scrollRight,renderTo:this.module.control_panel.getEl()});this.scrollLeftBtn=new SYNO.ux.Button({cls:"scroll-left-btn",scope:this,handler:this.scrollLeft,renderTo:this.module.control_panel.getEl()});var a=this.getScrollTarget();a.on("scroll",this.updateScrollButton,this);this.module.on("resize",this.updateScrollButton,this);this.module.control_panel.getEl().on("click",this.updateScrollButton,this);this.updateScrollButton()},updateScrollButton:function(){var b=this.getScrollTarget();var c=this.getHideScrollButtonDelayedTask();c.cancel();if(!b.isScrollable()){this.scrollRightBtn.hide();this.scrollLeftBtn.hide();return}var a=b.getScroll().left;if(a===0){this.scrollLeftBtn.hide()}else{this.scrollLeftBtn.show()}if(a+b.dom.getWidth()>=b.dom.scrollWidth){this.scrollRightBtn.hide()}else{this.scrollRightBtn.show()}c.delay(2800)},getHideScrollButtonDelayedTask:function(){if(!Ext.isDefined(this.hideScrollBtnDelayedTask)){var a=function(){this.scrollLeftBtn.hide();this.scrollRightBtn.hide()};this.hideScrollBtnDelayedTask=new Ext.util.DelayedTask(a,this)}return this.hideScrollBtnDelayedTask},scrollRight:function(){var a=this.getScrollTarget().getScroll().left+Ext.getBody().getWidth();this.getScrollTarget().scrollTo("Left",a)},scrollLeft:function(){var a=this.getScrollTarget().getScroll().left-Ext.getBody().getWidth();this.getScrollTarget().scrollTo("Left",a)},getPrevButton:function(){if(!Ext.isDefined(this.prev_button)){this.prev_button=new SYNO.VideoController2.PrevButton({module:this.module})}return this.prev_button},getNextButton:function(){if(!Ext.isDefined(this.next_button)){this.next_button=new SYNO.VideoController2.NextButton({module:this.module})}return this.next_button},getListButton:function(){if(!Ext.isDefined(this.list_button)){this.list_button=new SYNO.VideoController2.ListButton({module:this.module,hidden:true})}return this.list_button},getRepeatButton:function(){if(!Ext.isDefined(this.repeat_button)){this.repeat_button=new SYNO.VideoController2.RepeatButton({module:this.module})}return this.repeat_button},getSettingButton:function(){if(!Ext.isDefined(this.setting_button)){this.setting_button=new SYNO.VideoController2.SettingButton({module:this.module})}return this.setting_button},getSubtitleButton:function(){if(!Ext.isDefined(this.subtitle_button)){this.subtitle_button=new SYNO.VideoController2.SubtitleButton({module:this.module})}return this.subtitle_button},getPlayerButton:function(){if(!Ext.isDefined(this.player_button)){this.player_button=new SYNO.VideoController2.PlayerButton({module:this.module})}return this.player_button},getChannelButton:function(){if(!Ext.isDefined(this.channel_button)){this.channel_button=new SYNO.VideoController2.ChannelButton({module:this.module,hidden:true})}return this.channel_button}});Ext.define("SYNO.VideoController2.ControlPanel",{extend:"SYNO.SDS.VideoPlayerCommonVC.ControlPanel",constructor:function(b){var a={mouse_over:false};this.callParent([Ext.apply(a,b)])},getControlBar:function(){if(!Ext.isDefined(this.controlBar)){this.controlBar=new SYNO.VideoController2.ControlBar({module:this.module})}return this.controlBar},setPrevNext:function(b,a){this.getControlBar().getPrevButton().setDisabled(!b);this.getControlBar().getNextButton().setDisabled(!a)},setMouseOver:function(a){this.mouse_over=a},isMouseOver:function(){return this.mouse_over}});Ext.define("SYNO.VideoController2.Display",{extend:"SYNO.SDS.VideoPlayerCommonVC.Display",ALL_META_CLASSES:["poster","screenshot","buffer","error"],constructor:function(b){var a={remote_mode:false,video_info:{}};this.callParent([Ext.apply(a,b)])},setVideoInfo:function(a){this.video_info=a;this.playing_cls=((this.video_info.type==="movie")?"poster":"screenshot");this.playing_exclude_cls=this.ALL_META_CLASSES.filter(function(b){return(this.playing_cls!==b)},this);this.image_url=SYNO.VideoController2.Util.getImageURL(a.video_id,a.type)},setRemoteMode:function(b,a){this.remote_mode=b;if(this.remote_mode){this.status_text=String.format(_VCT("controller","playing_on"),a)}},setStopped:function(){if(!this.remote_mode){this.callParent(arguments);return}this.layout.setActiveItem(1);this.getMetaDisplay().removeClass(this.ALL_META_CLASSES);this.getMetaDisplay().setImage("");this.getMetaDisplay().setText("")},setPlaying:function(){if(!this.remote_mode){this.callParent(arguments);return}this.layout.setActiveItem(1);this.getMetaDisplay().removeClass(this.playing_exclude_cls);this.getMetaDisplay().addClass(this.playing_cls);this.getMetaDisplay().setImage(this.image_url);this.getMetaDisplay().setText(this.status_text)}});Ext.define("SYNO.VideoController2.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.VideoController2.AppWindow"});Ext.define("SYNO.VideoController2.AppWindow",{extend:"SYNO.SDS.VideoPlayerCommonVC.AppWindow",constructor:function(b){var a=Ext.apply({},b);a.listeners=a.listeners||{};Ext.apply(a.listeners,{afterrender:this.initTask.createDelegate(this)});this.callParent([a]);this.addClass("syno-vc-win")},getDisplay:function(){if(!Ext.isDefined(this.display)){this.display=new SYNO.VideoController2.Display()}return this.display},getControlPanel:function(){if(!Ext.isDefined(this.control_panel)){this.control_panel=new SYNO.VideoController2.ControlPanel({module:this})}return this.control_panel},getController:function(){if(!Ext.isDefined(this.controller)){var a=this.getControlPanel();this.controller=new SYNO.VideoController2.Controller({appWin:this,container:this.getDisplay().getEl(),video:this.getDisplay().getComponent("video_display").getComponent("video").getEl(),jsBaseURL:String.format("{0}/controller/ui",this.jsConfig.jsBaseURL),init_player_id:this.init_player_id,type_info:this.type_info,video_info:this.video_info,dtv_url:this.dtv_url,listeners:{busy:this.setStatusBusy.createDelegate(this),clear:this.clearStatusBusy.createDelegate(this),rawdisabled:this.onRawDisabled.createDelegate(this),capabilityready:this.onCapabilityReady.createDelegate(this),channellistready:this.onChannelListReady.createDelegate(this),playerlistchange:this.onPlayerListChange.createDelegate(this),playerdecided:this.onPlayerDecided.createDelegate(this),targetchange:this.onTargetChange.createDelegate(this),repeatchange:this.onRepeatChange.createDelegate(this),titlechange:this.onTitleChange.createDelegate(this),videochange:this.onVideoChange.createDelegate(this),statechange:this.setState.createDelegate(this),mutechange:a.setMute.createDelegate(a),volumechange:a.setVolume.createDelegate(a),timechange:this.setTime.createDelegate(this),subtitlechange:this.setSubtitle.createDelegate(this)}})}return this.controller},getControlBar:function(){return this.getControlPanel().getControlBar()},setSubtitle:function(c,b){this.callParent(arguments);var a=this.getControlBar().getSubtitleButton().menu;a.setItemSelected(b)},setTime:function(a,b){if(this.getController().isSubtitleVisible()){var c=this.getController().getSubtitleParser().getText(a+this.getController().getShiftTime());this.getDisplay().setSubtitle(c)}this.getControlPanel().setTime(a,b)},hasModalWin:function(){return this.modalWin.length>0},onRawDisabled:function(b,d){var a=this.getControlBar().getSettingButton().menu;var c=d;if(d===null){c=b?"hd_high":null}a.setItemSelected(c,SYNO.VideoController2.SettingMenu.prototype.GROUPNAME_PROFILE);a.setRawDisabled(b)},onCapabilityReady:function(c,a){if(!a){this.getControlBar().getSettingButton().hide();return}if(c){var b=this.getControlBar().getSettingButton();b.enable();b.menu.setQualityGroup(this.getController().profile)}},onChannelListReady:function(a){var b=this.getControlBar().getChannelButton();b.enable();b.menu.setChannelList(a,this.getController().channel_id)},onPlayerListChange:function(a){var b=this.getControlBar().getPlayerButton().menu;b.setPlayerList(a,this.getController().player_info.id)},onPlayerDecided:function(b,a){this.getControlBar().getSubtitleButton().menu.setSubtitleList(b,a)},onRepeatChange:function(c){var a="none";if(c===SYNO.VideoController2.Util.REPEAT_ALL){a="all"}else{if(c===SYNO.VideoController2.Util.REPEAT_ONE){a="one"}}var b=this.getControlBar().getRepeatButton();b.removeClass(["none","all","one"]);b.addClass(a)},onTargetChange:function(a){this.getDisplay().setRemoteMode(this.getController().isRemoteMode(),a.title);this.getControlBar().getVolumeButton().setDisabled(true!==a.volume_adjustable);this.getControlBar().getSettingButton().setDisabled(SYNO.VideoController2.Util.PLAYERTYPE_UPNP===a.type);var c=(SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY!==a.type)||this.getController().support_remux;this.getControlBar().getSubtitleButton().setDisabled(!c);var b=!this.getController().isRemoteMode()&&SYNO.SDS.VideoPlayerCommonVC.Util.isDomFullscreenSupported();this.getControlBar().getFullscreenButton().setDisabled(!b)},onVideoChange:function(h,f,g,e,b){this.getDisplay().setVideoInfo(g);this.getControlPanel().setPrevNext(h,f);var d=this.getControlBar();var a=this.getController();d.getSubtitleButton().menu.setSubtitleList(b);var c=d.getSettingButton().menu;if(a.support_remux){c.setAudioTrackGroup(e,a.audio_id)}},onTitleChange:function(a){this.setTitle(a)},onOpen:function(a){this.callParent(arguments);window.onbeforeunload=this.onWindowBeforeUnload.createDelegate(this);var b=this.getControlPanel().getControlBar();this.setStatusBusy();if(Ext.isString(a.dtv_url)){this.dtv_url=a.dtv_url;if(!Ext.isEmpty(Ext.util.Cookies.get("id"))){this.dtv_url+="_"+Ext.util.Cookies.get("id");if(!Ext.isEmpty(_S("SynoToken"))){this.dtv_url+="_"+_S("SynoToken")}}b.getPrevButton().hide();b.getNextButton().hide();b.getRepeatButton().hide();b.getSettingButton().disable();b.getChannelButton().disable();b.getSubtitleButton().hide();b.getPlayerButton().hide();b.getChannelButton().show();this.getController().initSequenceDTV()}else{if(Ext.isDefined(a.video_id)){this.init_player_id=a.player_id;this.type_info={type:a.browse_type,sort_info:Ext.decode(a.sort_info),id:parseInt(a.type_id,10)};this.video_info={id:parseInt(a.video_id,10),type:a.video_type,file_id:a.file_id,title:a.title};this.getController().initSequenceVideo()}else{if(Ext.isDefined(a.path)){b.getPlayerButton().hide();this.init_player_id=a.player_id;this.type_info={type:a.browse_type};this.video_info={path:a.path,type:a.video_type,symlink:Ext.isString(a.symlink)?a.symlink:null};this.getController().initSequenceVideo()}}}},onWindowBeforeUnload:function(){this.getController().unlink();this.getController().stop(Ext.emptyFn,true)},getFnKey:function(b){var a="none";if(b.ctrlKey&&!b.shiftKey){a="ctrl"}if(!b.ctrlKey&&b.shiftKey){a="shift"}return a},initTask:function(){var d=this;var c={"37":{none:-10,ctrl:-30,shift:-60},"39":{none:10,ctrl:30,shift:60}};var a={"38":{none:10,ctrl:25,shift:50},"40":{none:-10,ctrl:-25,shift:-50}};var b=new Ext.util.DelayedTask(function(){if(d.getController().state===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING&&!d.hasModalWin()&&!d.getControlBar().hasMenuVisible()&&!d.getControlPanel().isMouseOver()){d.getControlPanel().getProgressBar().hide();d.getControlPanel().getControlBar().hide();d.doLayout()}});Ext.getBody().on("mousemove",function(f){if(!d.getControlPanel().getProgressBar().isVisible()){d.getControlPanel().getProgressBar().show();d.getControlPanel().getControlBar().show();d.doLayout()}if(this.getController().state===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING){b.delay(2000)}},this);d.getControlPanel().getEl().on("mouseover",function(f){d.getControlPanel().setMouseOver(true)});d.getControlPanel().getEl().on("mouseout",function(f){d.getControlPanel().setMouseOver(false)});this.keymap=new Ext.KeyMap(Ext.getBody(),[{key:Ext.EventObject.SPACE,fn:function(){if(this.getController().spaceenabled){this.getController().play()}},scope:this},{key:[37,39],fn:function(h,g){if(!this.hasModalWin()){var f=this.getFnKey(g);this.getController().seekInterval(c[h][f])}},scope:this},{key:[38,40],fn:function(h,g){if(!this.hasModalWin()){var f=this.getFnKey(g);this.getController().adjustVolume(a[h][f])}},scope:this}]);this.pollingTask=this.addTask({interval:5000,scope:this,run:function(){if(this.isDestroyed){this.pollingTask.stop();return}if(this.getController().spaceenabled){document.activeElement.blur()}}}).start()}});