#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

PSQL="/usr/bin/psql"

ExecSqlCommand()
{
	$PSQL -U postgres video_metadata -c "$1" > /dev/null 2>&1
}

DATABASE="video_metadata"
TABLE="collection_sharing"

echo "test $TABLE table in $DATABASE DB"
ExecSqlCommand "SELECT * FROM $TABLE LIMIT 1"
Ret=$?
if [ $Ret = 1 ]; then
	echo "Create $TABLE table in $DATABASE DB"
	Script="/var/packages/VideoStation/target/scripts/sql/upgrade/005_sharing_smart_collection.pgsql"
	$PSQL -U postgres $DATABASE < $Script
	if [ $? != 0 ]; then
		echo "Failed to create $TABLE table in $DATABASE DB"
		exit
	fi
fi
