ACTION="$1"
PKG_PATH="$2"

FAILURE_LOG_PATH="/tmp/DVB_driver_intall_failed"
DEP_TABLE="usb.DVB.dep.table"
VIDPID_TABLE="usb.DVB.VIDPID.table"

buildnumber=`cat /etc.defaults/VERSION | grep buildnumber | cut -d'"' -f2`
if [ $buildnumber -le 4928 ]; then
	DEVICE_TABLE_FOLDER="/usr/syno/hotplug"
	DVB_HANDLER_FOLDER="/usr/syno/hotplug"
	DVB_HANDLER="usb.DVB.function"
else
	DEVICE_TABLE_FOLDER="/lib/udev/devicetable"
	DVB_HANDLER_FOLDER="/lib/udev/script"
	DVB_HANDLER="usb-dvb-util.sh"
fi

GetTableSuffix ()
{
	local DSMVersion="$1"."$2"
	local DriverVersion=""
	case "${DSMVersion}" in
		"5.0")
			DriverVersion="linux-media-2013-11-30"
			;;
		"5.1")
			DriverVersion="linux-media-2013-11-30"
			;;
		"5.2")
			DriverVersion="linux-media-2013-11-30"
			;;
		*)
			# should add new entry with new version of DSM development
			DriverVersion=""
			return
			;;
	esac
	echo "_DSM${DSMVersion}_${DriverVersion}"
}

if [ "${ACTION}" = "start" ]; then
	local VersionMajor=`cat /etc.defaults/VERSION | grep majorversion | cut -d'"' -f2`
	local VersionMinor=`cat /etc.defaults/VERSION | grep minorversion | cut -d'"' -f2`
	local FileExist=`ls ${PKG_PATH}/target/etc/KernelModules/ | grep "${VersionMajor}\.${VersionMinor}" | grep "bz2"`
	local DriverMatchAlready=`ls ${PKG_PATH}/target/etc/KernelModules/ | grep "${VersionMajor}\.${VersionMinor}_driver"`

	[ -n "${FileExist}" ] || echo "DVB driver tar for DSM${VersionMajor}.${VersionMinor} has gone..." >> ${FAILURE_LOG_PATH}

	if [ "${DriverMatchAlready}" = "" -a "${FileExist}" != "" ]; then
		rm -f ${PKG_PATH}/target/etc/KernelModules/*.ko
		sleep 1s
		/bin/tar -jxf ${PKG_PATH}/target/etc/KernelModules/${FileExist} -C ${PKG_PATH}/target/etc/KernelModules/;
		if [ "$?" != "0" ]; then
			echo "tar ${FileExist} failed...exit now" >> ${FAILURE_LOG_PATH}
			exit 1
		else
			rm -f ${PKG_PATH}/target/etc/KernelModules/*_driver
			touch ${PKG_PATH}/target/etc/KernelModules/${VersionMajor}\.${VersionMinor}_driver
		fi
	fi

	USB_AGENT="/usr/syno/hotplug/usb.agent"
	if [ -e ${USB_AGENT} ]; then
		if [ "`cat ${USB_AGENT} | grep "hotplug/usb.DVB.function" | grep "MAJOR"`" = "" ]; then
			/bin/sed -i 's/usb.DVB.function "$ACTION" "$usb_idVendor" "$usb_idProduct"/usb.DVB.function "$ACTION" "$usb_idVendor" "$usb_idProduct" "$MAJOR" "$MINOR"/' ${USB_AGENT}
		fi
	fi

	local TableSuffix=`GetTableSuffix ${VersionMajor} ${VersionMinor}`
	if [ -z ${TableSuffix} ]; then
		echo "No driver for DSM${VersionMajor}.${VersionMinor} ...exit now" >> ${FAILURE_LOG_PATH}
		exit 1
	fi
	local DepTablePath="${PKG_PATH}/target/scripts/Hotplug/${DEP_TABLE}${TableSuffix}"
	local VidPidTablePath="${PKG_PATH}/target/scripts/Hotplug/${VIDPID_TABLE}${TableSuffix}"
	if [ ! -f ${DepTablePath} ]; then
		echo "Cannot find dep table ${DepTablePath} ...exit now" >> ${FAILURE_LOG_PATH}
		exit 1
	fi
	if [ ! -f ${VidPidTablePath} ]; then
		echo "Cannot find VID/PID table ${VidPidTablePath} ...exit now" >> ${FAILURE_LOG_PATH}
		exit 1
	fi
	cp -f ${DepTablePath} ${DEVICE_TABLE_FOLDER}/${DEP_TABLE}
	cp -f ${VidPidTablePath} ${DEVICE_TABLE_FOLDER}/${VIDPID_TABLE}
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh "start" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh "start" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/Hotplug/${DVB_HANDLER}" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/${DVB_HANDLER} ${DVB_HANDLER_FOLDER}
	[ -e "${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh" ] && ${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh "add"
else
	[ -e "${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh" ] && ${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh "remove"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh "stop" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh "stop" "${PKG_PATH}"
	[ -e "/usr/syno/hotplug/usb.DVB.function" ] && rm -f /usr/syno/hotplug/usb.DVB.function
	[ -e "/usr/syno/hotplug/${DEP_TABLE}" ] && rm -f /usr/syno/hotplug/${DEP_TABLE}
	[ -e "/usr/syno/hotplug/${VIDPID_TABLE}" ] && rm -f /usr/syno/hotplug/${VIDPID_TABLE}
	[ -e "/lib/udev/script/usb-dvb-util.sh" ] && rm -f /lib/udev/script/usb-dvb-util.sh
	[ -e "/lib/udev/devicetable/${DEP_TABLE}" ] && rm -f /lib/udev/devicetable/${DEP_TABLE}
	[ -e "/lib/udev/devicetable/${VIDPID_TABLE}" ] && rm -f /lib/udev/devicetable/${VIDPID_TABLE}
fi
