#!/bin/sh

FROM_PATH=$2/target/etc/KernelModules

TO_PATH=/lib/modules

list=`ls $FROM_PATH`

case $1 in
	start)
		for i in $list;
		do
			#Only the *.ko need to be symbolic link
			if [ "`echo $i | cut -d'.' -f2`" != "ko" ]; then
				continue
			fi
			ln -sf $FROM_PATH/$i $TO_PATH/$i
		done
	;;
	stop)
		for i in $list;
		do
			#Only the *.ko need to remove symbolic link
			if [ "`echo $i | cut -d'.' -f2`" != "ko" ]; then
				continue
			fi
			rm -f $TO_PATH/$i
		done
	;;
	restart)
		$0 stop
		$0 start
	;;
	*)
		echo "$1 <= Not supported !"
	;;
esac
