-- vim:ft=sql

BEGIN;

CREATE TABLE watch_status (
	id serial NOT NULL,
	uid bigint NOT NULL,
	video_file_id serial NOT NULL,
	mapper_id serial NOT NULL,
	position integer NOT NULL,
	create_date timestamp DEFAULT current_timestamp,
	modify_date timestamp DEFAULT current_timestamp,
	CONSTRAINT watch_status_pkey PRIMARY KEY (id),
	CONSTRAINT watch_status_ukey UNIQUE (uid, video_file_id, mapper_id),
	CONSTRAINT watch_status_mapper_fkey FOREIGN KEY (mapper_id)
		REFERENCES mapper (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT watch_status_video_file_fkey FOREIGN KEY (video_file_id)
		REFERENCES video_file (id) MATCH SIMPLE
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

COMMIT;
