#!/bin/sh

FROM_PATH=$2/target/etc/KernelFirmwares

# <DSM> #61696 - move firmware folder path
buildnumber=`cat /etc.defaults/VERSION | grep buildnumber | cut -d'"' -f2`
if [ $buildnumber -le 4928 ]; then
	TO_PATH=/usr/syno/hotplug/firmware
else
	TO_PATH=/lib/firmware
fi

list=`ls $FROM_PATH`

case $1 in
	start)
		for i in $list;
		do
			ln -sf $FROM_PATH/$i $TO_PATH/$i
		done
	;;
	stop)
		for i in $list;
		do
			rm -f $TO_PATH/$i
		done
	;;
	restart)
		$0 stop
		$0 start
	;;
	*)
		echo "$1 <= Not supported !"
	;;
esac
