BEGIN;

CREATE VIEW original_collection_video_list AS
	(SELECT 0 AS type, UPPER(sort_title) AS title, 0 AS season, 0 AS episode, mapper_id, sort_time FROM movie) UNION
	(SELECT 2 AS type, UPPER(sort_title) AS title, 0 AS season, 0 AS episode, mapper_id, record_time AS sort_time FROM home_video) UNION
	(SELECT 3 AS type, UPPER(sort_title) AS title, 0 AS season, 0 AS episode, mapper_id, record_time AS sort_time FROM tv_record) UNION
	(SELECT 1 AS type, tv.t AS title, season, episode, mapper_id, sort_time FROM tvshow_episode LEFT JOIN (SELECT id, UPPER(sort_title) AS t FROM tvshow) as tv ON tvshow_episode.tvshow_id = tv.id);

CREATE VIEW tvshow_episode_with_title AS
	SELECT e.id, e.tvshow_id, e.library_id, e.mapper_id, e.tag_line, e.season, e.episode,
	       e.year, e.originally_available, e.sort_time, e.islock, e.create_date, e.modify_date, tv.sort_title FROM tvshow_episode AS e
	LEFT JOIN (SELECT id, UPPER(sort_title) AS sort_title FROM tvshow) AS tv ON e.tvshow_id = tv.id;

COMMIT;
