/* Copyright (c) 2014 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.VideoStation.ImageLoadManager",{extend:"Ext.util.Observable",MAX_CONCURRENT:5,running:0,jobs:null,preemptJobs:null,delegate:null,constructor:function(){this.callParent(arguments);this.jobs=[];this.preemptJobs=[];this.delayedPreemptJob=new Ext.util.DelayedTask(this.preemptJob,this)},clear:function(){this.running=0;this.jobs=[];this.preemptJobs=[]},appendJob:function(a){if(-1!==this.jobs.indexOf(a)){return}this.jobs.push(a);this.dispatch()},insertJob:function(a){this.preemptJobs.push(a);this.delayedPreemptJob.delay(100)},preemptJob:function(){Ext.each(this.preemptJobs,function(a){this.jobs.remove(a)},this);this.jobs.unshift.apply(this.jobs,this.preemptJobs);this.preemptJobs=[];this.dispatch()},dispatch:function(){while(this.MAX_CONCURRENT>=this.running){var a=this.jobs.shift();if(!a){break}this.running++;this.setImgURL(a)}},setImgURL:function(c){var b=c.getAttribute("url");if(!b){this.running--;this.dispatch.defer(0,this);return}var a=document.createElement("img");Ext.fly(a).on({load:this.onImageLoad.createDelegate(this,[c,a,b]),error:this.onImageError.createDelegate(this,[c,a,b])});c.dom.removeAttribute("url");a.src=b},finalizedImageLoad:function(b,a){this.running--;this.dispatch.defer(0,this)},onImageLoad:function(c,a,b){this.finalizedImageLoad(a);if(this.delegate){this.delegate.onImageLoad(a)}c.dom.setAttribute("style",String.format(SYNO.SDS.VideoStation.Util.BACKGROUND_IMAGE_STR,b));c.removeClass("loading");a=null},onImageError:function(c,a,b){this.finalizedImageLoad(c,a);if(this.delegate){this.delegate.onImageError(c,a)}}});Ext.define("SYNO.SDS.VideoStation.PagingToolbar",{extend:"SYNO.ux.PagingToolbar"});Ext.define("SYNO.SDS.VideoStation.ListPanel",{extend:"SYNO.ux.ModuleList",updateScrollBarEventNames:["loadlibrary","afterlayout","resize","expandnode","collapsenode"],constructor:function(a){this.TitleMap={};this.TitleMap[SYNO.SDS.VideoStation.Util._MOVIE_ID]=_VST("type","movie");this.TitleMap[SYNO.SDS.VideoStation.Util._TVSHOW_ID]=_VST("type","tv_show");this.TitleMap[SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID]=_VST("type","home_video");this.TitleMap[SYNO.SDS.VideoStation.Util._TV_RECORDER_ID]=_VST("type","tv_recorder");this.TitleMap[SYNO.SDS.VideoStation.Util._COLLECTION_ID]=_VST("collection","title");this.IconMap={};this.IconMap[SYNO.SDS.VideoStation.Util._MOVIE_ID]="movie";this.IconMap[SYNO.SDS.VideoStation.Util._TVSHOW_ID]="tvshow";this.IconMap[SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID]="homevideo";this.IconMap[SYNO.SDS.VideoStation.Util._TV_RECORDER_ID]="tvrecord";this.IconMap[SYNO.SDS.VideoStation.Util._COLLECTION_ID]="collection";this.current_library=SYNO.SDS.VideoStation.Util._MOVIE_ID;this.callParent([this.fillConfig(a)]);this.addClass("syno-vs-listpanel");SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ListPanel",this);this.mon(this.getSelectionModel(),"selectionchange",this.onListSelect,this);this.getStore().load()},fillConfig:function(a){var b={cls:"syno-vs-list",tbar:{items:[this.getSearchField()]},listItems:this.getListItems()};return Ext.apply(b,a)},getListItems:function(){var b=[SYNO.SDS.VideoStation.Util._COLLECTION_ID,SYNO.SDS.VideoStation.Util._MOVIE_ID,SYNO.SDS.VideoStation.Util._TVSHOW_ID,SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,SYNO.SDS.VideoStation.Util._TV_RECORDER_ID];var a=[];Ext.each(b,function(d){var c={id:d,type:d,title:this.TitleMap[d]};a.push({text:this.TitleMap[c.type],iconCls:this.IconMap[c.type],fn:c.id,library:c})},this);return a},getSearchField:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");return new SYNO.SDS.VideoStation.SearchField({width:212,getMenu:a.getSearchMenu.createDelegate(a)})},addLibrary:function(a){var b={text:a.title,iconCls:"library",fn:a.id,library:a};this.appendModule(b)},clearCustomLibrary:function(){this.store.each(function(a){this.removeModule(a.data.id)},this)},onLibraryLoad:function(){this.store.each(function(a){this.addLibrary(a.data)},this);if(!this.getNodeById(this.current_library)){this.current_library=SYNO.SDS.VideoStation.Util._MOVIE_ID}this.selectModule(this.current_library);this.fireEvent("loadlibrary")},loadLibrary:function(){this.getStore().load()},getStore:function(){if(this.store){return this.store}var a=new SYNO.SDS.VideoStation.LibraryStore({appWindow:SYNO.SDS.VideoStation.Window,listeners:{scope:this,beforeload:this.clearCustomLibrary,load:this.onLibraryLoad}});this.addManagedComponent(a);return(this.store=a)},onListSelect:function(a,b){var c=b||this.getNodeById(SYNO.SDS.VideoStation.Util._MOVIE_ID);this.current_library=c.id;this.onSwitchPanel(c.attributes.library)},onSwitchPanel:function(a){this.hideSearchOptions(a.id);SYNO.SDS.VideoStation.Window.getPathMgr().initLibrary(a);SYNO.SDS.VideoStation.Window.getPathMgr().onGotoPanel(a.id)},hideSearchOptions:function(c){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.SearchField");var a="";if(c===SYNO.SDS.VideoStation.Util._COLLECTION_ID){a="actor, director, genre, writer, year, date, channelname, title"}else{if(c===SYNO.SDS.VideoStation.Util._TV_RECORDER_ID){a="actor, director, genre, writer, year"}else{a="date, channelname, title"}}Ext.each(b.getMenu().items.items,function(f,d,e){if(-1!==a.indexOf(f.categoryValue)){f.hide()}else{f.show()}},this)}});Ext.define("SYNO.SDS.VideoStation.LibraryStore",{extend:"SYNO.API.Store",constructor:function(b){var a={api:"SYNO.VideoStation.Library",method:"list",version:1,reader:new Ext.data.JsonReader({root:"libraries",fields:["id","title","type"]})};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation.SearchField",{extend:"SYNO.ux.SearchField",constructor:function(b){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.SearchField",this);var a={emptyText:_VST("search","keyword"),enableKeyEvents:true,getMenu:b.getMenu||Ext.emptyFn,listeners:{scope:this,keypress:this.onSearchFieldKeyDown}};this.callParent([Ext.apply(a,b)])},onSearchTriggerClick:function(){if(SYNO.SDS.VideoStation.Util._getHistoryInfo().type.type===SYNO.SDS.VideoStation.Util._COLLECTION_ID){return false}this.callParent(arguments)},onTriggerClick:function(){var a=this.getValue();this.callParent(arguments);if(a){if(this.isFilterMode()&&true===this.isFiltered){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoSearch(true);this.isFiltered=false}}},isFilterMode:function(){var b=false;var a=SYNO.SDS.VideoStation.Util.SEARCH_HISTORY[SYNO.SDS.VideoStation.Util._getCurId()];var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();if("all"!==a&&c&&c.subtype&&"classes"===c.subtype){b=true}return b},onSearchFieldKeyDown:function(d,a){if(a.getKey()!==Ext.EventObject.ENTER){return}var c=SYNO.SDS.VideoStation.Util._getHistoryInfo();if(c.type===SYNO.SDS.VideoStation.Util._COLLECTION_ID&&c.index===0){return}var b=d.getValue().trim();if(b||this.isFilterMode()){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoSearch(true);this.isFiltered=(b&&this.isFilterMode())?true:false}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.ViewSearch=Ext.extend(Ext.Container,{constructor:function(a){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewSearch",this);var b=this.fillConfig(a);SYNO.SDS.VideoStation.ViewSearch.superclass.constructor.call(this,b)},fillConfig:function(a){var b={};Ext.apply(b,a);return b}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.TVseasonHttpProxy=Ext.extend(Ext.data.HttpProxy,{onRead:function(d,b,f){try{var a=Ext.decode(f.responseText);var g=a.data;var k={};Ext.each(g.episodes,function(e){var m=e.season;m=m>0?m:-1;if(!k[m]){k[m]=[]}k[m].push(e)},this);a.newdata=[];for(var l in k){if(k.hasOwnProperty(l)){a.newdata.push({season:l,episodes:k[l]})}}a.newdata.sort(function(o,n){var m=parseInt(o.season,10);var e=parseInt(n.season,10);if(m<=0){return 1}else{if(e<=0){return -1}}return(m-e)});Ext.each(a.newdata,function(e){e.episodes.sort(function(p,n){var o=parseInt(p.episode,10);var m=parseInt(n.episode,10);if(o<=0){return 1}else{if(m<=0){return -1}}return(o-m)})});if(a.newdata.length>0){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo().params;a.newdata.splice(0,0,{season:-10,episodes:[{season:-10,title:c.name||"",original_available:c.original_available||"",additional:{summary:c.summary||""}}]})}f.responseText=Ext.encode(a);SYNO.SDS.VideoStation.TVseasonHttpProxy.superclass.onRead.apply(this,arguments)}catch(j){this.fireEvent("loadexception",this,b,f,j);this.fireEvent("exception",this,"response",d,b,f,j);return}}});Ext.define("SYNO.SDS.VideoStation.ViewTVseason",{extend:"SYNO.ux.Panel",constructor:function(a){this.updateScrollBarEventNames.push("load");this.addEvents("load");SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewTVseason",this);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={border:false,cls:"syno-vs-episode-panel",layout:"fit",autoFlexcroll:true,items:[],listeners:{activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({proxy:new SYNO.SDS.VideoStation.TVseasonHttpProxy({url:this._getWebAPIURL("tvshow_episode.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}},load:function(c,e,d){if(!(e&&e.reader&&e.reader.jsonData&&e.reader.jsonData.data&&e.reader.jsonData.data.episodes)){return}this.lastWatchedID=-1;if(!this.isRecentlyWatch){return}var b=e.reader.jsonData.data.episodes;var a=-1;b.each(function(f){if(parseInt(f.last_watched,10)>parseInt(a,10)){a=f.last_watched;this.lastWatchedID=f.id}},this)}}}),method:"POST",baseParams:{api:"SYNO.VideoStation.TVShowEpisode",method:"list",version:"1"},reader:new Ext.data.JsonReader({id:"season",root:"newdata",totalProperty:"data.total",fields:["season","episodes"]}),listeners:{scope:this,beforeload:function(){this._getOwner().setStatusBusy();this.removeAll()},load:this.onAfterLoadStore,exception:function(){this._getOwner().clearStatusBusy()}}});return this.store},onAfterLoadStore:function(b,e){var c=0,d;this._getOwner().clearStatusBusy();if(0===e.length){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoBack()}var a=this.collapsedseasons||[];Ext.each(e,function(g){var f=(a.indexOf(parseInt(g.id,10))!==-1);if(g.id===-10){this.add(this.createTVShowSummary(g.data,f))}else{this.add(this.createSeason(g.data,f))}return true},this);this.doLayout();this.fireEvent("load")},createTVShowSummary:function(c,f){var e=c.episodes[0].title;var b=new SYNO.SDS.VideoStation.EpisodePanel({module:this,season:-10});b.loadEpisodes(c);var d=this.getSeasonDesc(c);var a=new SYNO.ux.FieldSet({title:e,style:"width: 100%;",layout:"fit",autoHeight:true,collapsible:true,listeners:{afterlayout:{single:true,fn:function(j){var g=j.getEl().child("legend");Ext.DomHelper.insertFirst(g,{tag:"div",cls:"summary-header",html:d})}}},items:[b]});return a},createSeason:function(d,g){var f="";var c=parseInt(d.season,10);if(c>0){f=String.format(_VST("season","title"),c)}else{f=_VST("classification","other")}var b=new SYNO.SDS.VideoStation.EpisodePanel({module:this,season:c});b.loadEpisodes(d);var e=this.getSeasonDesc(d);var a=new SYNO.ux.FieldSet({title:f,style:"width: 100%;",layout:"fit",autoHeight:true,collapsible:true,listeners:{afterlayout:{single:true,fn:function(k){var j=k.getEl().child("legend");Ext.DomHelper.insertFirst(j,{tag:"div",cls:"season-header",html:e})}}},items:[b]});return a},getSeasonDesc:function(b){if(-10===b.season){var c="",a=b.episodes[0].original_available;if(a&&a!=="0"){c=a;c+=", "}c+=String.format(_VST("season","number"),this.getStore().getCount()-1);return c}return String.format(_VST("episode","number"),b.episodes.length)},selectEpisode:function(d,b,a){if(a){Ext.each(this.getSeasons(),function(e){e.clearSelections()})}var c=this.getSeasons(d);if(c.length>0&&c[0]){c[0].select(b,!a)}},getSeasons:function(b){var a=this.findBy(function(c){var e=Ext.isString(c.itemSelector)&&Ext.isNumber(c.season)&&c.season!==-10;var d=!Ext.isNumber(b)||c.season===b;return e&&d});return a},onGotoNext:function(b){var a="<i>"+_VST("classification","other")+"</i>";if(b.episode){a=String.format(_VST("episode","title")+" - {1}",b.episode,b.title)}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoNext({id:b.id,name:a,poster_mtime:b.additional?b.additional.poster_mtime||"":""})},onActivate:function(){var b=this._getHistoryInfo();var a=b.status;if(a.tvshow_id!==b.params.id){b.status={};this.collapsedseasons=undefined}this.onLoadStore()},onDeactivate:function(){this.collapsedseasons=SYNO.Util.copy(this.getCollapsedSeasons())},getCollapsedSeasons:function(){var a=[];this.items.each(function(b){if(b.collapsed){a.push(b.items.items[0].season)}});return a},hasSeasons:function(){var a=this.getStore().getCount();return !(0===a||(1===a&&this.getStore().data.first().data.season<=0))},checkFieldSetStatus:function(b){var a=false;this.items.each(function(c){if(c.collapsed===b){a=true;return false}});return a},isOneExpandSeason:function(){return this.checkFieldSetStatus(false)},isOneCollapseSeason:function(){return this.checkFieldSetStatus(true)},onExpandCollapseSeasons:function(a){this.items.each(function(b){b[a?"expand":"collapse"](false)})},onLoadStore:function(){var b=this._getHistoryInfo();var c={library_id:this._getCurLibraryId(),tvshow:b.params.id,additional:"summary,collection,poster_mtime"};var a=undefined;if(b.params&&b.params.category&&"recently_watched"===b.params.category){this.isRecentlyWatch=true}else{this.isRecentlyWatch=false}if(b.params&&"all"!==b.params.category){a=b.params.category;c[a]=b.params.category_id;if("recently_watched"===a){Ext.apply(c,{sort_by:"last_watched",sort_direction:"desc",recently_watched:0})}}this.getStore().load({params:c});Ext.apply(this._getHistoryInfo().status,{tvshow_id:b.params.id})},getSelectedDatas:function(){var a=[];Ext.each(this.getSeasons(),function(b){a.push.apply(a,b.getSelectedRecords())});return a},getSelectedData:function(){var a=null;Ext.each(this.getSeasons(),function(b){if(b.getSelectionCount()>0){a=b.getSelectedRecords()[0];return false}});return a},getSelectionCount:function(){var a=0;Ext.each(this.getSeasons(),function(b){a+=b.getSelectionCount()});return a}});Ext.define("SYNO.SDS.VideoStation.EpisodePanel",{extend:"SYNO.ux.Panel",constructor:function(b){this.dataview=new SYNO.SDS.VideoStation.EpisodeView({module:b.module,season:b.season,store:this.getStore()});var a={cls:"episode-panel",items:this.dataview};this.callParent([Ext.apply(a,b)])},loadEpisodes:function(a){this.getStore().loadData(a)},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.Store({reader:new Ext.data.JsonReader({root:"episodes",fields:["id","additional","episode","season","tagline","title","tvshow_id","tvshow_mapper_id","tvshow_original_available"]})});return this.store}});Ext.define("SYNO.SDS.VideoStation.EpisodeView",{extend:"Ext.DataView",summarylength:230,constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);this.season=b.season;var a={module:b.module,cls:"syno-vs-dataview-episode",itemSelector:"div.syno-vs-data-template",overClass:"syno-vs-data-item-over",trackOver:false,hideHeaders:true,multiSelect:true,listeners:{scope:this,beforeclick:function(c,d,f,g){if(this.season===-10){return false}if(g.ctrlKey){if(this.isSelected(f)){this.deselect(f)}else{this.addThisSelection(d)}}else{if(this.isClickingIcon(g)){this.gotoDetail(f)}else{this.singleSelectThis(d)}}return false}},tpl:this.getTpl()};this.callParent([Ext.apply(a,b)])},isClickingIcon:function(c){var b=c.getTarget();var a=Ext.get(b);if(a&&a.is("div.syno-vs-data-icon")){return true}return false},gotoDetail:function(a){this.module.onGotoNext(this.getRecord(a).data)},singleSelectThis:function(a){this.module.selectEpisode(this.season,a,true)},addThisSelection:function(a){this.module.selectEpisode(this.season,a,false)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="syno-vs-data-template {[this.getEpisodeCls(values)]}">','<div class="data-container">','<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout syno-vs-data-template-table">',"<tbody><tr>",'<td class="x-table-layout-cell">',"{[this.getIcon(values)]}","</td>",'<td class="x-table-layout-cell" valign="top">','<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout"><tbody>',"{[this.getTitleRow(values)]}","{[this.getDescRow(values)]}","<tr>",'<td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-summary" valign="top">',"<div><span>","{[this.getSummary(values)]}","</span></div>","</td>","</tr>","</tbody></table>","</td>","</tr></tbody>","</table>","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{compiled:true,disableFormats:true,getEpisodeCls:this.getEpisodeCls.createDelegate(this),getTitleRow:this.getTitleRow.createDelegate(this),getDescRow:this.getDescRow.createDelegate(this),getIcon:this.getIcon.createDelegate(this),getSummary:this.getSummary.createDelegate(this)})},getEpisodeCls:function(a){if(-10===a.season){return"syno-vs-type-tv-season-main"}else{return"syno-vs-type-episode"}},getTitleRow:function(a){if(a.season===-10){return""}return["<tr>",'<td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-name" valign="top">','<div class="syno-vs-data-title">',"<span>"+this.getEpisodeTitle(a)+"</span>","</div>","</tr>"].join("")},getEpisodeTitle:function(b,a){if(b.episode===0){var c=_VST("classification","other");return a?c:"<i>"+c+"</i>"}return String.format(_VST("episode","title"),b.episode)},getDescRow:function(a){if(-10===a.season){return""}var b=this.getDesc(a,false);return["<tr>",'<td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-desc" valign="top">',"<div><span>",b,"</span></div>","</td>","</tr>"].join("")},getDesc:function(b,a){if(!b.tagline){return"&nbsp;"}return this.encodedMsg("- "+b.tagline,a)},getIcon:function(c){var a="screenshot";if(c.season===-10){a="poster"}var e=this.getImageURL(c);var d=String.format("filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",e);var b=String.format("background-image: url('{0}')",e);stylestr=String.format('style="{0};"',(Ext.isIE8||Ext.isIE7)?d:b);return'<div class="syno-vs-data-icon '+a+'" '+stylestr+"></div>"},getImageURL:function(b){var a=this._getHistoryInfo().type;var c=b.id;if(-10===b.season){a="tvshow";c=this._getHistoryInfo().params.id}return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a,id:c,mtime:b.additional?b.additional.poster_mtime||"":""})},getSummary:function(a){var b=SYNO.SDS.VideoStation.Util.getAddtionalText(a,"summary");if(-10===a.season){return b}else{return b.substr(0,this.summarylength)}},encodedMsg:function(b,a){return SYNO.SDS.VideoStation.Util.encodedMsg(b,a)}});Ext.define("SYNO.SDS.VideoStation.ViewMetaData",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewMetaData",this);SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)]);this.addManagedComponent(this.getStore());this.fieldRe=new RegExp("syno-vs-field-([^\\s]+)","")},fillConfig:function(a){var b={cls:"syno-vs-meta-panel",layout:"border",items:[{cls:"syno-vs-meta-container",xtype:"syno_panel",region:"center",itemId:"container",layout:"border",items:[this.getImageBox(),this.getMetaForm()]},this.getFileGrid()],listeners:{buffer:80,activate:function(){this.onActivate()},deactivate:this.onDeactivate}};Ext.apply(b,a);return b},getImageContainer:function(){if(this.imageInnerContainer){return this.imageInnerContainer}this.playBtn=new Ext.Container({cls:"play",border:false,overCls:"over",listeners:{scope:this,afterrender:function(){var a=this.playBtn.getEl();a.addClassOnClick("click");this.mon(a,"click",this.playVideo.createDelegate(this,[]),this)}},html:""});this.imageInnerContainer=new Ext.Container({cls:"syno-vs-meta-image",border:false,items:this.playBtn});return this.imageInnerContainer},getImageBox:function(){return new Ext.Container({cls:"image-box",border:false,region:"west",items:[this.getImageContainer(),{xtype:"container",layout:"hbox",layoutConfig:{type:"hbox",align:"stretchmax",pack:"start"},cls:"syno-vs-collect-rate-container",items:[this.getCollectionToolbar(),{flex:1,xtype:"form",cls:"syno-vs-meta-rate-form",hideMode:"visibility",border:false,height:16,width:80,items:[this.rater=new Ext.ux.form.Rater({animate:false,unit:16,cls:"syno-vs-meta-rate",hideLabel:true,name:"rating",hideMode:"visibility",height:16,maxValue:5})]}]}]})},getCollectionToolbar:function(){if(this.collection_tb){return this.collection_tb}this.collection_tb=new SYNO.ux.Toolbar({height:24,width:120,cls:"collection-action-bar",defaultType:"syno_button",defaults:{scope:this},items:[{cls:"favorite",itemId:"add_favorite",tooltip:_VST("action","add_favorite"),handler:this.onAddFavoite},{cls:"favorite remove",itemId:"remove_favorite",tooltip:_VST("action","remove_favorite"),handler:this.onRemoveFavoite,hidden:true},{cls:"watchlist",itemId:"add_watchlist",tooltip:_VST("action","add_watch_list"),handler:this.onAddWatchList},{cls:"watchlist remove",itemId:"remove_watchlist",tooltip:_VST("action","remove_watch_list"),hidden:true,handler:this.onRemoveWatchList},{cls:"userdefine",itemId:"collections",tooltip:_VST("collection","user_define_collection"),menu:this.getUserDefineMenu(),getMenuClass:Ext.emptyFn,hideMode:"visibility"}]});this.add_favorite=this.collection_tb.getComponent("add_favorite");this.remove_favorite=this.collection_tb.getComponent("remove_favorite");this.add_watchlist=this.collection_tb.getComponent("add_watchlist");this.remove_watchlist=this.collection_tb.getComponent("remove_watchlist");this.user_define_collections=this.collection_tb.getComponent("collections");return this.collection_tb},getMetaForm:function(){if(this.form){return this.form}this.form=new SYNO.ux.FormPanel({cls:"syno-vs-meta-form",border:false,region:"center",autoFlexcroll:true,labelWidth:150,layoutConfig:{labelSeparator:""},labelSeparator:"",items:[{border:false,layout:{type:"table",columns:2},items:[{cellCls:"syno-vs-meta-title",hideLabel:true,itemId:"title",xtype:"displayfield",value:"&nbsp;"}]},{itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel"),xtype:"displayfield",hidden:true},{itemId:"play_time",name:"play_time",fieldLabel:_VST("metadata","play_time"),xtype:"displayfield",hidden:true},{itemId:"record_date",name:"record_date",fieldLabel:_VST("video_info","record_time"),xtype:"displayfield",hidden:true},{itemId:"genre",name:"genre",fieldLabel:_VST("genre","title"),xtype:"displayfield"},{itemId:"season",name:"season",fieldLabel:_VST("season","season_title"),xtype:"displayfield",hidden:true},{itemId:"episode",name:"episode",fieldLabel:_VST("episode","episode_title"),xtype:"displayfield",hidden:true},{itemId:"original_available",name:"original_available",fieldLabel:_VST("original_available","title"),xtype:"displayfield"},{itemId:"duration",name:"duration",fieldLabel:_VST("duration","title"),xtype:"displayfield",hidden:true},{itemId:"actor",name:"actor",fieldLabel:_VST("actor","title"),xtype:"displayfield"},{itemId:"writer",name:"writer",fieldLabel:_VST("writer","title"),xtype:"displayfield"},{itemId:"director",name:"director",fieldLabel:_VST("director","title"),xtype:"displayfield"},this.imdb=new Ext.form.DisplayField({itemId:"imdb",name:"imdb",fieldLabel:_VST("imdb","reference"),cls:"syno-vs-data-imdb",overCls:"syno-vs-data-over"}),{itemId:"summary",name:"summary",hideLabel:true,xtype:"displayfield",cls:"syno-vs-data-summary"}]});return this.form},getFileGrid:function(){if(this.grid){return this.grid}this.grid=new SYNO.ux.GridPanel({border:false,cls:"syno-vs-grid syno-vs-file-grid",minSize:75,maxSize:200,autoExpandColumn:"path",minColumnWidth:100,height:120,region:"south",ds:this.getStore(),cm:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({single:true}),viewConfig:{scrollDelay:false,rowHeight:36,borderHeight:0,cacheSize:50,forceFit:false},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,mouseover:function(b){var a=b.getTarget("div.syno-vs-action-play",2,true);if(a){a.addClass("syno-vs-action-over")}},mouseout:function(b){var a=b.getTarget("div.syno-vs-action-play",2,true);if(a){a.removeClass("syno-vs-action-over")}},mousedown:{scope:this,buffer:100,fn:function(c){var b=c.getTarget("div.syno-vs-action-play",2,true);if(b){b.addClass("syno-vs-action-click");var j=Ext.getDoc(),a=function(){b.removeClass("syno-vs-action-click");j.removeListener("mouseup",a)};j.on("mouseup",a);var g=b.findParent("div.x-grid3-row",11);if(g&&Ext.isNumber(g.rowIndex)){var k=this.grid.getSelectionModel();if(!k.isSelected(g.rowIndex)||c.hasModifier()){k.handleMouseDown(this.grid,g.rowIndex,c)}var f=this.grid.store.getAt(g.rowIndex);if(f){this.onPlayAction(f.data)}}}}},rowcontextmenu:function(a,d,b){b.preventDefault();var c=a.getSelectionModel();if(!c.isSelected(d)){c.selectRow(d)}this.getGirdCtxMenu().showAt(b.getXY())}}});return this.grid},getUserDefineMenu:function(a){if(this.collectionMenu){this.collectionMenu.destroy()}if(!this.collectionMenu||a){this.collectionMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[],listeners:{scope:this,beforeshow:this.onUpdateCollectionMenu}});this.addManagedComponent(this.collectionMenu)}this.updateCollectionsMenuitems();return this.collectionMenu},updateCollectionsMenuitems:function(){var b=[];this.collectionMenu.removeAll(true);var a={itemId:"creat_collection_list",handler:this.launchCreatCollectionList,text:_VST("collection","new_collection"),disabled:_S("demo_mode"),scope:this};b=b.concat(a);if(2<SYNO.SDS.VideoStation.gData.collections.length){b.push({xtype:"menuseparator",itemId:"sep_newcollection"})}Ext.each(SYNO.SDS.VideoStation.gData.collections,function(e,c,d){if(e.title!=="syno_favorite"&&e.title!=="syno_watchlist"){b.push({itemId:e.id+"_add_"+e.title,handler:this.onMenuAddToUserDefCollection,text:e.title,hideOnClick:false,scope:this});b.push({itemId:e.id+"_remove_"+e.title,handler:this.onMenuRemoveFromUserDefCollection,hidden:true,text:e.title,hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:this})}},this);Ext.each(b,function(e,c,d){this.collectionMenu.addItem(e)},this)},launchCreatCollectionList:function(){var a=new SYNO.SDS.VideoStation.NewEditCollectionDialog({create:true,viewmetadataAddCollection:Ext.isDefined(this.currentAddCollection)?this.currentAddCollection:[]});a.open()},onMenuAddToUserDefCollection:function(b,c){var f,d;if(b.itemId){d=b.itemId.indexOf("_add");f=b.itemId.substring(0,d)}var a={id:f};this.onRequestCollection("addvideo",true,a,function(e,j,g){this.onRequestCollectionCallBack(e,j,g,"addvideo",a)},this)},onMenuRemoveFromUserDefCollection:function(b,c){var f,d;if(b.itemId){d=b.itemId.indexOf("_remove");f=b.itemId.substring(0,d)}var a={id:f};this.onRequestCollection("deletevideo",true,a,function(e,j,g){this.onRequestCollectionCallBack(e,j,g,"deletevideo",a)},this)},onSetCollectionMenuToDefault:function(){Ext.each(this.collectionMenu.items.items,function(a,b,c){if("creat_collection_list"!==a.itemId&&"sep_newcollection"!==a.itemId){if(0<a.itemId.indexOf("_remove_")&&0>a.itemId.indexOf("_add_")){a.hide()}else{a.show()}}},this)},onSetCollectionMenuIcon:function(b,a){var c;Ext.each(this.collectionMenu.items.items,function(f,d,e){var j,g="";j=f.itemId.indexOf("_add");if(-1!==j){g=f.itemId.substring(0,j)}if(""!==g&&parseInt(g,10)===parseInt(b,10)){if(a){f.hide()}else{f.show()}}g=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(f.itemId,"_remove");j=f.itemId.indexOf("_remove");if(-1!==j){g=f.itemId.substring(0,j)}if(""!==g&&parseInt(g,10)===parseInt(b,10)){if(a){f.show()}else{f.hide()}}},this)},onUpdateCollectionMenu:function(a){SYNO.SDS.VideoStation.Util.getCurrentCollection(this)},onShowHideCollection:function(){this.onSetCollectionMenuToDefault();if(this.currentAddCollection){Ext.each(this.currentAddCollection,function(a){this.onSetCollectionMenuIcon(a.id,true)},this)}},getGirdCtxMenu:function(){if(this.gridCtxMenu){return this.gridCtxMenu}var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");var b=[];b=b.concat(a.getMetaActionGroup().getArray());b.push(new Ext.menu.Separator({itemId:"sep_meta"}));b=b.concat(a.getPlayViewActionGroup().getArray());return(this.gridCtxMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:b,listeners:{scope:this,beforeshow:this.onUpdateMenu}}))},onUpdateMenu:function(b){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");if(_S("is_admin")){a.getMetaActionGroup().get("edit_metadata").hide();a.getMetaActionGroup().get("correct_metadata").show()}a.getPlayViewActionGroup().showAll();a.getPlayViewActionGroup().get("view_photos").hide();a.onUpdateSepItem(b)},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.JsonStore({autoLoad:false,idProperty:"id",fields:[{name:"id"},{name:"path"},{name:"sharepath",sortType:function(a){if(!a){return""}var b=SYNO.SDS.VideoStation.Util.parseFullPathToFileName(a);return b.toLowerCase()}},{name:"duration",sortType:function(a){if(!a){return 0}var b=a.split(":",3);return parseInt(b[0],10)*10000+parseInt(b[1],10)*100+parseInt(b[2],10)}},{name:"filesize",type:"int"},{name:"resolutionx"},{name:"resolutiony"},{name:"container_type"},{name:"video_codec"},{name:"audio_codec"},{name:"frame_bitrate"}],data:[],listeners:{scope:this,load:function(){if(this.grid&&!this.grid.getSelectionModel().getSelected()){this.grid.getSelectionModel().selectRow(0)}}}}))},getColumnModel:function(){if(this.colmodel){return this.colmodel}this.colmodel=new Ext.grid.ColumnModel({defaults:{align:"left"},columns:[{id:"path",header:_T("common","name"),dataIndex:"sharepath",sortable:true,renderer:(function(j,f,a,e,g,b){var d=SYNO.SDS.VideoStation.Util.parseFullPathToFileName(j);var c=Ext.util.Format.htmlEncode(d);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(j))+'"';return c}).createDelegate(this)},{header:_VST("duration","title"),dataIndex:"duration",sortable:true,width:120,renderer:(function(g,e,a,d,f,b){var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_T("common","size"),dataIndex:"filesize",sortable:true,width:120,renderer:(function(g,e,a,d,f,b){if(Ext.isEmpty(g)){return""}g=Ext.util.Format.fileSize(g);var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{xtype:"actioncolumn",header:_VST("action","start"),dataIndex:"id",align:"center",width:100,sortable:false,getClass:function(){return"play"},handler:(function(b,c,a){var d=this.grid.getSelectionModel();d.selectRow(c);this.onPlayAction(d.getSelected().data,"streaming")}).createDelegate(this)}]});return this.colmodel},onActivate:function(b){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");a.mainTbar.getComponent("sort").hide();this.onLoadData(b);this.loadPlayer()},onDeactivate:function(){if(this.ajaxTask){this.ajaxTask.remove()}this.setPlayerBtnVisibility(false);var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");a.mainTbar.getComponent("sort").show()},getAPIParams:function(a){return SYNO.SDS.VideoStation.Util.getinfo_WebAPI(a)},getArrname:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return"movies";case SYNO.SDS.VideoStation.Util._TVSHOW_ID:return"episodes";case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return"videos";case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:return"recordings";case SYNO.SDS.VideoStation.Util._COLLECTION_ID:return"collections";default:return""}},encodedMsg:function(d,b){var c="";if(Ext.isArray(d)){for(var a=0;a<d.length;a++){if(a>0){c+="</span>, "}c+='<span class="syno-vs-field-'+d[a].id+'">';c+=SYNO.SDS.VideoStation.Util.encodedMsg(d[a].name,b)}c+="</span>";return c}return SYNO.SDS.VideoStation.Util.encodedMsg(d,b)},onLoadData:function(b){this._getOwner().setStatusBusy();this.setImage();this.rater.hide();this.imdb.hide();this.form.getForm().reset();this.getStore().removeAll(true);this.form.getForm().findField("duration").hide();this.form.getForm().findField("season").hide();this.form.getForm().findField("episode").hide();if(this.playBtn){this.playBtn.hide()}this.grid.getView().updateHeaders();this.getStore().sortInfo={field:"sharepath",direction:"ASC"};this.setFieldValue("title","");this.setFieldValue("channel_name","");this.setFieldValue("original_available","");this.setFieldValue("summary","");this.setFieldValue("actor","");this.setFieldValue("writer","");this.setFieldValue("director","");this.setFieldValue("duration","");this.setFieldValue("genre","");this.setFieldValue("season","");this.setFieldValue("episode","");this.add_favorite.hide();this.add_watchlist.hide();this.remove_favorite.hide();this.remove_watchlist.hide();this.user_define_collections.hide();this.user_define_collections.removeClass("activate");var c=this._getHistoryInfo().params;var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");this.ajaxTask=this.addAjaxTask({single:true,autoJsonDecode:true,url:this.getCgiURL(),method:"POST",params:Ext.apply({id:c.id,additional:"summary,files,actor,writer,director,extra,genre,collection,poster_mtime"},this.getAPIParams(this._getCurType())),scope:this,callback:function(e,p,j){if(this.isDestroyed){return}var m=false,d;if(j&&j.success&&j.data&&!Ext.isEmpty((d=j.data[this.getArrname(this.getCurType())]))){var k=d[0];this.user_define_collections.show();if(k){var n;if(!Ext.isEmpty(k.title)&&!Ext.isEmpty(k.tagline)){n=k.title+" - "+k.tagline}else{if(!Ext.isEmpty(k.tagline)){n=k.tagline}else{n=k.title}}var g=a.getHistoryInfo();if(g.params&&g.params.name){g.params.name=k.title;if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_ID){g.params.name="<i>"+_VST("classification","other")+"</i>";if(k.episode){g.params.name=String.format(_VST("episode","title")+" - {1}",k.episode,k.title)}}a.updatePathBar()}this.setFieldValue("title",this.encodedMsg(n));this.setFieldValue("original_available",k.original_available==="0"?"":k.original_available,1);if(this.getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_ID){this.form.getForm().findField("season").show();this.form.getForm().findField("episode").show();this.setFieldValue("season",k.season===0?"":k.season,2);this.setFieldValue("episode",k.episode===0?"":k.episode,2)}this.add_favorite.show();this.add_watchlist.show()}if(k&&k.additional){this.onSetCollectionMenuToDefault();if(Ext.isArray(k.additional.collection)){this.currentAddCollection=k.additional.collection;Ext.each(k.additional.collection,function(q){if("syno_favorite"===q.title){this.add_favorite.hide();this.remove_favorite.show();return}if("syno_watchlist"===q.title){this.add_watchlist.hide();this.remove_watchlist.show();return}this.user_define_collections.addClass("activate");this.onSetCollectionMenuIcon(q.id,true)},this)}else{this.currentAddCollection=undefined}if(k.additional.files){if(k.additional.files.length>1){m=true}this.getStore().loadData(k.additional.files);this.getStore().commitChanges();if(k.additional.files.length==1){this.form.getForm().findField("duration").show();this.setFieldValue("duration",k.additional.files[0].duration);this.setPlayAction(k.additional.files)}}if(k.additional.extra){this.setRating(k.additional.extra);this.setIMDB(k.additional.extra)}var o=this.encodedMsg(k.additional.summary).split("\n").join("<br />");this.setFieldValue("summary",o);this.setFieldValue("actor",this.encodedMsg(k.additional.actor),1);this.setFieldValue("writer",this.encodedMsg(k.additional.writer),1);this.setFieldValue("director",this.encodedMsg(k.additional.director),1);this.setFieldValue("genre",this.encodedMsg(k.additional.genre),1)}if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===this.getCurType()){this.form.getForm().findField("actor").hide();this.form.getForm().findField("writer").hide();this.form.getForm().findField("director").hide();this.form.getForm().findField("genre").hide();this.form.getForm().findField("channel_name").show();this.setFieldValue("channel_name",this.encodedMsg(k.channel_name))}else{this.form.getForm().findField("actor").show();this.form.getForm().findField("writer").show();this.form.getForm().findField("director").show();this.form.getForm().findField("genre").show();this.form.getForm().findField("channel_name").hide()}switch(this.getCurType()){case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:this.form.getForm().findField("record_date").hide();this.form.getForm().findField("original_available").hide();this.form.getForm().findField("play_time").show();this.setFieldValue("play_time",this.encodedMsg(k.record_date));break;case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:this.form.getForm().findField("play_time").hide();this.form.getForm().findField("original_available").hide();this.form.getForm().findField("record_date").show();this.setFieldValue("record_date",this.encodedMsg(k.record_date));break;default:this.form.getForm().findField("record_date").hide();this.form.getForm().findField("play_time").hide();this.form.getForm().findField("original_available").show();break}}else{var l=function(){a.onGotoBack()};if(b!==false&&!(j&&j.success&&j.data&&(Ext.isEmpty(d)||Ext.isEmpty(d[0])))){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(j,_T("error","error_error_system"));this._getOwner().getMsgBox().alert(_VST("app","displayname"),f,function(){l()})}else{l.defer(100)}}this.grid.setVisible(m);this.doLayout();this._getOwner().clearStatusBusy()}}).start(true)},getCgiURL:function(){var b=SYNO.SDS.VideoStation.Util;var a=b.SEC_CFG[this.getCurType()];return this._getWebAPIURL(a.data[a.data.length-1].cgiURL)},getSelectedFile:function(){var a=this.grid.getSelectionModel();return a.getSelected()},getFiles:function(){return this.getStore().data},setFieldValue:function(g,j,a){var e=j;var f=this.form.getForm();if(Ext.isEmpty(j)){j="<span>";switch(a){case 1:j+=_VST("metadata","unknown");break;case 2:j+=_VST("classification","other");break}j+="</span>"}var d,c,b;if(g==="actor"||g==="writer"||g==="director"||g==="genre"){c=f.findField(g).el.select("span");c.each(function(k){k.removeAllListeners()},this)}f.setValues([{id:g,value:j||""}]);if(g==="actor"||g==="writer"||g==="director"||g==="genre"){c=f.findField(g).el.select("span");c.each(function(k){k.addClassOnOver("syno-vs-data-over");this.mon(k,"click",this.onGotoClasses.createDelegate(this,[this.getCurLibrary(),g,e],true))},this)}},onGotoClasses:function(f){var d=arguments[arguments.length-2];var j=arguments[arguments.length-3];var g=arguments[arguments.length-1];var c=f.getTarget("span",1,true);var b=g;if(!Ext.isDefined(b)||b===""||d==="year"&&(b==="0"||b==="")){b=_VST("metadata","unknown")}var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");a.onGotoClasses(j,{library_id:a.getCurLibraryId(),category_id:Ext.isEmpty(g)?"":this.getFieldIndex(c),category:d,name:Ext.isEmpty(g)?b:c.dom.innerHTML})},getFieldIndex:function(b){if(b){var a=b.dom.className.match(this.fieldRe),c;if(a&&(c=a[1])){return parseInt(c,10)}}return false},setRating:function(c){var j=0;if(Ext.isEmpty(c)){return}var m;try{m=Ext.decode(c)}catch(g){return}var k,d,f,a=false,l=-1;for(d in m){if(m.hasOwnProperty(d)){for(f in m[d]){if(m[d].hasOwnProperty(f)){if(-1!=f.toLowerCase().indexOf("rating")){for(k in m[d][f]){if(m[d][f].hasOwnProperty(k)){var b=m[d][f][k];if(Ext.isNumber(b)){if(l<b){l=b}a=true}}}}}}}}if(a){this.rater.disabled=false;this.rater.setValue(l/2,l);this.rater.show()}},setIMDB:function(d){var k=0;if(Ext.isEmpty(d)){return}var n;try{n=Ext.decode(d)}catch(j){return}var m,f,g,c,o;var a,l,b;for(f in n){if(n.hasOwnProperty(f)){for(g in n[f]){if(n[f].hasOwnProperty(g)){if(-1!=g.toLowerCase().indexOf("reference")){for(m in n[f][g]){if(n[f][g].hasOwnProperty(m)){if(m.toLowerCase()==="imdb"){c=n[f][g][m];if(!Ext.isEmpty(c)){c=this.getIMDBURL(c);c=String.format('<a class="allowDefCtxMenu link-font" target="_blank" href="{0}">{1}</a>',c,_VST("imdb","title"));if(f.toLowerCase()==="com.synology.synovideodb"){a=c}else{if(f.toLowerCase()==="com.synology.themoviedb"){l=c}}}}if(m.toLowerCase()==="atmovie"){c=n[f][g][m];if(!Ext.isEmpty(c)){c=this.getATMovieURL(c);b=String.format('<a class="allowDefCtxMenu link-font" target="_blank" href="{0}">{1}</a>',c,_VST("video_info","source_atmovies"))}}}}}}}}}if(!Ext.isEmpty(b)){o=b}if(!Ext.isEmpty(o)){if(!Ext.isEmpty(a)){o=o+","+a}else{if(!Ext.isEmpty(l)){o=o+","+l}}}else{if(!Ext.isEmpty(a)){o=a}else{if(!Ext.isEmpty(l)){o=l}}}if(!Ext.isEmpty(o)){this.imdb.setValue(o);this.imdb.show()}},imdblang:{enu:"com",ger:"de",spn:"es",fre:"fr",ita:"it"},getIMDBURL:function(b){var a=this.imdblang[_S("lang")];a=a?a:"com";return String.format("http://www.imdb.{0}/title/{1}",a,b)},getATMovieURL:function(a){return String.format("http://synology.atmovies.com.tw:8088/film/?sid={0}",a)},getCurLibrary:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var c=b.getHistoryInfo();var a;if(Ext.isDefined(c.params)&&Ext.isDefined(c.params.library_id)){a=c.params.library_id;return("tvshow_episode"==a)?"tvshow":a}a=b.getCurLibraryId();return a===0?this.getCurType():a},getCurType:function(){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var c=b.getHistoryInfo();var a=c.params?(c.params.type||b.getCurType()):b.getCurType();return(a==="tvshow_episode")?"tvshow":a},setImage:function(){var a=(SYNO.SDS.VideoStation.Util._MOVIE_ID===this.getCurType())?"poster":"screenshot";this.imageInnerContainer.removeClass(["poster","screenshot"]);this.imageInnerContainer.addClass(a);var b=this.getImageURL();if(Ext.isIE8||Ext.isIE7){this.imageInnerContainer.getEl().setStyle("filter",String.format("progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",b))}else{this.imageInnerContainer.getEl().setStyle("background-image",String.format("url('{0}')",b))}},getImageURL:function(){var b=this._getHistoryInfo();var a=b.params.type||this._getHistoryInfo().type;var c=b.params.id;return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a,id:c,mtime:b.params.poster_mtime||""})},playVideo:function(b){if(this.grid.isVisible()){var a=this.grid.getSelectionModel().getSelected();if(Ext.isObject(a)){this.onPlayAction(a.data,b||"streaming")}}else{if(Ext.isObject(this.current_file)){this.onPlayAction(this.current_file,b||"streaming")}}},setPlayAction:function(a){this.current_file=a[0];this.playBtn.show()},onPlayAction:function(b,a){SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),b,SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo(),a)},hasFavorite:function(){return this.add_favorite.hidden},hasWatchList:function(){return this.add_watchlist.hidden},hasUserCollection:function(){return this.collectionMenu},onAddFavoite:function(){var a={id:-1};this.onRequestCollection("addvideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onAddWatchList:function(){var a={id:-2};this.onRequestCollection("addvideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onRemoveFavoite:function(){var a={id:-1};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRemoveWatchList:function(){var a={id:-2};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRequestCollection:function(e,c,a,d,b){if(c){if(e==="deletevideo"){this.onSetCollectionMenuIcon(a.id,false)}else{if(e==="addvideo"){this.onSetCollectionMenuIcon(a.id,true)}}SYNO.SDS.VideoStation.Util.onRequestCollectionNoMesg.call(this,e,a,d,b)}else{SYNO.SDS.VideoStation.Util.onRequestCollectionNoMesg.call(this,e,a,d,b)}},onRequestCollectionCallBack:function(a,d,c,e,b){SYNO.SDS.VideoStation.Util.onRequestCollectionCallBack.apply(this,arguments)},onSetShowHideCollection:function(a,e,d,f,b){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();switch(f){case"addvideo":if(-1===b.id){this.add_favorite.hide();this.remove_favorite.show()}else{if(-2===b.id){this.add_watchlist.hide();this.remove_watchlist.show()}else{c.onActivate()}}break;case"deletevideo":if(-1===b.id){this.add_favorite.show();this.remove_favorite.hide()}else{if(-2===b.id){this.add_watchlist.show();this.remove_watchlist.hide()}else{c.onActivate()}}break;default:c.onActivate();break}},setPlayerBtnVisibility:function(a){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");var c=b.getPlayerButton();c.setVisible(a);b.toolbar.syncSize()},onPlayerLoad:function(){var b=[];this.player_store.each(function(c){b.push(c.data)},this);if(b.length>0){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").getPlayerButton().menu;a.setPlayerList(b);this.setPlayerBtnVisibility(SYNO.SDS.VideoStation.Util.ableToControlRenderer())}},loadPlayer:function(){if(!this.player_store){this.player_store=new SYNO.VideoController2.PlayerStore({appWindow:SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main")})}this.player_store.load({scope:this,callback:this.onPlayerLoad})}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.ViewList=Ext.extend(Ext.Panel,{constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewList",this);var b=this.fillConfig(a);SYNO.SDS.VideoStation.ViewList.superclass.constructor.call(this,b)},fillConfig:function(a){this.dataView=new SYNO.SDS.VideoStation.ViewListDataView({moudle:this});this.paging=new SYNO.SDS.VideoStation.PagingToolbar({displayInfo:true,store:this.dataView.getStore(),pageSize:SYNO.SDS.VideoStation.Config.pageSize});var b={boxMinHeight:1,boxMinWidth:1,border:false,layout:"fit",style:"margin-top:2px;",bodyStyle:"overflow: visible;",items:[this.dataView],bbar:this.paging,listeners:{activate:this.onActivate,deactivate:this.onDeactivate}};Ext.apply(b,a);return b},onActivate:function(){this.dataView.onActivate()},onDeactivate:function(){this.dataView.onDeactivate()}});SYNO.SDS.VideoStation.ViewListBasicDataView=Ext.extend(SYNO.SDS.Utils.DataView.LazyDataView,{itemSelector:"div.syno-vs-data-template",overClass:"syno-vs-data-item-over",constructor:function(a){this.init();var b=this.fillConfig(a);SYNO.SDS.VideoStation.ViewListBasicDataView.superclass.constructor.call(this,b)},init:function(){SYNO.SDS.VideoStation.Util._initWinWrappers.apply(this,arguments)},fillConfig:Ext.emptyFn,getTpl:Ext.emptyFn,onLoadStore:Ext.emptyFn,getStore:Ext.emptyFn,onDeactivate:Ext.emptyFn,onActivate:function(){this.onLoadStore(0)},encodedMsg:function(b,a){return SYNO.SDS.VideoStation.Util.encodedMsg(b,a)}});SYNO.SDS.VideoStation.ViewListDataView=Ext.extend(SYNO.SDS.VideoStation.ViewListBasicDataView,{paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},poster_summarylength:270,screen_summarylength:200,init:function(){SYNO.SDS.VideoStation.ViewListDataView.superclass.init.apply(this,arguments);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewListDavaview",this);this.loader=new SYNO.SDS.VideoStation.ImageLoadManager()},fillConfig:function(a){var b={itemSelector:this.itemSelector,overClass:this.overClass,tpl:this.getTpl(),itemId:"dataview",singleSelect:true,store:this.getStore(),listeners:{buffer:80,scope:this,click:function(c,d,j,k){var g=k.getTarget();if(!g){return false}var f=Ext.get(g);if(f.is("div.syno-vs-data-icon")){var l=c.getStore().getAt(d);if(!l){return false}this.onGotoNext(l)}},dblclick:function(d,e,f,c){var g=d.getStore().getAt(e);if(!g){return false}this.onGotoNext(g)},activate:this.onActivate,deactivate:this.onDeactivate,selectionchange:function(){Ext.apply(this._getHistoryInfo().status,{selected_id:this.getSelectedRecords()[0]?this.getSelectedRecords()[0].get("id"):undefined})}}};Ext.apply(b,a);return b},refresh:function(){SYNO.SDS.VideoStation.ViewListDataView.superclass.refresh.apply(this,arguments);this.loader.clear();this.preloadItems()},getImageItems:function(a,b){Ext.each(a,function(f,c,e){var d=Ext.fly(f).select(".syno-vs-data-icon");if(0<d.elements.length&&d.item(0).hasClass("loading")){b(d.item(0))}})},preloadItems:function(){var a=this.getNodes();this.getImageItems(a,this.loader.appendJob.createDelegate(this.loader))},onGotoNext:function(f){var g,d,b,c,a;g=f.get("id");a=f.get("additional");if(this.checkIsByfolder()&&"file"===f.get("type")&&a&&a.metadata){g=a.metadata.id}d=(this.checkIsByfolder()&&a)?a.original_available:f.get("original_available");if(this.checkIsByfolder()&&a&&a.summary){b=a.summary}else{b=(f.get("additional")?(f.get("additional").summary||""):"")}if(this.checkIsByfolder()&&a&&a.poster_mtime){c=a.poster_mtime}else{c=(f.get("additional")?(f.get("additional").poster_mtime||""):"")}var e={id:g,name:f.get("title"),original_available:d,summary:b,poster_mtime:c};if(this.checkIsByfolder()){Ext.apply(e,{category:"folder",dirtype:f.get("type")})}if(this._getHistoryInfo().type===SYNO.SDS.VideoStation.Util._TVSHOW_ID&&this._getHistoryInfo().params&&this._getHistoryInfo().params.category){e.category=this._getHistoryInfo().params.category;e.category_id=this._getHistoryInfo().params.category_id}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoNext(e)},onActivate:function(){var c=this._getHistoryInfo();var a=c.status||{};var d=c.params;var b=d?d.category:undefined;if(c.subtype!==a.subtype||b!==a.category){c.status=a={}}if(this.getEl().isMasked()){this.getEl().unmask()}this.onLoadStore({offset:a.offset||0,limit:a.limit,sort_by:a.sort_by,sort_direction:a.sort_direction})},onDeactivate:function(){},getRoot:function(){if(this.Roots&&this.Roots[this.getCurType()]){return this.Roots[this.getCurType()]}},getReader:function(){if(this.Readers&&this.Readers[this.getCurType()]){return this.Readers[this.getCurType()]}},getStore:function(){if(this.stores&&this.stores[this.getCurType()]){if(this.store!==this.stores[this.getCurType()]){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewList").paging.bindStore(this.stores[this.getCurType()]);this.bindStore(this.stores[this.getCurType()])}return this.stores[this.getCurType()]}this.stores={};this.Proxies={};this.Readers={};this.Roots={};this.WebAPIUrls={};this.WebAPI={};this.createStores();return(this.stores[this.getCurType()])},checkIsByfolder:function(){return SYNO.SDS.VideoStation.Util._checkIsByfolder()},changeReaderRoot:function(a){this.getReader().meta.root=a;delete this.getStore().reader.ef;this.getReader().buildExtractors()},changeWebAPIandProxyToFolder:function(){if(this.stores[this.getCurType()].proxy.url!==this._getWebAPIURL("folder.cgi")){this.stores[this.getCurType()].baseParams.api="SYNO.VideoStation.Folder";this.stores[this.getCurType()].proxy.setApi(Ext.data.Api.actions.read,this._getWebAPIURL("folder.cgi"))}},chageWebAPIandProxyToDef:function(){this.stores[this.getCurType()].baseParams.api=this.WebAPI[this.getCurType()];this.stores[this.getCurType()].proxy.setApi(Ext.data.Api.actions.read,this.WebAPIUrls[this.getCurType()])},onBeforeLoadStore:function(a,c){this.getEl().mask(_T("common","loading"),"x-mask-loading");var j=c.params;var f=this._getOwner().appInstance.getUserSettings(this._getCurType()+"sortstate");var e=(this._getHistoryInfo().subtype==="search");if(!this.blFirstType){this.blFirstType={}}if(!j.sort_by&&!j.sort_direction){var b=!this.blFirstType[this._getCurType()];if(b&&f&&f.sort_by&&f.sort_direction){j.sort_by=f.sort_by;j.sort_direction=f.sort_direction}else{j.sort_by=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main").getParamSortBy(b);j.sort_direction=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main").getParamSortOrder(b)}}if(!this.blFirstType[this._getCurType()]){this.blFirstType[this._getCurType()]=true}Ext.apply(j,{offset:Ext.isDefined(j.offset)?j.offset:SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewList").paging.cursor,limit:Ext.isDefined(j.limit)?j.limit:SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewList").paging.pageSize,additional:"poster_mtime,summary"+((this._getCurType()===SYNO.SDS.VideoStation.Util._TVSHOW_ID)?"":",collection"),library_id:this._getCurLibraryId()});if(j.sort_by&&j.sort_direction){this._getOwner().appInstance.setUserSettings(this._getCurType()+"sortstate",{sort_by:j.sort_by,sort_direction:j.sort_direction})}Ext.apply(this._getHistoryInfo().status,{offset:j.offset,limit:j.limit,sort_by:j.sort_by,sort_direction:j.sort_direction,subtype:this._getHistoryInfo().subtype,category:this._getHistoryInfo().params?this._getHistoryInfo().params.category:undefined});if(e){var g=this._getHistoryInfo().searchval;if(this.getReader()&&"data.objects"===this.getReader().meta.root){this.chageWebAPIandProxyToDef();this.changeReaderRoot(this.getRoot())}if(this._getCurId()===SYNO.SDS.VideoStation.Util._TV_RECORDER_ID){Ext.apply(j,{method:"search",keywords:Ext.encode({title:g,channel_name:g})})}else{if(this._getCurId()===SYNO.SDS.VideoStation.Util._TVSHOW_ID){Ext.apply(j,{method:"search",keywords:Ext.encode({title:g,actor:g,director:g,writer:g,episode_title:g,gnere:g})})}else{Ext.apply(j,{method:"search",keywords:Ext.encode({title:g,actor:g,director:g,writer:g,gnere:g})})}}}else{if(this.checkIsByfolder()){if(this.getReader()&&"data.objects"!==this.getReader().meta.root){this.changeWebAPIandProxyToFolder();this.changeReaderRoot("data.objects")}j.sort_by="filename";Ext.apply(j,{method:"list",id:(this._getHistoryInfo().params&&this._getHistoryInfo().params.id)?this._getHistoryInfo().params.id:"",type:this.getCurType()})}else{if(this.getReader()&&"data.objects"===this.getReader().meta.root){this.chageWebAPIandProxyToDef();this.changeReaderRoot(this.getRoot())}if(this._getHistoryInfo().params&&"recently_watched"===this._getHistoryInfo().params.category){Ext.apply(j,{sort_by:"last_watched",sort_direction:"desc"})}Ext.apply(j,{method:"list"})}delete j.title;delete j.tagline}var d=undefined;if(this._getHistoryInfo().params&&"all"!==this._getHistoryInfo().params.category){d=this._getHistoryInfo().params.category;j[d]=this._getHistoryInfo().params.category_id}},onAfterLoadStore:function(d,c,e){this.moudle.doLayout();this.getEl().unmask();if(!this.getSelectionCount()){var b=this._getHistoryInfo().status;var f=b.selected_id,j;if(f&&(j=this.getStore().getById(f))){var g=this.getNode(j);this.select(g);SYNO.SDS.VideoStation.Util.gotoScroll(this.el,g)}else{this.select(0)}}if(d&&0===d.getCount()){var a=this.getEl().mask(_VST("common","no_video_item"),"syno-ux-mask-info")}else{if(this.getEl().isMasked()){this.getEl().unmask()}}},onExceptionLoadStore:function(){if(this._getOwner().modalWin.length<=0){this._getOwner().clearStatusBusy()}},onLoadStore:function(a){this.getStore().load({params:Ext.apply({offset:(a?(a.start||0):0)},a||{})})},createProxies:function(){var b=SYNO.SDS.VideoStation.Util;var a=(function(){for(var d in this.Proxies){if(this.Proxies.hasOwnProperty(d)){var c=this.Proxies[d];var e=c.activeRequest.read;if(e){Ext.Ajax.abort(e)}}}}).createDelegate(this);this.WebAPIUrls[b._MOVIE_ID]=this._getWebAPIURL("movie.cgi");this.Proxies[b._MOVIE_ID]=new Ext.data.HttpProxy({url:this.WebAPIUrls[b._MOVIE_ID],listeners:{beforeload:a}});this.WebAPIUrls[b._TVSHOW_ID]=this._getWebAPIURL("tvshow.cgi");this.Proxies[b._TVSHOW_ID]=new Ext.data.HttpProxy({url:this.WebAPIUrls[b._TVSHOW_ID],listeners:{beforeload:a}});this.WebAPIUrls[b._HOME_VIDEO_ID]=this._getWebAPIURL("homevideo.cgi");this.Proxies[b._HOME_VIDEO_ID]=new Ext.data.HttpProxy({url:this.WebAPIUrls[b._HOME_VIDEO_ID],listeners:{beforeload:a}});this.Proxies[b._TV_RECORDER_ID]=new Ext.data.HttpProxy({url:this._getWebAPIURL("tvrecord.cgi"),listeners:{beforeload:a}});this.Proxies[b._COLLECTION_ID]=new Ext.data.HttpProxy({url:this._getWebAPIURL("collection.cgi"),listeners:{beforeload:a}})},createStores:function(){var b=SYNO.SDS.VideoStation.Util;this.createProxies();this.Roots[b._MOVIE_ID]="data.movies";this.Readers[b._MOVIE_ID]=new Ext.data.JsonReader({id:"id",root:this.Roots[b._MOVIE_ID],totalProperty:"data.total",fields:["id","title","original_available","metadata_locked","additional","type","path","sharepath","file_count"]});this.WebAPI[b._MOVIE_ID]="SYNO.VideoStation.Movie";this.stores[b._MOVIE_ID]=new Ext.data.Store({proxy:this.Proxies[b._MOVIE_ID],method:"POST",baseParams:{api:this.WebAPI[b._MOVIE_ID],version:"1"},paramNames:this.paramNames,reader:this.Readers[b._MOVIE_ID],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.Roots[b._TVSHOW_ID]="data.tvshows";this.Readers[b._TVSHOW_ID]=new Ext.data.JsonReader({root:this.Roots[b._TVSHOW_ID],totalProperty:"data.total",id:"id",fields:["id","title","original_available","metadata_locked","additional","type","path","sharepath","file_count"]});this.WebAPI[b._TVSHOW_ID]="SYNO.VideoStation.TVShow";this.stores[b._TVSHOW_ID]=new Ext.data.Store({proxy:this.Proxies[b._TVSHOW_ID],baseParams:{api:this.WebAPI[b._TVSHOW_ID],version:"1"},paramNames:this.paramNames,reader:this.Readers[b._TVSHOW_ID],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.Roots[b._HOME_VIDEO_ID]="data.videos";this.Readers[b._HOME_VIDEO_ID]=new Ext.data.JsonReader({id:"id",root:this.Roots[b._HOME_VIDEO_ID],totalProperty:"data.total",fields:["id","title","record_date","additional","type","path","sharepath","file_count"]});this.WebAPI[b._HOME_VIDEO_ID]="SYNO.VideoStation.HomeVideo";this.stores[b._HOME_VIDEO_ID]=new Ext.data.Store({proxy:this.Proxies[b._HOME_VIDEO_ID],method:"POST",baseParams:{api:this.WebAPI[b._HOME_VIDEO_ID],version:"1"},paramNames:this.paramNames,reader:this.Readers[b._HOME_VIDEO_ID],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.stores[b._TV_RECORDER_ID]=new Ext.data.Store({proxy:this.Proxies[b._TV_RECORDER_ID],baseParams:{api:"SYNO.VideoStation.TVRecording",version:"1"},paramNames:this.paramNames,reader:new Ext.data.JsonReader({root:"data.recordings",totalProperty:"data.total",id:"id",fields:["id","title","channel_name","record_date","additional"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});this.stores[b._COLLECTION_ID]=new Ext.data.Store({proxy:this.Proxies[b._COLLECTION_ID],method:"POST",baseParams:{api:"SYNO.VideoStation.Collection",version:"1"},paramNames:this.paramNames,reader:new Ext.data.JsonReader({id:"id",root:"data.collections",totalProperty:"data.total",fields:["id","title","additional"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}});for(var a in this.stores){this.addManagedComponent(this.stores[a])}},getCurType:function(){return this._getCurLibraryType()},isTVShowFolderMode:function(b,c){var a=false;if(this.getCurType()===b&&!c&&this.checkIsByfolder()){a=true}return a},getIcon:function(d){var e=SYNO.SDS.VideoStation.Util;var c=this.getCurType();var a=(Ext.isDefined(d.type)&&"folder"===d.type);if(a){cls="folder"}else{if(c===e._MOVIE_ID||(c===e._TVSHOW_ID&&!this.checkIsByfolder())){cls="poster"}else{cls="screenshot"}}var b=this.checkIsByfolder()&&d.type==="folder";var f=b?"":this.getImageURL(d);return String.format('<div class="syno-vs-data-icon {0} {1}" url="{2}"></div>',cls,(b?"":"loading"),Ext.util.Format.htmlEncode(f))},onLoadItem:function(a){this.getImageItems([a],this.loader.insertJob.createDelegate(this.loader))},getImageURL:function(b){var a=this._getHistoryInfo().type;var c;if(this.checkIsByfolder()&&b.additional&&b.additional.metadata){c=b.additional.metadata.id}else{c=b.id}return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a,id:c,mtime:b.additional?b.additional.poster_mtime||"":""})},getDesc:function(c,b){var e,a="<span>";if(this.checkIsByfolder()&&c.type&&"file"===c.type){var d=SYNO.SDS.VideoStation.Util;e=(c.additional&&c.additional.metadata&&c.additional.metadata.title)?c.additional.metadata.title:"";if(d._TVSHOW_ID===this.getCurType()&&c.additional&&c.additional.metadata&&c.additional.metadata.tagline){e=e+" - "+c.additional.metadata.tagline}else{if(d._MOVIE_ID==this.getCurType()){a='<span style="padding-left:2px;">'}}}else{e=c.record_date||c.original_available}if(!e||e==="0"){a=a+"&nbsp;"}else{a=a+this.encodedMsg(e,b)}a=a+"</span>";return a},getTitle:function(a){if(!a.title||(this.checkIsByfolder()&&a.type!=="file")){return""}return['<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-name">',"<div>",'<span ext:qtip="'+this.encodedMsg(this.encodedMsg(a.title))+'">',this.encodedMsg(a.title),"</span>","</div>","</td></tr>"].join("")},getDirName:function(b){if(this.checkIsByfolder()&&Ext.isDefined(b.type)&&"folder"===b.type&&b.title){var a=['<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-dir">',"<div>",'<span ext:qtip="'+this.encodedMsg(this.encodedMsg(b.title))+'">',this.encodedMsg(b.title),"</span>","</div>","</td></tr>"];return a.join("")}return this.encodedMsg("",true)},getFilesNumber:function(c){if(c.type&&"folder"===c.type&&c.file_count){var b=String.format(_VST("file","dir_files"),c.file_count);var a='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-number">';a=a+"<div><span>";a=a+b+"</span></div></td></tr>";return a}return this.encodedMsg("",true)},getChannelName:function(c){if(c.channel_name){var b=this.encodedMsg(c.channel_name,true);var a='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-channel">';a=a+"<div><span>";a=a+b+"</span></div></td></tr>";return a}return this.encodedMsg("",true)},getSummary:function(a){return SYNO.SDS.VideoStation.Util.getAddtionalText(a,"summary").substr(0,this.poster_summarylength)},getDataType:function(b){var a=this.getCurType();if(this.checkIsByfolder()&&b.type==="folder"){return"dir"}else{if(this.checkIsByfolder()&&a==="tvshow"){return"episode"}else{return this.getCurType()}}},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="syno-vs-data-template syno-vs-type-{[this.getDataType(values)]}" style="cursor: default">','<div class="data-container">','<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout syno-vs-data-template-table"><tbody>',"<tr>",'<td class="x-table-layout-cell">',"{[this.getIcon(values)]}","</td>",'<td class="x-table-layout-cell syno-vs-data-text {[this.getDataType(values)]}">','<table cellspacing="0" cellpadding="0" border="0" class="x-table-layout"><tbody>',"{[this.getTitle(values)]}","{[this.getDirName(values)]}","{[this.getFilesNumber(values)]}","{[this.getChannelName(values)]}",'<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-desc" valign="top">',"<div>","{[this.getDesc(values, false)]}</div>","</td></tr>",'<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-summary" valign="top" rowspan="4">',"<div><span>{[this.getSummary(values)]}</span></div>","</td></tr>","</tbody></table>","</td>","</tr>","</tbody></table>","</div></div></tpl>",'<div class="x-clear"></div>',{compiled:true,disableFormats:true,getDataType:this.getDataType.createDelegate(this),getTitle:this.getTitle.createDelegate(this),getDirName:this.getDirName.createDelegate(this),getFilesNumber:this.getFilesNumber.createDelegate(this),getChannelName:this.getChannelName.createDelegate(this),getDesc:this.getDesc.createDelegate(this),getIcon:this.getIcon.createDelegate(this),getSummary:this.getSummary.createDelegate(this)})}});Ext.define("SYNO.SDS.VideoStation.ViewGrid",{extend:"SYNO.ux.GridPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewGrid",this);this.callParent([this.fillConfig(a)]);this.addManagedComponent(this.getStore())},fillConfig:function(a){var b=Ext.apply({enableHdMenu:false,cls:"syno-vs-grid syno-vs-classification-grid",itemId:"grid",border:false,store:this.getStore(),columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),viewConfig:{scrollDelay:false,rowHeight:36,borderHeight:0,cacheSize:50},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{activate:this.onActivate,deactivate:this.onDeactivate,dblclick:this.dbClick,rowclick:this.rowClick}},a);return b},getColumnModel:function(){if(this.colModel){return this.colModel}this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_VST("classification","title"),dataIndex:"name",sortable:true,width:150,align:"left",renderer:(function(g,e,a,d,f,b){var c;if(!Ext.isDefined(g)||g===""||(this._getHistoryInfo().params&&this._getHistoryInfo().params.category==="year"&&(g==="0"||g===""))){g=_VST("metadata","unknown");c="<i>"+g+"</i>"}else{c=Ext.util.Format.htmlEncode(g)}if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===this._getHistoryInfo().type){e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"'}else{e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"style="cursor: pointer"'}return c}).createDelegate(this)}]});return this.colModel},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.Store({method:"POST",remoteSort:false,proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("movie.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),baseParams:{api:"SYNO.VideoStation.Metadata",method:"list",version:"1"},sortInfo:{field:"name",direction:"ASC"},reader:new Ext.data.JsonReader({id:"id",root:"data.metadatas",totalProperty:"data.total",fields:["id","index","name"]}),listeners:{scope:this,beforeload:function(){this._getOwner().setStatusBusy()},load:function(){this._getOwner().clearStatusBusy()},exception:function(){this._getOwner().clearStatusBusy()}},createSortFunction:(function(d,c){c=c||"ASC";var b=c.toUpperCase()=="DESC"?-1:1;var e=this.store.fields.get(d).sortType;var a=(this._getHistoryInfo().params&&this._getHistoryInfo().params.category==="year");return function(g,f){var k=e(g.data[d]),j=e(f.data[d]);if(Ext.isNumber(k)){return b*(k>j?1:(k<j?-1:0))}if(k===""){return b===1?1:-1}if(j===""){return b===1?-1:1}if(a){if(k==="0"){return b===1?1:-1}if(j==="0"){return b===1?-1:1}}return b*(k.toUpperCase()>j.toUpperCase()?1:(k.toUpperCase()<j.toUpperCase()?-1:0))}}).createDelegate(this)}))},dbClick:function(a,d,c){var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();if(b.id===SYNO.SDS.VideoStation.Util._COLLECTION_ID&&0===b.index){this.rowanddbClick(a,d,c)}},rowClick:function(a,l,k){var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");if(d.id!==SYNO.SDS.VideoStation.Util._COLLECTION_ID||0!==d.index){var f=this.getSelectionModel().getSelected();if(f){var j=false,b=f.get("id");Ext.each(c.searchMenu.items.items,function(o,e,n){if(b===o.categoryValue){SYNO.SDS.VideoStation.Util.SEARCH_HISTORY[this._getCurId()]=b;j=true}},this);if(!j){SYNO.SDS.VideoStation.Util.SEARCH_HISTORY[this._getCurId()]="all"}}this.rowanddbClick(a,l,k)}else{if(d.id===SYNO.SDS.VideoStation.Util._COLLECTION_ID&&0===d.index){var m=c.actionMenu.items.items;for(var g=0;g<m.length;g++){if("edit_collection"===m[g].itemId||"delete_collection"===m[g].itemId){m[g].setDisabled(l<2)}}}}},rowanddbClick:function(a,l,k){var f=this.getSelectionModel();var g=f.getSelected();if(!g){return}var d,c;var j=undefined;if(0===SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo().index){d=g.get("id");if(d==="folder"){j=6}else{if(d==="all"||d==="recently_added"||d==="recently_watched"){j=2}}if(d==="recently_watched"){c=1}if(d==="recently_added"){c=SYNO.SDS.VideoStation.Config.recentadd}}else{d=this._getHistoryInfo().params.category;c=g.get("id")}var b=g.get("name");if(!Ext.isDefined(b)||b===""||(this._getHistoryInfo().params&&this._getHistoryInfo().params.category==="year"&&(b==="0"||b===""))){b=_VST("metadata","unknown")}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoNext({category_id:c,category:d,name:b},j)},onActivate:function(){this._getOwner().setStatusBusy();var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");if("SYNO.SDS.VideoStation.ViewGrid"!==b.getHistoryInfo().layoutCfg){return}var a=false;var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();if(c.id===SYNO.SDS.VideoStation.Util._COLLECTION_ID){this.getStore().sortInfo.field="index";this.getStore().sortInfo.direction="ASC";this.onLoadCollection()}else{if(0===c.index){this.getStore().sortInfo.field="index";this.getStore().sortInfo.direction="ASC";this.onLoadClassification()}else{a=true;this.getStore().sortInfo.field="name";this.onLoadData(0)}}this.setSortColumnModel(a)},onDeactivate:function(){if(this.ajaxTask){this.ajaxTask.remove()}},setSortColumnModel:function(c){var a=this.getColumnModel();var b=a.columns;var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();if(d.id===SYNO.SDS.VideoStation.Util._COLLECTION_ID){b[0].header=_VST("collection","title")}else{if(d.webAPIID==="SYNO.VideoStation.Metadata"){b[0].header=SYNO.SDS.VideoStation.Util.getCategoryString(d.params.category)}else{b[0].header=_VST("classification","title")}}Ext.each(b,function(e){e.sortable=c});a.setConfig(b,false)},onLoadClassification:function(){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var b;if(c.id===SYNO.SDS.VideoStation.Util._TV_RECORDER_ID){b=[{id:"all",name:_VST("classification","all"),index:0},{id:"date",name:_VST("classification","bydate"),index:1},{id:"channelname",name:_VST("classification","bychannlename"),index:2},{id:"title",name:_VST("classification","bytitle"),index:3},{id:"recently_watched",name:_VST("classification","recently_watched"),index:4}]}else{b=[{id:"all",name:_VST("classification","all"),index:0},{id:"actor",name:_VST("classification","actor"),index:1},{id:"director",name:_VST("classification","director"),index:2},{id:"genre",name:_VST("classification","genre"),index:3},{id:"folder",name:_VST("classification","folder"),index:4},{id:"writer",name:_VST("classification","writer"),index:5},{id:"year",name:_VST("classification","year"),index:6},{id:"recently_added",name:_VST("classification","recently_added"),index:7},{id:"recently_watched",name:_VST("classification","recently_watched"),index:8}]}var a={data:{metadatas:b,total:7}};this.getStore().removeAll(true);this.getStore().loadData(a)},onLoadCollection:function(){this._getOwner().setStatusBusy();this.getStore().removeAll(true);var a=this.getStore().getSortState();SYNO.API.currentManager.requestAPI("SYNO.VideoStation.Collection","list","1",{offset:0,limit:-1,sort_by:"title",sort_direction:a?a.direction:"ASC"},this.onLoadCollectionDone,this)},onLoadCollectionDone:function(a,g,e){var d=[],b=0;if(a&&g.collections){Ext.each(g.collections,function(l,j,k){if(-1===l.id){d.push({id:l.id,name:_VST("collection","favorite"),index:0})}else{if(-2===l.id){d.push({id:l.id,name:_VST("collection","watchlist"),index:1})}else{d.push({id:l.id,name:l.title,index:j})}}j++},this);var c={data:{metadatas:d,total:g.total}};this.getStore().loadData(c);this.getStore().commitChanges();this.updateActionMenu(d.length)}else{var f=SYNO.SDS.VideoStation.Util.getWebAPIErr(a,g,e);this._getOwner().getMsgBox().alert(_VST("app","displayname"),f);SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoBack()}this._getOwner().clearStatusBusy()},updateActionMenu:function(c){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");if(c>2){this.getSelectionModel().selectRow(2)}var d=a.actionMenu.items.items;for(var b=0;b<d.length;b++){if(c>2&&("edit_collection"===d[b].itemId||"delete_collection"===d[b].itemId)){d[b].show();d[b].setDisabled(false)}else{d[b].hide()}}},onLoadData:function(e){this._getOwner().setStatusBusy();this.getStore().removeAll(true);var b=this.getStore().getSortState();var c=this._getHistoryInfo();var a=(c.type==="tvshow")?"tvshow_episode":c.type;var d=c.params;this.ajaxTask=this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getWebAPIURL(c.cgiURL),method:"POST",params:{api:"SYNO.VideoStation.Metadata",method:"list",version:"1",type:a,library_id:this._getCurLibraryId(),category:d.category,sort_by:d.category,sort_direction:b?b.direction:"ASC",filter:d.filter},scope:this,callback:function(f,k,g){if(g&&g.success){this.getStore().loadData(g);this.getStore().commitChanges()}else{var j=SYNO.SDS.VideoStation.Util.getErrinfoString(g,_T("common","commfail"));this._getOwner().getMsgBox().alert(_VST("app","displayname"),j);SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoBack()}this._getOwner().clearStatusBusy()}}).start()}});Ext.define("SYNO.SDS.VideoStation.ViewCollection",{extend:"SYNO.ux.GridPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.ViewCollection",this);this.callParent([this.fillConfig(a)]);this.addManagedComponent(this.getStore())},fillConfig:function(a){this.paging=new SYNO.SDS.VideoStation.PagingToolbar({store:this.getStore(),pageSize:200,displayInfo:true});var b=Ext.apply({cls:"syno-vs-grid syno-vs-grid-collection",itemId:"grid_collection",border:false,store:this.getStore(),enableColumnMove:false,minColumnWidth:100,autoExpandColumn:"title",columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({single:true}),bbar:this.paging,viewConfig:{scrollDelay:false,rowHeight:88,borderHeight:0,cacheSize:50,forceFit:false,rowSelectorDepth:12},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{activate:this.onActivate,deactivate:this.onDeactivate,rowdblclick:function(d,k,f){var j=this.getSelectionModel();var g=j.getSelected();if(!g){return}var c=g.get("library_id");SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").onGotoNext({id:g.get("id"),type:g.get("type"),name:g.get("title"),library_id:c===0?g.get("type"):c})},columnresize:function(){if(Math.abs(this.columnModelwidth-this.getColumnModel().getColumnWidth(1))>10){var c=this.getView();c.refresh()}},resize:function(){if(Math.abs(this.columnModelwidth-this.getColumnModel().getColumnWidth(1))>10){var c=this.getView();c.refresh()}}}});return b},getColumnModel:function(){if(this.colModel){return this.colModel}this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_VST("type","tile"),dataIndex:"type",sortable:true,width:90,renderer:(function(f,d,a,c,e,b){switch(a.data.type){case"movie":f=_VST("type","movie");break;case"tvshow":case"tvshow_episode":f=_VST("type","tv_show");break;case"home_video":f=_VST("type","home_video");break;case"tv_record":f=_VST("type","tv_recorder");break;default:break}d.attr='ext:qtip="'+f+'"';return this.getIcon(a.data)}).createDelegate(this)},{header:_VST("common","title"),id:"title",align:"left",dataIndex:"title",sortable:true,autoExpand:true,renderer:(function(g,e,a,d,f,b){var c=new Ext.Template('<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" class="x-table-layout"><tbody><tr><td height="18" class="x-table-layout-cell syno-vs-data-cell syno-vs-data-name" valign="top"><div><span>{title}</span></div></td></tr>{tvshowinfo}{summary}</tbody></table>');c.compile();return c.apply({title:this.encodedMsg(a.data.title),summary:this.getSummary(a.data),tvshowinfo:this.getTVShowInfo(a.data)})}).createDelegate(this)},{id:"time",header:_VST("time","title"),dataIndex:"time",sortable:true,width:100,renderer:(function(g,e,a,d,f,b){g=a.get("time");switch(a.data.type){case"movie":case"tvshow":case"tvshow_episode":g=g.split(" ",2)[0];break;default:break}if(g==="0"){return""}var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)}]});return this.colModel},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.Store({paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},remoteSort:true,sortInfo:{field:"title",direction:"ASC"},method:"POST",proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("collection.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),method:"POST",baseParams:{api:"SYNO.VideoStation.Collection",version:"1"},reader:new Ext.data.JsonReader({id:"mapper_id",root:"data.videos",totalProperty:"data.total",fields:["mapper_id","id","title","type","time","metadata_locked","additional","season","episode","tag_line","library_id"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:this.onExceptionLoadStore}}))},getCollectionId:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var b;if(this._getHistoryInfo().subtype==="search"){b=a.getHistoryInfo(a.getCurId(),1);if(b&&b.params){return b.params.category}}b=this._getHistoryInfo();return(b.params)?(b.params.category||b.collection_id):b.collection_id},onBeforeLoadStore:function(a,b){this._getOwner().setStatusBusy();var f=b.params;var g=this.getCollectionId();Ext.apply(f,{offset:Ext.isDefined(f.offset)?f.offset:this.paging.cursor,limit:this.paging.pageSize,additional:"summary,poster_mtime",id:g});if(this._getHistoryInfo().subtype==="search"){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.SearchField").getValue();Ext.apply(f,{method:"search",keywords:Ext.encode({title:e,actor:e,director:e,writer:e})});var d=c.getHistoryInfo(c.getCurId(),1);if(d&&d.params){Ext.apply(f,{id:d.params.category})}}else{Ext.apply(f,{method:"video_list"})}},onAfterLoadStore:function(){this._getOwner().clearStatusBusy();if(!this.getSelectionModel().getSelected()){this.getSelectionModel().selectRow(0)}},onGetSelectedData:function(){return this.getSelectionModel().getSelections()},onExceptionLoadStore:function(){this._getOwner().clearStatusBusy()},onActivate:function(){this.getStore().load()},onDeactivate:function(){},encodedMsg:function(b,a){return SYNO.SDS.VideoStation.Util.encodedMsg(b,a)},getSummary:function(c){var b="";if(c.type&&"tvshow_episode"!==c.type){var a=SYNO.SDS.VideoStation.Util.getAddtionalText(c,"summary");b='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-summary" valign="top" rowspan="4"><div><span>'+a+"</span></div></td></tr>"}return b},getTVShowInfo:function(b){var a="";if(b.type&&"tvshow_episode"===b.type){if(b.season){a=String.format(_VST("season","title"),b.season)}if(""!==a&&b.episode){a=a+", "+String.format(_VST("episode","title"),b.episode)}else{if(b.episode){a=String.format(_VST("episode","title"),b.episode)}}if(""!==a&&b.tag_line){a=a+" - "+b.tag_line}else{if(b.tag_line){a=b.tag_line}}var c=a;a='<tr><td class="x-table-layout-cell syno-vs-data-cell syno-vs-data-collection-tvshowinfo" valign="top" rowspan="4"><div><span>'+c+"</span></div></td></tr>"}return a},getIcon:function(b){var a=(b.type==="movie")?"poster":"screenshot";return['<div class="icon '+a+'"','style="',String.format(SYNO.SDS.VideoStation.Util.BACKGROUND_IMAGE_STR,this.getImageURL(b)),'">',"</div>"].join("")},getImageURL:function(a){return SYNO.SDS.VideoStation.Util.getImageURL(this._getWebAPIURL("poster.cgi"),{type:a.type,id:a.id,mtime:a.additional?a.additional.poster_mtime||"":""})}});Ext.ns("SYNO.SDS.VideoStation.Config");Ext.apply(SYNO.SDS.VideoStation.Config,{pageSize:120,recentadd:-1});Ext.ns("SYNO.SDS.VideoStation.Util");function _VST(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}}Ext.apply(SYNO.SDS.VideoStation.Util,{init:(function(){var a=SYNO.SDS.VideoStation.Util;a._MOVIE_ID="movie";a._TVSHOW_ID="tvshow";a._TVSHOW_EPISODE_ID="tvshow_episode";a._HOME_VIDEO_ID="home_video";a._TV_RECORDER_ID="tv_record";a._COLLECTION_ID="collection";a._SEARCH_ID="search";a.SEC_LIST=[a._COLLECTION_ID,a._MOVIE_ID,a._TVSHOW_ID,a._HOME_VIDEO_ID,a._TV_RECORDER_ID];a.SEARCH_HISTORY={};a.SEARCH_HISTORY[a._MOVIE_ID]="all";a.SEARCH_HISTORY[a._TVSHOW_ID]="all";a.SEARCH_HISTORY[a._HOME_VIDEO_ID]="all";a.SEARCH_HISTORY[a._TV_RECORDER_ID]="all";a.SEARCH_HISTORY[a._COLLECTION_ID]="all";a.SEC_CFG={};a.SEC_CFG[a._MOVIE_ID]={id:a._MOVIE_ID,type:a._MOVIE_ID,title:_VST("type","movie"),webAPIID:"SYNO.VideoStation.Movie",data:[{index:0,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",type:"movie",subtype:"root",status:{}},{index:1,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",webAPIID:"SYNO.VideoStation.Metadata",cgiURL:"metadata.cgi",type:"movie",subtype:"classes",status:{}},{index:2,name:_VST("type","movie"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.Movie",cgiURL:"movie.cgi",type:"movie",response_root:"movies",subtype:"list",status:{}},{index:3,name:_VST("search","title"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.Movie",cgiURL:"movie.cgi",type:"movie",subtype:"search",response_root:"movies",status:{}},{index:4,layoutCfg:"SYNO.SDS.VideoStation.ViewMetaData",webAPIID:"SYNO.VideoStation.Movie",cgiURL:"movie.cgi",type:"movie",subtype:"detail",response_root:"movies"},{index:5,name:_VST("type","movie"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.Movie",cgiURL:"movie.cgi",type:"movie",response_root:"movies",subtype:"listdir",status:{}}]};a.SEC_CFG[a._TVSHOW_ID]={id:a._TVSHOW_ID,type:a._TVSHOW_ID,title:_VST("type","tv_show"),webAPIID:"SYNO.VideoStation.TVShow",data:[{index:0,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",type:"tvshow",subtype:"root",status:{}},{index:1,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",webAPIID:"SYNO.VideoStation.Metadata",cgiURL:"metadata.cgi",type:"tvshow",subtype:"classes",status:{}},{index:2,name:_VST("type","tv_show"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.TVShow",cgiURL:"tvshow.cgi",type:"tvshow",response_root:"tvshows",subtype:"list",status:{}},{index:3,name:_VST("search","title"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.TVShow",cgiURL:"tvshow.cgi",type:"tvshow",subtype:"search",response_root:"tvshows",status:{}},{index:4,layoutCfg:"SYNO.SDS.VideoStation.ViewTVseason",webAPIID:"SYNO.VideoStation.TVShowEpisode",cgiURL:"tvshow_episode.cgi",type:"tvshow_episode",subtype:"tvshow_episode",response_root:"episodes",status:{}},{index:5,layoutCfg:"SYNO.SDS.VideoStation.ViewMetaData",webAPIID:"SYNO.VideoStation.TVShowEpisode",cgiURL:"tvshow_episode.cgi",type:"tvshow_episode",subtype:"detail",response_root:"episodes"},{index:6,name:_VST("type","tv_show"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.TVShowEpisode",cgiURL:"tvshow_episode.cgi",type:"tvshow_episode",response_root:"episodes",subtype:"listdir",status:{}}]};a.SEC_CFG[a._HOME_VIDEO_ID]={id:a._HOME_VIDEO_ID,type:a._HOME_VIDEO_ID,title:_VST("type","home_video"),webAPIID:"SYNO.VideoStation.HomeVideo",data:[{index:0,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",type:"home_video",subtype:"root",status:{}},{index:1,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",webAPIID:"SYNO.VideoStation.Metadata",cgiURL:"metadata.cgi",type:"home_video",subtype:"classes",status:{}},{index:2,name:_VST("type","home_video"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.HomeVideo",cgiURL:"homevideo.cgi",type:"home_video",subtype:"list",response_root:"videos",status:{}},{index:3,name:_VST("search","title"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.HomeVideo",cgiURL:"homevideo.cgi",type:"home_video",subtype:"search",response_root:"videos",status:{}},{index:4,layoutCfg:"SYNO.SDS.VideoStation.ViewMetaData",webAPIID:"SYNO.VideoStation.HomeVideo",cgiURL:"homevideo.cgi",type:"home_video",subtype:"detail",response_root:"videos"},{index:5,name:_VST("type","home_video"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.HomeVideo",cgiURL:"homevideo.cgi",type:"home_video",response_root:"videos",subtype:"listdir",status:{}}]};a.SEC_CFG[a._TV_RECORDER_ID]={title:_VST("type","tv_recorder"),id:a._TV_RECORDER_ID,type:a._TV_RECORDER_ID,webAPIID:"SYNO.VideoStation.TVRecording",data:[{index:0,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",type:"tv_record",status:{}},{index:1,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",webAPIID:"SYNO.VideoStation.Metadata",cgiURL:"metadata.cgi",type:"tv_record",subtype:"classes",status:{}},{index:2,name:_VST("type","tv_recorder"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.TVRecording",cgiURL:"tvrecorder.cgi",type:"tv_record",subtype:"list",response_root:"recordings",status:{}},{index:3,name:_VST("search","title"),layoutCfg:"SYNO.SDS.VideoStation.ViewList",webAPIID:"SYNO.VideoStation.TVRecording",cgiURL:"tvrecorder.cgi",type:"tv_record",subtype:"search",response_root:"recordings",status:{}},{index:4,layoutCfg:"SYNO.SDS.VideoStation.ViewMetaData",webAPIID:"SYNO.VideoStation.TVRecording",cgiURL:"tvrecord.cgi",type:"tv_record",subtype:"detail",response_root:"recordings"}]};a.SEC_CFG[a._COLLECTION_ID]={id:a._COLLECTION_ID,title:_VST("collection","title"),type:a._COLLECTION_ID,webAPIID:"SYNO.VideoStation.Collection",data:[{index:0,layoutCfg:"SYNO.SDS.VideoStation.ViewGrid",webAPIID:"SYNO.VideoStation.Collection",type:"collection",cgiURL:"collection.cgi",status:{}},{index:1,name:_VST("collection","favorite"),collection_id:-1,layoutCfg:"SYNO.SDS.VideoStation.ViewCollection",webAPIID:"SYNO.VideoStation.Collection",cgiURL:"collection.cgi",type:"collection",status:{}},{index:2,name:_VST("search","title"),collection_id:-1,layoutCfg:"SYNO.SDS.VideoStation.ViewCollection",webAPIID:"SYNO.VideoStation.Collection",cgiURL:"collection.cgi",type:"collection",subtype:"search",status:{}},{index:3,layoutCfg:"SYNO.SDS.VideoStation.ViewMetaData",type:"collection",subtype:"detail",status:{}}]};a.MOD_IMG={};a.MOD_IMG[a._TVSHOW_EPISODE_ID]={};a.MOD_IMG[a._MOVIE_ID]={};a.MOD_IMG[a._TVSHOW_ID]={};a.MOD_IMG[a._TVSHOW_EPISODE_ID]={};a.MOD_IMG[a._HOME_VIDEO_ID]={};a.MOD_IMG[a._TV_RECORDER_ID]={}}),BACKGROUND_IMAGE_STR:((Ext.isIE8||Ext.isIE7)?"filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')":"background-image: url('{0}')"),setModImgTime:function(a,c){var b=SYNO.SDS.VideoStation.Util;if(!b.MOD_IMG[a]){b.MOD_IMG[a]={}}b.MOD_IMG[a][c]=(new Date().getTime())},getModImgTime:function(a,c){var b=SYNO.SDS.VideoStation.Util;if(!b.MOD_IMG[a]||!b.MOD_IMG[a][c]){return 0}return b.MOD_IMG[a][c]},getErrinfoString:function(d,b){var a=SYNO.SDS.VideoStation.Util;var c=null;var e=Ext.isString(b)?b:"";if(d&&d.success!==true){c=d.errinfo||{};if(d.error&&Ext.isNumber(d.error.code)){e=_T("error","error_error_system")}else{if(c.sec&&c.key){e=_VST(c.sec,c.key)||_T(c.sec,c.key)||String.format("{0}:{1}",c.sec,c.key)}else{e=_T("error","error_error_system")}}if(Ext.isNumber(c.line)){e=String.format("{0} ({1})",e,c.line)}}return e},getWebAPIErr:function(a,c,b){if(!a){if(c&&c.code<400){return SYNO.API.CheckResponse(a,c,b)}else{switch(c.code){case 400:return _VST("error","download_failed");case 417:return _VST("error","image_format");case 418:return String.format(_VST("error","image_too_big"),4);case 431:return _VST("collection","collection_duplicate_name");default:return _T("error","error_error_system")}}}},_initWinWrappers:function(a){this._getOwner=function(){if(this.owner){return this.owner}else{if(a&&a.owner){return(this.owner=a.owner)}}return(this.owner=SYNO.SDS.VideoStation.Window)};Ext.each(["_getAbsoluteURL"],function(b){this[b]=function(){var c=SYNO.SDS.VideoStation.Window;return c[b].apply(c,arguments)}},this);Ext.each(["_getCurId","_getHistoryInfo","_getWebAPIURL","_getCurType","_getCurLibraryId","_getCurLibraryType"],function(b){this[b]=function(){var c=SYNO.SDS.VideoStation.Util;return c[b].apply(SYNO.SDS.VideoStation.Window,arguments)}},this)},_getWebAPIURL:function(a){return String.format("{0}/{1}","/webapi/VideoStation",a)},_getCurId:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurId()},_getCurType:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var b=a.getHistoryInfo();return(b.params&&b.params.type)?b.params.type:a.getCurType()},_getCurLibraryId:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurLibraryId()},_getCurLibraryType:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurLibraryType()},_getHistoryInfo:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo()},_checkIsByfolder:function(){var a=false;if(this._getHistoryInfo().params&&"folder"===this._getHistoryInfo().params.category){a=true}return a},_createAction:function(b){var d=b.itemId||Ext.id();var c=b.text||_VST("action",d);var a=b.iconCls||("syno-vs-action-"+d);return(new Ext.Action(Ext.apply({itemId:d,text:c,iconCls:a,scope:b.scope||this,handler:b.handler||Ext.emptyFn},b)))},_createActions:function(b){if(!this.actions){this.actions={}}var a=[];if(!Ext.isArray(b)){b=[b]}Ext.each(b,function(c){var d=c.itemId||Ext.id();this.actions[d]=this._createAction(c);a.push(this.actions[d])},this);return a},_getAction:function(a){if(a in this.actions){return this.actions[a]}else{SYNO.Debug("no this action: "+a);return undefined}},_initUtilFnWrappers:function(a){Ext.each(a,function(b){this[b]=function(){return SYNO.SDS.VideoStation.Util[b].apply(this,arguments)}},this)},parseFullPathToFileName:function(d,c){var b=c?c:"/";var a="";var e=d.lastIndexOf(b);a=d.substring(e+1);return a},getCategoryString:function(a){switch(a){case"actor":return _VST("actor","title");case"director":return _VST("director","title");case"genre":return _VST("genre","title");case"writer":return _VST("writer","title");case"year":return _VST("year","title");default:return _T("common","name")}},getShareData:function(c){var b=c;var d=b.indexOf("/",1);var a="";b=b.substr(1);if(d>0){a=b.substr(d);b=b.substr(0,d-1)}return{share:Ext.util.Format.lowercase(b),orishare:b,subpath:a}},isConflictTargetPath:function(e,b,d){var a=d?d:"/";var c="";var g="";if(b.length<e.length){var f=e.lastIndexOf(a);if(d==="\\"&&e[f-1]===":"){f++}g=e.substring(f);return(b+g==e)}else{if(b.length==e.length){return(b==e)}else{c=b.substring(0,e.length);g=b.substring(e.length);return((c==e)&&(a==g.charAt(0)))}}},ableToControlDTV:function(){var a=SYNO.SDS.VideoStation.Util.privilege;return Ext.isObject(a)?a.dtv:false},ableToControlRenderer:function(){var a=SYNO.SDS.VideoStation.Util.privilege;return Ext.isObject(a)?a.renderer:false},getSessionString:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return _VST("type","movie");case SYNO.SDS.VideoStation.Util._TVSHOW_ID:return _VST("type","tv_show");case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return _VST("type","home_video")}},setItemSize:function(a,d,c){a.setWidth(c);a.setHeight(c);var e=a.down(".cover-link");if(e){e.setWidth(c);e.setHeight(c)}var b=a.child(".photo-thumb-img");SYNO.SDS.VideoStation.Util.setOuterFitImgStyle(a,b,w,h,c)},setOuterFitImgStyle:function(a,d,b,e,c){if(b<=c&&e<=c){d.setStyle("height",e+"px");d.setStyle("width",b+"px");d.alignTo(a,"c-c");return}d.setStyle("left",undefined);d.setStyle("top",undefined);if(b>e){d.setStyle("height",c+"px");d.setStyle("width",undefined);d.setStyle("margin-left",(c-b/e*c)/2+"px");d.setStyle("margin-top","0px")}else{d.setStyle("width",c+"px");d.setStyle("height",undefined);d.setStyle("margin-top",(c-e/b*c)/2+"px");d.setStyle("margin-left","0px")}},sendAjax:function(d,b,c,a){Ext.Ajax.request({url:d,method:"GET",success:b,params:c,failure:function(e,f){SYNO.Debug("Ajax load failure "+e.responseText)},scope:a})},mappingDTVStatus:function(a){switch(a){case 401:return _VST("error","error_someone_streaming");case 402:return _VST("error","error_someone_scaning");case 403:return _VST("error","dtv_channeltable_not_found");case 404:return _VST("error","recorde_program_not_exist");case 405:return _VST("error","recorde_duplicate");case 406:return _VST("error","dtv_folder_not_found");case 407:return _VST("error","dtv_request_dongle");case 408:return _VST("action","scan_fail");case 409:return _VST("error","no_data");case 412:return _VST("error","update_recording");case 413:return _VST("error","update_streaming");case 414:return _T("error","error_file_exist");case 415:return _VST("action","dvbs_scan_fail");default:return _T("common","error_system")}},dtvStatus:function(a){switch(a){case 1:return"idle";case 6:case 2:return"record";case 4:return"stream";case 8:return"update";case 16:return"scan";case 32:return"nodevice"}},programStatus:function(a){switch(a){case 0:return"";case 1:return"pass";case 2:return"streaming";case 3:return"recording";case 4:return"scheduled";case 22:return"repeatschedule";case 12:case 13:return"repeatschedule"}},getScheduleStatusString:function(a){switch(a){case 0:return _T("error","error_error");case 1:return _VST("record","task_waiting");case 2:return _VST("streaming","streaming_for_someone");case 3:return _VST("action","recording");case 4:return _VST("error","no_dtv_dongle");case 5:return _VST("record","record_interrupt");case 6:return _VST("record","task_finished");case 7:return _VST("error","record_dest_deny");case 8:return _VST("error","invalid_user");case 9:return _VST("error","record_quota_reached");case 10:return _VST("error","record_no_volume");case 11:return _VST("error","record_dest_not_exist");case 12:return _VST("repeat","repeat_weekly");case 13:return _VST("repeat","repeat_daily");case 14:return _VST("record","record_interrupt");case 15:return _VST("record","skip")}},modifyHM:function(a){var b=a;if(10>a){b="0"+a}return b},getWeekDayfromNumber:function(a){var b=false;switch(a){case 0:b=_VST("repeat","schedule_sun");break;case 1:b=_VST("repeat","schedule_mon");break;case 2:b=_VST("repeat","schedule_tue");break;case 3:b=_VST("repeat","schedule_wed");break;case 4:b=_VST("repeat","schedule_thu");break;case 5:b=_VST("repeat","schedule_fri");break;case 6:b=_VST("repeat","schedule_sat");break}return b},encodedMsg:function(c,a){var b=c;if(!Ext.isDefined(c)){b=""}else{if(a){b=Ext.util.Format.stripTags(b)}}return Ext.util.Format.htmlEncode(b)},onProxyBeforeLoad:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}},onPlayAction:function(f,d,a,c){if(!d||!d.id||!d.path){return}var b=c||"streaming";var e=d.path;SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{ieMode:9,file_id:d.id,player_id:b,title:e.substr(e.lastIndexOf("/")+1),browse_type:a.pathType,type_id:a.typeID,video_id:a.videoID,video_type:a.videoType})},onOpenContainingFolder:function(a){SYNO.SDS.AppLaunch("SYNO.SDS.App.FileStation3.Instance",{openfile:a})},onGetHeight:function(d,c){var a=d.getHeight()+(c||0);var b=SYNO.SDS.Desktop.getEl().getHeight();if(b<a){a=b}return a},getinfo_WebAPI:function(b){var a="";switch(b){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return{api:"SYNO.VideoStation.Movie",method:"getinfo",version:"1"};case"tvshow_episode":case SYNO.SDS.VideoStation.Util._TVSHOW_ID:return{api:"SYNO.VideoStation.TVShowEpisode",method:"getinfo",version:"1"};case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return{api:"SYNO.VideoStation.HomeVideo",method:"getinfo",version:"1"};case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:return{api:"SYNO.VideoStation.TVRecording",method:"getinfo",version:"1"};case SYNO.SDS.VideoStation.Util._COLLECTION_ID:return{api:"SYNO.VideoStation.Collection",method:"getinfo",version:"1"};default:break}},onRequestCollectionNoMesg:function(f,b,e,c){var d=this._getHistoryInfo();var a=this._getCurType();if(a==="tvshow"){a="tvshow_episode"}SYNO.API.currentManager.requestAPI("SYNO.VideoStation.Collection",f,1,Ext.apply({video_type:a,video_id:d.params?d.params.id:""},b),function(g,l,k){if(!g){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(g,l,k));return}else{if(Ext.isFunction(e)){e.call(c,g,l,k)}else{var j=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();j.onActivate()}}},this)},onRequestCollection:function(f,b,e,c){var d=this._getHistoryInfo();this._getOwner().setStatusBusy();var a=this._getCurType();if(a==="tvshow"){a="tvshow_episode"}SYNO.API.currentManager.requestAPI("SYNO.VideoStation.Collection",f,1,Ext.apply({video_type:a,video_id:d.params?d.params.id:""},b),function(g,m,k){this._getOwner().clearStatusBusy();if(!g){this._getOwner().getMsgBox().alert(_VST("app","displayname"),SYNO.SDS.VideoStation.Util.getWebAPIErr(g,m,k));return}else{var l=_VST("common","saved");switch(f){case"addvideo":if(-1===b.id){l=_VST("collection","favorite_added")}else{if(-2===b.id){l=_VST("collection","watchlist_added")}}break;case"deletevideo":if(-1===b.id){l=_VST("collection","favorite_removed")}else{if(-2===b.id){l=_VST("collection","watchlist_removed")}}break;default:break}this._getOwner().getMsgBox().alert(_VST("app","displayname"),l);if(Ext.isFunction(e)){e.call(c,g,m,k)}else{var j=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();j.onActivate()}}},this)},onRequestCollectionCallBack:function(a,g,e,j,b){var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();if(!a||!g||!c){c.onActivate()}else{if(c.onSetShowHideCollection){c.onSetShowHideCollection(a,g,e,j,b)}}var f=d.getHistoryInfo(d.getCurId(),1);if(("deletevideo"===j)&&SYNO.SDS.VideoStation.Util._COLLECTION_ID===this._getCurId()&&f.collection_id===b.id){d.onGotoBack(4==d.objHistory.collection.length?2:1)}},gotoScroll:function(a,b){if(a&&a.dom&&a.dom.fleXcroll){(function(){a.dom.fleXcroll.scrollToElement(b)}).defer(Ext.isIE?750:550)}},getAddtionalText:function(a,b){if((!a||!a.additional||!a.additional[b])&&(!a.file||!a.file.additional||!a.file.additional[b])){return""}if(a.additional&&a.additional[b]){return a.additional[b].replace(/[\n\r\t]/g,"")}else{if(a.file&&a.file.additional&&a.file.additional[b]){return a.file.additional[b].replace(/[\n\r\t]/g,"")}else{return""}}},getImageURL:function(a,c){c=c||{};Ext.apply(c,{api:"SYNO.VideoStataion.Poster",method:"getimage",version:"1"});var b=SYNO.SDS.VideoStation.Util.getModImgTime(c.type,c.id);if(b){Ext.apply(c,{_dc:b})}if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(c,{hr:2})}url=Ext.urlAppend(a,Ext.urlEncode(c));return url},getLangStore:function(){var b=SYNO.SDS.Utils.getSupportedLanguage(),a;a=new Ext.data.SimpleStore({fields:["value","display"],data:b,autoDestroy:true});return a},onGetUserDefineCollectionID:function(b,a){var d,c="";d=b.indexOf(a);if(-1!==d){c=b.substring(0,d)}return c},getTVShowID:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");if(SYNO.SDS.VideoStation.Util._TVSHOW_ID!==SYNO.SDS.VideoStation.Util._getCurLibraryType()){return null}var d=a.objHistory[a.getCurId()];var b=d.length-1;if(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID!==d[b].subtype){b--}if(!Ext.isDefined(d[b].params)){return null}var c=d[b].params.id;return c},getCollectionID:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");if(SYNO.SDS.VideoStation.Util._COLLECTION_ID!==a.getHistoryInfo().id){return null}var d=a.objHistory[SYNO.SDS.VideoStation.Util._COLLECTION_ID];var b=d.length-1;if(Ext.isDefined(d[b].subtype)){b--}var c;if(Ext.isDefined(d[b].params.category)){c=d[b].params.category}else{c=-1}return c},getPlayAdditionalInfo:function(){var e,d,c,b;var a=SYNO.SDS.VideoStation.Util._getHistoryInfo();b=SYNO.SDS.VideoStation.Util.getTVShowID()||SYNO.SDS.VideoStation.Util.getCollectionID()||null;e=a.type;c=(SYNO.SDS.VideoStation.Util._COLLECTION_ID===e)?a.params.type:e;switch(a.subtype){case"detail":d=a.params.id;break;case"list":d=a.status.selected_id;break;default:d=(SYNO.SDS.VideoStation.Util._COLLECTION_ID===e)?a.params.id:"";break}return{pathType:e,videoType:c,typeID:b,videoID:d}},getCurrentCollection:function(a){SYNO.API.currentManager.requestAPI("SYNO.VideoStation.Collection","list","1",{offset:0,limit:-1,sort_by:"title",sort_direction:"ASC"},function(b,f,d){if(b&&f&&f.collections&&a.collectionMenu.isVisible()){var e,c=[];Ext.each(f.collections,function(k,g,j){e={id:k.id,title:k.title};c.push(e)},a);SYNO.SDS.VideoStation.gData.collections=c;a.updateCollectionsMenuitems();a.onShowHideCollection()}},this);a.onShowHideCollection()},GangCheckBox:function(c,b,a){var d=SYNO.SDS.Utils.FieldFind(c,b);this.fields=a;this.form=c;d.mon(d,"check",function(k,j){var g,f,e;if(j){for(g=0,f=this.fields.length;g<f;g++){e=SYNO.SDS.Utils.FieldFind(this.form,this.fields[g]);e.setDisabled(false)}}else{for(g=0,f=this.fields.length;g<f;g++){e=SYNO.SDS.Utils.FieldFind(this.form,this.fields[g]);e.setDisabled(true)}}},this)},ableToPlayDTV:function(){var a=(SYNO.SDS.VideoStation.Util.support_transcode||SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported());return a}});Ext.define("SYNO.SDS.VideoStation.ModalWindow",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){var a=Ext.isString(b.cls)?(b.cls+" syno-vs-dialog"):"syno-vs-dialog";b.cls=a;this.callParent([b])},_getAbsoluteURL:function(){return this._getOwner()._getAbsoluteURL.apply(this._getOwner(),arguments)},_getWebAPIURL:function(){return this._getOwner()._getWebAPIURL.apply(this._getOwner(),arguments)},_getOwner:function(){if(this.owner){return this.owner}return(this.owner=SYNO.SDS.VideoStation.Window)}});SYNO.SDS.VideoStation.ChannelListDropTarget=function(a,b){this.ddTarget=a;this.store=a.store;SYNO.SDS.VideoStation.ChannelListDropTarget.superclass.constructor.call(this,a.container,b)};Ext.extend(SYNO.SDS.VideoStation.ChannelListDropTarget,Ext.dd.DropTarget,{ddTarget:null,store:null,notifyDrop:function(a,k,j){var b=-1,d=this.ddTarget,c,g,f=new Date().getTime();if(f<this.dropTargetLastTime+500){return false}else{this.dropTargetLastTime=f}b=d.view.findRowIndex(k.getTarget());if(false===b){a.endDrag();return false}g=j.selections;for(c=0;c<g.length;c++){this.store.remove(g[c]);if(0===c){pos=b}else{pos=this.store.indexOf(g[c-1])+1}this.store.insert(pos,g[c]);d.isChannelChanged=true}d.selModel.selectRecords(g);a.endDrag();return true}});Ext.define("SYNO.SDS.VideoStation.StreamingDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:this._getOwner(),width:600,height:_S("is_admin")?300:250,minWidth:300,minHeight:250,title:_VST("programguide","broadcast_streaming"),layout:"fit",plain:true,items:[this.getFormPanel()],buttons:[this.playbtn=new SYNO.ux.Button({btnStyle:"blue",text:_VST("action","play"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToPlayDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onPlayStreaming}),{btnStyle:"red",text:_VST("streaming","streaming_stop"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onStopStreaming},{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onStopStreaming},{key:27,scope:this,handler:this.close}]};return Ext.apply(b,a)},show:function(){this.setStatusBusy({text:_T("common","loading")});this.basePort=9025;SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","list","1",{additional:"channel_status"},this.getTunerListDone,this);this.callParent(arguments)},getTunerListDone:function(a,g,f){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,g,f));return}if(!g.tuners||0===g.tuners.length){this.clearStatusBusy();return}var c=this.formPanel.tunerCombo.getStore();var d=[];Ext.each(g.tuners,function(l,j,k){if(l&&l.additional&&l.additional.channel_status&&l.additional.channel_status.streaming_id&&-1!==l.additional.channel_status.streaming_id){if(!Ext.isDefined(this.currentTunerID)){this.currentTunerID=l.id}d.push([l.id,l.title])}},this);var b=this.basePort;if(Ext.isDefined(this.currentTunerID)){b=this.currentTunerID%16+b}var e=String.format(_VST("streaming","streaming_description"),b);this.formPanel.getForm().findField("description").setValue(e);c.loadData(d,false);c.sort("display","ASC");if(Ext.isDefined(this.currentTunerID)){this.formPanel.tunerCombo.setValue(this.currentTunerID)}else{this.formPanel.tunerCombo.setValue(0)}SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","getchannel","1",{tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.getChannelDone,this)},getChannelDone:function(a,c,b){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,c,b));return}if(c&&c.streaming_id){SYNO.API.currentManager.requestAPI("SYNO.DTV.Channel","getinfo","1",{id:c.streaming_id,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.getChannelInfoDone,this)}else{this.clearStatusBusy()}},getChannelInfoDone:function(a,d,c){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,d,c));return}var b=this.formPanel.getForm();channel_name=this.formPanel.form.findField("channel_name");this.ChannelName=d.channels[0].title;channel_name.setValue(d.channels[0].title);SYNO.API.currentManager.requestAPI("SYNO.DTV.Statistic","getinfo","1",{},this.getStatistic,this)},getStatistic:function(a,f,d){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,f,d));return}var c=this.formPanel.getForm();var e=c.findField("watchnumber");var b=(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0);Ext.each(f.statistics,function(k,g,j){if(b===k.id){e.setValue(k.brocasting_count);return}},this);SYNO.API.currentManager.requestAPI("SYNO.DTV.Streaming","open","1",{accept_format:"raw",tuner:(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0)},this.StreamOpenDone,this)},StreamOpenDone:function(a,g,e){this.clearStatusBusy();if(!a){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,g,e));return}var d=this.formPanel.getForm();var c=d.findField("url");var b=window.location.port;var f=window.location.protocol;if(b){this.streamUrl=f+"//"+window.location.hostname+":"+b+"/"+g.additional[0].url+"/"+(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0)}else{this.streamUrl=f+"//"+window.location.hostname+"/"+g.additional[0].url+"/"+(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0)}c.setValue(this.streamUrl);c.selectText(0,c.length)},onStopStreaming:function(){if(_S("demo_mode")){this.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));return}this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","setchannel","1",{id:-1,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.onStopStreamingDone,this)},onStopStreamingDone:function(a,c,b){this.clearStatusBusy();if(!a){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,c,b));return}else{this.owner.mainpanel.mainCardPanel.tunerStatus.restart();this.close()}},onPlayStreaming:function(){if(this.streamUrl){SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{dtv_url:this.streamUrl,title:this.ChannelName})}},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.StreamingFormpanel({module:this})}return this.formPanel}});Ext.define("SYNO.SDS.VideoStation.StreamingFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.module=a.module;this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=Ext.apply({frame:false,border:false,labelWidth:160,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[this.tunerCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dongle","tuner"),name:"tuner",triggerAction:"all",resizable:false,store:this.createTunerStore(),editable:false,displayField:"display",valueField:"value",value:"no_dongle",mode:"local",listeners:{scope:this,select:this.onChangeTuner}}),{xtype:"syno_displayfield",itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel")},{xtype:"syno_displayfield",itemId:"watchnumber",name:"watchnumber",fieldLabel:_VST("streaming","streaming_watch")},{xtype:"syno_textfield",itemId:"url",name:"url",fieldLabel:_VST("streaming","streaming_url"),width:350,readOnly:true,cls:"selectabletext allowDefCtxMenu"},{xtype:"syno_displayfield",name:"description",value:String.format(_VST("streaming","streaming_description"),"9025~9040"),hidden:!_S("is_admin")}]},a);return b},createTunerStore:function(){this.defTunerValue=["no_dongle",_VST("error","no_dtv_dongle")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defTunerValue]});this.addManagedComponent(a);return a},onChangeTuner:function(e,a,c){this.module.setStatusBusy({text:_T("common","loading")});this.module.currentTunerID=a.data.value;var b=this.module.basePort;if(Ext.isDefined(this.module.currentTunerID)){b=this.module.currentTunerID%16+b}var d=String.format(_VST("streaming","streaming_description"),b);this.getForm().findField("description").setValue(d);SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","getchannel","1",{tuner:Ext.isDefined(this.module.currentTunerID)?this.module.currentTunerID:0},this.module.getChannelDone,this.module)}});Ext.define("SYNO.SDS.VideoStation.RecordingDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:this._getOwner(),width:400,height:200,minWidth:210,minHeight:150,title:_VST("programguide","programguide_recording"),layout:"fit",items:[this.getFormPanel()],buttons:[{btnStyle:"red",text:_VST("record","stop_record"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onStopRecording},{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onStopRecording},{key:27,scope:this,handler:this.close}]};return Ext.apply(b,a)},show:function(){this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","list","1",{additional:"channel_status"},this.getTunerListDone,this);this.callParent(arguments)},getTunerListDone:function(a,e,d){if(!a){this.clearStatusBusy();this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,e,d));return}if(!e.tuners||0===e.tuners.length){this.clearStatusBusy();return}var b=this.formPanel.tunerCombo.getStore();var c=[];Ext.each(e.tuners,function(j,f,g){if(j&&j.additional&&j.additional.channel_status&&j.additional.channel_status.recording_id&&-1!==j.additional.channel_status.recording_id){if(!Ext.isDefined(this.currentTunerID)){this.currentTunerID=j.id}c.push([j.id,j.title])}},this);b.loadData(c,false);b.sort("display","ASC");if(Ext.isDefined(this.currentTunerID)){this.formPanel.tunerCombo.setValue(this.currentTunerID)}else{this.formPanel.tunerCombo.setValue(0)}SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","list","1",{start:0,limit:-1,tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},this.getRecordingDone,this)},getRecordingDone:function(a,e,c){this.clearStatusBusy();if(!a){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(a,e,c));return}var b=this.formPanel.form.findField("channel_name");var d=this.formPanel.form.findField("title");Ext.each(e.schedules,function(j,f,g){if(j.status&&"recording"===SYNO.SDS.VideoStation.Util.programStatus(j.status)){b.setValue(j.channel_name);d.setValue(j.title)}},this)},onStopRecording:function(){if(_S("demo_mode")){this.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));return}this.getMsgBox().confirm(this.title,_VST("schedule","pause_record"),function(a){if("yes"===a){this.setStatusBusy({text:_T("common","saving")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete","1",{tuner:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},function(b,e,d){this.clearStatusBusy();if(!b){if(e.code<400){this.getMsgBox().alert(this.title,SYNO.API.CheckResponse(b,e,d))}else{var c=SYNO.SDS.VideoStation.Util.mappingDTVStatus(e.code);this.getMsgBox().alert(this.title,c)}}else{this.owner.mainpanel.mainCardPanel.tunerStatus.restart();this.close()}},this)}},this)},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.RecordingFormpanel({module:this})}return this.formPanel}});Ext.define("SYNO.SDS.VideoStation.RecordingFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=Ext.apply({frame:false,border:false,labelWidth:160,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[this.tunerCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dongle","tuner"),name:"tuner",triggerAction:"all",resizable:false,store:this.createTunerStore(),editable:false,displayField:"display",valueField:"value",value:"no_dongle",mode:"local",listeners:{scope:this,select:this.onChangeTuner}}),{xtype:"syno_displayfield",itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel")},{xtype:"syno_displayfield",itemId:"title",name:"title",fieldLabel:_VST("programguide","title")}]},a);return b},createTunerStore:function(){this.defTunerValue=["no_dongle",_VST("error","no_dtv_dongle")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defTunerValue]});this.addManagedComponent(a);return a},onChangeTuner:function(c,a,b){this.module.setStatusBusy({text:_T("common","loading")});this.module.currentTunerID=a.data.value;SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","list","1",{start:0,limit:-1,tuner:Ext.isDefined(this.module.currentTunerID)?this.module.currentTunerID:0},this.module.getRecordingDone,this.module)}});Ext.define("SYNO.SDS.VideoStation.SignalMenu",{extend:"SYNO.ux.Menu",constructor:function(b){var a={cls:"syno-vs-signal-panel",items:[this.getPanel()],defaultOffsets:[34,0],listeners:{scope:this,beforeshow:function(){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel");this.getPanel().loadData(c.tuners)}}};this.callParent([Ext.apply(a,b)])},getPanel:function(){if(this.panel){return this.panel}this.panel=new SYNO.SDS.VideoStation.SignalPanel({tuners:this.tuners});return this.panel}});Ext.define("SYNO.SDS.VideoStation.SignalPanel",{extend:"SYNO.ux.Panel",constructor:function(b){this.tuners=b.tuners||[];var a={shadow:false,frame:true,footer:true,layout:"fit",autoHeight:true,items:this.getDataView()};this.callParent([Ext.apply(a,b)])},getDataView:function(){if(this.dataview){return this.dataview}this.dataview=new Ext.DataView({itemSelector:"div.item",emptyText:"No tuner",itemId:"dataview",cls:"syno-vs-dtv-signalpanel-dataview",store:this.getStore(),tpl:new Ext.XTemplate('<div class="header-text">'+_VST("dongle","signal_strength")+"</div>",'<tpl for=".">','<div class="item">','<div class="image-{values.signal}"></div>','<span class="title">{values.title}</span>',"</div>","</tpl>",{compiled:true,disableFormats:true})});return this.dataview},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.ArrayStore({data:[],idIndex:0,autoDestroy:true,fields:["id","title","signal"]});this.addManagedComponent(this.store);return this.store},getItems:function(){var a=[],b=0;Ext.each(this.tuners,function(c){if(!Ext.isNumber(c.signal)||c.signal<=0){return true}var d=Ext.min([100,Math.ceil(c.signal/20)*20]);a.push([c.id,c.title,d])},this);return a},loadData:function(a){this.tuners=a;this.getStore().loadData(this.getItems(),false)}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.CardPanel",{extend:"SYNO.ux.Panel",constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.CardPanel",this);this.pathBar=new SYNO.SDS.VideoStation.PathBar({scope:this});var d=(function(){var f=0;a.items.each(function(j){if(true!==j.hidden){try{f+=j.getOuterSize().width}catch(k){}}});f-=this.pathBar.tbPanel.getWidth();var e=a.getWidth()-a.getResizeEl().getPadding("lr")-2;var g=e-f;if(g>0){this.pathBar.setWidth(g)}}).createDelegate(this);var a=new Ext.Toolbar({toolbarCls:"syno-vs-path-bar",itemId:"topToolbar",enableOverflow:false,items:[this.pathBar.getPanel(),"->",{xtype:"syno_button",cls:"dtv-signal",itemId:"showsignal",hidden:true,menu:new SYNO.SDS.VideoStation.SignalMenu(),menuAlign:"tr-br",getMenuClass:Ext.emptyFn},{xtype:"syno_button",tooltip:_VST("programguide","programguide_recording"),cls:"dtv-showrecording",itemId:"showrecording",disabled:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),hidden:true,scope:this,handler:function(){var e=new SYNO.SDS.VideoStation.RecordingDialog();e.show()}},{xtype:"syno_button",tooltip:_VST("programguide","broadcast_streaming"),cls:"dtv-showstreaming",itemId:"showstreaming",hidden:true,scope:this,handler:function(){if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("dtv","error_disabled"))}else{var e=new SYNO.SDS.VideoStation.StreamingDialog();e.show()}}},this.getPlayerButton()],listeners:{buffer:100,show:d,resize:d,scope:this,render:{single:true,buffer:80,scope:this,fn:function(){this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"beforeactivate",function(g,e,f){this.showrecordingbtn.hide();this.showstreamingbtn.hide();this.showsignalbtn.hide();if(f.type==="tv_record"){this.getTunerStatus();this.tunerStatus.restart()}else{if(this.tunerStatus){this.tunerStatus.stop()}}},this)}}}});this.toolbar=a;this.showrecordingbtn=a.getComponent("showrecording");this.showstreamingbtn=a.getComponent("showstreaming");this.showsignalbtn=a.getComponent("showsignal");this.metadata=new SYNO.SDS.VideoStation.ViewMetaData({itemId:"metadata"});this.list=new SYNO.SDS.VideoStation.ViewList({itemId:"list",forceLayout:true});this.grid=new SYNO.SDS.VideoStation.ViewGrid({itemId:"grid"});this.search=new SYNO.SDS.VideoStation.ViewSearch({itemId:"search"});this.groupgrid=new SYNO.SDS.VideoStation.ViewTVseason({itemId:"groupgrid"});this.collection=new SYNO.SDS.VideoStation.ViewCollection({});var c={activeItem:0,layout:"card",tbar:a,items:[this.list,this.grid,this.groupgrid,this.metadata,this.search,this.collection],border:false,cls:"syno-vs-card",listeners:{scope:this,render:function(){var e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");this.mainTbar=e.getTBar();this.mainTbar.render(this.tbar,0)}}};Ext.apply(c,b);SYNO.SDS.VideoStation.CardPanel.superclass.constructor.call(this,c)},getTunerStatus:function(){if(!this.tunerStatus){this.tunerStatus=this.addTask({interval:8000,scope:this,run:function(){SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","list","1",{additional:"channel_status"},this.getTunerListDone,this)}})}},getTunerListDone:function(j,d,c){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main");var g=a.getTBar().getComponent("digitaltv");if(!j||!d||!d.tuners||0===d.tuners.length){if(!this.showNoDongle){if(true!==SYNO.SDS.VideoStation.gData.disable_dtv){var b=String.format('<a target="_blank" class="link-font" href="http://www.synology.com/support/faq_show.php?q_id=532">{0}</a>',_VST("common","synology_website"));var k=String.format(_VST("error","dtv_request_dongle2"),b);this._getOwner().getMsgBox().alert(_VST("type","tv_recorder"),k)}this.showNoDongle=true}g.setDisabled(true);this.showstreamingbtn.hide();this.showrecordingbtn.hide();this.showsignalbtn.hide();return}if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurId()){g.setDisabled(false);a.updateScheduleMenuItems(d.tuners);var e=false,f=false,l=false;Ext.each(d.tuners,function(o,m,n){if(-1!==o.additional.channel_status.streaming_id){e=true}if(-1!==o.additional.channel_status.recording_id){f=true}if(o.signal&&o.signal>0){l=true}},this);if(e){this.showstreamingbtn.show()}else{this.showstreamingbtn.hide()}if(f){this.showrecordingbtn.show()}else{this.showrecordingbtn.hide()}if(l){this.showsignalbtn.show()}else{this.showsignalbtn.hide()}this.tuners=d.tuners}this.toolbar.syncSize()},getPlayerButton:function(){if(this.playerBtn){return this.playerBtn}var b=new SYNO.VideoController2.PlayerMenu({cls:"no-tick",defaultOffsets:[0,0],addStreamingItem:Ext.emptyFn,selectPlayer:function(c){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData").playVideo(c.id)}});var a={tooltip:_VST("controller","tooltip_player"),cls:"player",itemId:"player",hidden:true,scope:this,getMenuClass:Ext.emptyFn,menuAlign:"tr-br",menu:b};this.playerBtn=new SYNO.ux.Button(a);return this.playerBtn}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.PathBar=Ext.extend(Ext.util.Observable,{constructor:function(a){SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.PathBar",this);this.init();SYNO.SDS.VideoStation.PathBar.superclass.constructor.apply(this,arguments)},init:function(){this.tbPanel=new SYNO.SDS.VideoStation.PathButtonsPanel({cls:"syno-vs-ux-pathtoolbar"});return this},addPathButton:function(f,e,c,g,b,d,a){return this.tbPanel.addButton(f,e,c,g,b,d,a)},updatePathButton:function(e,d,c,f,b,a){return this.tbPanel.updateButton(e,d,c,f,b,a)},addPathButtons:function(c){var b=(this.tbPanel.items.length<c.length)?c.length:this.tbPanel.items.length;var d=c.length-1;for(var a=0;a<b;a++){if(a<this.tbPanel.items.length&&a<c.length){this.updatePathButton(a,c[a].text,c[a].tooltip,c[a].callback,c[a].scope,a===d)}else{if(a<c.length){this.addPathButton(this.tbPanel.items.length,c[a].text,c[a].tooltip,c[a].callback,c[a].scope,a===0,a===d)}else{this.removePathButtons(a,b);break}}}this.tbPanel.setActiveButton(this.tbPanel.items[this.tbPanel.items.length-1])},removePathButtons:function(b,a){this.tbPanel.removeButtons(b,a)},setWidth:function(a){this.tbPanel.setWidth(a)},getPanel:function(){return this.tbPanel}});SYNO.SDS.VideoStation.PathButtonsPanel=Ext.extend(Ext.BoxComponent,{activeButton:null,enableScroll:true,scrollIncrement:0,scrollRepeatInterval:400,scrollDuration:0.35,animScroll:true,buttonWidthSet:false,allowDomMove:false,onRender:function(){SYNO.SDS.VideoStation.PathButtonsPanel.superclass.onRender.call(this,arguments);this.mon(this,"resize",this.delegateUpdates);this.items=[];var a=Ext.get(this.el);this.stripWrap=a.createChild({cls:"ux-pathbuttons-strip-wrap",cn:{tag:"ul",cls:"ux-pathbuttons-strip"}});this.stripSpacer=a.createChild({cls:"ux-pathbuttons-strip-spacer"});this.strip=new Ext.Element(this.stripWrap.dom.firstChild);this.edge=this.strip.createChild({tag:"li",cls:"ux-pathbuttons-edge"});this.strip.createChild({cls:"x-clear"});this.addEvents("updatepath")},addButton:function(c,f,k,e,j,b,g){var d=this.strip.createChild({tag:"li"},this.edge);var a=new SYNO.SDS.VideoStation.PathBar.PathButton(this,d,c,f,k,e,j,b,g);this.items.push(a);if(!this.buttonWidthSet){this.lastButtonWidth=a.container.getWidth()}this.addManagedComponent(a);return a},updateButton:function(f,e,d,g,c,b){var a=this.items[f];a.updateButton(e,d,g,c,b)},removeButtons:function(f,e){var a;var c;for(var b=f;b<e;b++){c=this.items[b];a=document.getElementById(c.container.id);this.removeManagedComponent(c);c.purgeListeners();c.destroy();a.parentNode.removeChild(a)}var d=[];for(b=0;b<f;b++){d.push(this.items[b])}this.items=d;this.delegateUpdates()},setActiveButton:function(a){this.activeButton=a;this.delegateUpdates()},delegateUpdates:function(){if(this.enableScroll&&this.rendered){this.onAutoScroll()}},onAutoScroll:function(){var f=this.items.length;var d=this.el.dom.offsetWidth;var c=this.el.dom.clientWidth;var e=this.stripWrap;var b=e.dom.offsetWidth;var g=this.getScrollPos();var a=this.edge.getOffsetsTo(this.stripWrap)[0]+g;if(!this.enableScroll||f<1||b<20){return}e.setWidth(c);if(a<=c){e.dom.scrollLeft=0;if(this.scrolling){this.scrolling=false;this.el.removeClass("x-pathbuttons-scrolling");this.scrollLeft.hide();this.scrollRight.hide()}}else{if(!this.scrolling){this.el.addClass("x-pathbuttons-scrolling")}c-=e.getMargins("lr");e.setWidth(c>20?c:20);if(!this.scrolling){if(!this.scrollLeft){this.createScrollers()}else{this.scrollLeft.show();this.scrollRight.show()}}this.scrolling=true;if(g>(a-c)){e.dom.scrollLeft=a-c}else{this.scrollToButton(this.activeButton,false)}this.updateScrollButtons()}},createScrollers:function(){var c=this.el.dom.offsetHeight;var a=this.el.insertFirst({cls:"ux-pathbuttons-scroller-left"});a.setHeight(c);a.addClassOnOver("over");this.leftRepeater=new Ext.util.ClickRepeater(a,{interval:this.scrollRepeatInterval,handler:this.onScrollLeft,scope:this});this.scrollLeft=a;var b=this.el.insertFirst({cls:"ux-pathbuttons-scroller-right"});b.setHeight(c);b.addClassOnOver("over");this.rightRepeater=new Ext.util.ClickRepeater(b,{interval:this.scrollRepeatInterval,handler:this.onScrollRight,scope:this});this.scrollRight=b},getScrollWidth:function(){return this.edge.getOffsetsTo(this.stripWrap)[0]+this.getScrollPos()},getScrollPos:function(){return parseInt(this.stripWrap.dom.scrollLeft,10)||0},getScrollArea:function(){return parseInt(this.stripWrap.dom.clientWidth,10)||0},getScrollAnim:function(){return{duration:this.scrollDuration,callback:this.updateScrollButtons,scope:this}},getScrollIncrement:function(){return(this.scrollIncrement||this.lastButtonWidth+2)},scrollToButton:function(e,a){if(!e.el.dom){return}e=e.el.dom.parentNode;if(!e){return}var c=e;var g=this.getScrollPos(),d=this.getScrollArea();var f=Ext.fly(c).getOffsetsTo(this.stripWrap)[0]+g;var b=f+c.offsetWidth;if(f<g){this.scrollTo(f,a)}else{if(b>(g+d)){this.scrollTo(b-d,a)}}},scrollTo:function(b,a){this.stripWrap.scrollTo("left",b,a?this.getScrollAnim():false);if(!a){this.updateScrollButtons()}},onScrollRight:function(){var a=this.getScrollWidth()-this.getScrollArea();var c=this.getScrollPos();var b=Math.min(a,c+this.getScrollIncrement());if(b!=c){this.scrollTo(b,this.animScroll)}},onScrollLeft:function(){var b=this.getScrollPos();var a=Math.max(0,b-this.getScrollIncrement());if(a!=b){this.scrollTo(a,this.animScroll)}},updateScrollButtons:function(){var a=this.getScrollPos();this.scrollLeft[a==0?"addClass":"removeClass"]("disabled");this.scrollRight[a>=(this.getScrollWidth()-this.getScrollArea())?"addClass":"removeClass"]("disabled")}});SYNO.SDS.VideoStation.PathBar.PathButton=function(a,b,f,k,n,j,m,d,g){var c=d?this.firstBtnCls:"";var l=g?this.lastBtnCls:"";var e=Ext.isFunction(j)?j:Ext.emptyFn;SYNO.SDS.VideoStation.PathBar.PathButton.superclass.constructor.call(this,{text:k,itemId:f,renderTo:b,tooltip:n,clickEvent:"mousedown",listeners:{click:{fn:e,scope:m||this}},template:new Ext.Template('<table cellspacing="0" class="x-btn '+c+" "+l+' {3}"><tbody><tr>','<td class="ux-pathbutton-left"></td>','<td class="ux-pathbutton-center"><em class="{5}" unselectable="on">','<button class="x-btn-text {2}" type="{1}">{0}</button>',"</em></td>",'<td class="ux-pathbutton-right"></td>',"</tr></tbody></table>")});if(d){this.setIconClass("syno-vs-home-icon")}};Ext.extend(SYNO.SDS.VideoStation.PathBar.PathButton,Ext.Button,{firstBtnCls:"x-first-btn",lastBtnCls:"x-last-btn",updateButton:function(e,d,f,c,b){var a=Ext.isFunction(f)?f:Ext.emptyFn;this.purgeListeners();this.mon(this,"click",a,c||this);this.setText(e);this.setTooltip(d);if(b){this.addClass(this.lastBtnCls)}else{this.removeClass(this.lastBtnCls)}}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.Main",{extend:"SYNO.ux.Panel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.Main",this);var b=this.fillConfig(a);this.callParent([b]);this.createPollingTask()},fillConfig:function(a){this.listPanel=new SYNO.SDS.VideoStation.ListPanel({itemId:"list",region:"west",baseCls:"vs-x-panel"});this.mainCardPanel=new SYNO.SDS.VideoStation.CardPanel({itemId:"grid",region:"center",baseCls:"vs-x-panel"});var b={border:false,layout:"border",cls:"syno-vs-panel",bodyCssClass:"syno-vs-panel-body",width:800,height:500,monitorResize:true,items:[this.listPanel,this.mainCardPanel]};Ext.apply(b,a);return b},launchSettingDialog:function(a){if(!_S("is_admin")){return}var b=new SYNO.SDS.VideoStation.SettingDialog();b.open(a)},launchProgramScheduleDialog:function(b,d){var c={id:b.itemId,title:b.text,type:b.type};var a=new SYNO.SDS.VideoStation.ProgramScheduleDialog({tunerInfo:c});a.open()},getActionMenu:function(){if(!this.actionMenu){this.actionMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[],listeners:{scope:this,beforeshow:this.onUpdateMenu}});this.addManagedComponent(this.actionMenu)}this.updateActionMenuItems();return this.actionMenu},updateActionMenuItems:function(){var a=[];this.actionMenu.removeAll(true);a.push({text:_VST("collection","title"),itemId:"collections",menu:this.getCollectionMenu(true),hideOnClick:false,cls:"syno-vs-action"});a.push({itemId:"edit_collection",handler:this.onEditCollection,text:_VST("collection","edit_collection"),hidden:true,scope:this});a.push({itemId:"delete_collection",handler:this.onDeleteCollection,text:_VST("collection","delete_collection"),hidden:true,scope:this});a.push({itemId:"remove_favorite_from_collection",handler:this.onRemoveFavoite,text:_VST("action","remove_favorite"),hidden:true,scope:this});a.push({itemId:"remove_watch_list_from_collection",handler:this.onRemoveWatchList,text:_VST("action","remove_watch_list"),hidden:true,scope:this});Ext.each(SYNO.SDS.VideoStation.gData.collections,function(d,b,c){if(d.title!=="syno_favorite"&&d.title!=="syno_watchlist"){a.push({itemId:d.id+"_remove_"+d.title+"from_collection",handler:this.onRemoveFromUserDefCollection,text:String.format(_VST("collection","remove_from_colection"),d.title),hidden:true,scope:this})}},this);a.push({xtype:"menuseparator",itemId:"sep_collection"});a=a.concat(this.getMetaActionGroup().getArray());a.push({xtype:"menuseparator",itemId:"sep_meta"});a=a.concat(this.getTranscodeActionGroup().getArray());a.push({xtype:"menuseparator",itemId:"sep_trans"});a=a.concat(this.getPlayViewActionGroup().getArray());Ext.each(a,function(d,b,c){this.actionMenu.addItem(d)},this)},getCollectionMenu:function(a){if(this.collectionMenu){this.collectionMenu.destroy()}if(!this.collectionMenu||a){this.collectionMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[],listeners:{scope:this,beforeshow:this.onUpdateCollectionMenu}});this.addManagedComponent(this.collectionMenu)}this.updateCollectionsMenuitems();return this.collectionMenu},updateCollectionsMenuitems:function(){var b=[];this.collectionMenu.removeAll(true);var a={itemId:"creat_collection_list",handler:this.launchCreatCollectionList,text:_VST("collection","new_collection"),disabled:_S("demo_mode"),scope:this};b=b.concat(a);b.push({xtype:"menuseparator",itemId:"sep_newcollection"});b.push({itemId:"add_favorite_from_menu",handler:this.onMenuAddFavoite,text:_VST("collection","favorite"),disabled:_S("demo_mode"),hideOnClick:false,scope:this});b.push({itemId:"remove_favorite_from_menu",handler:this.onMenuRemoveFavoite,text:_VST("collection","favorite"),disabled:_S("demo_mode"),hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:this});b.push({itemId:"add_watch_list_from_menu",handler:this.onMenuAddWatchList,text:_VST("collection","watchlist"),disabled:_S("demo_mode"),hideOnClick:false,scope:this});b.push({itemId:"remove_watch_list_from_menu",handler:this.onMenuRemoveWatchList,text:_VST("collection","watchlist"),disabled:_S("demo_mode"),hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:this});Ext.each(SYNO.SDS.VideoStation.gData.collections,function(e,c,d){if(e.title!=="syno_favorite"&&e.title!=="syno_watchlist"){b.push({itemId:e.id+"_add_"+e.title,handler:this.onMenuAddToUserDefCollection,text:e.title,hideOnClick:false,scope:this});b.push({itemId:e.id+"_remove_"+e.title,handler:this.onMenuRemoveFromUserDefCollection,hidden:true,text:e.title,hidden:true,hideOnClick:false,iconCls:"syno-vs-collection-menu-item",scope:this})}},this);Ext.each(b,function(e,c,d){this.collectionMenu.addItem(e)},this)},launchCreatCollectionList:function(){var b={},g,d;var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var e=this.onGetSelectedData();var a={create:true};if(f&&f.subtype&&"detail"!==f.subtype&&SYNO.SDS.VideoStation.Util._COLLECTION_ID!==f.type){if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){additional=e.get("additional");g=additional.metadata.id;d=f.type}else{g=e.get("id");d=e.get("type")}if(g){Ext.apply(b,{video_id:g})}if(d){Ext.apply(b,{video_type:d})}Ext.apply(a,{mainVideoOption:b})}var c=new SYNO.SDS.VideoStation.NewEditCollectionDialog(a);c.open()},onUpdateCollectionMenu:function(a){SYNO.SDS.VideoStation.Util.getCurrentCollection(this)},onUpdateMenu:function(a){var k=SYNO.SDS.VideoStation.Util;var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var c=b.getHistoryInfo();var j=false;var d=false;var f=false;var e=false;var m=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();var g=m.getSelectionCount?m.getSelectionCount()>1:false;var l=SYNO.SDS.VideoStation.Util._getCurLibraryType();switch(l){case k._MOVIE_ID:switch(c.subtype){case"root":case"classes":break;case"list":case"search":case"detail":d=_S("is_admin");e=true;j=true;break;case"listdir":if(c.status&&c.status.selected_id&&-1!==c.status.selected_id.indexOf("/")){e=true}else{j=true;e=true}break}break;case k._TVSHOW_ID:switch(c.subtype){case"root":case"classes":break;case"list":case"search":d=_S("is_admin");break;case"tvshow_episode":if(m.getSelectionCount&&m.getSelectionCount()){d=_S("is_admin");e=true;j=true}break;case"detail":d=_S("is_admin");e=true;j=true;break;case"listdir":if(c.status&&c.status.selected_id&&-1!==c.status.selected_id.indexOf("/")){e=true}else{j=true;e=true}break}break;case k._HOME_VIDEO_ID:switch(c.subtype){case"root":case"classes":break;case"list":case"search":case"detail":case"home_video":d=_S("is_admin");e=true;j=true;break;case"listdir":if(c.status&&c.status.selected_id&&-1!==c.status.selected_id.indexOf("/")){e=true}else{j=true;e=true}break}break;case k._TV_RECORDER_ID:switch(c.index){case 0:case 1:break;case 2:case 3:case 4:d=_S("is_admin");e=true;j=true;break}break;case k._COLLECTION_ID:switch(c.index){case 0:break;case 1:if(m.getSelectionModel().getCount()>1){d=false;e=false}else{d=_S("is_admin");e=true}break;case 2:case 3:d=_S("is_admin");e=true;break}break}if(!j||g){a.items.items[0].hide()}else{a.items.items[0].show()}this.getMetaActionGroup()[!d?"hideAll":"showAll"]();if(_S("is_admin")){var n=((m.getFiles&&!Ext.isEmpty(m.getFiles)&&m.getFiles().length>1));this.getMetaActionGroup().get("correct_metadata")[n?"show":"hide"]()}this.getTranscodeActionGroup()[!f||g?"hideAll":"showAll"]();this.getPlayViewActionGroup()[!e||g?"hideAll":"showAll"]();this.getPlayViewActionGroup().get("view_photos").hide();if((l===k._MOVIE_ID||l===k._TVSHOW_ID||l===k._HOME_VIDEO_ID)&&"listdir"===c.subtype){if(c.status&&c.status.selected_id&&-1!==c.status.selected_id.indexOf("/")){this.getPlayViewActionGroup().get("play").hide();this.getPlayViewActionGroup().get("view_video_info").hide()}else{if(_S("is_admin")){this.getMetaActionGroup().get("correct_metadata").show()}}}if(c.id===k._COLLECTION_ID){this.onUpdateRemoveCollection(m,c)}else{this.onUpdateRemoveCollection(m,c)}this.onUpdateSepItem(a)},onUpdateRemoveCollection:function(a,f){var b,d;if(a.getCollectionId){d=a.getCollectionId()}var e=this.actionMenu.items.items;for(var c=0;c<e.length;c++){b=-1;if(-1===e[c].itemId.indexOf("remove_")&&"edit_collection"!==e[c].itemId&&"delete_collection"!==e[c].itemId){continue}if(f.id!==SYNO.SDS.VideoStation.Util._COLLECTION_ID){e[c].hide();continue}b=e[c].itemId.indexOf("_remove_");b=(-1!==b)?e[c].itemId.substring(0,b):-1;if(-1===d&&"remove_favorite_from_collection"===e[c].itemId){e[c].show()}else{if(-2===d&&"remove_watch_list_from_collection"===e[c].itemId){e[c].show()}else{if(-1!==b&&b===d){e[c].show()}else{if(0===f.index&&("edit_collection"===e[c].itemId||"delete_collection"===e[c].itemId)){e[c].show()}else{e[c].hide()}}}}}},onUpdateSepItem:function(e){var a=0,b=0,d=false,c=null;e.items.each(function(f){if(f.itemId.substr(0,3)==="sep"){f.show()}});e.items.each(function(f){if(!f.hidden){a++;if(f.itemId.substr(0,3)==="sep"){b++;if(1===a||2<=b){f.hide()}else{f.show();c=f;d=true}}else{d=false;b=0}}},this);if(d){c.hide()}},getTunerMenu:function(){if(!this.tunerMenu){this.tunerMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[]});this.addManagedComponent(this.tunerMenu)}return this.tunerMenu},updateScheduleMenuItems:function(c){var b=[];this.tunerMenu.removeAll(true);var a={FE_QPSK:0,FE_QAM:1,FE_OFDM:2,FE_ATSC:3};Ext.each(c,function(f,d,e){if((a.FE_QPSK==f.type)&&(_S("version")<3731)&&(-1!==_D("unique").indexOf("x86")||-1!==_D("unique").indexOf("cedarview")||-1!==_D("unique").indexOf("bromolow"))){return}b.push({itemId:f.id,handler:this.launchProgramScheduleDialog,text:f.title,type:f.type,scope:this})},this);Ext.each(b,function(f,d,e){this.tunerMenu.addItem(f)},this)},getSearchMenu:function(){if(this.searchMenu){return this.searchMenu}this.searchMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",enableScrolling:false,defaults:{checked:false,group:"searchCate",scope:this},items:[{text:_VST("classification","all"),checked:true,categoryValue:"all",handler:this.setSearchCategory.createDelegate(this,["all"])},{text:_VST("actor","title"),categoryValue:"actor",handler:this.setSearchCategory.createDelegate(this,["actor"])},{text:_VST("director","title"),categoryValue:"director",handler:this.setSearchCategory.createDelegate(this,["director"])},{text:_VST("genre","title"),categoryValue:"genre",handler:this.setSearchCategory.createDelegate(this,["genre"])},{text:_VST("writer","title"),categoryValue:"writer",handler:this.setSearchCategory.createDelegate(this,["writer"])},{text:_VST("schedule","channel"),hidden:true,categoryValue:"channelname",handler:this.setSearchCategory.createDelegate(this,["channelname"])},{text:_VST("programguide","title"),hidden:true,categoryValue:"title",handler:this.setSearchCategory.createDelegate(this,["title"])}],listeners:{scope:this,beforeshow:function(a){Ext.each(a.items.items,function(b){if(b.categoryValue==SYNO.SDS.VideoStation.Util.SEARCH_HISTORY[this._getCurId()]){b.getEl().parent().addClass("x-menu-item-checked")}else{b.getEl().parent().removeClass("x-menu-item-checked")}},this)}}});this.addManagedComponent(this.searchMenu);return this.searchMenu},setSearchCategory:function(a){SYNO.SDS.VideoStation.Util.SEARCH_HISTORY[this._getCurId()]=a},getTBar:function(){if(this.toolbar){return this.toolbar}var a=[{text:_VST("action","start"),itemId:"action",menu:this.getActionMenu(),cls:"syno-vs-action"},{text:_VST("action","settings"),itemId:"settings",hidden:!_S("is_admin"),handler:function(){this.launchSettingDialog(0)},scope:this},{text:_VST("dtv","title"),itemId:"digitaltv",hidden:true,menu:this.getTunerMenu(),cls:"syno-vs-action"},"->",{cls:"syno-vs-sort-btn",tooltip:_VST("action","sort"),itemId:"sort",getMenuClass:Ext.emptyFn,disabled:true,menu:(this.sortMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:[{itemId:"item_title",text:String.format(_VST("sort","sort_by"),_VST("common","title")),iconCls:"syno-vs-tbar-sel-sort",listeners:{click:{fn:function(c){this.onChangeSortItem(c)},scope:this}}},{itemId:"item_date",text:String.format(_VST("sort","sort_by"),_VST("date","title")),listeners:{click:{fn:function(c){this.onChangeSortItem(c)},scope:this}}},"-",{itemId:"order_asc",text:_VST("sort","order_asc"),iconCls:"syno-vs-tbar-sel-sort",listeners:{click:{fn:function(c){this.onChangeSortOrder(c)},scope:this}}},{itemId:"order_desc",text:_VST("sort","order_desc"),listeners:{click:{fn:function(c){this.onChangeSortOrder(c)},scope:this}}}],listeners:{scope:this,beforeshow:function(){var c=SYNO.SDS.VideoStation.Util._getHistoryInfo().status;var d;if("desc"===c.sort_direction){d="order_desc"}else{d="order_asc"}this.onChangeSortOrder(this.sortMenu.items.get(d),true);switch(c.sort_by){case"original_available":case"record_date":d="item_date";break;default:d="item_title";break}this.onChangeSortItem(this.sortMenu.items.get(d),true)}}})),listeners:{render:{single:true,buffer:80,scope:this,fn:function(c){this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"beforeactivate",function(f,d,e){if(e.layoutCfg==="SYNO.SDS.VideoStation.ViewMetaData"||e.layoutCfg==="SYNO.SDS.VideoStation.ViewGrid"||(e.type==="tvshow_episode")||e.type==="collection"||(e.params&&"recently_added"===e.params.category)||(e.params&&"recently_watched"===e.params.category)||(e.params&&"folder"===e.params.category)){c.disable()}else{c.enable()}},this)}}}},{cls:"syno-vs-expand-btn",tooltip:_VST("action","expand_seasons")+" / "+_VST("action","collapse_seasons"),itemId:"expand",hidden:true,getMenuClass:Ext.emptyFn,menu:(this.expaneMenu=new SYNO.ux.Menu({cls:"syno-vs-menu",items:this.getSeasonActionGroup().getArray(),listeners:{scope:this,beforeshow:this.onShowHideSeason}}))}];var b=new SYNO.ux.Toolbar({cls:"syno-vs-toolbar",items:a,listeners:{scope:this,render:{single:true,buffer:80,scope:this,fn:function(){this.mon(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr"),"beforeactivate",function(f,c,e){if("tv_record"===e.type&&SYNO.SDS.VideoStation.Util.ableToControlDTV()){this.digitaltvbtn.show()}else{this.digitaltvbtn.hide()}var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var g=d.getHistoryInfo();b.getComponent("expand").setVisible(("tvshow_episode"===d.getCurType()&&g&&g.index===4))},this)}}}});this.digitaltvbtn=b.getComponent("digitaltv");this.toolbar=b;return this.toolbar},getParamSortBy:function(b){var a=b?"item_title":(this.sort_item||"item_title");switch(a){case"item_title":return"title";case"item_date":switch(SYNO.SDS.VideoStation.Util._getHistoryInfo().type){case"home_video":case"tv_record":return"record_date";default:return"original_available"}default:return"title"}},getParamSortOrder:function(b){var a=b?"order_asc":(this.sort_order||"order_asc");switch(a){case"order_asc":return"asc";case"order_desc":return"desc";default:return"asc"}},onChangeSortItem:function(c,b){var a=c.itemId;if(this.sort_item!=a){this.sort_item=a;c.parentMenu.items.each(function(d){if(d.itemId===a){d.setIconClass("syno-vs-tbar-sel-sort")}else{if(d.itemId&&d.itemId.substr(0,5)==="item_"){d.setIconClass(undefined)}}});if(true!==b){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewListDavaview").onLoadStore()}}},onChangeSortOrder:function(c,b){var a=c.itemId;if(this.sort_order!=a){this.sort_order=a;c.parentMenu.items.each(function(d){if(d.itemId===a){d.setIconClass("syno-vs-tbar-sel-sort")}else{if(d.itemId&&d.itemId.substr(0,6)==="order_"){d.setIconClass(undefined)}}});if(true!==b){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewListDavaview").onLoadStore()}}},getMetaActionGroup:function(){if(this.metaAction){return this.metaAction}var b=SYNO.SDS.VideoStation.Util;var a=b._createAction({hidden:!_S("is_admin"),itemId:"edit_metadata",handler:function(){this.onEditMetaData()},scope:this});var c=b._createAction({hidden:!_S("is_admin"),itemId:"correct_metadata",handler:function(){this.onEditMetaData(true)},scope:this});return(this.metaAction=new SYNO.SDS.Utils.ActionGroup([a,c]))},onEditMetaData:function(d){var e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var c=e.getHistoryInfo();var l=e.getActiveItem();var a,k,g,f;k=this.onGetSelectedDatas();if(k.length===0){return}g=k[0];if(g){if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){var b=g.get("additional");a=b.metadata.id;f=g}else{if(!g.get){g=g[0]}a=g.get("id")}if(g.get("type")&&!SYNO.SDS.VideoStation.Util._checkIsByfolder()){c.params=c.params||{};Ext.apply(c.params,{id:g.get("id"),type:g.get("type")})}}else{if(l&&this._getHistoryInfo().params){a=this._getHistoryInfo().params.id}}if(!a){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}var j=this._getHistoryInfo().type;if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===j){if(!g){j=this._getHistoryInfo().params.type}else{j=g.get("type")}}if(d&&"detail"===c.subtype){g=l.getSelectedFile();f=g}if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID===j){this.dialogDTVMetaData=new SYNO.SDS.VideoStation.DTVMetaDataDialog();this.dialogDTVMetaData.show(a)}else{if(SYNO.SDS.VideoStation.Util._MOVIE_ID===j){this.dialogMovieMetaData=new SYNO.SDS.VideoStation.MetaDataDialog();if(1==k.length){this.dialogMovieMetaData.onLoad(a,f)}else{this.dialogMovieMetaData.onLoads(k)}}else{if(SYNO.SDS.VideoStation.Util._TVSHOW_ID===j){this.dialogTVShowMetaData=new SYNO.SDS.VideoStation.MetaDataDialog();if(1==k.length){this.dialogTVShowMetaData.onLoad(a,f)}else{this.dialogTVShowMetaData.onLoads(k)}}else{if(SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID===j){this.dialogTVShowEpisodeMetaData=new SYNO.SDS.VideoStation.MetaDataDialog();if(1==k.length){this.dialogTVShowEpisodeMetaData.onLoad(a,f)}else{this.dialogTVShowEpisodeMetaData.onLoads(k)}}else{if(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===j){this.dialogHomeVideoMetaData=new SYNO.SDS.VideoStation.MetaDataDialog();if(1==k.length){this.dialogHomeVideoMetaData.onLoad(a,f)}else{this.dialogHomeVideoMetaData.onLoads(k)}}}}}}},getSeasonActionGroup:function(){if(this.seasonAction){return this.seasonAction}var a=SYNO.SDS.VideoStation.Util;var b=a._createAction({itemId:"collapse_seasons",handler:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewTVseason").onExpandCollapseSeasons(false)},scope:this});var c=a._createAction({itemId:"expand_seasons",handler:function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewTVseason").onExpandCollapseSeasons(true)},scope:this});return(this.seasonAction=new SYNO.SDS.Utils.ActionGroup([b,c]))},getTranscodeActionGroup:function(){if(this.transcodeAction){return this.transcodeAction}var a=SYNO.SDS.VideoStation.Util;var b=a._createAction({itemId:"offline_transcoding",handler:function(){},scope:this});return(this.transcodeAction=new SYNO.SDS.Utils.ActionGroup([b]))},onGetSelectedDatas:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();var b=[];if(a.getSelectedDatas){b=a.getSelectedDatas()}else{b=[this.onGetSelectedData()]}return b},onGetSelectedData:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();var b;if(a.getSelectedData){b=a.getSelectedData()}else{if(a.onGetSelectedData){b=a.onGetSelectedData()}else{if(a.dataView){b=a.dataView.getSelectedRecords()[0]}}}return b},onGetSelectedFile:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();if(a.getSelectedFile){return a.getSelectedFile()}},onCheckIsFolderChoose:function(){var a=this.onGetSelectedData();if(a&&a.get("sharepath")){return a}},getPlayViewActionGroup:function(){if(this.playviewAction){return this.playviewAction}var b=SYNO.SDS.VideoStation.Util;var f=b._createAction({itemId:"play",handler:function(){var g;if((g=this.onGetSelectedFile())){SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),g.data,SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo())}else{this.onLoadMetaData(function(k){var j=Ext.apply(SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo(),{videoID:k.id});if(k.additional.files.length===1){var m=k.additional.files[0];SYNO.SDS.VideoStation.Util.onPlayAction(this._getOwner(),m,j)}else{var l=new SYNO.SDS.VideoStation.VideoListDialog();l.playAdditionalInfo=j;l.onLoadData(k.additional.files)}})}},scope:this});var e=b._createAction({itemId:"open_folder",handler:function(){var g;if((g=this.onGetSelectedFile())){SYNO.SDS.VideoStation.Util.onOpenContainingFolder(g.get("sharepath"))}else{if(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&(g=this.onCheckIsFolderChoose())){SYNO.SDS.VideoStation.Util.onOpenContainingFolder(g.get("sharepath"))}else{this.onLoadMetaData(function(j){if(j.additional.files.length===1){SYNO.SDS.VideoStation.Util.onOpenContainingFolder(j.additional.files[0].sharepath)}else{var k=new SYNO.SDS.VideoStation.VideoListDialog();k.onLoadData(j.additional.files)}})}}},scope:this});var d=b._createAction({itemId:"view_photos",handler:function(){},scope:this});var c=b._createAction({itemId:"view_video_info",handler:function(){var j;if((j=this.onGetSelectedFile())){var g=new SYNO.SDS.VideoStation.VideoInfoDialog();g.onLoad(j)}else{this.onLoadMetaData(function(k){var l;if(k.additional.files.length===1){var m=new Ext.data.Record(k.additional.files[0]);l=new SYNO.SDS.VideoStation.VideoInfoDialog();l.onLoad(m)}else{l=new SYNO.SDS.VideoStation.VideoListDialog();l.onLoadData(k.additional.files)}})}},scope:this});var a=[f];if(!_S("standalone")&&SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.App.FileStation3.Instance")){a.push(e)}a.push(d,c);return(this.playviewAction=new SYNO.SDS.Utils.ActionGroup(a))},sendVideoAjaxRequest:function(b,a){if(b.method===this.load_apimethod){this.owner.setStatusBusy()}else{this.owner.setStatusBusy({text:_T("common","saving")})}SYNO.API.currentManager.requestAPI(b.api,b.method||"getinfo",b.version||1,a,this.onRequestDone,this)},updateAllComponents:function(){if(this.isDestroyed){this.pollingTask.stop();return}var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.SearchField");var e=this.getTBar().getComponent("action");e.enable();var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").layout.activeItem;var g;var a=d.dataView;var f=this._getHistoryInfo();var c=SYNO.SDS.VideoStation.Util._getCurLibraryType();if(c===SYNO.SDS.VideoStation.Util._TVSHOW_ID&&(f.index===2||f.index===3)&&(!_S("is_admin"))){e.disable()}else{if(d.getSelectionCount){if(0===d.getSelectionCount()||!d.hasSeasons()){e.disable()}}else{if(a&&a.getSelectionCount){if(!a.getSelectionCount()){e.disable()}}else{if(d.getSelectionModel&&!d.getSelectionModel().getSelected()){e.disable()}else{switch(c){case SYNO.SDS.VideoStation.Util._MOVIE_ID:case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:case SYNO.SDS.VideoStation.Util._TVSHOW_ID:switch(f.index){case 0:case 1:e.disable();break}break;case SYNO.SDS.VideoStation.Util._COLLECTION_ID:if(0===f.index){b.reset()}break}}}}}},createPollingTask:function(){this.pollingTask=this.addTask({interval:800,scope:this,run:this.updateAllComponents}).start()},onLoadMetaData:function(j){var f=this.onGetSelectedData();if(!f){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}this._getOwner().setStatusBusy();var g,d;if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){var a=f.get("additional");g=a.metadata.id;d=SYNO.SDS.VideoStation.Util._getCurLibraryType()}else{if(!f.get){f=f[0]}g=f.get("id");d=f.get("type")||SYNO.SDS.VideoStation.Util._getCurLibraryType()}var b={id:g,additional:"files"};if(f.get("type")&&!SYNO.SDS.VideoStation.Util._checkIsByfolder()){var e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();e.params=e.params||{};Ext.apply(e.params,{id:f.get("id"),type:f.get("type")})}var c=SYNO.SDS.VideoStation.Util.getinfo_WebAPI(d);SYNO.API.currentManager.requestAPI(c.api,c.method||"getinfo",c.version||1,b,function(k,m,l){this.onLoadMetaDataCallBack(k,m,l,j)},this)},onLoadMetaDataCallBack:function(l,g,j,o){if(this.isDestroyed){return}this._getOwner().clearStatusBusy();if(!l){var e=this._getOwner().getMsgBox().alert(this._getOwner().title,SYNO.SDS.VideoStation.Util.getWebAPIErr(l,g,j));return}if(g){var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var d=f.params?(f.params.type||f.id):f.id;d=(d==="tvshow_episode")?"tvshow":d;var n=f.response_root;if(!n){var k=SYNO.SDS.VideoStation.Util.SEC_CFG[d];n=k.data[k.data.length-1].response_root}var a=(g[n]);if(a&&!Ext.isEmpty(a)&&(data=a[0])&&(data&&data.additional&&Ext.isArray(data.additional.files))){var c=data;if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){var m=this.onGetSelectedData();var q=m.get("path");var b="";Ext.each(data.additional.files,function(s){if(q===s.path){b=s}},this);if(""!==b){data.additional.files=[b]}}if(Ext.isFunction(o)){o.call(this,data)}}else{this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("error","no_data"));var p=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();p.onActivate(false);return}}},onMenuAddFavoite:function(){var a={id:-1};this.onRequestCollection("addvideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onAddFavoite:function(){var a={id:-1};this.onRequestCollection("addvideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onMenuAddWatchList:function(){var a={id:-2};this.onRequestCollection("addvideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onAddWatchList:function(){var a={id:-2};this.onRequestCollection("addvideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"addvideo",a)},this)},onMenuAddToUserDefCollection:function(c,d){var k,j;if(c.itemId){j=c.itemId.indexOf("_add");k=c.itemId.substring(0,j)}var b={id:k};var g=this.onGetSelectedData();var a,f;if(g&&(!Ext.isEmpty(a=g.get("additional"))||(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&!Ext.isEmpty(a=g.data.additional)))){if(!Ext.isArray(a.collection)){a.collection=[]}f=a.collection;f.push({id:c.itemId,title:c.text})}this.onRequestCollection("addvideo",true,b,function(e,m,l){this.onRequestCollectionCallBack(e,m,l,"addvideo",b)},this)},onMenuRemoveFavoite:function(){var a={id:-1};this.onRequestCollection("deletevideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRemoveFavoite:function(){var a={id:-1};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onMenuRemoveWatchList:function(){var a={id:-2};this.onRequestCollection("deletevideo",true,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onRemoveWatchList:function(){var a={id:-2};this.onRequestCollection("deletevideo",false,a,function(b,d,c){this.onRequestCollectionCallBack(b,d,c,"deletevideo",a)},this)},onMenuRemoveFromUserDefCollection:function(l,j){var a,k;if(l.itemId){k=l.itemId.indexOf("_remove");a=l.itemId.substring(0,k)}var m={id:a};var c=this.onGetSelectedData();var b,f,g;if(c&&((!Ext.isEmpty((b=c.get("additional")))&&!Ext.isEmpty((f=b.collection)))||(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&!Ext.isEmpty((b=c.data.additional))&&!Ext.isEmpty((f=b.collection))))){g=(l&&l.text)?l.text:"";for(var d=0;d<f.length;d++){if(f[d].title===g){f.splice(d,1);break}}}this.onRequestCollection("deletevideo",true,m,function(e,o,n){this.onRequestCollectionCallBack(e,o,n,"deletevideo",m)},this)},onRemoveFromUserDefCollection:function(b,c){var f,d;if(b.itemId){d=b.itemId.indexOf("_remove");f=b.itemId.substring(0,d)}var a={id:f};this.onRequestCollection("deletevideo",false,a,function(e,j,g){this.onRequestCollectionCallBack(e,j,g,"deletevideo",a)},this)},onDeleteCollection:function(){var a,c=-1;var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewGrid");if(d.getSelectionModel()){a=d.getSelectionModel().getSelected()}if(a){c=a.data.id}var b={id:c};this._getOwner().getMsgBox().confirm(_VST("collection","title"),_VST("collection","delete_collection_alert"),function(e,f){if(e==="yes"){this.onRequestCollection("delete",false,b,function(g,k,j){this.onRequestCollectionCallBack(g,k,j,"delete",b)},this)}else{return false}},this)},onEditCollection:function(){var a,d=-1,c;var e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewGrid");if(e.getSelectionModel()){a=e.getSelectionModel().getSelected()}if(a){d=a.data.id;c=a.data.name}var b=new SYNO.SDS.VideoStation.NewEditCollectionDialog({create:false,collectionTitle:c,collectionID:d});b.open()},onSetCollectionMenuToDefault:function(){this.onSetCollectionMenuIcon(-1,"",false);this.onSetCollectionMenuIcon(-2,"",false);Ext.each(this.collectionMenu.items.items,function(a,b,c){if("add_favorite_from_menu"!==a.itemId&&"remove_favorite_from_menu"!==a.itemId&&"add_watch_list_from_menu"!==a.itemId&&"remove_watch_list_from_menu"!==a.itemId){if(0<a.itemId.indexOf("_remove_")&&0>a.itemId.indexOf("_add_")){a.hide()}else{a.show()}}},this)},onSetCollectionMenuIcon:function(b,d,a){var c="";Ext.each(this.collectionMenu.items.items,function(g,e,f){if(-1===b||"syno_favorite"===d){if("add_favorite_from_menu"===g.itemId){if(a){g.hide()}else{g.show()}return}else{if("remove_favorite_from_menu"===g.itemId){if(a){g.show()}else{g.hide()}return}}}else{if(-2===b||"syno_watchlist"===d){if("add_watch_list_from_menu"===g.itemId){if(a){g.hide()}else{g.show()}return}else{if("remove_watch_list_from_menu"===g.itemId){if(a){g.show()}else{g.hide()}return}}}else{c=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(g.itemId,"_add");if(""!==c&&parseInt(c,10)===parseInt(b,10)){if(a){g.hide()}else{g.show()}}c=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(g.itemId,"_remove");if(""!==c&&parseInt(c,10)===parseInt(b,10)){if(a){g.show()}else{g.hide()}}}}},this)},onRequestCollection:function(a,e,m,k,l){var g,b,f,d;var j=[];var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();if(a==="deletevideo"){g=this.onGetSelectedDatas();g=g[0]}else{g=this.onGetSelectedData()}if(g){if(a==="deletevideo"){if(SYNO.SDS.VideoStation.Util._COLLECTION_ID!==this._getCurId()){f=g.get("type");if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){d=g.get("additional");b=d.metadata.id;f=c.type}else{if("tvshow"===this._getCurType()&&c.params){b=c.params.id}else{b=g.get("id")}}if(b){Ext.apply(m,{video_id:b})}if(f){Ext.apply(m,{video_type:f})}}else{if(Ext.isDefined(g[0])){g.each(function(p,n,o){j[n]={video_id:p.get("id"),video_type:p.get("type")?p.get("type"):c.type}},this)}Ext.apply(m,{video_collections:Ext.encode(j),video_id:"",video_type:""})}}else{if(SYNO.SDS.VideoStation.Util._checkIsByfolder()){d=g.get("additional");b=d.metadata.id;f=c.type}else{b=g.get("id");f=g.get("type")}if(b){Ext.apply(m,{video_id:b})}if(f){Ext.apply(m,{video_type:f})}}}if(e){if(a==="deletevideo"){this.onSetCollectionMenuIcon(m.id,"",false)}else{if(a==="addvideo"){this.onSetCollectionMenuIcon(m.id,"",true)}}}if(e){SYNO.SDS.VideoStation.Util.onRequestCollectionNoMesg.call(this,a,m,k,l)}else{SYNO.SDS.VideoStation.Util.onRequestCollection.call(this,a,m,k,l)}},onRequestCollectionCallBack:function(j,c,f,a,m){SYNO.SDS.VideoStation.Util.onRequestCollectionCallBack.apply(this,arguments);var d,b;if(a==="deletevideo"){d=this.onGetSelectedDatas();if(d){d=d[0];if(d&&d[0]){d=d[0]}}}else{d=this.onGetSelectedData()}var k=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var l=k.getActiveItem();if(!d||(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&Ext.isEmpty((b=d.data.additional)))||Ext.isEmpty((b=d.get("additional")))){if("delete"===a){this.updateDeleteCollection(m.id)}l.onActivate();return}if(!Ext.isArray(b.collection)){b.collection=[]}collection=b.collection;switch(a){case"addvideo":if(-1===m.id){collection.push({title:"syno_favorite"})}else{if(-2===m.id){collection.push({title:"syno_watchlist"})}}break;case"deletevideo":var g;if(-1===m.id){g="syno_favorite"}else{if(-2===m.id){g="syno_watchlist"}}if(g){for(var e=0;e<collection.length;e++){if(collection[e].title===g){collection.splice(e,1);break}}}if(SYNO.SDS.VideoStation.Util._COLLECTION_ID===k.curID){l.onActivate()}break;default:l.onActivate();break}},updateDeleteCollection:function(c){for(var b=0;b<SYNO.SDS.VideoStation.gData.collections.length;b++){if(parseInt(c,10)===parseInt(SYNO.SDS.VideoStation.gData.collections[b].id,10)){SYNO.SDS.VideoStation.gData.collections.splice(b,1)}}var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData");a.updateCollectionsMenuitems();this.updateCollectionsMenuitems();this.updateActionMenuItems()},onShowHideCollection:function(){var f=this.onGetSelectedData();var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr");var b=c.getActiveItem();var d=c.getHistoryInfo();var j,g="";if(b.hasFavorite&&b.hasWatchList&&b.hasUserCollection){if(b.hasFavorite()){this.onSetCollectionMenuIcon(-1,"",true)}else{this.onSetCollectionMenuIcon(-1,"",false)}if(b.hasWatchList()){this.onSetCollectionMenuIcon(-2,"",true)}else{this.onSetCollectionMenuIcon(-2,"",false)}if(b.currentAddCollection){Ext.each(b.currentAddCollection,function(k){if(k.title==="syno_favorite"||k.title==="syno_watchlist"){return}this.onSetCollectionMenuIcon(k.id,k.title,true)},this)}else{Ext.each(b.hasUserCollection().items.items,function(m,k,l){if("creat_collection_list"===m.itemId||"sep_newcollection"===m.itemId){return}g=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(m.itemId,"_add");if(""!==g){this.onSetCollectionMenuIcon(g,m.itemId,!m.hidden)}g=SYNO.SDS.VideoStation.Util.onGetUserDefineCollectionID(m.itemId,"_remove");if(""!==g){this.onSetCollectionMenuIcon(g,m.itemId,!m.hidden)}},this)}return}this.onSetCollectionMenuToDefault();var a,e;if(f&&((!Ext.isEmpty((a=f.get("additional")))&&!Ext.isEmpty((e=a.collection)))||(SYNO.SDS.VideoStation.Util._checkIsByfolder()&&!Ext.isEmpty((a=f.data.additional))&&!Ext.isEmpty((e=a.collection))))){if(Ext.isArray(e)){Ext.each(e,function(k){this.onSetCollectionMenuIcon(k.id,k.title,true)},this)}}},onShowHideSeason:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();if(a.hasSeasons()){this.getSeasonActionGroup().get("collapse_seasons")[a.isOneExpandSeason()?"show":"hide"]();this.getSeasonActionGroup().get("expand_seasons")[a.isOneCollapseSeason()?"show":"hide"]()}else{this.getSeasonActionGroup().hideAll()}}});Ext.define("SYNO.SDS.VideoStation.ListDataView",{statics:{ViewWidth:180},extend:"SYNO.ux.FleXcroll.DataView",constructor:function(b){this.desc_key=b.desc_key||"";var a={cls:"syno-vs-dataview-list",itemSelector:"dl.list-template",trackOver:false,overClass:"over",hideHeaders:true,singleSelect:true,tpl:this.getListTpl(b.getItemClass)};this.callParent([Ext.apply(a,b)])},getListTpl:function(c){var b=[];Ext.each(this.cls_key,function(e){b.push("{"+e+"}")});var d=c||Ext.emptyFn;var a=new Ext.XTemplate('<tpl for=".">','<dl class="list-template">','<dt class="{[this.getItemClass(values)]}">','<div class="sds-ellipsis" ext:qtip="{[this.doubleEncode(values.'+this.desc_key+')]}">',"{"+this.desc_key+":htmlEncode}","</div>","</dt>","</dl>","</tpl>",'<div class="x-clear"></div>',{compiled:true,doubleEncode:function(e){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(e))},getItemClass:d.createDelegate(this)});return a}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.LibraryList",{extend:"SYNO.ux.Panel",DefaultLibrary:{title:_VST("library","default"),field:"category",id:0},Movie:{title:_VST("type","movie"),type:"movie",is_public:true,field:"item",id:-1},TVShow:{title:_VST("type","tv_show"),type:"tvshow",is_public:true,field:"item",id:-2},HomeVideo:{title:_VST("type","home_video"),type:"home_video",is_public:true,field:"item",id:-3},CustomLibrary:{title:_VST("library","custom"),field:"category",id:-4},constructor:function(a){this.module=a.module;this.defaultListItems=[new Ext.data.Record(this.DefaultLibrary),new Ext.data.Record(this.Movie),new Ext.data.Record(this.TVShow),new Ext.data.Record(this.HomeVideo),new Ext.data.Record(this.CustomLibrary)];this.callParent([this.fillConfig(a)])},fillConfig:function(b){this.dataview=new SYNO.SDS.VideoStation.ListDataView({desc_key:"title",store:this.getStore(),getItemClass:function(c){return c.field},listeners:{beforeclick:function(d,e,f,c){var g=d.getRecord(f);return("category"===g.get("field"))?false:true},selectionchange:{buffer:100,scope:this,fn:this.onListSelect},dblclick:this.module.openLibraryEditDialog.createDelegate(this.module,["edit"])}});var a={width:SYNO.SDS.VideoStation.ListDataView.ViewWidth,layout:"fit",cls:"syno-vs-library-list",items:this.dataview};return Ext.apply(a,b)},getStore:function(){if(this.store){return this.store}var a=new Ext.data.JsonStore({autoLoad:false,root:"data.libraries",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"title",type:"string"},{name:"id",type:"int"},{name:"type",type:"string"},{name:"is_public",type:"boolean",defaulValue:true},{name:"field",type:"string",defaultValue:"item"}],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL("library_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}}),listeners:{scope:this,load:this.onLibraryLoad}});return(this.store=a)},onListSelect:function(c,a){if(0===a.length){return}var b=this.dataview.getRecord(a[0]);var d={section:b.get("type")};if(b.get("id")>0){d.library_id=b.get("id")}this.module.folderGrid.reload(d);this.module.onChangeButtonStatus()},onLibraryLoad:function(b,a,c){this.module._getOwner().clearStatusBusy();this.getStore().insert(0,this.defaultListItems);var d;b.each(function(e){if("category"!==e.get("field")){d=e;return false}});if(Ext.isDefined(d)){this.dataview.select(d)}this.getStore().fireEvent("update")},getSelectedLibrary:function(){if(0>=this.dataview.getSelectionCount()){return null}var a=this.dataview.getSelectedRecords()[0];return{title:a.get("title"),type:a.get("type"),id:a.get("id"),is_public:a.get("is_public")}},getLibraryCount:function(){return Ext.max([0,this.getStore().getCount()-2])},getLibraryList:function(){var a=[];this.getStore().each(function(b){if("item"===b.get("field")){var c=Ext.copyTo({},b.data,["id","title","type","is_public"]);a.push(c)}});return a},reload:function(){this.module._getOwner().setStatusBusy({text:_T("common","loading")});this.getStore().load()}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.FolderGrid",{extend:"SYNO.ux.GridPanel",constructor:function(a){this.module=a.module;this.callParent([this.fillConfig(a)])},fillConfig:function(b){var a={stripeRows:true,cls:"syno-vs-folder-grid",itemId:"grid",border:false,store:this.getStore(),columns:this.getColumnModel(),selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{selectionchange:{fn:this.module.onChangeButtonStatus,buffer:50,scope:this.module}}}),listeners:{dblclick:this.module.openFolderEditDialog.createDelegate(this.module,["edit"])}};return Ext.apply(a,b)},getColumnModel:function(){if(this.colModel){return this.colModel}this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_T("common","folder"),dataIndex:"path",sortable:true,width:150,align:"left",renderer:function(g,a,d,f,k,j){var e=d.get("exist");var c=Ext.util.Format.htmlEncode(g);var b=e?Ext.util.Format.htmlEncode(c):_T("mediaservice","error_folder_not_exist");a.attr=String.format('ext:qtip="{0}"',b);return e?c:'<font color="red">'+c+"</font>"}},{header:_VST("common","status"),dataIndex:"status",width:50,renderer:function(f,b,a,g,d,c){if(f!=="indexing"){return""}var e=Ext.util.Format.htmlEncode(_VST("reindex","indexing"));b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(e)+'"';return e}}]});return this.colModel},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,idProperty:"path",root:"data.folders",baseParams:{action:"list"},fields:["exist","path","share","subpath","status","preferlang","section"],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL("folder_manage.cgi"),listeners:{scope:this,beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}}),listeners:{scope:this,load:this.onFolderLoad}});return this.store},getSelectedFolder:function(){var a=this.getSelectionModel();if(0>=a.getCount()){return null}var b=a.getSelected();var c={path:b.get("path"),share:b.get("share"),subpath:b.get("subpath"),preferlang:b.get("preferlang"),section:b.get("section")};return c},onFolderLoad:function(d,c,e){var f=this.getEl();if(d.getCount()===0){var b=f.mask(_VST("videofolder","hint"),"syno-ux-mask-info");var a=b.next().first();a.setStyle("cursor","pointer");a.on("click",function(){this.module.openFolderEditDialog("add")},this)}else{if(f.isMasked()){f.unmask()}this.getSelectionModel().selectFirstRow()}},reload:function(a){if(Ext.isDefined(a)){this.params=a;this.store.load({params:a})}else{this.store.load({params:this.params})}}});Ext.define("SYNO.SDS.VideoStation.AddEditDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(c){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,c);this.module=c.module;this.mode=c.mode;var a=c.applyButton;var b=Ext.apply({title:("add"===this.mode)?_T("common","add"):_T("common","alt_edit"),width:500,height:350,layout:"fit",items:[this.getFormPanel()],buttons:[a,{btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}],addAction:"create",editAction:"modify"},c);this.callParent([b])},onRequest:function(a){var b=("add"===this.mode)?this.addAction:this.editAction;var c=Ext.apply(this.getParameter(),{action:b});this.setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getAbsoluteURL(a),method:"POST",single:true,autoJsonDecode:true,params:c,scope:this,callback:this.onRequestDone.createDelegate(this)},this).start(true)},onCancel:function(){if("edit"!==this.mode||!this.isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this._getOwner().getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),a,this)},isDirty:Ext.emptyFn,getFormPanel:Ext.emptyFn,onRequestDone:Ext.emptyFn,getParameter:Ext.emptyFn});Ext.define("SYNO.SDS.VideoStation.FileChooser",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",constructor:function(b){var a={usage:{type:"chooseDir"},folderToolbar:true,treeFilter:function(d,c){if(c&&(c.spath==="/home"||c.spath==="/homes")){return false}return true}};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoStation.FolderDialog",{extend:"SYNO.SDS.VideoStation.AddEditDialog",constructor:function(b){this.folder=b.folder;this.library=b.library;var a=Ext.apply({resizable:false,width:500,applyButton:{btnStyle:"blue",text:_T("common","alt_apply"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onRequest}},b);this.callParent([a])},getFormPanel:function(){if(this.formpanel){return this.formpanel}var b={xtype:"syno_fieldset",title:_VST("videofolder","title"),labelWidth:100,items:[{xtype:"syno_compositefield",fieldLabel:_T("common","folder"),defaults:{hideLabel:true},items:[{xtype:"syno_textfield",width:200,name:"path",readOnly:true,allowBlank:false,blankText:_VST("videofolder","specify_path"),validationEvent:"afterrender"},{xtype:"syno_button",text:_VST("common","select"),btnStyle:"blue",disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onEditPathBtnHandler}]}]};var d={xtype:"syno_fieldset",title:_VST("library","title"),items:[{disabled:("edit"===this.mode),xtype:"syno_combobox",name:"library_id",fieldLabel:_VST("library","title"),displayField:"title",valueField:"id",tpl:'<tpl for="."><div class="x-combo-list-item">{title:htmlEncode}</div></tpl>',store:this.getLibraryStore(),listeners:{scope:this,select:this.onLibrarySelect}}]};var c={xtype:"syno_fieldset",title:_VST("videofolder","prefer_lang"),items:[{xtype:"syno_combobox",disabled:(SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID===this.library.type),name:"preferlanguage",fieldLabel:_VST("language","title"),displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation.Util.getLangStore()),tpl:new Ext.XTemplate('<tpl for=".">','<div class="x-combo-list-item" ext:qtip="{display}">',"{display}","</div>","</tpl>")}]};var a={trackResetOnLoad:true,border:false,items:[b,d,c]};return(this.formpanel=new SYNO.ux.FormPanel(a))},getLibraryStore:function(){if(this.libraryStore){return this.libraryStore}var a=this.module.libraryList.getLibraryList();this.libraryStore=new Ext.data.JsonStore({autoLoad:false,autoDestroy:true,root:"data",fields:[{name:"id",type:"int"},{name:"title",type:"string"},{name:"type",type:"string"}],data:{data:a}});return this.libraryStore},onOpen:function(){var b=this.getFormPanel().getForm();var a=("edit"===this.mode)?this.folder.preferlang:"enu";var c=("edit"==this.mode)?this.folder.path:"";b.findField("library_id").setValue(this.library.id);b.findField("preferlanguage").setValue(a);b.findField("path").setValue(c);SYNO.SDS.VideoStation.FolderDialog.superclass.onOpen.call(this)},onRequest:function(){if(!this.getFormPanel().getForm().findField("path").validate()){this.getMsgBox().alert(_VST("videofolder","title"),_VST("videofolder","specify_path"));return}SYNO.SDS.VideoStation.FolderDialog.superclass.onRequest.call(this,"folder_manage.cgi")},onRequestDone:function(a,d,b){this.clearStatusBusy();if(b&&b.success){this.module.folderGrid.reload();this.close()}else{var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),c)}},getParameter:function(){var b=this.getFormPanel().getForm();var c=b.findField("path").getValue();var a=b.findField("library_id").getValue();var e=SYNO.SDS.VideoStation.Util.getShareData(c);var d={share:e.orishare,subpath:e.subpath,section:this.getLibraryByID(a).type,preferlang:b.findField("preferlanguage").getValue()};if(a>0){d.library_id=a}if("edit"===this.mode){Ext.apply(d,{old_share:this.folder.share,old_subpath:this.folder.subpath})}return d},getLibraryByID:function(b){var a=null;this.libraryStore.each(function(c){if(b===c.get("id")){a=c.json;return false}});return a},onChooserSelect:function(b,c){if(c&&Ext.isString(c.path)){var a=this.getFormPanel().getForm();a.findField("path").setValue(c.path)}b.close()},onEditPathBtnHandler:function(){var a=new SYNO.SDS.VideoStation.FileChooser({owner:this,title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},onLibrarySelect:function(d,a,c){var b=this.getFormPanel().getForm().findField("preferlanguage");b.setDisabled(a.get("type")===SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID)},isDirty:function(){if(!Ext.isDefined(this.folder)||!Ext.isDefined(this.library)){return false}var d=this.getFormPanel().getForm();var e=d.findField("path").getValue();var b=d.findField("library_id").getValue();var a=d.findField("preferlanguage").getValue();var c=(e!==this.folder.path)||(b!==this.library.id)||(a!==this.folder.preferlang);return c}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.MAX_LIBRARY=100;Ext.define("SYNO.SDS.VideoStation.LibrarySettingPanel",{extend:"SYNO.ux.Panel",constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getAction","_createActions","_createAction"]);var a=this.fillConfig(b);this.callParent([this.fillConfig(b)])},fillConfig:function(b){var a={title:_VST("library","title"),border:false,layout:"border",monitorResize:true,tbar:this.createToolbarActions(),items:[this.libraryList=new SYNO.SDS.VideoStation.LibraryList({module:this,region:"west"}),this.folderGrid=new SYNO.SDS.VideoStation.FolderGrid({module:this,region:"center"})],listeners:{scope:this,activate:{fn:this.onActivate}}};Ext.apply(a,b);return a},createToolbarActions:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[{xtype:"syno_button",disabled:_S("demo_mode"),text:_T("common","create"),itemId:"create",scope:this,menu:this.createCreateMenu()},{xtype:"syno_button",disabled:true,text:_T("common","alt_edit"),itemId:"edit",scope:this,menu:this.createEditMenu()},{xtype:"syno_button",disabled:true,text:_T("common","delete"),itemId:"delete",scope:this,menu:this.createDeleteMenu()},{xtype:"syno_button",disabled:true,text:_VST("action","reindex"),itemId:"reindex",scope:this,menu:this.createReindexMenu()}]})},createCreateMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"create-library",text:_VST("library","create"),handler:this.openLibraryEditDialog.createDelegate(this,["add"])},{itemId:"create-folder",text:_VST("videofolder","add"),handler:this.openFolderEditDialog.createDelegate(this,["add"])}],listeners:{scope:this,beforeshow:function(d){var b=this.libraryList.getSelectedLibrary();var c=this.libraryList.getLibraryList().length;d.items.get("create-library").setDisabled(SYNO.SDS.VideoStation.MAX_LIBRARY<=c);d.items.get("create-folder").setDisabled(!Ext.isObject(b))}}};return new Ext.menu.Menu(a)},createEditMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"edit-library",text:_VST("library","edit"),handler:this.openLibraryEditDialog.createDelegate(this,["edit"])},{itemId:"edit-folder",text:_VST("videofolder","edit"),handler:this.openFolderEditDialog.createDelegate(this,["edit"])}],listeners:{scope:this,beforeshow:function(d){var b=this.libraryList.getSelectedLibrary();var c=this.folderGrid.getSelectionModel().getCount();d.items.get("edit-library").setDisabled(b.id<=0);d.items.get("edit-folder").setDisabled(c<=0)}}};return new Ext.menu.Menu(a)},createDeleteMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"delete-library",text:_VST("library","delete"),handler:this.onDelete.createDelegate(this,["library"])},{itemId:"delete-folder",text:_VST("videofolder","delete"),handler:this.onDelete.createDelegate(this,["folder"])}],listeners:{scope:this,beforeshow:function(d){var b=this.libraryList.getSelectedLibrary();var c=this.folderGrid.getSelectionModel().getCount();d.items.get("delete-library").setDisabled(b.id<=0);d.items.get("delete-folder").setDisabled(c<=0)}}};return new Ext.menu.Menu(a)},createReindexMenu:function(){var a={cls:"syno-vs-menu",items:[{itemId:"reindex-noupdate",text:_VST("action","reindex_no_update"),handler:this.onFolderRequest.createDelegate(this,["reindex-noupdate"])},{itemId:"reindex-update",text:_VST("action","reindex_with_update"),handler:this.onFolderRequest.createDelegate(this,["reindex-update"])}],listeners:{scope:this,beforeshow:function(c){var b=this.libraryList.getSelectedLibrary();c.items.get("reindex-update").setDisabled(b.type===SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID)}}};return new Ext.menu.Menu(a)},openLibraryEditDialog:function(d){if(_S("demo_mode")){return}var b={module:this,owner:this._getOwner(),mode:d};if("edit"===d){var a=this.libraryList.getSelectedLibrary();if(!Ext.isDefined(a)||!Ext.isNumber(a.id)||a.id<=0){return}Ext.apply(b,{library:a})}var c=new SYNO.SDS.VideoStation.LibraryDialog(b);c.open()},openFolderEditDialog:function(b){if(_S("demo_mode")){return}var a=new SYNO.SDS.VideoStation.FolderDialog({module:this,owner:this._getOwner(),folder:"edit"===b?this.folderGrid.getSelectedFolder():null,library:this.libraryList.getSelectedLibrary(),mode:b});a.open()},onFolderRequest:function(b){var a=this.folderGrid.getSelectedFolder();var c={action:b,share:a.share,subpath:a.subpath};this._getOwner().setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getAbsoluteURL("folder_manage.cgi"),method:"POST",single:true,autoJsonDecode:true,params:c,scope:this,callback:function(d,g,e){this._getOwner().clearStatusBusy();this.folderGrid.reload();if(!e||!e.success){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),f)}}},this).start(true)},initLoadData:Ext.emptyFn,onActivate:function(){this.libraryList.reload()},save:Ext.emptyFn,isDirty:function(){return false},getAction:function(a){return this.getTopToolbar().getComponent(a)},onChangeButtonStatus:function(){if(_S("demo_mode")){return}var c=this.folderGrid.getSelectionModel().getCount();var a=this.libraryList.getSelectedLibrary();var b=this.libraryList.getLibraryCount();this.getAction("create").setDisabled(SYNO.SDS.VideoStation.MAX_LIBRARY<=b);this.getAction("edit").setDisabled(0===c&&a.id<=0);this.getAction("delete").setDisabled(0===c&&a.id<=0);this.getAction("reindex").setDisabled(0===c)},onDelete:function(c){var d=c==="library"?_VST("library","delete_confirm"):_VST("videofolder","delete_confirm");var b=c==="library"?this.deleteLibrary.createDelegate(this):this.onFolderRequest.createDelegate(this,["delete"]);var a=function(e){if("yes"===e){b()}};this._getOwner().getMsgBox().confirm(_VST("action","settings"),d,a)},deleteLibrary:function(){var a=this.libraryList.getSelectedLibrary();this._getOwner().setStatusBusy({text:_T("common","loading")});this.addAjaxTask({url:this._getOwner()._getAbsoluteURL("library_manage.cgi"),method:"POST",single:true,autoJsonDecode:true,params:{action:"delete",id:a.id,type:a.type},scope:this,callback:function(c,e,b){this._getOwner().clearStatusBusy();if(b&&b.success){this.libraryList.reload();SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ListPanel").loadLibrary()}else{var d=SYNO.SDS.VideoStation.Util.getErrinfoString(obj,_T("common","commfail"));this.getMsgBox().alert(_VST("action","settings"),d)}}},this).start(true)}});Ext.define("SYNO.SDS.VideoStation.DTVSettingPanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var c={xtype:"syno_fieldset",collapsible:true,title:_VST("programguide","broadcast_streaming"),labelWidth:250,items:[{xtype:"syno_checkbox",boxLabel:_VST("streaming","enable_streaming_auth"),name:"enableauth"},{xtype:"syno_compositefield",itemId:"username_item",indent:1,hideLabel:false,fieldLabel:_VST("streaming","stream_auth_user"),width:300,items:[{xtype:"syno_textfield",name:"account",width:157}]},{xtype:"syno_compositefield",itemId:"passwd_item",indent:1,hideLabel:false,fieldLabel:_T("common","password"),width:300,items:[{xtype:"syno_textfield",textType:"password",name:"passwd",width:157}]},{xtype:"syno_compositefield",indent:1,hideLabel:false,fieldLabel:_VST("streaming","pass_confirm"),width:300,items:[{xtype:"syno_textfield",textType:"password_confirm",name:"password_confirm",width:157}]},{xtype:"syno_checkbox",boxLabel:_VST("streaming","enable_stream_limit"),name:"enable_viewer_limit"},{xtype:"syno_compositefield",hideLabel:false,fieldLabel:_VST("streaming","streaming_limit_viewer"),width:300,indent:1,items:[{xtype:"syno_numberfield",name:"streaming_limit",width:157,decimalPrecision:0,minValue:1,maxlength:6}]}]};var b={itemId:"dtv_settings",labelWidth:200,trackResetOnLoad:true,hideMode:"offsets",items:[{xtype:"syno_fieldset",collapsible:true,title:_VST("dtvfolder","title"),labelWidth:250,items:[{xtype:"hidden",name:"share"},{xtype:"hidden",name:"subpath"},{xtype:"syno_compositefield",itemId:"destselectfield",fieldLabel:_VST("dtvfolder","dtv_destination"),defaults:{hideLabel:true},items:[{xtype:"syno_textfield",name:"dtv_destination",postBlur:this.checkDestValid.createDelegate(this),readOnly:true,width:157},this.btnDTVFolder=new SYNO.ux.Button({btnStyle:"blue",text:_VST("common","select"),scope:this,disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",id:this.btnDTVFolderID=Ext.id(),handler:this.onDTVFolderChoose})]}]},c,{xtype:"syno_fieldset",collapsible:true,title:_VST("record","record_setting"),labelWidth:250,items:[{xtype:"syno_checkbox",boxLabel:_VST("record","record_first_stream"),name:"closestreaming"},{xtype:"syno_compositefield",itemId:"pre_recording_item",hideLabel:false,fieldLabel:_VST("record","pre_recording_interval"),indent:1,width:300,items:[{xtype:"syno_numberfield",name:"pre_recording",minValue:0,maxValue:3600,maxlength:4,width:157},{xtype:"syno_displayfield",value:_T("common","time_seconds")}]},{xtype:"syno_compositefield",itemId:"post_recording_item",hideLabel:false,fieldLabel:_VST("record","post_recording_interval"),indent:1,width:300,items:[{xtype:"syno_numberfield",name:"post_recording",minValue:0,maxValue:3600,maxlength:4,width:157},{xtype:"syno_displayfield",value:_T("common","time_seconds")}]}]},{xtype:"syno_fieldset",collapsible:true,title:_T("common","advanced"),items:[new SYNO.SDS.VideoStation.DTVDisableCheckbox({owner:this})]}],listeners:{scope:this,activate:this.checkDestValid}};SYNO.LayoutConfig.fill(b);Ext.apply(b,a);return b},checkDestValid:function(){if(true===this.destInvalid){this.getForm().findField("dtv_destination").markInvalid(_VST("error","record_dest_not_exist"))}},onDTVFolderChoose:function(){var a=new SYNO.SDS.VideoStation.FileChooser({owner:this._getOwner(),title:this.title});a.mon(a,"choose",this.onChooserSelect,this);a.open()},save:function(m){var a=this.getForm();var f=a.findField("enableauth").getValue();var k=a.findField("account").getValue();var b=a.findField("passwd").getValue();var j=a.findField("password_confirm").getValue();if(f&&this.invalidCheck(k,b,j)){this._getOwner().tabPanel.setActiveTab(1);return false}var d=a.findField("dtv_destination").getValue();var g=SYNO.SDS.VideoStation.Util.getShareData(d);var l=Ext.apply(a.getValues(),{share:g.orishare,subpath:g.subpath});var c=a.findField("disable_dtv").getValue();SYNO.SDS.VideoStation.gData.disable_dtv=(c.toString()==="true");var e=Ext.apply({action:"save"},l);e.disable_dtv=c?"yes":"no";this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("dtv_manage.cgi"),params:e,method:"POST",scope:this,callback:function(n,q,o){this._getOwner().clearStatusBusy();if(o&&o.success){this.getForm().setValues(l);m.fn.call(m.scope)}else{var p=SYNO.SDS.VideoStation.Util.getErrinfoString(o,_T("common","commfail"));this._getOwner().getMsgBox().alert(_VST("action","settings"),p)}}},this).start(true)},invalidCheck:function(e,c,a){var b=false,d;if(this.isEmptyUserPwd(e,c)){d=_VST("error","invalid_userpwd");b=true}else{if(this.isInvalidUser(e,c)){d=_VST("streaming","msg_invalid_user");b=true}else{if(this.isInvalidPassword(e,c)){d=_VST("streaming","error_empty_password");b=true}else{if(this.isConfirmPassword(c,a)){d=_VST("streaming","nzb_confirmpass");b=true}}}}if(b){this._getOwner().getMsgBox().alert(_VST("action","settings"),d)}return b},isEmptyUserPwd:function(b,a){if(!b&&!a){return true}},isInvalidUser:function(b,a){if(!b&&a){return true}return false},isInvalidPassword:function(b,a){if(b&&!a){return true}return false},isConfirmPassword:function(b,a){if(b&&(b!=a)&&(b!="12345678"||a!="87654321")){return true}return false},isDirty:function(){return this.getForm().isDirty()},onChooserSelect:function(a,b){if(b&&Ext.isString(b.path)){this.destInvalid=false;this.getForm().findField("dtv_destination").setValue(b.path)}a.close()},initEnableCheckGroup:function(){var c=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enableauth",["account","passwd","password_confirm"]);var b=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_viewer_limit",["streaming_limit"]);var a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"disable_dtv",[],[this.btnDTVFolderID,"dtv_destination","enableauth","enable_viewer_limit","closestreaming","pre_recording","post_recording"])},initLoadData:function(){this.initEnableCheckGroup();this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("dtv_manage.cgi"),params:{action:"load"},method:"POST",scope:this,callback:this.onLoadDTVSettingDone},this).start(true)},onLoadDTVSettingDone:function(b,d,a){this._getOwner().clearStatusBusy();if(!a||!a.success){var c=SYNO.SDS.VideoStation.Util.getErrinfoString(a,_T("common","commfail"));this._getOwner().getMsgBox().alert(this.title,c);return}if(!a.data.dtv_destination_exists&&""!==a.data.dtv_destination){this.destInvalid=true}this.OrigDisableDTV=a.data.disable_dtv;this.getForm().setValues(a.data);this.checkDestValid()}});Ext.define("SYNO.SDS.VideoStation.DTVDisableCheckbox",{extend:"SYNO.ux.Checkbox",constructor:function(b){var a={boxLabel:_VST("dtv","disable_dtv"),name:"disable_dtv"};this.callParent([Ext.apply(a,b)])},onClick:function(){if(true===this.getValue()&&true===this.owner.DVB_conflict){this.owner.owner.getMsgBox().alert(this.owner.title,_VST("dtv","enable_conflict"))}else{this.callParent(arguments)}}});Ext.define("SYNO.SDS.VideoStation.AdvancedSettingPanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.default_cmzvideo_cover_rule="cover.jpg;Cover.jpg;COVER.jpg;folder.jpg;Folder.jpg;FOLDER.jpg";SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var d={xtype:"syno_fieldset",collapsible:true,title:_VST("advanced","transcoding_settings"),items:[new SYNO.ux.Checkbox({boxLabel:_VST("advanced","pass_through_ac3"),name:"not_trans_audio_ac3_to_mp3"})]};if(SYNO.SDS.VideoStation.Util.support_hardware_transcode){var e=new SYNO.ux.Checkbox({boxLabel:_VST("advanced","enable_hardware_accelerate"),name:"hardware_transcode"});d.items.push(e)}var c=String.format(_VST("advanced","cover_format_error"),this.default_cmzvideo_cover_rule);var f={xtype:"syno_fieldset",collapsible:true,title:_VST("advanced","video_cover_settings"),items:[new SYNO.ux.Checkbox({name:"cmzvideo_cover",boxLabel:_VST("advanced","customized_video_cover")}),{xtype:"syno_displayfield",indent:1,name:"video_cover_note",value:String.format('<span class="syno-ux-note">{0}: </span>{1} {2}',_T("common","note"),_VST("advanced","only_apply_to"),_VST("advanced","same_filename_high_priority"))},{xtype:"syno_textfield",indent:1,width:300,name:"cmzvideo_cover_rule",fieldLabel:_VST("advanced","filename"),validator:function(j){if(Ext.isEmpty(j.trim())){return true}var k=j.split(";");for(var g=0;g<k.size();g++){if(-1==k[g].search(/.+\.([jJ][pP][gG]|[jJ][pP][eE][gG])$/)){return c}}return true}}]};var b={itemId:"advanced_settings",labelWidth:200,trackResetOnLoad:true,hideMode:"offsets",items:[d,f]};SYNO.LayoutConfig.fill(b);Ext.apply(b,a);return b},save:function(j){var d=this.getForm();var c=false;if(!d.findField("cmzvideo_cover_rule").isValid()){return}var b=d.findField("not_trans_audio_ac3_to_mp3").getValue();var f=d.findField("cmzvideo_cover").getValue();var e=d.findField("cmzvideo_cover_rule").getValue();if(Ext.isEmpty(e.trim())){d.findField("cmzvideo_cover_rule").setValue(this.default_cmzvideo_cover_rule);e=this.default_cmzvideo_cover_rule}var a={cmzvideo_cover:f,cmzvideo_cover_rule:e,not_trans_audio_ac3_to_mp3:b};if(null!==d.findField("hardware_transcode")){c=d.findField("hardware_transcode").getValue();a.hardware_transcode=c}var g=Ext.apply({action:"save"},a);this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("advanced_manage.cgi"),params:g,method:"POST",scope:this,callback:function(k,n,l){this._getOwner().clearStatusBusy();if(l&&l.success){d.setValues(a);j.fn.call(j.scope)}else{var m=SYNO.SDS.VideoStation.Util.getErrinfoString(l,_T("common","commfail"));this._getOwner().getMsgBox().alert(_VST("action","settings"),m)}}},this).start(true)},isDirty:function(){return this.getForm().isDirty()},initEnableCheckGroup:function(){var a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"cmzvideo_cover",["cmzvideo_cover_rule"])},initLoadData:function(){this.initEnableCheckGroup();this._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:this._getAbsoluteURL("advanced_manage.cgi"),params:{action:"load"},method:"POST",scope:this,callback:function(a,d,b){this._getOwner().clearStatusBusy();if(!b||!b.success){var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this._getOwner().getMsgBox().alert(this.title,c);return}this.getForm().setValues(b.data)}},this).start(true)}});Ext.define("SYNO.SDS.VideoStation.CheckBoxGrid",{extend:"SYNO.ux.GridPanel",pageSize:50,constructor:function(b){var a=this.fillConfig(b);this.callParent([this.fillConfig(b)]);this.getStore().on("beforeload",this.onBeforeLoad,this)},fillConfig:function(b){var c=new SYNO.ux.PagingToolbar({pageSize:b.pageSize||this.pageSize,store:this.getStore(),displayInfo:true});var a={itemId:"grid",store:this.getStore(),border:false,flex:1,viewConfig:{scrollDelay:false,borderHeight:0,cacheSize:50,forceFit:false},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},stripeRows:true,enableColLock:false,enableColumnMove:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),bbar:c,columns:this.getColumns()};return Ext.apply(a,b)},getStore:Ext.emptyFn,getColumns:Ext.emptyFn,isDirty:function(){return 0<this.getStore().getModifiedRecords().length},getSaveParams:Ext.emptyFn,saveChanges:function(a,c){var b=this.module;b._getOwner().setStatusBusy({text:_T("common","saving")});this.addAjaxTask({single:true,autoJsonDecode:true,url:b._getAbsoluteURL(this.cgiURL),method:"POST",params:this.getSaveParams(),scope:this,callback:function(e,g,d){b._getOwner().clearStatusBusy();if(d&&d.success){this.getStore().commitChanges();if(!Ext.isDefined(c)){this.getStore().load(a)}else{c.fn.call(c.scope)}}else{var f=SYNO.SDS.VideoStation.Util.getErrinfoString(d,_T("common","commfail"));b._getOwner().getMsgBox().alert(_VST("action","settings"),f)}}},this).start(true)},onBeforeLoad:function(a,b){if(!this.isDirty()){return true}var c=function(d){if("yes"===d){this.saveChanges(b)}else{a.rejectChanges();a.load(b)}};this.module._getOwner().getMsgBox().confirm(this.module.title,_T("share","share_save_chg_before_reload"),c,this);return false}});Ext.namespace("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.PrivilegeGrid=Ext.extend(SYNO.SDS.VideoStation.CheckBoxGrid,{cgiURL:"privilege_manage.cgi",constructor:function(b){this.module=b.module;var a=Ext.apply({cls:"privilege-grid",autoExpandColumn:"name",plugins:[this.getDTVColumn(),this.getRendererColumn()]},b);SYNO.SDS.VideoStation.PrivilegeGrid.superclass.constructor.call(this,a);this.getStore().on("load",this.onUserLoad,this)},getStore:function(){if(this.store){return this.store}var a=new Ext.data.JsonStore({autoLoad:false,root:"data.users",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"dtv",type:"boolean",defaulValue:false},{name:"renderer",type:"boolean",defaulValue:false}],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL("privilege_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}})});return(this.store=a)},getColumns:function(){if(this.colModel){return this.colModel}var a={defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getDTVColumn(),this.getRendererColumn()]};return(this.colModel=new Ext.grid.ColumnModel(a))},getDTVColumn:function(){if(this.dtvColumn){return this.dtvColumn}return(this.dtvColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("privilege","dtv_control"),dataIndex:"dtv",id:"dtv",width:150,ignoreKey:"is_admin"}))},getRendererColumn:function(){if(this.rendererColumn){return this.rendererColumn}return(this.rendererColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("privilege","renderer_control"),dataIndex:"renderer",id:"renderer",width:200,ignoreKey:"is_admin"}))},getChanges:function(){if(!this.isDirty()){return}var a=this.getStore().getModifiedRecords();var b={};Ext.each(a,function(c){var d=c.get("uid");if(!Ext.isDefined(b[d])){b[d]={}}b[d]["dtv"]=c.get("dtv");b[d]["renderer"]=c.get("renderer")});return b},getSaveParams:function(){return{action:"save",privilege:Ext.util.JSON.encode(this.getChanges())}},save:function(a){this.saveChanges(null,a)},initLoadData:function(){this.getStore().load({start:0,limit:50})},onUserLoad:function(c,b,d){var e=this.getEl();if(!e){this.on("afterrender",this.onUserLoad,this,{single:true,delay:1000});return}if(this.getStore().getCount()===0){var a=e.mask(_VST("privilege","no_user_hint"),"syno-ux-mask-info")}else{if(e.isMasked()){e.unmask()}}}});Ext.define("SYNO.SDS.VideoStation.SettingDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){var b=this.fillConfig(a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={owner:this._getOwner(),width:690,height:640,minWidth:400,minHeight:280,title:_VST("action","settings"),layout:"fit",items:[this.getTabPanel()],buttons:[{btnStyle:"blue",disabled:_S("demo_mode"),text:_T("common","ok"),scope:this,handler:this.onApply},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],listeners:{scope:this,beforeshow:{fn:this.onBeforeShow,scope:this,single:true}}};Ext.apply(b,a);return b},open:function(a){if(this.tabPanel&&a){this.tabPanel.setActiveTab(a)}SYNO.SDS.VideoStation.SettingDialog.superclass.open.apply(this,arguments)},onBeforeShow:function(){this.getTabPanel().loadAllForm();var a=SYNO.SDS.Desktop?SYNO.SDS.Desktop.getEl().getHeight():Ext.lib.Dom.getViewHeight();if(a<this.getHeight()){this.setSize(this.getWidth(),a)}},getTabPanel:function(){if(!this.tabPanel){var a=[this.getLibrarySettingPanel(),this.getDTVSettingPanel(),this.getPrivilegeGrid(),this.getAdvancedSettingPanel()];var b={owner:this,items:a};this.tabPanel=new SYNO.SDS.VideoStation.SettingTabPanel(b)}return this.tabPanel},getDTVSettingPanel:function(){if(this.dtvSettingPanel){return this.dtvSettingPanel}return(this.dtvSettingPanel=new SYNO.SDS.VideoStation.DTVSettingPanel({title:_VST("dtv","title"),owner:this}))},getLibrarySettingPanel:function(){if(this.librarySettingPanel){return this.librarySettingPanel}return(this.librarySettingPanel=new SYNO.SDS.VideoStation.LibrarySettingPanel({title:_VST("library","title"),owner:this}))},getPrivilegeGrid:function(){if(this.privilegeGrid){return this.privilegeGrid}return(this.privilegeGrid=new SYNO.SDS.VideoStation.PrivilegeGrid({title:_VST("privilege","title"),module:this,owner:this}))},getAdvancedSettingPanel:function(){if(this.advancedSettingPanel){return this.advancedSettingPanel}return(this.advancedSettingPanel=new SYNO.SDS.VideoStation.AdvancedSettingPanel({title:_VST("advanced","panel_title"),owner:this}))},onCancel:function(){var a=this.dtvSettingPanel;if(this.dtvSettingPanel.isDirty()||this.privilegeGrid.isDirty()||this.advancedSettingPanel.isDirty()){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close()}},this)}else{this.close()}},onApply:function(){var c=this.privilegeGrid;var d=this.dtvSettingPanel;var b=this.advancedSettingPanel;if(!d.getForm().isValid()){return false}if(!d.isDirty()&&!c.isDirty()&&(!Ext.isDefined(b)||!b.isDirty())){this.close();return false}var a=("true"===d.getForm().findField("disable_dtv").getValue())?true:false;if(true===a&&a!==d.OrigDisableDTV){this.getMsgBox().confirm(_VST("action","settings"),_VST("dtv","disable_dtv_desc"),function(e){if("yes"===e){this.tabPanel.doApplyAll()}},this);return false}this.tabPanel.doApplyAll()}});Ext.define("SYNO.SDS.VideoStation.SettingTabPanel",{extend:"SYNO.ux.TabPanel",constructor:function(b){var a={activeTab:0};this.callParent([Ext.apply(a,b)])},loadAllForm:function(){this.items.each(function(a){a.initLoadData()})},doApplyAll:function(){var a=false;var b={fn:this.doApplyAll,scope:this};this.items.each(function(c){if(c.isDirty()){c.save(b);a=true;return false}});if(!a){this.owner.close()}}});Ext.define("SYNO.SDS.VideoStation.SearchDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",displayNum:500,constructor:function(a){this.callParent([this.fillConfig(a)]);this.createPollingTask()},fillConfig:function(a){var b={cls:"syno-vs-search-dialog",width:800,height:400,minWidth:200,minHeight:200,title:_VST("action","search_correct"),layout:"border",border:false,items:[this.createTBar(),this.fillGridConfig()],buttons:[this.btnApply=new SYNO.ux.Button({btnStyle:"blue",disabled:true,text:_T("common","commit"),scope:this,handler:this.onApply}),{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onSearch},{key:27,scope:this,handler:this.close}],listeners:{scope:this,beforeshow:{fn:this.onBeforeShow,scope:this,single:true}}};Ext.apply(b,a);return b},onApply:function(){var a=this.getSearchPanel().getSelectionModel().getSelected();if(this.getType()!=="tvshow_episode"){if(a){this.owner.onSetRecords(a);this.close()}}else{this.setStatusBusy();SYNO.API.currentManager.requestAPI("SYNO.VideoStation.PluginSearch","query",1,{id:this.searchId,type:this.getType(),data:Ext.encode(a.data)},function(c,g,f){var b;if(this.isDestroyed){return}this.clearStatusBusy();if(c){try{b=this.reader.readRecords({data:g});if(!Ext.isEmpty(a=b.records[0])){this.owner.onSetRecords(a);this.close();return}}catch(d){SYNO.Debug("Fail to read data",d,g)}}var j=SYNO.SDS.VideoStation.Util.getWebAPIErr(c,g,f);this.getMsgBox().alert(_VST("app","displayname"),j,function(){},this)},this)}},onClose:function(){this.onStop();SYNO.SDS.VideoStation.SearchDialog.superclass.onClose.apply(this,arguments)},onMask:function(b,a){this.getSearchPanel().getGridEl().mask(b,a||"syno-ux-mask-info")},onUnMask:function(){this.getSearchPanel().getGridEl().unmask()},onIsMask:function(){return this.getSearchPanel().getGridEl().isMasked()},onBeforeShow:function(){this.onMask(_VST("search","desc"))},createTBar:function(){var a=this.getType()=="tvshow_episode";var b=[this.searchfield=new SYNO.ux.TextFilter({itemId:"search_field",emptyText:_VST("search","keyword"),flex:2}),{xtype:"syno_displayfield",margins:"0px 3px 0 3px",value:_VST("language","title")+": "},{xtype:"container",cls:"syno-search-preferlang-container",items:[this.preferlang=new SYNO.ux.ComboBox({itemId:"preferlanguage",displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation.Util.getLangStore()),mode:"local",triggerAction:"all",resizable:false,editable:false,value:SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","search_lang")||"enu",listeners:{scope:this,change:function(e,d,c){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","search_lang",d)}}})]},{xtype:"syno_displayfield",margins:"0px 3px 0px 3px",value:_VST("season","season_title")+": ",hidden:!a},this.season=new SYNO.ux.NumberField({itemId:"season",name:"season",xtype:"numberfield",allowNegative:false,allowDecimals:false,allowBlank:true,style:"position: absolute",hidden:!a,flex:1}),{xtype:"syno_displayfield",margins:"0px 3px 0px 3px",value:_VST("episode","episode_title")+": ",hidden:!a},this.episode=new SYNO.ux.NumberField({itemId:"episode",name:"episode",allowNegative:false,allowDecimals:false,allowBlank:true,style:"position: absolute",hidden:!a,flex:1}),{xtyp:"tbspacer",border:false,width:6},this.btnSearch=new SYNO.ux.Button({text:_VST("search","title"),tooltip:_VST("search","title"),itemId:"search",disabled:_S("demo_mode"),scope:this,handler:this.onSearch})];return{region:"north",height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-window-tbar",items:[{flex:1,height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-toolbar x-toolbar-cell",style:"border-top:0 none;",items:b}]}},createPollingTask:function(){var a=this.addTask({interval:800,scope:this,run:function(){if(this.isDestroyed){a.stop();return}if(this.getSearchPanel().getSelectionModel().getSelected()){this.btnApply.enable()}else{this.btnApply.disable()}}}).start()},getType:function(){var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var b=a.params?(a.params.type||a.type):a.type;return b},onSearch:function(){var b=this.getType();var d=this.searchfield.getValue();var a=this.preferlang.getValue();d=d.trim();if(Ext.isEmpty(d)){this.getMsgBox().alert(_VST("app","displayname"),_VST("search","desc"));return}if(this.searchId){this.onStop()}this.onMask(_VST("search","searching"),"x-mask-loading");this.btnSearch.disable();var c={title:d,type:b,preferlanguage:a,offset:0};if(this.getType()==="tvshow_episode"){this.onRemoveAll();if(!Ext.isEmpty(this.season.getValue())){Ext.apply(c,{season:this.season.getValue()})}if(!Ext.isEmpty(this.episode.getValue())){Ext.apply(c,{episode:this.episode.getValue()})}}SYNO.API.currentManager.requestAPI("SYNO.VideoStation.PluginSearch","start",1,c,function(e,j,g){if(this.isDestroyed){return}if(e&&j&&j.id){this.searchId=j.id;if(this.isDestroyed){this.onStop();return}this.onList()}else{var f=SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("common","commfail"));this.getMsgBox().alert(_VST("app","displayname"),f);this.onUnMask();this.btnSearch.enable()}},this)},onStop:function(){if(Ext.isEmpty(this.searchId)){return}if(!this.isDestroyed){this.onUnMask();this.onHideLoading()}SYNO.API.currentManager.requestAPI("SYNO.VideoStation.PluginSearch","stop",1,{id:this.searchId});if(this.updateTask){this.updateTask.remove();this.updateTask=null}},onList:function(a){this.btnSearch.enable();this.onShowLoading();if(!this.updateTask||this.updateTask.removed){this.updateTask=this.addAjaxTask({id:"updateTask",interval:1500,url:this._getWebAPIURL("pluginsearch.cgi"),params:this.getUpdateRecordParams(),method:"POST",autoJsonDecode:true,callback:this.onStoreUpdated,scope:this});var b=this.getTaskRunner();this.mon(b,"beforestart",this.onBeforeStartUpdateRecords,this)}this.updateTask.start(a||false)},getUpdateRecordParams:function(){var a=this.getStore().getSortState();var b={api:"SYNO.VideoStation.PluginSearch",method:"list",version:1,id:this.searchId,offset:this.paging.cursor,limit:this.paging.pageSize,sort_by:a.field,sort_direction:a.direction};return b},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{api:"SYNO.VideoStation.PluginSearch",method:"list",version:1,offset:Ext.isDefined(c.offset)?c.offset:this.paging.cursor,limit:this.paging.pageSize,id:this.searchId});return c},onBeforeStartUpdateRecords:function(a){if(this.updateTask===a){a.reqConfig.params=this.getUpdateRecordParams()}},getSearchPanel:function(){if(this.searchPanel){return this.searchPanel}return(this.searchPanel=this.getComponent("grid"))},fillGridConfig:function(){return this.fillMainGridConfig()},createPaging:function(b){var c=new SYNO.ux.Button({tooltip:_VST("search","searching"),overflowText:_VST("search","searching"),cls:"loading",hidden:true});var a=Ext.apply({showRefreshBtn:false,loading:c,pageSize:this.displayNum,displayInfo:true,items:[c],hideLoading:function(){this.refresh.show();this.loading.hide()},showLoading:function(){this.refresh.hide();this.loading.show()}},b);return new SYNO.ux.PagingToolbar(a)},fillMainGridConfig:function(){var b=this;this.paging=this.createPaging({store:this.getStore()});var a=Ext.apply({xtype:"syno_gridpanel",cls:"syno-vs-info-search-grid",stripeRows:true,loadMask:true,region:"center",itemId:"grid",border:false,autoExpandMin:160,autoExpandColumn:"title",bbar:this.paging,store:this.getStore(),cm:this.getColumnModel(),sm:new Ext.grid.RowSelectionModel({single:true,silentMode:true}),viewConfig:{autoFill:true,forceFit:true,scrollDelay:false,cacheSize:50,rowHeight:27},getView:function(){if(!this.view){this.view=new SYNO.SDS.VideoStation.HoldBufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,rowdblclick:function(c,j,d){var g=c.getSelectionModel();var f=g.getSelected();if(!f){return}this.onApply()}}});return a},onRemoveAll:function(){this.getStore().removeAll();this.paging.jumpPageByOffset(0);this.searchPanel.getView().setHoldScroll(undefined)},getColumnModel:function(){if(this.colModel){return this.colModel}var a=[{id:"title",header:_VST("common","title"),dataIndex:"title",sortable:true,width:200,autoExpand:true,renderer:(function(j,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"original_available",header:(this.getType()!=="tvshow_episode")?_VST("original_available","title"):(_VST("original_available","title")+" ("+_VST("type","tv_show")+")"),dataIndex:"original_available",sortable:true,width:150,renderer:(function(k,g,b,e,j,c){var f=this.getType();if("tvshow_episode"===f){k=b.data.tvshow_original_available}if(k==="0"){k=""}var d=Ext.util.Format.htmlEncode(k);g.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)}];if(this.getType()==="tvshow_episode"){a.push({id:"episode_name_title",header:_VST("episode","name_title"),dataIndex:"tag_line",width:100,renderer:(function(j,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"season",header:_VST("season","season_title"),dataIndex:"season",width:70,renderer:(function(j,f,b,e,g,c){if(j==="0"){return""}var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"episode",header:_VST("episode","episode_title"),dataIndex:"episode",width:70,renderer:(function(j,f,b,e,g,c){if(j==="0"){return""}var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)})}a.push({id:"summary",header:(this.getType()!=="tvshow_episode")?_VST("summary","title"):(_VST("summary","title")+" ("+_VST("episode","episode_title")+")"),dataIndex:"summary",width:300,renderer:(function(j,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)});this.colModel=new Ext.grid.ColumnModel({defaults:{align:"left",sortable:true},columns:a});return this.colModel},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.Store({autoLoad:false,method:"POST",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},remoteSort:true,sortInfo:{field:"title",direction:"ASC"},proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("pluginsearch.cgi"),listeners:{scope:this,beforeload:function(a,b){var c=a.activeRequest.read;if(c){Ext.Ajax.abort(c)}}}}),reader:this.reader=new Ext.data.JsonReader({id:"id",root:"data.results",totalProperty:"data.total",fields:["id","title","tag_line","original_available","summary","season","episode","writer","director","actor","genre","extra","tvshow_summary","tvshow_extra","tvshow_original_available","tvshow_year","tvshow_sort_time","tvshow_index"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onStoreLoad,exception:this.onExceptionLoadStore}}))},onStoreLoad:function(){if(!this.getSearchPanel().getSelectionModel().getSelected()){this.getSearchPanel().getSelectionModel().selectRow(0)}},onExceptionLoadStore:function(){this.onStop()},onLoadData:function(a){if(this.isDestroyed){return}this.getStore().loadData(a)},onUpdateError:function(a){this.onUnMask();var b=SYNO.SDS.VideoStation.Util.getErrinfoString(a,_T("common","commfail"));this.getMsgBox().alert(_VST("app","displayname"),b);this.onStop()},onStoreUpdated:function(b,o,e){if(this.isDestroyed){this.updateTask.stop();return}if(!o||!e||!e.success||!e.data){this.onUpdateError(e);return}var g=this.getStore().getSortState();if(b.params.id!=this.searchId||b.params.sort_by!==g.field||b.params.sort_direction!==g.direction||b.params.offset!==this.paging.cursor){return}var f=e.data;if(this.onIsMask()){if(f.status==="updated"||(f.results&&f.results.length>0)){this.onUnMask()}}if(f.status==="updated"){this.onHideLoading();this.updateTask.stop();this.searchPanel.getView().setHoldScroll(false)}var c=false;var m=f.results;if(this.getStore()&&(f.total!=this.getStore().getTotalCount())){c=true}else{for(var d=0;d<m.length;d++){var l=this.getStore().getById(m[d].id);var k=this.getStore().getAt(d);if(!l||!k||m[d].id!=k.get("id")){c=true;break}if(l){for(var n in l.data){l.data[n]=m[d][n]}l.commit()}else{c=true;break}}}if(c){var a=this.paging.cursor;this.paging.unbind(this.getStore());this.getStore().loadData(e,false);this.paging.bind(this.getStore());this.paging.onLoad(this.getStore(),m,{params:{offset:a}})}},onLoad:function(c,b,a){if(!Ext.isEmpty(c)){this.searchfield.setValue(c);this.searchfield.trigger.show();this.mon(this,"show",function(){this.searchfield.selectText(0,0)},this,{delay:800,single:true})}if(!Ext.isEmpty(b)&&!Ext.isEmpty(a)){if(b!=="0"){this.season.setValue(b)}if(a!=="0"){this.episode.setValue(a)}}this.show()},onHideLoading:function(){this.paging.hideLoading()},onShowLoading:function(){this.paging.showLoading()}});Ext.define("SYNO.SDS.VideoStation.HoldBufferView",{extend:"SYNO.ux.FleXcroll.grid.BufferView",onLoad:function(){if(!this.holdPosition){this.callParent(arguments)}if(!Ext.isDefined(this.holdPosition)){this.holdPosition=true}},setHoldScroll:function(a){this.holdPosition=a}});Ext.define("SYNO.SDS.VideoStation.SourceDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var c=new SYNO.SDS.VideoStation.SourceListPanel();var b={owner:this._getOwner(),width:460,height:480,minWidth:300,minHeight:280,title:_VST("video_info","source"),layout:"fit",padding:24,autoScroll:false,resizable:false,items:[c],buttons:[{text:_T("common","close"),scope:this,handler:this.onClose}],keys:[{key:27,scope:this,handler:this.onClose}]};Ext.apply(b,a);return b},onClose:function(){this.hide()}});Ext.define("SYNO.SDS.VideoStation.SourceListPanel",{extend:"Ext.list.ListView",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var g='<a target="_blank" class="syno-vs-source-link" href="http://www.atmovies.com.tw/home/">'+_VST("video_info","source_atmovies")+"</a>";var j='<a target="_blank" class="syno-vs-source-link" href="https://www.themoviedb.org/">'+_VST("video_info","tmdb")+"</a>";var d='<a target="_blank" class="syno-vs-source-link" href="http://creativecommons.org/licenses/by/2.5/">'+_VST("video_info","cc_by")+"</a>";var e='<a target="_blank" class="syno-vs-source-link" href="http://creativecommons.org/licenses/by/3.0/us/">'+_VST("video_info","cc_by")+"</a>";var f='<a target="_blank" class="syno-vs-source-link" href="http://www.allocine.fr/">'+_VST("video_info","allocine")+"</a>";var b=new Ext.data.JsonStore({data:{items:[{title:String.format(_VST("video_info","license_under"),g),id:"atmovies"},{title:String.format(_VST("video_info","license_under"),j),id:"tmdbdescription"},{title:String.format(_VST("video_info","license_under"),d),id:"ccby"},{title:String.format(_VST("video_info","license_under"),e),id:"tvdb"},{title:String.format(_VST("video_info","license_under"),f),id:"allocine"},{title:_VST("video_info","source_description"),id:"description",type:"description"}]},autoLoad:true,root:"items",fields:["title","id",{name:"type",defaultValue:"item"}]});var c={cls:"syno-vs-source-list",split:false,trackOver:false,hideHeaders:true,autoScroll:false,store:b,tpl:new Ext.XTemplate('<tpl for="rows">',"<dl>",'<tpl for="parent.columns">','<dt style="width:431px;text-align:{align};">',"{[values.tpl.apply(parent)]}","</dt>","</tpl>",'<div class="x-clear"></div>',"</dl>","</tpl>"),columns:[{dataIndex:"title",sortable:false,tpl:'<div class="container-{type}"><div class="ml-{type}"></div><div class="mc-{type}"><div class="video-source-{id}"><span>{title}</span></div></div><div class="mr-{type}"></div></div>'}],listeners:{scope:this,activate:this.onActivate}};Ext.apply(c,a);return c},onActivate:function(){}});Ext.define("SYNO.SDS.VideoStation.PosterPanel",{extend:"SYNO.ux.Panel",constructor:function(b){var a={cls:"poster-panel",layout:{type:"hbox",pack:"start",align:"middle"},items:[{xtype:"container",width:20},this.getPosterContainer(),{xtype:"container",width:14},this.getPosterForm()]};this.callParent([Ext.apply(a,b)])},getPosterID:function(){if(this.poster_id){return this.poster_id}this.poster_id=Ext.id();return this.poster_id},getPosterContainer:function(){if(this.poster){return this.poster}var a={cls:"frame",width:200,height:296,html:['<div class="icon" id="'+this.getPosterID()+'">',"</div>"].join("")};this.poster=new Ext.Container(a);return this.poster},getForm:function(){return this.getPosterForm().getForm()},isValid:function(){return this.getPosterForm().isValid()},isDirty:function(){return this.getPosterForm().isDirty()},getPosterForm:function(){if(this.form){return this.form}var a={width:450};this.form=new SYNO.SDS.VideoStation.PosterForm(a);return this.form},loadResponse:function(e){var d=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var f=d.params?(d.params.type||d.id):d.id;f=(f==="tvshow_episode")?"tvshow":f;var b=d.response_root;if(!b){var a=SYNO.SDS.VideoStation.Util.SEC_CFG[f];b=a.data[a.data.length-1].response_root}var c=e[b];if(Ext.isArray(c)){c=c[0]}if(Ext.isEmpty(c)){return}this.setIcon(c)},setIcon:function(d){var e=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var f=SYNO.SDS.VideoStation.Util;var c=e.params?(e.params.type||e.type):e.type;var a=(c===f._MOVIE_ID||c===f._TVSHOW_ID)?"poster":"screenshot";this.poster.removeClass(["poster","screenshot"]);this.poster.addClass(a);var b=Ext.get(this.getPosterID());var g=this.getImageURL(d);if(Ext.isIE8||Ext.isIE7){b.setStyle("filter",String.format("progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{0}', sizingMethod='scale')",g))}else{b.setStyle("background-image",String.format("url('{0}')",g))}},getImageURL:function(b){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var a=c.params?(c.params.type||c.type):c.type;var d=b.id;return SYNO.SDS.VideoStation.Util.getImageURL(SYNO.SDS.VideoStation.Util._getWebAPIURL("poster.cgi"),{type:a,id:d,mtime:b.additional?b.additional.poster_mtime||"":""})},clearValues:function(){this.getForm().reset()}});Ext.define("SYNO.SDS.VideoStation.PosterForm",{extend:"SYNO.ux.FormPanel",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={itemId:"poster",trackResetOnLoad:true,width:500,autoHeight:true,cls:"syno-vs-meta-form-setting",border:false,labelWidth:130,defaults:{anchor:"100%"},items:[this.radio_group=new Ext.form.RadioGroup({itemId:"poster",vertical:true,columns:1,hideLabel:true,items:[this.radio_original=new SYNO.ux.Radio({boxLabel:_VST("poster","original"),name:"poster",itemId:"original",inputValue:"original",checked:true}),{xtype:"syno_radio",boxLabel:_VST("poster","url"),name:"poster",inputValue:"url"},{xtype:"syno_textfield",name:"url",width:500,indent:1,vtype:"url",allowBlank:false,disabled:true}],listeners:{scope:this,change:function(d,c){this.getForm().findField("url").setDisabled((c.inputValue!=="url"))}},validate:this.validatePoster.createDelegate(this)})]};return Ext.apply(b,a)},validatePoster:function(){var b=Ext.form.RadioGroup.prototype.validate.apply(this.radio_group,arguments);var a=this.getForm().findField("url").isValid();return(b&&a)?true:false}});Ext.define("SYNO.SDS.VideoStation.DateField",{extend:"SYNO.ux.DateField",constructor:function(b){var a={format:"Y-m-d",altFormats:"Y"};this.callParent([Ext.apply(a,b)]);this.yearValue=null},isYear:function(){return Ext.isString(this.yearValue)&&!Ext.isEmpty(this.yearValue)},getYearValue:function(){return this.isYear()?this.yearValue:""},setValue:function(a){SYNO.Debug("setvalue: ",a);if(!Date.parseDate(a,"Y-m-d")&&Date.parseDate(a,"Y")){this.yearValue=a}else{this.yearValue=null}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoStation.MetaDataDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)]);this.getTabPanel().addDeactivateCheck(this)},fillConfig:function(a){var c=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var b={cls:"syno-vs-metadata-win",owner:this._getOwner(),width:800,height:(c.id!==SYNO.SDS.VideoStation.Util._TVSHOW_ID||c.type!=="tvshow")?640:550,minWidth:200,minHeight:200,title:_VST("action","edit_metadata"),layout:"fit",items:[this.getTabPanel()],buttons:[{btnStyle:"blue",disabled:_S("demo_mode"),text:_T("common","ok"),scope:this,handler:function(){this.onApply()}},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:27,scope:this,handler:this.onCancel}]};return Ext.apply(b,a)},onCancel:function(){var b,a;b=this.getMetadataPanel().getForm();if(this.getPosterPanel()){a=this.getPosterPanel().getForm()}if(b.isDirty()||(a&&a.isDirty())){this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(c){if(c==="yes"){this.onHideDialog()}},this)}else{this.onHideDialog()}},onHideDialog:function(){if(this.getTabPanel()){this.getTabPanel().setActiveTab(0)}this.clearValues();this.clearDirty();this.setting_count=0;this.hide()},clearDirty:function(){var f=this.getMetadataPanel().getForm();var d,b=f.items.items,a=b.length,e;for(d=0;d<a;d++){e=b[d];e.originalValue=String(e.getValue())}},sourceHandle:function(){var a=Ext.fly(this.metadataPanel.sourceID);a.dom.onclick=this.onClicSource.createDelegate(this)},onClicSource:function(){if(!this.sourceDialog){this.sourceDialog=new SYNO.SDS.VideoStation.SourceDialog({owner:this})}this.sourceDialog.open()},onLoads:function(b){this.getTabPanel().hideTabStripItem("poster");this.getMetadataPanel().onLoadDatas(b);this.fromInternet=false;this.show();var a=SYNO.SDS.VideoStation.Util.onGetHeight(this.getMetadataPanel(),140);this.setHeight(a<350?350:a);this.episode_recs=b;if(this.metadataPanel.sourceID){this.sourceHandle()}},onLoad:function(d,a){this.data_id=d;var b=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();this.fromInternet=false;var c={id:d,additional:"title,tvshow_summary,tvshow_extra,summary,files,actor,writer,director,extra,genre,poster_mtime"};this.data_video_rec=a;if(a){this.setTitle(_VST("action","correct_metadata"));this.getMetadataPanel().onSetVisibleFileFields(true,a.get("sharepath"))}else{this.getMetadataPanel().onSetVisibleFileFields(false);this.setTitle(_VST("action","edit_metadata"))}this.mon(this,"beforeshow",function(){this.getTabPanel().loadAllForm({method:"getinfo",api:this.getWebAPIID()},c)},this,{single:true});this.show();if(this.metadataPanel.sourceID){this.sourceHandle()}},clearValues:function(){this.getMetadataPanel().clearValues();this.getPosterPanel().clearValues();this.searchmetadata=undefined},onSetMetaData:function(a){this.clearValues();this.getMetadataPanel().onSetData(a,!!this.episode_recs)},onSetRecords:function(e){this.clearValues();var b=this.getMetadataPanel().getForm();var c=SYNO.Util.copy(e.data);if(!Ext.isEmpty(c.tag_line)){Ext.apply(c,{tagline:c.tag_line});delete c.tag_line}this.onSetRecord(b,c);var a=this.getPoster(c.extra),d;b=this.getPosterPanel().getForm();d=b.findField("poster");if(a){d.setValue("url");d=b.findField("url");d.setValue(a)}this.searchmetadata=this.getTitleAndDateString();this.fromInternet=true},getTitleAndDateString:function(){var b=this.getMetadataPanel().getForm();var a=b.findField("original_available");var c=b.findField("title");return c+a},getPoster:function(a){if(!a){return}var g;try{g=Ext.decode(a)}catch(f){return}var d,c,b;for(c in g){if(g.hasOwnProperty(c)){for(b in g[c]){if(g[c].hasOwnProperty(b)){if(-1!=b.toLowerCase().indexOf("poster")){var j;Ext.each(g[c][b],function(e){if(!Ext.isEmpty(e)){j=e}});return j}}}}}},onSetRecord:function(c,b){var e,j;for(j in b){if(!Ext.isFunction(b[j])&&(e=c.findField(j))){if(Ext.isEmpty(b[j])){continue}if(e.xtype==="syno_superboxselect"){var a=[],g=Ext.decode(b[j]);if(!Ext.isArray(g)){g=[g]}Ext.each(g,function(k){a.push({name:k,display:Ext.util.Format.htmlEncode(k)})});e.setValueEx(a)}else{if(b[j]==="0"){continue}e.setValue(b[j])}}}var f;if(b.original_available){e=c.findField("original_available");f=b.original_available.split("-");var d=f[0]+"-"+(Ext.isEmpty(f[1])?"01":f[1])+"-"+(Ext.isEmpty(f[2])?"01":f[2]);e.setValue(d)}},isModified:function(){return this.getMetadataPanel().isModified()},onApply:function(f,x){if(_S("demo_mode")){this.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}if(!x&&!this.isModified()){x={overwrite:"skip"}}x=x||{};var o,p;var c=this.getMetadataPanel().getForm();if(this.episode_recs){x={};var g=[],A,y,b;var n=["title","tvshow_original_available","season","episode"];for(var s=0;s<this.episode_recs.length;s++){A={};o=this.episode_recs[s].get("id");for(var q=0;q<n.length;q++){y=n[q];b=c.findField(y);if(b.isDirty()){A[y]=b.getValue()}}if(Ext.isEmpty(A)){continue}A.id=o;g.push(A)}p=Ext.apply({episodes:Ext.encode(g)},x)}else{if(this.data_video_rec){x=Ext.apply({video_id:this.data_video_rec.get("id")},x);if(!f){var k=c.findField("tvshow_original_available")||c.findField("original_available")||c.findField("record_date");var B=c.findField("title");var u=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();var z=c.findField("season"),l=c.findField("episode");var v=false;if(z&&l){v=z.isDirty()||l.isDirty()}if(!k.isDirty()&&!B.isDirty()&&!v){o=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurId();B=SYNO.SDS.VideoStation.Util.SEC_CFG[o].title;var e=String.format(_VST("metadata","correct_metadata_confirm"),B);this.getMsgBox().confirm(this.title,e,function(j){if(j==="yes"){this.onApply(true)}else{this.mun(this,"beforeclose",this.getTabPanel().onBeforeDeactivate,this);this.getTabPanel().resetAllForm();this.onHideDialog()}},this);return}}}else{x=Ext.apply({id:this.data_id},x)}}var a=c.findField("record_date");if(a){var t=c.findField("original_available");a=(Ext.form.DateField.superclass.getValue.call(t)+" "+a.getValue());Ext.apply(x,{record_date:a,original_available:""})}if(!this.episode_recs&&this.searchmetadata&&this.searchmetadata!==this.getTitleAndDateString()){Ext.apply(x,{extra:"",tvshow_extra:""})}var d=this.episode_recs?"edit_adv":"edit";var m=this._getHistoryInfo().webAPIID;if(this._getHistoryInfo().id===SYNO.SDS.VideoStation.Util._COLLECTION_ID){m=this.getWebAPIID()}if(this._getHistoryInfo().id===SYNO.SDS.VideoStation.Util._TVSHOW_ID){Ext.apply(x,{update_tvshow:this.fromInternet||false})}Ext.apply(x,{library_id:this._getCurLibraryId()});this.getTabPanel().applyAllForm({method:d,api:m},x,p)},getID:function(){var a=this._getHistoryInfo();var b=a.params?(a.params.type||a.id):a.id;return(b==="tvshow_episode")?"tvshow":b},isTVShowEpisode:function(){var a=this._getHistoryInfo();return(a.type==="tvshow_episode")},getTabPanel:function(){if(!this.tabPanel){var a=[this.getMetadataPanel()];a.push(this.getPosterPanel());var b={owner:this,activeTab:0,checkFormDirty:true,items:a,listeners:{applysuccess:(function(f,c,j,g){var e=this._getHistoryInfo();var d=e.type;if(e.id===SYNO.SDS.VideoStation.Util._COLLECTION_ID){d=e.params?(e.params.type||e.id):e.id}this.setting_count=this.setting_count||1;var l=Ext.isBoolean(this.blOverwrite)?this.blOverwrite:true;if(this.episode_recs||!this.getPosterPanel().getForm().findField("poster").isDirty()||1<this.setting_count||!l){(function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").layout.activeItem.onActivate(false)}).defer(100);return true}var k=j.id||this.data_id;this.setting_count++;this.getTabPanel().applyAllForm({method:"setimage",api:"SYNO.VideoStataion.Poster"},{id:k,type:this.data_video_rec?"video":d,url:this.getPosterPanel().getForm().findField("url").getValue()});SYNO.SDS.VideoStation.Util.setModImgTime(d,k);return false}).createDelegate(this),loadsuccess:(function(){var c=SYNO.SDS.VideoStation.Util.onGetHeight(this.getMetadataPanel(),140);this.setHeight(c<350?350:c)}).createDelegate(this),requestfail:(function(e,c,g,f){if(!c&&g&&(422===g.code)){var d=new SYNO.SDS.VideoStation.MetaDataConfirmDialog({owner:this});this.mon(d,"onapply",function(j,k){this.blOverwrite=k;this.onApply(true,{overwrite:k?"overwrite":"skip"})},this,{single:true});d.show()}else{this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation.Util.getWebAPIErr(c,g,f),function(j){},this)}this.setting_count=0}).createDelegate(this)}};this.tabPanel=new SYNO.SDS.VideoStation.MetadataTabPanel(b)}return this.tabPanel},getMetadataPanel:function(){if(this.metadataPanel){return this.metadataPanel}return(this.metadataPanel=new SYNO.SDS.VideoStation.MetadataPanel({title:_VST("metadata","title"),owner:this}))},getPosterPanel:function(){if(this.PosterPanel){return this.PosterPanel}return(this.PosterPanel=new SYNO.SDS.VideoStation.PosterPanel({title:_VST("poster","title"),owner:this}))},getWebAPIID:function(){var a=this._getHistoryInfo();if(a.params&&a.params.type){return SYNO.SDS.VideoStation.Util.getinfo_WebAPI(a.params.type).api}else{return a.webAPIID}}});Ext.define("SYNO.SDS.VideoStation.MetadataTabPanel",{extend:"SYNO.SDS.Utils.SettingTabPanel",loadAllForm:function(b,a){if(!b){SYNO.Debug("No api in TabPanel");return}this.load_apimethod=b.method;if(false===this.onBeforeRequest(b,a)){return false}this.sendAjaxRequest(b,a)},applyAllForm:function(b,a,c){if(!b){SYNO.Debug("No url in TabPanel");return false}this.save_apimethod=b.method;if(this.checkFormDirty&&!this.isAnyFormDirty()){this.owner.mun(this.owner,"beforeclose",this.onBeforeDeactivate,this);this.owner.onHideDialog();return true}if(false===this.onBeforeRequest(b,a)){return false}if(!Ext.isDefined(c)){c=c||{};this.items.each(function(l,f,k){if(!l.getForm){return}var j=l.getForm();var e=j.getValues();if(j.findField("original_available")&&!j.findField("original_available").isDirty()){delete e.original_available}var d=j.findField("tvshow_original_available");if(d&&d.isYear()){e.tvshow_original_available=d.getYearValue()}if(j.findField("extra")&&!j.findField("extra").isDirty()){delete e.extra}if(j.findField("tvshow_extra")&&!j.findField("tvshow_extra").isDirty()){delete e.tvshow_extra}var g;for(g in e){if(e.hasOwnProperty(g)){if(Ext.isArray(e[g])){e[g]=e[g].join("|")}if(j.findField(g)&&j.findField(g).disabled){delete e[g]}}}Ext.apply(c,e)},this)}else{c=c||{}}a=a||{};Ext.apply(c,a);this.sendAjaxRequest(b,c)},sendAjaxRequest:function(b,a){if(b.method===this.load_apimethod){this.owner.setStatusBusy()}else{this.owner.setStatusBusy({text:_T("common","saving")})}SYNO.API.currentManager.requestAjaxAPI(b.api,b.method||"getinfo",b.version||1,{timeout:3600000},a,this.onRequestDone,this)},onBeforeRequest:function(c,b){var a=this.getAllForms();var d=true;if(c.method===this.load_apimethod){return true}Ext.each(a,function(g,e,f){if(!g.isValid()){d=false;this.setActiveByForm(g,e);return false}},this);if(!d){return false}return true},onRequestDone:function(a,d,c,b){if(this.isDestroyed){return}this.owner.clearStatusBusy();if(!a){this.reportFail(a,d,b.params)}else{this.reportSuccess(a,d,b.params)}},reportSuccess:function(a,d,c){var b=c.method;if(b===this.save_apimethod){this.owner.setStatusOK();if(false!==this.fireEvent("applysuccess",this,a,d,c)){this.owner.mun(this.owner,"beforeclose",this.onBeforeDeactivate,this);this.owner.onHideDialog()}return}this.items.each(function(j,e,g){if(j.loadResponse){j.loadResponse(d)}else{if(j.getForm){var f=j.getForm();f.loadRecord(d);return}}},this);this.fireEvent("loadsuccess",this,a,d,c)},reportFail:function(a,c,b){this.fireEvent("requestfail",this,a,c,b)}});Ext.define("SYNO.SDS.VideoStation.MetaDataConfirmDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){var b={owner:a.owner,resizable:false,minimizable:false,maximizable:false,closable:true,stateful:false,buttonAlign:"center",width:400,height:240,title:_VST("action","edit_metadata"),items:[this.getFormPanel()],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:27,fn:this.close,scope:this}]};SYNO.SDS.VideoStation.MetaDataConfirmDialog.superclass.constructor.call(this,b)},getFormPanel:function(){if(this.form){return this.form}var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getCurId();this.form=new SYNO.ux.FormPanel({items:[{xtype:"syno_displayfield",value:String.format(_VST("metadata","duplicate_desc"),SYNO.SDS.VideoStation.Util.SEC_CFG[a].title)},{xtype:"radiogroup",itemId:"mode",columns:1,vertical:true,hideLabel:true,items:[{xtype:"syno_radio",boxLabel:_VST("metadata","duplicate_keep"),inputValue:"skip",name:"mode",checked:true},{xtype:"syno_radio",boxLabel:_VST("metadata","duplicate_replace"),name:"mode",inputValue:"overwrite",checked:false}]}]});return this.form},onApply:function(){var a=false;if("overwrite"===this.getFormPanel().getForm().findField("mode").getValue().inputValue){a=true}this.fireEvent("onapply",this,a);this.close()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.VideoListDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){var b=this.fillConfig(a);SYNO.SDS.VideoStation.VideoListDialog.superclass.constructor.call(this,b);this.createPollingTask()},getTBar:function(a){return[{xtype:"syno_button",itemId:"play",text:_VST("action","play"),handler:function(){var b;if(!(b=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}SYNO.SDS.VideoStation.Util.onPlayAction(this,b.data,SYNO.SDS.VideoStation.Util.getPlayAdditionalInfo())},scope:this},{xtype:"syno_button",itemId:"open_folder",text:_VST("action","open_folder"),hidden:(_S("standalone")||!SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.App.FileStation3.Instance")),handler:function(){var b;if(!(b=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}SYNO.SDS.VideoStation.Util.onOpenContainingFolder(b.get("sharepath"))},scope:this},{xtype:"syno_button",itemId:"view_video_info",text:_VST("action","view_video_info"),handler:function(){var c;if(!(c=this.onGetSelectedFile())){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","select_one"));return}var b=new SYNO.SDS.VideoStation.VideoInfoDialog({owner:this});b.onLoad(c)},scope:this}]},getGrid:function(a){if(this.grid){return this.grid}this.grid=new SYNO.ux.GridPanel({stripeRows:true,itemId:"grid",border:false,store:this.getStore(),tbar:this.getTBar(),bbar:[{itemId:"desc",xtype:"displayfield",value:_VST("error","select_one_video")}],cm:this.getColumnModel(),sm:new Ext.grid.RowSelectionModel({single:true})});return this.grid},fillConfig:function(a){var b=Ext.apply({cls:"syno-vs-video-list-win",owner:this._getOwner(),width:650,height:400,minWidth:200,minHeight:200,title:_VST("app","displayname"),layout:"fit",items:this.getGrid(),buttons:[{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:27,scope:this,handler:this.close}]});return b},getStore:function(){if(this.store){return this.store}return(this.store=new Ext.data.JsonStore({autoLoad:false,idProperty:"id",fields:["id","path","sharepath","duration","filesize","resolutionx","resolutiony","container_type","video_codec","audio_codec","frame_bitrate"]}))},getColumnModel:function(){if(this.colmodel){return this.colmodel}this.colmodel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[{header:_VST("file","file_name"),dataIndex:"sharepath",sortable:true,width:150,align:"left",renderer:(function(g,e,a,d,f,b){g=SYNO.SDS.VideoStation.Util.parseFullPathToFileName(g);var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_VST("file","file_path"),dataIndex:"sharepath",sortable:true,width:250,align:"left",renderer:(function(g,e,a,d,f,b){var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_VST("duration","title"),dataIndex:"duration",sortable:true,width:100,align:"left",renderer:(function(g,e,a,d,f,b){var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)},{header:_T("common","size"),dataIndex:"filesize",sortable:true,width:100,align:"left",renderer:(function(g,e,a,d,f,b){if(Ext.isEmpty(g)){return""}g=Ext.util.Format.fileSize(g);var c=Ext.util.Format.htmlEncode(g);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}).createDelegate(this)}]});return this.colmodel},onLoadData:function(a){this.mon(this,"show",function(){if(this.grid&&!this.onGetSelectedFile()){this.grid.getSelectionModel().selectRow(0)}},this,{single:true,buffer:100});this.show();this.getStore().loadData(a)},onGetSelectedFile:function(){return this.grid.getSelectionModel().getSelected()},createPollingTask:function(){this.pollingTask=this.addTask({interval:800,scope:this,run:function(){if(this.isDestroyed){this.pollingTask.stop();return}var a=false;if(this.onGetSelectedFile()){a=true}this.getTopToolbar().items.each(function(b){b.setDisabled(!a)})}}).start()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.VideoInfoDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){var b=this.fillConfig(a);SYNO.SDS.VideoStation.VideoInfoDialog.superclass.constructor.call(this,b)},fillConfig:function(a){var b={cls:"syno-vs-video-info-win",owner:this._getOwner(),width:500,height:400,minWidth:200,minHeight:200,title:_VST("action","view_video_info"),layout:"fit",items:[{itemId:"form",xtype:"syno_formpanel",border:false,autoFlexcroll:true,labelWidth:130,defaults:{anchor:"100%"},items:[{itemId:"file_name",name:"file_name",xtype:"syno_displayfield",style:"word-wrap: break-word",fieldLabel:_VST("file","file_name")},{itemId:"file_path",name:"file_path",xtype:"syno_displayfield",style:"word-wrap: break-word",fieldLabel:_VST("file","file_path")},{itemId:"duration",name:"duration",xtype:"syno_displayfield",fieldLabel:_VST("duration","title")},{itemId:"filesize",name:"filesize",xtype:"syno_displayfield",fieldLabel:_T("common","size")},{itemId:"resolution",name:"resolution",xtype:"syno_displayfield",fieldLabel:_VST("video_info","resolution")},{itemId:"container_type",name:"container_type",xtype:"syno_displayfield",fieldLabel:_VST("video_info","container")},{itemId:"video_codec",name:"video_codec",xtype:"syno_displayfield",fieldLabel:_VST("video_info","video_codec")},{itemId:"audio_codec",name:"audio_codec",xtype:"syno_displayfield",fieldLabel:_VST("video_info","audio_codec")},{itemId:"video_bitrate",name:"video_bitrate",xtype:"syno_displayfield",fieldLabel:_VST("video_info","video_bitrate")}]}],buttons:[{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},formatBitrate:function(c){var b=parseInt(c,10);var a=(b/1024).toFixed(1);return String.format("{0} Kbps",a)},onLoad:function(c){var a=this.get("form").getForm();if("aac_invalid"===c.get("audio_codec")){c.data.audio_codec="aac"}a.loadRecord(c);var b=c.get("path");a.setValues({file_name:SYNO.SDS.VideoStation.Util.parseFullPathToFileName(b),file_path:c.get("sharepath"),resolution:c.get("resolutionx")+" X "+c.get("resolutiony"),filesize:Ext.util.Format.fileSize(c.get("filesize")),video_bitrate:this.formatBitrate(c.get("frame_bitrate"))});this.show();this.setHeight(SYNO.SDS.VideoStation.Util.onGetHeight(this.get("form"),120))}});Ext.define("SYNO.SDS.VideoStation.VideoSelectionDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",displayNum:300,constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)]);this.createPollingTask()},fillConfig:function(a){var b={cls:"syno-vs-video-selection-dialog",width:750,height:400,minWidth:200,minHeight:200,title:_VST("action","select_db"),layout:"border",border:false,bodyBorder:false,hideBorders:true,items:[this.createTBar(),this.fillGridConfig()],buttons:[this.btnApply=new SYNO.ux.Button({btnStyle:"blue",disabled:true,text:_T("common","commit"),scope:this,handler:this.onApply}),{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onSearch},{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},onApply:function(){var c=this.getSearchPanel().getSelectionModel().getSelected();if(c){var a=this._getCurType(),b=c.data;if("tvshow_episode"===a){b={tvshow_original_available:c.data.original_available,tvshow_summary:SYNO.SDS.VideoStation.Util.getAddtionalText(c.data,"summary"),title:c.data.title}}this.owner.onSetMetaData(b)}this.close()},getSearchPanel:function(){if(this.searchPanel){return this.searchPanel}return(this.searchPanel=this.getComponent("grid"))},createPollingTask:function(){var a=this.addTask({interval:800,scope:this,run:function(){if(this.isDestroyed){a.stop();return}if(this.getSearchPanel().getSelectionModel().getSelected()){this.btnApply.enable()}else{this.btnApply.disable()}}}).start()},createTBar:function(){var a=[this.searchfield=new SYNO.ux.TextFilter({itemId:"search_field",emptyText:_VST("search","keyword"),flex:1}),{xtype:"tbspacer",width:6},this.btnSearch=new SYNO.ux.Button({text:_VST("search","title"),tooltip:_VST("search","title"),itemId:"search",scope:this,handler:this.onSearch})];return{region:"north",height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-window-tbar",items:[{flex:1,height:28,xtype:"container",border:false,layout:"hbox",layoutConfig:{type:"hbox",align:"stretch",pack:"start"},cls:"x-toolbar x-toolbar-cell",style:"border-top:0 none;",items:a}]}},fillGridConfig:function(a){this.paging=new SYNO.ux.PagingToolbar({store:this.getStore(),pageSize:this.displayNum,displayInfo:true});var b=Ext.apply({xtype:"syno_gridpanel",cls:"syno-vs-video-selection-grid",stripeRows:true,loadMask:true,region:"center",itemId:"grid",border:false,autoExpandMin:160,autoExpandColumn:"title",bbar:this.paging,store:this.getStore(),cm:this.getColumnModel(),sm:new Ext.grid.RowSelectionModel({single:true}),viewConfig:{autoFill:true,forceFit:true,scrollDelay:false,cacheSize:50,rowHeight:27},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{scope:this,rowdblclick:function(c,j,d){var g=c.getSelectionModel();var f=g.getSelected();if(!f){return}this.onApply()}}});return b},getColumnModel:function(){if(this.colModel){return this.colModel}var a=this._getCurType();this.colModel=new Ext.grid.ColumnModel({defaults:{align:"left",sortable:true},columns:[{id:"title",autoExpand:true,header:_VST("common","title"),dataIndex:"title",sortable:true,width:200,autoExpand:true,renderer:(function(j,f,b,e,g,c){var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{id:"original_available",header:a==="home_video"?_VST("video_info","record_time"):_VST("original_available","title"),dataIndex:a==="home_video"?"record_date":"original_available",sortable:true,width:150,renderer:(function(j,f,b,e,g,c){if(j==="0"){j=""}var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)},{sortable:false,id:"additional",header:_VST("summary","title"),dataIndex:"additional",width:300,renderer:(function(j,f,b,e,g,c){if(!j||!j.summary){return}j=j.summary;var d=Ext.util.Format.htmlEncode(j);f.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d}).createDelegate(this)}]});return this.colModel},getRoot:function(a){switch(a){case SYNO.SDS.VideoStation.Util._MOVIE_ID:return"movies";case SYNO.SDS.VideoStation.Util._TVSHOW_ID:case SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID:return"tvshows";case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:return"videos";default:return""}},getStore:function(){if(this.store){return this.store}var b,c=this._getCurType(),a;if(c==="tvshow_episode"){c="tvshow"}a=SYNO.SDS.VideoStation.Util.SEC_CFG[c];b=a.webAPIID;root=this.getRoot(c);return(this.store=new Ext.data.JsonStore({autoDestroy:true,autoLoad:true,method:"POST",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},remoteSort:true,sortInfo:{field:"title",direction:"ASC"},proxy:new SYNO.API.Proxy({api:b,method:"search",version:1,listeners:{scope:this,beforeload:function(d,e){var f=d.activeRequest.read;if(f){Ext.Ajax.abort(f)}}}}),baseParams:{additional:"summary,actor,writer,director,extra,genre"},root:root,totalProperty:"total",fields:["id","title","tagline","original_available","record_date","metadata_locked","additional"],listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onStoreLoad,exception:this.onExceptionLoadStore}}))},onSearch:function(){var a=this.searchfield.getValue();a=a.trim();if(Ext.isEmpty(a)){this.getStore().load({offset:0});return}this.getStore().load({params:{offset:0,keywords:Ext.encode({title:a,actor:a,director:a,writer:a})}})},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{library_id:this._getCurLibraryId(),offset:Ext.isDefined(c.offset)?c.offset:this.paging.cursor,limit:this.paging.pageSize});return c},onStoreLoad:function(){if(this.isDestroyed){return}if(!this.getSearchPanel().getSelectionModel().getSelected()){this.getSearchPanel().getSelectionModel().selectRow(0)}},onExceptionLoadStore:function(b,c,d,a,e){var f=SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("error","error_error_system"));this.getMsgBox().alert(_VST("app","displayname"),f,function(){this.close()},this);SYNO.Debug("Ajax load failure ",arguments)},onLoad:function(c,b,a){this.show();this.searchfield.setValue(c)}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.PathHistoryMgr=Ext.extend(Ext.util.Observable,{init:function(){this.objHistory={};this.objHistoryFileName={};var a=[SYNO.SDS.VideoStation.Util._MOVIE_ID,SYNO.SDS.VideoStation.Util._TVSHOW_ID,SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,SYNO.SDS.VideoStation.Util._TV_RECORDER_ID];Ext.each(SYNO.SDS.VideoStation.Util.SEC_LIST,function(d){this.pushHistory(d,{id:d},0);if(-1!==a.indexOf(d)){var b="recently_added";var c={id:d};if(SYNO.SDS.VideoStation.Util._TV_RECORDER_ID!==d){Ext.apply(c,{params:{category:b,category_id:-1,name:this.getClassName(b)}})}this.pushHistory(d,c,2)}},this)},constructor:function(a){this.init();SYNO.SDS.VideoStation.Window.addPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr",this);SYNO.SDS.VideoStation.PathHistoryMgr.superclass.constructor.call(this,a)},initLibrary:function(a){var e=SYNO.SDS.VideoStation.Util;var f=a.id;var c=a.type;if(Ext.isDefined(e.SEC_CFG[f])&&e.SEC_CFG[f].type===c){return}e.SEC_CFG[f]=SYNO.Util.copy(e.SEC_CFG[c]);e.SEC_CFG[f].title=String(a.title);e.SEC_CFG[f].data[2].name=String(a.title);e.SEARCH_HISTORY[f]="all";this.pushHistory(f,{id:f},0);var b="recently_added";var d={id:f,params:{category:b,category_id:-1,name:this.getClassName(b)}};this.pushHistory(f,d,2)},onGotoNext:function(b,a){var c=this.curID;if(this.pushHistory(c,{id:c,params:SYNO.Util.copy(b||{})},a)){this.onGotoPanel(c)}},onGotoBack:function(a){if(0===a){return}if(!a){var b=(this.getHistoryInfo(this.curID,this.objHistory[this.curID].length-2));if(b){a=b.index}else{a=0}}this.onGotoPanel(this.curID,a)},getCfg:function(b,e,a){var d=SYNO.SDS.VideoStation.Util.SEC_CFG[e].data;if(!d){return false}for(var c=a;c<d.length;c++){if(d[c].subtype===b){break}}return SYNO.Util.copy(d[c])},onSetGotoCfg:function(d,c,b){this.oldID=this.curID||d;this.curID=d;if(Ext.isDefined(c)){var a=[];Ext.each(this.objHistory[d],function(e){if(e.index>c){return false}if(!Ext.isFunction(b)||b(e)){a.push(e)}if(e.index===c){return false}});this.objHistory[d]=SYNO.Util.copy(a)}},onGotoSearch:function(a){var g=this.curID;var b=0,d,f;var e={id:g};if(a===true){f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.SearchField").getValue();f=f.trim()}if(g==="collection"){d=this.getHistoryInfo(this.curID,1);this.onSetGotoCfg(g,1,function(j){return !("classes"==j.subtype)});if(a===true){Ext.apply(e,{status:{},searchval:f})}this.objHistory[g][this.objHistory[g].length]=Ext.apply(this.getCfg("search",g,b+1),e)}else{searchCategory=SYNO.SDS.VideoStation.Util.SEARCH_HISTORY[g];if("all"===searchCategory){if(this.objHistory[g].length>1){d=this.getHistoryInfo(this.curID,1);if(d.index===2&&!Ext.isEmpty(d.status)){Ext.apply(e,{status:SYNO.Util.copy(d.status)})}if(this.objHistory[g].length>2){d=this.getHistoryInfo(this.curID,2);if(d.index===3&&!Ext.isEmpty(d.searchval)){Ext.apply(e,{searchval:d.searchval})}}}this.onSetGotoCfg(g,b,function(j){return !("classes"===j.subtype||"listdir"===j.subtype)});this.pushHistory(g,e,2);if(a===true){Ext.apply(e,{status:{},searchval:f})}this.objHistory[g][this.objHistory[g].length]=Ext.apply(this.getCfg("search",g,b+1),e)}else{var c;this.onSetGotoCfg(g,0);Ext.apply(e,{name:this.getClassName(searchCategory),category:searchCategory,sort_by:searchCategory,filter:f});c={id:g,params:SYNO.Util.copy(e||{})};this.pushHistory(g,c,1)}}this.setMainItem(g);this.updatePathBar()},getClassName:function(a){switch(a){case"all":return _VST("classification","all");case"actor":return _VST("classification","actor");case"director":return _VST("classification","director");case"genre":return _VST("classification","genre");case"writer":return _VST("classification","writer");case"year":return _VST("classification","year");case"recently_added":return _VST("classification","recently_added");default:return a}},onGotoClasses:function(c,b){if(this.curID==="collection"){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ListPanel").selectItemById(c);this.curID=c}this.onSetGotoCfg(c,0);this.pushHistory(c,{id:c,params:{category:b.category,name:this.getClassName(b.category)}},1);var a={id:c,params:SYNO.Util.copy(b||{})};this.objHistory[c][this.objHistory[c].length]=Ext.apply(this.getCfg("list",c,2),a);this.setMainItem(c);this.updatePathBar()},onGotoPanel:function(e,b,d){if(Ext.isDefined(b)){var c=SYNO.SDS.VideoStation.Util.SEC_CFG[e].data;if(!c){return false}if(c[b]&&c[b].subtype==="search"){this.onGotoSearch();return}}this.onSetGotoCfg(e,b);this.setMainItem(e);var a=true;if(Ext.isDefined(d)){a=!d}this.updatePathBar(a)},pushHistory:function(g,e,b){if(!this.objHistory[g]){this.objHistory[g]=[]}var d=SYNO.SDS.VideoStation.Util.SEC_CFG[g].data;if(!d){return false}var a;if(e&&e.params&&e.params.category&&"folder"===e.params.category){var f=4;var c=5;if(SYNO.SDS.VideoStation.Util._TVSHOW_ID===this.getCurLibraryType()){f=f+1;c=c+1}if(e.params.dirtype&&"file"===e.params.dirtype){a=SYNO.Util.copy(d[f])}else{a=SYNO.Util.copy(d[c])}if(this.objHistory[g][this.objHistory[g].length-1]){a.index=b||this.objHistory[g][this.objHistory[g].length-1].index+1}}else{if(!Ext.isDefined(b)){b=this.getHistoryInfo().index+1}if(!d[b]){return false}if(d[b].subtype==="search"){b++}a=SYNO.Util.copy(d[b])}this.objHistory[g][this.objHistory[g].length]=Ext.apply(a,SYNO.Util.copy(e||{}));return true},getCardPanel:function(){return SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel")},setMainItem:function(d){var a=this.objHistory[d][this.objHistory[d].length-1].layoutCfg;var c=this.getCardPanel().layout.activeItem,b=SYNO.SDS.VideoStation.Window.getPanelScope(a);this.fireEvent("beforeactivate",this,b,this.objHistory[d][this.objHistory[d].length-1]);if(c!==b){this.getCardPanel().layout.setActiveItem(b)}else{if(b.onActivate){b.onActivate()}}},getMainItem:function(a){return this.getCardPanel().getComponent(a)},getActiveItem:function(){return this.getCardPanel().layout.activeItem},getCurId:function(){return this.curID||SYNO.SDS.VideoStation.Util.SEC_LIST[0]},getCurType:function(){return this.getHistoryInfo().type},getCurLibraryId:function(){return Ext.isNumber(this.curID)?this.curID:0},getHistoryInfo:function(b,a){if(!Ext.isDefined(b)){b=this.getCurId()}if(!Ext.isDefined(a)){a=this.objHistory[b].length-1}return this.objHistory[b][a]},onClickBtn:function(a){this.onGotoPanel(a.id,a.index,true)},updatePathBar:function(g){var f=0,d=0;var b=this.objHistory[this.curID];var l=SYNO.SDS.VideoStation.Util;var e=true;switch(this.getCurLibraryType()){case l._MOVIE_ID:case l._TVSHOW_ID:case l._HOME_VIDEO_ID:case l._TV_RECORDER_ID:case l._COLLECTION_ID:SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathBar").getPanel().show();var k=[];for(f=0;f<b.length;f++){var c=this.getHistoryInfo(this.curID,f);var a=c.name;if(c.params&&c.params.name){a=c.params.name}if(this.getCurLibraryType()===l._TV_RECORDER_ID&&c.index===2&&!a){continue}if(l._checkIsByfolder()){if(c.params&&c.params.dirtype&&"file"===c.params.dirtype){e=false}if(c.params&&c.params.dirtype&&"file"===c.params.dirtype&&!this.objHistoryFileName[this.curID]&&g){this.objHistoryFileName[this.curID]=a}if(c.params&&c.params.dirtype&&"file"===c.params.dirtype&&this.objHistoryFileName[this.curID]){a=this.objHistoryFileName[this.curID]}}k[d]={text:Ext.util.Format.ellipsis(a,100),tooltip:a,callback:this.onClickBtn.createDelegate(this,[c])};d++}if(e){this.objHistoryFileName[this.curID]=false}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathBar").addPathButtons(k);break;default:SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathBar").getPanel().hide();break}},getCurLibraryType:function(){var a=this.getCurType();return a===SYNO.SDS.VideoStation.Util._TVSHOW_EPISODE_ID?SYNO.SDS.VideoStation.Util._TVSHOW_ID:a}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.TpSettingPanel=Ext.extend(SYNO.ux.Panel,{constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.TpSettingPanel.superclass.constructor.call(this,b)},fillConfig:function(a){this.owner=a.owner;var b={region:"center",layout:"vbox",layoutConfig:{type:"vbox",align:"stretch",pack:"start"},items:[this.grid=new SYNO.SDS.VideoStation.TpGrid({owner:this._getOwner(),border:true,flex:0.8})]};Ext.apply(b,a);return b},isDirty:function(){return this.grid.isDirty()},load:function(b){var a;if(b==this.grid.lnb){return}this.grid.lnb=b;var d=("add_lnb"==this.grid.lnb)?"get_tp_default":"get_tp";var c={tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite,lnb:this.grid.lnb};this._getOwner().setStatusBusy();SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,d,this.owner.ChannelScanAPIVerion,c,this.grid.onLoadDone,this.grid)},onSave:function(){this.owner.setStatusBusy();this.grid.onClickSave(this.onSaveDone)},onSaveDone:function(a,c,b){this.owner.clearStatusBusy();if(!a){this.owner.alertErrorMesg(a,c,b);return}this.owner.close()}});SYNO.SDS.VideoStation.TpGrid=Ext.extend(SYNO.ux.GridPanel,{constructor:function(b){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,b);SYNO.SDS.VideoStation.Util._initUtilFnWrappers.call(this,["_getAction","_createActions","_createAction"]);this.owner=b.owner;this.clickedDefault=false;var a=Ext.apply({stripeRows:true,cls:"syno-vs-setting-grid",itemId:"grid",border:false,store:this.getStore(),tbar:this.createActions(),columns:this.getColumnModel(),plugins:[this.enableColumn],selModel:new Ext.grid.RowSelectionModel({single:true,listeners:{selectionchange:{fn:this.onChgButtonStatus,buffer:50,scope:this}}}),viewConfig:{scrollDelay:false,cacheSize:50,rowHeight:24},getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},listeners:{rowcontextmenu:{scope:this,fn:function(d,f,c){c.preventDefault();var e=d.getSelectionModel();e.selectRow(f,e.isSelected(f))}},rowdblclick:function(){this.openTpDialog("edit_tp")},scope:this}},b);SYNO.SDS.VideoStation.TpGrid.superclass.constructor.call(this,a);this.addManagedComponent(this.getStore())},createActions:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[{text:_T("common","create"),itemId:"create",scope:this,handler:function(b,a){this.openTpDialog("create_tp")}},{text:_T("common","alt_edit"),itemId:"edit",disabled:true,scope:this,handler:function(b,a){this.openTpDialog("edit_tp")}},{text:_T("common","delete"),itemId:"delete",disabled:true,scope:this,handler:this.onClickDelete},{text:_VST("dtvsscan","apply_default"),scope:this,handler:this.onClickDefault}]})},onClickDefault:function(){this.clickedDefault=true;var a={tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite,lnb:this.owner.lnbSettingPanel.form.getValues().profile};this._getOwner().setStatusBusy();SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,"get_tp_default",this.owner.ChannelScanAPIVerion,a,this.onLoadDone,this)},onClickDelete:function(){this.owner.getMsgBox().confirm(this.title,_VST("dtvsscan","delete_cfrmrm"),function(a){if("yes"===a){var b=this.selModel.getSelected();this.store.modified.remove(b);this.store.removed.push(b);this.store.remove(b)}},this)},onClickSave:function(c){var a=[];Ext.each(this.store.data.items,function(f,d,e){a.push(f.data)},this);var b={tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite,lnb:this.lnb,tps:Ext.encode(a)};SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,"save_tp",this.owner.ChannelScanAPIVerion,b,c,this)},getColumnModel:function(){if(this.colModel){return this.colModel}this.enableColumn=new SYNO.ux.EnableColumn({dataIndex:"checked",width:50,align:"center",menuDisabled:true,enableFastSelectAll:true});this.colModel=new Ext.grid.ColumnModel({defaults:{align:"center"},columns:[this.enableColumn,{header:_VST("video_info","frequency")+"(MHz)",dataIndex:"freq",sortable:true,width:180},{header:_VST("dtvsscan","symbol_rate")+"(Ksym/s)",dataIndex:"sr",width:180},{header:_VST("dtvsscan","polarisation"),dataIndex:"pol",width:90}]});return this.colModel},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.ArrayStore({autoDestroy:true,sortInfo:{field:"freq",direction:"ASC"},fields:["freq","sr","pol","checked"],data:[]});this.addManagedComponent(this.store);return this.store},onLoadDone:function(a,d,c){this._getOwner().clearStatusBusy();if(!a){this.alertErrorMesg(a,d,c);return}var b=[];Ext.each(d.tps,function(g,e,f){b.push([g.freq,g.sr,g.pol,g.checked])},this);this.store.loadData(b,false);if(this.store.getCount()){this.getSelectionModel().selectFirstRow()}else{this.onChgButtonStatus()}},isDirty:function(){return(0<this.store.getModifiedRecords().length||0<this.store.removed.length||this.clickedDefault)},onChgButtonStatus:function(){if(_S("demo_mode")){return}var a=this.getSelectionModel().getCount();this.getTopToolbar().getComponent("edit").setDisabled(1!==a);this.getTopToolbar().getComponent("delete").setDisabled(0===a)},openTpDialog:function(d){var a={freq:"",sr:"",pol:"V"};var b=-1;if("edit_tp"==d){if(1!=this.selModel.getCount()){return}a=this.selModel.getSelected().data;b=this.store.indexOf(this.selModel.getSelected())}var c=new SYNO.SDS.VideoStation.TpDialog({owner:this._getOwner(),store:this.store,method:d,index:b,values:a,grid:this});c.open()}});SYNO.SDS.VideoStation.TpDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){this.init(a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.TpDialog.superclass.constructor.call(this,b)},init:function(a){this.owner=a.owner;this.method=a.method;this.store=a.store;this.values=a.values;this.index=a.index;this.grid=a.grid;Ext.form.VTypes.normalname=/^[^\:"<>\*\\\/\|\?\,]*$/;Ext.form.VTypes.first_digital=/^[\d]/;Ext.form.VTypes.only_dash=/^-+$/},fillConfig:function(a){var c=new SYNO.ux.FormPanel(SYNO.LayoutConfig.fill({fileUpload:false,labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:false,labelWidth:130,defaults:{width:189},items:[{xtype:"syno_textfield",fieldLabel:_VST("video_info","frequency")+"(MHz)",name:"freq",allowBlank:false,maxLength:64,value:this.values.freq,stripCharsRe:/(^\s+|\s+$)/g,validator:function(d){return Ext.form.VTypes.only_digital.test(d)&&d==0||(d>2999&&d<20001)}},{xtype:"syno_textfield",fieldLabel:_VST("dtvsscan","symbol_rate")+"(Ksym/s)",name:"sr",allowBlank:false,maxLength:16,value:this.values.sr,stripCharsRe:/(^\s+|\s+$)/g,validator:function(d){var e=parseInt(d,10);return Ext.form.VTypes.only_digital.test(d)}},{xtype:"syno_combobox",fieldLabel:_VST("dtvsscan","polarisation"),name:"pol",value:this.values.pol,store:new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[["H","H"],["V","V"]]}),triggerAction:"all",resizable:false,editable:false,displayField:"display",valueField:"value",mode:"local"}]}));var b={width:400,height:260,minWidth:300,minHeight:240,layout:"fit",plain:true,buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,disabled:_S("demo_mode"),hidden:!_S("is_admin"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onSave},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:[10,13],scope:this,handler:this.onSave},{key:27,scope:this,handler:this.onCancel}],items:[c],listeners:{scope:this,beforeshow:this.beforeShow}};Ext.apply(b,a);return b},beforeShow:function(){var a=this.items.get(0).getForm();a.findField("freq").clearInvalid();a.findField("sr").clearInvalid();if("edit_tp"==this.method){this.setTitle(_VST("dtvsscan","edit_transponder"))}else{this.setTitle(_VST("dtvsscan","add_transponder"))}return},onSave:function(){var c=this.items.get(0).getForm();if(!c.isValid()){return}if(!c.isDirty()){this.close();return}var d=c.getValues();if(-1==this.index){var e=d.freq+"_"+d.sr+"_"+d.pol;if(this.store.getById(e)){this.owner.getMsgBox().alert(this.title,_T("error","error_file_exist"));return}var a=new this.store.recordType({checked:true,freq:parseInt(d.freq,10),sr:parseInt(d.sr,10),pol:d.pol});a.markDirty();this.store.addSorted(a);var b=this.store.indexOf(a);this.grid.getSelectionModel().selectRow(b);this.grid.getView().getRow(b).scrollIntoView();this.close()}else{this.store.getAt(this.index).set("pol",d.pol);this.store.getAt(this.index).set("freq",parseInt(d.freq,10));this.store.getAt(this.index).set("sr",parseInt(d.sr,10));this.close()}return},onCancel:function(){this.close()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.LnbSettingPanel=Ext.extend(SYNO.ux.FormPanel,{constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.init(a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.LnbSettingPanel.superclass.constructor.call(this,b);var c=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enablediseqc",["diseqc"])},init:function(a){this.owner=a.owner;this.params=this.owner.params;this.lnbpreset=this.params.preset;Ext.form.VTypes.normalname=/^[^\:"<>\*\\\/\|\?\,]*$/;Ext.form.VTypes.only_dash=/^-+$/;Ext.form.VTypes.only_digital=/^([0-9]+)$/},fillConfig:function(b){var a=("customize"==this.params.profile)?false:true;this.lnbNameItems=new SYNO.ux.FieldSet(SYNO.LayoutConfig.fill({title:"LNB",hidden:this.params.preset,items:[{xtype:"syno_textfield",fieldLabel:_VST("dtvsscan","lnb_name"),name:"name",value:this.params.name,width:189,allowBlank:false,maxLength:32,stripCharsRe:/(^\s+|\s+$)/g,validator:function(e){return Ext.form.VTypes.normalname.test(e)&&!Ext.form.VTypes.only_dash.test(e)}}]}));this.displayLnbNameItems=new SYNO.ux.FieldSet({title:"LNB",hidden:!this.params.preset,items:[{xtype:"syno_displayfield",fieldLabel:_VST("dtvsscan","lnb_name"),name:"display_name",value:this.params.name,width:189}]});this.displayLnbItems=new SYNO.ux.FieldSet({title:_VST("dtvsscan","general_setting"),hidden:!this.params.preset,defaults:{width:189},items:[{xtype:"syno_displayfield",fieldLabel:_VST("dtvsscan","lnb_type"),value:this.params.profile,name:"display_profile"},{xtype:"syno_displayfield",fieldLabel:"Low Band(MHz)",value:this.params.low,name:"display_low"},{xtype:"syno_displayfield",fieldLabel:"High Band(MHz)",value:this.params.high,name:"display_high"},{xtype:"syno_displayfield",fieldLabel:_VST("dtvsscan","switch")+"(MHz)",value:this.params["switch"],name:"display_switch"}]});this.lnbItems=new SYNO.ux.FieldSet(SYNO.LayoutConfig.fill({title:_VST("dtvsscan","general_setting"),hidden:this.params.preset,defaults:{width:189},items:[{xtype:"syno_combobox",fieldLabel:_VST("dtvsscan","lnb_type"),value:this.params.profile,name:"profile",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createProfileStore(),editable:false,displayField:"display",valueField:"profile",hiddenName:"profile",allowBlank:false,width:189,mode:"local",listeners:{scope:this,select:function(e,f,g){var j=f.data;this.setLnbProfile(j)},expand:function(e){if(e.wrap.getWidth()>=e.list.getWidth()){e.list.setSize(e.wrap.getWidth(),0)}else{e.list.setSize("auto",0)}}}},{xtype:"syno_textfield",fieldLabel:"Low Band(MHz)",disabled:a,value:this.params.low,name:"low",allowBlank:false,maxLength:5,validator:function(e){var f=parseInt(e,10);return Ext.form.VTypes.only_digital.test(e)&&0==f||(20001>f&&2999<f)}},{xtype:"syno_textfield",fieldLabel:"High Band(MHz)",disabled:a,value:this.params.high,name:"high",allowBlank:false,maxLength:5,validator:function(e){var f=parseInt(e,10);return Ext.form.VTypes.only_digital.test(e)&&0==f||(20001>f&&2999<f)}},{xtype:"syno_textfield",fieldLabel:_VST("dtvsscan","switch")+"(MHz)",disabled:a,value:this.params["switch"],name:"switch",allowBlank:false,maxLength:5,validator:function(e){var f=parseInt(e,10);return Ext.form.VTypes.only_digital.test(e)&&0==f||(20001>f&&2999<f)}}]}));var d=SYNO.LayoutConfig.fill({xtype:"syno_fieldset",title:_VST("dtvsscan","adv_setting"),defaults:{width:189},items:[{xtype:"syno_checkbox",hideLabel:true,triMode:false,boxLabel:_VST("dtvsscan","use_diseqc"),value:this.params.enablediseqc,name:"enablediseqc",checked:this.params.enablediseqc},{xtype:"syno_combobox",indent:1,fieldLabel:"DiSEqC",value:this.params.diseqc,name:"diseqc",triggerAction:"all",resizable:false,store:new Ext.data.ArrayStore({fields:["value","display"],data:[[0,0],[1,1],[2,2],[3,3]]}),editable:false,displayField:"display",valueField:"value",mode:"local"},{xtype:"syno_textfield",value:this.params.name,name:"lnb",hidden:true}]});var c={labelWidth:200,autoFlexcroll:true,trackResetOnLoad:true,hideMode:"offsets",items:[this.lnbNameItems,this.displayLnbNameItems,this.lnbItems,this.displayLnbItems,d]};Ext.apply(c,b);return c},createProfileStore:function(){var b=[["C-BAND","C-BAND","5150","0","0"],["C-MULTI","C-MULTI","5150","5750","0"],["DBS","DBS","11250","0","0"],["ENHANCED","ENHANCED","9750","0","0"],["STANDARD","STANDARD","10000","0","0"],["UNIVERSAL","UNIVERSAL","9750","10600","11700"]];if("customize"==this.params.profile){b.push(["customize",_T("common","customize"),this.params.low,this.params.high,this.params["switch"]])}else{b.push(["customize",_T("common","customize"),"","",""])}var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["profile","display","low","high","switch"],data:b});this.addManagedComponent(a);return a},setLnbProfile:function(g){var e=this.form.findField("profile");var b=this.form.findField("low");var l=this.form.findField("high");var j=this.form.findField("switch");var a=this.form.findField("display_profile");var k=this.form.findField("display_low");var f=this.form.findField("display_high");var d=this.form.findField("display_switch");var c=("customize"==g.profile)?false:true;e.setValue(g.profile);b.setValue(g.low);l.setValue(g.high);j.setValue(g["switch"]);a.setValue(g.profile);k.setValue(g.low);f.setValue(g.high);d.setValue(g["switch"]);b.setDisabled(c);l.setDisabled(c);j.setDisabled(c)},isDirty:function(){var b=this.form.isDirty();if(b){var a=this.form.findField("enablediseqc");a.setDisabled(true);if(false==this.form.isDirty()&&"false"==a.originalValue&&!a.getValue()){b=false}a.setDisabled(false)}return b},onSave:function(){var a=this.getForm();if(!a.isValid()){var b=this.owner.tabPanel;if(b.getActiveTab()!=this){b.setActiveTab(this)}return}a.submit({url:Ext.urlAppend(this._getWebAPIURL(this.owner.APIUrl)),params:{method:this.params.method,version:this.owner.ChannelScanAPIVerion,api:this.owner.ChannelScanAPI,tuner:this.owner.tunerInfo.id,satellite:this.owner.satellite},failure:function(e,f){if(f.result.error&&f.result.error.code){var d=f.result.error.code;var c=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d);this.owner.getMsgBox().alert(_VST("action","channelscan"),c)}},success:this.onSaveSuccess,scope:this})},onSaveSuccess:function(e,f){var b=this.owner.owner.LnbCombo;var j=b.getStore();var g=this.owner.owner.lnbData;var a={name:e.findField("name").getValue(),low:parseInt(e.findField("low").getValue(),10),high:parseInt(e.findField("high").getValue(),10),"switch":parseInt(e.findField("switch").getValue(),10),diseqc:parseInt(e.findField("diseqc").getValue(),10),profile:e.findField("profile").getValue(),enablediseqc:"true"==e.findField("enablediseqc").getValue()?true:false};var c=e.findField("lnb").getValue();var d=a.name;if(c){if(c!=d){j.remove(j.data.map[c])}Ext.each(g,function(m,k,l){if(c==m.name){a.preset=m.preset;a.tp_count=m.tp_count;g[k]=a}return},this)}else{this.owner.tpSettingPanel.grid.lnb=d;a.preset=false;a.tp_count=0;g.push(a)}if(c!=d){j.add(new j.recordType({value:d,display:d},d));this.owner.owner.sortLnbCombo(j);b.setValue(d);b.nextSibling().setDisabled(false)}this.owner.onApplySecond()}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.DVBSSettingDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){this.init(a);var b=this.fillConfig(a);SYNO.SDS.VideoStation.DVBSSettingDialog.superclass.constructor.call(this,b)},init:function(a){this.owner=a.owner;this.ChannelScanAPI=this.owner.ChannelScanAPI;this.ChannelScanAPIVerion=this.owner.ChannelScanAPIVerion;this.APIUrl=this.owner.APIUrl;this.tunerInfo=this.owner.tunerInfo;this.params=a.params;this.satellite=this.params.satellite;this.lnb=this.params.lnb},fillConfig:function(a){var b={title:this.satellite,width:490,height:520,minWidth:400,minHeight:280,layout:"fit",items:[this.getTabPanel()],buttons:[{btnStyle:"red",hidden:true,id:"dvbssettings_deletebtn",text:_T("common","delete"),scope:this,handler:this.tabPanel.onDelete},{btnStyle:"blue",disabled:_S("demo_mode"),text:_T("common","ok"),scope:this,handler:this.tabPanel.onApply},{text:_T("common","cancel"),scope:this,handler:this.tabPanel.onClose}],listeners:{scope:this,beforeshow:{fn:this.onBeforeShow,scope:this,single:true}}};Ext.apply(b,a);return b},open:function(a){this.tpSettingPanel.load(this.lnb);SYNO.SDS.VideoStation.DVBSSettingDialog.superclass.open.apply(this,arguments)},onBeforeShow:function(){var a=SYNO.SDS.Desktop?SYNO.SDS.Desktop.getEl().getHeight():Ext.lib.Dom.getViewHeight();if(a<this.getHeight()){this.setSize(this.getWidth(),a)}},getTabPanel:function(){if(!this.tabPanel){var a={owner:this,height:380,activeTab:0,items:[this.getLnbSettingPanel(),this.getTPSettingPanel()]};this.tabPanel=new SYNO.SDS.VideoStation.LnbSettingTabpanel(a)}return this.tabPanel},getLnbSettingPanel:function(){if(this.lnbSettingPanel){return this.lnbSettingPanel}return(this.lnbSettingPanel=new SYNO.SDS.VideoStation.LnbSettingPanel({title:"LNB",owner:this}))},getTPSettingPanel:function(){if(this.tpSettingPanel){return this.tpSettingPanel}return(this.tpSettingPanel=new SYNO.SDS.VideoStation.TpSettingPanel({title:_VST("dtvsscan","transponder"),owner:this}))},onApplySecond:function(){if(this.tpSettingPanel.isDirty()||"add_lnb"==this.lnb){this.tpSettingPanel.onSave()}else{this.close()}return},alertErrorMesg:function(a,d,c){this.clearStatusBusy();if(d.code&&d.code<400){this.getMsgBox().alert(_VST("action","channelscan"),SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code);this.getMsgBox().alert(_VST("action","channelscan"),b)}}});SYNO.SDS.VideoStation.LnbSettingTabpanel=Ext.extend(SYNO.SDS.Utils.SettingTabPanel,{defineBehaviors:function(){SYNO.SDS.VideoStation.LnbSettingTabpanel.superclass.defineBehaviors.apply(this,arguments);this.ERR_STR_FN=_VST;this.ERR_STR_STRUCT=SYNO.SDS.Strings["SYNO.SDS.VideoStation.AppInstance"]},onBeforeRequest:function(a){return SYNO.SDS.VideoStation.LnbSettingTabpanel.superclass.onBeforeRequest.apply(this,arguments)},onApply:function(){if(this.lnbSettingPanel.isDirty()||"add_lnb"==this.tpSettingPanel.grid.lnb){this.lnbSettingPanel.onSave()}else{this.onApplySecond()}},onDelete:function(){if(!this.satellite||!this.lnb){return}this.owner.getMsgBox().confirm(_VST("action","channelscan"),_VST("dtvsscan","delete_cfrmrm"),function(a){if("yes"===a){SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"delete_lnb",this.ChannelScanAPIVerion,{satellite:this.satellite,lnb:this.lnb,tuner:this.tunerInfo.id},this.tabPanel.onDeleteDone,this)}},this)},onDeleteDone:function(b,g,f){if(!b){this.owner.alertErrorMesg(b,g,f)}else{var c=this.owner.LnbCombo;var d=c.getStore();var a,e=[];Ext.each(this.owner.lnbData,function(l,j,k){if(this.lnb==l.name){return}if(!a){a=l.name}e.push(l)},this);this.owner.lnbData=e;d.remove(d.data.map[this.lnb]);this.owner.sortLnbCombo(d);if(a){c.setValue(a)}else{c.setValue("add_lnb")}}this.close()},onApplyRequestFail:function(a,b,c){},onLostChangeClose:function(a){this.owner.getMsgBox().confirm(_VST("action","channelscan"),_T("common","confirm_lostchange"),function(b){if("yes"===b){this.owner.close()}else{this.setActiveTab(a)}},this)},onClose:function(){var a=this.tabPanel.getActiveTab();if(a.isDirty()){this.tabPanel.onLostChangeClose(a)}else{if(a.previousSibling()&&a.previousSibling().isDirty()){this.tabPanel.onLostChangeClose(a.previousSibling())}else{if(a.nextSibling()&&a.nextSibling().isDirty()){this.tabPanel.onLostChangeClose(a.nextSibling())}else{this.close()}}}},onBeforeTabChange:function(c,a,d){if(a.disabled===true){return false}var b=Ext.getCmp("dvbssettings_deletebtn");if(a instanceof Ext.form.FormPanel){b.setVisible(!a.lnbpreset&&"add_lnb"!=a.owner.lnb)}else{b.setVisible(false)}return true}});Ext.define("SYNO.SDS.VideoStation.ChannelScanDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.init(a);this.callParent([this.fillConfig(a)])},init:function(a){this.tunerInfo=a.tunerInfo;this.tunerType={FE_QPSK:0,FE_QAM:1,FE_OFDM:2,FE_ATSC:3}},fillConfig:function(a){var b={width:420,height:240,minWidth:300,minHeight:200,title:_VST("action","channelscan"),layout:"fit",items:[this.initFormConfig()],buttons:[{btnStyle:"blue",text:_VST("action","scan"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onScanHandler},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:[10,13],scope:this,handler:this.onScanHandler},{key:27,scope:this,handler:this.onCancel}],listeners:{scope:this,beforeshow:this.beforeShow}};Ext.apply(b,a);return b},beforeShow:function(){if(this.tunerInfo.type==this.tunerType.FE_QPSK){var a=this.LnbSettingBtn.getWidth();if(a>60){this.setWidth(360+a)}}return true},onCancel:function(){this.hide();if(this.hasScaned){this.hasScaned=false;this.reloadProgramList()}},onScanHandler:function(){if(_S("demo_mode")){this.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));return}if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")&&"country_value"===this.CountryCombo.getValue()){this.getMsgBox().alert(this.title,_VST("dtvtscan","choose_conutry_model"));return}if(this.tunerInfo.type==this.tunerType.FE_QPSK&&("satellite_value"==this.SatelliteCombo.getValue()||"lnb_value"==this.LnbCombo.getValue()||"add_lnb"==this.LnbCombo.getValue())){this.getMsgBox().alert(this.title,_VST("dtvsscan","choose_satellite_lnb"));return}if(this.tunerInfo.type!==this.tunerType.FE_QPSK&&-1===this.tunerInfo.title.indexOf("HDHomeRun")&&("country_value"===this.CountryCombo.getValue()||"region_value"===this.RegionCombo.getValue())){this.getMsgBox().alert(this.title,_VST("dtvtscan","choose_conutry_region"));return}if(this.tunerInfo.type!==this.tunerType.FE_QPSK&&this.SelectCountry&&this.SelectRegion){this.getMsgBox().confirm(this.title,_VST("action","rescan_message"),function(a){if("yes"===a){this.sendStartScan()}},this)}else{this.sendStartScan()}},sendStartScan:function(){this.getEl().mask(_VST("action","scanning"),"x-mask-loading");var a={tuner:this.tunerInfo.id};if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.satellite=this.SatelliteCombo.getValue();a.lnb=this.LnbCombo.getValue()}else{if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")){a.country=this.CountryCombo.getValue();a.region=this.modelCombo.getValue()}else{a.country=this.CountryCombo.getValue();a.region=this.RegionCombo.getValue()}}SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"start",this.ChannelScanAPIVerion,a,this.startScanDone,this)},startScanDone:function(a,c,b){if(!a){this.alertErrorMesg(a,c,b);return}this.ScanPollingTask=this.addAjaxTask({id:"channelScanPollingTask",interval:5000,autoJsonDecode:true,url:this._getWebAPIURL(this.APIUrl),params:{api:this.ChannelScanAPI,version:this.ChannelScanAPIVerion,method:"status",tuner:this.tunerInfo.id},success:this.updateScanProgress,failure:function(d,e){this.getEl().unmask();SYNO.Debug("Ajax load failure ",d)},scope:this});this.ScanPollingTask.start();this.getMsgBox().show({title:_VST("action","scanning"),progress:true,closable:true,hideDlg:false,width:310,minWidth:250,buttons:Ext.MessageBox.CANCEL,fn:this.pauseButton,scope:this})},updateScanProgress:function(b,c){if(!b.success){this.ScanPollingTask.remove();this.getMsgBox().hide();var a=_T("common","error_system");if(b.error&&b.error.code){a=SYNO.SDS.VideoStation.Util.mappingDTVStatus(b.error.code)}this.getMsgBox().alert(this.title,a);this.getEl().unmask();return}if(!b.data){return}var d;if(100===b.data.progress){d=_VST("action","scanning_finish")+"<br />"+String.format(_VST("action","scan_finish_show"),b.data.scaned_count);this.updateProgress=this.getMsgBox().updateProgress(1,"",d);this.updateProgress.fbButtons.cancel.setText(_T("common","close"));this.updateProgress.setTitle(_VST("dtv","title_scan_done"));this.ScanPollingTask.remove()}else{if((0!==b.data.scaned_count&&!b.data.service_name)||"(null)"===b.data.service_name||"null"===b.data.service_name||null===b.data.service_name){d=_VST("action","unknown_channel")+"<br />"+String.format(_VST("action","scan_total_show"),b.data.scaned_count)}else{if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")&&50<=b.data.progress){d=_VST("dtvtscan","scan_epging")}else{d=b.data.service_name+"<br />"+String.format(_VST("action","scan_total_show"),b.data.scaned_count)}}if(b.data.lnb_name){d="LNB - "+b.data.lnb_name+"<br />"+d}this.getMsgBox().updateProgress(b.data.progress/100,"",d)}},reloadProgramList:function(){var a=this.owner.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramList;this.owner.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.owner.Channel_API,"list",this.owner.Channel_APIVerion,{tuner:this.tunerInfo.id,offset:0,limit:-1},a.channelListDone,a);return},pauseButton:function(a,b){var c=true;if(this.updateProgress){c=false;this.updateProgress=null;this.reloadProgramList();this.hide()}if(c){if(!this.getEl().isMasked()){this.getEl().mask(_T("common","saving"),"x-mask-loading")}this.ScanPollingTask.remove();SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"stop",this.ChannelScanAPIVerion,{tuner:this.tunerInfo.id},this.stopScanDone,this)}this.hasScaned=true},stopScanDone:function(a,c,b){if(!a){this.alertErrorMesg(a,c,b);return}if(this.getEl().isMasked()){this.getEl().unmask()}},show:function(){if(!this.defined){this.defineBehaviors();this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,"getconfig",this.ChannelScanAPIVerion,{tuner:this.tunerInfo.id},this.getConfigDone,this)}this.setPosition(this.x,this.y);SYNO.SDS.VideoStation.ChannelScanDialog.superclass.show.apply(this,arguments)},defineBehaviors:function(){this.defined=true;this.TunerAPI="SYNO.DTV.Tuner";this.TunerAPIVersion="1";if(this.tunerInfo.type==this.tunerType.FE_QPSK){this.ChannelScanAPI="SYNO.DTV.DVBSScan";this.ChannelScanAPIVerion="1";this.APIUrl="dvbsscan.cgi"}else{this.ChannelScanAPI="SYNO.DTV.ChannelScan";this.ChannelScanAPIVerion="1";this.APIUrl="channelscan.cgi"}},initFormConfig:function(){this.CountryCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dtvtscan","country"),name:"country",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createCountryStore(),editable:false,displayField:"display",valueField:"value",value:"country_value",mode:"local",listeners:{scope:this,select:this.onChangeCountry,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.RegionCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dtvtscan","region"),name:"region",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createRegionStore(),editable:false,displayField:"display",valueField:"value",value:"region_value",mode:"local",listeners:{scope:this,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.modelCombo=new SYNO.ux.ComboBox({fieldLabel:_VST("dtvtscan","model"),name:"model",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createModelStore(),editable:false,displayField:"display",valueField:"value",value:"region_value",mode:"local",hidden:true,listeners:{scope:this,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.SatelliteCombo=new SYNO.ux.ComboBox({name:"satellite",triggerAction:"all",resizable:false,listWidth:"auto",store:this.createSatelliteStore(),editable:false,displayField:"display",valueField:"value",value:"satellite_value",mode:"local",listeners:{scope:this,select:this.onChangeCountry,beforeselect:this.beforeSatelliteSelect,expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});this.LnbCombo=new SYNO.ux.ComboBox({listWidth:"auto",name:"lnb",editable:false,resizable:false,store:this.createLnbStore(),mode:"local",triggerAction:"all",displayField:"display",valueField:"value",value:"lnb_value",allowBlank:false,listeners:{scope:this,beforeselect:this.beforeLnbSelect,select:function(e,c,d){this.LnbSettingBtn.setDisabled(false)},expand:function(c){if(c.wrap.getWidth()>=c.list.getWidth()){c.list.setSize(c.wrap.getWidth(),0)}else{c.list.setSize("auto",0)}}}});var a=[{xtype:"syno_displayfield",name:"tuner",fieldLabel:_VST("schedule","channel"),fieldLabel:_VST("dongle","tuner"),value:this.tunerInfo.title}];if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.push({xtype:"syno_compositefield",fieldLabel:_VST("dtvsscan","satellite"),items:[this.SatelliteCombo,this.SatelliteBtn=new SYNO.ux.Button({disabled:true,text:_T("common","alt_edit"),scope:this,handler:this.launchSatelliteSettingDialog})]})}else{a.push(this.CountryCombo)}if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.push({xtype:"syno_compositefield",fieldLabel:"LNB",items:[this.LnbCombo,this.LnbSettingBtn=new SYNO.ux.Button({text:_VST("action","settings"),disabled:true,scope:this,handler:function(){var c=this.LnbCombo.getValue();return this.launchLnbSettingDialog(c)}})]})}else{a.push(this.RegionCombo);a.push(this.modelCombo)}var b={xtype:"syno_formpanel",url:this._getWebAPIURL(this.APIUrl),fileUpload:false,itemId:"channelscanform",labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:false,labelWidth:100,items:a};return b},launchSatelliteSettingDialog:function(){this.setSatelliteEditBtn();if(this.SatelliteBtn.disabled){return}var a=new SYNO.SDS.VideoStation.SatelliteDialog({owner:this,satellite:this.SatelliteCombo.value});a.open();return},launchLnbSettingDialog:function(c){var b=this.SatelliteCombo.getValue();var a={};if("satellite_value"==b){this.getMsgBox().alert(this.title,_VST("dtvsscan","choose_satellite_lnb"));return}if("add_lnb"==c){a={name:"",low:"5150",high:"0","switch":"0",diseqc:"0",profile:"C-BAND",preset:false,enablediseqc:false};a.method="create_lnb"}else{Ext.each(this.lnbData,function(f,d,e){if(c==f.name){a=f;a.method="edit_lnb"}},this)}if(!a.method){this.getMsgBox().alert(this.title,_VST("dtvsscan","choose_satellite_lnb"));return}a.satellite=b;a.lnb=c;this.lnbSettingDialog=new SYNO.SDS.VideoStation.DVBSSettingDialog({owner:this,params:a});this.lnbSettingDialog.open();return},createCountryStore:function(){this.defCountryValue=["country_value",_VST("action","select_country")];var a=new Ext.data.ArrayStore({autoDestroy:true,id:0,fields:["value","display"],data:[this.defCountryValue]});this.addManagedComponent(a);return a},createRegionStore:function(){this.defRegionValue=["region_value",_VST("action","select_region")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[this.defRegionValue]});this.addManagedComponent(a);return a},createModelStore:function(){this.defmodelValue=["region_value",_VST("dtvtscan","pls_select_model")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[this.defmodelValue]});this.addManagedComponent(a);return a},createSatelliteStore:function(){this.defmodelValue=["satellite_value",_VST("dtvsscan","pls_select_satellite")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display","preset"],data:[this.defmodelValue]});this.addManagedComponent(a);return a},createLnbStore:function(){this.defmodelValue=["lnb_value",_VST("dtvsscan","pls_select_lnb")];var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[this.defmodelValue]});this.addManagedComponent(a);return a},getConfigDone:function(a,c,b){if(c&&c.select_country&&c.select_region){this.SelectCountry=c.select_country;this.SelectRegion=c.select_region}else{if(c&&c.select_satellite&&c.select_lnb){this.SelectCountry=c.select_satellite;this.SelectRegion=c.select_lnb}else{this.SelectCountry=undefined;this.SelectRegion=undefined}}if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")){this.modelCombo.show();this.RegionCombo.hide()}else{this.modelCombo.hide();this.RegionCombo.show()}this.getCountry()},getCountry:function(){var a;var b=(this.tunerInfo.type==this.tunerType.FE_QPSK)?"get_satellite":"getcountry";SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,b,this.ChannelScanAPIVerion,{tuner:this.tunerInfo.id},this.getCountryDone,this)},getCountryDone:function(a,g,d){if(!a){this.alertErrorMesg(a,g,d);return}if(!g||(!g.country&&!g.satellite)){this.clearStatusBusy();return}var f=false;var e=[];var c=this.CountryCombo;if(g.satellite){e.push(["add_satellite",_VST("dtvsscan","add_satellite"),false]);e.push(["--","--",false]);Ext.each(g.satellite,function(l,j,k){if(this.SelectCountry===l.name){f=true}e.push([l.name,l.name,l.preset])},this);c=this.SatelliteCombo}else{Ext.each(g.country,function(l,j,k){if(this.SelectCountry===l){f=true}e.push([l,l])},this)}var b=c.getStore();b.loadData(e,false);if(!g.satellite){b.sort("display","ASC")}if(this.SelectCountry&&this.SelectRegion&&f){c.setValue(this.SelectCountry);if(this.tunerInfo.type==this.tunerType.FE_QPSK){this.setSatelliteEditBtn()}this.getRegion(this.SelectCountry)}else{this.clearStatusBusy()}},getRegion:function(b){var c=(this.tunerInfo.type==this.tunerType.FE_QPSK)?"get_lnb":"getregion";var a={tuner:this.tunerInfo.id};if(this.tunerInfo.type==this.tunerType.FE_QPSK){a.satellite=b}else{a.country=b}SYNO.API.currentManager.requestAPI(this.ChannelScanAPI,c,this.ChannelScanAPIVerion,a,this.getRegionDone,this)},getRegionDone:function(b,g,f){var c,a,d=false;var e=[];this.clearStatusBusy();if(!b){this.alertErrorMesg(b,g,f);return}if(g.lnb){this.lnbData=g.lnb;c=this.LnbCombo.getStore();this.lnbData.sort(function(k,j){var m=k.name,l=j.name;return(m>l)?1:((l>m)?-1:0)});e.push(["add_lnb",_VST("dtvsscan","add_lnb")]);e.push(["--","--"]);Ext.each(this.lnbData,function(l,j,k){if(!a){a=l.name}if(this.SelectRegion&&l.name==this.SelectRegion){d=true}e.push([l.name,l.name])},this);c.loadData(e,false);this.sortLnbCombo(c);if(this.SelectRegion&&d){this.LnbCombo.setValue(this.SelectRegion);this.LnbSettingBtn.setDisabled(false)}else{if(a){this.LnbCombo.setValue(a);this.LnbSettingBtn.setDisabled(false)}else{this.LnbCombo.setValue("--");this.LnbSettingBtn.setDisabled(true)}}}else{if(-1!==this.tunerInfo.title.indexOf("HDHomeRun")){c=this.modelCombo.getStore();this.modelCombo.setValue([]);Ext.each(g.region,function(l,j,k){if(!a){a=l}if(this.SelectRegion&&l===this.SelectRegion){d=true}e.push([l,l])},this);c.loadData(e,false);c.sort("display","ASC");if(this.SelectRegion&&d){this.modelCombo.setValue(this.SelectRegion)}else{this.modelCombo.setValue(a)}}else{c=this.RegionCombo.getStore();this.RegionCombo.setValue([]);Ext.each(g.region,function(l,j,k){if(!a){a=l}if(this.SelectRegion&&l===this.SelectRegion){d=true}e.push([l,l])},this);c.loadData(e,false);c.sort("display","ASC");if(this.SelectRegion&&d){this.RegionCombo.setValue(this.SelectRegion)}else{this.RegionCombo.setValue(a)}}}},onChangeCountry:function(c,a,b){this.SelectRegion=null;this.getRegion(a.data.value);if(this.tunerInfo.type==this.tunerType.FE_QPSK){this.setSatelliteEditBtn()}},beforeSatelliteSelect:function(c,a,b){if("add_satellite"==a.data.value){this.addSatellite();c.collapse();return false}if("--"==a.data.value){return false}return true},beforeLnbSelect:function(c,a,b){if("add_lnb"==a.data.value){this.launchLnbSettingDialog("add_lnb");c.collapse();return false}if("--"==a.data.value){return false}return true},setSatelliteEditBtn:function(){var c=this.SatelliteCombo.value;var a=this.SatelliteCombo.getStore();var b=a.data.map[c].data.preset;return this.SatelliteBtn.setDisabled(b)},addSatellite:function(){var a=new SYNO.SDS.VideoStation.SatelliteDialog({owner:this,satellite:""});a.open()},setComboToDefault:function(){var d=[],c=[],b=[],a;d.push(this.defCountryValue);a=this.CountryCombo.getStore();a.loadData(d,false);this.CountryCombo.setValue("country_value");c.push(this.defRegionValue);a=this.RegionCombo.getStore();a.loadData(c,false);this.RegionCombo.setValue("region_value");b.push(this.defmodelValue);a=this.modelCombo.getStore();a.loadData(b,false);this.modelCombo.setValue("region_value")},sortLnbCombo:function(a){a.remove(a.data.map["--"]);a.remove(a.data.map.add_lnb);a.sort("display","ASC");var b=[new a.recordType({value:"add_lnb",display:_VST("dtvsscan","add_lnb")},"add_lnb"),new a.recordType({value:"--",display:"--"},"--")];a.insert(0,b)},alertErrorMesg:function(a,d,c){this.clearStatusBusy();if(d.code&&d.code<400){this.getMsgBox().alert(_VST("action","channelscan"),SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code);this.getMsgBox().alert(_VST("action","channelscan"),b)}}});Ext.define("SYNO.SDS.VideoStation.SatelliteDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.init(a);this.callParent([this.fillConfig(a)])},init:function(a){this.owner=a.owner;this.satellite=a.satellite;this.method=(!this.satellite)?"create_satellite":"edit_satellite";Ext.form.VTypes.normalname=/^[^\:"<>\*\\\/\|\?\,]*$/;Ext.form.VTypes.only_dash=/^-+$/},fillConfig:function(a){var c=new SYNO.ux.FormPanel(SYNO.LayoutConfig.fill({fileUpload:false,labelAlign:"left",trackResetOnLoad:true,waitMsgTarget:true,border:false,labelWidth:100,items:[{xtype:"syno_textfield",fieldLabel:_T("common","name"),name:"name",allowBlank:false,maxLength:32,width:189,value:this.satellite,stripCharsRe:/(^\s+|\s+$)/g,validator:function(d){return Ext.form.VTypes.normalname.test(d)&&!Ext.form.VTypes.only_dash.test(d)}},{xtype:"syno_textfield",name:"satellite",value:this.satellite,hidden:true}]}));var b={title:(!this.satellite)?_VST("dtvsscan","add_satellite"):_VST("dtvsscan","edit_satellite"),width:400,height:140,minWidth:300,minHeight:100,layout:"fit",buttons:[{btnStyle:"red",text:_T("common","delete"),scope:this,disabled:_S("demo_mode"),hidden:!_S("is_admin")||(!this.satellite),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onDelete},{btnStyle:"blue",text:_T("common","ok"),scope:this,disabled:_S("demo_mode"),hidden:!_S("is_admin"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onSave},{text:_T("common","cancel"),scope:this,handler:this.onCancel}],keys:[{key:[10,13],scope:this,handler:this.onSave},{key:27,scope:this,handler:this.onCancel}],items:[c],listeners:{scope:this,beforeshow:this.beforeShow}};Ext.apply(b,a);return b},beforeShow:function(){this.alignTo(this.owner.el,"tl-tl",[50,50]);if(!this.satellite){var a=this.items.get(0).getForm();a.findField("name").clearInvalid()}return},onDelete:function(){if(!this.satellite){return}this.getMsgBox().confirm(this.title,_VST("dtvsscan","delete_cfrmrm"),function(a){if("yes"===a){SYNO.API.currentManager.requestAPI(this.owner.ChannelScanAPI,"delete_satellite",this.owner.ChannelScanAPIVerion,{satellite:this.satellite,tuner:this.owner.tunerInfo.id},this.onDeleteDone,this)}},this)},onDeleteDone:function(a,e,d){if(!a){this.owner.alertErrorMesg(a,e,d)}else{var c=this.owner.SatelliteCombo;var b=c.getStore();b.remove(b.data.map[this.satellite]);this.sortSatelliteCombo(b);c.setValue(b.getAt(2).data.value);this.owner.setSatelliteEditBtn();this.owner.getRegion(b.getAt(2).data.value)}this.close()},onSave:function(){var a=this.items.get(0).getForm();if(!a.isValid()){return}if(!a.isDirty()){this.close();return}a.submit({url:this._getWebAPIURL(this.owner.APIUrl),params:{method:this.method,version:this.owner.ChannelScanAPIVerion,api:this.owner.ChannelScanAPI,tuner:this.owner.tunerInfo.id},failure:function(d,e){if(e.result.error&&e.result.error.code){var c=e.result.error.code;var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(c);this.getMsgBox().alert(_VST("action","channelscan"),b)}},success:function(d,e){if(!e||!e.result){return}var c=d.findField("name").getValue();var f=this.owner.SatelliteCombo;var b=f.getStore();if(this.satellite){b.remove(b.data.map[this.satellite])}b.add(new b.recordType({value:c,display:c,preset:false},c));this.sortSatelliteCombo(b);f.setValue(c);this.owner.setSatelliteEditBtn();this.owner.getRegion(c);this.close()},scope:this});return},onCancel:function(){var a=this.items.get(0).getForm();if(!a.isDirty()){this.close();return}this.getMsgBox().confirm(_VST("action","channelscan"),_T("common","confirm_lostchange"),function(b){if("yes"===b){this.close()}},this)},sortSatelliteCombo:function(a){r=[a.getAt(0),a.getAt(1)];a.removeAt(0);a.removeAt(0);a.sort("display","ASC");a.insert(0,r);return}});Ext.define("SYNO.SDS.VideoStation.ChannelEditDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.tunerInfo=a.tunerInfo;this.callParent([this.fillConfig(a)]);this.addManagedComponent(a.store)},fillConfig:function(a){var b={owner:a.owner,width:420,height:600,cls:"syno-vs-video-channel-edit-dialog",title:_VST("action","channeledit"),layout:"fit",items:[this.panel=new SYNO.SDS.VideoStation.ChannelEditPanel({owner:this,store:a.store})],buttons:[{text:_T("common","save"),btnStyle:"blue",scope:this,handler:this.hSave},{text:_T("common","close"),scope:this,handler:this.hClose}]};return b},hSave:function(){if(!this.panel.isChannelChanged){this.close();return}this.setStatusBusy();var a=[];this.panel.store.each(function(c){var d={};d.id=c.get("id");d.title=c.get("title");d.scrambled=c.get("scrambled");a.push(d)},this);var b={tuner:this.tunerInfo.id,channels:Ext.encode(a)};SYNO.API.currentManager.requestAPI(this.owner.Channel_API,"edit",this.owner.Channel_APIVerion,b,this.onSaveDone,this)},onSaveDone:function(a,d,b){this.clearStatusBusy();if(!a){var c="";if(d.code<400){c=SYNO.API.CheckResponse(a,d,b)}else{c=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code)}this.setStatusError({text:c,clear:true})}else{this.owner.ProgramScheduleTabpanel.ProgramGuidePanel.reloadChannels();this.close()}},hClose:function(){if(this.panel.isChannelChanged){this.getMsgBox().confirm("",_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this)}else{this.close()}}});Ext.define("SYNO.SDS.VideoStation.ChannelEditPanel",{extend:"SYNO.ux.GridPanel",isChannelChanged:false,constructor:function(a){this.callParent([this.fillConfig(a)]);this.mon(this.getSelectionModel(),"selectionchange",this.hSelectionChange,this)},fillConfig:function(a){var b={owner:a.owner,enableDragDrop:true,ddGroup:"ChannelListDD",tbar:this.getTopToolbar(),cm:this.getColumnModel(),store:a.store,bbar:this.getBottomToolbar(),listeners:{scope:this,viewready:this.onGridViewReady,afterrender:this.onGridAfterRender,rowclick:this.onGridRowClick,destroy:this.onGridDestroy}};return b},getTopToolbar:function(){if(this.topToolbar){return this.topToolbar}this.topToolbar=new SYNO.ux.Toolbar({items:[this.deleteBtn=new SYNO.ux.Button({text:_T("common","delete"),scope:this,disabled:true,handler:this.onDeleteChannel})]});return this.topToolbar},getBottomToolbar:function(){if(this.bottomToolbar){return this.bottomToolbar}this.bottomToolbar=new SYNO.ux.Toolbar({items:[{xtype:"syno_displayfield",value:'<span class="syno-ux-note">'+_VST("common","hint")+":</span> "+_VST("action","drag_drop_channels")}]});return this.bottomToolbar},getColumnModel:function(){if(this.columnModel){return this.columnModel}this.columnModel=new Ext.grid.ColumnModel([{header:_VST("schedule","channel"),dataIndex:"title",sortable:false}]);return this.columnModel},onDeleteChannel:function(){var a=_VST("action","remove_confirm");this.owner.getMsgBox().confirmDelete("",a,this.deleteChannels,this)},deleteChannels:function(c){if("no"===c){return}var d=this.getSelectionModel();var b=d.getSelections();var a=[];for(i=0;i<b.length;++i){this.store.remove(b[i])}this.isChannelChanged=true},onGridViewReady:function(){this.view.updateScroller()},onGridAfterRender:function(a){if(!this.ChannelDropTarget){this.ChannelDropTarget=new SYNO.SDS.VideoStation.ChannelListDropTarget(a,{panel:a,ddGroup:"ChannelListDD"})}},onGridRowClick:function(a,c,b){if(b&&c&&!b.hasModifier()){a.getSelectionModel().selectRow(c)}},onGridDestroy:function(){if(this.ChannelDropTarget){this.ChannelDropTarget.removeFromGroup(this.ddGroup)}},hSelectionChange:function(){var b=this.getSelectionModel();var a=b.getCount();if(0===a){this.deleteBtn.disable()}else{this.deleteBtn.enable()}}});Ext.define("SYNO.SDS.VideoStation.StreamHintDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(b){this.port=b.port;this.tuner=b.tuner;this.channel=b.channel;var a={title:_VST("action","program_guide"),width:660,height:250,layout:"fit",items:[this.getForm()],buttons:[this.playbtn=new SYNO.ux.Button({btnStyle:"blue",text:_VST("action","play"),scope:this,disabled:_S("demo_mode"),hidden:!SYNO.SDS.VideoStation.Util.ableToPlayDTV(),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:function(){SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{dtv_url:this.stream_url,title:this.channel})}}),{text:_T("common","close"),scope:this,handler:function(){this.close()}}],listeners:{scope:this,show:function(){var c=this.getForm().getForm().findField("url");c.selectText(0,c.length)}}};this.callParent([Ext.apply(a,b)])},getUrlID:function(){if(this.url_id){return this.url_id}this.url_id=Ext.id();return this.url_id},getForm:function(){if(this.form){return this.form}this.stream_url=String.format("{0}//{1}:{2}/VideoStation/livestreaming/{3}",window.location.protocol,window.location.hostname,window.location.port,Ext.isNumber(this.tuner)?this.tuner:0);this.form=new SYNO.ux.FormPanel({items:[{xtype:"syno_displayfield",value:_VST("streaming","streaming_open_ok")},{xtype:"syno_textfield",fieldLabel:_VST("streaming","streaming_url"),cls:"selectabletext allowDefCtxMenu",readOnly:true,width:400,name:"url",id:this.getUrlID(),value:this.stream_url},{xtype:"syno_displayfield",value:String.format(_VST("streaming","streaming_description"),this.port)}]});return this.form}});Ext.ns("SYNO.SDS.VideoStation");Ext.define("SYNO.SDS.VideoStation.ProgramGuideListPanel",{extend:"SYNO.ux.Panel",constructor:function(a){Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.DefaultChannel={title:_VST("schedule","channel"),type:"category",scrambled:false,id:"0@0"};this.dataview=new SYNO.SDS.VideoStation.ListDataView({desc_key:"title",store:this.getStore(),getItemClass:function(d){var c=d.type;if(d.scrambled){c+=" lock"}return c},listeners:{beforeclick:function(d,e,f,c){var g=d.getRecord(f);return("category"===g.get("type"))?false:true},selectionchange:{buffer:100,scope:this,fn:this.onListSelect}}});var b={cls:"syno-vs-dtv-channellist",width:SYNO.SDS.VideoStation.ListDataView.ViewWidth,layout:"fit",items:this.dataview};return Ext.apply(b,a)},getStore:function(){if(this.store){return this.store}this.store=new Ext.data.JsonStore({data:{channels:[this.DefaultChannel]},autoLoad:false,root:"channels",fields:["title","id","scrambled",{name:"type",defaultValue:"item"}]});return this.store},onListSelect:function(b,a){if(0==a.length){return}var d=this.dataview.getRecord(a[0]);var e=d.get("id");if("epgsearchresult"===e){this.isAtChannlelist=false;if(!this.module.ProgramGuidePanel.ProgramGrid.isNewSearch){this.module.ProgramGuidePanel.ProgramGrid.doSearch()}this.module.btnStream.setDisabled(true);var c=this.module.ProgramGuidePanel.ProgramGrid;if(c.programGuideStatus){c.programGuideStatus.stop()}if(c.programGuideStatusForSearch){c.programGuideStatusForSearch.stop()}c.Bbar.hide();c.doLayout();return}this.changeProgramList(e)},changeProgramList:function(a){var b;if(!a){return}this.isAtChannlelist=true;b=this.module.ProgramGuidePanel.ProgramGrid;if(b.programGuideStatus){b.programGuideStatus.stop()}if(b.programGuideStatusForSearch){b.programGuideStatusForSearch.stop()}b.isNewSearch=false;b.Bbar.show();this.module.ProgramGuidePanel.ProgramGrid.doLayout();b.getColumnModel().setConfig(b.ChannelCM,false);b.clearProgramStatus();b.ServiceID=a;this.module.owner.setStatusBusy({text:_T("common","loading")});b.store.load()},channelListDone:function(j,d,b){var m,e,k,a,l;var g=_VST("action","unknown_channel");var f="Unknown";this.module.owner.clearStatusBusy();if(!j){if(d.code<400){this.module.owner.getMsgBox().alert(_VST("schedule","channel"),SYNO.API.CheckResponse(j,d,b))}else{if(403==d.code&&!this.EmptyChannelScanAsked){this.EmptyChannelScanAsked=true;this.launchChannelScanDialog()}else{var o=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code);this.module.owner.getMsgBox().alert(_VST("schedule","channel"),o)}}}else{if(d.channels&&0===d.channels.length){this.module.owner.getMsgBox().alert(_VST("schedule","channel"),_VST("error","dtv_channeltable_not_found"))}}m=this.store;k=this.DefaultChannel;e={channels:[k]};Ext.each(d.channels,function(s,p,q){if(!a){a=s.id}if(f===s.title){l=g}else{l=s.title}k={title:l,id:s.id,scrambled:s.scrambled,type:"item"};e.channels.push(k)},this);m.loadData(e,false);if(a){var c=this.getCurrentRecord();if(!c){this.dataview.select(1)}this.module.btnStream.setDisabled(false||_S("demo_mode"));this.module.btnUpdateEPG.setDisabled(false||_S("demo_mode"));this.recordmenu.getComponent("userdefine_record").setDisabled(false||_S("demo_mode"));this.module.btnDeleteallchannels.setDisabled(false||_S("demo_mode"))}else{var n=this.module.ProgramGuidePanel.ProgramGrid;if(n.getEl().isMasked()){n.getEl().unmask()}this.recordmenu.getComponent("userdefine_record").setDisabled(true);this.module.btnDeleteallchannels.setDisabled(true)}},stream:function(){this.module.owner.setStatusBusy();SYNO.API.currentManager.requestAPI("SYNO.DTV.Controller","setchannel","1",{id:this.getCurrentRecord().id,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.streamDone,this)},streamDone:function(a,c,b){this.module.owner.clearStatusBusy();if(!a){this.module.owner.getMsgBox().alert(_VST("action","program_guide"),SYNO.API.CheckResponse(a,c,b))}else{this.module.owner.owner.mainpanel.mainCardPanel.tunerStatus.restart();this.ChannelName=this.getCurrentRecord().get("title");this.createSteamMsgWindow().open()}},createSteamMsgWindow:function(){var a=9025;if(Ext.isDefined(this.tunerInfo)){a=this.tunerInfo.id%16+a}return new SYNO.SDS.VideoStation.StreamHintDialog({owner:this.module.owner,port:a,tuner:this.tunerInfo.id,channel:this.ChannelName})},requesUpdateEPG:function(){var a=this.module.ProgramGuidePanel.ProgramGrid;if(a.getEl().isMasked()){a.getEl().unmask()}this.module.getEl().mask(_VST("programguide","updating_epg"),"x-mask-loading");SYNO.API.currentManager.requestAPI("SYNO.DTV.Program","update","1",{id:this.getCurrentRecord().id,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.updateEPGDone,this)},updateEPGDone:function(a,d,c){if(!a){this.module.getEl().unmask();var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code);this.module.owner.getMsgBox().alert(_VST("action","program_guide"),b)}else{if(!this.programGuideStatus){this.programGuideStatus=this.module.owner.addAjaxTask({id:"updateGuideStatusPollingTask",interval:5000,autoJsonDecode:true,url:this.module.owner._getWebAPIURL("tuner.cgi"),params:{api:"SYNO.DTV.Tuner",method:"getinfo",version:"1",id:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},success:this.updateGuideStatusDone,failure:function(e,f){this.module.getEl().unmask();SYNO.Debug("Ajax load failure ",e)},scope:this})}this.programGuideStatus.restart()}},updateGuideStatusDone:function(b,c){if(!b.success||!b.data||!b.data.tuners||!b.data.tuners.status||"ready"===b.data.tuners.status){this.module.getEl().unmask();this.programGuideStatus.stop();var a=this.module.ProgramGuidePanel.ProgramGrid;a.store.load()}},launchChannelScanDialog:function(){if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("dtv","error_disabled"));return}if(!this.dialogChannelScan){this.dialogChannelScan=new SYNO.SDS.VideoStation.ChannelScanDialog({owner:this.module.owner,tunerInfo:this.tunerInfo})}this.dialogChannelScan.open()},launchChannelEditDialog:function(){if(true===SYNO.SDS.VideoStation.gData.disable_dtv){this._getOwner().getMsgBox().alert(_VST("app","displayname"),_VST("dtv","error_disabled"));return}var b=[];this.store.each(function(d){if("item"===d.get("type")&&/\d@\d/.test(d.get("id"))){b.push(d.copy())}});var a=new Ext.data.Store({recordType:this.store.recordType});a.add(b);var c=new SYNO.SDS.VideoStation.ChannelEditDialog({owner:this.module.owner,store:a,tunerInfo:this.tunerInfo});c.show()},delteAllChannels:function(){var b="delete_all_channels";var a={tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)};this.module.owner.getMsgBox().confirm(_VST("schedule","channel"),_VST("action","delete_all_channels_confirm"),function(c){if("yes"===c){this.module.getEl().mask(_VST("common","deleting"),"x-mask-loading");SYNO.API.currentManager.requestAPI(this.module.owner.Channel_API,b,this.module.owner.Channel_APIVerion,a,this.delteAllChannelsDone,this)}},this)},delteAllChannelsDone:function(a,d,c){if(this.module.getEl().isMasked()){this.module.getEl().unmask()}if(!a){this.module.owner.getMsgBox().alert(_VST("schedule","channel"),_VST("action","delete_all_channels_failed"))}else{this.module.owner.getMsgBox().alert(_VST("schedule","channel"),_VST("action","delete_all_channels_completed"));var b=this.module.ProgramGuidePanel.ProgramGrid;this.deselect(this.selected);this.store.removeAll();b.store.removeAll();if(b.getEl().isMasked()){b.getEl().unmask()}}this.recordmenu.getComponent("userdefine_record").setDisabled(true);this.module.btnStream.setDisabled(true);this.module.btnUpdateEPG.setDisabled(true);this.module.btnDeleteallchannels.setDisabled(true)},getCurrentRecord:function(){return this.dataview.getSelectedRecords()[0]}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.RepeatScheduleDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){Ext.apply(this,a||{});this.defineBehaviors();var b=this.fillConfig(a);SYNO.SDS.VideoStation.RepeatScheduleDialog.superclass.constructor.call(this,b)},fillConfig:function(a){this.RepeatScheduleFormpanel=new SYNO.SDS.VideoStation.RepeatScheduleFormpanel({owner:this,itemId:"RepeatScheduleFormpanel"});this.pragramstore=this.owner.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramGrid.store;this.schedulestore=this.owner.ProgramScheduleTabpanel.ProgramScheduleGridPanel.store;var b={owner:this.owner,width:430,height:480,minWidth:420,minHeight:450,title:_VST("schedule","schedule"),layout:"fit",items:[this.RepeatScheduleFormpanel],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this.RepeatScheduleFormpanel,handler:this.RepeatScheduleFormpanel.Apply},{text:_T("common","close"),scope:this,handler:this.onCloseDialog}],keys:[{key:[10,13],scope:this.RepeatScheduleFormpanel,handler:this.RepeatScheduleFormpanel.Apply},{key:27,scope:this,handler:this.onCloseDialog}]};Ext.apply(b,a);return b},onCloseDialog:function(){var a=this.RepeatScheduleFormpanel.getForm();if(a.isDirty()&&this.loadsetting){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close()}},this)}else{this.close()}},defineBehaviors:function(){}});Ext.define("SYNO.SDS.VideoStation.RepeatScheduleFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.owner=a.owner;var d="";for(var c=0;c<this.owner.weekdaystatus.length;c++){if(this.owner.weekdaystatus[c]){d+=(0==d.length)?"":",";d+=c}}var b={owner:this.owner,border:false,trackResetOnLoad:true,deferredRender:false,labelWidth:150,items:[{xtype:"syno_displayfield",itemId:"channelname",fieldLabel:_VST("schedule","channel"),value:this.owner.channel_name},{xtype:"syno_displayfield",itemId:"programtitle",fieldLabel:_VST("programguide","title"),value:this.owner.program_title},{xtype:"syno_combobox",fieldLabel:_VST("repeat","repeat"),triggerAction:"all",resizable:false,store:this.createRepeatCycleStore(),editable:false,displayField:"display",valueField:"value",value:this.owner.isweekly?"weekly":"daily",mode:"local",name:"repeat_cycle",listeners:{scope:this,select:this.onChangeRepeatCycle}},{fieldLabel:_VST("repeat","repeat_data"),width:189,name:"repeat_days",xtype:"syno_superboxselect",allowAddNewData:false,editable:false,resizable:true,store:this.createDaysStore(),mode:"local",grow:false,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"display",valueField:"value",value:d,allowBlank:false,settingValue:false,listeners:{beforeremoveitem:function(j,g,k){var e=new Date(this.owner.start_date).getDay();return j.settingValue||(e!==g)},scope:this},resetStore:function(){this.store.clearFilter();if(!this.removeValuesFromStore){return this}this.usedRecords.each(function(e){this.store.add(e)},this);this.usedRecords.clear();this.store.sort(this.valueField,"ASC");return this}},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_displayfield",width:150,value:_VST("repeat","end_day")+_T("common","colon")},{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_never"),inputValue:"never",name:"end_never",checked:(this.owner.end_date&&this.owner.end_date!=="1")?false:true,listeners:{scope:this,check:function(e,f){this.getForm().findField("end_on").setValue(!f);this.getForm().findField("end_value").setDisabled(f)}}}]},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_displayfield",width:150,value:""},{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_on"),inputValue:"on",name:"end_on",checked:(this.owner.end_date&&this.owner.end_date!=="1")?true:false,listeners:{scope:this,check:function(e,f){this.getForm().findField("end_never").setValue(!f)}}},{xtype:"syno_datefield",format:"Y-m-d",name:"end_value",editable:false,allowBlank:false,value:((this.owner.end_date&&this.owner.end_date!=="1")?this.owner.end_date:this.owner.start_date),disabled:(this.owner.end_date&&this.owner.end_date!=="1")?false:true,preFocus:function(){this.el.blur()},validator:(function(f){var g=f.substring(0,4)+f.substring(5,7)+f.substring(8,10);var e=this.owner.start_date.substring(0,4)+this.owner.start_date.substring(5,7)+this.owner.start_date.substring(8,10);if(parseInt(g,10)<parseInt(e,10)){return _VST("repeat","repeat_endday_error")}return true}).createDelegate(this)}]}]};Ext.apply(b,a);SYNO.SDS.VideoStation.RepeatScheduleFormpanel.superclass.constructor.call(this,b)},createDaysStore:function(){var a=new Ext.data.ArrayStore({autoDestroy:true,idIndex:0,fields:["value","display"],data:[[0,_VST("repeat","schedule_sun")],[1,_VST("repeat","schedule_mon")],[2,_VST("repeat","schedule_tue")],[3,_VST("repeat","schedule_wed")],[4,_VST("repeat","schedule_thu")],[5,_VST("repeat","schedule_fri")],[6,_VST("repeat","schedule_sat")]]});return a},createRepeatCycleStore:function(){var a=new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],data:[["weekly",_VST("repeat","repeat_weekly")],["daily",_VST("repeat","repeat_daily")]]});return a},onChangeRepeatCycle:function(e,a,b){var c=this.getForm();var d=this.getForm().findField("repeat_days");if("daily"===a.data.value){d.settingValue=true;d.setValue("0,1,2,3,4,5,6");d.settingValue=false;d.setDisabled(true)}else{d.reset();d.setDisabled(false)}},Apply:function(){var f=false;var c=this.getForm();if(!c.isValid()){return}var e=c.findField("repeat_cycle").getValue();var j=c.findField("repeat_days").getValueEx();var k=c.findField("end_never").getValue();var a=c.findField("end_value").getValue();if(k){end_date=1}else{end_date=a.getFullYear()+"-"+SYNO.SDS.VideoStation.Util.modifyHM(a.getMonth()+1)+"-"+SYNO.SDS.VideoStation.Util.modifyHM(a.getDate());if(0===a.length){this.owner.getMsgBox().alert(this.owner.title,_VST("repeat","repeat_endday_empty"));return}var b=end_date.substring(0,4)+end_date.substring(5,7)+end_date.substring(8,10);var g=this.owner.start_date.substring(0,4)+this.owner.start_date.substring(5,7)+this.owner.start_date.substring(8,10);if(parseInt(b,10)<parseInt(g,10)){this.owner.getMsgBox().alert(this.owner.title,_VST("repeat","repeat_endday_error"));return}}if("weekly"===e){f=true}this.owner.weekdaystatus=[0,0,0,0,0,0,0];j.each(function(l){this.owner.weekdaystatus[l.value]=1},this);var d;this.owner.setStatusBusy({text:_T("common","saving")});if(this.owner.loadsetting){d={id:this.owner.id,start_time:this.owner.start_time,isweekly:f,weekdaystatus:this.owner.weekdaystatus.join(","),end_date:end_date,tuner:Ext.isDefined(this.owner.tunerInfo)?this.owner.tunerInfo.id:0};SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","edit_repeat","1",d,this.ApplyDone,this)}else{d={id:this.owner.id,channel_name:this.owner.channel_name,start_time:this.owner.start_time,start_date:this.owner.start_date,duration:this.owner.duration,title:this.owner.program_title,description:this.owner.description,weekday:this.owner.weekday,isweekly:f,weekdaystatus:this.owner.weekdaystatus.join(","),end_date:end_date,tuner:Ext.isDefined(this.owner.tunerInfo)?this.owner.tunerInfo.id:0};SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","create_repeat","1",d,this.ApplyDone,this)}},ApplyDone:function(a,d,c){this.owner.clearStatusBusy();if(!a){if(d.code<400){this.owner.getMsgBox().alert(this.owner.title,SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code);if(406===d.code){this.owner.getMsgBox().alert(this.owner.title,b,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main").launchSettingDialog(1)},this)}else{this.owner.getMsgBox().alert(this.owner.title,b)}}}else{if(!this.owner.loadsetting){this.owner.pragramstore.load({params:{start:0,limit:-1}})}else{this.owner.schedulestore.reload()}this.owner.close()}}});Ext.define("SYNO.SDS.VideoStation.ProgramGuideGridPanel",{extend:"SYNO.ux.GridPanel",ServiceID:0,Today:null,ShowDay:null,Timezone:null,constructor:function(a){Ext.apply(this,a||{});this.BaseUrl=this.module.owner.owner.jsConfig.jsBaseURL;var b=this.createStore();this.callParent([this.fillConfig(a,b)])},fillConfig:function(a,b){this.ChannelCM=[{id:"schedule",header:_VST("schedule","schedule"),dataIndex:"schedule",width:150,align:"left",renderer:this.scheduleRenderer.createDelegate(this)},{id:"event_name",header:_VST("programguide","title"),dataIndex:"title",width:220,align:"left",renderer:this.titleDesRender.createDelegate(this)},{id:"text_name",header:_VST("programguide","description"),dataIndex:"description",width:230,align:"left",renderer:this.titleDesRender.createDelegate(this)}];this.SearchCM=[{id:"channelname",header:_VST("schedule","channel"),dataIndex:"channel_name",width:90,align:"left",sortable:true,renderer:this.scheduleRenderer.createDelegate(this)},{id:"event_name",header:_VST("programguide","title"),dataIndex:"title",width:140,align:"left",sortable:true,renderer:this.titleDesRender.createDelegate(this)},{id:"text_name",header:_VST("programguide","description"),dataIndex:"description",width:180,align:"left",renderer:this.titleDesRender.createDelegate(this)},{id:"start",header:_T("common","start"),dataIndex:"start",width:140,align:"left",sortable:true,renderer:this.startRenderer.createDelegate(this)},{id:"duration",header:_VST("schedule","duration"),dataIndex:"duration",width:80,align:"left",renderer:this.durationRender.createDelegate(this)}];var c={cls:"syno-vs-dtv-program-grid",border:false,bbar:this.Bbar=this.createBBar(),getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},stripeRows:true,split:false,enableColumnMove:false,enableColLock:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,sm:new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{scope:this,selectionchange:function(j){var e=this.getSelectionModel().getSelections();var g=true,f=true;var d=this.getAllowedRecordes("recorde",e);if(d&&0<d.length){g=false}d=this.getAllowedRecordes("remove",e);if(d&&0<d.length){f=false}this.recordmenu.getComponent("record").setDisabled((_S("demo_mode")||g));this.btnRemove.setDisabled(f)}}}),loadMask:true,store:b,colModel:new Ext.grid.ColumnModel({columns:this.ChannelCM,defaults:{sortable:false,menuDisabled:false,align:"right"}}),listeners:{rowcontextmenu:function(d,j,f){},rowclick:function(d,j,f){if(f&&j&&!f.hasModifier()){d.getSelectionModel().selectRow(j)}},rowdblclick:function(d,j,f){},scope:this}};Ext.apply(c,a);b.on("load",this.onLoad,this);b.on("beforeload",this.onBeforeLoad,this);return c},createStore:function(){var a=new Ext.data.JsonStore({autoLoad:false,pruneModifiedRecords:true,totalProperty:"total",idProperty:"start_time",proxy:new SYNO.API.Proxy({api:this.module.owner.Program_API,method:"list",version:this.module.owner.Program_APIVerion,listeners:{scope:this,load:function(c,d,b){if(!d||!d.id||!d.timezone||!d.day){return}this.ServiceID=d.id;this.Timezone=d.timezone;this.ShowDay=d.day;this.WeekDayNumber=d.weekday;this.WeekDay=SYNO.SDS.VideoStation.Util.getWeekDayfromNumber(this.WeekDayNumber);if(null===this.Today){this.Today=this.ShowDay}this.isFinalProgram=false;if(0===d.programs.length){this.getEl().mask(_VST("dtvtscan","no_data"),"syno-ux-mask-info")}else{if(this.getEl().isMasked()){this.getEl().unmask()}}Ext.each(d.programs,function(g,e,f){if(g.finalprogram){this.isFinalProgram=true}},this);this.handlePreNextDay();this.Bbar.syncSize()}}}),root:"programs",fields:["channel_id","channel_name","start_time","start","schedule","weekday","duration","title","description","status"],baseParams:{start:0,limit:-1,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},listeners:{exception:function(c,d,f,b,g){this.module.owner.clearStatusBusy();var e=SYNO.SDS.VideoStation.Util.mappingDTVStatus(g.code);this.getEl().mask(e,"syno-ux-mask-info")},scope:this}});this.addManagedComponent(a);return a},createBBar:function(){var a=new Ext.Toolbar.TextItem({cls:"date",hidden:true});var b=[{tooltip:_T("common","prevpage"),iconCls:"previous",itemId:"preday",hidden:true,handler:this.requestPreDay,scope:this},a,{tooltip:_T("common","nextpage"),iconCls:"next",itemId:"nexday",hidden:true,handler:this.requestNexDay,scope:this}];var c=new SYNO.ux.Toolbar({cls:"syno-vs-dtv-programguide-bottombar",buttonAlign:"center",items:b});this.btnPreday=c.getComponent("preday");this.txtShowDay=a;this.btnNexday=c.getComponent("nexday");return c},scheduleRenderer:function(j,e,g,d,f,c){var b=SYNO.SDS.VideoStation.Util.programStatus(g.get("status"));e.attr=this.columeUtilRender(j,g);var a=b||"";return['<div class="'+a+'">',"<span>",j,"</span>","</div>"].join("")},titleDesRender:function(g,d,f,c,e,a){var b=Ext.util.Format.htmlEncode(g);d.attr=this.columeUtilRender(b,f);return b},columeUtilRender:function(d,c){var b="";b='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';var a=SYNO.SDS.VideoStation.Util.programStatus(c.get("status"));if("pass"===a){b+='style="color:#96A0AA;"'}else{if("scheduled"===a){b+='style="color:#1470CC;"'}else{if("repeatschedule"===a){b+='style="color:#1470CC;"'}else{b+='style="color:#3C3C3C;"'}}}return b},startRenderer:function(j,d,g,c,f,b){var a;var e=SYNO.SDS.VideoStation.Util.getWeekDayfromNumber(g.get("weekday"));if(e){e=" ("+e+")";a=j+e}else{a=j}d.attr=this.columeUtilRender(a,g);return a},durationRender:function(c,j,e,l,a,k){if(c){var g,f,d;g=SYNO.SDS.VideoStation.Util.modifyHM(c%60);f=SYNO.SDS.VideoStation.Util.modifyHM(((c-g)/60)%60);if(0<(c-(g+f*60))){d=SYNO.SDS.VideoStation.Util.modifyHM((c-(g+f*60))/3600)}else{d=SYNO.SDS.VideoStation.Util.modifyHM(0)}var b=d+":"+f+":"+g;j.attr=this.columeUtilRender(b,e);return b}},onLoad:function(c,f,d){this.module.owner.clearStatusBusy();if(c.getCount()<1){return}c.sort("start_time","ASC");this.HaveCanRecordItem=false;this.HaveRecordItem=false;if(!this.selectRow){this.selectFirsRecordRow(c)}else{this.getSelectionModel().selectRow(this.selectRow)}var b=this.getSelectionModel().getSelections();var e=b.length;var a=false;if(e===1&&"recording"===SYNO.SDS.VideoStation.Util.programStatus(b[0].get("status"))){a=true}this.recordmenu.getComponent("record").setDisabled((_S("demo_mode")||!this.HaveCanRecordItem||a));if(e===1&&!_S("demo_mode")){this.recordmenu.getComponent("repeat_record").setDisabled(false)}this.btnRemove.setDisabled(!this.HaveRecordItem);SYNO.API.currentManager.requestAPI("SYNO.DTV.Tuner","getinfo","1",{id:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.getTunerInfoDone,this);c.each(function(k,j){if(1!==k.get("status")){var g=Math.floor(this.view.el.getHeight()/28);this.view.focusRow.defer(200,this.view,[Math.min(c.getCount()-1,j+Math.floor(g/2))]);return false}},this)},onBeforeLoad:function(a,b){this.getStore().removeAll();if(this.getEl().isMasked()){this.getEl().unmask()}if(0===this.ServiceID){return false}b.params.id=this.ServiceID;if(this.ShowDay){b.params.day=this.ShowDay}if(this.Timezone){b.params.timezone=this.Timezone}},clearProgramStatus:function(){this.Today=null;this.ShowDay=null;this.WeekDayNumber=0;this.WeekDay=null;this.btnPreday.setDisabled(false);this.btnNexday.setDisabled(false);this.ServiceID=0;this.dayComponentShow(false)},dayConvert:function(a){var b,d,c;b=a.substring(0,4)+"/"+a.substring(4,6)+"/"+a.substring(6,8);b=new Date(b);d=SYNO.SDS.VideoStation.Util.modifyHM((parseInt(b.getMonth(),10)+1));c=SYNO.SDS.VideoStation.Util.modifyHM(b.getDate());b=b.getFullYear()+"/"+d+"/"+c;return b},dayComponentShow:function(a){if(a){this.btnPreday.show();this.txtShowDay.show();this.btnNexday.show()}else{this.btnPreday.hide();this.txtShowDay.hide();this.btnNexday.hide()}},handlePreNextDay:function(){var a=this.dayConvert(this.ShowDay);if(this.WeekDay){a=a+" ("+this.WeekDay+")"}this.txtShowDay.setText(a);this.btnPreday.setDisabled((this.Today===this.ShowDay)?true:false);this.btnNexday.setDisabled(this.isFinalProgram);this.dayComponentShow(true)},requestDayCom:function(e){var d,f,b,c;var a=this.ShowDay.substring(0,4)+"/"+this.ShowDay.substring(4,6)+"/"+this.ShowDay.substring(6,8);c=new Date(this.dayConvert(this.ShowDay));if("next"===e){c=new Date(c.valueOf()+60*60*24*1000)}else{c=new Date(c.valueOf()-60*60*24*1000)}d=c.getFullYear();f=SYNO.SDS.VideoStation.Util.modifyHM((parseInt(c.getMonth(),10)+1));b=SYNO.SDS.VideoStation.Util.modifyHM(c.getDate());return(d.toString()+f.toString()+b.toString())},requestNexDay:function(){this.ShowDay=this.requestDayCom("next");this.btnNexday.setDisabled(true);this.store.load()},requestPreDay:function(){this.ShowDay=this.requestDayCom("pre");this.btnPreday.setDisabled(true);this.store.load()},selectFirsRecordRow:function(b){var a;Ext.each(b.data.items,function(e,c,d){a=SYNO.SDS.VideoStation.Util.programStatus(e.data.status);if("pass"!=a&&!this.HaveCanRecordItem){this.getSelectionModel().selectRow(c);this.firstSelectStartTime=e.data.start_time;this.HaveCanRecordItem=true}if(("scheduled"===a||"recording"===a)&&!this.HaveRecordItem){this.HaveRecordItem=true}},this)},getAllowedRecordes:function(e,c){var a=[];var d,b;for(d=0;d<c.length;d++){b=SYNO.SDS.VideoStation.Util.programStatus(c[d].get("status"));if("recorde"===e&&(""===b||"streaming"===b)){a.push(c[d].get("start_time"))}if("remove"===e&&("recording"===b||"scheduled"===b)){a.push(c[d].get("start_time"))}}return a.join(",")},checkBeforeRequest:function(){var a=true;if(_S("demo_mode")){this.module.owner.getMsgBox().alert(_VST("action","settings"),_JSLIBSTR("uicommon","error_demo"));a=false}if(this.getStore().getTotalCount()===0){a=false}if(this.getSelectionModel().hasSelection()===false){this.module.owner.getMsgBox().alert(_VST("action","program_guide"),_VST("action","dvt_cfrm_select"));a=false}return a},requestRecord:function(){if(!this.checkBeforeRequest()){return}var b=[];var c=this.getSelectionModel().getSelections();var a=this.getAllowedRecordes("recorde",c);for(var d=0;d<c.length;d++){if(this.firstSelectStartTime===c[d].get("start_time")){this.disableBtnStream=true}if(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){b.push(c[d].get("channel_id"))}}b=b.join(",");if(this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){params={id:this.ServiceID,start_time:a}}else{params={id:b,start_time:a}}params=Ext.apply({tuner:Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0},params);if(a&&0<a.length){SYNO.API.currentManager.requestAPI(this.module.owner.Schedule_API,"create",this.module.owner.Schedule_APIVerion,params,this.requestDone,this)}},getTunerInfoDone:function(a,c,b){if(!a){return}if(!c.tuners||!c.tuners.additional||!c.tuners.additional.channel_status){return}if(-1!==c.tuners.additional.channel_status.recording_id||this.disableBtnStream){this.module.btnStream.setDisabled(true)}else{this.disableBtnStream=false;this.module.btnStream.setDisabled(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist||_S("demo_mode"))}},requestDone:function(a,f,d){if(this.module.getEl().isMasked()){this.module.getEl().unmask()}var e=_VST("action","program_guide");if(!a){if(f.code<400){this.module.owner.getMsgBox().alert(e,SYNO.API.CheckResponse(a,f,d))}else{var c=SYNO.SDS.VideoStation.Util.mappingDTVStatus(f.code);if(406===f.code){this.module.owner.getMsgBox().alert(e,c,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main").launchSettingDialog(1)},this)}else{this.module.owner.getMsgBox().alert(e,c)}}return}if(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){this.requesthDoneForSearch(d);return}this.store.load({params:{start:0,limit:-1}});this.module.btnStream.setDisabled(this.disableBtnStream||_S("demo_mode"));this.module.owner.updateStreamBtnTask.delay(15000,function(){this.module.owner.updateStreamBtn()},this);if(!this.programGuideStatus){this.programGuideStatus=this.module.owner.addAjaxTask({id:"programGuideStatusPollingTask",interval:10000,autoJsonDecode:true,url:this.module.owner.Program_APIURL,params:{api:this.module.owner.Program_API,method:"list",version:this.module.owner.Program_APIVerion,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0),start:0,limit:-1,id:this.ServiceID,timezone:this.Timezone,day:this.ShowDay},success:this.programGuideStatusDone,failure:function(g,j){SYNO.Debug("Ajax load failure ",g)},scope:this})}if("create"===d.method){var b=new Ext.util.DelayedTask();b.delay(8000,function(){this.programGuideStatus.restart()},this)}},requesthDoneForSearch:function(b){this.doSearch();if(!this.programGuideStatusForSearch){this.programGuideStatusForSearch=this.module.owner.addAjaxTask({id:"programGuideStatusPollingTaskForSearch",interval:11000,autoJsonDecode:true,url:this.module.owner.Program_APIURL,params:{api:this.module.owner.Program_API,method:"search",version:this.module.owner.Program_APIVerion,offset:0,limit:-1,keyword:this.searchkey},success:this.programGuideStatusDone,failure:function(c,d){SYNO.Debug("Ajax load failure ",c)},scope:this})}if("create"===b.method){var a=new Ext.util.DelayedTask();a.delay(8000,function(){this.programGuideStatusForSearch.restart()},this)}},generateRemoveServiceID:function(c){var b=[];var d,a;for(d=0;d<c.length;d++){a=SYNO.SDS.VideoStation.Util.programStatus(c[d].get("status"));if("recording"===a||"scheduled"===a){if(this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){b.push(this.ServiceID)}else{b.push(c[d].get("channel_id"))}}}return b.join(",")},requesRecordRemove:function(){if(!this.checkBeforeRequest()){return}var b=this.getSelectionModel().getSelections();var a=this.getAllowedRecordes("remove",b);for(var c=0;c<b.length;c++){if(this.firstSelectStartTime===b[c].get("start_time")){this.disableBtnStream=false}}if(a&&0<a.length){var d=this.generateRemoveServiceID(b);SYNO.API.currentManager.requestAPI(this.module.owner.Schedule_API,"delete",this.module.owner.Schedule_APIVerion,{id:a,channel_id:d,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}this.module.getEl().mask(_T("common","loading"),"x-mask-loading")},programGuideStatusDone:function(b,c){var d;if(b.data.programs){d=b.data.programs;this.programGuideStatus.stop()}else{if(b.data.results){d=b.data.results;this.programGuideStatusForSearch.stop()}}for(var a=0;a<d.length;a++){var e=this.getStore().getById(d[a].start_time);if(e){e.data.status=d[a].status;e.commit()}}},onSearchEPG:function(){this.searchkey=this.searchField.getValue();if(0===this.searchkey.length){this.module.owner.getMsgBox().alert(_VST("schedule","schedule"),_VST("search","search_keyword_empty"));return}this.searchkey=this.searchkey.trim();this.isNewSearch=true;this.doSearch()},doSearch:function(){if(this.isNewSearch){var a={channels:[{title:_VST("search","title"),type:"category",id:"epgsearch"},{title:_VST("search","search_result"),type:"item",id:"epgsearchresult"}]};var c=this.module.ProgramGuidePanel.ProgramList;var b=c.getStore();b.loadData(a,true);c.dataview.select(b.getCount()-1);if(c.getEl().dom){c.getEl().dom.lastChild.scrollTop=c.getEl().dom.lastChild.scrollHeight}}this.module.owner.setStatusBusy({text:_T("search","searching")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Program","search","1",{keyword:this.searchkey,offset:0,limit:-1,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.doSearchDone,this)},doSearchDone:function(a,c,b){this.getColumnModel().setConfig(this.SearchCM,false);this.module.owner.clearStatusBusy();var d;searchResults={programs:[]};Ext.each(c.results,function(g,e,f){d={channel_id:g.channel_id,channel_name:g.channel_name,title:g.title,description:g.description,start_time:g.start_time,duration:g.duration,start:g.start,weekday:g.weekday,status:g.status};searchResults.programs.push(d)},this);this.store.loadData(searchResults,false);if(0===c.results.length){this.getEl().mask(_VST("dtvtscan","no_data"),"syno-ux-mask-info")}else{if(this.getEl().isMasked()){this.getEl().unmask()}}},onRecordMenuBeforeShow:function(c){if(this.getSelectionModel().hasSelection()===false){c.getComponent("record").setDisabled(true);c.getComponent("repeat_record").setDisabled(true);return}var b=this.getSelectionModel().getSelections();var a=this.getAllowedRecordes("recorde",b);if(1===this.getSelectionModel().getCount()&&a&&0<a.length){c.getComponent("repeat_record").setDisabled(false||_S("demo_mode"))}else{c.getComponent("repeat_record").setDisabled(true)}if(!this.module.ProgramGuidePanel.ProgramList.isAtChannlelist){c.getComponent("repeat_record").setDisabled(true)}},onRecordItemClick:function(f,b){var g=[];if("record"===f.itemId){this.requestRecord()}else{if("repeat_record"===f.itemId){var c=this.getSelectionModel().getSelections();for(var e=0;e<=6;e++){if(this.WeekDayNumber===e){g.push(1)}else{g.push(0)}}var a=this.ShowDay;a=a.substring(0,4)+"-"+a.substring(4,6)+"-"+a.substring(6,8);var d=new SYNO.SDS.VideoStation.RepeatScheduleDialog({owner:this.module.owner,id:this.ServiceID,channel_name:this.module.ProgramGuidePanel.ProgramList.getCurrentRecord().data.title,start_date:a,start_time:c[0].get("start_time"),duration:c[0].get("duration"),program_title:c[0].get("title"),description:c[0].get("description"),weekday:this.WeekDayNumber,isweekly:true,weekdaystatus:g,loadsetting:false,title:_VST("repeat","repeat_schedule"),tunerInfo:this.tunerInfo});d.open()}else{if("userdefine_record"===f.itemId){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","getinfo_userdefine",1,{tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0),start_time:-1},this.getUserdefineInfoDone,this)}}}},getUserdefineInfoDone:function(b,j,f){var g=_VST("schedule","schedule_recording");if(!b){if(j.code<400){this.module.owner.getMsgBox().alert(g,SYNO.API.CheckResponse(b,j,f))}else{var e=SYNO.SDS.VideoStation.Util.mappingDTVStatus(j.code);this.module.owner.getMsgBox().alert(g,e)}}else{if(j){var a=j.weekdaystatus.split(",");j.weekdaystatus="";for(var d=0;d<a.length;d++){if("1"==a[d]){j.weekdaystatus+=(0<j.weekdaystatus.length)?",":"";j.weekdaystatus+=d}}var c=new SYNO.SDS.VideoStation.UserDefineScheduleDialog({owner:this.module.owner,id:this.ServiceID,channel_name:this.module.ProgramGuidePanel.ProgramList.getCurrentRecord().data.title,loadsetting:(0<f.start_time),title:_VST("schedule","user_define_schedule"),data:j,tunerInfo:this.tunerInfo});c.open()}}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.UserDefineScheduleDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){Ext.apply(this,a||{});var b=this.fillConfig(a);SYNO.SDS.VideoStation.UserDefineScheduleDialog.superclass.constructor.call(this,b)},fillConfig:function(a){this.UserDefineScheduleFormpanel=new SYNO.SDS.VideoStation.UserDefineScheduleFormpanel({owner:this,itemId:"UserDefineScheduleFormpanel"});this.schedulestore=this.owner.ProgramScheduleTabpanel.ProgramScheduleGridPanel.store;var b={owner:this.owner,width:430,height:600,minWidth:420,minHeight:450,title:_VST("schedule","user_define_schedule"),layout:"fit",items:[this.UserDefineScheduleFormpanel],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this.UserDefineScheduleFormpanel,handler:this.UserDefineScheduleFormpanel.Apply},{text:_T("common","close"),scope:this,handler:this.onCloseDialog}],keys:[{key:[10,13],scope:this.UserDefineScheduleFormpanel,handler:this.UserDefineScheduleFormpanel.Apply},{key:27,scope:this,handler:this.onCloseDialog}]};Ext.apply(b,a);return b},onCloseDialog:function(){var a=this.UserDefineScheduleFormpanel.getForm();if(a.isDirty()&&this.loadsetting){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.close()}},this)}else{this.close()}}});Ext.define("SYNO.SDS.VideoStation.UserDefineScheduleFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){this.owner=a.owner;var c=this.owner.data;var b={owner:this.owner,border:false,trackResetOnLoad:false,deferredRender:false,labelWidth:150,items:[{xtype:"syno_displayfield",fieldLabel:_VST("schedule","channel"),width:200,name:"channel_name",value:this.owner.channel_name||c.channel_name},{xtype:"syno_textfield",fieldLabel:_VST("programguide","title"),allowBlank:false,maxLength:256,width:200,value:c.title||"",name:"title"},{xtype:"syno_textfield",fieldLabel:_VST("programguide","description"),width:200,maxLength:256,value:c.description,name:"description"},{xtype:"syno_compositefield",fieldLabel:_T("common","start"),items:[{xtype:"syno_datefield",format:"Y-m-d",name:"start_date",editable:false,width:140,allowBlank:false,value:c.start_date,validator:(function(f){var d=this.owner.data.today_date;var g=f.substring(0,4)+f.substring(5,7)+f.substring(8,10);var e=d.substring(0,4)+d.substring(5,7)+d.substring(8,10);if(this.owner.loadsetting&&f==this.owner.data.start_date&&("undefined"==typeof this.form.getValues().start_time||this.form.getValues().start_time==this.owner.data.start_time)){this.gangWeekday(f);return true}if(parseInt(e,10)>parseInt(g,10)){return _VST("repeat","repeat_endday_error")}this.gangWeekday(f);return true}).createDelegate(this)},{xtype:"syno_textfield",name:"start_time",width:54,value:c.start_time,allowBlank:false,listeners:{scope:this,blur:function(j){var e=this.getForm().findField("end_time");if(!j.isValid()||!e.isValid()){return}var m=j.getValue();var d=e.getValue();var l=parseInt(m.split(":")[0],10)*60+parseInt(m.split(":")[1],10);var k=parseInt(d.split(":")[0],10)*60+parseInt(d.split(":")[1],10);var g=k-l>=0?k-l:k-l+1440;var f=new Date(0,0,0,Math.floor(g/60),g%60,0);this.getForm().findField("duration").setValue(f.format("H:i"))}},validator:this.generalTimeValidator.createDelegate(this)}]},{xtype:"syno_textfield",fieldLabel:_VST("schedule","end")+" (hh:mm)",width:200,value:this.calcEndTime(c.start_time,c.duration),name:"end_time",allowBlank:false,listeners:{scope:this,blur:function(j){var e=this.getForm().findField("start_time");if(!j.isValid()||!e.isValid()){return}var m=e.getValue();var d=j.getValue();var l=parseInt(m.split(":")[0],10)*60+parseInt(m.split(":")[1],10);var k=parseInt(d.split(":")[0],10)*60+parseInt(d.split(":")[1],10);var g=k-l+1440;var f=new Date(0,0,0,Math.floor(g/60),g%60,0);this.getForm().findField("duration").setValue(f.format("H:i"))}},validator:(function(e){var d=this.generalTimeValidator(e);if(true!==d){return d}if(this.getForm().findField("start_time").getValue()===e){return _VST("schedule","time_conflict")}return true}).createDelegate(this)},{xtype:"syno_textfield",fieldLabel:_VST("schedule","duration")+" (hh:mm)",width:200,value:c.duration,allowBlank:false,name:"duration",listeners:{scope:this,blur:function(e){var d=this.getForm().findField("start_time");if(!e.isValid()||!d.isValid()){return}this.getForm().findField("end_time").setValue(this.calcEndTime(d.getValue(),e.getValue()))}},validator:(function(e){var d=this.generalTimeValidator(e);if(true!==d){return d}if("00:00"==e){return false}return true}).createDelegate(this)},{xtype:"syno_checkbox",name:"is_repeat",boxLabel:_VST("action","repeat_record"),checked:c.is_repeat,hideLabel:true},{xtype:"syno_superboxselect",indent:1,fieldLabel:_VST("repeat","repeat_data"),width:200,name:"repeat_days",allowAddNewData:false,editable:false,resizable:true,store:this.createDaysStore(),mode:"local",grow:false,minChars:1,queryParam:"filter",disabled:!c.is_repeat,triggerAction:"all",displayField:"display",valueField:"value",value:c.weekdaystatus,allowBlank:false,settingValue:false,listeners:{beforeremoveitem:function(e,d,g){return e.settingValue||(d!==this.form.findField("start_date").getValue().getDay())},scope:this},resetStore:function(){this.store.clearFilter();if(!this.removeValuesFromStore){return this}this.usedRecords.each(function(d){this.store.add(d)},this);this.usedRecords.clear();this.store.sort(this.valueField,"ASC");return this}},{xtype:"syno_compositefield",indent:1,fieldLabel:_VST("repeat","end_day"),items:[{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_never"),inputValue:"never",name:"end_never",disabled:!c.is_repeat,checked:(c.end_date==1)?true:false,listeners:{scope:this,check:function(d,e){this.getForm().findField("end_on").setValue(!e);this.getForm().findField("end_value").setDisabled(e)}}}]},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_displayfield",width:150,value:""},{xtype:"syno_radio",boxLabel:_VST("repeat","repeat_on"),inputValue:"on",name:"end_on",disabled:!c.is_repeat,checked:(c.end_date==1)?false:true,listeners:{scope:this,check:function(d,e){this.getForm().findField("end_never").setValue(!e)}}},{xtype:"syno_datefield",format:"Y-m-d",name:"end_value",editable:false,allowBlank:false,width:140,disabled:!c.is_repeat,value:(c.end_date==1)?c.today_date:c.end_date,preFocus:function(){this.el.blur()},validator:(function(f){if(0===f.length){this.owner.getMsgBox().alert(this.owner.title,_VST("repeat","repeat_endday_empty"));return}var d=this.owner.data.today_date;var g=f.substring(0,4)+f.substring(5,7)+f.substring(8,10);var e=d.substring(0,4)+d.substring(5,7)+d.substring(8,10);if(parseInt(e,10)>parseInt(g,10)){return _VST("repeat","repeat_endday_error")}return true}).createDelegate(this)}]}]};Ext.apply(b,a);SYNO.SDS.VideoStation.UserDefineScheduleFormpanel.superclass.constructor.call(this,b);SYNO.SDS.VideoStation.Util.GangCheckBox(this.form,"is_repeat",["repeat_days","end_never","end_on"])},calcEndTime:function(c,d){var g=c.split(":");var b=d.split(":");var f=parseInt(g[0],10)*60+parseInt(g[1],10);var e=f+parseInt(b[0],10)*60+parseInt(b[1],10);var a=new Date(0,0,0,Math.floor(e/60),e%60,0);return a.format("H:i")},generalTimeValidator:function(a){if(""===a||""!==a.replace(/\d\d:\d\d/,"")){return String.format(_VST("schedule","format_error"),"hh:mm")}if(23<parseInt(a.split(":")[0],10)){return _VST("schedule","hour_exceed")}if(59<parseInt(a.split(":")[1],10)){return _VST("schedule","minute_exceed")}return true},createDaysStore:function(){var a=new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],idIndex:0,data:[[0,_VST("repeat","schedule_sun")],[1,_VST("repeat","schedule_mon")],[2,_VST("repeat","schedule_tue")],[3,_VST("repeat","schedule_wed")],[4,_VST("repeat","schedule_thu")],[5,_VST("repeat","schedule_fri")],[6,_VST("repeat","schedule_sat")]]});return a},gangWeekday:function(b){if(this.isVisible()){var d=this.form.findField("repeat_days");var a=new Date(b).getDay();var e=d.store.getById(a);if(e&&d.disabled){d.setValue(a)}else{if(e&&!d.disabled){var c=d.getValueEx();c.push({display:e.get("display"),value:e.get("value")});c.sort(function(g,f){return g.value>f.value});d.settingValue=true;d.setValueEx(c);d.settingValue=false}}}},Apply:function(){var d=this.getForm();if(!d.isValid()){return}var a=d.getValues();var c=d.getFieldValues();var g={id:this.owner.id,channel_name:this.owner.channel_name,start_time:a.start_time,start_date:a.start_date,duration:a.duration,title:a.title,description:a.description,tuner:Ext.isDefined(this.owner.tunerInfo)?this.owner.tunerInfo.id:0,is_repeat:c.is_repeat};if(c.is_repeat){var e=[0,0,0,0,0,0,0];var f=d.findField("repeat_days").getValue().split(",");f.each(function(j){this[j]=1},e);Ext.apply(g,{isweekly:(7!=f.length),weekdaystatus:e.join(","),end_date:(a.end_never)?1:a.end_value})}this.owner.setStatusBusy({text:_T("common","saving")});if(this.owner.loadsetting){var b=new Date(this.form.findField("start_date").originalValue);Ext.apply(g,{orig_start_time:this.form.findField("start_time").originalValue,orig_start_date:b.format("Y-m-d")});SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","edit_userdefine","1",g,this.ApplyDone,this)}else{SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","create_userdefine","1",g,this.ApplyDone,this)}},ApplyDone:function(a,d,c){this.owner.clearStatusBusy();if(!a){if(d.code<400){this.owner.getMsgBox().alert(this.owner.title,SYNO.API.CheckResponse(a,d,c))}else{var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(d.code);if(406===d.code){this.owner.getMsgBox().alert(this.owner.title,b,function(){SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.Main").launchSettingDialog(1)},this)}else{this.owner.getMsgBox().alert(this.owner.title,b)}}}else{this.owner.schedulestore.reload();this.owner.close()}}});Ext.define("SYNO.SDS.VideoStation.ProgramScheduleGridPanel",{extend:"SYNO.ux.GridPanel",PageSize:10,constructor:function(a){Ext.apply(this,a||{});this.BaseUrl=this.module.owner.owner.jsConfig.jsBaseURL;var b=this.createStore();var c=this.fillConfig(a,b);SYNO.SDS.VideoStation.ProgramScheduleGridPanel.superclass.constructor.call(this,c)},fillConfig:function(a,b){var c={cls:"syno-vs-dtv-schedule-grid",border:false,getView:function(){if(!this.view){this.view=new SYNO.ux.FleXcroll.grid.BufferView(this.viewConfig||{})}return this.view},stripeRows:true,split:false,enableColumnMove:false,enableColLock:false,enableColumnHide:false,enableHdMenu:false,enableColumnResize:true,tbar:this.createTBar(),bbar:this.createBBar(b),title:_VST("schedule","schedule_recording"),sm:new Ext.grid.RowSelectionModel({singleSelect:false,listeners:{scope:this,selectionchange:function(f){var e=f.getSelections();if(!e[0]){return}var d=e[0].get("status");if(1===f.getCount()&&(12===d||13===d||(1===d&&e[0].get("is_userdefine")))){this.btnEditRepeatSchedule.setDisabled(false)}else{this.btnEditRepeatSchedule.setDisabled(true)}}}}),loadMask:true,store:b,colModel:new Ext.grid.ColumnModel({columns:[{id:"channelname",header:_VST("schedule","channel"),dataIndex:"channel_name",width:90,align:"left",renderer:this.channelRenderer.createDelegate(this)},{id:"title",header:_VST("programguide","title"),dataIndex:"title",width:140,align:"left",renderer:this.qtipRenderer.createDelegate(this)},{id:"description",header:_VST("programguide","description"),dataIndex:"description",width:180,align:"left",renderer:this.qtipRenderer.createDelegate(this)},{id:"start",header:_T("common","start"),dataIndex:"start",width:180,align:"left",renderer:this.startRenderer.createDelegate(this)},{id:"duration",header:_VST("schedule","duration"),dataIndex:"duration",width:80,align:"left",renderer:this.durationRender.createDelegate(this)},{id:"status",header:_VST("common","status"),dataIndex:"status",width:100,align:"center",renderer:this.statusRender.createDelegate(this)}],defaults:{sortable:false,menuDisabled:false,align:"right"}}),listeners:{rowcontextmenu:function(d,j,f){},rowclick:function(d,j,f){if(f&&j&&!f.hasModifier()){d.getSelectionModel().selectRow(j)}},rowdblclick:function(d,j,f){},scope:this}};Ext.apply(c,a);b.on("load",this.onLoad,this);return c},createStore:function(){var a=new Ext.data.JsonStore({autoLoad:false,pruneModifiedRecords:true,totalProperty:"total",idProperty:"primeid",proxy:new SYNO.API.Proxy({api:this.module.owner.Schedule_API,method:"list",version:this.module.owner.Schedule_APIVerion}),root:"schedules",fields:["id","channel_name","title","description","start_time","start","weekday","duration","status","primeid","is_userdefine"],baseParams:{api:this.module.owner.Schedule_API,version:this.module.owner.Schedule_APIVerion,method:"list",start:0,limit:this.PageSize,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},listeners:{exception:function(c,d,e,b,f){SYNO.Debug("Ajax load failure ",f)},scope:this}});this.addManagedComponent(a);return a},createTBar:function(){var a=[{tooltip:_VST("action","cancel_recording"),text:_VST("action","cancel_recording"),disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),itemId:"removerecording",handler:function(){if(_S("demo_mode")){this.module.owner.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}if(this.getStore().getTotalCount()===0){return}if(this.getSelectionModel().hasSelection()===false){this.module.owner.getMsgBox().alert(this.title,_VST("action","dvt_cfrm_select"));return}var j=this.getSelectionModel().getSelections();var c=[];var d=[];var s=[];var o=[];var g=[];var p=[];for(var n=0;n<j.length;n++){if(j[n].get("is_userdefine")){g.push(j[n].get("start_time"));p.push(j[n].get("id"))}else{if(12===j[n].get("status")||13===j[n].get("status")){s.push(j[n].get("start_time"));o.push(j[n].get("id"))}else{c.push(j[n].get("start_time"));d.push(j[n].get("id"))}}}var f=c.join(",");var e=d.join(",");if(f&&0<f.length){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete",1,{id:f,channel_id:e,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}var q=s.join(",");var k=o.join(",");if(q&&0<q.length){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete_repeat",1,{id:q,channel_id:k,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}var m=g.join(",");var l=p.join(",");if(m&&0<m.length){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete_userdefine",1,{id:m,channel_id:l,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)}this.module.owner.setStatusBusy({text:_T("common","loading")})},scope:this},{tooltip:_VST("action","edit_repeat_schedule"),text:_T("common","alt_edit"),disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),itemId:"edit_repeat_schedule",handler:function(){if(_S("demo_mode")){this.module.owner.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}if(this.getStore().getTotalCount()===0){return}if(this.getSelectionModel().hasSelection()===false){this.module.owner.getMsgBox().alert(this.title,_VST("action","dvt_cfrm_select"));return}var d=this.getSelectionModel().getSelections();var e=d[0].get("start_time");var f=d[0].get("id");var c=d[0].get("status");if(d[0].get("is_userdefine")){SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","getinfo_userdefine",1,{tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0),start_time:e},this.getUserdefineInfoDone,this)}else{SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","getinfo_repeat",1,{id:f,start_time:e,tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.getRepeatInfoDone,this)}},scope:this},{tooltip:_VST("action","clear_pass_task"),text:_VST("action","clearpasstask"),disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),itemId:"clear_pass_task",handler:function(){if(_S("demo_mode")){this.module.owner.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}SYNO.API.currentManager.requestAPI("SYNO.DTV.Schedule","delete_passed",1,{tuner:(Ext.isDefined(this.tunerInfo)?this.tunerInfo.id:0)},this.requestDone,this)},scope:this}];var b=new SYNO.ux.Toolbar({items:a});this.btnRemove=b.getComponent("removerecording");this.btnClearPassTask=b.getComponent("clear_pass_task");this.btnEditRepeatSchedule=b.getComponent("edit_repeat_schedule");return b},createBBar:function(a){this.pagingbar=new SYNO.ux.PagingToolbar({store:a,displayInfo:true,pageSize:this.PageSize});return this.pagingbar},channelRenderer:function(b,e,c,k,a,g){var f=Ext.util.Format.htmlEncode(b);e.attr='ext:qtip="'+Ext.util.Format.htmlEncode(f)+'"';var d=SYNO.SDS.VideoStation.Util.programStatus(c.get("status"));var j=d||"";return['<div class="'+j+'">',"<span>",f,"</span>","</div>"].join("")},qtipRenderer:function(f,c,e,b,d,a){c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(f)+'"';return f},startRenderer:function(j,d,g,c,f,b){var a;var e=SYNO.SDS.VideoStation.Util.getWeekDayfromNumber(g.get("weekday"));if(e){e=" ("+e+")"}a=j+e;d.attr='ext:qtip="'+Ext.util.Format.htmlEncode(a)+'"';return a},durationRender:function(b,g,d,k,a,j){if(b){var f,e,c;f=SYNO.SDS.VideoStation.Util.modifyHM(b%60);e=SYNO.SDS.VideoStation.Util.modifyHM(((b-f)/60)%60);if(0<(b-(f+e*60))){c=SYNO.SDS.VideoStation.Util.modifyHM((b-(f+e*60))/3600)}else{c=SYNO.SDS.VideoStation.Util.modifyHM(0)}return c+":"+e+":"+f}},statusRender:function(g,c,f,b,e,a){var d=SYNO.SDS.VideoStation.Util.getScheduleStatusString(g);c.attr='ext:qtip="'+Ext.util.Format.htmlEncode(d)+'"';return d},onLoad:function(c,e,d){if(c.getCount()<1){this.btnRemove.setDisabled(true);this.btnClearPassTask.setDisabled(true);this.btnEditRepeatSchedule.setDisabled(true);return}c.sort("start_time","ASC");this.StartOffset=d.params.start;this.getSelectionModel().selectFirstRow();this.btnRemove.setDisabled(_S("demo_mode"));this.btnClearPassTask.setDisabled(_S("demo_mode"));this.btnEditRepeatSchedule.setDisabled(_S("demo_mode"));var b=this.getSelectionModel().getSelections();if(b&&b[0]){var a=b[0].get("status");if(12===a||13===a||(1===a&&b[0].get("is_userdefine"))){this.btnEditRepeatSchedule.setDisabled(false||_S("demo_mode"))}else{this.btnEditRepeatSchedule.setDisabled(true)}}},requestDone:function(a,e,c){if(this.getEl().isMasked()){this.getEl().unmask()}this.module.owner.clearStatusBusy();var d=_VST("action","program_guide");if(!a){if(e.code<400){this.module.owner.getMsgBox().alert(d,SYNO.API.CheckResponse(a,e,c))}else{var b=SYNO.SDS.VideoStation.Util.mappingDTVStatus(e.code);this.module.owner.getMsgBox().alert(d,b)}}if("delete_passed"===c.method){this.pagingbar.moveFirst();return}if(0!=this.StartOffset&&this.StartOffset>=(this.getStore().getTotalCount()-this.getSelectionModel().getSelections().length)){this.StartOffset=this.StartOffset-this.PageSize}this.store.load({params:{start:this.StartOffset,limit:this.PageSize}});this.module.owner.updateStreamBtnTask.delay(15000,function(){this.module.owner.updateStreamBtn()},this)},getRepeatInfoDone:function(a,g,e){var f=_VST("action","program_guide");if(!a){if(g.code<400){this.module.owner.getMsgBox().alert(f,SYNO.API.CheckResponse(a,g,e))}else{var c=SYNO.SDS.VideoStation.Util.mappingDTVStatus(g.code);this.module.owner.getMsgBox().alert(f,c)}}if(g){var d=[];d=g.weekdaystatus.split(",");Ext.each(d,function(l,j,k){d[j]=parseInt(d[j],10)},this);var b=new SYNO.SDS.VideoStation.RepeatScheduleDialog({owner:this.module.owner,id:g.id,channel_name:g.channel_name,start_date:g.start_date,start_time:g.start_time,program_title:g.title,description:g.description,isweekly:g.isweekly,weekdaystatus:d,end_date:g.end_date,loadsetting:true,title:_VST("repeat","repeat_schedule"),tunerInfo:this.tunerInfo});b.open()}},getUserdefineInfoDone:function(b,j,f){var g=_VST("schedule","schedule_recording");if(!b){if(j.code<400){this.module.owner.getMsgBox().alert(g,SYNO.API.CheckResponse(b,j,f))}else{var e=SYNO.SDS.VideoStation.Util.mappingDTVStatus(j.code);this.module.owner.getMsgBox().alert(g,e)}}else{if(j){var a=j.weekdaystatus.split(",");j.weekdaystatus="";for(var d=0;d<a.length;d++){if("1"==a[d]){j.weekdaystatus+=(0<j.weekdaystatus.length)?",":"";j.weekdaystatus+=d}}var c=new SYNO.SDS.VideoStation.UserDefineScheduleDialog({owner:this.module.owner,id:j.channel_id,channel_name:j.channel_name,loadsetting:(0<f.start_time),title:_VST("schedule","user_define_schedule"),data:j,tunerInfo:this.tunerInfo});c.open()}}}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.ProgramScheduleDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){this.owner=this._getOwner();this.defineBehaviors();var b=this.fillConfig(a);SYNO.SDS.VideoStation.ProgramScheduleDialog.superclass.constructor.call(this,b)},fillConfig:function(a){this.ProgramScheduleTabpanel=new SYNO.SDS.VideoStation.ProgramScheduleTabpanel({owner:this,itemId:"ProgramScheduleTablpanel",tunerInfo:a.tunerInfo});var b={owner:this.owner,width:850,height:520,minWidth:700,minHeight:550,title:_VST("schedule","schedule")+"  -  "+a.tunerInfo.title,layout:"fit",items:[this.ProgramScheduleTabpanel],buttons:[{text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramGrid,handler:this.ProgramScheduleTabpanel.ProgramGuidePanel.ProgramGrid.onSearchEPG},{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},defineBehaviors:function(){this.Channel_API="SYNO.DTV.Channel";this.Channel_APIVerion="1";this.Program_API="SYNO.DTV.Program";this.Program_APIVerion="1";this.Program_APIURL=this.owner._getWebAPIURL("programlist.cgi");this.Schedule_API="SYNO.DTV.Schedule";this.Schedule_APIVerion="1";if(!this.updateStreamBtnTask){this.updateStreamBtnTask=new Ext.util.DelayedTask()}},updateStreamBtn:function(){if(this.owner){this.ProgramScheduleTabpanel.btnStream.setDisabled(!this.owner.mainpanel.mainCardPanel.showrecordingbtn.hidden||_S("demo_mode"))}}});Ext.define("SYNO.SDS.VideoStation.ProgramScheduleTabpanel",{extend:"SYNO.ux.TabPanel",constructor:function(a){this.owner=a.owner;this.ProgramGuidePanel=new SYNO.SDS.VideoStation.ProgramGuidePanel({module:this,tunerInfo:a.tunerInfo,itemId:"ProgramGuidePanel"});this.ProgramScheduleGridPanel=new SYNO.SDS.VideoStation.ProgramScheduleGridPanel({module:this,tunerInfo:a.tunerInfo,itemId:"ProgramScheduleGridPanel"});var b={owner:this.owner,activeTab:0,plain:true,deferredRender:false,items:[this.ProgramGuidePanel,this.ProgramScheduleGridPanel],listeners:{scope:this,tabchange:this.onTabchange}};Ext.apply(b,a);SYNO.SDS.VideoStation.ProgramScheduleTabpanel.superclass.constructor.call(this,b)},onTabchange:function(b,a){if("ProgramScheduleGridPanel"===a.itemId){this.ProgramScheduleGridPanel.store.load()}else{if(this.ProgramGuidePanel.ProgramList.isAtChannlelist){if(this.ProgramGuidePanel.ProgramList.dataview.getSelectedRecords().length){this.ProgramGuidePanel.ProgramGrid.store.load()}}else{this.ProgramGuidePanel.ProgramGrid.doSearch()}}}});Ext.define("SYNO.SDS.VideoStation.ProgramGuidePanel",{extend:"SYNO.ux.Panel",constructor:function(a){this.init();Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},init:function(){this.tunerType={FE_QPSK:0,FE_QAM:1,FE_OFDM:2,FE_ATSC:3}},fillConfig:function(a){this.ProgramList=new SYNO.SDS.VideoStation.ProgramGuideListPanel({module:this.module,itemId:"ProgramList",region:"west",isAtChannlelist:true,tunerInfo:a.tunerInfo});this.ProgramGrid=new SYNO.SDS.VideoStation.ProgramGuideGridPanel({module:this.module,itemId:"ProgramGrid",region:"center",tunerInfo:a.tunerInfo});var b={border:false,title:_VST("action","program_guide"),layout:"border",width:680,height:500,monitorResize:true,tbar:this.createTBar(),items:[this.ProgramList,this.ProgramGrid],listeners:{scope:this,activate:{fn:this.onActivate,scope:this}}};Ext.apply(b,a);return b},createTBar:function(){var a=this.ProgramGrid;var b=this.ProgramList;var e;var c=new SYNO.ux.Menu({cls:"syno-vs-menu",itemId:"recordingmenu",items:[{text:_VST("action","record"),itemId:"record"},{text:_VST("action","repeat_record"),itemId:"repeat_record"},{text:_VST("schedule","user_define_schedule"),itemId:"userdefine_record"},{text:_VST("action","cancel_recording"),disabled:true,itemId:"remove_record",handler:a.requesRecordRemove,scope:a}],listeners:{scope:a,beforeshow:a.onRecordMenuBeforeShow,itemclick:a.onRecordItemClick}});this.addManagedComponent(c);a.recordmenu=c;b.recordmenu=c;var f=new SYNO.ux.Menu({cls:"syno-vs-menu",itemId:"startmenu",items:[{text:_VST("action","channelscan"),itemId:"channelscan",disabled:_S("demo_mode"),handler:b.launchChannelScanDialog,scope:b},{text:_VST("action","channeledit"),itemId:"channeledit",disabled:_S("demo_mode"),handler:b.launchChannelEditDialog,scope:b},{text:_VST("action","delete_all_channels"),itemId:"deleteallchannels",disabled:_S("demo_mode"),hidden:(this.tunerInfo.type!=this.tunerType.FE_QPSK),handler:b.delteAllChannels,scope:b},{text:_VST("programguide","update_epg"),disabled:true,itemId:"updateepg",hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),handler:b.requesUpdateEPG,scope:b}]});var d=[{tooltip:_VST("programguide","broadcast_streaming"),text:_VST("programguide","broadcast_streaming"),itemId:"broadcaststreaming",disabled:true,hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),handler:b.stream,scope:b},{text:_VST("action","record"),itemId:"recordingaction",hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),menu:c},{text:_VST("action","start"),itemId:"startaction",hidden:!SYNO.SDS.VideoStation.Util.ableToControlDTV(),menu:f},"->",e=new SYNO.ux.TextFilter({itemId:"search_field",emptyText:_VST("search","keyword")})];var g=new SYNO.ux.Toolbar({cls:"syno-vs-dtv-programguide-toolbar",items:d});a.searchField=e;a.btnRemove=c.getComponent("remove_record");this.module.btnStream=g.getComponent("broadcaststreaming");this.module.btnUpdateEPG=f.getComponent("updateepg");this.module.btnDeleteallchannels=f.getComponent("deleteallchannels");return g},reloadChannels:function(){this.IsHaveLoadChannel=false;this.onActivate()},onActivate:function(){if(!this.IsHaveLoadChannel){this.module.owner.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.module.owner.Channel_API,"list",this.module.owner.Channel_APIVerion,{tuner:(Ext.isDefined(this.module.owner.tunerInfo)?this.module.owner.tunerInfo.id:0),offset:0,limit:-1},this.ProgramList.channelListDone,this.ProgramList);this.IsHaveLoadChannel=true}}});Ext.define("SYNO.SDS.VideoStation.DTVMetaDataDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={cls:"syno-vs-metadata-win",owner:this._getOwner(),width:400,height:250,minWidth:300,minHeight:200,title:_VST("action","edit_metadata"),layout:"fit",items:[this.getFormPanel()],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,handler:function(){this.onApply()}},{text:_T("common","cancel"),scope:this,handler:this.onCloseDialog}],keys:[{key:27,scope:this,handler:this.onCloseDialog}]};return Ext.apply(b,a)},show:function(c){this.data_id=c;var b={id:c,additional:"summary,files"};var a=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo();if(a.params&&a.params.type){this.webAPIID=SYNO.SDS.VideoStation.Util.getinfo_WebAPI(a.params.type).api}else{this.webAPIID=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getHistoryInfo().webAPIID}this.setStatusBusy({text:_T("common","loading")});SYNO.API.currentManager.requestAPI(this.webAPIID,"getinfo",1,b,this.onLoadDataDone,this);this.callParent(arguments)},onCloseDialog:function(){var a=this.formPanel.getForm();if(a.isDirty()){this.getMsgBox().confirm(_VST("action","settings"),_T("common","confirm_lostchange"),function(b){if(b==="yes"){this.hide()}},this)}else{this.hide()}},onApply:function(d){if(_S("demo_mode")){this.getMsgBox().alert(this.title,_JSLIBSTR("uicommon","error_demo"));return}var c=this.formPanel.getForm();if(!c.isDirty()){this.hide();return}var b=c.findField("channel_name").getValue();var f=c.findField("title").getValue();var a=c.findField("summary").getValue();var e={id:this.data_id,channel_name:b,title:f,summary:a};this.setStatusBusy();SYNO.API.currentManager.requestAPI(this.webAPIID,"edit",1,e,this.onSaveDone,this)},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.DTVMetaDataFormpanel()}return this.formPanel},onLoadDataDone:function(a,g,f){this.clearStatusBusy();if(!a){var j=SYNO.SDS.VideoStation.Util.getWebAPIErr(a,g,f);this.setStatusError({text:j,clear:true});return false}if(!g&&!g.recordings&&g.recordings[0]){return}var d=this.formPanel.getForm();var b=d.findField("channel_name");var e=d.findField("title");var c=d.findField("summary");d.setValues({channel_name:g.recordings[0].channel_name,title:g.recordings[0].title,summary:g.recordings[0].additional.summary})},onSaveDone:function(a,c,b){this.clearStatusBusy();if(!a){var d=SYNO.SDS.VideoStation.Util.getWebAPIErr(a,c,b);this.setStatusError({text:d,clear:true});return false}SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.CardPanel").layout.activeItem.onActivate(false);this.hide()}});Ext.define("SYNO.SDS.VideoStation.DTVMetaDataFormpanel",{extend:"SYNO.ux.FormPanel",constructor:function(a){Ext.apply(this,a||{});this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b=Ext.apply({frame:false,border:false,labelWidth:90,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[{xtype:"syno_displayfield",itemId:"channel_name",name:"channel_name",fieldLabel:_VST("schedule","channel")},{xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("programguide","title"),allowBlank:false},{xtype:"syno_textarea",itemId:"summary",name:"summary",fieldLabel:_VST("programguide","description"),width:280,height:70}]},a);return b}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.NewEditCollectionDialog=Ext.extend(SYNO.SDS.VideoStation.ModalWindow,{constructor:function(a){var b=this.fillConfig(a);SYNO.SDS.VideoStation.NewEditCollectionDialog.superclass.constructor.call(this,b)},fillConfig:function(a){var b={owner:this._getOwner(),width:450,height:140,minWidth:300,title:a.create?_VST("collection","new_collection"):_VST("collection","edit_collection"),layout:"fit",plain:true,items:[this.getFormPanel()],buttons:[{text:_T("common","ok"),btnStyle:"blue",scope:this,disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):undefined,handler:this.onSaveCollectionName},{text:_T("common","cancel"),scope:this,handler:this.close}],keys:[{key:[10,13],scope:this,handler:this.onSaveCollectionName},{key:27,scope:this,handler:this.close}]};Ext.apply(b,a);return b},show:function(){if(!this.create&&this.collectionTitle){var b,a=this.getFormPanel().getForm();b=new Ext.data.Record({collection_name:this.collectionTitle});a.loadRecord(b)}SYNO.SDS.VideoStation.NewEditCollectionDialog.superclass.show.apply(this,arguments)},onSaveCollectionName:function(){var a=false;var b=this.getFormPanel().getForm();if(!b.isValid()){return false}this.collectionTitle=b.findField("collection_name").getValue();if(""===this.collectionTitle){this.setStatusError({text:_VST("collection","collection_isnotempty"),clear:true});return}Ext.each(SYNO.SDS.VideoStation.gData.collections,function(e,c,d){if(e.title!=="syno_favorite"&&e.title!=="syno_watchlist"&&e.title===this.collectionTitle){if(this.create){a=true}else{if(this.collectionID!==e.id){a=true}}return}},this);if(a){this.setStatusError({text:_VST("collection","collection_duplicate_name"),clear:true});return}this.setStatusBusy({text:_T("common","save")});if(this.create){SYNO.API.currentManager.requestAPI("SYNO.VideoStation.Collection","create","1",{title:this.collectionTitle},this.newediteCollectionDone,this)}else{if(b.isDirty()){SYNO.API.currentManager.requestAPI("SYNO.VideoStation.Collection","edit","1",{id:this.collectionID,title:this.collectionTitle},this.newediteCollectionDone,this)}}},newediteCollectionDone:function(g,d,e,a){var c=a.params;this.clearStatusBusy();if(!g){this.setStatusError({text:SYNO.SDS.VideoStation.Util.getWebAPIErr(g,d,c),clear:true});return}if("create"===c.method){var b={id:d.id,title:this.collectionTitle};SYNO.SDS.VideoStation.gData.collections.push(b);var k={id:d.id};if(Ext.isDefined(this.viewmetadataAddCollection)){this.viewmetadataAddCollection.push(b)}else{if(Ext.isDefined(this.mainVideoOption)){if(this.mainVideoOption.video_id){Ext.apply(k,{video_id:this.mainVideoOption.video_id})}if(this.mainVideoOption.video_type){Ext.apply(k,{video_type:this.mainVideoOption.video_type})}}else{}}SYNO.SDS.VideoStation.Util.onRequestCollectionNoMesg.call(SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData"),"addvideo",k,null,this)}else{Ext.each(SYNO.SDS.VideoStation.gData.collections,function(n,l,m){if(parseInt(n.id,10)===parseInt(this.collectionID,10)){n.title=this.collectionTitle}},this);var f=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();f.onActivate()}var j=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ViewMetaData");j.updateCollectionsMenuitems();this.owner.mainpanel.updateCollectionsMenuitems();this.owner.mainpanel.updateActionMenuItems();this.close()},getFormPanel:function(){if(!this.formPanel){this.formPanel=new SYNO.SDS.VideoStation.NewEditCollectionFormpanel()}return this.formPanel}});SYNO.SDS.VideoStation.NewEditCollectionFormpanel=Ext.extend(SYNO.ux.FormPanel,{constructor:function(a){Ext.apply(this,a||{});SYNO.SDS.VideoStation.NewEditCollectionFormpanel.superclass.constructor.call(this,Ext.apply(SYNO.LayoutConfig.fill({frame:false,border:false,autoScroll:true,autoHeight:true,labelWidth:120,trackResetOnLoad:true,defaults:{anchor:"100%"},items:[{itemId:"collection_name",id:"collection_name",name:"collection_name",fieldLabel:_VST("collection","collection_name"),synotype:"text",width:280,maxLength:255,maxLengthText:_VST("collection","collection_name_too_long")}]}),a));this.getForm().findField("collection_name").focus(true,500)}});Ext.ns("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.AppInstance=Ext.extend(SYNO.SDS.AppInstance,{appWindowName:"SYNO.SDS.VideoStation.AppWindow",constructor:function(){SYNO.SDS.VideoStation.Util.init();SYNO.SDS.VideoStation.AppInstance.superclass.constructor.apply(this,arguments)}});Ext.define("SYNO.SDS.VideoStation.AppWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(a){this.panellist={};SYNO.SDS.VideoStation.Window=this;var b=this.fillConfig(a);this.callParent([this.fillConfig(a)]);this.setStatusBusy();SYNO.API.currentManager.queryAPI("all",function(c,e,d){if(!SYNO.API.CheckResponse(c,e,d)){this.getMsgBox().alert(_VST("app","displayname"),_T("common","commfail"))}},this);this.addAjaxTask({autoJsonDecode:true,url:this._getAbsoluteURL("session.cgi"),params:{action:"load"},method:"POST",single:true,callback:function(f,g,e){var j=Ext.emptyFn;SYNO.SDS.VideoStation.gData={};if(!g||!e||!e.success){this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation.Util.getErrinfoString(e,_T("common","commfail")))}else{SYNO.SDS.VideoStation.gData=e;if(_S("is_admin")===true&&Ext.isEmpty(e.video_folder)){j=function(){this.getMsgBox().alert(_VST("app","displayname"),_VST("error","no_video_folder"),function(){var k=new SYNO.SDS.VideoStation.SettingDialog();k.open()},this)}}if(SYNO.SDS.QuickConnect.Utils.isInTunnel()&&!SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","blNotShowQuickConnectMsg")){var d={items:[{xtype:"syno_displayfield",value:_VST("app","warn_quickconnect_tunnel")},{xtype:"syno_checkbox",boxLabel:_T("plugin","plugin_not_remind"),listeners:{scope:this,check:function(l,k){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","blNotShowQuickConnectMsg",k)}}}]};var c=new SYNO.SDS.ModalWindow({owner:this,cls:"syno-vs-dialog",layout:"fit",resizable:false,width:550,height:200,hideLabel:false,title:_VST("app","displayname"),buttons:[{text:_T("common","ok"),btnStyle:"blue",handler:function(){c.close()}}],items:new SYNO.SDS.Utils.FormPanel(d)});c.open()}}this.delayConstructor(d,j)},scope:this}).start();this.queryPrivilege()},fillConfig:function(a){var b={layout:"fit",cls:"syno-vs-win syno-vs-main-win",width:1022,height:600,minWidth:480,minHeight:360,html:""};Ext.apply(b,a);return b},delayConstructor:function(a,c){if(this.isDestroyed){return}if(!this.rendered){this.delayConstructor.defer(10,this,arguments);return}this.getPathMgr();this.clearStatusBusy();var b=[];b.push(this.mainpanel=new SYNO.SDS.VideoStation.Main({header:false,itemId:"main"}));this.mon(this.mainpanel,"afterlayout",c,this,{single:true,buffer:100});this.removeAll();this.add(b);this.doLayout()},_getAbsoluteURL:function(a,b){return String.format("{0}/{1}/{2}",this.jsConfig.jsBaseURL,(b||"cgi"),a)},_getWebAPIURL:function(a){return String.format("{0}/{1}","/webapi/VideoStation",a)},addPanelScope:function(b,a){this.panellist[b]=a},getPanelScope:function(a){if(a in this.panellist){return this.panellist[a]}return null},getPathMgr:function(){if(this.pathMgr){return this.pathMgr}return(this.pathMgr=new SYNO.SDS.VideoStation.PathHistoryMgr())},queryPrivilege:function(){var a={api:"SYNO.VideoStation.Info",version:1,method:"getinfo"};var b=function(f,c,d){this.clearStatusBusy();if(f){SYNO.SDS.VideoStation.Util.privilege=c.privilege;SYNO.SDS.VideoStation.Util.support_hardware_transcode=c.support_hardware_transcode;SYNO.SDS.VideoStation.Util.support_transcode=c.support_transcode}else{var e=SYNO.SDS.VideoStation.Util.getWebAPIErr(f,c,d);this.getMsgBox().alert(this.title,e)}};this.setStatusBusy();SYNO.API.currentManager.requestAPI(a.api,a.method,a.version,{},b,this)}});Ext.define("SYNO.SDS.VideoStation.MetadataPanel",{extend:"SYNO.ux.FormPanel",pageSize:300,szkDifferentValueKey:"@SYNO_DIFFERENT_VALUE",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.callParent([this.fillConfig(a)])},getItems:function(){var e=this._getHistoryInfo();var c=this._getCurType();var f=this.getID();var a=[];a.push({xtype:"syno_displayfield",itemId:"file_name",name:"file_name",fieldLabel:_VST("file","file_name")},{xtype:"syno_displayfield",itemId:"file_path",name:"file_path",fieldLabel:_VST("file","file_path")});switch(f){case SYNO.SDS.VideoStation.Util._MOVIE_ID:a.push({xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("common","title"),allowBlank:false},{xtype:"syno_textfield",itemId:"tagline",name:"tagline",fieldLabel:_VST("tagline","title")});break;case SYNO.SDS.VideoStation.Util._TVSHOW_ID:a.push({xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("tvshow","title"),allowBlank:false});if(c!=="tvshow"){a.push(new SYNO.SDS.VideoStation.DateField({itemId:"tvshow_original_available",name:"tvshow_original_available",fieldLabel:_VST("original_available","title")+" ("+_VST("type","tv_show")+")",editable:false,preFocus:function(){this.el.blur()}}),{xtype:"syno_textarea",itemId:"tvshow_summary",name:"tvshow_summary",hideLabel:true,hidden:true},{xtype:"syno_textfield",itemId:"tagline",name:"tagline",fieldLabel:_VST("episode","name_title")},{xtype:"syno_numberfield",itemId:"season",name:"season",fieldLabel:_VST("season","season_title"),allowBlank:true,allowDecimals:false,allowNegative:false},{xtype:"syno_numberfield",itemId:"episode",name:"episode",fieldLabel:_VST("episode","episode_title"),allowBlank:true,allowDecimals:false,allowNegative:false})}break;default:a.push({xtype:"syno_textfield",itemId:"title",name:"title",fieldLabel:_VST("common","title"),allowBlank:false});break}switch(f){case SYNO.SDS.VideoStation.Util._TV_RECORDER_ID:case SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID:a.push({xtype:"syno_compositefield",fieldLabel:_VST("video_info","record_time"),layout:"hbox",anchor:"100%",items:[{xtype:"syno_datefield",itemId:"original_available",name:"original_available",format:"Y-m-d",editable:false,allowBlank:false,flex:1,preFocus:function(){this.el.blur()}},{xtype:"syno_timefield",listClass:"syno-vs-combo-list",itemId:"record_date",name:"record_date",format:"H:i:s",editable:false,increment:1,allowBlank:false,flex:1,preFocus:function(){this.el.blur()}}]});break;default:var b=(f===SYNO.SDS.VideoStation.Util._TVSHOW_ID&&c==="tvshow_episode")?(_VST("original_available","title")+" ("+_VST("episode","episode_title")+")"):_VST("original_available","title");a.push({xtype:"syno_datefield",itemId:"original_available",name:"original_available",fieldLabel:b,editable:false,format:"Y-m-d",preFocus:function(){this.el.blur()}});break}if(f!==SYNO.SDS.VideoStation.Util._TVSHOW_ID||c!=="tvshow"){a.push({xtype:"syno_superboxselect",itemId:"genre",name:"genre",fieldLabel:_VST("genre","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("genre"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",listeners:{scope:this,newitem:this.onAddNewitem}},{xtype:"syno_superboxselect",itemId:"actor",name:"actor",fieldLabel:_VST("actor","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("actor"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",listeners:{scope:this,newitem:this.onAddNewitem}},{xtype:"syno_superboxselect",itemId:"writer",name:"writer",fieldLabel:_VST("writer","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("writer"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",listeners:{scope:this,newitem:this.onAddNewitem}},{xtype:"syno_superboxselect",itemId:"director",name:"director",fieldLabel:_VST("director","title"),allowAddNewData:true,addNewDataOnBlur:true,store:this.getCategoryStore("director"),mode:"remote",resizable:true,pageSize:this.pageSize,grow:true,minChars:1,queryParam:"filter",triggerAction:"all",displayField:"name",valueField:"name",listeners:{scope:this,newitem:this.onAddNewitem}})}a.push({xtype:"radiogroup",itemId:"lock",name:"metadata_locked",column:2,fieldLabel:_VST("lock","status")+' <img src="'+this._getAbsoluteURL("information.png","images")+'" style="vertical-align:bottom;padding-left:3px;" border="0" ext:qtip="'+Ext.util.Format.htmlEncode(_VST("lock","desc"))+'">',items:[{xtype:"syno_radio",boxLabel:_VST("lock","status_lock"),name:"metadata_locked",inputValue:true,checked:true},{xtype:"syno_radio",boxLabel:_VST("lock","status_unlock"),name:"metadata_locked",inputValue:false}]});a.push({xtype:"syno_textarea",itemId:"summary",name:"summary",fieldLabel:_VST("summary","title"),width:300,height:130});if(f===SYNO.SDS.VideoStation.Util._MOVIE_ID||f===SYNO.SDS.VideoStation.Util._TVSHOW_ID){a.push({xtype:"syno_textfield",hideLabel:true,itemId:"extra",name:"extra",style:"display:none;"});if(c==="tvshow_episode"){a.push({xtype:"syno_textfield",hideLabel:true,itemId:"tvshow_extra",name:"tvshow_extra",style:"display:none;"})}this.sourceID=Ext.id();var d='<div class="syno-vs-source-link" style="float: right;"><a id = "{0}" style = "cursor: pointer; text-decoration: none;color: #916CD9;float:right;height:20px;">{1}</a></div>';a.push({xtype:"syno_displayfield",hideLabel:true,name:"source",value:String.format(d,this.sourceID,_VST("video_info","source"))})}return a},getCategoryStore:function(a){return new Ext.data.Store({method:"POST",remoteSort:false,proxy:new Ext.data.HttpProxy({url:this._getWebAPIURL("metadata.cgi"),listeners:{scope:this,beforeload:function(b,c){var d=b.activeRequest.read;if(d){Ext.Ajax.abort(d)}}}}),baseParams:{api:"SYNO.VideoStation.Metadata",method:"list",version:"1",type:this._getCurType(),library_id:this._getCurLibraryId(),category:a,sort_by:a,sort_direction:"ASC"},paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},reader:new Ext.data.JsonReader({id:"id",root:"data.metadatas",totalProperty:"data.total",fields:["id","name"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore}})},fillConfig:function(a){var b={trackResetOnLoad:true,cls:"syno-vs-meta-form-setting",padding:"10px 10px 0 10px",border:false,autoFlexcroll:true,labelWidth:140,defaults:{anchor:"100%"},items:this.getItems(),tbar:{xtype:"syno_toolbar",items:[]}};if(this.getID()==="tvshow"||this.getID()==="movie"){b.tbar.items.push({disabled:_S("demo_mode"),itemId:"search_correct",text:_VST("action","search_correct"),scope:this,handler:this.onLaunchSearchDialog})}b.tbar.items.push({itemId:"select_db",text:_VST("action","select_db"),scope:this,handler:function(){var c=new SYNO.SDS.VideoStation.VideoSelectionDialog({owner:this.owner});c.onLoad(this.getForm().findField("title").getValue())}},{itemId:"reset",text:_T("common","reset"),scope:this,handler:function(){this.getForm().reset()}});return Ext.apply(SYNO.LayoutConfig.fill(b),a)},onBeforeLoadStore:function(a,b){var c=b.params;Ext.apply(c,{library_id:this._getCurLibraryId()});return c},onLaunchSearchDialog:function(){var e=new SYNO.SDS.VideoStation.SearchDialog({owner:this.owner});var c=this.getForm().findField("episode");var a=this.getForm().findField("season");var d,b;if(a){d=a.getValue()}if(c){b=c.getValue()}e.onLoad(this.getForm().findField("title").getValue(),d,b)},onAddNewitem:function(b,a,c){a=a.trim();if(a){if(/[|]/.test(a)){this.owner.getMsgBox().alert(_VST("metadata","title"),_VST("error","illegal_char"));return}b.addItem({name:a,display:Ext.util.Format.htmlEncode(a)},true)}},getID:function(){var a=this._getCurType();return(a==="tvshow_episode")?"tvshow":a},loadResponse:function(e){var d=this._getHistoryInfo();var f=this.getID();var b=d.response_root;if(!b){var a=SYNO.SDS.VideoStation.Util.SEC_CFG[f];b=a.data[a.data.length-1].response_root}var c=e[b];if(Ext.isArray(c)){c=c[0]}this.onLoadData(c)},onSetData:function(d,c){var a=false;if("tvshow_episode"===this._getCurType()){a=(d.title!==this.getForm().findField("title").getValue())&&(d.tvshow_original_available!==this.getForm().findField("tvshow_original_available").getValue())}var b=this.getForm();b.trackResetOnLoad=false;this.onLoadData(d);b.trackResetOnLoad=true;if(c!==true&&a){this.owner.getMsgBox().confirm(_VST("metadata","title"),_VST("metadata","research_msg"),function(e){if("yes"===e){this.onLaunchSearchDialog()}},this)}},onLoadData:function(g){if(Ext.isEmpty(g)){this.owner.getMsgBox().alert(_VST("metadata","title"),_VST("error","no_data"),function(){var m=SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.PathHistoryMgr").getActiveItem();m.onActivate(false);this.owner.getTabPanel().resetAllForm();this.owner.close()},this);return}var d=this.getForm();var k=d.getFieldValues();for(var c in k){if(k.hasOwnProperty(c)){var f=g[c]||(g.additional?g.additional[c]:undefined);this.setFieldValue(c,f)}}var j=this.getForm().findField("metadata_locked");if(j){j.setVisible(Ext.isBoolean(g.metadata_locked));var l=j.items.items[g.metadata_locked===false?1:0];l.setValue(true);j.eachItem(function(m){m.initValue()})}var b,e;if(g.original_available){e=this.getForm().findField("original_available");b=g.original_available.split("-");if(b.length!==3&&b.length===1){g.original_available=g.original_available+"-01-01";b=g.original_available.split("-")}this.getForm().setValues({original_available:(b.length===3)?g.original_available:""})}if(g.record_date){e=this.getForm().findField("original_available");var a=this.getForm().findField("record_date");b=g.record_date.split(" ");this.getForm().setValues({original_available:b[0],record_date:b[1]})}this.loadedFormString=this.getForm().getValues(true);this.doLayout()},isModified:function(){return this.loadedFormString!==this.getForm().getValues(true)},setFieldValue:function(f,e){var d;if((d=this.getForm().findField(f))&&Ext.isDefined(e)){if(Ext.isArray(e)&&Ext.isFunction(d.setValueEx)){var a=[],b;for(var c=0;c<e.length;c++){b=e[c].name;a.push({name:b,display:Ext.util.Format.htmlEncode(b)})}d.setValueEx(a);d.originalValue=d.getValue()}else{this.getForm().setValues([{id:f,value:e||""}])}}},onSetVisibleFileFields:function(a,d){var c=this.getForm().findField("file_name");var b=this.getForm().findField("file_path");if(c&&b){c.setVisible(a||false);b.setVisible(a||false);if(d){this.getForm().setValues({file_name:SYNO.SDS.VideoStation.Util.parseFullPathToFileName(d),file_path:d})}}},showItems:function(a){if(!Ext.isArray(a)){a=[a]}Ext.each(this.getForm().items.keys,function(b){form.findField(b)[(-1!=a.indexOf(b))?"show":"hide"]()})},clearValues:function(){var a=this.getForm();a.items.each(function(b){if(b.name&&b.name==="source"){return}if(b.xtype==="radiogroup"){b.items.items[0].setValue(true);b.items.items[1].setValue(false)}else{if(b.clearValue){b.clearValue()}else{b.setValue("")}}})},onLoadDatas:function(c){var b=this.getForm();var a=["title","tvshow_original_available","season","episode"];b.items.each(function(d){if(-1===a.indexOf(d.itemId)){d.hide();d.disable()}});b.setValues(Ext.apply({title:c[0].get("title"),tvshow_original_available:c[0].get("tvshow_original_available")},this.getSeasonEpisodeValues(c)));this.loadedFormString=this.getForm().getValues(true);this.doLayout()},getSeasonEpisodeValues:function(e){var d,c=true;var b,f=true;Ext.each(e,function(g){if(!d){d=g.get("season")}else{if(d!==g.get("season")){c=false}}if(!b){b=g.get("episode")}else{if(b!==g.get("episode")){f=false}}});var a={};if(c&&d){a.season=d}if(f&&b){a.episode=b}return a}});Ext.namespace("SYNO.SDS.VideoStation");SYNO.SDS.VideoStation.LibraryPermissionGrid=Ext.extend(SYNO.SDS.VideoStation.CheckBoxGrid,{cgiURL:"library_manage.cgi",constructor:function(b){this.module=b.module;this.library_id=b.library_id;var a=Ext.apply({cls:"library-permission-grid",autoExpandColumn:"name",plugins:[this.getBrowseColumn()]},b);SYNO.SDS.VideoStation.LibraryPermissionGrid.superclass.constructor.call(this,a);this.changes=b.permission;this.saveChanges=this.saveLocalChanges;this.getStore().on("load",this.applyLocalChanges,this);this.getStore().on("load",this.onUserLoad,this)},getStore:function(){if(this.store){return this.store}var b={action:"list_permission"};if(Ext.isDefined(this.library_id)){Ext.apply(b,{library_id:this.library_id})}var a=new Ext.data.JsonStore({autoLoad:true,root:"data.users",totalProperty:"data.total",baseParams:b,fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:false},{name:"browse",type:"boolean",defaulValue:false}],proxy:new Ext.data.HttpProxy({url:this.module._getAbsoluteURL(this.cgiURL),listeners:{beforeload:SYNO.SDS.VideoStation.Util.onProxyBeforeLoad}})});return(this.store=a)},getColumns:function(){if(this.colModel){return this.colModel}var a={defaults:{align:"center",sortable:false},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getBrowseColumn()]};return(this.colModel=new Ext.grid.ColumnModel(a))},getBrowseColumn:function(){if(this.browseColumn){return this.browseColumn}return(this.browseColumn=new SYNO.SDS.VideoStation.EnableColumn({header:_VST("common","browse"),dataIndex:"browse",id:"browse",width:150,ignoreKey:"is_admin"}))},getChanges:function(){if(!this.isDirty()){return}var a=this.getStore().getModifiedRecords();var b={};Ext.each(a,function(c){var d=c.get("uid");if(!Ext.isDefined(b[d])){b[d]={}}b[d]["browse"]=c.get("browse")});return b},getLocalChanges:function(){var a=this.changes||{};return Ext.apply(a,this.getChanges())},saveLocalChanges:function(a){if(!Ext.isDefined(this.changes)){this.changes={}}Ext.apply(this.changes,this.getChanges());this.getStore().commitChanges();this.getStore().load(a)},applyLocalChanges:function(b,a,c){if(!Ext.isDefined(this.changes)){return}b.each(function(d){var e=d.get("uid");if(Ext.isDefined(this.changes[e])){d.set("browse",this.changes[e]["browse"])}},this);b.commitChanges()},onUserLoad:function(c,b,d){var e=this.getEl();if(c.getCount()===0){var a=e.mask(_VST("privilege","no_user_hint"),"syno-ux-mask-info")}else{if(e.isMasked()){e.unmask()}}}});Ext.define("SYNO.SDS.VideoStation.LibraryPermissionDialog",{extend:"SYNO.SDS.VideoStation.ModalWindow",constructor:function(a){SYNO.SDS.VideoStation.Util._initWinWrappers.call(this,a);this.library_id=a.library_id;this.callParent([this.fillConfig(a)])},fillConfig:function(b){var a={width:500,height:600,minWidth:300,minHeight:280,resizable:true,cls:"syno-vs-library-dialog",title:_VST("library","permission"),layout:"fit",items:[this.getGridPanel()],buttons:[{btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{text:_T("common","cancel"),scope:this,handler:this.onCancel}]};return Ext.apply(a,b)},getGridPanel:function(){if(this.grid){return this.grid}this.grid=new SYNO.SDS.VideoStation.LibraryPermissionGrid({module:this,library_id:this.library_id,permission:this._getOwner().permission});return this.grid},onApply:function(){if(!this.grid.isDirty()){this.close();return}this.save()},save:function(){var a=this._getOwner();if(!Ext.isDefined(a.permission)){a.permission=this.grid.getLocalChanges()}else{Ext.apply(a.permission,this.grid.getLocalChanges())}this.close()},onCancel:function(){if(!this.grid.isDirty()){this.close();return}var a=function(b){if("yes"===b){this.close()}};this._getOwner().getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),a,this)}});Ext.define("SYNO.SDS.VideoStation.LibraryDialog",{extend:"SYNO.SDS.VideoStation.AddEditDialog",constructor:function(b){this.library=b.library;var a=Ext.apply({width:485,height:320,resizable:false,cls:"syno-vs-library-dialog",applyButton:{btnStyle:"blue",text:_T("common","alt_apply"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",scope:this,handler:this.onRequest}},b);this.callParent([a])},getFormPanel:function(){if(this.formPanel){return this.formPanel}var d={xtype:"syno_textfield",itemId:"title",fieldLabel:_T("common","name"),width:250,allowBlank:false,maxLength:50};var c={xtype:"radiogroup",itemId:"type",fieldLabel:_VST("type","tile"),columns:1,items:[{xtype:"syno_radio",boxLabel:_VST("type","movie"),inputValue:SYNO.SDS.VideoStation.Util._MOVIE_ID,name:"type",checked:true},{xtype:"syno_radio",boxLabel:_VST("type","tv_show"),inputValue:SYNO.SDS.VideoStation.Util._TVSHOW_ID,name:"type",checked:false},{xtype:"syno_radio",boxLabel:_VST("type","others"),inputValue:SYNO.SDS.VideoStation.Util._HOME_VIDEO_ID,name:"type",checked:false}]};var e={xtype:"radiogroup",itemId:"is_public",fieldLabel:_VST("library","permission_title"),columns:1,items:[{xtype:"syno_radio",boxLabel:_VST("library","public"),inputValue:1,name:"is_public",checked:true},{xtype:"syno_radio",boxLabel:_VST("library","private"),inputValue:0,name:"is_public",checked:false}],listeners:{scope:this,change:{fn:function(g,f){this.getFormPanel().getComponent("permissionButton").setDisabled(f.inputValue===1)}}}};var b={xtype:"syno_button",btnStyle:"red",style:"margin-left: 185px;",cls:"form-button",itemId:"permissionButton",disabled:true,text:_VST("library","permission"),handler:this.openPermissionDialog.createDelegate(this)};var a={trackResetOnLoad:true,border:false,labelWidth:180,hideLabels:false,items:[d,c,e,b]};return(this.formPanel=new SYNO.ux.FormPanel(a))},openPermissionDialog:function(){var a=new SYNO.SDS.VideoStation.LibraryPermissionDialog({owner:this,library_id:Ext.isDefined(this.library)?this.library.id:undefined});a.open()},onOpen:function(){if("edit"===this.mode){var a=this.getFormPanel().getForm();a.findField("title").setValue(this.library.title);a.findField("type").setValue(this.library.type);a.findField("is_public").setValue(this.library.is_public?1:0)}SYNO.SDS.VideoStation.FolderDialog.superclass.onOpen.call(this)},onRequest:function(){if(!this.getFormPanel().getForm().findField("title").validate()){this.getMsgBox().alert(_VST("library","title"),_T("error","error_bad_field"));return}SYNO.SDS.VideoStation.LibraryDialog.superclass.onRequest.call(this,"library_manage.cgi")},onRequestDone:function(a,d,b){this.clearStatusBusy();if(b&&b.success){this.module.libraryList.reload();SYNO.SDS.VideoStation.Window.getPanelScope("SYNO.SDS.VideoStation.ListPanel").loadLibrary();this.close()}else{var c=SYNO.SDS.VideoStation.Util.getErrinfoString(b,_T("common","commfail"));this.getMsgBox().alert(_VST("library","title"),c)}},getParameter:function(){var b=this.getFormPanel().getForm();var e=b.findField("title").getValue();var a=b.findField("type").getValue().inputValue;var c=b.findField("is_public").getValue().inputValue;var d={title:e,is_public:c,type:a,permission:Ext.util.JSON.encode(this.permission||{})};if("edit"===this.mode&&Ext.isDefined(this.library)){Ext.apply(d,{id:this.library.id,old_type:this.library.type,old_is_public:this.library.is_public?1:0,old_title:this.library.title})}return d},isDirty:function(){if(!Ext.isDefined(this.library)){return false}var d=this.getFormPanel().getForm();var f=d.findField("title").getValue();var c=d.findField("type").getValue().inputValue;var e=d.findField("is_public").getValue().inputValue;var a=this.library.is_public?1:0;var b=(f!==this.library.title)||(c!==this.library.type)||(e!==a)||Ext.isObject(this.permission);return b}});Ext.define("SYNO.SDS.VideoStation.EnableColumn",{extend:"SYNO.ux.EnableColumn",constructor:function(a){this.callParent([a])},isIgnore:function(b,a){if(Ext.isEmpty(this.ignoreKey)){return false}return(true===a.get(this.ignoreKey))},renderer:function(g,e,a,f,c,b){var d=this.scope;if(Ext.isString(d.ignoreKey)&&a.data[d.ignoreKey]===true){return SYNO.SDS.VideoStation.EnableColumn.superclass.renderer.call(this,"gray",e,a,f,c,b)}else{return SYNO.SDS.VideoStation.EnableColumn.superclass.renderer.apply(this,arguments)}}});