ACTION="$1"
PKG_PATH="$2"

if [ "${ACTION}" = "start" ]; then
	local VersionMajor=`cat /etc.defaults/VERSION | grep majorversion | cut -d'"' -f2`
	local VersionMinor=`cat /etc.defaults/VERSION | grep minorversion | cut -d'"' -f2`
	local FileExist=`ls ${PKG_PATH}/target/etc/KernelModules/ | grep "${VersionMajor}\.${VersionMinor}" | grep "bz2"`
	local DriverMatchAlready=`ls ${PKG_PATH}/target/etc/KernelModules/ | grep "${VersionMajor}\.${VersionMinor}_driver"`

	[ -n "${FileExist}" ] || touch /tmp/DVB_driver_tar_${VersionMajor}\.${VersionMinor}_has_gone

	if [ "${DriverMatchAlready}" = "" -a "${FileExist}" != "" ]; then
		rm -f ${PKG_PATH}/target/etc/KernelModules/*.ko
		sleep 1s
		/bin/tar -jxf ${PKG_PATH}/target/etc/KernelModules/${FileExist} -C ${PKG_PATH}/target/etc/KernelModules/;
		if [ "$?" != "0" ]; then
			echo "tar ${FileExist} failed...exit now" >> /tmp/DVB_driver_untar_error
			exit
		else
			rm -f ${PKG_PATH}/target/etc/KernelModules/*_driver
			touch ${PKG_PATH}/target/etc/KernelModules/${VersionMajor}\.${VersionMinor}_driver
		fi
	fi

	if [ "`cat /usr/syno/hotplug/usb.agent | grep "hotplug/usb.DVB.function" | grep "MAJOR"`" = "" ]; then
		/bin/sed -i 's/usb.DVB.function "$ACTION" "$usb_idVendor" "$usb_idProduct"/usb.DVB.function "$ACTION" "$usb_idVendor" "$usb_idProduct" "$MAJOR" "$MINOR"/' /usr/syno/hotplug/usb.agent
	fi

	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh "start" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh "start" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/Hotplug/usb.DVB.function" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/usb.DVB.function /usr/syno/hotplug
	[ -e "${PKG_PATH}/target/scripts/Hotplug/usb.DVB.dep.table" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/usb.DVB.dep.table /usr/syno/hotplug
	[ -e "${PKG_PATH}/target/scripts/Hotplug/usb.DVB.VIDPID.table" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/usb.DVB.VIDPID.table /usr/syno/hotplug
	[ -e "${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh" ] && ${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh "add"
else
	[ -e "${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh" ] && ${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh "remove"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh "stop" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh "stop" "${PKG_PATH}"
	[ -e "/usr/syno/hotplug/usb.DVB.function" ] && rm -f /usr/syno/hotplug/usb.DVB.function
	[ -e "/usr/syno/hotplug/usb.DVB.dep.table" ] && rm -f /usr/syno/hotplug/usb.DVB.dep.table
	[ -e "/usr/syno/hotplug/usb.DVB.VIDPID.table" ] && rm -f /usr/syno/hotplug/usb.DVB.VIDPID.table
fi
