/* Copyright (c) 2014 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.VideoPlayerCommonVC.VideoDisplay",{extend:"Ext.Container",constructor:function(b){var a={layout:"border",itemId:"video_display",cls:"video-display",hideMode:"offsets",items:[{xtype:"container",itemId:"video",region:"center",cls:"video"},new SYNO.SDS.VideoPlayerCommonVC.SubtitleDisplay({itemId:"subtitle",region:"south",hidden:true})]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleDisplay",{extend:"Ext.Container",SUBTITLE_HEIGHT:80,MAX_LINE:6,constructor:function(b){var a={height:this.SUBTITLE_HEIGHT,cls:"subtitle",prev_text:null};this.callParent([Ext.apply(a,b)])},setText:function(f){if(f===this.prev_text){return}this.prev_text=f;var b=this.SUBTITLE_HEIGHT;var c=Ext.min([f.split("<br/>").length,this.MAX_LINE]);var e=(c>1)?(b/c):b;var a=(c>1)?(e*0.9):(b*0.45);var d=this.getEl();d.update(f);d.setStyle("font-size",a.toFixed(2)+"px");d.setStyle("line-height",e.toFixed(2)+"px")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.MetaDisplay",{extend:"Ext.Container",constructor:function(b){var a={itemId:"meta_display",cls:"meta-display",hidden:true,hideMode:"offsets",html:this.getHtml()};this.callParent([Ext.apply(a,b)])},setImage:function(b){var a=Ext.get(this.getIconID());if(""===b){this.icon_src="";a.hide();a.setStyle("background-image","")}else{if(b===this.icon_src){return}this.icon_src=b;a.setStyle("background-image",String.format("url({0})",b));a.show()}},setText:function(a){if(!Ext.isString(a)){return}Ext.get(this.getTextID()).update(Ext.util.Format.htmlEncode(a))},getTextID:function(){if(!Ext.isDefined(this.text_id)){this.text_id=Ext.id()}return this.text_id},getIconID:function(){if(!Ext.isDefined(this.icon_id)){this.icon_id=Ext.id()}return this.icon_id},getHtml:function(){return['<table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0">',"<tbody>","<tr><td>",'<div class="frame">','<div class="cover-frame"></div>','<div class="icon-frame"><div class="icon" id="'+this.getIconID()+'"></div></div>',"</div>",'<div class="status-text" id="'+this.getTextID()+'"></div>',"</td></tr>","</tbody>","</table>"].join("")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Display",{extend:"Ext.Container",constructor:function(b){var a={layout:"card",itemId:"body",cls:"syno-vp-body",activeItem:0,items:[this.getVideoDisplay(),this.getMetaDisplay()],listeners:{scope:this,afterrender:function(){SYNO.SDS.VideoPlayerCommonVC.Util.hookDoLayout(this)}}};this.callParent([Ext.apply(a,b)])},setSubtitle:function(a){this.getVideoDisplay().getComponent("subtitle").setText(a)},showSubtitle:function(a){this.getVideoDisplay().getComponent("subtitle")[(true===a)?"show":"hide"]();this.doLayout()},getVideoDisplay:function(){if(!Ext.isDefined(this.video_display)){this.video_display=new SYNO.SDS.VideoPlayerCommonVC.VideoDisplay()}return this.video_display},getMetaDisplay:function(){if(!Ext.isDefined(this.meta_display)){this.meta_display=new SYNO.SDS.VideoPlayerCommonVC.MetaDisplay()}return this.meta_display},setState:function(a,b){switch(a){case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED:this.setStopped();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING:this.setPlaying();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING:this.setBuffering();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:SYNO.Debug("error: ",b);this.setError(b);break;default:break}},setStopped:function(){this.layout.setActiveItem(0);this.getMetaDisplay().removeClass(["buffer","error"])},setPlaying:function(){this.layout.setActiveItem(0)},setBuffering:function(){this.layout.setActiveItem(1);this.getMetaDisplay().addClass("buffer");this.getMetaDisplay().removeClass("error");this.getMetaDisplay().setText("")},setError:function(a){this.layout.setActiveItem(1);this.getMetaDisplay().addClass("error");this.getMetaDisplay().removeClass("buffer");this.getMetaDisplay().setText(a);this.getMetaDisplay().setImage("")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Util",{statics:{STATE:{NO_MEDIA:0,STOPPED:1,PLAYING:2,PAUSED:3,BUFFERING:4,ERROR:5,CLEAR:6},MimeType:{ogg:"audio/ogg",ogv:"video/ogg",wav:"audio/wav",mp3:"audio/mpeg",m4a:"audio/mp4",m4b:"audio/mp4",m4v:"video/mp4",mov:"video/mp4"},getFileExt:function(a){var b=(/[.]/.exec(a))?/[^.]+$/.exec(a)[0]:"";return b.toLowerCase()},createVLCElement:function(e,f,d,a,c){var b;if(Ext.isIE||Ext.isIE11){b=e.createChild({tag:"object",id:f,classid:"clsid:9BE31822-FDAD-461B-AD51-BE1D1C159921",codebase:"http://download.videolan.org/pub/videolan/vlc/last/win32/axvlc.cab",width:d||"100%",height:a||"100%",style:c||"",cn:[{tag:"param",name:"src",value:""},{tag:"param",name:"allowfullscreen",value:"false"},{tag:"param",name:"bgcolor",value:"#000000"},{tag:"param",name:"toolbar",value:"false"}]})}else{b=e.createChild({tag:"embed",id:f,type:"application/x-vlc-plugin",version:"VideoLAN.VLCPlugin.2",pluginspage:"http://www.videolan.org/",width:d||"100%",height:a||"100%",style:c||"",src:"",allowfullscreen:"false",bgcolor:"#000000",toolbar:"false"})}return b},isVLCSupported:function(){if(Ext.isMac&&Ext.isSafari){return false}var a=SYNO.SDS.VideoPlayerCommonVC.Util.detectPlugin("VideoLAN.VLCPlugin.2","VideoLAN","VLC")||SYNO.SDS.VideoPlayerCommonVC.Util.detectPlugin("VideoLAN.VLCPlugin.2","VLC","VLC");return a},detectPlugin:function(){var b,d,a,c=navigator.plugins||[],f=arguments;if(Ext.isIE||Ext.isIE11){try{if((new ActiveXObject(f[0]))){return true}}catch(g){}return false}for(b=0;b<c.length;++b){a=true;for(d=1;d<f.length;++d){if(-1===c[b].name.indexOf(f[d])&&-1===c[b].description.indexOf(f[d])){a=false;break}}if(a){return true}}return false},addDomListener:function(a){return function(f,e,d,c,b){if(!f||!Ext.isString(e)||!Ext.isFunction(d)||!Ext.isObject(c)){return}if(a&&Ext.isIE&&f.attachEvent){f.attachEvent(e,d.createDelegate(c,b))}else{if(Ext.isFunction(f.addEventListener)){f.addEventListener(e,d.createDelegate(c,b),false)}else{f["on"+e]=d.createDelegate(c,b)}}}},FullscreenEventMap:{requestFullscreen:"fullscreenchange",webkitRequestFullscreen:"webkitfullscreenchange",mozRequestFullScreen:"mozfullscreenchange",msRequestFullscreen:"MSFullscreenChange"},FullscreenFn:["requestFullscreen","webkitRequestFullscreen","mozRequestFullScreen","msRequestFullscreen"],hookDoLayout:function(a){var c;var b=a.getEl();Ext.each(SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenFn,function(e){if(Ext.isFunction(b.dom[e])){c=SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenEventMap[e];return false}});if(Ext.isString(c)){var d=function(){SYNO.Debug("dolayout");a.doLayout()};SYNO.Debug("add fullscreen listener to: ",c);document.addEventListener(c,d,false)}},setDomFullscreen:function(a){Ext.each(SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenFn,function(b){if(Ext.isFunction(a[b])){a[b]();return false}})},isDomFullscreenSupported:function(){var b=document.body;var a=false;Ext.each(SYNO.SDS.VideoPlayerCommonVC.Util.FullscreenFn,function(c){if(Ext.isFunction(b[c])){a=true;return false}});return a}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Button",{extend:"SYNO.ux.Button",constructor:function(b){var a={cls:"vp-button",handler:this.clickHandler};this.callParent([Ext.apply(a,b)])},getController:function(){return this.module.getController()},clickHandler:Ext.emptyFn});Ext.define("SYNO.SDS.VideoPlayerCommonVC.PlayButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(a){this.callParent([a]);this.addClass("big");this.addClass("play-pause");this.addClass("play")},clickHandler:function(){this.getController().play()}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.StopButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(a){this.callParent([a]);this.addClass("stop")},clickHandler:function(){this.getController().stop()}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Slider",{extend:"Ext.slider.SingleSlider",constructor:function(b){var a={animate:false,increment:1,value:0,listeners:{scope:this,change:this.onChange,changecomplete:this.onChangeComplete,afterrender:this.onAfterRender}};this.callParent([Ext.apply(a,b)]);this.addClass("vp-slider")},onChange:Ext.emptyFn,onChangeComplete:Ext.emptyFn,onAfterRender:Ext.emptyFn,isDragging:function(){return this.thumbs[0].dragging}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ProgressBar",{extend:"SYNO.SDS.VideoPlayerCommonVC.Slider",progressMax:10000,constructor:function(b){var a={minValue:0,maxValue:this.progressMax};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vp-progress-bar");this.duration=0},updateView:function(a,b){this.duration=b||this.duration;if(Ext.isNumber(this.duration)&&this.duration>0){this.setDisable(false);if(!this.isDragging()){this.setValue(this.progressMax*a/this.duration)}}else{this.setDisable(true)}},insertSeekProgress:function(){if(this.seekProgress){return}this.seekProgress=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"progress"},true);this.seekProgress.setWidth(0);this.halfThumb=12},onAfterRender:function(){this.insertSeekProgress();this.setValue(1);this.setValue(0)},onChange:function(c,d,b){var a=this.duration*d/this.progressMax;this.module.getControlPanel().setPlaybackPosition(a);this.seekProgress.setWidth(b.el.getLeft(true)+this.halfThumb)},onChangeComplete:function(c,d,b){var a=this.duration*d/this.progressMax;if(Ext.isNumber(a)){this.module.getController().seek(a)}},setDisable:function(a){if(a){this.setValue(0);this.seekProgress.setWidth(0);this.disable()}else{this.enable()}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Menu",{extend:"Ext.menu.Menu",constructor:function(b){var a={cls:"syno-vp-menu",listeners:{scope:this,beforerender:function(){this.orig_useShims=Ext.useShims;Ext.useShims=true},afterrender:function(){Ext.useShims=this.orig_useShims}}};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ItemMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.Menu",constructor:function(b){var a={defaultOffsets:[0,-11]};this.callParent([Ext.apply(a,b)]);this.addClass("item-menu")},addItemGeneral:function(g,f,a,d,b){var e=Ext.util.Format.ellipsis(f,40,false);var c=new Ext.menu.Item({item_id:g,text:Ext.util.Format.htmlEncode(e),cls:a,group:d||"",scope:this,handler:b,listeners:{render:function(){this.getEl().dom.qtip=Ext.util.Format.htmlEncode(f)}}});this.addItem(c)},addTitle:function(b,a){if(!Ext.isString(b)){return}this.addItemGeneral(Ext.id(),b,"title",a,Ext.emptyFn)},addOneItem:function(f,e,a,c,d){if(!Ext.isDefined(f)||!Ext.isString(e)||!Ext.isFunction(a)){return}var b=function(){this.setItemSelected(f,d);a()};this.addItemGeneral(f,e,((true===c)?"selected":""),d,b)},setItemSelected:function(b,a){if(!this.items||!Ext.isDefined(b)){return}this.items.each(function(c){if(!Ext.isDefined(a)||c.group===a){c.removeClass("selected");c[(c.item_id===b)?"addClass":"removeClass"]("selected")}})},removeGroup:function(a){if(!Ext.isObject(this.items)){return}this.items.each(function(b){if(b.group===a){this.remove(b)}},this)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu",{statics:{ID_NO_SUBTITLE:"no_subtitle",ID_EXTERNAL:"external"},extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",constructor:function(a){this.callParent([a]);this.addNoSubtitleItem()},addNoSubtitleItem:function(){this.addOneItem(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,_T("video_player","no_subtitle"),this.setNoSubtitle.createDelegate(this),true)},setNoSubtitle:function(){this.button.getController().setSubtitleEnabled(false)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.MenuButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={menu:this.createMenu(),menuAlign:"br-tr"};this.callParent([Ext.apply(a,b)])},createMenu:Ext.emptyFn,getMenuClass:function(){return""}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(a){this.callParent([a]);this.addClass("subtitle")},createMenu:function(){return new SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu({button:this})}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.FullscreenButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={disabled:!SYNO.SDS.VideoPlayerCommonVC.Util.isDomFullscreenSupported()};this.callParent([Ext.apply(a,b)]);this.addClass("fullscreen")},clickHandler:function(){this.getController().fullscreen()}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VolumeButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){this.module=b.module;var a={muted:false,menuAlign:"b-t"};this.callParent([Ext.apply(a,b)]);this.addClass("volume")},createMenu:function(){this.volumePanel=new SYNO.SDS.VideoPlayerCommonVC.VolumePanel({module:this.module});var a=new SYNO.SDS.VideoPlayerCommonVC.Menu({cls:"syno-vp-volume-menu",defaultOffsets:[0,-11],items:[this.volumePanel]});return a},setMute:function(a){this.muted=a;if(this.muted){this.addClass("mute");this.hideMenu()}else{this.removeClass("mute");if(this.getEl().hasClass("x-btn-over")){this.showMenu()}}},setVolume:function(a){this.volumePanel.volumeBar.updateView(a)},clickHandler:function(){this.getController().toggleMute()},onClick:function(a){if(a){a.preventDefault()}if(a.button!==0||this.disabled){return}this.doToggle();this.fireEvent("click",this,a);if(this.handler){this.handler.call(this.scope||this,this,a)}},onMouseOver:function(a){if(!this.muted&&!this.disabled){this.showMenu()}this.callParent(arguments)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VolumePanel",{extend:"Ext.Panel",constructor:function(b){this.volumeBar=new SYNO.SDS.VideoPlayerCommonVC.VolumeBar({module:b.module});var a={cls:"vp-volume-panel",frame:true,items:[this.volumeBar]};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VolumeBar",{extend:"SYNO.SDS.VideoPlayerCommonVC.Slider",constructor:function(b){var a={cls:"vp-volume-bar",minValue:0,maxValue:100,vertical:true};this.callParent([Ext.apply(a,b)])},updateView:function(a){if(!this.disabled&&!this.isDragging()){this.setValue(a)}},insertVolumeStrip:function(){if(this.volumeStrip){return}this.volumeStrip=Ext.DomHelper.insertBefore(this.thumbs[0].el,{tag:"div",cls:"volume"},true);this.volumeStrip.setHeight(0);this.halfThumb=8},onAfterRender:function(){this.insertVolumeStrip();var a=this.getValue();this.setValue(1);this.setValue(a)},onChange:function(c,d,b){var a=d/100*138;this.volumeStrip.setHeight(a)},onChangeComplete:function(b,c,a){if(!this.disabled){this.module.getController().setVolume(c)}},setDisable:function(a){if(a){this.setValue(0);this.volumeStrip.setWidth(0);this.disable()}else{this.enable()}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.TimeText",{extend:"Ext.Toolbar.TextItem",constructor:function(b){var a={text:"00:00"};this.callParent([Ext.apply(a,b)])},formatTime:function(c){c=parseInt(Math.round(c),10);var a=parseInt(c/3600,10);var d=parseInt((c%3600)/60,10);var b=c%60;return((a>0)?a+":":"")+String.leftPad(d,2,"0")+":"+String.leftPad(b,2,"0")},updateView:function(a){if(!Ext.isNumber(a)||0>=a){this.setText("00:00")}else{this.setText(this.formatTime(a))}}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ControlBar",{extend:"SYNO.ux.Toolbar",slashConfig:{cls:"slash",xtype:"tbtext",text:" / "},constructor:function(b){this.module=b.module;var a={items:[{xtype:"tbspacer",width:14},this.getPlayButton(),this.getStopButton(),{xtype:"tbspacer",width:14},{xtype:"tbseparator",cls:"vp-separator"},{xtype:"tbspacer",width:30},this.getPositionText(),this.slashConfig,this.getDurationText(),"->",this.getVolumeButton(),this.getSubtitleButton(),this.getFullscreenButton(),{xtype:"tbspacer",width:14}]};this.callParent([Ext.apply(a,b)]);this.addClass("syno-vp-control-bar")},getPlayButton:function(){if(!Ext.isDefined(this.playButton)){this.playButton=new SYNO.SDS.VideoPlayerCommonVC.PlayButton({module:this.module})}return this.playButton},getStopButton:function(){if(!Ext.isDefined(this.stopButton)){this.stopButton=new SYNO.SDS.VideoPlayerCommonVC.StopButton({module:this.module})}return this.stopButton},getPositionText:function(){if(!Ext.isDefined(this.positionText)){this.positionText=new SYNO.SDS.VideoPlayerCommonVC.TimeText({cls:"position"})}return this.positionText},getDurationText:function(){if(!Ext.isDefined(this.durationText)){this.durationText=new SYNO.SDS.VideoPlayerCommonVC.TimeText({cls:"duration"})}return this.durationText},getVolumeButton:function(){if(!Ext.isDefined(this.volumeButton)){this.volumeButton=new SYNO.SDS.VideoPlayerCommonVC.VolumeButton({module:this.module})}return this.volumeButton},getSubtitleButton:function(){if(!Ext.isDefined(this.subtitleButton)){this.subtitleButton=new SYNO.SDS.VideoPlayerCommonVC.SubtitleButton({module:this.module})}return this.subtitleButton},getFullscreenButton:function(){if(!Ext.isDefined(this.fullscreenButton)){this.fullscreenButton=new SYNO.SDS.VideoPlayerCommonVC.FullscreenButton({module:this.module})}return this.fullscreenButton}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Player",{extend:"Ext.util.Observable",constructor:function(b){var a=Ext.apply({name:"",player:null,pluginInit:false},b);this.callParent([a]);Ext.apply(this,a)},canPlayType:Ext.emptyFn,isAvailable:Ext.emptyFn,getName:function(){return this.name},fullscreen:Ext.emptyFn,play:Ext.emptyFn,pause:Ext.emptyFn,resume:Ext.emptyFn,stop:Ext.emptyFn,seek:Ext.emptyFn,getPosition:Ext.emptyFn,getDuration:Ext.emptyFn,getVolume:Ext.emptyFn,setVolume:Ext.emptyFn,getMute:Ext.emptyFn,setMute:Ext.emptyFn,getState:Ext.emptyFn,disablePlayerSubtitle:Ext.emptyFn,setStartPosition:function(a){if(Ext.isNumber(a)&&a>0){this.start_position=a}},notifyClear:function(){this.controller.updateState(SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR)},clear:function(){if(this.player){this.el.remove();this.el=null;this.player=null;this.pluginInit=false;this.notifyClear()}},stateHandler:function(d){var c=this.getState();if(c===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING){this.disablePlayerSubtitle();if(Ext.isNumber(this.start_position)){var a=this.start_position;this.start_position=null;var b=this.seek.createDelegate(this,[a]);b.defer(200)}}this.controller.updateState(c,d)},durationHandler:function(b){var a=Ext.isNumber(b)?b:this.getDuration();this.controller.updateDuration(a)},positionHandler:function(a){var b=Ext.isNumber(a)?a:this.getPosition();this.controller.updatePosition(b)},volumeHandler:function(){this.controller.updateMute(this.getMute());this.controller.updateVolume(this.getVolume())},registerEventHandler:Ext.emptyFn});Ext.define("SYNO.SDS.VideoPlayerCommonVC.HTML5Player",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"HTML5",player_id:"_html5_video_player",stopped:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(b){var a=document.createElement("video"),c=SYNO.SDS.VideoPlayerCommonVC.Util.MimeType[b]||("video/"+b);if(!a||!Ext.isFunction(a.canPlayType)){return false}return a.canPlayType(c)},isAvailable:function(){var a=document.createElement("video");if(!a||!Ext.isFunction(a.canPlayType)){return false}return true},fullscreen:function(){if(this.pluginInit){SYNO.SDS.VideoPlayerCommonVC.Util.setDomFullscreen(this.controller.container.dom)}},play:function(a){this.stopped=false;this.createPlayer();this.player.src=a;this.player.play();this.setVolume(this.controller.volume)},pause:function(){if(this.pluginInit){this.player.pause()}},resume:function(){if(this.pluginInit){this.player.play()}},stop:function(){if(this.pluginInit){this.stopped=true;this.player.pause();this.stateHandler()}},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.duration){this.player.currentTime=a}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.currentTime},getDuration:function(){if(!this.pluginInit){return -1}return this.player.duration},getVolume:function(){if(!this.pluginInit){return -1}return this.player.volume*100},setVolume:function(a){if(this.pluginInit){this.player.volume=a/100}},getMute:function(){var a=false;if(this.pluginInit){a=this.player.muted}return a},setMute:function(a){if(this.pluginInit){this.player.muted=a}},getState:function(){if(!this.pluginInit){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA}if(this.player.error){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR}if(this.player.ended||this.player.HAVE_NOTHING===this.player.readyState||this.stopped){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED}if(this.player.paused){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED}if(this.player.HAVE_CURRENT_DATA>=this.player.readyState){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING}return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING},setVisible:function(a){if(Ext.isSafari&&this.el){this.el.setVisible(a)}},createPlayer:function(){if(this.player){return false}this.el=Ext.get(this.player_id)||this.controller.video.createChild({tag:"video",id:this.player_id,style:{width:"100%",height:"100%"}});this.player=this.el.dom;this.registerEventHandler();this.pluginInit=true;this.el.enableDisplayMode();this.el.show();this.player.pause();return true},registerEventHandler:function(){var a=SYNO.SDS.VideoPlayerCommonVC.Util.addDomListener(false);a(this.player,"play",this.stateHandler,this);a(this.player,"playing",this.stateHandler,this);a(this.player,"waiting",this.stateHandler,this);a(this.player,"pause",this.stateHandler,this);a(this.player,"ended",this.stateHandler,this);a(this.player,"error",this.stateHandler,this);a(this.player,"durationchange",this.durationHandler,this);a(this.player,"timeupdate",this.positionHandler,this);a(this.player,"volumechange",this.volumeHandler,this)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.VLCPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"VLC",player_id:"_vlc_video_player",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(a){return("ogg"!==a)&&("ogv"!==a)},isAvailable:function(){return SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported()},fullscreen:function(){if(this.pluginInit){SYNO.SDS.VideoPlayerCommonVC.Util.setDomFullscreen(this.controller.container.dom)}},play:function(a){this.url=a;if(!this.createPlayer()){this.onVLCReady()}},pause:function(){if(this.pluginInit){this.player.playlist.pause()}},resume:function(){if(this.pluginInit){this.player.playlist.play()}},stop:function(){var a=this.getState();if(this.pluginInit){if(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING||a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED){this.player.playlist.stop()}else{arguments.callee.defer(100,this,arguments)}}},seek:function(a){var b=a*1000;if(this.pluginInit&&b>=0&&b<=this.player.input.length){this.player.input.time=b}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.input.time/1000},getDuration:function(){if(!this.pluginInit){return -1}return this.player.input.length/1000},getVolume:function(){if(!this.pluginInit){return -1}return this.player.audio.volume},setVolume:function(a){if(this.pluginInit){this.player.audio.volume=a;this.volumeHandler()}},getMute:function(){var a=false;if(this.pluginInit){a=this.player.audio.mute}return a},setMute:function(a){if(this.pluginInit){this.player.audio.mute=a;this.volumeHandler()}},StateMap:{0:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA,1:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,2:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,3:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING,4:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED,5:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,6:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,7:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR},getPlayerState:function(){var a=1;try{a=this.player.input.state}catch(b){}if(a===7){this.error=true}return a},getState:function(){if(!this.pluginInit){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA}if(this.error){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR}var a=this.StateMap[this.getPlayerState()]||SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;return a},disablePlayerSubtitle:function(){if(this.pluginInit){this.player.subtitle.track=-1}},createPlayer:function(){if(this.player){return false}this.el=SYNO.SDS.VideoPlayerCommonVC.Util.createVLCElement(this.controller.video,this.player_id);this.player=this.el.dom;this.registerEventHandler();this.el.enableDisplayMode();this.el.show();this.pluginInit=true;this.onVLCReady();return true},onVLCReady:function(){if(!this.player){return}if(!this.player.VersionInfo){arguments.callee.defer(100,this);return}this.fitPlayer.defer(100,this);this.fitPlayer.defer(500,this);if(Ext.isString(this.url)){if(this.player.playlist.items&&this.player.playlist.items.count>0){this.player.playlist.items.clear()}this.playlistItemId=this.player.playlist.add(this.url);this.player.playlist.playItem(this.playlistItemId);this.setVolume(this.controller.volume)}if(Ext.isIE){this.adjustPlayerWidthHack()}return},fitPlayer:function(){if(this.el){this.el.setSize("100%","100%")}},adjustPlayerWidthHack:function(){if(this.el){this.el.setWidth(this.el.getWidth()+1);this.el.setWidth(this.el.getWidth()-1)}},durationHandler:function(b){var a=Ext.isNumber(b)?(b/1000):null;this.callParent([a])},positionHandler:function(a){this.callParent([a/1000])},stateHandler:function(){this.volumeHandler.defer(1000,this);this.durationHandler();this.callParent(arguments)},registerEventHandler:function(){var a=SYNO.SDS.VideoPlayerCommonVC.Util.addDomListener(true);a(this.player,"MediaPlayerOpening",this.stateHandler,this);a(this.player,"MediaPlayerPlaying",this.stateHandler,this);a(this.player,"MediaPlayerPaused",this.stateHandler,this);a(this.player,"MediaPlayerStopped",this.stateHandler,this);a(this.player,"MediaPlayerEndReached",this.stateHandler,this);a(this.player,"MediaPlayerEncounteredError",this.stateHandler,this);a(this.player,"MediaPlayerTimeChanged",this.positionHandler,this);a(this.player,"MediaPlayerLengthChanged",this.durationHandler,this)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.FlashPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"Flash",player_id:"_flash_video_player",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(a){var b=["mp4","mov","m4v","flv","f4v"];return(-1!==b.indexOf(a))},isAvailable:function(){return SYNO.SDS.VideoPlayerCommonVC.Util.detectPlugin("ShockwaveFlash.ShockwaveFlash","Shockwave","Flash")},fullscreen:function(){if(this.pluginInit){SYNO.SDS.VideoPlayerCommonVC.Util.setDomFullscreen(this.controller.container.dom)}},play:function(a){this.error=false;this.url=a;if(!this.createPlayer()){this.player.load([{file:this.url}])}},pause:function(){if(this.pluginInit){this.player.pause(true)}},resume:function(){if(this.pluginInit){this.player.play(true)}},stop:function(){if(this.pluginInit){this.player.stop()}},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.getDuration()){this.player.seek(a)}},getPosition:function(){if(!this.pluginInit){return -1}return this.player.getPosition()},getDuration:function(){if(!this.pluginInit){return -1}return this.player.getDuration()},getVolume:function(){if(!this.pluginInit){return -1}return this.player.getVolume()},setVolume:function(a){if(this.pluginInit){this.player.setVolume(a)}},getMute:function(){if(!this.pluginInit){return false}return this.player.getMute()},setMute:function(a){if(this.pluginInit){this.player.setMute(a)}},StateMap:{IDLE:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,BUFFERING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,PLAYING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING,PAUSED:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED},getPlayerState:function(){if(!this.pluginInit){return"IDLE"}return this.player.getState()},getState:function(){if(!this.pluginInit){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA}if(this.error){return SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR}var a=this.StateMap[this.getPlayerState()]||SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;return a},clear:function(){this.delayDestroy.defer(1,this,arguments)},delayDestroy:function(){if(this.player){this.player.remove();this.el.remove();this.el=null;this.el=Ext.get(this.player_id);this.el.remove();this.el=null;this.player=null;this.pluginInit=false;this.notifyClear()}},onReady:function(){this.pluginInit=true;this.setVolume(this.controller.volume)},onError:function(){this.error=true;this.stateHandler()},onPlaylist:function(){this.player.playlistItem(0)},onTime:function(a){if(!Ext.isObject(a)){return}if(Ext.isNumber(a.duration)){this.durationHandler(a.duration)}if(Ext.isNumber(a.position)){this.positionHandler(a.position)}},createPlayer:function(){if(this.player){return false}if(!Ext.isDefined(window.jwplayer)){this.loadJWScript();return true}this.el=Ext.get(this.player_id)||this.controller.video.createChild({tag:"div",id:this.player_id,style:{width:"100%",height:"100%"}});var a=String.format("{0}/skin/empty-controlbar.xml",this.controller.jsBaseURL);this.player=jwplayer(this.player_id).setup({file:this.url,controls:false,autostart:false,skin:a,height:"100%",width:"100%",stretching:"uniform",modes:[{type:"flash"}],analytics:{enabled:false},events:{onReady:this.onReady.createDelegate(this),onSetupError:this.onError.createDelegate(this),onPlaylist:this.onPlaylist.createDelegate(this),onPlaylistComplete:this.stateHandler.createDelegate(this),onPlay:this.stateHandler.createDelegate(this),onPause:this.stateHandler.createDelegate(this),onBuffer:this.stateHandler.createDelegate(this),onIdle:this.stateHandler.createDelegate(this),onComplete:this.stateHandler.createDelegate(this),onError:this.onError.createDelegate(this),onTime:this.onTime.createDelegate(this),onMute:this.volumeHandler.createDelegate(this),onVolume:this.volumeHandler.createDelegate(this)}});return true},loadJWScript:function(){var a=document.getElementsByTagName("head")[0];var b=document.createElement("script");var e=String.format("{0}/jwplayer.js",this.controller.jsBaseURL);var d=this.setJWPlayerKey.createSequence(this.createPlayer,this);b.type="text/javascript";if(Ext.isIE){b.onready=d;b.onreadystatechange=function c(){if("complete"!==this.readyState&&"loaded"!==this.readyState){return}this.onready()}}else{b.onload=d}b.src=e;a.appendChild(b)},setJWPlayerKey:function(){if(jwplayer.key){return}jwplayer.key="ADrNpyYVQ13xVOfDuZpCXl4Bioq40D0Omx8S/CIM46w="}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.NullPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",constructor:function(b){var a={name:"Null",error:false};this.callParent([Ext.apply(a,b)])},canPlayType:function(){return false},isAvailable:function(){return true},play:function(){this.error=true;var a=!Ext.isMac&&!SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported();this.stateHandler(a?_T("video_player","error_play_vlc"):_T("video_player","error_play"))},getState:function(){return this.error?SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.SubtitleParser",{extend:"Ext.util.Observable",subtitles:null,destroy:function(){delete this.subtitles},parseSeconds:function(f){if(!f){return}var d,a,b=0;var e=f.split(":");if(e.length>3){return}for(var c=0;c<e.length;++c){b=b*60+parseFloat(e[c].replace(",","."))}return b},parseSrt:function(f){var d=f.replace(/\r\n|\r/g,"\n").trim();var e=d.split("\n\n");this.clear();for(var b=0;b<e.length;++b){var c=e[b].split("\n");if(c.length<3){continue}c.shift();var a=c.shift().split(" --> ");this.subtitles.push({from:this.parseSeconds(a[0]),to:this.parseSeconds(a[1]),text:c.join("<br/>")})}},clear:function(){this.subtitles=[]},getText:function(c){var e=this.subtitles;var d=[];if(!e){return""}for(var a=0;a<e.length;++a){var b=e[a];if(c<b.from){break}if(b.from<=c&&c<=b.to){d.push(b.text)}}return d.join("<br/>")}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.Controller",{extend:"Ext.util.Observable",constructor:function(b){this.addEvents({statechange:true,mutechange:true,volumechange:true,timechange:true,subtitlechange:true});var a=Ext.apply({subtitle_visible:false,mute:false,state:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,volume:50,position:0,duration:0,initPlaying:false},b);Ext.apply(this,a);this.callParent([a]);this.initPlayers()},onStateChange:function(a,b){this.fireEvent("statechange",a,b)},onMuteChange:function(a){this.fireEvent("mutechange",a)},onVolumeChange:function(a){this.fireEvent("volumechange",a)},onTimeChange:function(a,b){this.fireEvent("timechange",a,b)},onSubtitleChange:function(b,a){this.fireEvent("subtitlechange",b,a)},initPlayers:function(){var a;if("https:"===window.location.protocol){a=[new SYNO.SDS.VideoPlayerCommonVC.NullPlayer({controller:this}),new SYNO.SDS.VideoPlayerCommonVC.HTML5Player({controller:this}),this.flashPlayer(),new SYNO.SDS.VideoPlayerCommonVC.VLCPlayer({controller:this})]}else{a=[new SYNO.SDS.VideoPlayerCommonVC.NullPlayer({controller:this}),new SYNO.SDS.VideoPlayerCommonVC.VLCPlayer({controller:this}),new SYNO.SDS.VideoPlayerCommonVC.HTML5Player({controller:this}),this.flashPlayer()]}this.players=[];Ext.each(a,function(b){if(b.isAvailable()){this.players.push(b)}},this)},flashPlayer:function(){return new SYNO.SDS.VideoPlayerCommonVC.FlashPlayer({controller:this})},updatePlayer:function(d){var a=d.filename;var b;if(Ext.isString(a)){var c=SYNO.SDS.VideoPlayerCommonVC.Util.getFileExt(a);Ext.each(this.players,function(e){if(e.canPlayType(c)){b=e;return false}},this)}this.player=b||this.players[0]},selectPlayer:function(a){var b=null;Ext.each(this.players,function(c){if(a===c.getName()){b=c;return false}});if(b===null){b=this.players[0]}return(this.player=b)},getPlayer:function(){if(Ext.isObject(this.player)){return this.player}return this.players[0]},play:function(b){switch(this.state){case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:var a=this.play.createDelegate(this,arguments);this.initPlaying=false;this.updateState(SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA);this.stop(a);break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.NO_MEDIA:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED:this.initPlaying=true;this.url=b||this.url;this.playCurrentVideo();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING:this.getPlayer().pause();break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED:this.getPlayer().resume();break;default:break}},playCurrentVideo:function(){this.getPlayer().play(this.url)},stop:function(a){if(!this.getPlayer().pluginInit){if(Ext.isFunction(a)){a()}return}this.clearCallback=a;this.getPlayer().stop()},updateState:function(a,b){this.state=a;if(!this.initPlaying&&a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED){this.getPlayer().clear();this.updateDuration(0);this.updatePosition(0)}if(this.initPlaying&&(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING||a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING)){this.initPlaying=false}if(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR){b=Ext.isString(b)?b:_T("video_player","error_play")}this.onStateChange(this.state,b);if(a===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR&&Ext.isFunction(this.clearCallback)){var c=this.clearCallback;this.clearCallback=null;c()}},toggleMute:function(){this.getPlayer().setMute(!this.mute)},updateMute:function(a){this.mute=a;this.onMuteChange(this.mute)},setVolume:function(a){this.getPlayer().setVolume(a)},updateVolume:function(a){this.volume=a;this.onVolumeChange(this.volume)},updateDuration:function(a){this.duration=a;this.onTimeChange(this.position,this.duration)},seek:function(a){this.getPlayer().seek(a)},updatePosition:function(a){this.position=a;this.onTimeChange(this.position,this.duration)},fullscreen:function(){this.getPlayer().fullscreen()},isSubtitleVisible:function(){return this.subtitle_visible},setSubtitleEnabled:function(b,a){this.subtitle_visible=b;this.onSubtitleChange(b,a)},getSubtitleParser:function(){if(!Ext.isDefined(this.subtitle_parser)){this.subtitle_parser=new SYNO.SDS.VideoPlayerCommonVC.SubtitleParser()}return this.subtitle_parser}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.ControlPanel",{extend:"Ext.Container",constructor:function(b){this.module=b.module;var a={overCls:"control-panel-over",items:[this.getProgressBar(),this.getControlBar()]};this.callParent([Ext.apply(a,b)])},getControlBar:function(){if(!Ext.isDefined(this.controlBar)){this.controlBar=new SYNO.SDS.VideoPlayerCommonVC.ControlBar({module:this.module})}return this.controlBar},getProgressBar:function(){if(!Ext.isDefined(this.progressBar)){this.progressBar=new SYNO.SDS.VideoPlayerCommonVC.ProgressBar({module:this.module})}return this.progressBar},setMute:function(a){this.getControlBar().getVolumeButton().setMute(a)},setVolume:function(a){this.getControlBar().getVolumeButton().setVolume(a)},setState:function(b,c){var a=this.getControlBar().getPlayButton();switch(b){case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.CLEAR:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR:a.removeClass("pause");a.addClass("play");break;case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING:case SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING:a.removeClass("play");a.addClass("pause");break;default:break}a.setDisabled(b===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR)},setTime:function(a,c){var b=this.getProgressBar();b.updateView(a,c);this.setPlaybackDuration(c)},setPlaybackPosition:function(a){this.getControlBar().getPositionText().updateView(a)},setPlaybackDuration:function(a){this.getControlBar().getDurationText().updateView(a)}});Ext.define("SYNO.SDS.VideoPlayerCommonVC.AppWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(b){var a={dsmStyle:"v5",showHelp:false,cls:"syno-vp-appwin",minHeight:480,minWidth:720,items:[this.getDisplay()],bbar:this.getControlPanel()};this.callParent([Ext.apply(a,b)])},getDisplay:function(){if(!Ext.isDefined(this.display)){this.display=new SYNO.SDS.VideoPlayerCommonVC.Display()}return this.display},getControlPanel:function(){if(!Ext.isDefined(this.control_panel)){this.control_panel=new SYNO.SDS.VideoPlayerCommonVC.ControlPanel({module:this})}return this.control_panel},setState:function(a,b){this.getDisplay().setState(a,b);this.getControlPanel().setState(a,b)},setTime:function(a,b){if(this.getController().isSubtitleVisible()){var c=this.getController().getSubtitleParser().getText(a);this.getDisplay().setSubtitle(c)}this.getControlPanel().setTime(a,b)},setSubtitle:function(a){this.getDisplay().showSubtitle(a)}});Ext.define("SYNO.VideoController2.ChannelStore",{extend:"SYNO.API.Store",ChannelRecord:Ext.data.Record.create([{name:"channel",type:"int"},{name:"id",type:"string"},{name:"title",type:"string"}]),constructor:function(b){var a={api:"SYNO.DTV.Channel",method:"list",version:1,baseParams:{offset:0,limit:-1},reader:new Ext.data.JsonReader({root:"channels"},this.ChannelRecord)};this.callParent([Ext.apply(a,b)])}});_VCT=function(b,a){try{return _TT("SYNO.SDS.VideoStation.AppInstance",b,a)}catch(c){return _T(b,a)}};Ext.define("SYNO.VideoController2.Util",{statics:{REPEAT_NONE:0,REPEAT_ALL:1,REPEAT_ONE:2,APIErrorStringMap:{"SYNO.VideoStation.Streaming":{413:_VCT("controller","unsupported_format"),420:_VCT("controller","in_transcoding"),421:_VCT("controller","unsupported_format"),439:_VCT("controller","unsupported_audio_codec"),440:_VCT("controller","unsupported_format")},"SYNO.DTV.Streaming":{425:_VCT("controller","unsupported_format")},"SYNO.VideoController.Playback":{400:_T("error","error_error_system"),450:_VCT("controller","unsupported_format"),451:_VCT("controller","in_transcoding"),452:_VCT("controller","unsupported_audio_codec"),453:_VCT("controller","unsupported_format")},"SYNO.VideoController.Volume":{400:_T("error","error_error_system")},"SYNO.VideoController.Password":{400:_T("error","error_error_system")}},STREAMING_ID:"streaming",PLAYERTYPE_STREAMING:"streaming",PLAYERTYPE_AIRPLAY:"airplay",PLAYERTYPE_UPNP:"upnp",getErrorString:function(a,b){if(!Ext.isObject(a)){return""}var g;var c=a.code;if(Ext.isArray(a.errors)&&a.errors.length>0){var f=a.errors[0];if(Ext.isNumber(f.code)){c=f.code}}c=Ext.isNumber(c)?c:100;try{if(c<400){g=SYNO.API.Erros.common[c]||_T("common","error_error_system")}else{g=SYNO.VideoController2.Util.APIErrorStringMap[b][c]||_T("common","error_error_system")}}catch(d){g=_T("common","error_error_system")}return g},getHost:function(){return String.format("{0}//{1}",window.location.protocol,window.location.host)},getDisplayResolution:function(b){if(!Ext.isDefined(b)||!Ext.isNumber(b.resolutionx)||!Ext.isNumber(b.resolutiony)||!Ext.isNumber(b.sample_aspect_ratio_den)||!Ext.isNumber(b.sample_aspect_ratio_num)){return null}var a=(b.sample_aspect_ratio_den>0)?b.sample_aspect_ratio_num/b.sample_aspect_ratio_den:1;return{width:b.resolutionx,height:b.resolutiony/a}},getStreamURL:function(c,a){var d={api:"SYNO.VideoStation.Streaming",method:"stream",version:1,_sid:Ext.util.Cookies.get("id"),id:c,format:a};var b=String.format("{0}{1}/{2}/1.m3u8",SYNO.VideoController2.Util.getHost(),"/webapi/VideoStation","vtestreaming.cgi");return Ext.urlAppend(b,Ext.urlEncode(d))},getExtM3U:function(c,a,b,d){var f={width:c,height:a,url:b};var e=String.format("{0}/cgi/{1}/1.m3u8",d,"extm3u.cgi");return Ext.urlAppend(e,Ext.urlEncode(f))},getLiveStreamURL:function(b,a){var c={api:"SYNO.DTV.Streaming",method:"stream",version:1,tuner:b,stream_id:a,format:"hls"};return Ext.urlAppend("/webapi/VideoStation/dtvstreaming.cgi/1.m3u8",Ext.urlEncode(c))},getImageURL:function(b,a){var c={api:"SYNO.VideoStation.Poster",method:"getimage",version:1,id:b,type:a};if(SYNO.SDS.UIFeatures.test("isRetina")){Ext.apply(c,{hr:2})}return Ext.urlAppend("/webapi/VideoStation/poster.cgi",Ext.urlEncode(c))},toHex:function(c){var b="";for(var a=0;a<c.length;++a){b+=c.charCodeAt(a).toString(16)}return b},tryCallback:function(a){if(Ext.isFunction(a)){a()}}}});Ext.define("SYNO.VideoController2.FlashPlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.FlashPlayer",AbleToRemux:function(d){if(true!==this.controller.support_remux){return false}var a=d.container_type;var c=d.video_codec;var b=("h264"===c)&&("mp4"===a||"matroska,webm"===a);return b},AbleToTranscode:function(){var a=(true===this.controller.support_transcode);return a},stop:function(){this.callParent(arguments);if(Ext.isEmpty(this.controller.stream_id)||Ext.isEmpty(this.controller.stream_format)){return}SYNO.API.Request({async:false,api:"SYNO.VideoStation.Streaming",method:"close",version:1,params:{id:this.controller.stream_id,format:this.controller.stream_format},scope:this,callback:function(d,c,b,a){if(d){this.controller.stream_id=null;this.controller.stream_format=null}}})}});Ext.define("SYNO.VideoController2.RemotePlayer",{extend:"SYNO.SDS.VideoPlayerCommonVC.Player",PlaybackAPI:{api:"SYNO.VideoController.Playback",version:1},VolumeAPI:{api:"SYNO.VideoController.Volume",version:1},constructor:function(b){var a={name:"Remote",pluginInit:true,initPlaying:false,state:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,volume:50,volume_adjustable:true,seekable:true};this.callParent([Ext.apply(a,b)])},getState:function(){return this.state},getDuration:function(){return this.duration},getPosition:function(){return this.position},getMute:function(){return false},getVolume:function(){return this.volume},getClientID:function(){return this.client_id},generateClientID:function(){this.client_id=SYNO.Encryption.Base64.hex2b64(SYNO.VideoController2.Util.toHex(this.title))+new Date().format("U");return this.client_id},sendControllerAPI:function(b,f,d,e,c){var a=Ext.isBoolean(c)?!c:true;SYNO.API.Request({async:a,api:b,method:f,version:1,params:d,scope:this,callback:function(j,i,h,g){if(j){SYNO.VideoController2.Util.tryCallback(e)}else{this.controller.onAPIError.apply(this.controller,arguments)}}})},sendPlaybackAPI:function(d,b,c,a){this.sendControllerAPI("SYNO.VideoController.Playback",d,b,c,a)},sendVolumeAPI:function(d,b,c,a){this.sendControllerAPI("SYNO.VideoController.Volume",d,b,c,a)},play:function(){var a={id:this.id,uri:String.format("videostation://{0}",this.file_id),title:this.title,client_id:this.generateClientID()};if(Ext.isNumber(this.start_position)){a.position=this.start_position;this.start_position=null}if(!Ext.isEmpty(this.subtitle_id)){a.subtitle_id=this.subtitle_id}if(!Ext.isEmpty(this.audio_id)){a.audio_id=this.audio_id}if(!Ext.isEmpty(this.profile)){a.profile=this.profile}this.state=SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING;this.stateHandler();var b=function(){this.startPolling()};this.sendPlaybackAPI("play",a,this.startPolling.createDelegate(this))},pause:function(){this.sendPlaybackAPI("pause",{id:this.id},Ext.emptyFn)},resume:function(){this.pause()},stop:function(){if(this.task_runner){this.sendPlaybackAPI("stop",{id:this.id},Ext.emptyFn,true)}else{this.notifyClear()}},seek:function(a){if(!this.seekable){return}var b={id:this.id,position:a.toFixed(0)};this.sendPlaybackAPI("seek",b,Ext.emptyFn)},setVolume:function(a){if(!this.volume_adjustable){return}var b={id:this.id,volume:a};this.sendVolumeAPI("setvolume",b,Ext.emptyFn)},clear:function(){this.stopPolling();this.notifyClear()},StateMap:{STOPPED:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED,PLAYING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PLAYING,PAUSED:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.PAUSED,TRANSITIONING:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.BUFFERING,ERROR:SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR},updateStatus:function(d,c,b,a){this.duration=c.duration;this.position=c.position;this.state=this.StateMap[c.state]||SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR;if(this.client_id!==c.client_id){this.state=SYNO.SDS.VideoPlayerCommonVC.Util.STATE.STOPPED}this.durationHandler(this.duration);this.positionHandler(this.position);if(this.state===SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR){this.stateHandler(_T("error","error_error_system"))}else{this.stateHandler()}},updateVolume:function(d,c,b,a){this.volume=c.volume;this.volumeHandler()},startPolling:function(){this.stopPolling();this.task_runner=new SYNO.SDS.TaskRunner();this.polling_status=this.task_runner.createWebAPITask({id:"SYNOVideoControllerPollingStatus",interval:1000,api:"SYNO.VideoController.Playback",method:"status",version:1,params:{id:this.id},scope:this,callback:this.updateStatus});this.polling_status.start(true);if(this.volume_adjustable){this.polling_volume=this.task_runner.createWebAPITask({id:"SYNOVideoControllerPollingVolume",interval:1000,api:"SYNO.VideoController.Volume",method:"getvolume",version:1,params:{id:this.id},scope:this,callback:this.updateVolume});this.polling_volume.start(true)}},stopPolling:function(){if(this.task_runner){this.task_runner.destroy();this.task_runner=null;this.polling_status=null;this.polling_volume=null}}});Ext.define("SYNO.VideoController2.PlayerStore",{extend:"SYNO.API.Store",PlayerRecord:Ext.data.Record.create([{name:"id",type:"string"},{name:"type",type:"string"},{name:"title",type:"string"},{name:"volume_adjustable",type:"boolean"},{name:"password_protected",type:"boolean"},{name:"seekable",type:"boolean"}]),constructor:function(b){var a={api:"SYNO.VideoController.Device",method:"list",version:1,reader:new Ext.data.JsonReader({root:"devices"},this.PlayerRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.PasswordDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){this.player_title=b.player_title;var a={dsmStyle:"v5",cls:"password-dialog",title:_VCT("controller","renderer_password_title"),width:520,height:180,items:[this.getFormPanel()],buttons:[{text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.applyHandler},{text:_T("common","cancel"),btnStyle:"grey",scope:this,handler:this.cancelHandler}],listeners:{scope:this,afterrender:this.focusInputField}};this.callParent([Ext.apply(a,b)])},getFormPanel:function(){if(this.form){return this.form}var a={cls:"password-form",items:[{xtype:"syno_displayfield",value:String.format(_VCT("controller","renderer_password_desc"),this.player_title)},{xtype:"syno_textfield",textType:"password",fieldLabel:_VCT("common","password"),name:"password",maxlength:50}]};this.form=new SYNO.ux.FormPanel(a);return this.form},getPasswordField:function(){return this.getFormPanel().getForm().findField("password")},focusInputField:function(){this.getPasswordField().focus(false,300)},applyHandler:function(){var a=this.getPasswordField().getValue();if(Ext.isString(a)&&!Ext.isEmpty(a)){this.testPassword(a)}else{this.focusInputField()}},cancelHandler:function(){this.close()},testPassword:function(a){SYNO.API.Request({api:"SYNO.VideoController.Password",method:"testpassword",version:1,params:{id:this.player_id,password:a},scope:this,callback:function(e,d,c,b){if(e){if(d.correct){this.setPassword(a)}else{this.showPasswordIncorrect()}}else{this.getMsgBox().alert(this.title,SYNO.VideoController2.Util.getErrorString(d,"SYNO.VideoController.Password"))}}})},setPassword:function(a){SYNO.API.Request({api:"SYNO.VideoController.Password",method:"setpassword",version:1,params:{id:this.player_id,password:a},scope:this,callback:function(e,d,c,b){if(e){this.correctCallback.defer(1);this.close()}else{this.getMsgBox().alert(this.title,SYNO.VideoController2.Util.getErrorString(d,"SYNO.VideoController.Password"))}}})},showPasswordIncorrect:function(){var a={title:_T("video_player","title"),msg:_VCT("controller","error_renderer_password_incorrect"),buttons:Ext.MessageBox.OK};this.getMsgBox().show(a)}});Ext.define("SYNO.VideoController2.SubtitleManager",{extend:"Ext.Component",constructor:function(b){this.addEvents({subtitleready:true});var a=Ext.apply({subtitle:{}},b);Ext.apply(this,a);this.callParent([a])},isSubtitleReady:function(a,b){return Ext.isDefined(this.subtitle[a])&&Ext.isString(this.subtitle[a][b])},getSubtitle:function(a,b){if(this.isSubtitleReady(a,b)){return this.subtitle[a][b]}return""},putSubtitle:function(a,b,c){if(!Ext.isDefined(this.subtitle[a])){this.subtitle[a]={}}this.subtitle[a][b]=c},requestSubtitle:function(b,c,a){if(this.isSubtitleReady(b,c)){this.fireEvent("subtitleready",b,c);return}if(a){this.sendRequest(b,c,true)}this.sendRequest(b,c,false)},sendRequest:function(b,c,a){this.addAjaxTask({requestTimeout:360,url:"/webapi/VideoStation/subtitle.cgi",method:"POST",single:true,params:{api:"SYNO.VideoStation.Subtitle",method:"get",version:2,id:b,subtitle_id:c,preview:a},scope:this,success:function(d,g){try{Ext.decode(d.responseText)}catch(h){var f=d.responseText;this.putSubtitle(b,c,f);this.fireEvent("subtitleready",b,c)}}}).start(true)}});Ext.define("SYNO.VideoController2.VideoFile",{extend:"Ext.Component",constructor:function(b){var a={video_info_fetched:false,video_id:null,type:null,seasion:null,episode:null,file_id:null,title:null,duration:null,resolution:null,codec_info:null,watch_status_fetched:false,position:0,audio_track_fetched:false,audio_store:null,audio_track:[],subtitle_fetched:false,subtitle_store:null,subtitle_list:[]};this.callParent([Ext.apply(a,b)])},onLoad:Ext.emptyFn,GetInfoAPIMap:{movie:"SYNO.VideoStation.Movie",tvshow_episode:"SYNO.VideoStation.TVShowEpisode",home_video:"SYNO.VideoStation.HomeVideo",tv_record:"SYNO.VideoStation.TVRecording"},GetInfoRootMap:{movie:"movies",tvshow_episode:"episodes",home_video:"videos",tv_record:"recordings"},getInfo:function(a){if(!this.audio_track_fetched||!this.video_info_fetched||!this.subtitle_fetched||!this.watch_status_fetched){this.getInfoSequence(a)}else{SYNO.VideoController2.Util.tryCallback(a)}},getInfoSequence:function(a){if(!this.video_info_fetched){this.getVideoInfo(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.watch_status_fetched){this.getWatchStatus(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.audio_track_fetched){this.getAudioTrack(this.getInfoSequence.createDelegate(this,[a]));return}if(!this.subtitle_fetched){this.getSubtitleList(this.getInfoSequence.createDelegate(this,[a]));return}SYNO.VideoController2.Util.tryCallback(a)},getVideoInfo:function(b){var a=this.GetInfoAPIMap[this.type];if(!Ext.isDefined(a)){SYNO.VideoController2.Util.tryCallback(b);return}SYNO.API.Request({api:a,method:"getinfo",version:1,params:{id:this.video_id,additional:"files"},scope:this,callback:function(g,f,e,d){this.video_info_fetched=true;if(g){this.fillVideoInfo(f);SYNO.VideoController2.Util.tryCallback(b)}else{var c=this.list.appWin.getController();c.onAPIError.apply(c,arguments)}}})},fillVideoInfo:function(g){var f=g[this.GetInfoRootMap[this.type]][0].additional.files;if(Ext.isNumber(this.file_id)){var b=this.file_id;f=f.filter(function(h){return(b==h.id)})}else{var a=this.parseDuration;f.sort(function(i,h){return(a(h.duration)-a(i.duration))})}var e=f[0];var d=e.path;var c={};Ext.copyTo(c,e,["container_type","audio_codec","video_codec"]);Ext.apply(this,{title:d.substring(d.lastIndexOf("/")+1),file_id:parseInt(e.id,10),resolution:{width:e.resolutionx,height:e.resolutiony},duration:this.parseDuration(e.duration),codec_info:c})},getResumePosition:function(){return(this.position>10&&(this.duration-this.position)>10)?this.position-2:null},getWatchStatus:function(a){if(this.watch_status_fetched){SYNO.VideoController2.Util.tryCallback(a);return}SYNO.API.Request({api:"SYNO.VideoStation.WatchStatus",method:"getinfo",version:1,params:{id:this.file_id},scope:this,callback:function(e,d,c,b){this.watch_status_fetched=true;if(e){if(Ext.isObject(d)&&Ext.isObject(d.watch_status)){this.position=parseFloat(d.watch_status.position)}}SYNO.VideoController2.Util.tryCallback(a)}})},setWatchStatus:function(a,e,d){if(!Ext.isNumber(a)||a<=0){SYNO.VideoController2.Util.tryCallback(e);return}var c=Ext.isBoolean(d)?!d:true;var b=c?e:Ext.emptyFn;this.position=a;SYNO.API.Request({async:true,api:"SYNO.VideoStation.WatchStatus",method:"setinfo",version:1,params:{id:this.file_id,position:a},scope:this,callback:b});if(!c){SYNO.VideoController2.Util.tryCallback(e)}},getAudioTrack:function(a){if(this.audio_track_fetched){SYNO.VideoController2.Util.tryCallback(a);return}this.audio_store=new SYNO.VideoController2.AudioTrackStore({appWindow:this.list.appWin});this.addManagedComponent(this.audio_store);this.audio_store.load({scope:this,callback:function(){this.audio_track_fetched=true;this.audio_store.data.each(function(b){this.audio_track.push(b.data)},this);SYNO.VideoController2.Util.tryCallback(a)},params:{id:this.file_id}})},getSubtitleList:function(a){if(this.subtitle_fetched){SYNO.VideoController2.Util.tryCallback(a);return}this.subtitle_store=new SYNO.VideoController2.SubtitleStore({appWindow:this.list.appWin});this.addManagedComponent(this.subtitle_store);this.subtitle_store.load({scope:this,callback:function(){this.subtitle_fetched=true;this.subtitle_store.data.each(function(b){this.subtitle_list.push(b.data)},this);SYNO.VideoController2.Util.tryCallback(a)},params:{id:this.file_id}})},parseDuration:function(d){if(!d){return 0}var c=0;var b=d.split(":");for(var a=0;a<b.length;++a){c=c*60+parseFloat(b[a])}return c}});Ext.define("SYNO.VideoController2.AudioTrackStore",{extend:"SYNO.API.Store",AudioTrackRecord:Ext.data.Record.create([{name:"id",type:"int"},{name:"track",type:"int"},{name:"codec",type:"string"},{name:"language",type:"string"}]),constructor:function(b){var a={api:"SYNO.VideoStation.AudioTrack",method:"list",version:1,reader:new Ext.data.JsonReader({root:"trackinfo"},this.AudioTrackRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.SubtitleStore",{extend:"SYNO.API.Store",SubtitleRecord:Ext.data.Record.create([{name:"subtitle_id",type:"string",mapping:"id"},{name:"lang",type:"string"},{name:"title",type:"string"},{name:"format",type:"string"},{name:"embedded",type:"boolean"},{name:"need_preview",type:"boolean"}]),constructor:function(b){var a={api:"SYNO.VideoStation.Subtitle",method:"list",version:2,reader:new Ext.data.JsonReader({},this.SubtitleRecord)};this.callParent([Ext.apply(a,b)])}});Ext.define("SYNO.VideoController2.VideoList",{extend:"Ext.Component",constructor:function(b){var a={loaded:false,browse_type:null,type_id:null,store:null,video_list:[],current_index:-1};this.callParent([Ext.apply(a,b)])},NullVideoFile:new SYNO.VideoController2.VideoFile(),isCollection:function(){return("collection"===this.browse_type)},isTVShow:function(){return("tvshow_episode"===this.browse_type||"tvshow"===this.browse_type)},isSingleVideo:function(){return(!Ext.isNumber(this.type_id)||(!this.isCollection()&&!this.isTVShow()))},getStore:function(){if(this.store){return this.store}var b,a;if(this.isCollection()){b={is_collection:true,reader_root:"videos",api:"SYNO.VideoStation.Collection",method:"video_list",version:1,baseParams:{id:this.type_id,sort_by:"title",sort_direction:"ASC",limit:1000}}}else{b={is_collection:false,reader_root:"episodes",api:"SYNO.VideoStation.TVShowEpisode",method:"list",version:1,baseParams:{tvshow:this.type_id}}}this.store=new SYNO.VideoController2.VideoStore(Ext.apply(b,{appWindow:this.appWin}));this.addManagedComponent(this.store);return this.store},initSingleVideo:function(a,b){this.video_list.push(new SYNO.VideoController2.VideoFile(Ext.apply({list:this},a)));this.current_index=0;this.loaded=true;SYNO.VideoController2.Util.tryCallback(b)},init:function(a,b){if(this.isSingleVideo()){this.initSingleVideo(a,b);return}this.getStore().load({callback:this.onVideoListLoad.createDelegate(this,[a,b]),scope:this})},onVideoListLoad:function(e,g){var b=e.video_id;var c=e.file_id;var f=e.title;this.store.data.each(function(h){this.video_list.push(new SYNO.VideoController2.VideoFile(Ext.apply({list:this},h.data)))},this);var a=this.video_list[this.getCurrentIndex(b,e.type)];a.file_id=c;a.title=f;if(this.isTVShow()){var d=a.season;this.video_list=this.video_list.filter(function(h){return(d===h.season)});this.video_list.sort(this.tvshowSortFunction)}this.getCurrentIndex(b,e.type);this.loaded=true;SYNO.VideoController2.Util.tryCallback(g)},tvshowSortFunction:function(d,c){var f=0,e=0;f+=(0===d.episode)?1024:0;e+=(0===c.episode)?1024:0;f+=(d.season>c.season)?2:0;e+=(c.season>d.season)?2:0;f+=(d.episode>c.episode)?1:0;e+=(c.episode>d.episode)?1:0;return f-e},getCurrentIndex:function(b,a){if(!Ext.isDefined(b)||!Ext.isDefined(a)){if(Ext.isNumber(this.current_index)&&0<=this.current_index){return this.current_index}else{return -1}}for(var c=0;c<this.video_list.length;++c){if(b===this.video_list[c].video_id&&a===this.video_list[c].type){this.current_index=c;break}}return this.current_index},getCurrentVideo:function(){var a=this.getCurrentIndex();return(0>a)?this.NullVideoFile:this.video_list[a]},getVideoID:function(){return this.getCurrentVideo().video_id},getVideoType:function(){return this.getCurrentVideo().type},getFileID:function(){return this.getCurrentVideo().file_id},getTitle:function(){return this.getCurrentVideo().title},getDuration:function(){return this.getCurrentVideo().duration},getResolution:function(){return this.getCurrentVideo().resolution},getCodecInfo:function(){return this.getCurrentVideo().codec_info},getAudioTrack:function(){return this.getCurrentVideo().audio_track},getDefaultAudioID:function(){var b=0;var a=this.getAudioTrack();if(a.length>0){b=a[0].id}return b},getSubtitleList:function(){return this.getCurrentVideo().subtitle_list},hasPrev:function(){return(this.current_index-1>=0)},hasNext:function(){return(this.video_list.length>this.current_index+1)},goPrev:function(a){if(!this.hasPrev()){if(true===a){this.current_index=this.video_list.length-1;return true}else{return false}}this.current_index--;return true},goNext:function(a){if(!this.hasNext()){if(true===a){this.current_index=0;return true}else{return false}}this.current_index++;return true}});Ext.define("SYNO.VideoController2.VideoStore",{extend:"SYNO.API.Store",CollectionRecord:Ext.data.Record.create([{name:"video_id",type:"int",mapping:"id"},{name:"type",type:"string"},{name:"unique_id",type:"string",convert:function(b,a){return String.format("{0}-{1}",a.type,a.id)}}]),TvshowRecord:Ext.data.Record.create([{name:"episode",type:"int"},{name:"season",type:"int"},{name:"video_id",type:"int",mapping:"id"},{name:"type",type:"string",defaultValue:"tvshow_episode"},{name:"unique_id",type:"string",convert:function(b,a){return String.format("{0}-{1}",a.type,a.id)}}]),constructor:function(c){var a=(c.is_collection)?this.CollectionRecord:this.TvshowRecord;var b={reader:new Ext.data.JsonReader({root:c.reader_root,idProperty:"unique_id"},a)};this.callParent([Ext.apply(b,c)])}});Ext.define("SYNO.VideoController2.Controller",{extend:"SYNO.SDS.VideoPlayerCommonVC.Controller",constructor:function(b){this.addEvents({capabilityready:true,playerlistchange:true,busy:true,clear:true,rawdisabled:true,repeatchange:true,targetchange:true,titlechange:true,videochange:true,videolistready:true});var a={audio_id:null,subtitle_id:null,profile:null,player_info:{id:null,type:SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,title:_VCT("controller","streaming_mode"),volume_adjustable:true,seekable:false,password_protected:false},repeat:SYNO.VideoController2.Util.REPEAT_NONE,player_store:null,player_list:null,video_list:null,channel_id:null,channel_list:null,force_resume:false,start_position:0,support_remux:null,support_transcode:null,rawdisabled:false};this.callParent([Ext.apply(a,b)]);this.subtitle_manager=new SYNO.VideoController2.SubtitleManager({listeners:{subtitleready:this.onSubtitleReady.createDelegate(this)}})},loadVideoList:function(e){var a=this.type_info;var b=this.video_info;this.video_list=new SYNO.VideoController2.VideoList({appWin:this.appWin,browse_type:a.type,type_id:parseInt(a.id,10)});var c={video_id:parseInt(b.id,10),type:b.type,file_id:parseInt(b.file_id,10),title:b.title};var d=this.fireEvent.createDelegate(this,["videolistready",this.video_list.isCollection()]);this.video_list.init(c,d.createSequence(e))},requestTranscodeCapability:function(a){if(_S("demo_mode")){this.support_remux=false;this.support_transcode=false;this.support_hardware_transcode=false;SYNO.VideoController2.Util.tryCallback(a);return}SYNO.API.Request({api:"SYNO.VideoStation.Info",method:"getinfo",version:1,scope:this,callback:function(e,d,c,b){if(e){Ext.apply(this,d);this.fireEvent("capabilityready",this.support_transcode);SYNO.VideoController2.Util.tryCallback(a)}else{this.onAPIError.apply(this,arguments)}}})},requestPlayerList:function(a){if(_S("demo_mode")){this.player_list=[];SYNO.VideoController2.Util.tryCallback(a);return}this.player_store=new SYNO.VideoController2.PlayerStore({appWindow:this.appWin});this.player_store.load({scope:this,callback:function(e,d,c,b){if(e){this.player_list=[];this.player_store.each(function(f){this.player_list.push(f.data)},this);this.fireEvent("playerlistchange",this.player_list);SYNO.VideoController2.Util.tryCallback(a)}}})},requestCurrentChannel:function(a){SYNO.API.Request({api:"SYNO.DTV.Controller",method:"getchannel",version:1,params:{tuner:this.tuner_id},scope:this,callback:function(e,d,c,b){if(e){this.channel_id=d.streaming_id}SYNO.VideoController2.Util.tryCallback(a)}})},requestChannelList:function(a){if(_S("demo_mode")){this.channel_list=[];SYNO.VideoController2.Util.tryCallback(a);return}this.channel_store=new SYNO.VideoController2.ChannelStore({appWindow:this.appWin});this.channel_store.load({scope:this,params:{tuner:this.tuner_id},callback:function(e,d,c,b){if(e){this.channel_list=[];this.channel_store.each(function(f){this.channel_list.push(f.data)},this);this.fireEvent("channellistready",this.channel_list);SYNO.VideoController2.Util.tryCallback(a)}}})},initSequenceDTV:function(){var a=this.initSequenceDTV.createDelegate(this);if(!Ext.isBoolean(this.support_remux)){this.requestTranscodeCapability(a);return}if(Ext.isEmpty(this.channel_id)){this.tuner_id=this.dtv_url.substr(this.dtv_url.lastIndexOf("/")+1);this.requestCurrentChannel(a);return}if(this.privilege.dtv&&!Ext.isArray(this.channel_list)){this.requestChannelList(a);return}this.fireEvent("clear");this.playDTV()},initSequenceVideo:function(){var a=this.initSequenceVideo.createDelegate(this);if(!Ext.isObject(this.video_list)||!this.video_list.loaded){this.loadVideoList(a);return}if(!Ext.isBoolean(this.support_remux)){this.requestTranscodeCapability(a);return}if(!Ext.isArray(this.player_list)){this.requestPlayerList(a);return}this.fireEvent("clear");this.onReadyToPlay()},flashPlayer:function(){return new SYNO.VideoController2.FlashPlayer({controller:this})},onReadyToPlay:function(){var a=function(){this.fireEvent("clear");this.audio_id=this.video_list.getDefaultAudioID();this.fireEvent("videochange",this.video_list.hasPrev(),this.video_list.hasNext(),this.video_list.getCurrentVideo(),this.video_list.getAudioTrack(),this.video_list.getSubtitleList());this.fireEvent("titlechange",this.video_list.getTitle());this.selectDefaultSubtitle();if(!Ext.isEmpty(this.init_player_id)){this.appWin.getControlBar().getPlayerButton().menu.setInitPlayer(this.init_player_id);this.init_player_id=null}else{this.play()}}.createDelegate(this);this.fireEvent("busy");this.video_list.getCurrentVideo().getInfo(a)},playCurrentVideo:function(){if(Ext.isEmpty(this.channel_id)){this.checkResumeVideo()}else{this.playDTV()}},checkResumeVideo:function(){var b=this.video_list.getCurrentVideo().getResumePosition();if(!Ext.isNumber(b)){this.start_position=0;this.playVideo();return}else{if(this.force_resume){this.start_position=b;this.playVideo();return}else{if(this.repeat!==SYNO.VideoController2.Util.REPEAT_NONE){this.start_position=0;this.playVideo();return}}}var a={title:_T("video_player","title"),msg:_VCT("controller","resume_watch_desc"),buttons:Ext.MessageBox.YESNO,scope:this,fn:function(c){if("no"===c){this.start_position=0}else{this.start_position=b}this.playVideo()}};this.appWin.getMsgBox().show(a)},playVideo:function(){this.updateAfterPlaybackAction();if(this.isRemoteMode()){if(this.player_info.password_protected){this.checkPassword(this.playRemote.createDelegate(this))}else{this.playRemote()}}else{this.playStreaming()}},switchChannel:function(c,a,b){if(_S("demo_mode")||!this.privilege.dtv){SYNO.VideoController2.Util.tryCallback(b);return}this.fireEvent("busy");SYNO.API.Request({api:"SYNO.DTV.Controller",method:"setchannel",version:1,params:{id:c,tuner:this.tuner_id},scope:this,callback:function(g,f,e,d){this.fireEvent("clear");if(g){this.channel_id=c;this.fireEvent("titlechange",a);SYNO.VideoController2.Util.tryCallback(b)}else{this.onAPIError.apply(this,arguments)}}})},playDTV:function(){this.setRawDisabled(this.selectPlayer("VLC").getName()!=="VLC");if(Ext.isString(this.profile)){if(this.selectPlayer("Flash").getName()==="Flash"){this.playTranscodeDTV(this.profile)}else{this.onErrorOccur(_T("video_player","error_play"))}return}if(this.selectPlayer("VLC").getName()==="VLC"){this.getPlayer().play(this.dtv_url)}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.playTranscodeDTV("hd_high",this.audio_id)}else{var a=!Ext.isMac&&!SYNO.SDS.VideoPlayerCommonVC.Util.isVLCSupported();this.onErrorOccur(a?_T("video_player","error_play_vlc"):_T("video_player","error_play"))}}},playTranscodeDTV:function(a){this.fireEvent("busy");SYNO.API.Request({api:"SYNO.DTV.Streaming",method:"open",version:1,params:{tuner:this.tuner_id,profile:a,accept_format:"hls"},scope:this,callback:function(f,e,d,c){this.fireEvent("clear");if(f){var b=SYNO.VideoController2.Util.getLiveStreamURL(this.tuner_id,e.stream_id);this.getPlayer().play(b)}else{this.onAPIError.apply(this,arguments)}}})},playStreaming:function(){this.setRawDisabled(!this.ableToPlayRawQuality());if(Ext.isString(this.profile)){if(this.selectPlayer("Flash").getName()==="Flash"){this.playTranscodeVideo(this.profile,this.audio_id)}else{this.onErrorOccur(_T("video_player","error_play"))}return}this.updateToRawPlayer();if(this.getPlayer().getName()!=="Null"&&(this.audio_id===this.video_list.getDefaultAudioID())){var a=SYNO.SDS.VideoPlayerCommonVC.Util.getFileExt(this.video_list.getTitle());this.playRawVideo(a)}else{if(this.selectPlayer("Flash").getName()==="Flash"){this.playTranscodeVideo(this.profile,this.audio_id)}else{this.onErrorOccur(_T("video_player","error_play"))}}},updateToRawPlayer:function(){var a=this.video_list.getTitle();this.updatePlayer({filename:a})},ableToPlayRawQuality:function(){this.updateToRawPlayer();var b=(this.getPlayer().getName()!=="Null");var a=false;if(this.selectPlayer("Flash").getName()==="Flash"){a=this.getPlayer().AbleToRemux(this.video_list.getCodecInfo())}return(b||a)},playRawVideo:function(c){var d={api:"SYNO.VideoStation.Video",method:"download",version:1,_sid:Ext.util.Cookies.get("id"),id:this.video_list.getFileID()};var b=String.format("/{0}/{1}/1.{2}","webapi/VideoStation","video.cgi",c);var a=Ext.urlAppend(b,Ext.urlEncode(d));this.getPlayer().setStartPosition(this.start_position);this.getPlayer().play(a);this.force_resume=false},playTranscodeVideo:function(d,b){var e=this.getPlayer().AbleToRemux(this.video_list.getCodecInfo());var c=this.getPlayer().AbleToTranscode();if(!e&&!c){this.onErrorOccur(String.format(_VCT("controller","unsupported_format"),this.player_info.title));return}var a=(!e||Ext.isString(d))?"hls":"hls_remux";var f={id:this.video_list.getFileID(),hls_header:1,accept_format:a};if(Ext.isString(d)){f.profile=d}if(Ext.isNumber(b)){f.audio_id=b}this.fireEvent("busy");SYNO.API.Request({api:"SYNO.VideoStation.Streaming",method:"open",version:1,params:f,scope:this,callback:function(j,i,h,g){this.fireEvent("clear");if(j){this.onVTEStreamReady(i)}else{this.onAPIError.apply(this,arguments)}}})},onVTEStreamReady:function(c){this.stream_id=c.stream_id;this.stream_format=c.format;var b=SYNO.VideoController2.Util.getDisplayResolution(c.video)||this.video_list.getResolution();var a=SYNO.VideoController2.Util.getStreamURL(this.stream_id,this.stream_format);a=SYNO.VideoController2.Util.getExtM3U(b.width,b.height,a,"3rdparty/VideoStation/controller/ui");this.getPlayer().setStartPosition(this.start_position);this.getPlayer().play(a);this.force_resume=false},checkPassword:function(a){SYNO.API.Request({api:"SYNO.VideoController.Password",method:"testpassword",version:1,params:{id:this.player_info.id},scope:this,callback:function(e,d,c,b){if(e){if(d.correct){SYNO.VideoController2.Util.tryCallback(a)}else{this.promptPasswordDialog(a)}}else{this.onAPIError.apply(this,arguments)}}})},promptPasswordDialog:function(c){var a={owner:this.appWin,correctCallback:c,player_title:this.player_info.title,player_id:this.player_info.id};var b=new SYNO.VideoController2.PasswordDialog(a);b.show()},playRemote:function(){var a={controller:this,id:this.player_info.id,type:this.player_info.type,volume_adjustable:this.player_info.volume_adjustable,seekable:this.player_info.seekable,file_id:this.video_list.getFileID(),title:this.video_list.getTitle(),profile:this.profile};if(!Ext.isEmpty(this.subtitle_id)&&this.subtitle_id!==SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE){a.subtitle_id=this.subtitle_id}if(this.audio_id!==this.video_list.getDefaultAudioID()){a.audio_id=this.audio_id}this.player=new SYNO.VideoController2.RemotePlayer(a);this.getPlayer().setStartPosition(this.start_position);this.player.play();this.force_resume=false},stop:function(d,b){this.clearCallback=null;var a=this.getPlayer().getPosition();if(!Ext.isEmpty(this.dtv_url)||!Ext.isNumber(a)||a<=0){this.callParent(arguments);return}var c=SYNO.VideoController2.Controller.superclass.stop.createDelegate(this,arguments);this.video_list.getCurrentVideo().setWatchStatus(a,c,b)},prev:function(){this.stop(this.goPrev.createDelegate(this))},goPrev:function(a){if(this.video_list.goPrev(a)){this.onReadyToPlay()}},next:function(){this.stop(this.goNext.createDelegate(this))},goNext:function(a){if(this.video_list.goNext(a)){this.onReadyToPlay()}},setProfile:function(a){if(a===this.profile){return}if(this.rawdisabled&&a==="hd_high"&&this.profile===null){return}this.profile=a;this.force_resume=true;this.stop(this.play.createDelegate(this))},setAudioTrack:function(a){if(a===this.audio_id){return}this.audio_id=a;this.force_resume=true;this.stop(this.play.createDelegate(this))},selectSubtitle:function(c,b){this.subtitle_id=c;if(this.isRemoteMode()){this.setSubtitleEnabled(false,c)}else{var a=(c!==SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE);if(a){this.subtitle_manager.requestSubtitle(this.video_list.getFileID(),c,b)}this.setSubtitleEnabled(a,c)}},selectDefaultSubtitle:function(){var a=this.video_list.getSubtitleList();if(a.length<=0){this.subtitle_id=SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE;this.setSubtitleEnabled(false,SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE);return}var b=a[0];this.selectSubtitle(b.subtitle_id,b.need_preview)},setSubtitle:function(b,a){if(this.isRemoteMode()&&b===this.subtitle_id){return}this.selectSubtitle(b,a);if(this.isRemoteMode()){this.force_resume=true;this.stop(this.play.createDelegate(this))}},setPlayer:function(a){if(a.id===this.player_info.id){return}this.player_info=a;this.fireEvent("targetchange",this.player_info);this.force_resume=Ext.isEmpty(this.init_player_id);this.stop(this.play.createDelegate(this))},setChannel:function(a){if(a.id===this.channel_id){return}this.channel_id=a.id;this.stop(this.switchChannel.createDelegate(this,[a.id,a.title,this.play.createDelegate(this)]))},toggleRepeat:function(){switch(this.repeat){case SYNO.VideoController2.Util.REPEAT_NONE:this.repeat=SYNO.VideoController2.Util.REPEAT_ALL;break;case SYNO.VideoController2.Util.REPEAT_ALL:this.repeat=SYNO.VideoController2.Util.REPEAT_ONE;break;case SYNO.VideoController2.Util.REPEAT_ONE:this.repeat=SYNO.VideoController2.Util.REPEAT_NONE;break;default:this.repeat=SYNO.VideoController2.Util.REPEAT_NONE;break}this.updateAfterPlaybackAction();this.fireEvent("repeatchange",this.repeat)},updateAfterPlaybackAction:function(){var a=Ext.emptyFn;if(this.repeat===SYNO.VideoController2.Util.REPEAT_ALL){a=this.goNext.createDelegate(this,[true])}else{if(this.repeat===SYNO.VideoController2.Util.REPEAT_ONE){a=this.play.createDelegate(this)}else{if(this.repeat===SYNO.VideoController2.Util.REPEAT_NONE){a=this.goNext.createDelegate(this,[false])}}}this.clearCallback=a},setRawDisabled:function(a){this.rawdisabled=a;this.fireEvent("rawdisabled",a,this.profile)},onSubtitleReady:function(b,c){if(b!==this.video_list.getFileID()||c!==this.subtitle_id){return}var a=this.subtitle_manager.getSubtitle(b,c);this.getSubtitleParser().parseSrt(a)},onAPIError:function(e,d,c,a){if(e){return}var b=SYNO.VideoController2.Util.getErrorString(d,a.params.api);this.onErrorOccur(String.format(b,this.player_info.title))},onErrorOccur:function(a){this.updateState(SYNO.SDS.VideoPlayerCommonVC.Util.STATE.ERROR,a)},isRemoteMode:function(){return(this.player_info.type!==SYNO.VideoController2.Util.PLAYERTYPE_STREAMING)}});Ext.define("SYNO.VideoController2.ChannelMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",constructor:function(a){this.callParent([a])},setChannelList:function(b,a){this.removeAll();Ext.each(b,function(c){this.addOneItem(c.id,c.title,this.selectChannel.createDelegate(this,[c]),(c.id===a))},this)},selectChannel:function(a){this.button.getController().setChannel(a)}});Ext.define("SYNO.VideoController2.PrevButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("prev")},clickHandler:function(){this.getController().prev()}});Ext.define("SYNO.VideoController2.NextButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(a){this.callParent([a]);this.addClass("next")},clickHandler:function(){this.getController().next()}});Ext.define("SYNO.VideoController2.PlayerMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",constructor:function(a){this.callParent([a]);this.addStreamingItem(true)},addStreamingItem:function(b){var a={id:SYNO.VideoController2.Util.STREAMING_ID,type:SYNO.VideoController2.Util.PLAYERTYPE_STREAMING,title:_VCT("controller","streaming_mode"),volume_adjustable:true,password_protected:false,seekable:true};this.addOneItem(SYNO.VideoController2.Util.STREAMING_ID,_VCT("controller","streaming_mode"),this.selectPlayer.createDelegate(this,[a]),b)},setPlayerList:function(a,b){this.removeAll();this.addStreamingItem(b===SYNO.VideoController2.Util.STREAMING_ID);Ext.each(a,function(c){this.addOneItem(c.id,c.title,this.selectPlayer.createDelegate(this,[c]),(b===c.id))},this)},setInitPlayer:function(b){var a=this.items.itemAt(0);this.items.each(function(c){if(c.item_id===b){a=c;return false}});a.handler.call(this)},selectPlayer:function(a){this.button.getController().setPlayer(a)}});Ext.define("SYNO.VideoController2.SettingMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.ItemMenu",GROUPNAME_AUDIOTRACK:"audiotrack",GROUPNAME_PROFILE:"profile",QUALITY_LIST:[{title:_VCT("controller","quality_raw"),profile:null},{title:_VCT("controller","quality_high"),profile:"hd_high"},{title:_VCT("controller","quality_medium"),profile:"hd_medium"},{title:_VCT("controller","quality_low"),profile:"hd_low"}],constructor:function(a){this.callParent([a])},setQualityGroup:function(a){this.removeGroup(this.GROUPNAME_PROFILE);this.addTitle(_VCT("controller","playback_quality"),this.GROUPNAME_PROFILE);Ext.each(this.QUALITY_LIST,function(b){this.addOneItem(b.profile,b.title,this.selectProfile.createDelegate(this,[b.profile]),(b.profile===a),this.GROUPNAME_PROFILE)},this)},setRawDisabled:function(a){if(!this.items||!Ext.isBoolean(a)){return}var b=null;this.items.each(function(c){if(c.group===this.GROUPNAME_PROFILE&&c.item_id===null){b=c;return false}},this);if(!Ext.isObject(b)){return}b.setDisabled(a)},selectProfile:function(a){this.button.getController().setProfile(a)},setAudioTrackGroup:function(a,b){this.removeGroup(this.GROUPNAME_AUDIOTRACK);this.addTitle(_VCT("controller","audio_track"),this.GROUPNAME_AUDIOTRACK);Ext.each(a,function(c){var e=c.language;var d=_VCT("controller","audio_track")+"#"+c.track+((0>=e.length)?"":" - "+e);this.addOneItem(c.id,d,this.selectAudioTrack.createDelegate(this,[c.id]),(c.id===b),this.GROUPNAME_AUDIOTRACK)},this)},selectAudioTrack:function(a){this.button.getController().setAudioTrack(a)}});Ext.define("SYNO.VideoController2.SubtitleMenu",{extend:"SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu",constructor:function(a){this.callParent([a])},setSubtitleList:function(a){this.removeAll();this.addNoSubtitleItem();Ext.each(a,function(b){var d=b.format;if(!Ext.isString(d)||"srt"!==d.toLowerCase()){return true}var c=b.subtitle_id;var f=b.lang.toLowerCase();var e;if(false===b.embedded){e=_VCT("controller","external_subtitle");e+=f.length>0?(" - "+f):""}else{if(!Ext.isEmpty(b.title)){e=b.title}else{if(!Ext.isEmpty(f)){e=f}else{e=String.format("Subtitle Track #{0}",c)}}}this.addOneItem(c,e,this.selectSubtitle.createDelegate(this,[c,b.need_preview]),false)},this)},addNoSubtitleItem:function(){this.addOneItem(SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,_T("video_player","no_subtitle"),this.selectSubtitle.createDelegate(this,[SYNO.SDS.VideoPlayerCommonVC.SubtitleMenu.ID_NO_SUBTITLE,false]))},selectSubtitle:function(b,a){this.button.getController().setSubtitle(b,a)}});Ext.define("SYNO.VideoController2.RepeatButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.Button",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("repeat")},clickHandler:function(){this.getController().toggleRepeat()}});Ext.define("SYNO.VideoController2.SettingButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("setting")},createMenu:function(){return new SYNO.VideoController2.SettingMenu({button:this})}});Ext.define("SYNO.VideoController2.SubtitleButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.SubtitleButton",constructor:function(a){this.callParent([a])},createMenu:function(){return new SYNO.VideoController2.SubtitleMenu({button:this})}});Ext.define("SYNO.VideoController2.PlayerButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("player")},createMenu:function(){return new SYNO.VideoController2.PlayerMenu({button:this})}});Ext.define("SYNO.VideoController2.ChannelButton",{extend:"SYNO.SDS.VideoPlayerCommonVC.MenuButton",constructor:function(b){var a={};this.callParent([Ext.apply(a,b)]);this.addClass("channel")},createMenu:function(){return new SYNO.VideoController2.ChannelMenu({button:this})}});Ext.define("SYNO.VideoController2.ControlBar",{extend:"SYNO.SDS.VideoPlayerCommonVC.ControlBar",constructor:function(b){this.module=b.module;var a={items:[{xtype:"tbspacer",width:14},this.getPrevButton(),this.getPlayButton(),this.getStopButton(),this.getNextButton(),{xtype:"tbspacer",width:14},{xtype:"tbseparator",cls:"vp-separator"},{xtype:"tbspacer",width:30},this.getPositionText(),this.slashConfig,this.getDurationText(),"->",this.getRepeatButton(),this.getVolumeButton(),this.getSettingButton(),this.getSubtitleButton(),this.getPlayerButton(),this.getChannelButton(),this.getFullscreenButton(),{xtype:"tbspacer",width:14}]};this.callParent([Ext.apply(a,b)])},getPrevButton:function(){if(!Ext.isDefined(this.prev_button)){this.prev_button=new SYNO.VideoController2.PrevButton({module:this.module})}return this.prev_button},getNextButton:function(){if(!Ext.isDefined(this.next_button)){this.next_button=new SYNO.VideoController2.NextButton({module:this.module})}return this.next_button},getRepeatButton:function(){if(!Ext.isDefined(this.repeat_button)){this.repeat_button=new SYNO.VideoController2.RepeatButton({module:this.module,hidden:true})}return this.repeat_button},getSettingButton:function(){if(!Ext.isDefined(this.setting_button)){this.setting_button=new SYNO.VideoController2.SettingButton({module:this.module})}return this.setting_button},getSubtitleButton:function(){if(!Ext.isDefined(this.subtitle_button)){this.subtitle_button=new SYNO.VideoController2.SubtitleButton({module:this.module})}return this.subtitle_button},getPlayerButton:function(){if(!Ext.isDefined(this.player_button)){this.player_button=new SYNO.VideoController2.PlayerButton({module:this.module})}return this.player_button},getChannelButton:function(){if(!Ext.isDefined(this.channel_button)){this.channel_button=new SYNO.VideoController2.ChannelButton({module:this.module,hidden:true})}return this.channel_button}});Ext.define("SYNO.VideoController2.ControlPanel",{extend:"SYNO.SDS.VideoPlayerCommonVC.ControlPanel",getControlBar:function(){if(!Ext.isDefined(this.controlBar)){this.controlBar=new SYNO.VideoController2.ControlBar({module:this.module})}return this.controlBar},setPrevNext:function(b,a){this.getControlBar().getPrevButton().setDisabled(!b);this.getControlBar().getNextButton().setDisabled(!a)}});Ext.define("SYNO.VideoController2.Display",{extend:"SYNO.SDS.VideoPlayerCommonVC.Display",ALL_META_CLASSES:["poster","screenshot","buffer","error"],constructor:function(b){var a={remote_mode:false,video_info:{}};this.callParent([Ext.apply(a,b)])},setVideoInfo:function(a){this.video_info=a;this.playing_cls=((this.video_info.type==="movie")?"poster":"screenshot");this.playing_exclude_cls=this.ALL_META_CLASSES.filter(function(b){return(this.playing_cls!==b)},this);this.image_url=SYNO.VideoController2.Util.getImageURL(a.video_id,a.type)},setRemoteMode:function(b,a){this.remote_mode=b;if(this.remote_mode){this.status_text=String.format(_VCT("controller","playing_on"),a)}},setStopped:function(){if(!this.remote_mode){this.callParent(arguments);return}this.layout.setActiveItem(1);this.getMetaDisplay().removeClass(this.ALL_META_CLASSES);this.getMetaDisplay().setImage("");this.getMetaDisplay().setText("")},setPlaying:function(){if(!this.remote_mode){this.callParent(arguments);return}this.layout.setActiveItem(1);this.getMetaDisplay().removeClass(this.playing_exclude_cls);this.getMetaDisplay().addClass(this.playing_cls);this.getMetaDisplay().setImage(this.image_url);this.getMetaDisplay().setText(this.status_text)}});Ext.define("SYNO.VideoController2.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.VideoController2.AppWindow"});Ext.define("SYNO.VideoController2.AppWindow",{extend:"SYNO.SDS.VideoPlayerCommonVC.AppWindow",constructor:function(a){this.callParent([a]);this.addClass("syno-vc-win")},getDisplay:function(){if(!Ext.isDefined(this.display)){this.display=new SYNO.VideoController2.Display()}return this.display},getControlPanel:function(){if(!Ext.isDefined(this.control_panel)){this.control_panel=new SYNO.VideoController2.ControlPanel({module:this})}return this.control_panel},getController:function(){if(!Ext.isDefined(this.controller)){var a=this.getControlPanel();this.controller=new SYNO.VideoController2.Controller({appWin:this,container:this.getDisplay().getEl(),video:this.getDisplay().getComponent("video_display").getComponent("video").getEl(),jsBaseURL:String.format("{0}/controller/ui",this.jsConfig.jsBaseURL),init_player_id:this.init_player_id,type_info:this.type_info,video_info:this.video_info,dtv_url:this.dtv_url,listeners:{busy:this.setStatusBusy.createDelegate(this),clear:this.clearStatusBusy.createDelegate(this),rawdisabled:this.onRawDisabled.createDelegate(this),capabilityready:this.onCapabilityReady.createDelegate(this),channellistready:this.onChannelListReady.createDelegate(this),playerlistchange:this.onPlayerListChange.createDelegate(this),videolistready:this.onVideoListReady.createDelegate(this),targetchange:this.onTargetChange.createDelegate(this),repeatchange:this.onRepeatChange.createDelegate(this),titlechange:this.onTitleChange.createDelegate(this),videochange:this.onVideoChange.createDelegate(this),statechange:this.setState.createDelegate(this),mutechange:a.setMute.createDelegate(a),volumechange:a.setVolume.createDelegate(a),timechange:this.setTime.createDelegate(this),subtitlechange:this.setSubtitle.createDelegate(this)}})}return this.controller},getControlBar:function(){return this.getControlPanel().getControlBar()},setSubtitle:function(c,b){this.callParent(arguments);var a=this.getControlBar().getSubtitleButton().menu;a.setItemSelected(b)},onRawDisabled:function(b,d){var a=this.getControlBar().getSettingButton().menu;var c=d;if(d===null){c=b?"hd_high":null}a.setItemSelected(c,SYNO.VideoController2.SettingMenu.prototype.GROUPNAME_PROFILE);a.setRawDisabled(b)},onCapabilityReady:function(b){if(b){var a=this.getControlBar().getSettingButton();a.enable();a.menu.setQualityGroup(this.getController().profile)}},onChannelListReady:function(a){var b=this.getControlBar().getChannelButton();b.enable();b.menu.setChannelList(a,this.getController().channel_id)},onPlayerListChange:function(a){var b=this.getControlBar().getPlayerButton().menu;b.setPlayerList(a,this.getController().player_info.id)},onVideoListReady:function(a){if(!a){return}this.getControlBar().getRepeatButton().show()},onRepeatChange:function(c){var a="none";if(c===SYNO.VideoController2.Util.REPEAT_ALL){a="all"}else{if(c===SYNO.VideoController2.Util.REPEAT_ONE){a="one"}}var b=this.getControlBar().getRepeatButton();b.removeClass(["none","all","one"]);b.addClass(a)},onTargetChange:function(a){this.getDisplay().setRemoteMode(this.getController().isRemoteMode(),a.title);this.getControlBar().getVolumeButton().setDisabled(true!==a.volume_adjustable);this.getControlBar().getSettingButton().setDisabled(SYNO.VideoController2.Util.PLAYERTYPE_UPNP===a.type);var c=(SYNO.VideoController2.Util.PLAYERTYPE_AIRPLAY!==a.type)||this.getController().support_remux;this.getControlBar().getSubtitleButton().setDisabled(!c);var b=!this.getController().isRemoteMode()&&SYNO.SDS.VideoPlayerCommonVC.Util.isDomFullscreenSupported();this.getControlBar().getFullscreenButton().setDisabled(!b)},onVideoChange:function(h,f,g,e,b){this.getDisplay().setVideoInfo(g);this.getControlPanel().setPrevNext(h,f);var d=this.getControlBar();var a=this.getController();d.getSubtitleButton().menu.setSubtitleList(b);var c=d.getSettingButton().menu;if(a.support_remux){c.setAudioTrackGroup(e,a.audio_id)}},onTitleChange:function(a){this.setTitle(a)},onOpen:function(a){this.callParent(arguments);window.onbeforeunload=this.onWindowBeforeUnload.createDelegate(this);this.setStatusBusy();if(Ext.isString(a.dtv_url)){this.dtv_url=a.dtv_url;var b=this.getControlPanel().getControlBar();b.getPrevButton().hide();b.getNextButton().hide();b.getSettingButton().disable();b.getChannelButton().disable();b.getSubtitleButton().hide();b.getPlayerButton().hide();b.getChannelButton().show();this.getController().initSequenceDTV()}else{this.init_player_id=a.player_id;this.type_info={type:a.browse_type,id:parseInt(a.type_id,10)};this.video_info={id:parseInt(a.video_id,10),type:a.video_type,file_id:a.file_id,title:a.title};this.getController().initSequenceVideo()}},onWindowBeforeUnload:function(){this.getController().stop(Ext.emptyFn,true)}});