PACKAGE_DIR="/var/packages/VideoStation"
SYNODTV_BIN="${PACKAGE_DIR}/target/bin/synodtv"
DTV_SETTING_CONF="${PACKAGE_DIR}/etc/dtv_setting.conf"
SYNOPKG_PKG_STATUS="$2"

start()
{
	[ -e "${PACKAGE_DIR}/target/scripts/DVB_Admin.sh" ] && ${PACKAGE_DIR}/target/scripts/DVB_Admin.sh "start" "${PACKAGE_DIR}"

	# synodtv daemon
	${SYNODTV_BIN} start
	if [ -n "$SYNOPKG_PKG_STATUS" ]; then
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh add
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh hupapache &
	fi
}

stop()
{
	# synodtv daemon
	${SYNODTV_BIN} stop

	[ -e "${PACKAGE_DIR}/target/scripts/DVB_Admin.sh" ] && ${PACKAGE_DIR}/target/scripts/DVB_Admin.sh "stop" "${PACKAGE_DIR}"

	if [ -n "$SYNOPKG_PKG_STATUS" ]; then
		${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh delete
		if [ "UPGRADE" != "$SYNOPKG_PKG_STATUS" ]; then
			${PACKAGE_DIR}/scripts/ReloadDTVStreamingPath.sh hupapache &
		fi
	fi
}

case $1 in
	start)
		start
		exit 0
	;;
	stop)
		stop
		exit 0
	;;
esac
