#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.
VIDEO_METADATA_DB="video_metadata"

PG_SCRIPT="/var/packages/VideoStation/target/scripts/sql/video_metadata.pgsql"
CREATE_DB="/usr/syno/pgsql/bin/createdb"
PSQL="/usr/syno/pgsql/bin/psql"
UPGRADE_DIR="/var/packages/VideoStation/target/scripts/sql/upgrade"

Upgrade=0

echo "Update video_file table where video id = 0 to test db existence"
su -l admin -c "$PSQL $VIDEO_METADATA_DB -c \"update video_file set duration = 0 where id = 0\""
Ret=$?
if [ $Ret = 2 ]; then
   su -l admin -c "$CREATE_DB $VIDEO_METADATA_DB"
   if [ $? != 0 ]; then
      echo "Failed to create database"
      exit
   fi
   Ret=1
fi

if [ $Ret = 1 ]; then      
   $PSQL $VIDEO_METADATA_DB -U admin -f $PG_SCRIPT
   if [ $? != 0 ]; then
      echo "Failed to create tables in video_metadata database"
      exit
   fi
fi

upgrades=`find $UPGRADE_DIR -name "*.sh" | sort`
for ThisArg in $upgrades;
do
	$ThisArg
	Ret=$?
	if [ $Ret = 1 ]; then
		NeedReindex=1
	fi
done

