#!/bin/sh

ScriptDir=$(dirname `readlink -f $0`)
UISTRING_PATH="$ScriptDir/../../uistring/videostation/"
pkg_get_string() {
	local file=$1
	local sec=$2
	local key=$3
	local param1=$4

	sed -n '/^\['$sec'\]/,/^'$key'/s/'$key'.*=.*"\(.*\)"/\1/p' "$file"| sed -n 's/{0}/'$param1'/p'
}

dump_content() 
{
local UISTRING_PATH=$1
for lan in $UISTRING_PATH/*; do
	lan=$(basename "$lan")
	file="$UISTRING_PATH/$lan/strings"

	if [ ! -r "$file" ]; then
		continue;
	fi
	cat << EOF
		$lan)
			echo "$(pkg_get_string $file app package_conflict DVBLink)" > \$SYNOPKG_TEMP_LOGFILE 
		;;
EOF

done
	cat << EOF
		*)
			echo "$(pkg_get_string $UISTRING_PATH/enu/strings app package_conflict DVBLink)" > \$SYNOPKG_TEMP_LOGFILE 
		;;
EOF

}

rm -f $ScriptDir/start-conflict-check
cat > $ScriptDir/start-conflict-check <<EOF
#!/bin/sh
start_conflict_check()
{
	process=\`ps | grep dvblink_server | grep -v grep\`

	if [ ! -f /var/packages/DVBLink/enabled ]; then
		if [ "x\$process" == "x" ]; then
			return;
		fi
	fi
	case \$SYNOPKG_DSM_LANGUAGE in
$(dump_content $UISTRING_PATH)
	esac
	exit 1
}

EOF
chmod 755 $ScriptDir/start-conflict-check
