#!/usr/bin/php
<?php
define('PLUGINID', 'com.synology.TvRage');
define('API_URL', 'http://services.tvrage.com');

$DEFAULT_TYPE = 'tvshow_episode';
$DEFAULT_LANG = 'enu';

$SUPPORTED_TYPE = array('tvshow', 'tvshow_episode');
$SUPPORTED_PROPERTIES = array('title');

require_once(dirname(__FILE__) . '/../search.inc.php');

function GetXML($xml_path)
{
	$xml = NULL;

	try {
		@$xml = new SimpleXMLElement(file_get_contents($xml_path));
	} catch (Exception $e) {
	}

	return $xml;
}

function GetDownloadedQueryData($query, $lang)
{
	$query = urlencode($query);

	$xml = FALSE;
	$need_refresh = TRUE;
	$dir = GetPluginDataDirectory(PLUGINID) . "/query";
	$xml_path = "{$dir}/{$query}.xml";

	if (file_exists($xml_path)) {
		$lastupdated = filemtime($xml_path);
		if (86400 >= (time() - $lastupdated)) {
			$xml = GetXML($xml_path);
			if (NULL !== $xml) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($xml_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

		$response = HTTPGETDownload(API_URL . "/feeds/search.php?show={$query}", $fh);
		fclose($fh);

		if (FALSE !== $response) {
			$xml = GetXML($xml_path);
			if (NULL === $xml) {
				$xml = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			@unlink($xml_path);
		}
	}

	return $xml;
}

function GetDownloadedSeriesData($id, $lang)
{
	$xml = FALSE;
	$need_refresh = TRUE;
	$xml_path = GetPluginDataDirectory(PLUGINID) . "/{$id}.xml";

    // whether we need to udpate series data base on last update time
	if (file_exists($xml_path)) {
		$lastupdated = filemtime($xml_path);
		if (86400 >= (time() - $lastupdated)) {
			$xml = GetXML($xml_path);
			if (NULL !== $xml) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		$fh = @fopen($xml_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

        $response = HTTPGETDownload(API_URL . "/feeds/full_show_info.php?sid={$id}", $fh);
		fclose($fh);

		if (FALSE !== $response) {
			$xml = GetXML($xml_path);
			if (NULL === $xml) {
				$xml = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			unlink($xml_path);
		}
	}

	return $xml;
}

function ParseTVShowData($series_data, $data)
{
    $data['title'] = (string)$series_data->name;

	if (preg_match('/(.*)\/(.*)\/(.*)/', (string)$series_data->started, $matches))
		$data['original_available'] = @date("Y-m-d", strtotime("{$matches[2]} {$matches[1]} {$matches[3]}"));

	$data['genre'] = array();
	foreach($series_data->genres->genre as $genre) {
        $data['genre'][] = (string)$genre;
    }

	$data['extra'][PLUGINID] = array('reference' => array());
	$data['extra'][PLUGINID]['reference']['tvrage'] = (string)$series_data->showid;
    if ((string)$series_data->image) {
		$data['extra'][PLUGINID]['poster'] = array((string)$series_data->image);
	}

    return $data;
}

function ParseEpisodeData($episode_data, $season, $episode, $data)
{
	$data['season'] = $season;
	$data['episode'] = $episode;
    $data['tagline'] = (string)$episode_data->title;
    $data['original_available'] = (string)$episode_data->airdate;

	if ((string)$episode_data->screencap) {
		$data['extra'][PLUGINID]['poster'] = array((string)$episode_data->screencap);
	}

    return $data;
}

function SeasonCompare($a, $b)
{
    if ($a['season'] == $b['season']) {
        return 0;
    }

    return ($a['season'] < $b['season']) ? -1 : 1;
}

function EpisodeCompare($a, $b)
{
    if ($a['episode'] == $b['episode']) {
        return 0;
    }
    return ($a['episode'] < $b['episode']) ? -1 : 1;
}

function InsertItemToList($item, &$list)
{
    $found = false;

    foreach ($list as $key => $value) {
        if ($value['season'] == $item['season']) {
            $found = true;
            break;
        }
    }

    if ($found) {
        $list[$key]['episode'][] = $item;
    } else {
        $list[] = array(
            'season' => $item['season'],
            'episode' => array($item));
    }
}

function SortList(&$list) {
	uasort($list, 'SeasonCompare');

	foreach($list as $key => $value) {
		uasort($list[$key]['episode'], 'EpisodeCompare');
	}
}

function GetTVShowInfo($series_data, $data)
{
	//Fill tvshow information
	$data = ParseTVShowData($series_data, $data);

	//Fill all episode information
	$list = array();
	foreach ($series_data->Episodelist->Season as $season_element) {
        $season_num = (int)$season_element->attributes()->no;
		foreach ($season_element->episode as $episode_element) {
			$episode_num = (int)$episode_element->seasonnum;
			$item = ParseEpisodeData($episode_element, $season_num, $episode_num, array());
			InsertItemToList($item, $list);
		}
    }
	SortList($list);
	$data['extra'][PLUGINID]['list'] = $list;

	return $data;
}

function GetEpisodeInfo($series_data, $season, $episode, $data)
{
    $episode_data = FALSE;

	//Get episode data
	foreach ($series_data->Episodelist->Season as $season_element) {
        $season_num = (int)$season_element->attributes()->no;
		if ($season == $season_num ||
			(NULL === $season && 1 == $season_num)) {

			foreach ($season_element->episode as $episode_element) {
				$episode_num = (int)$episode_element->seasonnum;
				if ($episode == $episode_num) {
                    $episode_data = $episode_element;
                    break;
                }
            }
        }
		if ($episode_data) {
			break;
        }
    }

	//Fill tvshow information
    $data['title'] = (string)$series_data->name;
	$data['extra'] = array(PLUGINID => array());
	$data['extra'][PLUGINID]['tvshow'] = ParseTVShowData($series_data, array());

	//Fill episode information
	if ($episode_data) {
		$data = ParseEpisodeData($episode_data, $season_num, $episode_num, $data);
	}

	return $data;
}

function QueryTVShow($title, $season, $episode, $lang, $type, $limit)
{
	global $DATA_TEMPLATE;

	$result = array();
	$xml = GetDownloadedQueryData($title, $lang);
	if (!$xml) {
		return array();
	}

	foreach($xml->show as $show) {
		// copy template
		$data = $DATA_TEMPLATE;
		$seriesid = (string)$show->showid;

		$series_data = GetDownloadedSeriesData($seriesid, $lang);
		if (!$series_data) {
			continue;
		}

		switch ($type) {
			case 'tvshow':
				$data = GetTVShowInfo($series_data, $data);
				break;
			case 'tvshow_episode':
				$data = GetEpisodeInfo($series_data, $season, $episode, $data);
				break;
		}

		if ($data) {
			$result[] = $data;
			// -1: all, 0: no result, >0: limit
			if (0 === --$limit) {
				break;
			}
		}
    }

	return $result;
}

function Process($input, $lang, $type, $limit, $search_properties)
{
	$result = array();

	$title = $input['title'];
	$season = $input['season'];
	$episode = $input['episode'];

	$titles = GetGuessingList($title);
	foreach ($titles as $checkTitle) {
		if (empty($checkTitle)) {
			continue;
		}
		$result = QueryTVShow($checkTitle, $season, $episode, $lang, $type, $limit);
		if (0 < count($result)) {
			break;
		}
	}

	return $result;
}

PluginRun('Process');

?>
