#!/usr/bin/php
<?php
$DEFAULT_TYPE = 'movie';
$DEFAULT_LANG = 'enu';

$SUPPORTED_TYPE = array('movie', 'tvshow_episode', 'home_video', 'tv_record');
$SUPPORTED_PROPERTIES = array('title');

require_once(dirname(__FILE__) . '/../search.inc.php');
require_once(dirname(__FILE__) . '/cleanname.inc.php');
require_once(dirname(__FILE__) . '/movie.inc.php');
require_once(dirname(__FILE__) . '/episode.inc.php');
require_once(dirname(__FILE__) . '/tv.inc.php');
require_once(dirname(__FILE__) . '/home_video.inc.php');

function Process($input, $lang, $type, $limit, $search_properties)
{
	$path = $input['path'];
	$title = NULL;
	$tagline = NULL;
	$year = NULL;
	$season = NULL;
	$episode = NULL;
	$summary = NULL;

	switch ($type) {
		case 'movie':
			list($title, $year) = GetMovieInfo($path);
			break;
		case 'tvshow_episode':
			list($title, $tagline, $year, $season, $episode) = GetEpisodeInfo($path);
			break;
		case 'tv_record':
			list($title, $tagline, $year, $summary) = GetTVInfo($path);
			break;
		case 'home_video':
			list($title, $year) = GetHomeVideoInfo($path);
			break;
		default:
			$title = basename($path);
			$title = CleanName($title);
	}

	if ($title) {
		$input['title'] = $title;
	}
	if ($tagline) {
		$input['tagline'] = $tagline;
	}
	if ($year) {
		$input['original_available'] = $year;
	}
	if ($season) {
		$input['season'] = (int)$season;
	}
	if ($episode) {
		$input['episode'] = (int)$episode;
	}
	if ($summary) {
		$input['summary'] = $summary;
	}
	return $input;
}

PluginRun('Process');
?>
