ACTION="$1"
PKG_PATH="$2"

if [ "${ACTION}" = "start" ]; then
	local ls_module=`ls ${PKG_PATH}/target/etc/KernelModules/*.ko`
	local version=`uname -a | cut -d'#' -f2 | cut -d' ' -f1`
	if [ "${ls_module}" = "" ]; then
		if [ "${version}" -lt "3103" ]; then
			/bin/tar -jxf ${PKG_PATH}/target/etc/KernelModules/4.1.tar.bz2 -C ${PKG_PATH}/target/etc/KernelModules/;
		else
			/bin/tar -jxf ${PKG_PATH}/target/etc/KernelModules/4.2.tar.bz2 -C ${PKG_PATH}/target/etc/KernelModules/;
		fi
		if [ "$?" != "0" ]; then
			echo "tar ${version}.tar.bz2 failed...exit now" > /tmp/DVB_driver_untar_error
			exit
		else
			rm -f ${PKG_PATH}/target/etc/KernelModules/*.tar.bz2
		fi
	fi
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh "start" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh "start" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/Hotplug/usb.DVB.function" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/usb.DVB.function /usr/syno/hotplug
	[ -e "${PKG_PATH}/target/scripts/Hotplug/usb.DVB.dep.table" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/usb.DVB.dep.table /usr/syno/hotplug
	[ -e "${PKG_PATH}/target/scripts/Hotplug/usb.DVB.VIDPID.table" ] && cp -f ${PKG_PATH}/target/scripts/Hotplug/usb.DVB.VIDPID.table /usr/syno/hotplug
	[ -e "${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh" ] && ${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh "add"
	if [ "`cat /usr/syno/hotplug/usb.agent | grep "hotplug/usb.DVB.function" | grep "MAJOR"`" = "" ]; then
		/bin/sed -i 's/usb.DVB.function "$ACTION" "$usb_idVendor" "$usb_idProduct"/usb.DVB.function "$ACTION" "$usb_idVendor" "$usb_idProduct" "$MAJOR" "$MINOR"/' /usr/syno/hotplug/usb.agent
	fi
else
	[ -e "${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh" ] && ${PKG_PATH}/target/scripts/Hotplug/manual_gen_hotplug.sh "remove"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicFirmwares.sh "stop" "${PKG_PATH}"
	[ -e "${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh" ] && ${PKG_PATH}/target/scripts/KernelScripts/SymbolicModules.sh "stop" "${PKG_PATH}"
	[ -e "/usr/syno/hotplug/usb.DVB.function" ] && rm -f /usr/syno/hotplug/usb.DVB.function
	[ -e "/usr/syno/hotplug/usb.DVB.dep.table" ] && rm -f /usr/syno/hotplug/usb.DVB.dep.table
	[ -e "/usr/syno/hotplug/usb.DVB.VIDPID.table" ] && rm -f /usr/syno/hotplug/usb.DVB.VIDPID.table
fi
