<?php
function GetMovieInfo($path)
{
	$invalid_titles = array('sample', 'samples', 'trailer', 'trailers');
	$pathinfo = pathinfo($path);

	//Split path into each component and arrage items backwards. example:
	//'/volume1/video/movie/inception.rmvb' =>
	//Array([0] => inception.rmvb, [1] => movie, [2] => video, [3] => volume1, [4] => )
	$path_component = array_reverse(explode('/', $path));

	//Path depth exclude share level (/volume1/video/) and the empty root element
	$path_depth = count($path_component) - 3;

	$title = NULL;

	//Check DVD structure.
	if (0 === strcasecmp('vob', $pathinfo['extension'])) {
		//List all files in the same dicrectory
		$files = array_map('strtolower', (array)@scandir($pathinfo['dirname']));

		//video_ts.ifo or video_ts.bup exist
		$is_dvd = is_array($files) && (in_array('video_ts.ifo', $files) || in_array('video_ts.bup', $files));

		if ($is_dvd) {
			//example: '/volome1/video/movie/inception/VIDEO_TS.VOB'
			if (2 >= $path_depth || 0 !== strcasecmp('video_ts', $path_component[1])) {
				$title = $path_component[1];
			//example: '/volome1/video/movie/inception/VIDEO_TS/VIDEO_TS.VOB'
			} else {
				$title = $path_component[2];
			}
		}
	//Check BDMV structure. example: '/volome1/video/movie/inception/BDMV/STREAM/xxx.m2ts'
	} else if (3 <= $path_depth &&
		!strcasecmp('stream', $path_component[1]) &&
		!strcasecmp('bdmv', $path_component[2])) {
		$title = $path_component[3];
	//Folder name includes title and year info. example: '/volome1/video/movie/inception 2010/xxx.avi'
	} else if (2 <= $path_depth) {
		$regex_series_year = '/([ \(\[\.\-])?([1-2][0-9]{3})-([1-2][0-9]{3})([ \.\-\)\]_,+$]|$)/Uui';
		if (0 == preg_match($regex_series_year, $path_component[1], $matches)) {
			list($testTitle, $testYear) = CleanName($path_component[1]);
			if (!empty($testTitle) && !empty($testYear)) {
				$title = $testTitle;
			}
		}
	}

	//If title is not compatible to above situations, use filename as title directly.
	if (NULL === $title) {
		$title = $pathinfo['filename'];
	}

	//Verify title name
	for ($index = 1; $path_depth > $index; $index++) {
		list($testTitle) = CleanName($title);
		if (!in_array(strtolower($testTitle), $invalid_titles)) {
			break;
		}
		$title = $path_component[$index];
	}

	//Result
	return CleanName($title);
}
?>
